/* Generated from library.scm by the CHICKEN compiler
   http://www.call-cc.org
   Version 6.0.0pre3 ((HEAD detached at 6.0.0pre3)) (rev 57e82bac)
   linux-unix-gnu-x86-64 [ 64bit dload ptables ]
   command line: library.scm -optimize-level 2 -include-path . -include-path ./ -inline -ignore-repository -feature chicken-bootstrap -no-warnings -specialize -consult-types-file ./types.db -explicit-use -no-trace -output-file library.c -no-module-registration -emit-import-library chicken.bitwise -emit-import-library chicken.bytevector -emit-import-library chicken.fixnum -emit-import-library chicken.flonum -emit-import-library chicken.gc -emit-import-library chicken.keyword -emit-import-library chicken.platform -emit-import-library chicken.plist -emit-import-library chicken.io -emit-import-library chicken.process-context
   unit: library
   uses: build-version library
*/
#include "chicken.h"

#include <errno.h>
#include <float.h>

#ifdef HAVE_SYSEXITS_H
# include <sysexits.h>
#endif

#ifndef EX_SOFTWARE
# define EX_SOFTWARE	70
#endif

#define C_close_file(p)	      (C_fclose((C_FILEPTR)(C_port_file(p))), C_SCHEME_UNDEFINED)
#define C_a_f64peek(ptr, c, b, i)  C_flonum(ptr, ((double *)C_data_pointer(b))[ C_unfix(i) ])
#define C_fetch_c_strlen(b, i) C_fix(strlen((C_char *)C_block_item(b, C_unfix(i))))
#define C_asciiz_strlen(str) C_fix(strlen(C_c_string(str)))
#define C_peek_c_string(b, i, to, len) (C_memcpy(C_data_pointer(to), (C_char *)C_block_item(b, C_unfix(i)), C_unfix(len)), C_SCHEME_UNDEFINED)
#define C_free_mptr(p, i)     (C_free((void *)C_block_item(p, C_unfix(i))), C_SCHEME_UNDEFINED)
#define C_free_sptr(p, i)     (C_free((void *)(((C_char **)C_block_item(p, 0))[ C_unfix(i) ])), C_SCHEME_UNDEFINED)

#define C_a_get_current_seconds(ptr, c, dummy)  C_int64_to_num(ptr, time(NULL))
#define C_peek_c_string_at(ptr, i)    ((C_char *)(((C_char **)ptr)[ i ]))

#define C_utf_bytes_needed(b)  C_fix(C_utf_expect(C_unfix(b)))

static C_word
fast_read_line_from_file(C_word str, C_word port, C_word size) {
  int n = C_unfix(size);
  int i;
  int c;
  char *buf = C_c_string(str);
  C_FILEPTR fp = C_port_file(port);

  if ((c = C_getc(fp)) == EOF) {
    if (ferror(fp)) {
      clearerr(fp);
      return C_fix(-1);
    } else { /* feof (fp) */
      return C_SCHEME_END_OF_FILE;
    }
  }

  C_ungetc(c, fp);

  for (i = 0; i < n; i++) {
    c = C_getc(fp);

    if(c == EOF && ferror(fp)) {
      clearerr(fp);
      return C_fix(-(i + 1));
    }

    switch (c) {
    case '\r':	if ((c = C_getc(fp)) != '\n') C_ungetc(c, fp);
    case EOF:	clearerr(fp);
    case '\n':	return C_fix(i);
    }
    buf[i] = c;
  }
  return C_SCHEME_FALSE;
}

static C_word
fast_read_string_from_file(C_word dest, C_word port, C_word len, C_word pos)
{
  size_t m;
  int n = C_unfix (len);
  C_char * buf = C_c_string(dest) + C_unfix(pos);
  C_FILEPTR fp = C_port_file (port);

  if(feof(fp)) return C_SCHEME_END_OF_FILE;

  m = fread (buf, sizeof (char), n, fp);

  if (m < n) {
    if (ferror(fp)) /* Report to Scheme, which may retry, so clear errors */
      clearerr(fp);
    else if (feof(fp) && 0 == m) /* eof but m > 0? Return data first, below */
      return C_SCHEME_END_OF_FILE; /* Calling again will get us here */
  }

  return C_fix (m);
}

static C_word
shallow_equal(C_word x, C_word y)
{
  /* assumes x and y are non-immediate */
  int i, len = C_header_size(x);

  if(C_header_size(y) != len) return C_SCHEME_FALSE;
  else return C_mk_bool(!C_memcmp((void *)x, (void *)y, len * sizeof(C_word)));
}

static C_word
signal_debug_event(C_word mode, C_word msg, C_word args)
{
  C_DEBUG_INFO cell;
  C_word av[ 3 ];
  cell.enabled = 1;
  cell.event = C_DEBUG_SIGNAL;
  cell.loc = "";
  cell.val = "";
  av[ 0 ] = mode;
  av[ 1 ] = msg;
  av[ 2 ] = args;
  C_debugger(&cell, 3, av);
  return C_SCHEME_UNDEFINED;
}

static C_word C_i_sleep_until_interrupt(C_word secs)
{
   while(C_i_process_sleep(secs) == C_fix(-1) && errno == EINTR);
   return C_SCHEME_UNDEFINED;
}

#ifdef NO_DLOAD2
# define HAVE_DLOAD 0
#else
# define HAVE_DLOAD 1
#endif

#ifdef C_ENABLE_PTABLES
# define HAVE_PTABLES 1
#else
# define HAVE_PTABLES 0
#endif

#ifdef C_GC_HOOKS
# define HAVE_GCHOOKS 1
#else
# define HAVE_GCHOOKS 0
#endif

#if defined(C_CROSS_CHICKEN) && C_CROSS_CHICKEN
# define IS_CROSS_CHICKEN 1
#else
# define IS_CROSS_CHICKEN 0
#endif

#if defined(_WIN32) && !defined(__CYGWIN__)
#include <direct.h>

static C_word C_chdir(C_word str) {
	return C_fix(_wchdir(C_utf16(str, 0)));
}

static C_word C_curdir(C_word buf, C_word size) {
	C_WCHAR *cwd = _wgetcwd((C_WCHAR *)C_c_string(buf), C_unfix(size));
        if(cwd == NULL) return C_SCHEME_FALSE;
	C_char *up = C_utf8(cwd);
	C_char *p = up;
	while(*p) {
		*p = *p == '\\' ? '/' : *p;
		++p;
	}
	int len = C_strlen(up);
	C_memcpy(cwd, up, len + 1);
        return C_fix(len);
}
#else
# define C_chdir(str) C_fix(chdir(C_c_string(str)))
# define C_curdir(buf, size) (getcwd(C_c_string(buf), size) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)
#endif



static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_build_2dversion_toplevel)
C_extern void C_ccall C_build_2dversion_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(C_library_toplevel)
C_extern void C_ccall C_library_toplevel(C_word c,C_word *av) C_noret;

static C_word lf[1635];
static double C_possibly_force_alignment;
static C_char li0[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,110,111,116,32,120,41,0,0};
static C_char li1[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,98,111,111,108,101,97,110,63,32,120,41,0,0,0,0,0};
static C_char li2[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,101,113,63,32,120,32,121,41};
static C_char li3[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,101,113,118,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char li4[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,101,113,117,97,108,63,32,120,32,121,41,0,0,0,0,0};
static C_char li5[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,102,41};
static C_char li6[] C_aligned={C_lihdr(0,0,29),40,115,99,104,101,109,101,35,98,111,111,108,101,97,110,61,63,32,120,32,121,32,46,32,109,111,114,101,41,0,0,0};
static C_char li7[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,102,41};
static C_char li8[] C_aligned={C_lihdr(0,0,28),40,115,99,104,101,109,101,35,115,121,109,98,111,108,61,63,32,120,32,121,32,46,32,109,111,114,101,41,0,0,0,0};
static C_char li9[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,112,97,105,114,63,32,120,41};
static C_char li10[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,111,110,115,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char li11[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,99,97,114,32,120,41,0,0};
static C_char li12[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,99,100,114,32,120,41,0,0};
static C_char li13[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,115,101,116,45,99,97,114,33,32,120,32,121,41,0,0,0};
static C_char li14[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,115,101,116,45,99,100,114,33,32,120,32,121,41,0,0,0};
static C_char li15[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,99,97,100,114,32,120,41,0};
static C_char li16[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,97,100,100,114,32,120,41};
static C_char li17[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,100,100,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char li18[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,100,100,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char li19[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,99,97,97,114,32,120,41,0};
static C_char li20[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,99,100,97,114,32,120,41,0};
static C_char li21[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,99,100,100,114,32,120,41,0};
static C_char li22[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,97,97,97,114,32,120,41};
static C_char li23[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,97,97,100,114,32,120,41};
static C_char li24[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,97,100,97,114,32,120,41};
static C_char li25[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,100,97,97,114,32,120,41};
static C_char li26[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,100,97,100,114,32,120,41};
static C_char li27[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,100,100,97,114,32,120,41};
static C_char li28[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,100,100,100,114,32,120,41};
static C_char li29[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,97,97,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char li30[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,97,97,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char li31[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,97,100,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char li32[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,97,100,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char li33[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,100,97,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char li34[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,100,97,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char li35[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,100,100,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char li36[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,97,97,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char li37[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,97,97,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char li38[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,97,100,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char li39[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,97,100,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char li40[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,100,97,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char li41[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,100,97,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char li42[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,100,100,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char li43[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,110,117,108,108,63,32,120,41};
static C_char li44[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,108,105,115,116,32,46,32,108,115,116,41,0,0,0,0,0};
static C_char li45[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,108,101,110,103,116,104,32,108,115,116,41,0,0,0,0,0};
static C_char li46[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,108,105,115,116,45,116,97,105,108,32,108,115,116,32,105,41};
static C_char li47[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,108,105,115,116,45,114,101,102,32,108,115,116,32,105,41,0};
static C_char li48[] C_aligned={C_lihdr(0,0,15),40,108,111,111,112,32,108,115,116,32,114,101,115,116,41,0};
static C_char li49[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,114,101,118,101,114,115,101,32,108,115,116,48,41,0,0,0};
static C_char li50[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,109,101,109,113,32,120,32,108,115,116,41,0,0,0,0,0};
static C_char li51[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,109,101,109,118,32,120,32,108,115,116,41,0,0,0,0,0};
static C_char li52[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char li53[] C_aligned={C_lihdr(0,0,28),40,115,99,104,101,109,101,35,109,101,109,98,101,114,32,120,32,108,115,116,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char li54[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,97,115,115,113,32,120,32,108,115,116,41,0,0,0,0,0};
static C_char li55[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,97,115,115,118,32,120,32,108,115,116,41,0,0,0,0,0};
static C_char li56[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char li57[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,97,115,115,111,99,32,120,32,108,115,116,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li58[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,108,105,115,116,63,32,120,41};
static C_char li59[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,115,116,114,105,110,103,63,32,120,41,0,0,0,0,0,0};
static C_char li60[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,108,101,110,103,116,104,32,115,41};
static C_char li61[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,114,101,102,32,115,32,105,41,0};
static C_char li62[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,115,101,116,33,32,115,32,105,32,99,41,0,0,0,0,0,0};
static C_char li63[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,115,115,32,102,41,0,0,0,0,0};
static C_char li64[] C_aligned={C_lihdr(0,0,28),40,115,99,104,101,109,101,35,115,116,114,105,110,103,61,63,32,120,32,121,32,46,32,109,111,114,101,41,0,0,0,0};
static C_char li65[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,115,115,32,102,41,0,0,0,0,0};
static C_char li66[] C_aligned={C_lihdr(0,0,31),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,105,61,63,32,120,32,121,32,46,32,109,111,114,101,41,0};
static C_char li67[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,101,120,97,99,116,45,62,105,110,101,120,97,99,116,32,120,41,0,0,0,0,0,0,0};
static C_char li68[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,97,98,115,32,120,41,0,0};
static C_char li69[] C_aligned={C_lihdr(0,0,6),67,95,112,108,117,115,0,0};
static C_char li70[] C_aligned={C_lihdr(0,0,7),67,95,109,105,110,117,115,0};
static C_char li71[] C_aligned={C_lihdr(0,0,7),67,95,116,105,109,101,115,0};
static C_char li72[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,113,117,111,116,105,101,110,116,32,97,32,98,41,0,0,0};
static C_char li73[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,114,101,109,97,105,110,100,101,114,32,97,32,98,41,0,0};
static C_char li74[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,109,111,100,117,108,111,32,97,32,98,41,0,0,0,0,0};
static C_char li75[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,101,118,101,110,63,32,110,41};
static C_char li76[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,111,100,100,63,32,110,41,0};
static C_char li77[] C_aligned={C_lihdr(0,0,9),67,95,110,101,113,117,97,108,112,0,0,0,0,0,0,0};
static C_char li78[] C_aligned={C_lihdr(0,0,10),67,95,103,114,101,97,116,101,114,112,0,0,0,0,0,0};
static C_char li79[] C_aligned={C_lihdr(0,0,7),67,95,108,101,115,115,112,0};
static C_char li80[] C_aligned={C_lihdr(0,0,20),67,95,103,114,101,97,116,101,114,95,111,114,95,101,113,117,97,108,95,112,0,0,0,0};
static C_char li81[] C_aligned={C_lihdr(0,0,17),67,95,108,101,115,115,95,111,114,95,101,113,117,97,108,95,112,0,0,0,0,0,0,0};
static C_char li82[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,110,117,109,98,101,114,63,32,120,41,0,0,0,0,0,0};
static C_char li83[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,114,101,97,108,63,32,120,41};
static C_char li84[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,114,97,116,105,111,110,97,108,63,32,110,41,0,0,0,0};
static C_char li85[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,105,110,116,101,103,101,114,63,32,120,41,0,0,0,0,0};
static C_char li86[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,101,120,97,99,116,63,32,120,41,0,0,0,0,0,0,0};
static C_char li87[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,105,110,101,120,97,99,116,63,32,120,41,0,0,0,0,0};
static C_char li88[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,122,101,114,111,63,32,110,41};
static C_char li89[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,112,111,115,105,116,105,118,101,63,32,110,41,0,0,0,0};
static C_char li90[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,110,101,103,97,116,105,118,101,63,32,110,41,0,0,0,0};
static C_char li91[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,101,120,97,99,116,45,105,110,116,101,103,101,114,63,32,120,41,0,0,0,0,0,0,0};
static C_char li92[] C_aligned={C_lihdr(0,0,18),67,95,110,117,109,98,101,114,95,116,111,95,115,116,114,105,110,103,0,0,0,0,0,0};
static C_char li93[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,115,121,109,98,111,108,63,32,120,41,0,0,0,0,0,0};
static C_char li94[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,118,101,99,116,111,114,63,32,120,41,0,0,0,0,0,0};
static C_char li95[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,108,101,110,103,116,104,32,118,41};
static C_char li96[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,114,101,102,32,118,32,105,41,0};
static C_char li97[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,115,101,116,33,32,118,32,105,32,120,41,0,0,0,0,0,0};
static C_char li98[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,104,97,114,63,32,120,41};
static C_char li99[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,99,104,97,114,45,62,105,110,116,101,103,101,114,32,99,41};
static C_char li100[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,105,110,116,101,103,101,114,45,62,99,104,97,114,32,110,41};
static C_char li101[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,99,115,32,102,41,0,0,0,0,0};
static C_char li102[] C_aligned={C_lihdr(0,0,28),40,115,99,104,101,109,101,35,99,104,97,114,61,63,32,99,49,32,99,50,32,46,32,109,111,114,101,41,0,0,0,0};
static C_char li103[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,99,115,32,102,41,0,0,0,0,0};
static C_char li104[] C_aligned={C_lihdr(0,0,28),40,115,99,104,101,109,101,35,99,104,97,114,62,63,32,99,49,32,99,50,32,46,32,109,111,114,101,41,0,0,0,0};
static C_char li105[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,99,115,32,102,41,0,0,0,0,0};
static C_char li106[] C_aligned={C_lihdr(0,0,28),40,115,99,104,101,109,101,35,99,104,97,114,60,63,32,99,49,32,99,50,32,46,32,109,111,114,101,41,0,0,0,0};
static C_char li107[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,99,115,32,102,41,0,0,0,0,0};
static C_char li108[] C_aligned={C_lihdr(0,0,29),40,115,99,104,101,109,101,35,99,104,97,114,62,61,63,32,99,49,32,99,50,32,46,32,109,111,114,101,41,0,0,0};
static C_char li109[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,99,115,32,102,41,0,0,0,0,0};
static C_char li110[] C_aligned={C_lihdr(0,0,29),40,115,99,104,101,109,101,35,99,104,97,114,60,61,63,32,99,49,32,99,50,32,46,32,109,111,114,101,41,0,0,0};
static C_char li111[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,99,104,97,114,45,117,112,99,97,115,101,32,99,41,0,0};
static C_char li112[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,99,104,97,114,45,100,111,119,110,99,97,115,101,32,99,41};
static C_char li113[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,99,104,97,114,45,117,112,112,101,114,45,99,97,115,101,63,32,99,41,0,0,0,0,0};
static C_char li114[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,99,104,97,114,45,108,111,119,101,114,45,99,97,115,101,63,32,99,41,0,0,0,0,0};
static C_char li115[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,99,104,97,114,45,110,117,109,101,114,105,99,63,32,99,41};
static C_char li116[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,99,104,97,114,45,119,104,105,116,101,115,112,97,99,101,63,32,99,41,0,0,0,0,0};
static C_char li117[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,99,104,97,114,45,97,108,112,104,97,98,101,116,105,99,63,32,99,41,0,0,0,0,0};
static C_char li118[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,46,99,104,97,114,35,100,105,103,105,116,45,118,97,108,117,101,32,99,41,0,0,0,0,0};
static C_char li119[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,99,104,97,114,45,102,111,108,100,99,97,115,101,32,99,41};
static C_char li120[] C_aligned={C_lihdr(0,0,28),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,102,111,108,100,99,97,115,101,32,115,116,114,41,0,0,0,0};
static C_char li121[] C_aligned={C_lihdr(0,0,28),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,100,111,119,110,99,97,115,101,32,115,116,114,41,0,0,0,0};
static C_char li122[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,117,112,99,97,115,101,32,115,116,114,41,0,0,0,0,0,0};
static C_char li123[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,112,114,111,99,101,100,117,114,101,63,32,120,41,0,0,0};
static C_char li124[] C_aligned={C_lihdr(0,0,7),67,95,97,112,112,108,121,0};
static C_char li125[] C_aligned={C_lihdr(0,0,8),67,95,118,97,108,117,101,115};
static C_char li126[] C_aligned={C_lihdr(0,0,18),67,95,99,97,108,108,95,119,105,116,104,95,118,97,108,117,101,115,0,0,0,0,0,0};
static C_char li127[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,105,110,112,117,116,45,112,111,114,116,63,32,120,41,0,0};
static C_char li128[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,111,117,116,112,117,116,45,112,111,114,116,63,32,120,41,0};
static C_char li129[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,98,105,110,97,114,121,45,112,111,114,116,63,32,112,111,114,116,41,0,0,0,0,0,0};
static C_char li130[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,116,101,120,116,117,97,108,45,112,111,114,116,63,32,112,111,114,116,41,0,0,0,0,0};
static C_char li131[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,112,111,114,116,63,32,120,41};
static C_char li132[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,105,110,112,117,116,45,112,111,114,116,45,111,112,101,110,63,32,112,41,0,0,0,0,0};
static C_char li133[] C_aligned={C_lihdr(0,0,28),40,115,99,104,101,109,101,35,111,117,116,112,117,116,45,112,111,114,116,45,111,112,101,110,63,32,112,41,0,0,0,0};
static C_char li134[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,101,111,102,45,111,98,106,101,99,116,63,32,120,41,0,0};
static C_char li135[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,101,118,97,108,32,120,32,46,32,101,110,118,41,0,0,0};
static C_char li136[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,105,110,116,101,114,97,99,116,105,111,110,45,101,110,118,105,114,111,110,109,101,110,116,41};
static C_char li137[] C_aligned={C_lihdr(0,0,36),40,115,99,104,101,109,101,35,115,99,104,101,109,101,45,114,101,112,111,114,116,45,101,110,118,105,114,111,110,109,101,110,116,32,110,41,0,0,0,0};
static C_char li138[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,110,117,108,108,45,101,110,118,105,114,111,110,109,101,110,116,41,0,0,0,0,0,0,0};
static C_char li139[] C_aligned={C_lihdr(0,0,34),40,115,99,104,101,109,101,35,108,111,97,100,32,102,105,108,101,110,97,109,101,32,46,32,101,118,97,108,117,97,116,111,114,41,0,0,0,0,0,0};
static C_char li140[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,105,120,110,117,109,63,32,120,41};
static C_char li141[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,108,111,110,117,109,63,32,120,41};
static C_char li142[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,98,105,103,110,117,109,63,32,120,41};
static C_char li143[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,114,97,116,110,117,109,63,32,120,41};
static C_char li144[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,112,108,120,110,117,109,63,32,120,41,0,0,0,0,0,0,0};
static C_char li145[] C_aligned={C_lihdr(0,0,24),67,95,113,117,111,116,105,101,110,116,95,97,110,100,95,114,101,109,97,105,110,100,101,114};
static C_char li146[] C_aligned={C_lihdr(0,0,8),40,97,49,50,54,54,55,41};
static C_char li147[] C_aligned={C_lihdr(0,0,16),40,97,49,50,54,55,51,32,100,105,118,32,114,101,109,41};
static C_char li148[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,97,115,101,35,113,117,111,116,105,101,110,116,38,109,111,100,117,108,111,32,120,32,121,41,0,0,0,0,0,0};
static C_char li149[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,105,110,105,116,101,63,32,120,41};
static C_char li150[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,98,97,115,101,35,105,110,102,105,110,105,116,101,63,32,120,41,0,0,0,0,0,0};
static C_char li151[] C_aligned={C_lihdr(0,0,21),40,99,104,105,99,107,101,110,46,98,97,115,101,35,110,97,110,63,32,120,41,0,0,0};
static C_char li152[] C_aligned={C_lihdr(0,0,8),67,95,115,105,103,110,117,109};
static C_char li153[] C_aligned={C_lihdr(0,0,21),40,99,104,105,99,107,101,110,46,98,97,115,101,35,97,100,100,49,32,110,41,0,0,0};
static C_char li154[] C_aligned={C_lihdr(0,0,21),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,117,98,49,32,110,41,0,0,0};
static C_char li155[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,114,114,111,114,32,46,32,97,114,103,115,41,0,0,0,0,0};
static C_char li156[] C_aligned={C_lihdr(0,0,23),40,99,104,105,99,107,101,110,46,98,97,115,101,35,118,111,105,100,32,46,32,95,41,0};
static C_char li157[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,114,111,109,105,115,101,63,32,120,41,0,0,0,0,0,0,0};
static C_char li158[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,109,97,107,101,45,112,114,111,109,105,115,101,32,112,114,111,99,41,0,0,0,0,0,0,0};
static C_char li159[] C_aligned={C_lihdr(0,0,8),40,97,49,50,55,56,56,41};
static C_char li160[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,98,97,115,101,35,109,97,107,101,45,112,114,111,109,105,115,101,32,111,98,106,41,0};
static C_char li161[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,108,115,116,32,122,41,0,0,0,0};
static C_char li162[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,111,108,100,108,32,102,32,122,32,108,115,116,41,0,0,0,0};
static C_char li163[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char li164[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,111,108,100,114,32,102,32,122,32,108,115,116,41,0,0,0,0};
static C_char li165[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,111,110,45,101,120,105,116,32,116,104,117,110,107,41,0,0,0,0};
static C_char li166[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,120,105,116,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char li167[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,109,101,114,103,101,110,99,121,45,101,120,105,116,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char li168[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,98,97,115,101,35,105,100,101,110,116,105,116,121,32,120,41,0,0,0,0,0,0,0};
static C_char li169[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,114,101,100,115,41,0,0,0,0};
static C_char li170[] C_aligned={C_lihdr(0,0,11),40,102,95,49,50,57,49,56,32,120,41,0,0,0,0,0};
static C_char li171[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,111,110,106,111,105,110,32,46,32,112,114,101,100,115,41,0,0};
static C_char li172[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,114,101,100,115,41,0,0,0,0};
static C_char li173[] C_aligned={C_lihdr(0,0,11),40,102,95,49,50,57,53,49,32,120,41,0,0,0,0,0};
static C_char li174[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,97,115,101,35,100,105,115,106,111,105,110,32,46,32,112,114,101,100,115,41,0,0};
static C_char li175[] C_aligned={C_lihdr(0,0,13),40,102,95,49,50,57,57,55,32,46,32,95,41,0,0,0};
static C_char li176[] C_aligned={C_lihdr(0,0,13),40,102,95,49,50,57,57,57,32,46,32,95,41,0,0,0};
static C_char li177[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,111,110,115,116,97,110,116,108,121,32,46,32,120,115,41,0,0};
static C_char li178[] C_aligned={C_lihdr(0,0,13),40,102,95,49,51,48,48,57,32,120,32,121,41,0,0,0};
static C_char li179[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,108,105,112,32,112,114,111,99,41};
static C_char li180[] C_aligned={C_lihdr(0,0,16),40,102,95,49,51,48,49,55,32,46,32,97,114,103,115,41};
static C_char li181[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,111,109,112,108,101,109,101,110,116,32,112,41,0,0,0,0,0};
static C_char li182[] C_aligned={C_lihdr(0,0,8),40,97,49,51,48,52,51,41};
static C_char li183[] C_aligned={C_lihdr(0,0,16),40,102,95,49,51,48,51,56,32,46,32,97,114,103,115,41};
static C_char li184[] C_aligned={C_lihdr(0,0,14),40,114,101,99,32,102,48,32,46,32,102,110,115,41,0,0};
static C_char li185[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,111,109,112,111,115,101,32,46,32,102,110,115,41,0,0,0,0};
static C_char li186[] C_aligned={C_lihdr(0,0,11),40,102,95,49,51,48,56,57,32,120,41,0,0,0,0,0};
static C_char li187[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,102,110,115,41,0,0,0,0,0,0};
static C_char li188[] C_aligned={C_lihdr(0,0,22),40,99,104,105,99,107,101,110,46,98,97,115,101,35,111,32,46,32,102,110,115,41,0,0};
static C_char li189[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char li190[] C_aligned={C_lihdr(0,0,13),40,102,95,49,51,49,48,52,32,108,115,116,41,0,0,0};
static C_char li191[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,108,105,115,116,45,111,102,63,32,112,114,101,100,41,0,0,0,0};
static C_char li192[] C_aligned={C_lihdr(0,0,13),40,102,95,49,51,49,53,52,32,46,32,95,41,0,0,0};
static C_char li193[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,114,111,99,115,41,0,0,0,0};
static C_char li194[] C_aligned={C_lihdr(0,0,16),40,102,95,49,51,49,54,56,32,46,32,97,114,103,115,41};
static C_char li195[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,97,99,104,32,46,32,112,114,111,99,115,41,0,0,0,0,0};
static C_char li196[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,98,119,112,45,111,98,106,101,99,116,63,32,120,41,0,0,0,0};
static C_char li197[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,119,101,97,107,45,99,111,110,115,32,120,32,121,41,0,0,0,0};
static C_char li198[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,97,115,101,35,119,101,97,107,45,112,97,105,114,63,32,120,41,0,0,0,0,0};
static C_char li199[] C_aligned={C_lihdr(0,0,22),40,99,104,105,99,107,101,110,46,98,97,115,101,35,97,116,111,109,63,32,120,41,0,0};
static C_char li200[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char li201[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,116,97,105,108,63,32,120,32,121,41};
static C_char li202[] C_aligned={C_lihdr(0,0,9),40,108,111,111,112,32,110,115,41,0,0,0,0,0,0,0};
static C_char li203[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,98,97,115,101,35,105,110,116,101,114,115,112,101,114,115,101,32,108,115,116,32,120,41};
static C_char li204[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char li205[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,98,97,115,101,35,98,117,116,108,97,115,116,32,108,115,116,41,0,0,0,0,0,0};
static C_char li206[] C_aligned={C_lihdr(0,0,17),40,108,111,111,112,32,108,105,115,116,115,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char li207[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,108,97,116,116,101,110,32,46,32,108,105,115,116,115,48,41,0};
static C_char li208[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,108,115,116,115,41,0,0,0,0,0};
static C_char li209[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,97,115,101,35,106,111,105,110,32,108,115,116,115,32,46,32,108,115,116,41,0,0};
static C_char li210[] C_aligned={C_lihdr(0,0,15),40,108,111,111,112,32,98,108,115,116,32,108,115,116,41,0};
static C_char li211[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,111,109,112,114,101,115,115,32,98,108,115,116,32,108,115,116,41};
static C_char li212[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char li213[] C_aligned={C_lihdr(0,0,15),40,102,95,49,51,53,50,52,32,120,32,108,115,116,41,0};
static C_char li214[] C_aligned={C_lihdr(0,0,43),40,99,104,105,99,107,101,110,46,98,97,115,101,35,97,108,105,115,116,45,117,112,100,97,116,101,33,32,120,32,121,32,108,115,116,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li215[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char li216[] C_aligned={C_lihdr(0,0,42),40,99,104,105,99,107,101,110,46,98,97,115,101,35,97,108,105,115,116,45,117,112,100,97,116,101,32,107,32,118,32,108,115,116,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char li217[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char li218[] C_aligned={C_lihdr(0,0,15),40,102,95,49,51,55,49,54,32,120,32,108,115,116,41,0};
static C_char li219[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,98,97,115,101,35,97,108,105,115,116,45,114,101,102,32,120,32,108,115,116,32,46,32,114,101,115,116,41,0,0,0};
static C_char li220[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,108,41};
static C_char li221[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,98,97,115,101,35,114,97,115,115,111,99,32,120,32,108,115,116,32,46,32,116,115,116,41,0,0,0,0,0,0,0};
static C_char li222[] C_aligned={C_lihdr(0,0,33),40,115,99,104,101,109,101,35,111,112,101,110,45,105,110,112,117,116,45,115,116,114,105,110,103,32,115,116,114,105,110,103,41,0,0,0,0,0,0,0};
static C_char li223[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,111,112,101,110,45,111,117,116,112,117,116,45,115,116,114,105,110,103,41,0,0,0,0,0};
static C_char li224[] C_aligned={C_lihdr(0,0,31),40,115,99,104,101,109,101,35,103,101,116,45,111,117,116,112,117,116,45,115,116,114,105,110,103,32,112,111,114,116,41,0};
static C_char li225[] C_aligned={C_lihdr(0,0,10),40,97,49,51,57,51,55,32,95,41,0,0,0,0,0,0};
static C_char li226[] C_aligned={C_lihdr(0,0,10),40,97,49,51,57,53,48,32,95,41,0,0,0,0,0,0};
static C_char li227[] C_aligned={C_lihdr(0,0,12),40,97,49,51,57,53,57,32,95,32,95,41,0,0,0,0};
static C_char li228[] C_aligned={C_lihdr(0,0,10),40,97,49,51,57,54,53,32,95,41,0,0,0,0,0,0};
static C_char li229[] C_aligned={C_lihdr(0,0,23),40,97,49,51,57,55,53,32,112,32,110,32,100,101,115,116,32,115,116,97,114,116,41,0};
static C_char li230[] C_aligned={C_lihdr(0,0,33),40,115,99,104,101,109,101,35,111,112,101,110,45,105,110,112,117,116,45,98,121,116,101,118,101,99,116,111,114,32,98,118,41,0,0,0,0,0,0,0};
static C_char li231[] C_aligned={C_lihdr(0,0,18),40,97,100,100,32,98,118,32,115,116,97,114,116,32,101,110,100,41,0,0,0,0,0,0};
static C_char li232[] C_aligned={C_lihdr(0,0,8),40,103,101,116,116,101,114,41};
static C_char li233[] C_aligned={C_lihdr(0,0,12),40,97,49,52,48,50,51,32,112,32,99,41,0,0,0,0};
static C_char li234[] C_aligned={C_lihdr(0,0,23),40,97,49,52,48,52,48,32,112,32,98,118,32,115,116,97,114,116,32,101,110,100,41,0};
static C_char li235[] C_aligned={C_lihdr(0,0,12),40,97,49,52,48,52,54,32,95,32,95,41,0,0,0,0};
static C_char li236[] C_aligned={C_lihdr(0,0,31),40,115,99,104,101,109,101,35,111,112,101,110,45,111,117,116,112,117,116,45,98,121,116,101,118,101,99,116,111,114,41,0};
static C_char li237[] C_aligned={C_lihdr(0,0,6),40,102,97,105,108,41,0,0};
static C_char li238[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,103,101,116,45,111,117,116,112,117,116,45,98,121,116,101,118,101,99,116,111,114,32,112,41};
static C_char li239[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,43,32,120,32,121,41};
static C_char li240[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,45,32,120,32,121,41};
static C_char li241[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,42,32,120,32,121,41};
static C_char li242[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,61,32,120,32,121,41};
static C_char li243[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,62,32,120,32,121,41};
static C_char li244[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,60,32,120,32,121,41};
static C_char li245[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,62,61,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char li246[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,60,61,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char li247[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,109,105,110,32,120,32,121,41,0,0,0,0,0,0};
static C_char li248[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,109,97,120,32,120,32,121,41,0,0,0,0,0,0};
static C_char li249[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,110,101,103,32,120,41};
static C_char li250[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,97,110,100,32,120,32,121,41,0,0,0,0,0,0};
static C_char li251[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,105,111,114,32,120,32,121,41,0,0,0,0,0,0};
static C_char li252[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,120,111,114,32,120,32,121,41,0,0,0,0,0,0};
static C_char li253[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,110,111,116,32,120,41};
static C_char li254[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,115,104,108,32,120,32,121,41,0,0,0,0,0,0};
static C_char li255[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,115,104,114,32,120,32,121,41,0,0,0,0,0,0};
static C_char li256[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,111,100,100,63,32,120,41,0,0,0,0,0,0,0};
static C_char li257[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,101,118,101,110,63,32,120,41,0,0,0,0,0,0};
static C_char li258[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,108,101,110,32,120,41};
static C_char li259[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,47,32,120,32,121,41};
static C_char li260[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,103,99,100,32,120,32,121,41,0,0,0,0,0,0};
static C_char li261[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,109,111,100,32,120,32,121,41,0,0,0,0,0,0};
static C_char li262[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,114,101,109,32,120,32,121,41,0,0,0,0,0,0};
static C_char li263[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,43,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char li264[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,45,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char li265[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,42,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char li266[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,47,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char li267[] C_aligned={C_lihdr(0,0,19),40,35,35,115,121,115,35,100,101,98,117,103,45,109,111,100,101,63,41,0,0,0,0,0};
static C_char li268[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,98,97,115,101,35,119,97,114,110,105,110,103,32,109,115,103,32,46,32,97,114,103,115,41,0,0,0,0,0,0,0};
static C_char li269[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,98,97,115,101,35,110,111,116,105,99,101,32,109,115,103,32,46,32,97,114,103,115,41};
static C_char li270[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,110,97,98,108,101,45,119,97,114,110,105,110,103,115,32,46,32,98,111,111,108,41,0,0,0};
static C_char li271[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,101,114,114,111,114,47,101,114,114,110,111,32,101,114,114,32,46,32,97,114,103,115,41,0,0};
static C_char li272[] C_aligned={C_lihdr(0,0,4),67,95,103,99,0,0,0,0};
static C_char li273[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,115,101,116,115,108,111,116,32,120,32,105,32,121,41,0,0,0};
static C_char li274[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,115,101,116,105,115,108,111,116,32,120,32,105,32,121,41,0,0};
static C_char li275[] C_aligned={C_lihdr(0,0,17),67,95,97,108,108,111,99,97,116,101,95,118,101,99,116,111,114,0,0,0,0,0,0,0};
static C_char li276[] C_aligned={C_lihdr(0,0,21),67,95,97,108,108,111,99,97,116,101,95,98,121,116,101,118,101,99,116,111,114,0,0,0};
static C_char li277[] C_aligned={C_lihdr(0,0,16),67,95,109,97,107,101,95,115,116,114,117,99,116,117,114,101};
static C_char li278[] C_aligned={C_lihdr(0,0,21),67,95,101,110,115,117,114,101,95,104,101,97,112,95,114,101,115,101,114,118,101,0,0,0};
static C_char li279[] C_aligned={C_lihdr(0,0,23),67,95,103,101,116,95,115,121,109,98,111,108,95,116,97,98,108,101,95,105,110,102,111,0};
static C_char li280[] C_aligned={C_lihdr(0,0,17),67,95,103,101,116,95,109,101,109,111,114,121,95,105,110,102,111,0,0,0,0,0,0,0};
static C_char li281[] C_aligned={C_lihdr(0,0,19),40,35,35,115,121,115,35,115,116,97,114,116,45,116,105,109,101,114,41,0,0,0,0,0};
static C_char li282[] C_aligned={C_lihdr(0,0,12),67,95,115,116,111,112,95,116,105,109,101,114,0,0,0,0};
static C_char li283[] C_aligned={C_lihdr(0,0,12),67,95,115,116,111,112,95,116,105,109,101,114,0,0,0,0};
static C_char li284[] C_aligned={C_lihdr(0,0,18),40,35,35,115,121,115,35,115,116,111,112,45,116,105,109,101,114,41,0,0,0,0,0,0};
static C_char li285[] C_aligned={C_lihdr(0,0,20),40,35,35,115,121,115,35,105,109,109,101,100,105,97,116,101,63,32,120,41,0,0,0,0};
static C_char li286[] C_aligned={C_lihdr(0,0,19),40,35,35,115,121,115,35,109,101,115,115,97,103,101,32,115,116,114,41,0,0,0,0,0};
static C_char li287[] C_aligned={C_lihdr(0,0,16),40,35,35,115,121,115,35,98,121,116,101,32,120,32,105,41};
static C_char li288[] C_aligned={C_lihdr(0,0,16),40,35,35,115,121,115,35,104,97,108,116,32,109,115,103,41};
static C_char li289[] C_aligned={C_lihdr(0,0,8),67,95,98,101,99,111,109,101};
static C_char li290[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,98,108,111,99,107,45,114,101,102,32,120,32,105,41,0,0,0};
static C_char li291[] C_aligned={C_lihdr(0,0,14),67,95,97,112,112,108,121,95,118,97,108,117,101,115,0,0};
static C_char li292[] C_aligned={C_lihdr(0,0,14),67,95,99,111,112,121,95,99,108,111,115,117,114,101,0,0};
static C_char li293[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,98,108,111,99,107,45,115,101,116,33,32,120,32,105,32,121,41};
static C_char li294[] C_aligned={C_lihdr(0,0,43),40,99,104,105,99,107,101,110,46,116,105,109,101,35,99,117,114,114,101,110,116,45,112,114,111,99,101,115,115,45,109,105,108,108,105,115,101,99,111,110,100,115,41,0,0,0,0,0};
static C_char li295[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,116,105,109,101,35,99,117,114,114,101,110,116,45,115,101,99,111,110,100,115,41,0,0};
static C_char li296[] C_aligned={C_lihdr(0,0,23),40,99,104,105,99,107,101,110,46,116,105,109,101,35,99,112,117,45,116,105,109,101,41,0};
static C_char li297[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,99,104,101,99,107,45,115,116,114,117,99,116,117,114,101,32,120,32,121,32,46,32,108,111,99,41,0,0,0,0,0,0,0};
static C_char li298[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,98,108,111,98,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char li299[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,112,97,105,114,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char li300[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,108,105,115,116,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char li301[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,99,104,101,99,107,45,115,116,114,105,110,103,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char li302[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,99,104,101,99,107,45,110,117,109,98,101,114,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char li303[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,99,104,101,99,107,45,102,105,120,110,117,109,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char li304[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,99,104,101,99,107,45,98,121,116,101,118,101,99,116,111,114,32,120,32,46,32,108,111,99,41};
static C_char li305[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,99,104,101,99,107,45,101,120,97,99,116,32,120,32,46,32,108,111,99,41,0,0,0,0,0};
static C_char li306[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,99,104,101,99,107,45,105,110,101,120,97,99,116,32,120,32,46,32,108,111,99,41,0,0,0};
static C_char li307[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,99,104,101,99,107,45,115,121,109,98,111,108,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char li308[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,99,104,101,99,107,45,107,101,121,119,111,114,100,32,120,32,46,32,108,111,99,41,0,0,0};
static C_char li309[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,99,104,101,99,107,45,118,101,99,116,111,114,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char li310[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,99,104,97,114,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char li311[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,99,104,101,99,107,45,98,111,111,108,101,97,110,32,120,32,46,32,108,111,99,41,0,0,0};
static C_char li312[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,99,104,101,99,107,45,108,111,99,97,116,105,118,101,32,120,32,46,32,108,111,99,41,0,0};
static C_char li313[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,99,104,101,99,107,45,105,110,116,101,103,101,114,32,120,32,46,32,108,111,99,41,0,0,0};
static C_char li314[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,99,104,101,99,107,45,101,120,97,99,116,45,105,110,116,101,103,101,114,32,120,32,46,32,108,111,99,41,0,0,0,0,0};
static C_char li315[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,99,104,101,99,107,45,101,120,97,99,116,45,117,105,110,116,101,103,101,114,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char li316[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,114,101,97,108,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char li317[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,99,104,101,99,107,45,114,97,110,103,101,32,105,32,102,114,111,109,32,116,111,32,46,32,108,111,99,41,0,0,0,0,0};
static C_char li318[] C_aligned={C_lihdr(0,0,45),40,35,35,115,121,115,35,99,104,101,99,107,45,114,97,110,103,101,47,105,110,99,108,117,100,105,110,103,32,105,32,102,114,111,109,32,116,111,32,46,32,108,111,99,41,0,0,0};
static C_char li319[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,99,104,101,99,107,45,115,112,101,99,105,97,108,32,112,116,114,32,46,32,108,111,99,41,0};
static C_char li320[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,99,104,101,99,107,45,99,108,111,115,117,114,101,32,120,32,46,32,108,111,99,41,0,0,0};
static C_char li321[] C_aligned={C_lihdr(0,0,20),40,108,112,32,112,114,111,109,105,115,101,32,102,111,114,119,97,114,100,41,0,0,0,0};
static C_char li322[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,102,111,114,99,101,32,111,98,106,41,0,0,0,0,0,0};
static C_char li323[] C_aligned={C_lihdr(0,0,7),67,95,100,108,111,97,100,0};
static C_char li324[] C_aligned={C_lihdr(0,0,18),67,95,115,101,116,95,100,108,111,112,101,110,95,102,108,97,103,115,0,0,0,0,0,0};
static C_char li325[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,101,114,114,111,114,45,110,111,116,45,97,45,112,114,111,112,101,114,45,108,105,115,116,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char li326[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,110,117,109,98,101,114,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li327[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,105,110,116,101,103,101,114,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char li328[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,101,120,97,99,116,45,105,110,116,101,103,101,114,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char li329[] C_aligned={C_lihdr(0,0,43),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,101,120,97,99,116,45,117,105,110,116,101,103,101,114,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li330[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,105,110,101,120,97,99,116,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char li331[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,114,101,97,108,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char li332[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,98,97,115,101,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char li333[] C_aligned={C_lihdr(0,0,11),40,99,111,112,121,32,110,111,100,101,41,0,0,0,0,0};
static C_char li334[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,108,115,116,115,41,0,0,0,0,0};
static C_char li335[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,97,112,112,101,110,100,32,46,32,108,115,116,115,41,0,0};
static C_char li336[] C_aligned={C_lihdr(0,0,15),40,108,111,111,112,32,108,115,116,32,114,101,115,116,41,0};
static C_char li337[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,102,97,115,116,45,114,101,118,101,114,115,101,32,108,115,116,48,41,0,0,0,0,0,0,0};
static C_char li338[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,109,97,107,101,45,98,121,116,101,118,101,99,116,111,114,32,115,105,122,101,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li339[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,109,97,107,101,45,115,116,114,105,110,103,32,115,105,122,101,32,46,32,114,101,115,116,41,0};
static C_char li340[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,98,117,102,102,101,114,45,62,115,116,114,105,110,103,32,98,117,102,32,115,116,97,114,116,32,108,101,110,41,0,0,0,0};
static C_char li341[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,117,116,102,45,100,101,99,111,100,101,114,32,98,117,102,32,115,116,97,114,116,32,108,101,110,32,107,41,0,0,0,0,0};
static C_char li342[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,117,116,102,45,101,110,99,111,100,101,114,32,98,117,102,32,115,116,97,114,116,32,108,101,110,32,107,41,0,0,0,0,0};
static C_char li343[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,117,116,102,45,115,99,97,110,110,101,114,32,115,116,97,116,101,32,98,121,116,101,41,0,0};
static C_char li344[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,108,97,116,105,110,45,100,101,99,111,100,101,114,32,98,118,32,115,116,97,114,116,32,108,101,110,32,107,41,0,0,0,0};
static C_char li345[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,108,97,116,105,110,45,101,110,99,111,100,101,114,32,98,118,32,115,116,97,114,116,32,108,101,110,32,107,41,0,0,0,0};
static C_char li346[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,108,97,116,105,110,45,115,99,97,110,110,101,114,32,115,116,97,116,101,32,98,121,116,101,41};
static C_char li347[] C_aligned={C_lihdr(0,0,37),40,35,35,115,121,115,35,98,105,110,97,114,121,45,100,101,99,111,100,101,114,32,98,118,32,115,116,97,114,116,32,108,101,110,32,107,41,0,0,0};
static C_char li348[] C_aligned={C_lihdr(0,0,37),40,35,35,115,121,115,35,98,105,110,97,114,121,45,101,110,99,111,100,101,114,32,98,118,32,115,116,97,114,116,32,108,101,110,32,107,41,0,0,0};
static C_char li349[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,98,105,110,97,114,121,45,115,99,97,110,110,101,114,32,115,116,97,116,101,32,98,121,116,101,41,0,0,0,0,0,0,0};
static C_char li350[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,101,110,99,111,100,105,110,103,45,104,111,111,107,32,101,110,99,32,107,41,0,0,0,0,0};
static C_char li351[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,101,110,99,111,100,105,110,103,45,104,111,111,107,32,101,110,99,32,107,41,0,0,0,0,0};
static C_char li352[] C_aligned={C_lihdr(0,0,44),40,35,35,115,121,115,35,114,101,103,105,115,116,101,114,45,101,110,99,111,100,105,110,103,32,110,97,109,101,115,32,100,101,99,32,101,110,99,32,115,99,97,110,41,0,0,0,0};
static C_char li353[] C_aligned={C_lihdr(0,0,20),40,97,49,53,50,51,52,32,100,101,99,111,100,101,114,32,95,32,95,41,0,0,0,0};
static C_char li354[] C_aligned={C_lihdr(0,0,49),40,35,35,115,121,115,35,98,117,102,102,101,114,45,62,115,116,114,105,110,103,47,101,110,99,111,100,105,110,103,32,98,117,102,32,115,116,97,114,116,32,108,101,110,32,101,110,99,41,0,0,0,0,0,0,0};
static C_char li355[] C_aligned={C_lihdr(0,0,20),40,97,49,53,50,52,54,32,95,32,101,110,99,111,100,101,114,32,95,41,0,0,0,0};
static C_char li356[] C_aligned={C_lihdr(0,0,40),40,35,35,115,121,115,35,101,110,99,111,100,101,45,98,117,102,102,101,114,32,98,118,32,115,116,97,114,116,32,108,101,110,32,101,110,99,32,107,41};
static C_char li357[] C_aligned={C_lihdr(0,0,20),40,97,49,53,50,53,56,32,100,101,99,111,100,101,114,32,95,32,95,41,0,0,0,0};
static C_char li358[] C_aligned={C_lihdr(0,0,40),40,35,35,115,121,115,35,100,101,99,111,100,101,45,98,117,102,102,101,114,32,98,118,32,115,116,97,114,116,32,108,101,110,32,101,110,99,32,107,41};
static C_char li359[] C_aligned={C_lihdr(0,0,22),40,97,49,53,50,55,57,32,98,117,102,32,115,116,97,114,116,32,108,101,110,41,0,0};
static C_char li360[] C_aligned={C_lihdr(0,0,20),40,97,49,53,50,55,48,32,95,32,101,110,99,111,100,101,114,32,95,41,0,0,0,0};
static C_char li361[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,101,110,99,111,100,101,45,99,104,97,114,32,99,32,98,118,32,101,110,99,41,0,0,0,0};
static C_char li362[] C_aligned={C_lihdr(0,0,20),40,97,49,53,50,57,50,32,98,117,102,32,115,116,97,114,116,32,95,41,0,0,0,0};
static C_char li363[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,100,101,99,111,100,101,45,99,104,97,114,32,98,118,32,101,110,99,32,115,116,97,114,116,41};
static C_char li364[] C_aligned={C_lihdr(0,0,14),40,108,111,111,112,32,115,116,97,116,101,32,105,41,0,0};
static C_char li365[] C_aligned={C_lihdr(0,0,19),40,97,49,53,51,48,49,32,100,101,99,32,95,32,115,99,97,110,41,0,0,0,0,0};
static C_char li366[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,114,101,97,100,45,99,104,97,114,47,101,110,99,111,100,105,110,103,32,112,32,101,110,99,32,107,41,0,0,0,0,0,0};
static C_char li367[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,109,97,107,101,45,115,116,114,105,110,103,32,115,105,122,101,32,46,32,102,105,108,108,41};
static C_char li368[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,105,32,108,115,41,0,0,0,0,0};
static C_char li369[] C_aligned={C_lihdr(0,0,30),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,62,108,105,115,116,32,115,32,46,32,114,101,115,116,41,0,0};
static C_char li370[] C_aligned={C_lihdr(0,0,14),40,108,111,111,112,32,105,32,112,32,108,115,116,41,0,0};
static C_char li371[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,108,105,115,116,45,62,115,116,114,105,110,103,32,108,115,116,48,41,0,0,0,0,0,0};
static C_char li372[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,32,108,32,110,41,0,0,0,0};
static C_char li373[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,114,101,118,101,114,115,101,45,108,105,115,116,45,62,115,116,114,105,110,103,32,108,41,0,0};
static C_char li374[] C_aligned={C_lihdr(0,0,12),40,100,111,108,111,111,112,50,48,54,50,41,0,0,0,0};
static C_char li375[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,102,105,108,108,33,32,115,32,99,32,46,32,114,101,115,116,41};
static C_char li376[] C_aligned={C_lihdr(0,0,29),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,111,112,121,32,115,32,46,32,114,101,115,116,41,0,0,0};
static C_char li377[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,50,49,50,48,32,105,41,0,0};
static C_char li378[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,50,49,50,54,32,105,41,0,0};
static C_char li379[] C_aligned={C_lihdr(0,0,39),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,111,112,121,33,32,116,111,32,97,116,32,102,114,111,109,32,46,32,114,101,115,116,41,0};
static C_char li380[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,115,117,98,115,116,114,105,110,103,32,115,32,115,116,97,114,116,32,101,110,100,41,0,0,0};
static C_char li381[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,115,117,98,115,116,114,105,110,103,32,115,32,115,116,97,114,116,32,46,32,101,110,100,41};
static C_char li382[] C_aligned={C_lihdr(0,0,17),40,108,111,111,112,32,115,32,108,101,110,32,115,115,32,102,41,0,0,0,0,0,0,0};
static C_char li383[] C_aligned={C_lihdr(0,0,28),40,99,111,109,112,97,114,101,32,115,49,32,115,50,32,109,111,114,101,32,108,111,99,32,99,109,112,41,0,0,0,0};
static C_char li384[] C_aligned={C_lihdr(0,0,22),40,97,49,54,48,55,52,32,99,109,112,32,108,101,110,49,32,108,101,110,50,41,0,0};
static C_char li385[] C_aligned={C_lihdr(0,0,30),40,115,99,104,101,109,101,35,115,116,114,105,110,103,60,63,32,115,49,32,115,50,32,46,32,109,111,114,101,41,0,0};
static C_char li386[] C_aligned={C_lihdr(0,0,22),40,97,49,54,48,57,56,32,99,109,112,32,108,101,110,49,32,108,101,110,50,41,0,0};
static C_char li387[] C_aligned={C_lihdr(0,0,30),40,115,99,104,101,109,101,35,115,116,114,105,110,103,62,63,32,115,49,32,115,50,32,46,32,109,111,114,101,41,0,0};
static C_char li388[] C_aligned={C_lihdr(0,0,22),40,97,49,54,49,50,50,32,99,109,112,32,108,101,110,49,32,108,101,110,50,41,0,0};
static C_char li389[] C_aligned={C_lihdr(0,0,31),40,115,99,104,101,109,101,35,115,116,114,105,110,103,60,61,63,32,115,49,32,115,50,32,46,32,109,111,114,101,41,0};
static C_char li390[] C_aligned={C_lihdr(0,0,22),40,97,49,54,49,52,51,32,99,109,112,32,108,101,110,49,32,108,101,110,50,41,0,0};
static C_char li391[] C_aligned={C_lihdr(0,0,31),40,115,99,104,101,109,101,35,115,116,114,105,110,103,62,61,63,32,115,49,32,115,50,32,46,32,109,111,114,101,41,0};
static C_char li392[] C_aligned={C_lihdr(0,0,17),40,108,111,111,112,32,115,32,108,101,110,32,115,115,32,102,41,0,0,0,0,0,0,0};
static C_char li393[] C_aligned={C_lihdr(0,0,28),40,99,111,109,112,97,114,101,32,115,49,32,115,50,32,109,111,114,101,32,108,111,99,32,99,109,112,41,0,0,0,0};
static C_char li394[] C_aligned={C_lihdr(0,0,22),40,97,49,54,50,50,52,32,99,109,112,32,108,101,110,49,32,108,101,110,50,41,0,0};
static C_char li395[] C_aligned={C_lihdr(0,0,33),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,105,60,63,32,115,49,32,115,50,32,46,32,109,111,114,101,41,0,0,0,0,0,0,0};
static C_char li396[] C_aligned={C_lihdr(0,0,22),40,97,49,54,50,52,56,32,99,109,112,32,108,101,110,49,32,108,101,110,50,41,0,0};
static C_char li397[] C_aligned={C_lihdr(0,0,33),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,105,62,63,32,115,49,32,115,50,32,46,32,109,111,114,101,41,0,0,0,0,0,0,0};
static C_char li398[] C_aligned={C_lihdr(0,0,22),40,97,49,54,50,55,50,32,99,109,112,32,108,101,110,49,32,108,101,110,50,41,0,0};
static C_char li399[] C_aligned={C_lihdr(0,0,34),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,105,60,61,63,32,115,49,32,115,50,32,46,32,109,111,114,101,41,0,0,0,0,0,0};
static C_char li400[] C_aligned={C_lihdr(0,0,22),40,97,49,54,50,57,51,32,99,109,112,32,108,101,110,49,32,108,101,110,50,41,0,0};
static C_char li401[] C_aligned={C_lihdr(0,0,34),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,105,62,61,63,32,115,49,32,115,50,32,46,32,109,111,114,101,41,0,0,0,0,0,0};
static C_char li402[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,115,116,114,105,110,103,45,97,112,112,101,110,100,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char li403[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,115,116,114,115,32,110,32,117,108,41};
static C_char li404[] C_aligned={C_lihdr(0,0,28),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,97,112,112,101,110,100,32,46,32,97,108,108,41,0,0,0,0};
static C_char li405[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,115,116,114,105,110,103,32,46,32,99,104,97,114,115,41,0};
static C_char li406[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,99,104,97,114,45,62,117,116,102,56,45,115,116,114,105,110,103,32,99,41,0,0,0,0,0};
static C_char li407[] C_aligned={C_lihdr(0,0,20),40,100,111,108,111,111,112,50,51,49,50,32,104,100,32,116,108,32,99,41,0,0,0,0};
static C_char li408[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,108,115,116,32,105,41,0,0,0,0};
static C_char li409[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,104,111,112,32,108,115,116,32,110,41,0,0,0,0,0,0,0};
static C_char li410[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,43,32,120,32,121,41};
static C_char li411[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,45,32,120,32,121,41};
static C_char li412[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,42,32,120,32,121,41};
static C_char li413[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,47,32,120,32,121,41};
static C_char li414[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,42,43,32,120,32,121,32,122,41,0,0,0,0,0};
static C_char li415[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,103,99,100,32,120,32,121,41,0,0,0,0,0,0};
static C_char li416[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,47,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char li417[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,61,32,120,32,121,41};
static C_char li418[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,62,32,120,32,121,41};
static C_char li419[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,60,32,120,32,121,41};
static C_char li420[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,62,61,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char li421[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,60,61,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char li422[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,110,101,103,32,120,41};
static C_char li423[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,109,97,120,32,120,32,121,41,0,0,0,0,0,0};
static C_char li424[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,109,105,110,32,120,32,121,41,0,0,0,0,0,0};
static C_char li425[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,102,108,111,111,114,32,120,41,0,0,0,0,0,0};
static C_char li426[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,116,114,117,110,99,97,116,101,32,120,41,0,0,0};
static C_char li427[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,114,111,117,110,100,32,120,41,0,0,0,0,0,0};
static C_char li428[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,99,101,105,108,105,110,103,32,120,41,0,0,0,0};
static C_char li429[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,115,105,110,32,120,41};
static C_char li430[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,99,111,115,32,120,41};
static C_char li431[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,116,97,110,32,120,41};
static C_char li432[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,115,105,110,32,120,41,0,0,0,0,0,0,0};
static C_char li433[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,99,111,115,32,120,41,0,0,0,0,0,0,0};
static C_char li434[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,116,97,110,32,120,41,0,0,0,0,0,0,0};
static C_char li435[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,116,97,110,50,32,120,32,121,41,0,0,0,0};
static C_char li436[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,115,105,110,104,32,120,41,0,0,0,0,0,0,0};
static C_char li437[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,99,111,115,104,32,120,41,0,0,0,0,0,0,0};
static C_char li438[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,116,97,110,104,32,120,41,0,0,0,0,0,0,0};
static C_char li439[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,115,105,110,104,32,120,41,0,0,0,0,0,0};
static C_char li440[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,99,111,115,104,32,120,41,0,0,0,0,0,0};
static C_char li441[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,116,97,110,104,32,120,41,0,0,0,0,0,0};
static C_char li442[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,101,120,112,32,120,41};
static C_char li443[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,101,120,112,116,32,120,32,121,41,0,0,0,0,0};
static C_char li444[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,108,111,103,32,120,41};
static C_char li445[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,115,113,114,116,32,120,41,0,0,0,0,0,0,0};
static C_char li446[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,98,115,32,120,41};
static C_char li447[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,105,110,116,101,103,101,114,63,32,120,41,0,0,0};
static C_char li448[] C_aligned={C_lihdr(0,0,46),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,108,111,110,117,109,45,112,114,105,110,116,45,112,114,101,99,105,115,105,111,110,32,46,32,114,101,115,116,41,0,0};
static C_char li449[] C_aligned={C_lihdr(0,0,18),40,109,97,107,101,45,99,111,109,112,108,101,120,32,114,32,105,41,0,0,0,0,0,0};
static C_char li450[] C_aligned={C_lihdr(0,0,29),40,115,99,104,101,109,101,35,109,97,107,101,45,114,101,99,116,97,110,103,117,108,97,114,32,114,32,105,41,0,0,0};
static C_char li451[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,109,97,107,101,45,112,111,108,97,114,32,114,32,112,104,105,41,0,0,0,0,0,0,0};
static C_char li452[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,114,101,97,108,45,112,97,114,116,32,120,41,0,0,0,0};
static C_char li453[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,105,109,97,103,45,112,97,114,116,32,120,41,0,0,0,0};
static C_char li454[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,97,110,103,108,101,32,110,41};
static C_char li455[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,109,97,103,110,105,116,117,100,101,32,120,41,0,0,0,0};
static C_char li456[] C_aligned={C_lihdr(0,0,10),40,114,97,116,110,117,109,32,110,41,0,0,0,0,0,0};
static C_char li457[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,110,117,109,101,114,97,116,111,114,32,110,41,0,0,0,0};
static C_char li458[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,100,101,110,111,109,105,110,97,116,111,114,32,110,41,0,0};
static C_char li459[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,101,120,116,101,110,100,101,100,45,115,105,103,110,117,109,32,120,41,0,0,0,0,0,0,0};
static C_char li460[] C_aligned={C_lihdr(0,0,16),40,100,111,108,111,111,112,50,56,56,51,32,120,32,105,41};
static C_char li461[] C_aligned={C_lihdr(0,0,13),40,100,101,108,105,118,101,114,32,121,32,100,41,0,0,0};
static C_char li462[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,105,110,101,120,97,99,116,45,62,101,120,97,99,116,32,120,41,0,0,0,0,0,0,0};
static C_char li463[] C_aligned={C_lihdr(0,0,13),67,95,98,105,116,119,105,115,101,95,97,110,100,0,0,0};
static C_char li464[] C_aligned={C_lihdr(0,0,13),67,95,98,105,116,119,105,115,101,95,105,111,114,0,0,0};
static C_char li465[] C_aligned={C_lihdr(0,0,13),67,95,98,105,116,119,105,115,101,95,120,111,114,0,0,0};
static C_char li466[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,98,105,116,119,105,115,101,35,98,105,116,119,105,115,101,45,110,111,116,32,110,41,0};
static C_char li467[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,105,116,119,105,115,101,35,98,105,116,45,62,98,111,111,108,101,97,110,32,110,32,105,41,0,0,0,0,0,0};
static C_char li468[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,105,116,119,105,115,101,35,105,110,116,101,103,101,114,45,108,101,110,103,116,104,32,120,41,0,0,0,0,0,0};
static C_char li469[] C_aligned={C_lihdr(0,0,38),40,99,104,105,99,107,101,110,46,98,105,116,119,105,115,101,35,97,114,105,116,104,109,101,116,105,99,45,115,104,105,102,116,32,110,32,109,41,0,0};
static C_char li470[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,97,114,103,115,32,120,41,0,0,0};
static C_char li471[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,47,32,97,114,103,49,32,46,32,97,114,103,115,41,0,0};
static C_char li472[] C_aligned={C_lihdr(0,0,15),40,35,35,115,121,115,35,47,45,50,32,120,32,121,41,0};
static C_char li473[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,102,108,111,111,114,32,120,41};
static C_char li474[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,99,101,105,108,105,110,103,32,120,41,0,0,0,0,0,0};
static C_char li475[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,116,114,117,110,99,97,116,101,32,120,41,0,0,0,0,0};
static C_char li476[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,114,111,117,110,100,32,120,41};
static C_char li477[] C_aligned={C_lihdr(0,0,8),40,115,114,32,120,32,121,41};
static C_char li478[] C_aligned={C_lihdr(0,0,24),40,102,105,110,100,45,114,97,116,105,111,45,98,101,116,119,101,101,110,32,120,32,121,41};
static C_char li479[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,114,97,116,105,111,110,97,108,105,122,101,32,120,32,101,41};
static C_char li480[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,105,32,109,32,120,115,41,0,0,0};
static C_char li481[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,109,97,120,32,120,49,32,46,32,120,115,41,0,0,0,0};
static C_char li482[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,105,32,109,32,120,115,41,0,0,0};
static C_char li483[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,109,105,110,32,120,49,32,46,32,120,115,41,0,0,0,0};
static C_char li484[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,101,120,112,32,110,41,0,0};
static C_char li485[] C_aligned={C_lihdr(0,0,15),40,35,35,115,121,115,35,108,111,103,45,49,32,120,41,0};
static C_char li486[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,108,111,103,32,97,32,46,32,114,101,115,116,41,0,0,0};
static C_char li487[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,115,105,110,32,110,41,0,0};
static C_char li488[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,99,111,115,32,110,41,0,0};
static C_char li489[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,116,97,110,32,110,41,0,0};
static C_char li490[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,97,115,105,110,32,110,41,0};
static C_char li491[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,97,99,111,115,32,110,41,0};
static C_char li492[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,97,116,97,110,32,110,32,46,32,114,101,115,116,41,0,0};
static C_char li493[] C_aligned={C_lihdr(0,0,8),40,97,49,57,48,53,51,41};
static C_char li494[] C_aligned={C_lihdr(0,0,34),67,95,117,95,105,110,116,101,103,101,114,95,113,117,111,116,105,101,110,116,95,97,110,100,95,114,101,109,97,105,110,100,101,114,0,0,0,0,0,0};
static C_char li495[] C_aligned={C_lihdr(0,0,8),40,97,49,57,48,56,52,41};
static C_char li496[] C_aligned={C_lihdr(0,0,20),40,97,49,57,49,48,48,32,113,51,50,53,48,32,117,51,50,53,50,41,0,0,0,0};
static C_char li497[] C_aligned={C_lihdr(0,0,22),40,97,49,57,48,54,55,32,115,94,51,50,51,48,32,114,94,51,50,51,50,41,0,0};
static C_char li498[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,101,120,97,99,116,45,105,110,116,101,103,101,114,45,115,113,114,116,32,97,41,0,0,0,0};
static C_char li499[] C_aligned={C_lihdr(0,0,29),40,115,99,104,101,109,101,35,101,120,97,99,116,45,105,110,116,101,103,101,114,45,115,113,114,116,32,120,41,0,0,0};
static C_char li500[] C_aligned={C_lihdr(0,0,8),40,97,49,57,50,52,48,41};
static C_char li501[] C_aligned={C_lihdr(0,0,14),40,97,49,57,50,52,54,32,115,94,50,32,114,41,0,0};
static C_char li502[] C_aligned={C_lihdr(0,0,8),40,97,49,57,50,54,56,41};
static C_char li503[] C_aligned={C_lihdr(0,0,8),40,97,49,57,50,57,50,41};
static C_char li504[] C_aligned={C_lihdr(0,0,16),40,97,49,57,51,48,52,32,100,115,94,50,32,100,114,41};
static C_char li505[] C_aligned={C_lihdr(0,0,16),40,97,49,57,50,56,48,32,110,115,94,50,32,110,114,41};
static C_char li506[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,115,113,114,116,47,108,111,99,32,108,111,99,32,110,41,0,0};
static C_char li507[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,115,113,114,116,32,120,41,0};
static C_char li508[] C_aligned={C_lihdr(0,0,8),40,97,49,57,51,52,55,41};
static C_char li509[] C_aligned={C_lihdr(0,0,16),40,97,49,57,51,53,51,32,100,105,118,32,114,101,109,41};
static C_char li510[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,102,108,111,111,114,47,32,120,32,121,41,0,0,0,0,0};
static C_char li511[] C_aligned={C_lihdr(0,0,8),40,97,49,57,52,48,50,41};
static C_char li512[] C_aligned={C_lihdr(0,0,16),40,97,49,57,52,48,56,32,100,105,118,32,114,101,109,41};
static C_char li513[] C_aligned={C_lihdr(0,0,28),40,115,99,104,101,109,101,35,102,108,111,111,114,45,114,101,109,97,105,110,100,101,114,32,120,32,121,41,0,0,0,0};
static C_char li514[] C_aligned={C_lihdr(0,0,8),40,97,49,57,52,49,55,41};
static C_char li515[] C_aligned={C_lihdr(0,0,16),40,97,49,57,52,50,51,32,100,105,118,32,114,101,109,41};
static C_char li516[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,102,108,111,111,114,45,113,117,111,116,105,101,110,116,32,120,32,121,41,0,0,0,0,0};
static C_char li517[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,115,113,117,97,114,101,32,110,41,0,0,0,0,0,0,0};
static C_char li518[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,120,97,99,116,45,105,110,116,101,103,101,114,45,110,116,104,45,114,111,111,116,32,107,32,110,41,0,0,0,0,0,0,0};
static C_char li519[] C_aligned={C_lihdr(0,0,10),40,108,112,32,103,48,32,103,49,41,0,0,0,0,0,0};
static C_char li520[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,101,120,97,99,116,45,105,110,116,101,103,101,114,45,110,116,104,45,114,111,111,116,47,108,111,99,32,108,111,99,32,107,32,110,41,0,0,0,0,0,0};
static C_char li521[] C_aligned={C_lihdr(0,0,11),40,108,112,32,114,101,115,32,101,50,41,0,0,0,0,0};
static C_char li522[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,105,110,116,101,103,101,114,45,112,111,119,101,114,32,98,97,115,101,32,101,41,0,0,0,0};
static C_char li523[] C_aligned={C_lihdr(0,0,14),40,108,111,103,45,101,120,112,116,32,97,32,98,41,0,0};
static C_char li524[] C_aligned={C_lihdr(0,0,15),40,115,108,111,119,45,101,120,112,116,32,97,32,98,41,0};
static C_char li525[] C_aligned={C_lihdr(0,0,8),40,97,49,57,55,53,50,41};
static C_char li526[] C_aligned={C_lihdr(0,0,15),40,97,49,57,55,54,52,32,100,115,94,110,32,114,41,0};
static C_char li527[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,101,120,112,116,32,97,32,98,41,0,0,0,0,0,0,0};
static C_char li528[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,105,110,116,101,114,110,97,108,45,103,99,100,32,108,111,99,32,97,32,98,41,0,0,0,0};
static C_char li529[] C_aligned={C_lihdr(0,0,15),40,35,35,115,121,115,35,103,99,100,32,97,32,98,41,0};
static C_char li530[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,104,101,97,100,32,110,101,120,116,41};
static C_char li531[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,103,99,100,32,46,32,110,115,41,0,0,0,0,0,0,0};
static C_char li532[] C_aligned={C_lihdr(0,0,15),40,35,35,115,121,115,35,108,99,109,32,120,32,121,41,0};
static C_char li533[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,104,101,97,100,32,110,101,120,116,41};
static C_char li534[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,108,99,109,32,46,32,110,115,41,0,0,0,0,0,0,0};
static C_char li535[] C_aligned={C_lihdr(0,0,34),67,95,117,95,105,110,116,101,103,101,114,95,113,117,111,116,105,101,110,116,95,97,110,100,95,114,101,109,97,105,110,100,101,114,0,0,0,0,0,0};
static C_char li536[] C_aligned={C_lihdr(0,0,8),40,97,50,48,49,49,50,41};
static C_char li537[] C_aligned={C_lihdr(0,0,22),40,97,50,48,49,49,56,32,104,105,51,52,53,51,32,108,111,51,52,53,53,41,0,0};
static C_char li538[] C_aligned={C_lihdr(0,0,61),40,35,35,115,121,115,35,105,110,116,101,103,101,114,45,62,115,116,114,105,110,103,47,114,101,99,117,114,115,105,118,101,32,110,32,98,97,115,101,32,101,120,112,101,99,116,101,100,45,115,116,114,105,110,103,45,115,105,122,101,41,0,0,0};
static C_char li539[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,101,120,116,101,110,100,101,100,45,110,117,109,98,101,114,45,62,115,116,114,105,110,103,32,110,32,98,97,115,101,41,0,0};
static C_char li540[] C_aligned={C_lihdr(0,0,20),40,114,111,117,110,100,45,113,117,111,116,105,101,110,116,32,110,32,100,41,0,0,0,0};
static C_char li541[] C_aligned={C_lihdr(0,0,13),40,103,111,45,105,110,101,120,97,99,116,33,41,0,0,0};
static C_char li542[] C_aligned={C_lihdr(0,0,23),40,115,97,102,101,45,101,120,112,111,110,101,110,116,32,118,97,108,117,101,32,101,41,0};
static C_char li543[] C_aligned={C_lihdr(0,0,6),40,108,112,32,105,41,0,0};
static C_char li544[] C_aligned={C_lihdr(0,0,19),40,115,99,97,110,45,100,105,103,105,116,115,32,115,116,97,114,116,41,0,0,0,0,0};
static C_char li545[] C_aligned={C_lihdr(0,0,6),40,108,112,32,105,41,0,0};
static C_char li546[] C_aligned={C_lihdr(0,0,19),40,115,99,97,110,45,104,97,115,104,101,115,32,115,116,97,114,116,41,0,0,0,0,0};
static C_char li547[] C_aligned={C_lihdr(0,0,46),40,115,99,97,110,45,100,105,103,105,116,115,43,104,97,115,104,101,115,32,115,116,97,114,116,32,110,101,103,63,32,97,108,108,45,104,97,115,104,101,115,45,111,107,63,41,0,0};
static C_char li548[] C_aligned={C_lihdr(0,0,21),40,115,99,97,110,45,101,120,112,111,110,101,110,116,32,115,116,97,114,116,41,0,0,0};
static C_char li549[] C_aligned={C_lihdr(0,0,43),40,115,99,97,110,45,100,101,99,105,109,97,108,45,116,97,105,108,32,115,116,97,114,116,32,110,101,103,63,32,100,101,99,105,109,97,108,45,104,101,97,100,41,0,0,0,0,0};
static C_char li550[] C_aligned={C_lihdr(0,0,23),40,115,99,97,110,45,117,114,101,97,108,32,115,116,97,114,116,32,110,101,103,63,41,0};
static C_char li551[] C_aligned={C_lihdr(0,0,17),40,115,99,97,110,45,114,101,97,108,32,115,116,97,114,116,41,0,0,0,0,0,0,0};
static C_char li552[] C_aligned={C_lihdr(0,0,50),40,35,35,115,121,115,35,115,116,114,105,110,103,45,62,99,111,109,112,110,117,109,32,114,97,100,105,120,32,115,116,114,32,111,102,102,115,101,116,32,101,120,97,99,116,110,101,115,115,41,0,0,0,0,0,0};
static C_char li553[] C_aligned={C_lihdr(0,0,32),40,115,99,97,110,45,112,114,101,102,105,120,32,105,32,101,120,110,101,115,115,32,114,97,100,105,120,32,108,101,110,41};
static C_char li554[] C_aligned={C_lihdr(0,0,34),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,62,110,117,109,98,101,114,32,115,116,114,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char li555[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,115,116,114,105,110,103,45,62,110,117,109,98,101,114,32,115,116,114,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char li556[] C_aligned={C_lihdr(0,0,18),67,95,102,105,120,110,117,109,95,116,111,95,115,116,114,105,110,103,0,0,0,0,0,0};
static C_char li557[] C_aligned={C_lihdr(0,0,18),67,95,102,108,111,110,117,109,95,116,111,95,115,116,114,105,110,103,0,0,0,0,0,0};
static C_char li558[] C_aligned={C_lihdr(0,0,19),67,95,105,110,116,101,103,101,114,95,116,111,95,115,116,114,105,110,103,0,0,0,0,0};
static C_char li559[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li560[] C_aligned={C_lihdr(0,0,25),40,99,111,109,112,97,114,101,45,115,108,111,116,115,32,120,32,121,32,115,116,97,114,116,41,0,0,0,0,0,0,0};
static C_char li561[] C_aligned={C_lihdr(0,0,10),40,119,97,108,107,32,120,32,121,41,0,0,0,0,0,0};
static C_char li562[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,113,117,97,108,61,63,32,120,32,121,41,0,0,0,0,0,0};
static C_char li563[] C_aligned={C_lihdr(0,0,18),67,95,115,116,114,105,110,103,95,116,111,95,115,121,109,98,111,108,0,0,0,0,0,0};
static C_char li564[] C_aligned={C_lihdr(0,0,19),67,95,115,116,114,105,110,103,95,116,111,95,107,101,121,119,111,114,100,0,0,0,0,0};
static C_char li565[] C_aligned={C_lihdr(0,0,13),67,95,109,97,107,101,95,115,121,109,98,111,108,0,0,0};
static C_char li566[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,105,110,116,101,114,110,101,100,45,115,121,109,98,111,108,63,32,120,41,0,0,0,0,0,0};
static C_char li567[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,115,116,114,105,110,103,45,62,115,121,109,98,111,108,45,110,97,109,101,32,115,41,0,0,0};
static C_char li568[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,115,121,109,98,111,108,45,62,115,116,114,105,110,103,47,115,104,97,114,101,100,32,115,41,0};
static C_char li569[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,115,121,109,98,111,108,45,62,115,116,114,105,110,103,32,115,41};
static C_char li570[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,115,116,114,105,110,103,45,62,115,121,109,98,111,108,32,115,116,114,41,0,0,0,0,0,0};
static C_char li571[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,115,121,109,98,111,108,45,62,115,116,114,105,110,103,32,115,41,0,0,0,0,0,0,0};
static C_char li572[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,62,115,121,109,98,111,108,32,115,116,114,41,0,0,0,0,0};
static C_char li573[] C_aligned={C_lihdr(0,0,44),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,116,114,105,110,103,45,62,117,110,105,110,116,101,114,110,101,100,45,115,121,109,98,111,108,32,115,116,114,41,0,0,0,0};
static C_char li574[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,97,115,101,35,103,101,110,115,121,109,32,46,32,115,116,114,45,111,114,45,115,121,109,41,0,0,0,0,0,0};
static C_char li575[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,52,48,49,50,32,103,52,48,50,52,41,0,0,0,0};
static C_char li576[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,121,109,98,111,108,45,97,112,112,101,110,100,32,46,32,115,115,41,0,0,0,0,0,0,0};
static C_char li577[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,107,101,121,119,111,114,100,35,107,101,121,119,111,114,100,63,32,120,41,0,0,0,0};
static C_char li578[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,107,101,121,119,111,114,100,35,115,116,114,105,110,103,45,62,107,101,121,119,111,114,100,32,115,41,0,0,0,0,0};
static C_char li579[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,107,101,121,119,111,114,100,35,107,101,121,119,111,114,100,45,62,115,116,114,105,110,103,32,107,119,41,0,0,0,0};
static C_char li580[] C_aligned={C_lihdr(0,0,45),40,99,104,105,99,107,101,110,46,107,101,121,119,111,114,100,35,103,101,116,45,107,101,121,119,111,114,100,32,107,101,121,32,97,114,103,115,32,46,32,114,101,115,116,41,0,0,0};
static C_char li581[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,105,32,108,115,116,41,0,0,0,0};
static C_char li582[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,98,121,116,101,118,101,99,116,111,114,45,62,108,105,115,116,32,118,41,0,0,0,0,0,0};
static C_char li583[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,108,115,116,32,105,41,0,0,0,0};
static C_char li584[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,108,105,115,116,45,62,98,121,116,101,118,101,99,116,111,114,32,108,115,116,48,41,0,0,0};
static C_char li585[] C_aligned={C_lihdr(0,0,48),40,99,104,105,99,107,101,110,46,98,121,116,101,118,101,99,116,111,114,35,109,97,107,101,45,98,121,116,101,118,101,99,116,111,114,32,115,105,122,101,32,46,32,114,101,115,116,41};
static C_char li586[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,121,116,101,118,101,99,116,111,114,35,98,121,116,101,118,101,99,116,111,114,63,32,120,41,0,0,0,0,0,0};
static C_char li587[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,98,121,116,101,118,101,99,116,111,114,35,98,121,116,101,118,101,99,116,111,114,45,108,101,110,103,116,104,32,98,118,41,0,0,0,0,0,0,0};
static C_char li588[] C_aligned={C_lihdr(0,0,43),40,99,104,105,99,107,101,110,46,98,121,116,101,118,101,99,116,111,114,35,98,121,116,101,118,101,99,116,111,114,45,117,56,45,114,101,102,32,98,118,32,105,41,0,0,0,0,0};
static C_char li589[] C_aligned={C_lihdr(0,0,46),40,99,104,105,99,107,101,110,46,98,121,116,101,118,101,99,116,111,114,35,98,121,116,101,118,101,99,116,111,114,45,117,56,45,115,101,116,33,32,98,118,32,105,32,98,41,0,0};
static C_char li590[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,98,121,116,101,118,101,99,116,111,114,35,115,116,114,105,110,103,45,62,117,116,102,56,32,115,41,0,0,0,0,0};
static C_char li591[] C_aligned={C_lihdr(0,0,43),40,99,104,105,99,107,101,110,46,98,121,116,101,118,101,99,116,111,114,35,117,116,102,56,45,62,115,116,114,105,110,103,32,98,118,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li592[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,98,121,116,101,118,101,99,116,111,114,35,115,116,114,105,110,103,45,62,108,97,116,105,110,49,32,115,41,0,0,0};
static C_char li593[] C_aligned={C_lihdr(0,0,38),40,99,104,105,99,107,101,110,46,98,121,116,101,118,101,99,116,111,114,35,108,97,116,105,110,49,45,62,115,116,114,105,110,103,32,98,118,41,0,0};
static C_char li594[] C_aligned={C_lihdr(0,0,39),40,99,104,105,99,107,101,110,46,98,121,116,101,118,101,99,116,111,114,35,98,121,116,101,118,101,99,116,111,114,61,63,32,98,49,32,98,50,41,0};
static C_char li595[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li596[] C_aligned={C_lihdr(0,0,38),40,99,104,105,99,107,101,110,46,98,121,116,101,118,101,99,116,111,114,35,98,121,116,101,118,101,99,116,111,114,32,46,32,97,114,103,115,41,0,0};
static C_char li597[] C_aligned={C_lihdr(0,0,46),40,99,104,105,99,107,101,110,46,98,121,116,101,118,101,99,116,111,114,35,98,121,116,101,118,101,99,116,111,114,45,99,111,112,121,32,98,118,32,46,32,114,101,115,116,41,0,0};
static C_char li598[] C_aligned={C_lihdr(0,0,55),40,99,104,105,99,107,101,110,46,98,121,116,101,118,101,99,116,111,114,35,98,121,116,101,118,101,99,116,111,114,45,99,111,112,121,33,32,98,118,49,32,97,116,32,98,118,50,32,46,32,114,101,115,116,41,0};
static C_char li599[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li600[] C_aligned={C_lihdr(0,0,14),40,108,111,111,112,32,108,115,116,32,108,101,110,41,0,0};
static C_char li601[] C_aligned={C_lihdr(0,0,44),40,99,104,105,99,107,101,110,46,98,121,116,101,118,101,99,116,111,114,35,98,121,116,101,118,101,99,116,111,114,45,97,112,112,101,110,100,32,46,32,98,118,115,41,0,0,0,0};
static C_char li602[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,109,97,107,101,45,118,101,99,116,111,114,32,115,105,122,101,32,46,32,102,105,108,108,41};
static C_char li603[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li604[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,108,105,115,116,45,62,118,101,99,116,111,114,32,108,115,116,48,41,0,0,0,0,0,0};
static C_char li605[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li606[] C_aligned={C_lihdr(0,0,30),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,62,108,105,115,116,32,118,32,46,32,114,101,115,116,41,0,0};
static C_char li607[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,118,101,99,116,111,114,32,46,32,120,115,41,0,0,0,0};
static C_char li608[] C_aligned={C_lihdr(0,0,12),40,100,111,108,111,111,112,52,51,53,48,41,0,0,0,0};
static C_char li609[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,102,105,108,108,33,32,118,32,120,32,46,32,114,101,115,116,41};
static C_char li610[] C_aligned={C_lihdr(0,0,15),40,100,111,108,111,111,112,52,51,56,49,32,102,105,41,0};
static C_char li611[] C_aligned={C_lihdr(0,0,18),40,99,111,112,121,32,118,32,115,116,97,114,116,32,101,110,100,41,0,0,0,0,0,0};
static C_char li612[] C_aligned={C_lihdr(0,0,29),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,99,111,112,121,32,118,32,46,32,114,101,115,116,41,0,0,0};
static C_char li613[] C_aligned={C_lihdr(0,0,15),40,100,111,108,111,111,112,52,52,50,50,32,116,105,41,0};
static C_char li614[] C_aligned={C_lihdr(0,0,15),40,100,111,108,111,111,112,52,52,50,56,32,116,105,41,0};
static C_char li615[] C_aligned={C_lihdr(0,0,28),40,99,111,112,121,33,32,116,111,32,97,116,32,102,114,111,109,32,115,116,97,114,116,32,101,110,100,41,0,0,0,0};
static C_char li616[] C_aligned={C_lihdr(0,0,39),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,99,111,112,121,33,32,116,111,32,97,116,32,102,114,111,109,32,46,32,114,101,115,116,41,0};
static C_char li617[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,52,52,52,55,41,0,0,0,0,0};
static C_char li618[] C_aligned={C_lihdr(0,0,22),40,100,111,108,111,111,112,52,53,49,52,32,118,115,32,108,101,110,115,32,105,41,0,0};
static C_char li619[] C_aligned={C_lihdr(0,0,17),40,102,111,108,100,108,52,53,48,52,32,103,52,53,48,51,41,0,0,0,0,0,0,0};
static C_char li620[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,52,52,55,51,32,103,52,52,56,53,41,0,0,0,0};
static C_char li621[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,97,112,112,101,110,100,32,46,32,118,115,41,0,0,0,0,0};
static C_char li622[] C_aligned={C_lihdr(0,0,12),40,100,111,108,111,111,112,52,53,52,49,41,0,0,0,0};
static C_char li623[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,117,98,118,101,99,116,111,114,32,118,32,105,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li624[] C_aligned={C_lihdr(0,0,39),40,99,104,105,99,107,101,110,46,98,97,115,101,35,118,101,99,116,111,114,45,114,101,115,105,122,101,32,118,32,110,32,46,32,114,101,115,116,41,0};
static C_char li625[] C_aligned={C_lihdr(0,0,12),40,100,111,108,111,111,112,52,53,54,57,41,0,0,0,0};
static C_char li626[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,118,101,99,116,111,114,45,114,101,115,105,122,101,32,118,32,110,32,105,110,105,116,41,0,0};
static C_char li627[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,99,32,99,115,32,102,41,0,0,0};
static C_char li628[] C_aligned={C_lihdr(0,0,29),40,115,99,104,101,109,101,35,99,104,97,114,45,99,105,61,63,32,120,32,121,32,46,32,109,111,114,101,41,0,0,0};
static C_char li629[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,99,32,99,115,32,102,41,0,0,0};
static C_char li630[] C_aligned={C_lihdr(0,0,29),40,115,99,104,101,109,101,35,99,104,97,114,45,99,105,62,63,32,120,32,121,32,46,32,109,111,114,101,41,0,0,0};
static C_char li631[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,99,32,99,115,32,102,41,0,0,0};
static C_char li632[] C_aligned={C_lihdr(0,0,29),40,115,99,104,101,109,101,35,99,104,97,114,45,99,105,60,63,32,120,32,121,32,46,32,109,111,114,101,41,0,0,0};
static C_char li633[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,99,32,99,115,32,102,41,0,0,0};
static C_char li634[] C_aligned={C_lihdr(0,0,30),40,115,99,104,101,109,101,35,99,104,97,114,45,99,105,62,61,63,32,120,32,121,32,46,32,109,111,114,101,41,0,0};
static C_char li635[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,99,32,99,115,32,102,41,0,0,0};
static C_char li636[] C_aligned={C_lihdr(0,0,30),40,115,99,104,101,109,101,35,99,104,97,114,45,99,105,60,61,63,32,120,32,121,32,46,32,109,111,114,101,41,0,0};
static C_char li637[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char li638[] C_aligned={C_lihdr(0,0,15),40,108,111,111,107,117,112,45,99,104,97,114,32,99,41,0};
static C_char li639[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,104,97,114,45,110,97,109,101,32,120,32,46,32,121,41,0,0};
static C_char li640[] C_aligned={C_lihdr(0,0,9),67,95,99,97,108,108,95,99,99,0,0,0,0,0,0,0};
static C_char li641[] C_aligned={C_lihdr(0,0,19),67,95,99,97,108,108,95,119,105,116,104,95,99,116,104,117,108,104,117,0,0,0,0,0};
static C_char li642[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char li643[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,102,111,114,45,101,97,99,104,32,112,32,108,115,116,48,41,0};
static C_char li644[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char li645[] C_aligned={C_lihdr(0,0,18),40,35,35,115,121,115,35,109,97,112,32,112,32,108,115,116,48,41,0,0,0,0,0,0};
static C_char li646[] C_aligned={C_lihdr(0,0,9),40,108,112,32,108,115,116,115,41,0,0,0,0,0,0,0};
static C_char li647[] C_aligned={C_lihdr(0,0,14),40,97,50,52,50,56,54,32,101,109,112,116,121,41,0,0};
static C_char li648[] C_aligned={C_lihdr(0,0,24),40,109,97,112,115,97,102,101,52,55,49,53,32,112,32,108,115,116,115,32,108,111,99,41};
static C_char li649[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,52,55,51,53,32,103,52,55,52,50,41,0,0,0,0,0,0,0};
static C_char li650[] C_aligned={C_lihdr(0,0,10),40,97,50,52,52,48,56,32,120,41,0,0,0,0,0,0};
static C_char li651[] C_aligned={C_lihdr(0,0,10),40,97,50,52,52,49,52,32,120,41,0,0,0,0,0,0};
static C_char li652[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,97,108,108,41,0,0,0,0,0,0};
static C_char li653[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,102,111,114,45,101,97,99,104,32,102,110,32,108,115,116,49,32,46,32,108,115,116,115,41};
static C_char li654[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,52,55,54,51,32,103,52,55,55,53,41,0,0,0,0};
static C_char li655[] C_aligned={C_lihdr(0,0,10),40,97,50,52,53,48,57,32,120,41,0,0,0,0,0,0};
static C_char li656[] C_aligned={C_lihdr(0,0,10),40,97,50,52,53,49,53,32,120,41,0,0,0,0,0,0};
static C_char li657[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,97,108,108,41,0,0,0,0,0,0};
static C_char li658[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,109,97,112,32,102,110,32,108,115,116,49,32,46,32,108,115,116,115,41,0,0,0,0,0};
static C_char li659[] C_aligned={C_lihdr(0,0,18),40,97,50,52,53,51,53,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0};
static C_char li660[] C_aligned={C_lihdr(0,0,40),40,115,99,104,101,109,101,35,100,121,110,97,109,105,99,45,119,105,110,100,32,98,101,102,111,114,101,32,116,104,117,110,107,32,97,102,116,101,114,41};
static C_char li661[] C_aligned={C_lihdr(0,0,24),40,99,111,110,116,105,110,117,97,116,105,111,110,32,46,32,114,101,115,117,108,116,115,41};
static C_char li662[] C_aligned={C_lihdr(0,0,13),40,97,50,52,53,53,57,32,99,111,110,116,41,0,0,0};
static C_char li663[] C_aligned={C_lihdr(0,0,44),40,115,99,104,101,109,101,35,99,97,108,108,45,119,105,116,104,45,99,117,114,114,101,110,116,45,99,111,110,116,105,110,117,97,116,105,111,110,32,112,114,111,99,41,0,0,0,0};
static C_char li664[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,100,121,110,97,109,105,99,45,117,110,119,105,110,100,32,119,105,110,100,115,32,110,41,0,0};
static C_char li665[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,111,114,116,45,99,108,111,115,101,100,63,32,112,41,0,0,0};
static C_char li666[] C_aligned={C_lihdr(0,0,37),40,35,35,115,121,115,35,109,97,107,101,45,112,111,114,116,32,105,47,111,32,99,108,97,115,115,32,110,97,109,101,32,116,121,112,101,41,0,0,0};
static C_char li667[] C_aligned={C_lihdr(0,0,22),40,97,52,49,55,51,52,32,98,117,102,32,115,116,97,114,116,32,108,101,110,41,0,0};
static C_char li668[] C_aligned={C_lihdr(0,0,26),40,97,52,49,55,50,56,32,98,117,102,32,115,116,97,114,116,32,108,101,110,32,100,101,99,41,0,0,0,0,0,0};
static C_char li669[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char li670[] C_aligned={C_lihdr(0,0,10),40,97,52,49,54,54,48,32,112,41,0,0,0,0,0,0};
static C_char li671[] C_aligned={C_lihdr(0,0,20),40,97,52,49,55,55,49,32,98,117,102,32,115,116,97,114,116,32,95,41,0,0,0,0};
static C_char li672[] C_aligned={C_lihdr(0,0,26),40,97,52,49,55,53,57,32,98,117,102,32,115,116,97,114,116,32,108,101,110,32,100,101,99,41,0,0,0,0,0,0};
static C_char li673[] C_aligned={C_lihdr(0,0,10),40,97,52,49,55,52,49,32,112,41,0,0,0,0,0,0};
static C_char li674[] C_aligned={C_lihdr(0,0,12),40,97,52,49,55,55,52,32,112,32,99,41,0,0,0,0};
static C_char li675[] C_aligned={C_lihdr(0,0,21),40,97,52,49,56,49,54,32,98,118,32,115,116,97,114,116,32,108,101,110,41,0,0,0};
static C_char li676[] C_aligned={C_lihdr(0,0,21),40,97,52,49,56,48,50,32,112,32,98,118,32,102,114,111,109,32,116,111,41,0,0,0};
static C_char li677[] C_aligned={C_lihdr(0,0,12),40,97,52,49,56,49,57,32,112,32,100,41,0,0,0,0};
static C_char li678[] C_aligned={C_lihdr(0,0,10),40,97,52,49,56,50,53,32,112,41,0,0,0,0,0,0};
static C_char li679[] C_aligned={C_lihdr(0,0,10),40,97,52,49,56,50,56,32,112,41,0,0,0,0,0,0};
static C_char li680[] C_aligned={C_lihdr(0,0,8),40,97,52,49,56,55,52,41};
static C_char li681[] C_aligned={C_lihdr(0,0,20),40,108,111,111,112,32,114,101,109,32,97,99,116,32,115,116,97,114,116,41,0,0,0,0};
static C_char li682[] C_aligned={C_lihdr(0,0,23),40,97,52,49,56,51,49,32,112,32,110,32,100,101,115,116,32,115,116,97,114,116,41,0};
static C_char li683[] C_aligned={C_lihdr(0,0,8),40,97,52,50,48,51,57,41};
static C_char li684[] C_aligned={C_lihdr(0,0,32),40,108,111,111,112,32,108,101,110,32,108,105,109,105,116,32,98,117,102,102,101,114,32,114,101,115,117,108,116,32,102,41};
static C_char li685[] C_aligned={C_lihdr(0,0,17),40,97,52,49,57,51,56,32,112,32,114,108,105,109,105,116,41,0,0,0,0,0,0,0};
static C_char li686[] C_aligned={C_lihdr(0,0,16),67,95,111,112,101,110,95,102,105,108,101,95,112,111,114,116};
static C_char li687[] C_aligned={C_lihdr(0,0,37),40,35,35,115,121,115,35,99,104,101,99,107,45,105,110,112,117,116,45,112,111,114,116,32,120,32,111,112,101,110,32,46,32,108,111,99,41,0,0,0};
static C_char li688[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,99,104,101,99,107,45,111,117,116,112,117,116,45,112,111,114,116,32,120,32,111,112,101,110,32,46,32,108,111,99,41,0,0};
static C_char li689[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,112,111,114,116,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char li690[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,99,104,101,99,107,45,111,112,101,110,45,112,111,114,116,32,120,32,46,32,108,111,99,41,0};
static C_char li691[] C_aligned={C_lihdr(0,0,10),40,98,111,100,121,52,57,55,55,41,0,0,0,0,0,0};
static C_char li692[] C_aligned={C_lihdr(0,0,34),40,115,99,104,101,109,101,35,99,117,114,114,101,110,116,45,105,110,112,117,116,45,112,111,114,116,32,46,32,97,114,103,115,41,0,0,0,0,0,0};
static C_char li693[] C_aligned={C_lihdr(0,0,10),40,98,111,100,121,53,48,48,50,41,0,0,0,0,0,0};
static C_char li694[] C_aligned={C_lihdr(0,0,35),40,115,99,104,101,109,101,35,99,117,114,114,101,110,116,45,111,117,116,112,117,116,45,112,111,114,116,32,46,32,97,114,103,115,41,0,0,0,0,0};
static C_char li695[] C_aligned={C_lihdr(0,0,10),40,98,111,100,121,53,48,50,55,41,0,0,0,0,0,0};
static C_char li696[] C_aligned={C_lihdr(0,0,40),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,117,114,114,101,110,116,45,101,114,114,111,114,45,112,111,114,116,32,46,32,97,114,103,115,41};
static C_char li697[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,116,116,121,45,112,111,114,116,63,32,112,111,114,116,41,0,0};
static C_char li698[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,112,111,114,116,45,100,97,116,97,32,112,111,114,116,41,0,0};
static C_char li699[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,115,101,116,45,112,111,114,116,45,100,97,116,97,33,32,112,111,114,116,32,100,97,116,97,41};
static C_char li700[] C_aligned={C_lihdr(0,0,18),40,100,111,108,111,111,112,53,48,54,54,32,109,111,100,101,115,41,0,0,0,0,0,0};
static C_char li701[] C_aligned={C_lihdr(0,0,25),40,111,112,101,110,32,110,97,109,101,32,105,110,112,32,109,111,100,101,115,32,108,111,99,41,0,0,0,0,0,0,0};
static C_char li702[] C_aligned={C_lihdr(0,0,20),40,99,108,111,115,101,32,112,111,114,116,32,105,110,112,32,108,111,99,41,0,0,0,0};
static C_char li703[] C_aligned={C_lihdr(0,0,36),40,115,99,104,101,109,101,35,111,112,101,110,45,105,110,112,117,116,45,102,105,108,101,32,110,97,109,101,32,46,32,109,111,100,101,41,0,0,0,0};
static C_char li704[] C_aligned={C_lihdr(0,0,37),40,115,99,104,101,109,101,35,111,112,101,110,45,111,117,116,112,117,116,45,102,105,108,101,32,110,97,109,101,32,46,32,109,111,100,101,41,0,0,0};
static C_char li705[] C_aligned={C_lihdr(0,0,30),40,115,99,104,101,109,101,35,99,108,111,115,101,45,105,110,112,117,116,45,112,111,114,116,32,112,111,114,116,41,0,0};
static C_char li706[] C_aligned={C_lihdr(0,0,31),40,115,99,104,101,109,101,35,99,108,111,115,101,45,111,117,116,112,117,116,45,112,111,114,116,32,112,111,114,116,41,0};
static C_char li707[] C_aligned={C_lihdr(0,0,8),40,97,50,53,50,56,51,41};
static C_char li708[] C_aligned={C_lihdr(0,0,18),40,97,50,53,50,56,57,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0};
static C_char li709[] C_aligned={C_lihdr(0,0,43),40,115,99,104,101,109,101,35,99,97,108,108,45,119,105,116,104,45,105,110,112,117,116,45,102,105,108,101,32,110,97,109,101,32,112,32,46,32,109,111,100,101,41,0,0,0,0,0};
static C_char li710[] C_aligned={C_lihdr(0,0,8),40,97,50,53,51,48,55,41};
static C_char li711[] C_aligned={C_lihdr(0,0,18),40,97,50,53,51,49,51,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0};
static C_char li712[] C_aligned={C_lihdr(0,0,44),40,115,99,104,101,109,101,35,99,97,108,108,45,119,105,116,104,45,111,117,116,112,117,116,45,102,105,108,101,32,110,97,109,101,32,112,32,46,32,109,111,100,101,41,0,0,0,0};
static C_char li713[] C_aligned={C_lihdr(0,0,8),40,97,50,53,51,51,49,41};
static C_char li714[] C_aligned={C_lihdr(0,0,18),40,97,50,53,51,52,50,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0};
static C_char li715[] C_aligned={C_lihdr(0,0,8),40,97,50,53,51,51,54,41};
static C_char li716[] C_aligned={C_lihdr(0,0,8),40,97,50,53,51,53,49,41};
static C_char li717[] C_aligned={C_lihdr(0,0,46),40,115,99,104,101,109,101,35,119,105,116,104,45,105,110,112,117,116,45,102,114,111,109,45,102,105,108,101,32,115,116,114,32,116,104,117,110,107,32,46,32,109,111,100,101,41,0,0};
static C_char li718[] C_aligned={C_lihdr(0,0,8),40,97,50,53,51,54,53,41};
static C_char li719[] C_aligned={C_lihdr(0,0,18),40,97,50,53,51,55,54,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0};
static C_char li720[] C_aligned={C_lihdr(0,0,8),40,97,50,53,51,55,48,41};
static C_char li721[] C_aligned={C_lihdr(0,0,8),40,97,50,53,51,56,53,41};
static C_char li722[] C_aligned={C_lihdr(0,0,45),40,115,99,104,101,109,101,35,119,105,116,104,45,111,117,116,112,117,116,45,116,111,45,102,105,108,101,32,115,116,114,32,116,104,117,110,107,32,46,32,109,111,100,101,41,0,0,0};
static C_char li723[] C_aligned={C_lihdr(0,0,40),40,35,35,115,121,115,35,102,105,108,101,45,101,120,105,115,116,115,63,32,110,97,109,101,32,102,105,108,101,63,32,100,105,114,63,32,108,111,99,41};
static C_char li724[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,102,108,117,115,104,45,111,117,116,112,117,116,32,112,111,114,116,41,0,0,0,0,0,0,0};
static C_char li725[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,108,117,115,104,45,111,117,116,112,117,116,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char li726[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,112,111,114,116,45,108,105,110,101,32,112,111,114,116,41,0,0};
static C_char li727[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,53,50,51,48,32,105,41,0,0};
static C_char li728[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li729[] C_aligned={C_lihdr(0,0,43),40,35,35,115,121,115,35,100,101,99,111,114,97,116,101,45,108,97,109,98,100,97,32,112,114,111,99,32,112,114,101,100,32,100,101,99,111,114,97,116,111,114,41,0,0,0,0,0};
static C_char li730[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li731[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,108,97,109,98,100,97,45,100,101,99,111,114,97,116,105,111,110,32,112,114,111,99,32,112,114,101,100,41,0,0,0,0,0};
static C_char li732[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,109,97,107,101,45,108,97,109,98,100,97,45,105,110,102,111,32,115,116,114,41,0,0,0,0};
static C_char li733[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,108,97,109,98,100,97,45,105,110,102,111,63,32,120,41,0,0};
static C_char li734[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,108,97,109,98,100,97,45,105,110,102,111,32,112,114,111,99,41};
static C_char li735[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,108,97,109,98,100,97,45,105,110,102,111,45,62,115,116,114,105,110,103,32,105,110,102,111,41};
static C_char li736[] C_aligned={C_lihdr(0,0,38),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,114,111,99,101,100,117,114,101,45,105,110,102,111,114,109,97,116,105,111,110,32,120,41,0,0};
static C_char li737[] C_aligned={C_lihdr(0,0,12),40,97,50,53,54,55,53,32,112,32,105,41,0,0,0,0};
static C_char li738[] C_aligned={C_lihdr(0,0,10),40,97,50,53,54,56,53,32,120,41,0,0,0,0,0,0};
static C_char li739[] C_aligned={C_lihdr(0,0,15),40,97,50,53,55,48,49,32,112,114,111,99,32,105,41,0};
static C_char li740[] C_aligned={C_lihdr(0,0,48),40,99,104,105,99,107,101,110,46,98,97,115,101,35,103,101,116,116,101,114,45,119,105,116,104,45,115,101,116,116,101,114,32,103,101,116,32,115,101,116,32,46,32,114,101,115,116,41};
static C_char li741[] C_aligned={C_lihdr(0,0,11),40,102,95,50,53,57,54,50,32,120,41,0,0,0,0,0};
static C_char li742[] C_aligned={C_lihdr(0,0,28),40,97,115,115,105,103,110,32,118,97,108,32,110,32,99,111,110,118,101,114,116,63,32,115,101,116,63,41,0,0,0,0};
static C_char li743[] C_aligned={C_lihdr(0,0,24),40,98,111,100,121,53,51,56,50,32,99,111,110,118,101,114,116,63,32,115,101,116,63,41};
static C_char li744[] C_aligned={C_lihdr(0,0,24),40,100,101,102,45,115,101,116,63,53,51,56,53,32,37,99,111,110,118,101,114,116,63,41};
static C_char li745[] C_aligned={C_lihdr(0,0,18),40,100,101,102,45,99,111,110,118,101,114,116,63,53,51,56,52,41,0,0,0,0,0,0};
static C_char li746[] C_aligned={C_lihdr(0,0,15),40,97,50,53,56,53,51,32,46,32,97,114,103,115,41,0};
static C_char li747[] C_aligned={C_lihdr(0,0,12),40,97,50,53,57,51,53,32,118,97,108,41,0,0,0,0};
static C_char li748[] C_aligned={C_lihdr(0,0,35),40,115,99,104,101,109,101,35,109,97,107,101,45,112,97,114,97,109,101,116,101,114,32,105,110,105,116,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li749[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,99,104,97,114,45,114,101,97,100,121,63,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li750[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,114,101,97,100,45,99,104,97,114,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char li751[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,114,101,97,100,45,99,104,97,114,45,48,32,112,41,0,0,0};
static C_char li752[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,114,101,97,100,45,99,104,97,114,47,112,111,114,116,32,112,111,114,116,41,0,0,0,0,0};
static C_char li753[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,112,101,101,107,45,99,104,97,114,45,48,32,112,41,0,0,0};
static C_char li754[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,112,101,101,107,45,99,104,97,114,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char li755[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,114,101,97,100,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char li756[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,114,101,97,100,45,112,114,111,109,112,116,45,104,111,111,107,41};
static C_char li757[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,105,110,102,105,120,45,108,105,115,116,45,104,111,111,107,32,108,115,116,41,0,0,0,0,0};
static C_char li758[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,115,104,97,114,112,45,110,117,109,98,101,114,45,104,111,111,107,32,112,111,114,116,32,110,41};
static C_char li759[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,114,101,97,100,45,119,97,114,110,105,110,103,32,112,111,114,116,32,109,115,103,32,46,32,97,114,103,115,41,0,0,0,0};
static C_char li760[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,114,101,97,100,45,101,114,114,111,114,32,112,111,114,116,32,109,115,103,32,46,32,97,114,103,115,41,0,0,0,0,0,0};
static C_char li761[] C_aligned={C_lihdr(0,0,11),40,102,95,50,54,50,52,51,32,99,41,0,0,0,0,0};
static C_char li762[] C_aligned={C_lihdr(0,0,21),40,105,110,102,111,32,99,108,97,115,115,32,100,97,116,97,32,118,97,108,41,0,0,0};
static C_char li763[] C_aligned={C_lihdr(0,0,8),40,115,107,105,112,32,99,41};
static C_char li764[] C_aligned={C_lihdr(0,0,13),40,115,107,105,112,45,116,111,45,101,111,108,41,0,0,0};
static C_char li765[] C_aligned={C_lihdr(0,0,22),40,114,101,115,101,114,118,101,100,45,99,104,97,114,97,99,116,101,114,32,99,41,0,0};
static C_char li766[] C_aligned={C_lihdr(0,0,29),40,114,101,97,100,45,117,110,114,101,115,101,114,118,101,100,45,99,104,97,114,45,48,32,112,111,114,116,41,0,0,0};
static C_char li767[] C_aligned={C_lihdr(0,0,24),40,114,101,103,105,115,116,101,114,45,115,104,97,114,101,100,33,32,116,104,117,110,107,41};
static C_char li768[] C_aligned={C_lihdr(0,0,16),40,117,110,116,104,117,110,107,32,111,32,102,97,105,108,41};
static C_char li769[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,53,53,53,56,32,105,41,0,0};
static C_char li770[] C_aligned={C_lihdr(0,0,9),40,108,111,111,112,33,32,111,41,0,0,0,0,0,0,0};
static C_char li771[] C_aligned={C_lihdr(0,0,20),40,117,110,116,104,117,110,107,105,102,121,33,32,111,32,102,97,105,108,41,0,0,0,0};
static C_char li772[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,99,41};
static C_char li773[] C_aligned={C_lihdr(0,0,10),40,114,45,115,112,97,99,101,115,41,0,0,0,0,0,0};
static C_char li774[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,115,101,113,32,110,41,0,0,0,0};
static C_char li775[] C_aligned={C_lihdr(0,0,22),40,114,45,117,115,101,113,117,101,110,99,101,32,117,32,110,32,98,97,115,101,41,0,0};
static C_char li776[] C_aligned={C_lihdr(0,0,11),40,112,97,114,115,101,32,115,101,113,41,0,0,0,0,0};
static C_char li777[] C_aligned={C_lihdr(0,0,7),40,97,98,111,114,116,41,0};
static C_char li778[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,115,101,113,41,0,0,0,0,0,0};
static C_char li779[] C_aligned={C_lihdr(0,0,19),40,114,45,120,115,101,113,117,101,110,99,101,32,100,101,108,105,109,41,0,0,0,0,0};
static C_char li780[] C_aligned={C_lihdr(0,0,14),40,101,97,116,45,119,115,32,99,32,110,108,63,41,0,0};
static C_char li781[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,99,32,108,115,116,41,0,0,0,0};
static C_char li782[] C_aligned={C_lihdr(0,0,15),40,114,45,115,116,114,105,110,103,32,116,101,114,109,41,0};
static C_char li783[] C_aligned={C_lihdr(0,0,19),40,115,116,97,114,116,105,110,103,45,108,105,110,101,32,109,115,103,41,0,0,0,0,0};
static C_char li784[] C_aligned={C_lihdr(0,0,11),40,102,95,50,55,50,55,48,32,99,41,0,0,0,0,0};
static C_char li785[] C_aligned={C_lihdr(0,0,15),40,97,50,55,51,56,53,32,116,111,107,32,107,119,41,0};
static C_char li786[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,108,97,115,116,41,0,0,0,0,0};
static C_char li787[] C_aligned={C_lihdr(0,0,15),40,97,50,55,50,54,54,32,114,101,116,117,114,110,41,0};
static C_char li788[] C_aligned={C_lihdr(0,0,18),40,114,45,108,105,115,116,32,115,116,97,114,116,32,101,110,100,41,0,0,0,0,0,0};
static C_char li789[] C_aligned={C_lihdr(0,0,10),40,114,45,118,101,99,116,111,114,41,0,0,0,0,0,0};
static C_char li790[] C_aligned={C_lihdr(0,0,15),40,97,50,55,53,49,50,32,116,111,107,32,107,119,41,0};
static C_char li791[] C_aligned={C_lihdr(0,0,26),40,114,45,110,117,109,98,101,114,32,114,97,100,105,120,32,101,120,97,99,116,110,101,115,115,41,0,0,0,0,0,0};
static C_char li792[] C_aligned={C_lihdr(0,0,31),40,114,45,110,117,109,98,101,114,45,119,105,116,104,45,101,120,97,99,116,110,101,115,115,32,114,97,100,105,120,41,0};
static C_char li793[] C_aligned={C_lihdr(0,0,31),40,114,45,110,117,109,98,101,114,45,119,105,116,104,45,114,97,100,105,120,32,101,120,97,99,116,110,101,115,115,41,0};
static C_char li794[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,99,32,108,115,116,41,0,0,0,0};
static C_char li795[] C_aligned={C_lihdr(0,0,9),40,114,45,116,111,107,101,110,41,0,0,0,0,0,0,0};
static C_char li796[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,99,32,108,115,116,41,0,0,0,0};
static C_char li797[] C_aligned={C_lihdr(0,0,10),40,114,45,100,105,103,105,116,115,41,0,0,0,0,0,0};
static C_char li798[] C_aligned={C_lihdr(0,0,15),40,97,50,55,56,48,54,32,115,116,114,32,107,119,41,0};
static C_char li799[] C_aligned={C_lihdr(0,0,10),40,114,45,115,121,109,98,111,108,41,0,0,0,0,0,0};
static C_char li800[] C_aligned={C_lihdr(0,0,18),40,108,111,111,112,32,108,115,116,32,115,107,119,32,113,116,100,41,0,0,0,0,0,0};
static C_char li801[] C_aligned={C_lihdr(0,0,12),40,114,45,120,116,111,107,101,110,32,107,41,0,0,0,0};
static C_char li802[] C_aligned={C_lihdr(0,0,8),40,114,45,99,104,97,114,41};
static C_char li803[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li804[] C_aligned={C_lihdr(0,0,11),40,114,45,99,111,109,109,101,110,116,41,0,0,0,0,0};
static C_char li805[] C_aligned={C_lihdr(0,0,14),40,114,45,101,120,116,45,115,121,109,98,111,108,41,0,0};
static C_char li806[] C_aligned={C_lihdr(0,0,11),40,114,45,113,117,111,116,101,32,113,41,0,0,0,0,0};
static C_char li807[] C_aligned={C_lihdr(0,0,8),40,97,50,56,52,52,53,41};
static C_char li808[] C_aligned={C_lihdr(0,0,13),40,97,50,56,52,53,49,32,46,32,120,115,41,0,0,0};
static C_char li809[] C_aligned={C_lihdr(0,0,8),40,97,50,56,53,55,57,41};
static C_char li810[] C_aligned={C_lihdr(0,0,8),40,97,50,56,54,49,56,41};
static C_char li811[] C_aligned={C_lihdr(0,0,13),40,97,50,56,54,50,52,32,46,32,120,115,41,0,0,0};
static C_char li812[] C_aligned={C_lihdr(0,0,9),40,103,53,57,57,57,32,104,41,0,0,0,0,0,0,0};
static C_char li813[] C_aligned={C_lihdr(0,0,8),40,97,50,56,54,57,50,41};
static C_char li814[] C_aligned={C_lihdr(0,0,13),40,97,50,56,54,57,56,32,46,32,120,115,41,0,0,0};
static C_char li815[] C_aligned={C_lihdr(0,0,8),40,97,50,56,56,57,48,41};
static C_char li816[] C_aligned={C_lihdr(0,0,15),40,97,50,56,57,48,49,32,115,116,114,32,107,119,41,0};
static C_char li817[] C_aligned={C_lihdr(0,0,8),40,97,50,56,56,57,53,41};
static C_char li818[] C_aligned={C_lihdr(0,0,8),40,97,50,56,57,51,48,41};
static C_char li819[] C_aligned={C_lihdr(0,0,8),40,97,50,57,48,55,50,41};
static C_char li820[] C_aligned={C_lihdr(0,0,13),40,97,50,57,48,55,56,32,46,32,120,115,41,0,0,0};
static C_char li821[] C_aligned={C_lihdr(0,0,9),40,114,101,97,100,114,101,99,41,0,0,0,0,0,0,0};
static C_char li822[] C_aligned={C_lihdr(0,0,12),40,97,50,57,51,50,54,32,46,32,97,41,0,0,0,0};
static C_char li823[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,114,101,97,100,32,112,111,114,116,32,105,110,102,111,104,97,110,100,108,101,114,41,0,0,0};
static C_char li824[] C_aligned={C_lihdr(0,0,11),40,102,97,105,108,32,105,116,101,109,41,0,0,0,0,0};
static C_char li825[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,117,115,101,114,45,114,101,97,100,45,104,111,111,107,32,99,104,97,114,32,112,111,114,116,41};
static C_char li826[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,114,101,97,100,45,110,117,109,118,101,99,116,111,114,45,100,97,116,97,32,112,111,114,116,41};
static C_char li827[] C_aligned={C_lihdr(0,0,15),40,108,111,111,112,50,32,110,115,32,112,114,101,118,41,0};
static C_char li828[] C_aligned={C_lihdr(0,0,9),40,114,101,116,114,121,32,120,41,0,0,0,0,0,0,0};
static C_char li829[] C_aligned={C_lihdr(0,0,15),40,108,111,111,112,32,108,115,116,32,112,114,101,118,41,0};
static C_char li830[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,99,97,110,111,110,105,99,97,108,105,122,101,45,110,117,109,98,101,114,45,108,105,115,116,33,32,108,115,116,49,41,0,0};
static C_char li831[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,119,114,105,116,101,45,99,104,97,114,45,48,32,99,32,112,41};
static C_char li832[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,119,114,105,116,101,45,99,104,97,114,47,112,111,114,116,32,99,32,112,111,114,116,41,0,0};
static C_char li833[] C_aligned={C_lihdr(0,0,28),40,115,99,104,101,109,101,35,119,114,105,116,101,45,99,104,97,114,32,99,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char li834[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,110,101,119,108,105,110,101,32,46,32,114,101,115,116,41,0};
static C_char li835[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,119,114,105,116,101,32,120,32,46,32,114,101,115,116,41,0};
static C_char li836[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,100,105,115,112,108,97,121,32,120,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char li837[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,54,50,54,49,32,103,54,50,54,56,41,0,0,0,0,0,0,0};
static C_char li838[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,114,105,110,116,32,46,32,97,114,103,115,41,0,0,0,0,0};
static C_char li839[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,54,50,57,51,32,103,54,51,48,48,41,0,0,0,0,0,0,0};
static C_char li840[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,114,105,110,116,42,32,46,32,97,114,103,115,41,0,0,0,0};
static C_char li841[] C_aligned={C_lihdr(0,0,17),40,111,117,116,115,116,114,32,112,111,114,116,32,115,116,114,41,0,0,0,0,0,0,0};
static C_char li842[] C_aligned={C_lihdr(0,0,18),40,111,117,116,115,116,114,48,32,112,111,114,116,32,115,116,114,41,0,0,0,0,0,0};
static C_char li843[] C_aligned={C_lihdr(0,0,17),40,111,117,116,99,104,114,32,112,111,114,116,32,99,104,114,41,0,0,0,0,0,0,0};
static C_char li844[] C_aligned={C_lihdr(0,0,17),40,111,117,116,115,121,109,32,112,111,114,116,32,115,121,109,41,0,0,0,0,0,0,0};
static C_char li845[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li846[] C_aligned={C_lihdr(0,0,25),40,111,117,116,114,101,97,100,97,98,108,101,115,121,109,32,112,111,114,116,32,115,116,114,41,0,0,0,0,0,0,0};
static C_char li847[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li848[] C_aligned={C_lihdr(0,0,22),40,115,121,109,45,105,115,45,114,101,97,100,97,98,108,101,63,32,115,116,114,41,0,0};
static C_char li849[] C_aligned={C_lihdr(0,0,10),40,103,54,52,54,51,32,99,110,41,0,0,0,0,0,0};
static C_char li850[] C_aligned={C_lihdr(0,0,16),40,100,111,108,111,111,112,54,52,56,52,32,105,32,99,41};
static C_char li851[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,54,53,49,53,32,120,41,0,0};
static C_char li852[] C_aligned={C_lihdr(0,0,16),40,100,111,108,111,111,112,54,53,52,52,32,105,32,99,41};
static C_char li853[] C_aligned={C_lihdr(0,0,7),40,111,117,116,32,120,41,0};
static C_char li854[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,112,114,105,110,116,32,120,32,114,101,97,100,97,98,108,101,32,112,111,114,116,41,0,0,0};
static C_char li855[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,112,114,111,99,101,100,117,114,101,45,62,115,116,114,105,110,103,32,120,41,0,0,0,0,0};
static C_char li856[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,97,115,101,35,114,101,99,111,114,100,45,112,114,105,110,116,101,114,32,116,121,112,101,41,0,0,0,0,0,0};
static C_char li857[] C_aligned={C_lihdr(0,0,44),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,101,116,45,114,101,99,111,114,100,45,112,114,105,110,116,101,114,33,32,116,121,112,101,32,112,114,111,99,41,0,0,0,0};
static C_char li858[] C_aligned={C_lihdr(0,0,8),40,97,51,49,48,54,52,41};
static C_char li859[] C_aligned={C_lihdr(0,0,11),40,97,51,49,48,53,56,32,101,120,41,0,0,0,0,0};
static C_char li860[] C_aligned={C_lihdr(0,0,8),40,97,51,49,49,49,49,41};
static C_char li861[] C_aligned={C_lihdr(0,0,8),40,97,51,49,49,50,54,41};
static C_char li862[] C_aligned={C_lihdr(0,0,15),40,97,51,49,49,50,48,32,46,32,97,114,103,115,41,0};
static C_char li863[] C_aligned={C_lihdr(0,0,8),40,97,51,49,49,48,53,41};
static C_char li864[] C_aligned={C_lihdr(0,0,10),40,97,51,49,48,53,50,32,107,41,0,0,0,0,0,0};
static C_char li865[] C_aligned={C_lihdr(0,0,39),40,35,35,115,121,115,35,117,115,101,114,45,112,114,105,110,116,45,104,111,111,107,32,120,32,114,101,97,100,97,98,108,101,32,112,111,114,116,41,0};
static C_char li866[] C_aligned={C_lihdr(0,0,8),40,97,51,49,49,57,53,41};
static C_char li867[] C_aligned={C_lihdr(0,0,8),40,97,51,49,50,51,56,41};
static C_char li868[] C_aligned={C_lihdr(0,0,8),40,97,51,49,50,52,52,41};
static C_char li869[] C_aligned={C_lihdr(0,0,15),40,97,51,49,49,56,57,32,114,101,116,117,114,110,41,0};
static C_char li870[] C_aligned={C_lihdr(0,0,43),40,35,35,115,121,115,35,119,105,116,104,45,112,114,105,110,116,45,108,101,110,103,116,104,45,108,105,109,105,116,32,108,105,109,105,116,32,116,104,117,110,107,41,0,0,0,0,0};
static C_char li871[] C_aligned={C_lihdr(0,0,15),40,99,104,101,99,107,54,54,54,51,32,112,32,110,41,0};
static C_char li872[] C_aligned={C_lihdr(0,0,10),40,97,52,49,49,54,50,32,112,41,0,0,0,0,0,0};
static C_char li873[] C_aligned={C_lihdr(0,0,10),40,97,52,49,49,56,52,32,112,41,0,0,0,0,0,0};
static C_char li874[] C_aligned={C_lihdr(0,0,12),40,97,52,49,50,48,50,32,112,32,99,41,0,0,0,0};
static C_char li875[] C_aligned={C_lihdr(0,0,21),40,97,52,49,50,49,56,32,112,32,98,118,32,102,114,111,109,32,116,111,41,0,0,0};
static C_char li876[] C_aligned={C_lihdr(0,0,10),40,97,52,49,50,52,48,32,112,41,0,0,0,0,0,0};
static C_char li877[] C_aligned={C_lihdr(0,0,10),40,97,52,49,50,52,51,32,112,41,0,0,0,0,0,0};
static C_char li878[] C_aligned={C_lihdr(0,0,23),40,97,52,49,50,52,54,32,112,32,110,32,100,101,115,116,32,115,116,97,114,116,41,0};
static C_char li879[] C_aligned={C_lihdr(0,0,12),40,97,52,49,51,49,54,32,112,111,115,41,0,0,0,0};
static C_char li880[] C_aligned={C_lihdr(0,0,8),40,97,52,49,51,48,54,41};
static C_char li881[] C_aligned={C_lihdr(0,0,29),40,97,52,49,51,50,53,32,110,101,120,116,32,108,105,110,101,32,102,117,108,108,45,108,105,110,101,63,41,0,0,0};
static C_char li882[] C_aligned={C_lihdr(0,0,16),40,97,52,49,50,56,50,32,112,32,108,105,109,105,116,41};
static C_char li883[] C_aligned={C_lihdr(0,0,10),40,97,52,49,51,54,54,32,112,41,0,0,0,0,0,0};
static C_char li884[] C_aligned={C_lihdr(0,0,6),40,103,114,111,119,41,0,0};
static C_char li885[] C_aligned={C_lihdr(0,0,18),40,99,111,110,99,32,98,117,102,32,102,114,111,109,32,116,111,41,0,0,0,0,0,0};
static C_char li886[] C_aligned={C_lihdr(0,0,9),40,99,111,110,99,49,32,98,41,0,0,0,0,0,0,0};
static C_char li887[] C_aligned={C_lihdr(0,0,9),40,103,101,116,108,105,110,101,41,0,0,0,0,0,0,0};
static C_char li888[] C_aligned={C_lihdr(0,0,8),40,97,51,49,52,49,52,41};
static C_char li889[] C_aligned={C_lihdr(0,0,25),40,97,51,49,52,50,48,32,98,117,102,32,111,102,102,115,101,116,32,108,105,109,105,116,41,0,0,0,0,0,0,0};
static C_char li890[] C_aligned={C_lihdr(0,0,8),40,97,51,49,52,56,56,41};
static C_char li891[] C_aligned={C_lihdr(0,0,25),40,97,51,49,52,57,52,32,98,117,102,32,111,102,102,115,101,116,32,108,105,109,105,116,41,0,0,0,0,0,0,0};
static C_char li892[] C_aligned={C_lihdr(0,0,27),40,108,111,111,112,32,98,117,102,32,111,102,102,115,101,116,32,112,111,115,32,108,105,109,105,116,41,0,0,0,0,0};
static C_char li893[] C_aligned={C_lihdr(0,0,63),40,35,35,115,121,115,35,115,99,97,110,45,98,117,102,102,101,114,45,108,105,110,101,32,98,117,102,32,108,105,109,105,116,32,115,116,97,114,116,45,112,111,115,32,101,111,115,45,104,97,110,100,108,101,114,32,46,32,114,101,115,116,41,0};
static C_char li894[] C_aligned={C_lihdr(0,0,9),40,103,54,56,49,54,32,120,41,0,0,0,0,0,0,0};
static C_char li895[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,54,56,49,53,32,103,54,56,50,50,41,0,0,0,0,0,0,0};
static C_char li896[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,112,114,105,110,116,45,116,111,45,115,116,114,105,110,103,32,120,115,41,0,0,0,0,0,0};
static C_char li897[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,112,111,105,110,116,101,114,45,62,115,116,114,105,110,103,32,120,41,0,0,0,0,0,0,0};
static C_char li898[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li899[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,98,97,115,101,35,103,101,116,45,99,97,108,108,45,99,104,97,105,110,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char li900[] C_aligned={C_lihdr(0,0,8),40,97,51,49,56,56,57,41};
static C_char li901[] C_aligned={C_lihdr(0,0,12),40,103,54,56,56,53,32,105,110,102,111,41,0,0,0,0};
static C_char li902[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,54,56,56,52,32,103,54,56,57,49,41,0,0,0,0,0,0,0};
static C_char li903[] C_aligned={C_lihdr(0,0,49),40,35,35,115,121,115,35,114,101,97,108,108,121,45,112,114,105,110,116,45,99,97,108,108,45,99,104,97,105,110,32,112,111,114,116,32,99,104,97,105,110,32,104,101,97,100,101,114,41,0,0,0,0,0,0,0};
static C_char li904[] C_aligned={C_lihdr(0,0,38),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,114,105,110,116,45,99,97,108,108,45,99,104,97,105,110,32,46,32,114,101,115,116,41,0,0};
static C_char li905[] C_aligned={C_lihdr(0,0,7),40,98,114,101,97,107,41,0};
static C_char li906[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,117,115,101,114,45,105,110,116,101,114,114,117,112,116,45,104,111,111,107,41,0,0,0,0,0};
static C_char li907[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,54,57,52,52,32,103,54,57,53,49,41,0,0,0,0,0,0,0};
static C_char li908[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char li909[] C_aligned={C_lihdr(0,0,21),40,99,108,101,97,110,117,112,45,98,101,102,111,114,101,45,101,120,105,116,41,0,0,0};
static C_char li910[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,100,98,103,45,104,111,111,107,32,46,32,97,114,103,115,41,0};
static C_char li911[] C_aligned={C_lihdr(0,0,8),40,97,51,50,50,50,49,41};
static C_char li912[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,55,48,50,51,32,103,55,48,51,48,41,0,0,0,0,0,0,0};
static C_char li913[] C_aligned={C_lihdr(0,0,47),40,35,35,115,121,115,35,115,105,103,110,97,108,45,104,111,111,107,47,101,114,114,110,111,32,109,111,100,101,32,101,114,114,110,111,32,109,115,103,32,46,32,97,114,103,115,41,0};
static C_char li914[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,115,105,103,110,97,108,45,104,111,111,107,32,109,111,100,101,32,109,115,103,32,46,32,97,114,103,115,41,0,0,0,0,0};
static C_char li915[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,97,98,111,114,116,32,120,41,0,0,0,0,0};
static C_char li916[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,115,105,103,110,97,108,32,120,41,0,0,0,0};
static C_char li917[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,99,117,114,114,101,110,116,45,101,120,99,101,112,116,105,111,110,45,104,97,110,100,108,101,114,32,99,41,0,0,0,0,0};
static C_char li918[] C_aligned={C_lihdr(0,0,8),40,97,51,50,54,56,53,41};
static C_char li919[] C_aligned={C_lihdr(0,0,8),40,97,51,50,54,56,57,41};
static C_char li920[] C_aligned={C_lihdr(0,0,56),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,119,105,116,104,45,101,120,99,101,112,116,105,111,110,45,104,97,110,100,108,101,114,32,104,97,110,100,108,101,114,32,116,104,117,110,107,41};
static C_char li921[] C_aligned={C_lihdr(0,0,10),40,98,111,100,121,55,49,56,48,41,0,0,0,0,0,0};
static C_char li922[] C_aligned={C_lihdr(0,0,52),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,117,114,114,101,110,116,45,101,120,99,101,112,116,105,111,110,45,104,97,110,100,108,101,114,32,46,32,97,114,103,115,41,0,0,0,0};
static C_char li923[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,114,111,112,115,41,0,0,0,0};
static C_char li924[] C_aligned={C_lihdr(0,0,69),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,112,114,111,112,45,108,105,115,116,45,62,107,105,110,100,45,112,114,101,102,105,120,101,100,45,112,114,111,112,45,108,105,115,116,32,108,111,99,32,107,105,110,100,32,112,108,105,115,116,41,0,0,0};
static C_char li925[] C_aligned={C_lihdr(0,0,56),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,109,97,107,101,45,112,114,111,112,101,114,116,121,45,99,111,110,100,105,116,105,111,110,32,107,105,110,100,32,46,32,112,114,111,112,115,41};
static C_char li926[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,55,50,50,52,41,0,0,0,0,0};
static C_char li927[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,55,50,54,57,32,103,55,50,56,49,41,0,0,0,0};
static C_char li928[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,55,50,52,50,32,103,55,50,53,52,41,0,0,0,0};
static C_char li929[] C_aligned={C_lihdr(0,0,55),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,109,97,107,101,45,99,111,109,112,111,115,105,116,101,45,99,111,110,100,105,116,105,111,110,32,99,49,32,46,32,99,111,110,100,115,41,0};
static C_char li930[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,55,51,50,57,32,103,55,51,52,49,41,0,0,0,0};
static C_char li931[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,55,51,48,50,32,103,55,51,49,52,41,0,0,0,0};
static C_char li932[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,111,110,100,105,116,105,111,110,32,97,114,103,49,32,46,32,97,114,103,115,41,0,0,0,0,0,0,0};
static C_char li933[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,111,110,100,105,116,105,111,110,63,32,120,41};
static C_char li934[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,114,111,112,115,41,0,0,0,0};
static C_char li935[] C_aligned={C_lihdr(0,0,9),40,103,55,51,54,53,32,107,41,0,0,0,0,0,0,0};
static C_char li936[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,55,51,53,57,32,103,55,51,55,49,41,0,0,0,0};
static C_char li937[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,111,110,100,105,116,105,111,110,45,62,108,105,115,116,32,120,41,0,0,0};
static C_char li938[] C_aligned={C_lihdr(0,0,11),40,102,95,51,51,50,48,56,32,99,41,0,0,0,0,0};
static C_char li939[] C_aligned={C_lihdr(0,0,44),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,111,110,100,105,116,105,111,110,45,112,114,101,100,105,99,97,116,101,32,107,105,110,100,41,0,0,0,0};
static C_char li940[] C_aligned={C_lihdr(0,0,11),40,102,95,51,51,50,51,53,32,99,41,0,0,0,0,0};
static C_char li941[] C_aligned={C_lihdr(0,0,67),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,111,110,100,105,116,105,111,110,45,112,114,111,112,101,114,116,121,45,97,99,99,101,115,115,111,114,32,107,105,110,100,32,112,114,111,112,32,46,32,101,114,114,45,100,101,102,41,0,0,0,0,0};
static C_char li942[] C_aligned={C_lihdr(0,0,64),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,103,101,116,45,99,111,110,100,105,116,105,111,110,45,112,114,111,112,101,114,116,121,32,99,32,107,105,110,100,32,112,114,111,112,32,46,32,101,114,114,45,100,101,102,41};
static C_char li943[] C_aligned={C_lihdr(0,0,8),40,97,51,51,51,48,49,41};
static C_char li944[] C_aligned={C_lihdr(0,0,9),40,103,55,52,51,48,32,120,41,0,0,0,0,0,0,0};
static C_char li945[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,55,52,50,57,32,103,55,52,51,54,41,0,0,0,0,0,0,0};
static C_char li946[] C_aligned={C_lihdr(0,0,21),40,119,114,105,116,101,97,114,103,115,32,97,114,103,115,32,112,111,114,116,41,0,0,0};
static C_char li947[] C_aligned={C_lihdr(0,0,11),40,103,55,52,55,51,32,109,115,103,41,0,0,0,0,0};
static C_char li948[] C_aligned={C_lihdr(0,0,22),40,98,111,100,121,55,52,53,48,32,112,111,114,116,32,104,101,97,100,101,114,41,0,0};
static C_char li949[] C_aligned={C_lihdr(0,0,22),40,100,101,102,45,104,101,97,100,101,114,55,52,53,51,32,37,112,111,114,116,41,0,0};
static C_char li950[] C_aligned={C_lihdr(0,0,14),40,100,101,102,45,112,111,114,116,55,52,53,50,41,0,0};
static C_char li951[] C_aligned={C_lihdr(0,0,49),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,112,114,105,110,116,45,101,114,114,111,114,45,109,101,115,115,97,103,101,32,101,120,32,46,32,97,114,103,115,41,0,0,0,0,0,0,0};
static C_char li952[] C_aligned={C_lihdr(0,0,47),40,35,35,115,121,115,35,115,104,111,119,45,101,120,99,101,112,116,105,111,110,45,119,97,114,110,105,110,103,32,101,120,110,32,99,97,117,115,101,32,46,32,114,101,115,116,41,0};
static C_char li953[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,101,114,114,111,114,45,104,111,111,107,32,99,111,100,101,32,108,111,99,32,46,32,97,114,103,115,41,0,0,0,0,0,0};
static C_char li954[] C_aligned={C_lihdr(0,0,8),40,97,51,52,51,49,51,41};
static C_char li955[] C_aligned={C_lihdr(0,0,8),40,97,51,52,51,53,51,41};
static C_char li956[] C_aligned={C_lihdr(0,0,45),40,115,99,104,101,109,101,35,119,105,116,104,45,101,120,99,101,112,116,105,111,110,45,104,97,110,100,108,101,114,32,104,97,110,100,108,101,114,32,116,104,117,110,107,41,0,0,0};
static C_char li957[] C_aligned={C_lihdr(0,0,8),40,97,51,52,51,56,53,41};
static C_char li958[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,114,97,105,115,101,32,111,98,106,41,0,0,0,0,0,0};
static C_char li959[] C_aligned={C_lihdr(0,0,8),40,97,51,52,52,50,54,41};
static C_char li960[] C_aligned={C_lihdr(0,0,30),40,115,99,104,101,109,101,35,114,97,105,115,101,45,99,111,110,116,105,110,117,97,98,108,101,32,111,98,106,41,0,0};
static C_char li961[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,114,101,97,100,45,101,114,114,111,114,63,32,111,98,106,41};
static C_char li962[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,102,105,108,101,45,101,114,114,111,114,63,32,111,98,106,41};
static C_char li963[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,115,116,114,117,99,116,117,114,101,63,32,120,32,115,41,0,0};
static C_char li964[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,103,101,110,101,114,105,99,45,115,116,114,117,99,116,117,114,101,63,32,120,41,0,0,0,0};
static C_char li965[] C_aligned={C_lihdr(0,0,16),40,35,35,115,121,115,35,115,108,111,116,32,120,32,105,41};
static C_char li966[] C_aligned={C_lihdr(0,0,14),40,35,35,115,121,115,35,115,105,122,101,32,120,41,0,0};
static C_char li967[] C_aligned={C_lihdr(0,0,14),67,95,109,97,107,101,95,112,111,105,110,116,101,114,0,0};
static C_char li968[] C_aligned={C_lihdr(0,0,21),67,95,109,97,107,101,95,116,97,103,103,101,100,95,112,111,105,110,116,101,114,0,0,0};
static C_char li969[] C_aligned={C_lihdr(0,0,18),40,35,35,115,121,115,35,112,111,105,110,116,101,114,63,32,120,41,0,0,0,0,0,0};
static C_char li970[] C_aligned={C_lihdr(0,0,37),40,35,35,115,121,115,35,115,101,116,45,112,111,105,110,116,101,114,45,97,100,100,114,101,115,115,33,32,112,116,114,32,97,100,100,114,41,0,0,0};
static C_char li971[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,98,121,116,101,118,101,99,116,111,114,63,32,120,41,0,0,0};
static C_char li972[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,115,116,114,105,110,103,45,62,112,98,121,116,101,118,101,99,116,111,114,32,115,41,0,0,0};
static C_char li973[] C_aligned={C_lihdr(0,0,20),40,35,35,115,121,115,35,112,101,114,109,97,110,101,110,116,63,32,120,41,0,0,0,0};
static C_char li974[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,98,108,111,99,107,45,97,100,100,114,101,115,115,32,120,41,0};
static C_char li975[] C_aligned={C_lihdr(0,0,19),40,35,35,115,121,115,35,108,111,99,97,116,105,118,101,63,32,120,41,0,0,0,0,0};
static C_char li976[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,115,114,102,105,45,52,45,118,101,99,116,111,114,63,32,120,41};
static C_char li977[] C_aligned={C_lihdr(0,0,20),40,35,35,115,121,115,35,110,117,108,108,45,112,111,105,110,116,101,114,41,0,0,0,0};
static C_char li978[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,110,117,108,108,45,112,111,105,110,116,101,114,63,32,120,41,0};
static C_char li979[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,97,100,100,114,101,115,115,45,62,112,111,105,110,116,101,114,32,97,100,100,114,41,0,0,0};
static C_char li980[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,112,111,105,110,116,101,114,45,62,97,100,100,114,101,115,115,32,112,116,114,41,0,0,0,0};
static C_char li981[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,109,97,107,101,45,99,45,115,116,114,105,110,103,32,115,116,114,32,46,32,114,101,115,116,41};
static C_char li982[] C_aligned={C_lihdr(0,0,21),67,95,112,101,101,107,95,115,105,103,110,101,100,95,105,110,116,101,103,101,114,0,0,0};
static C_char li983[] C_aligned={C_lihdr(0,0,23),67,95,112,101,101,107,95,117,110,115,105,103,110,101,100,95,105,110,116,101,103,101,114,0};
static C_char li984[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,112,101,101,107,45,102,105,120,110,117,109,32,98,32,105,41,0};
static C_char li985[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,112,101,101,107,45,98,121,116,101,32,112,116,114,32,105,41,0};
static C_char li986[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,118,101,99,116,111,114,45,62,115,116,114,117,99,116,117,114,101,33,32,118,101,99,41,0,0};
static C_char li987[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,112,101,101,107,45,100,111,117,98,108,101,32,98,32,105,41,0};
static C_char li988[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,112,101,101,107,45,99,45,115,116,114,105,110,103,32,98,32,105,41,0,0,0,0,0,0,0};
static C_char li989[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,112,101,101,107,45,110,111,110,110,117,108,108,45,99,45,115,116,114,105,110,103,32,98,32,105,41,0,0,0,0,0,0,0};
static C_char li990[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,112,101,101,107,45,97,110,100,45,102,114,101,101,45,99,45,115,116,114,105,110,103,32,98,32,105,41,0,0,0,0,0,0};
static C_char li991[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,112,101,101,107,45,97,110,100,45,102,114,101,101,45,110,111,110,110,117,108,108,45,99,45,115,116,114,105,110,103,32,98,32,105,41,0,0,0,0,0,0};
static C_char li992[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,112,111,107,101,45,99,45,115,116,114,105,110,103,32,98,32,105,32,115,41,0,0,0,0,0};
static C_char li993[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,112,111,107,101,45,105,110,116,101,103,101,114,32,98,32,105,32,110,41,0,0,0,0,0,0};
static C_char li994[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,112,111,107,101,45,100,111,117,98,108,101,32,98,32,105,32,110,41,0,0,0,0,0,0,0};
static C_char li995[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li996[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,112,101,101,107,45,99,45,115,116,114,105,110,103,45,108,105,115,116,32,112,116,114,32,110,41};
static C_char li997[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li998[] C_aligned={C_lihdr(0,0,41),40,35,35,115,121,115,35,112,101,101,107,45,97,110,100,45,102,114,101,101,45,99,45,115,116,114,105,110,103,45,108,105,115,116,32,112,116,114,32,110,41,0,0,0,0,0,0,0};
static C_char li999[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,118,101,99,116,111,114,45,62,99,108,111,115,117,114,101,33,32,118,101,99,32,97,100,100,114,41,0,0,0,0,0,0,0};
static C_char li1000[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,115,121,109,98,111,108,45,104,97,115,45,116,111,112,108,101,118,101,108,45,98,105,110,100,105,110,103,63,32,115,41,0,0};
static C_char li1001[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,98,108,111,99,107,45,112,111,105,110,116,101,114,32,120,41,0};
static C_char li1002[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,99,104,97,114,45,97,114,103,117,109,101,110,116,32,120,41,0};
static C_char li1003[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,102,105,120,110,117,109,45,97,114,103,117,109,101,110,116,32,120,41,0,0,0,0,0,0,0};
static C_char li1004[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,102,108,111,110,117,109,45,97,114,103,117,109,101,110,116,32,120,41,0,0,0,0,0,0,0};
static C_char li1005[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,98,108,111,99,107,45,97,114,103,117,109,101,110,116,32,120,41};
static C_char li1006[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,99,112,108,120,110,117,109,45,97,114,103,117,109,101,110,116,32,120,41,0,0,0,0,0,0};
static C_char li1007[] C_aligned={C_lihdr(0,0,43),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,115,116,114,117,99,116,45,119,114,97,112,112,101,114,45,97,114,103,117,109,101,110,116,32,116,32,120,41,0,0,0,0,0};
static C_char li1008[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,115,116,114,105,110,103,45,97,114,103,117,109,101,110,116,32,120,41,0,0,0,0,0,0,0};
static C_char li1009[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,115,121,109,98,111,108,45,97,114,103,117,109,101,110,116,32,120,41,0,0,0,0,0,0,0};
static C_char li1010[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,112,111,105,110,116,101,114,45,97,114,103,117,109,101,110,116,32,120,41,0,0,0,0,0,0};
static C_char li1011[] C_aligned={C_lihdr(0,0,44),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,116,97,103,103,101,100,45,112,111,105,110,116,101,114,45,97,114,103,117,109,101,110,116,32,120,32,116,120,41,0,0,0,0};
static C_char li1012[] C_aligned={C_lihdr(0,0,48),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,114,97,110,103,101,100,45,105,110,116,101,103,101,114,45,97,114,103,117,109,101,110,116,32,111,98,106,32,115,105,122,101,41};
static C_char li1013[] C_aligned={C_lihdr(0,0,57),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,117,110,115,105,103,110,101,100,45,114,97,110,103,101,100,45,105,110,116,101,103,101,114,45,97,114,103,117,109,101,110,116,32,111,98,106,32,115,105,122,101,41,0,0,0,0,0,0,0};
static C_char li1014[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,119,114,97,112,45,115,116,114,117,99,116,32,116,121,112,101,32,114,101,99,41,0,0,0,0};
static C_char li1015[] C_aligned={C_lihdr(0,0,37),40,35,35,115,121,115,35,100,101,102,97,117,108,116,45,101,120,99,101,112,116,105,111,110,45,104,97,110,100,108,101,114,32,97,114,103,41,0,0,0};
static C_char li1016[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,109,97,107,101,45,116,104,114,101,97,100,32,116,104,117,110,107,32,115,116,97,116,101,32,110,97,109,101,32,113,41,0,0};
static C_char li1017[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,109,97,107,101,45,109,117,116,101,120,32,105,100,32,111,119,110,101,114,41,0,0,0,0,0};
static C_char li1018[] C_aligned={C_lihdr(0,0,16),40,35,35,115,121,115,35,115,99,104,101,100,117,108,101,41};
static C_char li1019[] C_aligned={C_lihdr(0,0,8),40,97,51,52,57,50,51,41};
static C_char li1020[] C_aligned={C_lihdr(0,0,15),40,97,51,52,57,49,52,32,114,101,116,117,114,110,41,0};
static C_char li1021[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,116,104,114,101,97,100,45,121,105,101,108,100,33,41,0,0,0};
static C_char li1022[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,107,105,108,108,45,111,116,104,101,114,45,116,104,114,101,97,100,115,32,116,104,117,110,107,41};
static C_char li1023[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,114,101,115,117,109,101,45,116,104,114,101,97,100,45,111,110,45,101,118,101,110,116,32,116,41};
static C_char li1024[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,115,117,115,112,101,110,100,45,116,104,114,101,97,100,45,111,110,45,101,118,101,110,116,32,116,41,0,0,0,0,0,0,0};
static C_char li1025[] C_aligned={C_lihdr(0,0,12),40,97,51,52,57,53,48,32,46,32,95,41,0,0,0,0};
static C_char li1026[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,115,108,101,101,112,45,117,110,116,105,108,45,105,110,116,101,114,114,117,112,116,41,0,0,0};
static C_char li1027[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,109,97,107,101,45,101,118,101,110,116,45,113,117,101,117,101,41};
static C_char li1028[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,97,100,100,45,101,118,101,110,116,45,116,111,45,113,117,101,117,101,33,32,113,32,101,41,0};
static C_char li1029[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,103,101,116,45,110,101,120,116,45,101,118,101,110,116,32,113,41};
static C_char li1030[] C_aligned={C_lihdr(0,0,7),40,97,103,97,105,110,41,0};
static C_char li1031[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,119,97,105,116,45,102,111,114,45,110,101,120,116,45,101,118,101,110,116,32,113,41,0,0,0};
static C_char li1032[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,108,101,101,112,45,104,111,111,107,32,110,41,0,0,0,0,0};
static C_char li1033[] C_aligned={C_lihdr(0,0,22),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,108,101,101,112,32,110,41,0,0};
static C_char li1034[] C_aligned={C_lihdr(0,0,16),67,95,99,111,110,116,101,120,116,95,115,119,105,116,99,104};
static C_char li1035[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,114,101,97,115,111,110,41,0,0,0};
static C_char li1036[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,105,110,116,101,114,114,117,112,116,45,104,111,111,107,32,114,101,97,115,111,110,32,115,116,97,116,101,41,0,0,0,0,0};
static C_char li1037[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,100,105,115,112,97,116,99,104,45,105,110,116,101,114,114,117,112,116,32,107,41,0,0,0,0};
static C_char li1038[] C_aligned={C_lihdr(0,0,20),40,35,35,115,121,115,35,117,112,100,97,116,101,45,101,114,114,110,111,41,0,0,0,0};
static C_char li1039[] C_aligned={C_lihdr(0,0,13),40,35,35,115,121,115,35,101,114,114,110,111,41,0,0,0};
static C_char li1040[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,55,57,50,53,32,99,41,0,0};
static C_char li1041[] C_aligned={C_lihdr(0,0,13),40,114,101,97,100,108,110,32,112,111,114,116,41,0,0,0};
static C_char li1042[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char li1043[] C_aligned={C_lihdr(0,0,36),40,114,101,97,100,45,101,115,99,97,112,101,100,45,115,101,120,112,32,112,111,114,116,32,115,107,105,112,45,98,114,97,99,101,63,41,0,0,0,0};
static C_char li1044[] C_aligned={C_lihdr(0,0,15),40,100,111,108,111,111,112,55,57,54,48,32,108,110,41,0};
static C_char li1045[] C_aligned={C_lihdr(0,0,15),40,103,101,116,47,99,108,101,97,114,45,115,116,114,41,0};
static C_char li1046[] C_aligned={C_lihdr(0,0,27),40,108,111,111,112,50,32,108,115,116,32,110,101,120,116,45,115,116,114,105,110,103,32,97,99,99,41,0,0,0,0,0};
static C_char li1047[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char li1048[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,117,115,101,114,45,114,101,97,100,45,104,111,111,107,32,99,104,97,114,32,112,111,114,116,41};
static C_char li1049[] C_aligned={C_lihdr(0,0,47),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,41,0};
static C_char li1050[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,45,104,111,111,107,32,100,105,114,41,0,0,0,0,0,0,0};
static C_char li1051[] C_aligned={C_lihdr(0,0,54),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,103,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,32,118,97,114,41,0,0};
static C_char li1052[] C_aligned={C_lihdr(0,0,59),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,115,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,33,32,118,97,114,32,118,97,108,41,0,0,0,0,0};
static C_char li1053[] C_aligned={C_lihdr(0,0,57),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,117,110,115,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,33,32,118,97,114,41,0,0,0,0,0,0,0};
static C_char li1054[] C_aligned={C_lihdr(0,0,8),40,115,99,97,110,32,106,41};
static C_char li1055[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li1056[] C_aligned={C_lihdr(0,0,51),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,103,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,115,41,0,0,0,0,0};
static C_char li1057[] C_aligned={C_lihdr(0,0,45),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,101,120,101,99,117,116,97,98,108,101,45,112,97,116,104,110,97,109,101,41,0,0,0};
static C_char li1058[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,97,114,103,99,43,97,114,103,118,41,0,0,0,0,0};
static C_char li1059[] C_aligned={C_lihdr(0,0,16),40,100,111,108,111,111,112,56,49,50,56,32,105,32,118,41};
static C_char li1060[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,97,114,103,118,41,0,0};
static C_char li1061[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,103,99,35,99,117,114,114,101,110,116,45,103,99,45,109,105,108,108,105,115,101,99,111,110,100,115,41,0,0,0,0};
static C_char li1062[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,103,99,35,115,101,116,45,103,99,45,114,101,112,111,114,116,33,32,102,108,97,103,41};
static C_char li1063[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,103,99,35,109,101,109,111,114,121,45,115,116,97,116,105,115,116,105,99,115,41,0,0};
static C_char li1064[] C_aligned={C_lihdr(0,0,20),67,95,114,101,103,105,115,116,101,114,95,102,105,110,97,108,105,122,101,114,0,0,0,0};
static C_char li1065[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,105,110,105,116,45,102,105,110,97,108,105,122,101,114,32,120,32,121,41,0,0,0,0,0,0};
static C_char li1066[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,103,99,35,102,105,110,97,108,105,122,101,114,63,32,120,41,0,0,0,0,0,0,0};
static C_char li1067[] C_aligned={C_lihdr(0,0,11),40,104,97,110,100,108,101,114,32,111,41,0,0,0,0,0};
static C_char li1068[] C_aligned={C_lihdr(0,0,10),40,104,97,110,100,108,101,32,111,41,0,0,0,0,0,0};
static C_char li1069[] C_aligned={C_lihdr(0,0,15),40,97,51,54,48,56,55,32,46,32,114,101,115,116,41,0};
static C_char li1070[] C_aligned={C_lihdr(0,0,15),40,97,51,54,49,48,56,32,112,114,111,99,32,105,41,0};
static C_char li1071[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,56,50,49,53,32,103,56,50,50,50,41,0,0,0,0,0,0,0};
static C_char li1072[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,103,99,35,109,97,107,101,45,102,105,110,97,108,105,122,101,114,32,46,32,111,98,106,101,99,116,115,41,0,0,0};
static C_char li1073[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,56,50,53,55,32,103,56,50,54,52,41,0,0,0,0,0,0,0};
static C_char li1074[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,103,99,35,97,100,100,45,116,111,45,102,105,110,97,108,105,122,101,114,32,102,32,46,32,111,98,106,101,99,116,115,41,0,0,0,0,0,0,0};
static C_char li1075[] C_aligned={C_lihdr(0,0,8),40,97,51,54,50,55,50,41};
static C_char li1076[] C_aligned={C_lihdr(0,0,11),40,97,51,54,50,54,54,32,101,120,41,0,0,0,0,0};
static C_char li1077[] C_aligned={C_lihdr(0,0,8),40,97,51,54,50,56,52,41};
static C_char li1078[] C_aligned={C_lihdr(0,0,8),40,97,51,54,51,48,55,41};
static C_char li1079[] C_aligned={C_lihdr(0,0,15),40,97,51,54,51,48,49,32,46,32,97,114,103,115,41,0};
static C_char li1080[] C_aligned={C_lihdr(0,0,8),40,97,51,54,50,55,56,41};
static C_char li1081[] C_aligned={C_lihdr(0,0,10),40,97,51,54,50,54,48,32,107,41,0,0,0,0,0,0};
static C_char li1082[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,56,50,56,57,32,105,41,0,0};
static C_char li1083[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,114,117,110,45,112,101,110,100,105,110,103,45,102,105,110,97,108,105,122,101,114,115,32,115,116,97,116,101,41,0,0,0,0};
static C_char li1084[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char li1085[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,102,111,114,99,101,45,102,105,110,97,108,105,122,101,114,115,41};
static C_char li1086[] C_aligned={C_lihdr(0,0,21),40,99,104,105,99,107,101,110,46,103,99,35,103,99,32,46,32,97,114,103,41,0,0,0};
static C_char li1087[] C_aligned={C_lihdr(0,0,41),40,35,35,115,121,115,35,109,97,107,101,45,108,111,99,97,116,105,118,101,32,111,98,106,32,105,110,100,101,120,32,119,101,97,107,63,32,108,111,99,41,0,0,0,0,0,0,0};
static C_char li1088[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,112,108,105,115,116,35,112,117,116,33,32,115,121,109,32,112,114,111,112,32,118,97,108,41,0,0,0,0,0,0,0};
static C_char li1089[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,112,108,105,115,116,35,103,101,116,32,115,121,109,32,112,114,111,112,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li1090[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,112,116,108,41,0,0,0,0,0,0};
static C_char li1091[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,112,108,105,115,116,35,114,101,109,112,114,111,112,33,32,115,121,109,32,112,114,111,112,41,0,0,0,0,0,0,0};
static C_char li1092[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,108,105,115,116,41,0,0,0,0};
static C_char li1093[] C_aligned={C_lihdr(0,0,40),40,99,104,105,99,107,101,110,46,112,108,105,115,116,35,103,101,116,45,112,114,111,112,101,114,116,105,101,115,32,115,121,109,32,112,114,111,112,115,41};
static C_char li1094[] C_aligned={C_lihdr(0,0,10),40,112,110,117,109,32,110,117,109,41,0,0,0,0,0,0};
static C_char li1095[] C_aligned={C_lihdr(0,0,14),40,114,111,117,110,100,45,116,111,32,120,32,121,41,0,0};
static C_char li1096[] C_aligned={C_lihdr(0,0,12),40,112,109,101,109,32,98,121,116,101,115,41,0,0,0,0};
static C_char li1097[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,100,105,115,112,108,97,121,45,116,105,109,101,115,32,105,110,102,111,41,0,0,0,0,0,0};
static C_char li1098[] C_aligned={C_lihdr(0,0,17),67,95,100,117,109,112,95,104,101,97,112,95,115,116,97,116,101,0,0,0,0,0,0,0};
static C_char li1099[] C_aligned={C_lihdr(0,0,21),67,95,102,105,108,116,101,114,95,104,101,97,112,95,111,98,106,101,99,116,115,0,0,0};
static C_char li1100[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,115,111,102,116,119,97,114,101,45,116,121,112,101,41};
static C_char li1101[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,109,97,99,104,105,110,101,45,116,121,112,101,41,0};
static C_char li1102[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,109,97,99,104,105,110,101,45,98,121,116,101,45,111,114,100,101,114,41,0,0,0};
static C_char li1103[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,115,111,102,116,119,97,114,101,45,118,101,114,115,105,111,110,41,0,0,0,0,0};
static C_char li1104[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,98,117,105,108,100,45,112,108,97,116,102,111,114,109,41,0,0,0,0,0,0,0};
static C_char li1105[] C_aligned={C_lihdr(0,0,7),40,115,116,114,32,120,41,0};
static C_char li1106[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,99,104,105,99,107,101,110,45,118,101,114,115,105,111,110,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char li1107[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,99,104,105,99,107,101,110,45,104,111,109,101,41,0};
static C_char li1108[] C_aligned={C_lihdr(0,0,38),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,105,110,99,108,117,100,101,45,112,97,116,104,32,46,32,114,101,115,116,41,0,0};
static C_char li1109[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,115,116,97,114,116,32,112,111,115,41};
static C_char li1110[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,115,112,108,105,116,45,112,97,116,104,32,112,97,116,104,41,0};
static C_char li1111[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,99,104,111,112,45,115,101,112,97,114,97,116,111,114,32,115,116,114,41,0,0,0};
static C_char li1112[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,105,110,99,108,117,100,101,45,112,97,116,104,41,0};
static C_char li1113[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,45,62,102,101,97,116,117,114,101,45,105,100,32,120,41,0,0,0,0,0,0,0};
static C_char li1114[] C_aligned={C_lihdr(0,0,9),40,99,104,101,99,107,32,102,41,0,0,0,0,0,0,0};
static C_char li1115[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,56,55,54,50,32,103,56,55,54,57,41,0,0,0,0,0,0,0};
static C_char li1116[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,114,101,103,105,115,116,101,114,45,102,101,97,116,117,114,101,33,32,46,32,102,115,41,0,0,0,0,0,0,0};
static C_char li1117[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,102,102,115,41,0,0,0,0,0,0};
static C_char li1118[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,56,55,56,53,32,103,56,55,57,55,41,0,0,0,0};
static C_char li1119[] C_aligned={C_lihdr(0,0,43),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,117,110,114,101,103,105,115,116,101,114,45,102,101,97,116,117,114,101,33,32,46,32,102,115,41,0,0,0,0,0};
static C_char li1120[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,105,100,115,41,0,0,0,0,0,0};
static C_char li1121[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,102,101,97,116,117,114,101,63,32,46,32,105,100,115,41,0,0,0,0,0,0,0};
static C_char li1122[] C_aligned={C_lihdr(0,0,16),67,95,114,101,116,117,114,110,95,116,111,95,104,111,115,116};
static C_char li1123[] C_aligned={C_lihdr(0,0,42),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,115,121,115,116,101,109,45,99,111,110,102,105,103,45,100,105,114,101,99,116,111,114,121,41,0,0,0,0,0,0};
static C_char li1124[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,115,121,115,116,101,109,45,99,97,99,104,101,45,100,105,114,101,99,116,111,114,121,41,0,0,0,0,0,0,0};
static C_char li1125[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,56,56,55,55,32,103,56,56,56,57,41,0,0,0,0};
static C_char li1126[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,102,101,97,116,117,114,101,115,41,0,0,0,0,0,0,0};
static C_char li1127[] C_aligned={C_lihdr(0,0,21),40,100,111,108,111,111,112,56,57,49,51,32,105,32,114,101,115,117,108,116,41,0,0,0};
static C_char li1128[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,109,97,107,101,45,108,105,115,116,32,110,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li1129[] C_aligned={C_lihdr(0,0,16),40,100,111,108,111,111,112,56,57,50,51,32,105,32,108,41};
static C_char li1130[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,108,105,115,116,45,115,101,116,33,32,108,32,110,32,111,98,106,41,0,0,0,0,0,0};
static C_char li1131[] C_aligned={C_lihdr(0,0,12),40,108,112,32,114,101,115,32,108,115,116,41,0,0,0,0};
static C_char li1132[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,108,105,115,116,45,99,111,112,121,32,108,115,116,41,0,0};
static C_char li1133[] C_aligned={C_lihdr(0,0,15),40,100,111,108,111,111,112,56,57,54,50,32,102,105,41,0};
static C_char li1134[] C_aligned={C_lihdr(0,0,18),40,115,45,62,118,32,115,32,115,116,97,114,116,32,101,110,100,41,0,0,0,0,0,0};
static C_char li1135[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,62,118,101,99,116,111,114,32,115,32,46,32,114,101,115,116,41};
static C_char li1136[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,116,105,32,102,105,41,0,0,0,0};
static C_char li1137[] C_aligned={C_lihdr(0,0,18),40,118,45,62,115,32,118,32,115,116,97,114,116,32,101,110,100,41,0,0,0,0,0,0};
static C_char li1138[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,62,115,116,114,105,110,103,32,118,32,46,32,114,101,115,116,41};
static C_char li1139[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,105,32,106,41,0,0,0,0,0,0};
static C_char li1140[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,57,48,50,53,41,0,0,0,0,0};
static C_char li1141[] C_aligned={C_lihdr(0,0,17),40,102,111,108,100,108,57,48,53,53,32,103,57,48,53,52,41,0,0,0,0,0,0,0};
static C_char li1142[] C_aligned={C_lihdr(0,0,7),40,103,57,49,48,51,41,0};
static C_char li1143[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,57,48,57,55,32,103,57,49,48,57,41,0,0,0,0};
static C_char li1144[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,57,48,57,50,32,105,41,0,0};
static C_char li1145[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,57,48,54,50,32,103,57,48,55,52,41,0,0,0,0};
static C_char li1146[] C_aligned={C_lihdr(0,0,35),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,109,97,112,32,112,114,111,99,32,115,116,114,32,46,32,109,111,114,101,41,0,0,0,0,0};
static C_char li1147[] C_aligned={C_lihdr(0,0,6),40,108,112,32,105,41,0,0};
static C_char li1148[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,57,49,52,56,41,0,0,0,0,0};
static C_char li1149[] C_aligned={C_lihdr(0,0,17),40,102,111,108,100,108,57,49,55,56,32,103,57,49,55,55,41,0,0,0,0,0,0,0};
static C_char li1150[] C_aligned={C_lihdr(0,0,7),40,103,57,50,50,54,41,0};
static C_char li1151[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,57,50,50,48,32,103,57,50,51,50,41,0,0,0,0};
static C_char li1152[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,57,50,49,53,32,105,41,0,0};
static C_char li1153[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,57,49,56,53,32,103,57,49,57,55,41,0,0,0,0};
static C_char li1154[] C_aligned={C_lihdr(0,0,40),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,102,111,114,45,101,97,99,104,32,112,114,111,99,32,115,116,114,32,46,32,109,111,114,101,41};
static C_char li1155[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,57,50,54,54,32,105,41,0,0};
static C_char li1156[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,57,50,55,54,41,0,0,0,0,0};
static C_char li1157[] C_aligned={C_lihdr(0,0,17),40,102,111,108,100,108,57,51,48,54,32,103,57,51,48,53,41,0,0,0,0,0,0,0};
static C_char li1158[] C_aligned={C_lihdr(0,0,7),40,103,57,51,53,52,41,0};
static C_char li1159[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,57,51,52,56,32,103,57,51,54,48,41,0,0,0,0};
static C_char li1160[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,57,51,52,51,32,105,41,0,0};
static C_char li1161[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,57,51,49,51,32,103,57,51,50,53,41,0,0,0,0};
static C_char li1162[] C_aligned={C_lihdr(0,0,33),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,109,97,112,32,112,114,111,99,32,118,32,46,32,109,111,114,101,41,0,0,0,0,0,0,0};
static C_char li1163[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,57,51,57,50,32,105,41,0,0};
static C_char li1164[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,57,52,48,50,41,0,0,0,0,0};
static C_char li1165[] C_aligned={C_lihdr(0,0,17),40,102,111,108,100,108,57,52,51,50,32,103,57,52,51,49,41,0,0,0,0,0,0,0};
static C_char li1166[] C_aligned={C_lihdr(0,0,7),40,103,57,52,56,48,41,0};
static C_char li1167[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,57,52,55,52,32,103,57,52,56,54,41,0,0,0,0};
static C_char li1168[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,57,52,54,57,32,105,41,0,0};
static C_char li1169[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,57,52,51,57,32,103,57,52,53,49,41,0,0,0,0};
static C_char li1170[] C_aligned={C_lihdr(0,0,38),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,102,111,114,45,101,97,99,104,32,112,114,111,99,32,118,32,46,32,109,111,114,101,41,0,0};
static C_char li1171[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,99,108,111,115,101,45,112,111,114,116,32,112,111,114,116,41};
static C_char li1172[] C_aligned={C_lihdr(0,0,8),40,97,51,57,49,49,48,41};
static C_char li1173[] C_aligned={C_lihdr(0,0,14),40,97,51,57,49,49,54,32,46,32,114,101,116,41,0,0};
static C_char li1174[] C_aligned={C_lihdr(0,0,33),40,115,99,104,101,109,101,35,99,97,108,108,45,119,105,116,104,45,112,111,114,116,32,112,111,114,116,32,112,114,111,99,41,0,0,0,0,0,0,0};
static C_char li1175[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,101,111,102,45,111,98,106,101,99,116,41,0,0,0,0,0};
static C_char li1176[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,112,101,101,107,45,117,56,32,46,32,114,118,97,114,41,0};
static C_char li1177[] C_aligned={C_lihdr(0,0,30),40,115,99,104,101,109,101,35,119,114,105,116,101,45,115,116,114,105,110,103,32,115,32,46,32,114,101,115,116,41,0,0};
static C_char li1178[] C_aligned={C_lihdr(0,0,19),40,100,111,108,111,111,112,57,53,57,56,32,120,32,105,32,120,115,41,0,0,0,0,0};
static C_char li1179[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,105,111,35,114,101,97,100,45,108,105,115,116,32,46,32,114,101,115,116,41,0,0,0};
static C_char li1180[] C_aligned={C_lihdr(0,0,10),40,103,57,54,50,50,32,114,108,41,0,0,0,0,0,0};
static C_char li1181[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li1182[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,105,111,35,114,101,97,100,45,108,105,110,101,32,46,32,97,114,103,115,41,0,0,0};
static C_char li1183[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,108,110,115,32,110,41,0,0,0,0};
static C_char li1184[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,105,111,35,114,101,97,100,45,108,105,110,101,115,32,46,32,114,101,115,116,41,0,0};
static C_char li1185[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,105,111,35,119,114,105,116,101,45,108,105,110,101,32,115,116,114,32,46,32,112,111,114,116,41,0,0,0,0,0,0};
static C_char li1186[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,115,116,97,114,116,32,110,32,109,41};
static C_char li1187[] C_aligned={C_lihdr(0,0,52),40,99,104,105,99,107,101,110,46,105,111,35,114,101,97,100,45,98,121,116,101,118,101,99,116,111,114,33,47,112,111,114,116,32,110,32,100,101,115,116,32,112,111,114,116,32,115,116,97,114,116,41,0,0,0,0};
static C_char li1188[] C_aligned={C_lihdr(0,0,23),40,97,51,57,55,55,53,32,100,98,117,102,32,115,116,97,114,116,32,108,101,110,41,0};
static C_char li1189[] C_aligned={C_lihdr(0,0,20),40,114,101,97,100,98,32,110,32,98,117,102,32,112,111,114,116,32,112,41,0,0,0,0};
static C_char li1190[] C_aligned={C_lihdr(0,0,14),40,102,105,110,105,115,104,32,98,121,116,101,115,41,0,0};
static C_char li1191[] C_aligned={C_lihdr(0,0,15),40,114,101,99,111,117,110,116,32,98,121,116,101,115,41,0};
static C_char li1192[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,112,32,110,32,117,110,32,98,110,41};
static C_char li1193[] C_aligned={C_lihdr(0,0,20),40,97,51,57,55,53,55,32,100,101,99,111,100,101,114,32,95,32,95,41,0,0,0,0};
static C_char li1194[] C_aligned={C_lihdr(0,0,48),40,99,104,105,99,107,101,110,46,105,111,35,114,101,97,100,45,115,116,114,105,110,103,33,47,112,111,114,116,32,110,32,100,101,115,116,32,112,111,114,116,32,115,116,97,114,116,41};
static C_char li1195[] C_aligned={C_lihdr(0,0,39),40,99,104,105,99,107,101,110,46,105,111,35,114,101,97,100,45,115,116,114,105,110,103,33,32,110,32,100,101,115,116,32,46,32,114,101,115,116,41,0};
static C_char li1196[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,105,111,35,114,101,97,100,45,98,121,116,101,118,101,99,116,111,114,33,32,100,101,115,116,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char li1197[] C_aligned={C_lihdr(0,0,16),40,97,52,48,48,57,57,32,98,117,102,32,108,101,110,41};
static C_char li1198[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,105,111,35,114,101,97,100,45,115,116,114,105,110,103,47,112,111,114,116,32,110,32,112,41,0,0,0,0,0,0,0};
static C_char li1199[] C_aligned={C_lihdr(0,0,20),40,108,111,111,112,32,98,117,102,32,98,115,105,122,101,32,112,111,115,41,0,0,0,0};
static C_char li1200[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,114,101,97,100,45,114,101,109,97,105,110,105,110,103,32,112,32,107,41,0,0,0,0,0,0};
static C_char li1201[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,105,111,35,114,101,97,100,45,98,121,116,101,118,101,99,116,111,114,47,112,111,114,116,32,110,32,112,41,0,0,0};
static C_char li1202[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,105,111,35,114,101,97,100,45,115,116,114,105,110,103,32,46,32,114,101,115,116,41,0};
static C_char li1203[] C_aligned={C_lihdr(0,0,16),40,97,52,48,50,55,49,32,98,117,102,32,108,101,110,41};
static C_char li1204[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,105,111,35,114,101,97,100,45,98,121,116,101,118,101,99,116,111,114,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li1205[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,105,111,35,114,101,97,100,45,98,117,102,102,101,114,101,100,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char li1206[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char li1207[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,105,111,35,114,101,97,100,45,116,111,107,101,110,32,112,114,101,100,32,46,32,112,111,114,116,41,0,0,0,0,0};
static C_char li1208[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,105,111,35,114,101,97,100,45,98,121,116,101,32,46,32,114,101,115,116,41,0,0,0};
static C_char li1209[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,105,111,35,119,114,105,116,101,45,98,121,116,101,32,98,121,116,101,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li1210[] C_aligned={C_lihdr(0,0,39),40,99,104,105,99,107,101,110,46,105,111,35,119,114,105,116,101,45,98,121,116,101,118,101,99,116,111,114,32,98,118,32,46,32,114,101,115,116,41,0};
static C_char li1211[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,56,55,48,50,32,103,56,55,49,52,41,0,0,0,0};
static C_char li1212[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,56,54,54,48,41,0,0,0,0,0};
static C_char li1213[] C_aligned={C_lihdr(0,0,12),40,97,52,48,55,49,50,32,110,101,119,41,0,0,0,0};
static C_char li1214[] C_aligned={C_lihdr(0,0,16),67,95,98,117,105,108,100,95,112,108,97,116,102,111,114,109};
static C_char li1215[] C_aligned={C_lihdr(0,0,18),67,95,115,111,102,116,119,97,114,101,95,118,101,114,115,105,111,110,0,0,0,0,0,0};
static C_char li1216[] C_aligned={C_lihdr(0,0,20),67,95,109,97,99,104,105,110,101,95,98,121,116,101,95,111,114,100,101,114,0,0,0,0};
static C_char li1217[] C_aligned={C_lihdr(0,0,14),67,95,109,97,99,104,105,110,101,95,116,121,112,101,0,0};
static C_char li1218[] C_aligned={C_lihdr(0,0,15),67,95,115,111,102,116,119,97,114,101,95,116,121,112,101,0};
static C_char li1219[] C_aligned={C_lihdr(0,0,12),40,97,52,48,56,49,49,32,115,121,109,41,0,0,0,0};
static C_char li1220[] C_aligned={C_lihdr(0,0,16),40,97,52,48,56,50,48,32,115,121,109,32,108,115,116,41};
static C_char li1221[] C_aligned={C_lihdr(0,0,10),40,97,52,48,56,54,48,32,120,41,0,0,0,0,0,0};
static C_char li1222[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,97,114,103,115,41,0,0,0,0,0};
static C_char li1223[] C_aligned={C_lihdr(0,0,19),40,102,52,57,48,55,52,32,120,56,49,52,57,52,57,48,55,51,41,0,0,0,0,0};
static C_char li1224[] C_aligned={C_lihdr(0,0,19),40,102,52,57,48,56,48,32,120,56,49,51,53,52,57,48,55,57,41,0,0,0,0,0};
static C_char li1225[] C_aligned={C_lihdr(0,0,19),40,102,52,57,48,56,54,32,120,56,49,51,53,52,57,48,56,53,41,0,0,0,0,0};
static C_char li1226[] C_aligned={C_lihdr(0,0,8),40,97,52,48,57,52,49,41};
static C_char li1227[] C_aligned={C_lihdr(0,0,12),40,97,52,48,57,54,54,32,100,105,114,41,0,0,0,0};
static C_char li1228[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,55,48,57,49,32,103,55,48,57,56,41,0,0,0,0,0,0,0};
static C_char li1229[] C_aligned={C_lihdr(0,0,8),40,97,52,49,48,48,56,41};
static C_char li1230[] C_aligned={C_lihdr(0,0,9),40,103,55,49,49,55,32,120,41,0,0,0,0,0,0,0};
static C_char li1231[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,55,49,49,54,32,103,55,49,50,51,41,0,0,0,0,0,0,0};
static C_char li1232[] C_aligned={C_lihdr(0,0,15),40,97,52,49,49,50,48,32,46,32,97,114,103,115,41,0};
static C_char li1233[] C_aligned={C_lihdr(0,0,19),40,97,52,48,57,56,49,32,109,115,103,32,46,32,97,114,103,115,41,0,0,0,0,0};
static C_char li1234[] C_aligned={C_lihdr(0,0,8),40,97,52,49,49,50,51,41};
static C_char li1235[] C_aligned={C_lihdr(0,0,8),40,97,52,49,49,51,50,41};
static C_char li1236[] C_aligned={C_lihdr(0,0,15),40,97,52,49,49,51,56,32,46,32,114,101,115,116,41,0};
static C_char li1237[] C_aligned={C_lihdr(0,0,10),40,97,52,49,51,57,55,32,120,41,0,0,0,0,0,0};
static C_char li1238[] C_aligned={C_lihdr(0,0,14),40,97,52,49,52,48,54,32,120,32,105,32,121,41,0,0};
static C_char li1239[] C_aligned={C_lihdr(0,0,12),40,97,52,49,52,49,54,32,120,32,121,41,0,0,0,0};
static C_char li1240[] C_aligned={C_lihdr(0,0,12),40,97,52,49,52,50,54,32,120,32,121,41,0,0,0,0};
static C_char li1241[] C_aligned={C_lihdr(0,0,12),40,97,52,49,52,51,54,32,120,32,121,41,0,0,0,0};
static C_char li1242[] C_aligned={C_lihdr(0,0,12),40,97,52,49,52,52,54,32,120,32,121,41,0,0,0,0};
static C_char li1243[] C_aligned={C_lihdr(0,0,12),40,97,52,49,52,53,54,32,120,32,121,41,0,0,0,0};
static C_char li1244[] C_aligned={C_lihdr(0,0,12),40,97,52,49,52,54,54,32,120,32,121,41,0,0,0,0};
static C_char li1245[] C_aligned={C_lihdr(0,0,12),40,97,52,49,52,55,54,32,120,32,121,41,0,0,0,0};
static C_char li1246[] C_aligned={C_lihdr(0,0,12),40,97,52,49,52,56,54,32,120,32,121,41,0,0,0,0};
static C_char li1247[] C_aligned={C_lihdr(0,0,12),40,97,52,49,52,57,54,32,120,32,121,41,0,0,0,0};
static C_char li1248[] C_aligned={C_lihdr(0,0,12),40,97,52,49,53,48,54,32,120,32,121,41,0,0,0,0};
static C_char li1249[] C_aligned={C_lihdr(0,0,12),40,97,52,49,53,49,54,32,120,32,121,41,0,0,0,0};
static C_char li1250[] C_aligned={C_lihdr(0,0,12),40,97,52,49,53,50,54,32,120,32,121,41,0,0,0,0};
static C_char li1251[] C_aligned={C_lihdr(0,0,10),40,97,52,49,53,54,48,32,120,41,0,0,0,0,0,0};
static C_char li1252[] C_aligned={C_lihdr(0,0,13),40,97,52,49,53,51,54,32,112,114,111,99,41,0,0,0};
static C_char li1253[] C_aligned={C_lihdr(0,0,10),40,97,52,49,53,55,54,32,120,41,0,0,0,0,0,0};
static C_char li1254[] C_aligned={C_lihdr(0,0,10),40,97,52,49,54,51,49,32,120,41,0,0,0,0,0,0};
static C_char li1255[] C_aligned={C_lihdr(0,0,15),40,97,52,49,54,52,55,32,112,114,111,99,32,105,41,0};
static C_char li1256[] C_aligned={C_lihdr(0,0,16),40,97,52,49,54,48,50,32,103,101,116,32,115,101,116,41};
static C_char li1257[] C_aligned={C_lihdr(0,0,15),40,97,52,49,53,57,50,32,112,114,111,99,32,105,41,0};
static C_char li1258[] C_aligned={C_lihdr(0,0,10),40,116,111,112,108,101,118,101,108,41,0,0,0,0,0,0};


#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
C_regparm static C_word stub8124(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word i=(C_word )(C_a0);
C_return(C_main_argv[C_unfix(i)]);
C_ret:
#undef return

return C_r;}

/* from chicken.process-context#executable-pathname in k35745 in k35109 in k34889 in k34463 in k34460 in k34457 in k34454 in k34449 in k34445 in k34304 in k33288 in k33285 in k33282 in k32515 in k32176 in k32172 in k32168 in k31028 in k29832 in k29828 in k29824 in ... */
C_regparm static C_word stub8116(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_mpointer(&C_a,(void*)C_executable_pathname());
return C_r;}

/* from k35773 */
C_regparm static C_word stub8092(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from chicken.process-context#_getenv */
C_regparm static C_word stub8084(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenv(t0));
return C_r;}

/* from k34759 */
C_regparm static C_word stub7759(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
C_free(t0);
return C_r;}

/* from k34750 */
C_regparm static C_word stub7751(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_mpointer(&C_a,(void*)C_peek_c_string_at(t0,t1));
return C_r;}

/* from k34698 */
C_regparm static C_word stub7732(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_mpointer(&C_a,(void*)C_peek_c_string_at(t0,t1));
return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
C_regparm static C_word stub6838(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word x=(C_word )(C_a0);
C_return((C_char *)x);
C_ret:
#undef return

return C_r;}

/* from k20321 */
C_regparm static C_word stub3511(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
double t0=(double )C_c_double(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_flonum(&C_a,ldexp(t0,t1));
return C_r;}

C_noret_decl(f45147)
static void C_ccall f45147(C_word c,C_word *av) C_noret;
C_noret_decl(f45346)
static void C_ccall f45346(C_word c,C_word *av) C_noret;
C_noret_decl(f45350)
static void C_ccall f45350(C_word c,C_word *av) C_noret;
C_noret_decl(f45480)
static void C_ccall f45480(C_word c,C_word *av) C_noret;
C_noret_decl(f45485)
static void C_ccall f45485(C_word c,C_word *av) C_noret;
C_noret_decl(f45492)
static void C_ccall f45492(C_word c,C_word *av) C_noret;
C_noret_decl(f45501)
static void C_ccall f45501(C_word c,C_word *av) C_noret;
C_noret_decl(f45510)
static void C_ccall f45510(C_word c,C_word *av) C_noret;
C_noret_decl(f49074)
static void C_ccall f49074(C_word c,C_word *av) C_noret;
C_noret_decl(f49080)
static void C_ccall f49080(C_word c,C_word *av) C_noret;
C_noret_decl(f49086)
static void C_ccall f49086(C_word c,C_word *av) C_noret;
C_noret_decl(f_11451)
static void C_ccall f_11451(C_word c,C_word *av) C_noret;
C_noret_decl(f_11453)
static void C_ccall f_11453(C_word c,C_word *av) C_noret;
C_noret_decl(f_11456)
static void C_ccall f_11456(C_word c,C_word *av) C_noret;
C_noret_decl(f_11459)
static void C_ccall f_11459(C_word c,C_word *av) C_noret;
C_noret_decl(f_11462)
static void C_ccall f_11462(C_word c,C_word *av) C_noret;
C_noret_decl(f_11465)
static void C_ccall f_11465(C_word c,C_word *av) C_noret;
C_noret_decl(f_11468)
static void C_ccall f_11468(C_word c,C_word *av) C_noret;
C_noret_decl(f_11484)
static C_word f_11484(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_11513)
static void C_ccall f_11513(C_word c,C_word *av) C_noret;
C_noret_decl(f_11529)
static C_word f_11529(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_11558)
static void C_ccall f_11558(C_word c,C_word *av) C_noret;
C_noret_decl(f_11561)
static void C_ccall f_11561(C_word c,C_word *av) C_noret;
C_noret_decl(f_11564)
static void C_ccall f_11564(C_word c,C_word *av) C_noret;
C_noret_decl(f_11567)
static void C_ccall f_11567(C_word c,C_word *av) C_noret;
C_noret_decl(f_11570)
static void C_ccall f_11570(C_word c,C_word *av) C_noret;
C_noret_decl(f_11573)
static void C_ccall f_11573(C_word c,C_word *av) C_noret;
C_noret_decl(f_11576)
static void C_ccall f_11576(C_word c,C_word *av) C_noret;
C_noret_decl(f_11579)
static void C_ccall f_11579(C_word c,C_word *av) C_noret;
C_noret_decl(f_11582)
static void C_ccall f_11582(C_word c,C_word *av) C_noret;
C_noret_decl(f_11585)
static void C_ccall f_11585(C_word c,C_word *av) C_noret;
C_noret_decl(f_11588)
static void C_ccall f_11588(C_word c,C_word *av) C_noret;
C_noret_decl(f_11591)
static void C_ccall f_11591(C_word c,C_word *av) C_noret;
C_noret_decl(f_11594)
static void C_ccall f_11594(C_word c,C_word *av) C_noret;
C_noret_decl(f_11597)
static void C_ccall f_11597(C_word c,C_word *av) C_noret;
C_noret_decl(f_11611)
static void C_ccall f_11611(C_word c,C_word *av) C_noret;
C_noret_decl(f_11618)
static void C_ccall f_11618(C_word c,C_word *av) C_noret;
C_noret_decl(f_11625)
static void C_ccall f_11625(C_word c,C_word *av) C_noret;
C_noret_decl(f_11639)
static void C_ccall f_11639(C_word c,C_word *av) C_noret;
C_noret_decl(f_11646)
static void C_ccall f_11646(C_word c,C_word *av) C_noret;
C_noret_decl(f_11660)
static void C_ccall f_11660(C_word c,C_word *av) C_noret;
C_noret_decl(f_11674)
static void C_ccall f_11674(C_word c,C_word *av) C_noret;
C_noret_decl(f_11692)
static void C_ccall f_11692(C_word c,C_word *av) C_noret;
C_noret_decl(f_11703)
static void C_ccall f_11703(C_word c,C_word *av) C_noret;
C_noret_decl(f_11714)
static void C_ccall f_11714(C_word c,C_word *av) C_noret;
C_noret_decl(f_11721)
static void C_ccall f_11721(C_word c,C_word *av) C_noret;
C_noret_decl(f_11732)
static void C_ccall f_11732(C_word c,C_word *av) C_noret;
C_noret_decl(f_11736)
static void C_ccall f_11736(C_word c,C_word *av) C_noret;
C_noret_decl(f_11743)
static void C_ccall f_11743(C_word c,C_word *av) C_noret;
C_noret_decl(f_11761)
static void C_ccall f_11761(C_word c,C_word *av) C_noret;
C_noret_decl(f_11772)
static void C_ccall f_11772(C_word c,C_word *av) C_noret;
C_noret_decl(f_11783)
static void C_ccall f_11783(C_word c,C_word *av) C_noret;
C_noret_decl(f_11790)
static void C_ccall f_11790(C_word c,C_word *av) C_noret;
C_noret_decl(f_11808)
static void C_ccall f_11808(C_word c,C_word *av) C_noret;
C_noret_decl(f_11819)
static void C_ccall f_11819(C_word c,C_word *av) C_noret;
C_noret_decl(f_11837)
static void C_ccall f_11837(C_word c,C_word *av) C_noret;
C_noret_decl(f_11843)
static void C_ccall f_11843(C_word c,C_word *av) C_noret;
C_noret_decl(f_11846)
static void C_ccall f_11846(C_word c,C_word *av) C_noret;
C_noret_decl(f_11849)
static void C_ccall f_11849(C_word c,C_word *av) C_noret;
C_noret_decl(f_11852)
static void C_ccall f_11852(C_word c,C_word *av) C_noret;
C_noret_decl(f_11855)
static void C_ccall f_11855(C_word c,C_word *av) C_noret;
C_noret_decl(f_11861)
static void f_11861(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_11894)
static void C_ccall f_11894(C_word c,C_word *av) C_noret;
C_noret_decl(f_11897)
static void C_ccall f_11897(C_word c,C_word *av) C_noret;
C_noret_decl(f_11900)
static void C_ccall f_11900(C_word c,C_word *av) C_noret;
C_noret_decl(f_11912)
static void f_11912(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_11925)
static void C_ccall f_11925(C_word c,C_word *av) C_noret;
C_noret_decl(f_11944)
static void C_ccall f_11944(C_word c,C_word *av) C_noret;
C_noret_decl(f_11947)
static void C_ccall f_11947(C_word c,C_word *av) C_noret;
C_noret_decl(f_11950)
static void C_ccall f_11950(C_word c,C_word *av) C_noret;
C_noret_decl(f_11962)
static void f_11962(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_11975)
static void C_ccall f_11975(C_word c,C_word *av) C_noret;
C_noret_decl(f_11999)
static void C_ccall f_11999(C_word c,C_word *av) C_noret;
C_noret_decl(f_12002)
static void C_ccall f_12002(C_word c,C_word *av) C_noret;
C_noret_decl(f_12005)
static void C_ccall f_12005(C_word c,C_word *av) C_noret;
C_noret_decl(f_12008)
static void C_ccall f_12008(C_word c,C_word *av) C_noret;
C_noret_decl(f_12011)
static void C_ccall f_12011(C_word c,C_word *av) C_noret;
C_noret_decl(f_12014)
static void C_ccall f_12014(C_word c,C_word *av) C_noret;
C_noret_decl(f_12021)
static C_word f_12021(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_12047)
static void C_ccall f_12047(C_word c,C_word *av) C_noret;
C_noret_decl(f_12054)
static C_word f_12054(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_12098)
static void C_ccall f_12098(C_word c,C_word *av) C_noret;
C_noret_decl(f_12101)
static void C_ccall f_12101(C_word c,C_word *av) C_noret;
C_noret_decl(f_12107)
static void C_ccall f_12107(C_word c,C_word *av) C_noret;
C_noret_decl(f_12110)
static void C_ccall f_12110(C_word c,C_word *av) C_noret;
C_noret_decl(f_12113)
static void C_ccall f_12113(C_word c,C_word *av) C_noret;
C_noret_decl(f_12116)
static void C_ccall f_12116(C_word c,C_word *av) C_noret;
C_noret_decl(f_12119)
static void C_ccall f_12119(C_word c,C_word *av) C_noret;
C_noret_decl(f_12127)
static void C_ccall f_12127(C_word c,C_word *av) C_noret;
C_noret_decl(f_12131)
static void C_ccall f_12131(C_word c,C_word *av) C_noret;
C_noret_decl(f_12134)
static void C_ccall f_12134(C_word c,C_word *av) C_noret;
C_noret_decl(f_12137)
static void C_ccall f_12137(C_word c,C_word *av) C_noret;
C_noret_decl(f_12140)
static void C_ccall f_12140(C_word c,C_word *av) C_noret;
C_noret_decl(f_12143)
static void C_ccall f_12143(C_word c,C_word *av) C_noret;
C_noret_decl(f_12146)
static void C_ccall f_12146(C_word c,C_word *av) C_noret;
C_noret_decl(f_12149)
static void C_ccall f_12149(C_word c,C_word *av) C_noret;
C_noret_decl(f_12152)
static void C_ccall f_12152(C_word c,C_word *av) C_noret;
C_noret_decl(f_12155)
static void C_ccall f_12155(C_word c,C_word *av) C_noret;
C_noret_decl(f_12159)
static void C_ccall f_12159(C_word c,C_word *av) C_noret;
C_noret_decl(f_12162)
static void C_ccall f_12162(C_word c,C_word *av) C_noret;
C_noret_decl(f_12165)
static void C_ccall f_12165(C_word c,C_word *av) C_noret;
C_noret_decl(f_12168)
static void C_ccall f_12168(C_word c,C_word *av) C_noret;
C_noret_decl(f_12171)
static void C_ccall f_12171(C_word c,C_word *av) C_noret;
C_noret_decl(f_12179)
static void C_ccall f_12179(C_word c,C_word *av) C_noret;
C_noret_decl(f_12182)
static void C_ccall f_12182(C_word c,C_word *av) C_noret;
C_noret_decl(f_12189)
static void C_ccall f_12189(C_word c,C_word *av) C_noret;
C_noret_decl(f_12196)
static void C_ccall f_12196(C_word c,C_word *av) C_noret;
C_noret_decl(f_12209)
static C_word f_12209(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_12235)
static void C_ccall f_12235(C_word c,C_word *av) C_noret;
C_noret_decl(f_12248)
static C_word f_12248(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_12274)
static void C_ccall f_12274(C_word c,C_word *av) C_noret;
C_noret_decl(f_12287)
static C_word f_12287(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_12313)
static void C_ccall f_12313(C_word c,C_word *av) C_noret;
C_noret_decl(f_12326)
static C_word f_12326(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_12352)
static void C_ccall f_12352(C_word c,C_word *av) C_noret;
C_noret_decl(f_12365)
static C_word f_12365(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_12391)
static void C_ccall f_12391(C_word c,C_word *av) C_noret;
C_noret_decl(f_12397)
static void C_ccall f_12397(C_word c,C_word *av) C_noret;
C_noret_decl(f_12408)
static void C_ccall f_12408(C_word c,C_word *av) C_noret;
C_noret_decl(f_12414)
static void C_ccall f_12414(C_word c,C_word *av) C_noret;
C_noret_decl(f_12420)
static void C_ccall f_12420(C_word c,C_word *av) C_noret;
C_noret_decl(f_12426)
static void C_ccall f_12426(C_word c,C_word *av) C_noret;
C_noret_decl(f_12432)
static void C_ccall f_12432(C_word c,C_word *av) C_noret;
C_noret_decl(f_12438)
static void C_ccall f_12438(C_word c,C_word *av) C_noret;
C_noret_decl(f_12454)
static void C_ccall f_12454(C_word c,C_word *av) C_noret;
C_noret_decl(f_12460)
static void C_ccall f_12460(C_word c,C_word *av) C_noret;
C_noret_decl(f_12474)
static void C_ccall f_12474(C_word c,C_word *av) C_noret;
C_noret_decl(f_12480)
static void C_ccall f_12480(C_word c,C_word *av) C_noret;
C_noret_decl(f_12494)
static void C_ccall f_12494(C_word c,C_word *av) C_noret;
C_noret_decl(f_12500)
static void C_ccall f_12500(C_word c,C_word *av) C_noret;
C_noret_decl(f_12514)
static void C_ccall f_12514(C_word c,C_word *av) C_noret;
C_noret_decl(f_12520)
static void C_ccall f_12520(C_word c,C_word *av) C_noret;
C_noret_decl(f_12528)
static void C_ccall f_12528(C_word c,C_word *av) C_noret;
C_noret_decl(f_12534)
static void C_ccall f_12534(C_word c,C_word *av) C_noret;
C_noret_decl(f_12540)
static void C_ccall f_12540(C_word c,C_word *av) C_noret;
C_noret_decl(f_12547)
static void C_ccall f_12547(C_word c,C_word *av) C_noret;
C_noret_decl(f_12556)
static void C_ccall f_12556(C_word c,C_word *av) C_noret;
C_noret_decl(f_12563)
static void C_ccall f_12563(C_word c,C_word *av) C_noret;
C_noret_decl(f_12572)
static void C_ccall f_12572(C_word c,C_word *av) C_noret;
C_noret_decl(f_12578)
static void C_ccall f_12578(C_word c,C_word *av) C_noret;
C_noret_decl(f_12583)
static void C_ccall f_12583(C_word c,C_word *av) C_noret;
C_noret_decl(f_12598)
static void C_ccall f_12598(C_word c,C_word *av) C_noret;
C_noret_decl(f_12609)
static void C_ccall f_12609(C_word c,C_word *av) C_noret;
C_noret_decl(f_12615)
static void C_ccall f_12615(C_word c,C_word *av) C_noret;
C_noret_decl(f_12621)
static void C_ccall f_12621(C_word c,C_word *av) C_noret;
C_noret_decl(f_12627)
static void C_ccall f_12627(C_word c,C_word *av) C_noret;
C_noret_decl(f_12633)
static void C_ccall f_12633(C_word c,C_word *av) C_noret;
C_noret_decl(f_12643)
static void C_ccall f_12643(C_word c,C_word *av) C_noret;
C_noret_decl(f_12645)
static void C_ccall f_12645(C_word c,C_word *av) C_noret;
C_noret_decl(f_12648)
static void C_ccall f_12648(C_word c,C_word *av) C_noret;
C_noret_decl(f_12651)
static void C_ccall f_12651(C_word c,C_word *av) C_noret;
C_noret_decl(f_12654)
static void C_ccall f_12654(C_word c,C_word *av) C_noret;
C_noret_decl(f_12657)
static void C_ccall f_12657(C_word c,C_word *av) C_noret;
C_noret_decl(f_12662)
static void C_ccall f_12662(C_word c,C_word *av) C_noret;
C_noret_decl(f_12668)
static void C_ccall f_12668(C_word c,C_word *av) C_noret;
C_noret_decl(f_12674)
static void C_ccall f_12674(C_word c,C_word *av) C_noret;
C_noret_decl(f_12709)
static void C_ccall f_12709(C_word c,C_word *av) C_noret;
C_noret_decl(f_12712)
static void C_ccall f_12712(C_word c,C_word *av) C_noret;
C_noret_decl(f_12715)
static void C_ccall f_12715(C_word c,C_word *av) C_noret;
C_noret_decl(f_12723)
static void C_ccall f_12723(C_word c,C_word *av) C_noret;
C_noret_decl(f_12729)
static void C_ccall f_12729(C_word c,C_word *av) C_noret;
C_noret_decl(f_12736)
static void C_ccall f_12736(C_word c,C_word *av) C_noret;
C_noret_decl(f_12751)
static void C_ccall f_12751(C_word c,C_word *av) C_noret;
C_noret_decl(f_12765)
static void C_ccall f_12765(C_word c,C_word *av) C_noret;
C_noret_decl(f_12771)
static void C_ccall f_12771(C_word c,C_word *av) C_noret;
C_noret_decl(f_12777)
static void C_ccall f_12777(C_word c,C_word *av) C_noret;
C_noret_decl(f_12784)
static void C_ccall f_12784(C_word c,C_word *av) C_noret;
C_noret_decl(f_12789)
static void C_ccall f_12789(C_word c,C_word *av) C_noret;
C_noret_decl(f_12792)
static void C_ccall f_12792(C_word c,C_word *av) C_noret;
C_noret_decl(f_12801)
static void f_12801(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_12819)
static void C_ccall f_12819(C_word c,C_word *av) C_noret;
C_noret_decl(f_12829)
static void C_ccall f_12829(C_word c,C_word *av) C_noret;
C_noret_decl(f_12838)
static void f_12838(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_12856)
static void C_ccall f_12856(C_word c,C_word *av) C_noret;
C_noret_decl(f_12869)
static void C_ccall f_12869(C_word c,C_word *av) C_noret;
C_noret_decl(f_12876)
static void C_ccall f_12876(C_word c,C_word *av) C_noret;
C_noret_decl(f_12883)
static void C_ccall f_12883(C_word c,C_word *av) C_noret;
C_noret_decl(f_12894)
static void C_ccall f_12894(C_word c,C_word *av) C_noret;
C_noret_decl(f_12913)
static void C_ccall f_12913(C_word c,C_word *av) C_noret;
C_noret_decl(f_12916)
static void C_ccall f_12916(C_word c,C_word *av) C_noret;
C_noret_decl(f_12918)
static void C_ccall f_12918(C_word c,C_word *av) C_noret;
C_noret_decl(f_12924)
static void f_12924(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_12940)
static void C_ccall f_12940(C_word c,C_word *av) C_noret;
C_noret_decl(f_12949)
static void C_ccall f_12949(C_word c,C_word *av) C_noret;
C_noret_decl(f_12951)
static void C_ccall f_12951(C_word c,C_word *av) C_noret;
C_noret_decl(f_12957)
static void f_12957(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_12970)
static void C_ccall f_12970(C_word c,C_word *av) C_noret;
C_noret_decl(f_12986)
static void C_ccall f_12986(C_word c,C_word *av) C_noret;
C_noret_decl(f_12997)
static void C_ccall f_12997(C_word c,C_word *av) C_noret;
C_noret_decl(f_12999)
static void C_ccall f_12999(C_word c,C_word *av) C_noret;
C_noret_decl(f_13007)
static void C_ccall f_13007(C_word c,C_word *av) C_noret;
C_noret_decl(f_13009)
static void C_ccall f_13009(C_word c,C_word *av) C_noret;
C_noret_decl(f_13015)
static void C_ccall f_13015(C_word c,C_word *av) C_noret;
C_noret_decl(f_13017)
static void C_ccall f_13017(C_word c,C_word *av) C_noret;
C_noret_decl(f_13025)
static void C_ccall f_13025(C_word c,C_word *av) C_noret;
C_noret_decl(f_13027)
static void C_ccall f_13027(C_word c,C_word *av) C_noret;
C_noret_decl(f_13030)
static void C_ccall f_13030(C_word c,C_word *av) C_noret;
C_noret_decl(f_13038)
static void C_ccall f_13038(C_word c,C_word *av) C_noret;
C_noret_decl(f_13044)
static void C_ccall f_13044(C_word c,C_word *av) C_noret;
C_noret_decl(f_13052)
static void C_ccall f_13052(C_word c,C_word *av) C_noret;
C_noret_decl(f_13063)
static void C_ccall f_13063(C_word c,C_word *av) C_noret;
C_noret_decl(f_13075)
static void f_13075(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_13089)
static void C_ccall f_13089(C_word c,C_word *av) C_noret;
C_noret_decl(f_13097)
static void C_ccall f_13097(C_word c,C_word *av) C_noret;
C_noret_decl(f_13100)
static void C_ccall f_13100(C_word c,C_word *av) C_noret;
C_noret_decl(f_13102)
static void C_ccall f_13102(C_word c,C_word *av) C_noret;
C_noret_decl(f_13104)
static void C_ccall f_13104(C_word c,C_word *av) C_noret;
C_noret_decl(f_13110)
static void f_13110(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_13129)
static void C_ccall f_13129(C_word c,C_word *av) C_noret;
C_noret_decl(f_13146)
static void C_ccall f_13146(C_word c,C_word *av) C_noret;
C_noret_decl(f_13154)
static void C_ccall f_13154(C_word c,C_word *av) C_noret;
C_noret_decl(f_13168)
static void C_ccall f_13168(C_word c,C_word *av) C_noret;
C_noret_decl(f_13174)
static void f_13174(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_13193)
static void C_ccall f_13193(C_word c,C_word *av) C_noret;
C_noret_decl(f_13202)
static void C_ccall f_13202(C_word c,C_word *av) C_noret;
C_noret_decl(f_13205)
static void C_ccall f_13205(C_word c,C_word *av) C_noret;
C_noret_decl(f_13208)
static void C_ccall f_13208(C_word c,C_word *av) C_noret;
C_noret_decl(f_13211)
static void C_ccall f_13211(C_word c,C_word *av) C_noret;
C_noret_decl(f_13214)
static void C_ccall f_13214(C_word c,C_word *av) C_noret;
C_noret_decl(f_13223)
static C_word f_13223(C_word t0,C_word t1);
C_noret_decl(f_13242)
static void C_ccall f_13242(C_word c,C_word *av) C_noret;
C_noret_decl(f_13248)
static void f_13248(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_13273)
static void C_ccall f_13273(C_word c,C_word *av) C_noret;
C_noret_decl(f_13275)
static void C_ccall f_13275(C_word c,C_word *av) C_noret;
C_noret_decl(f_13284)
static void f_13284(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_13305)
static void C_ccall f_13305(C_word c,C_word *av) C_noret;
C_noret_decl(f_13307)
static void C_ccall f_13307(C_word c,C_word *av) C_noret;
C_noret_decl(f_13313)
static void f_13313(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_13339)
static void C_ccall f_13339(C_word c,C_word *av) C_noret;
C_noret_decl(f_13346)
static void C_ccall f_13346(C_word c,C_word *av) C_noret;
C_noret_decl(f_13348)
static void C_ccall f_13348(C_word c,C_word *av) C_noret;
C_noret_decl(f_13360)
static void f_13360(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_13395)
static void C_ccall f_13395(C_word c,C_word *av) C_noret;
C_noret_decl(f_13405)
static void C_ccall f_13405(C_word c,C_word *av) C_noret;
C_noret_decl(f_13414)
static void f_13414(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_13456)
static void C_ccall f_13456(C_word c,C_word *av) C_noret;
C_noret_decl(f_13485)
static void C_ccall f_13485(C_word c,C_word *av) C_noret;
C_noret_decl(f_13492)
static void f_13492(C_word t0,C_word t1) C_noret;
C_noret_decl(f_13495)
static void C_ccall f_13495(C_word c,C_word *av) C_noret;
C_noret_decl(f_13524)
static void C_ccall f_13524(C_word c,C_word *av) C_noret;
C_noret_decl(f_13530)
static void f_13530(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_13546)
static void C_ccall f_13546(C_word c,C_word *av) C_noret;
C_noret_decl(f_13571)
static void C_ccall f_13571(C_word c,C_word *av) C_noret;
C_noret_decl(f_13580)
static void f_13580(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_13621)
static void C_ccall f_13621(C_word c,C_word *av) C_noret;
C_noret_decl(f_13643)
static void C_ccall f_13643(C_word c,C_word *av) C_noret;
C_noret_decl(f_13675)
static void C_ccall f_13675(C_word c,C_word *av) C_noret;
C_noret_decl(f_13691)
static void f_13691(C_word t0,C_word t1) C_noret;
C_noret_decl(f_13694)
static void C_ccall f_13694(C_word c,C_word *av) C_noret;
C_noret_decl(f_13716)
static void C_ccall f_13716(C_word c,C_word *av) C_noret;
C_noret_decl(f_13722)
static void f_13722(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_13747)
static void C_ccall f_13747(C_word c,C_word *av) C_noret;
C_noret_decl(f_13787)
static void C_ccall f_13787(C_word c,C_word *av) C_noret;
C_noret_decl(f_13799)
static void f_13799(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_13818)
static void C_ccall f_13818(C_word c,C_word *av) C_noret;
C_noret_decl(f_13835)
static void C_ccall f_13835(C_word c,C_word *av) C_noret;
C_noret_decl(f_13842)
static void C_ccall f_13842(C_word c,C_word *av) C_noret;
C_noret_decl(f_13852)
static void C_ccall f_13852(C_word c,C_word *av) C_noret;
C_noret_decl(f_13863)
static void C_ccall f_13863(C_word c,C_word *av) C_noret;
C_noret_decl(f_13867)
static void C_ccall f_13867(C_word c,C_word *av) C_noret;
C_noret_decl(f_13880)
static void C_ccall f_13880(C_word c,C_word *av) C_noret;
C_noret_decl(f_13882)
static void C_ccall f_13882(C_word c,C_word *av) C_noret;
C_noret_decl(f_13916)
static void C_ccall f_13916(C_word c,C_word *av) C_noret;
C_noret_decl(f_13920)
static void C_ccall f_13920(C_word c,C_word *av) C_noret;
C_noret_decl(f_13938)
static void C_ccall f_13938(C_word c,C_word *av) C_noret;
C_noret_decl(f_13951)
static void C_ccall f_13951(C_word c,C_word *av) C_noret;
C_noret_decl(f_13960)
static void C_ccall f_13960(C_word c,C_word *av) C_noret;
C_noret_decl(f_13966)
static void C_ccall f_13966(C_word c,C_word *av) C_noret;
C_noret_decl(f_13976)
static void C_ccall f_13976(C_word c,C_word *av) C_noret;
C_noret_decl(f_13980)
static void C_ccall f_13980(C_word c,C_word *av) C_noret;
C_noret_decl(f_13984)
static void C_ccall f_13984(C_word c,C_word *av) C_noret;
C_noret_decl(f_13988)
static void C_ccall f_13988(C_word c,C_word *av) C_noret;
C_noret_decl(f_13991)
static void C_ccall f_13991(C_word c,C_word *av) C_noret;
C_noret_decl(f_13993)
static void f_13993(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_13997)
static void f_13997(C_word t0,C_word t1) C_noret;
C_noret_decl(f_14001)
static void C_ccall f_14001(C_word c,C_word *av) C_noret;
C_noret_decl(f_14005)
static void C_ccall f_14005(C_word c,C_word *av) C_noret;
C_noret_decl(f_14009)
static void C_ccall f_14009(C_word c,C_word *av) C_noret;
C_noret_decl(f_14024)
static void C_ccall f_14024(C_word c,C_word *av) C_noret;
C_noret_decl(f_14041)
static void C_ccall f_14041(C_word c,C_word *av) C_noret;
C_noret_decl(f_14047)
static void C_ccall f_14047(C_word c,C_word *av) C_noret;
C_noret_decl(f_14053)
static void C_ccall f_14053(C_word c,C_word *av) C_noret;
C_noret_decl(f_14056)
static void f_14056(C_word t0,C_word t1) C_noret;
C_noret_decl(f_14063)
static void C_ccall f_14063(C_word c,C_word *av) C_noret;
C_noret_decl(f_14100)
static void C_ccall f_14100(C_word c,C_word *av) C_noret;
C_noret_decl(f_14103)
static void C_ccall f_14103(C_word c,C_word *av) C_noret;
C_noret_decl(f_14106)
static void C_ccall f_14106(C_word c,C_word *av) C_noret;
C_noret_decl(f_14109)
static void C_ccall f_14109(C_word c,C_word *av) C_noret;
C_noret_decl(f_14115)
static void C_ccall f_14115(C_word c,C_word *av) C_noret;
C_noret_decl(f_14118)
static void C_ccall f_14118(C_word c,C_word *av) C_noret;
C_noret_decl(f_14121)
static void C_ccall f_14121(C_word c,C_word *av) C_noret;
C_noret_decl(f_14124)
static void C_ccall f_14124(C_word c,C_word *av) C_noret;
C_noret_decl(f_14127)
static void C_ccall f_14127(C_word c,C_word *av) C_noret;
C_noret_decl(f_14130)
static void C_ccall f_14130(C_word c,C_word *av) C_noret;
C_noret_decl(f_14133)
static void C_ccall f_14133(C_word c,C_word *av) C_noret;
C_noret_decl(f_14136)
static void C_ccall f_14136(C_word c,C_word *av) C_noret;
C_noret_decl(f_14139)
static void C_ccall f_14139(C_word c,C_word *av) C_noret;
C_noret_decl(f_14142)
static void C_ccall f_14142(C_word c,C_word *av) C_noret;
C_noret_decl(f_14145)
static void C_ccall f_14145(C_word c,C_word *av) C_noret;
C_noret_decl(f_14148)
static void C_ccall f_14148(C_word c,C_word *av) C_noret;
C_noret_decl(f_14151)
static void C_ccall f_14151(C_word c,C_word *av) C_noret;
C_noret_decl(f_14154)
static void C_ccall f_14154(C_word c,C_word *av) C_noret;
C_noret_decl(f_14157)
static void C_ccall f_14157(C_word c,C_word *av) C_noret;
C_noret_decl(f_14160)
static void C_ccall f_14160(C_word c,C_word *av) C_noret;
C_noret_decl(f_14163)
static void C_ccall f_14163(C_word c,C_word *av) C_noret;
C_noret_decl(f_14166)
static void C_ccall f_14166(C_word c,C_word *av) C_noret;
C_noret_decl(f_14169)
static void C_ccall f_14169(C_word c,C_word *av) C_noret;
C_noret_decl(f_14172)
static void C_ccall f_14172(C_word c,C_word *av) C_noret;
C_noret_decl(f_14175)
static void C_ccall f_14175(C_word c,C_word *av) C_noret;
C_noret_decl(f_14178)
static void C_ccall f_14178(C_word c,C_word *av) C_noret;
C_noret_decl(f_14181)
static void C_ccall f_14181(C_word c,C_word *av) C_noret;
C_noret_decl(f_14184)
static void C_ccall f_14184(C_word c,C_word *av) C_noret;
C_noret_decl(f_14187)
static void C_ccall f_14187(C_word c,C_word *av) C_noret;
C_noret_decl(f_14192)
static void C_ccall f_14192(C_word c,C_word *av) C_noret;
C_noret_decl(f_14201)
static void C_ccall f_14201(C_word c,C_word *av) C_noret;
C_noret_decl(f_14213)
static void C_ccall f_14213(C_word c,C_word *av) C_noret;
C_noret_decl(f_14227)
static void C_ccall f_14227(C_word c,C_word *av) C_noret;
C_noret_decl(f_14243)
static void C_ccall f_14243(C_word c,C_word *av) C_noret;
C_noret_decl(f_14246)
static void C_ccall f_14246(C_word c,C_word *av) C_noret;
C_noret_decl(f_14255)
static void C_ccall f_14255(C_word c,C_word *av) C_noret;
C_noret_decl(f_14259)
static void C_ccall f_14259(C_word c,C_word *av) C_noret;
C_noret_decl(f_14261)
static void C_ccall f_14261(C_word c,C_word *av) C_noret;
C_noret_decl(f_14265)
static void C_ccall f_14265(C_word c,C_word *av) C_noret;
C_noret_decl(f_14268)
static void C_ccall f_14268(C_word c,C_word *av) C_noret;
C_noret_decl(f_14279)
static void C_ccall f_14279(C_word c,C_word *av) C_noret;
C_noret_decl(f_14281)
static void C_ccall f_14281(C_word c,C_word *av) C_noret;
C_noret_decl(f_14288)
static void C_ccall f_14288(C_word c,C_word *av) C_noret;
C_noret_decl(f_14291)
static void C_ccall f_14291(C_word c,C_word *av) C_noret;
C_noret_decl(f_14296)
static void C_ccall f_14296(C_word c,C_word *av) C_noret;
C_noret_decl(f_14300)
static void C_ccall f_14300(C_word c,C_word *av) C_noret;
C_noret_decl(f_14305)
static void C_ccall f_14305(C_word c,C_word *av) C_noret;
C_noret_decl(f_14309)
static void C_ccall f_14309(C_word c,C_word *av) C_noret;
C_noret_decl(f_14340)
static void C_ccall f_14340(C_word c,C_word *av) C_noret;
C_noret_decl(f_14343)
static void C_ccall f_14343(C_word c,C_word *av) C_noret;
C_noret_decl(f_14346)
static void C_ccall f_14346(C_word c,C_word *av) C_noret;
C_noret_decl(f_14363)
static void C_ccall f_14363(C_word c,C_word *av) C_noret;
C_noret_decl(f_14374)
static void C_ccall f_14374(C_word c,C_word *av) C_noret;
C_noret_decl(f_14385)
static void C_ccall f_14385(C_word c,C_word *av) C_noret;
C_noret_decl(f_14396)
static void C_ccall f_14396(C_word c,C_word *av) C_noret;
C_noret_decl(f_14407)
static void C_ccall f_14407(C_word c,C_word *av) C_noret;
C_noret_decl(f_14418)
static void C_ccall f_14418(C_word c,C_word *av) C_noret;
C_noret_decl(f_14429)
static void C_ccall f_14429(C_word c,C_word *av) C_noret;
C_noret_decl(f_14440)
static void C_ccall f_14440(C_word c,C_word *av) C_noret;
C_noret_decl(f_14451)
static void C_ccall f_14451(C_word c,C_word *av) C_noret;
C_noret_decl(f_14462)
static void C_ccall f_14462(C_word c,C_word *av) C_noret;
C_noret_decl(f_14473)
static void C_ccall f_14473(C_word c,C_word *av) C_noret;
C_noret_decl(f_14484)
static void C_ccall f_14484(C_word c,C_word *av) C_noret;
C_noret_decl(f_14495)
static void C_ccall f_14495(C_word c,C_word *av) C_noret;
C_noret_decl(f_14506)
static void C_ccall f_14506(C_word c,C_word *av) C_noret;
C_noret_decl(f_14517)
static void C_ccall f_14517(C_word c,C_word *av) C_noret;
C_noret_decl(f_14528)
static void C_ccall f_14528(C_word c,C_word *av) C_noret;
C_noret_decl(f_14539)
static void C_ccall f_14539(C_word c,C_word *av) C_noret;
C_noret_decl(f_14556)
static void C_ccall f_14556(C_word c,C_word *av) C_noret;
C_noret_decl(f_14573)
static void C_ccall f_14573(C_word c,C_word *av) C_noret;
C_noret_decl(f_14597)
static void C_ccall f_14597(C_word c,C_word *av) C_noret;
C_noret_decl(f_14614)
static void C_ccall f_14614(C_word c,C_word *av) C_noret;
C_noret_decl(f_14625)
static void C_ccall f_14625(C_word c,C_word *av) C_noret;
C_noret_decl(f_14636)
static void C_ccall f_14636(C_word c,C_word *av) C_noret;
C_noret_decl(f_14656)
static void C_ccall f_14656(C_word c,C_word *av) C_noret;
C_noret_decl(f_14667)
static void C_ccall f_14667(C_word c,C_word *av) C_noret;
C_noret_decl(f_14679)
static void f_14679(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_14713)
static void C_ccall f_14713(C_word c,C_word *av) C_noret;
C_noret_decl(f_14728)
static void f_14728(C_word t0,C_word t1) C_noret;
C_noret_decl(f_14795)
static void C_ccall f_14795(C_word c,C_word *av) C_noret;
C_noret_decl(f_14811)
static void C_ccall f_14811(C_word c,C_word *av) C_noret;
C_noret_decl(f_14827)
static void C_ccall f_14827(C_word c,C_word *av) C_noret;
C_noret_decl(f_14843)
static void C_ccall f_14843(C_word c,C_word *av) C_noret;
C_noret_decl(f_14859)
static void C_ccall f_14859(C_word c,C_word *av) C_noret;
C_noret_decl(f_14875)
static void C_ccall f_14875(C_word c,C_word *av) C_noret;
C_noret_decl(f_14891)
static void C_ccall f_14891(C_word c,C_word *av) C_noret;
C_noret_decl(f_14907)
static void C_ccall f_14907(C_word c,C_word *av) C_noret;
C_noret_decl(f_14923)
static void C_ccall f_14923(C_word c,C_word *av) C_noret;
C_noret_decl(f_14935)
static void f_14935(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_14954)
static void f_14954(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_14985)
static void C_ccall f_14985(C_word c,C_word *av) C_noret;
C_noret_decl(f_15002)
static void C_ccall f_15002(C_word c,C_word *av) C_noret;
C_noret_decl(f_15008)
static void f_15008(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_15032)
static void C_ccall f_15032(C_word c,C_word *av) C_noret;
C_noret_decl(f_15047)
static void C_ccall f_15047(C_word c,C_word *av) C_noret;
C_noret_decl(f_15057)
static void C_ccall f_15057(C_word c,C_word *av) C_noret;
C_noret_decl(f_15069)
static void C_ccall f_15069(C_word c,C_word *av) C_noret;
C_noret_decl(f_15073)
static void C_ccall f_15073(C_word c,C_word *av) C_noret;
C_noret_decl(f_15080)
static void C_ccall f_15080(C_word c,C_word *av) C_noret;
C_noret_decl(f_15086)
static void C_ccall f_15086(C_word c,C_word *av) C_noret;
C_noret_decl(f_15092)
static void C_ccall f_15092(C_word c,C_word *av) C_noret;
C_noret_decl(f_15116)
static void C_ccall f_15116(C_word c,C_word *av) C_noret;
C_noret_decl(f_15120)
static void C_ccall f_15120(C_word c,C_word *av) C_noret;
C_noret_decl(f_15129)
static void C_ccall f_15129(C_word c,C_word *av) C_noret;
C_noret_decl(f_15133)
static void C_ccall f_15133(C_word c,C_word *av) C_noret;
C_noret_decl(f_15142)
static void C_ccall f_15142(C_word c,C_word *av) C_noret;
C_noret_decl(f_15145)
static void C_ccall f_15145(C_word c,C_word *av) C_noret;
C_noret_decl(f_15151)
static void C_ccall f_15151(C_word c,C_word *av) C_noret;
C_noret_decl(f_15157)
static void C_ccall f_15157(C_word c,C_word *av) C_noret;
C_noret_decl(f_15160)
static void C_ccall f_15160(C_word c,C_word *av) C_noret;
C_noret_decl(f_15199)
static void C_ccall f_15199(C_word c,C_word *av) C_noret;
C_noret_decl(f_15202)
static void C_ccall f_15202(C_word c,C_word *av) C_noret;
C_noret_decl(f_15212)
static void f_15212(C_word t0,C_word t1) C_noret;
C_noret_decl(f_15229)
static void C_ccall f_15229(C_word c,C_word *av) C_noret;
C_noret_decl(f_15235)
static void C_ccall f_15235(C_word c,C_word *av) C_noret;
C_noret_decl(f_15241)
static void C_ccall f_15241(C_word c,C_word *av) C_noret;
C_noret_decl(f_15247)
static void C_ccall f_15247(C_word c,C_word *av) C_noret;
C_noret_decl(f_15253)
static void C_ccall f_15253(C_word c,C_word *av) C_noret;
C_noret_decl(f_15259)
static void C_ccall f_15259(C_word c,C_word *av) C_noret;
C_noret_decl(f_15265)
static void C_ccall f_15265(C_word c,C_word *av) C_noret;
C_noret_decl(f_15271)
static void C_ccall f_15271(C_word c,C_word *av) C_noret;
C_noret_decl(f_15275)
static void C_ccall f_15275(C_word c,C_word *av) C_noret;
C_noret_decl(f_15280)
static void C_ccall f_15280(C_word c,C_word *av) C_noret;
C_noret_decl(f_15283)
static void C_ccall f_15283(C_word c,C_word *av) C_noret;
C_noret_decl(f_15293)
static void C_ccall f_15293(C_word c,C_word *av) C_noret;
C_noret_decl(f_15296)
static void C_ccall f_15296(C_word c,C_word *av) C_noret;
C_noret_decl(f_15302)
static void C_ccall f_15302(C_word c,C_word *av) C_noret;
C_noret_decl(f_15306)
static void C_ccall f_15306(C_word c,C_word *av) C_noret;
C_noret_decl(f_15314)
static void f_15314(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_15318)
static void C_ccall f_15318(C_word c,C_word *av) C_noret;
C_noret_decl(f_15336)
static void C_ccall f_15336(C_word c,C_word *av) C_noret;
C_noret_decl(f_15360)
static void C_ccall f_15360(C_word c,C_word *av) C_noret;
C_noret_decl(f_15367)
static void C_ccall f_15367(C_word c,C_word *av) C_noret;
C_noret_decl(f_15391)
static void C_ccall f_15391(C_word c,C_word *av) C_noret;
C_noret_decl(f_15413)
static void C_ccall f_15413(C_word c,C_word *av) C_noret;
C_noret_decl(f_15416)
static void C_ccall f_15416(C_word c,C_word *av) C_noret;
C_noret_decl(f_15425)
static void f_15425(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_15482)
static void C_ccall f_15482(C_word c,C_word *av) C_noret;
C_noret_decl(f_15495)
static void C_ccall f_15495(C_word c,C_word *av) C_noret;
C_noret_decl(f_15500)
static void f_15500(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_15544)
static void C_ccall f_15544(C_word c,C_word *av) C_noret;
C_noret_decl(f_15548)
static void C_ccall f_15548(C_word c,C_word *av) C_noret;
C_noret_decl(f_15553)
static void f_15553(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_15595)
static void C_ccall f_15595(C_word c,C_word *av) C_noret;
C_noret_decl(f_15618)
static void f_15618(C_word t0,C_word t1) C_noret;
C_noret_decl(f_15641)
static C_word f_15641(C_word t0,C_word t1);
C_noret_decl(f_15714)
static void C_ccall f_15714(C_word c,C_word *av) C_noret;
C_noret_decl(f_15734)
static void f_15734(C_word t0,C_word t1) C_noret;
C_noret_decl(f_15737)
static void C_ccall f_15737(C_word c,C_word *av) C_noret;
C_noret_decl(f_15740)
static void f_15740(C_word t0,C_word t1) C_noret;
C_noret_decl(f_15749)
static void C_ccall f_15749(C_word c,C_word *av) C_noret;
C_noret_decl(f_15753)
static void C_ccall f_15753(C_word c,C_word *av) C_noret;
C_noret_decl(f_15763)
static void C_ccall f_15763(C_word c,C_word *av) C_noret;
C_noret_decl(f_15790)
static void C_ccall f_15790(C_word c,C_word *av) C_noret;
C_noret_decl(f_15820)
static void C_ccall f_15820(C_word c,C_word *av) C_noret;
C_noret_decl(f_15839)
static C_word f_15839(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_15873)
static C_word f_15873(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_15907)
static void C_ccall f_15907(C_word c,C_word *av) C_noret;
C_noret_decl(f_15941)
static void C_ccall f_15941(C_word c,C_word *av) C_noret;
C_noret_decl(f_15945)
static void C_ccall f_15945(C_word c,C_word *av) C_noret;
C_noret_decl(f_15955)
static void C_ccall f_15955(C_word c,C_word *av) C_noret;
C_noret_decl(f_15965)
static void f_15965(C_word t0,C_word t1) C_noret;
C_noret_decl(f_15972)
static void f_15972(C_word t0,C_word t1) C_noret;
C_noret_decl(f_16000)
static void f_16000(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_16020)
static void C_ccall f_16020(C_word c,C_word *av) C_noret;
C_noret_decl(f_16022)
static void f_16022(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_16050)
static void C_ccall f_16050(C_word c,C_word *av) C_noret;
C_noret_decl(f_16069)
static void C_ccall f_16069(C_word c,C_word *av) C_noret;
C_noret_decl(f_16075)
static void C_ccall f_16075(C_word c,C_word *av) C_noret;
C_noret_decl(f_16093)
static void C_ccall f_16093(C_word c,C_word *av) C_noret;
C_noret_decl(f_16099)
static void C_ccall f_16099(C_word c,C_word *av) C_noret;
C_noret_decl(f_16117)
static void C_ccall f_16117(C_word c,C_word *av) C_noret;
C_noret_decl(f_16123)
static void C_ccall f_16123(C_word c,C_word *av) C_noret;
C_noret_decl(f_16138)
static void C_ccall f_16138(C_word c,C_word *av) C_noret;
C_noret_decl(f_16144)
static void C_ccall f_16144(C_word c,C_word *av) C_noret;
C_noret_decl(f_16158)
static void f_16158(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_16178)
static void C_ccall f_16178(C_word c,C_word *av) C_noret;
C_noret_decl(f_16180)
static void f_16180(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_16208)
static void C_ccall f_16208(C_word c,C_word *av) C_noret;
C_noret_decl(f_16219)
static void C_ccall f_16219(C_word c,C_word *av) C_noret;
C_noret_decl(f_16225)
static void C_ccall f_16225(C_word c,C_word *av) C_noret;
C_noret_decl(f_16243)
static void C_ccall f_16243(C_word c,C_word *av) C_noret;
C_noret_decl(f_16249)
static void C_ccall f_16249(C_word c,C_word *av) C_noret;
C_noret_decl(f_16267)
static void C_ccall f_16267(C_word c,C_word *av) C_noret;
C_noret_decl(f_16273)
static void C_ccall f_16273(C_word c,C_word *av) C_noret;
C_noret_decl(f_16288)
static void C_ccall f_16288(C_word c,C_word *av) C_noret;
C_noret_decl(f_16294)
static void C_ccall f_16294(C_word c,C_word *av) C_noret;
C_noret_decl(f_16309)
static void C_ccall f_16309(C_word c,C_word *av) C_noret;
C_noret_decl(f_16325)
static void C_ccall f_16325(C_word c,C_word *av) C_noret;
C_noret_decl(f_16355)
static void C_ccall f_16355(C_word c,C_word *av) C_noret;
C_noret_decl(f_16359)
static void C_ccall f_16359(C_word c,C_word *av) C_noret;
C_noret_decl(f_16361)
static void f_16361(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_16372)
static void C_ccall f_16372(C_word c,C_word *av) C_noret;
C_noret_decl(f_16395)
static void C_ccall f_16395(C_word c,C_word *av) C_noret;
C_noret_decl(f_16413)
static void C_ccall f_16413(C_word c,C_word *av) C_noret;
C_noret_decl(f_16419)
static void C_ccall f_16419(C_word c,C_word *av) C_noret;
C_noret_decl(f_16425)
static void C_ccall f_16425(C_word c,C_word *av) C_noret;
C_noret_decl(f_16432)
static void C_ccall f_16432(C_word c,C_word *av) C_noret;
C_noret_decl(f_16440)
static void f_16440(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_16461)
static void f_16461(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_16475)
static void C_ccall f_16475(C_word c,C_word *av) C_noret;
C_noret_decl(f_16479)
static void C_ccall f_16479(C_word c,C_word *av) C_noret;
C_noret_decl(f_16520)
static void C_ccall f_16520(C_word c,C_word *av) C_noret;
C_noret_decl(f_16542)
static void C_ccall f_16542(C_word c,C_word *av) C_noret;
C_noret_decl(f_16544)
static void C_ccall f_16544(C_word c,C_word *av) C_noret;
C_noret_decl(f_16566)
static void C_ccall f_16566(C_word c,C_word *av) C_noret;
C_noret_decl(f_16568)
static void C_ccall f_16568(C_word c,C_word *av) C_noret;
C_noret_decl(f_16590)
static void C_ccall f_16590(C_word c,C_word *av) C_noret;
C_noret_decl(f_16592)
static void C_ccall f_16592(C_word c,C_word *av) C_noret;
C_noret_decl(f_16614)
static void C_ccall f_16614(C_word c,C_word *av) C_noret;
C_noret_decl(f_16616)
static void C_ccall f_16616(C_word c,C_word *av) C_noret;
C_noret_decl(f_16620)
static void C_ccall f_16620(C_word c,C_word *av) C_noret;
C_noret_decl(f_16623)
static void f_16623(C_word t0,C_word t1) C_noret;
C_noret_decl(f_16641)
static void C_ccall f_16641(C_word c,C_word *av) C_noret;
C_noret_decl(f_16663)
static void C_ccall f_16663(C_word c,C_word *av) C_noret;
C_noret_decl(f_16665)
static void C_ccall f_16665(C_word c,C_word *av) C_noret;
C_noret_decl(f_16687)
static void C_ccall f_16687(C_word c,C_word *av) C_noret;
C_noret_decl(f_16689)
static void C_ccall f_16689(C_word c,C_word *av) C_noret;
C_noret_decl(f_16711)
static void C_ccall f_16711(C_word c,C_word *av) C_noret;
C_noret_decl(f_16713)
static void C_ccall f_16713(C_word c,C_word *av) C_noret;
C_noret_decl(f_16735)
static void C_ccall f_16735(C_word c,C_word *av) C_noret;
C_noret_decl(f_16737)
static void C_ccall f_16737(C_word c,C_word *av) C_noret;
C_noret_decl(f_16759)
static void C_ccall f_16759(C_word c,C_word *av) C_noret;
C_noret_decl(f_16761)
static void C_ccall f_16761(C_word c,C_word *av) C_noret;
C_noret_decl(f_16783)
static void C_ccall f_16783(C_word c,C_word *av) C_noret;
C_noret_decl(f_16785)
static void C_ccall f_16785(C_word c,C_word *av) C_noret;
C_noret_decl(f_16807)
static void C_ccall f_16807(C_word c,C_word *av) C_noret;
C_noret_decl(f_16809)
static void C_ccall f_16809(C_word c,C_word *av) C_noret;
C_noret_decl(f_16825)
static void C_ccall f_16825(C_word c,C_word *av) C_noret;
C_noret_decl(f_16827)
static void C_ccall f_16827(C_word c,C_word *av) C_noret;
C_noret_decl(f_16849)
static void C_ccall f_16849(C_word c,C_word *av) C_noret;
C_noret_decl(f_16851)
static void C_ccall f_16851(C_word c,C_word *av) C_noret;
C_noret_decl(f_16873)
static void C_ccall f_16873(C_word c,C_word *av) C_noret;
C_noret_decl(f_16875)
static void C_ccall f_16875(C_word c,C_word *av) C_noret;
C_noret_decl(f_16891)
static void C_ccall f_16891(C_word c,C_word *av) C_noret;
C_noret_decl(f_16893)
static void C_ccall f_16893(C_word c,C_word *av) C_noret;
C_noret_decl(f_16909)
static void C_ccall f_16909(C_word c,C_word *av) C_noret;
C_noret_decl(f_16911)
static void C_ccall f_16911(C_word c,C_word *av) C_noret;
C_noret_decl(f_16927)
static void C_ccall f_16927(C_word c,C_word *av) C_noret;
C_noret_decl(f_16929)
static void C_ccall f_16929(C_word c,C_word *av) C_noret;
C_noret_decl(f_16945)
static void C_ccall f_16945(C_word c,C_word *av) C_noret;
C_noret_decl(f_16947)
static void C_ccall f_16947(C_word c,C_word *av) C_noret;
C_noret_decl(f_16963)
static void C_ccall f_16963(C_word c,C_word *av) C_noret;
C_noret_decl(f_16965)
static void C_ccall f_16965(C_word c,C_word *av) C_noret;
C_noret_decl(f_16981)
static void C_ccall f_16981(C_word c,C_word *av) C_noret;
C_noret_decl(f_16983)
static void C_ccall f_16983(C_word c,C_word *av) C_noret;
C_noret_decl(f_16999)
static void C_ccall f_16999(C_word c,C_word *av) C_noret;
C_noret_decl(f_17001)
static void C_ccall f_17001(C_word c,C_word *av) C_noret;
C_noret_decl(f_17017)
static void C_ccall f_17017(C_word c,C_word *av) C_noret;
C_noret_decl(f_17019)
static void C_ccall f_17019(C_word c,C_word *av) C_noret;
C_noret_decl(f_17035)
static void C_ccall f_17035(C_word c,C_word *av) C_noret;
C_noret_decl(f_17037)
static void C_ccall f_17037(C_word c,C_word *av) C_noret;
C_noret_decl(f_17053)
static void C_ccall f_17053(C_word c,C_word *av) C_noret;
C_noret_decl(f_17055)
static void C_ccall f_17055(C_word c,C_word *av) C_noret;
C_noret_decl(f_17077)
static void C_ccall f_17077(C_word c,C_word *av) C_noret;
C_noret_decl(f_17079)
static void C_ccall f_17079(C_word c,C_word *av) C_noret;
C_noret_decl(f_17095)
static void C_ccall f_17095(C_word c,C_word *av) C_noret;
C_noret_decl(f_17097)
static void C_ccall f_17097(C_word c,C_word *av) C_noret;
C_noret_decl(f_17113)
static void C_ccall f_17113(C_word c,C_word *av) C_noret;
C_noret_decl(f_17115)
static void C_ccall f_17115(C_word c,C_word *av) C_noret;
C_noret_decl(f_17131)
static void C_ccall f_17131(C_word c,C_word *av) C_noret;
C_noret_decl(f_17133)
static void C_ccall f_17133(C_word c,C_word *av) C_noret;
C_noret_decl(f_17149)
static void C_ccall f_17149(C_word c,C_word *av) C_noret;
C_noret_decl(f_17151)
static void C_ccall f_17151(C_word c,C_word *av) C_noret;
C_noret_decl(f_17167)
static void C_ccall f_17167(C_word c,C_word *av) C_noret;
C_noret_decl(f_17169)
static void C_ccall f_17169(C_word c,C_word *av) C_noret;
C_noret_decl(f_17185)
static void C_ccall f_17185(C_word c,C_word *av) C_noret;
C_noret_decl(f_17187)
static void C_ccall f_17187(C_word c,C_word *av) C_noret;
C_noret_decl(f_17203)
static void C_ccall f_17203(C_word c,C_word *av) C_noret;
C_noret_decl(f_17205)
static void C_ccall f_17205(C_word c,C_word *av) C_noret;
C_noret_decl(f_17227)
static void C_ccall f_17227(C_word c,C_word *av) C_noret;
C_noret_decl(f_17229)
static void C_ccall f_17229(C_word c,C_word *av) C_noret;
C_noret_decl(f_17245)
static void C_ccall f_17245(C_word c,C_word *av) C_noret;
C_noret_decl(f_17247)
static void C_ccall f_17247(C_word c,C_word *av) C_noret;
C_noret_decl(f_17263)
static void C_ccall f_17263(C_word c,C_word *av) C_noret;
C_noret_decl(f_17265)
static void C_ccall f_17265(C_word c,C_word *av) C_noret;
C_noret_decl(f_17281)
static void C_ccall f_17281(C_word c,C_word *av) C_noret;
C_noret_decl(f_17283)
static void C_ccall f_17283(C_word c,C_word *av) C_noret;
C_noret_decl(f_17299)
static void C_ccall f_17299(C_word c,C_word *av) C_noret;
C_noret_decl(f_17301)
static void C_ccall f_17301(C_word c,C_word *av) C_noret;
C_noret_decl(f_17319)
static void f_17319(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_17329)
static void C_ccall f_17329(C_word c,C_word *av) C_noret;
C_noret_decl(f_17333)
static void C_ccall f_17333(C_word c,C_word *av) C_noret;
C_noret_decl(f_17355)
static void C_ccall f_17355(C_word c,C_word *av) C_noret;
C_noret_decl(f_17359)
static void C_ccall f_17359(C_word c,C_word *av) C_noret;
C_noret_decl(f_17362)
static void C_ccall f_17362(C_word c,C_word *av) C_noret;
C_noret_decl(f_17367)
static void C_ccall f_17367(C_word c,C_word *av) C_noret;
C_noret_decl(f_17371)
static void C_ccall f_17371(C_word c,C_word *av) C_noret;
C_noret_decl(f_17374)
static void C_ccall f_17374(C_word c,C_word *av) C_noret;
C_noret_decl(f_17377)
static void C_ccall f_17377(C_word c,C_word *av) C_noret;
C_noret_decl(f_17390)
static void C_ccall f_17390(C_word c,C_word *av) C_noret;
C_noret_decl(f_17413)
static void C_ccall f_17413(C_word c,C_word *av) C_noret;
C_noret_decl(f_17439)
static void C_ccall f_17439(C_word c,C_word *av) C_noret;
C_noret_decl(f_17448)
static void C_ccall f_17448(C_word c,C_word *av) C_noret;
C_noret_decl(f_17453)
static void C_ccall f_17453(C_word c,C_word *av) C_noret;
C_noret_decl(f_17455)
static void C_ccall f_17455(C_word c,C_word *av) C_noret;
C_noret_decl(f_17499)
static C_word f_17499(C_word *a,C_word t0,C_word t1);
C_noret_decl(f_17545)
static void C_ccall f_17545(C_word c,C_word *av) C_noret;
C_noret_decl(f_17568)
static void C_ccall f_17568(C_word c,C_word *av) C_noret;
C_noret_decl(f_17572)
static void C_ccall f_17572(C_word c,C_word *av) C_noret;
C_noret_decl(f_17590)
static void C_ccall f_17590(C_word c,C_word *av) C_noret;
C_noret_decl(f_17613)
static void C_ccall f_17613(C_word c,C_word *av) C_noret;
C_noret_decl(f_17617)
static void C_ccall f_17617(C_word c,C_word *av) C_noret;
C_noret_decl(f_17635)
static void C_ccall f_17635(C_word c,C_word *av) C_noret;
C_noret_decl(f_17676)
static void f_17676(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_17687)
static void C_ccall f_17687(C_word c,C_word *av) C_noret;
C_noret_decl(f_17693)
static void f_17693(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_17697)
static void C_ccall f_17697(C_word c,C_word *av) C_noret;
C_noret_decl(f_17711)
static void C_ccall f_17711(C_word c,C_word *av) C_noret;
C_noret_decl(f_17724)
static void C_ccall f_17724(C_word c,C_word *av) C_noret;
C_noret_decl(f_17728)
static void C_ccall f_17728(C_word c,C_word *av) C_noret;
C_noret_decl(f_17745)
static void C_ccall f_17745(C_word c,C_word *av) C_noret;
C_noret_decl(f_17749)
static void C_ccall f_17749(C_word c,C_word *av) C_noret;
C_noret_decl(f_17755)
static void C_ccall f_17755(C_word c,C_word *av) C_noret;
C_noret_decl(f_17759)
static void C_ccall f_17759(C_word c,C_word *av) C_noret;
C_noret_decl(f_17799)
static void C_ccall f_17799(C_word c,C_word *av) C_noret;
C_noret_decl(f_17803)
static void C_ccall f_17803(C_word c,C_word *av) C_noret;
C_noret_decl(f_17823)
static void C_ccall f_17823(C_word c,C_word *av) C_noret;
C_noret_decl(f_17826)
static void C_ccall f_17826(C_word c,C_word *av) C_noret;
C_noret_decl(f_17829)
static void C_ccall f_17829(C_word c,C_word *av) C_noret;
C_noret_decl(f_17832)
static void C_ccall f_17832(C_word c,C_word *av) C_noret;
C_noret_decl(f_17835)
static void C_ccall f_17835(C_word c,C_word *av) C_noret;
C_noret_decl(f_17856)
static void C_ccall f_17856(C_word c,C_word *av) C_noret;
C_noret_decl(f_17858)
static void f_17858(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_17876)
static void C_ccall f_17876(C_word c,C_word *av) C_noret;
C_noret_decl(f_17886)
static void C_ccall f_17886(C_word c,C_word *av) C_noret;
C_noret_decl(f_17890)
static void C_ccall f_17890(C_word c,C_word *av) C_noret;
C_noret_decl(f_17928)
static void C_ccall f_17928(C_word c,C_word *av) C_noret;
C_noret_decl(f_17931)
static void C_ccall f_17931(C_word c,C_word *av) C_noret;
C_noret_decl(f_17934)
static void C_ccall f_17934(C_word c,C_word *av) C_noret;
C_noret_decl(f_17937)
static void C_ccall f_17937(C_word c,C_word *av) C_noret;
C_noret_decl(f_17943)
static void C_ccall f_17943(C_word c,C_word *av) C_noret;
C_noret_decl(f_17946)
static void C_ccall f_17946(C_word c,C_word *av) C_noret;
C_noret_decl(f_17994)
static void C_ccall f_17994(C_word c,C_word *av) C_noret;
C_noret_decl(f_17998)
static void C_ccall f_17998(C_word c,C_word *av) C_noret;
C_noret_decl(f_18075)
static void C_ccall f_18075(C_word c,C_word *av) C_noret;
C_noret_decl(f_18114)
static void C_ccall f_18114(C_word c,C_word *av) C_noret;
C_noret_decl(f_18167)
static void C_ccall f_18167(C_word c,C_word *av) C_noret;
C_noret_decl(f_18211)
static void C_ccall f_18211(C_word c,C_word *av) C_noret;
C_noret_decl(f_18255)
static void C_ccall f_18255(C_word c,C_word *av) C_noret;
C_noret_decl(f_18291)
static void C_ccall f_18291(C_word c,C_word *av) C_noret;
C_noret_decl(f_18310)
static void C_ccall f_18310(C_word c,C_word *av) C_noret;
C_noret_decl(f_18334)
static void f_18334(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_18337)
static void f_18337(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_18341)
static void C_ccall f_18341(C_word c,C_word *av) C_noret;
C_noret_decl(f_18344)
static void C_ccall f_18344(C_word c,C_word *av) C_noret;
C_noret_decl(f_18362)
static void C_ccall f_18362(C_word c,C_word *av) C_noret;
C_noret_decl(f_18385)
static void C_ccall f_18385(C_word c,C_word *av) C_noret;
C_noret_decl(f_18389)
static void C_ccall f_18389(C_word c,C_word *av) C_noret;
C_noret_decl(f_18412)
static void C_ccall f_18412(C_word c,C_word *av) C_noret;
C_noret_decl(f_18416)
static void C_ccall f_18416(C_word c,C_word *av) C_noret;
C_noret_decl(f_18448)
static void C_ccall f_18448(C_word c,C_word *av) C_noret;
C_noret_decl(f_18484)
static void C_ccall f_18484(C_word c,C_word *av) C_noret;
C_noret_decl(f_18488)
static void C_ccall f_18488(C_word c,C_word *av) C_noret;
C_noret_decl(f_18507)
static void C_ccall f_18507(C_word c,C_word *av) C_noret;
C_noret_decl(f_18509)
static void C_ccall f_18509(C_word c,C_word *av) C_noret;
C_noret_decl(f_18516)
static void f_18516(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_18553)
static void C_ccall f_18553(C_word c,C_word *av) C_noret;
C_noret_decl(f_18560)
static void f_18560(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_18597)
static void C_ccall f_18597(C_word c,C_word *av) C_noret;
C_noret_decl(f_18615)
static void C_ccall f_18615(C_word c,C_word *av) C_noret;
C_noret_decl(f_18624)
static void C_ccall f_18624(C_word c,C_word *av) C_noret;
C_noret_decl(f_18629)
static void C_ccall f_18629(C_word c,C_word *av) C_noret;
C_noret_decl(f_18642)
static void C_ccall f_18642(C_word c,C_word *av) C_noret;
C_noret_decl(f_18668)
static void C_ccall f_18668(C_word c,C_word *av) C_noret;
C_noret_decl(f_18676)
static void C_ccall f_18676(C_word c,C_word *av) C_noret;
C_noret_decl(f_18680)
static void C_ccall f_18680(C_word c,C_word *av) C_noret;
C_noret_decl(f_18684)
static void C_ccall f_18684(C_word c,C_word *av) C_noret;
C_noret_decl(f_18688)
static void C_ccall f_18688(C_word c,C_word *av) C_noret;
C_noret_decl(f_18691)
static void C_ccall f_18691(C_word c,C_word *av) C_noret;
C_noret_decl(f_18705)
static void C_ccall f_18705(C_word c,C_word *av) C_noret;
C_noret_decl(f_18709)
static void C_ccall f_18709(C_word c,C_word *av) C_noret;
C_noret_decl(f_18720)
static void C_ccall f_18720(C_word c,C_word *av) C_noret;
C_noret_decl(f_18744)
static void C_ccall f_18744(C_word c,C_word *av) C_noret;
C_noret_decl(f_18748)
static void C_ccall f_18748(C_word c,C_word *av) C_noret;
C_noret_decl(f_18754)
static void C_ccall f_18754(C_word c,C_word *av) C_noret;
C_noret_decl(f_18778)
static void C_ccall f_18778(C_word c,C_word *av) C_noret;
C_noret_decl(f_18782)
static void C_ccall f_18782(C_word c,C_word *av) C_noret;
C_noret_decl(f_18788)
static void C_ccall f_18788(C_word c,C_word *av) C_noret;
C_noret_decl(f_18805)
static void C_ccall f_18805(C_word c,C_word *av) C_noret;
C_noret_decl(f_18809)
static void C_ccall f_18809(C_word c,C_word *av) C_noret;
C_noret_decl(f_18813)
static void C_ccall f_18813(C_word c,C_word *av) C_noret;
C_noret_decl(f_18823)
static void f_18823(C_word t0,C_word t1) C_noret;
C_noret_decl(f_18829)
static void f_18829(C_word t0,C_word t1) C_noret;
C_noret_decl(f_18836)
static void C_ccall f_18836(C_word c,C_word *av) C_noret;
C_noret_decl(f_18848)
static void C_ccall f_18848(C_word c,C_word *av) C_noret;
C_noret_decl(f_18871)
static void C_ccall f_18871(C_word c,C_word *av) C_noret;
C_noret_decl(f_18875)
static void C_ccall f_18875(C_word c,C_word *av) C_noret;
C_noret_decl(f_18885)
static void f_18885(C_word t0,C_word t1) C_noret;
C_noret_decl(f_18891)
static void f_18891(C_word t0,C_word t1) C_noret;
C_noret_decl(f_18898)
static void C_ccall f_18898(C_word c,C_word *av) C_noret;
C_noret_decl(f_18913)
static void C_ccall f_18913(C_word c,C_word *av) C_noret;
C_noret_decl(f_18917)
static void C_ccall f_18917(C_word c,C_word *av) C_noret;
C_noret_decl(f_18950)
static void C_ccall f_18950(C_word c,C_word *av) C_noret;
C_noret_decl(f_18954)
static void C_ccall f_18954(C_word c,C_word *av) C_noret;
C_noret_decl(f_18971)
static void C_ccall f_18971(C_word c,C_word *av) C_noret;
C_noret_decl(f_18981)
static void C_ccall f_18981(C_word c,C_word *av) C_noret;
C_noret_decl(f_19054)
static void C_ccall f_19054(C_word c,C_word *av) C_noret;
C_noret_decl(f_19068)
static void C_ccall f_19068(C_word c,C_word *av) C_noret;
C_noret_decl(f_19085)
static void C_ccall f_19085(C_word c,C_word *av) C_noret;
C_noret_decl(f_19101)
static void C_ccall f_19101(C_word c,C_word *av) C_noret;
C_noret_decl(f_19172)
static void C_ccall f_19172(C_word c,C_word *av) C_noret;
C_noret_decl(f_19176)
static void C_ccall f_19176(C_word c,C_word *av) C_noret;
C_noret_decl(f_19181)
static void C_ccall f_19181(C_word c,C_word *av) C_noret;
C_noret_decl(f_19191)
static void C_ccall f_19191(C_word c,C_word *av) C_noret;
C_noret_decl(f_19195)
static void C_ccall f_19195(C_word c,C_word *av) C_noret;
C_noret_decl(f_19210)
static void C_ccall f_19210(C_word c,C_word *av) C_noret;
C_noret_decl(f_19214)
static void C_ccall f_19214(C_word c,C_word *av) C_noret;
C_noret_decl(f_19231)
static void C_ccall f_19231(C_word c,C_word *av) C_noret;
C_noret_decl(f_19241)
static void C_ccall f_19241(C_word c,C_word *av) C_noret;
C_noret_decl(f_19247)
static void C_ccall f_19247(C_word c,C_word *av) C_noret;
C_noret_decl(f_19258)
static void C_ccall f_19258(C_word c,C_word *av) C_noret;
C_noret_decl(f_19269)
static void C_ccall f_19269(C_word c,C_word *av) C_noret;
C_noret_decl(f_19281)
static void C_ccall f_19281(C_word c,C_word *av) C_noret;
C_noret_decl(f_19293)
static void C_ccall f_19293(C_word c,C_word *av) C_noret;
C_noret_decl(f_19305)
static void C_ccall f_19305(C_word c,C_word *av) C_noret;
C_noret_decl(f_19322)
static void C_ccall f_19322(C_word c,C_word *av) C_noret;
C_noret_decl(f_19329)
static void C_ccall f_19329(C_word c,C_word *av) C_noret;
C_noret_decl(f_19333)
static void C_ccall f_19333(C_word c,C_word *av) C_noret;
C_noret_decl(f_19335)
static void C_ccall f_19335(C_word c,C_word *av) C_noret;
C_noret_decl(f_19342)
static void C_ccall f_19342(C_word c,C_word *av) C_noret;
C_noret_decl(f_19348)
static void C_ccall f_19348(C_word c,C_word *av) C_noret;
C_noret_decl(f_19354)
static void C_ccall f_19354(C_word c,C_word *av) C_noret;
C_noret_decl(f_19397)
static void C_ccall f_19397(C_word c,C_word *av) C_noret;
C_noret_decl(f_19403)
static void C_ccall f_19403(C_word c,C_word *av) C_noret;
C_noret_decl(f_19409)
static void C_ccall f_19409(C_word c,C_word *av) C_noret;
C_noret_decl(f_19412)
static void C_ccall f_19412(C_word c,C_word *av) C_noret;
C_noret_decl(f_19418)
static void C_ccall f_19418(C_word c,C_word *av) C_noret;
C_noret_decl(f_19424)
static void C_ccall f_19424(C_word c,C_word *av) C_noret;
C_noret_decl(f_19427)
static void C_ccall f_19427(C_word c,C_word *av) C_noret;
C_noret_decl(f_19433)
static void C_ccall f_19433(C_word c,C_word *av) C_noret;
C_noret_decl(f_19437)
static void C_ccall f_19437(C_word c,C_word *av) C_noret;
C_noret_decl(f_19440)
static void C_ccall f_19440(C_word c,C_word *av) C_noret;
C_noret_decl(f_19445)
static void C_ccall f_19445(C_word c,C_word *av) C_noret;
C_noret_decl(f_19455)
static void f_19455(C_word t0,C_word t1) C_noret;
C_noret_decl(f_19475)
static void C_ccall f_19475(C_word c,C_word *av) C_noret;
C_noret_decl(f_19490)
static void f_19490(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_19520)
static void C_ccall f_19520(C_word c,C_word *av) C_noret;
C_noret_decl(f_19531)
static void C_ccall f_19531(C_word c,C_word *av) C_noret;
C_noret_decl(f_19547)
static void C_ccall f_19547(C_word c,C_word *av) C_noret;
C_noret_decl(f_19551)
static void C_ccall f_19551(C_word c,C_word *av) C_noret;
C_noret_decl(f_19555)
static void C_ccall f_19555(C_word c,C_word *av) C_noret;
C_noret_decl(f_19571)
static void C_ccall f_19571(C_word c,C_word *av) C_noret;
C_noret_decl(f_19589)
static void C_ccall f_19589(C_word c,C_word *av) C_noret;
C_noret_decl(f_19600)
static void f_19600(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_19622)
static void C_ccall f_19622(C_word c,C_word *av) C_noret;
C_noret_decl(f_19639)
static void C_ccall f_19639(C_word c,C_word *av) C_noret;
C_noret_decl(f_19642)
static void f_19642(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_19654)
static void C_ccall f_19654(C_word c,C_word *av) C_noret;
C_noret_decl(f_19656)
static void f_19656(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_19677)
static void C_ccall f_19677(C_word c,C_word *av) C_noret;
C_noret_decl(f_19708)
static void C_ccall f_19708(C_word c,C_word *av) C_noret;
C_noret_decl(f_19712)
static void C_ccall f_19712(C_word c,C_word *av) C_noret;
C_noret_decl(f_19746)
static void C_ccall f_19746(C_word c,C_word *av) C_noret;
C_noret_decl(f_19753)
static void C_ccall f_19753(C_word c,C_word *av) C_noret;
C_noret_decl(f_19765)
static void C_ccall f_19765(C_word c,C_word *av) C_noret;
C_noret_decl(f_19785)
static void C_ccall f_19785(C_word c,C_word *av) C_noret;
C_noret_decl(f_19789)
static void C_ccall f_19789(C_word c,C_word *av) C_noret;
C_noret_decl(f_19809)
static void f_19809(C_word t0,C_word t1) C_noret;
C_noret_decl(f_19829)
static void C_ccall f_19829(C_word c,C_word *av) C_noret;
C_noret_decl(f_19833)
static void C_ccall f_19833(C_word c,C_word *av) C_noret;
C_noret_decl(f_19837)
static void C_ccall f_19837(C_word c,C_word *av) C_noret;
C_noret_decl(f_19844)
static void C_ccall f_19844(C_word c,C_word *av) C_noret;
C_noret_decl(f_19860)
static void C_ccall f_19860(C_word c,C_word *av) C_noret;
C_noret_decl(f_19864)
static void C_ccall f_19864(C_word c,C_word *av) C_noret;
C_noret_decl(f_19905)
static void f_19905(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_19936)
static void C_ccall f_19936(C_word c,C_word *av) C_noret;
C_noret_decl(f_19964)
static void C_ccall f_19964(C_word c,C_word *av) C_noret;
C_noret_decl(f_19972)
static void C_ccall f_19972(C_word c,C_word *av) C_noret;
C_noret_decl(f_19978)
static void C_ccall f_19978(C_word c,C_word *av) C_noret;
C_noret_decl(f_19998)
static void f_19998(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_20023)
static void C_ccall f_20023(C_word c,C_word *av) C_noret;
C_noret_decl(f_20029)
static void C_ccall f_20029(C_word c,C_word *av) C_noret;
C_noret_decl(f_20033)
static void C_ccall f_20033(C_word c,C_word *av) C_noret;
C_noret_decl(f_20043)
static void C_ccall f_20043(C_word c,C_word *av) C_noret;
C_noret_decl(f_20063)
static void f_20063(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_20084)
static void C_ccall f_20084(C_word c,C_word *av) C_noret;
C_noret_decl(f_20101)
static void C_ccall f_20101(C_word c,C_word *av) C_noret;
C_noret_decl(f_20108)
static void C_ccall f_20108(C_word c,C_word *av) C_noret;
C_noret_decl(f_20113)
static void C_ccall f_20113(C_word c,C_word *av) C_noret;
C_noret_decl(f_20119)
static void C_ccall f_20119(C_word c,C_word *av) C_noret;
C_noret_decl(f_20123)
static void C_ccall f_20123(C_word c,C_word *av) C_noret;
C_noret_decl(f_20126)
static void C_ccall f_20126(C_word c,C_word *av) C_noret;
C_noret_decl(f_20133)
static void C_ccall f_20133(C_word c,C_word *av) C_noret;
C_noret_decl(f_20151)
static void C_ccall f_20151(C_word c,C_word *av) C_noret;
C_noret_decl(f_20165)
static void C_ccall f_20165(C_word c,C_word *av) C_noret;
C_noret_decl(f_20169)
static void C_ccall f_20169(C_word c,C_word *av) C_noret;
C_noret_decl(f_20206)
static void C_ccall f_20206(C_word c,C_word *av) C_noret;
C_noret_decl(f_20214)
static void C_ccall f_20214(C_word c,C_word *av) C_noret;
C_noret_decl(f_20243)
static void C_ccall f_20243(C_word c,C_word *av) C_noret;
C_noret_decl(f_20246)
static void C_ccall f_20246(C_word c,C_word *av) C_noret;
C_noret_decl(f_20261)
static void C_ccall f_20261(C_word c,C_word *av) C_noret;
C_noret_decl(f_20264)
static void f_20264(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20271)
static void C_ccall f_20271(C_word c,C_word *av) C_noret;
C_noret_decl(f_20282)
static void C_ccall f_20282(C_word c,C_word *av) C_noret;
C_noret_decl(f_20300)
static void C_ccall f_20300(C_word c,C_word *av) C_noret;
C_noret_decl(f_20325)
static void f_20325(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20340)
static void C_ccall f_20340(C_word c,C_word *av) C_noret;
C_noret_decl(f_20368)
static void f_20368(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_20372)
static C_word f_20372(C_word t0,C_word t1);
C_noret_decl(f_20386)
static void f_20386(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_20446)
static void C_ccall f_20446(C_word c,C_word *av) C_noret;
C_noret_decl(f_20466)
static void f_20466(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20472)
static void f_20472(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20532)
static void f_20532(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20570)
static void f_20570(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20576)
static void f_20576(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20618)
static void f_20618(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_20622)
static void C_ccall f_20622(C_word c,C_word *av) C_noret;
C_noret_decl(f_20625)
static void C_ccall f_20625(C_word c,C_word *av) C_noret;
C_noret_decl(f_20674)
static void f_20674(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20687)
static void f_20687(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20693)
static void C_ccall f_20693(C_word c,C_word *av) C_noret;
C_noret_decl(f_20727)
static void f_20727(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_20737)
static void C_ccall f_20737(C_word c,C_word *av) C_noret;
C_noret_decl(f_20746)
static void f_20746(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20758)
static void f_20758(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20767)
static void C_ccall f_20767(C_word c,C_word *av) C_noret;
C_noret_decl(f_20779)
static void C_ccall f_20779(C_word c,C_word *av) C_noret;
C_noret_decl(f_20785)
static void f_20785(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20791)
static void C_ccall f_20791(C_word c,C_word *av) C_noret;
C_noret_decl(f_20833)
static void C_ccall f_20833(C_word c,C_word *av) C_noret;
C_noret_decl(f_20939)
static void f_20939(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_20946)
static void f_20946(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20959)
static void C_ccall f_20959(C_word c,C_word *av) C_noret;
C_noret_decl(f_21017)
static void f_21017(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21035)
static void C_ccall f_21035(C_word c,C_word *av) C_noret;
C_noret_decl(f_21045)
static void C_ccall f_21045(C_word c,C_word *av) C_noret;
C_noret_decl(f_21081)
static void C_ccall f_21081(C_word c,C_word *av) C_noret;
C_noret_decl(f_21107)
static void C_ccall f_21107(C_word c,C_word *av) C_noret;
C_noret_decl(f_21118)
static void C_ccall f_21118(C_word c,C_word *av) C_noret;
C_noret_decl(f_21281)
static void f_21281(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_21294)
static void f_21294(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21349)
static void f_21349(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21387)
static void C_ccall f_21387(C_word c,C_word *av) C_noret;
C_noret_decl(f_21435)
static void C_ccall f_21435(C_word c,C_word *av) C_noret;
C_noret_decl(f_21512)
static void C_ccall f_21512(C_word c,C_word *av) C_noret;
C_noret_decl(f_21515)
static void C_ccall f_21515(C_word c,C_word *av) C_noret;
C_noret_decl(f_21527)
static void C_ccall f_21527(C_word c,C_word *av) C_noret;
C_noret_decl(f_21609)
static void C_ccall f_21609(C_word c,C_word *av) C_noret;
C_noret_decl(f_21673)
static void C_ccall f_21673(C_word c,C_word *av) C_noret;
C_noret_decl(f_21751)
static void C_ccall f_21751(C_word c,C_word *av) C_noret;
C_noret_decl(f_21761)
static void C_ccall f_21761(C_word c,C_word *av) C_noret;
C_noret_decl(f_21768)
static void f_21768(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_22000)
static void C_ccall f_22000(C_word c,C_word *av) C_noret;
C_noret_decl(f_22046)
static void C_ccall f_22046(C_word c,C_word *av) C_noret;
C_noret_decl(f_22049)
static void f_22049(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_22076)
static void f_22076(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_22100)
static void C_ccall f_22100(C_word c,C_word *av) C_noret;
C_noret_decl(f_22117)
static void f_22117(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_22233)
static void C_ccall f_22233(C_word c,C_word *av) C_noret;
C_noret_decl(f_22236)
static void C_ccall f_22236(C_word c,C_word *av) C_noret;
C_noret_decl(f_22246)
static void C_ccall f_22246(C_word c,C_word *av) C_noret;
C_noret_decl(f_22248)
static void C_ccall f_22248(C_word c,C_word *av) C_noret;
C_noret_decl(f_22254)
static void C_ccall f_22254(C_word c,C_word *av) C_noret;
C_noret_decl(f_22264)
static void C_ccall f_22264(C_word c,C_word *av) C_noret;
C_noret_decl(f_22267)
static void C_ccall f_22267(C_word c,C_word *av) C_noret;
C_noret_decl(f_22275)
static void C_ccall f_22275(C_word c,C_word *av) C_noret;
C_noret_decl(f_22277)
static void C_ccall f_22277(C_word c,C_word *av) C_noret;
C_noret_decl(f_22286)
static void C_ccall f_22286(C_word c,C_word *av) C_noret;
C_noret_decl(f_22295)
static void C_ccall f_22295(C_word c,C_word *av) C_noret;
C_noret_decl(f_22306)
static void C_ccall f_22306(C_word c,C_word *av) C_noret;
C_noret_decl(f_22308)
static void C_ccall f_22308(C_word c,C_word *av) C_noret;
C_noret_decl(f_22325)
static void C_ccall f_22325(C_word c,C_word *av) C_noret;
C_noret_decl(f_22329)
static void C_ccall f_22329(C_word c,C_word *av) C_noret;
C_noret_decl(f_22333)
static void C_ccall f_22333(C_word c,C_word *av) C_noret;
C_noret_decl(f_22337)
static void C_ccall f_22337(C_word c,C_word *av) C_noret;
C_noret_decl(f_22346)
static void C_ccall f_22346(C_word c,C_word *av) C_noret;
C_noret_decl(f_22366)
static void C_ccall f_22366(C_word c,C_word *av) C_noret;
C_noret_decl(f_22374)
static void C_ccall f_22374(C_word c,C_word *av) C_noret;
C_noret_decl(f_22389)
static void C_ccall f_22389(C_word c,C_word *av) C_noret;
C_noret_decl(f_22391)
static void f_22391(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_22416)
static void C_ccall f_22416(C_word c,C_word *av) C_noret;
C_noret_decl(f_22425)
static void C_ccall f_22425(C_word c,C_word *av) C_noret;
C_noret_decl(f_22428)
static void C_ccall f_22428(C_word c,C_word *av) C_noret;
C_noret_decl(f_22439)
static void C_ccall f_22439(C_word c,C_word *av) C_noret;
C_noret_decl(f_22441)
static void C_ccall f_22441(C_word c,C_word *av) C_noret;
C_noret_decl(f_22448)
static void C_ccall f_22448(C_word c,C_word *av) C_noret;
C_noret_decl(f_22459)
static void C_ccall f_22459(C_word c,C_word *av) C_noret;
C_noret_decl(f_22466)
static void C_ccall f_22466(C_word c,C_word *av) C_noret;
C_noret_decl(f_22490)
static void C_ccall f_22490(C_word c,C_word *av) C_noret;
C_noret_decl(f_22503)
static void f_22503(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_22524)
static void C_ccall f_22524(C_word c,C_word *av) C_noret;
C_noret_decl(f_22531)
static void C_ccall f_22531(C_word c,C_word *av) C_noret;
C_noret_decl(f_22536)
static void f_22536(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_22549)
static void C_ccall f_22549(C_word c,C_word *av) C_noret;
C_noret_decl(f_22563)
static void C_ccall f_22563(C_word c,C_word *av) C_noret;
C_noret_decl(f_22587)
static void C_ccall f_22587(C_word c,C_word *av) C_noret;
C_noret_decl(f_22593)
static void C_ccall f_22593(C_word c,C_word *av) C_noret;
C_noret_decl(f_22602)
static void C_ccall f_22602(C_word c,C_word *av) C_noret;
C_noret_decl(f_22605)
static void C_ccall f_22605(C_word c,C_word *av) C_noret;
C_noret_decl(f_22608)
static void C_ccall f_22608(C_word c,C_word *av) C_noret;
C_noret_decl(f_22622)
static void C_ccall f_22622(C_word c,C_word *av) C_noret;
C_noret_decl(f_22624)
static void C_ccall f_22624(C_word c,C_word *av) C_noret;
C_noret_decl(f_22634)
static void C_ccall f_22634(C_word c,C_word *av) C_noret;
C_noret_decl(f_22664)
static void C_ccall f_22664(C_word c,C_word *av) C_noret;
C_noret_decl(f_22681)
static void C_ccall f_22681(C_word c,C_word *av) C_noret;
C_noret_decl(f_22683)
static void C_ccall f_22683(C_word c,C_word *av) C_noret;
C_noret_decl(f_22693)
static void C_ccall f_22693(C_word c,C_word *av) C_noret;
C_noret_decl(f_22699)
static void C_ccall f_22699(C_word c,C_word *av) C_noret;
C_noret_decl(f_22721)
static void C_ccall f_22721(C_word c,C_word *av) C_noret;
C_noret_decl(f_22726)
static void C_ccall f_22726(C_word c,C_word *av) C_noret;
C_noret_decl(f_22731)
static C_word f_22731(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_22752)
static void C_ccall f_22752(C_word c,C_word *av) C_noret;
C_noret_decl(f_22777)
static void C_ccall f_22777(C_word c,C_word *av) C_noret;
C_noret_decl(f_22783)
static void f_22783(C_word t0,C_word t1) C_noret;
C_noret_decl(f_22789)
static void C_ccall f_22789(C_word c,C_word *av) C_noret;
C_noret_decl(f_22792)
static void C_ccall f_22792(C_word c,C_word *av) C_noret;
C_noret_decl(f_22833)
static void C_ccall f_22833(C_word c,C_word *av) C_noret;
C_noret_decl(f_22867)
static void f_22867(C_word t0,C_word t1) C_noret;
C_noret_decl(f_22870)
static void C_ccall f_22870(C_word c,C_word *av) C_noret;
C_noret_decl(f_22873)
static void C_ccall f_22873(C_word c,C_word *av) C_noret;
C_noret_decl(f_22876)
static void C_ccall f_22876(C_word c,C_word *av) C_noret;
C_noret_decl(f_22915)
static void C_ccall f_22915(C_word c,C_word *av) C_noret;
C_noret_decl(f_22921)
static void f_22921(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_22931)
static void C_ccall f_22931(C_word c,C_word *av) C_noret;
C_noret_decl(f_22936)
static C_word f_22936(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_22973)
static void C_ccall f_22973(C_word c,C_word *av) C_noret;
C_noret_decl(f_22980)
static void C_ccall f_22980(C_word c,C_word *av) C_noret;
C_noret_decl(f_23002)
static void C_ccall f_23002(C_word c,C_word *av) C_noret;
C_noret_decl(f_23018)
static void C_ccall f_23018(C_word c,C_word *av) C_noret;
C_noret_decl(f_23023)
static C_word f_23023(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_23054)
static void C_ccall f_23054(C_word c,C_word *av) C_noret;
C_noret_decl(f_23076)
static void C_ccall f_23076(C_word c,C_word *av) C_noret;
C_noret_decl(f_23079)
static void C_ccall f_23079(C_word c,C_word *av) C_noret;
C_noret_decl(f_23084)
static void f_23084(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_23102)
static void C_ccall f_23102(C_word c,C_word *av) C_noret;
C_noret_decl(f_23140)
static void C_ccall f_23140(C_word c,C_word *av) C_noret;
C_noret_decl(f_23146)
static void C_ccall f_23146(C_word c,C_word *av) C_noret;
C_noret_decl(f_23168)
static void C_ccall f_23168(C_word c,C_word *av) C_noret;
C_noret_decl(f_23171)
static void C_ccall f_23171(C_word c,C_word *av) C_noret;
C_noret_decl(f_23176)
static C_word f_23176(C_word t0,C_word t1);
C_noret_decl(f_23227)
static void C_ccall f_23227(C_word c,C_word *av) C_noret;
C_noret_decl(f_23244)
static void f_23244(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_23251)
static void C_ccall f_23251(C_word c,C_word *av) C_noret;
C_noret_decl(f_23254)
static void C_ccall f_23254(C_word c,C_word *av) C_noret;
C_noret_decl(f_23257)
static void C_ccall f_23257(C_word c,C_word *av) C_noret;
C_noret_decl(f_23262)
static C_word f_23262(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_23334)
static void C_ccall f_23334(C_word c,C_word *av) C_noret;
C_noret_decl(f_23354)
static void f_23354(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_23367)
static void C_ccall f_23367(C_word c,C_word *av) C_noret;
C_noret_decl(f_23370)
static void C_ccall f_23370(C_word c,C_word *av) C_noret;
C_noret_decl(f_23373)
static void C_ccall f_23373(C_word c,C_word *av) C_noret;
C_noret_decl(f_23376)
static void C_ccall f_23376(C_word c,C_word *av) C_noret;
C_noret_decl(f_23395)
static C_word f_23395(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_23429)
static C_word f_23429(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_23507)
static void C_ccall f_23507(C_word c,C_word *av) C_noret;
C_noret_decl(f_23522)
static void C_ccall f_23522(C_word c,C_word *av) C_noret;
C_noret_decl(f_23525)
static void C_ccall f_23525(C_word c,C_word *av) C_noret;
C_noret_decl(f_23530)
static void f_23530(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_23540)
static void C_ccall f_23540(C_word c,C_word *av) C_noret;
C_noret_decl(f_23570)
static C_word f_23570(C_word t0,C_word t1);
C_noret_decl(f_23594)
static void f_23594(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_23628)
static C_word f_23628(C_word t0);
C_noret_decl(f_23651)
static void C_ccall f_23651(C_word c,C_word *av) C_noret;
C_noret_decl(f_23670)
static void C_ccall f_23670(C_word c,C_word *av) C_noret;
C_noret_decl(f_23673)
static void C_ccall f_23673(C_word c,C_word *av) C_noret;
C_noret_decl(f_23676)
static void C_ccall f_23676(C_word c,C_word *av) C_noret;
C_noret_decl(f_23681)
static C_word f_23681(C_word t0,C_word t1);
C_noret_decl(f_23714)
static void C_ccall f_23714(C_word c,C_word *av) C_noret;
C_noret_decl(f_23735)
static void f_23735(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_23739)
static void C_ccall f_23739(C_word c,C_word *av) C_noret;
C_noret_decl(f_23742)
static void C_ccall f_23742(C_word c,C_word *av) C_noret;
C_noret_decl(f_23747)
static C_word f_23747(C_word t0,C_word t1);
C_noret_decl(f_23774)
static void C_ccall f_23774(C_word c,C_word *av) C_noret;
C_noret_decl(f_23790)
static void f_23790(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_23806)
static void C_ccall f_23806(C_word c,C_word *av) C_noret;
C_noret_decl(f_23823)
static void C_ccall f_23823(C_word c,C_word *av) C_noret;
C_noret_decl(f_23837)
static void f_23837(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_23853)
static void C_ccall f_23853(C_word c,C_word *av) C_noret;
C_noret_decl(f_23866)
static void C_ccall f_23866(C_word c,C_word *av) C_noret;
C_noret_decl(f_23880)
static void f_23880(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_23896)
static void C_ccall f_23896(C_word c,C_word *av) C_noret;
C_noret_decl(f_23909)
static void C_ccall f_23909(C_word c,C_word *av) C_noret;
C_noret_decl(f_23923)
static void f_23923(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_23939)
static void C_ccall f_23939(C_word c,C_word *av) C_noret;
C_noret_decl(f_23952)
static void C_ccall f_23952(C_word c,C_word *av) C_noret;
C_noret_decl(f_23966)
static void f_23966(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_23982)
static void C_ccall f_23982(C_word c,C_word *av) C_noret;
C_noret_decl(f_23997)
static void C_ccall f_23997(C_word c,C_word *av) C_noret;
C_noret_decl(f_23999)
static void f_23999(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24012)
static C_word f_24012(C_word t0,C_word t1);
C_noret_decl(f_24040)
static void C_ccall f_24040(C_word c,C_word *av) C_noret;
C_noret_decl(f_24053)
static void C_ccall f_24053(C_word c,C_word *av) C_noret;
C_noret_decl(f_24071)
static void C_ccall f_24071(C_word c,C_word *av) C_noret;
C_noret_decl(f_24074)
static void C_ccall f_24074(C_word c,C_word *av) C_noret;
C_noret_decl(f_24157)
static void C_ccall f_24157(C_word c,C_word *av) C_noret;
C_noret_decl(f_24160)
static void C_ccall f_24160(C_word c,C_word *av) C_noret;
C_noret_decl(f_24163)
static void C_ccall f_24163(C_word c,C_word *av) C_noret;
C_noret_decl(f_24166)
static void C_ccall f_24166(C_word c,C_word *av) C_noret;
C_noret_decl(f_24169)
static void C_ccall f_24169(C_word c,C_word *av) C_noret;
C_noret_decl(f_24172)
static void C_ccall f_24172(C_word c,C_word *av) C_noret;
C_noret_decl(f_24175)
static void C_ccall f_24175(C_word c,C_word *av) C_noret;
C_noret_decl(f_24178)
static void C_ccall f_24178(C_word c,C_word *av) C_noret;
C_noret_decl(f_24181)
static void C_ccall f_24181(C_word c,C_word *av) C_noret;
C_noret_decl(f_24184)
static void C_ccall f_24184(C_word c,C_word *av) C_noret;
C_noret_decl(f_24187)
static void C_ccall f_24187(C_word c,C_word *av) C_noret;
C_noret_decl(f_24190)
static void C_ccall f_24190(C_word c,C_word *av) C_noret;
C_noret_decl(f_24193)
static void C_ccall f_24193(C_word c,C_word *av) C_noret;
C_noret_decl(f_24196)
static void C_ccall f_24196(C_word c,C_word *av) C_noret;
C_noret_decl(f_24201)
static void C_ccall f_24201(C_word c,C_word *av) C_noret;
C_noret_decl(f_24207)
static void f_24207(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24223)
static void C_ccall f_24223(C_word c,C_word *av) C_noret;
C_noret_decl(f_24239)
static void C_ccall f_24239(C_word c,C_word *av) C_noret;
C_noret_decl(f_24245)
static void f_24245(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24265)
static void C_ccall f_24265(C_word c,C_word *av) C_noret;
C_noret_decl(f_24269)
static void C_ccall f_24269(C_word c,C_word *av) C_noret;
C_noret_decl(f_24281)
static void C_ccall f_24281(C_word c,C_word *av) C_noret;
C_noret_decl(f_24287)
static void C_ccall f_24287(C_word c,C_word *av) C_noret;
C_noret_decl(f_24293)
static void f_24293(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24325)
static void C_ccall f_24325(C_word c,C_word *av) C_noret;
C_noret_decl(f_24329)
static void C_ccall f_24329(C_word c,C_word *av) C_noret;
C_noret_decl(f_24339)
static void C_ccall f_24339(C_word c,C_word *av) C_noret;
C_noret_decl(f_24354)
static void f_24354(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24364)
static void C_ccall f_24364(C_word c,C_word *av) C_noret;
C_noret_decl(f_24384)
static void f_24384(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24391)
static void C_ccall f_24391(C_word c,C_word *av) C_noret;
C_noret_decl(f_24400)
static void C_ccall f_24400(C_word c,C_word *av) C_noret;
C_noret_decl(f_24407)
static void C_ccall f_24407(C_word c,C_word *av) C_noret;
C_noret_decl(f_24409)
static void C_ccall f_24409(C_word c,C_word *av) C_noret;
C_noret_decl(f_24415)
static void C_ccall f_24415(C_word c,C_word *av) C_noret;
C_noret_decl(f_24421)
static void C_ccall f_24421(C_word c,C_word *av) C_noret;
C_noret_decl(f_24439)
static void f_24439(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24464)
static void C_ccall f_24464(C_word c,C_word *av) C_noret;
C_noret_decl(f_24480)
static void f_24480(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24487)
static void C_ccall f_24487(C_word c,C_word *av) C_noret;
C_noret_decl(f_24500)
static void C_ccall f_24500(C_word c,C_word *av) C_noret;
C_noret_decl(f_24504)
static void C_ccall f_24504(C_word c,C_word *av) C_noret;
C_noret_decl(f_24508)
static void C_ccall f_24508(C_word c,C_word *av) C_noret;
C_noret_decl(f_24510)
static void C_ccall f_24510(C_word c,C_word *av) C_noret;
C_noret_decl(f_24516)
static void C_ccall f_24516(C_word c,C_word *av) C_noret;
C_noret_decl(f_24523)
static void C_ccall f_24523(C_word c,C_word *av) C_noret;
C_noret_decl(f_24527)
static void C_ccall f_24527(C_word c,C_word *av) C_noret;
C_noret_decl(f_24536)
static void C_ccall f_24536(C_word c,C_word *av) C_noret;
C_noret_decl(f_24544)
static void C_ccall f_24544(C_word c,C_word *av) C_noret;
C_noret_decl(f_24554)
static void C_ccall f_24554(C_word c,C_word *av) C_noret;
C_noret_decl(f_24560)
static void C_ccall f_24560(C_word c,C_word *av) C_noret;
C_noret_decl(f_24563)
static void C_ccall f_24563(C_word c,C_word *av) C_noret;
C_noret_decl(f_24567)
static void C_ccall f_24567(C_word c,C_word *av) C_noret;
C_noret_decl(f_24594)
static void f_24594(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24610)
static void C_ccall f_24610(C_word c,C_word *av) C_noret;
C_noret_decl(f_24616)
static void C_ccall f_24616(C_word c,C_word *av) C_noret;
C_noret_decl(f_24639)
static void C_ccall f_24639(C_word c,C_word *av) C_noret;
C_noret_decl(f_24652)
static void C_ccall f_24652(C_word c,C_word *av) C_noret;
C_noret_decl(f_24656)
static void C_ccall f_24656(C_word c,C_word *av) C_noret;
C_noret_decl(f_24665)
static void C_ccall f_24665(C_word c,C_word *av) C_noret;
C_noret_decl(f_24711)
static void C_ccall f_24711(C_word c,C_word *av) C_noret;
C_noret_decl(f_24715)
static void C_ccall f_24715(C_word c,C_word *av) C_noret;
C_noret_decl(f_24719)
static void C_ccall f_24719(C_word c,C_word *av) C_noret;
C_noret_decl(f_24722)
static void C_ccall f_24722(C_word c,C_word *av) C_noret;
C_noret_decl(f_24725)
static void C_ccall f_24725(C_word c,C_word *av) C_noret;
C_noret_decl(f_24728)
static void C_ccall f_24728(C_word c,C_word *av) C_noret;
C_noret_decl(f_24730)
static void C_ccall f_24730(C_word c,C_word *av) C_noret;
C_noret_decl(f_24741)
static void C_ccall f_24741(C_word c,C_word *av) C_noret;
C_noret_decl(f_24752)
static void C_ccall f_24752(C_word c,C_word *av) C_noret;
C_noret_decl(f_24763)
static void C_ccall f_24763(C_word c,C_word *av) C_noret;
C_noret_decl(f_24774)
static void C_ccall f_24774(C_word c,C_word *av) C_noret;
C_noret_decl(f_24787)
static void C_ccall f_24787(C_word c,C_word *av) C_noret;
C_noret_decl(f_24789)
static C_word f_24789(C_word t0,C_word t1);
C_noret_decl(f_24795)
static C_word f_24795(C_word t0);
C_noret_decl(f_24800)
static C_word f_24800(C_word t0);
C_noret_decl(f_24835)
static void C_ccall f_24835(C_word c,C_word *av) C_noret;
C_noret_decl(f_24848)
static void C_ccall f_24848(C_word c,C_word *av) C_noret;
C_noret_decl(f_24850)
static C_word f_24850(C_word t0,C_word t1);
C_noret_decl(f_24856)
static C_word f_24856(C_word t0);
C_noret_decl(f_24861)
static C_word f_24861(C_word t0);
C_noret_decl(f_24896)
static void C_ccall f_24896(C_word c,C_word *av) C_noret;
C_noret_decl(f_24909)
static void C_ccall f_24909(C_word c,C_word *av) C_noret;
C_noret_decl(f_24911)
static C_word f_24911(C_word t0,C_word t1);
C_noret_decl(f_24917)
static C_word f_24917(C_word t0);
C_noret_decl(f_24922)
static C_word f_24922(C_word t0);
C_noret_decl(f_24957)
static void C_ccall f_24957(C_word c,C_word *av) C_noret;
C_noret_decl(f_24969)
static void C_ccall f_24969(C_word c,C_word *av) C_noret;
C_noret_decl(f_24971)
static void C_ccall f_24971(C_word c,C_word *av) C_noret;
C_noret_decl(f_24977)
static void C_ccall f_24977(C_word c,C_word *av) C_noret;
C_noret_decl(f_24984)
static void f_24984(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_24994)
static void C_ccall f_24994(C_word c,C_word *av) C_noret;
C_noret_decl(f_24997)
static void C_ccall f_24997(C_word c,C_word *av) C_noret;
C_noret_decl(f_25000)
static void C_ccall f_25000(C_word c,C_word *av) C_noret;
C_noret_decl(f_25006)
static void C_ccall f_25006(C_word c,C_word *av) C_noret;
C_noret_decl(f_25009)
static void C_ccall f_25009(C_word c,C_word *av) C_noret;
C_noret_decl(f_25016)
static void C_ccall f_25016(C_word c,C_word *av) C_noret;
C_noret_decl(f_25020)
static void C_ccall f_25020(C_word c,C_word *av) C_noret;
C_noret_decl(f_25024)
static void C_ccall f_25024(C_word c,C_word *av) C_noret;
C_noret_decl(f_25028)
static void C_ccall f_25028(C_word c,C_word *av) C_noret;
C_noret_decl(f_25034)
static void f_25034(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_25047)
static void C_ccall f_25047(C_word c,C_word *av) C_noret;
C_noret_decl(f_25091)
static void f_25091(C_word t0,C_word t1) C_noret;
C_noret_decl(f_25101)
static void f_25101(C_word t0,C_word t1) C_noret;
C_noret_decl(f_25214)
static void f_25214(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_25218)
static void C_ccall f_25218(C_word c,C_word *av) C_noret;
C_noret_decl(f_25251)
static void C_ccall f_25251(C_word c,C_word *av) C_noret;
C_noret_decl(f_25257)
static void C_ccall f_25257(C_word c,C_word *av) C_noret;
C_noret_decl(f_25263)
static void C_ccall f_25263(C_word c,C_word *av) C_noret;
C_noret_decl(f_25269)
static void C_ccall f_25269(C_word c,C_word *av) C_noret;
C_noret_decl(f_25275)
static void C_ccall f_25275(C_word c,C_word *av) C_noret;
C_noret_decl(f_25279)
static void C_ccall f_25279(C_word c,C_word *av) C_noret;
C_noret_decl(f_25284)
static void C_ccall f_25284(C_word c,C_word *av) C_noret;
C_noret_decl(f_25290)
static void C_ccall f_25290(C_word c,C_word *av) C_noret;
C_noret_decl(f_25294)
static void C_ccall f_25294(C_word c,C_word *av) C_noret;
C_noret_decl(f_25299)
static void C_ccall f_25299(C_word c,C_word *av) C_noret;
C_noret_decl(f_25303)
static void C_ccall f_25303(C_word c,C_word *av) C_noret;
C_noret_decl(f_25308)
static void C_ccall f_25308(C_word c,C_word *av) C_noret;
C_noret_decl(f_25314)
static void C_ccall f_25314(C_word c,C_word *av) C_noret;
C_noret_decl(f_25318)
static void C_ccall f_25318(C_word c,C_word *av) C_noret;
C_noret_decl(f_25323)
static void C_ccall f_25323(C_word c,C_word *av) C_noret;
C_noret_decl(f_25327)
static void C_ccall f_25327(C_word c,C_word *av) C_noret;
C_noret_decl(f_25332)
static void C_ccall f_25332(C_word c,C_word *av) C_noret;
C_noret_decl(f_25337)
static void C_ccall f_25337(C_word c,C_word *av) C_noret;
C_noret_decl(f_25343)
static void C_ccall f_25343(C_word c,C_word *av) C_noret;
C_noret_decl(f_25347)
static void C_ccall f_25347(C_word c,C_word *av) C_noret;
C_noret_decl(f_25352)
static void C_ccall f_25352(C_word c,C_word *av) C_noret;
C_noret_decl(f_25357)
static void C_ccall f_25357(C_word c,C_word *av) C_noret;
C_noret_decl(f_25361)
static void C_ccall f_25361(C_word c,C_word *av) C_noret;
C_noret_decl(f_25366)
static void C_ccall f_25366(C_word c,C_word *av) C_noret;
C_noret_decl(f_25371)
static void C_ccall f_25371(C_word c,C_word *av) C_noret;
C_noret_decl(f_25377)
static void C_ccall f_25377(C_word c,C_word *av) C_noret;
C_noret_decl(f_25381)
static void C_ccall f_25381(C_word c,C_word *av) C_noret;
C_noret_decl(f_25386)
static void C_ccall f_25386(C_word c,C_word *av) C_noret;
C_noret_decl(f_25391)
static void C_ccall f_25391(C_word c,C_word *av) C_noret;
C_noret_decl(f_25396)
static void C_ccall f_25396(C_word c,C_word *av) C_noret;
C_noret_decl(f_25417)
static void C_ccall f_25417(C_word c,C_word *av) C_noret;
C_noret_decl(f_25424)
static void C_ccall f_25424(C_word c,C_word *av) C_noret;
C_noret_decl(f_25430)
static void C_ccall f_25430(C_word c,C_word *av) C_noret;
C_noret_decl(f_25448)
static void C_ccall f_25448(C_word c,C_word *av) C_noret;
C_noret_decl(f_25457)
static void C_ccall f_25457(C_word c,C_word *av) C_noret;
C_noret_decl(f_25470)
static void f_25470(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_25478)
static void C_ccall f_25478(C_word c,C_word *av) C_noret;
C_noret_decl(f_25483)
static void f_25483(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_25520)
static void C_ccall f_25520(C_word c,C_word *av) C_noret;
C_noret_decl(f_25532)
static void C_ccall f_25532(C_word c,C_word *av) C_noret;
C_noret_decl(f_25542)
static void f_25542(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_25558)
static void C_ccall f_25558(C_word c,C_word *av) C_noret;
C_noret_decl(f_25571)
static void C_ccall f_25571(C_word c,C_word *av) C_noret;
C_noret_decl(f_25581)
static void C_ccall f_25581(C_word c,C_word *av) C_noret;
C_noret_decl(f_25587)
static void C_ccall f_25587(C_word c,C_word *av) C_noret;
C_noret_decl(f_25600)
static void C_ccall f_25600(C_word c,C_word *av) C_noret;
C_noret_decl(f_25606)
static void C_ccall f_25606(C_word c,C_word *av) C_noret;
C_noret_decl(f_25613)
static void C_ccall f_25613(C_word c,C_word *av) C_noret;
C_noret_decl(f_25620)
static void C_ccall f_25620(C_word c,C_word *av) C_noret;
C_noret_decl(f_25624)
static void C_ccall f_25624(C_word c,C_word *av) C_noret;
C_noret_decl(f_25627)
static void C_ccall f_25627(C_word c,C_word *av) C_noret;
C_noret_decl(f_25637)
static void C_ccall f_25637(C_word c,C_word *av) C_noret;
C_noret_decl(f_25641)
static void C_ccall f_25641(C_word c,C_word *av) C_noret;
C_noret_decl(f_25649)
static void C_ccall f_25649(C_word c,C_word *av) C_noret;
C_noret_decl(f_25652)
static void C_ccall f_25652(C_word c,C_word *av) C_noret;
C_noret_decl(f_25659)
static void C_ccall f_25659(C_word c,C_word *av) C_noret;
C_noret_decl(f_25662)
static void C_ccall f_25662(C_word c,C_word *av) C_noret;
C_noret_decl(f_25665)
static void C_ccall f_25665(C_word c,C_word *av) C_noret;
C_noret_decl(f_25668)
static void C_ccall f_25668(C_word c,C_word *av) C_noret;
C_noret_decl(f_25676)
static void C_ccall f_25676(C_word c,C_word *av) C_noret;
C_noret_decl(f_25684)
static void C_ccall f_25684(C_word c,C_word *av) C_noret;
C_noret_decl(f_25686)
static void C_ccall f_25686(C_word c,C_word *av) C_noret;
C_noret_decl(f_25702)
static void C_ccall f_25702(C_word c,C_word *av) C_noret;
C_noret_decl(f_25729)
static void C_ccall f_25729(C_word c,C_word *av) C_noret;
C_noret_decl(f_25733)
static void C_ccall f_25733(C_word c,C_word *av) C_noret;
C_noret_decl(f_25737)
static void C_ccall f_25737(C_word c,C_word *av) C_noret;
C_noret_decl(f_25741)
static void C_ccall f_25741(C_word c,C_word *av) C_noret;
C_noret_decl(f_25745)
static void C_ccall f_25745(C_word c,C_word *av) C_noret;
C_noret_decl(f_25749)
static void C_ccall f_25749(C_word c,C_word *av) C_noret;
C_noret_decl(f_25753)
static void C_ccall f_25753(C_word c,C_word *av) C_noret;
C_noret_decl(f_25757)
static void C_ccall f_25757(C_word c,C_word *av) C_noret;
C_noret_decl(f_25761)
static void C_ccall f_25761(C_word c,C_word *av) C_noret;
C_noret_decl(f_25765)
static void C_ccall f_25765(C_word c,C_word *av) C_noret;
C_noret_decl(f_25769)
static void C_ccall f_25769(C_word c,C_word *av) C_noret;
C_noret_decl(f_25773)
static void C_ccall f_25773(C_word c,C_word *av) C_noret;
C_noret_decl(f_25777)
static void C_ccall f_25777(C_word c,C_word *av) C_noret;
C_noret_decl(f_25781)
static void C_ccall f_25781(C_word c,C_word *av) C_noret;
C_noret_decl(f_25785)
static void C_ccall f_25785(C_word c,C_word *av) C_noret;
C_noret_decl(f_25789)
static void C_ccall f_25789(C_word c,C_word *av) C_noret;
C_noret_decl(f_25793)
static void C_ccall f_25793(C_word c,C_word *av) C_noret;
C_noret_decl(f_25797)
static void C_ccall f_25797(C_word c,C_word *av) C_noret;
C_noret_decl(f_25804)
static void C_ccall f_25804(C_word c,C_word *av) C_noret;
C_noret_decl(f_25811)
static void C_ccall f_25811(C_word c,C_word *av) C_noret;
C_noret_decl(f_25812)
static void f_25812(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_25816)
static void f_25816(C_word t0,C_word t1) C_noret;
C_noret_decl(f_25819)
static void C_ccall f_25819(C_word c,C_word *av) C_noret;
C_noret_decl(f_25835)
static void C_ccall f_25835(C_word c,C_word *av) C_noret;
C_noret_decl(f_25846)
static void f_25846(C_word t0,C_word t1) C_noret;
C_noret_decl(f_25854)
static void C_ccall f_25854(C_word c,C_word *av) C_noret;
C_noret_decl(f_25866)
static void f_25866(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_25875)
static void f_25875(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_25880)
static void f_25880(C_word t0,C_word t1) C_noret;
C_noret_decl(f_25936)
static void C_ccall f_25936(C_word c,C_word *av) C_noret;
C_noret_decl(f_25950)
static void C_ccall f_25950(C_word c,C_word *av) C_noret;
C_noret_decl(f_25962)
static void C_ccall f_25962(C_word c,C_word *av) C_noret;
C_noret_decl(f_25968)
static void C_ccall f_25968(C_word c,C_word *av) C_noret;
C_noret_decl(f_25993)
static void C_ccall f_25993(C_word c,C_word *av) C_noret;
C_noret_decl(f_26011)
static void C_ccall f_26011(C_word c,C_word *av) C_noret;
C_noret_decl(f_26015)
static void C_ccall f_26015(C_word c,C_word *av) C_noret;
C_noret_decl(f_26071)
static void C_ccall f_26071(C_word c,C_word *av) C_noret;
C_noret_decl(f_26080)
static void C_ccall f_26080(C_word c,C_word *av) C_noret;
C_noret_decl(f_26093)
static void C_ccall f_26093(C_word c,C_word *av) C_noret;
C_noret_decl(f_26105)
static void C_ccall f_26105(C_word c,C_word *av) C_noret;
C_noret_decl(f_26123)
static void C_ccall f_26123(C_word c,C_word *av) C_noret;
C_noret_decl(f_26143)
static void C_ccall f_26143(C_word c,C_word *av) C_noret;
C_noret_decl(f_26146)
static void C_ccall f_26146(C_word c,C_word *av) C_noret;
C_noret_decl(f_26151)
static void C_ccall f_26151(C_word c,C_word *av) C_noret;
C_noret_decl(f_26153)
static void C_ccall f_26153(C_word c,C_word *av) C_noret;
C_noret_decl(f_26161)
static void C_ccall f_26161(C_word c,C_word *av) C_noret;
C_noret_decl(f_26165)
static void C_ccall f_26165(C_word c,C_word *av) C_noret;
C_noret_decl(f_26169)
static void C_ccall f_26169(C_word c,C_word *av) C_noret;
C_noret_decl(f_26173)
static void C_ccall f_26173(C_word c,C_word *av) C_noret;
C_noret_decl(f_26177)
static void C_ccall f_26177(C_word c,C_word *av) C_noret;
C_noret_decl(f_26179)
static void C_ccall f_26179(C_word c,C_word *av) C_noret;
C_noret_decl(f_26187)
static void C_ccall f_26187(C_word c,C_word *av) C_noret;
C_noret_decl(f_26190)
static void C_ccall f_26190(C_word c,C_word *av) C_noret;
C_noret_decl(f_26200)
static void C_ccall f_26200(C_word c,C_word *av) C_noret;
C_noret_decl(f_26202)
static void C_ccall f_26202(C_word c,C_word *av) C_noret;
C_noret_decl(f_26210)
static void C_ccall f_26210(C_word c,C_word *av) C_noret;
C_noret_decl(f_26213)
static void C_ccall f_26213(C_word c,C_word *av) C_noret;
C_noret_decl(f_26223)
static void C_ccall f_26223(C_word c,C_word *av) C_noret;
C_noret_decl(f_26225)
static void C_ccall f_26225(C_word c,C_word *av) C_noret;
C_noret_decl(f_26232)
static void C_ccall f_26232(C_word c,C_word *av) C_noret;
C_noret_decl(f_26235)
static void C_ccall f_26235(C_word c,C_word *av) C_noret;
C_noret_decl(f_26238)
static void C_ccall f_26238(C_word c,C_word *av) C_noret;
C_noret_decl(f_26241)
static void C_ccall f_26241(C_word c,C_word *av) C_noret;
C_noret_decl(f_26243)
static void C_ccall f_26243(C_word c,C_word *av) C_noret;
C_noret_decl(f_26249)
static void f_26249(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_26258)
static void f_26258(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26266)
static void C_ccall f_26266(C_word c,C_word *av) C_noret;
C_noret_decl(f_26268)
static void f_26268(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26282)
static void C_ccall f_26282(C_word c,C_word *av) C_noret;
C_noret_decl(f_26295)
static void f_26295(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26299)
static void C_ccall f_26299(C_word c,C_word *av) C_noret;
C_noret_decl(f_26304)
static void f_26304(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26308)
static void C_ccall f_26308(C_word c,C_word *av) C_noret;
C_noret_decl(f_26319)
static C_word f_26319(C_word *a,C_word t0,C_word t1,C_word t2);
C_noret_decl(f_26330)
static void f_26330(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_26334)
static void C_ccall f_26334(C_word c,C_word *av) C_noret;
C_noret_decl(f_26358)
static void f_26358(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_26364)
static void f_26364(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26374)
static void C_ccall f_26374(C_word c,C_word *av) C_noret;
C_noret_decl(f_26393)
static void C_ccall f_26393(C_word c,C_word *av) C_noret;
C_noret_decl(f_26417)
static void C_ccall f_26417(C_word c,C_word *av) C_noret;
C_noret_decl(f_26439)
static void f_26439(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26452)
static void C_ccall f_26452(C_word c,C_word *av) C_noret;
C_noret_decl(f_26472)
static void C_ccall f_26472(C_word c,C_word *av) C_noret;
C_noret_decl(f_26478)
static void f_26478(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26481)
static void f_26481(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26489)
static void C_ccall f_26489(C_word c,C_word *av) C_noret;
C_noret_decl(f_26491)
static void f_26491(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26504)
static void C_ccall f_26504(C_word c,C_word *av) C_noret;
C_noret_decl(f_26511)
static void C_ccall f_26511(C_word c,C_word *av) C_noret;
C_noret_decl(f_26520)
static void C_ccall f_26520(C_word c,C_word *av) C_noret;
C_noret_decl(f_26527)
static void C_ccall f_26527(C_word c,C_word *av) C_noret;
C_noret_decl(f_26529)
static void f_26529(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_26535)
static void f_26535(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_26545)
static void C_ccall f_26545(C_word c,C_word *av) C_noret;
C_noret_decl(f_26548)
static void C_ccall f_26548(C_word c,C_word *av) C_noret;
C_noret_decl(f_26558)
static void C_ccall f_26558(C_word c,C_word *av) C_noret;
C_noret_decl(f_26561)
static void C_ccall f_26561(C_word c,C_word *av) C_noret;
C_noret_decl(f_26589)
static void f_26589(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26592)
static void f_26592(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26596)
static void C_ccall f_26596(C_word c,C_word *av) C_noret;
C_noret_decl(f_26599)
static void C_ccall f_26599(C_word c,C_word *av) C_noret;
C_noret_decl(f_26609)
static void C_ccall f_26609(C_word c,C_word *av) C_noret;
C_noret_decl(f_26611)
static C_word f_26611(C_word t0);
C_noret_decl(f_26615)
static void f_26615(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26624)
static void f_26624(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26628)
static void C_ccall f_26628(C_word c,C_word *av) C_noret;
C_noret_decl(f_26646)
static void C_ccall f_26646(C_word c,C_word *av) C_noret;
C_noret_decl(f_26667)
static void C_ccall f_26667(C_word c,C_word *av) C_noret;
C_noret_decl(f_26679)
static void f_26679(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26690)
static void C_ccall f_26690(C_word c,C_word *av) C_noret;
C_noret_decl(f_26693)
static void C_ccall f_26693(C_word c,C_word *av) C_noret;
C_noret_decl(f_26729)
static void f_26729(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26737)
static void C_ccall f_26737(C_word c,C_word *av) C_noret;
C_noret_decl(f_26739)
static void f_26739(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_26756)
static void C_ccall f_26756(C_word c,C_word *av) C_noret;
C_noret_decl(f_26769)
static void C_ccall f_26769(C_word c,C_word *av) C_noret;
C_noret_decl(f_26786)
static void C_ccall f_26786(C_word c,C_word *av) C_noret;
C_noret_decl(f_26803)
static void C_ccall f_26803(C_word c,C_word *av) C_noret;
C_noret_decl(f_26820)
static void C_ccall f_26820(C_word c,C_word *av) C_noret;
C_noret_decl(f_26837)
static void C_ccall f_26837(C_word c,C_word *av) C_noret;
C_noret_decl(f_26854)
static void C_ccall f_26854(C_word c,C_word *av) C_noret;
C_noret_decl(f_26871)
static void C_ccall f_26871(C_word c,C_word *av) C_noret;
C_noret_decl(f_26891)
static void C_ccall f_26891(C_word c,C_word *av) C_noret;
C_noret_decl(f_26899)
static void C_ccall f_26899(C_word c,C_word *av) C_noret;
C_noret_decl(f_26908)
static void C_ccall f_26908(C_word c,C_word *av) C_noret;
C_noret_decl(f_26915)
static void C_ccall f_26915(C_word c,C_word *av) C_noret;
C_noret_decl(f_26932)
static void C_ccall f_26932(C_word c,C_word *av) C_noret;
C_noret_decl(f_26939)
static void C_ccall f_26939(C_word c,C_word *av) C_noret;
C_noret_decl(f_26956)
static void f_26956(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26963)
static void C_ccall f_26963(C_word c,C_word *av) C_noret;
C_noret_decl(f_26976)
static void f_26976(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26981)
static void f_26981(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_26998)
static void C_ccall f_26998(C_word c,C_word *av) C_noret;
C_noret_decl(f_27013)
static void C_ccall f_27013(C_word c,C_word *av) C_noret;
C_noret_decl(f_27026)
static void C_ccall f_27026(C_word c,C_word *av) C_noret;
C_noret_decl(f_27048)
static void C_ccall f_27048(C_word c,C_word *av) C_noret;
C_noret_decl(f_27051)
static void C_ccall f_27051(C_word c,C_word *av) C_noret;
C_noret_decl(f_27080)
static void f_27080(C_word t0,C_word t1) C_noret;
C_noret_decl(f_27090)
static void C_ccall f_27090(C_word c,C_word *av) C_noret;
C_noret_decl(f_27106)
static void C_ccall f_27106(C_word c,C_word *av) C_noret;
C_noret_decl(f_27117)
static void C_ccall f_27117(C_word c,C_word *av) C_noret;
C_noret_decl(f_27124)
static void C_ccall f_27124(C_word c,C_word *av) C_noret;
C_noret_decl(f_27222)
static void C_ccall f_27222(C_word c,C_word *av) C_noret;
C_noret_decl(f_27228)
static void f_27228(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_27237)
static void f_27237(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27251)
static void C_ccall f_27251(C_word c,C_word *av) C_noret;
C_noret_decl(f_27254)
static void C_ccall f_27254(C_word c,C_word *av) C_noret;
C_noret_decl(f_27265)
static void C_ccall f_27265(C_word c,C_word *av) C_noret;
C_noret_decl(f_27267)
static void C_ccall f_27267(C_word c,C_word *av) C_noret;
C_noret_decl(f_27270)
static void C_ccall f_27270(C_word c,C_word *av) C_noret;
C_noret_decl(f_27287)
static void C_ccall f_27287(C_word c,C_word *av) C_noret;
C_noret_decl(f_27292)
static void f_27292(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27296)
static void C_ccall f_27296(C_word c,C_word *av) C_noret;
C_noret_decl(f_27299)
static void f_27299(C_word t0,C_word t1) C_noret;
C_noret_decl(f_27302)
static void C_ccall f_27302(C_word c,C_word *av) C_noret;
C_noret_decl(f_27312)
static void C_ccall f_27312(C_word c,C_word *av) C_noret;
C_noret_decl(f_27330)
static void C_ccall f_27330(C_word c,C_word *av) C_noret;
C_noret_decl(f_27333)
static void C_ccall f_27333(C_word c,C_word *av) C_noret;
C_noret_decl(f_27342)
static void f_27342(C_word t0,C_word t1) C_noret;
C_noret_decl(f_27345)
static void C_ccall f_27345(C_word c,C_word *av) C_noret;
C_noret_decl(f_27348)
static void C_ccall f_27348(C_word c,C_word *av) C_noret;
C_noret_decl(f_27354)
static void C_ccall f_27354(C_word c,C_word *av) C_noret;
C_noret_decl(f_27367)
static void C_ccall f_27367(C_word c,C_word *av) C_noret;
C_noret_decl(f_27371)
static void C_ccall f_27371(C_word c,C_word *av) C_noret;
C_noret_decl(f_27375)
static void C_ccall f_27375(C_word c,C_word *av) C_noret;
C_noret_decl(f_27386)
static void C_ccall f_27386(C_word c,C_word *av) C_noret;
C_noret_decl(f_27390)
static void C_ccall f_27390(C_word c,C_word *av) C_noret;
C_noret_decl(f_27393)
static void C_ccall f_27393(C_word c,C_word *av) C_noret;
C_noret_decl(f_27421)
static void C_ccall f_27421(C_word c,C_word *av) C_noret;
C_noret_decl(f_27476)
static void C_ccall f_27476(C_word c,C_word *av) C_noret;
C_noret_decl(f_27480)
static void C_ccall f_27480(C_word c,C_word *av) C_noret;
C_noret_decl(f_27487)
static void C_ccall f_27487(C_word c,C_word *av) C_noret;
C_noret_decl(f_27489)
static void f_27489(C_word t0,C_word t1) C_noret;
C_noret_decl(f_27493)
static void C_ccall f_27493(C_word c,C_word *av) C_noret;
C_noret_decl(f_27507)
static void f_27507(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_27513)
static void C_ccall f_27513(C_word c,C_word *av) C_noret;
C_noret_decl(f_27520)
static void C_ccall f_27520(C_word c,C_word *av) C_noret;
C_noret_decl(f_27527)
static void C_ccall f_27527(C_word c,C_word *av) C_noret;
C_noret_decl(f_27547)
static void C_ccall f_27547(C_word c,C_word *av) C_noret;
C_noret_decl(f_27576)
static void f_27576(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27586)
static void C_ccall f_27586(C_word c,C_word *av) C_noret;
C_noret_decl(f_27589)
static void C_ccall f_27589(C_word c,C_word *av) C_noret;
C_noret_decl(f_27625)
static void C_ccall f_27625(C_word c,C_word *av) C_noret;
C_noret_decl(f_27627)
static void f_27627(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27637)
static void C_ccall f_27637(C_word c,C_word *av) C_noret;
C_noret_decl(f_27640)
static void C_ccall f_27640(C_word c,C_word *av) C_noret;
C_noret_decl(f_27692)
static void C_ccall f_27692(C_word c,C_word *av) C_noret;
C_noret_decl(f_27694)
static void f_27694(C_word t0,C_word t1) C_noret;
C_noret_decl(f_27702)
static void C_ccall f_27702(C_word c,C_word *av) C_noret;
C_noret_decl(f_27704)
static void f_27704(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_27714)
static void f_27714(C_word t0,C_word t1) C_noret;
C_noret_decl(f_27729)
static void C_ccall f_27729(C_word c,C_word *av) C_noret;
C_noret_decl(f_27736)
static void C_ccall f_27736(C_word c,C_word *av) C_noret;
C_noret_decl(f_27755)
static void f_27755(C_word t0,C_word t1) C_noret;
C_noret_decl(f_27763)
static void C_ccall f_27763(C_word c,C_word *av) C_noret;
C_noret_decl(f_27765)
static void f_27765(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_27781)
static void C_ccall f_27781(C_word c,C_word *av) C_noret;
C_noret_decl(f_27788)
static void C_ccall f_27788(C_word c,C_word *av) C_noret;
C_noret_decl(f_27801)
static void f_27801(C_word t0,C_word t1) C_noret;
C_noret_decl(f_27807)
static void C_ccall f_27807(C_word c,C_word *av) C_noret;
C_noret_decl(f_27811)
static void C_ccall f_27811(C_word c,C_word *av) C_noret;
C_noret_decl(f_27818)
static void C_ccall f_27818(C_word c,C_word *av) C_noret;
C_noret_decl(f_27826)
static void f_27826(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27831)
static void f_27831(C_word t0,C_word t1) C_noret;
C_noret_decl(f_27836)
static void f_27836(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_27840)
static void C_ccall f_27840(C_word c,C_word *av) C_noret;
C_noret_decl(f_27849)
static void f_27849(C_word t0,C_word t1) C_noret;
C_noret_decl(f_27855)
static void f_27855(C_word t0,C_word t1) C_noret;
C_noret_decl(f_27862)
static void C_ccall f_27862(C_word c,C_word *av) C_noret;
C_noret_decl(f_27879)
static void C_ccall f_27879(C_word c,C_word *av) C_noret;
C_noret_decl(f_27885)
static void f_27885(C_word t0,C_word t1) C_noret;
C_noret_decl(f_27895)
static void C_ccall f_27895(C_word c,C_word *av) C_noret;
C_noret_decl(f_27946)
static void C_ccall f_27946(C_word c,C_word *av) C_noret;
C_noret_decl(f_27955)
static void C_ccall f_27955(C_word c,C_word *av) C_noret;
C_noret_decl(f_27962)
static void C_ccall f_27962(C_word c,C_word *av) C_noret;
C_noret_decl(f_27966)
static void C_ccall f_27966(C_word c,C_word *av) C_noret;
C_noret_decl(f_27970)
static void C_ccall f_27970(C_word c,C_word *av) C_noret;
C_noret_decl(f_27979)
static void C_ccall f_27979(C_word c,C_word *av) C_noret;
C_noret_decl(f_27990)
static void C_ccall f_27990(C_word c,C_word *av) C_noret;
C_noret_decl(f_28012)
static void C_ccall f_28012(C_word c,C_word *av) C_noret;
C_noret_decl(f_28068)
static void C_ccall f_28068(C_word c,C_word *av) C_noret;
C_noret_decl(f_28072)
static void C_ccall f_28072(C_word c,C_word *av) C_noret;
C_noret_decl(f_28074)
static void f_28074(C_word t0,C_word t1) C_noret;
C_noret_decl(f_28078)
static void C_ccall f_28078(C_word c,C_word *av) C_noret;
C_noret_decl(f_28081)
static void C_ccall f_28081(C_word c,C_word *av) C_noret;
C_noret_decl(f_28093)
static void C_ccall f_28093(C_word c,C_word *av) C_noret;
C_noret_decl(f_28113)
static void f_28113(C_word t0,C_word t1) C_noret;
C_noret_decl(f_28119)
static void C_ccall f_28119(C_word c,C_word *av) C_noret;
C_noret_decl(f_28129)
static void C_ccall f_28129(C_word c,C_word *av) C_noret;
C_noret_decl(f_28266)
static void f_28266(C_word t0,C_word t1) C_noret;
C_noret_decl(f_28273)
static void C_ccall f_28273(C_word c,C_word *av) C_noret;
C_noret_decl(f_28291)
static void f_28291(C_word t0,C_word t1) C_noret;
C_noret_decl(f_28297)
static void f_28297(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_28301)
static void C_ccall f_28301(C_word c,C_word *av) C_noret;
C_noret_decl(f_28337)
static void C_ccall f_28337(C_word c,C_word *av) C_noret;
C_noret_decl(f_28360)
static void C_ccall f_28360(C_word c,C_word *av) C_noret;
C_noret_decl(f_28378)
static void f_28378(C_word t0,C_word t1) C_noret;
C_noret_decl(f_28382)
static void C_ccall f_28382(C_word c,C_word *av) C_noret;
C_noret_decl(f_28389)
static void C_ccall f_28389(C_word c,C_word *av) C_noret;
C_noret_decl(f_28391)
static void f_28391(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_28395)
static void C_ccall f_28395(C_word c,C_word *av) C_noret;
C_noret_decl(f_28406)
static void C_ccall f_28406(C_word c,C_word *av) C_noret;
C_noret_decl(f_28426)
static void C_ccall f_28426(C_word c,C_word *av) C_noret;
C_noret_decl(f_28429)
static void C_ccall f_28429(C_word c,C_word *av) C_noret;
C_noret_decl(f_28432)
static void C_ccall f_28432(C_word c,C_word *av) C_noret;
C_noret_decl(f_28446)
static void C_ccall f_28446(C_word c,C_word *av) C_noret;
C_noret_decl(f_28452)
static void C_ccall f_28452(C_word c,C_word *av) C_noret;
C_noret_decl(f_28474)
static void C_ccall f_28474(C_word c,C_word *av) C_noret;
C_noret_decl(f_28486)
static void C_ccall f_28486(C_word c,C_word *av) C_noret;
C_noret_decl(f_28498)
static void C_ccall f_28498(C_word c,C_word *av) C_noret;
C_noret_decl(f_28507)
static void C_ccall f_28507(C_word c,C_word *av) C_noret;
C_noret_decl(f_28517)
static void C_ccall f_28517(C_word c,C_word *av) C_noret;
C_noret_decl(f_28526)
static void C_ccall f_28526(C_word c,C_word *av) C_noret;
C_noret_decl(f_28529)
static void C_ccall f_28529(C_word c,C_word *av) C_noret;
C_noret_decl(f_28547)
static void C_ccall f_28547(C_word c,C_word *av) C_noret;
C_noret_decl(f_28550)
static void C_ccall f_28550(C_word c,C_word *av) C_noret;
C_noret_decl(f_28571)
static void C_ccall f_28571(C_word c,C_word *av) C_noret;
C_noret_decl(f_28577)
static void C_ccall f_28577(C_word c,C_word *av) C_noret;
C_noret_decl(f_28580)
static void C_ccall f_28580(C_word c,C_word *av) C_noret;
C_noret_decl(f_28590)
static void C_ccall f_28590(C_word c,C_word *av) C_noret;
C_noret_decl(f_28609)
static void f_28609(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_28617)
static void C_ccall f_28617(C_word c,C_word *av) C_noret;
C_noret_decl(f_28619)
static void C_ccall f_28619(C_word c,C_word *av) C_noret;
C_noret_decl(f_28625)
static void C_ccall f_28625(C_word c,C_word *av) C_noret;
C_noret_decl(f_28656)
static void C_ccall f_28656(C_word c,C_word *av) C_noret;
C_noret_decl(f_28679)
static void C_ccall f_28679(C_word c,C_word *av) C_noret;
C_noret_decl(f_28693)
static void C_ccall f_28693(C_word c,C_word *av) C_noret;
C_noret_decl(f_28699)
static void C_ccall f_28699(C_word c,C_word *av) C_noret;
C_noret_decl(f_28724)
static void C_ccall f_28724(C_word c,C_word *av) C_noret;
C_noret_decl(f_28736)
static void C_ccall f_28736(C_word c,C_word *av) C_noret;
C_noret_decl(f_28748)
static void C_ccall f_28748(C_word c,C_word *av) C_noret;
C_noret_decl(f_28760)
static void C_ccall f_28760(C_word c,C_word *av) C_noret;
C_noret_decl(f_28772)
static void C_ccall f_28772(C_word c,C_word *av) C_noret;
C_noret_decl(f_28784)
static void C_ccall f_28784(C_word c,C_word *av) C_noret;
C_noret_decl(f_28805)
static void C_ccall f_28805(C_word c,C_word *av) C_noret;
C_noret_decl(f_28817)
static void C_ccall f_28817(C_word c,C_word *av) C_noret;
C_noret_decl(f_28820)
static void C_ccall f_28820(C_word c,C_word *av) C_noret;
C_noret_decl(f_28832)
static void C_ccall f_28832(C_word c,C_word *av) C_noret;
C_noret_decl(f_28844)
static void C_ccall f_28844(C_word c,C_word *av) C_noret;
C_noret_decl(f_28847)
static void C_ccall f_28847(C_word c,C_word *av) C_noret;
C_noret_decl(f_28859)
static void C_ccall f_28859(C_word c,C_word *av) C_noret;
C_noret_decl(f_28871)
static void C_ccall f_28871(C_word c,C_word *av) C_noret;
C_noret_decl(f_28883)
static void C_ccall f_28883(C_word c,C_word *av) C_noret;
C_noret_decl(f_28886)
static void C_ccall f_28886(C_word c,C_word *av) C_noret;
C_noret_decl(f_28891)
static void C_ccall f_28891(C_word c,C_word *av) C_noret;
C_noret_decl(f_28896)
static void C_ccall f_28896(C_word c,C_word *av) C_noret;
C_noret_decl(f_28902)
static void C_ccall f_28902(C_word c,C_word *av) C_noret;
C_noret_decl(f_28931)
static void C_ccall f_28931(C_word c,C_word *av) C_noret;
C_noret_decl(f_28943)
static void C_ccall f_28943(C_word c,C_word *av) C_noret;
C_noret_decl(f_28946)
static void C_ccall f_28946(C_word c,C_word *av) C_noret;
C_noret_decl(f_28949)
static void C_ccall f_28949(C_word c,C_word *av) C_noret;
C_noret_decl(f_28964)
static void C_ccall f_28964(C_word c,C_word *av) C_noret;
C_noret_decl(f_28973)
static void C_ccall f_28973(C_word c,C_word *av) C_noret;
C_noret_decl(f_28976)
static void C_ccall f_28976(C_word c,C_word *av) C_noret;
C_noret_decl(f_28982)
static void f_28982(C_word t0,C_word t1) C_noret;
C_noret_decl(f_28985)
static void C_ccall f_28985(C_word c,C_word *av) C_noret;
C_noret_decl(f_28991)
static void C_ccall f_28991(C_word c,C_word *av) C_noret;
C_noret_decl(f_29038)
static void C_ccall f_29038(C_word c,C_word *av) C_noret;
C_noret_decl(f_29057)
static void C_ccall f_29057(C_word c,C_word *av) C_noret;
C_noret_decl(f_29073)
static void C_ccall f_29073(C_word c,C_word *av) C_noret;
C_noret_decl(f_29079)
static void C_ccall f_29079(C_word c,C_word *av) C_noret;
C_noret_decl(f_29149)
static void C_ccall f_29149(C_word c,C_word *av) C_noret;
C_noret_decl(f_29161)
static void C_ccall f_29161(C_word c,C_word *av) C_noret;
C_noret_decl(f_29239)
static void C_ccall f_29239(C_word c,C_word *av) C_noret;
C_noret_decl(f_29313)
static void C_ccall f_29313(C_word c,C_word *av) C_noret;
C_noret_decl(f_29316)
static void C_ccall f_29316(C_word c,C_word *av) C_noret;
C_noret_decl(f_29319)
static void C_ccall f_29319(C_word c,C_word *av) C_noret;
C_noret_decl(f_29327)
static void C_ccall f_29327(C_word c,C_word *av) C_noret;
C_noret_decl(f_29337)
static void C_ccall f_29337(C_word c,C_word *av) C_noret;
C_noret_decl(f_29342)
static void C_ccall f_29342(C_word c,C_word *av) C_noret;
C_noret_decl(f_29345)
static void f_29345(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_29358)
static void f_29358(C_word t0,C_word t1) C_noret;
C_noret_decl(f_29361)
static void C_ccall f_29361(C_word c,C_word *av) C_noret;
C_noret_decl(f_29397)
static void C_ccall f_29397(C_word c,C_word *av) C_noret;
C_noret_decl(f_29413)
static void C_ccall f_29413(C_word c,C_word *av) C_noret;
C_noret_decl(f_29463)
static void C_ccall f_29463(C_word c,C_word *av) C_noret;
C_noret_decl(f_29467)
static void C_ccall f_29467(C_word c,C_word *av) C_noret;
C_noret_decl(f_29494)
static void C_ccall f_29494(C_word c,C_word *av) C_noret;
C_noret_decl(f_29500)
static void f_29500(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_29516)
static void f_29516(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_29556)
static void C_ccall f_29556(C_word c,C_word *av) C_noret;
C_noret_decl(f_29558)
static void f_29558(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_29565)
static void f_29565(C_word t0,C_word t1) C_noret;
C_noret_decl(f_29622)
static void C_ccall f_29622(C_word c,C_word *av) C_noret;
C_noret_decl(f_29629)
static void C_ccall f_29629(C_word c,C_word *av) C_noret;
C_noret_decl(f_29638)
static void C_ccall f_29638(C_word c,C_word *av) C_noret;
C_noret_decl(f_29650)
static void C_ccall f_29650(C_word c,C_word *av) C_noret;
C_noret_decl(f_29671)
static void C_ccall f_29671(C_word c,C_word *av) C_noret;
C_noret_decl(f_29686)
static void C_ccall f_29686(C_word c,C_word *av) C_noret;
C_noret_decl(f_29704)
static void C_ccall f_29704(C_word c,C_word *av) C_noret;
C_noret_decl(f_29722)
static void C_ccall f_29722(C_word c,C_word *av) C_noret;
C_noret_decl(f_29741)
static void f_29741(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_29751)
static void C_ccall f_29751(C_word c,C_word *av) C_noret;
C_noret_decl(f_29765)
static void C_ccall f_29765(C_word c,C_word *av) C_noret;
C_noret_decl(f_29768)
static void C_ccall f_29768(C_word c,C_word *av) C_noret;
C_noret_decl(f_29773)
static void C_ccall f_29773(C_word c,C_word *av) C_noret;
C_noret_decl(f_29792)
static void f_29792(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_29802)
static void C_ccall f_29802(C_word c,C_word *av) C_noret;
C_noret_decl(f_29816)
static void C_ccall f_29816(C_word c,C_word *av) C_noret;
C_noret_decl(f_29819)
static void C_ccall f_29819(C_word c,C_word *av) C_noret;
C_noret_decl(f_29826)
static void C_ccall f_29826(C_word c,C_word *av) C_noret;
C_noret_decl(f_29830)
static void C_ccall f_29830(C_word c,C_word *av) C_noret;
C_noret_decl(f_29834)
static void C_ccall f_29834(C_word c,C_word *av) C_noret;
C_noret_decl(f_29836)
static void C_ccall f_29836(C_word c,C_word *av) C_noret;
C_noret_decl(f_29843)
static void C_ccall f_29843(C_word c,C_word *av) C_noret;
C_noret_decl(f_29846)
static void C_ccall f_29846(C_word c,C_word *av) C_noret;
C_noret_decl(f_29849)
static void C_ccall f_29849(C_word c,C_word *av) C_noret;
C_noret_decl(f_29852)
static void C_ccall f_29852(C_word c,C_word *av) C_noret;
C_noret_decl(f_29854)
static void f_29854(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_29864)
static void C_ccall f_29864(C_word c,C_word *av) C_noret;
C_noret_decl(f_29870)
static void C_ccall f_29870(C_word c,C_word *av) C_noret;
C_noret_decl(f_29882)
static void C_ccall f_29882(C_word c,C_word *av) C_noret;
C_noret_decl(f_29885)
static void C_ccall f_29885(C_word c,C_word *av) C_noret;
C_noret_decl(f_29888)
static void C_ccall f_29888(C_word c,C_word *av) C_noret;
C_noret_decl(f_29905)
static void C_ccall f_29905(C_word c,C_word *av) C_noret;
C_noret_decl(f_29913)
static void f_29913(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_29937)
static void f_29937(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_29941)
static void C_ccall f_29941(C_word c,C_word *av) C_noret;
C_noret_decl(f_29954)
static void C_ccall f_29954(C_word c,C_word *av) C_noret;
C_noret_decl(f_29957)
static void C_ccall f_29957(C_word c,C_word *av) C_noret;
C_noret_decl(f_29966)
static void C_ccall f_29966(C_word c,C_word *av) C_noret;
C_noret_decl(f_29969)
static void C_ccall f_29969(C_word c,C_word *av) C_noret;
C_noret_decl(f_29997)
static void f_29997(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_30001)
static void C_ccall f_30001(C_word c,C_word *av) C_noret;
C_noret_decl(f_30010)
static void C_ccall f_30010(C_word c,C_word *av) C_noret;
C_noret_decl(f_30027)
static void f_30027(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_30034)
static void C_ccall f_30034(C_word c,C_word *av) C_noret;
C_noret_decl(f_30039)
static void f_30039(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30063)
static void C_ccall f_30063(C_word c,C_word *av) C_noret;
C_noret_decl(f_30069)
static void C_ccall f_30069(C_word c,C_word *av) C_noret;
C_noret_decl(f_30072)
static void C_ccall f_30072(C_word c,C_word *av) C_noret;
C_noret_decl(f_30083)
static void C_ccall f_30083(C_word c,C_word *av) C_noret;
C_noret_decl(f_30086)
static void C_ccall f_30086(C_word c,C_word *av) C_noret;
C_noret_decl(f_30089)
static void C_ccall f_30089(C_word c,C_word *av) C_noret;
C_noret_decl(f_30112)
static void f_30112(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30163)
static void f_30163(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30238)
static void f_30238(C_word t0,C_word t1) C_noret;
C_noret_decl(f_30338)
static void C_ccall f_30338(C_word c,C_word *av) C_noret;
C_noret_decl(f_30343)
static void f_30343(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30398)
static void C_ccall f_30398(C_word c,C_word *av) C_noret;
C_noret_decl(f_30404)
static void C_ccall f_30404(C_word c,C_word *av) C_noret;
C_noret_decl(f_30408)
static void f_30408(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30416)
static void C_ccall f_30416(C_word c,C_word *av) C_noret;
C_noret_decl(f_30431)
static void C_ccall f_30431(C_word c,C_word *av) C_noret;
C_noret_decl(f_30438)
static void C_ccall f_30438(C_word c,C_word *av) C_noret;
C_noret_decl(f_30457)
static void C_ccall f_30457(C_word c,C_word *av) C_noret;
C_noret_decl(f_30493)
static void C_ccall f_30493(C_word c,C_word *av) C_noret;
C_noret_decl(f_30505)
static void C_ccall f_30505(C_word c,C_word *av) C_noret;
C_noret_decl(f_30511)
static void C_ccall f_30511(C_word c,C_word *av) C_noret;
C_noret_decl(f_30540)
static void C_ccall f_30540(C_word c,C_word *av) C_noret;
C_noret_decl(f_30550)
static void C_ccall f_30550(C_word c,C_word *av) C_noret;
C_noret_decl(f_30559)
static void C_ccall f_30559(C_word c,C_word *av) C_noret;
C_noret_decl(f_30568)
static void f_30568(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_30584)
static void C_ccall f_30584(C_word c,C_word *av) C_noret;
C_noret_decl(f_30622)
static void C_ccall f_30622(C_word c,C_word *av) C_noret;
C_noret_decl(f_30688)
static void C_ccall f_30688(C_word c,C_word *av) C_noret;
C_noret_decl(f_30691)
static void C_ccall f_30691(C_word c,C_word *av) C_noret;
C_noret_decl(f_30694)
static void C_ccall f_30694(C_word c,C_word *av) C_noret;
C_noret_decl(f_30701)
static void C_ccall f_30701(C_word c,C_word *av) C_noret;
C_noret_decl(f_30745)
static void C_ccall f_30745(C_word c,C_word *av) C_noret;
C_noret_decl(f_30748)
static void C_ccall f_30748(C_word c,C_word *av) C_noret;
C_noret_decl(f_30757)
static void f_30757(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30770)
static void C_ccall f_30770(C_word c,C_word *av) C_noret;
C_noret_decl(f_30779)
static void C_ccall f_30779(C_word c,C_word *av) C_noret;
C_noret_decl(f_30789)
static void C_ccall f_30789(C_word c,C_word *av) C_noret;
C_noret_decl(f_30792)
static void C_ccall f_30792(C_word c,C_word *av) C_noret;
C_noret_decl(f_30818)
static void C_ccall f_30818(C_word c,C_word *av) C_noret;
C_noret_decl(f_30825)
static void C_ccall f_30825(C_word c,C_word *av) C_noret;
C_noret_decl(f_30841)
static void C_ccall f_30841(C_word c,C_word *av) C_noret;
C_noret_decl(f_30853)
static void C_ccall f_30853(C_word c,C_word *av) C_noret;
C_noret_decl(f_30856)
static void C_ccall f_30856(C_word c,C_word *av) C_noret;
C_noret_decl(f_30863)
static void C_ccall f_30863(C_word c,C_word *av) C_noret;
C_noret_decl(f_30872)
static void C_ccall f_30872(C_word c,C_word *av) C_noret;
C_noret_decl(f_30875)
static void C_ccall f_30875(C_word c,C_word *av) C_noret;
C_noret_decl(f_30922)
static void C_ccall f_30922(C_word c,C_word *av) C_noret;
C_noret_decl(f_30925)
static void C_ccall f_30925(C_word c,C_word *av) C_noret;
C_noret_decl(f_30934)
static void f_30934(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_30947)
static void C_ccall f_30947(C_word c,C_word *av) C_noret;
C_noret_decl(f_30950)
static void C_ccall f_30950(C_word c,C_word *av) C_noret;
C_noret_decl(f_30975)
static void C_ccall f_30975(C_word c,C_word *av) C_noret;
C_noret_decl(f_30979)
static void C_ccall f_30979(C_word c,C_word *av) C_noret;
C_noret_decl(f_30989)
static void C_ccall f_30989(C_word c,C_word *av) C_noret;
C_noret_decl(f_30992)
static void C_ccall f_30992(C_word c,C_word *av) C_noret;
C_noret_decl(f_31004)
static void C_ccall f_31004(C_word c,C_word *av) C_noret;
C_noret_decl(f_31008)
static void C_ccall f_31008(C_word c,C_word *av) C_noret;
C_noret_decl(f_31030)
static void C_ccall f_31030(C_word c,C_word *av) C_noret;
C_noret_decl(f_31032)
static void C_ccall f_31032(C_word c,C_word *av) C_noret;
C_noret_decl(f_31048)
static void C_ccall f_31048(C_word c,C_word *av) C_noret;
C_noret_decl(f_31053)
static void C_ccall f_31053(C_word c,C_word *av) C_noret;
C_noret_decl(f_31059)
static void C_ccall f_31059(C_word c,C_word *av) C_noret;
C_noret_decl(f_31065)
static void C_ccall f_31065(C_word c,C_word *av) C_noret;
C_noret_decl(f_31069)
static void C_ccall f_31069(C_word c,C_word *av) C_noret;
C_noret_decl(f_31072)
static void C_ccall f_31072(C_word c,C_word *av) C_noret;
C_noret_decl(f_31087)
static void C_ccall f_31087(C_word c,C_word *av) C_noret;
C_noret_decl(f_31090)
static void C_ccall f_31090(C_word c,C_word *av) C_noret;
C_noret_decl(f_31106)
static void C_ccall f_31106(C_word c,C_word *av) C_noret;
C_noret_decl(f_31112)
static void C_ccall f_31112(C_word c,C_word *av) C_noret;
C_noret_decl(f_31121)
static void C_ccall f_31121(C_word c,C_word *av) C_noret;
C_noret_decl(f_31127)
static void C_ccall f_31127(C_word c,C_word *av) C_noret;
C_noret_decl(f_31134)
static void C_ccall f_31134(C_word c,C_word *av) C_noret;
C_noret_decl(f_31137)
static void C_ccall f_31137(C_word c,C_word *av) C_noret;
C_noret_decl(f_31140)
static void C_ccall f_31140(C_word c,C_word *av) C_noret;
C_noret_decl(f_31149)
static void C_ccall f_31149(C_word c,C_word *av) C_noret;
C_noret_decl(f_31165)
static void C_ccall f_31165(C_word c,C_word *av) C_noret;
C_noret_decl(f_31184)
static void C_ccall f_31184(C_word c,C_word *av) C_noret;
C_noret_decl(f_31190)
static void C_ccall f_31190(C_word c,C_word *av) C_noret;
C_noret_decl(f_31196)
static void C_ccall f_31196(C_word c,C_word *av) C_noret;
C_noret_decl(f_31200)
static void C_ccall f_31200(C_word c,C_word *av) C_noret;
C_noret_decl(f_31203)
static void C_ccall f_31203(C_word c,C_word *av) C_noret;
C_noret_decl(f_31206)
static void C_ccall f_31206(C_word c,C_word *av) C_noret;
C_noret_decl(f_31210)
static void C_ccall f_31210(C_word c,C_word *av) C_noret;
C_noret_decl(f_31214)
static void C_ccall f_31214(C_word c,C_word *av) C_noret;
C_noret_decl(f_31218)
static void C_ccall f_31218(C_word c,C_word *av) C_noret;
C_noret_decl(f_31221)
static void C_ccall f_31221(C_word c,C_word *av) C_noret;
C_noret_decl(f_31224)
static void C_ccall f_31224(C_word c,C_word *av) C_noret;
C_noret_decl(f_31227)
static void C_ccall f_31227(C_word c,C_word *av) C_noret;
C_noret_decl(f_31239)
static void C_ccall f_31239(C_word c,C_word *av) C_noret;
C_noret_decl(f_31245)
static void C_ccall f_31245(C_word c,C_word *av) C_noret;
C_noret_decl(f_31249)
static void C_ccall f_31249(C_word c,C_word *av) C_noret;
C_noret_decl(f_31252)
static void C_ccall f_31252(C_word c,C_word *av) C_noret;
C_noret_decl(f_31255)
static void C_ccall f_31255(C_word c,C_word *av) C_noret;
C_noret_decl(f_31258)
static void C_ccall f_31258(C_word c,C_word *av) C_noret;
C_noret_decl(f_31261)
static void C_ccall f_31261(C_word c,C_word *av) C_noret;
C_noret_decl(f_31264)
static void C_ccall f_31264(C_word c,C_word *av) C_noret;
C_noret_decl(f_31269)
static void C_ccall f_31269(C_word c,C_word *av) C_noret;
C_noret_decl(f_31291)
static void C_ccall f_31291(C_word c,C_word *av) C_noret;
C_noret_decl(f_31297)
static void C_ccall f_31297(C_word c,C_word *av) C_noret;
C_noret_decl(f_31322)
static void C_ccall f_31322(C_word c,C_word *av) C_noret;
C_noret_decl(f_31329)
static void C_ccall f_31329(C_word c,C_word *av) C_noret;
C_noret_decl(f_31331)
static void f_31331(C_word t0,C_word t1) C_noret;
C_noret_decl(f_31338)
static void C_ccall f_31338(C_word c,C_word *av) C_noret;
C_noret_decl(f_31342)
static void f_31342(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_31349)
static void C_ccall f_31349(C_word c,C_word *av) C_noret;
C_noret_decl(f_31365)
static void f_31365(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_31369)
static void C_ccall f_31369(C_word c,C_word *av) C_noret;
C_noret_decl(f_31385)
static void f_31385(C_word t0,C_word t1) C_noret;
C_noret_decl(f_31400)
static void f_31400(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_31410)
static void C_ccall f_31410(C_word c,C_word *av) C_noret;
C_noret_decl(f_31415)
static void C_ccall f_31415(C_word c,C_word *av) C_noret;
C_noret_decl(f_31421)
static void C_ccall f_31421(C_word c,C_word *av) C_noret;
C_noret_decl(f_31435)
static void C_ccall f_31435(C_word c,C_word *av) C_noret;
C_noret_decl(f_31444)
static void C_ccall f_31444(C_word c,C_word *av) C_noret;
C_noret_decl(f_31455)
static void C_ccall f_31455(C_word c,C_word *av) C_noret;
C_noret_decl(f_31461)
static void f_31461(C_word t0,C_word t1) C_noret;
C_noret_decl(f_31464)
static void C_ccall f_31464(C_word c,C_word *av) C_noret;
C_noret_decl(f_31475)
static void C_ccall f_31475(C_word c,C_word *av) C_noret;
C_noret_decl(f_31484)
static void C_ccall f_31484(C_word c,C_word *av) C_noret;
C_noret_decl(f_31489)
static void C_ccall f_31489(C_word c,C_word *av) C_noret;
C_noret_decl(f_31495)
static void C_ccall f_31495(C_word c,C_word *av) C_noret;
C_noret_decl(f_31516)
static void C_ccall f_31516(C_word c,C_word *av) C_noret;
C_noret_decl(f_31519)
static void C_ccall f_31519(C_word c,C_word *av) C_noret;
C_noret_decl(f_31526)
static void C_ccall f_31526(C_word c,C_word *av) C_noret;
C_noret_decl(f_31533)
static void C_ccall f_31533(C_word c,C_word *av) C_noret;
C_noret_decl(f_31542)
static void C_ccall f_31542(C_word c,C_word *av) C_noret;
C_noret_decl(f_31553)
static void C_ccall f_31553(C_word c,C_word *av) C_noret;
C_noret_decl(f_31599)
static void C_ccall f_31599(C_word c,C_word *av) C_noret;
C_noret_decl(f_31603)
static void C_ccall f_31603(C_word c,C_word *av) C_noret;
C_noret_decl(f_31604)
static void f_31604(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_31614)
static void C_ccall f_31614(C_word c,C_word *av) C_noret;
C_noret_decl(f_31619)
static void f_31619(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_31629)
static void C_ccall f_31629(C_word c,C_word *av) C_noret;
C_noret_decl(f_31642)
static void C_ccall f_31642(C_word c,C_word *av) C_noret;
C_noret_decl(f_31653)
static void C_ccall f_31653(C_word c,C_word *av) C_noret;
C_noret_decl(f_31657)
static void C_ccall f_31657(C_word c,C_word *av) C_noret;
C_noret_decl(f_31661)
static void C_ccall f_31661(C_word c,C_word *av) C_noret;
C_noret_decl(f_31683)
static void C_ccall f_31683(C_word c,C_word *av) C_noret;
C_noret_decl(f_31687)
static void C_ccall f_31687(C_word c,C_word *av) C_noret;
C_noret_decl(f_31695)
static void C_ccall f_31695(C_word c,C_word *av) C_noret;
C_noret_decl(f_31711)
static void C_ccall f_31711(C_word c,C_word *av) C_noret;
C_noret_decl(f_31722)
static void f_31722(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_31741)
static void f_31741(C_word t0,C_word t1) C_noret;
C_noret_decl(f_31752)
static void C_ccall f_31752(C_word c,C_word *av) C_noret;
C_noret_decl(f_31763)
static void C_ccall f_31763(C_word c,C_word *av) C_noret;
C_noret_decl(f_31849)
static void C_ccall f_31849(C_word c,C_word *av) C_noret;
C_noret_decl(f_31859)
static void C_ccall f_31859(C_word c,C_word *av) C_noret;
C_noret_decl(f_31860)
static void f_31860(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_31873)
static void C_ccall f_31873(C_word c,C_word *av) C_noret;
C_noret_decl(f_31876)
static void C_ccall f_31876(C_word c,C_word *av) C_noret;
C_noret_decl(f_31879)
static void C_ccall f_31879(C_word c,C_word *av) C_noret;
C_noret_decl(f_31882)
static void C_ccall f_31882(C_word c,C_word *av) C_noret;
C_noret_decl(f_31890)
static void C_ccall f_31890(C_word c,C_word *av) C_noret;
C_noret_decl(f_31897)
static void f_31897(C_word t0,C_word t1) C_noret;
C_noret_decl(f_31900)
static void C_ccall f_31900(C_word c,C_word *av) C_noret;
C_noret_decl(f_31903)
static void C_ccall f_31903(C_word c,C_word *av) C_noret;
C_noret_decl(f_31926)
static void C_ccall f_31926(C_word c,C_word *av) C_noret;
C_noret_decl(f_31931)
static void f_31931(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_31941)
static void C_ccall f_31941(C_word c,C_word *av) C_noret;
C_noret_decl(f_31954)
static void C_ccall f_31954(C_word c,C_word *av) C_noret;
C_noret_decl(f_31995)
static void C_ccall f_31995(C_word c,C_word *av) C_noret;
C_noret_decl(f_32045)
static void C_ccall f_32045(C_word c,C_word *av) C_noret;
C_noret_decl(f_32048)
static void C_ccall f_32048(C_word c,C_word *av) C_noret;
C_noret_decl(f_32067)
static void f_32067(C_word t0) C_noret;
C_noret_decl(f_32072)
static void C_ccall f_32072(C_word c,C_word *av) C_noret;
C_noret_decl(f_32078)
static void C_ccall f_32078(C_word c,C_word *av) C_noret;
C_noret_decl(f_32081)
static void C_ccall f_32081(C_word c,C_word *av) C_noret;
C_noret_decl(f_32090)
static void C_ccall f_32090(C_word c,C_word *av) C_noret;
C_noret_decl(f_32096)
static void C_ccall f_32096(C_word c,C_word *av) C_noret;
C_noret_decl(f_32115)
static void f_32115(C_word t0,C_word t1) C_noret;
C_noret_decl(f_32134)
static void C_ccall f_32134(C_word c,C_word *av) C_noret;
C_noret_decl(f_32139)
static void f_32139(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_32149)
static void C_ccall f_32149(C_word c,C_word *av) C_noret;
C_noret_decl(f_32163)
static void C_ccall f_32163(C_word c,C_word *av) C_noret;
C_noret_decl(f_32170)
static void C_ccall f_32170(C_word c,C_word *av) C_noret;
C_noret_decl(f_32174)
static void C_ccall f_32174(C_word c,C_word *av) C_noret;
C_noret_decl(f_32178)
static void C_ccall f_32178(C_word c,C_word *av) C_noret;
C_noret_decl(f_32180)
static void C_ccall f_32180(C_word c,C_word *av) C_noret;
C_noret_decl(f_32183)
static void C_ccall f_32183(C_word c,C_word *av) C_noret;
C_noret_decl(f_32209)
static void C_ccall f_32209(C_word c,C_word *av) C_noret;
C_noret_decl(f_32212)
static void C_ccall f_32212(C_word c,C_word *av) C_noret;
C_noret_decl(f_32215)
static void C_ccall f_32215(C_word c,C_word *av) C_noret;
C_noret_decl(f_32222)
static void C_ccall f_32222(C_word c,C_word *av) C_noret;
C_noret_decl(f_32226)
static void C_ccall f_32226(C_word c,C_word *av) C_noret;
C_noret_decl(f_32232)
static void C_ccall f_32232(C_word c,C_word *av) C_noret;
C_noret_decl(f_32237)
static void f_32237(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_32247)
static void C_ccall f_32247(C_word c,C_word *av) C_noret;
C_noret_decl(f_32285)
static void f_32285(C_word t0,C_word t1) C_noret;
C_noret_decl(f_32288)
static void f_32288(C_word t0,C_word t1) C_noret;
C_noret_decl(f_32308)
static void f_32308(C_word t0,C_word t1) C_noret;
C_noret_decl(f_32326)
static void C_ccall f_32326(C_word c,C_word *av) C_noret;
C_noret_decl(f_32460)
static void C_ccall f_32460(C_word c,C_word *av) C_noret;
C_noret_decl(f_32477)
static void C_ccall f_32477(C_word c,C_word *av) C_noret;
C_noret_decl(f_32492)
static void C_ccall f_32492(C_word c,C_word *av) C_noret;
C_noret_decl(f_32496)
static void C_ccall f_32496(C_word c,C_word *av) C_noret;
C_noret_decl(f_32509)
static void C_ccall f_32509(C_word c,C_word *av) C_noret;
C_noret_decl(f_32517)
static void C_ccall f_32517(C_word c,C_word *av) C_noret;
C_noret_decl(f_32520)
static void C_ccall f_32520(C_word c,C_word *av) C_noret;
C_noret_decl(f_32524)
static void C_ccall f_32524(C_word c,C_word *av) C_noret;
C_noret_decl(f_32563)
static void C_ccall f_32563(C_word c,C_word *av) C_noret;
C_noret_decl(f_32566)
static void C_ccall f_32566(C_word c,C_word *av) C_noret;
C_noret_decl(f_32573)
static void C_ccall f_32573(C_word c,C_word *av) C_noret;
C_noret_decl(f_32577)
static void C_ccall f_32577(C_word c,C_word *av) C_noret;
C_noret_decl(f_32603)
static void C_ccall f_32603(C_word c,C_word *av) C_noret;
C_noret_decl(f_32634)
static void C_ccall f_32634(C_word c,C_word *av) C_noret;
C_noret_decl(f_32637)
static void C_ccall f_32637(C_word c,C_word *av) C_noret;
C_noret_decl(f_32649)
static void C_ccall f_32649(C_word c,C_word *av) C_noret;
C_noret_decl(f_32652)
static void C_ccall f_32652(C_word c,C_word *av) C_noret;
C_noret_decl(f_32655)
static void C_ccall f_32655(C_word c,C_word *av) C_noret;
C_noret_decl(f_32680)
static void C_ccall f_32680(C_word c,C_word *av) C_noret;
C_noret_decl(f_32686)
static void C_ccall f_32686(C_word c,C_word *av) C_noret;
C_noret_decl(f_32690)
static void C_ccall f_32690(C_word c,C_word *av) C_noret;
C_noret_decl(f_32694)
static void C_ccall f_32694(C_word c,C_word *av) C_noret;
C_noret_decl(f_32707)
static void C_ccall f_32707(C_word c,C_word *av) C_noret;
C_noret_decl(f_32709)
static C_word f_32709(C_word t0,C_word t1);
C_noret_decl(f_32715)
static C_word f_32715(C_word t0);
C_noret_decl(f_32720)
static C_word f_32720(C_word t0);
C_noret_decl(f_32755)
static void f_32755(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_32761)
static void f_32761(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_32777)
static void f_32777(C_word t0,C_word t1) C_noret;
C_noret_decl(f_32799)
static void C_ccall f_32799(C_word c,C_word *av) C_noret;
C_noret_decl(f_32823)
static void C_ccall f_32823(C_word c,C_word *av) C_noret;
C_noret_decl(f_32835)
static void C_ccall f_32835(C_word c,C_word *av) C_noret;
C_noret_decl(f_32837)
static void C_ccall f_32837(C_word c,C_word *av) C_noret;
C_noret_decl(f_32856)
static void C_ccall f_32856(C_word c,C_word *av) C_noret;
C_noret_decl(f_32860)
static void C_ccall f_32860(C_word c,C_word *av) C_noret;
C_noret_decl(f_32872)
static void C_ccall f_32872(C_word c,C_word *av) C_noret;
C_noret_decl(f_32874)
static void f_32874(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_32918)
static void C_ccall f_32918(C_word c,C_word *av) C_noret;
C_noret_decl(f_32920)
static void f_32920(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_32954)
static C_word f_32954(C_word t0);
C_noret_decl(f_32977)
static void C_ccall f_32977(C_word c,C_word *av) C_noret;
C_noret_decl(f_32984)
static void C_ccall f_32984(C_word c,C_word *av) C_noret;
C_noret_decl(f_32994)
static void C_ccall f_32994(C_word c,C_word *av) C_noret;
C_noret_decl(f_32996)
static void f_32996(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_33046)
static void C_ccall f_33046(C_word c,C_word *av) C_noret;
C_noret_decl(f_33048)
static void f_33048(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_33073)
static void C_ccall f_33073(C_word c,C_word *av) C_noret;
C_noret_decl(f_33082)
static void C_ccall f_33082(C_word c,C_word *av) C_noret;
C_noret_decl(f_33088)
static void C_ccall f_33088(C_word c,C_word *av) C_noret;
C_noret_decl(f_33092)
static void C_ccall f_33092(C_word c,C_word *av) C_noret;
C_noret_decl(f_33096)
static void f_33096(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_33104)
static void C_ccall f_33104(C_word c,C_word *av) C_noret;
C_noret_decl(f_33110)
static void f_33110(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_33141)
static void C_ccall f_33141(C_word c,C_word *av) C_noret;
C_noret_decl(f_33166)
static void f_33166(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_33191)
static void C_ccall f_33191(C_word c,C_word *av) C_noret;
C_noret_decl(f_33201)
static void C_ccall f_33201(C_word c,C_word *av) C_noret;
C_noret_decl(f_33206)
static void C_ccall f_33206(C_word c,C_word *av) C_noret;
C_noret_decl(f_33208)
static void C_ccall f_33208(C_word c,C_word *av) C_noret;
C_noret_decl(f_33215)
static void C_ccall f_33215(C_word c,C_word *av) C_noret;
C_noret_decl(f_33227)
static void C_ccall f_33227(C_word c,C_word *av) C_noret;
C_noret_decl(f_33235)
static void C_ccall f_33235(C_word c,C_word *av) C_noret;
C_noret_decl(f_33273)
static void C_ccall f_33273(C_word c,C_word *av) C_noret;
C_noret_decl(f_33277)
static void C_ccall f_33277(C_word c,C_word *av) C_noret;
C_noret_decl(f_33284)
static void C_ccall f_33284(C_word c,C_word *av) C_noret;
C_noret_decl(f_33287)
static void C_ccall f_33287(C_word c,C_word *av) C_noret;
C_noret_decl(f_33290)
static void C_ccall f_33290(C_word c,C_word *av) C_noret;
C_noret_decl(f_33291)
static void f_33291(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_33293)
static void f_33293(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_33297)
static void C_ccall f_33297(C_word c,C_word *av) C_noret;
C_noret_decl(f_33302)
static void C_ccall f_33302(C_word c,C_word *av) C_noret;
C_noret_decl(f_33314)
static void f_33314(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_33324)
static void C_ccall f_33324(C_word c,C_word *av) C_noret;
C_noret_decl(f_33336)
static void C_ccall f_33336(C_word c,C_word *av) C_noret;
C_noret_decl(f_33338)
static void f_33338(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_33345)
static void C_ccall f_33345(C_word c,C_word *av) C_noret;
C_noret_decl(f_33348)
static void C_ccall f_33348(C_word c,C_word *av) C_noret;
C_noret_decl(f_33357)
static void C_ccall f_33357(C_word c,C_word *av) C_noret;
C_noret_decl(f_33360)
static void C_ccall f_33360(C_word c,C_word *av) C_noret;
C_noret_decl(f_33363)
static void C_ccall f_33363(C_word c,C_word *av) C_noret;
C_noret_decl(f_33378)
static void C_ccall f_33378(C_word c,C_word *av) C_noret;
C_noret_decl(f_33384)
static void C_ccall f_33384(C_word c,C_word *av) C_noret;
C_noret_decl(f_33392)
static void f_33392(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_33396)
static void C_ccall f_33396(C_word c,C_word *av) C_noret;
C_noret_decl(f_33399)
static void C_ccall f_33399(C_word c,C_word *av) C_noret;
C_noret_decl(f_33402)
static void C_ccall f_33402(C_word c,C_word *av) C_noret;
C_noret_decl(f_33415)
static void C_ccall f_33415(C_word c,C_word *av) C_noret;
C_noret_decl(f_33419)
static void C_ccall f_33419(C_word c,C_word *av) C_noret;
C_noret_decl(f_33440)
static void C_ccall f_33440(C_word c,C_word *av) C_noret;
C_noret_decl(f_33456)
static void C_ccall f_33456(C_word c,C_word *av) C_noret;
C_noret_decl(f_33459)
static void C_ccall f_33459(C_word c,C_word *av) C_noret;
C_noret_decl(f_33465)
static void C_ccall f_33465(C_word c,C_word *av) C_noret;
C_noret_decl(f_33487)
static void f_33487(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_33492)
static void f_33492(C_word t0,C_word t1) C_noret;
C_noret_decl(f_33527)
static void C_ccall f_33527(C_word c,C_word *av) C_noret;
C_noret_decl(f_33537)
static void C_ccall f_33537(C_word c,C_word *av) C_noret;
C_noret_decl(f_33540)
static void C_ccall f_33540(C_word c,C_word *av) C_noret;
C_noret_decl(f_33543)
static void C_ccall f_33543(C_word c,C_word *av) C_noret;
C_noret_decl(f_33546)
static void C_ccall f_33546(C_word c,C_word *av) C_noret;
C_noret_decl(f_33549)
static void C_ccall f_33549(C_word c,C_word *av) C_noret;
C_noret_decl(f_33552)
static void C_ccall f_33552(C_word c,C_word *av) C_noret;
C_noret_decl(f_33559)
static void C_ccall f_33559(C_word c,C_word *av) C_noret;
C_noret_decl(f_33562)
static void C_ccall f_33562(C_word c,C_word *av) C_noret;
C_noret_decl(f_33565)
static void C_ccall f_33565(C_word c,C_word *av) C_noret;
C_noret_decl(f_33576)
static void C_ccall f_33576(C_word c,C_word *av) C_noret;
C_noret_decl(f_33599)
static void C_ccall f_33599(C_word c,C_word *av) C_noret;
C_noret_decl(f_33610)
static void C_ccall f_33610(C_word c,C_word *av) C_noret;
C_noret_decl(f_33614)
static void C_ccall f_33614(C_word c,C_word *av) C_noret;
C_noret_decl(f_33636)
static void C_ccall f_33636(C_word c,C_word *av) C_noret;
C_noret_decl(f_33647)
static void C_ccall f_33647(C_word c,C_word *av) C_noret;
C_noret_decl(f_33651)
static void C_ccall f_33651(C_word c,C_word *av) C_noret;
C_noret_decl(f_34150)
static void C_ccall f_34150(C_word c,C_word *av) C_noret;
C_noret_decl(f_34161)
static void C_ccall f_34161(C_word c,C_word *av) C_noret;
C_noret_decl(f_34165)
static void C_ccall f_34165(C_word c,C_word *av) C_noret;
C_noret_decl(f_34306)
static void C_ccall f_34306(C_word c,C_word *av) C_noret;
C_noret_decl(f_34308)
static void C_ccall f_34308(C_word c,C_word *av) C_noret;
C_noret_decl(f_34314)
static void C_ccall f_34314(C_word c,C_word *av) C_noret;
C_noret_decl(f_34318)
static void C_ccall f_34318(C_word c,C_word *av) C_noret;
C_noret_decl(f_34321)
static void C_ccall f_34321(C_word c,C_word *av) C_noret;
C_noret_decl(f_34330)
static void C_ccall f_34330(C_word c,C_word *av) C_noret;
C_noret_decl(f_34344)
static void C_ccall f_34344(C_word c,C_word *av) C_noret;
C_noret_decl(f_34352)
static void C_ccall f_34352(C_word c,C_word *av) C_noret;
C_noret_decl(f_34354)
static void C_ccall f_34354(C_word c,C_word *av) C_noret;
C_noret_decl(f_34358)
static void C_ccall f_34358(C_word c,C_word *av) C_noret;
C_noret_decl(f_34366)
static void C_ccall f_34366(C_word c,C_word *av) C_noret;
C_noret_decl(f_34374)
static void C_ccall f_34374(C_word c,C_word *av) C_noret;
C_noret_decl(f_34376)
static void C_ccall f_34376(C_word c,C_word *av) C_noret;
C_noret_decl(f_34386)
static void C_ccall f_34386(C_word c,C_word *av) C_noret;
C_noret_decl(f_34393)
static void C_ccall f_34393(C_word c,C_word *av) C_noret;
C_noret_decl(f_34403)
static void C_ccall f_34403(C_word c,C_word *av) C_noret;
C_noret_decl(f_34407)
static void C_ccall f_34407(C_word c,C_word *av) C_noret;
C_noret_decl(f_34411)
static void C_ccall f_34411(C_word c,C_word *av) C_noret;
C_noret_decl(f_34415)
static void C_ccall f_34415(C_word c,C_word *av) C_noret;
C_noret_decl(f_34417)
static void C_ccall f_34417(C_word c,C_word *av) C_noret;
C_noret_decl(f_34427)
static void C_ccall f_34427(C_word c,C_word *av) C_noret;
C_noret_decl(f_34438)
static void C_ccall f_34438(C_word c,C_word *av) C_noret;
C_noret_decl(f_34442)
static void C_ccall f_34442(C_word c,C_word *av) C_noret;
C_noret_decl(f_34447)
static void C_ccall f_34447(C_word c,C_word *av) C_noret;
C_noret_decl(f_34451)
static void C_ccall f_34451(C_word c,C_word *av) C_noret;
C_noret_decl(f_34456)
static void C_ccall f_34456(C_word c,C_word *av) C_noret;
C_noret_decl(f_34459)
static void C_ccall f_34459(C_word c,C_word *av) C_noret;
C_noret_decl(f_34462)
static void C_ccall f_34462(C_word c,C_word *av) C_noret;
C_noret_decl(f_34465)
static void C_ccall f_34465(C_word c,C_word *av) C_noret;
C_noret_decl(f_34467)
static void C_ccall f_34467(C_word c,C_word *av) C_noret;
C_noret_decl(f_34474)
static void C_ccall f_34474(C_word c,C_word *av) C_noret;
C_noret_decl(f_34477)
static void C_ccall f_34477(C_word c,C_word *av) C_noret;
C_noret_decl(f_34485)
static void C_ccall f_34485(C_word c,C_word *av) C_noret;
C_noret_decl(f_34492)
static void C_ccall f_34492(C_word c,C_word *av) C_noret;
C_noret_decl(f_34497)
static void C_ccall f_34497(C_word c,C_word *av) C_noret;
C_noret_decl(f_34500)
static void C_ccall f_34500(C_word c,C_word *av) C_noret;
C_noret_decl(f_34503)
static void C_ccall f_34503(C_word c,C_word *av) C_noret;
C_noret_decl(f_34506)
static void C_ccall f_34506(C_word c,C_word *av) C_noret;
C_noret_decl(f_34511)
static void C_ccall f_34511(C_word c,C_word *av) C_noret;
C_noret_decl(f_34514)
static void C_ccall f_34514(C_word c,C_word *av) C_noret;
C_noret_decl(f_34517)
static void C_ccall f_34517(C_word c,C_word *av) C_noret;
C_noret_decl(f_34520)
static void C_ccall f_34520(C_word c,C_word *av) C_noret;
C_noret_decl(f_34523)
static void C_ccall f_34523(C_word c,C_word *av) C_noret;
C_noret_decl(f_34526)
static void C_ccall f_34526(C_word c,C_word *av) C_noret;
C_noret_decl(f_34529)
static void C_ccall f_34529(C_word c,C_word *av) C_noret;
C_noret_decl(f_34532)
static void C_ccall f_34532(C_word c,C_word *av) C_noret;
C_noret_decl(f_34556)
static void C_ccall f_34556(C_word c,C_word *av) C_noret;
C_noret_decl(f_34560)
static void C_ccall f_34560(C_word c,C_word *av) C_noret;
C_noret_decl(f_34562)
static void C_ccall f_34562(C_word c,C_word *av) C_noret;
C_noret_decl(f_34570)
static void C_ccall f_34570(C_word c,C_word *av) C_noret;
C_noret_decl(f_34572)
static void C_ccall f_34572(C_word c,C_word *av) C_noret;
C_noret_decl(f_34576)
static void C_ccall f_34576(C_word c,C_word *av) C_noret;
C_noret_decl(f_34578)
static void C_ccall f_34578(C_word c,C_word *av) C_noret;
C_noret_decl(f_34585)
static void C_ccall f_34585(C_word c,C_word *av) C_noret;
C_noret_decl(f_34621)
static void C_ccall f_34621(C_word c,C_word *av) C_noret;
C_noret_decl(f_34624)
static void C_ccall f_34624(C_word c,C_word *av) C_noret;
C_noret_decl(f_34627)
static void C_ccall f_34627(C_word c,C_word *av) C_noret;
C_noret_decl(f_34630)
static void C_ccall f_34630(C_word c,C_word *av) C_noret;
C_noret_decl(f_34633)
static void C_ccall f_34633(C_word c,C_word *av) C_noret;
C_noret_decl(f_34649)
static void C_ccall f_34649(C_word c,C_word *av) C_noret;
C_noret_decl(f_34653)
static void C_ccall f_34653(C_word c,C_word *av) C_noret;
C_noret_decl(f_34662)
static void C_ccall f_34662(C_word c,C_word *av) C_noret;
C_noret_decl(f_34666)
static void C_ccall f_34666(C_word c,C_word *av) C_noret;
C_noret_decl(f_34668)
static void C_ccall f_34668(C_word c,C_word *av) C_noret;
C_noret_decl(f_34672)
static void C_ccall f_34672(C_word c,C_word *av) C_noret;
C_noret_decl(f_34674)
static void C_ccall f_34674(C_word c,C_word *av) C_noret;
C_noret_decl(f_34679)
static void C_ccall f_34679(C_word c,C_word *av) C_noret;
C_noret_decl(f_34681)
static void C_ccall f_34681(C_word c,C_word *av) C_noret;
C_noret_decl(f_34684)
static void C_ccall f_34684(C_word c,C_word *av) C_noret;
C_noret_decl(f_34704)
static void C_ccall f_34704(C_word c,C_word *av) C_noret;
C_noret_decl(f_34710)
static void f_34710(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_34720)
static void C_ccall f_34720(C_word c,C_word *av) C_noret;
C_noret_decl(f_34730)
static void C_ccall f_34730(C_word c,C_word *av) C_noret;
C_noret_decl(f_34765)
static void C_ccall f_34765(C_word c,C_word *av) C_noret;
C_noret_decl(f_34769)
static void C_ccall f_34769(C_word c,C_word *av) C_noret;
C_noret_decl(f_34774)
static void f_34774(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_34784)
static void C_ccall f_34784(C_word c,C_word *av) C_noret;
C_noret_decl(f_34794)
static void C_ccall f_34794(C_word c,C_word *av) C_noret;
C_noret_decl(f_34803)
static void C_ccall f_34803(C_word c,C_word *av) C_noret;
C_noret_decl(f_34806)
static void C_ccall f_34806(C_word c,C_word *av) C_noret;
C_noret_decl(f_34809)
static void C_ccall f_34809(C_word c,C_word *av) C_noret;
C_noret_decl(f_34813)
static void C_ccall f_34813(C_word c,C_word *av) C_noret;
C_noret_decl(f_34815)
static void C_ccall f_34815(C_word c,C_word *av) C_noret;
C_noret_decl(f_34818)
static void C_ccall f_34818(C_word c,C_word *av) C_noret;
C_noret_decl(f_34821)
static void C_ccall f_34821(C_word c,C_word *av) C_noret;
C_noret_decl(f_34824)
static void C_ccall f_34824(C_word c,C_word *av) C_noret;
C_noret_decl(f_34827)
static void C_ccall f_34827(C_word c,C_word *av) C_noret;
C_noret_decl(f_34836)
static void C_ccall f_34836(C_word c,C_word *av) C_noret;
C_noret_decl(f_34839)
static void C_ccall f_34839(C_word c,C_word *av) C_noret;
C_noret_decl(f_34842)
static void C_ccall f_34842(C_word c,C_word *av) C_noret;
C_noret_decl(f_34845)
static void C_ccall f_34845(C_word c,C_word *av) C_noret;
C_noret_decl(f_34848)
static void C_ccall f_34848(C_word c,C_word *av) C_noret;
C_noret_decl(f_34851)
static void C_ccall f_34851(C_word c,C_word *av) C_noret;
C_noret_decl(f_34854)
static void C_ccall f_34854(C_word c,C_word *av) C_noret;
C_noret_decl(f_34857)
static void C_ccall f_34857(C_word c,C_word *av) C_noret;
C_noret_decl(f_34864)
static void C_ccall f_34864(C_word c,C_word *av) C_noret;
C_noret_decl(f_34867)
static void C_ccall f_34867(C_word c,C_word *av) C_noret;
C_noret_decl(f_34883)
static void C_ccall f_34883(C_word c,C_word *av) C_noret;
C_noret_decl(f_34891)
static void C_ccall f_34891(C_word c,C_word *av) C_noret;
C_noret_decl(f_34894)
static void C_ccall f_34894(C_word c,C_word *av) C_noret;
C_noret_decl(f_34900)
static void C_ccall f_34900(C_word c,C_word *av) C_noret;
C_noret_decl(f_34909)
static void C_ccall f_34909(C_word c,C_word *av) C_noret;
C_noret_decl(f_34915)
static void C_ccall f_34915(C_word c,C_word *av) C_noret;
C_noret_decl(f_34924)
static void C_ccall f_34924(C_word c,C_word *av) C_noret;
C_noret_decl(f_34930)
static void C_ccall f_34930(C_word c,C_word *av) C_noret;
C_noret_decl(f_34936)
static void C_ccall f_34936(C_word c,C_word *av) C_noret;
C_noret_decl(f_34939)
static void C_ccall f_34939(C_word c,C_word *av) C_noret;
C_noret_decl(f_34945)
static void C_ccall f_34945(C_word c,C_word *av) C_noret;
C_noret_decl(f_34951)
static void C_ccall f_34951(C_word c,C_word *av) C_noret;
C_noret_decl(f_34954)
static void C_ccall f_34954(C_word c,C_word *av) C_noret;
C_noret_decl(f_34960)
static void C_ccall f_34960(C_word c,C_word *av) C_noret;
C_noret_decl(f_34999)
static void C_ccall f_34999(C_word c,C_word *av) C_noret;
C_noret_decl(f_35042)
static void C_ccall f_35042(C_word c,C_word *av) C_noret;
C_noret_decl(f_35049)
static void C_ccall f_35049(C_word c,C_word *av) C_noret;
C_noret_decl(f_35054)
static void f_35054(C_word t0,C_word t1) C_noret;
C_noret_decl(f_35070)
static void C_ccall f_35070(C_word c,C_word *av) C_noret;
C_noret_decl(f_35096)
static void C_ccall f_35096(C_word c,C_word *av) C_noret;
C_noret_decl(f_35099)
static void C_ccall f_35099(C_word c,C_word *av) C_noret;
C_noret_decl(f_35106)
static void C_ccall f_35106(C_word c,C_word *av) C_noret;
C_noret_decl(f_35111)
static void C_ccall f_35111(C_word c,C_word *av) C_noret;
C_noret_decl(f_35113)
static void C_ccall f_35113(C_word c,C_word *av) C_noret;
C_noret_decl(f_35117)
static void C_ccall f_35117(C_word c,C_word *av) C_noret;
C_noret_decl(f_35144)
static void f_35144(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_35154)
static void C_ccall f_35154(C_word c,C_word *av) C_noret;
C_noret_decl(f_35163)
static void C_ccall f_35163(C_word c,C_word *av) C_noret;
C_noret_decl(f_35170)
static void C_ccall f_35170(C_word c,C_word *av) C_noret;
C_noret_decl(f_35174)
static void C_ccall f_35174(C_word c,C_word *av) C_noret;
C_noret_decl(f_35188)
static void f_35188(C_word t0,C_word t1) C_noret;
C_noret_decl(f_35192)
static void C_ccall f_35192(C_word c,C_word *av) C_noret;
C_noret_decl(f_35199)
static void C_ccall f_35199(C_word c,C_word *av) C_noret;
C_noret_decl(f_35201)
static void f_35201(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_35223)
static void C_ccall f_35223(C_word c,C_word *av) C_noret;
C_noret_decl(f_35230)
static void C_ccall f_35230(C_word c,C_word *av) C_noret;
C_noret_decl(f_35235)
static void f_35235(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_35239)
static void C_ccall f_35239(C_word c,C_word *av) C_noret;
C_noret_decl(f_35242)
static void C_ccall f_35242(C_word c,C_word *av) C_noret;
C_noret_decl(f_35245)
static void C_ccall f_35245(C_word c,C_word *av) C_noret;
C_noret_decl(f_35250)
static void f_35250(C_word t0,C_word t1) C_noret;
C_noret_decl(f_35254)
static void C_ccall f_35254(C_word c,C_word *av) C_noret;
C_noret_decl(f_35280)
static void C_ccall f_35280(C_word c,C_word *av) C_noret;
C_noret_decl(f_35293)
static void C_ccall f_35293(C_word c,C_word *av) C_noret;
C_noret_decl(f_35296)
static void C_ccall f_35296(C_word c,C_word *av) C_noret;
C_noret_decl(f_35305)
static void C_ccall f_35305(C_word c,C_word *av) C_noret;
C_noret_decl(f_35308)
static void C_ccall f_35308(C_word c,C_word *av) C_noret;
C_noret_decl(f_35311)
static void C_ccall f_35311(C_word c,C_word *av) C_noret;
C_noret_decl(f_35317)
static void C_ccall f_35317(C_word c,C_word *av) C_noret;
C_noret_decl(f_35324)
static void C_ccall f_35324(C_word c,C_word *av) C_noret;
C_noret_decl(f_35326)
static void f_35326(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_35339)
static void C_ccall f_35339(C_word c,C_word *av) C_noret;
C_noret_decl(f_35352)
static void C_ccall f_35352(C_word c,C_word *av) C_noret;
C_noret_decl(f_35355)
static void C_ccall f_35355(C_word c,C_word *av) C_noret;
C_noret_decl(f_35358)
static void C_ccall f_35358(C_word c,C_word *av) C_noret;
C_noret_decl(f_35365)
static void C_ccall f_35365(C_word c,C_word *av) C_noret;
C_noret_decl(f_35417)
static void C_ccall f_35417(C_word c,C_word *av) C_noret;
C_noret_decl(f_35420)
static void C_ccall f_35420(C_word c,C_word *av) C_noret;
C_noret_decl(f_35423)
static void C_ccall f_35423(C_word c,C_word *av) C_noret;
C_noret_decl(f_35425)
static void f_35425(C_word t0,C_word t1) C_noret;
C_noret_decl(f_35429)
static void C_ccall f_35429(C_word c,C_word *av) C_noret;
C_noret_decl(f_35433)
static void C_ccall f_35433(C_word c,C_word *av) C_noret;
C_noret_decl(f_35439)
static void C_ccall f_35439(C_word c,C_word *av) C_noret;
C_noret_decl(f_35444)
static void f_35444(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_35448)
static void C_ccall f_35448(C_word c,C_word *av) C_noret;
C_noret_decl(f_35460)
static void C_ccall f_35460(C_word c,C_word *av) C_noret;
C_noret_decl(f_35472)
static void C_ccall f_35472(C_word c,C_word *av) C_noret;
C_noret_decl(f_35479)
static void C_ccall f_35479(C_word c,C_word *av) C_noret;
C_noret_decl(f_35485)
static void f_35485(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_35499)
static void C_ccall f_35499(C_word c,C_word *av) C_noret;
C_noret_decl(f_35538)
static void C_ccall f_35538(C_word c,C_word *av) C_noret;
C_noret_decl(f_35557)
static void C_ccall f_35557(C_word c,C_word *av) C_noret;
C_noret_decl(f_35579)
static void C_ccall f_35579(C_word c,C_word *av) C_noret;
C_noret_decl(f_35588)
static void C_ccall f_35588(C_word c,C_word *av) C_noret;
C_noret_decl(f_35595)
static void C_ccall f_35595(C_word c,C_word *av) C_noret;
C_noret_decl(f_35612)
static void C_ccall f_35612(C_word c,C_word *av) C_noret;
C_noret_decl(f_35620)
static void C_ccall f_35620(C_word c,C_word *av) C_noret;
C_noret_decl(f_35631)
static void C_ccall f_35631(C_word c,C_word *av) C_noret;
C_noret_decl(f_35639)
static void C_ccall f_35639(C_word c,C_word *av) C_noret;
C_noret_decl(f_35646)
static void C_ccall f_35646(C_word c,C_word *av) C_noret;
C_noret_decl(f_35708)
static void C_ccall f_35708(C_word c,C_word *av) C_noret;
C_noret_decl(f_35715)
static void C_ccall f_35715(C_word c,C_word *av) C_noret;
C_noret_decl(f_35718)
static void C_ccall f_35718(C_word c,C_word *av) C_noret;
C_noret_decl(f_35728)
static void C_ccall f_35728(C_word c,C_word *av) C_noret;
C_noret_decl(f_35732)
static void C_ccall f_35732(C_word c,C_word *av) C_noret;
C_noret_decl(f_35736)
static void C_ccall f_35736(C_word c,C_word *av) C_noret;
C_noret_decl(f_35739)
static void C_ccall f_35739(C_word c,C_word *av) C_noret;
C_noret_decl(f_35747)
static void C_ccall f_35747(C_word c,C_word *av) C_noret;
C_noret_decl(f_35756)
static void C_ccall f_35756(C_word c,C_word *av) C_noret;
C_noret_decl(f_35764)
static void C_ccall f_35764(C_word c,C_word *av) C_noret;
C_noret_decl(f_35777)
static void C_ccall f_35777(C_word c,C_word *av) C_noret;
C_noret_decl(f_35785)
static void C_ccall f_35785(C_word c,C_word *av) C_noret;
C_noret_decl(f_35789)
static void C_ccall f_35789(C_word c,C_word *av) C_noret;
C_noret_decl(f_35797)
static void C_ccall f_35797(C_word c,C_word *av) C_noret;
C_noret_decl(f_35805)
static void C_ccall f_35805(C_word c,C_word *av) C_noret;
C_noret_decl(f_35807)
static void C_ccall f_35807(C_word c,C_word *av) C_noret;
C_noret_decl(f_35813)
static void f_35813(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_35817)
static void C_ccall f_35817(C_word c,C_word *av) C_noret;
C_noret_decl(f_35825)
static void f_35825(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_35845)
static void C_ccall f_35845(C_word c,C_word *av) C_noret;
C_noret_decl(f_35853)
static void C_ccall f_35853(C_word c,C_word *av) C_noret;
C_noret_decl(f_35857)
static void C_ccall f_35857(C_word c,C_word *av) C_noret;
C_noret_decl(f_35872)
static void C_ccall f_35872(C_word c,C_word *av) C_noret;
C_noret_decl(f_35879)
static void C_ccall f_35879(C_word c,C_word *av) C_noret;
C_noret_decl(f_35891)
static void C_ccall f_35891(C_word c,C_word *av) C_noret;
C_noret_decl(f_35899)
static void C_ccall f_35899(C_word c,C_word *av) C_noret;
C_noret_decl(f_35905)
static void f_35905(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_35927)
static void C_ccall f_35927(C_word c,C_word *av) C_noret;
C_noret_decl(f_35931)
static void C_ccall f_35931(C_word c,C_word *av) C_noret;
C_noret_decl(f_35935)
static void C_ccall f_35935(C_word c,C_word *av) C_noret;
C_noret_decl(f_35937)
static void C_ccall f_35937(C_word c,C_word *av) C_noret;
C_noret_decl(f_35940)
static void C_ccall f_35940(C_word c,C_word *av) C_noret;
C_noret_decl(f_35943)
static void C_ccall f_35943(C_word c,C_word *av) C_noret;
C_noret_decl(f_35947)
static void C_ccall f_35947(C_word c,C_word *av) C_noret;
C_noret_decl(f_35950)
static void C_ccall f_35950(C_word c,C_word *av) C_noret;
C_noret_decl(f_35972)
static void C_ccall f_35972(C_word c,C_word *av) C_noret;
C_noret_decl(f_35978)
static void C_ccall f_35978(C_word c,C_word *av) C_noret;
C_noret_decl(f_35982)
static void C_ccall f_35982(C_word c,C_word *av) C_noret;
C_noret_decl(f_35999)
static void C_ccall f_35999(C_word c,C_word *av) C_noret;
C_noret_decl(f_36009)
static void C_ccall f_36009(C_word c,C_word *av) C_noret;
C_noret_decl(f_36013)
static void C_ccall f_36013(C_word c,C_word *av) C_noret;
C_noret_decl(f_36017)
static void C_ccall f_36017(C_word c,C_word *av) C_noret;
C_noret_decl(f_36029)
static void C_ccall f_36029(C_word c,C_word *av) C_noret;
C_noret_decl(f_36039)
static void C_ccall f_36039(C_word c,C_word *av) C_noret;
C_noret_decl(f_36048)
static void C_ccall f_36048(C_word c,C_word *av) C_noret;
C_noret_decl(f_36064)
static void C_ccall f_36064(C_word c,C_word *av) C_noret;
C_noret_decl(f_36068)
static void C_ccall f_36068(C_word c,C_word *av) C_noret;
C_noret_decl(f_36070)
static void C_ccall f_36070(C_word c,C_word *av) C_noret;
C_noret_decl(f_36076)
static void C_ccall f_36076(C_word c,C_word *av) C_noret;
C_noret_decl(f_36083)
static void C_ccall f_36083(C_word c,C_word *av) C_noret;
C_noret_decl(f_36088)
static void C_ccall f_36088(C_word c,C_word *av) C_noret;
C_noret_decl(f_36109)
static void C_ccall f_36109(C_word c,C_word *av) C_noret;
C_noret_decl(f_36119)
static void f_36119(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_36129)
static void C_ccall f_36129(C_word c,C_word *av) C_noret;
C_noret_decl(f_36142)
static void C_ccall f_36142(C_word c,C_word *av) C_noret;
C_noret_decl(f_36146)
static void C_ccall f_36146(C_word c,C_word *av) C_noret;
C_noret_decl(f_36149)
static void C_ccall f_36149(C_word c,C_word *av) C_noret;
C_noret_decl(f_36157)
static void f_36157(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_36167)
static void C_ccall f_36167(C_word c,C_word *av) C_noret;
C_noret_decl(f_36189)
static void C_ccall f_36189(C_word c,C_word *av) C_noret;
C_noret_decl(f_36193)
static void C_ccall f_36193(C_word c,C_word *av) C_noret;
C_noret_decl(f_36224)
static void C_ccall f_36224(C_word c,C_word *av) C_noret;
C_noret_decl(f_36227)
static void C_ccall f_36227(C_word c,C_word *av) C_noret;
C_noret_decl(f_36230)
static void C_ccall f_36230(C_word c,C_word *av) C_noret;
C_noret_decl(f_36236)
static void f_36236(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_36249)
static void C_ccall f_36249(C_word c,C_word *av) C_noret;
C_noret_decl(f_36252)
static void C_ccall f_36252(C_word c,C_word *av) C_noret;
C_noret_decl(f_36261)
static void C_ccall f_36261(C_word c,C_word *av) C_noret;
C_noret_decl(f_36267)
static void C_ccall f_36267(C_word c,C_word *av) C_noret;
C_noret_decl(f_36273)
static void C_ccall f_36273(C_word c,C_word *av) C_noret;
C_noret_decl(f_36279)
static void C_ccall f_36279(C_word c,C_word *av) C_noret;
C_noret_decl(f_36285)
static void C_ccall f_36285(C_word c,C_word *av) C_noret;
C_noret_decl(f_36302)
static void C_ccall f_36302(C_word c,C_word *av) C_noret;
C_noret_decl(f_36308)
static void C_ccall f_36308(C_word c,C_word *av) C_noret;
C_noret_decl(f_36323)
static void C_ccall f_36323(C_word c,C_word *av) C_noret;
C_noret_decl(f_36327)
static void C_ccall f_36327(C_word c,C_word *av) C_noret;
C_noret_decl(f_36331)
static void C_ccall f_36331(C_word c,C_word *av) C_noret;
C_noret_decl(f_36335)
static void C_ccall f_36335(C_word c,C_word *av) C_noret;
C_noret_decl(f_36356)
static void C_ccall f_36356(C_word c,C_word *av) C_noret;
C_noret_decl(f_36358)
static void C_ccall f_36358(C_word c,C_word *av) C_noret;
C_noret_decl(f_36364)
static void f_36364(C_word t0,C_word t1) C_noret;
C_noret_decl(f_36368)
static void C_ccall f_36368(C_word c,C_word *av) C_noret;
C_noret_decl(f_36377)
static void C_ccall f_36377(C_word c,C_word *av) C_noret;
C_noret_decl(f_36386)
static void C_ccall f_36386(C_word c,C_word *av) C_noret;
C_noret_decl(f_36429)
static void C_ccall f_36429(C_word c,C_word *av) C_noret;
C_noret_decl(f_36696)
static void C_ccall f_36696(C_word c,C_word *av) C_noret;
C_noret_decl(f_36702)
static void C_ccall f_36702(C_word c,C_word *av) C_noret;
C_noret_decl(f_36721)
static void C_ccall f_36721(C_word c,C_word *av) C_noret;
C_noret_decl(f_36723)
static void C_ccall f_36723(C_word c,C_word *av) C_noret;
C_noret_decl(f_36746)
static C_word f_36746(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_36792)
static void C_ccall f_36792(C_word c,C_word *av) C_noret;
C_noret_decl(f_36794)
static void C_ccall f_36794(C_word c,C_word *av) C_noret;
C_noret_decl(f_36801)
static void f_36801(C_word t0,C_word t1) C_noret;
C_noret_decl(f_36810)
static void f_36810(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_36854)
static void C_ccall f_36854(C_word c,C_word *av) C_noret;
C_noret_decl(f_36869)
static void f_36869(C_word t0,C_word t1) C_noret;
C_noret_decl(f_36877)
static void C_ccall f_36877(C_word c,C_word *av) C_noret;
C_noret_decl(f_36883)
static void f_36883(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_36891)
static void C_ccall f_36891(C_word c,C_word *av) C_noret;
C_noret_decl(f_36895)
static void C_ccall f_36895(C_word c,C_word *av) C_noret;
C_noret_decl(f_36903)
static void C_ccall f_36903(C_word c,C_word *av) C_noret;
C_noret_decl(f_36905)
static void f_36905(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_36915)
static void C_ccall f_36915(C_word c,C_word *av) C_noret;
C_noret_decl(f_36922)
static void C_ccall f_36922(C_word c,C_word *av) C_noret;
C_noret_decl(f_36926)
static void C_ccall f_36926(C_word c,C_word *av) C_noret;
C_noret_decl(f_36937)
static void C_ccall f_36937(C_word c,C_word *av) C_noret;
C_noret_decl(f_36944)
static void C_ccall f_36944(C_word c,C_word *av) C_noret;
C_noret_decl(f_36948)
static void C_ccall f_36948(C_word c,C_word *av) C_noret;
C_noret_decl(f_36959)
static void C_ccall f_36959(C_word c,C_word *av) C_noret;
C_noret_decl(f_36966)
static void C_ccall f_36966(C_word c,C_word *av) C_noret;
C_noret_decl(f_36970)
static void C_ccall f_36970(C_word c,C_word *av) C_noret;
C_noret_decl(f_36975)
static void C_ccall f_36975(C_word c,C_word *av) C_noret;
C_noret_decl(f_36981)
static void C_ccall f_36981(C_word c,C_word *av) C_noret;
C_noret_decl(f_36984)
static void C_ccall f_36984(C_word c,C_word *av) C_noret;
C_noret_decl(f_36987)
static void C_ccall f_36987(C_word c,C_word *av) C_noret;
C_noret_decl(f_36993)
static void C_ccall f_36993(C_word c,C_word *av) C_noret;
C_noret_decl(f_37002)
static void C_ccall f_37002(C_word c,C_word *av) C_noret;
C_noret_decl(f_37011)
static void C_ccall f_37011(C_word c,C_word *av) C_noret;
C_noret_decl(f_37017)
static void C_ccall f_37017(C_word c,C_word *av) C_noret;
C_noret_decl(f_37020)
static void C_ccall f_37020(C_word c,C_word *av) C_noret;
C_noret_decl(f_37023)
static void C_ccall f_37023(C_word c,C_word *av) C_noret;
C_noret_decl(f_37035)
static void C_ccall f_37035(C_word c,C_word *av) C_noret;
C_noret_decl(f_37038)
static void C_ccall f_37038(C_word c,C_word *av) C_noret;
C_noret_decl(f_37041)
static void C_ccall f_37041(C_word c,C_word *av) C_noret;
C_noret_decl(f_37044)
static void C_ccall f_37044(C_word c,C_word *av) C_noret;
C_noret_decl(f_37056)
static void C_ccall f_37056(C_word c,C_word *av) C_noret;
C_noret_decl(f_37059)
static void C_ccall f_37059(C_word c,C_word *av) C_noret;
C_noret_decl(f_37062)
static void C_ccall f_37062(C_word c,C_word *av) C_noret;
C_noret_decl(f_37065)
static void C_ccall f_37065(C_word c,C_word *av) C_noret;
C_noret_decl(f_37074)
static void C_ccall f_37074(C_word c,C_word *av) C_noret;
C_noret_decl(f_37077)
static void C_ccall f_37077(C_word c,C_word *av) C_noret;
C_noret_decl(f_37090)
static void C_ccall f_37090(C_word c,C_word *av) C_noret;
C_noret_decl(f_37091)
static void C_ccall f_37091(C_word c,C_word *av) C_noret;
C_noret_decl(f_37096)
static void C_ccall f_37096(C_word c,C_word *av) C_noret;
C_noret_decl(f_37097)
static void C_ccall f_37097(C_word c,C_word *av) C_noret;
C_noret_decl(f_37102)
static void C_ccall f_37102(C_word c,C_word *av) C_noret;
C_noret_decl(f_37103)
static void C_ccall f_37103(C_word c,C_word *av) C_noret;
C_noret_decl(f_37108)
static void C_ccall f_37108(C_word c,C_word *av) C_noret;
C_noret_decl(f_37109)
static void C_ccall f_37109(C_word c,C_word *av) C_noret;
C_noret_decl(f_37114)
static void C_ccall f_37114(C_word c,C_word *av) C_noret;
C_noret_decl(f_37115)
static void C_ccall f_37115(C_word c,C_word *av) C_noret;
C_noret_decl(f_37120)
static void f_37120(C_word t0,C_word t1) C_noret;
C_noret_decl(f_37122)
static void C_ccall f_37122(C_word c,C_word *av) C_noret;
C_noret_decl(f_37132)
static void C_ccall f_37132(C_word c,C_word *av) C_noret;
C_noret_decl(f_37135)
static void C_ccall f_37135(C_word c,C_word *av) C_noret;
C_noret_decl(f_37138)
static void C_ccall f_37138(C_word c,C_word *av) C_noret;
C_noret_decl(f_37141)
static void C_ccall f_37141(C_word c,C_word *av) C_noret;
C_noret_decl(f_37143)
static void f_37143(C_word t0,C_word t1) C_noret;
C_noret_decl(f_37157)
static void C_ccall f_37157(C_word c,C_word *av) C_noret;
C_noret_decl(f_37165)
static void C_ccall f_37165(C_word c,C_word *av) C_noret;
C_noret_decl(f_37169)
static void C_ccall f_37169(C_word c,C_word *av) C_noret;
C_noret_decl(f_37173)
static void C_ccall f_37173(C_word c,C_word *av) C_noret;
C_noret_decl(f_37177)
static void C_ccall f_37177(C_word c,C_word *av) C_noret;
C_noret_decl(f_37183)
static void C_ccall f_37183(C_word c,C_word *av) C_noret;
C_noret_decl(f_37190)
static void C_ccall f_37190(C_word c,C_word *av) C_noret;
C_noret_decl(f_37194)
static void C_ccall f_37194(C_word c,C_word *av) C_noret;
C_noret_decl(f_37198)
static void C_ccall f_37198(C_word c,C_word *av) C_noret;
C_noret_decl(f_37202)
static void C_ccall f_37202(C_word c,C_word *av) C_noret;
C_noret_decl(f_37220)
static void C_ccall f_37220(C_word c,C_word *av) C_noret;
C_noret_decl(f_37239)
static void C_ccall f_37239(C_word c,C_word *av) C_noret;
C_noret_decl(f_37242)
static void C_ccall f_37242(C_word c,C_word *av) C_noret;
C_noret_decl(f_37245)
static void C_ccall f_37245(C_word c,C_word *av) C_noret;
C_noret_decl(f_37248)
static void C_ccall f_37248(C_word c,C_word *av) C_noret;
C_noret_decl(f_37257)
static void C_ccall f_37257(C_word c,C_word *av) C_noret;
C_noret_decl(f_37263)
static void C_ccall f_37263(C_word c,C_word *av) C_noret;
C_noret_decl(f_37286)
static void C_ccall f_37286(C_word c,C_word *av) C_noret;
C_noret_decl(f_37308)
static void C_ccall f_37308(C_word c,C_word *av) C_noret;
C_noret_decl(f_37314)
static void f_37314(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_37334)
static void C_ccall f_37334(C_word c,C_word *av) C_noret;
C_noret_decl(f_37349)
static void C_ccall f_37349(C_word c,C_word *av) C_noret;
C_noret_decl(f_37353)
static void C_ccall f_37353(C_word c,C_word *av) C_noret;
C_noret_decl(f_37376)
static void C_ccall f_37376(C_word c,C_word *av) C_noret;
C_noret_decl(f_37380)
static void C_ccall f_37380(C_word c,C_word *av) C_noret;
C_noret_decl(f_37382)
static void C_ccall f_37382(C_word c,C_word *av) C_noret;
C_noret_decl(f_37412)
static void C_ccall f_37412(C_word c,C_word *av) C_noret;
C_noret_decl(f_37415)
static void C_ccall f_37415(C_word c,C_word *av) C_noret;
C_noret_decl(f_37417)
static void C_ccall f_37417(C_word c,C_word *av) C_noret;
C_noret_decl(f_37435)
static void C_ccall f_37435(C_word c,C_word *av) C_noret;
C_noret_decl(f_37442)
static void C_ccall f_37442(C_word c,C_word *av) C_noret;
C_noret_decl(f_37464)
static void C_ccall f_37464(C_word c,C_word *av) C_noret;
C_noret_decl(f_37473)
static void f_37473(C_word t0,C_word t1) C_noret;
C_noret_decl(f_37488)
static void C_ccall f_37488(C_word c,C_word *av) C_noret;
C_noret_decl(f_37491)
static void C_ccall f_37491(C_word c,C_word *av) C_noret;
C_noret_decl(f_37494)
static void C_ccall f_37494(C_word c,C_word *av) C_noret;
C_noret_decl(f_37497)
static void C_ccall f_37497(C_word c,C_word *av) C_noret;
C_noret_decl(f_37500)
static void C_ccall f_37500(C_word c,C_word *av) C_noret;
C_noret_decl(f_37503)
static void C_ccall f_37503(C_word c,C_word *av) C_noret;
C_noret_decl(f_37506)
static void f_37506(C_word t0,C_word t1) C_noret;
C_noret_decl(f_37509)
static void f_37509(C_word t0,C_word t1) C_noret;
C_noret_decl(f_37512)
static void f_37512(C_word t0,C_word t1) C_noret;
C_noret_decl(f_37515)
static void f_37515(C_word t0,C_word t1) C_noret;
C_noret_decl(f_37523)
static void C_ccall f_37523(C_word c,C_word *av) C_noret;
C_noret_decl(f_37526)
static void C_ccall f_37526(C_word c,C_word *av) C_noret;
C_noret_decl(f_37531)
static void C_ccall f_37531(C_word c,C_word *av) C_noret;
C_noret_decl(f_37537)
static void C_ccall f_37537(C_word c,C_word *av) C_noret;
C_noret_decl(f_37550)
static void C_ccall f_37550(C_word c,C_word *av) C_noret;
C_noret_decl(f_37552)
static void f_37552(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_37575)
static void C_ccall f_37575(C_word c,C_word *av) C_noret;
C_noret_decl(f_37582)
static void C_ccall f_37582(C_word c,C_word *av) C_noret;
C_noret_decl(f_37586)
static void C_ccall f_37586(C_word c,C_word *av) C_noret;
C_noret_decl(f_37588)
static void f_37588(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_37617)
static void C_ccall f_37617(C_word c,C_word *av) C_noret;
C_noret_decl(f_37619)
static void f_37619(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_37644)
static void C_ccall f_37644(C_word c,C_word *av) C_noret;
C_noret_decl(f_37653)
static void C_ccall f_37653(C_word c,C_word *av) C_noret;
C_noret_decl(f_37659)
static void f_37659(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_37683)
static void C_ccall f_37683(C_word c,C_word *av) C_noret;
C_noret_decl(f_37690)
static void C_ccall f_37690(C_word c,C_word *av) C_noret;
C_noret_decl(f_37694)
static void C_ccall f_37694(C_word c,C_word *av) C_noret;
C_noret_decl(f_37706)
static void C_ccall f_37706(C_word c,C_word *av) C_noret;
C_noret_decl(f_37714)
static void C_ccall f_37714(C_word c,C_word *av) C_noret;
C_noret_decl(f_37718)
static void C_ccall f_37718(C_word c,C_word *av) C_noret;
C_noret_decl(f_37727)
static void C_ccall f_37727(C_word c,C_word *av) C_noret;
C_noret_decl(f_37736)
static void C_ccall f_37736(C_word c,C_word *av) C_noret;
C_noret_decl(f_37744)
static void C_ccall f_37744(C_word c,C_word *av) C_noret;
C_noret_decl(f_37757)
static void C_ccall f_37757(C_word c,C_word *av) C_noret;
C_noret_decl(f_37765)
static void f_37765(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_37790)
static void C_ccall f_37790(C_word c,C_word *av) C_noret;
C_noret_decl(f_37799)
static void C_ccall f_37799(C_word c,C_word *av) C_noret;
C_noret_decl(f_37806)
static void C_ccall f_37806(C_word c,C_word *av) C_noret;
C_noret_decl(f_37809)
static void C_ccall f_37809(C_word c,C_word *av) C_noret;
C_noret_decl(f_37814)
static void f_37814(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_37846)
static void C_ccall f_37846(C_word c,C_word *av) C_noret;
C_noret_decl(f_37850)
static void C_ccall f_37850(C_word c,C_word *av) C_noret;
C_noret_decl(f_37853)
static void C_ccall f_37853(C_word c,C_word *av) C_noret;
C_noret_decl(f_37858)
static void f_37858(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_37871)
static void C_ccall f_37871(C_word c,C_word *av) C_noret;
C_noret_decl(f_37896)
static void C_ccall f_37896(C_word c,C_word *av) C_noret;
C_noret_decl(f_37908)
static void f_37908(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_37933)
static void C_ccall f_37933(C_word c,C_word *av) C_noret;
C_noret_decl(f_37935)
static void C_ccall f_37935(C_word c,C_word *av) C_noret;
C_noret_decl(f_37949)
static void f_37949(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_37959)
static void C_ccall f_37959(C_word c,C_word *av) C_noret;
C_noret_decl(f_37962)
static void C_ccall f_37962(C_word c,C_word *av) C_noret;
C_noret_decl(f_37965)
static void C_ccall f_37965(C_word c,C_word *av) C_noret;
C_noret_decl(f_37970)
static C_word f_37970(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_38039)
static void C_ccall f_38039(C_word c,C_word *av) C_noret;
C_noret_decl(f_38053)
static void f_38053(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_38063)
static void C_ccall f_38063(C_word c,C_word *av) C_noret;
C_noret_decl(f_38066)
static void C_ccall f_38066(C_word c,C_word *av) C_noret;
C_noret_decl(f_38069)
static void C_ccall f_38069(C_word c,C_word *av) C_noret;
C_noret_decl(f_38074)
static void f_38074(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_38153)
static void C_ccall f_38153(C_word c,C_word *av) C_noret;
C_noret_decl(f_38163)
static void C_ccall f_38163(C_word c,C_word *av) C_noret;
C_noret_decl(f_38168)
static void f_38168(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_38181)
static void C_ccall f_38181(C_word c,C_word *av) C_noret;
C_noret_decl(f_38215)
static void C_ccall f_38215(C_word c,C_word *av) C_noret;
C_noret_decl(f_38229)
static void C_ccall f_38229(C_word c,C_word *av) C_noret;
C_noret_decl(f_38238)
static void C_ccall f_38238(C_word c,C_word *av) C_noret;
C_noret_decl(f_38243)
static void f_38243(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_38264)
static void C_ccall f_38264(C_word c,C_word *av) C_noret;
C_noret_decl(f_38269)
static C_word f_38269(C_word t0,C_word t1);
C_noret_decl(f_38276)
static void C_ccall f_38276(C_word c,C_word *av) C_noret;
C_noret_decl(f_38278)
static void f_38278(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_38312)
static C_word f_38312(C_word t0,C_word t1);
C_noret_decl(f_38336)
static void f_38336(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_38370)
static C_word f_38370(C_word t0);
C_noret_decl(f_38393)
static void C_ccall f_38393(C_word c,C_word *av) C_noret;
C_noret_decl(f_38405)
static void f_38405(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_38415)
static void C_ccall f_38415(C_word c,C_word *av) C_noret;
C_noret_decl(f_38441)
static void C_ccall f_38441(C_word c,C_word *av) C_noret;
C_noret_decl(f_38455)
static void C_ccall f_38455(C_word c,C_word *av) C_noret;
C_noret_decl(f_38464)
static void C_ccall f_38464(C_word c,C_word *av) C_noret;
C_noret_decl(f_38469)
static void f_38469(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_38479)
static void C_ccall f_38479(C_word c,C_word *av) C_noret;
C_noret_decl(f_38491)
static C_word f_38491(C_word t0,C_word t1);
C_noret_decl(f_38498)
static void C_ccall f_38498(C_word c,C_word *av) C_noret;
C_noret_decl(f_38500)
static void f_38500(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_38534)
static C_word f_38534(C_word t0,C_word t1);
C_noret_decl(f_38558)
static void f_38558(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_38592)
static C_word f_38592(C_word t0);
C_noret_decl(f_38615)
static void C_ccall f_38615(C_word c,C_word *av) C_noret;
C_noret_decl(f_38625)
static void C_ccall f_38625(C_word c,C_word *av) C_noret;
C_noret_decl(f_38634)
static void C_ccall f_38634(C_word c,C_word *av) C_noret;
C_noret_decl(f_38639)
static void f_38639(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_38660)
static void C_ccall f_38660(C_word c,C_word *av) C_noret;
C_noret_decl(f_38670)
static void C_ccall f_38670(C_word c,C_word *av) C_noret;
C_noret_decl(f_38684)
static void C_ccall f_38684(C_word c,C_word *av) C_noret;
C_noret_decl(f_38693)
static void C_ccall f_38693(C_word c,C_word *av) C_noret;
C_noret_decl(f_38698)
static void f_38698(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_38719)
static void C_ccall f_38719(C_word c,C_word *av) C_noret;
C_noret_decl(f_38724)
static C_word f_38724(C_word t0,C_word t1);
C_noret_decl(f_38731)
static void C_ccall f_38731(C_word c,C_word *av) C_noret;
C_noret_decl(f_38733)
static void f_38733(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_38767)
static C_word f_38767(C_word t0,C_word t1);
C_noret_decl(f_38791)
static void f_38791(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_38825)
static C_word f_38825(C_word t0);
C_noret_decl(f_38848)
static void C_ccall f_38848(C_word c,C_word *av) C_noret;
C_noret_decl(f_38858)
static void C_ccall f_38858(C_word c,C_word *av) C_noret;
C_noret_decl(f_38869)
static void f_38869(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_38879)
static void C_ccall f_38879(C_word c,C_word *av) C_noret;
C_noret_decl(f_38896)
static void C_ccall f_38896(C_word c,C_word *av) C_noret;
C_noret_decl(f_38910)
static void C_ccall f_38910(C_word c,C_word *av) C_noret;
C_noret_decl(f_38919)
static void C_ccall f_38919(C_word c,C_word *av) C_noret;
C_noret_decl(f_38924)
static void f_38924(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_38934)
static void C_ccall f_38934(C_word c,C_word *av) C_noret;
C_noret_decl(f_38946)
static C_word f_38946(C_word t0,C_word t1);
C_noret_decl(f_38953)
static void C_ccall f_38953(C_word c,C_word *av) C_noret;
C_noret_decl(f_38955)
static void f_38955(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_38989)
static C_word f_38989(C_word t0,C_word t1);
C_noret_decl(f_39013)
static void f_39013(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_39047)
static C_word f_39047(C_word t0);
C_noret_decl(f_39070)
static void C_ccall f_39070(C_word c,C_word *av) C_noret;
C_noret_decl(f_39074)
static void C_ccall f_39074(C_word c,C_word *av) C_noret;
C_noret_decl(f_39077)
static void C_ccall f_39077(C_word c,C_word *av) C_noret;
C_noret_decl(f_39080)
static void C_ccall f_39080(C_word c,C_word *av) C_noret;
C_noret_decl(f_39105)
static void C_ccall f_39105(C_word c,C_word *av) C_noret;
C_noret_decl(f_39111)
static void C_ccall f_39111(C_word c,C_word *av) C_noret;
C_noret_decl(f_39117)
static void C_ccall f_39117(C_word c,C_word *av) C_noret;
C_noret_decl(f_39121)
static void C_ccall f_39121(C_word c,C_word *av) C_noret;
C_noret_decl(f_39126)
static void C_ccall f_39126(C_word c,C_word *av) C_noret;
C_noret_decl(f_39129)
static void C_ccall f_39129(C_word c,C_word *av) C_noret;
C_noret_decl(f_39140)
static void C_ccall f_39140(C_word c,C_word *av) C_noret;
C_noret_decl(f_39165)
static void C_ccall f_39165(C_word c,C_word *av) C_noret;
C_noret_decl(f_39179)
static void C_ccall f_39179(C_word c,C_word *av) C_noret;
C_noret_decl(f_39207)
static void f_39207(C_word t0,C_word t1) C_noret;
C_noret_decl(f_39210)
static void f_39210(C_word t0,C_word t1) C_noret;
C_noret_decl(f_39213)
static void C_ccall f_39213(C_word c,C_word *av) C_noret;
C_noret_decl(f_39283)
static void C_ccall f_39283(C_word c,C_word *av) C_noret;
C_noret_decl(f_39312)
static void C_ccall f_39312(C_word c,C_word *av) C_noret;
C_noret_decl(f_39314)
static void f_39314(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_39334)
static void C_ccall f_39334(C_word c,C_word *av) C_noret;
C_noret_decl(f_39386)
static void C_ccall f_39386(C_word c,C_word *av) C_noret;
C_noret_decl(f_39396)
static void f_39396(C_word t0,C_word t1) C_noret;
C_noret_decl(f_39406)
static void f_39406(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_39419)
static void C_ccall f_39419(C_word c,C_word *av) C_noret;
C_noret_decl(f_39424)
static void f_39424(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_39437)
static void C_ccall f_39437(C_word c,C_word *av) C_noret;
C_noret_decl(f_39470)
static void C_ccall f_39470(C_word c,C_word *av) C_noret;
C_noret_decl(f_39479)
static void C_ccall f_39479(C_word c,C_word *av) C_noret;
C_noret_decl(f_39505)
static void C_ccall f_39505(C_word c,C_word *av) C_noret;
C_noret_decl(f_39513)
static void C_ccall f_39513(C_word c,C_word *av) C_noret;
C_noret_decl(f_39542)
static void C_ccall f_39542(C_word c,C_word *av) C_noret;
C_noret_decl(f_39570)
static void f_39570(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_39583)
static void C_ccall f_39583(C_word c,C_word *av) C_noret;
C_noret_decl(f_39632)
static void C_ccall f_39632(C_word c,C_word *av) C_noret;
C_noret_decl(f_39651)
static void C_ccall f_39651(C_word c,C_word *av) C_noret;
C_noret_decl(f_39671)
static void C_ccall f_39671(C_word c,C_word *av) C_noret;
C_noret_decl(f_39686)
static void f_39686(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_39690)
static void C_ccall f_39690(C_word c,C_word *av) C_noret;
C_noret_decl(f_39746)
static void C_ccall f_39746(C_word c,C_word *av) C_noret;
C_noret_decl(f_39750)
static void C_ccall f_39750(C_word c,C_word *av) C_noret;
C_noret_decl(f_39758)
static void C_ccall f_39758(C_word c,C_word *av) C_noret;
C_noret_decl(f_39761)
static void f_39761(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_39765)
static void C_ccall f_39765(C_word c,C_word *av) C_noret;
C_noret_decl(f_39776)
static void C_ccall f_39776(C_word c,C_word *av) C_noret;
C_noret_decl(f_39779)
static C_word f_39779(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_39785)
static void f_39785(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_39789)
static void C_ccall f_39789(C_word c,C_word *av) C_noret;
C_noret_decl(f_39809)
static void f_39809(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_39834)
static void C_ccall f_39834(C_word c,C_word *av) C_noret;
C_noret_decl(f_39904)
static void C_ccall f_39904(C_word c,C_word *av) C_noret;
C_noret_decl(f_39979)
static void C_ccall f_39979(C_word c,C_word *av) C_noret;
C_noret_decl(f_40064)
static void C_ccall f_40064(C_word c,C_word *av) C_noret;
C_noret_decl(f_40083)
static void C_ccall f_40083(C_word c,C_word *av) C_noret;
C_noret_decl(f_40086)
static void C_ccall f_40086(C_word c,C_word *av) C_noret;
C_noret_decl(f_40100)
static void C_ccall f_40100(C_word c,C_word *av) C_noret;
C_noret_decl(f_40112)
static void C_ccall f_40112(C_word c,C_word *av) C_noret;
C_noret_decl(f_40114)
static void C_ccall f_40114(C_word c,C_word *av) C_noret;
C_noret_decl(f_40122)
static void C_ccall f_40122(C_word c,C_word *av) C_noret;
C_noret_decl(f_40124)
static void f_40124(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_40131)
static void C_ccall f_40131(C_word c,C_word *av) C_noret;
C_noret_decl(f_40143)
static void C_ccall f_40143(C_word c,C_word *av) C_noret;
C_noret_decl(f_40163)
static void C_ccall f_40163(C_word c,C_word *av) C_noret;
C_noret_decl(f_40167)
static void C_ccall f_40167(C_word c,C_word *av) C_noret;
C_noret_decl(f_40170)
static void C_ccall f_40170(C_word c,C_word *av) C_noret;
C_noret_decl(f_40179)
static void C_ccall f_40179(C_word c,C_word *av) C_noret;
C_noret_decl(f_40181)
static void C_ccall f_40181(C_word c,C_word *av) C_noret;
C_noret_decl(f_40232)
static void C_ccall f_40232(C_word c,C_word *av) C_noret;
C_noret_decl(f_40257)
static void C_ccall f_40257(C_word c,C_word *av) C_noret;
C_noret_decl(f_40272)
static void C_ccall f_40272(C_word c,C_word *av) C_noret;
C_noret_decl(f_40282)
static void C_ccall f_40282(C_word c,C_word *av) C_noret;
C_noret_decl(f_40312)
static void C_ccall f_40312(C_word c,C_word *av) C_noret;
C_noret_decl(f_40340)
static void C_ccall f_40340(C_word c,C_word *av) C_noret;
C_noret_decl(f_40350)
static void C_ccall f_40350(C_word c,C_word *av) C_noret;
C_noret_decl(f_40355)
static void f_40355(C_word t0,C_word t1) C_noret;
C_noret_decl(f_40359)
static void C_ccall f_40359(C_word c,C_word *av) C_noret;
C_noret_decl(f_40365)
static void C_ccall f_40365(C_word c,C_word *av) C_noret;
C_noret_decl(f_40368)
static void C_ccall f_40368(C_word c,C_word *av) C_noret;
C_noret_decl(f_40375)
static void C_ccall f_40375(C_word c,C_word *av) C_noret;
C_noret_decl(f_40396)
static void C_ccall f_40396(C_word c,C_word *av) C_noret;
C_noret_decl(f_40406)
static void C_ccall f_40406(C_word c,C_word *av) C_noret;
C_noret_decl(f_40409)
static void C_ccall f_40409(C_word c,C_word *av) C_noret;
C_noret_decl(f_40423)
static void C_ccall f_40423(C_word c,C_word *av) C_noret;
C_noret_decl(f_40436)
static void C_ccall f_40436(C_word c,C_word *av) C_noret;
C_noret_decl(f_40454)
static void C_ccall f_40454(C_word c,C_word *av) C_noret;
C_noret_decl(f_40488)
static void C_ccall f_40488(C_word c,C_word *av) C_noret;
C_noret_decl(f_40491)
static void C_ccall f_40491(C_word c,C_word *av) C_noret;
C_noret_decl(f_40550)
static void C_ccall f_40550(C_word c,C_word *av) C_noret;
C_noret_decl(f_40558)
static void C_ccall f_40558(C_word c,C_word *av) C_noret;
C_noret_decl(f_40562)
static void C_ccall f_40562(C_word c,C_word *av) C_noret;
C_noret_decl(f_40566)
static void C_ccall f_40566(C_word c,C_word *av) C_noret;
C_noret_decl(f_40572)
static void C_ccall f_40572(C_word c,C_word *av) C_noret;
C_noret_decl(f_40576)
static void C_ccall f_40576(C_word c,C_word *av) C_noret;
C_noret_decl(f_40580)
static void C_ccall f_40580(C_word c,C_word *av) C_noret;
C_noret_decl(f_40602)
static void C_ccall f_40602(C_word c,C_word *av) C_noret;
C_noret_decl(f_40606)
static void C_ccall f_40606(C_word c,C_word *av) C_noret;
C_noret_decl(f_40610)
static void C_ccall f_40610(C_word c,C_word *av) C_noret;
C_noret_decl(f_40614)
static void C_ccall f_40614(C_word c,C_word *av) C_noret;
C_noret_decl(f_40618)
static void C_ccall f_40618(C_word c,C_word *av) C_noret;
C_noret_decl(f_40638)
static void C_ccall f_40638(C_word c,C_word *av) C_noret;
C_noret_decl(f_40646)
static void f_40646(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_40671)
static void C_ccall f_40671(C_word c,C_word *av) C_noret;
C_noret_decl(f_40688)
static void C_ccall f_40688(C_word c,C_word *av) C_noret;
C_noret_decl(f_40692)
static void C_ccall f_40692(C_word c,C_word *av) C_noret;
C_noret_decl(f_40695)
static void C_ccall f_40695(C_word c,C_word *av) C_noret;
C_noret_decl(f_40698)
static void C_ccall f_40698(C_word c,C_word *av) C_noret;
C_noret_decl(f_40708)
static void C_ccall f_40708(C_word c,C_word *av) C_noret;
C_noret_decl(f_40711)
static void C_ccall f_40711(C_word c,C_word *av) C_noret;
C_noret_decl(f_40713)
static void C_ccall f_40713(C_word c,C_word *av) C_noret;
C_noret_decl(f_40730)
static C_word f_40730(C_word t0);
C_noret_decl(f_40757)
static void C_ccall f_40757(C_word c,C_word *av) C_noret;
C_noret_decl(f_40766)
static void C_ccall f_40766(C_word c,C_word *av) C_noret;
C_noret_decl(f_40786)
static void C_ccall f_40786(C_word c,C_word *av) C_noret;
C_noret_decl(f_40790)
static void C_ccall f_40790(C_word c,C_word *av) C_noret;
C_noret_decl(f_40794)
static void C_ccall f_40794(C_word c,C_word *av) C_noret;
C_noret_decl(f_40798)
static void C_ccall f_40798(C_word c,C_word *av) C_noret;
C_noret_decl(f_40802)
static void C_ccall f_40802(C_word c,C_word *av) C_noret;
C_noret_decl(f_40806)
static void C_ccall f_40806(C_word c,C_word *av) C_noret;
C_noret_decl(f_40810)
static void C_ccall f_40810(C_word c,C_word *av) C_noret;
C_noret_decl(f_40812)
static void C_ccall f_40812(C_word c,C_word *av) C_noret;
C_noret_decl(f_40821)
static void C_ccall f_40821(C_word c,C_word *av) C_noret;
C_noret_decl(f_40831)
static void C_ccall f_40831(C_word c,C_word *av) C_noret;
C_noret_decl(f_40856)
static void C_ccall f_40856(C_word c,C_word *av) C_noret;
C_noret_decl(f_40859)
static void C_ccall f_40859(C_word c,C_word *av) C_noret;
C_noret_decl(f_40861)
static void C_ccall f_40861(C_word c,C_word *av) C_noret;
C_noret_decl(f_40877)
static void f_40877(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_40912)
static void C_ccall f_40912(C_word c,C_word *av) C_noret;
C_noret_decl(f_40936)
static void C_ccall f_40936(C_word c,C_word *av) C_noret;
C_noret_decl(f_40940)
static void C_ccall f_40940(C_word c,C_word *av) C_noret;
C_noret_decl(f_40942)
static void C_ccall f_40942(C_word c,C_word *av) C_noret;
C_noret_decl(f_40946)
static void C_ccall f_40946(C_word c,C_word *av) C_noret;
C_noret_decl(f_40949)
static void C_ccall f_40949(C_word c,C_word *av) C_noret;
C_noret_decl(f_40962)
static void C_ccall f_40962(C_word c,C_word *av) C_noret;
C_noret_decl(f_40967)
static void C_ccall f_40967(C_word c,C_word *av) C_noret;
C_noret_decl(f_40982)
static void C_ccall f_40982(C_word c,C_word *av) C_noret;
C_noret_decl(f_40986)
static void C_ccall f_40986(C_word c,C_word *av) C_noret;
C_noret_decl(f_40995)
static void C_ccall f_40995(C_word c,C_word *av) C_noret;
C_noret_decl(f_40998)
static void C_ccall f_40998(C_word c,C_word *av) C_noret;
C_noret_decl(f_41001)
static void C_ccall f_41001(C_word c,C_word *av) C_noret;
C_noret_decl(f_41004)
static void C_ccall f_41004(C_word c,C_word *av) C_noret;
C_noret_decl(f_41007)
static void C_ccall f_41007(C_word c,C_word *av) C_noret;
C_noret_decl(f_41009)
static void C_ccall f_41009(C_word c,C_word *av) C_noret;
C_noret_decl(f_41019)
static void C_ccall f_41019(C_word c,C_word *av) C_noret;
C_noret_decl(f_41031)
static void C_ccall f_41031(C_word c,C_word *av) C_noret;
C_noret_decl(f_41039)
static void f_41039(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_41049)
static void C_ccall f_41049(C_word c,C_word *av) C_noret;
C_noret_decl(f_41065)
static void C_ccall f_41065(C_word c,C_word *av) C_noret;
C_noret_decl(f_41071)
static void C_ccall f_41071(C_word c,C_word *av) C_noret;
C_noret_decl(f_41074)
static void C_ccall f_41074(C_word c,C_word *av) C_noret;
C_noret_decl(f_41077)
static void C_ccall f_41077(C_word c,C_word *av) C_noret;
C_noret_decl(f_41078)
static void f_41078(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_41082)
static void C_ccall f_41082(C_word c,C_word *av) C_noret;
C_noret_decl(f_41088)
static void C_ccall f_41088(C_word c,C_word *av) C_noret;
C_noret_decl(f_41092)
static void C_ccall f_41092(C_word c,C_word *av) C_noret;
C_noret_decl(f_41094)
static void f_41094(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_41104)
static void C_ccall f_41104(C_word c,C_word *av) C_noret;
C_noret_decl(f_41121)
static void C_ccall f_41121(C_word c,C_word *av) C_noret;
C_noret_decl(f_41124)
static void C_ccall f_41124(C_word c,C_word *av) C_noret;
C_noret_decl(f_41128)
static void C_ccall f_41128(C_word c,C_word *av) C_noret;
C_noret_decl(f_41133)
static void C_ccall f_41133(C_word c,C_word *av) C_noret;
C_noret_decl(f_41139)
static void C_ccall f_41139(C_word c,C_word *av) C_noret;
C_noret_decl(f_41155)
static void C_ccall f_41155(C_word c,C_word *av) C_noret;
C_noret_decl(f_41163)
static void C_ccall f_41163(C_word c,C_word *av) C_noret;
C_noret_decl(f_41185)
static void C_ccall f_41185(C_word c,C_word *av) C_noret;
C_noret_decl(f_41203)
static void C_ccall f_41203(C_word c,C_word *av) C_noret;
C_noret_decl(f_41207)
static void C_ccall f_41207(C_word c,C_word *av) C_noret;
C_noret_decl(f_41219)
static void C_ccall f_41219(C_word c,C_word *av) C_noret;
C_noret_decl(f_41226)
static void C_ccall f_41226(C_word c,C_word *av) C_noret;
C_noret_decl(f_41241)
static void C_ccall f_41241(C_word c,C_word *av) C_noret;
C_noret_decl(f_41244)
static void C_ccall f_41244(C_word c,C_word *av) C_noret;
C_noret_decl(f_41247)
static void C_ccall f_41247(C_word c,C_word *av) C_noret;
C_noret_decl(f_41260)
static void f_41260(C_word t0,C_word t1) C_noret;
C_noret_decl(f_41283)
static void C_ccall f_41283(C_word c,C_word *av) C_noret;
C_noret_decl(f_41307)
static void C_ccall f_41307(C_word c,C_word *av) C_noret;
C_noret_decl(f_41317)
static void C_ccall f_41317(C_word c,C_word *av) C_noret;
C_noret_decl(f_41326)
static void C_ccall f_41326(C_word c,C_word *av) C_noret;
C_noret_decl(f_41367)
static void C_ccall f_41367(C_word c,C_word *av) C_noret;
C_noret_decl(f_41389)
static void C_ccall f_41389(C_word c,C_word *av) C_noret;
C_noret_decl(f_41398)
static void C_ccall f_41398(C_word c,C_word *av) C_noret;
C_noret_decl(f_41402)
static void C_ccall f_41402(C_word c,C_word *av) C_noret;
C_noret_decl(f_41407)
static void C_ccall f_41407(C_word c,C_word *av) C_noret;
C_noret_decl(f_41417)
static void C_ccall f_41417(C_word c,C_word *av) C_noret;
C_noret_decl(f_41427)
static void C_ccall f_41427(C_word c,C_word *av) C_noret;
C_noret_decl(f_41437)
static void C_ccall f_41437(C_word c,C_word *av) C_noret;
C_noret_decl(f_41447)
static void C_ccall f_41447(C_word c,C_word *av) C_noret;
C_noret_decl(f_41457)
static void C_ccall f_41457(C_word c,C_word *av) C_noret;
C_noret_decl(f_41467)
static void C_ccall f_41467(C_word c,C_word *av) C_noret;
C_noret_decl(f_41477)
static void C_ccall f_41477(C_word c,C_word *av) C_noret;
C_noret_decl(f_41487)
static void C_ccall f_41487(C_word c,C_word *av) C_noret;
C_noret_decl(f_41497)
static void C_ccall f_41497(C_word c,C_word *av) C_noret;
C_noret_decl(f_41507)
static void C_ccall f_41507(C_word c,C_word *av) C_noret;
C_noret_decl(f_41517)
static void C_ccall f_41517(C_word c,C_word *av) C_noret;
C_noret_decl(f_41527)
static void C_ccall f_41527(C_word c,C_word *av) C_noret;
C_noret_decl(f_41537)
static void C_ccall f_41537(C_word c,C_word *av) C_noret;
C_noret_decl(f_41553)
static void C_ccall f_41553(C_word c,C_word *av) C_noret;
C_noret_decl(f_41561)
static void C_ccall f_41561(C_word c,C_word *av) C_noret;
C_noret_decl(f_41577)
static void C_ccall f_41577(C_word c,C_word *av) C_noret;
C_noret_decl(f_41593)
static void C_ccall f_41593(C_word c,C_word *av) C_noret;
C_noret_decl(f_41603)
static void C_ccall f_41603(C_word c,C_word *av) C_noret;
C_noret_decl(f_41613)
static void C_ccall f_41613(C_word c,C_word *av) C_noret;
C_noret_decl(f_41632)
static void C_ccall f_41632(C_word c,C_word *av) C_noret;
C_noret_decl(f_41648)
static void C_ccall f_41648(C_word c,C_word *av) C_noret;
C_noret_decl(f_41661)
static void C_ccall f_41661(C_word c,C_word *av) C_noret;
C_noret_decl(f_41667)
static void C_ccall f_41667(C_word c,C_word *av) C_noret;
C_noret_decl(f_41699)
static void C_ccall f_41699(C_word c,C_word *av) C_noret;
C_noret_decl(f_41715)
static void C_ccall f_41715(C_word c,C_word *av) C_noret;
C_noret_decl(f_41719)
static void C_ccall f_41719(C_word c,C_word *av) C_noret;
C_noret_decl(f_41729)
static void C_ccall f_41729(C_word c,C_word *av) C_noret;
C_noret_decl(f_41735)
static void C_ccall f_41735(C_word c,C_word *av) C_noret;
C_noret_decl(f_41742)
static void C_ccall f_41742(C_word c,C_word *av) C_noret;
C_noret_decl(f_41760)
static void C_ccall f_41760(C_word c,C_word *av) C_noret;
C_noret_decl(f_41764)
static void C_ccall f_41764(C_word c,C_word *av) C_noret;
C_noret_decl(f_41772)
static void C_ccall f_41772(C_word c,C_word *av) C_noret;
C_noret_decl(f_41775)
static void C_ccall f_41775(C_word c,C_word *av) C_noret;
C_noret_decl(f_41788)
static void C_ccall f_41788(C_word c,C_word *av) C_noret;
C_noret_decl(f_41791)
static void C_ccall f_41791(C_word c,C_word *av) C_noret;
C_noret_decl(f_41803)
static void C_ccall f_41803(C_word c,C_word *av) C_noret;
C_noret_decl(f_41817)
static void C_ccall f_41817(C_word c,C_word *av) C_noret;
C_noret_decl(f_41820)
static void C_ccall f_41820(C_word c,C_word *av) C_noret;
C_noret_decl(f_41826)
static void C_ccall f_41826(C_word c,C_word *av) C_noret;
C_noret_decl(f_41829)
static void C_ccall f_41829(C_word c,C_word *av) C_noret;
C_noret_decl(f_41832)
static void C_ccall f_41832(C_word c,C_word *av) C_noret;
C_noret_decl(f_41839)
static void f_41839(C_word t0,C_word t1) C_noret;
C_noret_decl(f_41848)
static void f_41848(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_41864)
static void C_ccall f_41864(C_word c,C_word *av) C_noret;
C_noret_decl(f_41875)
static void C_ccall f_41875(C_word c,C_word *av) C_noret;
C_noret_decl(f_41886)
static void C_ccall f_41886(C_word c,C_word *av) C_noret;
C_noret_decl(f_41890)
static void C_ccall f_41890(C_word c,C_word *av) C_noret;
C_noret_decl(f_41939)
static void C_ccall f_41939(C_word c,C_word *av) C_noret;
C_noret_decl(f_41946)
static void f_41946(C_word t0,C_word t1) C_noret;
C_noret_decl(f_41959)
static void f_41959(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_41981)
static void C_ccall f_41981(C_word c,C_word *av) C_noret;
C_noret_decl(f_42005)
static void C_ccall f_42005(C_word c,C_word *av) C_noret;
C_noret_decl(f_42009)
static void C_ccall f_42009(C_word c,C_word *av) C_noret;
C_noret_decl(f_42026)
static void C_ccall f_42026(C_word c,C_word *av) C_noret;
C_noret_decl(f_42040)
static void C_ccall f_42040(C_word c,C_word *av) C_noret;
C_noret_decl(f_42048)
static void C_ccall f_42048(C_word c,C_word *av) C_noret;
C_noret_decl(f_42052)
static void C_ccall f_42052(C_word c,C_word *av) C_noret;
C_noret_decl(f_42067)
static void C_ccall f_42067(C_word c,C_word *av) C_noret;
C_noret_decl(f_42071)
static void C_ccall f_42071(C_word c,C_word *av) C_noret;
C_noret_decl(f_42085)
static void C_ccall f_42085(C_word c,C_word *av) C_noret;
C_noret_decl(f_42125)
static void C_ccall f_42125(C_word c,C_word *av) C_noret;
C_noret_decl(C_library_toplevel)
C_extern void C_ccall C_library_toplevel(C_word c,C_word *av) C_noret;

C_noret_decl(trf_11861)
static void C_ccall trf_11861(C_word c,C_word *av) C_noret;
static void C_ccall trf_11861(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_11861(t0,t1,t2,t3);}

C_noret_decl(trf_11912)
static void C_ccall trf_11912(C_word c,C_word *av) C_noret;
static void C_ccall trf_11912(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_11912(t0,t1,t2);}

C_noret_decl(trf_11962)
static void C_ccall trf_11962(C_word c,C_word *av) C_noret;
static void C_ccall trf_11962(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_11962(t0,t1,t2);}

C_noret_decl(trf_12801)
static void C_ccall trf_12801(C_word c,C_word *av) C_noret;
static void C_ccall trf_12801(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_12801(t0,t1,t2,t3);}

C_noret_decl(trf_12838)
static void C_ccall trf_12838(C_word c,C_word *av) C_noret;
static void C_ccall trf_12838(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_12838(t0,t1,t2);}

C_noret_decl(trf_12924)
static void C_ccall trf_12924(C_word c,C_word *av) C_noret;
static void C_ccall trf_12924(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_12924(t0,t1,t2);}

C_noret_decl(trf_12957)
static void C_ccall trf_12957(C_word c,C_word *av) C_noret;
static void C_ccall trf_12957(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_12957(t0,t1,t2);}

C_noret_decl(trf_13075)
static void C_ccall trf_13075(C_word c,C_word *av) C_noret;
static void C_ccall trf_13075(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_13075(t0,t1,t2);}

C_noret_decl(trf_13110)
static void C_ccall trf_13110(C_word c,C_word *av) C_noret;
static void C_ccall trf_13110(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_13110(t0,t1,t2);}

C_noret_decl(trf_13174)
static void C_ccall trf_13174(C_word c,C_word *av) C_noret;
static void C_ccall trf_13174(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_13174(t0,t1,t2);}

C_noret_decl(trf_13248)
static void C_ccall trf_13248(C_word c,C_word *av) C_noret;
static void C_ccall trf_13248(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_13248(t0,t1,t2);}

C_noret_decl(trf_13284)
static void C_ccall trf_13284(C_word c,C_word *av) C_noret;
static void C_ccall trf_13284(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_13284(t0,t1,t2);}

C_noret_decl(trf_13313)
static void C_ccall trf_13313(C_word c,C_word *av) C_noret;
static void C_ccall trf_13313(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_13313(t0,t1,t2,t3);}

C_noret_decl(trf_13360)
static void C_ccall trf_13360(C_word c,C_word *av) C_noret;
static void C_ccall trf_13360(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_13360(t0,t1,t2);}

C_noret_decl(trf_13414)
static void C_ccall trf_13414(C_word c,C_word *av) C_noret;
static void C_ccall trf_13414(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_13414(t0,t1,t2,t3);}

C_noret_decl(trf_13492)
static void C_ccall trf_13492(C_word c,C_word *av) C_noret;
static void C_ccall trf_13492(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_13492(t0,t1);}

C_noret_decl(trf_13530)
static void C_ccall trf_13530(C_word c,C_word *av) C_noret;
static void C_ccall trf_13530(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_13530(t0,t1,t2);}

C_noret_decl(trf_13580)
static void C_ccall trf_13580(C_word c,C_word *av) C_noret;
static void C_ccall trf_13580(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_13580(t0,t1,t2);}

C_noret_decl(trf_13691)
static void C_ccall trf_13691(C_word c,C_word *av) C_noret;
static void C_ccall trf_13691(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_13691(t0,t1);}

C_noret_decl(trf_13722)
static void C_ccall trf_13722(C_word c,C_word *av) C_noret;
static void C_ccall trf_13722(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_13722(t0,t1,t2);}

C_noret_decl(trf_13799)
static void C_ccall trf_13799(C_word c,C_word *av) C_noret;
static void C_ccall trf_13799(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_13799(t0,t1,t2);}

C_noret_decl(trf_13993)
static void C_ccall trf_13993(C_word c,C_word *av) C_noret;
static void C_ccall trf_13993(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_13993(t0,t1,t2,t3,t4);}

C_noret_decl(trf_13997)
static void C_ccall trf_13997(C_word c,C_word *av) C_noret;
static void C_ccall trf_13997(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_13997(t0,t1);}

C_noret_decl(trf_14056)
static void C_ccall trf_14056(C_word c,C_word *av) C_noret;
static void C_ccall trf_14056(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_14056(t0,t1);}

C_noret_decl(trf_14679)
static void C_ccall trf_14679(C_word c,C_word *av) C_noret;
static void C_ccall trf_14679(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_14679(t0,t1,t2,t3);}

C_noret_decl(trf_14728)
static void C_ccall trf_14728(C_word c,C_word *av) C_noret;
static void C_ccall trf_14728(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_14728(t0,t1);}

C_noret_decl(trf_14935)
static void C_ccall trf_14935(C_word c,C_word *av) C_noret;
static void C_ccall trf_14935(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_14935(t0,t1,t2);}

C_noret_decl(trf_14954)
static void C_ccall trf_14954(C_word c,C_word *av) C_noret;
static void C_ccall trf_14954(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_14954(t0,t1,t2);}

C_noret_decl(trf_15008)
static void C_ccall trf_15008(C_word c,C_word *av) C_noret;
static void C_ccall trf_15008(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_15008(t0,t1,t2,t3);}

C_noret_decl(trf_15212)
static void C_ccall trf_15212(C_word c,C_word *av) C_noret;
static void C_ccall trf_15212(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_15212(t0,t1);}

C_noret_decl(trf_15314)
static void C_ccall trf_15314(C_word c,C_word *av) C_noret;
static void C_ccall trf_15314(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_15314(t0,t1,t2,t3);}

C_noret_decl(trf_15425)
static void C_ccall trf_15425(C_word c,C_word *av) C_noret;
static void C_ccall trf_15425(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_15425(t0,t1,t2,t3);}

C_noret_decl(trf_15500)
static void C_ccall trf_15500(C_word c,C_word *av) C_noret;
static void C_ccall trf_15500(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_15500(t0,t1,t2,t3,t4);}

C_noret_decl(trf_15553)
static void C_ccall trf_15553(C_word c,C_word *av) C_noret;
static void C_ccall trf_15553(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_15553(t0,t1,t2,t3,t4);}

C_noret_decl(trf_15618)
static void C_ccall trf_15618(C_word c,C_word *av) C_noret;
static void C_ccall trf_15618(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_15618(t0,t1);}

C_noret_decl(trf_15734)
static void C_ccall trf_15734(C_word c,C_word *av) C_noret;
static void C_ccall trf_15734(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_15734(t0,t1);}

C_noret_decl(trf_15740)
static void C_ccall trf_15740(C_word c,C_word *av) C_noret;
static void C_ccall trf_15740(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_15740(t0,t1);}

C_noret_decl(trf_15965)
static void C_ccall trf_15965(C_word c,C_word *av) C_noret;
static void C_ccall trf_15965(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_15965(t0,t1);}

C_noret_decl(trf_15972)
static void C_ccall trf_15972(C_word c,C_word *av) C_noret;
static void C_ccall trf_15972(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_15972(t0,t1);}

C_noret_decl(trf_16000)
static void C_ccall trf_16000(C_word c,C_word *av) C_noret;
static void C_ccall trf_16000(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_16000(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_16022)
static void C_ccall trf_16022(C_word c,C_word *av) C_noret;
static void C_ccall trf_16022(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_16022(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_16158)
static void C_ccall trf_16158(C_word c,C_word *av) C_noret;
static void C_ccall trf_16158(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_16158(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_16180)
static void C_ccall trf_16180(C_word c,C_word *av) C_noret;
static void C_ccall trf_16180(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_16180(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_16361)
static void C_ccall trf_16361(C_word c,C_word *av) C_noret;
static void C_ccall trf_16361(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_16361(t0,t1,t2,t3,t4);}

C_noret_decl(trf_16440)
static void C_ccall trf_16440(C_word c,C_word *av) C_noret;
static void C_ccall trf_16440(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_16440(t0,t1,t2,t3);}

C_noret_decl(trf_16461)
static void C_ccall trf_16461(C_word c,C_word *av) C_noret;
static void C_ccall trf_16461(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_16461(t0,t1,t2,t3,t4);}

C_noret_decl(trf_16623)
static void C_ccall trf_16623(C_word c,C_word *av) C_noret;
static void C_ccall trf_16623(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_16623(t0,t1);}

C_noret_decl(trf_17319)
static void C_ccall trf_17319(C_word c,C_word *av) C_noret;
static void C_ccall trf_17319(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_17319(t0,t1,t2);}

C_noret_decl(trf_17676)
static void C_ccall trf_17676(C_word c,C_word *av) C_noret;
static void C_ccall trf_17676(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_17676(t0,t1,t2,t3);}

C_noret_decl(trf_17693)
static void C_ccall trf_17693(C_word c,C_word *av) C_noret;
static void C_ccall trf_17693(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_17693(t0,t1,t2,t3);}

C_noret_decl(trf_17858)
static void C_ccall trf_17858(C_word c,C_word *av) C_noret;
static void C_ccall trf_17858(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_17858(t0,t1,t2,t3);}

C_noret_decl(trf_18334)
static void C_ccall trf_18334(C_word c,C_word *av) C_noret;
static void C_ccall trf_18334(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_18334(t0,t1,t2);}

C_noret_decl(trf_18337)
static void C_ccall trf_18337(C_word c,C_word *av) C_noret;
static void C_ccall trf_18337(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_18337(t0,t1,t2,t3);}

C_noret_decl(trf_18516)
static void C_ccall trf_18516(C_word c,C_word *av) C_noret;
static void C_ccall trf_18516(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_18516(t0,t1,t2,t3,t4);}

C_noret_decl(trf_18560)
static void C_ccall trf_18560(C_word c,C_word *av) C_noret;
static void C_ccall trf_18560(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_18560(t0,t1,t2,t3,t4);}

C_noret_decl(trf_18823)
static void C_ccall trf_18823(C_word c,C_word *av) C_noret;
static void C_ccall trf_18823(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_18823(t0,t1);}

C_noret_decl(trf_18829)
static void C_ccall trf_18829(C_word c,C_word *av) C_noret;
static void C_ccall trf_18829(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_18829(t0,t1);}

C_noret_decl(trf_18885)
static void C_ccall trf_18885(C_word c,C_word *av) C_noret;
static void C_ccall trf_18885(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_18885(t0,t1);}

C_noret_decl(trf_18891)
static void C_ccall trf_18891(C_word c,C_word *av) C_noret;
static void C_ccall trf_18891(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_18891(t0,t1);}

C_noret_decl(trf_19455)
static void C_ccall trf_19455(C_word c,C_word *av) C_noret;
static void C_ccall trf_19455(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_19455(t0,t1);}

C_noret_decl(trf_19490)
static void C_ccall trf_19490(C_word c,C_word *av) C_noret;
static void C_ccall trf_19490(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_19490(t0,t1,t2,t3);}

C_noret_decl(trf_19600)
static void C_ccall trf_19600(C_word c,C_word *av) C_noret;
static void C_ccall trf_19600(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_19600(t0,t1,t2,t3);}

C_noret_decl(trf_19642)
static void C_ccall trf_19642(C_word c,C_word *av) C_noret;
static void C_ccall trf_19642(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_19642(t0,t1,t2);}

C_noret_decl(trf_19656)
static void C_ccall trf_19656(C_word c,C_word *av) C_noret;
static void C_ccall trf_19656(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_19656(t0,t1,t2);}

C_noret_decl(trf_19809)
static void C_ccall trf_19809(C_word c,C_word *av) C_noret;
static void C_ccall trf_19809(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_19809(t0,t1);}

C_noret_decl(trf_19905)
static void C_ccall trf_19905(C_word c,C_word *av) C_noret;
static void C_ccall trf_19905(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_19905(t0,t1,t2,t3);}

C_noret_decl(trf_19998)
static void C_ccall trf_19998(C_word c,C_word *av) C_noret;
static void C_ccall trf_19998(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_19998(t0,t1,t2,t3);}

C_noret_decl(trf_20063)
static void C_ccall trf_20063(C_word c,C_word *av) C_noret;
static void C_ccall trf_20063(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_20063(t0,t1,t2,t3);}

C_noret_decl(trf_20264)
static void C_ccall trf_20264(C_word c,C_word *av) C_noret;
static void C_ccall trf_20264(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20264(t0,t1);}

C_noret_decl(trf_20325)
static void C_ccall trf_20325(C_word c,C_word *av) C_noret;
static void C_ccall trf_20325(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20325(t0,t1,t2);}

C_noret_decl(trf_20368)
static void C_ccall trf_20368(C_word c,C_word *av) C_noret;
static void C_ccall trf_20368(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_20368(t0,t1,t2,t3,t4);}

C_noret_decl(trf_20386)
static void C_ccall trf_20386(C_word c,C_word *av) C_noret;
static void C_ccall trf_20386(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_20386(t0,t1,t2,t3);}

C_noret_decl(trf_20466)
static void C_ccall trf_20466(C_word c,C_word *av) C_noret;
static void C_ccall trf_20466(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20466(t0,t1,t2);}

C_noret_decl(trf_20472)
static void C_ccall trf_20472(C_word c,C_word *av) C_noret;
static void C_ccall trf_20472(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20472(t0,t1,t2);}

C_noret_decl(trf_20532)
static void C_ccall trf_20532(C_word c,C_word *av) C_noret;
static void C_ccall trf_20532(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20532(t0,t1);}

C_noret_decl(trf_20570)
static void C_ccall trf_20570(C_word c,C_word *av) C_noret;
static void C_ccall trf_20570(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20570(t0,t1,t2);}

C_noret_decl(trf_20576)
static void C_ccall trf_20576(C_word c,C_word *av) C_noret;
static void C_ccall trf_20576(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20576(t0,t1,t2);}

C_noret_decl(trf_20618)
static void C_ccall trf_20618(C_word c,C_word *av) C_noret;
static void C_ccall trf_20618(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_20618(t0,t1,t2,t3,t4);}

C_noret_decl(trf_20674)
static void C_ccall trf_20674(C_word c,C_word *av) C_noret;
static void C_ccall trf_20674(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20674(t0,t1,t2);}

C_noret_decl(trf_20687)
static void C_ccall trf_20687(C_word c,C_word *av) C_noret;
static void C_ccall trf_20687(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20687(t0,t1);}

C_noret_decl(trf_20727)
static void C_ccall trf_20727(C_word c,C_word *av) C_noret;
static void C_ccall trf_20727(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_20727(t0,t1,t2,t3,t4);}

C_noret_decl(trf_20746)
static void C_ccall trf_20746(C_word c,C_word *av) C_noret;
static void C_ccall trf_20746(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20746(t0,t1);}

C_noret_decl(trf_20758)
static void C_ccall trf_20758(C_word c,C_word *av) C_noret;
static void C_ccall trf_20758(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20758(t0,t1);}

C_noret_decl(trf_20785)
static void C_ccall trf_20785(C_word c,C_word *av) C_noret;
static void C_ccall trf_20785(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20785(t0,t1);}

C_noret_decl(trf_20939)
static void C_ccall trf_20939(C_word c,C_word *av) C_noret;
static void C_ccall trf_20939(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_20939(t0,t1,t2,t3);}

C_noret_decl(trf_20946)
static void C_ccall trf_20946(C_word c,C_word *av) C_noret;
static void C_ccall trf_20946(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20946(t0,t1);}

C_noret_decl(trf_21017)
static void C_ccall trf_21017(C_word c,C_word *av) C_noret;
static void C_ccall trf_21017(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21017(t0,t1);}

C_noret_decl(trf_21281)
static void C_ccall trf_21281(C_word c,C_word *av) C_noret;
static void C_ccall trf_21281(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_21281(t0,t1,t2);}

C_noret_decl(trf_21294)
static void C_ccall trf_21294(C_word c,C_word *av) C_noret;
static void C_ccall trf_21294(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21294(t0,t1);}

C_noret_decl(trf_21349)
static void C_ccall trf_21349(C_word c,C_word *av) C_noret;
static void C_ccall trf_21349(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21349(t0,t1);}

C_noret_decl(trf_21768)
static void C_ccall trf_21768(C_word c,C_word *av) C_noret;
static void C_ccall trf_21768(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_21768(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_22049)
static void C_ccall trf_22049(C_word c,C_word *av) C_noret;
static void C_ccall trf_22049(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_22049(t0,t1,t2,t3,t4);}

C_noret_decl(trf_22076)
static void C_ccall trf_22076(C_word c,C_word *av) C_noret;
static void C_ccall trf_22076(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_22076(t0,t1,t2);}

C_noret_decl(trf_22117)
static void C_ccall trf_22117(C_word c,C_word *av) C_noret;
static void C_ccall trf_22117(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_22117(t0,t1,t2,t3);}

C_noret_decl(trf_22391)
static void C_ccall trf_22391(C_word c,C_word *av) C_noret;
static void C_ccall trf_22391(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_22391(t0,t1,t2);}

C_noret_decl(trf_22503)
static void C_ccall trf_22503(C_word c,C_word *av) C_noret;
static void C_ccall trf_22503(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_22503(t0,t1,t2,t3);}

C_noret_decl(trf_22536)
static void C_ccall trf_22536(C_word c,C_word *av) C_noret;
static void C_ccall trf_22536(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_22536(t0,t1,t2,t3);}

C_noret_decl(trf_22783)
static void C_ccall trf_22783(C_word c,C_word *av) C_noret;
static void C_ccall trf_22783(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_22783(t0,t1);}

C_noret_decl(trf_22867)
static void C_ccall trf_22867(C_word c,C_word *av) C_noret;
static void C_ccall trf_22867(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_22867(t0,t1);}

C_noret_decl(trf_22921)
static void C_ccall trf_22921(C_word c,C_word *av) C_noret;
static void C_ccall trf_22921(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_22921(t0,t1,t2,t3);}

C_noret_decl(trf_23084)
static void C_ccall trf_23084(C_word c,C_word *av) C_noret;
static void C_ccall trf_23084(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_23084(t0,t1,t2);}

C_noret_decl(trf_23244)
static void C_ccall trf_23244(C_word c,C_word *av) C_noret;
static void C_ccall trf_23244(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_23244(t0,t1,t2,t3);}

C_noret_decl(trf_23354)
static void C_ccall trf_23354(C_word c,C_word *av) C_noret;
static void C_ccall trf_23354(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_23354(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_23530)
static void C_ccall trf_23530(C_word c,C_word *av) C_noret;
static void C_ccall trf_23530(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_23530(t0,t1,t2,t3,t4);}

C_noret_decl(trf_23594)
static void C_ccall trf_23594(C_word c,C_word *av) C_noret;
static void C_ccall trf_23594(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_23594(t0,t1,t2);}

C_noret_decl(trf_23735)
static void C_ccall trf_23735(C_word c,C_word *av) C_noret;
static void C_ccall trf_23735(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_23735(t0,t1,t2,t3);}

C_noret_decl(trf_23790)
static void C_ccall trf_23790(C_word c,C_word *av) C_noret;
static void C_ccall trf_23790(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_23790(t0,t1,t2,t3,t4);}

C_noret_decl(trf_23837)
static void C_ccall trf_23837(C_word c,C_word *av) C_noret;
static void C_ccall trf_23837(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_23837(t0,t1,t2,t3,t4);}

C_noret_decl(trf_23880)
static void C_ccall trf_23880(C_word c,C_word *av) C_noret;
static void C_ccall trf_23880(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_23880(t0,t1,t2,t3,t4);}

C_noret_decl(trf_23923)
static void C_ccall trf_23923(C_word c,C_word *av) C_noret;
static void C_ccall trf_23923(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_23923(t0,t1,t2,t3,t4);}

C_noret_decl(trf_23966)
static void C_ccall trf_23966(C_word c,C_word *av) C_noret;
static void C_ccall trf_23966(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_23966(t0,t1,t2,t3,t4);}

C_noret_decl(trf_23999)
static void C_ccall trf_23999(C_word c,C_word *av) C_noret;
static void C_ccall trf_23999(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_23999(t0,t1,t2);}

C_noret_decl(trf_24207)
static void C_ccall trf_24207(C_word c,C_word *av) C_noret;
static void C_ccall trf_24207(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24207(t0,t1,t2);}

C_noret_decl(trf_24245)
static void C_ccall trf_24245(C_word c,C_word *av) C_noret;
static void C_ccall trf_24245(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24245(t0,t1,t2);}

C_noret_decl(trf_24293)
static void C_ccall trf_24293(C_word c,C_word *av) C_noret;
static void C_ccall trf_24293(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24293(t0,t1,t2);}

C_noret_decl(trf_24354)
static void C_ccall trf_24354(C_word c,C_word *av) C_noret;
static void C_ccall trf_24354(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24354(t0,t1,t2);}

C_noret_decl(trf_24384)
static void C_ccall trf_24384(C_word c,C_word *av) C_noret;
static void C_ccall trf_24384(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24384(t0,t1,t2);}

C_noret_decl(trf_24439)
static void C_ccall trf_24439(C_word c,C_word *av) C_noret;
static void C_ccall trf_24439(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24439(t0,t1,t2);}

C_noret_decl(trf_24480)
static void C_ccall trf_24480(C_word c,C_word *av) C_noret;
static void C_ccall trf_24480(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24480(t0,t1,t2);}

C_noret_decl(trf_24594)
static void C_ccall trf_24594(C_word c,C_word *av) C_noret;
static void C_ccall trf_24594(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24594(t0,t1,t2);}

C_noret_decl(trf_24984)
static void C_ccall trf_24984(C_word c,C_word *av) C_noret;
static void C_ccall trf_24984(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_24984(t0,t1,t2,t3,t4);}

C_noret_decl(trf_25034)
static void C_ccall trf_25034(C_word c,C_word *av) C_noret;
static void C_ccall trf_25034(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_25034(t0,t1,t2);}

C_noret_decl(trf_25091)
static void C_ccall trf_25091(C_word c,C_word *av) C_noret;
static void C_ccall trf_25091(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_25091(t0,t1);}

C_noret_decl(trf_25101)
static void C_ccall trf_25101(C_word c,C_word *av) C_noret;
static void C_ccall trf_25101(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_25101(t0,t1);}

C_noret_decl(trf_25214)
static void C_ccall trf_25214(C_word c,C_word *av) C_noret;
static void C_ccall trf_25214(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_25214(t0,t1,t2,t3);}

C_noret_decl(trf_25470)
static void C_ccall trf_25470(C_word c,C_word *av) C_noret;
static void C_ccall trf_25470(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_25470(t0,t1,t2);}

C_noret_decl(trf_25483)
static void C_ccall trf_25483(C_word c,C_word *av) C_noret;
static void C_ccall trf_25483(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_25483(t0,t1,t2);}

C_noret_decl(trf_25542)
static void C_ccall trf_25542(C_word c,C_word *av) C_noret;
static void C_ccall trf_25542(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_25542(t0,t1,t2);}

C_noret_decl(trf_25812)
static void C_ccall trf_25812(C_word c,C_word *av) C_noret;
static void C_ccall trf_25812(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_25812(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_25816)
static void C_ccall trf_25816(C_word c,C_word *av) C_noret;
static void C_ccall trf_25816(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_25816(t0,t1);}

C_noret_decl(trf_25846)
static void C_ccall trf_25846(C_word c,C_word *av) C_noret;
static void C_ccall trf_25846(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_25846(t0,t1);}

C_noret_decl(trf_25866)
static void C_ccall trf_25866(C_word c,C_word *av) C_noret;
static void C_ccall trf_25866(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_25866(t0,t1,t2,t3);}

C_noret_decl(trf_25875)
static void C_ccall trf_25875(C_word c,C_word *av) C_noret;
static void C_ccall trf_25875(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_25875(t0,t1,t2);}

C_noret_decl(trf_25880)
static void C_ccall trf_25880(C_word c,C_word *av) C_noret;
static void C_ccall trf_25880(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_25880(t0,t1);}

C_noret_decl(trf_26249)
static void C_ccall trf_26249(C_word c,C_word *av) C_noret;
static void C_ccall trf_26249(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_26249(t0,t1,t2,t3,t4);}

C_noret_decl(trf_26258)
static void C_ccall trf_26258(C_word c,C_word *av) C_noret;
static void C_ccall trf_26258(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26258(t0,t1);}

C_noret_decl(trf_26268)
static void C_ccall trf_26268(C_word c,C_word *av) C_noret;
static void C_ccall trf_26268(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26268(t0,t1,t2);}

C_noret_decl(trf_26295)
static void C_ccall trf_26295(C_word c,C_word *av) C_noret;
static void C_ccall trf_26295(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26295(t0,t1,t2);}

C_noret_decl(trf_26304)
static void C_ccall trf_26304(C_word c,C_word *av) C_noret;
static void C_ccall trf_26304(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26304(t0,t1,t2);}

C_noret_decl(trf_26330)
static void C_ccall trf_26330(C_word c,C_word *av) C_noret;
static void C_ccall trf_26330(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_26330(t0,t1,t2,t3);}

C_noret_decl(trf_26358)
static void C_ccall trf_26358(C_word c,C_word *av) C_noret;
static void C_ccall trf_26358(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_26358(t0,t1,t2,t3);}

C_noret_decl(trf_26364)
static void C_ccall trf_26364(C_word c,C_word *av) C_noret;
static void C_ccall trf_26364(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26364(t0,t1,t2);}

C_noret_decl(trf_26439)
static void C_ccall trf_26439(C_word c,C_word *av) C_noret;
static void C_ccall trf_26439(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26439(t0,t1,t2);}

C_noret_decl(trf_26478)
static void C_ccall trf_26478(C_word c,C_word *av) C_noret;
static void C_ccall trf_26478(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26478(t0,t1);}

C_noret_decl(trf_26481)
static void C_ccall trf_26481(C_word c,C_word *av) C_noret;
static void C_ccall trf_26481(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26481(t0,t1);}

C_noret_decl(trf_26491)
static void C_ccall trf_26491(C_word c,C_word *av) C_noret;
static void C_ccall trf_26491(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26491(t0,t1,t2);}

C_noret_decl(trf_26529)
static void C_ccall trf_26529(C_word c,C_word *av) C_noret;
static void C_ccall trf_26529(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_26529(t0,t1,t2,t3,t4);}

C_noret_decl(trf_26535)
static void C_ccall trf_26535(C_word c,C_word *av) C_noret;
static void C_ccall trf_26535(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_26535(t0,t1,t2,t3);}

C_noret_decl(trf_26589)
static void C_ccall trf_26589(C_word c,C_word *av) C_noret;
static void C_ccall trf_26589(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26589(t0,t1,t2);}

C_noret_decl(trf_26592)
static void C_ccall trf_26592(C_word c,C_word *av) C_noret;
static void C_ccall trf_26592(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26592(t0,t1,t2);}

C_noret_decl(trf_26615)
static void C_ccall trf_26615(C_word c,C_word *av) C_noret;
static void C_ccall trf_26615(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26615(t0,t1);}

C_noret_decl(trf_26624)
static void C_ccall trf_26624(C_word c,C_word *av) C_noret;
static void C_ccall trf_26624(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26624(t0,t1,t2);}

C_noret_decl(trf_26679)
static void C_ccall trf_26679(C_word c,C_word *av) C_noret;
static void C_ccall trf_26679(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26679(t0,t1);}

C_noret_decl(trf_26729)
static void C_ccall trf_26729(C_word c,C_word *av) C_noret;
static void C_ccall trf_26729(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26729(t0,t1,t2);}

C_noret_decl(trf_26739)
static void C_ccall trf_26739(C_word c,C_word *av) C_noret;
static void C_ccall trf_26739(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_26739(t0,t1,t2,t3);}

C_noret_decl(trf_26956)
static void C_ccall trf_26956(C_word c,C_word *av) C_noret;
static void C_ccall trf_26956(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26956(t0,t1);}

C_noret_decl(trf_26976)
static void C_ccall trf_26976(C_word c,C_word *av) C_noret;
static void C_ccall trf_26976(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26976(t0,t1);}

C_noret_decl(trf_26981)
static void C_ccall trf_26981(C_word c,C_word *av) C_noret;
static void C_ccall trf_26981(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_26981(t0,t1,t2,t3);}

C_noret_decl(trf_27080)
static void C_ccall trf_27080(C_word c,C_word *av) C_noret;
static void C_ccall trf_27080(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_27080(t0,t1);}

C_noret_decl(trf_27228)
static void C_ccall trf_27228(C_word c,C_word *av) C_noret;
static void C_ccall trf_27228(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_27228(t0,t1,t2,t3);}

C_noret_decl(trf_27237)
static void C_ccall trf_27237(C_word c,C_word *av) C_noret;
static void C_ccall trf_27237(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27237(t0,t1,t2);}

C_noret_decl(trf_27292)
static void C_ccall trf_27292(C_word c,C_word *av) C_noret;
static void C_ccall trf_27292(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27292(t0,t1,t2);}

C_noret_decl(trf_27299)
static void C_ccall trf_27299(C_word c,C_word *av) C_noret;
static void C_ccall trf_27299(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_27299(t0,t1);}

C_noret_decl(trf_27342)
static void C_ccall trf_27342(C_word c,C_word *av) C_noret;
static void C_ccall trf_27342(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_27342(t0,t1);}

C_noret_decl(trf_27489)
static void C_ccall trf_27489(C_word c,C_word *av) C_noret;
static void C_ccall trf_27489(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_27489(t0,t1);}

C_noret_decl(trf_27507)
static void C_ccall trf_27507(C_word c,C_word *av) C_noret;
static void C_ccall trf_27507(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_27507(t0,t1,t2,t3);}

C_noret_decl(trf_27576)
static void C_ccall trf_27576(C_word c,C_word *av) C_noret;
static void C_ccall trf_27576(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27576(t0,t1,t2);}

C_noret_decl(trf_27627)
static void C_ccall trf_27627(C_word c,C_word *av) C_noret;
static void C_ccall trf_27627(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27627(t0,t1,t2);}

C_noret_decl(trf_27694)
static void C_ccall trf_27694(C_word c,C_word *av) C_noret;
static void C_ccall trf_27694(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_27694(t0,t1);}

C_noret_decl(trf_27704)
static void C_ccall trf_27704(C_word c,C_word *av) C_noret;
static void C_ccall trf_27704(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_27704(t0,t1,t2,t3);}

C_noret_decl(trf_27714)
static void C_ccall trf_27714(C_word c,C_word *av) C_noret;
static void C_ccall trf_27714(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_27714(t0,t1);}

C_noret_decl(trf_27755)
static void C_ccall trf_27755(C_word c,C_word *av) C_noret;
static void C_ccall trf_27755(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_27755(t0,t1);}

C_noret_decl(trf_27765)
static void C_ccall trf_27765(C_word c,C_word *av) C_noret;
static void C_ccall trf_27765(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_27765(t0,t1,t2,t3);}

C_noret_decl(trf_27801)
static void C_ccall trf_27801(C_word c,C_word *av) C_noret;
static void C_ccall trf_27801(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_27801(t0,t1);}

C_noret_decl(trf_27826)
static void C_ccall trf_27826(C_word c,C_word *av) C_noret;
static void C_ccall trf_27826(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27826(t0,t1,t2);}

C_noret_decl(trf_27831)
static void C_ccall trf_27831(C_word c,C_word *av) C_noret;
static void C_ccall trf_27831(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_27831(t0,t1);}

C_noret_decl(trf_27836)
static void C_ccall trf_27836(C_word c,C_word *av) C_noret;
static void C_ccall trf_27836(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_27836(t0,t1,t2,t3,t4);}

C_noret_decl(trf_27849)
static void C_ccall trf_27849(C_word c,C_word *av) C_noret;
static void C_ccall trf_27849(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_27849(t0,t1);}

C_noret_decl(trf_27855)
static void C_ccall trf_27855(C_word c,C_word *av) C_noret;
static void C_ccall trf_27855(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_27855(t0,t1);}

C_noret_decl(trf_27885)
static void C_ccall trf_27885(C_word c,C_word *av) C_noret;
static void C_ccall trf_27885(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_27885(t0,t1);}

C_noret_decl(trf_28074)
static void C_ccall trf_28074(C_word c,C_word *av) C_noret;
static void C_ccall trf_28074(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_28074(t0,t1);}

C_noret_decl(trf_28113)
static void C_ccall trf_28113(C_word c,C_word *av) C_noret;
static void C_ccall trf_28113(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_28113(t0,t1);}

C_noret_decl(trf_28266)
static void C_ccall trf_28266(C_word c,C_word *av) C_noret;
static void C_ccall trf_28266(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_28266(t0,t1);}

C_noret_decl(trf_28291)
static void C_ccall trf_28291(C_word c,C_word *av) C_noret;
static void C_ccall trf_28291(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_28291(t0,t1);}

C_noret_decl(trf_28297)
static void C_ccall trf_28297(C_word c,C_word *av) C_noret;
static void C_ccall trf_28297(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_28297(t0,t1,t2);}

C_noret_decl(trf_28378)
static void C_ccall trf_28378(C_word c,C_word *av) C_noret;
static void C_ccall trf_28378(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_28378(t0,t1);}

C_noret_decl(trf_28391)
static void C_ccall trf_28391(C_word c,C_word *av) C_noret;
static void C_ccall trf_28391(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_28391(t0,t1,t2);}

C_noret_decl(trf_28609)
static void C_ccall trf_28609(C_word c,C_word *av) C_noret;
static void C_ccall trf_28609(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_28609(t0,t1,t2);}

C_noret_decl(trf_28982)
static void C_ccall trf_28982(C_word c,C_word *av) C_noret;
static void C_ccall trf_28982(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_28982(t0,t1);}

C_noret_decl(trf_29345)
static void C_ccall trf_29345(C_word c,C_word *av) C_noret;
static void C_ccall trf_29345(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_29345(t0,t1,t2);}

C_noret_decl(trf_29358)
static void C_ccall trf_29358(C_word c,C_word *av) C_noret;
static void C_ccall trf_29358(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_29358(t0,t1);}

C_noret_decl(trf_29500)
static void C_ccall trf_29500(C_word c,C_word *av) C_noret;
static void C_ccall trf_29500(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_29500(t0,t1,t2,t3);}

C_noret_decl(trf_29516)
static void C_ccall trf_29516(C_word c,C_word *av) C_noret;
static void C_ccall trf_29516(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_29516(t0,t1,t2);}

C_noret_decl(trf_29558)
static void C_ccall trf_29558(C_word c,C_word *av) C_noret;
static void C_ccall trf_29558(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_29558(t0,t1,t2,t3);}

C_noret_decl(trf_29565)
static void C_ccall trf_29565(C_word c,C_word *av) C_noret;
static void C_ccall trf_29565(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_29565(t0,t1);}

C_noret_decl(trf_29741)
static void C_ccall trf_29741(C_word c,C_word *av) C_noret;
static void C_ccall trf_29741(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_29741(t0,t1,t2);}

C_noret_decl(trf_29792)
static void C_ccall trf_29792(C_word c,C_word *av) C_noret;
static void C_ccall trf_29792(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_29792(t0,t1,t2);}

C_noret_decl(trf_29854)
static void C_ccall trf_29854(C_word c,C_word *av) C_noret;
static void C_ccall trf_29854(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_29854(t0,t1,t2,t3);}

C_noret_decl(trf_29913)
static void C_ccall trf_29913(C_word c,C_word *av) C_noret;
static void C_ccall trf_29913(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_29913(t0,t1,t2);}

C_noret_decl(trf_29937)
static void C_ccall trf_29937(C_word c,C_word *av) C_noret;
static void C_ccall trf_29937(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_29937(t0,t1,t2,t3);}

C_noret_decl(trf_29997)
static void C_ccall trf_29997(C_word c,C_word *av) C_noret;
static void C_ccall trf_29997(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_29997(t0,t1,t2,t3);}

C_noret_decl(trf_30027)
static void C_ccall trf_30027(C_word c,C_word *av) C_noret;
static void C_ccall trf_30027(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_30027(t0,t1,t2,t3);}

C_noret_decl(trf_30039)
static void C_ccall trf_30039(C_word c,C_word *av) C_noret;
static void C_ccall trf_30039(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30039(t0,t1,t2);}

C_noret_decl(trf_30112)
static void C_ccall trf_30112(C_word c,C_word *av) C_noret;
static void C_ccall trf_30112(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30112(t0,t1,t2);}

C_noret_decl(trf_30163)
static void C_ccall trf_30163(C_word c,C_word *av) C_noret;
static void C_ccall trf_30163(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30163(t0,t1,t2);}

C_noret_decl(trf_30238)
static void C_ccall trf_30238(C_word c,C_word *av) C_noret;
static void C_ccall trf_30238(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_30238(t0,t1);}

C_noret_decl(trf_30343)
static void C_ccall trf_30343(C_word c,C_word *av) C_noret;
static void C_ccall trf_30343(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30343(t0,t1,t2);}

C_noret_decl(trf_30408)
static void C_ccall trf_30408(C_word c,C_word *av) C_noret;
static void C_ccall trf_30408(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30408(t0,t1,t2);}

C_noret_decl(trf_30568)
static void C_ccall trf_30568(C_word c,C_word *av) C_noret;
static void C_ccall trf_30568(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_30568(t0,t1,t2,t3);}

C_noret_decl(trf_30757)
static void C_ccall trf_30757(C_word c,C_word *av) C_noret;
static void C_ccall trf_30757(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30757(t0,t1,t2);}

C_noret_decl(trf_30934)
static void C_ccall trf_30934(C_word c,C_word *av) C_noret;
static void C_ccall trf_30934(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_30934(t0,t1,t2,t3);}

C_noret_decl(trf_31331)
static void C_ccall trf_31331(C_word c,C_word *av) C_noret;
static void C_ccall trf_31331(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_31331(t0,t1);}

C_noret_decl(trf_31342)
static void C_ccall trf_31342(C_word c,C_word *av) C_noret;
static void C_ccall trf_31342(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_31342(t0,t1,t2,t3,t4);}

C_noret_decl(trf_31365)
static void C_ccall trf_31365(C_word c,C_word *av) C_noret;
static void C_ccall trf_31365(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_31365(t0,t1,t2);}

C_noret_decl(trf_31385)
static void C_ccall trf_31385(C_word c,C_word *av) C_noret;
static void C_ccall trf_31385(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_31385(t0,t1);}

C_noret_decl(trf_31400)
static void C_ccall trf_31400(C_word c,C_word *av) C_noret;
static void C_ccall trf_31400(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_31400(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_31461)
static void C_ccall trf_31461(C_word c,C_word *av) C_noret;
static void C_ccall trf_31461(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_31461(t0,t1);}

C_noret_decl(trf_31604)
static void C_ccall trf_31604(C_word c,C_word *av) C_noret;
static void C_ccall trf_31604(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_31604(t0,t1,t2);}

C_noret_decl(trf_31619)
static void C_ccall trf_31619(C_word c,C_word *av) C_noret;
static void C_ccall trf_31619(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_31619(t0,t1,t2);}

C_noret_decl(trf_31722)
static void C_ccall trf_31722(C_word c,C_word *av) C_noret;
static void C_ccall trf_31722(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_31722(t0,t1,t2);}

C_noret_decl(trf_31741)
static void C_ccall trf_31741(C_word c,C_word *av) C_noret;
static void C_ccall trf_31741(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_31741(t0,t1);}

C_noret_decl(trf_31860)
static void C_ccall trf_31860(C_word c,C_word *av) C_noret;
static void C_ccall trf_31860(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_31860(t0,t1,t2);}

C_noret_decl(trf_31897)
static void C_ccall trf_31897(C_word c,C_word *av) C_noret;
static void C_ccall trf_31897(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_31897(t0,t1);}

C_noret_decl(trf_31931)
static void C_ccall trf_31931(C_word c,C_word *av) C_noret;
static void C_ccall trf_31931(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_31931(t0,t1,t2);}

C_noret_decl(trf_32067)
static void C_ccall trf_32067(C_word c,C_word *av) C_noret;
static void C_ccall trf_32067(C_word c,C_word *av){
C_word t0=av[0];
f_32067(t0);}

C_noret_decl(trf_32115)
static void C_ccall trf_32115(C_word c,C_word *av) C_noret;
static void C_ccall trf_32115(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_32115(t0,t1);}

C_noret_decl(trf_32139)
static void C_ccall trf_32139(C_word c,C_word *av) C_noret;
static void C_ccall trf_32139(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_32139(t0,t1,t2);}

C_noret_decl(trf_32237)
static void C_ccall trf_32237(C_word c,C_word *av) C_noret;
static void C_ccall trf_32237(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_32237(t0,t1,t2);}

C_noret_decl(trf_32285)
static void C_ccall trf_32285(C_word c,C_word *av) C_noret;
static void C_ccall trf_32285(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_32285(t0,t1);}

C_noret_decl(trf_32288)
static void C_ccall trf_32288(C_word c,C_word *av) C_noret;
static void C_ccall trf_32288(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_32288(t0,t1);}

C_noret_decl(trf_32308)
static void C_ccall trf_32308(C_word c,C_word *av) C_noret;
static void C_ccall trf_32308(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_32308(t0,t1);}

C_noret_decl(trf_32755)
static void C_ccall trf_32755(C_word c,C_word *av) C_noret;
static void C_ccall trf_32755(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_32755(t0,t1,t2,t3);}

C_noret_decl(trf_32761)
static void C_ccall trf_32761(C_word c,C_word *av) C_noret;
static void C_ccall trf_32761(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_32761(t0,t1,t2);}

C_noret_decl(trf_32777)
static void C_ccall trf_32777(C_word c,C_word *av) C_noret;
static void C_ccall trf_32777(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_32777(t0,t1);}

C_noret_decl(trf_32874)
static void C_ccall trf_32874(C_word c,C_word *av) C_noret;
static void C_ccall trf_32874(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_32874(t0,t1,t2);}

C_noret_decl(trf_32920)
static void C_ccall trf_32920(C_word c,C_word *av) C_noret;
static void C_ccall trf_32920(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_32920(t0,t1,t2);}

C_noret_decl(trf_32996)
static void C_ccall trf_32996(C_word c,C_word *av) C_noret;
static void C_ccall trf_32996(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_32996(t0,t1,t2);}

C_noret_decl(trf_33048)
static void C_ccall trf_33048(C_word c,C_word *av) C_noret;
static void C_ccall trf_33048(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_33048(t0,t1,t2);}

C_noret_decl(trf_33096)
static void C_ccall trf_33096(C_word c,C_word *av) C_noret;
static void C_ccall trf_33096(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_33096(t0,t1,t2);}

C_noret_decl(trf_33110)
static void C_ccall trf_33110(C_word c,C_word *av) C_noret;
static void C_ccall trf_33110(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_33110(t0,t1,t2);}

C_noret_decl(trf_33166)
static void C_ccall trf_33166(C_word c,C_word *av) C_noret;
static void C_ccall trf_33166(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_33166(t0,t1,t2);}

C_noret_decl(trf_33291)
static void C_ccall trf_33291(C_word c,C_word *av) C_noret;
static void C_ccall trf_33291(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_33291(t0,t1,t2);}

C_noret_decl(trf_33293)
static void C_ccall trf_33293(C_word c,C_word *av) C_noret;
static void C_ccall trf_33293(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_33293(t0,t1,t2);}

C_noret_decl(trf_33314)
static void C_ccall trf_33314(C_word c,C_word *av) C_noret;
static void C_ccall trf_33314(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_33314(t0,t1,t2);}

C_noret_decl(trf_33338)
static void C_ccall trf_33338(C_word c,C_word *av) C_noret;
static void C_ccall trf_33338(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_33338(t0,t1,t2,t3);}

C_noret_decl(trf_33392)
static void C_ccall trf_33392(C_word c,C_word *av) C_noret;
static void C_ccall trf_33392(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_33392(t0,t1,t2);}

C_noret_decl(trf_33487)
static void C_ccall trf_33487(C_word c,C_word *av) C_noret;
static void C_ccall trf_33487(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_33487(t0,t1,t2);}

C_noret_decl(trf_33492)
static void C_ccall trf_33492(C_word c,C_word *av) C_noret;
static void C_ccall trf_33492(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_33492(t0,t1);}

C_noret_decl(trf_34710)
static void C_ccall trf_34710(C_word c,C_word *av) C_noret;
static void C_ccall trf_34710(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_34710(t0,t1,t2);}

C_noret_decl(trf_34774)
static void C_ccall trf_34774(C_word c,C_word *av) C_noret;
static void C_ccall trf_34774(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_34774(t0,t1,t2);}

C_noret_decl(trf_35054)
static void C_ccall trf_35054(C_word c,C_word *av) C_noret;
static void C_ccall trf_35054(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_35054(t0,t1);}

C_noret_decl(trf_35144)
static void C_ccall trf_35144(C_word c,C_word *av) C_noret;
static void C_ccall trf_35144(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_35144(t0,t1,t2);}

C_noret_decl(trf_35188)
static void C_ccall trf_35188(C_word c,C_word *av) C_noret;
static void C_ccall trf_35188(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_35188(t0,t1);}

C_noret_decl(trf_35201)
static void C_ccall trf_35201(C_word c,C_word *av) C_noret;
static void C_ccall trf_35201(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_35201(t0,t1,t2);}

C_noret_decl(trf_35235)
static void C_ccall trf_35235(C_word c,C_word *av) C_noret;
static void C_ccall trf_35235(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_35235(t0,t1,t2);}

C_noret_decl(trf_35250)
static void C_ccall trf_35250(C_word c,C_word *av) C_noret;
static void C_ccall trf_35250(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_35250(t0,t1);}

C_noret_decl(trf_35326)
static void C_ccall trf_35326(C_word c,C_word *av) C_noret;
static void C_ccall trf_35326(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_35326(t0,t1,t2);}

C_noret_decl(trf_35425)
static void C_ccall trf_35425(C_word c,C_word *av) C_noret;
static void C_ccall trf_35425(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_35425(t0,t1);}

C_noret_decl(trf_35444)
static void C_ccall trf_35444(C_word c,C_word *av) C_noret;
static void C_ccall trf_35444(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_35444(t0,t1,t2);}

C_noret_decl(trf_35485)
static void C_ccall trf_35485(C_word c,C_word *av) C_noret;
static void C_ccall trf_35485(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_35485(t0,t1,t2,t3,t4);}

C_noret_decl(trf_35813)
static void C_ccall trf_35813(C_word c,C_word *av) C_noret;
static void C_ccall trf_35813(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_35813(t0,t1,t2);}

C_noret_decl(trf_35825)
static void C_ccall trf_35825(C_word c,C_word *av) C_noret;
static void C_ccall trf_35825(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_35825(t0,t1,t2);}

C_noret_decl(trf_35905)
static void C_ccall trf_35905(C_word c,C_word *av) C_noret;
static void C_ccall trf_35905(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_35905(t0,t1,t2,t3);}

C_noret_decl(trf_36119)
static void C_ccall trf_36119(C_word c,C_word *av) C_noret;
static void C_ccall trf_36119(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_36119(t0,t1,t2);}

C_noret_decl(trf_36157)
static void C_ccall trf_36157(C_word c,C_word *av) C_noret;
static void C_ccall trf_36157(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_36157(t0,t1,t2);}

C_noret_decl(trf_36236)
static void C_ccall trf_36236(C_word c,C_word *av) C_noret;
static void C_ccall trf_36236(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_36236(t0,t1,t2);}

C_noret_decl(trf_36364)
static void C_ccall trf_36364(C_word c,C_word *av) C_noret;
static void C_ccall trf_36364(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_36364(t0,t1);}

C_noret_decl(trf_36801)
static void C_ccall trf_36801(C_word c,C_word *av) C_noret;
static void C_ccall trf_36801(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_36801(t0,t1);}

C_noret_decl(trf_36810)
static void C_ccall trf_36810(C_word c,C_word *av) C_noret;
static void C_ccall trf_36810(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_36810(t0,t1,t2);}

C_noret_decl(trf_36869)
static void C_ccall trf_36869(C_word c,C_word *av) C_noret;
static void C_ccall trf_36869(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_36869(t0,t1);}

C_noret_decl(trf_36883)
static void C_ccall trf_36883(C_word c,C_word *av) C_noret;
static void C_ccall trf_36883(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_36883(t0,t1,t2);}

C_noret_decl(trf_36905)
static void C_ccall trf_36905(C_word c,C_word *av) C_noret;
static void C_ccall trf_36905(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_36905(t0,t1,t2);}

C_noret_decl(trf_37120)
static void C_ccall trf_37120(C_word c,C_word *av) C_noret;
static void C_ccall trf_37120(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_37120(t0,t1);}

C_noret_decl(trf_37143)
static void C_ccall trf_37143(C_word c,C_word *av) C_noret;
static void C_ccall trf_37143(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_37143(t0,t1);}

C_noret_decl(trf_37314)
static void C_ccall trf_37314(C_word c,C_word *av) C_noret;
static void C_ccall trf_37314(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_37314(t0,t1,t2,t3);}

C_noret_decl(trf_37473)
static void C_ccall trf_37473(C_word c,C_word *av) C_noret;
static void C_ccall trf_37473(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_37473(t0,t1);}

C_noret_decl(trf_37506)
static void C_ccall trf_37506(C_word c,C_word *av) C_noret;
static void C_ccall trf_37506(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_37506(t0,t1);}

C_noret_decl(trf_37509)
static void C_ccall trf_37509(C_word c,C_word *av) C_noret;
static void C_ccall trf_37509(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_37509(t0,t1);}

C_noret_decl(trf_37512)
static void C_ccall trf_37512(C_word c,C_word *av) C_noret;
static void C_ccall trf_37512(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_37512(t0,t1);}

C_noret_decl(trf_37515)
static void C_ccall trf_37515(C_word c,C_word *av) C_noret;
static void C_ccall trf_37515(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_37515(t0,t1);}

C_noret_decl(trf_37552)
static void C_ccall trf_37552(C_word c,C_word *av) C_noret;
static void C_ccall trf_37552(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_37552(t0,t1,t2);}

C_noret_decl(trf_37588)
static void C_ccall trf_37588(C_word c,C_word *av) C_noret;
static void C_ccall trf_37588(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_37588(t0,t1,t2);}

C_noret_decl(trf_37619)
static void C_ccall trf_37619(C_word c,C_word *av) C_noret;
static void C_ccall trf_37619(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_37619(t0,t1,t2);}

C_noret_decl(trf_37659)
static void C_ccall trf_37659(C_word c,C_word *av) C_noret;
static void C_ccall trf_37659(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_37659(t0,t1,t2);}

C_noret_decl(trf_37765)
static void C_ccall trf_37765(C_word c,C_word *av) C_noret;
static void C_ccall trf_37765(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_37765(t0,t1,t2);}

C_noret_decl(trf_37814)
static void C_ccall trf_37814(C_word c,C_word *av) C_noret;
static void C_ccall trf_37814(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_37814(t0,t1,t2,t3);}

C_noret_decl(trf_37858)
static void C_ccall trf_37858(C_word c,C_word *av) C_noret;
static void C_ccall trf_37858(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_37858(t0,t1,t2,t3);}

C_noret_decl(trf_37908)
static void C_ccall trf_37908(C_word c,C_word *av) C_noret;
static void C_ccall trf_37908(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_37908(t0,t1,t2,t3);}

C_noret_decl(trf_37949)
static void C_ccall trf_37949(C_word c,C_word *av) C_noret;
static void C_ccall trf_37949(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_37949(t0,t1,t2,t3);}

C_noret_decl(trf_38053)
static void C_ccall trf_38053(C_word c,C_word *av) C_noret;
static void C_ccall trf_38053(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_38053(t0,t1,t2,t3);}

C_noret_decl(trf_38074)
static void C_ccall trf_38074(C_word c,C_word *av) C_noret;
static void C_ccall trf_38074(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_38074(t0,t1,t2,t3);}

C_noret_decl(trf_38168)
static void C_ccall trf_38168(C_word c,C_word *av) C_noret;
static void C_ccall trf_38168(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_38168(t0,t1,t2,t3);}

C_noret_decl(trf_38243)
static void C_ccall trf_38243(C_word c,C_word *av) C_noret;
static void C_ccall trf_38243(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38243(t0,t1,t2);}

C_noret_decl(trf_38278)
static void C_ccall trf_38278(C_word c,C_word *av) C_noret;
static void C_ccall trf_38278(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38278(t0,t1,t2);}

C_noret_decl(trf_38336)
static void C_ccall trf_38336(C_word c,C_word *av) C_noret;
static void C_ccall trf_38336(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38336(t0,t1,t2);}

C_noret_decl(trf_38405)
static void C_ccall trf_38405(C_word c,C_word *av) C_noret;
static void C_ccall trf_38405(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38405(t0,t1,t2);}

C_noret_decl(trf_38469)
static void C_ccall trf_38469(C_word c,C_word *av) C_noret;
static void C_ccall trf_38469(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38469(t0,t1,t2);}

C_noret_decl(trf_38500)
static void C_ccall trf_38500(C_word c,C_word *av) C_noret;
static void C_ccall trf_38500(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38500(t0,t1,t2);}

C_noret_decl(trf_38558)
static void C_ccall trf_38558(C_word c,C_word *av) C_noret;
static void C_ccall trf_38558(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38558(t0,t1,t2);}

C_noret_decl(trf_38639)
static void C_ccall trf_38639(C_word c,C_word *av) C_noret;
static void C_ccall trf_38639(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38639(t0,t1,t2);}

C_noret_decl(trf_38698)
static void C_ccall trf_38698(C_word c,C_word *av) C_noret;
static void C_ccall trf_38698(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38698(t0,t1,t2);}

C_noret_decl(trf_38733)
static void C_ccall trf_38733(C_word c,C_word *av) C_noret;
static void C_ccall trf_38733(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38733(t0,t1,t2);}

C_noret_decl(trf_38791)
static void C_ccall trf_38791(C_word c,C_word *av) C_noret;
static void C_ccall trf_38791(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38791(t0,t1,t2);}

C_noret_decl(trf_38869)
static void C_ccall trf_38869(C_word c,C_word *av) C_noret;
static void C_ccall trf_38869(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38869(t0,t1,t2);}

C_noret_decl(trf_38924)
static void C_ccall trf_38924(C_word c,C_word *av) C_noret;
static void C_ccall trf_38924(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38924(t0,t1,t2);}

C_noret_decl(trf_38955)
static void C_ccall trf_38955(C_word c,C_word *av) C_noret;
static void C_ccall trf_38955(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38955(t0,t1,t2);}

C_noret_decl(trf_39013)
static void C_ccall trf_39013(C_word c,C_word *av) C_noret;
static void C_ccall trf_39013(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_39013(t0,t1,t2);}

C_noret_decl(trf_39207)
static void C_ccall trf_39207(C_word c,C_word *av) C_noret;
static void C_ccall trf_39207(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_39207(t0,t1);}

C_noret_decl(trf_39210)
static void C_ccall trf_39210(C_word c,C_word *av) C_noret;
static void C_ccall trf_39210(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_39210(t0,t1);}

C_noret_decl(trf_39314)
static void C_ccall trf_39314(C_word c,C_word *av) C_noret;
static void C_ccall trf_39314(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_39314(t0,t1,t2,t3,t4);}

C_noret_decl(trf_39396)
static void C_ccall trf_39396(C_word c,C_word *av) C_noret;
static void C_ccall trf_39396(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_39396(t0,t1);}

C_noret_decl(trf_39406)
static void C_ccall trf_39406(C_word c,C_word *av) C_noret;
static void C_ccall trf_39406(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_39406(t0,t1,t2);}

C_noret_decl(trf_39424)
static void C_ccall trf_39424(C_word c,C_word *av) C_noret;
static void C_ccall trf_39424(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_39424(t0,t1,t2);}

C_noret_decl(trf_39570)
static void C_ccall trf_39570(C_word c,C_word *av) C_noret;
static void C_ccall trf_39570(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_39570(t0,t1,t2,t3);}

C_noret_decl(trf_39686)
static void C_ccall trf_39686(C_word c,C_word *av) C_noret;
static void C_ccall trf_39686(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_39686(t0,t1,t2,t3,t4);}

C_noret_decl(trf_39761)
static void C_ccall trf_39761(C_word c,C_word *av) C_noret;
static void C_ccall trf_39761(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_39761(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_39785)
static void C_ccall trf_39785(C_word c,C_word *av) C_noret;
static void C_ccall trf_39785(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_39785(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_39809)
static void C_ccall trf_39809(C_word c,C_word *av) C_noret;
static void C_ccall trf_39809(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_39809(t0,t1,t2);}

C_noret_decl(trf_40124)
static void C_ccall trf_40124(C_word c,C_word *av) C_noret;
static void C_ccall trf_40124(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_40124(t0,t1,t2,t3,t4);}

C_noret_decl(trf_40355)
static void C_ccall trf_40355(C_word c,C_word *av) C_noret;
static void C_ccall trf_40355(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_40355(t0,t1);}

C_noret_decl(trf_40646)
static void C_ccall trf_40646(C_word c,C_word *av) C_noret;
static void C_ccall trf_40646(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_40646(t0,t1,t2);}

C_noret_decl(trf_40877)
static void C_ccall trf_40877(C_word c,C_word *av) C_noret;
static void C_ccall trf_40877(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_40877(t0,t1,t2);}

C_noret_decl(trf_41039)
static void C_ccall trf_41039(C_word c,C_word *av) C_noret;
static void C_ccall trf_41039(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_41039(t0,t1,t2);}

C_noret_decl(trf_41078)
static void C_ccall trf_41078(C_word c,C_word *av) C_noret;
static void C_ccall trf_41078(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_41078(t0,t1,t2);}

C_noret_decl(trf_41094)
static void C_ccall trf_41094(C_word c,C_word *av) C_noret;
static void C_ccall trf_41094(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_41094(t0,t1,t2);}

C_noret_decl(trf_41260)
static void C_ccall trf_41260(C_word c,C_word *av) C_noret;
static void C_ccall trf_41260(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_41260(t0,t1);}

C_noret_decl(trf_41839)
static void C_ccall trf_41839(C_word c,C_word *av) C_noret;
static void C_ccall trf_41839(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_41839(t0,t1);}

C_noret_decl(trf_41848)
static void C_ccall trf_41848(C_word c,C_word *av) C_noret;
static void C_ccall trf_41848(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_41848(t0,t1,t2,t3,t4);}

C_noret_decl(trf_41946)
static void C_ccall trf_41946(C_word c,C_word *av) C_noret;
static void C_ccall trf_41946(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_41946(t0,t1);}

C_noret_decl(trf_41959)
static void C_ccall trf_41959(C_word c,C_word *av) C_noret;
static void C_ccall trf_41959(C_word c,C_word *av){
C_word t0=av[6];
C_word t1=av[5];
C_word t2=av[4];
C_word t3=av[3];
C_word t4=av[2];
C_word t5=av[1];
C_word t6=av[0];
f_41959(t0,t1,t2,t3,t4,t5,t6);}

/* f45147 in chicken.base#exit in k12641 in k11449 */
static void C_ccall f45147(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f45147,c,av);}
/* library.scm:947: g916 */
t2=t1;{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=C_fix(0);
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* f45346 in chicken.base#gensym in k12641 in k11449 */
static void C_ccall f45346(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f45346,c,av);}
/* library.scm:3348: ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[511]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[511]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=lf[751];
av2[3]=t1;
tp(4,av2);}}

/* f45350 in k22344 in chicken.base#gensym in k12641 in k11449 */
static void C_ccall f45350(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f45350,c,av);}
/* library.scm:3348: ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[511]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[511]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
tp(4,av2);}}

/* f45480 in k27388 in a27385 in k27340 in k27331 in k27328 in k27300 in k27297 in k27294 in loop in a27266 in k27485 in r-list in readrec in k26239 in k26236 in k26233 in k26230 in k29335 in ##sys#read in k26175 in k26171 in ... */
static void C_ccall f45480(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f45480,c,av);}
/* library.scm:5077: ##sys#intern-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[737]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[737]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
tp(3,av2);}}

/* f45485 in k27388 in a27385 in k27340 in k27331 in k27328 in k27300 in k27297 in k27294 in loop in a27266 in k27485 in r-list in readrec in k26239 in k26236 in k26233 in k26230 in k29335 in ##sys#read in k26175 in k26171 in ... */
static void C_ccall f45485(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f45485,c,av);}
/* library.scm:5077: ##sys#intern-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[737]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[737]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
tp(3,av2);}}

/* f45492 in a27512 in r-number in readrec in k26239 in k26236 in k26233 in k26230 in k29335 in ##sys#read in k26175 in k26171 in k26167 in k26163 in k26159 in k26149 in k25795 in k25791 in k25787 in k25783 in k25779 in k25775 in ... */
static void C_ccall f45492(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f45492,c,av);}
/* library.scm:5077: ##sys#intern-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[737]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[737]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
tp(3,av2);}}

/* f45501 in a27806 in r-symbol in readrec in k26239 in k26236 in k26233 in k26230 in k29335 in ##sys#read in k26175 in k26171 in k26167 in k26163 in k26159 in k26149 in k25795 in k25791 in k25787 in k25783 in k25779 in k25775 in ... */
static void C_ccall f45501(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f45501,c,av);}
/* library.scm:5077: ##sys#intern-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[737]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[737]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
tp(3,av2);}}

/* f45510 in a28901 in a28895 in k28884 in k28881 in k28527 in k28524 in k28430 in k28427 in k28424 in readrec in k26239 in k26236 in k26233 in k26230 in k29335 in ##sys#read in k26175 in k26171 in k26167 in k26163 in k26159 in ... */
static void C_ccall f45510(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f45510,c,av);}
/* library.scm:5077: ##sys#intern-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[737]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[737]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
tp(3,av2);}}

/* f49074 in k40854 in k35929 in k35745 in k35109 in k34889 in k34463 in k34460 in k34457 in k34454 in k34449 in k34445 in k34304 in k33288 in k33285 in k33282 in k32515 in k32176 in k32172 in k32168 in k31028 in k29832 in ... */
static void C_ccall f49074(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f49074,c,av);}
t3=C_i_check_list_2(t2,lf[1595]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* f49080 in k40938 in k35745 in k35109 in k34889 in k34463 in k34460 in k34457 in k34454 in k34449 in k34445 in k34304 in k33288 in k33285 in k33282 in k32515 in k32176 in k32172 in k32168 in k31028 in k29832 in k29828 in ... */
static void C_ccall f49080(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f49080,c,av);}
t3=C_i_check_string_2(t2,lf[1598]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* f49086 in k40934 in k40938 in k35745 in k35109 in k34889 in k34463 in k34460 in k34457 in k34454 in k34449 in k34445 in k34304 in k33288 in k33285 in k33282 in k32515 in k32176 in k32172 in k32168 in k31028 in k29832 in ... */
static void C_ccall f49086(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f49086,c,av);}
t3=C_i_check_string_2(t2,lf[1598]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k11449 */
static void C_ccall f_11451(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word t106;
C_word t107;
C_word t108;
C_word t109;
C_word t110;
C_word t111;
C_word t112;
C_word t113;
C_word t114;
C_word t115;
C_word t116;
C_word t117;
C_word t118;
C_word t119;
C_word t120;
C_word t121;
C_word t122;
C_word t123;
C_word t124;
C_word t125;
C_word t126;
C_word t127;
C_word t128;
C_word t129;
C_word t130;
C_word t131;
C_word t132;
C_word t133;
C_word t134;
C_word t135;
C_word t136;
C_word t137;
C_word t138;
C_word t139;
C_word t140;
C_word t141;
C_word t142;
C_word t143;
C_word t144;
C_word t145;
C_word t146;
C_word t147;
C_word t148;
C_word t149;
C_word t150;
C_word t151;
C_word t152;
C_word t153;
C_word t154;
C_word t155;
C_word t156;
C_word t157;
C_word t158;
C_word t159;
C_word t160;
C_word t161;
C_word t162;
C_word t163;
C_word t164;
C_word t165;
C_word t166;
C_word t167;
C_word t168;
C_word t169;
C_word t170;
C_word t171;
C_word t172;
C_word t173;
C_word t174;
C_word t175;
C_word t176;
C_word t177;
C_word t178;
C_word t179;
C_word t180;
C_word t181;
C_word t182;
C_word t183;
C_word t184;
C_word t185;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(403,c,5)))){
C_save_and_reclaim((void *)f_11451,c,av);}
a=C_alloc(403);
t2=C_a_i_provide(&a,1,lf[0]);
t3=C_a_i_provide(&a,1,lf[1]);
t4=C_mutate((C_word*)lf[2]+1 /* (set! scheme#not ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11453,a[2]=((C_word)li0),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[3]+1 /* (set! scheme#boolean? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11456,a[2]=((C_word)li1),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[4]+1 /* (set! scheme#eq? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11459,a[2]=((C_word)li2),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[5]+1 /* (set! scheme#eqv? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11462,a[2]=((C_word)li3),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[6]+1 /* (set! scheme#equal? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11465,a[2]=((C_word)li4),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate((C_word*)lf[7]+1 /* (set! scheme#boolean=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11468,a[2]=((C_word)li6),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate((C_word*)lf[9]+1 /* (set! scheme#symbol=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11513,a[2]=((C_word)li8),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate((C_word*)lf[11]+1 /* (set! scheme#pair? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11558,a[2]=((C_word)li9),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate((C_word*)lf[12]+1 /* (set! scheme#cons ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11561,a[2]=((C_word)li10),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate((C_word*)lf[13]+1 /* (set! scheme#car ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11564,a[2]=((C_word)li11),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate((C_word*)lf[14]+1 /* (set! scheme#cdr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11567,a[2]=((C_word)li12),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate((C_word*)lf[15]+1 /* (set! scheme#set-car! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11570,a[2]=((C_word)li13),tmp=(C_word)a,a+=3,tmp));
t16=C_mutate((C_word*)lf[16]+1 /* (set! scheme#set-cdr! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11573,a[2]=((C_word)li14),tmp=(C_word)a,a+=3,tmp));
t17=C_mutate((C_word*)lf[17]+1 /* (set! scheme#cadr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11576,a[2]=((C_word)li15),tmp=(C_word)a,a+=3,tmp));
t18=C_mutate((C_word*)lf[18]+1 /* (set! scheme#caddr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11579,a[2]=((C_word)li16),tmp=(C_word)a,a+=3,tmp));
t19=C_mutate((C_word*)lf[19]+1 /* (set! scheme#cadddr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11582,a[2]=((C_word)li17),tmp=(C_word)a,a+=3,tmp));
t20=C_mutate((C_word*)lf[20]+1 /* (set! scheme#cddddr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11585,a[2]=((C_word)li18),tmp=(C_word)a,a+=3,tmp));
t21=C_mutate((C_word*)lf[21]+1 /* (set! scheme#caar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11588,a[2]=((C_word)li19),tmp=(C_word)a,a+=3,tmp));
t22=C_mutate((C_word*)lf[22]+1 /* (set! scheme#cdar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11591,a[2]=((C_word)li20),tmp=(C_word)a,a+=3,tmp));
t23=C_mutate((C_word*)lf[23]+1 /* (set! scheme#cddr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11594,a[2]=((C_word)li21),tmp=(C_word)a,a+=3,tmp));
t24=C_mutate((C_word*)lf[24]+1 /* (set! scheme#caaar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11597,a[2]=((C_word)li22),tmp=(C_word)a,a+=3,tmp));
t25=C_mutate((C_word*)lf[25]+1 /* (set! scheme#caadr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11611,a[2]=((C_word)li23),tmp=(C_word)a,a+=3,tmp));
t26=C_mutate((C_word*)lf[26]+1 /* (set! scheme#cadar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11618,a[2]=((C_word)li24),tmp=(C_word)a,a+=3,tmp));
t27=C_mutate((C_word*)lf[27]+1 /* (set! scheme#cdaar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11625,a[2]=((C_word)li25),tmp=(C_word)a,a+=3,tmp));
t28=C_mutate((C_word*)lf[28]+1 /* (set! scheme#cdadr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11639,a[2]=((C_word)li26),tmp=(C_word)a,a+=3,tmp));
t29=C_mutate((C_word*)lf[29]+1 /* (set! scheme#cddar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11646,a[2]=((C_word)li27),tmp=(C_word)a,a+=3,tmp));
t30=C_mutate((C_word*)lf[30]+1 /* (set! scheme#cdddr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11660,a[2]=((C_word)li28),tmp=(C_word)a,a+=3,tmp));
t31=C_mutate((C_word*)lf[31]+1 /* (set! scheme#caaaar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11674,a[2]=((C_word)li29),tmp=(C_word)a,a+=3,tmp));
t32=C_mutate((C_word*)lf[32]+1 /* (set! scheme#caaadr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11692,a[2]=((C_word)li30),tmp=(C_word)a,a+=3,tmp));
t33=C_mutate((C_word*)lf[33]+1 /* (set! scheme#caadar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11703,a[2]=((C_word)li31),tmp=(C_word)a,a+=3,tmp));
t34=C_mutate((C_word*)lf[34]+1 /* (set! scheme#caaddr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11714,a[2]=((C_word)li32),tmp=(C_word)a,a+=3,tmp));
t35=C_mutate((C_word*)lf[35]+1 /* (set! scheme#cadaar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11721,a[2]=((C_word)li33),tmp=(C_word)a,a+=3,tmp));
t36=C_mutate((C_word*)lf[36]+1 /* (set! scheme#cadadr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11732,a[2]=((C_word)li34),tmp=(C_word)a,a+=3,tmp));
t37=C_mutate((C_word*)lf[37]+1 /* (set! scheme#caddar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11736,a[2]=((C_word)li35),tmp=(C_word)a,a+=3,tmp));
t38=C_mutate((C_word*)lf[38]+1 /* (set! scheme#cdaaar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11743,a[2]=((C_word)li36),tmp=(C_word)a,a+=3,tmp));
t39=C_mutate((C_word*)lf[39]+1 /* (set! scheme#cdaadr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11761,a[2]=((C_word)li37),tmp=(C_word)a,a+=3,tmp));
t40=C_mutate((C_word*)lf[40]+1 /* (set! scheme#cdadar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11772,a[2]=((C_word)li38),tmp=(C_word)a,a+=3,tmp));
t41=C_mutate((C_word*)lf[41]+1 /* (set! scheme#cdaddr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11783,a[2]=((C_word)li39),tmp=(C_word)a,a+=3,tmp));
t42=C_mutate((C_word*)lf[42]+1 /* (set! scheme#cddaar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11790,a[2]=((C_word)li40),tmp=(C_word)a,a+=3,tmp));
t43=C_mutate((C_word*)lf[43]+1 /* (set! scheme#cddadr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11808,a[2]=((C_word)li41),tmp=(C_word)a,a+=3,tmp));
t44=C_mutate((C_word*)lf[44]+1 /* (set! scheme#cdddar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11819,a[2]=((C_word)li42),tmp=(C_word)a,a+=3,tmp));
t45=C_mutate((C_word*)lf[45]+1 /* (set! scheme#null? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11837,a[2]=((C_word)li43),tmp=(C_word)a,a+=3,tmp));
t46=C_mutate((C_word*)lf[46]+1 /* (set! scheme#list ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11843,a[2]=((C_word)li44),tmp=(C_word)a,a+=3,tmp));
t47=C_mutate((C_word*)lf[47]+1 /* (set! scheme#length ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11846,a[2]=((C_word)li45),tmp=(C_word)a,a+=3,tmp));
t48=C_mutate((C_word*)lf[48]+1 /* (set! scheme#list-tail ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11849,a[2]=((C_word)li46),tmp=(C_word)a,a+=3,tmp));
t49=C_mutate((C_word*)lf[49]+1 /* (set! scheme#list-ref ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11852,a[2]=((C_word)li47),tmp=(C_word)a,a+=3,tmp));
t50=C_mutate((C_word*)lf[50]+1 /* (set! scheme#reverse ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11855,a[2]=((C_word)li49),tmp=(C_word)a,a+=3,tmp));
t51=C_mutate((C_word*)lf[53]+1 /* (set! scheme#memq ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11894,a[2]=((C_word)li50),tmp=(C_word)a,a+=3,tmp));
t52=C_mutate((C_word*)lf[54]+1 /* (set! scheme#memv ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11897,a[2]=((C_word)li51),tmp=(C_word)a,a+=3,tmp));
t53=C_mutate((C_word*)lf[55]+1 /* (set! scheme#member ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11900,a[2]=((C_word)li53),tmp=(C_word)a,a+=3,tmp));
t54=C_mutate((C_word*)lf[56]+1 /* (set! scheme#assq ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11944,a[2]=((C_word)li54),tmp=(C_word)a,a+=3,tmp));
t55=C_mutate((C_word*)lf[57]+1 /* (set! scheme#assv ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11947,a[2]=((C_word)li55),tmp=(C_word)a,a+=3,tmp));
t56=C_mutate((C_word*)lf[58]+1 /* (set! scheme#assoc ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11950,a[2]=((C_word)li57),tmp=(C_word)a,a+=3,tmp));
t57=C_mutate((C_word*)lf[59]+1 /* (set! scheme#list? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11999,a[2]=((C_word)li58),tmp=(C_word)a,a+=3,tmp));
t58=C_mutate((C_word*)lf[60]+1 /* (set! scheme#string? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12002,a[2]=((C_word)li59),tmp=(C_word)a,a+=3,tmp));
t59=C_mutate((C_word*)lf[61]+1 /* (set! scheme#string-length ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12005,a[2]=((C_word)li60),tmp=(C_word)a,a+=3,tmp));
t60=C_mutate((C_word*)lf[62]+1 /* (set! scheme#string-ref ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12008,a[2]=((C_word)li61),tmp=(C_word)a,a+=3,tmp));
t61=C_mutate((C_word*)lf[63]+1 /* (set! scheme#string-set! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12011,a[2]=((C_word)li62),tmp=(C_word)a,a+=3,tmp));
t62=C_mutate((C_word*)lf[64]+1 /* (set! scheme#string=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12014,a[2]=((C_word)li64),tmp=(C_word)a,a+=3,tmp));
t63=C_mutate((C_word*)lf[66]+1 /* (set! scheme#string-ci=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12047,a[2]=((C_word)li66),tmp=(C_word)a,a+=3,tmp));
t64=C_set_block_item(lf[68] /* scheme#features */,0,C_SCHEME_UNDEFINED);
t65=C_set_block_item(lf[69] /* scheme#call-with-port */,0,C_SCHEME_UNDEFINED);
t66=C_set_block_item(lf[70] /* scheme#close-port */,0,C_SCHEME_UNDEFINED);
t67=C_set_block_item(lf[71] /* scheme#peek-u8 */,0,C_SCHEME_UNDEFINED);
t68=C_set_block_item(lf[72] /* scheme#string-map */,0,C_SCHEME_UNDEFINED);
t69=C_set_block_item(lf[73] /* scheme#vector-map */,0,C_SCHEME_UNDEFINED);
t70=C_set_block_item(lf[74] /* scheme#string-for-each */,0,C_SCHEME_UNDEFINED);
t71=C_set_block_item(lf[75] /* scheme#vector-for-each */,0,C_SCHEME_UNDEFINED);
t72=C_set_block_item(lf[76] /* scheme#make-list */,0,C_SCHEME_UNDEFINED);
t73=C_set_block_item(lf[77] /* scheme#list-set! */,0,C_SCHEME_UNDEFINED);
t74=C_set_block_item(lf[78] /* scheme#write-string */,0,C_SCHEME_UNDEFINED);
t75=C_set_block_item(lf[79] /* scheme#eof-object */,0,C_SCHEME_UNDEFINED);
t76=C_set_block_item(lf[80] /* scheme#list-copy */,0,C_SCHEME_UNDEFINED);
t77=C_set_block_item(lf[81] /* scheme#string->vector */,0,C_SCHEME_UNDEFINED);
t78=C_set_block_item(lf[82] /* scheme#vector->string */,0,C_SCHEME_UNDEFINED);
t79=C_set_block_item(lf[83] /* scheme#exact */,0,C_SCHEME_UNDEFINED);
t80=C_set_block_item(lf[84] /* scheme#inexact */,0,C_SCHEME_UNDEFINED);
t81=C_set_block_item(lf[85] /* scheme#make-parameter */,0,C_SCHEME_UNDEFINED);
t82=C_mutate((C_word*)lf[86]+1 /* (set! scheme#exact->inexact ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12098,a[2]=((C_word)li67),tmp=(C_word)a,a+=3,tmp));
t83=C_mutate((C_word*)lf[87]+1 /* (set! scheme#abs ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12101,a[2]=((C_word)li68),tmp=(C_word)a,a+=3,tmp));
t84=C_mutate((C_word*)lf[88]+1 /* (set! scheme#+ ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_plus,a[2]=((C_word)li69),tmp=(C_word)a,a+=3,tmp));
t85=C_mutate((C_word*)lf[89]+1 /* (set! scheme#- ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_minus,a[2]=((C_word)li70),tmp=(C_word)a,a+=3,tmp));
t86=C_mutate((C_word*)lf[90]+1 /* (set! scheme#* ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_times,a[2]=((C_word)li71),tmp=(C_word)a,a+=3,tmp));
t87=C_mutate((C_word*)lf[91]+1 /* (set! scheme#quotient ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12107,a[2]=((C_word)li72),tmp=(C_word)a,a+=3,tmp));
t88=C_mutate((C_word*)lf[92]+1 /* (set! scheme#remainder ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12110,a[2]=((C_word)li73),tmp=(C_word)a,a+=3,tmp));
t89=C_mutate((C_word*)lf[93]+1 /* (set! scheme#modulo ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12113,a[2]=((C_word)li74),tmp=(C_word)a,a+=3,tmp));
t90=C_mutate((C_word*)lf[94]+1 /* (set! scheme#even? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12116,a[2]=((C_word)li75),tmp=(C_word)a,a+=3,tmp));
t91=C_mutate((C_word*)lf[95]+1 /* (set! scheme#odd? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12119,a[2]=((C_word)li76),tmp=(C_word)a,a+=3,tmp));
t92=C_mutate((C_word*)lf[96]+1 /* (set! scheme#= ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_nequalp,a[2]=((C_word)li77),tmp=(C_word)a,a+=3,tmp));
t93=C_mutate((C_word*)lf[97]+1 /* (set! scheme#> ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_greaterp,a[2]=((C_word)li78),tmp=(C_word)a,a+=3,tmp));
t94=C_mutate((C_word*)lf[98]+1 /* (set! scheme#< ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_lessp,a[2]=((C_word)li79),tmp=(C_word)a,a+=3,tmp));
t95=C_mutate((C_word*)lf[99]+1 /* (set! scheme#>= ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_greater_or_equal_p,a[2]=((C_word)li80),tmp=(C_word)a,a+=3,tmp));
t96=C_mutate((C_word*)lf[100]+1 /* (set! scheme#<= ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_less_or_equal_p,a[2]=((C_word)li81),tmp=(C_word)a,a+=3,tmp));
t97=C_mutate((C_word*)lf[101]+1 /* (set! scheme#number? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12127,a[2]=((C_word)li82),tmp=(C_word)a,a+=3,tmp));
t98=C_mutate((C_word*)lf[102]+1 /* (set! scheme#complex? ...) */,*((C_word*)lf[101]+1));
t99=C_mutate((C_word*)lf[103]+1 /* (set! scheme#real? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12131,a[2]=((C_word)li83),tmp=(C_word)a,a+=3,tmp));
t100=C_mutate((C_word*)lf[104]+1 /* (set! scheme#rational? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12134,a[2]=((C_word)li84),tmp=(C_word)a,a+=3,tmp));
t101=C_mutate((C_word*)lf[105]+1 /* (set! scheme#integer? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12137,a[2]=((C_word)li85),tmp=(C_word)a,a+=3,tmp));
t102=C_mutate((C_word*)lf[106]+1 /* (set! scheme#exact? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12140,a[2]=((C_word)li86),tmp=(C_word)a,a+=3,tmp));
t103=C_mutate((C_word*)lf[107]+1 /* (set! scheme#inexact? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12143,a[2]=((C_word)li87),tmp=(C_word)a,a+=3,tmp));
t104=C_mutate((C_word*)lf[108]+1 /* (set! scheme#zero? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12146,a[2]=((C_word)li88),tmp=(C_word)a,a+=3,tmp));
t105=C_mutate((C_word*)lf[109]+1 /* (set! scheme#positive? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12149,a[2]=((C_word)li89),tmp=(C_word)a,a+=3,tmp));
t106=C_mutate((C_word*)lf[110]+1 /* (set! scheme#negative? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12152,a[2]=((C_word)li90),tmp=(C_word)a,a+=3,tmp));
t107=C_mutate((C_word*)lf[111]+1 /* (set! scheme#exact-integer? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12155,a[2]=((C_word)li91),tmp=(C_word)a,a+=3,tmp));
t108=C_mutate((C_word*)lf[112]+1 /* (set! scheme#number->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_number_to_string,a[2]=((C_word)li92),tmp=(C_word)a,a+=3,tmp));
t109=C_mutate((C_word*)lf[113]+1 /* (set! scheme#symbol? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12159,a[2]=((C_word)li93),tmp=(C_word)a,a+=3,tmp));
t110=C_mutate((C_word*)lf[114]+1 /* (set! scheme#vector? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12162,a[2]=((C_word)li94),tmp=(C_word)a,a+=3,tmp));
t111=C_mutate((C_word*)lf[115]+1 /* (set! scheme#vector-length ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12165,a[2]=((C_word)li95),tmp=(C_word)a,a+=3,tmp));
t112=C_mutate((C_word*)lf[116]+1 /* (set! scheme#vector-ref ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12168,a[2]=((C_word)li96),tmp=(C_word)a,a+=3,tmp));
t113=C_mutate((C_word*)lf[117]+1 /* (set! scheme#vector-set! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12171,a[2]=((C_word)li97),tmp=(C_word)a,a+=3,tmp));
t114=C_set_block_item(lf[118] /* scheme#make-vector */,0,C_SCHEME_UNDEFINED);
t115=C_set_block_item(lf[119] /* scheme#list->vector */,0,C_SCHEME_UNDEFINED);
t116=C_set_block_item(lf[120] /* scheme#vector->list */,0,C_SCHEME_UNDEFINED);
t117=C_set_block_item(lf[121] /* scheme#vector */,0,C_SCHEME_UNDEFINED);
t118=C_set_block_item(lf[122] /* scheme#vector-fill! */,0,C_SCHEME_UNDEFINED);
t119=C_mutate((C_word*)lf[123]+1 /* (set! scheme#char? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12179,a[2]=((C_word)li98),tmp=(C_word)a,a+=3,tmp));
t120=C_mutate((C_word*)lf[124]+1 /* (set! scheme#char->integer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12182,a[2]=((C_word)li99),tmp=(C_word)a,a+=3,tmp));
t121=C_mutate((C_word*)lf[126]+1 /* (set! scheme#integer->char ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12189,a[2]=((C_word)li100),tmp=(C_word)a,a+=3,tmp));
t122=C_mutate((C_word*)lf[128]+1 /* (set! scheme#char=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12196,a[2]=((C_word)li102),tmp=(C_word)a,a+=3,tmp));
t123=C_mutate((C_word*)lf[130]+1 /* (set! scheme#char>? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12235,a[2]=((C_word)li104),tmp=(C_word)a,a+=3,tmp));
t124=C_mutate((C_word*)lf[132]+1 /* (set! scheme#char<? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12274,a[2]=((C_word)li106),tmp=(C_word)a,a+=3,tmp));
t125=C_mutate((C_word*)lf[134]+1 /* (set! scheme#char>=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12313,a[2]=((C_word)li108),tmp=(C_word)a,a+=3,tmp));
t126=C_mutate((C_word*)lf[136]+1 /* (set! scheme#char<=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12352,a[2]=((C_word)li110),tmp=(C_word)a,a+=3,tmp));
t127=C_mutate((C_word*)lf[138]+1 /* (set! scheme#char-upcase ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12391,a[2]=((C_word)li111),tmp=(C_word)a,a+=3,tmp));
t128=C_mutate((C_word*)lf[140]+1 /* (set! scheme#char-downcase ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12397,a[2]=((C_word)li112),tmp=(C_word)a,a+=3,tmp));
t129=C_set_block_item(lf[142] /* scheme#char-ci=? */,0,C_SCHEME_UNDEFINED);
t130=C_set_block_item(lf[143] /* scheme#char-ci>? */,0,C_SCHEME_UNDEFINED);
t131=C_set_block_item(lf[144] /* scheme#char-ci<? */,0,C_SCHEME_UNDEFINED);
t132=C_set_block_item(lf[145] /* scheme#char-ci>=? */,0,C_SCHEME_UNDEFINED);
t133=C_set_block_item(lf[146] /* scheme#char-ci<=? */,0,C_SCHEME_UNDEFINED);
t134=C_mutate((C_word*)lf[147]+1 /* (set! scheme#char-upper-case? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12408,a[2]=((C_word)li113),tmp=(C_word)a,a+=3,tmp));
t135=C_mutate((C_word*)lf[149]+1 /* (set! scheme#char-lower-case? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12414,a[2]=((C_word)li114),tmp=(C_word)a,a+=3,tmp));
t136=C_mutate((C_word*)lf[151]+1 /* (set! scheme#char-numeric? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12420,a[2]=((C_word)li115),tmp=(C_word)a,a+=3,tmp));
t137=C_mutate((C_word*)lf[153]+1 /* (set! scheme#char-whitespace? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12426,a[2]=((C_word)li116),tmp=(C_word)a,a+=3,tmp));
t138=C_mutate((C_word*)lf[155]+1 /* (set! scheme#char-alphabetic? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12432,a[2]=((C_word)li117),tmp=(C_word)a,a+=3,tmp));
t139=C_mutate((C_word*)lf[157]+1 /* (set! scheme.char#digit-value ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12438,a[2]=((C_word)li118),tmp=(C_word)a,a+=3,tmp));
t140=C_mutate((C_word*)lf[159]+1 /* (set! scheme#char-foldcase ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12454,a[2]=((C_word)li119),tmp=(C_word)a,a+=3,tmp));
t141=C_mutate((C_word*)lf[161]+1 /* (set! scheme#string-foldcase ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12460,a[2]=((C_word)li120),tmp=(C_word)a,a+=3,tmp));
t142=C_mutate((C_word*)lf[165]+1 /* (set! scheme#string-downcase ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12480,a[2]=((C_word)li121),tmp=(C_word)a,a+=3,tmp));
t143=C_mutate((C_word*)lf[167]+1 /* (set! scheme#string-upcase ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12500,a[2]=((C_word)li122),tmp=(C_word)a,a+=3,tmp));
t144=C_mutate((C_word*)lf[169]+1 /* (set! scheme#procedure? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12520,a[2]=((C_word)li123),tmp=(C_word)a,a+=3,tmp));
t145=C_mutate((C_word*)lf[170]+1 /* (set! scheme#apply ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_apply,a[2]=((C_word)li124),tmp=(C_word)a,a+=3,tmp));
t146=C_mutate((C_word*)lf[171]+1 /* (set! scheme#values ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_values,a[2]=((C_word)li125),tmp=(C_word)a,a+=3,tmp));
t147=C_mutate((C_word*)lf[172]+1 /* (set! scheme#call-with-values ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_call_with_values,a[2]=((C_word)li126),tmp=(C_word)a,a+=3,tmp));
t148=C_set_block_item(lf[173] /* scheme#call-with-current-continuation */,0,C_SCHEME_UNDEFINED);
t149=C_set_block_item(lf[174] /* scheme#call/cc */,0,C_SCHEME_UNDEFINED);
t150=C_mutate((C_word*)lf[175]+1 /* (set! scheme#input-port? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12528,a[2]=((C_word)li127),tmp=(C_word)a,a+=3,tmp));
t151=C_mutate((C_word*)lf[176]+1 /* (set! scheme#output-port? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12534,a[2]=((C_word)li128),tmp=(C_word)a,a+=3,tmp));
t152=C_mutate((C_word*)lf[177]+1 /* (set! scheme#binary-port? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12540,a[2]=((C_word)li129),tmp=(C_word)a,a+=3,tmp));
t153=C_mutate((C_word*)lf[180]+1 /* (set! scheme#textual-port? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12556,a[2]=((C_word)li130),tmp=(C_word)a,a+=3,tmp));
t154=C_mutate((C_word*)lf[179]+1 /* (set! scheme#port? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12572,a[2]=((C_word)li131),tmp=(C_word)a,a+=3,tmp));
t155=C_mutate((C_word*)lf[182]+1 /* (set! scheme#input-port-open? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12578,a[2]=((C_word)li132),tmp=(C_word)a,a+=3,tmp));
t156=C_mutate((C_word*)lf[184]+1 /* (set! scheme#output-port-open? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12583,a[2]=((C_word)li133),tmp=(C_word)a,a+=3,tmp));
t157=C_set_block_item(lf[186] /* scheme#current-input-port */,0,C_SCHEME_UNDEFINED);
t158=C_set_block_item(lf[187] /* scheme#current-output-port */,0,C_SCHEME_UNDEFINED);
t159=C_set_block_item(lf[188] /* scheme#open-input-file */,0,C_SCHEME_UNDEFINED);
t160=C_set_block_item(lf[189] /* scheme#open-output-file */,0,C_SCHEME_UNDEFINED);
t161=C_set_block_item(lf[190] /* scheme#close-input-port */,0,C_SCHEME_UNDEFINED);
t162=C_set_block_item(lf[191] /* scheme#close-output-port */,0,C_SCHEME_UNDEFINED);
t163=C_set_block_item(lf[192] /* scheme#call-with-input-file */,0,C_SCHEME_UNDEFINED);
t164=C_set_block_item(lf[193] /* scheme#call-with-output-file */,0,C_SCHEME_UNDEFINED);
t165=C_set_block_item(lf[194] /* scheme#with-input-from-file */,0,C_SCHEME_UNDEFINED);
t166=C_set_block_item(lf[195] /* scheme#with-output-to-file */,0,C_SCHEME_UNDEFINED);
t167=C_mutate((C_word*)lf[196]+1 /* (set! scheme#eof-object? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12598,a[2]=((C_word)li134),tmp=(C_word)a,a+=3,tmp));
t168=C_set_block_item(lf[197] /* scheme#char-ready? */,0,C_SCHEME_UNDEFINED);
t169=C_set_block_item(lf[198] /* scheme#read-char */,0,C_SCHEME_UNDEFINED);
t170=C_set_block_item(lf[199] /* scheme#peek-char */,0,C_SCHEME_UNDEFINED);
t171=C_set_block_item(lf[200] /* scheme#read */,0,C_SCHEME_UNDEFINED);
t172=C_set_block_item(lf[201] /* scheme#write-char */,0,C_SCHEME_UNDEFINED);
t173=C_set_block_item(lf[202] /* scheme#newline */,0,C_SCHEME_UNDEFINED);
t174=C_set_block_item(lf[203] /* scheme#write */,0,C_SCHEME_UNDEFINED);
t175=C_set_block_item(lf[204] /* scheme#display */,0,C_SCHEME_UNDEFINED);
t176=C_mutate((C_word*)lf[205]+1 /* (set! scheme#eval ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12609,a[2]=((C_word)li135),tmp=(C_word)a,a+=3,tmp));
t177=C_mutate((C_word*)lf[209]+1 /* (set! scheme#interaction-environment ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12615,a[2]=((C_word)li136),tmp=(C_word)a,a+=3,tmp));
t178=C_mutate((C_word*)lf[212]+1 /* (set! scheme#scheme-report-environment ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12621,a[2]=((C_word)li137),tmp=(C_word)a,a+=3,tmp));
t179=C_mutate((C_word*)lf[215]+1 /* (set! scheme#null-environment ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12627,a[2]=((C_word)li138),tmp=(C_word)a,a+=3,tmp));
t180=C_mutate((C_word*)lf[218]+1 /* (set! scheme#load ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12633,a[2]=((C_word)li139),tmp=(C_word)a,a+=3,tmp));
t181=C_set_block_item(lf[221] /* scheme#for-each */,0,C_SCHEME_UNDEFINED);
t182=C_set_block_item(lf[222] /* scheme#map */,0,C_SCHEME_UNDEFINED);
t183=C_set_block_item(lf[223] /* scheme#dynamic-wind */,0,C_SCHEME_UNDEFINED);
t184=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12643,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);{
C_word *av2=av;
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t184;
C_library_toplevel(2,av2);}}

/* scheme#not in k11449 */
static void C_ccall f_11453(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11453,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_not(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#boolean? in k11449 */
static void C_ccall f_11456(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11456,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_booleanp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#eq? in k11449 */
static void C_ccall f_11459(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11459,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_eqp(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#eqv? in k11449 */
static void C_ccall f_11462(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11462,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_eqvp(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#equal? in k11449 */
static void C_ccall f_11465(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11465,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_equalp(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#boolean=? in k11449 */
static void C_ccall f_11468(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,3)))){
C_save_and_reclaim((void*)f_11468,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t5=C_i_check_boolean_2(t2,lf[8]);
t6=C_i_check_boolean_2(t3,lf[8]);
t7=C_eqp(t2,t3);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11484,a[2]=t3,a[3]=((C_word)li5),tmp=(C_word)a,a+=4,tmp);
t9=t1;{
C_word *av2=av;
av2[0]=t9;
av2[1]=(
  f_11484(t8,t4,t7)
);
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}

/* loop in scheme#boolean=? in k11449 */
static C_word f_11484(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t1))){
return(t2);}
else{
t3=C_slot(t1,C_fix(0));
t4=C_i_check_boolean_2(t3,lf[8]);
t5=C_slot(t1,C_fix(1));
if(C_truep(t2)){
t7=t5;
t8=C_eqp(t3,((C_word*)t0)[2]);
t1=t7;
t2=t8;
goto loop;}
else{
t7=t5;
t8=C_SCHEME_FALSE;
t1=t7;
t2=t8;
goto loop;}}}

/* scheme#symbol=? in k11449 */
static void C_ccall f_11513(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,3)))){
C_save_and_reclaim((void*)f_11513,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t5=C_i_check_symbol_2(t2,lf[10]);
t6=C_i_check_symbol_2(t3,lf[10]);
t7=C_eqp(t2,t3);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11529,a[2]=t3,a[3]=((C_word)li7),tmp=(C_word)a,a+=4,tmp);
t9=t1;{
C_word *av2=av;
av2[0]=t9;
av2[1]=(
  f_11529(t8,t4,t7)
);
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}

/* loop in scheme#symbol=? in k11449 */
static C_word f_11529(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t1))){
return(t2);}
else{
t3=C_slot(t1,C_fix(0));
t4=C_i_check_symbol_2(t3,lf[10]);
t5=C_slot(t1,C_fix(1));
if(C_truep(t2)){
t7=t5;
t8=C_eqp(t3,((C_word*)t0)[2]);
t1=t7;
t2=t8;
goto loop;}
else{
t7=t5;
t8=C_SCHEME_FALSE;
t1=t7;
t2=t8;
goto loop;}}}

/* scheme#pair? in k11449 */
static void C_ccall f_11558(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11558,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_pairp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#cons in k11449 */
static void C_ccall f_11561(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_11561,c,av);}
a=C_alloc(3);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_cons(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#car in k11449 */
static void C_ccall f_11564(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11564,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_car(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#cdr in k11449 */
static void C_ccall f_11567(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11567,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cdr(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#set-car! in k11449 */
static void C_ccall f_11570(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11570,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_set_car(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#set-cdr! in k11449 */
static void C_ccall f_11573(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11573,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_set_cdr(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#cadr in k11449 */
static void C_ccall f_11576(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11576,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cadr(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#caddr in k11449 */
static void C_ccall f_11579(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11579,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_caddr(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#cadddr in k11449 */
static void C_ccall f_11582(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11582,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cadddr(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#cddddr in k11449 */
static void C_ccall f_11585(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11585,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cddddr(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#caar in k11449 */
static void C_ccall f_11588(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11588,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_caar(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#cdar in k11449 */
static void C_ccall f_11591(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11591,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cdar(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#cddr in k11449 */
static void C_ccall f_11594(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11594,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cddr(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#caaar in k11449 */
static void C_ccall f_11597(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11597,c,av);}
t3=C_i_car(t2);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_car(C_i_car(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#caadr in k11449 */
static void C_ccall f_11611(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11611,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_car(C_i_cadr(t2));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#cadar in k11449 */
static void C_ccall f_11618(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11618,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cadr(C_i_car(t2));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#cdaar in k11449 */
static void C_ccall f_11625(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11625,c,av);}
t3=C_i_car(t2);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_cdr(C_i_car(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#cdadr in k11449 */
static void C_ccall f_11639(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11639,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cdr(C_i_cadr(t2));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#cddar in k11449 */
static void C_ccall f_11646(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11646,c,av);}
t3=C_i_car(t2);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_cdr(C_i_cdr(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#cdddr in k11449 */
static void C_ccall f_11660(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11660,c,av);}
t3=C_i_cdr(t2);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_cdr(C_i_cdr(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#caaaar in k11449 */
static void C_ccall f_11674(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11674,c,av);}
t3=C_i_car(t2);
t4=C_i_car(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_i_car(C_i_car(t4));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#caaadr in k11449 */
static void C_ccall f_11692(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11692,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_car(C_i_car(C_i_cadr(t2)));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#caadar in k11449 */
static void C_ccall f_11703(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11703,c,av);}
t3=C_i_car(t2);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_car(C_i_cadr(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#caaddr in k11449 */
static void C_ccall f_11714(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11714,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_car(C_i_caddr(t2));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#cadaar in k11449 */
static void C_ccall f_11721(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11721,c,av);}
t3=C_i_car(t2);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_cadr(C_i_car(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#cadadr in k11449 */
static void C_ccall f_11732(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11732,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cadr(C_i_cadr(t2));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#caddar in k11449 */
static void C_ccall f_11736(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11736,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_caddr(C_i_car(t2));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#cdaaar in k11449 */
static void C_ccall f_11743(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11743,c,av);}
t3=C_i_car(t2);
t4=C_i_car(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_i_cdr(C_i_car(t4));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#cdaadr in k11449 */
static void C_ccall f_11761(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11761,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cdr(C_i_car(C_i_cadr(t2)));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#cdadar in k11449 */
static void C_ccall f_11772(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11772,c,av);}
t3=C_i_car(t2);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_cdr(C_i_cadr(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#cdaddr in k11449 */
static void C_ccall f_11783(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11783,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cdr(C_i_caddr(t2));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#cddaar in k11449 */
static void C_ccall f_11790(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11790,c,av);}
t3=C_i_car(t2);
t4=C_i_car(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_i_cdr(C_i_cdr(t4));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#cddadr in k11449 */
static void C_ccall f_11808(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11808,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cdr(C_i_cdr(C_i_cadr(t2)));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#cdddar in k11449 */
static void C_ccall f_11819(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11819,c,av);}
t3=C_i_car(t2);
t4=C_i_cdr(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_i_cdr(C_i_cdr(t4));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#null? in k11449 */
static void C_ccall f_11837(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11837,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_eqp(t2,C_SCHEME_END_OF_LIST);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#list in k11449 */
static void C_ccall f_11843(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_11843,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+0);
t2=C_build_rest(&a,c,2,av);
C_word t3;
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#length in k11449 */
static void C_ccall f_11846(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11846,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_length(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#list-tail in k11449 */
static void C_ccall f_11849(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11849,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_list_tail(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#list-ref in k11449 */
static void C_ccall f_11852(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11852,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_list_ref(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#reverse in k11449 */
static void C_ccall f_11855(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_11855,c,av);}
a=C_alloc(7);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11861,a[2]=t4,a[3]=t2,a[4]=((C_word)li48),tmp=(C_word)a,a+=5,tmp));
t6=((C_word*)t4)[1];
f_11861(t6,t1,t2,C_SCHEME_END_OF_LIST);}

/* loop in scheme#reverse in k11449 */
static void f_11861(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(3,0,3)))){
C_save_and_reclaim_args((void *)trf_11861,4,t0,t1,t2,t3);}
a=C_alloc(3);
t4=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t4)){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t2))){
t5=C_slot(t2,C_fix(1));
t6=C_slot(t2,C_fix(0));
t7=C_a_i_cons(&a,2,t6,t3);
/* library.scm:365: loop */
t9=t1;
t10=t5;
t11=t7;
t1=t9;
t2=t10;
t3=t11;
goto loop;}
else{
/* library.scm:366: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[51]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[51]+1);
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
av2[3]=lf[52];
tp(4,av2);}}}}

/* scheme#memq in k11449 */
static void C_ccall f_11894(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11894,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_memq(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#memv in k11449 */
static void C_ccall f_11897(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11897,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_memv(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#member in k11449 */
static void C_ccall f_11900(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_11900,c,av);}
a=C_alloc(8);
t4=C_rest_nullp(c,4);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_get_rest_arg(c,4,av,4,t0));
if(C_truep(t5)){
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_11912,a[2]=t7,a[3]=t5,a[4]=t2,a[5]=((C_word)li52),tmp=(C_word)a,a+=6,tmp));
t9=((C_word*)t7)[1];
f_11912(t9,t1,t3);}
else{
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_i_member(t2,t3);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* loop in scheme#member in k11449 */
static void f_11912(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_11912,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11925,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* library.scm:375: eq */
t4=((C_word*)t0)[3];{
C_word av2[4];
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
av2[3]=C_slot(t2,C_fix(0));
((C_proc)C_fast_retrieve_proc(t4))(4,av2);}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k11923 in loop in scheme#member in k11449 */
static void C_ccall f_11925(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_11925,c,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* library.scm:377: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_11912(t2,((C_word*)t0)[2],C_slot(((C_word*)t0)[3],C_fix(1)));}}

/* scheme#assq in k11449 */
static void C_ccall f_11944(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11944,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_assq(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#assv in k11449 */
static void C_ccall f_11947(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11947,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_assv(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#assoc in k11449 */
static void C_ccall f_11950(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_11950,c,av);}
a=C_alloc(8);
t4=C_rest_nullp(c,4);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_get_rest_arg(c,4,av,4,t0));
if(C_truep(t5)){
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_11962,a[2]=t7,a[3]=t5,a[4]=t2,a[5]=((C_word)li56),tmp=(C_word)a,a+=6,tmp));
t9=((C_word*)t7)[1];
f_11962(t9,t1,t3);}
else{
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_i_assoc(t2,t3);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* loop in scheme#assoc in k11449 */
static void f_11962(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_11962,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11975,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
/* library.scm:387: eq */
t5=((C_word*)t0)[3];{
C_word av2[4];
av2[0]=t5;
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
av2[3]=C_i_car(t4);
((C_proc)C_fast_retrieve_proc(t5))(4,av2);}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k11973 in loop in scheme#assoc in k11449 */
static void C_ccall f_11975(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_11975,c,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_u_i_car(((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* library.scm:389: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_11962(t2,((C_word*)t0)[2],C_slot(((C_word*)t0)[3],C_fix(1)));}}

/* scheme#list? in k11449 */
static void C_ccall f_11999(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11999,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_listp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#string? in k11449 */
static void C_ccall f_12002(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12002,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_stringp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#string-length in k11449 */
static void C_ccall f_12005(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12005,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_string_length(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#string-ref in k11449 */
static void C_ccall f_12008(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12008,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_string_ref(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#string-set! in k11449 */
static void C_ccall f_12011(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12011,c,av);}
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_i_string_set(t2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#string=? in k11449 */
static void C_ccall f_12014(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,4)))){
C_save_and_reclaim((void*)f_12014,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
t5=C_i_string_equal_p(t2,t3);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12021,a[2]=((C_word)li63),tmp=(C_word)a,a+=3,tmp);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(
  f_12021(t3,t4,t5)
);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* loop in scheme#string=? in k11449 */
static C_word f_12021(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t2))){
return(t3);}
else{
t4=C_slot(t2,C_fix(0));
t5=C_i_check_string_2(t4,lf[65]);
t6=C_slot(t2,C_fix(1));
if(C_truep(t3)){
t8=t4;
t9=t6;
t10=C_i_string_equal_p(t1,t4);
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t8=t4;
t9=t6;
t10=C_SCHEME_FALSE;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}}

/* scheme#string-ci=? in k11449 */
static void C_ccall f_12047(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,4)))){
C_save_and_reclaim((void*)f_12047,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
t5=C_i_string_ci_equal_p(t2,t3);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12054,a[2]=((C_word)li65),tmp=(C_word)a,a+=3,tmp);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(
  f_12054(t3,t4,t5)
);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* loop in scheme#string-ci=? in k11449 */
static C_word f_12054(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t2))){
return(t3);}
else{
t4=C_slot(t2,C_fix(0));
t5=C_i_check_string_2(t4,lf[67]);
t6=C_slot(t2,C_fix(1));
if(C_truep(t3)){
t8=t4;
t9=t6;
t10=C_i_string_ci_equal_p(t1,t4);
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t8=t4;
t9=t6;
t10=C_SCHEME_FALSE;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}}

/* scheme#exact->inexact in k11449 */
static void C_ccall f_12098(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(12,c,1)))){
C_save_and_reclaim((void *)f_12098,c,av);}
a=C_alloc(12);
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_exact_to_inexact(&a,1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#abs in k11449 */
static void C_ccall f_12101(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,1)))){
C_save_and_reclaim((void *)f_12101,c,av);}
a=C_alloc(7);
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_i_abs(&a,1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#quotient in k11449 */
static void C_ccall f_12107(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_12107,c,av);}
a=C_alloc(5);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_s_a_i_quotient(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#remainder in k11449 */
static void C_ccall f_12110(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_12110,c,av);}
a=C_alloc(5);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_s_a_i_remainder(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#modulo in k11449 */
static void C_ccall f_12113(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_12113,c,av);}
a=C_alloc(5);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_s_a_i_modulo(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#even? in k11449 */
static void C_ccall f_12116(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12116,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_evenp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#odd? in k11449 */
static void C_ccall f_12119(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12119,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_oddp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#number? in k11449 */
static void C_ccall f_12127(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12127,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_numberp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#real? in k11449 */
static void C_ccall f_12131(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12131,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_realp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#rational? in k11449 */
static void C_ccall f_12134(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12134,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_rationalp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#integer? in k11449 */
static void C_ccall f_12137(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12137,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_integerp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#exact? in k11449 */
static void C_ccall f_12140(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12140,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_exactp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#inexact? in k11449 */
static void C_ccall f_12143(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12143,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_inexactp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#zero? in k11449 */
static void C_ccall f_12146(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12146,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_zerop(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#positive? in k11449 */
static void C_ccall f_12149(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12149,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_positivep(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#negative? in k11449 */
static void C_ccall f_12152(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12152,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_negativep(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#exact-integer? in k11449 */
static void C_ccall f_12155(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12155,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_exact_integerp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#symbol? in k11449 */
static void C_ccall f_12159(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12159,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_symbolp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#vector? in k11449 */
static void C_ccall f_12162(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12162,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_vectorp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#vector-length in k11449 */
static void C_ccall f_12165(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12165,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_vector_length(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#vector-ref in k11449 */
static void C_ccall f_12168(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12168,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_vector_ref(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#vector-set! in k11449 */
static void C_ccall f_12171(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12171,c,av);}
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_i_vector_set(t2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#char? in k11449 */
static void C_ccall f_12179(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12179,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_charp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#char->integer in k11449 */
static void C_ccall f_12182(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12182,c,av);}
t3=C_i_check_char_2(t2,lf[125]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fix(C_character_code(t2));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#integer->char in k11449 */
static void C_ccall f_12189(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12189,c,av);}
t3=C_i_check_fixnum_2(t2,lf[127]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_make_character(C_unfix(t2));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#char=? in k11449 */
static void C_ccall f_12196(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,4)))){
C_save_and_reclaim((void*)f_12196,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t5=C_i_check_char_2(t2,lf[129]);
t6=C_i_check_char_2(t3,lf[129]);
t7=C_u_i_char_equalp(t2,t3);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12209,a[2]=((C_word)li101),tmp=(C_word)a,a+=3,tmp);
t9=t1;{
C_word *av2=av;
av2[0]=t9;
av2[1]=(
  f_12209(t3,t4,t7)
);
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}

/* loop in scheme#char=? in k11449 */
static C_word f_12209(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t2))){
return(t3);}
else{
t4=C_slot(t2,C_fix(0));
t5=C_i_check_char_2(t4,lf[129]);
t6=C_slot(t2,C_fix(1));
if(C_truep(t3)){
t8=t4;
t9=t6;
t10=C_u_i_char_equalp(t1,t4);
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t8=t4;
t9=t6;
t10=C_SCHEME_FALSE;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}}

/* scheme#char>? in k11449 */
static void C_ccall f_12235(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,4)))){
C_save_and_reclaim((void*)f_12235,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t5=C_i_check_char_2(t2,lf[131]);
t6=C_i_check_char_2(t3,lf[131]);
t7=C_u_i_char_greaterp(t2,t3);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12248,a[2]=((C_word)li103),tmp=(C_word)a,a+=3,tmp);
t9=t1;{
C_word *av2=av;
av2[0]=t9;
av2[1]=(
  f_12248(t3,t4,t7)
);
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}

/* loop in scheme#char>? in k11449 */
static C_word f_12248(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t2))){
return(t3);}
else{
t4=C_slot(t2,C_fix(0));
t5=C_i_check_char_2(t4,lf[131]);
t6=C_slot(t2,C_fix(1));
if(C_truep(t3)){
t8=t4;
t9=t6;
t10=C_u_i_char_greaterp(t1,t4);
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t8=t4;
t9=t6;
t10=C_SCHEME_FALSE;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}}

/* scheme#char<? in k11449 */
static void C_ccall f_12274(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,4)))){
C_save_and_reclaim((void*)f_12274,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t5=C_i_check_char_2(t2,lf[133]);
t6=C_i_check_char_2(t3,lf[133]);
t7=C_u_i_char_lessp(t2,t3);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12287,a[2]=((C_word)li105),tmp=(C_word)a,a+=3,tmp);
t9=t1;{
C_word *av2=av;
av2[0]=t9;
av2[1]=(
  f_12287(t3,t4,t7)
);
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}

/* loop in scheme#char<? in k11449 */
static C_word f_12287(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t2))){
return(t3);}
else{
t4=C_slot(t2,C_fix(0));
t5=C_i_check_char_2(t4,lf[133]);
t6=C_slot(t2,C_fix(1));
if(C_truep(t3)){
t8=t4;
t9=t6;
t10=C_u_i_char_lessp(t1,t4);
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t8=t4;
t9=t6;
t10=C_SCHEME_FALSE;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}}

/* scheme#char>=? in k11449 */
static void C_ccall f_12313(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,4)))){
C_save_and_reclaim((void*)f_12313,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t5=C_i_check_char_2(t2,lf[135]);
t6=C_i_check_char_2(t3,lf[135]);
t7=C_u_i_char_greater_or_equal_p(t2,t3);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12326,a[2]=((C_word)li107),tmp=(C_word)a,a+=3,tmp);
t9=t1;{
C_word *av2=av;
av2[0]=t9;
av2[1]=(
  f_12326(t3,t4,t7)
);
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}

/* loop in scheme#char>=? in k11449 */
static C_word f_12326(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t2))){
return(t3);}
else{
t4=C_slot(t2,C_fix(0));
t5=C_i_check_char_2(t4,lf[135]);
t6=C_slot(t2,C_fix(1));
if(C_truep(t3)){
t8=t4;
t9=t6;
t10=C_u_i_char_greater_or_equal_p(t1,t4);
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t8=t4;
t9=t6;
t10=C_SCHEME_FALSE;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}}

/* scheme#char<=? in k11449 */
static void C_ccall f_12352(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,4)))){
C_save_and_reclaim((void*)f_12352,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t5=C_i_check_char_2(t2,lf[137]);
t6=C_i_check_char_2(t3,lf[137]);
t7=C_u_i_char_less_or_equal_p(t2,t3);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12365,a[2]=((C_word)li109),tmp=(C_word)a,a+=3,tmp);
t9=t1;{
C_word *av2=av;
av2[0]=t9;
av2[1]=(
  f_12365(t3,t4,t7)
);
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}

/* loop in scheme#char<=? in k11449 */
static C_word f_12365(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t2))){
return(t3);}
else{
t4=C_slot(t2,C_fix(0));
t5=C_i_check_char_2(t4,lf[137]);
t6=C_slot(t2,C_fix(1));
if(C_truep(t3)){
t8=t4;
t9=t6;
t10=C_u_i_char_less_or_equal_p(t1,t4);
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t8=t4;
t9=t6;
t10=C_SCHEME_FALSE;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}}

/* scheme#char-upcase in k11449 */
static void C_ccall f_12391(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12391,c,av);}
t3=C_i_check_char_2(t2,lf[139]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_char_upcase(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#char-downcase in k11449 */
static void C_ccall f_12397(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12397,c,av);}
t3=C_i_check_char_2(t2,lf[141]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_char_downcase(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#char-upper-case? in k11449 */
static void C_ccall f_12408(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12408,c,av);}
t3=C_i_check_char_2(t2,lf[148]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_char_upper_casep(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#char-lower-case? in k11449 */
static void C_ccall f_12414(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12414,c,av);}
t3=C_i_check_char_2(t2,lf[150]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_char_lower_casep(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#char-numeric? in k11449 */
static void C_ccall f_12420(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12420,c,av);}
t3=C_i_check_char_2(t2,lf[152]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_char_numericp(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#char-whitespace? in k11449 */
static void C_ccall f_12426(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12426,c,av);}
t3=C_i_check_char_2(t2,lf[154]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_char_whitespacep(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#char-alphabetic? in k11449 */
static void C_ccall f_12432(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12432,c,av);}
t3=C_i_check_char_2(t2,lf[156]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_char_alphabeticp(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme.char#digit-value in k11449 */
static void C_ccall f_12438(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12438,c,av);}
t3=C_i_check_char_2(t2,lf[158]);
t4=C_u_i_digit_value(t2);
t5=C_eqp(t4,C_fix(0));
t6=C_i_not(t5);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?C_fixnum_difference(t4,C_fix(1)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* scheme#char-foldcase in k11449 */
static void C_ccall f_12454(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12454,c,av);}
t3=C_i_check_char_2(t2,lf[160]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_utf_char_foldcase(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#string-foldcase in k11449 */
static void C_ccall f_12460(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_12460,c,av);}
a=C_alloc(5);
t3=C_i_check_string_2(t2,lf[162]);
t4=C_slot(t2,C_fix(0));
t5=C_block_size(t4);
t6=C_fixnum_difference(t5,C_fix(1));
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12474,a[2]=t1,a[3]=t4,a[4]=t6,tmp=(C_word)a,a+=5,tmp);
/* library.scm:685: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[164]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[164]+1);
av2[1]=t7;
av2[2]=C_fixnum_times(t6,C_fix(2));
tp(3,av2);}}

/* k12472 in scheme#string-foldcase in k11449 */
static void C_ccall f_12474(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_12474,c,av);}
/* library.scm:687: ##sys#buffer->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[163]+1));
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[163]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=C_fix(0);
av2[4]=C_utf_string_foldcase(((C_word*)t0)[3],t1,((C_word*)t0)[4]);
tp(5,av2);}}

/* scheme#string-downcase in k11449 */
static void C_ccall f_12480(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_12480,c,av);}
a=C_alloc(5);
t3=C_i_check_string_2(t2,lf[166]);
t4=C_slot(t2,C_fix(0));
t5=C_block_size(t4);
t6=C_fixnum_difference(t5,C_fix(1));
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12494,a[2]=t1,a[3]=t4,a[4]=t6,tmp=(C_word)a,a+=5,tmp);
/* library.scm:693: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[164]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[164]+1);
av2[1]=t7;
av2[2]=C_fixnum_times(t6,C_fix(2));
tp(3,av2);}}

/* k12492 in scheme#string-downcase in k11449 */
static void C_ccall f_12494(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_12494,c,av);}
/* library.scm:695: ##sys#buffer->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[163]+1));
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[163]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=C_fix(0);
av2[4]=C_utf_string_downcase(((C_word*)t0)[3],t1,((C_word*)t0)[4]);
tp(5,av2);}}

/* scheme#string-upcase in k11449 */
static void C_ccall f_12500(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_12500,c,av);}
a=C_alloc(5);
t3=C_i_check_string_2(t2,lf[168]);
t4=C_slot(t2,C_fix(0));
t5=C_block_size(t4);
t6=C_fixnum_difference(t5,C_fix(1));
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12514,a[2]=t1,a[3]=t4,a[4]=t6,tmp=(C_word)a,a+=5,tmp);
/* library.scm:701: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[164]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[164]+1);
av2[1]=t7;
av2[2]=C_fixnum_times(t6,C_fix(2));
tp(3,av2);}}

/* k12512 in scheme#string-upcase in k11449 */
static void C_ccall f_12514(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_12514,c,av);}
/* library.scm:703: ##sys#buffer->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[163]+1));
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[163]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=C_fix(0);
av2[4]=C_utf_string_upcase(((C_word*)t0)[3],t1,((C_word*)t0)[4]);
tp(5,av2);}}

/* scheme#procedure? in k11449 */
static void C_ccall f_12520(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12520,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_closurep(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#input-port? in k11449 */
static void C_ccall f_12528(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12528,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(C_blockp(t2))?C_input_portp(t2):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#output-port? in k11449 */
static void C_ccall f_12534(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12534,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(C_blockp(t2))?C_output_portp(t2):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#binary-port? in k11449 */
static void C_ccall f_12540(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_12540,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12547,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:725: port? */
t4=*((C_word*)lf[179]+1);{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k12545 in scheme#binary-port? in k11449 */
static void C_ccall f_12547(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12547,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=(C_truep(t1)?C_eqp(lf[178],C_slot(((C_word*)t0)[3],C_fix(14))):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* scheme#textual-port? in k11449 */
static void C_ccall f_12556(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_12556,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12563,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:729: port? */
t4=*((C_word*)lf[179]+1);{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k12561 in scheme#textual-port? in k11449 */
static void C_ccall f_12563(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12563,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=(C_truep(t1)?C_eqp(lf[181],C_slot(((C_word*)t0)[3],C_fix(14))):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* scheme#port? in k11449 */
static void C_ccall f_12572(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12572,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(C_blockp(t2))?C_portp(t2):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#input-port-open? in k11449 */
static void C_ccall f_12578(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12578,c,av);}
t3=C_i_check_port(t2,C_fix(1),lf[183]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_input_port_openp(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#output-port-open? in k11449 */
static void C_ccall f_12583(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12583,c,av);}
t3=C_i_check_port(t2,C_fix(2),lf[185]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_output_port_openp(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#eof-object? in k11449 */
static void C_ccall f_12598(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12598,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_eofp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#eval in k11449 */
static void C_ccall f_12609(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_12609,c,av);}
/* library.scm:779: ##sys#error */
t3=*((C_word*)lf[206]+1);{
C_word av2[4];
av2[0]=t3;
av2[1]=t1;
av2[2]=lf[207];
av2[3]=lf[208];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* scheme#interaction-environment in k11449 */
static void C_ccall f_12615(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_12615,c,av);}
/* library.scm:782: ##sys#error */
t2=*((C_word*)lf[206]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[210];
av2[3]=lf[211];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* scheme#scheme-report-environment in k11449 */
static void C_ccall f_12621(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_12621,c,av);}
/* library.scm:785: ##sys#error */
t3=*((C_word*)lf[206]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=lf[213];
av2[3]=lf[214];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* scheme#null-environment in k11449 */
static void C_ccall f_12627(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_12627,c,av);}
/* library.scm:788: ##sys#error */
t2=*((C_word*)lf[206]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[216];
av2[3]=lf[217];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* scheme#load in k11449 */
static void C_ccall f_12633(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_12633,c,av);}
/* library.scm:791: ##sys#error */
t3=*((C_word*)lf[206]+1);{
C_word av2[4];
av2[0]=t3;
av2[1]=t1;
av2[2]=lf[219];
av2[3]=lf[220];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k12641 in k11449 */
static void C_ccall f_12643(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word t106;
C_word t107;
C_word t108;
C_word t109;
C_word t110;
C_word t111;
C_word t112;
C_word t113;
C_word t114;
C_word t115;
C_word t116;
C_word t117;
C_word t118;
C_word t119;
C_word t120;
C_word t121;
C_word t122;
C_word t123;
C_word t124;
C_word t125;
C_word t126;
C_word t127;
C_word t128;
C_word t129;
C_word t130;
C_word t131;
C_word t132;
C_word t133;
C_word t134;
C_word t135;
C_word t136;
C_word t137;
C_word t138;
C_word t139;
C_word t140;
C_word t141;
C_word t142;
C_word t143;
C_word t144;
C_word t145;
C_word t146;
C_word t147;
C_word t148;
C_word t149;
C_word t150;
C_word t151;
C_word t152;
C_word t153;
C_word t154;
C_word t155;
C_word t156;
C_word t157;
C_word t158;
C_word t159;
C_word t160;
C_word t161;
C_word t162;
C_word t163;
C_word t164;
C_word t165;
C_word t166;
C_word t167;
C_word t168;
C_word t169;
C_word t170;
C_word t171;
C_word t172;
C_word t173;
C_word t174;
C_word t175;
C_word t176;
C_word t177;
C_word t178;
C_word t179;
C_word t180;
C_word t181;
C_word t182;
C_word t183;
C_word t184;
C_word t185;
C_word t186;
C_word t187;
C_word t188;
C_word t189;
C_word t190;
C_word t191;
C_word t192;
C_word t193;
C_word t194;
C_word t195;
C_word t196;
C_word t197;
C_word t198;
C_word t199;
C_word t200;
C_word t201;
C_word t202;
C_word t203;
C_word t204;
C_word t205;
C_word t206;
C_word t207;
C_word t208;
C_word t209;
C_word t210;
C_word t211;
C_word t212;
C_word t213;
C_word t214;
C_word t215;
C_word t216;
C_word t217;
C_word t218;
C_word t219;
C_word t220;
C_word t221;
C_word t222;
C_word t223;
C_word t224;
C_word t225;
C_word t226;
C_word t227;
C_word t228;
C_word t229;
C_word t230;
C_word t231;
C_word t232;
C_word t233;
C_word t234;
C_word t235;
C_word t236;
C_word t237;
C_word t238;
C_word t239;
C_word t240;
C_word t241;
C_word t242;
C_word t243;
C_word t244;
C_word t245;
C_word t246;
C_word t247;
C_word t248;
C_word t249;
C_word t250;
C_word t251;
C_word t252;
C_word t253;
C_word t254;
C_word t255;
C_word t256;
C_word t257;
C_word t258;
C_word t259;
C_word t260;
C_word t261;
C_word t262;
C_word t263;
C_word t264;
C_word t265;
C_word t266;
C_word t267;
C_word t268;
C_word t269;
C_word t270;
C_word t271;
C_word t272;
C_word t273;
C_word t274;
C_word t275;
C_word t276;
C_word t277;
C_word t278;
C_word t279;
C_word t280;
C_word t281;
C_word t282;
C_word t283;
C_word t284;
C_word t285;
C_word t286;
C_word t287;
C_word t288;
C_word t289;
C_word t290;
C_word t291;
C_word t292;
C_word t293;
C_word t294;
C_word t295;
C_word t296;
C_word t297;
C_word t298;
C_word t299;
C_word t300;
C_word t301;
C_word t302;
C_word t303;
C_word t304;
C_word t305;
C_word t306;
C_word t307;
C_word t308;
C_word t309;
C_word t310;
C_word t311;
C_word t312;
C_word t313;
C_word t314;
C_word t315;
C_word t316;
C_word t317;
C_word t318;
C_word t319;
C_word t320;
C_word t321;
C_word t322;
C_word t323;
C_word t324;
C_word t325;
C_word t326;
C_word t327;
C_word t328;
C_word t329;
C_word t330;
C_word t331;
C_word t332;
C_word t333;
C_word t334;
C_word t335;
C_word t336;
C_word t337;
C_word t338;
C_word t339;
C_word t340;
C_word t341;
C_word t342;
C_word t343;
C_word t344;
C_word t345;
C_word t346;
C_word t347;
C_word t348;
C_word t349;
C_word t350;
C_word t351;
C_word t352;
C_word t353;
C_word t354;
C_word t355;
C_word t356;
C_word t357;
C_word t358;
C_word t359;
C_word t360;
C_word t361;
C_word t362;
C_word t363;
C_word t364;
C_word t365;
C_word t366;
C_word t367;
C_word t368;
C_word t369;
C_word t370;
C_word t371;
C_word t372;
C_word t373;
C_word t374;
C_word t375;
C_word t376;
C_word t377;
C_word t378;
C_word t379;
C_word t380;
C_word t381;
C_word t382;
C_word t383;
C_word t384;
C_word t385;
C_word t386;
C_word t387;
C_word t388;
C_word t389;
C_word t390;
C_word t391;
C_word t392;
C_word t393;
C_word t394;
C_word t395;
C_word t396;
C_word t397;
C_word t398;
C_word t399;
C_word t400;
C_word t401;
C_word t402;
C_word t403;
C_word t404;
C_word t405;
C_word t406;
C_word t407;
C_word t408;
C_word t409;
C_word t410;
C_word t411;
C_word t412;
C_word t413;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(1133,c,7)))){
C_save_and_reclaim((void *)f_12643,c,av);}
a=C_alloc(1133);
t2=C_a_i_provide(&a,1,lf[224]);
t3=C_mutate((C_word*)lf[225]+1 /* (set! chicken.base#fixnum? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12645,a[2]=((C_word)li140),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[226]+1 /* (set! chicken.base#flonum? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12648,a[2]=((C_word)li141),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[227]+1 /* (set! chicken.base#bignum? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12651,a[2]=((C_word)li142),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[228]+1 /* (set! chicken.base#ratnum? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12654,a[2]=((C_word)li143),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[229]+1 /* (set! chicken.base#cplxnum? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12657,a[2]=((C_word)li144),tmp=(C_word)a,a+=3,tmp));
t8=C_set_block_item(lf[230] /* chicken.base#exact-integer-sqrt */,0,C_SCHEME_UNDEFINED);
t9=C_mutate((C_word*)lf[231]+1 /* (set! chicken.base#quotient&remainder ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_quotient_and_remainder,a[2]=((C_word)li145),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate((C_word*)lf[232]+1 /* (set! chicken.base#quotient&modulo ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12662,a[2]=((C_word)li148),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate((C_word*)lf[233]+1 /* (set! chicken.base#finite? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12709,a[2]=((C_word)li149),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate((C_word*)lf[234]+1 /* (set! chicken.base#infinite? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12712,a[2]=((C_word)li150),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate((C_word*)lf[235]+1 /* (set! chicken.base#nan? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12715,a[2]=((C_word)li151),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate((C_word*)lf[236]+1 /* (set! chicken.base#signum ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_signum,a[2]=((C_word)li152),tmp=(C_word)a,a+=3,tmp));
t15=C_set_block_item(lf[237] /* chicken.base#get-call-chain */,0,C_SCHEME_UNDEFINED);
t16=C_set_block_item(lf[238] /* chicken.base#print-call-chain */,0,C_SCHEME_UNDEFINED);
t17=C_set_block_item(lf[239] /* chicken.base#print */,0,C_SCHEME_UNDEFINED);
t18=C_set_block_item(lf[240] /* chicken.base#print* */,0,C_SCHEME_UNDEFINED);
t19=C_mutate((C_word*)lf[241]+1 /* (set! chicken.base#add1 ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12723,a[2]=((C_word)li153),tmp=(C_word)a,a+=3,tmp));
t20=C_mutate((C_word*)lf[242]+1 /* (set! chicken.base#sub1 ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12729,a[2]=((C_word)li154),tmp=(C_word)a,a+=3,tmp));
t21=C_set_block_item(lf[243] /* chicken.base#current-error-port */,0,C_SCHEME_UNDEFINED);
t22=C_mutate((C_word*)lf[244]+1 /* (set! chicken.base#error ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12736,a[2]=((C_word)li155),tmp=(C_word)a,a+=3,tmp));
t23=C_mutate((C_word*)lf[247]+1 /* (set! chicken.base#void ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12751,a[2]=((C_word)li156),tmp=(C_word)a,a+=3,tmp));
t24=C_set_block_item(lf[248] /* chicken.base#sleep */,0,C_SCHEME_UNDEFINED);
t25=C_set_block_item(lf[249] /* chicken.base#char-name */,0,C_SCHEME_UNDEFINED);
t26=C_set_block_item(lf[250] /* chicken.base#getter-with-setter */,0,C_SCHEME_UNDEFINED);
t27=C_set_block_item(lf[251] /* chicken.base#procedure-information */,0,C_SCHEME_UNDEFINED);
t28=C_set_block_item(lf[252] /* chicken.base#setter */,0,C_SCHEME_UNDEFINED);
t29=C_set_block_item(lf[253] /* chicken.base#record-printer */,0,C_SCHEME_UNDEFINED);
t30=C_set_block_item(lf[254] /* chicken.base#set-record-printer! */,0,C_SCHEME_UNDEFINED);
t31=C_set_block_item(lf[255] /* chicken.base#subvector */,0,C_SCHEME_UNDEFINED);
t32=C_set_block_item(lf[256] /* chicken.base#vector-resize */,0,C_SCHEME_UNDEFINED);
t33=C_set_block_item(lf[257] /* chicken.base#port-closed? */,0,C_SCHEME_UNDEFINED);
t34=C_set_block_item(lf[258] /* chicken.base#flush-output */,0,C_SCHEME_UNDEFINED);
t35=C_mutate((C_word*)lf[259]+1 /* (set! chicken.base#promise? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12765,a[2]=((C_word)li157),tmp=(C_word)a,a+=3,tmp));
t36=C_mutate((C_word*)lf[261]+1 /* (set! ##sys#make-promise ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12771,a[2]=((C_word)li158),tmp=(C_word)a,a+=3,tmp));
t37=C_mutate((C_word*)lf[262]+1 /* (set! chicken.base#make-promise ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12777,a[2]=((C_word)li160),tmp=(C_word)a,a+=3,tmp));
t38=C_mutate((C_word*)lf[263]+1 /* (set! chicken.base#foldl ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12792,a[2]=((C_word)li162),tmp=(C_word)a,a+=3,tmp));
t39=C_mutate((C_word*)lf[265]+1 /* (set! chicken.base#foldr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12829,a[2]=((C_word)li164),tmp=(C_word)a,a+=3,tmp));
t40=C_set_block_item(lf[267] /* chicken.base#implicit-exit-handler */,0,C_SCHEME_UNDEFINED);
t41=C_set_block_item(lf[268] /* chicken.base#exit-handler */,0,C_SCHEME_UNDEFINED);
t42=C_set_block_item(lf[269] /* chicken.base#cleanup-tasks */,0,C_SCHEME_END_OF_LIST);
t43=C_mutate((C_word*)lf[270]+1 /* (set! chicken.base#on-exit ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12869,a[2]=((C_word)li165),tmp=(C_word)a,a+=3,tmp));
t44=C_mutate((C_word*)lf[271]+1 /* (set! chicken.base#exit ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12876,a[2]=((C_word)li166),tmp=(C_word)a,a+=3,tmp));
t45=C_mutate((C_word*)lf[272]+1 /* (set! chicken.base#emergency-exit ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12894,a[2]=((C_word)li167),tmp=(C_word)a,a+=3,tmp));
t46=C_set_block_item(lf[274] /* chicken.base#case-sensitive */,0,C_SCHEME_UNDEFINED);
t47=C_set_block_item(lf[275] /* chicken.base#keyword-style */,0,C_SCHEME_UNDEFINED);
t48=C_set_block_item(lf[276] /* chicken.base#parentheses-synonyms */,0,C_SCHEME_UNDEFINED);
t49=C_set_block_item(lf[277] /* chicken.base#symbol-escape */,0,C_SCHEME_UNDEFINED);
t50=C_mutate((C_word*)lf[278]+1 /* (set! chicken.base#identity ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12913,a[2]=((C_word)li168),tmp=(C_word)a,a+=3,tmp));
t51=C_mutate((C_word*)lf[279]+1 /* (set! chicken.base#conjoin ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12916,a[2]=((C_word)li171),tmp=(C_word)a,a+=3,tmp));
t52=C_mutate((C_word*)lf[280]+1 /* (set! chicken.base#disjoin ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12949,a[2]=((C_word)li174),tmp=(C_word)a,a+=3,tmp));
t53=C_mutate((C_word*)lf[281]+1 /* (set! chicken.base#constantly ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12986,a[2]=((C_word)li177),tmp=(C_word)a,a+=3,tmp));
t54=C_mutate((C_word*)lf[282]+1 /* (set! chicken.base#flip ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13007,a[2]=((C_word)li179),tmp=(C_word)a,a+=3,tmp));
t55=C_mutate((C_word*)lf[283]+1 /* (set! chicken.base#complement ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13015,a[2]=((C_word)li181),tmp=(C_word)a,a+=3,tmp));
t56=C_mutate((C_word*)lf[284]+1 /* (set! chicken.base#compose ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13027,a[2]=((C_word)li185),tmp=(C_word)a,a+=3,tmp));
t57=C_mutate((C_word*)lf[285]+1 /* (set! chicken.base#o ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13063,a[2]=((C_word)li188),tmp=(C_word)a,a+=3,tmp));
t58=C_mutate((C_word*)lf[286]+1 /* (set! chicken.base#list-of? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13102,a[2]=((C_word)li191),tmp=(C_word)a,a+=3,tmp));
t59=C_mutate((C_word*)lf[287]+1 /* (set! chicken.base#each ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13146,a[2]=((C_word)li195),tmp=(C_word)a,a+=3,tmp));
t60=C_mutate((C_word*)lf[289]+1 /* (set! chicken.base#bwp-object? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13202,a[2]=((C_word)li196),tmp=(C_word)a,a+=3,tmp));
t61=C_mutate((C_word*)lf[290]+1 /* (set! chicken.base#weak-cons ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13205,a[2]=((C_word)li197),tmp=(C_word)a,a+=3,tmp));
t62=C_mutate((C_word*)lf[291]+1 /* (set! chicken.base#weak-pair? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13208,a[2]=((C_word)li198),tmp=(C_word)a,a+=3,tmp));
t63=C_mutate((C_word*)lf[292]+1 /* (set! chicken.base#atom? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13211,a[2]=((C_word)li199),tmp=(C_word)a,a+=3,tmp));
t64=C_mutate((C_word*)lf[293]+1 /* (set! chicken.base#tail? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13214,a[2]=((C_word)li201),tmp=(C_word)a,a+=3,tmp));
t65=C_mutate((C_word*)lf[295]+1 /* (set! chicken.base#intersperse ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13242,a[2]=((C_word)li203),tmp=(C_word)a,a+=3,tmp));
t66=C_mutate((C_word*)lf[296]+1 /* (set! chicken.base#butlast ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13275,a[2]=((C_word)li205),tmp=(C_word)a,a+=3,tmp));
t67=C_mutate((C_word*)lf[298]+1 /* (set! chicken.base#flatten ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13307,a[2]=((C_word)li207),tmp=(C_word)a,a+=3,tmp));
t68=C_mutate((C_word*)lf[299]+1 /* (set! chicken.base#join ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13348,a[2]=((C_word)li209),tmp=(C_word)a,a+=3,tmp));
t69=C_mutate((C_word*)lf[302]+1 /* (set! chicken.base#compress ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13405,a[2]=((C_word)li211),tmp=(C_word)a,a+=3,tmp));
t70=C_mutate((C_word*)lf[306]+1 /* (set! chicken.base#alist-update! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13485,a[2]=((C_word)li214),tmp=(C_word)a,a+=3,tmp));
t71=C_mutate((C_word*)lf[307]+1 /* (set! chicken.base#alist-update ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13571,a[2]=((C_word)li216),tmp=(C_word)a,a+=3,tmp));
t72=C_mutate((C_word*)lf[311]+1 /* (set! chicken.base#alist-ref ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13675,a[2]=((C_word)li219),tmp=(C_word)a,a+=3,tmp));
t73=C_mutate((C_word*)lf[314]+1 /* (set! chicken.base#rassoc ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13787,a[2]=((C_word)li221),tmp=(C_word)a,a+=3,tmp));
t74=C_mutate((C_word*)lf[316]+1 /* (set! scheme#open-input-string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13835,a[2]=((C_word)li222),tmp=(C_word)a,a+=3,tmp));
t75=C_mutate((C_word*)lf[322]+1 /* (set! scheme#open-output-string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13863,a[2]=((C_word)li223),tmp=(C_word)a,a+=3,tmp));
t76=C_mutate((C_word*)lf[324]+1 /* (set! scheme#get-output-string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13882,a[2]=((C_word)li224),tmp=(C_word)a,a+=3,tmp));
t77=C_mutate((C_word*)lf[327]+1 /* (set! scheme#open-input-bytevector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13916,a[2]=((C_word)li230),tmp=(C_word)a,a+=3,tmp));
t78=C_mutate((C_word*)lf[332]+1 /* (set! scheme#open-output-bytevector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13984,a[2]=((C_word)li236),tmp=(C_word)a,a+=3,tmp));
t79=C_mutate((C_word*)lf[334]+1 /* (set! scheme#get-output-bytevector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14053,a[2]=((C_word)li238),tmp=(C_word)a,a+=3,tmp));
t80=C_unsigned_long_to_num(&a,C_HEADER_SIZE_MASK);
t81=C_mutate(&lf[338] /* (set! maximal-string-length ...) */,C_s_a_u_i_integer_minus(&a,2,t80,C_fix(1)));
t82=C_a_i_provide(&a,1,lf[339]);
t83=C_set_block_item(lf[340] /* chicken.fixnum#most-positive-fixnum */,0,C_fix((C_word)C_MOST_POSITIVE_FIXNUM));
t84=C_set_block_item(lf[341] /* chicken.fixnum#most-negative-fixnum */,0,C_fix((C_word)C_MOST_NEGATIVE_FIXNUM));
t85=C_set_block_item(lf[342] /* chicken.fixnum#fixnum-bits */,0,C_fix((C_word)(C_WORD_SIZE - 1)));
t86=C_set_block_item(lf[343] /* chicken.fixnum#fixnum-precision */,0,C_fix((C_word)(C_WORD_SIZE - (1 + 1))));
t87=C_mutate((C_word*)lf[344]+1 /* (set! chicken.fixnum#fx+ ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14100,a[2]=((C_word)li239),tmp=(C_word)a,a+=3,tmp));
t88=C_mutate((C_word*)lf[345]+1 /* (set! chicken.fixnum#fx- ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14103,a[2]=((C_word)li240),tmp=(C_word)a,a+=3,tmp));
t89=C_mutate((C_word*)lf[346]+1 /* (set! chicken.fixnum#fx* ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14106,a[2]=((C_word)li241),tmp=(C_word)a,a+=3,tmp));
t90=C_mutate((C_word*)lf[347]+1 /* (set! chicken.fixnum#fx= ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14109,a[2]=((C_word)li242),tmp=(C_word)a,a+=3,tmp));
t91=C_mutate((C_word*)lf[348]+1 /* (set! chicken.fixnum#fx> ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14115,a[2]=((C_word)li243),tmp=(C_word)a,a+=3,tmp));
t92=C_mutate((C_word*)lf[349]+1 /* (set! chicken.fixnum#fx< ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14118,a[2]=((C_word)li244),tmp=(C_word)a,a+=3,tmp));
t93=C_mutate((C_word*)lf[350]+1 /* (set! chicken.fixnum#fx>= ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14121,a[2]=((C_word)li245),tmp=(C_word)a,a+=3,tmp));
t94=C_mutate((C_word*)lf[351]+1 /* (set! chicken.fixnum#fx<= ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14124,a[2]=((C_word)li246),tmp=(C_word)a,a+=3,tmp));
t95=C_mutate((C_word*)lf[352]+1 /* (set! chicken.fixnum#fxmin ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14127,a[2]=((C_word)li247),tmp=(C_word)a,a+=3,tmp));
t96=C_mutate((C_word*)lf[353]+1 /* (set! chicken.fixnum#fxmax ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14130,a[2]=((C_word)li248),tmp=(C_word)a,a+=3,tmp));
t97=C_mutate((C_word*)lf[354]+1 /* (set! chicken.fixnum#fxneg ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14133,a[2]=((C_word)li249),tmp=(C_word)a,a+=3,tmp));
t98=C_mutate((C_word*)lf[355]+1 /* (set! chicken.fixnum#fxand ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14136,a[2]=((C_word)li250),tmp=(C_word)a,a+=3,tmp));
t99=C_mutate((C_word*)lf[356]+1 /* (set! chicken.fixnum#fxior ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14139,a[2]=((C_word)li251),tmp=(C_word)a,a+=3,tmp));
t100=C_mutate((C_word*)lf[357]+1 /* (set! chicken.fixnum#fxxor ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14142,a[2]=((C_word)li252),tmp=(C_word)a,a+=3,tmp));
t101=C_mutate((C_word*)lf[358]+1 /* (set! chicken.fixnum#fxnot ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14145,a[2]=((C_word)li253),tmp=(C_word)a,a+=3,tmp));
t102=C_mutate((C_word*)lf[359]+1 /* (set! chicken.fixnum#fxshl ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14148,a[2]=((C_word)li254),tmp=(C_word)a,a+=3,tmp));
t103=C_mutate((C_word*)lf[360]+1 /* (set! chicken.fixnum#fxshr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14151,a[2]=((C_word)li255),tmp=(C_word)a,a+=3,tmp));
t104=C_mutate((C_word*)lf[361]+1 /* (set! chicken.fixnum#fxodd? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14154,a[2]=((C_word)li256),tmp=(C_word)a,a+=3,tmp));
t105=C_mutate((C_word*)lf[362]+1 /* (set! chicken.fixnum#fxeven? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14157,a[2]=((C_word)li257),tmp=(C_word)a,a+=3,tmp));
t106=C_mutate((C_word*)lf[363]+1 /* (set! chicken.fixnum#fxlen ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14160,a[2]=((C_word)li258),tmp=(C_word)a,a+=3,tmp));
t107=C_mutate((C_word*)lf[364]+1 /* (set! chicken.fixnum#fx/ ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14163,a[2]=((C_word)li259),tmp=(C_word)a,a+=3,tmp));
t108=C_mutate((C_word*)lf[365]+1 /* (set! chicken.fixnum#fxgcd ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14166,a[2]=((C_word)li260),tmp=(C_word)a,a+=3,tmp));
t109=C_mutate((C_word*)lf[366]+1 /* (set! chicken.fixnum#fxmod ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14169,a[2]=((C_word)li261),tmp=(C_word)a,a+=3,tmp));
t110=C_mutate((C_word*)lf[367]+1 /* (set! chicken.fixnum#fxrem ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14172,a[2]=((C_word)li262),tmp=(C_word)a,a+=3,tmp));
t111=C_mutate((C_word*)lf[368]+1 /* (set! chicken.fixnum#fx+? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14175,a[2]=((C_word)li263),tmp=(C_word)a,a+=3,tmp));
t112=C_mutate((C_word*)lf[369]+1 /* (set! chicken.fixnum#fx-? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14178,a[2]=((C_word)li264),tmp=(C_word)a,a+=3,tmp));
t113=C_mutate((C_word*)lf[370]+1 /* (set! chicken.fixnum#fx*? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14181,a[2]=((C_word)li265),tmp=(C_word)a,a+=3,tmp));
t114=C_mutate((C_word*)lf[371]+1 /* (set! chicken.fixnum#fx/? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14184,a[2]=((C_word)li266),tmp=(C_word)a,a+=3,tmp));
t115=C_mutate((C_word*)lf[372]+1 /* (set! ##sys#debug-mode? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14187,a[2]=((C_word)li267),tmp=(C_word)a,a+=3,tmp));
t116=C_set_block_item(lf[373] /* ##sys#warnings-enabled */,0,C_SCHEME_TRUE);
t117=C_set_block_item(lf[374] /* ##sys#notices-enabled */,0,C_i_debug_modep());
t118=C_mutate((C_word*)lf[375]+1 /* (set! chicken.base#warning ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14192,a[2]=((C_word)li268),tmp=(C_word)a,a+=3,tmp));
t119=C_mutate((C_word*)lf[377]+1 /* (set! chicken.base#notice ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14201,a[2]=((C_word)li269),tmp=(C_word)a,a+=3,tmp));
t120=C_mutate((C_word*)lf[379]+1 /* (set! chicken.base#enable-warnings ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14213,a[2]=((C_word)li270),tmp=(C_word)a,a+=3,tmp));
t121=C_mutate((C_word*)lf[206]+1 /* (set! ##sys#error ...) */,*((C_word*)lf[244]+1));
t122=C_mutate((C_word*)lf[380]+1 /* (set! ##sys#warn ...) */,*((C_word*)lf[375]+1));
t123=C_mutate((C_word*)lf[381]+1 /* (set! ##sys#notice ...) */,*((C_word*)lf[377]+1));
t124=C_mutate((C_word*)lf[382]+1 /* (set! ##sys#error/errno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14227,a[2]=((C_word)li271),tmp=(C_word)a,a+=3,tmp));
t125=C_mutate((C_word*)lf[384]+1 /* (set! ##sys#gc ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_gc,a[2]=((C_word)li272),tmp=(C_word)a,a+=3,tmp));
t126=C_mutate((C_word*)lf[385]+1 /* (set! ##sys#setslot ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14243,a[2]=((C_word)li273),tmp=(C_word)a,a+=3,tmp));
t127=C_mutate((C_word*)lf[386]+1 /* (set! ##sys#setislot ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14246,a[2]=((C_word)li274),tmp=(C_word)a,a+=3,tmp));
t128=C_mutate((C_word*)lf[387]+1 /* (set! ##sys#allocate-vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_allocate_vector,a[2]=((C_word)li275),tmp=(C_word)a,a+=3,tmp));
t129=C_mutate((C_word*)lf[388]+1 /* (set! ##sys#allocate-bytevector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_allocate_bytevector,a[2]=((C_word)li276),tmp=(C_word)a,a+=3,tmp));
t130=C_mutate((C_word*)lf[389]+1 /* (set! ##sys#make-structure ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_make_structure,a[2]=((C_word)li277),tmp=(C_word)a,a+=3,tmp));
t131=C_mutate((C_word*)lf[390]+1 /* (set! ##sys#ensure-heap-reserve ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_ensure_heap_reserve,a[2]=((C_word)li278),tmp=(C_word)a,a+=3,tmp));
t132=C_mutate((C_word*)lf[391]+1 /* (set! ##sys#symbol-table-info ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_get_symbol_table_info,a[2]=((C_word)li279),tmp=(C_word)a,a+=3,tmp));
t133=C_mutate((C_word*)lf[392]+1 /* (set! ##sys#memory-info ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_get_memory_info,a[2]=((C_word)li280),tmp=(C_word)a,a+=3,tmp));
t134=C_mutate((C_word*)lf[393]+1 /* (set! ##sys#start-timer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14255,a[2]=((C_word)li281),tmp=(C_word)a,a+=3,tmp));
t135=C_mutate((C_word*)lf[394]+1 /* (set! ##sys#stop-timer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14261,a[2]=((C_word)li284),tmp=(C_word)a,a+=3,tmp));
t136=C_mutate((C_word*)lf[395]+1 /* (set! ##sys#immediate? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14281,a[2]=((C_word)li285),tmp=(C_word)a,a+=3,tmp));
t137=C_mutate((C_word*)lf[396]+1 /* (set! ##sys#message ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14288,a[2]=((C_word)li286),tmp=(C_word)a,a+=3,tmp));
t138=C_mutate((C_word*)lf[397]+1 /* (set! ##sys#byte ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14291,a[2]=((C_word)li287),tmp=(C_word)a,a+=3,tmp));
t139=C_mutate((C_word*)lf[398]+1 /* (set! ##sys#void ...) */,*((C_word*)lf[247]+1));
t140=C_set_block_item(lf[288] /* ##sys#undefined-value */,0,C_SCHEME_UNDEFINED);
t141=C_mutate((C_word*)lf[399]+1 /* (set! ##sys#halt ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14296,a[2]=((C_word)li288),tmp=(C_word)a,a+=3,tmp));
t142=C_mutate((C_word*)lf[400]+1 /* (set! ##sys#become! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_become,a[2]=((C_word)li289),tmp=(C_word)a,a+=3,tmp));
t143=C_mutate((C_word*)lf[401]+1 /* (set! ##sys#block-ref ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14300,a[2]=((C_word)li290),tmp=(C_word)a,a+=3,tmp));
t144=C_mutate((C_word*)lf[402]+1 /* (set! ##sys#apply-values ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_apply_values,a[2]=((C_word)li291),tmp=(C_word)a,a+=3,tmp));
t145=C_mutate((C_word*)lf[403]+1 /* (set! ##sys#copy-closure ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_copy_closure,a[2]=((C_word)li292),tmp=(C_word)a,a+=3,tmp));
t146=C_mutate((C_word*)lf[404]+1 /* (set! ##sys#block-set! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14305,a[2]=((C_word)li293),tmp=(C_word)a,a+=3,tmp));
t147=C_a_i_provide(&a,1,lf[406]);
t148=C_mutate((C_word*)lf[407]+1 /* (set! chicken.time#current-process-milliseconds ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14340,a[2]=((C_word)li294),tmp=(C_word)a,a+=3,tmp));
t149=C_mutate((C_word*)lf[408]+1 /* (set! chicken.time#current-seconds ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14343,a[2]=((C_word)li295),tmp=(C_word)a,a+=3,tmp));
t150=C_mutate((C_word*)lf[409]+1 /* (set! chicken.time#cpu-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14346,a[2]=((C_word)li296),tmp=(C_word)a,a+=3,tmp));
t151=C_mutate((C_word*)lf[410]+1 /* (set! ##sys#check-structure ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14363,a[2]=((C_word)li297),tmp=(C_word)a,a+=3,tmp));
t152=C_mutate((C_word*)lf[411]+1 /* (set! ##sys#check-blob ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14374,a[2]=((C_word)li298),tmp=(C_word)a,a+=3,tmp));
t153=C_mutate((C_word*)lf[412]+1 /* (set! ##sys#check-pair ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14385,a[2]=((C_word)li299),tmp=(C_word)a,a+=3,tmp));
t154=C_mutate((C_word*)lf[413]+1 /* (set! ##sys#check-list ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14396,a[2]=((C_word)li300),tmp=(C_word)a,a+=3,tmp));
t155=C_mutate((C_word*)lf[414]+1 /* (set! ##sys#check-string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14407,a[2]=((C_word)li301),tmp=(C_word)a,a+=3,tmp));
t156=C_mutate((C_word*)lf[415]+1 /* (set! ##sys#check-number ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14418,a[2]=((C_word)li302),tmp=(C_word)a,a+=3,tmp));
t157=C_mutate((C_word*)lf[416]+1 /* (set! ##sys#check-fixnum ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14429,a[2]=((C_word)li303),tmp=(C_word)a,a+=3,tmp));
t158=C_mutate((C_word*)lf[417]+1 /* (set! ##sys#check-bytevector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14440,a[2]=((C_word)li304),tmp=(C_word)a,a+=3,tmp));
t159=C_mutate((C_word*)lf[418]+1 /* (set! ##sys#check-exact ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14451,a[2]=((C_word)li305),tmp=(C_word)a,a+=3,tmp));
t160=C_mutate((C_word*)lf[419]+1 /* (set! ##sys#check-inexact ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14462,a[2]=((C_word)li306),tmp=(C_word)a,a+=3,tmp));
t161=C_mutate((C_word*)lf[420]+1 /* (set! ##sys#check-symbol ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14473,a[2]=((C_word)li307),tmp=(C_word)a,a+=3,tmp));
t162=C_mutate((C_word*)lf[421]+1 /* (set! ##sys#check-keyword ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14484,a[2]=((C_word)li308),tmp=(C_word)a,a+=3,tmp));
t163=C_mutate((C_word*)lf[422]+1 /* (set! ##sys#check-vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14495,a[2]=((C_word)li309),tmp=(C_word)a,a+=3,tmp));
t164=C_mutate((C_word*)lf[423]+1 /* (set! ##sys#check-char ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14506,a[2]=((C_word)li310),tmp=(C_word)a,a+=3,tmp));
t165=C_mutate((C_word*)lf[424]+1 /* (set! ##sys#check-boolean ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14517,a[2]=((C_word)li311),tmp=(C_word)a,a+=3,tmp));
t166=C_mutate((C_word*)lf[425]+1 /* (set! ##sys#check-locative ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14528,a[2]=((C_word)li312),tmp=(C_word)a,a+=3,tmp));
t167=C_mutate((C_word*)lf[426]+1 /* (set! ##sys#check-integer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14539,a[2]=((C_word)li313),tmp=(C_word)a,a+=3,tmp));
t168=C_mutate((C_word*)lf[428]+1 /* (set! ##sys#check-exact-integer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14556,a[2]=((C_word)li314),tmp=(C_word)a,a+=3,tmp));
t169=C_mutate((C_word*)lf[430]+1 /* (set! ##sys#check-exact-uinteger ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14573,a[2]=((C_word)li315),tmp=(C_word)a,a+=3,tmp));
t170=C_mutate((C_word*)lf[432]+1 /* (set! ##sys#check-real ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14597,a[2]=((C_word)li316),tmp=(C_word)a,a+=3,tmp));
t171=C_mutate((C_word*)lf[434]+1 /* (set! ##sys#check-range ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14614,a[2]=((C_word)li317),tmp=(C_word)a,a+=3,tmp));
t172=C_mutate((C_word*)lf[435]+1 /* (set! ##sys#check-range/including ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14625,a[2]=((C_word)li318),tmp=(C_word)a,a+=3,tmp));
t173=C_mutate((C_word*)lf[436]+1 /* (set! ##sys#check-special ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14636,a[2]=((C_word)li319),tmp=(C_word)a,a+=3,tmp));
t174=C_mutate((C_word*)lf[438]+1 /* (set! ##sys#check-closure ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14656,a[2]=((C_word)li320),tmp=(C_word)a,a+=3,tmp));
t175=C_mutate((C_word*)lf[439]+1 /* (set! scheme#force ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14667,a[2]=((C_word)li322),tmp=(C_word)a,a+=3,tmp));
t176=C_mutate((C_word*)lf[441]+1 /* (set! ##sys#dload ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_dload,a[2]=((C_word)li323),tmp=(C_word)a,a+=3,tmp));
t177=C_mutate((C_word*)lf[442]+1 /* (set! ##sys#set-dlopen-flags! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_set_dlopen_flags,a[2]=((C_word)li324),tmp=(C_word)a,a+=3,tmp));
t178=C_mutate((C_word*)lf[51]+1 /* (set! ##sys#error-not-a-proper-list ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14795,a[2]=((C_word)li325),tmp=(C_word)a,a+=3,tmp));
t179=C_mutate((C_word*)lf[444]+1 /* (set! ##sys#error-bad-number ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14811,a[2]=((C_word)li326),tmp=(C_word)a,a+=3,tmp));
t180=C_mutate((C_word*)lf[427]+1 /* (set! ##sys#error-bad-integer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14827,a[2]=((C_word)li327),tmp=(C_word)a,a+=3,tmp));
t181=C_mutate((C_word*)lf[429]+1 /* (set! ##sys#error-bad-exact-integer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14843,a[2]=((C_word)li328),tmp=(C_word)a,a+=3,tmp));
t182=C_mutate((C_word*)lf[431]+1 /* (set! ##sys#error-bad-exact-uinteger ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14859,a[2]=((C_word)li329),tmp=(C_word)a,a+=3,tmp));
t183=C_mutate((C_word*)lf[445]+1 /* (set! ##sys#error-bad-inexact ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14875,a[2]=((C_word)li330),tmp=(C_word)a,a+=3,tmp));
t184=C_mutate((C_word*)lf[433]+1 /* (set! ##sys#error-bad-real ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14891,a[2]=((C_word)li331),tmp=(C_word)a,a+=3,tmp));
t185=C_mutate((C_word*)lf[446]+1 /* (set! ##sys#error-bad-base ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14907,a[2]=((C_word)li332),tmp=(C_word)a,a+=3,tmp));
t186=C_mutate((C_word*)lf[447]+1 /* (set! scheme#append ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14923,a[2]=((C_word)li335),tmp=(C_word)a,a+=3,tmp));
t187=C_mutate((C_word*)lf[449]+1 /* (set! ##sys#fast-reverse ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15002,a[2]=((C_word)li337),tmp=(C_word)a,a+=3,tmp));
t188=C_mutate((C_word*)lf[164]+1 /* (set! ##sys#make-bytevector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15032,a[2]=((C_word)li338),tmp=(C_word)a,a+=3,tmp));
t189=C_mutate((C_word*)lf[450]+1 /* (set! ##sys#make-string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15047,a[2]=((C_word)li339),tmp=(C_word)a,a+=3,tmp));
t190=C_mutate((C_word*)lf[163]+1 /* (set! ##sys#buffer->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15069,a[2]=((C_word)li340),tmp=(C_word)a,a+=3,tmp));
t191=C_mutate((C_word*)lf[451]+1 /* (set! ##sys#utf-decoder ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15080,a[2]=((C_word)li341),tmp=(C_word)a,a+=3,tmp));
t192=C_mutate((C_word*)lf[452]+1 /* (set! ##sys#utf-encoder ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15086,a[2]=((C_word)li342),tmp=(C_word)a,a+=3,tmp));
t193=C_mutate((C_word*)lf[453]+1 /* (set! ##sys#utf-scanner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15092,a[2]=((C_word)li343),tmp=(C_word)a,a+=3,tmp));
t194=C_mutate((C_word*)lf[454]+1 /* (set! ##sys#latin-decoder ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15116,a[2]=((C_word)li344),tmp=(C_word)a,a+=3,tmp));
t195=C_mutate((C_word*)lf[455]+1 /* (set! ##sys#latin-encoder ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15129,a[2]=((C_word)li345),tmp=(C_word)a,a+=3,tmp));
t196=C_mutate((C_word*)lf[456]+1 /* (set! ##sys#latin-scanner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15142,a[2]=((C_word)li346),tmp=(C_word)a,a+=3,tmp));
t197=C_mutate((C_word*)lf[457]+1 /* (set! ##sys#binary-decoder ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15145,a[2]=((C_word)li347),tmp=(C_word)a,a+=3,tmp));
t198=C_mutate((C_word*)lf[458]+1 /* (set! ##sys#binary-encoder ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15151,a[2]=((C_word)li348),tmp=(C_word)a,a+=3,tmp));
t199=C_mutate((C_word*)lf[459]+1 /* (set! ##sys#binary-scanner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15157,a[2]=((C_word)li349),tmp=(C_word)a,a+=3,tmp));
t200=C_mutate((C_word*)lf[460]+1 /* (set! ##sys#encoding-hook ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15160,a[2]=((C_word)li350),tmp=(C_word)a,a+=3,tmp));
t201=C_mutate((C_word*)lf[464]+1 /* (set! ##sys#register-encoding ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15199,a[2]=((C_word)li352),tmp=(C_word)a,a+=3,tmp));
t202=C_mutate((C_word*)lf[465]+1 /* (set! ##sys#buffer->string/encoding ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15229,a[2]=((C_word)li354),tmp=(C_word)a,a+=3,tmp));
t203=C_mutate((C_word*)lf[466]+1 /* (set! ##sys#encode-buffer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15241,a[2]=((C_word)li356),tmp=(C_word)a,a+=3,tmp));
t204=C_mutate((C_word*)lf[467]+1 /* (set! ##sys#decode-buffer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15253,a[2]=((C_word)li358),tmp=(C_word)a,a+=3,tmp));
t205=C_mutate((C_word*)lf[468]+1 /* (set! ##sys#encode-char ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15265,a[2]=((C_word)li361),tmp=(C_word)a,a+=3,tmp));
t206=C_mutate((C_word*)lf[469]+1 /* (set! ##sys#decode-char ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15283,a[2]=((C_word)li363),tmp=(C_word)a,a+=3,tmp));
t207=C_mutate((C_word*)lf[470]+1 /* (set! ##sys#read-char/encoding ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15296,a[2]=((C_word)li366),tmp=(C_word)a,a+=3,tmp));
t208=C_mutate((C_word*)lf[474]+1 /* (set! scheme#make-string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15360,a[2]=((C_word)li367),tmp=(C_word)a,a+=3,tmp));
t209=C_mutate((C_word*)lf[478]+1 /* (set! scheme#string->list ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15391,a[2]=((C_word)li369),tmp=(C_word)a,a+=3,tmp));
t210=C_mutate((C_word*)lf[480]+1 /* (set! ##sys#string->list ...) */,*((C_word*)lf[478]+1));
t211=C_mutate((C_word*)lf[481]+1 /* (set! scheme#list->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15482,a[2]=((C_word)li371),tmp=(C_word)a,a+=3,tmp));
t212=C_mutate((C_word*)lf[483]+1 /* (set! ##sys#list->string ...) */,*((C_word*)lf[481]+1));
t213=C_mutate((C_word*)lf[484]+1 /* (set! ##sys#reverse-list->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15544,a[2]=((C_word)li373),tmp=(C_word)a,a+=3,tmp));
t214=C_mutate((C_word*)lf[486]+1 /* (set! scheme#string-fill! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15595,a[2]=((C_word)li375),tmp=(C_word)a,a+=3,tmp));
t215=C_mutate((C_word*)lf[488]+1 /* (set! scheme#string-copy ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15714,a[2]=((C_word)li376),tmp=(C_word)a,a+=3,tmp));
t216=C_mutate((C_word*)lf[491]+1 /* (set! scheme#string-copy! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15790,a[2]=((C_word)li379),tmp=(C_word)a,a+=3,tmp));
t217=C_mutate((C_word*)lf[490]+1 /* (set! ##sys#substring ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15941,a[2]=((C_word)li380),tmp=(C_word)a,a+=3,tmp));
t218=C_mutate((C_word*)lf[493]+1 /* (set! scheme#substring ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15955,a[2]=((C_word)li381),tmp=(C_word)a,a+=3,tmp));
t219=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16000,a[2]=((C_word)li383),tmp=(C_word)a,a+=3,tmp);
t220=C_mutate((C_word*)lf[495]+1 /* (set! scheme#string<? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16069,a[2]=t219,a[3]=((C_word)li385),tmp=(C_word)a,a+=4,tmp));
t221=C_mutate((C_word*)lf[497]+1 /* (set! scheme#string>? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16093,a[2]=t219,a[3]=((C_word)li387),tmp=(C_word)a,a+=4,tmp));
t222=C_mutate((C_word*)lf[499]+1 /* (set! scheme#string<=? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16117,a[2]=t219,a[3]=((C_word)li389),tmp=(C_word)a,a+=4,tmp));
t223=C_mutate((C_word*)lf[501]+1 /* (set! scheme#string>=? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16138,a[2]=t219,a[3]=((C_word)li391),tmp=(C_word)a,a+=4,tmp));
t224=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16158,a[2]=((C_word)li393),tmp=(C_word)a,a+=3,tmp);
t225=C_mutate((C_word*)lf[503]+1 /* (set! scheme#string-ci<? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16219,a[2]=t224,a[3]=((C_word)li395),tmp=(C_word)a,a+=4,tmp));
t226=C_mutate((C_word*)lf[505]+1 /* (set! scheme#string-ci>? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16243,a[2]=t224,a[3]=((C_word)li397),tmp=(C_word)a,a+=4,tmp));
t227=C_mutate((C_word*)lf[507]+1 /* (set! scheme#string-ci<=? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16267,a[2]=t224,a[3]=((C_word)li399),tmp=(C_word)a,a+=4,tmp));
t228=C_mutate((C_word*)lf[509]+1 /* (set! scheme#string-ci>=? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16288,a[2]=t224,a[3]=((C_word)li401),tmp=(C_word)a,a+=4,tmp));
t229=C_mutate((C_word*)lf[511]+1 /* (set! ##sys#string-append ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16309,a[2]=((C_word)li402),tmp=(C_word)a,a+=3,tmp));
t230=C_mutate((C_word*)lf[512]+1 /* (set! scheme#string-append ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16355,a[2]=((C_word)li404),tmp=(C_word)a,a+=3,tmp));
t231=C_mutate((C_word*)lf[514]+1 /* (set! scheme#string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16413,a[2]=((C_word)li405),tmp=(C_word)a,a+=3,tmp));
t232=C_mutate((C_word*)lf[515]+1 /* (set! ##sys#char->utf8-string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16419,a[2]=((C_word)li406),tmp=(C_word)a,a+=3,tmp));
t233=C_mutate((C_word*)lf[516]+1 /* (set! chicken.base#chop ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16425,a[2]=((C_word)li409),tmp=(C_word)a,a+=3,tmp));
t234=C_a_i_provide(&a,1,lf[519]);
t235=C_mutate((C_word*)lf[520]+1 /* (set! chicken.flonum#maximum-flonum ...) */,C_flonum(&a,DBL_MAX));
t236=C_mutate((C_word*)lf[521]+1 /* (set! chicken.flonum#minimum-flonum ...) */,C_flonum(&a,DBL_MIN));
t237=C_set_block_item(lf[522] /* chicken.flonum#flonum-radix */,0,C_fix((C_word)FLT_RADIX));
t238=C_mutate((C_word*)lf[523]+1 /* (set! chicken.flonum#flonum-epsilon ...) */,C_flonum(&a,DBL_EPSILON));
t239=C_set_block_item(lf[524] /* chicken.flonum#flonum-precision */,0,C_fix((C_word)DBL_MANT_DIG));
t240=C_set_block_item(lf[525] /* chicken.flonum#flonum-decimal-precision */,0,C_fix((C_word)DBL_DIG));
t241=C_set_block_item(lf[526] /* chicken.flonum#flonum-maximum-exponent */,0,C_fix((C_word)DBL_MAX_EXP));
t242=C_set_block_item(lf[527] /* chicken.flonum#flonum-minimum-exponent */,0,C_fix((C_word)DBL_MIN_EXP));
t243=C_set_block_item(lf[528] /* chicken.flonum#flonum-maximum-decimal-exponent */,0,C_fix((C_word)DBL_MAX_10_EXP));
t244=C_set_block_item(lf[529] /* chicken.flonum#flonum-minimum-decimal-exponent */,0,C_fix((C_word)DBL_MIN_10_EXP));
t245=C_mutate((C_word*)lf[530]+1 /* (set! chicken.flonum#fp+ ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16520,a[2]=((C_word)li410),tmp=(C_word)a,a+=3,tmp));
t246=C_mutate((C_word*)lf[532]+1 /* (set! chicken.flonum#fp- ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16544,a[2]=((C_word)li411),tmp=(C_word)a,a+=3,tmp));
t247=C_mutate((C_word*)lf[534]+1 /* (set! chicken.flonum#fp* ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16568,a[2]=((C_word)li412),tmp=(C_word)a,a+=3,tmp));
t248=C_mutate((C_word*)lf[536]+1 /* (set! chicken.flonum#fp/ ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16592,a[2]=((C_word)li413),tmp=(C_word)a,a+=3,tmp));
t249=C_mutate((C_word*)lf[538]+1 /* (set! chicken.flonum#fp*+ ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16616,a[2]=((C_word)li414),tmp=(C_word)a,a+=3,tmp));
t250=C_mutate((C_word*)lf[540]+1 /* (set! chicken.flonum#fpgcd ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16641,a[2]=((C_word)li415),tmp=(C_word)a,a+=3,tmp));
t251=C_mutate((C_word*)lf[542]+1 /* (set! chicken.flonum#fp/? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16665,a[2]=((C_word)li416),tmp=(C_word)a,a+=3,tmp));
t252=C_mutate((C_word*)lf[544]+1 /* (set! chicken.flonum#fp= ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16689,a[2]=((C_word)li417),tmp=(C_word)a,a+=3,tmp));
t253=C_mutate((C_word*)lf[546]+1 /* (set! chicken.flonum#fp> ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16713,a[2]=((C_word)li418),tmp=(C_word)a,a+=3,tmp));
t254=C_mutate((C_word*)lf[548]+1 /* (set! chicken.flonum#fp< ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16737,a[2]=((C_word)li419),tmp=(C_word)a,a+=3,tmp));
t255=C_mutate((C_word*)lf[550]+1 /* (set! chicken.flonum#fp>= ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16761,a[2]=((C_word)li420),tmp=(C_word)a,a+=3,tmp));
t256=C_mutate((C_word*)lf[552]+1 /* (set! chicken.flonum#fp<= ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16785,a[2]=((C_word)li421),tmp=(C_word)a,a+=3,tmp));
t257=C_mutate((C_word*)lf[554]+1 /* (set! chicken.flonum#fpneg ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16809,a[2]=((C_word)li422),tmp=(C_word)a,a+=3,tmp));
t258=C_mutate((C_word*)lf[556]+1 /* (set! chicken.flonum#fpmax ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16827,a[2]=((C_word)li423),tmp=(C_word)a,a+=3,tmp));
t259=C_mutate((C_word*)lf[558]+1 /* (set! chicken.flonum#fpmin ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16851,a[2]=((C_word)li424),tmp=(C_word)a,a+=3,tmp));
t260=C_mutate((C_word*)lf[560]+1 /* (set! chicken.flonum#fpfloor ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16875,a[2]=((C_word)li425),tmp=(C_word)a,a+=3,tmp));
t261=C_mutate((C_word*)lf[562]+1 /* (set! chicken.flonum#fptruncate ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16893,a[2]=((C_word)li426),tmp=(C_word)a,a+=3,tmp));
t262=C_mutate((C_word*)lf[564]+1 /* (set! chicken.flonum#fpround ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16911,a[2]=((C_word)li427),tmp=(C_word)a,a+=3,tmp));
t263=C_mutate((C_word*)lf[566]+1 /* (set! chicken.flonum#fpceiling ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16929,a[2]=((C_word)li428),tmp=(C_word)a,a+=3,tmp));
t264=C_mutate((C_word*)lf[568]+1 /* (set! chicken.flonum#fpsin ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16947,a[2]=((C_word)li429),tmp=(C_word)a,a+=3,tmp));
t265=C_mutate((C_word*)lf[570]+1 /* (set! chicken.flonum#fpcos ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16965,a[2]=((C_word)li430),tmp=(C_word)a,a+=3,tmp));
t266=C_mutate((C_word*)lf[572]+1 /* (set! chicken.flonum#fptan ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16983,a[2]=((C_word)li431),tmp=(C_word)a,a+=3,tmp));
t267=C_mutate((C_word*)lf[574]+1 /* (set! chicken.flonum#fpasin ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17001,a[2]=((C_word)li432),tmp=(C_word)a,a+=3,tmp));
t268=C_mutate((C_word*)lf[576]+1 /* (set! chicken.flonum#fpacos ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17019,a[2]=((C_word)li433),tmp=(C_word)a,a+=3,tmp));
t269=C_mutate((C_word*)lf[578]+1 /* (set! chicken.flonum#fpatan ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17037,a[2]=((C_word)li434),tmp=(C_word)a,a+=3,tmp));
t270=C_mutate((C_word*)lf[580]+1 /* (set! chicken.flonum#fpatan2 ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17055,a[2]=((C_word)li435),tmp=(C_word)a,a+=3,tmp));
t271=C_mutate((C_word*)lf[582]+1 /* (set! chicken.flonum#fpsinh ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17079,a[2]=((C_word)li436),tmp=(C_word)a,a+=3,tmp));
t272=C_mutate((C_word*)lf[584]+1 /* (set! chicken.flonum#fpcosh ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17097,a[2]=((C_word)li437),tmp=(C_word)a,a+=3,tmp));
t273=C_mutate((C_word*)lf[586]+1 /* (set! chicken.flonum#fptanh ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17115,a[2]=((C_word)li438),tmp=(C_word)a,a+=3,tmp));
t274=C_mutate((C_word*)lf[588]+1 /* (set! chicken.flonum#fpasinh ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17133,a[2]=((C_word)li439),tmp=(C_word)a,a+=3,tmp));
t275=C_mutate((C_word*)lf[590]+1 /* (set! chicken.flonum#fpacosh ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17151,a[2]=((C_word)li440),tmp=(C_word)a,a+=3,tmp));
t276=C_mutate((C_word*)lf[592]+1 /* (set! chicken.flonum#fpatanh ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17169,a[2]=((C_word)li441),tmp=(C_word)a,a+=3,tmp));
t277=C_mutate((C_word*)lf[594]+1 /* (set! chicken.flonum#fpexp ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17187,a[2]=((C_word)li442),tmp=(C_word)a,a+=3,tmp));
t278=C_mutate((C_word*)lf[596]+1 /* (set! chicken.flonum#fpexpt ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17205,a[2]=((C_word)li443),tmp=(C_word)a,a+=3,tmp));
t279=C_mutate((C_word*)lf[598]+1 /* (set! chicken.flonum#fplog ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17229,a[2]=((C_word)li444),tmp=(C_word)a,a+=3,tmp));
t280=C_mutate((C_word*)lf[600]+1 /* (set! chicken.flonum#fpsqrt ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17247,a[2]=((C_word)li445),tmp=(C_word)a,a+=3,tmp));
t281=C_mutate((C_word*)lf[602]+1 /* (set! chicken.flonum#fpabs ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17265,a[2]=((C_word)li446),tmp=(C_word)a,a+=3,tmp));
t282=C_mutate((C_word*)lf[604]+1 /* (set! chicken.flonum#fpinteger? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17283,a[2]=((C_word)li447),tmp=(C_word)a,a+=3,tmp));
t283=C_mutate((C_word*)lf[606]+1 /* (set! chicken.flonum#flonum-print-precision ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17301,a[2]=((C_word)li448),tmp=(C_word)a,a+=3,tmp));
t284=C_mutate(&lf[608] /* (set! make-complex ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17319,a[2]=((C_word)li449),tmp=(C_word)a,a+=3,tmp));
t285=C_mutate((C_word*)lf[610]+1 /* (set! scheme#make-rectangular ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17355,a[2]=((C_word)li450),tmp=(C_word)a,a+=3,tmp));
t286=C_mutate((C_word*)lf[612]+1 /* (set! scheme#make-polar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17367,a[2]=((C_word)li451),tmp=(C_word)a,a+=3,tmp));
t287=C_mutate((C_word*)lf[614]+1 /* (set! scheme#real-part ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17390,a[2]=((C_word)li452),tmp=(C_word)a,a+=3,tmp));
t288=C_mutate((C_word*)lf[616]+1 /* (set! scheme#imag-part ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17413,a[2]=((C_word)li453),tmp=(C_word)a,a+=3,tmp));
t289=C_mutate((C_word*)lf[618]+1 /* (set! scheme#angle ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17439,a[2]=((C_word)li454),tmp=(C_word)a,a+=3,tmp));
t290=C_mutate((C_word*)lf[620]+1 /* (set! scheme#magnitude ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17455,a[2]=((C_word)li455),tmp=(C_word)a,a+=3,tmp));
t291=C_mutate(&lf[623] /* (set! ratnum ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17499,a[2]=((C_word)li456),tmp=(C_word)a,a+=3,tmp));
t292=C_mutate((C_word*)lf[624]+1 /* (set! scheme#numerator ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17545,a[2]=((C_word)li457),tmp=(C_word)a,a+=3,tmp));
t293=C_mutate((C_word*)lf[628]+1 /* (set! scheme#denominator ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17590,a[2]=((C_word)li458),tmp=(C_word)a,a+=3,tmp));
t294=C_mutate((C_word*)lf[632]+1 /* (set! ##sys#extended-signum ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17635,a[2]=((C_word)li459),tmp=(C_word)a,a+=3,tmp));
t295=C_mutate((C_word*)lf[626]+1 /* (set! scheme#inexact->exact ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17759,a[2]=((C_word)li462),tmp=(C_word)a,a+=3,tmp));
t296=C_a_i_provide(&a,1,lf[639]);
t297=C_mutate((C_word*)lf[640]+1 /* (set! chicken.bitwise#bitwise-and ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_bitwise_and,a[2]=((C_word)li463),tmp=(C_word)a,a+=3,tmp));
t298=C_mutate((C_word*)lf[641]+1 /* (set! chicken.bitwise#bitwise-ior ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_bitwise_ior,a[2]=((C_word)li464),tmp=(C_word)a,a+=3,tmp));
t299=C_mutate((C_word*)lf[642]+1 /* (set! chicken.bitwise#bitwise-xor ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_bitwise_xor,a[2]=((C_word)li465),tmp=(C_word)a,a+=3,tmp));
t300=C_mutate((C_word*)lf[643]+1 /* (set! chicken.bitwise#bitwise-not ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17823,a[2]=((C_word)li466),tmp=(C_word)a,a+=3,tmp));
t301=C_mutate((C_word*)lf[644]+1 /* (set! chicken.bitwise#bit->boolean ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17826,a[2]=((C_word)li467),tmp=(C_word)a,a+=3,tmp));
t302=C_mutate((C_word*)lf[645]+1 /* (set! chicken.bitwise#integer-length ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17829,a[2]=((C_word)li468),tmp=(C_word)a,a+=3,tmp));
t303=C_mutate((C_word*)lf[646]+1 /* (set! chicken.bitwise#arithmetic-shift ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17832,a[2]=((C_word)li469),tmp=(C_word)a,a+=3,tmp));
t304=C_mutate((C_word*)lf[647]+1 /* (set! scheme#/ ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17835,a[2]=((C_word)li471),tmp=(C_word)a,a+=3,tmp));
t305=C_mutate((C_word*)lf[634]+1 /* (set! ##sys#/-2 ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17886,a[2]=((C_word)li472),tmp=(C_word)a,a+=3,tmp));
t306=C_mutate((C_word*)lf[650]+1 /* (set! scheme#floor ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18167,a[2]=((C_word)li473),tmp=(C_word)a,a+=3,tmp));
t307=C_mutate((C_word*)lf[652]+1 /* (set! scheme#ceiling ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18211,a[2]=((C_word)li474),tmp=(C_word)a,a+=3,tmp));
t308=C_mutate((C_word*)lf[654]+1 /* (set! scheme#truncate ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18255,a[2]=((C_word)li475),tmp=(C_word)a,a+=3,tmp));
t309=C_mutate((C_word*)lf[656]+1 /* (set! scheme#round ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18291,a[2]=((C_word)li476),tmp=(C_word)a,a+=3,tmp));
t310=C_mutate(&lf[658] /* (set! find-ratio-between ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18334,a[2]=((C_word)li478),tmp=(C_word)a,a+=3,tmp));
t311=C_mutate((C_word*)lf[660]+1 /* (set! scheme#rationalize ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18484,a[2]=((C_word)li479),tmp=(C_word)a,a+=3,tmp));
t312=C_mutate((C_word*)lf[661]+1 /* (set! scheme#max ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18509,a[2]=((C_word)li481),tmp=(C_word)a,a+=3,tmp));
t313=C_mutate((C_word*)lf[329]+1 /* (set! scheme#min ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18553,a[2]=((C_word)li483),tmp=(C_word)a,a+=3,tmp));
t314=C_mutate((C_word*)lf[664]+1 /* (set! scheme#exp ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18597,a[2]=((C_word)li484),tmp=(C_word)a,a+=3,tmp));
t315=C_mutate((C_word*)lf[666]+1 /* (set! ##sys#log-1 ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18642,a[2]=((C_word)li485),tmp=(C_word)a,a+=3,tmp));
t316=C_mutate((C_word*)lf[670]+1 /* (set! scheme#log ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18691,a[2]=((C_word)li486),tmp=(C_word)a,a+=3,tmp));
t317=C_mutate((C_word*)lf[671]+1 /* (set! scheme#sin ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18720,a[2]=((C_word)li487),tmp=(C_word)a,a+=3,tmp));
t318=C_mutate((C_word*)lf[675]+1 /* (set! scheme#cos ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18754,a[2]=((C_word)li488),tmp=(C_word)a,a+=3,tmp));
t319=C_mutate((C_word*)lf[677]+1 /* (set! scheme#tan ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18788,a[2]=((C_word)li489),tmp=(C_word)a,a+=3,tmp));
t320=C_mutate((C_word*)lf[679]+1 /* (set! scheme#asin ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18813,a[2]=((C_word)li490),tmp=(C_word)a,a+=3,tmp));
t321=C_a_i_asin(&a,1,C_fix(1));
t322=C_mutate((C_word*)lf[684]+1 /* (set! scheme#acos ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18875,a[2]=t321,a[3]=((C_word)li491),tmp=(C_word)a,a+=4,tmp));
t323=C_mutate((C_word*)lf[686]+1 /* (set! scheme#atan ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18917,a[2]=((C_word)li492),tmp=(C_word)a,a+=3,tmp));
t324=C_mutate((C_word*)lf[688]+1 /* (set! ##sys#exact-integer-sqrt ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18981,a[2]=((C_word)li498),tmp=(C_word)a,a+=3,tmp));
t325=C_mutate((C_word*)lf[690]+1 /* (set! scheme#exact-integer-sqrt ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19172,a[2]=((C_word)li499),tmp=(C_word)a,a+=3,tmp));
t326=C_mutate((C_word*)lf[682]+1 /* (set! ##sys#sqrt/loc ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19181,a[2]=((C_word)li506),tmp=(C_word)a,a+=3,tmp));
t327=C_mutate((C_word*)lf[621]+1 /* (set! scheme#sqrt ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19335,a[2]=((C_word)li507),tmp=(C_word)a,a+=3,tmp));
t328=C_mutate((C_word*)lf[693]+1 /* (set! scheme#truncate/ ...) */,*((C_word*)lf[231]+1));
t329=C_mutate((C_word*)lf[694]+1 /* (set! scheme#floor/ ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19342,a[2]=((C_word)li510),tmp=(C_word)a,a+=3,tmp));
t330=C_mutate((C_word*)lf[695]+1 /* (set! scheme#floor-remainder ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19397,a[2]=((C_word)li513),tmp=(C_word)a,a+=3,tmp));
t331=C_mutate((C_word*)lf[696]+1 /* (set! scheme#floor-quotient ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19412,a[2]=((C_word)li516),tmp=(C_word)a,a+=3,tmp));
t332=C_mutate((C_word*)lf[697]+1 /* (set! scheme#square ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19427,a[2]=((C_word)li517),tmp=(C_word)a,a+=3,tmp));
t333=C_mutate((C_word*)lf[698]+1 /* (set! chicken.base#exact-integer-nth-root ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19433,a[2]=((C_word)li518),tmp=(C_word)a,a+=3,tmp));
t334=C_mutate((C_word*)lf[699]+1 /* (set! ##sys#exact-integer-nth-root/loc ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19445,a[2]=((C_word)li520),tmp=(C_word)a,a+=3,tmp));
t335=C_mutate((C_word*)lf[636]+1 /* (set! ##sys#integer-power ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19571,a[2]=((C_word)li522),tmp=(C_word)a,a+=3,tmp));
t336=C_mutate((C_word*)lf[638]+1 /* (set! scheme#expt ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19639,a[2]=((C_word)li527),tmp=(C_word)a,a+=3,tmp));
t337=C_mutate(&lf[648] /* (set! ##sys#internal-gcd ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19905,a[2]=((C_word)li528),tmp=(C_word)a,a+=3,tmp));
t338=C_mutate((C_word*)lf[703]+1 /* (set! ##sys#gcd ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19972,a[2]=((C_word)li529),tmp=(C_word)a,a+=3,tmp));
t339=C_mutate((C_word*)lf[705]+1 /* (set! scheme#gcd ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19978,a[2]=((C_word)li531),tmp=(C_word)a,a+=3,tmp));
t340=C_mutate((C_word*)lf[706]+1 /* (set! ##sys#lcm ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20029,a[2]=((C_word)li532),tmp=(C_word)a,a+=3,tmp));
t341=C_mutate((C_word*)lf[708]+1 /* (set! scheme#lcm ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20043,a[2]=((C_word)li534),tmp=(C_word)a,a+=3,tmp));
t342=C_mutate((C_word*)lf[709]+1 /* (set! ##sys#integer->string/recursive ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20101,a[2]=((C_word)li538),tmp=(C_word)a,a+=3,tmp));
t343=C_mutate((C_word*)lf[711]+1 /* (set! ##sys#extended-number->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20151,a[2]=((C_word)li539),tmp=(C_word)a,a+=3,tmp));
t344=C_mutate(&lf[717] /* (set! round-quotient ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20325,a[2]=((C_word)li540),tmp=(C_word)a,a+=3,tmp));
t345=C_mutate(&lf[718] /* (set! ##sys#string->compnum ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20368,a[2]=((C_word)li552),tmp=(C_word)a,a+=3,tmp));
t346=C_mutate((C_word*)lf[727]+1 /* (set! scheme#string->number ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_21751,a[2]=((C_word)li554),tmp=(C_word)a,a+=3,tmp));
t347=C_mutate((C_word*)lf[729]+1 /* (set! ##sys#string->number ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22000,a[2]=((C_word)li555),tmp=(C_word)a,a+=3,tmp));
t348=C_mutate((C_word*)lf[730]+1 /* (set! ##sys#fixnum->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_fixnum_to_string,a[2]=((C_word)li556),tmp=(C_word)a,a+=3,tmp));
t349=C_mutate((C_word*)lf[731]+1 /* (set! ##sys#flonum->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_flonum_to_string,a[2]=((C_word)li557),tmp=(C_word)a,a+=3,tmp));
t350=C_mutate((C_word*)lf[732]+1 /* (set! ##sys#integer->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_integer_to_string,a[2]=((C_word)li558),tmp=(C_word)a,a+=3,tmp));
t351=C_mutate((C_word*)lf[710]+1 /* (set! ##sys#number->string ...) */,*((C_word*)lf[112]+1));
t352=C_mutate((C_word*)lf[733]+1 /* (set! chicken.base#equal=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22046,a[2]=((C_word)li562),tmp=(C_word)a,a+=3,tmp));
t353=C_mutate((C_word*)lf[734]+1 /* (set! ##sys#snafu ...) */,lf[735]);
t354=C_mutate((C_word*)lf[736]+1 /* (set! ##sys#intern-symbol ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_string_to_symbol,a[2]=((C_word)li563),tmp=(C_word)a,a+=3,tmp));
t355=C_mutate((C_word*)lf[737]+1 /* (set! ##sys#intern-keyword ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_string_to_keyword,a[2]=((C_word)li564),tmp=(C_word)a,a+=3,tmp));
t356=C_mutate((C_word*)lf[738]+1 /* (set! ##sys#make-symbol ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_make_symbol,a[2]=((C_word)li565),tmp=(C_word)a,a+=3,tmp));
t357=C_mutate((C_word*)lf[739]+1 /* (set! ##sys#interned-symbol? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22233,a[2]=((C_word)li566),tmp=(C_word)a,a+=3,tmp));
t358=C_mutate((C_word*)lf[740]+1 /* (set! ##sys#string->symbol-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22236,a[2]=((C_word)li567),tmp=(C_word)a,a+=3,tmp));
t359=C_mutate((C_word*)lf[741]+1 /* (set! ##sys#symbol->string/shared ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22248,a[2]=((C_word)li568),tmp=(C_word)a,a+=3,tmp));
t360=C_mutate((C_word*)lf[742]+1 /* (set! ##sys#symbol->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22254,a[2]=((C_word)li569),tmp=(C_word)a,a+=3,tmp));
t361=C_mutate((C_word*)lf[743]+1 /* (set! ##sys#string->symbol ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22267,a[2]=((C_word)li570),tmp=(C_word)a,a+=3,tmp));
t362=C_mutate((C_word*)lf[744]+1 /* (set! scheme#symbol->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22277,a[2]=((C_word)li571),tmp=(C_word)a,a+=3,tmp));
t363=C_mutate((C_word*)lf[746]+1 /* (set! scheme#string->symbol ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22286,a[2]=((C_word)li572),tmp=(C_word)a,a+=3,tmp));
t364=C_mutate((C_word*)lf[748]+1 /* (set! chicken.base#string->uninterned-symbol ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22295,a[2]=((C_word)li573),tmp=(C_word)a,a+=3,tmp));
t365=C_fix(-1);
t366=(*a=C_VECTOR_TYPE|1,a[1]=t365,tmp=(C_word)a,a+=2,tmp);
t367=C_mutate((C_word*)lf[750]+1 /* (set! chicken.base#gensym ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_22308,a[2]=t366,a[3]=((C_word)li574),tmp=(C_word)a,a+=4,tmp));
t368=*((C_word*)lf[512]+1);
t369=C_mutate((C_word*)lf[754]+1 /* (set! chicken.base#symbol-append ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_22366,a[2]=t368,a[3]=((C_word)li576),tmp=(C_word)a,a+=4,tmp));
t370=C_a_i_provide(&a,1,lf[756]);
t371=C_mutate((C_word*)lf[757]+1 /* (set! chicken.keyword#keyword? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22425,a[2]=((C_word)li577),tmp=(C_word)a,a+=3,tmp));
t372=C_mutate((C_word*)lf[758]+1 /* (set! chicken.keyword#string->keyword ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22428,a[2]=((C_word)li578),tmp=(C_word)a,a+=3,tmp));
t373=*((C_word*)lf[757]+1);
t374=C_mutate((C_word*)lf[760]+1 /* (set! chicken.keyword#keyword->string ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_22441,a[2]=t373,a[3]=((C_word)li579),tmp=(C_word)a,a+=4,tmp));
t375=C_a_i_list1(&a,1,lf[763]);
t376=C_mutate((C_word*)lf[764]+1 /* (set! chicken.keyword#get-keyword ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_22459,a[2]=t375,a[3]=((C_word)li580),tmp=(C_word)a,a+=4,tmp));
t377=C_mutate((C_word*)lf[766]+1 /* (set! ##sys#get-keyword ...) */,*((C_word*)lf[764]+1));
t378=C_mutate((C_word*)lf[767]+1 /* (set! ##sys#bytevector->list ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22490,a[2]=((C_word)li582),tmp=(C_word)a,a+=3,tmp));
t379=C_mutate((C_word*)lf[768]+1 /* (set! ##sys#list->bytevector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22524,a[2]=((C_word)li584),tmp=(C_word)a,a+=3,tmp));
t380=C_a_i_provide(&a,1,lf[770]);
t381=C_mutate((C_word*)lf[771]+1 /* (set! chicken.bytevector#make-bytevector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22563,a[2]=((C_word)li585),tmp=(C_word)a,a+=3,tmp));
t382=C_mutate((C_word*)lf[773]+1 /* (set! chicken.bytevector#bytevector? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22587,a[2]=((C_word)li586),tmp=(C_word)a,a+=3,tmp));
t383=C_mutate((C_word*)lf[774]+1 /* (set! chicken.bytevector#bytevector-length ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22593,a[2]=((C_word)li587),tmp=(C_word)a,a+=3,tmp));
t384=C_mutate((C_word*)lf[776]+1 /* (set! chicken.bytevector#bytevector-u8-ref ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22602,a[2]=((C_word)li588),tmp=(C_word)a,a+=3,tmp));
t385=C_mutate((C_word*)lf[777]+1 /* (set! chicken.bytevector#bytevector-u8-set! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22605,a[2]=((C_word)li589),tmp=(C_word)a,a+=3,tmp));
t386=C_mutate((C_word*)lf[778]+1 /* (set! chicken.bytevector#string->utf8 ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22608,a[2]=((C_word)li590),tmp=(C_word)a,a+=3,tmp));
t387=C_mutate((C_word*)lf[780]+1 /* (set! chicken.bytevector#utf8->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22624,a[2]=((C_word)li591),tmp=(C_word)a,a+=3,tmp));
t388=C_mutate((C_word*)lf[782]+1 /* (set! chicken.bytevector#string->latin1 ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22664,a[2]=((C_word)li592),tmp=(C_word)a,a+=3,tmp));
t389=C_mutate((C_word*)lf[784]+1 /* (set! chicken.bytevector#latin1->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22683,a[2]=((C_word)li593),tmp=(C_word)a,a+=3,tmp));
t390=C_mutate((C_word*)lf[786]+1 /* (set! chicken.bytevector#bytevector=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22699,a[2]=((C_word)li594),tmp=(C_word)a,a+=3,tmp));
t391=C_mutate((C_word*)lf[788]+1 /* (set! chicken.bytevector#bytevector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22721,a[2]=((C_word)li596),tmp=(C_word)a,a+=3,tmp));
t392=C_mutate((C_word*)lf[790]+1 /* (set! chicken.bytevector#bytevector-copy ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22752,a[2]=((C_word)li597),tmp=(C_word)a,a+=3,tmp));
t393=C_mutate((C_word*)lf[793]+1 /* (set! chicken.bytevector#bytevector-copy! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22833,a[2]=((C_word)li598),tmp=(C_word)a,a+=3,tmp));
t394=C_mutate((C_word*)lf[796]+1 /* (set! chicken.bytevector#bytevector-append ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22915,a[2]=((C_word)li601),tmp=(C_word)a,a+=3,tmp));
t395=C_mutate((C_word*)lf[118]+1 /* (set! scheme#make-vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22973,a[2]=((C_word)li602),tmp=(C_word)a,a+=3,tmp));
t396=C_mutate((C_word*)lf[800]+1 /* (set! ##sys#make-vector ...) */,*((C_word*)lf[118]+1));
t397=C_mutate((C_word*)lf[119]+1 /* (set! scheme#list->vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23002,a[2]=((C_word)li604),tmp=(C_word)a,a+=3,tmp));
t398=C_mutate((C_word*)lf[120]+1 /* (set! scheme#vector->list ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23054,a[2]=((C_word)li606),tmp=(C_word)a,a+=3,tmp));
t399=C_mutate((C_word*)lf[121]+1 /* (set! scheme#vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23140,a[2]=((C_word)li607),tmp=(C_word)a,a+=3,tmp));
t400=C_mutate((C_word*)lf[122]+1 /* (set! scheme#vector-fill! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23146,a[2]=((C_word)li609),tmp=(C_word)a,a+=3,tmp));
t401=C_mutate((C_word*)lf[804]+1 /* (set! scheme#vector-copy ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23227,a[2]=((C_word)li612),tmp=(C_word)a,a+=3,tmp));
t402=C_mutate((C_word*)lf[806]+1 /* (set! scheme#vector-copy! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23334,a[2]=((C_word)li616),tmp=(C_word)a,a+=3,tmp));
t403=C_mutate((C_word*)lf[808]+1 /* (set! scheme#vector-append ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23507,a[2]=((C_word)li621),tmp=(C_word)a,a+=3,tmp));
t404=C_mutate((C_word*)lf[255]+1 /* (set! chicken.base#subvector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23651,a[2]=((C_word)li623),tmp=(C_word)a,a+=3,tmp));
t405=C_mutate((C_word*)lf[256]+1 /* (set! chicken.base#vector-resize ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23714,a[2]=((C_word)li624),tmp=(C_word)a,a+=3,tmp));
t406=C_mutate(&lf[812] /* (set! ##sys#vector-resize ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23735,a[2]=((C_word)li626),tmp=(C_word)a,a+=3,tmp));
t407=C_mutate((C_word*)lf[142]+1 /* (set! scheme#char-ci=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23774,a[2]=((C_word)li628),tmp=(C_word)a,a+=3,tmp));
t408=C_mutate((C_word*)lf[143]+1 /* (set! scheme#char-ci>? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23823,a[2]=((C_word)li630),tmp=(C_word)a,a+=3,tmp));
t409=C_mutate((C_word*)lf[144]+1 /* (set! scheme#char-ci<? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23866,a[2]=((C_word)li632),tmp=(C_word)a,a+=3,tmp));
t410=C_mutate((C_word*)lf[145]+1 /* (set! scheme#char-ci>=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23909,a[2]=((C_word)li634),tmp=(C_word)a,a+=3,tmp));
t411=C_mutate((C_word*)lf[146]+1 /* (set! scheme#char-ci<=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23952,a[2]=((C_word)li636),tmp=(C_word)a,a+=3,tmp));
t412=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23997,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3775: scheme#make-vector */
t413=*((C_word*)lf[118]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t413;
av2[1]=t412;
av2[2]=C_fix(37);
av2[3]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t413+1)))(4,av2);}}

/* chicken.base#fixnum? in k12641 in k11449 */
static void C_ccall f_12645(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12645,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_fixnump(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#flonum? in k12641 in k11449 */
static void C_ccall f_12648(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12648,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_flonump(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#bignum? in k12641 in k11449 */
static void C_ccall f_12651(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12651,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_bignump(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#ratnum? in k12641 in k11449 */
static void C_ccall f_12654(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12654,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_ratnump(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#cplxnum? in k12641 in k11449 */
static void C_ccall f_12657(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12657,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cplxnump(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#quotient&modulo in k12641 in k11449 */
static void C_ccall f_12662(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,4)))){
C_save_and_reclaim((void *)f_12662,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12668,a[2]=t2,a[3]=t3,a[4]=((C_word)li146),tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12674,a[2]=t3,a[3]=((C_word)li147),tmp=(C_word)a,a+=4,tmp);
/* library.scm:852: scheme#call-with-values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t4;
av2[3]=t5;
C_call_with_values(4,av2);}}

/* a12667 in chicken.base#quotient&modulo in k12641 in k11449 */
static void C_ccall f_12668(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_12668,c,av);}
/* library.scm:852: chicken.base#quotient&remainder */
t2=*((C_word*)lf[231]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* a12673 in chicken.base#quotient&modulo in k12641 in k11449 */
static void C_ccall f_12674(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(29,c,3)))){
C_save_and_reclaim((void *)f_12674,c,av);}
a=C_alloc(29);
if(C_truep(C_i_positivep(((C_word*)t0)[2]))){
if(C_truep(C_i_negativep(t3))){
t4=C_s_a_i_plus(&a,2,t3,((C_word*)t0)[2]);
/* library.scm:856: scheme#values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t2;
av2[3]=t4;
C_values(4,av2);}}
else{
/* library.scm:857: scheme#values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
C_values(4,av2);}}}
else{
if(C_truep(C_i_positivep(t3))){
t4=C_s_a_i_plus(&a,2,t3,((C_word*)t0)[2]);
/* library.scm:859: scheme#values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t2;
av2[3]=t4;
C_values(4,av2);}}
else{
/* library.scm:860: scheme#values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
C_values(4,av2);}}}}

/* chicken.base#finite? in k12641 in k11449 */
static void C_ccall f_12709(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12709,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_finitep(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#infinite? in k12641 in k11449 */
static void C_ccall f_12712(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12712,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_infinitep(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#nan? in k12641 in k11449 */
static void C_ccall f_12715(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12715,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_nanp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#add1 in k12641 in k11449 */
static void C_ccall f_12723(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(29,c,1)))){
C_save_and_reclaim((void *)f_12723,c,av);}
a=C_alloc(29);
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_i_plus(&a,2,t2,C_fix(1));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#sub1 in k12641 in k11449 */
static void C_ccall f_12729(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(29,c,1)))){
C_save_and_reclaim((void *)f_12729,c,av);}
a=C_alloc(29);
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_i_minus(&a,2,t2,C_fix(1));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#error in k12641 in k11449 */
static void C_ccall f_12736(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +0,c,4)))){
C_save_and_reclaim((void*)f_12736,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+0);
t2=C_build_rest(&a,c,2,av);
C_word t3;
if(C_truep(C_i_pairp(t2))){{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t1;
av2[2]=*((C_word*)lf[245]+1);
av2[3]=lf[246];
av2[4]=t2;
C_apply(5,av2);}}
else{
/* library.scm:881: ##sys#signal-hook */
t3=*((C_word*)lf[245]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=lf[246];
av2[3]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}}

/* chicken.base#void in k12641 in k11449 */
static void C_ccall f_12751(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12751,c,av);}
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.base#promise? in k12641 in k11449 */
static void C_ccall f_12765(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12765,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_structurep(t2,lf[260]);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#make-promise in k12641 in k11449 */
static void C_ccall f_12771(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_12771,c,av);}
a=C_alloc(3);
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_record2(&a,2,lf[260],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#make-promise in k12641 in k11449 */
static void C_ccall f_12777(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_12777,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12784,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:918: promise? */
t4=*((C_word*)lf[259]+1);{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k12782 in chicken.base#make-promise in k12641 in k11449 */
static void C_ccall f_12784(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_12784,c,av);}
a=C_alloc(4);
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12789,a[2]=((C_word*)t0)[3],a[3]=((C_word)li159),tmp=(C_word)a,a+=4,tmp);
/* library.scm:919: ##sys#make-promise */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[261]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[261]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t2;
tp(3,av2);}}}

/* a12788 in k12782 in chicken.base#make-promise in k12641 in k11449 */
static void C_ccall f_12789(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12789,c,av);}
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.base#foldl in k12641 in k11449 */
static void C_ccall f_12792(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_12792,c,av);}
a=C_alloc(7);
t5=C_i_check_list_2(t4,lf[264]);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12801,a[2]=t7,a[3]=t2,a[4]=((C_word)li161),tmp=(C_word)a,a+=5,tmp));
t9=((C_word*)t7)[1];
f_12801(t9,t1,t4,t3);}

/* loop in chicken.base#foldl in k12641 in k11449 */
static void f_12801(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_12801,4,t0,t1,t2,t3);}
a=C_alloc(5);
t4=C_i_pairp(t2);
if(C_truep(C_i_not(t4))){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t5=C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12819,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
/* library.scm:928: f */
t7=((C_word*)t0)[3];{
C_word av2[4];
av2[0]=t7;
av2[1]=t6;
av2[2]=t3;
av2[3]=C_slot(t2,C_fix(0));
((C_proc)C_fast_retrieve_proc(t7))(4,av2);}}}

/* k12817 in loop in chicken.base#foldl in k12641 in k11449 */
static void C_ccall f_12819(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_12819,c,av);}
/* library.scm:928: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_12801(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* chicken.base#foldr in k12641 in k11449 */
static void C_ccall f_12829(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_12829,c,av);}
a=C_alloc(8);
t5=C_i_check_list_2(t4,lf[266]);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_12838,a[2]=t3,a[3]=t2,a[4]=t7,a[5]=((C_word)li163),tmp=(C_word)a,a+=6,tmp));
t9=((C_word*)t7)[1];
f_12838(t9,t1,t4);}

/* loop in chicken.base#foldr in k12641 in k11449 */
static void f_12838(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_12838,3,t0,t1,t2);}
a=C_alloc(5);
t3=C_i_pairp(t2);
if(C_truep(C_i_not(t3))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_slot(t2,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12856,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* library.scm:935: loop */
t7=t5;
t8=C_slot(t2,C_fix(1));
t1=t7;
t2=t8;
goto loop;}}

/* k12854 in loop in chicken.base#foldr in k12641 in k11449 */
static void C_ccall f_12856(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_12856,c,av);}
/* library.scm:935: f */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=t1;
((C_proc)C_fast_retrieve_proc(t2))(4,av2);}}

/* chicken.base#on-exit in k12641 in k11449 */
static void C_ccall f_12869(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_12869,c,av);}
a=C_alloc(3);
t3=C_a_i_cons(&a,2,t2,*((C_word*)lf[269]+1));
t4=C_mutate((C_word*)lf[269]+1 /* (set! chicken.base#cleanup-tasks ...) */,t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* chicken.base#exit in k12641 in k11449 */
static void C_ccall f_12876(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_12876,c,av);}
a=C_alloc(4);
if(C_truep(C_rest_nullp(c,2))){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f45147,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:948: chicken.base#exit-handler */
t3=*((C_word*)lf[268]+1);{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=C_get_rest_arg(c,2,av,2,t0);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12883,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:948: chicken.base#exit-handler */
t4=*((C_word*)lf[268]+1);{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k12881 in chicken.base#exit in k12641 in k11449 */
static void C_ccall f_12883(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_12883,c,av);}
/* library.scm:947: g916 */
t2=t1;{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* chicken.base#emergency-exit in k12641 in k11449 */
static void C_ccall f_12894(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12894,c,av);}
if(C_truep(C_rest_nullp(c,2))){
t2=C_i_check_fixnum_2(C_fix(0),lf[273]);
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_exit_runtime(C_fix(0));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=C_get_rest_arg(c,2,av,2,t0);
t3=C_i_check_fixnum_2(t2,lf[273]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_exit_runtime(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* chicken.base#identity in k12641 in k11449 */
static void C_ccall f_12913(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12913,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#conjoin in k12641 in k11449 */
static void C_ccall f_12916(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,3)))){
C_save_and_reclaim((void*)f_12916,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12918,a[2]=t2,a[3]=((C_word)li170),tmp=(C_word)a,a+=4,tmp);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* f_12918 in chicken.base#conjoin in k12641 in k11449 */
static void C_ccall f_12918(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,3)))){
C_save_and_reclaim((void *)f_12918,c,av);}
a=C_alloc(7);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12924,a[2]=t4,a[3]=t2,a[4]=((C_word)li169),tmp=(C_word)a,a+=5,tmp));
t6=((C_word*)t4)[1];
f_12924(t6,t1,((C_word*)t0)[2]);}

/* loop */
static void f_12924(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_12924,3,t0,t1,t2);}
a=C_alloc(5);
t3=C_i_nullp(t2);
if(C_truep(t3)){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_slot(t2,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12940,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:969: g945 */
t6=t4;{
C_word av2[3];
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[3];
((C_proc)C_fast_retrieve_proc(t6))(3,av2);}}}

/* k12938 in loop */
static void C_ccall f_12940(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_12940,c,av);}
if(C_truep(t1)){
/* library.scm:970: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_12924(t2,((C_word*)t0)[3],C_slot(((C_word*)t0)[4],C_fix(1)));}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* chicken.base#disjoin in k12641 in k11449 */
static void C_ccall f_12949(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,3)))){
C_save_and_reclaim((void*)f_12949,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12951,a[2]=t2,a[3]=((C_word)li173),tmp=(C_word)a,a+=4,tmp);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* f_12951 in chicken.base#disjoin in k12641 in k11449 */
static void C_ccall f_12951(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,3)))){
C_save_and_reclaim((void *)f_12951,c,av);}
a=C_alloc(7);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12957,a[2]=t4,a[3]=t2,a[4]=((C_word)li172),tmp=(C_word)a,a+=5,tmp));
t6=((C_word*)t4)[1];
f_12957(t6,t1,((C_word*)t0)[2]);}

/* loop */
static void f_12957(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_12957,3,t0,t1,t2);}
a=C_alloc(5);
t3=C_i_nullp(t2);
if(C_truep(C_i_not(t3))){
t4=C_slot(t2,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12970,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:976: g957 */
t6=t4;{
C_word av2[3];
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[3];
((C_proc)C_fast_retrieve_proc(t6))(3,av2);}}
else{
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k12968 in loop */
static void C_ccall f_12970(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_12970,c,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* library.scm:977: loop */
t2=((C_word*)((C_word*)t0)[3])[1];
f_12957(t2,((C_word*)t0)[2],C_slot(((C_word*)t0)[4],C_fix(1)));}}

/* chicken.base#constantly in k12641 in k11449 */
static void C_ccall f_12986(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_12986,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
t3=C_eqp(C_fix(1),C_u_i_length(t2));
if(C_truep(t3)){
t4=C_i_car(t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12997,a[2]=t4,a[3]=((C_word)li175),tmp=(C_word)a,a+=4,tmp);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12999,a[2]=t2,a[3]=((C_word)li176),tmp=(C_word)a,a+=4,tmp);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* f_12997 in chicken.base#constantly in k12641 in k11449 */
static void C_ccall f_12997(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12997,c,av);}
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* f_12999 in chicken.base#constantly in k12641 in k11449 */
static void C_ccall f_12999(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_12999,c,av);}{
C_word av2[4];
av2[0]=0;
av2[1]=t1;
av2[2]=*((C_word*)lf[171]+1);
av2[3]=((C_word*)t0)[2];
C_apply(4,av2);}}

/* chicken.base#flip in k12641 in k11449 */
static void C_ccall f_13007(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,4)))){
C_save_and_reclaim((void *)f_13007,c,av);}
a=C_alloc(4);
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13009,a[2]=t2,a[3]=((C_word)li178),tmp=(C_word)a,a+=4,tmp);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* f_13009 in chicken.base#flip in k12641 in k11449 */
static void C_ccall f_13009(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13009,c,av);}
/* library.scm:985: proc */
t4=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t1;
av2[2]=t3;
av2[3]=t2;
((C_proc)C_fast_retrieve_proc(t4))(4,av2);}}

/* chicken.base#complement in k12641 in k11449 */
static void C_ccall f_13015(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_13015,c,av);}
a=C_alloc(4);
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13017,a[2]=t2,a[3]=((C_word)li180),tmp=(C_word)a,a+=4,tmp);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* f_13017 in chicken.base#complement in k12641 in k11449 */
static void C_ccall f_13017(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +3,c,3)))){
C_save_and_reclaim((void*)f_13017,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+3);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13025,a[2]=t1,tmp=(C_word)a,a+=3,tmp);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
av2[3]=t2;
C_apply(4,av2);}}

/* k13023 */
static void C_ccall f_13025(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13025,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_i_not(t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.base#compose in k12641 in k11449 */
static void C_ccall f_13027(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +6,c,3)))){
C_save_and_reclaim((void*)f_13027,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+6);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13030,a[2]=t4,a[3]=((C_word)li184),tmp=(C_word)a,a+=4,tmp));
if(C_truep(C_rest_nullp(c,2))){
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=*((C_word*)lf[171]+1);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=((C_word*)t4)[1];
av2[3]=t2;
C_apply(4,av2);}}}

/* rec in chicken.base#compose in k12641 in k11449 */
static void C_ccall f_13030(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +6,c,2)))){
C_save_and_reclaim((void*)f_13030,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+6);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
if(C_truep(C_i_nullp(t3))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13038,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=t2,a[5]=((C_word)li183),tmp=(C_word)a,a+=6,tmp);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* f_13038 in rec in chicken.base#compose in k12641 in k11449 */
static void C_ccall f_13038(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +6,c,3)))){
C_save_and_reclaim((void*)f_13038,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+6);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13044,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word)li182),tmp=(C_word)a,a+=6,tmp);
/* library.scm:996: scheme#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t3;
av2[3]=((C_word*)t0)[4];
C_call_with_values(4,av2);}}

/* a13043 */
static void C_ccall f_13044(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_13044,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13052,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t2;
av2[2]=((C_word*)((C_word*)t0)[3])[1];
av2[3]=((C_word*)t0)[4];
C_apply(4,av2);}}

/* k13050 in a13043 */
static void C_ccall f_13052(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13052,c,av);}{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=((C_word*)t0)[3];
C_apply(4,av2);}}

/* chicken.base#o in k12641 in k11449 */
static void C_ccall f_13063(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +6,c,3)))){
C_save_and_reclaim((void*)f_13063,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+6);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
if(C_truep(C_rest_nullp(c,2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=*((C_word*)lf[278]+1);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13075,a[2]=t4,a[3]=((C_word)li187),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_13075(t6,t1,t2);}}

/* loop in chicken.base#o in k12641 in k11449 */
static void f_13075(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_13075,3,t0,t1,t2);}
a=C_alloc(6);
t3=C_slot(t2,C_fix(0));
t4=C_slot(t2,C_fix(1));
if(C_truep(C_i_nullp(t4))){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13089,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=t4,a[5]=((C_word)li186),tmp=(C_word)a,a+=6,tmp);
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* f_13089 in loop in chicken.base#o in k12641 in k11449 */
static void C_ccall f_13089(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_13089,c,av);}
a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13097,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1011: loop */
t4=((C_word*)((C_word*)t0)[3])[1];
f_13075(t4,t3,((C_word*)t0)[4]);}

/* k13095 */
static void C_ccall f_13097(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_13097,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13100,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:1011: g986 */
t3=t1;{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
((C_proc)C_fast_retrieve_proc(t3))(3,av2);}}

/* k13098 in k13095 */
static void C_ccall f_13100(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_13100,c,av);}
/* library.scm:1011: h */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
((C_proc)C_fast_retrieve_proc(t2))(3,av2);}}

/* chicken.base#list-of? in k12641 in k11449 */
static void C_ccall f_13102(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_13102,c,av);}
a=C_alloc(4);
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13104,a[2]=t2,a[3]=((C_word)li190),tmp=(C_word)a,a+=4,tmp);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* f_13104 in chicken.base#list-of? in k12641 in k11449 */
static void C_ccall f_13104(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,3)))){
C_save_and_reclaim((void *)f_13104,c,av);}
a=C_alloc(7);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13110,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=((C_word)li189),tmp=(C_word)a,a+=5,tmp));
t6=((C_word*)t4)[1];
f_13110(t6,t1,t2);}

/* loop */
static void f_13110(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_13110,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_nullp(t2))){
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_i_pairp(t2);
if(C_truep(C_i_not(t3))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13129,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1018: pred */
t5=((C_word*)t0)[3];{
C_word av2[3];
av2[0]=t5;
av2[1]=t4;
av2[2]=C_slot(t2,C_fix(0));
((C_proc)C_fast_retrieve_proc(t5))(3,av2);}}}}

/* k13127 in loop */
static void C_ccall f_13129(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_13129,c,av);}
if(C_truep(t1)){
/* library.scm:1018: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_13110(t2,((C_word*)t0)[3],C_slot(((C_word*)t0)[4],C_fix(1)));}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* chicken.base#each in k12641 in k11449 */
static void C_ccall f_13146(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_13146,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
if(C_truep(C_i_nullp(t2))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13154,a[2]=((C_word)li192),tmp=(C_word)a,a+=3,tmp);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_slot(t2,C_fix(1));
t4=C_i_nullp(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=(C_truep(t4)?C_slot(t2,C_fix(0)):(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13168,a[2]=t2,a[3]=((C_word)li194),tmp=(C_word)a,a+=4,tmp));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* f_13154 in chicken.base#each in k12641 in k11449 */
static void C_ccall f_13154(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13154,c,av);}
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=*((C_word*)lf[288]+1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* f_13168 in chicken.base#each in k12641 in k11449 */
static void C_ccall f_13168(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +7,c,3)))){
C_save_and_reclaim((void*)f_13168,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+7);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13174,a[2]=t2,a[3]=t4,a[4]=((C_word)li193),tmp=(C_word)a,a+=5,tmp));
t6=((C_word*)t4)[1];
f_13174(t6,t1,((C_word*)t0)[2]);}

/* loop */
static void f_13174(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_13174,3,t0,t1,t2);}
a=C_alloc(5);
t3=C_slot(t2,C_fix(0));
t4=C_slot(t2,C_fix(1));
if(C_truep(C_i_nullp(t4))){{
C_word av2[4];
av2[0]=0;
av2[1]=t1;
av2[2]=t3;
av2[3]=((C_word*)t0)[2];
C_apply(4,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13193,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t4,tmp=(C_word)a,a+=5,tmp);{
C_word av2[4];
av2[0]=0;
av2[1]=t5;
av2[2]=t3;
av2[3]=((C_word*)t0)[2];
C_apply(4,av2);}}}

/* k13191 in loop */
static void C_ccall f_13193(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_13193,c,av);}
/* library.scm:1033: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_13174(t2,((C_word*)t0)[3],((C_word*)t0)[4]);}

/* chicken.base#bwp-object? in k12641 in k11449 */
static void C_ccall f_13202(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13202,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_bwpp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#weak-cons in k12641 in k11449 */
static void C_ccall f_13205(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_13205,c,av);}
a=C_alloc(3);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_weak_cons(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.base#weak-pair? in k12641 in k11449 */
static void C_ccall f_13208(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13208,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_weak_pairp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#atom? in k12641 in k11449 */
static void C_ccall f_13211(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13211,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_not_pair_p(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#tail? in k12641 in k11449 */
static void C_ccall f_13214(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_13214,c,av);}
a=C_alloc(4);
t4=C_i_check_list_2(t3,lf[294]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13223,a[2]=t2,a[3]=((C_word)li200),tmp=(C_word)a,a+=4,tmp);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(
  f_13223(t5,t3)
);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* loop in chicken.base#tail? in k12641 in k11449 */
static C_word f_13223(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_stack_overflow_check;
loop:{}
if(C_truep(C_eqp(((C_word*)t0)[2],t1))){
return(C_SCHEME_TRUE);}
else{
t2=(C_truep(C_blockp(t1))?C_pairp(t1):C_SCHEME_FALSE);
if(C_truep(t2)){
t4=C_slot(t1,C_fix(1));
t1=t4;
goto loop;}
else{
return(C_SCHEME_FALSE);}}}

/* chicken.base#intersperse in k12641 in k11449 */
static void C_ccall f_13242(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,3)))){
C_save_and_reclaim((void *)f_13242,c,av);}
a=C_alloc(7);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13248,a[2]=t3,a[3]=t5,a[4]=((C_word)li202),tmp=(C_word)a,a+=5,tmp));
t7=((C_word*)t5)[1];
f_13248(t7,t1,t2);}

/* loop in chicken.base#intersperse in k12641 in k11449 */
static void f_13248(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_13248,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_eqp(t2,C_SCHEME_END_OF_LIST))){
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_i_cdr(t2);
if(C_truep(C_eqp(t3,C_SCHEME_END_OF_LIST))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_slot(t2,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13273,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1062: loop */
t7=t5;
t8=t3;
t1=t7;
t2=t8;
goto loop;}}}

/* k13271 in loop in chicken.base#intersperse in k12641 in k11449 */
static void C_ccall f_13273(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,1)))){
C_save_and_reclaim((void *)f_13273,c,av);}
a=C_alloc(6);
t2=C_a_i_cons(&a,2,((C_word*)t0)[2],t1);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[4],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#butlast in k12641 in k11449 */
static void C_ccall f_13275(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_13275,c,av);}
a=C_alloc(6);
t3=C_i_check_pair_2(t2,lf[297]);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13284,a[2]=t5,a[3]=((C_word)li204),tmp=(C_word)a,a+=4,tmp));
t7=((C_word*)t5)[1];
f_13284(t7,t1,t2);}

/* loop in chicken.base#butlast in k12641 in k11449 */
static void f_13284(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_13284,3,t0,t1,t2);}
a=C_alloc(4);
t3=C_slot(t2,C_fix(1));
t4=(C_truep(C_blockp(t3))?C_pairp(t3):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=C_slot(t2,C_fix(0));
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13305,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1069: loop */
t8=t6;
t9=t3;
t1=t8;
t2=t9;
goto loop;}
else{
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k13303 in loop in chicken.base#butlast in k12641 in k11449 */
static void C_ccall f_13305(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_13305,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.base#flatten in k12641 in k11449 */
static void C_ccall f_13307(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +6,c,4)))){
C_save_and_reclaim((void*)f_13307,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+6);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13313,a[2]=t4,a[3]=((C_word)li206),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_13313(t6,t1,t2,C_SCHEME_END_OF_LIST);}

/* loop in chicken.base#flatten in k12641 in k11449 */
static void f_13313(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_13313,4,t0,t1,t2,t3);}
a=C_alloc(5);
if(C_truep(C_i_nullp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_slot(t2,C_fix(0));
t5=C_slot(t2,C_fix(1));
if(C_truep(C_i_listp(t4))){
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13339,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1079: loop */
t8=t6;
t9=t5;
t10=t3;
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13346,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1080: loop */
t8=t6;
t9=t5;
t10=t3;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}}

/* k13337 in loop in chicken.base#flatten in k12641 in k11449 */
static void C_ccall f_13339(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13339,c,av);}
/* library.scm:1079: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_13313(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k13344 in loop in chicken.base#flatten in k12641 in k11449 */
static void C_ccall f_13346(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_13346,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.base#join in k12641 in k11449 */
static void C_ccall f_13348(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +7,c,3)))){
C_save_and_reclaim((void*)f_13348,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+7);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
t4=C_i_pairp(t3);
t5=(C_truep(t4)?C_get_rest_arg(c,3,av,3,t0):C_SCHEME_END_OF_LIST);
t6=C_i_check_list_2(t5,lf[300]);
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13360,a[2]=t5,a[3]=t8,a[4]=((C_word)li208),tmp=(C_word)a,a+=5,tmp));
t10=((C_word*)t8)[1];
f_13360(t10,t1,t2);}

/* loop in chicken.base#join in k12641 in k11449 */
static void f_13360(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_13360,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_nullp(t2))){
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_i_pairp(t2);
if(C_truep(C_i_not(t3))){
/* library.scm:1090: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[51]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[51]+1);
av2[1]=t1;
av2[2]=t2;
tp(3,av2);}}
else{
t4=C_slot(t2,C_fix(0));
t5=C_slot(t2,C_fix(1));
if(C_truep(C_i_nullp(t5))){
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13395,a[2]=t1,a[3]=t4,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* library.scm:1096: loop */
t8=t6;
t9=t5;
t1=t8;
t2=t9;
goto loop;}}}}

/* k13393 in loop in chicken.base#join in k12641 in k11449 */
static void C_ccall f_13395(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_13395,c,av);}
/* library.scm:1096: ##sys#append */
t2=*((C_word*)lf[301]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
av2[4]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* chicken.base#compress in k12641 in k11449 */
static void C_ccall f_13405(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_13405,c,av);}
a=C_alloc(7);
t4=lf[303];
t5=C_i_check_list_2(t3,lf[304]);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13414,a[2]=t4,a[3]=t7,a[4]=((C_word)li210),tmp=(C_word)a,a+=5,tmp));
t9=((C_word*)t7)[1];
f_13414(t9,t1,t2,t3);}

/* loop in chicken.base#compress in k12641 in k11449 */
static void f_13414(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(4,0,5)))){
C_save_and_reclaim_args((void *)trf_13414,4,t0,t1,t2,t3);}
a=C_alloc(4);
if(C_truep(C_i_nullp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_i_pairp(t2);
if(C_truep(C_i_not(t4))){
/* library.scm:1105: ##sys#signal-hook */
t5=*((C_word*)lf[245]+1);{
C_word av2[6];
av2[0]=t5;
av2[1]=t1;
av2[2]=lf[305];
av2[3]=lf[304];
av2[4]=((C_word*)t0)[2];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(6,av2);}}
else{
t5=C_i_pairp(t3);
if(C_truep(C_i_not(t5))){
/* library.scm:1107: ##sys#signal-hook */
t6=*((C_word*)lf[245]+1);{
C_word av2[6];
av2[0]=t6;
av2[1]=t1;
av2[2]=lf[305];
av2[3]=lf[304];
av2[4]=((C_word*)t0)[2];
av2[5]=t3;
((C_proc)(void*)(*((C_word*)t6+1)))(6,av2);}}
else{
if(C_truep(C_slot(t2,C_fix(0)))){
t6=C_slot(t3,C_fix(0));
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13456,a[2]=t1,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1109: loop */
t9=t7;
t10=C_slot(t2,C_fix(1));
t11=C_slot(t3,C_fix(1));
t1=t9;
t2=t10;
t3=t11;
goto loop;}
else{
/* library.scm:1110: loop */
t9=t1;
t10=C_slot(t2,C_fix(1));
t11=C_slot(t3,C_fix(1));
t1=t9;
t2=t10;
t3=t11;
goto loop;}}}}}

/* k13454 in loop in chicken.base#compress in k12641 in k11449 */
static void C_ccall f_13456(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_13456,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.base#alist-update! in k12641 in k11449 */
static void C_ccall f_13485(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(10,c,4)))){
C_save_and_reclaim((void *)f_13485,c,av);}
a=C_alloc(10);
t5=C_rest_nullp(c,5);
t6=(C_truep(t5)?*((C_word*)lf[5]+1):C_get_rest_arg(c,5,av,5,t0));
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13492,a[2]=t3,a[3]=t1,a[4]=t4,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t8=C_eqp(*((C_word*)lf[4]+1),t6);
if(C_truep(t8)){
t9=t7;
f_13492(t9,*((C_word*)lf[56]+1));}
else{
t9=C_eqp(*((C_word*)lf[5]+1),t6);
if(C_truep(t9)){
t10=t7;
f_13492(t10,*((C_word*)lf[57]+1));}
else{
t10=C_eqp(*((C_word*)lf[6]+1),t6);
t11=t7;
f_13492(t11,(C_truep(t10)?*((C_word*)lf[58]+1):(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13524,a[2]=t6,a[3]=((C_word)li213),tmp=(C_word)a,a+=4,tmp)));}}}

/* k13490 in chicken.base#alist-update! in k12641 in k11449 */
static void f_13492(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,0,3)))){
C_save_and_reclaim_args((void *)trf_13492,2,t0,t1);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13495,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* library.scm:1127: aq */
t3=t1;{
C_word av2[4];
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[5];
av2[3]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k13493 in k13490 in chicken.base#alist-update! in k12641 in k11449 */
static void C_ccall f_13495(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,1)))){
C_save_and_reclaim((void *)f_13495,c,av);}
a=C_alloc(6);
t2=((C_word*)t0)[2];
if(C_truep(t1)){
t3=C_i_setslot(t1,C_fix(1),((C_word*)t2)[2]);
t4=((C_word*)t2)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=((C_word*)t2)[4];
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_a_i_cons(&a,2,((C_word*)t2)[5],((C_word*)t2)[2]);
t4=((C_word*)t2)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_cons(&a,2,t3,((C_word*)t2)[4]);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* f_13524 in chicken.base#alist-update! in k12641 in k11449 */
static void C_ccall f_13524(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_13524,c,av);}
a=C_alloc(8);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13530,a[2]=t5,a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=((C_word)li212),tmp=(C_word)a,a+=6,tmp));
t7=((C_word*)t5)[1];
f_13530(t7,t1,t3);}

/* loop */
static void f_13530(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_13530,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_pairp(t2))){
t3=C_slot(t2,C_fix(0));
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13546,a[2]=t1,a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_i_pairp(t3))){
/* library.scm:1124: cmp */
t5=((C_word*)t0)[3];{
C_word av2[4];
av2[0]=t5;
av2[1]=t4;
av2[2]=((C_word*)t0)[4];
av2[3]=C_slot(t3,C_fix(0));
((C_proc)C_fast_retrieve_proc(t5))(4,av2);}}
else{
/* library.scm:1126: loop */
t6=t1;
t7=C_slot(t2,C_fix(1));
t1=t6;
t2=t7;
goto loop;}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k13544 in loop */
static void C_ccall f_13546(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_13546,c,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* library.scm:1126: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_13530(t2,((C_word*)t0)[2],C_slot(((C_word*)t0)[5],C_fix(1)));}}

/* chicken.base#alist-update in k12641 in k11449 */
static void C_ccall f_13571(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_13571,c,av);}
a=C_alloc(9);
t5=C_rest_nullp(c,5);
t6=(C_truep(t5)?*((C_word*)lf[5]+1):C_get_rest_arg(c,5,av,5,t0));
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_13580,a[2]=t2,a[3]=t3,a[4]=t8,a[5]=t6,a[6]=((C_word)li215),tmp=(C_word)a,a+=7,tmp));
t10=((C_word*)t8)[1];
f_13580(t10,t1,t4);}

/* loop in chicken.base#alist-update in k12641 in k11449 */
static void f_13580(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,4)))){
C_save_and_reclaim_args((void *)trf_13580,3,t0,t1,t2);}
a=C_alloc(8);
if(C_truep(C_i_nullp(t2))){
t3=C_a_i_cons(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_a_i_list1(&a,1,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_i_pairp(t2);
if(C_truep(C_i_not(t3))){
/* library.scm:1139: chicken.base#error */
t4=*((C_word*)lf[244]+1);{
C_word av2[5];
av2[0]=t4;
av2[1]=t1;
av2[2]=lf[308];
av2[3]=lf[309];
av2[4]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}
else{
t4=C_slot(t2,C_fix(0));
t5=C_i_pairp(t4);
if(C_truep(C_i_not(t5))){
/* library.scm:1143: chicken.base#error */
t6=*((C_word*)lf[244]+1);{
C_word av2[5];
av2[0]=t6;
av2[1]=t1;
av2[2]=lf[308];
av2[3]=lf[310];
av2[4]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}
else{
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_13621,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=t1,a[6]=t4,a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp);
/* library.scm:1144: cmp */
t7=((C_word*)t0)[5];{
C_word av2[4];
av2[0]=t7;
av2[1]=t6;
av2[2]=((C_word*)t0)[2];
av2[3]=C_slot(t4,C_fix(0));
((C_proc)C_fast_retrieve_proc(t7))(4,av2);}}}}}

/* k13619 in loop in chicken.base#alist-update in k12641 in k11449 */
static void C_ccall f_13621(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_13621,c,av);}
a=C_alloc(7);
if(C_truep(t1)){
t2=C_a_i_cons(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=C_slot(((C_word*)t0)[4],C_fix(1));
t4=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_cons(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t2=C_slot(((C_word*)t0)[6],C_fix(0));
t3=C_slot(((C_word*)t0)[6],C_fix(1));
t4=C_a_i_cons(&a,2,t2,t3);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13643,a[2]=((C_word*)t0)[5],a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1148: loop */
t6=((C_word*)((C_word*)t0)[7])[1];
f_13580(t6,t5,C_slot(((C_word*)t0)[4],C_fix(1)));}}

/* k13641 in k13619 in loop in chicken.base#alist-update in k12641 in k11449 */
static void C_ccall f_13643(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_13643,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.base#alist-ref in k12641 in k11449 */
static void C_ccall f_13675(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(10,c,4)))){
C_save_and_reclaim((void *)f_13675,c,av);}
a=C_alloc(10);
t4=C_rest_nullp(c,4);
t5=(C_truep(t4)?*((C_word*)lf[5]+1):C_get_rest_arg(c,4,av,4,t0));
t6=C_rest_nullp(c,4);
t7=C_rest_nullp(c,5);
t8=(C_truep(t7)?C_SCHEME_FALSE:C_get_rest_arg(c,5,av,4,t0));
t9=C_rest_nullp(c,5);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13691,a[2]=t1,a[3]=t8,a[4]=t2,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t11=C_eqp(*((C_word*)lf[4]+1),t5);
if(C_truep(t11)){
t12=t10;
f_13691(t12,*((C_word*)lf[56]+1));}
else{
t12=C_eqp(*((C_word*)lf[5]+1),t5);
if(C_truep(t12)){
t13=t10;
f_13691(t13,*((C_word*)lf[57]+1));}
else{
t13=C_eqp(*((C_word*)lf[6]+1),t5);
t14=t10;
f_13691(t14,(C_truep(t13)?*((C_word*)lf[58]+1):(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13716,a[2]=t5,a[3]=((C_word)li218),tmp=(C_word)a,a+=4,tmp)));}}}

/* k13689 in chicken.base#alist-ref in k12641 in k11449 */
static void f_13691(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,3)))){
C_save_and_reclaim_args((void *)trf_13691,2,t0,t1);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13694,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:1166: aq */
t3=t1;{
C_word av2[4];
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k13692 in k13689 in chicken.base#alist-ref in k12641 in k11449 */
static void C_ccall f_13694(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13694,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=(C_truep(t1)?C_slot(t1,C_fix(1)):((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* f_13716 in chicken.base#alist-ref in k12641 in k11449 */
static void C_ccall f_13716(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_13716,c,av);}
a=C_alloc(8);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13722,a[2]=t5,a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=((C_word)li217),tmp=(C_word)a,a+=6,tmp));
t7=((C_word*)t5)[1];
f_13722(t7,t1,t3);}

/* loop */
static void f_13722(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,4)))){
C_save_and_reclaim_args((void *)trf_13722,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_nullp(t2))){
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t2))){
t3=C_slot(t2,C_fix(0));
t4=C_i_check_pair_2(t3,lf[312]);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13747,a[2]=t1,a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* library.scm:1162: cmp */
t6=((C_word*)t0)[3];{
C_word av2[4];
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[4];
av2[3]=C_slot(t3,C_fix(0));
((C_proc)C_fast_retrieve_proc(t6))(4,av2);}}
else{
/* library.scm:1165: chicken.base#error */
t3=*((C_word*)lf[244]+1);{
C_word av2[5];
av2[0]=t3;
av2[1]=t1;
av2[2]=lf[312];
av2[3]=lf[313];
av2[4]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}}}

/* k13745 in loop */
static void C_ccall f_13747(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_13747,c,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* library.scm:1164: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_13722(t2,((C_word*)t0)[2],C_slot(((C_word*)t0)[5],C_fix(1)));}}

/* chicken.base#rassoc in k12641 in k11449 */
static void C_ccall f_13787(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +8,c,3)))){
C_save_and_reclaim((void*)f_13787,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+8);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t5=C_i_check_list_2(t3,lf[315]);
t6=C_i_pairp(t4);
t7=(C_truep(t6)?C_get_rest_arg(c,4,av,4,t0):*((C_word*)lf[5]+1));
t8=C_SCHEME_UNDEFINED;
t9=(*a=C_VECTOR_TYPE|1,a[1]=t8,tmp=(C_word)a,a+=2,tmp);
t10=C_set_block_item(t9,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13799,a[2]=t9,a[3]=t7,a[4]=t2,a[5]=((C_word)li220),tmp=(C_word)a,a+=6,tmp));
t11=((C_word*)t9)[1];
f_13799(t11,t1,t3);}

/* loop in chicken.base#rassoc in k12641 in k11449 */
static void f_13799(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_13799,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_pairp(t2))){
t3=C_slot(t2,C_fix(0));
t4=C_i_check_pair_2(t3,lf[315]);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13818,a[2]=t1,a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* library.scm:1179: tst */
t6=((C_word*)t0)[3];{
C_word av2[4];
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[4];
av2[3]=C_slot(t3,C_fix(1));
((C_proc)C_fast_retrieve_proc(t6))(4,av2);}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k13816 in loop in chicken.base#rassoc in k12641 in k11449 */
static void C_ccall f_13818(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_13818,c,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* library.scm:1181: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_13799(t2,((C_word*)t0)[2],C_slot(((C_word*)t0)[5],C_fix(1)));}}

/* scheme#open-input-string in k12641 in k11449 */
static void C_ccall f_13835(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,5)))){
C_save_and_reclaim((void *)f_13835,c,av);}
a=C_alloc(4);
t3=C_i_check_string_2(t2,lf[317]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13842,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1192: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[318]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[318]+1);
av2[1]=t4;
av2[2]=C_fix(1);
av2[3]=C_fast_retrieve(lf[319]);
av2[4]=lf[320];
av2[5]=lf[321];
tp(6,av2);}}

/* k13840 in scheme#open-input-string in k12641 in k11449 */
static void C_ccall f_13842(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_13842,c,av);}
a=C_alloc(6);
t2=C_slot(((C_word*)t0)[2],C_fix(0));
t3=C_block_size(t2);
t4=C_fixnum_difference(t3,C_fix(1));
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13852,a[2]=t2,a[3]=t4,a[4]=t1,a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
/* library.scm:1195: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[164]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[164]+1);
av2[1]=t5;
av2[2]=t4;
tp(3,av2);}}

/* k13850 in k13840 in scheme#open-input-string in k12641 in k11449 */
static void C_ccall f_13852(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13852,c,av);}
t2=C_copy_memory(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=C_i_set_i_slot(((C_word*)t0)[4],C_fix(10),C_fix(0));
t4=C_i_set_i_slot(((C_word*)t0)[4],C_fix(11),((C_word*)t0)[3]);
t5=C_i_setslot(((C_word*)t0)[4],C_fix(12),t1);
t6=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t6;
av2[1]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* scheme#open-output-string in k12641 in k11449 */
static void C_ccall f_13863(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,5)))){
C_save_and_reclaim((void *)f_13863,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13867,a[2]=C_SCHEME_UNDEFINED,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1204: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[318]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[318]+1);
av2[1]=t2;
av2[2]=C_fix(2);
av2[3]=C_fast_retrieve(lf[319]);
av2[4]=lf[323];
av2[5]=lf[321];
tp(6,av2);}}

/* k13865 in scheme#open-output-string in k12641 in k11449 */
static void C_ccall f_13867(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_13867,c,av);}
a=C_alloc(3);
t2=C_mutate(((C_word *)t0)+2,t1);
t3=C_i_set_i_slot(((C_word*)t0)[2],C_fix(10),C_fix(0));
t4=C_i_set_i_slot(((C_word*)t0)[2],C_fix(11),C_fix(256));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13880,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* library.scm:1207: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[164]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[164]+1);
av2[1]=t5;
av2[2]=C_fix(256);
tp(3,av2);}}

/* k13878 in k13865 in scheme#open-output-string in k12641 in k11449 */
static void C_ccall f_13880(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13880,c,av);}
t2=((C_word*)t0)[2];
t3=C_i_setslot(((C_word*)t2)[2],C_fix(12),t1);
t4=((C_word*)t2)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=((C_word*)t2)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#get-output-string in k12641 in k11449 */
static void C_ccall f_13882(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_13882,c,av);}
t3=C_i_check_port_2(t2,C_fix(2),C_SCHEME_FALSE,lf[325]);
t4=C_slot(t2,C_fix(7));
t5=C_eqp(lf[321],t4);
if(C_truep(C_i_not(t5))){
/* library.scm:1214: ##sys#signal-hook */
t6=*((C_word*)lf[245]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t6;
av2[1]=t1;
av2[2]=lf[305];
av2[3]=lf[325];
av2[4]=lf[326];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t6+1)))(6,av2);}}
else{
/* library.scm:1216: ##sys#buffer->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[163]+1));
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[163]+1);
av2[1]=t1;
av2[2]=C_slot(t2,C_fix(12));
av2[3]=C_fix(0);
av2[4]=C_slot(t2,C_fix(10));
tp(5,av2);}}}

/* scheme#open-input-bytevector in k12641 in k11449 */
static void C_ccall f_13916(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,5)))){
C_save_and_reclaim((void *)f_13916,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13920,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1220: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[318]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[318]+1);
av2[1]=t3;
av2[2]=C_fix(1);
av2[3]=C_SCHEME_FALSE;
av2[4]=lf[330];
av2[5]=lf[331];
tp(6,av2);}}

/* k13918 in scheme#open-input-bytevector in k12641 in k11449 */
static void C_ccall f_13920(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(40,c,6)))){
C_save_and_reclaim((void *)f_13920,c,av);}
a=C_alloc(40);
t2=C_i_check_bytevector_2(((C_word*)t0)[2],lf[328]);
t3=C_i_setslot(t1,C_fix(14),lf[178]);
t4=C_fix(0);
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_block_size(((C_word*)t0)[2]);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13938,a[2]=t5,a[3]=t6,a[4]=((C_word*)t0)[2],a[5]=((C_word)li225),tmp=(C_word)a,a+=6,tmp);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13951,a[2]=t5,a[3]=t6,a[4]=((C_word*)t0)[2],a[5]=((C_word)li226),tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13960,a[2]=t1,a[3]=((C_word)li227),tmp=(C_word)a,a+=4,tmp);
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13966,a[2]=t5,a[3]=t6,a[4]=((C_word)li228),tmp=(C_word)a,a+=5,tmp);
t11=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13976,a[2]=((C_word*)t0)[2],a[3]=t5,a[4]=t6,a[5]=((C_word)li229),tmp=(C_word)a,a+=6,tmp);
t12=C_a_i_vector(&a,10,t7,t8,C_SCHEME_FALSE,C_SCHEME_FALSE,t9,C_SCHEME_FALSE,t10,t11,C_SCHEME_FALSE,C_SCHEME_FALSE);
t13=C_i_setslot(t1,C_fix(2),t12);
t14=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t14;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t14+1)))(2,av2);}}

/* a13937 in k13918 in scheme#open-input-bytevector in k12641 in k11449 */
static void C_ccall f_13938(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13938,c,av);}
t3=C_eqp(((C_word*)((C_word*)t0)[2])[1],((C_word*)t0)[3]);
if(C_truep(t3)){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_END_OF_FILE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_i_bytevector_ref(((C_word*)t0)[4],((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1)));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_make_character(C_unfix(t4));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* a13950 in k13918 in scheme#open-input-bytevector in k12641 in k11449 */
static void C_ccall f_13951(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13951,c,av);}
t3=C_eqp(((C_word*)((C_word*)t0)[2])[1],((C_word*)t0)[3]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=(C_truep(t3)?C_SCHEME_END_OF_FILE:C_i_bytevector_ref(((C_word*)t0)[4],((C_word*)((C_word*)t0)[2])[1]));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* a13959 in k13918 in scheme#open-input-bytevector in k12641 in k11449 */
static void C_ccall f_13960(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13960,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_set_i_slot(((C_word*)t0)[2],C_fix(8),C_SCHEME_TRUE);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* a13965 in k13918 in scheme#open-input-bytevector in k12641 in k11449 */
static void C_ccall f_13966(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13966,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_not(C_eqp(((C_word*)((C_word*)t0)[2])[1],((C_word*)t0)[3]));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* a13975 in k13918 in scheme#open-input-bytevector in k12641 in k11449 */
static void C_ccall f_13976(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,3)))){
C_save_and_reclaim((void *)f_13976,c,av);}
a=C_alloc(7);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_13980,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t5,a[5]=((C_word*)t0)[3],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* library.scm:1246: scheme#min */
t7=*((C_word*)lf[329]+1);{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
av2[2]=t3;
av2[3]=C_fixnum_difference(((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k13978 in a13975 in k13918 in scheme#open-input-bytevector in k12641 in k11449 */
static void C_ccall f_13980(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13980,c,av);}
t2=C_copy_memory_with_offset(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)((C_word*)t0)[5])[1],t1);
t3=C_mutate(((C_word *)((C_word*)t0)[5])+1,C_fixnum_plus(((C_word*)((C_word*)t0)[5])[1],t1));
t4=((C_word*)t0)[6];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#open-output-bytevector in k12641 in k11449 */
static void C_ccall f_13984(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,5)))){
C_save_and_reclaim((void *)f_13984,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13988,a[2]=C_SCHEME_UNDEFINED,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1256: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[318]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[318]+1);
av2[1]=t2;
av2[2]=C_fix(2);
av2[3]=C_SCHEME_FALSE;
av2[4]=lf[333];
av2[5]=lf[331];
tp(6,av2);}}

/* k13986 in scheme#open-output-bytevector in k12641 in k11449 */
static void C_ccall f_13988(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_13988,c,av);}
a=C_alloc(3);
t2=C_mutate(((C_word *)t0)+2,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13991,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* library.scm:1257: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[164]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[164]+1);
av2[1]=t3;
av2[2]=C_fix(256);
tp(3,av2);}}

/* k13989 in k13986 in scheme#open-output-bytevector in k12641 in k11449 */
static void C_ccall f_13991(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(42,c,6)))){
C_save_and_reclaim((void *)f_13991,c,av);}
a=C_alloc(42);
t2=((C_word*)t0)[2];
t3=t1;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_fix(0);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_fix(256);
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_SCHEME_UNDEFINED;
t10=(*a=C_VECTOR_TYPE|1,a[1]=t9,tmp=(C_word)a,a+=2,tmp);
t11=C_SCHEME_UNDEFINED;
t12=C_set_block_item(t10,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13993,a[2]=t6,a[3]=t4,a[4]=t8,a[5]=((C_word)li231),tmp=(C_word)a,a+=6,tmp));
t13=t11=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14005,a[2]=t4,a[3]=t6,a[4]=((C_word)li232),tmp=(C_word)a,a+=5,tmp);
t14=C_i_setslot(((C_word*)t2)[2],C_fix(9),t11);
t15=C_i_setslot(((C_word*)t2)[2],C_fix(14),lf[178]);
t16=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14024,a[2]=t10,a[3]=((C_word)li233),tmp=(C_word)a,a+=4,tmp);
t17=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14041,a[2]=t10,a[3]=((C_word)li234),tmp=(C_word)a,a+=4,tmp);
t18=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14047,a[2]=((C_word*)t2)[2],a[3]=((C_word)li235),tmp=(C_word)a,a+=4,tmp);
t19=C_a_i_vector(&a,10,C_SCHEME_FALSE,C_SCHEME_FALSE,t16,t17,t18,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE);
t20=C_i_setslot(((C_word*)t2)[2],C_fix(2),t19);
t21=((C_word*)t2)[3];{
C_word *av2=av;
av2[0]=t21;
av2[1]=((C_word*)t2)[2];
((C_proc)(void*)(*((C_word*)t21+1)))(2,av2);}}

/* add in k13989 in k13986 in scheme#open-output-bytevector in k12641 in k11449 */
static void f_13993(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(16,0,2)))){
C_save_and_reclaim_args((void *)trf_13993,5,t0,t1,t2,t3,t4);}
a=C_alloc(16);
t5=C_fixnum_difference(t4,t3);
t6=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],t5);
t7=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_13997,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=((C_word*)t0)[2],a[5]=t3,a[6]=t5,a[7]=t6,a[8]=t1,tmp=(C_word)a,a+=9,tmp);
if(C_truep(C_fixnum_greaterp(t6,((C_word*)((C_word*)t0)[4])[1]))){
t8=C_fixnum_times(((C_word*)((C_word*)t0)[4])[1],C_fix(2));
t9=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_14001,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[4],a[5]=t8,a[6]=t7,tmp=(C_word)a,a+=7,tmp);
/* library.scm:1265: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[164]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[164]+1);
av2[1]=t9;
av2[2]=t8;
tp(3,av2);}}
else{
t8=t7;
f_13997(t8,C_SCHEME_UNDEFINED);}}

/* k13995 in add in k13989 in k13986 in scheme#open-output-bytevector in k12641 in k11449 */
static void f_13997(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,1)))){
C_save_and_reclaim_args((void *)trf_13997,2,t0,t1);}
t2=C_copy_memory_with_offset(((C_word*)((C_word*)t0)[2])[1],((C_word*)t0)[3],((C_word*)((C_word*)t0)[4])[1],((C_word*)t0)[5],((C_word*)t0)[6]);
t3=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)t0)[7]);
t4=((C_word*)t0)[8];{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k13999 in add in k13989 in k13986 in scheme#open-output-bytevector in k12641 in k11449 */
static void C_ccall f_14001(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14001,c,av);}
t2=C_copy_memory_with_offset(t1,((C_word*)((C_word*)t0)[2])[1],C_fix(0),C_fix(0),((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)t0)[5]);
t4=C_mutate(((C_word *)((C_word*)t0)[2])+1,t1);
t5=((C_word*)t0)[6];
f_13997(t5,t4);}

/* getter in k13989 in k13986 in scheme#open-output-bytevector in k12641 in k11449 */
static void C_ccall f_14005(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_14005,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14009,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1272: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[164]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[164]+1);
av2[1]=t2;
av2[2]=((C_word*)((C_word*)t0)[3])[1];
tp(3,av2);}}

/* k14007 in getter in k13989 in k13986 in scheme#open-output-bytevector in k12641 in k11449 */
static void C_ccall f_14009(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14009,c,av);}
t2=C_copy_memory_with_offset(t1,((C_word*)((C_word*)t0)[2])[1],C_fix(0),C_fix(0),((C_word*)((C_word*)t0)[3])[1]);
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* a14023 in k13989 in k13986 in scheme#open-output-bytevector in k12641 in k11449 */
static void C_ccall f_14024(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_14024,c,av);}
a=C_alloc(8);
t4=C_a_i_string(&a,1,t3);
t5=C_slot(t4,C_fix(0));
t6=C_block_size(t5);
/* library.scm:1285: add */
t7=((C_word*)((C_word*)t0)[2])[1];
f_13993(t7,t1,t5,C_fix(0),C_fixnum_difference(t6,C_fix(1)));}

/* a14040 in k13989 in k13986 in scheme#open-output-bytevector in k12641 in k11449 */
static void C_ccall f_14041(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_14041,c,av);}
/* library.scm:1287: add */
t6=((C_word*)((C_word*)t0)[2])[1];
f_13993(t6,t1,t3,t4,t5);}

/* a14046 in k13989 in k13986 in scheme#open-output-bytevector in k12641 in k11449 */
static void C_ccall f_14047(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14047,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_set_i_slot(((C_word*)t0)[2],C_fix(8),C_SCHEME_TRUE);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#get-output-bytevector in k12641 in k11449 */
static void C_ccall f_14053(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_14053,c,av);}
a=C_alloc(9);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14056,a[2]=t2,a[3]=((C_word)li237),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14063,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1300: ##sys#check-port */
t5=*((C_word*)lf[337]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[335];
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* fail in scheme#get-output-bytevector in k12641 in k11449 */
static void f_14056(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,4)))){
C_save_and_reclaim_args((void *)trf_14056,2,t0,t1);}
/* library.scm:1299: chicken.base#error */
t2=*((C_word*)lf[244]+1);{
C_word av2[5];
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[335];
av2[3]=lf[336];
av2[4]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* k14061 in scheme#get-output-bytevector in k12641 in k11449 */
static void C_ccall f_14063(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14063,c,av);}
t2=C_slot(((C_word*)t0)[2],C_fix(7));
t3=C_eqp(t2,lf[331]);
if(C_truep(t3)){
t4=C_slot(((C_word*)t0)[2],C_fix(9));
if(C_truep(C_i_closurep(t4))){
/* library.scm:1304: getter */
t5=t4;{
C_word *av2=av;
av2[0]=t5;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
/* library.scm:1305: fail */
t5=((C_word*)t0)[4];
f_14056(t5,((C_word*)t0)[3]);}}
else{
/* library.scm:1306: fail */
t4=((C_word*)t0)[4];
f_14056(t4,((C_word*)t0)[3]);}}

/* chicken.fixnum#fx+ in k12641 in k11449 */
static void C_ccall f_14100(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14100,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_plus(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx- in k12641 in k11449 */
static void C_ccall f_14103(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14103,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_difference(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx* in k12641 in k11449 */
static void C_ccall f_14106(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14106,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_times(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx= in k12641 in k11449 */
static void C_ccall f_14109(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14109,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_eqp(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx> in k12641 in k11449 */
static void C_ccall f_14115(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14115,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_greaterp(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx< in k12641 in k11449 */
static void C_ccall f_14118(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14118,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_lessp(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx>= in k12641 in k11449 */
static void C_ccall f_14121(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14121,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_greater_or_equal_p(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx<= in k12641 in k11449 */
static void C_ccall f_14124(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14124,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_less_or_equal_p(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxmin in k12641 in k11449 */
static void C_ccall f_14127(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14127,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_fixnum_min(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxmax in k12641 in k11449 */
static void C_ccall f_14130(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14130,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_fixnum_max(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxneg in k12641 in k11449 */
static void C_ccall f_14133(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14133,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_fixnum_negate(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.fixnum#fxand in k12641 in k11449 */
static void C_ccall f_14136(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14136,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_and(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxior in k12641 in k11449 */
static void C_ccall f_14139(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14139,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_or(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxxor in k12641 in k11449 */
static void C_ccall f_14142(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14142,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_xor(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxnot in k12641 in k11449 */
static void C_ccall f_14145(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14145,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_fixnum_not(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.fixnum#fxshl in k12641 in k11449 */
static void C_ccall f_14148(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14148,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_shift_left(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxshr in k12641 in k11449 */
static void C_ccall f_14151(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14151,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_shift_right(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxodd? in k12641 in k11449 */
static void C_ccall f_14154(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14154,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_fixnumoddp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.fixnum#fxeven? in k12641 in k11449 */
static void C_ccall f_14157(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14157,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_fixnumevenp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.fixnum#fxlen in k12641 in k11449 */
static void C_ccall f_14160(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14160,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_fixnum_length(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.fixnum#fx/ in k12641 in k11449 */
static void C_ccall f_14163(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14163,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_divide(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxgcd in k12641 in k11449 */
static void C_ccall f_14166(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14166,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_fixnum_gcd(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxmod in k12641 in k11449 */
static void C_ccall f_14169(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14169,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_modulo(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxrem in k12641 in k11449 */
static void C_ccall f_14172(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14172,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_fixnum_remainder_checked(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx+? in k12641 in k11449 */
static void C_ccall f_14175(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14175,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_o_fixnum_plus(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx-? in k12641 in k11449 */
static void C_ccall f_14178(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14178,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_o_fixnum_difference(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx*? in k12641 in k11449 */
static void C_ccall f_14181(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14181,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_o_fixnum_times(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx/? in k12641 in k11449 */
static void C_ccall f_14184(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14184,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_o_fixnum_quotient(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#debug-mode? in k12641 in k11449 */
static void C_ccall f_14187(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14187,c,av);}
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_i_debug_modep();
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.base#warning in k12641 in k11449 */
static void C_ccall f_14192(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,5)))){
C_save_and_reclaim((void*)f_14192,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
if(C_truep(*((C_word*)lf[373]+1))){{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=0;
av2[1]=t1;
av2[2]=*((C_word*)lf[245]+1);
av2[3]=lf[376];
av2[4]=t2;
av2[5]=t3;
C_apply(6,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* chicken.base#notice in k12641 in k11449 */
static void C_ccall f_14201(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,5)))){
C_save_and_reclaim((void*)f_14201,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
t4=(C_truep(*((C_word*)lf[374]+1))?*((C_word*)lf[373]+1):C_SCHEME_FALSE);
if(C_truep(t4)){{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=0;
av2[1]=t1;
av2[2]=*((C_word*)lf[245]+1);
av2[3]=lf[378];
av2[4]=t2;
av2[5]=t3;
C_apply(6,av2);}}
else{
t5=C_SCHEME_UNDEFINED;
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* chicken.base#enable-warnings in k12641 in k11449 */
static void C_ccall f_14213(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14213,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+0);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
if(C_truep(C_i_pairp(t2))){
t3=C_mutate((C_word*)lf[373]+1 /* (set! ##sys#warnings-enabled ...) */,C_get_rest_arg(c,2,av,2,t0));
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=*((C_word*)lf[373]+1);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=*((C_word*)lf[373]+1);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* ##sys#error/errno in k12641 in k11449 */
static void C_ccall f_14227(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,6)))){
C_save_and_reclaim((void*)f_14227,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
if(C_truep(C_i_pairp(t3))){{
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_fast_retrieve(lf[383]);
av2[3]=lf[246];
av2[4]=t2;
av2[5]=C_SCHEME_FALSE;
av2[6]=t3;
C_apply(7,av2);}}
else{
/* library.scm:1391: ##sys#signal-hook/errno */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[383]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[383]+1);
av2[1]=t1;
av2[2]=lf[246];
av2[3]=t2;
av2[4]=C_SCHEME_FALSE;
tp(5,av2);}}}

/* ##sys#setslot in k12641 in k11449 */
static void C_ccall f_14243(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14243,c,av);}
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_i_setslot(t2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#setislot in k12641 in k11449 */
static void C_ccall f_14246(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14246,c,av);}
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_i_set_i_slot(t2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#start-timer in k12641 in k11449 */
static void C_ccall f_14255(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_14255,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14259,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:1406: ##sys#gc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[384]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[384]+1);
av2[1]=t2;
av2[2]=C_SCHEME_TRUE;
tp(3,av2);}}

/* k14257 in ##sys#start-timer in k12641 in k11449 */
static void C_ccall f_14259(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14259,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_start_timer();
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* ##sys#stop-timer in k12641 in k11449 */
static void C_ccall f_14261(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_14261,c,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_stop_timer,a[2]=((C_word)li282),tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14265,a[2]=C_SCHEME_UNDEFINED,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1410: g1529 */
t4=t2;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)C_fast_retrieve_proc(t4))(2,av2);}}

/* k14263 in ##sys#stop-timer in k12641 in k11449 */
static void C_ccall f_14265(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_14265,c,av);}
a=C_alloc(3);
t2=C_mutate(((C_word *)t0)+2,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14268,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* library.scm:1413: ##sys#gc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[384]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[384]+1);
av2[1]=t3;
av2[2]=C_SCHEME_TRUE;
tp(3,av2);}}

/* k14266 in k14263 in ##sys#stop-timer in k12641 in k11449 */
static void C_ccall f_14268(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_14268,c,av);}
a=C_alloc(6);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_stop_timer,a[2]=((C_word)li283),tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14279,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* library.scm:1414: g1531 */
t5=t3;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)C_fast_retrieve_proc(t5))(2,av2);}}

/* k14277 in k14266 in k14263 in ##sys#stop-timer in k12641 in k11449 */
static void C_ccall f_14279(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14279,c,av);}
t2=((C_word*)t0)[2];
t3=C_slot(t1,C_fix(6));
t4=C_i_setslot(((C_word*)t2)[2],C_fix(6),t3);
t5=((C_word*)t2)[3];{
C_word *av2=av;
av2[0]=t5;
av2[1]=((C_word*)t2)[2];
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#immediate? in k12641 in k11449 */
static void C_ccall f_14281(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14281,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_not(C_blockp(t2));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#message in k12641 in k11449 */
static void C_ccall f_14288(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14288,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_message(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#byte in k12641 in k11449 */
static void C_ccall f_14291(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14291,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_subbyte(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#halt in k12641 in k11449 */
static void C_ccall f_14296(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14296,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_halt(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#block-ref in k12641 in k11449 */
static void C_ccall f_14300(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14300,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_block_ref(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#block-set! in k12641 in k11449 */
static void C_ccall f_14305(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_14305,c,av);}
a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_14309,a[2]=t2,a[3]=t3,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=C_i_not(C_blockp(t2));
if(C_truep(t6)){
if(C_truep(t6)){
/* library.scm:1432: ##sys#signal-hook */
t7=*((C_word*)lf[245]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t7;
av2[1]=t5;
av2[2]=lf[305];
av2[3]=lf[404];
av2[4]=lf[405];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t7+1)))(6,av2);}}
else{
t7=t5;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_SCHEME_UNDEFINED;
f_14309(2,av2);}}}
else{
t7=(C_truep(C_specialp(t2))?C_eqp(t3,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t7)){
if(C_truep(t7)){
/* library.scm:1432: ##sys#signal-hook */
t8=*((C_word*)lf[245]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t8;
av2[1]=t5;
av2[2]=lf[305];
av2[3]=lf[404];
av2[4]=lf[405];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t8+1)))(6,av2);}}
else{
t8=t5;{
C_word *av2=av;
av2[0]=t8;
av2[1]=C_SCHEME_UNDEFINED;
f_14309(2,av2);}}}
else{
if(C_truep(C_byteblockp(t2))){
/* library.scm:1432: ##sys#signal-hook */
t8=*((C_word*)lf[245]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t8;
av2[1]=t5;
av2[2]=lf[305];
av2[3]=lf[404];
av2[4]=lf[405];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t8+1)))(6,av2);}}
else{
t8=t5;{
C_word *av2=av;
av2[0]=t8;
av2[1]=C_SCHEME_UNDEFINED;
f_14309(2,av2);}}}}}

/* k14307 in ##sys#block-set! in k12641 in k11449 */
static void C_ccall f_14309(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14309,c,av);}
t2=C_block_size(((C_word*)t0)[2]);
t3=C_i_check_range_2(((C_word*)t0)[3],C_fix(0),t2,lf[404]);
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_setslot(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[5]);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.time#current-process-milliseconds in k12641 in k11449 */
static void C_ccall f_14340(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,1)))){
C_save_and_reclaim((void *)f_14340,c,av);}
a=C_alloc(7);
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_current_process_milliseconds(&a,1,C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.time#current-seconds in k12641 in k11449 */
static void C_ccall f_14343(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,1)))){
C_save_and_reclaim((void *)f_14343,c,av);}
a=C_alloc(7);
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_get_current_seconds(&a,1,C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.time#cpu-time in k12641 in k11449 */
static void C_ccall f_14346(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(11,c,3)))){
C_save_and_reclaim((void *)f_14346,c,av);}
a=C_alloc(11);
t2=C_a_i_vector2(&a,2,C_SCHEME_FALSE,C_SCHEME_FALSE);
t3=C_a_i_cpu_time(&a,1,t2);
/* library.scm:1461: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_slot(t2,C_fix(0));
av2[3]=C_slot(t2,C_fix(1));
C_values(4,av2);}}

/* ##sys#check-structure in k12641 in k11449 */
static void C_ccall f_14363(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14363,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+0);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=C_i_pairp(t4);
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=(C_truep(t5)?C_i_check_structure_2(t2,t3,C_get_rest_arg(c,4,av,4,t0)):C_i_check_structure(t2,t3));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* ##sys#check-blob in k12641 in k11449 */
static void C_ccall f_14374(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14374,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_bytevector_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_bytevector(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-pair in k12641 in k11449 */
static void C_ccall f_14385(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14385,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_pair_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_pair(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-list in k12641 in k11449 */
static void C_ccall f_14396(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14396,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_list_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_list(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-string in k12641 in k11449 */
static void C_ccall f_14407(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14407,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_string_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_string(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-number in k12641 in k11449 */
static void C_ccall f_14418(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14418,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_number_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_number(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-fixnum in k12641 in k11449 */
static void C_ccall f_14429(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14429,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_fixnum_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_fixnum(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-bytevector in k12641 in k11449 */
static void C_ccall f_14440(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14440,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_bytevector_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_bytevector(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-exact in k12641 in k11449 */
static void C_ccall f_14451(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14451,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_exact_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_exact(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-inexact in k12641 in k11449 */
static void C_ccall f_14462(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14462,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_inexact_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_inexact(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-symbol in k12641 in k11449 */
static void C_ccall f_14473(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14473,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_symbol_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_symbol(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-keyword in k12641 in k11449 */
static void C_ccall f_14484(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14484,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_keyword_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_keyword(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-vector in k12641 in k11449 */
static void C_ccall f_14495(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14495,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_vector_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_vector(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-char in k12641 in k11449 */
static void C_ccall f_14506(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14506,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_char_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_char(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-boolean in k12641 in k11449 */
static void C_ccall f_14517(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14517,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_boolean_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_boolean(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-locative in k12641 in k11449 */
static void C_ccall f_14528(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14528,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_locative_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_locative(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-integer in k12641 in k11449 */
static void C_ccall f_14539(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,3)))){
C_save_and_reclaim((void*)f_14539,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
if(C_truep(C_i_integerp(t2))){
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t3))){
/* library.scm:1550: ##sys#error-bad-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[427]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[427]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_get_rest_arg(c,3,av,3,t0);
tp(4,av2);}}
else{
/* library.scm:1550: ##sys#error-bad-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[427]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[427]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}}}

/* ##sys#check-exact-integer in k12641 in k11449 */
static void C_ccall f_14556(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,3)))){
C_save_and_reclaim((void*)f_14556,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
if(C_truep(C_i_exact_integerp(t2))){
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t3))){
/* library.scm:1554: ##sys#error-bad-exact-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[429]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[429]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_get_rest_arg(c,3,av,3,t0);
tp(4,av2);}}
else{
/* library.scm:1554: ##sys#error-bad-exact-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[429]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[429]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}}}

/* ##sys#check-exact-uinteger in k12641 in k11449 */
static void C_ccall f_14573(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,3)))){
C_save_and_reclaim((void*)f_14573,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
t4=C_i_not(C_i_exact_integerp(t2));
t5=(C_truep(t4)?t4:C_i_integer_negativep(t2));
if(C_truep(t5)){
if(C_truep(C_i_pairp(t3))){
/* library.scm:1559: ##sys#error-bad-exact-uinteger */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[431]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[431]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_get_rest_arg(c,3,av,3,t0);
tp(4,av2);}}
else{
/* library.scm:1559: ##sys#error-bad-exact-uinteger */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[431]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[431]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}}
else{
t6=C_SCHEME_UNDEFINED;
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* ##sys#check-real in k12641 in k11449 */
static void C_ccall f_14597(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,3)))){
C_save_and_reclaim((void*)f_14597,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
if(C_truep(C_i_realp(t2))){
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t3))){
/* library.scm:1563: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[433]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[433]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_get_rest_arg(c,3,av,3,t0);
tp(4,av2);}}
else{
/* library.scm:1563: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[433]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[433]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}}}

/* ##sys#check-range in k12641 in k11449 */
static void C_ccall f_14614(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-5)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14614,c,av);}
a=C_alloc((c-5)*C_SIZEOF_PAIR+0);
t5=C_build_rest(&a,c,5,av);
C_word t6;
C_word t7;
t6=C_i_pairp(t5);
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=(C_truep(t6)?C_i_check_range_2(t2,t3,t4,C_get_rest_arg(c,5,av,5,t0)):C_i_check_range(t2,t3,t4));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* ##sys#check-range/including in k12641 in k11449 */
static void C_ccall f_14625(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-5)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14625,c,av);}
a=C_alloc((c-5)*C_SIZEOF_PAIR+0);
t5=C_build_rest(&a,c,5,av);
C_word t6;
C_word t7;
t6=C_i_pairp(t5);
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=(C_truep(t6)?C_i_check_range_including_2(t2,t3,t4,C_get_rest_arg(c,5,av,5,t0)):C_i_check_range_including(t2,t3,t4));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* ##sys#check-special in k12641 in k11449 */
static void C_ccall f_14636(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,5)))){
C_save_and_reclaim((void*)f_14636,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
t4=(C_truep(C_blockp(t2))?C_specialp(t2):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=C_SCHEME_UNDEFINED;
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t3))){
/* library.scm:1577: ##sys#signal-hook */
t5=*((C_word*)lf[245]+1);{
C_word av2[6];
av2[0]=t5;
av2[1]=t1;
av2[2]=lf[305];
av2[3]=C_get_rest_arg(c,3,av,3,t0);
av2[4]=lf[437];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(6,av2);}}
else{
/* library.scm:1577: ##sys#signal-hook */
t5=*((C_word*)lf[245]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=lf[305];
av2[3]=C_SCHEME_FALSE;
av2[4]=lf[437];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(6,av2);}}}}

/* ##sys#check-closure in k12641 in k11449 */
static void C_ccall f_14656(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14656,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_closure_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_closure(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#force in k12641 in k11449 */
static void C_ccall f_14667(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_14667,c,av);}
a=C_alloc(6);
if(C_truep(C_i_structurep(t2,lf[260]))){
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14679,a[2]=t4,a[3]=((C_word)li321),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_14679(t6,t1,t2,C_SCHEME_FALSE);}
else{
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* lp in scheme#force in k12641 in k11449 */
static void f_14679(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_14679,4,t0,t1,t2,t3);}
a=C_alloc(6);
t4=C_slot(t2,C_fix(1));
if(C_truep(C_i_nullp(t4))){
/* library.scm:1590: ##sys#values */{
C_word av2[2];
av2[0]=0;
av2[1]=t1;
C_values(2,av2);}}
else{
if(C_truep(C_i_pairp(t4))){{
C_word av2[3];
av2[0]=0;
av2[1]=t1;
av2[2]=t4;
C_apply_values(3,av2);}}
else{
if(C_truep(C_i_closurep(t4))){
t5=(C_truep(t3)?C_i_setslot(t3,C_fix(1),t2):C_SCHEME_UNDEFINED);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_14713,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* library.scm:1594: ##sys#call-with-values */{
C_word av2[4];
av2[0]=0;
av2[1]=t6;
av2[2]=t4;
av2[3]=*((C_word*)lf[440]+1);
C_call_with_values(4,av2);}}
else{
if(C_truep(C_i_structurep(t4,lf[260]))){
/* library.scm:1606: lp */
t8=t1;
t9=t4;
t10=t3;
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}}}}

/* k14711 in lp in scheme#force in k12641 in k11449 */
static void C_ccall f_14713(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_14713,c,av);}
a=C_alloc(6);
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=C_i_closurep(t2);
if(C_truep(C_i_not(t3))){
/* library.scm:1596: lp */
t4=((C_word*)((C_word*)t0)[3])[1];
f_14679(t4,((C_word*)t0)[4],((C_word*)t0)[2],((C_word*)t0)[5]);}
else{
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_14728,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t5=C_i_nullp(t1);
if(C_truep(C_i_not(t5))){
t6=C_i_cdr(t1);
t7=C_i_nullp(t6);
t8=t4;
f_14728(t8,(C_truep(t7)?C_i_structurep(C_slot(t1,C_fix(0)),lf[260]):C_SCHEME_FALSE));}
else{
t6=t4;
f_14728(t6,C_SCHEME_FALSE);}}}

/* k14726 in k14711 in lp in scheme#force in k12641 in k11449 */
static void f_14728(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,3)))){
C_save_and_reclaim_args((void *)trf_14728,2,t0,t1);}
if(C_truep(t1)){
t2=C_slot(((C_word*)t0)[2],C_fix(0));
t3=C_slot(t2,C_fix(1));
t4=C_i_setslot(((C_word*)t0)[3],C_fix(1),t3);
/* library.scm:1601: lp */
t5=((C_word*)((C_word*)t0)[4])[1];
f_14679(t5,((C_word*)t0)[5],((C_word*)t0)[3],t2);}
else{
t2=C_i_setslot(((C_word*)t0)[3],C_fix(1),((C_word*)t0)[2]);{
C_word av2[3];
av2[0]=0;
av2[1]=((C_word*)t0)[5];
av2[2]=((C_word*)t0)[2];
C_apply_values(3,av2);}}}

/* ##sys#error-not-a-proper-list in k12641 in k11449 */
static void C_ccall f_14795(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_14795,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_NOT_A_PROPER_LIST_ERROR);
/* library.scm:1616: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word av2[5];
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_NOT_A_PROPER_LIST_ERROR);
/* library.scm:1616: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word av2[5];
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-number in k12641 in k11449 */
static void C_ccall f_14811(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_14811,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_NUMBER_ERROR);
/* library.scm:1620: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word av2[5];
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_NUMBER_ERROR);
/* library.scm:1620: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word av2[5];
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-integer in k12641 in k11449 */
static void C_ccall f_14827(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_14827,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_INTEGER_ERROR);
/* library.scm:1624: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word av2[5];
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_INTEGER_ERROR);
/* library.scm:1624: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word av2[5];
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-exact-integer in k12641 in k11449 */
static void C_ccall f_14843(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_14843,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_INTEGER_ERROR);
/* library.scm:1628: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word av2[5];
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_INTEGER_ERROR);
/* library.scm:1628: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word av2[5];
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-exact-uinteger in k12641 in k11449 */
static void C_ccall f_14859(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_14859,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_UINTEGER_ERROR);
/* library.scm:1632: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word av2[5];
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_UINTEGER_ERROR);
/* library.scm:1632: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word av2[5];
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-inexact in k12641 in k11449 */
static void C_ccall f_14875(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_14875,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_CANT_REPRESENT_INEXACT_ERROR);
/* library.scm:1636: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word av2[5];
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_CANT_REPRESENT_INEXACT_ERROR);
/* library.scm:1636: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word av2[5];
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-real in k12641 in k11449 */
static void C_ccall f_14891(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_14891,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_REAL_ERROR);
/* library.scm:1640: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word av2[5];
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_REAL_ERROR);
/* library.scm:1640: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word av2[5];
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-base in k12641 in k11449 */
static void C_ccall f_14907(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_14907,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_BAD_BASE_ERROR);
/* library.scm:1644: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word av2[5];
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_BAD_BASE_ERROR);
/* library.scm:1644: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word av2[5];
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* scheme#append in k12641 in k11449 */
static void C_ccall f_14923(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +6,c,3)))){
C_save_and_reclaim((void*)f_14923,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+6);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
t3=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t3)){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14935,a[2]=t5,a[3]=((C_word)li334),tmp=(C_word)a,a+=4,tmp));
t7=((C_word*)t5)[1];
f_14935(t7,t1,t2);}}

/* loop in scheme#append in k12641 in k11449 */
static void f_14935(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,3)))){
C_save_and_reclaim_args((void *)trf_14935,3,t0,t1,t2);}
a=C_alloc(8);
t3=C_slot(t2,C_fix(1));
t4=C_eqp(t3,C_SCHEME_END_OF_LIST);
if(C_truep(t4)){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_slot(t2,C_fix(0));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t5=C_slot(t2,C_fix(0));
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_14954,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t7,a[5]=((C_word)li333),tmp=(C_word)a,a+=6,tmp));
t9=((C_word*)t7)[1];
f_14954(t9,t1,t5);}}

/* copy in loop in scheme#append in k12641 in k11449 */
static void f_14954(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(4,0,3)))){
C_save_and_reclaim_args((void *)trf_14954,3,t0,t1,t2);}
a=C_alloc(4);
t3=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t3)){
/* library.scm:1655: loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_14935(t4,t1,C_slot(((C_word*)t0)[3],C_fix(1)));}
else{
if(C_truep(C_i_pairp(t2))){
t4=C_slot(t2,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14985,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1657: copy */
t7=t5;
t8=C_slot(t2,C_fix(1));
t1=t7;
t2=t8;
goto loop;}
else{
/* library.scm:1659: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[51]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[51]+1);
av2[1]=t1;
av2[2]=C_slot(((C_word*)t0)[3],C_fix(0));
av2[3]=lf[448];
tp(4,av2);}}}}

/* k14983 in copy in loop in scheme#append in k12641 in k11449 */
static void C_ccall f_14985(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_14985,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* ##sys#fast-reverse in k12641 in k11449 */
static void C_ccall f_15002(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_15002,c,av);}
a=C_alloc(6);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15008,a[2]=t4,a[3]=((C_word)li336),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_15008(t6,t1,t2,C_SCHEME_END_OF_LIST);}

/* loop in ##sys#fast-reverse in k12641 in k11449 */
static void f_15008(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(3,0,3)))){
C_save_and_reclaim_args((void *)trf_15008,4,t0,t1,t2,t3);}
a=C_alloc(3);
if(C_truep(C_i_pairp(t2))){
t4=C_slot(t2,C_fix(1));
t5=C_slot(t2,C_fix(0));
t6=C_a_i_cons(&a,2,t5,t3);
/* library.scm:1665: loop */
t8=t1;
t9=t4;
t10=t6;
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* ##sys#make-bytevector in k12641 in k11449 */
static void C_ccall f_15032(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_15032,c,av);}
if(C_truep(C_rest_nullp(c,3))){
/* library.scm:1672: ##sys#allocate-bytevector */
t3=*((C_word*)lf[388]+1);{
C_word av2[4];
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}
else{
/* library.scm:1672: ##sys#allocate-bytevector */
t3=*((C_word*)lf[388]+1);{
C_word av2[4];
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
av2[3]=C_get_rest_arg(c,3,av,3,t0);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}}

/* ##sys#make-string in k12641 in k11449 */
static void C_ccall f_15047(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_15047,c,av);}
a=C_alloc(5);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_make_character(32):C_get_rest_arg(c,3,av,3,t0));
t5=C_utf_bytes(t4);
t6=C_fixnum_times(t5,t2);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15057,a[2]=t4,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1677: ##sys#allocate-bytevector */
t8=*((C_word*)lf[388]+1);{
C_word av2[4];
av2[0]=t8;
av2[1]=t7;
av2[2]=C_fixnum_plus(t6,C_fix(1));
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}

/* k15055 in ##sys#make-string in k12641 in k11449 */
static void C_ccall f_15057(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_15057,c,av);}
a=C_alloc(5);
t2=C_utf_fill(t1,((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_ustring(&a,2,t1,((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#buffer->string in k12641 in k11449 */
static void C_ccall f_15069(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_15069,c,av);}
a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15073,a[2]=t2,a[3]=t3,a[4]=t4,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* library.scm:1682: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[164]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[164]+1);
av2[1]=t5;
av2[2]=C_fixnum_plus(t4,C_fix(1));
tp(3,av2);}}

/* k15071 in ##sys#buffer->string in k12641 in k11449 */
static void C_ccall f_15073(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_15073,c,av);}
a=C_alloc(5);
t2=C_copy_memory_with_offset(t1,((C_word*)t0)[2],C_fix(0),((C_word*)t0)[3],((C_word*)t0)[4]);
t3=C_utf_range_length(t1,C_fix(0),((C_word*)t0)[4]);
t4=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_ustring(&a,2,t1,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#utf-decoder in k12641 in k11449 */
static void C_ccall f_15080(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_15080,c,av);}
/* library.scm:1688: k */
t6=t5;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=t4;
((C_proc)C_fast_retrieve_proc(t6))(5,av2);}}

/* ##sys#utf-encoder in k12641 in k11449 */
static void C_ccall f_15086(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_15086,c,av);}
/* library.scm:1691: k */
t6=t5;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=t4;
((C_proc)C_fast_retrieve_proc(t6))(5,av2);}}

/* ##sys#utf-scanner in k12641 in k11449 */
static void C_ccall f_15092(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_15092,c,av);}
if(C_truep(t2)){
t4=C_fixnum_greaterp(t2,C_fix(1));
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=(C_truep(t4)?C_fixnum_difference(t2,C_fix(1)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t4=C_utf_bytes_needed(t3);
t5=C_eqp(t4,C_fix(1));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(C_truep(t5)?C_SCHEME_FALSE:C_fixnum_difference(t4,C_fix(1)));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* ##sys#latin-decoder in k12641 in k11449 */
static void C_ccall f_15116(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_15116,c,av);}
a=C_alloc(7);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15120,a[2]=t5,a[3]=t1,a[4]=t2,a[5]=t3,a[6]=t4,tmp=(C_word)a,a+=7,tmp);
/* library.scm:1704: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[164]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[164]+1);
av2[1]=t6;
av2[2]=C_fixnum_times(t4,C_fix(2));
tp(3,av2);}}

/* k15118 in ##sys#latin-decoder in k12641 in k11449 */
static void C_ccall f_15120(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_15120,c,av);}
/* library.scm:1706: k */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
av2[3]=C_fix(0);
av2[4]=C_latin_to_utf(((C_word*)t0)[4],t1,((C_word*)t0)[5],((C_word*)t0)[6]);
((C_proc)C_fast_retrieve_proc(t2))(5,av2);}}

/* ##sys#latin-encoder in k12641 in k11449 */
static void C_ccall f_15129(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_15129,c,av);}
a=C_alloc(7);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15133,a[2]=t5,a[3]=t1,a[4]=t2,a[5]=t3,a[6]=t4,tmp=(C_word)a,a+=7,tmp);
/* library.scm:1709: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[164]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[164]+1);
av2[1]=t6;
av2[2]=C_fixnum_plus(t4,C_fix(1));
tp(3,av2);}}

/* k15131 in ##sys#latin-encoder in k12641 in k11449 */
static void C_ccall f_15133(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_15133,c,av);}
/* library.scm:1711: k */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
av2[3]=C_fix(0);
av2[4]=C_utf_to_latin(((C_word*)t0)[4],t1,((C_word*)t0)[5],((C_word*)t0)[6]);
((C_proc)C_fast_retrieve_proc(t2))(5,av2);}}

/* ##sys#latin-scanner in k12641 in k11449 */
static void C_ccall f_15142(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_15142,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#binary-decoder in k12641 in k11449 */
static void C_ccall f_15145(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_15145,c,av);}
/* library.scm:1716: k */
t6=t5;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=t4;
((C_proc)C_fast_retrieve_proc(t6))(5,av2);}}

/* ##sys#binary-encoder in k12641 in k11449 */
static void C_ccall f_15151(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_15151,c,av);}
/* library.scm:1719: k */
t6=t5;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=t4;
((C_proc)C_fast_retrieve_proc(t6))(5,av2);}}

/* ##sys#binary-scanner in k12641 in k11449 */
static void C_ccall f_15157(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_15157,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#encoding-hook in k12641 in k11449 */
static void C_ccall f_15160(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_15160,c,av);}
t4=C_eqp(t2,lf[178]);
if(C_truep(t4)){
/* library.scm:1726: k */
t5=t3;{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=*((C_word*)lf[457]+1);
av2[3]=*((C_word*)lf[458]+1);
av2[4]=*((C_word*)lf[459]+1);
((C_proc)C_fast_retrieve_proc(t5))(5,av2);}}
else{
t5=C_eqp(t2,lf[461]);
if(C_truep(t5)){
/* library.scm:1727: k */
t6=t3;{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t6;
av2[1]=t1;
av2[2]=*((C_word*)lf[451]+1);
av2[3]=*((C_word*)lf[452]+1);
av2[4]=*((C_word*)lf[453]+1);
((C_proc)C_fast_retrieve_proc(t6))(5,av2);}}
else{
t6=C_eqp(t2,lf[462]);
if(C_truep(t6)){
/* library.scm:1728: k */
t7=t3;{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t7;
av2[1]=t1;
av2[2]=*((C_word*)lf[454]+1);
av2[3]=*((C_word*)lf[455]+1);
av2[4]=*((C_word*)lf[456]+1);
((C_proc)C_fast_retrieve_proc(t7))(5,av2);}}
else{
/* library.scm:1729: ##sys#signal-hook */
t7=*((C_word*)lf[245]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t7;
av2[1]=t1;
av2[2]=lf[305];
av2[3]=C_SCHEME_FALSE;
av2[4]=lf[463];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t7+1)))(6,av2);}}}}}

/* ##sys#register-encoding in k12641 in k11449 */
static void C_ccall f_15199(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_15199,c,av);}
a=C_alloc(7);
t6=*((C_word*)lf[460]+1);
t7=C_mutate((C_word*)lf[460]+1 /* (set! ##sys#encoding-hook ...) */,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15202,a[2]=t2,a[3]=t3,a[4]=t5,a[5]=t6,a[6]=((C_word)li351),tmp=(C_word)a,a+=7,tmp));
t8=t1;{
C_word *av2=av;
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}

/* ##sys#encoding-hook in ##sys#register-encoding in k12641 in k11449 */
static void C_ccall f_15202(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,2)))){
C_save_and_reclaim((void *)f_15202,c,av);}
a=C_alloc(8);
t4=C_eqp(t2,((C_word*)t0)[2]);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_15212,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t2,a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],tmp=(C_word)a,a+=8,tmp);
if(C_truep(t4)){
t6=t5;
f_15212(t6,t4);}
else{
t6=C_i_pairp(((C_word*)t0)[2]);
t7=t5;
f_15212(t7,(C_truep(t6)?C_i_memq(t2,((C_word*)t0)[2]):C_SCHEME_FALSE));}}

/* k15210 in ##sys#encoding-hook in ##sys#register-encoding in k12641 in k11449 */
static void f_15212(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,4)))){
C_save_and_reclaim_args((void *)trf_15212,2,t0,t1);}
if(C_truep(t1)){
/* library.scm:1737: k */
t2=((C_word*)t0)[2];{
C_word av2[5];
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
av2[4]=((C_word*)t0)[6];
((C_proc)C_fast_retrieve_proc(t2))(5,av2);}}
else{
/* library.scm:1738: old */
t2=((C_word*)t0)[7];{
C_word av2[4];
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[5];
av2[3]=((C_word*)t0)[2];
((C_proc)C_fast_retrieve_proc(t2))(4,av2);}}}

/* ##sys#buffer->string/encoding in k12641 in k11449 */
static void C_ccall f_15229(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_15229,c,av);}
a=C_alloc(6);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15235,a[2]=t2,a[3]=t3,a[4]=t4,a[5]=((C_word)li353),tmp=(C_word)a,a+=6,tmp);
/* library.scm:1742: ##sys#encoding-hook */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[460]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[460]+1);
av2[1]=t1;
av2[2]=t5;
av2[3]=t6;
tp(4,av2);}}

/* a15234 in ##sys#buffer->string/encoding in k12641 in k11449 */
static void C_ccall f_15235(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_15235,c,av);}
/* library.scm:1744: decoder */
t5=t2;{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=((C_word*)t0)[3];
av2[4]=((C_word*)t0)[4];
av2[5]=*((C_word*)lf[163]+1);
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* ##sys#encode-buffer in k12641 in k11449 */
static void C_ccall f_15241(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6=av[6];
C_word t7;
C_word t8;
C_word *a;
if(c!=7) C_bad_argc_2(c,7,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,5)))){
C_save_and_reclaim((void *)f_15241,c,av);}
a=C_alloc(7);
t7=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15247,a[2]=t2,a[3]=t3,a[4]=t4,a[5]=t6,a[6]=((C_word)li355),tmp=(C_word)a,a+=7,tmp);
/* library.scm:1748: ##sys#encoding-hook */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[460]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[460]+1);
av2[1]=t1;
av2[2]=t5;
av2[3]=t7;
tp(4,av2);}}

/* a15246 in ##sys#encode-buffer in k12641 in k11449 */
static void C_ccall f_15247(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_15247,c,av);}
/* library.scm:1750: encoder */
t5=t3;{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=((C_word*)t0)[3];
av2[4]=((C_word*)t0)[4];
av2[5]=((C_word*)t0)[5];
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* ##sys#decode-buffer in k12641 in k11449 */
static void C_ccall f_15253(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6=av[6];
C_word t7;
C_word t8;
C_word *a;
if(c!=7) C_bad_argc_2(c,7,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,5)))){
C_save_and_reclaim((void *)f_15253,c,av);}
a=C_alloc(7);
t7=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15259,a[2]=t2,a[3]=t3,a[4]=t4,a[5]=t6,a[6]=((C_word)li357),tmp=(C_word)a,a+=7,tmp);
/* library.scm:1754: ##sys#encoding-hook */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[460]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[460]+1);
av2[1]=t1;
av2[2]=t5;
av2[3]=t7;
tp(4,av2);}}

/* a15258 in ##sys#decode-buffer in k12641 in k11449 */
static void C_ccall f_15259(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_15259,c,av);}
/* library.scm:1756: decoder */
t5=t2;{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=((C_word*)t0)[3];
av2[4]=((C_word*)t0)[4];
av2[5]=((C_word*)t0)[5];
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* ##sys#encode-char in k12641 in k11449 */
static void C_ccall f_15265(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_15265,c,av);}
a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15271,a[2]=t2,a[3]=t3,a[4]=((C_word)li360),tmp=(C_word)a,a+=5,tmp);
/* library.scm:1760: ##sys#encoding-hook */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[460]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[460]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t5;
tp(4,av2);}}

/* a15270 in ##sys#encode-char in k12641 in k11449 */
static void C_ccall f_15271(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_15271,c,av);}
a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15275,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* library.scm:1763: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[164]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[164]+1);
av2[1]=t5;
av2[2]=C_fix(4);
tp(3,av2);}}

/* k15273 in a15270 in ##sys#encode-char in k12641 in k11449 */
static void C_ccall f_15275(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,5)))){
C_save_and_reclaim((void *)f_15275,c,av);}
a=C_alloc(4);
t2=C_utf_insert(t1,C_fix(0),((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15280,a[2]=((C_word*)t0)[3],a[3]=((C_word)li359),tmp=(C_word)a,a+=4,tmp);
/* library.scm:1765: encoder */
t4=((C_word*)t0)[4];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=((C_word*)t0)[5];
av2[2]=t1;
av2[3]=C_fix(0);
av2[4]=t2;
av2[5]=t3;
((C_proc)C_fast_retrieve_proc(t4))(6,av2);}}

/* a15279 in k15273 in a15270 in ##sys#encode-char in k12641 in k11449 */
static void C_ccall f_15280(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_15280,c,av);}
t5=C_copy_memory_with_offset(((C_word*)t0)[2],t2,C_fix(0),t3,t4);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* ##sys#decode-char in k12641 in k11449 */
static void C_ccall f_15283(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,6)))){
C_save_and_reclaim((void *)f_15283,c,av);}
a=C_alloc(3);
t5=C_block_size(t2);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15293,a[2]=((C_word)li362),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1771: ##sys#decode-buffer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[467]+1));
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=*((C_word*)lf[467]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=t4;
av2[4]=t5;
av2[5]=t3;
av2[6]=t6;
tp(7,av2);}}

/* a15292 in ##sys#decode-char in k12641 in k11449 */
static void C_ccall f_15293(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_15293,c,av);}
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_utf_decode(t2,t3);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#read-char/encoding in k12641 in k11449 */
static void C_ccall f_15296(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_15296,c,av);}
a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15302,a[2]=t2,a[3]=t4,a[4]=((C_word)li365),tmp=(C_word)a,a+=5,tmp);
/* library.scm:1778: ##sys#encoding-hook */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[460]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[460]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=t5;
tp(4,av2);}}

/* a15301 in ##sys#read-char/encoding in k12641 in k11449 */
static void C_ccall f_15302(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_15302,c,av);}
a=C_alloc(7);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15306,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=t4,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* library.scm:1781: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[164]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[164]+1);
av2[1]=t5;
av2[2]=C_fix(4);
tp(3,av2);}}

/* k15304 in a15301 in ##sys#read-char/encoding in k12641 in k11449 */
static void C_ccall f_15306(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,c,4)))){
C_save_and_reclaim((void *)f_15306,c,av);}
a=C_alloc(12);
t2=C_slot(((C_word*)t0)[2],C_fix(2));
t3=C_slot(t2,C_fix(7));
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_15314,a[2]=t1,a[3]=t5,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t3,a[8]=((C_word*)t0)[2],a[9]=((C_word)li364),tmp=(C_word)a,a+=10,tmp));
t7=((C_word*)t5)[1];
f_15314(t7,((C_word*)t0)[6],C_SCHEME_FALSE,C_fix(0));}

/* loop in k15304 in a15301 in ##sys#read-char/encoding in k12641 in k11449 */
static void f_15314(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,0,5)))){
C_save_and_reclaim_args((void *)trf_15314,4,t0,t1,t2,t3);}
a=C_alloc(10);
t4=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_15318,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[6],a[9]=t2,tmp=(C_word)a,a+=10,tmp);
/* library.scm:1784: rbv! */
t5=((C_word*)t0)[7];{
C_word av2[6];
av2[0]=t5;
av2[1]=t4;
av2[2]=((C_word*)t0)[8];
av2[3]=C_fix(1);
av2[4]=((C_word*)t0)[2];
av2[5]=t3;
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* k15316 in loop in k15304 in a15301 in ##sys#read-char/encoding in k12641 in k11449 */
static void C_ccall f_15318(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,6)))){
C_save_and_reclaim((void *)f_15318,c,av);}
a=C_alloc(8);
t2=C_eqp(C_fix(0),t1);
if(C_truep(t2)){
t3=C_eqp(((C_word*)t0)[2],C_fix(0));
if(C_truep(t3)){
t4=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_END_OF_FILE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
/* library.scm:1788: ##sys#signal-hook */
t4=*((C_word*)lf[245]+1);{
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=t4;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[471];
av2[3]=lf[472];
av2[4]=lf[473];
av2[5]=((C_word*)t0)[4];
av2[6]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(7,av2);}}}
else{
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_15336,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
/* library.scm:1789: scan */
t4=((C_word*)t0)[8];{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[9];
av2[3]=C_subbyte(((C_word*)t0)[4],((C_word*)t0)[2]);
((C_proc)C_fast_retrieve_proc(t4))(4,av2);}}}

/* k15334 in k15316 in loop in k15304 in a15301 in ##sys#read-char/encoding in k12641 in k11449 */
static void C_ccall f_15336(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_15336,c,av);}
if(C_truep(t1)){
/* library.scm:1791: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_15314(t2,((C_word*)t0)[3],t1,C_fixnum_plus(((C_word*)t0)[4],C_fix(1)));}
else{
/* library.scm:1792: k */
t2=((C_word*)t0)[5];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[6];
av2[3]=C_fix(0);
av2[4]=C_fixnum_plus(((C_word*)t0)[4],C_fix(1));
av2[5]=((C_word*)t0)[7];
((C_proc)C_fast_retrieve_proc(t2))(6,av2);}}}

/* scheme#make-string in k12641 in k11449 */
static void C_ccall f_15360(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +5,c,5)))){
C_save_and_reclaim((void*)f_15360,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+5);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
t4=C_i_check_fixnum_2(t2,lf[475]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15367,a[2]=t3,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* library.scm:1798: ##sys#signal-hook */
t6=*((C_word*)lf[245]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=lf[476];
av2[3]=lf[475];
av2[4]=lf[477];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t6+1)))(6,av2);}}
else{
t6=t5;{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_SCHEME_UNDEFINED;
f_15367(2,av2);}}}

/* k15365 in scheme#make-string in k12641 in k11449 */
static void C_ccall f_15367(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_15367,c,av);}
if(C_truep(C_i_nullp(((C_word*)t0)[2]))){
/* library.scm:1799: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[450]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[450]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=C_make_character(32);
tp(4,av2);}}
else{
t2=C_i_car(((C_word*)t0)[2]);
t3=C_i_check_char_2(t2,lf[475]);
/* library.scm:1799: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[450]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[450]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=t2;
tp(4,av2);}}}

/* scheme#string->list in k12641 in k11449 */
static void C_ccall f_15391(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(11,c,5)))){
C_save_and_reclaim((void *)f_15391,c,av);}
a=C_alloc(11);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_get_rest_arg(c,3,av,3,t0));
t5=t4;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_rest_nullp(c,3);
t8=C_rest_nullp(c,4);
t9=(C_truep(t8)?C_SCHEME_FALSE:C_get_rest_arg(c,4,av,3,t0));
t10=t9;
t11=(*a=C_VECTOR_TYPE|1,a[1]=t10,tmp=(C_word)a,a+=2,tmp);
t12=C_rest_nullp(c,4);
t13=C_i_check_string_2(t2,lf[479]);
t14=C_slot(t2,C_fix(1));
t15=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15413,a[2]=t11,a[3]=t6,a[4]=t2,a[5]=t1,a[6]=t14,tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t6)[1])){
/* library.scm:1812: ##sys#check-range/including */
t16=*((C_word*)lf[435]+1);{
C_word av2[6];
av2[0]=t16;
av2[1]=t15;
av2[2]=((C_word*)t6)[1];
av2[3]=C_fix(0);
av2[4]=t14;
av2[5]=lf[479];
((C_proc)(void*)(*((C_word*)t16+1)))(6,av2);}}
else{
t16=C_set_block_item(t6,0,C_fix(0));
t17=t15;{
C_word *av2=av;
av2[0]=t17;
av2[1]=t16;
f_15413(2,av2);}}}

/* k15411 in scheme#string->list in k12641 in k11449 */
static void C_ccall f_15413(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_15413,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15416,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)((C_word*)t0)[2])[1])){
/* library.scm:1815: ##sys#check-range/including */
t3=*((C_word*)lf[435]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)((C_word*)t0)[2])[1];
av2[3]=C_fix(0);
av2[4]=((C_word*)t0)[6];
av2[5]=lf[479];
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}
else{
t3=C_mutate(((C_word *)((C_word*)t0)[2])+1,((C_word*)t0)[6]);
t4=t2;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
f_15416(2,av2);}}}

/* k15414 in k15411 in scheme#string->list in k12641 in k11449 */
static void C_ccall f_15416(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_15416,c,av);}
a=C_alloc(8);
t2=C_fixnum_difference(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15425,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t4,a[5]=((C_word)li368),tmp=(C_word)a,a+=6,tmp));
t6=((C_word*)t4)[1];
f_15425(t6,((C_word*)t0)[5],t2,C_SCHEME_END_OF_LIST);}

/* loop in k15414 in k15411 in scheme#string->list in k12641 in k11449 */
static void f_15425(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(3,0,3)))){
C_save_and_reclaim_args((void *)trf_15425,4,t0,t1,t2,t3);}
a=C_alloc(3);
if(C_truep(C_fixnum_lessp(t2,((C_word*)((C_word*)t0)[2])[1]))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fixnum_difference(t2,C_fix(1));
t5=C_i_string_ref(((C_word*)t0)[3],t2);
t6=C_a_i_cons(&a,2,t5,t3);
/* library.scm:1820: loop */
t8=t1;
t9=t4;
t10=t6;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}

/* scheme#list->string in k12641 in k11449 */
static void C_ccall f_15482(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_15482,c,av);}
a=C_alloc(4);
t3=C_i_listp(t2);
if(C_truep(C_i_not(t3))){
/* library.scm:1828: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[51]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[51]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[482];
tp(4,av2);}}
else{
t4=C_utf_list_size(t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15495,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1830: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[164]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[164]+1);
av2[1]=t5;
av2[2]=C_fixnum_plus(C_fix(1),t4);
tp(3,av2);}}}

/* k15493 in scheme#list->string in k12641 in k11449 */
static void C_ccall f_15495(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,5)))){
C_save_and_reclaim((void *)f_15495,c,av);}
a=C_alloc(7);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15500,a[2]=t1,a[3]=t3,a[4]=((C_word)li370),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_15500(t5,((C_word*)t0)[2],C_fix(0),C_fix(0),((C_word*)t0)[3]);}

/* loop in k15493 in scheme#list->string in k12641 in k11449 */
static void f_15500(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(5,0,4)))){
C_save_and_reclaim_args((void *)trf_15500,5,t0,t1,t2,t3,t4);}
a=C_alloc(5);
t5=C_i_pairp(t4);
if(C_truep(C_i_not(t5))){
t6=C_a_ustring(&a,2,((C_word*)t0)[2],t2);
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t6=C_slot(t4,C_fix(0));
t7=C_i_check_char_2(t6,lf[482]);
t8=C_utf_insert(((C_word*)t0)[2],t3,t6);
/* library.scm:1839: loop */
t10=t1;
t11=C_fixnum_plus(t2,C_fix(1));
t12=C_fixnum_plus(t3,C_utf_bytes(t6));
t13=C_slot(t4,C_fix(1));
t1=t10;
t2=t11;
t3=t12;
t4=t13;
goto loop;}}

/* ##sys#reverse-list->string in k12641 in k11449 */
static void C_ccall f_15544(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_15544,c,av);}
a=C_alloc(5);
t3=C_utf_list_size(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15548,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1847: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[164]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[164]+1);
av2[1]=t4;
av2[2]=C_fixnum_plus(t3,C_fix(1));
tp(3,av2);}}

/* k15546 in ##sys#reverse-list->string in k12641 in k11449 */
static void C_ccall f_15548(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,5)))){
C_save_and_reclaim((void *)f_15548,c,av);}
a=C_alloc(7);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15553,a[2]=t1,a[3]=t3,a[4]=((C_word)li372),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_15553(t5,((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4],C_fix(0));}

/* loop in k15546 in ##sys#reverse-list->string in k12641 in k11449 */
static void f_15553(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(5,0,4)))){
C_save_and_reclaim_args((void *)trf_15553,5,t0,t1,t2,t3,t4);}
a=C_alloc(5);
if(C_truep(C_i_nullp(t3))){
t5=C_a_ustring(&a,2,((C_word*)t0)[2],t4);
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t3))){
t5=C_slot(t3,C_fix(0));
t6=C_i_check_char_2(t5,lf[485]);
t7=C_utf_bytes(t5);
t8=C_fixnum_difference(t2,t7);
t9=C_utf_insert(((C_word*)t0)[2],t8,t5);
/* library.scm:1857: loop */
t11=t1;
t12=t8;
t13=C_slot(t3,C_fix(1));
t14=C_fixnum_plus(t4,C_fix(1));
t1=t11;
t2=t12;
t3=t13;
t4=t14;
goto loop;}
else{
/* library.scm:1858: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[51]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[51]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=lf[485];
tp(4,av2);}}}}

/* scheme#string-fill! in k12641 in k11449 */
static void C_ccall f_15595(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(11,c,2)))){
C_save_and_reclaim((void *)f_15595,c,av);}
a=C_alloc(11);
t4=C_rest_nullp(c,4);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_get_rest_arg(c,4,av,4,t0));
t6=t5;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_rest_nullp(c,4);
t9=C_rest_nullp(c,5);
t10=(C_truep(t9)?C_SCHEME_FALSE:C_get_rest_arg(c,5,av,4,t0));
t11=t10;
t12=(*a=C_VECTOR_TYPE|1,a[1]=t11,tmp=(C_word)a,a+=2,tmp);
t13=C_rest_nullp(c,5);
t14=C_i_check_string_2(t2,lf[487]);
t15=C_i_check_char_2(t3,lf[487]);
t16=C_u_i_string_length(t2);
t17=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15618,a[2]=t2,a[3]=t12,a[4]=t7,a[5]=t3,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t7)[1])){
t18=C_i_check_range_2(((C_word*)t7)[1],C_fix(0),t16,lf[487]);
if(C_truep(((C_word*)t12)[1])){
t19=t17;
f_15618(t19,C_i_check_range_2(((C_word*)t12)[1],C_fix(0),t16,lf[487]));}
else{
t19=C_set_block_item(t12,0,t16);
t20=t17;
f_15618(t20,t19);}}
else{
t18=C_set_block_item(t7,0,C_fix(0));
t19=C_set_block_item(t12,0,t16);
t20=t17;
f_15618(t20,t19);}}

/* k15616 in scheme#string-fill! in k12641 in k11449 */
static void f_15618(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,2)))){
C_save_and_reclaim_args((void *)trf_15618,2,t0,t1);}
a=C_alloc(6);
t2=C_slot(((C_word*)t0)[2],C_fix(0));
t3=C_block_size(t2);
t4=C_fixnum_difference(((C_word*)((C_word*)t0)[3])[1],((C_word*)((C_word*)t0)[4])[1]);
t5=C_i_fixnum_max(C_fix(0),t4);
t6=C_fix(C_character_code(((C_word*)t0)[5]));
t7=C_fixnum_difference(t3,C_fix(1));
t8=C_slot(((C_word*)t0)[2],C_fix(1));
t9=C_eqp(t7,t8);
t10=(C_truep(t9)?C_fixnum_lessp(t6,C_fix(128)):C_SCHEME_FALSE);
if(C_truep(t10)){
t11=((C_word*)t0)[6];{
C_word av2[2];
av2[0]=t11;
av2[1]=C_fill_bytevector(t2,t6,((C_word*)((C_word*)t0)[4])[1],t5);
((C_proc)(void*)(*((C_word*)t11+1)))(2,av2);}}
else{
t11=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15641,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[5],a[5]=((C_word)li374),tmp=(C_word)a,a+=6,tmp);
t12=((C_word*)t0)[6];{
C_word av2[2];
av2[0]=t12;
av2[1]=(
  f_15641(t11,((C_word*)((C_word*)t0)[4])[1])
);
((C_proc)(void*)(*((C_word*)t12+1)))(2,av2);}}}

/* doloop2062 in k15616 in scheme#string-fill! in k12641 in k11449 */
static C_word f_15641(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_stack_overflow_check;
loop:{}
if(C_truep(C_fixnum_greater_or_equal_p(t1,((C_word*)((C_word*)t0)[2])[1]))){
t2=C_SCHEME_UNDEFINED;
return(t2);}
else{
t2=C_i_string_set(((C_word*)t0)[3],t1,((C_word*)t0)[4]);
t4=C_fixnum_plus(t1,C_fix(1));
t1=t4;
goto loop;}}

/* scheme#string-copy in k12641 in k11449 */
static void C_ccall f_15714(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(17,c,5)))){
C_save_and_reclaim((void *)f_15714,c,av);}
a=C_alloc(17);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_get_rest_arg(c,3,av,3,t0));
t5=C_rest_nullp(c,3);
t6=C_rest_nullp(c,4);
t7=(C_truep(t6)?C_SCHEME_FALSE:C_get_rest_arg(c,4,av,3,t0));
t8=t7;
t9=(*a=C_VECTOR_TYPE|1,a[1]=t8,tmp=(C_word)a,a+=2,tmp);
t10=C_rest_nullp(c,4);
t11=C_i_check_string_2(t2,lf[489]);
t12=C_u_i_string_length(t2);
t13=C_fix(0);
t14=(*a=C_VECTOR_TYPE|1,a[1]=t13,tmp=(C_word)a,a+=2,tmp);
t15=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_15734,a[2]=t9,a[3]=t14,a[4]=t1,a[5]=t4,a[6]=t2,a[7]=t12,tmp=(C_word)a,a+=8,tmp);
if(C_truep(t4)){
t16=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15763,a[2]=t14,a[3]=t4,a[4]=t15,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1889: ##sys#check-range/including */
t17=*((C_word*)lf[435]+1);{
C_word av2[6];
av2[0]=t17;
av2[1]=t16;
av2[2]=t4;
av2[3]=C_fix(0);
av2[4]=t12;
av2[5]=lf[489];
((C_proc)(void*)(*((C_word*)t17+1)))(6,av2);}}
else{
t16=t15;
f_15734(t16,C_SCHEME_UNDEFINED);}}

/* k15732 in scheme#string-copy in k12641 in k11449 */
static void f_15734(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,5)))){
C_save_and_reclaim_args((void *)trf_15734,2,t0,t1);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15737,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)((C_word*)t0)[2])[1])){
/* library.scm:1892: ##sys#check-range/including */
t3=*((C_word*)lf[435]+1);{
C_word av2[6];
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)((C_word*)t0)[2])[1];
av2[3]=C_fix(0);
av2[4]=((C_word*)t0)[7];
av2[5]=lf[489];
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}
else{
t3=C_set_block_item(((C_word*)t0)[2],0,((C_word*)t0)[7]);
t4=t2;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
f_15737(2,av2);}}}

/* k15735 in k15732 in scheme#string-copy in k12641 in k11449 */
static void C_ccall f_15737(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_15737,c,av);}
a=C_alloc(8);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15740,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15753,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
if(C_truep(((C_word*)t0)[5])){
/* library.scm:1894: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[490]+1));
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[490]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[6];
av2[3]=((C_word*)((C_word*)t0)[3])[1];
av2[4]=((C_word*)((C_word*)t0)[2])[1];
tp(5,av2);}}
else{
t4=t2;
f_15740(t4,C_slot(((C_word*)t0)[6],C_fix(0)));}}

/* k15738 in k15735 in k15732 in scheme#string-copy in k12641 in k11449 */
static void f_15740(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,2)))){
C_save_and_reclaim_args((void *)trf_15740,2,t0,t1);}
a=C_alloc(6);
t2=C_block_size(t1);
t3=C_fixnum_difference(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15749,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[4],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* library.scm:1897: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[164]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[164]+1);
av2[1]=t4;
av2[2]=t2;
tp(3,av2);}}

/* k15747 in k15738 in k15735 in k15732 in scheme#string-copy in k12641 in k11449 */
static void C_ccall f_15749(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_15749,c,av);}
a=C_alloc(5);
t2=C_copy_memory(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_ustring(&a,2,t1,((C_word*)t0)[5]);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k15751 in k15735 in k15732 in scheme#string-copy in k12641 in k11449 */
static void C_ccall f_15753(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_15753,c,av);}
t2=((C_word*)t0)[2];
f_15740(t2,C_slot(t1,C_fix(0)));}

/* k15761 in scheme#string-copy in k12641 in k11449 */
static void C_ccall f_15763(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_15763,c,av);}
t2=C_set_block_item(((C_word*)t0)[2],0,((C_word*)t0)[3]);
t3=((C_word*)t0)[4];
f_15734(t3,t2);}

/* scheme#string-copy! in k12641 in k11449 */
static void C_ccall f_15790(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(18,c,5)))){
C_save_and_reclaim((void *)f_15790,c,av);}
a=C_alloc(18);
t5=C_rest_nullp(c,5);
t6=(C_truep(t5)?C_SCHEME_FALSE:C_get_rest_arg(c,5,av,5,t0));
t7=t6;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_rest_nullp(c,5);
t10=C_rest_nullp(c,6);
t11=(C_truep(t10)?C_SCHEME_FALSE:C_get_rest_arg(c,6,av,5,t0));
t12=t11;
t13=(*a=C_VECTOR_TYPE|1,a[1]=t12,tmp=(C_word)a,a+=2,tmp);
t14=C_rest_nullp(c,6);
t15=C_i_check_string_2(t2,lf[492]);
t16=C_i_check_string_2(t4,lf[492]);
t17=C_u_i_string_length(t2);
t18=C_u_i_string_length(t4);
t19=C_fixnum_difference(((C_word*)t13)[1],((C_word*)t8)[1]);
t20=C_i_check_range_2(t3,C_fix(0),t17,lf[492]);
t21=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_15820,a[2]=t2,a[3]=t4,a[4]=t8,a[5]=t3,a[6]=t19,a[7]=t13,a[8]=t1,tmp=(C_word)a,a+=9,tmp);
if(C_truep(((C_word*)t8)[1])){
t22=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15907,a[2]=t13,a[3]=t21,a[4]=t18,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1911: ##sys#check-range/including */
t23=*((C_word*)lf[435]+1);{
C_word av2[6];
av2[0]=t23;
av2[1]=t22;
av2[2]=((C_word*)t8)[1];
av2[3]=C_fix(0);
av2[4]=t18;
av2[5]=lf[492];
((C_proc)(void*)(*((C_word*)t23+1)))(6,av2);}}
else{
t22=C_set_block_item(t8,0,C_fix(0));
t23=t21;{
C_word *av2=av;
av2[0]=t23;
av2[1]=t22;
f_15820(2,av2);}}}

/* k15818 in scheme#string-copy! in k12641 in k11449 */
static void C_ccall f_15820(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_15820,c,av);}
a=C_alloc(6);
t2=C_eqp(((C_word*)t0)[2],((C_word*)t0)[3]);
t3=(C_truep(t2)?C_fixnum_lessp(((C_word*)((C_word*)t0)[4])[1],((C_word*)t0)[5]):C_SCHEME_FALSE);
if(C_truep(t3)){
t4=C_fixnum_plus(((C_word*)t0)[5],((C_word*)t0)[6]);
t5=C_fixnum_difference(t4,C_fix(1));
t6=C_fixnum_difference(((C_word*)((C_word*)t0)[7])[1],C_fix(1));
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15839,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[2],a[5]=((C_word)li377),tmp=(C_word)a,a+=6,tmp);
t8=((C_word*)t0)[8];{
C_word *av2=av;
av2[0]=t8;
av2[1]=(
  f_15839(t7,t5,t6)
);
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15873,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[2],a[5]=((C_word)li378),tmp=(C_word)a,a+=6,tmp);
t5=((C_word*)t0)[8];{
C_word *av2=av;
av2[0]=t5;
av2[1]=(
  f_15873(t4,((C_word*)t0)[5],((C_word*)((C_word*)t0)[4])[1])
);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* doloop2120 in k15818 in scheme#string-copy! in k12641 in k11449 */
static C_word f_15839(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_overflow_check;
loop:{}
if(C_truep(C_fixnum_lessp(t2,((C_word*)((C_word*)t0)[2])[1]))){
t3=C_SCHEME_UNDEFINED;
return(t3);}
else{
t3=C_i_string_ref(((C_word*)t0)[3],t2);
t4=C_i_string_set(((C_word*)t0)[4],t1,t3);
t6=C_fixnum_difference(t1,C_fix(1));
t7=C_fixnum_difference(t2,C_fix(1));
t1=t6;
t2=t7;
goto loop;}}

/* doloop2126 in k15818 in scheme#string-copy! in k12641 in k11449 */
static C_word f_15873(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_overflow_check;
loop:{}
if(C_truep(C_fixnum_greater_or_equal_p(t2,((C_word*)((C_word*)t0)[2])[1]))){
t3=C_SCHEME_UNDEFINED;
return(t3);}
else{
t3=C_i_string_ref(((C_word*)t0)[3],t2);
t4=C_i_string_set(((C_word*)t0)[4],t1,t3);
t6=C_fixnum_plus(t1,C_fix(1));
t7=C_fixnum_plus(t2,C_fix(1));
t1=t6;
t2=t7;
goto loop;}}

/* k15905 in scheme#string-copy! in k12641 in k11449 */
static void C_ccall f_15907(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_15907,c,av);}
if(C_truep(((C_word*)((C_word*)t0)[2])[1])){
/* library.scm:1913: ##sys#check-range/including */
t2=*((C_word*)lf[435]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)((C_word*)t0)[2])[1];
av2[3]=C_fix(0);
av2[4]=((C_word*)t0)[4];
av2[5]=lf[492];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}
else{
t2=C_set_block_item(((C_word*)t0)[2],0,((C_word*)t0)[4]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
f_15820(2,av2);}}}

/* ##sys#substring in k12641 in k11449 */
static void C_ccall f_15941(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_15941,c,av);}
a=C_alloc(6);
t5=C_utf_range(t2,t3,t4);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15945,a[2]=t4,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* library.scm:1928: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[164]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[164]+1);
av2[1]=t6;
av2[2]=C_fixnum_plus(t5,C_fix(1));
tp(3,av2);}}

/* k15943 in ##sys#substring in k12641 in k11449 */
static void C_ccall f_15945(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_15945,c,av);}
a=C_alloc(5);
t2=C_fixnum_difference(((C_word*)t0)[2],((C_word*)t0)[3]);
t3=C_a_ustring(&a,2,t1,t2);
t4=C_utf_copy(((C_word*)t0)[4],t3,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(0));
t5=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t5;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#substring in k12641 in k11449 */
static void C_ccall f_15955(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +6,c,2)))){
C_save_and_reclaim((void*)f_15955,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+6);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
t5=C_i_check_string_2(t2,lf[494]);
t6=C_i_check_fixnum_2(t3,lf[494]);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15965,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=C_SCHEME_UNDEFINED,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_i_pairp(t4))){
t8=C_get_rest_arg(c,4,av,4,t0);
t9=C_i_check_fixnum_2(t8,lf[494]);
t10=t7;
f_15965(t10,t8);}
else{
t8=t7;
f_15965(t8,C_u_i_string_length(t2));}}

/* k15963 in scheme#substring in k12641 in k11449 */
static void f_15965(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,0,2)))){
C_save_and_reclaim_args((void *)trf_15965,2,t0,t1);}
a=C_alloc(3);
t2=C_mutate(((C_word *)t0)+5,t1);
t3=C_u_i_string_length(((C_word*)t0)[3]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15972,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_fixnum_less_or_equal_p(((C_word*)t0)[4],((C_word*)t0)[5]))){
t5=C_fixnum_greater_or_equal_p(((C_word*)t0)[4],C_fix(0));
t6=t4;
f_15972(t6,(C_truep(t5)?C_fixnum_less_or_equal_p(((C_word*)t0)[5],t3):C_SCHEME_FALSE));}
else{
t5=t4;
f_15972(t5,C_SCHEME_FALSE);}}

/* k15970 in k15963 in scheme#substring in k12641 in k11449 */
static void f_15972(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,5)))){
C_save_and_reclaim_args((void *)trf_15972,2,t0,t1);}
t2=((C_word*)t0)[2];
if(C_truep(t1)){
/* library.scm:1946: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[490]+1));
C_word av2[5];
av2[0]=*((C_word*)lf[490]+1);
av2[1]=((C_word*)t2)[2];
av2[2]=((C_word*)t2)[3];
av2[3]=((C_word*)t2)[4];
av2[4]=((C_word*)t2)[5];
tp(5,av2);}}
else{
t3=C_fix((C_word)C_OUT_OF_BOUNDS_ERROR);
/* library.scm:1947: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word av2[6];
av2[0]=*((C_word*)lf[443]+1);
av2[1]=((C_word*)t2)[2];
av2[2]=t3;
av2[3]=lf[494];
av2[4]=((C_word*)t2)[3];
av2[5]=((C_word*)t2)[4];
tp(6,av2);}}}

/* compare in k12641 in k11449 */
static void f_16000(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,4)))){
C_save_and_reclaim_args((void *)trf_16000,6,t1,t2,t3,t4,t5,t6);}
a=C_alloc(7);
t7=C_i_check_string_2(t2,t5);
t8=C_i_check_string_2(t3,t5);
t9=C_u_i_string_length(t2);
t10=C_u_i_string_length(t3);
t11=C_fixnum_lessp(t9,t10);
t12=(C_truep(t11)?t9:t10);
t13=C_utf_compare(t2,t3,C_fix(0),C_fix(0),t12);
t14=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_16020,a[2]=t4,a[3]=t6,a[4]=t1,a[5]=t3,a[6]=t10,tmp=(C_word)a,a+=7,tmp);
t15=C_fixnum_lessp(t9,t10);
t16=(C_truep(t15)?t9:t10);
/* library.scm:1961: cmp */
t17=t6;{
C_word av2[5];
av2[0]=t17;
av2[1]=t14;
av2[2]=C_utf_compare(t2,t3,C_fix(0),C_fix(0),t16);
av2[3]=t9;
av2[4]=t10;
((C_proc)C_fast_retrieve_proc(t17))(5,av2);}}

/* k16018 in compare in k12641 in k11449 */
static void C_ccall f_16020(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,6)))){
C_save_and_reclaim((void *)f_16020,c,av);}
a=C_alloc(8);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_16022,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word)li382),tmp=(C_word)a,a+=6,tmp));
t5=((C_word*)t3)[1];
f_16022(t5,((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[2],t1);}

/* loop in k16018 in compare in k12641 in k11449 */
static void f_16022(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(7,0,5)))){
C_save_and_reclaim_args((void *)trf_16022,6,t0,t1,t2,t3,t4,t5);}
a=C_alloc(7);
if(C_truep(C_i_nullp(t4))){
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_slot(((C_word*)t0)[2],C_fix(0));
t7=C_i_string_length(t6);
t8=C_fixnum_lessp(t3,t7);
t9=(C_truep(t8)?t3:t7);
t10=C_utf_compare_ci(t2,t6,C_fix(0),C_fix(0),t9);
t11=C_slot(((C_word*)t0)[2],C_fix(1));
t12=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_16050,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t6,a[5]=t7,a[6]=t11,tmp=(C_word)a,a+=7,tmp);
if(C_truep(t5)){
/* library.scm:1973: cmp */
t13=((C_word*)t0)[4];{
C_word av2[5];
av2[0]=t13;
av2[1]=t12;
av2[2]=t10;
av2[3]=t3;
av2[4]=t7;
((C_proc)C_fast_retrieve_proc(t13))(5,av2);}}
else{
/* library.scm:1972: loop */
t14=t1;
t15=t6;
t16=t7;
t17=t11;
t18=C_SCHEME_FALSE;
t1=t14;
t2=t15;
t3=t16;
t4=t17;
t5=t18;
goto loop;}}}

/* k16048 in loop in k16018 in compare in k12641 in k11449 */
static void C_ccall f_16050(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_16050,c,av);}
/* library.scm:1972: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_16022(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],t1);}

/* scheme#string<? in k12641 in k11449 */
static void C_ccall f_16069(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,6)))){
C_save_and_reclaim((void*)f_16069,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16075,a[2]=((C_word)li384),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1975: compare */
f_16000(t1,t2,t3,t4,lf[496],t5);}

/* a16074 in scheme#string<? in k12641 in k11449 */
static void C_ccall f_16075(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16075,c,av);}
t5=C_fixnum_lessp(t2,C_fix(0));
if(C_truep(t5)){
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_fixnum_lessp(t3,t4);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?C_eqp(t2,C_fix(0)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* scheme#string>? in k12641 in k11449 */
static void C_ccall f_16093(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,6)))){
C_save_and_reclaim((void*)f_16093,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16099,a[2]=((C_word)li386),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1982: compare */
f_16000(t1,t2,t3,t4,lf[498],t5);}

/* a16098 in scheme#string>? in k12641 in k11449 */
static void C_ccall f_16099(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16099,c,av);}
t5=C_fixnum_greaterp(t2,C_fix(0));
if(C_truep(t5)){
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_fixnum_lessp(t4,t3);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?C_eqp(t2,C_fix(0)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* scheme#string<=? in k12641 in k11449 */
static void C_ccall f_16117(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,6)))){
C_save_and_reclaim((void*)f_16117,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16123,a[2]=((C_word)li388),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1989: compare */
f_16000(t1,t2,t3,t4,lf[500],t5);}

/* a16122 in scheme#string<=? in k12641 in k11449 */
static void C_ccall f_16123(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16123,c,av);}
t5=C_eqp(t2,C_fix(0));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(C_truep(t5)?C_fixnum_less_or_equal_p(t3,t4):C_fixnum_lessp(t2,C_fix(0)));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* scheme#string>=? in k12641 in k11449 */
static void C_ccall f_16138(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,6)))){
C_save_and_reclaim((void*)f_16138,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16144,a[2]=((C_word)li390),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1996: compare */
f_16000(t1,t2,t3,t4,lf[502],t5);}

/* a16143 in scheme#string>=? in k12641 in k11449 */
static void C_ccall f_16144(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16144,c,av);}
t5=C_eqp(t2,C_fix(0));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(C_truep(t5)?C_fixnum_greater_or_equal_p(t3,t4):C_fixnum_greaterp(t2,C_fix(0)));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* compare in k12641 in k11449 */
static void f_16158(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,4)))){
C_save_and_reclaim_args((void *)trf_16158,6,t1,t2,t3,t4,t5,t6);}
a=C_alloc(7);
t7=C_i_check_string_2(t2,t5);
t8=C_i_check_string_2(t3,t5);
t9=C_u_i_string_length(t2);
t10=C_u_i_string_length(t3);
t11=C_fixnum_lessp(t9,t10);
t12=(C_truep(t11)?t9:t10);
t13=C_utf_compare_ci(t2,t3,C_fix(0),C_fix(0),t12);
t14=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_16178,a[2]=t6,a[3]=t1,a[4]=t3,a[5]=t10,a[6]=t4,tmp=(C_word)a,a+=7,tmp);
/* library.scm:2013: cmp */
t15=t6;{
C_word av2[5];
av2[0]=t15;
av2[1]=t14;
av2[2]=t13;
av2[3]=t9;
av2[4]=t10;
((C_proc)C_fast_retrieve_proc(t15))(5,av2);}}

/* k16176 in compare in k12641 in k11449 */
static void C_ccall f_16178(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,6)))){
C_save_and_reclaim((void *)f_16178,c,av);}
a=C_alloc(7);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16180,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=((C_word)li392),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_16180(t5,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],t1);}

/* loop in k16176 in compare in k12641 in k11449 */
static void f_16180(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(7,0,5)))){
C_save_and_reclaim_args((void *)trf_16180,6,t0,t1,t2,t3,t4,t5);}
a=C_alloc(7);
if(C_truep(C_i_nullp(t4))){
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_slot(t4,C_fix(0));
t7=C_i_string_length(t6);
t8=C_fixnum_lessp(t3,t7);
t9=(C_truep(t8)?t3:t7);
t10=C_utf_compare_ci(t2,t6,C_fix(0),C_fix(0),t9);
t11=C_slot(t4,C_fix(1));
t12=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_16208,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t6,a[5]=t7,a[6]=t11,tmp=(C_word)a,a+=7,tmp);
if(C_truep(t5)){
/* library.scm:2022: cmp */
t13=((C_word*)t0)[3];{
C_word av2[5];
av2[0]=t13;
av2[1]=t12;
av2[2]=t10;
av2[3]=t3;
av2[4]=t7;
((C_proc)C_fast_retrieve_proc(t13))(5,av2);}}
else{
/* library.scm:2021: loop */
t14=t1;
t15=t6;
t16=t7;
t17=t11;
t18=C_SCHEME_FALSE;
t1=t14;
t2=t15;
t3=t16;
t4=t17;
t5=t18;
goto loop;}}}

/* k16206 in loop in k16176 in compare in k12641 in k11449 */
static void C_ccall f_16208(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_16208,c,av);}
/* library.scm:2021: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_16180(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],t1);}

/* scheme#string-ci<? in k12641 in k11449 */
static void C_ccall f_16219(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,6)))){
C_save_and_reclaim((void*)f_16219,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16225,a[2]=((C_word)li394),tmp=(C_word)a,a+=3,tmp);
/* library.scm:2024: compare */
f_16158(t1,t2,t3,t4,lf[504],t5);}

/* a16224 in scheme#string-ci<? in k12641 in k11449 */
static void C_ccall f_16225(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16225,c,av);}
t5=C_fixnum_lessp(t2,C_fix(0));
if(C_truep(t5)){
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_fixnum_lessp(t3,t4);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?C_eqp(t2,C_fix(0)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* scheme#string-ci>? in k12641 in k11449 */
static void C_ccall f_16243(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,6)))){
C_save_and_reclaim((void*)f_16243,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16249,a[2]=((C_word)li396),tmp=(C_word)a,a+=3,tmp);
/* library.scm:2031: compare */
f_16158(t1,t2,t3,t4,lf[506],t5);}

/* a16248 in scheme#string-ci>? in k12641 in k11449 */
static void C_ccall f_16249(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16249,c,av);}
t5=C_fixnum_greaterp(t2,C_fix(0));
if(C_truep(t5)){
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_fixnum_lessp(t4,t3);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?C_eqp(t2,C_fix(0)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* scheme#string-ci<=? in k12641 in k11449 */
static void C_ccall f_16267(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,6)))){
C_save_and_reclaim((void*)f_16267,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16273,a[2]=((C_word)li398),tmp=(C_word)a,a+=3,tmp);
/* library.scm:2038: compare */
f_16158(t1,t2,t3,t4,lf[508],t5);}

/* a16272 in scheme#string-ci<=? in k12641 in k11449 */
static void C_ccall f_16273(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16273,c,av);}
t5=C_eqp(t2,C_fix(0));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(C_truep(t5)?C_fixnum_less_or_equal_p(t3,t4):C_fixnum_lessp(t2,C_fix(0)));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* scheme#string-ci>=? in k12641 in k11449 */
static void C_ccall f_16288(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,6)))){
C_save_and_reclaim((void*)f_16288,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16294,a[2]=((C_word)li400),tmp=(C_word)a,a+=3,tmp);
/* library.scm:2045: compare */
f_16158(t1,t2,t3,t4,lf[510],t5);}

/* a16293 in scheme#string-ci>=? in k12641 in k11449 */
static void C_ccall f_16294(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16294,c,av);}
t5=C_eqp(t2,C_fix(0));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(C_truep(t5)?C_fixnum_greater_or_equal_p(t3,t4):C_fixnum_greaterp(t2,C_fix(0)));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* ##sys#string-append in k12641 in k11449 */
static void C_ccall f_16309(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_16309,c,av);}
a=C_alloc(9);
t4=C_slot(t2,C_fix(0));
t5=C_slot(t3,C_fix(0));
t6=C_block_size(t4);
t7=C_fixnum_difference(t6,C_fix(1));
t8=C_block_size(t5);
t9=C_fixnum_difference(t8,C_fix(1));
t10=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_16325,a[2]=t4,a[3]=t7,a[4]=t5,a[5]=t9,a[6]=t2,a[7]=t3,a[8]=t1,tmp=(C_word)a,a+=9,tmp);
t11=C_fixnum_plus(t9,C_fix(1));
/* library.scm:2057: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[164]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[164]+1);
av2[1]=t10;
av2[2]=C_fixnum_plus(t7,t11);
av2[3]=C_fix(0);
tp(4,av2);}}

/* k16323 in ##sys#string-append in k12641 in k11449 */
static void C_ccall f_16325(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_16325,c,av);}
a=C_alloc(5);
t2=C_copy_memory_with_offset(t1,((C_word*)t0)[2],C_fix(0),C_fix(0),((C_word*)t0)[3]);
t3=C_copy_memory_with_offset(t1,((C_word*)t0)[4],((C_word*)t0)[3],C_fix(0),((C_word*)t0)[5]);
t4=C_slot(((C_word*)t0)[6],C_fix(1));
t5=C_slot(((C_word*)t0)[7],C_fix(1));
t6=C_fixnum_plus(t4,t5);
t7=((C_word*)t0)[8];{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_a_ustring(&a,2,t1,t6);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* scheme#string-append in k12641 in k11449 */
static void C_ccall f_16355(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +17,c,5)))){
C_save_and_reclaim((void*)f_16355,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+17);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t3=C_SCHEME_FALSE;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_fix(0);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16359,a[2]=t1,a[3]=t4,a[4]=t6,tmp=(C_word)a,a+=5,tmp);
t8=C_SCHEME_UNDEFINED;
t9=(*a=C_VECTOR_TYPE|1,a[1]=t8,tmp=(C_word)a,a+=2,tmp);
t10=C_set_block_item(t9,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_16361,a[2]=t4,a[3]=t6,a[4]=t9,a[5]=((C_word)li403),tmp=(C_word)a,a+=6,tmp));
t11=((C_word*)t9)[1];
f_16361(t11,t7,t2,C_fix(0),C_fix(0));}

/* k16357 in scheme#string-append in k12641 in k11449 */
static void C_ccall f_16359(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_16359,c,av);}
a=C_alloc(5);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_ustring(&a,2,((C_word*)((C_word*)t0)[3])[1],((C_word*)((C_word*)t0)[4])[1]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* loop in scheme#string-append in k12641 in k11449 */
static void f_16361(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(7,0,4)))){
C_save_and_reclaim_args((void *)trf_16361,5,t0,t1,t2,t3,t4);}
a=C_alloc(7);
t5=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_16372,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t4,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* library.scm:2069: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[164]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[164]+1);
av2[1]=t6;
av2[2]=C_fixnum_plus(t3,C_fix(1));
av2[3]=C_fix(0);
tp(4,av2);}}
else{
t6=C_slot(t2,C_fix(0));
t7=C_i_check_string_2(t6,lf[513]);
t8=C_slot(t6,C_fix(0));
t9=C_block_size(t8);
t10=C_fixnum_difference(t9,C_fix(1));
t11=C_slot(t6,C_fix(1));
t12=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_16395,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t8,a[5]=t3,a[6]=t10,tmp=(C_word)a,a+=7,tmp);
/* library.scm:2077: loop */
t14=t12;
t15=C_slot(t2,C_fix(1));
t16=C_fixnum_plus(t3,t10);
t17=C_fixnum_plus(t4,t11);
t1=t14;
t2=t15;
t3=t16;
t4=t17;
goto loop;}}

/* k16370 in loop in scheme#string-append in k12641 in k11449 */
static void C_ccall f_16372(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16372,c,av);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,t1);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)t0)[4]);
t4=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k16393 in loop in scheme#string-append in k12641 in k11449 */
static void C_ccall f_16395(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16395,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_copy_memory_with_offset(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[4],((C_word*)t0)[5],C_fix(0),((C_word*)t0)[6]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* scheme#string in k12641 in k11449 */
static void C_ccall f_16413(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +0,c,2)))){
C_save_and_reclaim((void*)f_16413,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+0);
t2=C_build_rest(&a,c,2,av);
C_word t3;
/* ##sys#list->string */
t3=*((C_word*)lf[483]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* ##sys#char->utf8-string in k12641 in k11449 */
static void C_ccall f_16419(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,1)))){
C_save_and_reclaim((void *)f_16419,c,av);}
a=C_alloc(8);
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_string(&a,1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#chop in k12641 in k11449 */
static void C_ccall f_16425(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,4)))){
C_save_and_reclaim((void *)f_16425,c,av);}
a=C_alloc(5);
t4=C_i_check_fixnum_2(t3,lf[517]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16432,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnum_less_or_equal_p(t3,C_fix(0)))){
/* library.scm:2092: ##sys#error */
t6=*((C_word*)lf[206]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=lf[517];
av2[3]=lf[518];
av2[4]=t3;
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}
else{
t6=t5;{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_SCHEME_UNDEFINED;
f_16432(2,av2);}}}

/* k16430 in chicken.base#chop in k12641 in k11449 */
static void C_ccall f_16432(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_16432,c,av);}
a=C_alloc(7);
t2=C_i_length(((C_word*)t0)[2]);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16440,a[2]=((C_word*)t0)[3],a[3]=t4,a[4]=((C_word)li408),tmp=(C_word)a,a+=5,tmp));
t6=((C_word*)t4)[1];
f_16440(t6,((C_word*)t0)[4],((C_word*)t0)[2],t2);}

/* loop in k16430 in chicken.base#chop in k12641 in k11449 */
static void f_16440(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,0,5)))){
C_save_and_reclaim_args((void *)trf_16440,4,t0,t1,t2,t3);}
a=C_alloc(9);
if(C_truep(C_i_nullp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
if(C_truep(C_fixnum_lessp(t3,((C_word*)t0)[2]))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_a_i_list1(&a,1,t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_16461,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t5,a[6]=((C_word)li407),tmp=(C_word)a,a+=7,tmp));
t7=((C_word*)t5)[1];
f_16461(t7,t1,C_SCHEME_END_OF_LIST,t2,((C_word*)t0)[2]);}}}

/* doloop2312 in loop in k16430 in chicken.base#chop in k12641 in k11449 */
static void f_16461(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(7,0,4)))){
C_save_and_reclaim_args((void *)trf_16461,5,t0,t1,t2,t3,t4);}
a=C_alloc(7);
t5=C_eqp(t4,C_fix(0));
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_16475,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t3,a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
/* library.scm:2102: scheme#reverse */
t7=*((C_word*)lf[50]+1);{
C_word av2[3];
av2[0]=t7;
av2[1]=t6;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}
else{
t6=C_slot(t3,C_fix(0));
t7=C_a_i_cons(&a,2,t6,t2);
t9=t1;
t10=t7;
t11=C_slot(t3,C_fix(1));
t12=C_fixnum_difference(t4,C_fix(1));
t1=t9;
t2=t10;
t3=t11;
t4=t12;
goto loop;}}

/* k16473 in doloop2312 in loop in k16430 in chicken.base#chop in k12641 in k11449 */
static void C_ccall f_16475(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_16475,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16479,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2102: loop */
t3=((C_word*)((C_word*)t0)[3])[1];
f_16440(t3,t2,((C_word*)t0)[4],C_fixnum_difference(((C_word*)t0)[5],((C_word*)t0)[6]));}

/* k16477 in k16473 in doloop2312 in loop in k16430 in chicken.base#chop in k12641 in k11449 */
static void C_ccall f_16479(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_16479,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp+ in k12641 in k11449 */
static void C_ccall f_16520(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_16520,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16542,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_flonum(&a,C_ub_i_flonum_plus(C_flonum_magnitude(t2),C_flonum_magnitude(t3)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2133: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[531];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k16540 in chicken.flonum#fp+ in k12641 in k11449 */
static void C_ccall f_16542(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16542,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_ub_i_flonum_plus(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp- in k12641 in k11449 */
static void C_ccall f_16544(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_16544,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16566,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_flonum(&a,C_ub_i_flonum_difference(C_flonum_magnitude(t2),C_flonum_magnitude(t3)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2133: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[533];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k16564 in chicken.flonum#fp- in k12641 in k11449 */
static void C_ccall f_16566(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16566,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_ub_i_flonum_difference(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp* in k12641 in k11449 */
static void C_ccall f_16568(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_16568,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16590,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_flonum(&a,C_ub_i_flonum_times(C_flonum_magnitude(t2),C_flonum_magnitude(t3)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2133: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[535];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k16588 in chicken.flonum#fp* in k12641 in k11449 */
static void C_ccall f_16590(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16590,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_ub_i_flonum_times(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp/ in k12641 in k11449 */
static void C_ccall f_16592(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_16592,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16614,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_flonum(&a,C_ub_i_flonum_quotient(C_flonum_magnitude(t2),C_flonum_magnitude(t3)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2133: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[537];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k16612 in chicken.flonum#fp/ in k12641 in k11449 */
static void C_ccall f_16614(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16614,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_ub_i_flonum_quotient(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp*+ in k12641 in k11449 */
static void C_ccall f_16616(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(13,c,2)))){
C_save_and_reclaim((void *)f_16616,c,av);}
a=C_alloc(13);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_16620,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_16623,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,a[6]=t5,tmp=(C_word)a,a+=7,tmp);
if(C_truep(C_i_flonump(t2))){
t7=C_i_flonump(t3);
t8=t6;
f_16623(t8,(C_truep(t7)?C_i_flonump(t4):C_SCHEME_FALSE));}
else{
t7=t6;
f_16623(t7,C_SCHEME_FALSE);}}

/* k16618 in chicken.flonum#fp*+ in k12641 in k11449 */
static void C_ccall f_16620(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16620,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_ub_i_flonum_multiply_add(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]),C_flonum_magnitude(((C_word*)t0)[5])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k16621 in chicken.flonum#fp*+ in k12641 in k11449 */
static void f_16623(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,6)))){
C_save_and_reclaim_args((void *)trf_16623,2,t0,t1);}
a=C_alloc(4);
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_flonum(&a,C_ub_i_flonum_multiply_add(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]),C_flonum_magnitude(((C_word*)t0)[5])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2153: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word av2[7];
av2[0]=*((C_word*)lf[443]+1);
av2[1]=((C_word*)t0)[6];
av2[2]=t2;
av2[3]=lf[539];
av2[4]=((C_word*)t0)[3];
av2[5]=((C_word*)t0)[4];
av2[6]=((C_word*)t0)[5];
tp(7,av2);}}}

/* chicken.flonum#fpgcd in k12641 in k11449 */
static void C_ccall f_16641(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_16641,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16663,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_a_i_flonum_gcd(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2133: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[541];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k16661 in chicken.flonum#fpgcd in k12641 in k11449 */
static void C_ccall f_16663(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16663,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_flonum_gcd(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp/? in k12641 in k11449 */
static void C_ccall f_16665(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_16665,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16687,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_a_i_flonum_quotient_checked(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2133: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[543];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k16685 in chicken.flonum#fp/? in k12641 in k11449 */
static void C_ccall f_16687(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16687,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_flonum_quotient_checked(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp= in k12641 in k11449 */
static void C_ccall f_16689(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_16689,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16711,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_ub_i_flonum_equalp(C_flonum_magnitude(t2),C_flonum_magnitude(t3));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2133: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[545];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k16709 in chicken.flonum#fp= in k12641 in k11449 */
static void C_ccall f_16711(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16711,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_ub_i_flonum_equalp(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp> in k12641 in k11449 */
static void C_ccall f_16713(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_16713,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16735,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_ub_i_flonum_greaterp(C_flonum_magnitude(t2),C_flonum_magnitude(t3));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2133: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[547];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k16733 in chicken.flonum#fp> in k12641 in k11449 */
static void C_ccall f_16735(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16735,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_ub_i_flonum_greaterp(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp< in k12641 in k11449 */
static void C_ccall f_16737(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_16737,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16759,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_ub_i_flonum_lessp(C_flonum_magnitude(t2),C_flonum_magnitude(t3));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2133: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[549];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k16757 in chicken.flonum#fp< in k12641 in k11449 */
static void C_ccall f_16759(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16759,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_ub_i_flonum_lessp(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp>= in k12641 in k11449 */
static void C_ccall f_16761(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_16761,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16783,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_ub_i_flonum_greater_or_equal_p(C_flonum_magnitude(t2),C_flonum_magnitude(t3));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2133: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[551];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k16781 in chicken.flonum#fp>= in k12641 in k11449 */
static void C_ccall f_16783(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16783,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_ub_i_flonum_greater_or_equal_p(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp<= in k12641 in k11449 */
static void C_ccall f_16785(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_16785,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16807,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_ub_i_flonum_less_or_equal_p(C_flonum_magnitude(t2),C_flonum_magnitude(t3));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2133: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[553];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k16805 in chicken.flonum#fp<= in k12641 in k11449 */
static void C_ccall f_16807(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16807,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_ub_i_flonum_less_or_equal_p(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpneg in k12641 in k11449 */
static void C_ccall f_16809(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_16809,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16825,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_flonum_negate(&a,1,t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2129: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[555];
av2[4]=t2;
tp(5,av2);}}}

/* k16823 in chicken.flonum#fpneg in k12641 in k11449 */
static void C_ccall f_16825(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16825,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_flonum_negate(&a,1,((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpmax in k12641 in k11449 */
static void C_ccall f_16827(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_16827,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16849,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_i_flonum_max(t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2133: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[557];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k16847 in chicken.flonum#fpmax in k12641 in k11449 */
static void C_ccall f_16849(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16849,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_i_flonum_max(((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpmin in k12641 in k11449 */
static void C_ccall f_16851(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_16851,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16873,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_i_flonum_min(t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2133: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[559];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k16871 in chicken.flonum#fpmin in k12641 in k11449 */
static void C_ccall f_16873(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16873,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_i_flonum_min(((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpfloor in k12641 in k11449 */
static void C_ccall f_16875(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_16875,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16891,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_floor(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2129: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[561];
av2[4]=t2;
tp(5,av2);}}}

/* k16889 in chicken.flonum#fpfloor in k12641 in k11449 */
static void C_ccall f_16891(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16891,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_floor(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fptruncate in k12641 in k11449 */
static void C_ccall f_16893(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_16893,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16909,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_trunc(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2129: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[563];
av2[4]=t2;
tp(5,av2);}}}

/* k16907 in chicken.flonum#fptruncate in k12641 in k11449 */
static void C_ccall f_16909(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16909,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_trunc(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpround in k12641 in k11449 */
static void C_ccall f_16911(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_16911,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16927,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_round(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2129: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[565];
av2[4]=t2;
tp(5,av2);}}}

/* k16925 in chicken.flonum#fpround in k12641 in k11449 */
static void C_ccall f_16927(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16927,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_round(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpceiling in k12641 in k11449 */
static void C_ccall f_16929(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_16929,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16945,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_ceil(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2129: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[567];
av2[4]=t2;
tp(5,av2);}}}

/* k16943 in chicken.flonum#fpceiling in k12641 in k11449 */
static void C_ccall f_16945(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16945,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_ceil(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpsin in k12641 in k11449 */
static void C_ccall f_16947(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_16947,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16963,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_sin(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2129: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[569];
av2[4]=t2;
tp(5,av2);}}}

/* k16961 in chicken.flonum#fpsin in k12641 in k11449 */
static void C_ccall f_16963(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16963,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_sin(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpcos in k12641 in k11449 */
static void C_ccall f_16965(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_16965,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16981,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_cos(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2129: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[571];
av2[4]=t2;
tp(5,av2);}}}

/* k16979 in chicken.flonum#fpcos in k12641 in k11449 */
static void C_ccall f_16981(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16981,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_cos(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fptan in k12641 in k11449 */
static void C_ccall f_16983(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_16983,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16999,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_tan(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2129: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[573];
av2[4]=t2;
tp(5,av2);}}}

/* k16997 in chicken.flonum#fptan in k12641 in k11449 */
static void C_ccall f_16999(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16999,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_tan(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpasin in k12641 in k11449 */
static void C_ccall f_17001(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_17001,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17017,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_asin(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2129: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[575];
av2[4]=t2;
tp(5,av2);}}}

/* k17015 in chicken.flonum#fpasin in k12641 in k11449 */
static void C_ccall f_17017(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_17017,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_asin(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpacos in k12641 in k11449 */
static void C_ccall f_17019(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_17019,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17035,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_acos(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2129: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[577];
av2[4]=t2;
tp(5,av2);}}}

/* k17033 in chicken.flonum#fpacos in k12641 in k11449 */
static void C_ccall f_17035(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_17035,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_acos(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpatan in k12641 in k11449 */
static void C_ccall f_17037(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_17037,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17053,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_atan(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2129: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[579];
av2[4]=t2;
tp(5,av2);}}}

/* k17051 in chicken.flonum#fpatan in k12641 in k11449 */
static void C_ccall f_17053(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_17053,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_atan(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpatan2 in k12641 in k11449 */
static void C_ccall f_17055(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_17055,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17077,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_flonum(&a,C_atan2(C_flonum_magnitude(t2),C_flonum_magnitude(t3)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2133: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[581];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k17075 in chicken.flonum#fpatan2 in k12641 in k11449 */
static void C_ccall f_17077(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_17077,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_atan2(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpsinh in k12641 in k11449 */
static void C_ccall f_17079(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_17079,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17095,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_sinh(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2129: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[583];
av2[4]=t2;
tp(5,av2);}}}

/* k17093 in chicken.flonum#fpsinh in k12641 in k11449 */
static void C_ccall f_17095(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_17095,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_sinh(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpcosh in k12641 in k11449 */
static void C_ccall f_17097(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_17097,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17113,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_cosh(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2129: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[585];
av2[4]=t2;
tp(5,av2);}}}

/* k17111 in chicken.flonum#fpcosh in k12641 in k11449 */
static void C_ccall f_17113(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_17113,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_cosh(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fptanh in k12641 in k11449 */
static void C_ccall f_17115(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_17115,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17131,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_tanh(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2129: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[587];
av2[4]=t2;
tp(5,av2);}}}

/* k17129 in chicken.flonum#fptanh in k12641 in k11449 */
static void C_ccall f_17131(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_17131,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_tanh(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpasinh in k12641 in k11449 */
static void C_ccall f_17133(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_17133,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17149,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_asinh(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2129: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[589];
av2[4]=t2;
tp(5,av2);}}}

/* k17147 in chicken.flonum#fpasinh in k12641 in k11449 */
static void C_ccall f_17149(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_17149,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_asinh(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpacosh in k12641 in k11449 */
static void C_ccall f_17151(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_17151,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17167,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_acosh(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2129: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[591];
av2[4]=t2;
tp(5,av2);}}}

/* k17165 in chicken.flonum#fpacosh in k12641 in k11449 */
static void C_ccall f_17167(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_17167,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_acosh(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpatanh in k12641 in k11449 */
static void C_ccall f_17169(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_17169,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17185,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_atanh(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2129: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[593];
av2[4]=t2;
tp(5,av2);}}}

/* k17183 in chicken.flonum#fpatanh in k12641 in k11449 */
static void C_ccall f_17185(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_17185,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_atanh(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpexp in k12641 in k11449 */
static void C_ccall f_17187(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_17187,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17203,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_exp(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2129: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[595];
av2[4]=t2;
tp(5,av2);}}}

/* k17201 in chicken.flonum#fpexp in k12641 in k11449 */
static void C_ccall f_17203(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_17203,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_exp(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpexpt in k12641 in k11449 */
static void C_ccall f_17205(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_17205,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17227,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_a_i_flonum_expt(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2133: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[597];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k17225 in chicken.flonum#fpexpt in k12641 in k11449 */
static void C_ccall f_17227(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_17227,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_flonum_expt(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fplog in k12641 in k11449 */
static void C_ccall f_17229(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_17229,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17245,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_log(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2129: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[599];
av2[4]=t2;
tp(5,av2);}}}

/* k17243 in chicken.flonum#fplog in k12641 in k11449 */
static void C_ccall f_17245(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_17245,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_log(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpsqrt in k12641 in k11449 */
static void C_ccall f_17247(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_17247,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17263,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_sqrt(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2129: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[601];
av2[4]=t2;
tp(5,av2);}}}

/* k17261 in chicken.flonum#fpsqrt in k12641 in k11449 */
static void C_ccall f_17263(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_17263,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_sqrt(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpabs in k12641 in k11449 */
static void C_ccall f_17265(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_17265,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17281,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_fabs(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2129: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[603];
av2[4]=t2;
tp(5,av2);}}}

/* k17279 in chicken.flonum#fpabs in k12641 in k11449 */
static void C_ccall f_17281(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_17281,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_fabs(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpinteger? in k12641 in k11449 */
static void C_ccall f_17283(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,4)))){
C_save_and_reclaim((void *)f_17283,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17299,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_fpintegerp(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2129: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[605];
av2[4]=t2;
tp(5,av2);}}}

/* k17297 in chicken.flonum#fpinteger? in k12641 in k11449 */
static void C_ccall f_17299(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17299,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_u_i_fpintegerp(((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#flonum-print-precision in k12641 in k11449 */
static void C_ccall f_17301(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17301,c,av);}
t2=C_rest_nullp(c,2);
t3=(C_truep(t2)?C_SCHEME_FALSE:C_get_rest_arg(c,2,av,2,t0));
t4=C_get_print_precision();
if(C_truep(t3)){
t5=C_i_check_fixnum_2(t3,lf[607]);
t6=C_set_print_precision(t3);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* make-complex in k12641 in k11449 */
static void f_17319(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_17319,3,t1,t2,t3);}
a=C_alloc(5);
t4=C_eqp(t3,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17329,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(t4)){
t6=t5;{
C_word av2[2];
av2[0]=t6;
av2[1]=t4;
f_17329(2,av2);}}
else{
if(C_truep(C_i_flonump(t3))){
/* library.scm:2307: chicken.flonum#fp= */
t6=*((C_word*)lf[544]+1);{
C_word av2[4];
av2[0]=t6;
av2[1]=t5;
av2[2]=t3;
av2[3]=lf[609];
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}
else{
t6=t5;{
C_word av2[2];
av2[0]=t6;
av2[1]=C_SCHEME_FALSE;
f_17329(2,av2);}}}}

/* k17327 in make-complex in k12641 in k11449 */
static void C_ccall f_17329(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_17329,c,av);}
a=C_alloc(3);
if(C_truep(t1)){
t2=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17333,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_inexactp(((C_word*)t0)[3]))){
/* library.scm:2310: scheme#exact->inexact */
t3=*((C_word*)lf[86]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=((C_word*)t0)[2];
f_17333(2,av2);}}}}

/* k17331 in k17327 in make-complex in k12641 in k11449 */
static void C_ccall f_17333(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(14,c,1)))){
C_save_and_reclaim((void *)f_17333,c,av);}
a=C_alloc(14);
t2=((C_word*)t0)[2];
if(C_truep(C_i_inexactp(((C_word*)t2)[2]))){
t3=C_a_i_exact_to_inexact(&a,1,((C_word*)t2)[3]);
t4=C_a_i_cplxnum(&a,2,t1,t3);
t5=((C_word*)t2)[4];{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t3=C_a_i_cplxnum(&a,2,t1,((C_word*)t2)[3]);
t4=((C_word*)t2)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* scheme#make-rectangular in k12641 in k11449 */
static void C_ccall f_17355(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_17355,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17359,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2315: ##sys#check-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[432]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[432]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[611];
tp(4,av2);}}

/* k17357 in scheme#make-rectangular in k12641 in k11449 */
static void C_ccall f_17359(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_17359,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17362,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2316: ##sys#check-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[432]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[432]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=lf[611];
tp(4,av2);}}

/* k17360 in k17357 in scheme#make-rectangular in k12641 in k11449 */
static void C_ccall f_17362(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_17362,c,av);}
t2=((C_word*)t0)[2];
/* library.scm:2317: make-complex */
f_17319(((C_word*)t2)[2],((C_word*)t2)[3],((C_word*)t2)[4]);}

/* scheme#make-polar in k12641 in k11449 */
static void C_ccall f_17367(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_17367,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17371,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2321: ##sys#check-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[432]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[432]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[613];
tp(4,av2);}}

/* k17369 in scheme#make-polar in k12641 in k11449 */
static void C_ccall f_17371(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_17371,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17374,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2322: ##sys#check-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[432]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[432]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=lf[613];
tp(4,av2);}}

/* k17372 in k17369 in scheme#make-polar in k12641 in k11449 */
static void C_ccall f_17374(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_17374,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17377,a[2]=((C_word*)t2)[2],a[3]=((C_word*)t2)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2323: scheme#exact->inexact */
t4=*((C_word*)lf[86]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t2)[4];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k17375 in k17372 in k17369 in scheme#make-polar in k12641 in k11449 */
static void C_ccall f_17377(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(74,c,3)))){
C_save_and_reclaim((void *)f_17377,c,av);}
a=C_alloc(74);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],C_a_i_cos(&a,1,t1));
t3=C_s_a_i_times(&a,2,((C_word*)t0)[2],C_a_i_sin(&a,1,t1));
/* library.scm:2324: make-complex */
f_17319(((C_word*)t0)[3],t2,t3);}

/* scheme#real-part in k12641 in k11449 */
static void C_ccall f_17390(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_17390,c,av);}
if(C_truep(C_i_cplxnump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_u_i_cplxnum_real(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_numberp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* library.scm:2332: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[444]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[444]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[615];
tp(4,av2);}}}}

/* scheme#imag-part in k12641 in k11449 */
static void C_ccall f_17413(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_17413,c,av);}
if(C_truep(C_i_cplxnump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_u_i_cplxnum_imag(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=lf[609];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_numberp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_fix(0);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* library.scm:2339: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[444]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[444]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[617];
tp(4,av2);}}}}}

/* scheme#angle in k12641 in k11449 */
static void C_ccall f_17439(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_17439,c,av);}
a=C_alloc(4);
t3=C_i_check_number_2(t2,lf[619]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17448,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2345: scheme#imag-part */
t5=*((C_word*)lf[616]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}

/* k17446 in scheme#angle in k12641 in k11449 */
static void C_ccall f_17448(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,c,2)))){
C_save_and_reclaim((void *)f_17448,c,av);}
a=C_alloc(15);
t2=C_a_i_exact_to_inexact(&a,1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17453,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2346: scheme#real-part */
t4=*((C_word*)lf[614]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k17451 in k17446 in scheme#angle in k12641 in k11449 */
static void C_ccall f_17453(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,c,1)))){
C_save_and_reclaim((void *)f_17453,c,av);}
a=C_alloc(15);
t2=C_a_i_exact_to_inexact(&a,1,t1);
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_atan2(&a,2,((C_word*)t0)[3],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#magnitude in k12641 in k11449 */
static void C_ccall f_17455(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(95,c,3)))){
C_save_and_reclaim((void *)f_17455,c,av);}
a=C_alloc(95);
if(C_truep(C_i_cplxnump(t2))){
t3=C_u_i_cplxnum_real(t2);
t4=C_u_i_cplxnum_imag(t2);
t5=C_s_a_i_times(&a,2,t3,t3);
t6=C_s_a_i_times(&a,2,t4,t4);
t7=C_s_a_i_plus(&a,2,t5,t6);
/* library.scm:2353: scheme#sqrt */
t8=*((C_word*)lf[621]+1);{
C_word *av2=av;
av2[0]=t8;
av2[1]=t1;
av2[2]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(3,av2);}}
else{
if(C_truep(C_i_numberp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_i_abs(&a,1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* library.scm:2355: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[444]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[444]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[622];
tp(4,av2);}}}}

/* ratnum in k12641 in k11449 */
static C_word f_17499(C_word *a,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_stack_overflow_check;{}
switch(t2){
case C_fix(1):
return(t1);
case C_fix(-1):
return(C_s_a_u_i_integer_negate(&a,1,t1));
default:
if(C_truep(C_i_negativep(t2))){
t3=C_s_a_u_i_integer_negate(&a,1,t1);
t4=C_s_a_u_i_integer_negate(&a,1,t2);
return(C_a_i_ratnum(&a,2,t3,t4));}
else{
return(C_a_i_ratnum(&a,2,t1,t2));}}}

/* scheme#numerator in k12641 in k11449 */
static void C_ccall f_17545(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_17545,c,av);}
a=C_alloc(6);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
if(C_truep(C_i_not(C_i_finitep(t2)))){
/* library.scm:2375: ##sys#error-bad-inexact */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[445]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[445]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[625];
tp(4,av2);}}
else{
if(C_truep(C_u_i_fpintegerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17568,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17572,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2377: scheme#inexact->exact */
t5=*((C_word*)lf[626]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_u_i_ratnum_num(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* library.scm:2379: ##sys#signal-hook */
t3=*((C_word*)lf[245]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=lf[305];
av2[3]=lf[625];
av2[4]=lf[627];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}}}}

/* k17566 in scheme#numerator in k12641 in k11449 */
static void C_ccall f_17568(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,1)))){
C_save_and_reclaim((void *)f_17568,c,av);}
a=C_alloc(11);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_exact_to_inexact(&a,1,t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k17570 in scheme#numerator in k12641 in k11449 */
static void C_ccall f_17572(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_17572,c,av);}
/* library.scm:2377: scheme#numerator */
t2=*((C_word*)lf[624]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* scheme#denominator in k12641 in k11449 */
static void C_ccall f_17590(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_17590,c,av);}
a=C_alloc(6);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_fix(1);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
if(C_truep(C_i_not(C_i_finitep(t2)))){
/* library.scm:2388: ##sys#error-bad-inexact */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[445]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[445]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[629];
tp(4,av2);}}
else{
if(C_truep(C_u_i_fpintegerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=lf[630];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17613,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17617,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2390: scheme#inexact->exact */
t5=*((C_word*)lf[626]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_u_i_ratnum_denom(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* library.scm:2392: ##sys#signal-hook */
t3=*((C_word*)lf[245]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=lf[305];
av2[3]=lf[625];
av2[4]=lf[631];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}}}}

/* k17611 in scheme#denominator in k12641 in k11449 */
static void C_ccall f_17613(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,1)))){
C_save_and_reclaim((void *)f_17613,c,av);}
a=C_alloc(11);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_exact_to_inexact(&a,1,t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k17615 in scheme#denominator in k12641 in k11449 */
static void C_ccall f_17617(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_17617,c,av);}
/* library.scm:2390: scheme#denominator */
t2=*((C_word*)lf[628]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* ##sys#extended-signum in k12641 in k11449 */
static void C_ccall f_17635(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(26,c,3)))){
C_save_and_reclaim((void *)f_17635,c,av);}
a=C_alloc(26);
if(C_truep(C_i_ratnump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_u_i_integer_signum(C_u_i_ratnum_num(t2));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_cplxnump(t2))){
t3=C_u_i_cplxnum_imag(t2);
t4=C_a_i_exact_to_inexact(&a,1,t3);
t5=C_u_i_cplxnum_real(t2);
t6=C_a_i_exact_to_inexact(&a,1,t5);
t7=C_flonum(&a,C_atan2(C_flonum_magnitude(t4),C_flonum_magnitude(t6)));
/* library.scm:2400: scheme#make-polar */
t8=*((C_word*)lf[612]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t8;
av2[1]=t1;
av2[2]=C_fix(1);
av2[3]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}
else{
/* library.scm:2401: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[444]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[444]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[633];
tp(4,av2);}}}}

/* doloop2883 in deliver in scheme#inexact->exact in k12641 in k11449 */
static void f_17676(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_17676,4,t0,t1,t2,t3);}
a=C_alloc(5);
if(C_truep(C_u_i_fpintegerp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17687,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2409: chicken.flonum#fp* */
t5=*((C_word*)lf[534]+1);{
C_word av2[4];
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[637];
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}}

/* k17685 in doloop2883 in deliver in scheme#inexact->exact in k12641 in k11449 */
static void C_ccall f_17687(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_17687,c,av);}
t2=((C_word*)((C_word*)t0)[2])[1];
f_17676(t2,((C_word*)t0)[3],t1,C_fixnum_plus(((C_word*)t0)[4],C_fix(1)));}

/* deliver in scheme#inexact->exact in k12641 in k11449 */
static void f_17693(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(16,0,4)))){
C_save_and_reclaim_args((void *)trf_17693,4,t0,t1,t2,t3);}
a=C_alloc(16);
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_17697,a[2]=t2,a[3]=t1,a[4]=t3,a[5]=C_SCHEME_UNDEFINED,a[6]=((C_word*)t0)[2],tmp=(C_word)a,a+=7,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17728,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17676,a[2]=t7,a[3]=((C_word)li460),tmp=(C_word)a,a+=4,tmp));
t9=((C_word*)t7)[1];
f_17676(t9,t5,t2,C_fix(0));}

/* k17695 in deliver in scheme#inexact->exact in k12641 in k11449 */
static void C_ccall f_17697(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_17697,c,av);}
a=C_alloc(3);
t2=C_mutate(((C_word *)t0)+5,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17724,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2415: scheme#exact->inexact */
t4=*((C_word*)lf[86]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k17709 in k17722 in k17695 in deliver in scheme#inexact->exact in k12641 in k11449 */
static void C_ccall f_17711(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_17711,c,av);}
/* library.scm:2417: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[634]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[634]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=((C_word*)t0)[3];
tp(4,av2);}}

/* k17722 in k17695 in deliver in scheme#inexact->exact in k12641 in k11449 */
static void C_ccall f_17724(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(42,c,3)))){
C_save_and_reclaim((void *)f_17724,c,av);}
a=C_alloc(42);
t2=((C_word*)t0)[2];
t3=C_s_a_i_times(&a,2,((C_word*)t2)[2],t1);
if(C_truep(C_i_finitep(t3))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17711,a[2]=((C_word*)t2)[3],a[3]=((C_word*)t2)[4],tmp=(C_word)a,a+=4,tmp);
t5=C_s_a_u_i_flo_to_int(&a,1,t3);
/* library.scm:2417: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[634]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[634]+1);
av2[1]=t4;
av2[2]=t5;
av2[3]=((C_word*)t2)[5];
tp(4,av2);}}
else{
/* library.scm:2418: ##sys#error-bad-inexact */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[445]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[445]+1);
av2[1]=((C_word*)t2)[3];
av2[2]=((C_word*)t2)[6];
av2[3]=lf[635];
tp(4,av2);}}}

/* k17726 in deliver in scheme#inexact->exact in k12641 in k11449 */
static void C_ccall f_17728(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_17728,c,av);}
/* library.scm:2414: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[636]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[636]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=C_fix(2);
av2[3]=t1;
tp(4,av2);}}

/* k17743 in k17747 in k17753 in scheme#inexact->exact in k12641 in k11449 */
static void C_ccall f_17745(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_17745,c,av);}
/* library.scm:2422: deliver */
t2=((C_word*)t0)[2];
f_17693(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k17747 in k17753 in scheme#inexact->exact in k12641 in k11449 */
static void C_ccall f_17749(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(38,c,3)))){
C_save_and_reclaim((void *)f_17749,c,av);}
a=C_alloc(38);
t2=((C_word*)t0)[2];
t3=C_s_a_i_times(&a,2,((C_word*)t2)[2],t1);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17745,a[2]=((C_word*)t2)[3],a[3]=((C_word*)t2)[4],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2425: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[636]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[636]+1);
av2[1]=t4;
av2[2]=C_fix(2);
av2[3]=*((C_word*)lf[524]+1);
tp(4,av2);}}

/* k17753 in scheme#inexact->exact in k12641 in k11449 */
static void C_ccall f_17755(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_17755,c,av);}
a=C_alloc(3);
t2=(C_truep(t1)?C_ub_i_flonum_greaterp(C_flonum_magnitude(((C_word*)t0)[2]),(double)-1.0):C_SCHEME_FALSE);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17749,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2422: scheme#expt */
t4=*((C_word*)lf[638]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[637];
av2[3]=*((C_word*)lf[524]+1);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}
else{
/* library.scm:2426: deliver */
t3=((C_word*)t0)[3];
f_17693(t3,((C_word*)t0)[4],((C_word*)t0)[2],C_fix(1));}}

/* scheme#inexact->exact in k12641 in k11449 */
static void C_ccall f_17759(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,4)))){
C_save_and_reclaim((void *)f_17759,c,av);}
a=C_alloc(9);
if(C_truep(C_i_exactp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
if(C_truep(C_u_i_fpintegerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_u_i_flo_to_int(&a,1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_u_i_flonum_finitep(t2))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17693,a[2]=t2,a[3]=((C_word)li461),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17755,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2420: chicken.flonum#fp< */
t5=*((C_word*)lf[548]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[630];
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}
else{
/* library.scm:2434: ##sys#error-bad-inexact */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[445]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[445]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[635];
tp(4,av2);}}}}
else{
if(C_truep(C_i_cplxnump(t2))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17799,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2436: scheme#inexact->exact */
t4=*((C_word*)lf[626]+1);{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
av2[2]=C_u_i_cplxnum_real(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}
else{
/* library.scm:2438: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[444]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[444]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[635];
tp(4,av2);}}}}}

/* k17797 in scheme#inexact->exact in k12641 in k11449 */
static void C_ccall f_17799(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_17799,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17803,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2437: scheme#inexact->exact */
t3=*((C_word*)lf[626]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=C_u_i_cplxnum_imag(((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k17801 in k17797 in scheme#inexact->exact in k12641 in k11449 */
static void C_ccall f_17803(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_17803,c,av);}
/* library.scm:2436: make-complex */
f_17319(((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* chicken.bitwise#bitwise-not in k12641 in k11449 */
static void C_ccall f_17823(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_17823,c,av);}
a=C_alloc(5);
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_i_bitwise_not(&a,1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.bitwise#bit->boolean in k12641 in k11449 */
static void C_ccall f_17826(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17826,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_bit_to_bool(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.bitwise#integer-length in k12641 in k11449 */
static void C_ccall f_17829(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17829,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_integer_length(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.bitwise#arithmetic-shift in k12641 in k11449 */
static void C_ccall f_17832(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_17832,c,av);}
a=C_alloc(5);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_s_a_i_arithmetic_shift(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#/ in k12641 in k11449 */
static void C_ccall f_17835(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +4,c,3)))){
C_save_and_reclaim((void*)f_17835,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+4);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
if(C_truep(C_rest_nullp(c,3))){
/* library.scm:2470: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[634]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[634]+1);
av2[1]=t1;
av2[2]=C_fix(1);
av2[3]=t2;
tp(4,av2);}}
else{
t4=C_slot(t3,C_fix(1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17856,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2472: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[634]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[634]+1);
av2[1]=t5;
av2[2]=t2;
av2[3]=C_slot(t3,C_fix(0));
tp(4,av2);}}}

/* k17854 in scheme#/ in k12641 in k11449 */
static void C_ccall f_17856(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_17856,c,av);}
a=C_alloc(6);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17858,a[2]=t3,a[3]=((C_word)li470),tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_17858(t5,((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* loop in k17854 in scheme#/ in k12641 in k11449 */
static void f_17858(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_17858,4,t0,t1,t2,t3);}
a=C_alloc(5);
if(C_truep(C_i_nullp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_slot(t2,C_fix(1));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17876,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2476: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[634]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[634]+1);
av2[1]=t5;
av2[2]=t3;
av2[3]=C_slot(t2,C_fix(0));
tp(4,av2);}}}

/* k17874 in loop in k17854 in scheme#/ in k12641 in k11449 */
static void C_ccall f_17876(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_17876,c,av);}
/* library.scm:2475: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_17858(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* ##sys#/-2 in k12641 in k11449 */
static void C_ccall f_17886(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_17886,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17890,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t5=C_eqp(t3,C_fix(0));
if(C_truep(t5)){
t6=C_fix((C_word)C_DIVISION_BY_ZERO_ERROR);
/* library.scm:2483: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[443]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[443]+1);
av2[1]=t4;
av2[2]=t6;
av2[3]=lf[649];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}
else{
t6=t4;{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_SCHEME_UNDEFINED;
f_17890(2,av2);}}}

/* k17888 in ##sys#/-2 in k12641 in k11449 */
static void C_ccall f_17890(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(117,c,4)))){
C_save_and_reclaim((void *)f_17890,c,av);}
a=C_alloc(117);
t2=(C_truep(C_i_exact_integerp(((C_word*)t0)[2]))?C_i_exact_integerp(((C_word*)t0)[3]):C_SCHEME_FALSE);
if(C_truep(t2)){
t3=C_s_a_u_i_integer_gcd(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t4=C_s_a_u_i_integer_quotient(&a,2,((C_word*)t0)[2],t3);
t5=C_s_a_u_i_integer_quotient(&a,2,((C_word*)t0)[3],t3);
/* library.scm:2487: ratnum */
t6=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t6;
av2[1]=(
/* library.scm:2487: ratnum */
  f_17499(C_a_i(&a,21),t4,t5)
);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t3=C_i_cplxnump(((C_word*)t0)[2]);
t4=(C_truep(t3)?t3:C_i_cplxnump(((C_word*)t0)[3]));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17928,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2490: scheme#real-part */
t6=*((C_word*)lf[614]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
t5=C_i_flonump(((C_word*)t0)[2]);
t6=(C_truep(t5)?t5:C_i_flonump(((C_word*)t0)[3]));
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17994,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2498: scheme#exact->inexact */
t8=*((C_word*)lf[86]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t8;
av2[1]=t7;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t8+1)))(3,av2);}}
else{
if(C_truep(C_i_ratnump(((C_word*)t0)[2]))){
if(C_truep(C_i_ratnump(((C_word*)t0)[3]))){
t7=C_u_i_ratnum_num(((C_word*)t0)[2]);
t8=C_u_i_ratnum_denom(((C_word*)t0)[2]);
t9=C_u_i_ratnum_num(((C_word*)t0)[3]);
t10=C_u_i_ratnum_denom(((C_word*)t0)[3]);
t11=C_s_a_u_i_integer_gcd(&a,2,t7,t9);
t12=C_s_a_u_i_integer_gcd(&a,2,t8,t10);
t13=C_s_a_i_quotient(&a,2,t7,t11);
t14=C_s_a_i_quotient(&a,2,t10,t12);
t15=C_s_a_i_times(&a,2,t13,t14);
t16=C_s_a_i_quotient(&a,2,t8,t12);
t17=C_s_a_i_quotient(&a,2,t9,t11);
t18=C_s_a_i_times(&a,2,t16,t17);
/* library.scm:2508: ratnum */
t19=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t19;
av2[1]=(
/* library.scm:2508: ratnum */
  f_17499(C_a_i(&a,21),t15,t18)
);
((C_proc)(void*)(*((C_word*)t19+1)))(2,av2);}}
else{
t7=C_u_i_ratnum_num(((C_word*)t0)[2]);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18075,a[2]=t7,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* library.scm:2514: ##sys#internal-gcd */
f_19905(t8,lf[649],t7,((C_word*)t0)[3]);}}
else{
if(C_truep(C_i_ratnump(((C_word*)t0)[3]))){
t7=C_u_i_ratnum_num(((C_word*)t0)[3]);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18114,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t7,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* library.scm:2525: ##sys#internal-gcd */
f_19905(t8,lf[649],((C_word*)t0)[2],t7);}
else{
t7=C_i_numberp(((C_word*)t0)[2]);
if(C_truep(C_i_not(t7))){
/* library.scm:2531: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[444]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[444]+1);
av2[1]=((C_word*)t0)[4];
av2[2]=((C_word*)t0)[2];
av2[3]=lf[649];
tp(4,av2);}}
else{
/* library.scm:2532: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[444]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[444]+1);
av2[1]=((C_word*)t0)[4];
av2[2]=((C_word*)t0)[3];
av2[3]=lf[649];
tp(4,av2);}}}}}}}}

/* k17926 in k17888 in ##sys#/-2 in k12641 in k11449 */
static void C_ccall f_17928(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_17928,c,av);}
a=C_alloc(6);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_17931,a[2]=((C_word*)t2)[4],a[3]=C_SCHEME_UNDEFINED,a[4]=t1,a[5]=((C_word*)t2)[3],tmp=(C_word)a,a+=6,tmp);
/* library.scm:2490: scheme#imag-part */
t4=*((C_word*)lf[616]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t2)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k17929 in k17926 in k17888 in ##sys#/-2 in k12641 in k11449 */
static void C_ccall f_17931(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_17931,c,av);}
a=C_alloc(3);
t2=C_mutate(((C_word *)t0)+3,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17934,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2491: scheme#real-part */
t4=*((C_word*)lf[614]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k17932 in k17929 in k17926 in k17888 in ##sys#/-2 in k12641 in k11449 */
static void C_ccall f_17934(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,2)))){
C_save_and_reclaim((void *)f_17934,c,av);}
a=C_alloc(8);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_17937,a[2]=((C_word*)t2)[2],a[3]=((C_word*)t2)[3],a[4]=t1,a[5]=((C_word*)t2)[4],a[6]=C_SCHEME_UNDEFINED,a[7]=C_SCHEME_UNDEFINED,tmp=(C_word)a,a+=8,tmp);
/* library.scm:2491: scheme#imag-part */
t4=*((C_word*)lf[616]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t2)[5];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k17935 in k17932 in k17929 in k17926 in k17888 in ##sys#/-2 in k12641 in k11449 */
static void C_ccall f_17937(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(193,c,3)))){
C_save_and_reclaim((void *)f_17937,c,av);}
a=C_alloc(193);
t2=C_mutate(((C_word *)t0)+6,t1);
t3=C_s_a_i_times(&a,2,((C_word*)t0)[4],((C_word*)t0)[4]);
t4=C_s_a_i_times(&a,2,((C_word*)t0)[6],((C_word*)t0)[6]);
t5=C_s_a_i_plus(&a,2,t3,t4);
t6=C_mutate(((C_word *)t0)+7,t5);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17943,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t8=C_s_a_i_times(&a,2,((C_word*)t0)[5],((C_word*)t0)[4]);
t9=C_s_a_i_times(&a,2,((C_word*)t0)[3],((C_word*)t0)[6]);
t10=C_s_a_i_plus(&a,2,t8,t9);
/* library.scm:2493: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[634]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[634]+1);
av2[1]=t7;
av2[2]=t10;
av2[3]=((C_word*)t0)[7];
tp(4,av2);}}

/* k17941 in k17935 in k17932 in k17929 in k17926 in k17888 in ##sys#/-2 in k12641 in k11449 */
static void C_ccall f_17943(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(99,c,3)))){
C_save_and_reclaim((void *)f_17943,c,av);}
a=C_alloc(99);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17946,a[2]=((C_word*)t2)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=C_s_a_i_times(&a,2,((C_word*)t2)[3],((C_word*)t2)[4]);
t5=C_s_a_i_times(&a,2,((C_word*)t2)[5],((C_word*)t2)[6]);
t6=C_s_a_i_minus(&a,2,t4,t5);
/* library.scm:2494: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[634]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[634]+1);
av2[1]=t3;
av2[2]=t6;
av2[3]=((C_word*)t2)[7];
tp(4,av2);}}

/* k17944 in k17941 in k17935 in k17932 in k17929 in k17926 in k17888 in ##sys#/-2 in k12641 in k11449 */
static void C_ccall f_17946(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_17946,c,av);}
/* library.scm:2495: make-complex */
f_17319(((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* k17992 in k17888 in ##sys#/-2 in k12641 in k11449 */
static void C_ccall f_17994(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_17994,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17998,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2498: scheme#exact->inexact */
t3=*((C_word*)lf[86]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k17996 in k17992 in k17888 in ##sys#/-2 in k12641 in k11449 */
static void C_ccall f_17998(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_17998,c,av);}
/* library.scm:2498: chicken.flonum#fp/ */
t2=*((C_word*)lf[536]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k18073 in k17888 in ##sys#/-2 in k12641 in k11449 */
static void C_ccall f_18075(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(64,c,3)))){
C_save_and_reclaim((void *)f_18075,c,av);}
a=C_alloc(64);
t2=C_s_a_i_quotient(&a,2,((C_word*)t0)[2],t1);
t3=C_u_i_ratnum_denom(((C_word*)t0)[3]);
t4=C_s_a_i_quotient(&a,2,((C_word*)t0)[4],t1);
t5=C_s_a_i_times(&a,2,t3,t4);
if(C_truep(C_i_flonump(t5))){
/* library.scm:2518: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[634]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[634]+1);
av2[1]=((C_word*)t0)[5];
av2[2]=t2;
av2[3]=t5;
tp(4,av2);}}
else{
/* library.scm:2519: ratnum */
t6=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t6;
av2[1]=(
/* library.scm:2519: ratnum */
  f_17499(C_a_i(&a,21),t2,t5)
);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k18112 in k17888 in ##sys#/-2 in k12641 in k11449 */
static void C_ccall f_18114(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(64,c,3)))){
C_save_and_reclaim((void *)f_18114,c,av);}
a=C_alloc(64);
t2=C_s_a_i_quotient(&a,2,((C_word*)t0)[2],t1);
t3=C_u_i_ratnum_denom(((C_word*)t0)[3]);
t4=C_s_a_i_times(&a,2,t2,t3);
t5=C_s_a_i_quotient(&a,2,((C_word*)t0)[4],t1);
if(C_truep(C_i_flonump(t5))){
/* library.scm:2529: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[634]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[634]+1);
av2[1]=((C_word*)t0)[5];
av2[2]=t4;
av2[3]=t5;
tp(4,av2);}}
else{
/* library.scm:2530: ratnum */
t6=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t6;
av2[1]=(
/* library.scm:2530: ratnum */
  f_17499(C_a_i(&a,21),t4,t5)
);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* scheme#floor in k12641 in k11449 */
static void C_ccall f_18167(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(34,c,3)))){
C_save_and_reclaim((void *)f_18167,c,av);}
a=C_alloc(34);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
/* library.scm:2537: chicken.flonum#fpfloor */
t3=*((C_word*)lf[560]+1);{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=C_u_i_ratnum_num(t2);
t4=C_u_i_ratnum_denom(t2);
t5=C_s_a_i_quotient(&a,2,t3,t4);
t6=C_i_greater_or_equalp(t3,C_fix(0));
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?t5:C_s_a_i_minus(&a,2,t5,C_fix(1)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
/* library.scm:2542: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[433]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[433]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[651];
tp(4,av2);}}}}}

/* scheme#ceiling in k12641 in k11449 */
static void C_ccall f_18211(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(34,c,3)))){
C_save_and_reclaim((void *)f_18211,c,av);}
a=C_alloc(34);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
/* library.scm:2547: chicken.flonum#fpceiling */
t3=*((C_word*)lf[566]+1);{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=C_u_i_ratnum_num(t2);
t4=C_u_i_ratnum_denom(t2);
t5=C_s_a_i_quotient(&a,2,t3,t4);
t6=C_i_greater_or_equalp(t3,C_fix(0));
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?C_s_a_i_plus(&a,2,t5,C_fix(1)):t5);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
/* library.scm:2552: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[433]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[433]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[653];
tp(4,av2);}}}}}

/* scheme#truncate in k12641 in k11449 */
static void C_ccall f_18255(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_18255,c,av);}
a=C_alloc(5);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
/* library.scm:2557: chicken.flonum#fptruncate */
t3=*((C_word*)lf[562]+1);{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=C_u_i_ratnum_num(t2);
t4=C_u_i_ratnum_denom(t2);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_s_a_i_quotient(&a,2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
/* library.scm:2561: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[433]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[433]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[655];
tp(4,av2);}}}}}

/* scheme#round in k12641 in k11449 */
static void C_ccall f_18291(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(36,c,3)))){
C_save_and_reclaim((void *)f_18291,c,av);}
a=C_alloc(36);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_flonum_round_proper(&a,1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=C_a_i_ratnum(&a,2,C_fix(1),C_fix(2));
t4=C_s_a_i_plus(&a,2,t2,t3);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18310,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2570: scheme#floor */
t6=*((C_word*)lf[650]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
/* library.scm:2572: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[433]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[433]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[657];
tp(4,av2);}}}}}

/* k18308 in scheme#round in k12641 in k11449 */
static void C_ccall f_18310(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,1)))){
C_save_and_reclaim((void *)f_18310,c,av);}
a=C_alloc(29);
t2=C_i_nequalp(t1,((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(t2)?(C_truep(C_i_oddp(t1))?C_s_a_i_minus(&a,2,t1,C_fix(1)):t1):t1);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* find-ratio-between in k12641 in k11449 */
static void f_18334(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(67,0,4)))){
C_save_and_reclaim_args((void *)trf_18334,3,t1,t2,t3);}
a=C_alloc(67);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18337,a[2]=t5,a[3]=((C_word)li477),tmp=(C_word)a,a+=4,tmp));
if(C_truep(C_i_lessp(t3,t2))){
/* library.scm:2585: find-ratio-between */
t12=t1;
t13=t3;
t14=t2;
t1=t12;
t2=t13;
t3=t14;
goto loop;}
else{
t7=C_i_lessp(t2,t3);
if(C_truep(C_i_not(t7))){
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=C_a_i_list2(&a,2,t2,C_fix(1));
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
if(C_truep(C_i_positivep(t2))){
/* library.scm:2587: sr */
t8=((C_word*)t5)[1];
f_18337(t8,t1,t2,t3);}
else{
if(C_truep(C_i_negativep(t3))){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18448,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t9=C_s_a_i_negate(&a,1,t3);
t10=C_s_a_i_negate(&a,1,t2);
/* library.scm:2588: sr */
t11=((C_word*)t5)[1];
f_18337(t11,t8,t9,t10);}
else{
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=lf[659];
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}}}}

/* sr in find-ratio-between in k12641 in k11449 */
static void f_18337(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,0,2)))){
C_save_and_reclaim_args((void *)trf_18337,4,t0,t1,t2,t3);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18341,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18416,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2576: scheme#floor */
t6=*((C_word*)lf[650]+1);{
C_word av2[3];
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}

/* k18339 in sr in find-ratio-between in k12641 in k11449 */
static void C_ccall f_18341(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,2)))){
C_save_and_reclaim((void *)f_18341,c,av);}
a=C_alloc(10);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_18344,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18412,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2577: scheme#floor */
t4=*((C_word*)lf[650]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k18342 in k18339 in sr in find-ratio-between in k12641 in k11449 */
static void C_ccall f_18344(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(39,c,3)))){
C_save_and_reclaim((void *)f_18344,c,av);}
a=C_alloc(39);
t2=C_i_lessp(((C_word*)t0)[2],((C_word*)t0)[3]);
if(C_truep(C_i_not(t2))){
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_list2(&a,2,((C_word*)t0)[2],C_fix(1));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_nequalp(((C_word*)t0)[2],t1))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18362,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18385,a[2]=((C_word*)t0)[5],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
t5=C_s_a_i_minus(&a,2,((C_word*)t0)[6],t1);
/* library.scm:2580: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[634]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[634]+1);
av2[1]=t4;
av2[2]=C_fix(1);
av2[3]=t5;
tp(4,av2);}}
else{
t3=C_s_a_i_plus(&a,2,C_fix(1),((C_word*)t0)[2]);
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_list2(&a,2,t3,C_fix(1));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}}

/* k18360 in k18342 in k18339 in sr in find-ratio-between in k12641 in k11449 */
static void C_ccall f_18362(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(68,c,1)))){
C_save_and_reclaim((void *)f_18362,c,av);}
a=C_alloc(68);
t2=C_i_cadr(t1);
t3=C_u_i_car(t1);
t4=C_s_a_i_times(&a,2,((C_word*)t0)[2],t3);
t5=C_s_a_i_plus(&a,2,t2,t4);
t6=C_u_i_car(t1);
t7=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_a_i_list2(&a,2,t5,t6);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* k18383 in k18342 in k18339 in sr in find-ratio-between in k12641 in k11449 */
static void C_ccall f_18385(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(34,c,3)))){
C_save_and_reclaim((void *)f_18385,c,av);}
a=C_alloc(34);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18389,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=C_s_a_i_minus(&a,2,((C_word*)t0)[4],((C_word*)t0)[5]);
/* library.scm:2581: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[634]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[634]+1);
av2[1]=t2;
av2[2]=C_fix(1);
av2[3]=t3;
tp(4,av2);}}

/* k18387 in k18383 in k18342 in k18339 in sr in find-ratio-between in k12641 in k11449 */
static void C_ccall f_18389(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_18389,c,av);}
/* library.scm:2580: sr */
t2=((C_word*)((C_word*)t0)[2])[1];
f_18337(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k18410 in k18339 in sr in find-ratio-between in k12641 in k11449 */
static void C_ccall f_18412(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_18412,c,av);}
/* library.scm:2577: scheme#inexact->exact */
t2=*((C_word*)lf[626]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* k18414 in sr in find-ratio-between in k12641 in k11449 */
static void C_ccall f_18416(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_18416,c,av);}
/* library.scm:2576: scheme#inexact->exact */
t2=*((C_word*)lf[626]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* k18446 in find-ratio-between in k12641 in k11449 */
static void C_ccall f_18448(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(35,c,1)))){
C_save_and_reclaim((void *)f_18448,c,av);}
a=C_alloc(35);
t2=C_i_car(t1);
t3=C_s_a_i_negate(&a,1,t2);
t4=C_i_cadr(t1);
t5=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_a_i_list2(&a,2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#rationalize in k12641 in k11449 */
static void C_ccall f_18484(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(66,c,3)))){
C_save_and_reclaim((void *)f_18484,c,av);}
a=C_alloc(66);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18488,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18507,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=C_s_a_i_minus(&a,2,t2,t3);
t7=C_s_a_i_plus(&a,2,t2,t3);
/* library.scm:2592: find-ratio-between */
f_18334(t5,t6,t7);}

/* k18486 in scheme#rationalize in k12641 in k11449 */
static void C_ccall f_18488(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_18488,c,av);}
t2=C_i_inexactp(((C_word*)t0)[2]);
if(C_truep(t2)){
if(C_truep(t2)){
/* library.scm:2598: scheme#exact->inexact */
t3=*((C_word*)lf[86]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}
else{
if(C_truep(C_i_inexactp(((C_word*)t0)[4]))){
/* library.scm:2598: scheme#exact->inexact */
t3=*((C_word*)lf[86]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}}

/* k18505 in scheme#rationalize in k12641 in k11449 */
static void C_ccall f_18507(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_18507,c,av);}{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=*((C_word*)lf[634]+1);
av2[3]=t1;
C_apply(4,av2);}}

/* scheme#max in k12641 in k11449 */
static void C_ccall f_18509(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +6,c,5)))){
C_save_and_reclaim((void*)f_18509,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+6);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
t4=C_i_flonump(t2);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18516,a[2]=t6,a[3]=((C_word)li480),tmp=(C_word)a,a+=4,tmp));
t8=((C_word*)t6)[1];
f_18516(t8,t1,t4,t2,t3);}

/* loop in scheme#max in k12641 in k11449 */
static void f_18516(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(11,0,4)))){
C_save_and_reclaim_args((void *)trf_18516,5,t0,t1,t2,t3,t4);}
a=C_alloc(11);
t5=C_i_check_number_2(t3,lf[662]);
if(C_truep(C_i_nullp(t4))){
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=(C_truep(t2)?C_a_i_exact_to_inexact(&a,1,t3):t3);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_slot(t4,C_fix(0));
t7=(C_truep(t2)?t2:C_i_flonump(t6));
t8=C_i_greaterp(t6,t3);
t9=(C_truep(t8)?t6:t3);
/* library.scm:2608: loop */
t11=t1;
t12=t7;
t13=t9;
t14=C_slot(t4,C_fix(1));
t1=t11;
t2=t12;
t3=t13;
t4=t14;
goto loop;}}

/* scheme#min in k12641 in k11449 */
static void C_ccall f_18553(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +6,c,5)))){
C_save_and_reclaim((void*)f_18553,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+6);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
t4=C_i_flonump(t2);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18560,a[2]=t6,a[3]=((C_word)li482),tmp=(C_word)a,a+=4,tmp));
t8=((C_word*)t6)[1];
f_18560(t8,t1,t4,t2,t3);}

/* loop in scheme#min in k12641 in k11449 */
static void f_18560(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(11,0,4)))){
C_save_and_reclaim_args((void *)trf_18560,5,t0,t1,t2,t3,t4);}
a=C_alloc(11);
t5=C_i_check_number_2(t3,lf[663]);
if(C_truep(C_i_nullp(t4))){
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=(C_truep(t2)?C_a_i_exact_to_inexact(&a,1,t3):t3);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_slot(t4,C_fix(0));
t7=(C_truep(t2)?t2:C_i_flonump(t6));
t8=C_i_lessp(t6,t3);
t9=(C_truep(t8)?t6:t3);
/* library.scm:2619: loop */
t11=t1;
t12=t7;
t13=t9;
t14=C_slot(t4,C_fix(1));
t1=t11;
t2=t12;
t3=t13;
t4=t14;
goto loop;}}

/* scheme#exp in k12641 in k11449 */
static void C_ccall f_18597(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(15,c,2)))){
C_save_and_reclaim((void *)f_18597,c,av);}
a=C_alloc(15);
t3=C_i_check_number_2(t2,lf[665]);
if(C_truep(C_i_cplxnump(t2))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18615,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2628: scheme#exact->inexact */
t5=*((C_word*)lf[86]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=C_u_i_cplxnum_real(t2);
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}
else{
t4=C_a_i_exact_to_inexact(&a,1,t2);
t5=C_flonum(&a,C_exp(C_flonum_magnitude(t4)));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k18613 in scheme#exp in k12641 in k11449 */
static void C_ccall f_18615(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,c,2)))){
C_save_and_reclaim((void *)f_18615,c,av);}
a=C_alloc(12);
t2=C_a_i_exp(&a,1,t1);
t3=C_u_i_cplxnum_imag(((C_word*)t0)[2]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18624,a[2]=((C_word*)t0)[3],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18629,a[2]=t3,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2631: scheme#exact->inexact */
t6=*((C_word*)lf[86]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=t3;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}

/* k18622 in k18613 in scheme#exp in k12641 in k11449 */
static void C_ccall f_18624(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,1)))){
C_save_and_reclaim((void *)f_18624,c,av);}
a=C_alloc(33);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_s_a_i_times(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k18627 in k18613 in scheme#exp in k12641 in k11449 */
static void C_ccall f_18629(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(19,c,3)))){
C_save_and_reclaim((void *)f_18629,c,av);}
a=C_alloc(19);
t2=C_a_i_cos(&a,1,t1);
t3=C_a_i_exact_to_inexact(&a,1,((C_word*)t0)[2]);
t4=C_a_i_sin(&a,1,t3);
/* library.scm:2630: make-complex */
f_17319(((C_word*)t0)[3],t2,t4);}

/* ##sys#log-1 in k12641 in k11449 */
static void C_ccall f_18642(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,5)))){
C_save_and_reclaim((void *)f_18642,c,av);}
a=C_alloc(8);
t3=C_eqp(t2,C_fix(0));
if(C_truep(t3)){
/* library.scm:2638: ##sys#signal-hook */
t4=*((C_word*)lf[245]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t1;
av2[2]=lf[667];
av2[3]=lf[668];
av2[4]=lf[669];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(6,av2);}}
else{
t4=C_i_cplxnump(t2);
t5=(C_truep(t4)?t4:C_i_negativep(t2));
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18668,a[2]=t1,a[3]=C_SCHEME_UNDEFINED,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18684,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2641: scheme#magnitude */
t8=*((C_word*)lf[620]+1);{
C_word *av2=av;
av2[0]=t8;
av2[1]=t7;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t8+1)))(3,av2);}}
else{
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18688,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2644: scheme#exact->inexact */
t7=*((C_word*)lf[86]+1);{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}}}

/* k18666 in ##sys#log-1 in k12641 in k11449 */
static void C_ccall f_18668(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18668,c,av);}
a=C_alloc(3);
t2=C_mutate(((C_word *)t0)+3,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18676,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2642: make-complex */
f_17319(t3,C_fix(0),C_fix(1));}

/* k18674 in k18666 in ##sys#log-1 in k12641 in k11449 */
static void C_ccall f_18676(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_18676,c,av);}
a=C_alloc(5);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18680,a[2]=t1,a[3]=((C_word*)t2)[2],a[4]=((C_word*)t2)[3],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2642: scheme#angle */
t4=*((C_word*)lf[618]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t2)[4];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k18678 in k18674 in k18666 in ##sys#log-1 in k12641 in k11449 */
static void C_ccall f_18680(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(62,c,1)))){
C_save_and_reclaim((void *)f_18680,c,av);}
a=C_alloc(62);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],t1);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_i_plus(&a,2,((C_word*)t0)[4],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k18682 in ##sys#log-1 in k12641 in k11449 */
static void C_ccall f_18684(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_18684,c,av);}
/* library.scm:2641: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[666]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[666]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
tp(3,av2);}}

/* k18686 in ##sys#log-1 in k12641 in k11449 */
static void C_ccall f_18688(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_18688,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_log(&a,1,t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* scheme#log in k12641 in k11449 */
static void C_ccall f_18691(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_18691,c,av);}
a=C_alloc(4);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_get_rest_arg(c,3,av,3,t0));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18705,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2648: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[666]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[666]+1);
av2[1]=t5;
av2[2]=t2;
tp(3,av2);}}
else{
/* library.scm:2648: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[666]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[666]+1);
av2[1]=t1;
av2[2]=t2;
tp(3,av2);}}}

/* k18703 in scheme#log in k12641 in k11449 */
static void C_ccall f_18705(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_18705,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18709,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2648: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[666]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[666]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
tp(3,av2);}}

/* k18707 in k18703 in scheme#log in k12641 in k11449 */
static void C_ccall f_18709(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_18709,c,av);}
/* library.scm:2648: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[634]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[634]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
tp(4,av2);}}

/* scheme#sin in k12641 in k11449 */
static void C_ccall f_18720(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(37,c,2)))){
C_save_and_reclaim((void *)f_18720,c,av);}
a=C_alloc(37);
t3=C_i_check_number_2(t2,lf[672]);
if(C_truep(C_i_cplxnump(t2))){
t4=C_s_a_i_times(&a,2,lf[673],t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18744,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2655: scheme#exp */
t6=*((C_word*)lf[664]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
t4=C_a_i_exact_to_inexact(&a,1,t2);
t5=C_a_i_sin(&a,1,t4);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k18742 in scheme#sin in k12641 in k11449 */
static void C_ccall f_18744(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,2)))){
C_save_and_reclaim((void *)f_18744,c,av);}
a=C_alloc(33);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18748,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=C_s_a_i_negate(&a,1,((C_word*)t0)[3]);
/* library.scm:2655: scheme#exp */
t4=*((C_word*)lf[664]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t2;
av2[2]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k18746 in k18742 in scheme#sin in k12641 in k11449 */
static void C_ccall f_18748(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,3)))){
C_save_and_reclaim((void *)f_18748,c,av);}
a=C_alloc(29);
t2=C_s_a_i_minus(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2655: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[634]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[634]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
av2[3]=lf[674];
tp(4,av2);}}

/* scheme#cos in k12641 in k11449 */
static void C_ccall f_18754(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(37,c,2)))){
C_save_and_reclaim((void *)f_18754,c,av);}
a=C_alloc(37);
t3=C_i_check_number_2(t2,lf[676]);
if(C_truep(C_i_cplxnump(t2))){
t4=C_s_a_i_times(&a,2,lf[673],t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18778,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2663: scheme#exp */
t6=*((C_word*)lf[664]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
t4=C_a_i_exact_to_inexact(&a,1,t2);
t5=C_a_i_cos(&a,1,t4);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k18776 in scheme#cos in k12641 in k11449 */
static void C_ccall f_18778(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,2)))){
C_save_and_reclaim((void *)f_18778,c,av);}
a=C_alloc(33);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18782,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=C_s_a_i_negate(&a,1,((C_word*)t0)[3]);
/* library.scm:2663: scheme#exp */
t4=*((C_word*)lf[664]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t2;
av2[2]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k18780 in k18776 in scheme#cos in k12641 in k11449 */
static void C_ccall f_18782(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,3)))){
C_save_and_reclaim((void *)f_18782,c,av);}
a=C_alloc(29);
t2=C_s_a_i_plus(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2663: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[634]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[634]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
av2[3]=C_fix(2);
tp(4,av2);}}

/* scheme#tan in k12641 in k11449 */
static void C_ccall f_18788(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(15,c,2)))){
C_save_and_reclaim((void *)f_18788,c,av);}
a=C_alloc(15);
t3=C_i_check_number_2(t2,lf[678]);
if(C_truep(C_i_cplxnump(t2))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18805,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2670: scheme#sin */
t5=*((C_word*)lf[671]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}
else{
t4=C_a_i_exact_to_inexact(&a,1,t2);
t5=C_a_i_tan(&a,1,t4);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k18803 in scheme#tan in k12641 in k11449 */
static void C_ccall f_18805(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_18805,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18809,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2670: scheme#cos */
t3=*((C_word*)lf[675]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k18807 in k18803 in scheme#tan in k12641 in k11449 */
static void C_ccall f_18809(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_18809,c,av);}
/* library.scm:2670: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[634]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[634]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
tp(4,av2);}}

/* scheme#asin in k12641 in k11449 */
static void C_ccall f_18813(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_18813,c,av);}
a=C_alloc(8);
t3=C_i_check_number_2(t2,lf[680]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18823,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18871,a[2]=t4,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2677: chicken.flonum#fp>= */
t6=*((C_word*)lf[550]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
av2[3]=lf[683];
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}
else{
t5=t4;
f_18823(t5,C_SCHEME_FALSE);}}

/* k18821 in scheme#asin in k12641 in k11449 */
static void f_18823(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_18823,2,t0,t1);}
a=C_alloc(4);
if(C_truep(t1)){
t2=C_a_i_asin(&a,1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18829,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_fixnump(((C_word*)t0)[3]))){
t3=C_fixnum_greater_or_equal_p(((C_word*)t0)[3],C_fix(-1));
t4=t2;
f_18829(t4,(C_truep(t3)?C_fixnum_less_or_equal_p(((C_word*)t0)[3],C_fix(1)):C_SCHEME_FALSE));}
else{
t3=t2;
f_18829(t3,C_SCHEME_FALSE);}}}

/* k18827 in k18821 in scheme#asin in k12641 in k11449 */
static void f_18829(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(102,0,3)))){
C_save_and_reclaim_args((void *)trf_18829,2,t0,t1);}
a=C_alloc(102);
t2=((C_word*)t0)[2];
if(C_truep(t1)){
t3=((C_word*)t2)[2];{
C_word av2[2];
av2[0]=t3;
av2[1]=C_a_i_asin(&a,1,C_a_i_fix_to_flo(&a,1,((C_word*)t2)[3]));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18836,a[2]=((C_word*)t2)[2],tmp=(C_word)a,a+=3,tmp);
t4=C_s_a_i_times(&a,2,lf[673],((C_word*)t2)[3]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18848,a[2]=t4,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t6=C_s_a_i_times(&a,2,((C_word*)t2)[3],((C_word*)t2)[3]);
t7=C_s_a_i_minus(&a,2,C_fix(1),t6);
/* library.scm:2686: ##sys#sqrt/loc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[682]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[682]+1);
av2[1]=t5;
av2[2]=lf[680];
av2[3]=t7;
tp(4,av2);}}}

/* k18834 in k18827 in k18821 in scheme#asin in k12641 in k11449 */
static void C_ccall f_18836(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,1)))){
C_save_and_reclaim((void *)f_18836,c,av);}
a=C_alloc(33);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_s_a_i_times(&a,2,lf[681],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k18846 in k18827 in k18821 in scheme#asin in k12641 in k11449 */
static void C_ccall f_18848(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,2)))){
C_save_and_reclaim((void *)f_18848,c,av);}
a=C_alloc(29);
t2=C_s_a_i_plus(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2684: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[666]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[666]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
tp(3,av2);}}

/* k18869 in scheme#asin in k12641 in k11449 */
static void C_ccall f_18871(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18871,c,av);}
t2=((C_word*)t0)[2];
f_18823(t2,(C_truep(t1)?C_ub_i_flonum_less_or_equal_p(C_flonum_magnitude(((C_word*)t0)[3]),(double)1.0):C_SCHEME_FALSE));}

/* scheme#acos in k12641 in k11449 */
static void C_ccall f_18875(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_18875,c,av);}
a=C_alloc(9);
t3=C_i_check_number_2(t2,lf[685]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18885,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_flonump(t2))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18913,a[2]=t4,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2694: chicken.flonum#fp>= */
t6=*((C_word*)lf[550]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
av2[3]=lf[683];
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}
else{
t5=t4;
f_18885(t5,C_SCHEME_FALSE);}}

/* k18883 in scheme#acos in k12641 in k11449 */
static void f_18885(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_18885,2,t0,t1);}
a=C_alloc(4);
if(C_truep(t1)){
t2=C_a_i_acos(&a,1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18891,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_fixnump(((C_word*)t0)[3]))){
t3=C_fixnum_greater_or_equal_p(((C_word*)t0)[3],C_fix(-1));
t4=t2;
f_18891(t4,(C_truep(t3)?C_fixnum_less_or_equal_p(((C_word*)t0)[3],C_fix(1)):C_SCHEME_FALSE));}
else{
t3=t2;
f_18891(t3,C_SCHEME_FALSE);}}}

/* k18889 in k18883 in scheme#acos in k12641 in k11449 */
static void f_18891(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,2)))){
C_save_and_reclaim_args((void *)trf_18891,2,t0,t1);}
a=C_alloc(8);
t2=((C_word*)t0)[2];
if(C_truep(t1)){
t3=((C_word*)t2)[2];{
C_word av2[2];
av2[0]=t3;
av2[1]=C_a_i_acos(&a,1,C_a_i_fix_to_flo(&a,1,((C_word*)t2)[3]));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18898,a[2]=((C_word*)t2)[2],a[3]=((C_word*)t2)[4],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2701: scheme#asin */
t4=*((C_word*)lf[679]+1);{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t2)[3];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}}

/* k18896 in k18889 in k18883 in scheme#acos in k12641 in k11449 */
static void C_ccall f_18898(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,1)))){
C_save_and_reclaim((void *)f_18898,c,av);}
a=C_alloc(29);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_s_a_i_minus(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k18911 in scheme#acos in k12641 in k11449 */
static void C_ccall f_18913(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18913,c,av);}
t2=((C_word*)t0)[2];
f_18885(t2,(C_truep(t1)?C_ub_i_flonum_less_or_equal_p(C_flonum_magnitude(((C_word*)t0)[3]),(double)1.0):C_SCHEME_FALSE));}

/* scheme#atan in k12641 in k11449 */
static void C_ccall f_18917(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(66,c,3)))){
C_save_and_reclaim((void *)f_18917,c,av);}
a=C_alloc(66);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_get_rest_arg(c,3,av,3,t0));
t5=C_i_check_number_2(t2,lf[687]);
if(C_truep(C_i_cplxnump(t2))){
if(C_truep(t4)){
/* library.scm:2708: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[433]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[433]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[687];
tp(4,av2);}}
else{
t6=C_s_a_i_times(&a,2,lf[673],t2);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18950,a[2]=t1,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
t8=C_s_a_i_plus(&a,2,C_fix(1),t6);
/* library.scm:2710: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[666]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[666]+1);
av2[1]=t7;
av2[2]=t8;
tp(3,av2);}}}
else{
if(C_truep(t4)){
t6=C_a_i_exact_to_inexact(&a,1,t2);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18971,a[2]=t1,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2714: scheme#exact->inexact */
t8=*((C_word*)lf[86]+1);{
C_word *av2=av;
av2[0]=t8;
av2[1]=t7;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t8+1)))(3,av2);}}
else{
t6=C_a_i_exact_to_inexact(&a,1,t2);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_a_i_atan(&a,1,t6);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}}

/* k18948 in scheme#atan in k12641 in k11449 */
static void C_ccall f_18950(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,2)))){
C_save_and_reclaim((void *)f_18950,c,av);}
a=C_alloc(33);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18954,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=C_s_a_i_minus(&a,2,C_fix(1),((C_word*)t0)[3]);
/* library.scm:2711: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[666]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[666]+1);
av2[1]=t2;
av2[2]=t3;
tp(3,av2);}}

/* k18952 in k18948 in scheme#atan in k12641 in k11449 */
static void C_ccall f_18954(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,3)))){
C_save_and_reclaim((void *)f_18954,c,av);}
a=C_alloc(29);
t2=C_s_a_i_minus(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2710: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[634]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[634]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
av2[3]=lf[674];
tp(4,av2);}}

/* k18969 in scheme#atan in k12641 in k11449 */
static void C_ccall f_18971(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_18971,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_atan2(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* ##sys#exact-integer-sqrt in k12641 in k11449 */
static void C_ccall f_18981(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(10,c,4)))){
C_save_and_reclaim((void *)f_18981,c,av);}
a=C_alloc(10);
t3=C_fixnump(t2);
t4=(C_truep(t3)?C_fixnum_less_or_equal_p(t2,C_fix(4)):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=C_eqp(t2,C_fix(0));
t6=(C_truep(t5)?t5:C_eqp(t2,C_fix(1)));
if(C_truep(t6)){
/* library.scm:2726: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t2;
av2[3]=C_fix(0);
C_values(4,av2);}}
else{
switch(t2){
case C_fix(2):
/* library.scm:2727: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_fix(1);
av2[3]=C_fix(1);
C_values(4,av2);}
case C_fix(3):
/* library.scm:2728: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_fix(1);
av2[3]=C_fix(2);
C_values(4,av2);}
case C_fix(4):
/* library.scm:2729: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_fix(2);
av2[3]=C_fix(0);
C_values(4,av2);}
default:
/* library.scm:2730: chicken.base#error */
t7=*((C_word*)lf[244]+1);{
C_word *av2=av;
av2[0]=t7;
av2[1]=t1;
av2[2]=lf[689];
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}}}
else{
t5=C_fixnum_plus(C_i_integer_length(t2),C_fix(1));
t6=C_fixnum_shift_right(t5,C_fix(2));
t7=C_fixnum_shift_left(t6,C_fix(1));
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19054,a[2]=t7,a[3]=t2,a[4]=((C_word)li493),tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19068,a[2]=t6,a[3]=t2,a[4]=((C_word)li497),tmp=(C_word)a,a+=5,tmp);
/* library.scm:2731: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t8;
av2[3]=t9;
C_call_with_values(4,av2);}}}

/* a19053 in ##sys#exact-integer-sqrt in k12641 in k11449 */
static void C_ccall f_19054(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_19054,c,av);}
a=C_alloc(5);
t2=C_fixnum_negate(((C_word*)t0)[2]);
t3=C_s_a_i_arithmetic_shift(&a,2,((C_word*)t0)[3],t2);
/* library.scm:2734: ##sys#exact-integer-sqrt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[688]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[688]+1);
av2[1]=t1;
av2[2]=t3;
tp(3,av2);}}

/* a19067 in ##sys#exact-integer-sqrt in k12641 in k11449 */
static void C_ccall f_19068(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(38,c,4)))){
C_save_and_reclaim((void *)f_19068,c,av);}
a=C_alloc(38);
t4=C_s_a_i_arithmetic_shift(&a,2,C_fix(1),((C_word*)t0)[2]);
t5=C_s_a_u_i_integer_minus(&a,2,t4,C_fix(1));
t6=C_s_a_i_bitwise_and(&a,2,((C_word*)t0)[3],t5);
t7=C_fixnum_negate(((C_word*)t0)[2]);
t8=C_s_a_i_arithmetic_shift(&a,2,((C_word*)t0)[3],t7);
t9=C_s_a_i_bitwise_and(&a,2,t8,t5);
t10=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_19085,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=t9,a[5]=t2,a[6]=((C_word)li495),tmp=(C_word)a,a+=7,tmp);
t11=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_19101,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t6,a[5]=((C_word)li496),tmp=(C_word)a,a+=6,tmp);
/* library.scm:2731: ##sys#call-with-values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t10;
av2[3]=t11;
C_call_with_values(4,av2);}}

/* a19084 in a19067 in ##sys#exact-integer-sqrt in k12641 in k11449 */
static void C_ccall f_19085(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(18,c,3)))){
C_save_and_reclaim((void *)f_19085,c,av);}
a=C_alloc(18);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_u_integer_quotient_and_remainder,a[2]=((C_word)li494),tmp=(C_word)a,a+=3,tmp);
t3=C_s_a_i_arithmetic_shift(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t4=C_s_a_u_i_integer_plus(&a,2,t3,((C_word*)t0)[4]);
t5=C_s_a_i_arithmetic_shift(&a,2,((C_word*)t0)[5],C_fix(1));
/* library.scm:2731: g3254 */
t6=t2;{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=t1;
av2[2]=t4;
av2[3]=t5;
((C_proc)C_fast_retrieve_proc(t6))(4,av2);}}

/* a19100 in a19067 in ##sys#exact-integer-sqrt in k12641 in k11449 */
static void C_ccall f_19101(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(222,c,3)))){
C_save_and_reclaim((void *)f_19101,c,av);}
a=C_alloc(222);
t4=C_s_a_i_arithmetic_shift(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t5=C_s_a_i_plus(&a,2,t4,t2);
t6=C_s_a_i_arithmetic_shift(&a,2,t3,((C_word*)t0)[3]);
t7=C_s_a_i_times(&a,2,t2,t2);
t8=C_s_a_i_minus(&a,2,((C_word*)t0)[4],t7);
t9=C_s_a_i_plus(&a,2,t6,t8);
if(C_truep(C_i_negativep(t9))){
t10=C_s_a_i_minus(&a,2,t5,C_fix(1));
t11=C_s_a_i_arithmetic_shift(&a,2,t5,C_fix(1));
t12=C_s_a_i_plus(&a,2,t9,t11);
t13=C_s_a_i_minus(&a,2,t12,C_fix(1));
/* library.scm:2745: scheme#values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t10;
av2[3]=t13;
C_values(4,av2);}}
else{
/* library.scm:2747: scheme#values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t5;
av2[3]=t9;
C_values(4,av2);}}}

/* scheme#exact-integer-sqrt in k12641 in k11449 */
static void C_ccall f_19172(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_19172,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19176,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2751: ##sys#check-exact-uinteger */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[430]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[430]+1);
av2[1]=t3;
av2[2]=t2;
av2[3]=lf[691];
tp(4,av2);}}

/* k19174 in scheme#exact-integer-sqrt in k12641 in k11449 */
static void C_ccall f_19176(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19176,c,av);}
/* library.scm:2752: ##sys#exact-integer-sqrt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[688]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[688]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
tp(3,av2);}}

/* ##sys#sqrt/loc in k12641 in k11449 */
static void C_ccall f_19181(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(32,c,4)))){
C_save_and_reclaim((void *)f_19181,c,av);}
a=C_alloc(32);
if(C_truep(C_i_cplxnump(t3))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19191,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=C_u_i_cplxnum_imag(t3);
t6=C_a_i_exact_to_inexact(&a,1,t5);
t7=C_u_i_cplxnum_real(t3);
t8=C_a_i_exact_to_inexact(&a,1,t7);
t9=C_flonum(&a,C_atan2(C_flonum_magnitude(t6),C_flonum_magnitude(t8)));
/* library.scm:2758: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[634]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[634]+1);
av2[1]=t4;
av2[2]=t9;
av2[3]=C_fix(2);
tp(4,av2);}}
else{
if(C_truep(C_i_negativep(t3))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19231,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=C_s_a_i_negate(&a,1,t3);
/* library.scm:2763: scheme#exact->inexact */
t6=*((C_word*)lf[86]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t4;
av2[2]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
if(C_truep(C_i_exact_integerp(t3))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19241,a[2]=t3,a[3]=((C_word)li500),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19247,a[2]=t3,a[3]=((C_word)li501),tmp=(C_word)a,a+=4,tmp);
/* library.scm:2765: ##sys#call-with-values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t4;
av2[3]=t5;
C_call_with_values(4,av2);}}
else{
if(C_truep(C_i_ratnump(t3))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19269,a[2]=t3,a[3]=((C_word)li502),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19281,a[2]=t3,a[3]=t2,a[4]=((C_word)li505),tmp=(C_word)a,a+=5,tmp);
/* library.scm:2770: ##sys#call-with-values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t4;
av2[3]=t5;
C_call_with_values(4,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19333,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2778: scheme#exact->inexact */
t5=*((C_word*)lf[86]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t3;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}}}}}

/* k19189 in ##sys#sqrt/loc in k12641 in k11449 */
static void C_ccall f_19191(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_19191,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19195,a[2]=C_SCHEME_UNDEFINED,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2759: scheme#magnitude */
t3=*((C_word*)lf[620]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k19193 in k19189 in ##sys#sqrt/loc in k12641 in k11449 */
static void C_ccall f_19195(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_19195,c,av);}
a=C_alloc(7);
t2=C_a_i_sqrt(&a,1,t1);
t3=C_mutate(((C_word *)t0)+2,t2);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19214,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2760: scheme#cos */
t5=*((C_word*)lf[675]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(