/* Generated from tcp.scm by the CHICKEN compiler
   http://www.call-cc.org
   Version 6.0.0pre3 ((HEAD detached at 6.0.0pre3)) (rev 57e82bac)
   linux-unix-gnu-x86-64 [ 64bit dload ptables ]
   command line: tcp.scm -optimize-level 2 -include-path . -include-path ./ -inline -ignore-repository -feature chicken-bootstrap -no-warnings -specialize -consult-types-file ./types.db -explicit-use -no-trace -output-file tcp.c -emit-import-library chicken.tcp
   unit: tcp
   uses: scheduler port library
*/
#include "chicken.h"

#ifdef _WIN32
# include <winsock2.h>
# include <ws2tcpip.h>
/* Beware: winsock2.h must come BEFORE windows.h */
# define socklen_t	 int
static WSADATA wsa;
# ifndef SHUT_RD
#  define SHUT_RD	  SD_RECEIVE
# endif
# ifndef SHUT_WR
#  define SHUT_WR	  SD_SEND
# endif

# define typecorrect_getsockopt(socket, level, optname, optval, optlen)	\
    getsockopt(socket, level, optname, (char *)optval, optlen)

static C_word make_socket_nonblocking (C_word sock) {
  int fd = C_unfix(sock);
  C_return(C_mk_bool(ioctlsocket(fd, FIONBIO, (void *)&fd) != SOCKET_ERROR)) ;
}

/* This is a bit of a hack, but it keeps things simple */
static C_char *last_wsa_errorstring = NULL;

static char *errormsg_from_code(int code) {
  int bufsize;
  if (last_wsa_errorstring != NULL) {
    LocalFree(last_wsa_errorstring);
    last_wsa_errorstring = NULL;
  }
  bufsize = FormatMessage(
	FORMAT_MESSAGE_ALLOCATE_BUFFER |
	FORMAT_MESSAGE_FROM_SYSTEM |
	FORMAT_MESSAGE_IGNORE_INSERTS,
	NULL, code, MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
	(LPTSTR) &last_wsa_errorstring, 0, NULL);
  if (bufsize == 0) return "ERROR WHILE FETCHING ERROR";
  return last_wsa_errorstring;
}

# define get_last_socket_error()  WSAGetLastError()
# define should_retry_call()      (WSAGetLastError() == WSAEWOULDBLOCK)
/* Not EINPROGRESS in winsock.  Nonblocking connect returns EWOULDBLOCK... */
# define call_in_progress()       (WSAGetLastError() == WSAEWOULDBLOCK)
# define call_was_interrupted()   (WSAGetLastError() == WSAEINTR) /* ? */

#else
# include <errno.h>
# include <fcntl.h>
# include <sys/socket.h>
# include <sys/time.h>
# include <netinet/in.h>
# include <netdb.h>
# include <signal.h>
# define closesocket     close
# define INVALID_SOCKET  -1
# define SOCKET_ERROR    -1
# define typecorrect_getsockopt getsockopt

static C_word make_socket_nonblocking (C_word sock) {
  int fd = C_unfix(sock);
  int val = fcntl(fd, F_GETFL, 0);
  if(val == -1) C_return(C_SCHEME_FALSE);
  C_return(C_mk_bool(fcntl(fd, F_SETFL, val | O_NONBLOCK) != -1));
}

# define get_last_socket_error()  errno
# define errormsg_from_code(e)    strerror(e)

# define should_retry_call()      (errno == EAGAIN || errno == EWOULDBLOCK)
# define call_was_interrupted()   (errno == EINTR)
# define call_in_progress()       (errno == EINPROGRESS)
#endif

#ifdef ECOS
#include <sys/sockio.h>
#endif

#ifndef h_addr
# define h_addr  h_addr_list[ 0 ]
#endif

static char addr_buffer[ 20 ];

static int C_set_socket_options(int socket)
{
  int yes = 1; 
  int r;

  r = setsockopt(socket, SOL_SOCKET, SO_REUSEADDR, (const char *)&yes, sizeof(int));
  
  if(r != 0) return r;

#ifdef SO_NOSIGPIPE
  /*
   * Avoid SIGPIPE (iOS uses *only* SIGPIPE otherwise, not returning EPIPE).
   * For consistency we do this everywhere the option is supported.
   */
  r = setsockopt(socket, SOL_SOCKET, SO_NOSIGPIPE, (const char *)&yes, sizeof(int));
#endif

  return r;
}


static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_scheduler_toplevel)
C_extern void C_ccall C_scheduler_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(C_port_toplevel)
C_extern void C_ccall C_port_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(C_library_toplevel)
C_extern void C_ccall C_library_toplevel(C_word c,C_word *av) C_noret;

static C_word lf[112];
static double C_possibly_force_alignment;
static C_char li0[] C_aligned={C_lihdr(0,0,50),40,99,104,105,99,107,101,110,46,116,99,112,35,103,101,116,104,111,115,116,97,100,100,114,32,115,97,100,100,114,50,54,57,32,104,111,115,116,50,55,48,32,112,111,114,116,50,55,49,41,0,0,0,0,0,0};
static C_char li1[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,116,99,112,35,116,99,112,45,108,105,115,116,101,110,32,112,111,114,116,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char li2[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,116,99,112,35,116,99,112,45,108,105,115,116,101,110,101,114,63,32,120,41,0,0,0};
static C_char li3[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,116,99,112,35,116,99,112,45,99,108,111,115,101,32,116,99,112,108,41,0,0,0,0};
static C_char li4[] C_aligned={C_lihdr(0,0,10),40,102,95,49,54,57,57,32,120,41,0,0,0,0,0,0};
static C_char li5[] C_aligned={C_lihdr(0,0,11),40,99,104,101,99,107,32,108,111,99,41,0,0,0,0,0};
static C_char li6[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char li7[] C_aligned={C_lihdr(0,0,12),40,114,101,97,100,45,105,110,112,117,116,41,0,0,0,0};
static C_char li8[] C_aligned={C_lihdr(0,0,7),40,97,49,57,49,57,41,0};
static C_char li9[] C_aligned={C_lihdr(0,0,21),40,108,111,111,112,32,108,101,110,32,111,102,102,115,101,116,32,100,108,119,41,0,0,0};
static C_char li10[] C_aligned={C_lihdr(0,0,21),40,97,49,56,53,53,32,98,117,102,32,115,116,97,114,116,32,108,101,110,41,0,0,0};
static C_char li11[] C_aligned={C_lihdr(0,0,23),40,111,117,116,112,117,116,45,116,111,45,115,111,99,107,101,116,32,98,118,32,110,41,0};
static C_char li12[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,110,32,112,41,0,0,0,0,0,0};
static C_char li13[] C_aligned={C_lihdr(0,0,17),40,97,100,100,45,116,111,45,98,117,102,32,98,118,32,110,41,0,0,0,0,0,0,0};
static C_char li14[] C_aligned={C_lihdr(0,0,11),40,97,50,48,54,49,32,112,32,99,41,0,0,0,0,0};
static C_char li15[] C_aligned={C_lihdr(0,0,20),40,97,50,48,55,54,32,112,32,98,118,32,102,114,111,109,32,116,111,41,0,0,0,0};
static C_char li16[] C_aligned={C_lihdr(0,0,11),40,97,50,48,57,55,32,112,32,100,41,0,0,0,0,0};
static C_char li17[] C_aligned={C_lihdr(0,0,9),40,97,50,49,54,48,32,112,41,0,0,0,0,0,0,0};
static C_char li18[] C_aligned={C_lihdr(0,0,19),40,97,50,49,57,53,32,98,117,102,32,115,116,97,114,116,32,110,41,0,0,0,0,0};
static C_char li19[] C_aligned={C_lihdr(0,0,7),40,97,50,49,55,54,41,0};
static C_char li20[] C_aligned={C_lihdr(0,0,7),40,97,50,50,48,56,41,0};
static C_char li21[] C_aligned={C_lihdr(0,0,7),40,97,50,50,53,48,41,0};
static C_char li22[] C_aligned={C_lihdr(0,0,19),40,97,50,51,49,57,32,98,117,102,32,115,116,97,114,116,32,110,41,0,0,0,0,0};
static C_char li23[] C_aligned={C_lihdr(0,0,7),40,97,50,51,48,48,41,0};
static C_char li24[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,110,32,109,32,115,116,97,114,116,41};
static C_char li25[] C_aligned={C_lihdr(0,0,22),40,97,50,51,50,56,32,112,32,110,32,100,101,115,116,32,115,116,97,114,116,41,0,0};
static C_char li26[] C_aligned={C_lihdr(0,0,11),40,97,50,52,49,55,32,112,111,115,41,0,0,0,0,0};
static C_char li27[] C_aligned={C_lihdr(0,0,7),40,97,50,52,48,55,41,0};
static C_char li28[] C_aligned={C_lihdr(0,0,28),40,97,50,52,54,55,32,110,101,120,116,32,108,105,110,101,32,102,117,108,108,45,108,105,110,101,63,41,0,0,0,0};
static C_char li29[] C_aligned={C_lihdr(0,0,15),40,97,50,51,56,57,32,112,32,108,105,109,105,116,41,0};
static C_char li30[] C_aligned={C_lihdr(0,0,9),40,97,50,53,49,50,32,112,41,0,0,0,0,0,0,0};
static C_char li31[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,116,99,112,35,105,111,45,112,111,114,116,115,32,108,111,99,32,102,100,32,101,110,99,41,0,0,0,0,0,0,0};
static C_char li32[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char li33[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,116,99,112,35,116,99,112,45,97,99,99,101,112,116,32,116,99,112,108,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char li34[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,116,99,112,35,116,99,112,45,97,99,99,101,112,116,45,114,101,97,100,121,63,32,116,99,112,108,41,0,0,0,0};
static C_char li35[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char li36[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li37[] C_aligned={C_lihdr(0,0,7),40,97,50,57,56,50,41,0};
static C_char li38[] C_aligned={C_lihdr(0,0,23),40,97,50,57,56,56,32,104,111,115,116,55,54,55,32,112,111,114,116,55,54,56,41,0};
static C_char li39[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,116,99,112,35,116,99,112,45,99,111,110,110,101,99,116,32,104,111,115,116,32,46,32,114,101,115,116,41,0,0,0};
static C_char li40[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,116,99,112,35,116,99,112,45,112,111,114,116,45,62,102,105,108,101,110,111,32,112,32,108,111,99,41,0,0,0,0};
static C_char li41[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,116,99,112,35,116,99,112,45,97,100,100,114,101,115,115,101,115,32,112,41,0,0,0};
static C_char li42[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,116,99,112,35,116,99,112,45,112,111,114,116,45,110,117,109,98,101,114,115,32,112,41};
static C_char li43[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,116,99,112,35,116,99,112,45,108,105,115,116,101,110,101,114,45,112,111,114,116,32,116,99,112,108,41,0,0,0,0};
static C_char li44[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,116,99,112,35,116,99,112,45,97,98,97,110,100,111,110,45,112,111,114,116,32,112,41};
static C_char li45[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,116,99,112,35,116,99,112,45,108,105,115,116,101,110,101,114,45,102,105,108,101,110,111,32,108,41,0,0,0,0,0};
static C_char li46[] C_aligned={C_lihdr(0,0,10),40,116,111,112,108,101,118,101,108,41,0,0,0,0,0,0};


#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_ret; C_cblockend
C_regparm static C_word stub743(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int socket=(int )C_unfix(C_a0);
int err, optlen;
optlen = sizeof(err);
if (typecorrect_getsockopt(socket, SOL_SOCKET, SO_ERROR, &err, (socklen_t *)&optlen) == SOCKET_ERROR)
  C_return(SOCKET_ERROR);
C_return(err);
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (((C_word)(x))); goto C_ret; C_cblockend
C_regparm static C_word stub404(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * saddr=(void * )C_data_pointer(C_a0);
unsigned short port=(unsigned short )(unsigned short)C_unfix(C_a1);
struct sockaddr_in *addr = (struct sockaddr_in *)saddr;
memset(addr, 0, sizeof(struct sockaddr_in));
addr->sin_family = AF_INET;
addr->sin_port = htons(port);
addr->sin_addr.s_addr = htonl(INADDR_ANY);
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
C_regparm static C_word stub272(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * saddr=(void * )C_data_pointer(C_a0);
char * host=(char * )C_string_or_null(C_a1);
unsigned short port=(unsigned short )(unsigned short)C_unfix(C_a2);
struct hostent *he = gethostbyname(host);
struct sockaddr_in *addr = (struct sockaddr_in *)saddr;
if(he == NULL) C_return(0);
memset(addr, 0, sizeof(struct sockaddr_in));
addr->sin_family = AF_INET;
addr->sin_port = htons((short)port);
addr->sin_addr = *((struct in_addr *)he->h_addr);
C_return(1);
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_ret; C_cblockend
C_regparm static C_word stub260(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * serv=(char * )C_string_or_null(C_a0);
char * proto=(char * )C_string_or_null(C_a1);
struct servent *se;
     if((se = getservbyname(serv, proto)) == NULL) C_return(0);
     else C_return(ntohs(se->s_port));
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
C_regparm static C_word stub255(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
#ifdef _WIN32
     C_return(WSAStartup(MAKEWORD(1, 1), &wsa) == 0);
#else
     signal(SIGPIPE, SIG_IGN);
     C_return(1);
#endif
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
C_regparm static C_word stub250(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int s=(int )C_unfix(C_a0);
struct sockaddr_in sa;
unsigned char *ptr;
unsigned int len = sizeof(struct sockaddr_in);
if(getpeername(s, (struct sockaddr *)&sa, ((socklen_t *)&len)) != 0) C_return(NULL);
ptr = (unsigned char *)&sa.sin_addr;
C_snprintf(addr_buffer, sizeof(addr_buffer), "%d.%d.%d.%d", ptr[ 0 ], ptr[ 1 ], ptr[ 2 ], ptr[ 3 ]);
C_return(addr_buffer);
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_ret; C_cblockend
C_regparm static C_word stub245(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int s=(int )C_unfix(C_a0);
struct sockaddr_in sa;
int len = sizeof(struct sockaddr_in);
if(getpeername(s, (struct sockaddr *)&sa, (socklen_t *)(&len)) != 0) C_return(-1);
else C_return(ntohs(sa.sin_port));
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_ret; C_cblockend
C_regparm static C_word stub240(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int s=(int )C_unfix(C_a0);
struct sockaddr_in sa;
int len = sizeof(struct sockaddr_in);
if(getsockname(s, (struct sockaddr *)&sa, (socklen_t *)(&len)) != 0) C_return(-1);
else C_return(ntohs(sa.sin_port));
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
C_regparm static C_word stub234(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int s=(int )C_unfix(C_a0);
struct sockaddr_in sa;
unsigned char *ptr;
int len = sizeof(struct sockaddr_in);
if(getsockname(s, (struct sockaddr *)&sa, (socklen_t *)&len) != 0) C_return(NULL);
ptr = (unsigned char *)&sa.sin_addr;
C_snprintf(addr_buffer, sizeof(addr_buffer), "%d.%d.%d.%d", ptr[ 0 ], ptr[ 1 ], ptr[ 2 ], ptr[ 3 ]);
C_return(addr_buffer);
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_fix((C_word)(x))); goto C_ret; C_cblockend
C_regparm static C_word stub223(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3,C_word C_a4){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int s=(int )C_unfix(C_a0);
void * msg=(void * )C_data_pointer_or_null(C_a1);
int offset=(int )C_unfix(C_a2);
int len=(int )C_unfix(C_a3);
int flags=(int )C_unfix(C_a4);
C_return(send(s, (char *)msg+offset, len, flags));
C_ret:
#undef return

return C_r;}

/* from k1230 */
C_regparm static C_word stub214(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_set_socket_options(t0));
return C_r;}

/* from k1223 */
C_regparm static C_word stub209(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_check_fd_ready(t0));
return C_r;}

/* from k1213 */
C_regparm static C_word stub200(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_r=C_fix((C_word)connect(t0,t1,t2));
return C_r;}

/* from k1198 */
C_regparm static C_word stub192(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_fix((C_word)shutdown(t0,t1));
return C_r;}

/* from k1184 */
C_regparm static C_word stub181(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
int t3=(int )C_unfix(C_a3);
C_r=C_fix((C_word)recv(t0,t1,t2,t3));
return C_r;}

/* from k1165 */
C_regparm static C_word stub173(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)closesocket(t0));
return C_r;}

/* from k1152 */
C_regparm static C_word stub162(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_c_pointer_or_null(C_a1);
void * t2=(void * )C_c_pointer_or_null(C_a2);
C_r=C_fix((C_word)accept(t0,t1,t2));
return C_r;}

/* from k1137 */
C_regparm static C_word stub154(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_fix((C_word)listen(t0,t1));
return C_r;}

/* from k1123 */
C_regparm static C_word stub144(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
int t2=(int )C_unfix(C_a2);
C_r=C_fix((C_word)bind(t0,t1,t2));
return C_r;}

/* from k1108 */
C_regparm static C_word stub135(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
int t2=(int )C_unfix(C_a2);
C_r=C_fix((C_word)socket(t0,t1,t2));
return C_r;}

/* from chicken.tcp#interrupted? */
C_regparm static C_word stub129(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_mk_bool(call_was_interrupted());
return C_r;}

/* from chicken.tcp#in-progress? */
C_regparm static C_word stub126(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_mk_bool(call_in_progress());
return C_r;}

/* from chicken.tcp#retry? */
C_regparm static C_word stub123(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_mk_bool(should_retry_call());
return C_r;}

/* from k1084 */
C_regparm static C_word stub118(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)errormsg_from_code(t0));
return C_r;}

/* from chicken.tcp#last-error-code */
C_regparm static C_word stub114(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)get_last_socket_error());
return C_r;}

C_noret_decl(f3610)
static void C_ccall f3610(C_word c,C_word *av) C_noret;
C_noret_decl(f_1066)
static void C_ccall f_1066(C_word c,C_word *av) C_noret;
C_noret_decl(f_1069)
static void C_ccall f_1069(C_word c,C_word *av) C_noret;
C_noret_decl(f_1072)
static void C_ccall f_1072(C_word c,C_word *av) C_noret;
C_noret_decl(f_1300)
static void C_ccall f_1300(C_word c,C_word *av) C_noret;
C_noret_decl(f_1307)
static void C_ccall f_1307(C_word c,C_word *av) C_noret;
C_noret_decl(f_1311)
static void C_ccall f_1311(C_word c,C_word *av) C_noret;
C_noret_decl(f_1327)
static void f_1327(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_1336)
static void C_ccall f_1336(C_word c,C_word *av) C_noret;
C_noret_decl(f_1359)
static void f_1359(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_1384)
static void C_ccall f_1384(C_word c,C_word *av) C_noret;
C_noret_decl(f_1388)
static void C_ccall f_1388(C_word c,C_word *av) C_noret;
C_noret_decl(f_1391)
static void f_1391(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1394)
static void C_ccall f_1394(C_word c,C_word *av) C_noret;
C_noret_decl(f_1404)
static void C_ccall f_1404(C_word c,C_word *av) C_noret;
C_noret_decl(f_1408)
static void C_ccall f_1408(C_word c,C_word *av) C_noret;
C_noret_decl(f_1412)
static void C_ccall f_1412(C_word c,C_word *av) C_noret;
C_noret_decl(f_1447)
static void C_ccall f_1447(C_word c,C_word *av) C_noret;
C_noret_decl(f_1450)
static void C_ccall f_1450(C_word c,C_word *av) C_noret;
C_noret_decl(f_1456)
static void C_ccall f_1456(C_word c,C_word *av) C_noret;
C_noret_decl(f_1459)
static void C_ccall f_1459(C_word c,C_word *av) C_noret;
C_noret_decl(f_1462)
static void C_ccall f_1462(C_word c,C_word *av) C_noret;
C_noret_decl(f_1478)
static void C_ccall f_1478(C_word c,C_word *av) C_noret;
C_noret_decl(f_1482)
static void C_ccall f_1482(C_word c,C_word *av) C_noret;
C_noret_decl(f_1486)
static void C_ccall f_1486(C_word c,C_word *av) C_noret;
C_noret_decl(f_1502)
static void C_ccall f_1502(C_word c,C_word *av) C_noret;
C_noret_decl(f_1506)
static void C_ccall f_1506(C_word c,C_word *av) C_noret;
C_noret_decl(f_1510)
static void C_ccall f_1510(C_word c,C_word *av) C_noret;
C_noret_decl(f_1532)
static void C_ccall f_1532(C_word c,C_word *av) C_noret;
C_noret_decl(f_1541)
static void C_ccall f_1541(C_word c,C_word *av) C_noret;
C_noret_decl(f_1560)
static void C_ccall f_1560(C_word c,C_word *av) C_noret;
C_noret_decl(f_1566)
static void f_1566(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1569)
static void C_ccall f_1569(C_word c,C_word *av) C_noret;
C_noret_decl(f_1588)
static void C_ccall f_1588(C_word c,C_word *av) C_noret;
C_noret_decl(f_1592)
static void C_ccall f_1592(C_word c,C_word *av) C_noret;
C_noret_decl(f_1596)
static void C_ccall f_1596(C_word c,C_word *av) C_noret;
C_noret_decl(f_1640)
static void C_ccall f_1640(C_word c,C_word *av) C_noret;
C_noret_decl(f_1649)
static void C_ccall f_1649(C_word c,C_word *av) C_noret;
C_noret_decl(f_1669)
static void C_ccall f_1669(C_word c,C_word *av) C_noret;
C_noret_decl(f_1673)
static void C_ccall f_1673(C_word c,C_word *av) C_noret;
C_noret_decl(f_1677)
static void C_ccall f_1677(C_word c,C_word *av) C_noret;
C_noret_decl(f_1691)
static void C_ccall f_1691(C_word c,C_word *av) C_noret;
C_noret_decl(f_1697)
static void f_1697(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1699)
static void C_ccall f_1699(C_word c,C_word *av) C_noret;
C_noret_decl(f_1714)
static void C_ccall f_1714(C_word c,C_word *av) C_noret;
C_noret_decl(f_1718)
static void C_ccall f_1718(C_word c,C_word *av) C_noret;
C_noret_decl(f_1722)
static void C_ccall f_1722(C_word c,C_word *av) C_noret;
C_noret_decl(f_1726)
static void C_ccall f_1726(C_word c,C_word *av) C_noret;
C_noret_decl(f_1728)
static void f_1728(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_1732)
static void C_ccall f_1732(C_word c,C_word *av) C_noret;
C_noret_decl(f_1735)
static void C_ccall f_1735(C_word c,C_word *av) C_noret;
C_noret_decl(f_1741)
static void C_ccall f_1741(C_word c,C_word *av) C_noret;
C_noret_decl(f_1744)
static void C_ccall f_1744(C_word c,C_word *av) C_noret;
C_noret_decl(f_1745)
static void f_1745(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1749)
static void C_ccall f_1749(C_word c,C_word *av) C_noret;
C_noret_decl(f_1752)
static void f_1752(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1757)
static void C_ccall f_1757(C_word c,C_word *av) C_noret;
C_noret_decl(f_1776)
static void C_ccall f_1776(C_word c,C_word *av) C_noret;
C_noret_decl(f_1779)
static void C_ccall f_1779(C_word c,C_word *av) C_noret;
C_noret_decl(f_1782)
static void C_ccall f_1782(C_word c,C_word *av) C_noret;
C_noret_decl(f_1785)
static void C_ccall f_1785(C_word c,C_word *av) C_noret;
C_noret_decl(f_1813)
static void C_ccall f_1813(C_word c,C_word *av) C_noret;
C_noret_decl(f_1817)
static void C_ccall f_1817(C_word c,C_word *av) C_noret;
C_noret_decl(f_1821)
static void C_ccall f_1821(C_word c,C_word *av) C_noret;
C_noret_decl(f_1839)
static void C_ccall f_1839(C_word c,C_word *av) C_noret;
C_noret_decl(f_1842)
static void C_ccall f_1842(C_word c,C_word *av) C_noret;
C_noret_decl(f_1843)
static void f_1843(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_1847)
static void C_ccall f_1847(C_word c,C_word *av) C_noret;
C_noret_decl(f_1856)
static void C_ccall f_1856(C_word c,C_word *av) C_noret;
C_noret_decl(f_1864)
static void f_1864(C_word t0,C_word t1) C_noret;
C_noret_decl(f_1866)
static void f_1866(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_1888)
static void C_ccall f_1888(C_word c,C_word *av) C_noret;
C_noret_decl(f_1891)
static void C_ccall f_1891(C_word c,C_word *av) C_noret;
C_noret_decl(f_1894)
static void C_ccall f_1894(C_word c,C_word *av) C_noret;
C_noret_decl(f_1897)
static void C_ccall f_1897(C_word c,C_word *av) C_noret;
C_noret_decl(f_1920)
static void C_ccall f_1920(C_word c,C_word *av) C_noret;
C_noret_decl(f_1931)
static void C_ccall f_1931(C_word c,C_word *av) C_noret;
C_noret_decl(f_1935)
static void C_ccall f_1935(C_word c,C_word *av) C_noret;
C_noret_decl(f_1939)
static void C_ccall f_1939(C_word c,C_word *av) C_noret;
C_noret_decl(f_1979)
static void C_ccall f_1979(C_word c,C_word *av) C_noret;
C_noret_decl(f_1986)
static void C_ccall f_1986(C_word c,C_word *av) C_noret;
C_noret_decl(f_1987)
static void f_1987(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_1993)
static void f_1993(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_2015)
static void C_ccall f_2015(C_word c,C_word *av) C_noret;
C_noret_decl(f_2037)
static void C_ccall f_2037(C_word c,C_word *av) C_noret;
C_noret_decl(f_2046)
static void C_ccall f_2046(C_word c,C_word *av) C_noret;
C_noret_decl(f_2049)
static void C_ccall f_2049(C_word c,C_word *av) C_noret;
C_noret_decl(f_2062)
static void C_ccall f_2062(C_word c,C_word *av) C_noret;
C_noret_decl(f_2066)
static void C_ccall f_2066(C_word c,C_word *av) C_noret;
C_noret_decl(f_2077)
static void C_ccall f_2077(C_word c,C_word *av) C_noret;
C_noret_decl(f_2098)
static void C_ccall f_2098(C_word c,C_word *av) C_noret;
C_noret_decl(f_2106)
static void f_2106(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2109)
static void f_2109(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2115)
static void f_2115(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2122)
static void C_ccall f_2122(C_word c,C_word *av) C_noret;
C_noret_decl(f_2126)
static void C_ccall f_2126(C_word c,C_word *av) C_noret;
C_noret_decl(f_2130)
static void C_ccall f_2130(C_word c,C_word *av) C_noret;
C_noret_decl(f_2155)
static void C_ccall f_2155(C_word c,C_word *av) C_noret;
C_noret_decl(f_2161)
static void C_ccall f_2161(C_word c,C_word *av) C_noret;
C_noret_decl(f_2171)
static void C_ccall f_2171(C_word c,C_word *av) C_noret;
C_noret_decl(f_2177)
static void C_ccall f_2177(C_word c,C_word *av) C_noret;
C_noret_decl(f_2181)
static void C_ccall f_2181(C_word c,C_word *av) C_noret;
C_noret_decl(f_2196)
static void C_ccall f_2196(C_word c,C_word *av) C_noret;
C_noret_decl(f_2209)
static void C_ccall f_2209(C_word c,C_word *av) C_noret;
C_noret_decl(f_2222)
static void C_ccall f_2222(C_word c,C_word *av) C_noret;
C_noret_decl(f_2235)
static void C_ccall f_2235(C_word c,C_word *av) C_noret;
C_noret_decl(f_2239)
static void C_ccall f_2239(C_word c,C_word *av) C_noret;
C_noret_decl(f_2243)
static void C_ccall f_2243(C_word c,C_word *av) C_noret;
C_noret_decl(f_2251)
static void C_ccall f_2251(C_word c,C_word *av) C_noret;
C_noret_decl(f_2259)
static void f_2259(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2265)
static void f_2265(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2272)
static void C_ccall f_2272(C_word c,C_word *av) C_noret;
C_noret_decl(f_2276)
static void C_ccall f_2276(C_word c,C_word *av) C_noret;
C_noret_decl(f_2280)
static void C_ccall f_2280(C_word c,C_word *av) C_noret;
C_noret_decl(f_2301)
static void C_ccall f_2301(C_word c,C_word *av) C_noret;
C_noret_decl(f_2305)
static void C_ccall f_2305(C_word c,C_word *av) C_noret;
C_noret_decl(f_2320)
static void C_ccall f_2320(C_word c,C_word *av) C_noret;
C_noret_decl(f_2329)
static void C_ccall f_2329(C_word c,C_word *av) C_noret;
C_noret_decl(f_2335)
static void f_2335(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_2379)
static void C_ccall f_2379(C_word c,C_word *av) C_noret;
C_noret_decl(f_2390)
static void C_ccall f_2390(C_word c,C_word *av) C_noret;
C_noret_decl(f_2394)
static void C_ccall f_2394(C_word c,C_word *av) C_noret;
C_noret_decl(f_2408)
static void C_ccall f_2408(C_word c,C_word *av) C_noret;
C_noret_decl(f_2418)
static void C_ccall f_2418(C_word c,C_word *av) C_noret;
C_noret_decl(f_2434)
static void C_ccall f_2434(C_word c,C_word *av) C_noret;
C_noret_decl(f_2468)
static void C_ccall f_2468(C_word c,C_word *av) C_noret;
C_noret_decl(f_2513)
static void C_ccall f_2513(C_word c,C_word *av) C_noret;
C_noret_decl(f_2523)
static void C_ccall f_2523(C_word c,C_word *av) C_noret;
C_noret_decl(f_2550)
static void C_ccall f_2550(C_word c,C_word *av) C_noret;
C_noret_decl(f_2554)
static void C_ccall f_2554(C_word c,C_word *av) C_noret;
C_noret_decl(f_2558)
static void C_ccall f_2558(C_word c,C_word *av) C_noret;
C_noret_decl(f_2562)
static void C_ccall f_2562(C_word c,C_word *av) C_noret;
C_noret_decl(f_2575)
static void C_ccall f_2575(C_word c,C_word *av) C_noret;
C_noret_decl(f_2578)
static void f_2578(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2583)
static void C_ccall f_2583(C_word c,C_word *av) C_noret;
C_noret_decl(f_2587)
static void C_ccall f_2587(C_word c,C_word *av) C_noret;
C_noret_decl(f_2590)
static void C_ccall f_2590(C_word c,C_word *av) C_noret;
C_noret_decl(f_2593)
static void C_ccall f_2593(C_word c,C_word *av) C_noret;
C_noret_decl(f_2596)
static void C_ccall f_2596(C_word c,C_word *av) C_noret;
C_noret_decl(f_2624)
static void C_ccall f_2624(C_word c,C_word *av) C_noret;
C_noret_decl(f_2628)
static void C_ccall f_2628(C_word c,C_word *av) C_noret;
C_noret_decl(f_2632)
static void C_ccall f_2632(C_word c,C_word *av) C_noret;
C_noret_decl(f_2658)
static void C_ccall f_2658(C_word c,C_word *av) C_noret;
C_noret_decl(f_2666)
static void C_ccall f_2666(C_word c,C_word *av) C_noret;
C_noret_decl(f_2676)
static void C_ccall f_2676(C_word c,C_word *av) C_noret;
C_noret_decl(f_2689)
static void C_ccall f_2689(C_word c,C_word *av) C_noret;
C_noret_decl(f_2693)
static void C_ccall f_2693(C_word c,C_word *av) C_noret;
C_noret_decl(f_2697)
static void C_ccall f_2697(C_word c,C_word *av) C_noret;
C_noret_decl(f_2716)
static void C_ccall f_2716(C_word c,C_word *av) C_noret;
C_noret_decl(f_2732)
static void C_ccall f_2732(C_word c,C_word *av) C_noret;
C_noret_decl(f_2735)
static void f_2735(C_word t0,C_word t1) C_noret;
C_noret_decl(f_2738)
static void C_ccall f_2738(C_word c,C_word *av) C_noret;
C_noret_decl(f_2744)
static void C_ccall f_2744(C_word c,C_word *av) C_noret;
C_noret_decl(f_2750)
static void C_ccall f_2750(C_word c,C_word *av) C_noret;
C_noret_decl(f_2756)
static void C_ccall f_2756(C_word c,C_word *av) C_noret;
C_noret_decl(f_2759)
static void C_ccall f_2759(C_word c,C_word *av) C_noret;
C_noret_decl(f_2762)
static void C_ccall f_2762(C_word c,C_word *av) C_noret;
C_noret_decl(f_2765)
static void C_ccall f_2765(C_word c,C_word *av) C_noret;
C_noret_decl(f_2771)
static void C_ccall f_2771(C_word c,C_word *av) C_noret;
C_noret_decl(f_2790)
static void C_ccall f_2790(C_word c,C_word *av) C_noret;
C_noret_decl(f_2794)
static void C_ccall f_2794(C_word c,C_word *av) C_noret;
C_noret_decl(f_2798)
static void C_ccall f_2798(C_word c,C_word *av) C_noret;
C_noret_decl(f_2816)
static void C_ccall f_2816(C_word c,C_word *av) C_noret;
C_noret_decl(f_2820)
static void C_ccall f_2820(C_word c,C_word *av) C_noret;
C_noret_decl(f_2824)
static void C_ccall f_2824(C_word c,C_word *av) C_noret;
C_noret_decl(f_2828)
static void C_ccall f_2828(C_word c,C_word *av) C_noret;
C_noret_decl(f_2844)
static void C_ccall f_2844(C_word c,C_word *av) C_noret;
C_noret_decl(f_2847)
static void C_ccall f_2847(C_word c,C_word *av) C_noret;
C_noret_decl(f_2875)
static void C_ccall f_2875(C_word c,C_word *av) C_noret;
C_noret_decl(f_2879)
static void C_ccall f_2879(C_word c,C_word *av) C_noret;
C_noret_decl(f_2883)
static void C_ccall f_2883(C_word c,C_word *av) C_noret;
C_noret_decl(f_2902)
static void C_ccall f_2902(C_word c,C_word *av) C_noret;
C_noret_decl(f_2906)
static void C_ccall f_2906(C_word c,C_word *av) C_noret;
C_noret_decl(f_2910)
static void C_ccall f_2910(C_word c,C_word *av) C_noret;
C_noret_decl(f_2928)
static void C_ccall f_2928(C_word c,C_word *av) C_noret;
C_noret_decl(f_2932)
static void C_ccall f_2932(C_word c,C_word *av) C_noret;
C_noret_decl(f_2936)
static void C_ccall f_2936(C_word c,C_word *av) C_noret;
C_noret_decl(f_2952)
static void C_ccall f_2952(C_word c,C_word *av) C_noret;
C_noret_decl(f_2956)
static void C_ccall f_2956(C_word c,C_word *av) C_noret;
C_noret_decl(f_2960)
static void C_ccall f_2960(C_word c,C_word *av) C_noret;
C_noret_decl(f_2969)
static void C_ccall f_2969(C_word c,C_word *av) C_noret;
C_noret_decl(f_2975)
static void C_ccall f_2975(C_word c,C_word *av) C_noret;
C_noret_decl(f_2983)
static void C_ccall f_2983(C_word c,C_word *av) C_noret;
C_noret_decl(f_2989)
static void C_ccall f_2989(C_word c,C_word *av) C_noret;
C_noret_decl(f_3000)
static void C_ccall f_3000(C_word c,C_word *av) C_noret;
C_noret_decl(f_3026)
static void f_3026(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3030)
static void C_ccall f_3030(C_word c,C_word *av) C_noret;
C_noret_decl(f_3044)
static void C_ccall f_3044(C_word c,C_word *av) C_noret;
C_noret_decl(f_3050)
static void C_ccall f_3050(C_word c,C_word *av) C_noret;
C_noret_decl(f_3057)
static void C_ccall f_3057(C_word c,C_word *av) C_noret;
C_noret_decl(f_3060)
static void C_ccall f_3060(C_word c,C_word *av) C_noret;
C_noret_decl(f_3064)
static void C_ccall f_3064(C_word c,C_word *av) C_noret;
C_noret_decl(f_3067)
static void C_ccall f_3067(C_word c,C_word *av) C_noret;
C_noret_decl(f_3074)
static void C_ccall f_3074(C_word c,C_word *av) C_noret;
C_noret_decl(f_3078)
static void C_ccall f_3078(C_word c,C_word *av) C_noret;
C_noret_decl(f_3082)
static void C_ccall f_3082(C_word c,C_word *av) C_noret;
C_noret_decl(f_3095)
static void C_ccall f_3095(C_word c,C_word *av) C_noret;
C_noret_decl(f_3099)
static void C_ccall f_3099(C_word c,C_word *av) C_noret;
C_noret_decl(f_3103)
static void C_ccall f_3103(C_word c,C_word *av) C_noret;
C_noret_decl(f_3111)
static void C_ccall f_3111(C_word c,C_word *av) C_noret;
C_noret_decl(f_3117)
static void C_ccall f_3117(C_word c,C_word *av) C_noret;
C_noret_decl(f_3126)
static void C_ccall f_3126(C_word c,C_word *av) C_noret;
C_noret_decl(f_3129)
static void C_ccall f_3129(C_word c,C_word *av) C_noret;
C_noret_decl(f_3142)
static void C_ccall f_3142(C_word c,C_word *av) C_noret;
C_noret_decl(f_3146)
static void C_ccall f_3146(C_word c,C_word *av) C_noret;
C_noret_decl(f_3150)
static void C_ccall f_3150(C_word c,C_word *av) C_noret;
C_noret_decl(f_3166)
static void C_ccall f_3166(C_word c,C_word *av) C_noret;
C_noret_decl(f_3170)
static void C_ccall f_3170(C_word c,C_word *av) C_noret;
C_noret_decl(f_3174)
static void C_ccall f_3174(C_word c,C_word *av) C_noret;
C_noret_decl(f_3182)
static void C_ccall f_3182(C_word c,C_word *av) C_noret;
C_noret_decl(f_3195)
static void C_ccall f_3195(C_word c,C_word *av) C_noret;
C_noret_decl(f_3205)
static void C_ccall f_3205(C_word c,C_word *av) C_noret;
C_noret_decl(f_3209)
static void C_ccall f_3209(C_word c,C_word *av) C_noret;
C_noret_decl(f_3213)
static void C_ccall f_3213(C_word c,C_word *av) C_noret;
C_noret_decl(f_3221)
static void C_ccall f_3221(C_word c,C_word *av) C_noret;
C_noret_decl(f_3231)
static void C_ccall f_3231(C_word c,C_word *av) C_noret;
C_noret_decl(f_3237)
static void C_ccall f_3237(C_word c,C_word *av) C_noret;
C_noret_decl(f_3248)
static void C_ccall f_3248(C_word c,C_word *av) C_noret;
C_noret_decl(f_3252)
static void C_ccall f_3252(C_word c,C_word *av) C_noret;
C_noret_decl(f_3256)
static void C_ccall f_3256(C_word c,C_word *av) C_noret;
C_noret_decl(f_3260)
static void C_ccall f_3260(C_word c,C_word *av) C_noret;
C_noret_decl(C_tcp_toplevel)
C_extern void C_ccall C_tcp_toplevel(C_word c,C_word *av) C_noret;

C_noret_decl(trf_1327)
static void C_ccall trf_1327(C_word c,C_word *av) C_noret;
static void C_ccall trf_1327(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_1327(t0,t1,t2,t3);}

C_noret_decl(trf_1359)
static void C_ccall trf_1359(C_word c,C_word *av) C_noret;
static void C_ccall trf_1359(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_1359(t0,t1,t2);}

C_noret_decl(trf_1391)
static void C_ccall trf_1391(C_word c,C_word *av) C_noret;
static void C_ccall trf_1391(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_1391(t0,t1);}

C_noret_decl(trf_1566)
static void C_ccall trf_1566(C_word c,C_word *av) C_noret;
static void C_ccall trf_1566(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_1566(t0,t1);}

C_noret_decl(trf_1697)
static void C_ccall trf_1697(C_word c,C_word *av) C_noret;
static void C_ccall trf_1697(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_1697(t0,t1);}

C_noret_decl(trf_1728)
static void C_ccall trf_1728(C_word c,C_word *av) C_noret;
static void C_ccall trf_1728(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_1728(t0,t1,t2,t3,t4);}

C_noret_decl(trf_1745)
static void C_ccall trf_1745(C_word c,C_word *av) C_noret;
static void C_ccall trf_1745(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_1745(t0,t1);}

C_noret_decl(trf_1752)
static void C_ccall trf_1752(C_word c,C_word *av) C_noret;
static void C_ccall trf_1752(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_1752(t0,t1);}

C_noret_decl(trf_1843)
static void C_ccall trf_1843(C_word c,C_word *av) C_noret;
static void C_ccall trf_1843(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_1843(t0,t1,t2,t3);}

C_noret_decl(trf_1864)
static void C_ccall trf_1864(C_word c,C_word *av) C_noret;
static void C_ccall trf_1864(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_1864(t0,t1);}

C_noret_decl(trf_1866)
static void C_ccall trf_1866(C_word c,C_word *av) C_noret;
static void C_ccall trf_1866(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_1866(t0,t1,t2,t3,t4);}

C_noret_decl(trf_1987)
static void C_ccall trf_1987(C_word c,C_word *av) C_noret;
static void C_ccall trf_1987(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_1987(t0,t1,t2,t3);}

C_noret_decl(trf_1993)
static void C_ccall trf_1993(C_word c,C_word *av) C_noret;
static void C_ccall trf_1993(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_1993(t0,t1,t2,t3);}

C_noret_decl(trf_2106)
static void C_ccall trf_2106(C_word c,C_word *av) C_noret;
static void C_ccall trf_2106(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_2106(t0,t1);}

C_noret_decl(trf_2109)
static void C_ccall trf_2109(C_word c,C_word *av) C_noret;
static void C_ccall trf_2109(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_2109(t0,t1);}

C_noret_decl(trf_2115)
static void C_ccall trf_2115(C_word c,C_word *av) C_noret;
static void C_ccall trf_2115(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_2115(t0,t1);}

C_noret_decl(trf_2259)
static void C_ccall trf_2259(C_word c,C_word *av) C_noret;
static void C_ccall trf_2259(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_2259(t0,t1);}

C_noret_decl(trf_2265)
static void C_ccall trf_2265(C_word c,C_word *av) C_noret;
static void C_ccall trf_2265(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_2265(t0,t1);}

C_noret_decl(trf_2335)
static void C_ccall trf_2335(C_word c,C_word *av) C_noret;
static void C_ccall trf_2335(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_2335(t0,t1,t2,t3,t4);}

C_noret_decl(trf_2578)
static void C_ccall trf_2578(C_word c,C_word *av) C_noret;
static void C_ccall trf_2578(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_2578(t0,t1);}

C_noret_decl(trf_2735)
static void C_ccall trf_2735(C_word c,C_word *av) C_noret;
static void C_ccall trf_2735(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_2735(t0,t1);}

C_noret_decl(trf_3026)
static void C_ccall trf_3026(C_word c,C_word *av) C_noret;
static void C_ccall trf_3026(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_3026(t0,t1,t2);}

/* f3610 in loop in k2760 in k2757 in k2754 in k2748 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f3610(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f3610,c,av);}
/* tcp.scm:651: ##sys#thread-yield! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[35]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[35]+1);
av2[1]=((C_word*)t0)[2];
tp(2,av2);}}

/* k1064 */
static void C_ccall f_1066(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_1066,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1069,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);{
C_word *av2=av;
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t2;
C_scheduler_toplevel(2,av2);}}

/* k1067 in k1064 */
static void C_ccall f_1069(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(19,c,2)))){
C_save_and_reclaim((void *)f_1069,c,av);}
a=C_alloc(19);
t2=C_a_i_provide(&a,1,lf[0]);
t3=C_a_i_provide(&a,1,lf[1]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1072,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);{
C_word *av2=av;
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t4;
C_library_toplevel(2,av2);}}

/* k1070 in k1067 in k1064 */
static void C_ccall f_1072(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_1072,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1300,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
if(C_truep(stub255(C_SCHEME_UNDEFINED))){
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_1300(2,av2);}}
else{
/* tcp.scm:238: ##sys#signal-hook */
t3=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[7];
av2[3]=lf[111];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}}

/* k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1300(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,c,5)))){
C_save_and_reclaim((void *)f_1300,c,av);}
a=C_alloc(15);
t2=C_mutate(&lf[2] /* (set! chicken.tcp#gethostaddr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1327,a[2]=((C_word)li0),tmp=(C_word)a,a+=3,tmp));
t3=C_mutate((C_word*)lf[4]+1 /* (set! chicken.tcp#tcp-listen ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1541,a[2]=((C_word)li1),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[22]+1 /* (set! chicken.tcp#tcp-listener? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1640,a[2]=((C_word)li2),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[23]+1 /* (set! chicken.tcp#tcp-close ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1649,a[2]=((C_word)li3),tmp=(C_word)a,a+=3,tmp));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1691,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* tcp.scm:346: scheme#make-parameter */
t7=*((C_word*)lf[106]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t7;
av2[1]=t6;
av2[2]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}

/* k1305 in k1386 in k1382 in loop in a2982 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1307(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_1307,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1311,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[3])){
/* tcp.scm:241: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[3]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[3]+1);
av2[1]=t2;
av2[2]=C_i_foreign_string_argumentp(((C_word*)t0)[3]);
tp(3,av2);}}
else{
t3=((C_word*)t0)[2];
f_1391(t3,stub260(C_SCHEME_UNDEFINED,t1,C_SCHEME_FALSE));}}

/* k1309 in k1305 in k1386 in k1382 in loop in a2982 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1311(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_1311,c,av);}
t2=((C_word*)t0)[2];
f_1391(t2,stub260(C_SCHEME_UNDEFINED,((C_word*)t0)[3],t1));}

/* chicken.tcp#gethostaddr in k1298 in k1070 in k1067 in k1064 */
static void f_1327(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_1327,4,t1,t2,t3,t4);}
a=C_alloc(5);
t5=C_i_foreign_block_argumentp(t2);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1336,a[2]=t1,a[3]=t5,a[4]=t4,tmp=(C_word)a,a+=5,tmp);
if(C_truep(t3)){
/* tcp.scm:247: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[3]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[3]+1);
av2[1]=t6;
av2[2]=C_i_foreign_string_argumentp(t3);
tp(3,av2);}}
else{
t7=C_fix((C_word)sizeof(unsigned short) * CHAR_BIT);
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=stub272(C_SCHEME_UNDEFINED,t5,C_SCHEME_FALSE,C_i_foreign_unsigned_ranged_integer_argumentp(t4,t7));
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}

/* k1334 in chicken.tcp#gethostaddr in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1336(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_1336,c,av);}
t2=C_fix((C_word)sizeof(unsigned short) * CHAR_BIT);
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=stub272(C_SCHEME_UNDEFINED,((C_word*)t0)[3],t1,C_i_foreign_unsigned_ranged_integer_argumentp(((C_word*)t0)[4],t2));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* loop in a2982 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void f_1359(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(6,0,4)))){
C_save_and_reclaim_args((void *)trf_1359,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_fixnum_greater_or_equal_p(t2,((C_word*)t0)[2]))){
/* tcp.scm:283: scheme#values */{
C_word av2[4];
av2[0]=0;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
av2[3]=C_SCHEME_FALSE;
C_values(4,av2);}}
else{
t3=C_i_string_ref(((C_word*)t0)[3],t2);
if(C_truep(C_u_i_char_equalp(t3,C_make_character(58)))){
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1384,a[2]=t1,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[3],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* tcp.scm:287: substring */
t5=*((C_word*)lf[86]+1);{
C_word av2[5];
av2[0]=t5;
av2[1]=t4;
av2[2]=((C_word*)t0)[3];
av2[3]=C_fixnum_plus(t2,C_fix(1));
av2[4]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t5+1)))(5,av2);}}
else{
/* tcp.scm:293: loop */
t6=t1;
t7=C_fixnum_plus(t2,C_fix(1));
t1=t6;
t2=t7;
goto loop;}}}

/* k1382 in loop in a2982 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1384(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,4)))){
C_save_and_reclaim((void *)f_1384,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1388,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* tcp.scm:288: substring */
t3=*((C_word*)lf[86]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=C_fix(0);
av2[4]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}

/* k1386 in k1382 in loop in a2982 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1388(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,2)))){
C_save_and_reclaim((void *)f_1388,c,av);}
a=C_alloc(9);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1391,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1307,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
/* tcp.scm:241: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[3]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[3]+1);
av2[1]=t3;
av2[2]=C_i_foreign_string_argumentp(t1);
tp(3,av2);}}
else{
t4=t3;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
f_1307(2,av2);}}}

/* k1389 in k1386 in k1382 in loop in a2982 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void f_1391(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(13,0,3)))){
C_save_and_reclaim_args((void *)trf_1391,2,t0,t1);}
a=C_alloc(13);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1394,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=C_eqp(C_fix(0),t1);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1404,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1408,a[2]=t4,a[3]=C_SCHEME_UNDEFINED,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t5;
av2[2]=lf[85];
av2[3]=lf[13];
tp(4,av2);}}
else{
/* tcp.scm:286: scheme#values */{
C_word av2[4];
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
C_values(4,av2);}}}

/* k1392 in k1389 in k1386 in k1382 in loop in a2982 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1394(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_1394,c,av);}
/* tcp.scm:286: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
C_values(4,av2);}}

/* k1402 in k1389 in k1386 in k1382 in loop in a2982 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1404(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_1404,c,av);}
/* tcp.scm:291: ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[7];
av2[3]=lf[75];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k1406 in k1389 in k1386 in k1382 in loop in a2982 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1408(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_1408,c,av);}
a=C_alloc(8);
t2=C_mutate(((C_word *)t0)+3,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1412,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t4=stub114(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
/* tcp.scm:172: ##sys#peek-c-string */
t7=*((C_word*)lf[10]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=stub118(t5,t6);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k1410 in k1406 in k1389 in k1386 in k1382 in loop in a2982 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1412(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_1412,c,av);}
t2=((C_word*)t0)[2];
/* tcp.scm:291: scheme#string-append */
t3=*((C_word*)lf[9]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=((C_word*)t2)[2];
av2[2]=((C_word*)t2)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k1445 in k1558 in chicken.tcp#tcp-listen in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1447(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,c,4)))){
C_save_and_reclaim((void *)f_1447,c,av);}
a=C_alloc(12);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1450,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t0)[4])){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1532,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* tcp.scm:306: gethostaddr */
f_1327(t3,t1,((C_word*)t0)[4],((C_word*)t0)[5]);}
else{
t3=C_i_foreign_block_argumentp(t1);
t4=C_fix((C_word)sizeof(unsigned short) * CHAR_BIT);
t5=t2;{
C_word *av2=av;
av2[0]=t5;
av2[1]=stub404(C_SCHEME_UNDEFINED,t3,C_i_foreign_unsigned_ranged_integer_argumentp(((C_word*)t0)[5],t4));
f_1450(2,av2);}}}

/* k1448 in k1445 in k1558 in chicken.tcp#tcp-listen in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1450(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_1450,c,av);}
a=C_alloc(7);
t2=C_fix((C_word)AF_INET);
t3=stub135(C_SCHEME_UNDEFINED,C_i_foreign_fixnum_argumentp(t2),C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]),C_fix(0));
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1456,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],tmp=(C_word)a,a+=7,tmp);
t5=C_eqp(C_fix((C_word)INVALID_SOCKET),t3);
if(C_truep(t5)){
/* tcp.scm:313: ##sys#error */
t6=*((C_word*)lf[16]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t6;
av2[1]=t4;
av2[2]=lf[17];
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
t6=t4;{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_SCHEME_UNDEFINED;
f_1456(2,av2);}}}

/* k1454 in k1448 in k1445 in k1558 in chicken.tcp#tcp-listen in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1456(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,3)))){
C_save_and_reclaim((void *)f_1456,c,av);}
a=C_alloc(11);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1459,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t3=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
t4=C_eqp(C_fix((C_word)SOCKET_ERROR),stub214(C_SCHEME_UNDEFINED,t3));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1502,a[2]=t2,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1506,a[2]=t5,a[3]=C_SCHEME_UNDEFINED,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t6;
av2[2]=lf[15];
av2[3]=lf[13];
tp(4,av2);}}
else{
t5=t2;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_SCHEME_UNDEFINED;
f_1459(2,av2);}}}

/* k1457 in k1454 in k1448 in k1445 in k1558 in chicken.tcp#tcp-listen in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1459(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(14,c,3)))){
C_save_and_reclaim((void *)f_1459,c,av);}
a=C_alloc(14);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1462,a[2]=((C_word*)t2)[2],a[3]=((C_word*)t2)[3],tmp=(C_word)a,a+=4,tmp);
t4=C_fix((C_word)sizeof(struct sockaddr_in));
t5=C_i_foreign_fixnum_argumentp(((C_word*)t2)[3]);
t6=(C_truep(((C_word*)t2)[4])?C_i_foreign_block_argumentp(((C_word*)t2)[4]):C_SCHEME_FALSE);
t7=C_i_foreign_fixnum_argumentp(t4);
t8=C_eqp(C_fix((C_word)SOCKET_ERROR),stub144(C_SCHEME_UNDEFINED,t5,t6,t7));
if(C_truep(t8)){
t9=stub114(C_SCHEME_UNDEFINED);
t10=C_i_foreign_fixnum_argumentp(((C_word*)t2)[3]);
t11=stub173(C_SCHEME_UNDEFINED,t10);
t12=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1478,a[2]=t3,a[3]=((C_word*)t2)[3],a[4]=((C_word*)t2)[5],a[5]=((C_word*)t2)[6],tmp=(C_word)a,a+=6,tmp);
t13=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1482,a[2]=t12,a[3]=t9,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t13;
av2[2]=lf[14];
av2[3]=lf[13];
tp(4,av2);}}
else{
t9=((C_word*)t2)[2];
f_1566(t9,((C_word*)t2)[3]);}}

/* k1460 in k1457 in k1454 in k1448 in k1445 in k1558 in chicken.tcp#tcp-listen in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1462(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_1462,c,av);}
t2=((C_word*)t0)[2];
f_1566(t2,((C_word*)t0)[3]);}

/* k1476 in k1457 in k1454 in k1448 in k1445 in k1558 in chicken.tcp#tcp-listen in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1478(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,7)))){
C_save_and_reclaim((void *)f_1478,c,av);}
/* tcp.scm:318: ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 8) {
  av2=av;
} else {
  av2=C_alloc(8);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[7];
av2[3]=lf[8];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
av2[7]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t2+1)))(8,av2);}}

/* k1480 in k1457 in k1454 in k1448 in k1445 in k1558 in chicken.tcp#tcp-listen in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1482(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_1482,c,av);}
a=C_alloc(9);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1486,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=C_a_i_bytevector(&a,1,C_fix(3));
t4=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
/* tcp.scm:172: ##sys#peek-c-string */
t5=*((C_word*)lf[10]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t2;
av2[2]=stub118(t3,t4);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k1484 in k1480 in k1457 in k1454 in k1448 in k1445 in k1558 in chicken.tcp#tcp-listen in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1486(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_1486,c,av);}
/* tcp.scm:318: scheme#string-append */
t2=*((C_word*)lf[9]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k1500 in k1454 in k1448 in k1445 in k1558 in chicken.tcp#tcp-listen in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1502(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_1502,c,av);}
/* tcp.scm:316: ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[7];
av2[3]=lf[8];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k1504 in k1454 in k1448 in k1445 in k1558 in chicken.tcp#tcp-listen in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1506(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_1506,c,av);}
a=C_alloc(8);
t2=C_mutate(((C_word *)t0)+3,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1510,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t4=stub114(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
/* tcp.scm:172: ##sys#peek-c-string */
t7=*((C_word*)lf[10]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=stub118(t5,t6);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k1508 in k1504 in k1454 in k1448 in k1445 in k1558 in chicken.tcp#tcp-listen in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1510(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_1510,c,av);}
t2=((C_word*)t0)[2];
/* tcp.scm:316: scheme#string-append */
t3=*((C_word*)lf[9]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=((C_word*)t2)[2];
av2[2]=((C_word*)t2)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k1530 in k1445 in k1558 in chicken.tcp#tcp-listen in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1532(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_1532,c,av);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
f_1450(2,av2);}}
else{
/* tcp.scm:307: ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[7];
av2[3]=lf[8];
av2[4]=lf[18];
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(7,av2);}}}

/* chicken.tcp#tcp-listen in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1541(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_1541,c,av);}
a=C_alloc(6);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_fix(100):C_get_rest_arg(c,3,av,3,t0));
t5=C_rest_nullp(c,3);
t6=C_rest_nullp(c,4);
t7=(C_truep(t6)?C_SCHEME_FALSE:C_get_rest_arg(c,4,av,3,t0));
t8=C_rest_nullp(c,4);
t9=C_i_check_fixnum(t2);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1560,a[2]=t4,a[3]=t1,a[4]=t2,a[5]=t7,tmp=(C_word)a,a+=6,tmp);
t11=C_fixnum_lessp(t2,C_fix(0));
if(C_truep(t11)){
if(C_truep(t11)){
/* tcp.scm:326: ##sys#signal-hook */
t12=*((C_word*)lf[6]+1);{
C_word av2[6];
av2[0]=t12;
av2[1]=t10;
av2[2]=lf[20];
av2[3]=lf[8];
av2[4]=lf[21];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t12+1)))(6,av2);}}
else{
t12=t10;{
C_word *av2=av;
av2[0]=t12;
av2[1]=C_SCHEME_UNDEFINED;
f_1560(2,av2);}}}
else{
if(C_truep(C_fixnum_greaterp(t2,C_fix(65535)))){
/* tcp.scm:326: ##sys#signal-hook */
t12=*((C_word*)lf[6]+1);{
C_word av2[6];
av2[0]=t12;
av2[1]=t10;
av2[2]=lf[20];
av2[3]=lf[8];
av2[4]=lf[21];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t12+1)))(6,av2);}}
else{
t12=t10;{
C_word *av2=av;
av2[0]=t12;
av2[1]=C_SCHEME_UNDEFINED;
f_1560(2,av2);}}}}

/* k1558 in chicken.tcp#tcp-listen in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1560(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,3)))){
C_save_and_reclaim((void *)f_1560,c,av);}
a=C_alloc(11);
t2=C_i_check_fixnum(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1566,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t4=C_fix((C_word)SOCK_STREAM);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1447,a[2]=t4,a[3]=t3,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t6=C_fix((C_word)sizeof(struct sockaddr_in));
/* ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[19]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[19]+1);
av2[1]=t5;
av2[2]=t6;
av2[3]=C_make_character(32);
tp(4,av2);}}

/* k1564 in k1558 in chicken.tcp#tcp-listen in k1298 in k1070 in k1067 in k1064 */
static void f_1566(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(13,0,3)))){
C_save_and_reclaim_args((void *)trf_1566,2,t0,t1);}
a=C_alloc(13);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1569,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=C_i_foreign_fixnum_argumentp(t1);
t4=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
t5=C_eqp(C_fix((C_word)SOCKET_ERROR),stub154(C_SCHEME_UNDEFINED,t3,t4));
if(C_truep(t5)){
t6=stub114(C_SCHEME_UNDEFINED);
t7=C_i_foreign_fixnum_argumentp(t1);
t8=stub173(C_SCHEME_UNDEFINED,t7);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1588,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1592,a[2]=t9,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t10;
av2[2]=lf[12];
av2[3]=lf[13];
tp(4,av2);}}
else{
t6=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t6;
av2[1]=C_a_i_record2(&a,2,lf[5],t1);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k1567 in k1564 in k1558 in chicken.tcp#tcp-listen in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1569(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_1569,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_record2(&a,2,lf[5],((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k1586 in k1564 in k1558 in chicken.tcp#tcp-listen in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1588(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_1588,c,av);}
/* tcp.scm:330: ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[7];
av2[3]=lf[8];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(7,av2);}}

/* k1590 in k1564 in k1558 in chicken.tcp#tcp-listen in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1592(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_1592,c,av);}
a=C_alloc(9);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1596,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=C_a_i_bytevector(&a,1,C_fix(3));
t4=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
/* tcp.scm:172: ##sys#peek-c-string */
t5=*((C_word*)lf[10]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t2;
av2[2]=stub118(t3,t4);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k1594 in k1590 in k1564 in k1558 in chicken.tcp#tcp-listen in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1596(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_1596,c,av);}
/* tcp.scm:330: scheme#string-append */
t2=*((C_word*)lf[9]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* chicken.tcp#tcp-listener? in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1640(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_1640,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(C_blockp(t2))?C_i_structurep(t2,lf[5]):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.tcp#tcp-close in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1649(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_1649,c,av);}
a=C_alloc(8);
t3=C_i_check_structure(t2,lf[5]);
t4=C_slot(t2,C_fix(1));
t5=C_i_foreign_fixnum_argumentp(t4);
t6=C_eqp(C_fix((C_word)SOCKET_ERROR),stub173(C_SCHEME_UNDEFINED,t5));
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1669,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1673,a[2]=t7,a[3]=C_SCHEME_UNDEFINED,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t8;
av2[2]=lf[25];
av2[3]=lf[13];
tp(4,av2);}}
else{
t7=C_SCHEME_UNDEFINED;
t8=t1;{
C_word *av2=av;
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}

/* k1667 in chicken.tcp#tcp-close in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1669(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_1669,c,av);}
/* tcp.scm:341: ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[7];
av2[3]=lf[24];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k1671 in chicken.tcp#tcp-close in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1673(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_1673,c,av);}
a=C_alloc(8);
t2=C_mutate(((C_word *)t0)+3,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1677,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t4=stub114(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
/* tcp.scm:172: ##sys#peek-c-string */
t7=*((C_word*)lf[10]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=stub118(t5,t6);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k1675 in k1671 in chicken.tcp#tcp-close in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1677(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_1677,c,av);}
t2=((C_word*)t0)[2];
/* tcp.scm:341: scheme#string-append */
t3=*((C_word*)lf[9]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=((C_word*)t2)[2];
av2[2]=((C_word*)t2)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1691(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(16,c,3)))){
C_save_and_reclaim((void *)f_1691,c,av);}
a=C_alloc(16);
t2=C_mutate((C_word*)lf[26]+1 /* (set! chicken.tcp#tcp-buffer-size ...) */,t1);
t3=C_set_block_item(lf[27] /* chicken.tcp#tcp-read-timeout */,0,C_SCHEME_UNDEFINED);
t4=C_set_block_item(lf[28] /* chicken.tcp#tcp-write-timeout */,0,C_SCHEME_UNDEFINED);
t5=C_set_block_item(lf[29] /* chicken.tcp#tcp-connect-timeout */,0,C_SCHEME_UNDEFINED);
t6=C_set_block_item(lf[30] /* chicken.tcp#tcp-accept-timeout */,0,C_SCHEME_UNDEFINED);
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_SCHEME_UNDEFINED;
t10=(*a=C_VECTOR_TYPE|1,a[1]=t9,tmp=(C_word)a,a+=2,tmp);
t11=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1697,a[2]=((C_word)li5),tmp=(C_word)a,a+=3,tmp));
t12=C_fixnum_times(C_fix(60),C_fix(1000));
t13=C_set_block_item(t10,0,t12);
t14=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1714,a[2]=((C_word*)t0)[2],a[3]=t8,a[4]=t10,tmp=(C_word)a,a+=5,tmp);
t15=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3260,a[2]=t14,a[3]=t10,tmp=(C_word)a,a+=4,tmp);
/* tcp.scm:357: check */
f_1697(t15,lf[110]);}

/* check in k1689 in k1298 in k1070 in k1067 in k1064 */
static void f_1697(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,3)))){
C_save_and_reclaim_args((void *)trf_1697,2,t1,t2);}
a=C_alloc(4);
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1699,a[2]=t2,a[3]=((C_word)li4),tmp=(C_word)a,a+=4,tmp);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* f_1699 in check in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1699(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_1699,c,av);}
if(C_truep(t2)){
t3=C_i_check_fixnum_2(t2,((C_word*)t0)[2]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1714(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,2)))){
C_save_and_reclaim((void *)f_1714,c,av);}
a=C_alloc(8);
t2=C_mutate((C_word*)lf[27]+1 /* (set! chicken.tcp#tcp-read-timeout ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1718,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3256,a[2]=t3,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* tcp.scm:358: check */
f_1697(t4,lf[109]);}

/* k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1718(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_1718,c,av);}
a=C_alloc(6);
t2=C_mutate((C_word*)lf[28]+1 /* (set! chicken.tcp#tcp-write-timeout ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1722,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3252,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* tcp.scm:359: check */
f_1697(t4,lf[108]);}

/* k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1722(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_1722,c,av);}
a=C_alloc(6);
t2=((C_word*)t0)[2];
t3=C_mutate((C_word*)lf[29]+1 /* (set! chicken.tcp#tcp-connect-timeout ...) */,t1);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1726,a[2]=((C_word*)t2)[2],tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3248,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* tcp.scm:360: check */
f_1697(t5,lf[107]);}

/* k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1726(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(31,c,5)))){
C_save_and_reclaim((void *)f_1726,c,av);}
a=C_alloc(31);
t2=C_mutate((C_word*)lf[30]+1 /* (set! chicken.tcp#tcp-accept-timeout ...) */,t1);
t3=*((C_word*)lf[26]+1);
t4=C_mutate(&lf[31] /* (set! chicken.tcp#io-ports ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1728,a[2]=t3,a[3]=((C_word)li31),tmp=(C_word)a,a+=4,tmp));
t5=C_mutate((C_word*)lf[66]+1 /* (set! chicken.tcp#tcp-accept ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2562,a[2]=((C_word)li33),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[71]+1 /* (set! chicken.tcp#tcp-accept-ready? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2666,a[2]=((C_word)li34),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[74]+1 /* (set! chicken.tcp#tcp-connect ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2716,a[2]=((C_word)li39),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate(&lf[87] /* (set! chicken.tcp#tcp-port->fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3026,a[2]=((C_word)li40),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate((C_word*)lf[91]+1 /* (set! chicken.tcp#tcp-addresses ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3044,a[2]=((C_word)li41),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate((C_word*)lf[95]+1 /* (set! chicken.tcp#tcp-port-numbers ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3111,a[2]=((C_word)li42),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate((C_word*)lf[99]+1 /* (set! chicken.tcp#tcp-listener-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3182,a[2]=((C_word)li43),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate((C_word*)lf[102]+1 /* (set! chicken.tcp#tcp-abandon-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3221,a[2]=((C_word)li44),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate((C_word*)lf[104]+1 /* (set! chicken.tcp#tcp-listener-fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3237,a[2]=((C_word)li45),tmp=(C_word)a,a+=3,tmp));
t14=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t14;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t14+1)))(2,av2);}}

/* chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void f_1728(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,0,3)))){
C_save_and_reclaim_args((void *)trf_1728,5,t0,t1,t2,t3,t4);}
a=C_alloc(15);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1732,a[2]=t3,a[3]=t4,a[4]=t1,a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
if(C_truep(make_socket_nonblocking(t3))){
t6=t5;{
C_word av2[2];
av2[0]=t6;
av2[1]=C_SCHEME_UNDEFINED;
f_1732(2,av2);}}
else{
t6=stub114(C_SCHEME_UNDEFINED);
t7=C_i_foreign_fixnum_argumentp(t3);
t8=stub173(C_SCHEME_UNDEFINED,t7);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2550,a[2]=t5,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2554,a[2]=t9,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t10;
av2[2]=lf[65];
av2[3]=lf[13];
tp(4,av2);}}}

/* k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1732(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_1732,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1735,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* tcp.scm:367: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[46]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[46]+1);
av2[1]=t2;
av2[2]=C_fix(1024);
tp(3,av2);}}

/* k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1735(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(26,c,2)))){
C_save_and_reclaim((void *)f_1735,c,av);}
a=C_alloc(26);
t2=((C_word*)t0)[2];
t3=C_a_i_vector5(&a,5,((C_word*)t2)[2],C_SCHEME_FALSE,C_SCHEME_FALSE,t1,C_fix(0));
t4=C_fix(0);
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_fix(0);
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_SCHEME_FALSE;
t9=(*a=C_VECTOR_TYPE|1,a[1]=t8,tmp=(C_word)a,a+=2,tmp);
t10=C_SCHEME_FALSE;
t11=(*a=C_VECTOR_TYPE|1,a[1]=t10,tmp=(C_word)a,a+=2,tmp);
t12=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_1741,a[2]=((C_word*)t2)[2],a[3]=t1,a[4]=t5,a[5]=t3,a[6]=t7,a[7]=C_SCHEME_UNDEFINED,a[8]=t11,a[9]=t9,a[10]=((C_word*)t2)[3],a[11]=((C_word*)t2)[4],tmp=(C_word)a,a+=12,tmp);
/* tcp.scm:373: tbs */
t13=((C_word*)t2)[5];{
C_word *av2=av;
av2[0]=t13;
av2[1]=t12;
((C_proc)(void*)(*((C_word*)t13+1)))(2,av2);}}

/* k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1741(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_1741,c,av);}
a=C_alloc(3);
t2=C_mutate(((C_word *)t0)+7,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1744,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
if(C_truep(((C_word*)t0)[7])){
if(C_truep(C_fixnum_greaterp(((C_word*)t0)[7],C_fix(0)))){
/* tcp.scm:376: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[46]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[46]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[7];
tp(3,av2);}}
else{
t4=t3;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
f_1744(2,av2);}}}
else{
t4=t3;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
f_1744(2,av2);}}}

/* k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1744(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(73,c,12)))){
C_save_and_reclaim((void *)f_1744,c,av);}
a=C_alloc(73);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1745,a[2]=((C_word*)t2)[2],a[3]=((C_word*)t2)[3],a[4]=((C_word*)t2)[4],a[5]=((C_word*)t2)[5],a[6]=((C_word*)t2)[6],a[7]=((C_word)li7),tmp=(C_word)a,a+=8,tmp);
t4=C_SCHEME_FALSE;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_1842,a[2]=((C_word*)t2)[2],a[3]=((C_word*)t2)[6],a[4]=((C_word*)t2)[7],a[5]=t1,a[6]=((C_word*)t2)[8],a[7]=((C_word*)t2)[9],a[8]=((C_word*)t2)[5],a[9]=t5,a[10]=((C_word*)t2)[10],a[11]=((C_word*)t2)[11],tmp=(C_word)a,a+=12,tmp);
t7=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2177,a[2]=((C_word*)t2)[6],a[3]=((C_word*)t2)[4],a[4]=t5,a[5]=((C_word*)t2)[3],a[6]=t3,a[7]=((C_word)li19),tmp=(C_word)a,a+=8,tmp);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2209,a[2]=((C_word*)t2)[6],a[3]=((C_word*)t2)[4],a[4]=((C_word*)t2)[2],a[5]=((C_word)li20),tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2251,a[2]=((C_word*)t2)[9],a[3]=((C_word*)t2)[2],a[4]=((C_word*)t2)[8],a[5]=((C_word*)t2)[5],a[6]=((C_word)li21),tmp=(C_word)a,a+=7,tmp);
t10=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2301,a[2]=((C_word*)t2)[6],a[3]=((C_word*)t2)[4],a[4]=t5,a[5]=((C_word*)t2)[3],a[6]=t3,a[7]=((C_word)li23),tmp=(C_word)a,a+=8,tmp);
t11=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2329,a[2]=((C_word*)t2)[6],a[3]=((C_word*)t2)[4],a[4]=((C_word*)t2)[3],a[5]=t3,a[6]=((C_word)li25),tmp=(C_word)a,a+=7,tmp);
t12=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2390,a[2]=((C_word*)t2)[6],a[3]=((C_word*)t2)[4],a[4]=((C_word*)t2)[3],a[5]=t3,a[6]=t5,a[7]=((C_word)li29),tmp=(C_word)a,a+=8,tmp);
t13=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2513,a[2]=((C_word*)t2)[6],a[3]=((C_word*)t2)[4],a[4]=((C_word*)t2)[3],a[5]=t5,a[6]=((C_word)li30),tmp=(C_word)a,a+=7,tmp);
/* tcp.scm:405: chicken.port#make-input-port */
t14=*((C_word*)lf[60]+1);{
C_word *av2;
if(c >= 13) {
  av2=av;
} else {
  av2=C_alloc(13);
}
av2[0]=t14;
av2[1]=t6;
av2[2]=t7;
av2[3]=t8;
av2[4]=t9;
av2[5]=lf[61];
av2[6]=t10;
av2[7]=lf[62];
av2[8]=t11;
av2[9]=lf[63];
av2[10]=t12;
av2[11]=lf[64];
av2[12]=t13;
((C_proc)(void*)(*((C_word*)t14+1)))(13,av2);}}

/* read-input in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void f_1745(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,2)))){
C_save_and_reclaim_args((void *)trf_1745,2,t0,t1);}
a=C_alloc(8);
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1749,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t1,tmp=(C_word)a,a+=8,tmp);
/* tcp.scm:379: tcp-read-timeout */
t3=*((C_word*)lf[27]+1);{
C_word av2[2];
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k1747 in read-input in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1749(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(13,c,2)))){
C_save_and_reclaim((void *)f_1749,c,av);}
a=C_alloc(13);
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_1752,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],tmp=(C_word)a,a+=9,tmp);
if(C_truep(t1)){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1839,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* tcp.scm:380: chicken.time#current-process-milliseconds */
t4=*((C_word*)lf[41]+1);{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=t2;
f_1752(t3,C_SCHEME_FALSE);}}

/* k1750 in k1747 in read-input in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void f_1752(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(13,0,2)))){
C_save_and_reclaim_args((void *)trf_1752,2,t0,t1);}
a=C_alloc(13);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_1757,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=((C_word*)t0)[4],a[6]=t1,a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[6],a[9]=((C_word*)t0)[7],a[10]=((C_word)li6),tmp=(C_word)a,a+=11,tmp));
t5=((C_word*)t3)[1];{
C_word av2[2];
av2[0]=t5;
av2[1]=((C_word*)t0)[8];
f_1757(2,av2);}}

/* loop in k1750 in k1747 in read-input in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1757(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_1757,c,av);}
a=C_alloc(8);
t2=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t3=(C_truep(((C_word*)t0)[3])?C_i_foreign_block_argumentp(((C_word*)t0)[3]):C_SCHEME_FALSE);
t4=C_fix(1024);
t5=C_fix(0);
t6=stub181(C_SCHEME_UNDEFINED,t2,t3,t4,t5);
t7=C_eqp(C_fix((C_word)SOCKET_ERROR),t6);
if(C_truep(t7)){
if(C_truep(stub123(C_SCHEME_UNDEFINED))){
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_1776,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[6])){
/* tcp.scm:386: ##sys#thread-block-for-timeout! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[38]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[38]+1);
av2[1]=t8;
av2[2]=*((C_word*)lf[32]+1);
av2[3]=((C_word*)t0)[6];
tp(4,av2);}}
else{
t9=t8;{
C_word *av2=av;
av2[0]=t9;
av2[1]=C_SCHEME_UNDEFINED;
f_1776(2,av2);}}}
else{
if(C_truep(stub129(C_SCHEME_UNDEFINED))){
/* tcp.scm:396: ##sys#dispatch-interrupt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[39]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[39]+1);
av2[1]=t1;
av2[2]=((C_word*)((C_word*)t0)[4])[1];
tp(3,av2);}}
else{
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1813,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1817,a[2]=t8,a[3]=C_SCHEME_UNDEFINED,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t9;
av2[2]=lf[40];
av2[3]=lf[13];
tp(4,av2);}}}}
else{
t8=C_set_block_item(((C_word*)t0)[7],0,t6);
t9=C_i_set_i_slot(((C_word*)t0)[8],C_fix(4),t6);
t10=C_set_block_item(((C_word*)t0)[9],0,C_fix(0));
t11=t1;{
C_word *av2=av;
av2[0]=t11;
av2[1]=t10;
((C_proc)(void*)(*((C_word*)t11+1)))(2,av2);}}}

/* k1774 in loop in k1750 in k1747 in read-input in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1776(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_1776,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1779,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* tcp.scm:388: ##sys#thread-block-for-i/o! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[36]+1));
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[36]+1);
av2[1]=t2;
av2[2]=*((C_word*)lf[32]+1);
av2[3]=((C_word*)t0)[5];
av2[4]=lf[37];
tp(5,av2);}}

/* k1777 in k1774 in loop in k1750 in k1747 in read-input in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1779(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_1779,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1782,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* tcp.scm:389: ##sys#thread-yield! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[35]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[35]+1);
av2[1]=t3;
tp(2,av2);}}

/* k1780 in k1777 in k1774 in loop in k1750 in k1747 in read-input in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1782(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,5)))){
C_save_and_reclaim((void *)f_1782,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1785,a[2]=((C_word*)t2)[2],a[3]=((C_word*)t2)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_slot(*((C_word*)lf[32]+1),C_fix(13)))){
/* tcp.scm:391: ##sys#signal-hook */
t4=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[33];
av2[3]=lf[34];
av2[4]=((C_word*)t2)[4];
av2[5]=((C_word*)t2)[5];
((C_proc)(void*)(*((C_word*)t4+1)))(6,av2);}}
else{
/* tcp.scm:394: loop */
t4=((C_word*)((C_word*)t2)[2])[1];{
C_word *av2=av;
av2[0]=t4;
av2[1]=((C_word*)t2)[3];
f_1757(2,av2);}}}

/* k1783 in k1780 in k1777 in k1774 in loop in k1750 in k1747 in read-input in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 in ... */
static void C_ccall f_1785(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_1785,c,av);}
/* tcp.scm:394: loop */
t2=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
f_1757(2,av2);}}

/* k1811 in loop in k1750 in k1747 in read-input in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1813(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_1813,c,av);}
/* tcp.scm:398: ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[7];
av2[3]=C_SCHEME_FALSE;
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k1815 in loop in k1750 in k1747 in read-input in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1817(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_1817,c,av);}
a=C_alloc(8);
t2=C_mutate(((C_word *)t0)+3,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1821,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t4=stub114(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
/* tcp.scm:172: ##sys#peek-c-string */
t7=*((C_word*)lf[10]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=stub118(t5,t6);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k1819 in k1815 in loop in k1750 in k1747 in read-input in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1821(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_1821,c,av);}
t2=((C_word*)t0)[2];
/* tcp.scm:398: scheme#string-append */
t3=*((C_word*)lf[9]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=((C_word*)t2)[2];
av2[2]=((C_word*)t2)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k1837 in k1747 in read-input in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1839(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,1)))){
C_save_and_reclaim((void *)f_1839,c,av);}
a=C_alloc(29);
t2=((C_word*)t0)[2];
f_1752(t2,C_s_a_i_plus(&a,2,t1,((C_word*)t0)[3]));}

/* k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1842(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(62,c,6)))){
C_save_and_reclaim((void *)f_1842,c,av);}
a=C_alloc(62);
t2=C_SCHEME_FALSE;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1843,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=((C_word)li11),tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1987,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t4,a[6]=((C_word)li13),tmp=(C_word)a,a+=7,tmp);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2062,a[2]=((C_word*)t0)[5],a[3]=t5,a[4]=t4,a[5]=((C_word)li14),tmp=(C_word)a,a+=6,tmp);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2077,a[2]=((C_word*)t0)[5],a[3]=t5,a[4]=t4,a[5]=((C_word)li15),tmp=(C_word)a,a+=6,tmp);
t8=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_2098,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[3],a[8]=t4,a[9]=((C_word)li16),tmp=(C_word)a,a+=10,tmp);
t9=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2161,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[3],a[4]=t4,a[5]=((C_word)li17),tmp=(C_word)a,a+=6,tmp);
t10=C_a_i_vector(&a,10,C_SCHEME_FALSE,C_SCHEME_FALSE,t6,t7,t8,t9,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE);
t11=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2037,a[2]=((C_word*)t0)[9],a[3]=t1,a[4]=t3,a[5]=C_SCHEME_UNDEFINED,a[6]=((C_word*)t0)[10],a[7]=((C_word*)t0)[11],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
/* tcp.scm:577: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[51]+1));
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[51]+1);
av2[1]=t11;
av2[2]=C_fix(2);
av2[3]=t10;
av2[4]=lf[52];
av2[5]=lf[49];
tp(6,av2);}}

/* output-to-socket in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void f_1843(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,2)))){
C_save_and_reclaim_args((void *)trf_1843,4,t0,t1,t2,t3);}
a=C_alloc(7);
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1847,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=t2,a[6]=t3,tmp=(C_word)a,a+=7,tmp);
/* tcp.scm:498: tcp-write-timeout */
t5=*((C_word*)lf[28]+1);{
C_word av2[2];
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* k1845 in output-to-socket in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1847(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,6)))){
C_save_and_reclaim((void *)f_1847,c,av);}
a=C_alloc(5);
t2=C_slot(((C_word*)((C_word*)t0)[2])[1],C_fix(15));
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_1856,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word)li10),tmp=(C_word)a,a+=5,tmp);
/* tcp.scm:499: ##sys#encode-buffer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[45]+1));
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=*((C_word*)lf[45]+1);
av2[1]=((C_word*)t0)[4];
av2[2]=((C_word*)t0)[5];
av2[3]=C_fix(0);
av2[4]=((C_word*)t0)[6];
av2[5]=t2;
av2[6]=t3;
tp(7,av2);}}

/* a1855 in k1845 in output-to-socket in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1856(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(12,c,2)))){
C_save_and_reclaim((void *)f_1856,c,av);}
a=C_alloc(12);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_1864,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word*)t0)[3],a[5]=t1,a[6]=t4,a[7]=t3,tmp=(C_word)a,a+=8,tmp);
if(C_truep(((C_word*)t0)[3])){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1986,a[2]=t5,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* tcp.scm:504: chicken.time#current-process-milliseconds */
t7=*((C_word*)lf[41]+1);{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t6=t5;
f_1864(t6,C_SCHEME_FALSE);}}

/* k1862 in a1855 in k1845 in output-to-socket in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void f_1864(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,0,5)))){
C_save_and_reclaim_args((void *)trf_1864,2,t0,t1);}
a=C_alloc(9);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1866,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=((C_word*)t0)[4],a[6]=((C_word)li9),tmp=(C_word)a,a+=7,tmp));
t5=((C_word*)t3)[1];
f_1866(t5,((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[7],t1);}

/* loop in k1862 in a1855 in k1845 in output-to-socket in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void f_1866(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(9,0,4)))){
C_save_and_reclaim_args((void *)trf_1866,5,t0,t1,t2,t3,t4);}
a=C_alloc(9);
t5=C_i_fixnum_min(C_fix(8192),t2);
t6=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t7=(C_truep(((C_word*)t0)[3])?C_i_foreign_block_argumentp(((C_word*)t0)[3]):C_SCHEME_FALSE);
t8=C_i_foreign_fixnum_argumentp(t3);
t9=C_i_foreign_fixnum_argumentp(t5);
t10=C_fix(0);
t11=stub223(C_SCHEME_UNDEFINED,t6,t7,t8,t9,t10);
t12=C_eqp(C_fix((C_word)SOCKET_ERROR),t11);
if(C_truep(t12)){
if(C_truep(stub123(C_SCHEME_UNDEFINED))){
t13=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_1888,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=t2,a[5]=t3,a[6]=t4,a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[2],tmp=(C_word)a,a+=9,tmp);
if(C_truep(t4)){
/* tcp.scm:510: ##sys#thread-block-for-timeout! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[38]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[38]+1);
av2[1]=t13;
av2[2]=*((C_word*)lf[32]+1);
av2[3]=t4;
tp(4,av2);}}
else{
t14=t13;{
C_word av2[2];
av2[0]=t14;
av2[1]=C_SCHEME_UNDEFINED;
f_1888(2,av2);}}}
else{
if(C_truep(stub129(C_SCHEME_UNDEFINED))){
t13=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1920,a[2]=((C_word*)t0)[4],a[3]=t2,a[4]=t3,a[5]=t4,a[6]=((C_word)li8),tmp=(C_word)a,a+=7,tmp);
/* tcp.scm:518: ##sys#dispatch-interrupt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[39]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[39]+1);
av2[1]=t1;
av2[2]=t13;
tp(3,av2);}}
else{
t13=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1931,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t14=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_1935,a[2]=t13,a[3]=C_SCHEME_UNDEFINED,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t14;
av2[2]=lf[44];
av2[3]=lf[13];
tp(4,av2);}}}}
else{
if(C_truep(C_fixnum_lessp(t11,t2))){
t13=C_fixnum_difference(t2,t11);
t14=C_fixnum_plus(t3,t11);
t15=C_eqp(t11,C_fix(0));
if(C_truep(t15)){
/* tcp.scm:523: loop */
t18=t1;
t19=t13;
t20=t14;
t21=((C_word*)t0)[5];
t1=t18;
t2=t19;
t3=t20;
t4=t21;
goto loop;}
else{
if(C_truep(((C_word*)t0)[5])){
t16=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1979,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[4],a[4]=t1,a[5]=t13,a[6]=t14,tmp=(C_word)a,a+=7,tmp);
/* tcp.scm:527: chicken.time#current-process-milliseconds */
t17=*((C_word*)lf[41]+1);{
C_word av2[2];
av2[0]=t17;
av2[1]=t16;
((C_proc)(void*)(*((C_word*)t17+1)))(2,av2);}}
else{
/* tcp.scm:523: loop */
t18=t1;
t19=t13;
t20=t14;
t21=C_SCHEME_FALSE;
t1=t18;
t2=t19;
t3=t20;
t4=t21;
goto loop;}}}
else{
t13=t1;{
C_word av2[2];
av2[0]=t13;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t13+1)))(2,av2);}}}}

/* k1886 in loop in k1862 in a1855 in k1845 in output-to-socket in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1888(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_1888,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1891,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* tcp.scm:511: ##sys#thread-block-for-i/o! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[36]+1));
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[36]+1);
av2[1]=t2;
av2[2]=*((C_word*)lf[32]+1);
av2[3]=((C_word*)t0)[8];
av2[4]=lf[43];
tp(5,av2);}}

/* k1889 in k1886 in loop in k1862 in a1855 in k1845 in output-to-socket in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 in ... */
static void C_ccall f_1891(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_1891,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1894,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* tcp.scm:512: ##sys#thread-yield! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[35]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[35]+1);
av2[1]=t3;
tp(2,av2);}}

/* k1892 in k1889 in k1886 in loop in k1862 in a1855 in k1845 in output-to-socket in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in ... */
static void C_ccall f_1894(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,5)))){
C_save_and_reclaim((void *)f_1894,c,av);}
a=C_alloc(7);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1897,a[2]=((C_word*)t2)[2],a[3]=((C_word*)t2)[3],a[4]=((C_word*)t2)[4],a[5]=((C_word*)t2)[5],a[6]=((C_word*)t2)[6],tmp=(C_word)a,a+=7,tmp);
if(C_truep(C_slot(*((C_word*)lf[32]+1),C_fix(13)))){
/* tcp.scm:514: ##sys#signal-hook */
t4=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[33];
av2[3]=lf[42];
av2[4]=((C_word*)t2)[7];
av2[5]=((C_word*)t2)[8];
((C_proc)(void*)(*((C_word*)t4+1)))(6,av2);}}
else{
/* tcp.scm:516: loop */
t4=((C_word*)((C_word*)t2)[2])[1];
f_1866(t4,((C_word*)t2)[3],((C_word*)t2)[4],((C_word*)t2)[5],((C_word*)t2)[6]);}}

/* k1895 in k1892 in k1889 in k1886 in loop in k1862 in a1855 in k1845 in output-to-socket in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in ... */
static void C_ccall f_1897(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_1897,c,av);}
/* tcp.scm:516: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_1866(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6]);}

/* a1919 in loop in k1862 in a1855 in k1845 in output-to-socket in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1920(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_1920,c,av);}
/* tcp.scm:519: g639 */
t2=((C_word*)((C_word*)t0)[2])[1];
f_1866(t2,t1,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);}

/* k1929 in loop in k1862 in a1855 in k1845 in output-to-socket in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1931(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_1931,c,av);}
/* tcp.scm:521: ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[7];
av2[3]=C_SCHEME_FALSE;
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k1933 in loop in k1862 in a1855 in k1845 in output-to-socket in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1935(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_1935,c,av);}
a=C_alloc(8);
t2=C_mutate(((C_word *)t0)+3,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1939,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t4=stub114(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
/* tcp.scm:172: ##sys#peek-c-string */
t7=*((C_word*)lf[10]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=stub118(t5,t6);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k1937 in k1933 in loop in k1862 in a1855 in k1845 in output-to-socket in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 in ... */
static void C_ccall f_1939(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_1939,c,av);}
t2=((C_word*)t0)[2];
/* tcp.scm:521: scheme#string-append */
t3=*((C_word*)lf[9]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=((C_word*)t2)[2];
av2[2]=((C_word*)t2)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k1977 in loop in k1862 in a1855 in k1845 in output-to-socket in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1979(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,4)))){
C_save_and_reclaim((void *)f_1979,c,av);}
a=C_alloc(29);
t2=C_s_a_i_plus(&a,2,t1,((C_word*)t0)[2]);
/* tcp.scm:523: loop */
t3=((C_word*)((C_word*)t0)[3])[1];
f_1866(t3,((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],t2);}

/* k1984 in a1855 in k1845 in output-to-socket in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_1986(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,1)))){
C_save_and_reclaim((void *)f_1986,c,av);}
a=C_alloc(29);
t2=((C_word*)t0)[2];
f_1864(t2,C_s_a_i_plus(&a,2,t1,((C_word*)t0)[3]));}

/* add-to-buf in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void f_1987(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,0,4)))){
C_save_and_reclaim_args((void *)trf_1987,4,t0,t1,t2,t3);}
a=C_alloc(11);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_1993,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t2,a[6]=t5,a[7]=((C_word*)t0)[5],a[8]=((C_word)li12),tmp=(C_word)a,a+=9,tmp));
t7=((C_word*)t5)[1];
f_1993(t7,t1,t3,C_fix(0));}

/* loop in add-to-buf in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void f_1993(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,3)))){
C_save_and_reclaim_args((void *)trf_1993,4,t0,t1,t2,t3);}
a=C_alloc(8);
t4=C_eqp(t2,C_fix(0));
if(C_truep(t4)){
t5=C_SCHEME_UNDEFINED;
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t5=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],t2);
if(C_truep(C_fixnum_greaterp(t5,((C_word*)t0)[3]))){
t6=C_fixnum_difference(((C_word*)t0)[3],((C_word*)((C_word*)t0)[2])[1]);
t7=C_copy_memory_with_offset(((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)((C_word*)t0)[2])[1],t3,t6);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2015,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[6],a[4]=t1,a[5]=t2,a[6]=t6,a[7]=t3,tmp=(C_word)a,a+=8,tmp);
/* tcp.scm:537: output-to-socket */
t9=((C_word*)t0)[7];
f_1843(t9,t8,((C_word*)t0)[4],((C_word*)t0)[3]);}
else{
t6=C_copy_memory_with_offset(((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)((C_word*)t0)[2])[1],t3,t2);
t7=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],t2);
t8=C_set_block_item(((C_word*)t0)[2],0,t7);
t9=t1;{
C_word av2[2];
av2[0]=t9;
av2[1]=t8;
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}}}

/* k2013 in loop in add-to-buf in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2015(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_2015,c,av);}
t2=C_set_block_item(((C_word*)t0)[2],0,C_fix(0));
/* tcp.scm:539: loop */
t3=((C_word*)((C_word*)t0)[3])[1];
f_1993(t3,((C_word*)t0)[4],C_fixnum_difference(((C_word*)t0)[5],((C_word*)t0)[6]),C_fixnum_plus(((C_word*)t0)[7],((C_word*)t0)[6]));}

/* k2035 in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2037(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_2037,c,av);}
a=C_alloc(3);
t2=C_mutate(((C_word *)t0)+5,t1);
t3=C_i_setslot(((C_word*)t0)[3],C_fix(3),lf[48]);
t4=C_i_setslot(((C_word*)t0)[3],C_fix(7),lf[49]);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2046,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* tcp.scm:580: ##sys#set-port-data! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[50]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[50]+1);
av2[1]=t5;
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[8];
tp(4,av2);}}

/* k2044 in k2035 in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2046(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_2046,c,av);}
a=C_alloc(8);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2049,a[2]=((C_word*)t2)[2],a[3]=((C_word*)t2)[3],a[4]=((C_word*)t2)[4],a[5]=((C_word*)t2)[5],a[6]=((C_word*)t2)[6],a[7]=((C_word*)t2)[7],tmp=(C_word)a,a+=8,tmp);
/* tcp.scm:581: ##sys#set-port-data! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[50]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[50]+1);
av2[1]=t3;
av2[2]=((C_word*)t2)[5];
av2[3]=((C_word*)t2)[8];
tp(4,av2);}}

/* k2047 in k2044 in k2035 in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2049(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_2049,c,av);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,((C_word*)t0)[3]);
t3=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)t0)[5]);
t4=C_i_setslot(((C_word*)t0)[3],C_fix(15),((C_word*)t0)[6]);
t5=C_i_setslot(((C_word*)t0)[5],C_fix(15),((C_word*)t0)[6]);
/* tcp.scm:586: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[7];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[5];
C_values(4,av2);}}

/* a2061 in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2062(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_2062,c,av);}
a=C_alloc(7);
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2066,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=t1,a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
/* tcp.scm:549: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[46]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[46]+1);
av2[1]=t4;
av2[2]=C_fix(4);
tp(3,av2);}}

/* k2064 in a2061 in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2066(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_2066,c,av);}
t2=C_utf_insert(t1,C_fix(0),((C_word*)t0)[2]);
if(C_truep(((C_word*)t0)[3])){
/* tcp.scm:552: add-to-buf */
t3=((C_word*)t0)[4];
f_1987(t3,((C_word*)t0)[5],t1,t2);}
else{
/* tcp.scm:553: output-to-socket */
t3=((C_word*)t0)[6];
f_1843(t3,((C_word*)t0)[5],t1,t2);}}

/* a2076 in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2077(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_2077,c,av);}
t6=C_fixnum_difference(t5,t4);
if(C_truep(C_fixnum_greaterp(t6,C_fix(0)))){
if(C_truep(((C_word*)t0)[2])){
/* tcp.scm:558: add-to-buf */
t7=((C_word*)t0)[3];
f_1987(t7,t1,t3,t6);}
else{
/* tcp.scm:559: output-to-socket */
t7=((C_word*)t0)[4];
f_1843(t7,t1,t3,t6);}}
else{
t7=C_SCHEME_UNDEFINED;
t8=t1;{
C_word *av2=av;
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}

/* a2097 in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2098(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(10,c,3)))){
C_save_and_reclaim((void *)f_2098,c,av);}
a=C_alloc(10);
if(C_truep(((C_word*)((C_word*)t0)[2])[1])){
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t4=C_set_block_item(((C_word*)t0)[2],0,C_SCHEME_TRUE);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2106,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t6=(C_truep(((C_word*)t0)[6])?C_fixnum_greaterp(((C_word*)((C_word*)t0)[7])[1],C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2155,a[2]=((C_word*)t0)[7],a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* tcp.scm:564: output-to-socket */
t8=((C_word*)t0)[8];
f_1843(t8,t7,((C_word*)t0)[6],((C_word*)((C_word*)t0)[7])[1]);}
else{
t7=t5;
f_2106(t7,C_SCHEME_UNDEFINED);}}}

/* k2104 in a2097 in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void f_2106(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_2106,2,t0,t1);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2109,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_slot(((C_word*)t0)[5],C_fix(2)))){
t3=t2;
f_2109(t3,C_SCHEME_UNDEFINED);}
else{
t3=C_fix((C_word)SHUT_WR);
t4=t2;
f_2109(t4,stub192(C_SCHEME_UNDEFINED,C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]),C_i_foreign_fixnum_argumentp(t3)));}}

/* k2107 in k2104 in a2097 in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void f_2109(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_2109,2,t0,t1);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2115,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)((C_word*)t0)[4])[1])){
t3=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
t4=t2;
f_2115(t4,C_eqp(C_fix((C_word)SOCKET_ERROR),stub173(C_SCHEME_UNDEFINED,t3)));}
else{
t3=t2;
f_2115(t3,C_SCHEME_FALSE);}}

/* k2113 in k2107 in k2104 in a2097 in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void f_2115(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,3)))){
C_save_and_reclaim_args((void *)trf_2115,2,t0,t1);}
a=C_alloc(7);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2122,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2126,a[2]=t2,a[3]=C_SCHEME_UNDEFINED,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t3;
av2[2]=lf[47];
av2[3]=lf[13];
tp(4,av2);}}
else{
t2=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k2120 in k2113 in k2107 in k2104 in a2097 in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2122(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_2122,c,av);}
t2=((C_word*)t0)[2];
/* tcp.scm:568: ##sys#signal-hook */
t3=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=((C_word*)t2)[2];
av2[2]=lf[7];
av2[3]=C_SCHEME_FALSE;
av2[4]=t1;
av2[5]=((C_word*)t2)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}

/* k2124 in k2113 in k2107 in k2104 in a2097 in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2126(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_2126,c,av);}
a=C_alloc(8);
t2=C_mutate(((C_word *)t0)+3,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2130,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t4=stub114(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
/* tcp.scm:172: ##sys#peek-c-string */
t7=*((C_word*)lf[10]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=stub118(t5,t6);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k2128 in k2124 in k2113 in k2107 in k2104 in a2097 in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2130(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_2130,c,av);}
t2=((C_word*)t0)[2];
/* tcp.scm:568: scheme#string-append */
t3=*((C_word*)lf[9]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=((C_word*)t2)[2];
av2[2]=((C_word*)t2)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k2153 in a2097 in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2155(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2155,c,av);}
t2=C_set_block_item(((C_word*)t0)[2],0,C_fix(0));
t3=((C_word*)t0)[3];
f_2106(t3,t2);}

/* a2160 in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2161(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_2161,c,av);}
a=C_alloc(4);
t3=(C_truep(((C_word*)t0)[2])?C_fixnum_greaterp(((C_word*)((C_word*)t0)[3])[1],C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2171,a[2]=((C_word*)t0)[3],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* tcp.scm:571: output-to-socket */
t5=((C_word*)t0)[4];
f_1843(t5,t4,((C_word*)t0)[2],((C_word*)((C_word*)t0)[3])[1]);}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k2169 in a2160 in k1840 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2171(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2171,c,av);}
t2=C_set_block_item(((C_word*)t0)[2],0,C_fix(0));
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* a2176 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2177(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_2177,c,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2181,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
/* tcp.scm:408: read-input */
t3=((C_word*)t0)[6];
f_1745(t3,t2);}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_2181(2,av2);}}}

/* k2179 in a2176 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2181(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,6)))){
C_save_and_reclaim((void *)f_2181,c,av);}
a=C_alloc(4);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t2=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_END_OF_FILE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=C_slot(((C_word*)((C_word*)t0)[5])[1],C_fix(15));
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2196,a[2]=((C_word*)t0)[2],a[3]=((C_word)li18),tmp=(C_word)a,a+=4,tmp);
/* tcp.scm:411: ##sys#decode-buffer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[53]+1));
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=*((C_word*)lf[53]+1);
av2[1]=((C_word*)t0)[4];
av2[2]=((C_word*)t0)[6];
av2[3]=((C_word*)((C_word*)t0)[2])[1];
av2[4]=C_fix(1);
av2[5]=t2;
av2[6]=t3;
tp(7,av2);}}}

/* a2195 in k2179 in a2176 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2196(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2196,c,av);}
t5=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],t4);
t6=C_set_block_item(((C_word*)t0)[2],0,t5);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_utf_decode(t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* a2208 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2209(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(12,c,3)))){
C_save_and_reclaim((void *)f_2209,c,av);}
a=C_alloc(12);
t2=C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t2)){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_i_foreign_fixnum_argumentp(((C_word*)t0)[4]);
t4=stub209(C_SCHEME_UNDEFINED,t3);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2222,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t6=C_eqp(C_fix((C_word)SOCKET_ERROR),t4);
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2235,a[2]=t5,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2239,a[2]=t7,a[3]=C_SCHEME_UNDEFINED,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t8;
av2[2]=lf[54];
av2[3]=lf[13];
tp(4,av2);}}
else{
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_eqp(t4,C_fix(1));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}}

/* k2220 in a2208 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2222(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2222,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_eqp(((C_word*)t0)[3],C_fix(1));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k2233 in a2208 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2235(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_2235,c,av);}
/* tcp.scm:421: ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[7];
av2[3]=C_SCHEME_FALSE;
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k2237 in a2208 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2239(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_2239,c,av);}
a=C_alloc(8);
t2=C_mutate(((C_word *)t0)+3,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2243,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t4=stub114(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
/* tcp.scm:172: ##sys#peek-c-string */
t7=*((C_word*)lf[10]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=stub118(t5,t6);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k2241 in k2237 in a2208 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2243(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_2243,c,av);}
t2=((C_word*)t0)[2];
/* tcp.scm:421: scheme#string-append */
t3=*((C_word*)lf[9]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=((C_word*)t2)[2];
av2[2]=((C_word*)t2)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* a2250 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2251(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_2251,c,av);}
a=C_alloc(5);
if(C_truep(((C_word*)((C_word*)t0)[2])[1])){
t2=C_SCHEME_UNDEFINED;
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=C_set_block_item(((C_word*)t0)[2],0,C_SCHEME_TRUE);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2259,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_slot(((C_word*)t0)[5],C_fix(1)))){
t4=t3;
f_2259(t4,C_SCHEME_UNDEFINED);}
else{
t4=C_fix((C_word)SHUT_RD);
t5=t3;
f_2259(t5,stub192(C_SCHEME_UNDEFINED,C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]),C_i_foreign_fixnum_argumentp(t4)));}}}

/* k2257 in a2250 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void f_2259(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_2259,2,t0,t1);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2265,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)((C_word*)t0)[4])[1])){
t3=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
t4=t2;
f_2265(t4,C_eqp(C_fix((C_word)SOCKET_ERROR),stub173(C_SCHEME_UNDEFINED,t3)));}
else{
t3=t2;
f_2265(t3,C_SCHEME_FALSE);}}

/* k2263 in k2257 in a2250 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void f_2265(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,3)))){
C_save_and_reclaim_args((void *)trf_2265,2,t0,t1);}
a=C_alloc(7);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2272,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2276,a[2]=t2,a[3]=C_SCHEME_UNDEFINED,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t3;
av2[2]=lf[55];
av2[3]=lf[13];
tp(4,av2);}}
else{
t2=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k2270 in k2263 in k2257 in a2250 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2272(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_2272,c,av);}
t2=((C_word*)t0)[2];
/* tcp.scm:428: ##sys#signal-hook */
t3=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=((C_word*)t2)[2];
av2[2]=lf[7];
av2[3]=C_SCHEME_FALSE;
av2[4]=t1;
av2[5]=((C_word*)t2)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}

/* k2274 in k2263 in k2257 in a2250 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2276(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_2276,c,av);}
a=C_alloc(8);
t2=C_mutate(((C_word *)t0)+3,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2280,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t4=stub114(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
/* tcp.scm:172: ##sys#peek-c-string */
t7=*((C_word*)lf[10]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=stub118(t5,t6);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k2278 in k2274 in k2263 in k2257 in a2250 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2280(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_2280,c,av);}
t2=((C_word*)t0)[2];
/* tcp.scm:428: scheme#string-append */
t3=*((C_word*)lf[9]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=((C_word*)t2)[2];
av2[2]=((C_word*)t2)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* a2300 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2301(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_2301,c,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2305,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
/* tcp.scm:432: read-input */
t3=((C_word*)t0)[6];
f_1745(t3,t2);}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_2305(2,av2);}}}

/* k2303 in a2300 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2305(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,6)))){
C_save_and_reclaim((void *)f_2305,c,av);}
a=C_alloc(3);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t2=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_END_OF_FILE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=C_slot(((C_word*)((C_word*)t0)[5])[1],C_fix(15));
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2320,a[2]=((C_word)li22),tmp=(C_word)a,a+=3,tmp);
/* tcp.scm:435: ##sys#decode-buffer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[53]+1));
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=*((C_word*)lf[53]+1);
av2[1]=((C_word*)t0)[4];
av2[2]=((C_word*)t0)[6];
av2[3]=((C_word*)((C_word*)t0)[2])[1];
av2[4]=C_fix(1);
av2[5]=t2;
av2[6]=t3;
tp(7,av2);}}}

/* a2319 in k2303 in a2300 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2320(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2320,c,av);}
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_utf_decode(t2,t3);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* a2328 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2329(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(11,c,5)))){
C_save_and_reclaim((void *)f_2329,c,av);}
a=C_alloc(11);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2335,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t4,a[5]=((C_word*)t0)[4],a[6]=t7,a[7]=((C_word*)t0)[5],a[8]=((C_word)li24),tmp=(C_word)a,a+=9,tmp));
t9=((C_word*)t7)[1];
f_2335(t9,t1,t3,C_fix(0),t5);}

/* loop in a2328 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void f_2335(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(8,0,4)))){
C_save_and_reclaim_args((void *)trf_2335,5,t0,t1,t2,t3,t4);}
a=C_alloc(8);
t5=C_eqp(t2,C_fix(0));
if(C_truep(t5)){
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
if(C_truep(C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t6=C_fixnum_difference(((C_word*)((C_word*)t0)[3])[1],((C_word*)((C_word*)t0)[2])[1]);
t7=C_fixnum_lessp(t2,t6);
t8=(C_truep(t7)?t2:t6);
t9=C_copy_memory_with_offset(((C_word*)t0)[4],((C_word*)t0)[5],t4,((C_word*)((C_word*)t0)[2])[1],t8);
t10=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],t8);
t11=C_set_block_item(((C_word*)t0)[2],0,t10);
/* tcp.scm:448: loop */
t13=t1;
t14=C_fixnum_difference(t2,t8);
t15=C_fixnum_plus(t3,t8);
t16=C_fixnum_plus(t4,t8);
t1=t13;
t2=t14;
t3=t15;
t4=t16;
goto loop;}
else{
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2379,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t3,a[5]=((C_word*)t0)[6],a[6]=t2,a[7]=t4,tmp=(C_word)a,a+=8,tmp);
/* tcp.scm:450: read-input */
t7=((C_word*)t0)[7];
f_1745(t7,t6);}}}

/* k2377 in loop in a2328 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2379(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_2379,c,av);}
t2=C_eqp(((C_word*)((C_word*)t0)[2])[1],C_fix(0));
if(C_truep(t2)){
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* tcp.scm:453: loop */
t3=((C_word*)((C_word*)t0)[5])[1];
f_2335(t3,((C_word*)t0)[3],((C_word*)t0)[6],((C_word*)t0)[4],((C_word*)t0)[7]);}}

/* a2389 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2390(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(10,c,2)))){
C_save_and_reclaim((void *)f_2390,c,av);}
a=C_alloc(10);
t4=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_2394,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=t3,a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[6],a[9]=t2,tmp=(C_word)a,a+=10,tmp);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
/* tcp.scm:457: read-input */
t5=((C_word*)t0)[5];
f_1745(t5,t4);}
else{
t5=t4;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_SCHEME_UNDEFINED;
f_2394(2,av2);}}}

/* k2392 in a2389 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2394(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(16,c,5)))){
C_save_and_reclaim((void *)f_2394,c,av);}
a=C_alloc(16);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t2=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_END_OF_FILE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=(C_truep(((C_word*)t0)[5])?((C_word*)t0)[5]:C_fixnum_difference(*((C_word*)lf[56]+1),((C_word*)((C_word*)t0)[2])[1]));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2408,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word)li27),tmp=(C_word)a,a+=9,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2468,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[2],a[4]=((C_word)li28),tmp=(C_word)a,a+=5,tmp);
/* tcp.scm:461: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[4];
av2[2]=t5;
av2[3]=t6;
C_call_with_values(4,av2);}}}

/* a2407 in k2392 in a2389 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2408(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,6)))){
C_save_and_reclaim((void *)f_2408,c,av);}
a=C_alloc(8);
t2=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]);
t3=C_i_fixnum_min(((C_word*)((C_word*)t0)[4])[1],t2);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2418,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word)li26),tmp=(C_word)a,a+=8,tmp);
/* tcp.scm:462: ##sys#scan-buffer-line */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[57]+1));
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=*((C_word*)lf[57]+1);
av2[1]=t1;
av2[2]=((C_word*)t0)[5];
av2[3]=t3;
av2[4]=((C_word*)((C_word*)t0)[2])[1];
av2[5]=t4;
av2[6]=C_slot(((C_word*)((C_word*)t0)[7])[1],C_fix(15));
tp(7,av2);}}

/* a2417 in a2407 in k2392 in a2389 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2418(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_2418,c,av);}
a=C_alloc(8);
t3=C_fixnum_difference(t2,((C_word*)((C_word*)t0)[2])[1]);
if(C_truep(C_fixnum_greater_or_equal_p(t3,((C_word*)((C_word*)t0)[3])[1]))){
/* tcp.scm:469: scheme#values */{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_SCHEME_FALSE;
av2[3]=t2;
av2[4]=C_SCHEME_FALSE;
C_values(5,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2434,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[4],a[6]=t1,a[7]=((C_word*)t0)[5],tmp=(C_word)a,a+=8,tmp);
/* tcp.scm:470: read-input */
t5=((C_word*)t0)[6];
f_1745(t5,t4);}}

/* k2432 in a2417 in a2407 in k2392 in a2389 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2434(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_2434,c,av);}
t2=C_fixnum_difference(((C_word*)((C_word*)t0)[2])[1],((C_word*)t0)[3]);
t3=C_set_block_item(((C_word*)t0)[2],0,t2);
if(C_truep(C_fixnum_lessp(((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[5])[1]))){
t4=C_fixnum_plus(((C_word*)((C_word*)t0)[4])[1],((C_word*)((C_word*)t0)[2])[1]);
/* tcp.scm:473: scheme#values */{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=((C_word*)t0)[6];
av2[2]=((C_word*)t0)[7];
av2[3]=((C_word*)((C_word*)t0)[4])[1];
av2[4]=C_i_fixnum_min(((C_word*)((C_word*)t0)[5])[1],t4);
C_values(5,av2);}}
else{
/* tcp.scm:476: scheme#values */{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=((C_word*)t0)[6];
av2[2]=C_SCHEME_FALSE;
av2[3]=((C_word*)((C_word*)t0)[4])[1];
av2[4]=C_SCHEME_FALSE;
C_values(5,av2);}}}

/* a2467 in k2392 in a2389 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2468(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2468,c,av);}
if(C_truep(t4)){
t5=C_slot(((C_word*)t0)[2],C_fix(4));
t6=C_fixnum_plus(t5,C_fix(1));
t7=C_i_set_i_slot(((C_word*)t0)[2],C_fix(4),t6);
t8=C_i_set_i_slot(((C_word*)t0)[2],C_fix(5),C_fix(0));
t9=C_mutate(((C_word *)((C_word*)t0)[3])+1,t2);
t10=t1;{
C_word *av2=av;
av2[0]=t10;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}
else{
t5=C_slot(((C_word*)t0)[2],C_fix(5));
t6=C_i_string_length(t3);
t7=C_fixnum_plus(t5,t6);
t8=C_i_set_i_slot(((C_word*)t0)[2],C_fix(5),t7);
t9=C_mutate(((C_word *)((C_word*)t0)[3])+1,t2);
t10=t1;{
C_word *av2=av;
av2[0]=t10;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}}

/* a2512 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2513(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_2513,c,av);}
a=C_alloc(5);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=lf[58];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2523,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* tcp.scm:491: ##sys#buffer->string/encoding */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[59]+1));
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[59]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)((C_word*)t0)[2])[1];
av2[4]=((C_word*)((C_word*)t0)[3])[1];
av2[5]=C_slot(((C_word*)((C_word*)t0)[5])[1],C_fix(15));
tp(6,av2);}}}

/* k2521 in a2512 in k1742 in k1739 in k1733 in k1730 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2523(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2523,c,av);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k2548 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2550(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_2550,c,av);}
/* tcp.scm:366: ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[7];
av2[3]=((C_word*)t0)[3];
av2[4]=t1;
av2[5]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k2552 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2554(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_2554,c,av);}
a=C_alloc(9);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2558,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=C_a_i_bytevector(&a,1,C_fix(3));
t4=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
/* tcp.scm:172: ##sys#peek-c-string */
t5=*((C_word*)lf[10]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t2;
av2[2]=stub118(t3,t4);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k2556 in k2552 in chicken.tcp#io-ports in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2558(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_2558,c,av);}
/* tcp.scm:366: scheme#string-append */
t2=*((C_word*)lf[9]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* chicken.tcp#tcp-accept in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2562(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_2562,c,av);}
a=C_alloc(6);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?lf[67]:C_get_rest_arg(c,3,av,3,t0));
t5=C_i_check_structure(t2,lf[5]);
t6=C_slot(t2,C_fix(1));
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2575,a[2]=t6,a[3]=t4,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* tcp.scm:591: tcp-accept-timeout */
t8=*((C_word*)lf[30]+1);{
C_word *av2=av;
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}

/* k2573 in chicken.tcp#tcp-accept in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2575(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,2)))){
C_save_and_reclaim((void *)f_2575,c,av);}
a=C_alloc(11);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2578,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
if(C_truep(t1)){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2658,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* tcp.scm:592: chicken.time#current-process-milliseconds */
t4=*((C_word*)lf[41]+1);{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=t2;
f_2578(t3,C_SCHEME_FALSE);}}

/* k2576 in k2573 in chicken.tcp#tcp-accept in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void f_2578(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,0,2)))){
C_save_and_reclaim_args((void *)trf_2578,2,t0,t1);}
a=C_alloc(11);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2583,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t1,a[8]=((C_word)li32),tmp=(C_word)a,a+=9,tmp));
t5=((C_word*)t3)[1];{
C_word av2[2];
av2[0]=t5;
av2[1]=((C_word*)t0)[6];
f_2583(2,av2);}}

/* loop in k2576 in k2573 in chicken.tcp#tcp-accept in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2583(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_2583,c,av);}
a=C_alloc(8);
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2587,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
if(C_truep(((C_word*)t0)[7])){
/* tcp.scm:595: ##sys#thread-block-for-timeout! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[38]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[38]+1);
av2[1]=t2;
av2[2]=*((C_word*)lf[32]+1);
av2[3]=((C_word*)t0)[7];
tp(4,av2);}}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_2587(2,av2);}}}

/* k2585 in loop in k2576 in k2573 in chicken.tcp#tcp-accept in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2587(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_2587,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2590,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* tcp.scm:596: ##sys#thread-block-for-i/o! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[36]+1));
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[36]+1);
av2[1]=t2;
av2[2]=*((C_word*)lf[32]+1);
av2[3]=((C_word*)t0)[2];
av2[4]=lf[37];
tp(5,av2);}}

/* k2588 in k2585 in loop in k2576 in k2573 in chicken.tcp#tcp-accept in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2590(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_2590,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2593,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* tcp.scm:597: ##sys#thread-yield! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[35]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[35]+1);
av2[1]=t3;
tp(2,av2);}}

/* k2591 in k2588 in k2585 in loop in k2576 in k2573 in chicken.tcp#tcp-accept in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2593(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,6)))){
C_save_and_reclaim((void *)f_2593,c,av);}
a=C_alloc(7);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2596,a[2]=((C_word*)t2)[2],a[3]=((C_word*)t2)[3],a[4]=((C_word*)t2)[4],a[5]=((C_word*)t2)[5],a[6]=((C_word*)t2)[6],tmp=(C_word)a,a+=7,tmp);
if(C_truep(C_slot(*((C_word*)lf[32]+1),C_fix(13)))){
/* tcp.scm:599: ##sys#signal-hook */
t4=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[33];
av2[3]=lf[68];
av2[4]=lf[70];
av2[5]=((C_word*)t2)[7];
av2[6]=((C_word*)t2)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(7,av2);}}
else{
t4=t3;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
f_2596(2,av2);}}}

/* k2594 in k2591 in k2588 in k2585 in loop in k2576 in k2573 in chicken.tcp#tcp-accept in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2596(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_2596,c,av);}
a=C_alloc(8);
t2=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t3=stub162(C_SCHEME_UNDEFINED,t2,C_SCHEME_FALSE,C_SCHEME_FALSE);
t4=C_eqp(C_fix((C_word)INVALID_SOCKET),t3);
if(C_truep(C_i_not(t4))){
/* tcp.scm:605: io-ports */
t5=lf[31];
f_1728(t5,((C_word*)t0)[3],lf[68],t3,((C_word*)t0)[4]);}
else{
if(C_truep(stub129(C_SCHEME_UNDEFINED))){
/* tcp.scm:607: ##sys#dispatch-interrupt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[39]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[39]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)((C_word*)t0)[5])[1];
tp(3,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2624,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2628,a[2]=t5,a[3]=C_SCHEME_UNDEFINED,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t6;
av2[2]=lf[69];
av2[3]=lf[13];
tp(4,av2);}}}}

/* k2622 in k2594 in k2591 in k2588 in k2585 in loop in k2576 in k2573 in chicken.tcp#tcp-accept in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2624(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_2624,c,av);}
/* tcp.scm:609: ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[7];
av2[3]=lf[68];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k2626 in k2594 in k2591 in k2588 in k2585 in loop in k2576 in k2573 in chicken.tcp#tcp-accept in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2628(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_2628,c,av);}
a=C_alloc(8);
t2=C_mutate(((C_word *)t0)+3,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2632,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t4=stub114(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
/* tcp.scm:172: ##sys#peek-c-string */
t7=*((C_word*)lf[10]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=stub118(t5,t6);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k2630 in k2626 in k2594 in k2591 in k2588 in k2585 in loop in k2576 in k2573 in chicken.tcp#tcp-accept in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2632(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_2632,c,av);}
t2=((C_word*)t0)[2];
/* tcp.scm:609: scheme#string-append */
t3=*((C_word*)lf[9]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=((C_word*)t2)[2];
av2[2]=((C_word*)t2)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k2656 in k2573 in chicken.tcp#tcp-accept in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2658(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,1)))){
C_save_and_reclaim((void *)f_2658,c,av);}
a=C_alloc(29);
t2=((C_word*)t0)[2];
f_2578(t2,C_s_a_i_plus(&a,2,((C_word*)t0)[3],t1));}

/* chicken.tcp#tcp-accept-ready? in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2666(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(12,c,3)))){
C_save_and_reclaim((void *)f_2666,c,av);}
a=C_alloc(12);
t3=C_i_check_structure_2(t2,lf[5],lf[72]);
t4=C_slot(t2,C_fix(1));
t5=C_i_foreign_fixnum_argumentp(t4);
t6=stub209(C_SCHEME_UNDEFINED,t5);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2676,a[2]=t1,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
t8=C_eqp(C_fix((C_word)SOCKET_ERROR),t6);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2689,a[2]=t7,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2693,a[2]=t9,a[3]=C_SCHEME_UNDEFINED,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t10;
av2[2]=lf[73];
av2[3]=lf[13];
tp(4,av2);}}
else{
t9=t1;{
C_word *av2=av;
av2[0]=t9;
av2[1]=C_eqp(C_fix(1),t6);
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}}

/* k2674 in chicken.tcp#tcp-accept-ready? in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2676(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2676,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_eqp(C_fix(1),((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k2687 in chicken.tcp#tcp-accept-ready? in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2689(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_2689,c,av);}
/* tcp.scm:616: ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[7];
av2[3]=lf[72];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k2691 in chicken.tcp#tcp-accept-ready? in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2693(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_2693,c,av);}
a=C_alloc(8);
t2=C_mutate(((C_word *)t0)+3,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2697,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t4=stub114(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
/* tcp.scm:172: ##sys#peek-c-string */
t7=*((C_word*)lf[10]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=stub118(t5,t6);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k2695 in k2691 in chicken.tcp#tcp-accept-ready? in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2697(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_2697,c,av);}
t2=((C_word*)t0)[2];
/* tcp.scm:616: scheme#string-append */
t3=*((C_word*)lf[9]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=((C_word*)t2)[2];
av2[2]=((C_word*)t2)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2716(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(10,c,2)))){
C_save_and_reclaim((void *)f_2716,c,av);}
a=C_alloc(10);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_rest_nullp(c,3);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_get_rest_arg(c,3,av,3,t0));
t6=t5;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_rest_nullp(c,3);
t9=C_rest_nullp(c,4);
t10=(C_truep(t9)?lf[67]:C_get_rest_arg(c,4,av,3,t0));
t11=C_rest_nullp(c,4);
t12=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2732,a[2]=t3,a[3]=t7,a[4]=t1,a[5]=t10,tmp=(C_word)a,a+=6,tmp);
/* tcp.scm:628: tcp-connect-timeout */
t13=*((C_word*)lf[29]+1);{
C_word *av2=av;
av2[0]=t13;
av2[1]=t12;
((C_proc)(void*)(*((C_word*)t13+1)))(2,av2);}}

/* k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2732(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,2)))){
C_save_and_reclaim((void *)f_2732,c,av);}
a=C_alloc(11);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_2735,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=C_SCHEME_UNDEFINED,tmp=(C_word)a,a+=7,tmp);
if(C_truep(t1)){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3000,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* tcp.scm:629: chicken.time#current-process-milliseconds */
t4=*((C_word*)lf[41]+1);{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=t2;
f_2735(t3,C_SCHEME_FALSE);}}

/* k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void f_2735(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,0,3)))){
C_save_and_reclaim_args((void *)trf_2735,2,t0,t1);}
a=C_alloc(3);
t2=C_mutate(((C_word *)t0)+6,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2738,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t4=C_fix((C_word)sizeof(struct sockaddr_in));
/* ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[19]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[19]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=C_make_character(32);
tp(4,av2);}}

/* k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2738(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(22,c,4)))){
C_save_and_reclaim((void *)f_2738,c,av);}
a=C_alloc(22);
t2=((C_word*)t0)[2];
t3=C_i_check_string(((C_word*)((C_word*)t2)[2])[1]);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_2744,a[2]=((C_word*)t2)[3],a[3]=((C_word*)t2)[4],a[4]=((C_word*)t2)[5],a[5]=t1,a[6]=((C_word*)t2)[6],a[7]=((C_word*)t2)[2],tmp=(C_word)a,a+=8,tmp);
if(C_truep(((C_word*)((C_word*)t2)[3])[1])){
t5=t4;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_SCHEME_UNDEFINED;
f_2744(2,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2975,a[2]=((C_word*)t2)[3],a[3]=t4,a[4]=((C_word*)t2)[2],tmp=(C_word)a,a+=5,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2983,a[2]=((C_word*)t2)[2],a[3]=((C_word)li37),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2989,a[2]=((C_word*)t2)[2],a[3]=((C_word*)t2)[3],a[4]=((C_word)li38),tmp=(C_word)a,a+=5,tmp);
/* tcp.scm:633: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t5;
av2[2]=t6;
av2[3]=t7;
C_call_with_values(4,av2);}}}

/* k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2744(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_2744,c,av);}
a=C_alloc(7);
t2=C_i_check_fixnum(((C_word*)((C_word*)t0)[2])[1]);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2750,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2969,a[2]=t3,a[3]=((C_word*)t0)[7],tmp=(C_word)a,a+=4,tmp);
/* tcp.scm:636: gethostaddr */
f_1327(t4,((C_word*)t0)[5],((C_word*)((C_word*)t0)[7])[1],((C_word*)((C_word*)t0)[2])[1]);}

/* k2748 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2750(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(18,c,3)))){
C_save_and_reclaim((void *)f_2750,c,av);}
a=C_alloc(18);
t2=((C_word*)t0)[2];
t3=C_fix((C_word)AF_INET);
t4=C_fix((C_word)SOCK_STREAM);
t5=stub135(C_SCHEME_UNDEFINED,C_i_foreign_fixnum_argumentp(t3),C_i_foreign_fixnum_argumentp(t4),C_fix(0));
t6=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2756,a[2]=t5,a[3]=((C_word*)t2)[3],a[4]=((C_word*)t2)[4],a[5]=((C_word*)t2)[5],a[6]=((C_word*)t2)[6],a[7]=((C_word*)t2)[7],a[8]=((C_word*)t2)[2],tmp=(C_word)a,a+=9,tmp);
t7=C_eqp(C_fix((C_word)INVALID_SOCKET),t5);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2952,a[2]=t6,a[3]=((C_word*)t2)[7],a[4]=((C_word*)t2)[2],tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2956,a[2]=t8,a[3]=C_SCHEME_UNDEFINED,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t9;
av2[2]=lf[81];
av2[3]=lf[13];
tp(4,av2);}}
else{
t8=t6;{
C_word *av2=av;
av2[0]=t8;
av2[1]=C_SCHEME_UNDEFINED;
f_2756(2,av2);}}}

/* k2754 in k2748 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2756(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,3)))){
C_save_and_reclaim((void *)f_2756,c,av);}
a=C_alloc(11);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2759,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t3=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t4=C_eqp(C_fix((C_word)SOCKET_ERROR),stub214(C_SCHEME_UNDEFINED,t3));
if(C_truep(t4)){
t5=stub114(C_SCHEME_UNDEFINED);
t6=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t7=stub173(C_SCHEME_UNDEFINED,t6);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2928,a[2]=t2,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2932,a[2]=t8,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t9;
av2[2]=lf[80];
av2[3]=lf[13];
tp(4,av2);}}
else{
t5=t2;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_SCHEME_UNDEFINED;
f_2759(2,av2);}}}

/* k2757 in k2754 in k2748 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2759(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,3)))){
C_save_and_reclaim((void *)f_2759,c,av);}
a=C_alloc(11);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2762,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
if(C_truep(make_socket_nonblocking(((C_word*)t2)[2]))){
t4=t3;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
f_2762(2,av2);}}
else{
t4=stub114(C_SCHEME_UNDEFINED);
t5=C_i_foreign_fixnum_argumentp(((C_word*)t2)[2]);
t6=stub173(C_SCHEME_UNDEFINED,t5);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2902,a[2]=t3,a[3]=((C_word*)t2)[2],tmp=(C_word)a,a+=4,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2906,a[2]=t7,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t8;
av2[2]=lf[79];
av2[3]=lf[13];
tp(4,av2);}}}

/* k2760 in k2757 in k2754 in k2748 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2762(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(16,c,2)))){
C_save_and_reclaim((void *)f_2762,c,av);}
a=C_alloc(16);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_2765,a[2]=((C_word*)t2)[2],a[3]=((C_word*)t2)[3],a[4]=((C_word*)t2)[4],tmp=(C_word)a,a+=5,tmp);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_2828,a[2]=((C_word*)t2)[2],a[3]=((C_word*)t2)[5],a[4]=((C_word*)t2)[6],a[5]=t5,a[6]=((C_word*)t2)[7],a[7]=((C_word*)t2)[8],a[8]=((C_word)li35),tmp=(C_word)a,a+=9,tmp));
t7=((C_word*)t5)[1];{
C_word *av2=av;
av2[0]=t7;
av2[1]=t3;
f_2828(2,av2);}}

/* k2763 in k2760 in k2757 in k2754 in k2748 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2765(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,4)))){
C_save_and_reclaim((void *)f_2765,c,av);}
a=C_alloc(11);
t2=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t3=stub743(C_SCHEME_UNDEFINED,t2);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2771,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t5=C_eqp(C_fix((C_word)SOCKET_ERROR),t3);
if(C_truep(t5)){
t6=stub114(C_SCHEME_UNDEFINED);
t7=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t8=stub173(C_SCHEME_UNDEFINED,t7);
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2790,a[2]=t4,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2794,a[2]=t9,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t10;
av2[2]=lf[76];
av2[3]=lf[13];
tp(4,av2);}}
else{
if(C_truep(C_fixnum_greaterp(t3,C_fix(0)))){
t6=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t7=stub173(C_SCHEME_UNDEFINED,t6);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2816,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2820,a[2]=t8,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t9;
av2[2]=lf[77];
av2[3]=lf[13];
tp(4,av2);}}
else{
/* tcp.scm:663: io-ports */
t6=lf[31];
f_1728(t6,((C_word*)t0)[3],lf[75],((C_word*)t0)[2],((C_word*)t0)[4]);}}}

/* k2769 in k2763 in k2760 in k2757 in k2754 in k2748 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2771(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_2771,c,av);}
t2=((C_word*)t0)[2];
/* tcp.scm:663: io-ports */
t3=lf[31];
f_1728(t3,((C_word*)t2)[3],lf[75],((C_word*)t2)[2],((C_word*)t2)[4]);}

/* k2788 in k2763 in k2760 in k2757 in k2754 in k2748 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2790(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_2790,c,av);}
/* tcp.scm:659: ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[7];
av2[3]=lf[75];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k2792 in k2763 in k2760 in k2757 in k2754 in k2748 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2794(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_2794,c,av);}
a=C_alloc(9);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2798,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=C_a_i_bytevector(&a,1,C_fix(3));
t4=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
/* tcp.scm:172: ##sys#peek-c-string */
t5=*((C_word*)lf[10]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t2;
av2[2]=stub118(t3,t4);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k2796 in k2792 in k2763 in k2760 in k2757 in k2754 in k2748 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2798(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_2798,c,av);}
/* tcp.scm:659: scheme#string-append */
t2=*((C_word*)lf[9]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k2814 in k2763 in k2760 in k2757 in k2754 in k2748 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2816(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_2816,c,av);}
/* tcp.scm:662: ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[7];
av2[3]=lf[75];
av2[4]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* k2818 in k2763 in k2760 in k2757 in k2754 in k2748 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2820(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_2820,c,av);}
a=C_alloc(9);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2824,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=C_a_i_bytevector(&a,1,C_fix(3));
t4=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
/* tcp.scm:172: ##sys#peek-c-string */
t5=*((C_word*)lf[10]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t2;
av2[2]=stub118(t3,t4);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k2822 in k2818 in k2763 in k2760 in k2757 in k2754 in k2748 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2824(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_2824,c,av);}
/* tcp.scm:662: scheme#string-append */
t2=*((C_word*)lf[9]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* loop in k2760 in k2757 in k2754 in k2748 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2828(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(10,c,4)))){
C_save_and_reclaim((void *)f_2828,c,av);}
a=C_alloc(10);
t2=C_fix((C_word)sizeof(struct sockaddr_in));
t3=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t4=(C_truep(((C_word*)t0)[3])?C_i_foreign_block_argumentp(((C_word*)t0)[3]):C_SCHEME_FALSE);
t5=C_i_foreign_fixnum_argumentp(t2);
t6=C_eqp(C_fix((C_word)SOCKET_ERROR),stub200(C_SCHEME_UNDEFINED,t3,t4,t5));
if(C_truep(t6)){
if(C_truep(stub126(C_SCHEME_UNDEFINED))){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2844,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)t0)[4])){
/* tcp.scm:649: ##sys#thread-block-for-timeout! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[38]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[38]+1);
av2[1]=t7;
av2[2]=*((C_word*)lf[32]+1);
av2[3]=((C_word*)t0)[4];
tp(4,av2);}}
else{
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f3610,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* tcp.scm:650: ##sys#thread-block-for-i/o! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[36]+1));
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[36]+1);
av2[1]=t8;
av2[2]=*((C_word*)lf[32]+1);
av2[3]=((C_word*)t0)[2];
av2[4]=lf[43];
tp(5,av2);}}}
else{
if(C_truep(stub129(C_SCHEME_UNDEFINED))){
/* tcp.scm:653: ##sys#dispatch-interrupt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[39]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[39]+1);
av2[1]=t1;
av2[2]=((C_word*)((C_word*)t0)[5])[1];
tp(3,av2);}}
else{
t7=stub114(C_SCHEME_UNDEFINED);
t8=C_i_foreign_fixnum_argumentp(((C_word*)t0)[2]);
t9=stub173(C_SCHEME_UNDEFINED,t8);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_2875,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],tmp=(C_word)a,a+=6,tmp);
t11=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2879,a[2]=t10,a[3]=t7,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t11;
av2[2]=lf[78];
av2[3]=lf[13];
tp(4,av2);}}}}
else{
t7=C_SCHEME_UNDEFINED;
t8=t1;{
C_word *av2=av;
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}

/* k2842 in loop in k2760 in k2757 in k2754 in k2748 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2844(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_2844,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2847,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* tcp.scm:650: ##sys#thread-block-for-i/o! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[36]+1));
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[36]+1);
av2[1]=t2;
av2[2]=*((C_word*)lf[32]+1);
av2[3]=((C_word*)t0)[3];
av2[4]=lf[43];
tp(5,av2);}}

/* k2845 in k2842 in loop in k2760 in k2757 in k2754 in k2748 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2847(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2847,c,av);}
/* tcp.scm:651: ##sys#thread-yield! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[35]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[35]+1);
av2[1]=((C_word*)t0)[2];
tp(2,av2);}}

/* k2873 in loop in k2760 in k2757 in k2754 in k2748 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2875(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,7)))){
C_save_and_reclaim((void *)f_2875,c,av);}
/* tcp.scm:655: ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 8) {
  av2=av;
} else {
  av2=C_alloc(8);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[7];
av2[3]=lf[75];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)((C_word*)t0)[4])[1];
av2[7]=((C_word*)((C_word*)t0)[5])[1];
((C_proc)(void*)(*((C_word*)t2+1)))(8,av2);}}

/* k2877 in loop in k2760 in k2757 in k2754 in k2748 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2879(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_2879,c,av);}
a=C_alloc(9);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2883,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=C_a_i_bytevector(&a,1,C_fix(3));
t4=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
/* tcp.scm:172: ##sys#peek-c-string */
t5=*((C_word*)lf[10]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t2;
av2[2]=stub118(t3,t4);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k2881 in k2877 in loop in k2760 in k2757 in k2754 in k2748 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2883(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_2883,c,av);}
/* tcp.scm:655: scheme#string-append */
t2=*((C_word*)lf[9]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k2900 in k2757 in k2754 in k2748 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2902(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_2902,c,av);}
/* tcp.scm:644: ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[7];
av2[3]=lf[75];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k2904 in k2757 in k2754 in k2748 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2906(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_2906,c,av);}
a=C_alloc(9);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2910,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=C_a_i_bytevector(&a,1,C_fix(3));
t4=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
/* tcp.scm:172: ##sys#peek-c-string */
t5=*((C_word*)lf[10]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t2;
av2[2]=stub118(t3,t4);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k2908 in k2904 in k2757 in k2754 in k2748 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2910(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_2910,c,av);}
/* tcp.scm:644: scheme#string-append */
t2=*((C_word*)lf[9]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k2926 in k2754 in k2748 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2928(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_2928,c,av);}
/* tcp.scm:642: ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[7];
av2[3]=lf[75];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k2930 in k2754 in k2748 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2932(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_2932,c,av);}
a=C_alloc(9);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_2936,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t3=C_a_i_bytevector(&a,1,C_fix(3));
t4=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
/* tcp.scm:172: ##sys#peek-c-string */
t5=*((C_word*)lf[10]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t2;
av2[2]=stub118(t3,t4);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k2934 in k2930 in k2754 in k2748 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2936(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_2936,c,av);}
/* tcp.scm:642: scheme#string-append */
t2=*((C_word*)lf[9]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k2950 in k2748 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2952(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_2952,c,av);}
/* tcp.scm:640: ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[7];
av2[3]=lf[75];
av2[4]=t1;
av2[5]=((C_word*)((C_word*)t0)[3])[1];
av2[6]=((C_word*)((C_word*)t0)[4])[1];
((C_proc)(void*)(*((C_word*)t2+1)))(7,av2);}}

/* k2954 in k2748 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2956(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_2956,c,av);}
a=C_alloc(8);
t2=C_mutate(((C_word *)t0)+3,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2960,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t4=stub114(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
/* tcp.scm:172: ##sys#peek-c-string */
t7=*((C_word*)lf[10]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=stub118(t5,t6);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k2958 in k2954 in k2748 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2960(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_2960,c,av);}
t2=((C_word*)t0)[2];
/* tcp.scm:640: scheme#string-append */
t3=*((C_word*)lf[9]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=((C_word*)t2)[2];
av2[2]=((C_word*)t2)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k2967 in k2742 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2969(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_2969,c,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_UNDEFINED;
f_2750(2,av2);}}
else{
/* tcp.scm:637: ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[7];
av2[3]=lf[75];
av2[4]=lf[82];
av2[5]=((C_word*)((C_word*)t0)[3])[1];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}

/* k2973 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2975(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_2975,c,av);}
if(C_truep(((C_word*)((C_word*)t0)[2])[1])){
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
f_2744(2,av2);}}
else{
/* tcp.scm:634: ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[20];
av2[3]=lf[75];
av2[4]=lf[83];
av2[5]=((C_word*)((C_word*)t0)[4])[1];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}

/* a2982 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2983(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_2983,c,av);}
a=C_alloc(9);
t2=((C_word*)((C_word*)t0)[2])[1];
t3=lf[84];
t4=C_i_string_length(t2);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_1359,a[2]=t4,a[3]=t2,a[4]=t3,a[5]=t6,a[6]=((C_word)li36),tmp=(C_word)a,a+=7,tmp));
t8=((C_word*)t6)[1];
f_1359(t8,t1,C_fix(0));}

/* a2988 in k2736 in k2733 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_2989(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_2989,c,av);}
t4=C_mutate(((C_word *)((C_word*)t0)[2])+1,t2);
t5=C_mutate(((C_word *)((C_word*)t0)[3])+1,t3);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* k2998 in k2730 in chicken.tcp#tcp-connect in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3000(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,1)))){
C_save_and_reclaim((void *)f_3000,c,av);}
a=C_alloc(29);
t2=((C_word*)t0)[2];
f_2735(t2,C_s_a_i_plus(&a,2,t1,((C_word*)t0)[3]));}

/* chicken.tcp#tcp-port->fileno in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void f_3026(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_3026,3,t1,t2,t3);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3030,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* tcp.scm:666: ##sys#port-data */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[90]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[90]+1);
av2[1]=t4;
av2[2]=t2;
tp(3,av2);}}

/* k3028 in chicken.tcp#tcp-port->fileno in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3030(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_3030,c,av);}
if(C_truep(C_i_vectorp(t1))){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_slot(t1,C_fix(0));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* tcp.scm:669: chicken.base#error */
t2=*((C_word*)lf[88]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=lf[89];
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}}

/* chicken.tcp#tcp-addresses in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3044(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_3044,c,av);}
a=C_alloc(5);
t3=C_i_check_port_2(t2,C_fix(0),C_SCHEME_TRUE,lf[92]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3050,a[2]=t1,a[3]=t2,a[4]=C_SCHEME_UNDEFINED,tmp=(C_word)a,a+=5,tmp);
/* tcp.scm:673: tcp-port->fileno */
f_3026(t4,t2,lf[92]);}

/* k3048 in chicken.tcp#tcp-addresses in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3050(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_3050,c,av);}
a=C_alloc(8);
t2=C_mutate(((C_word *)t0)+4,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3057,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=C_i_foreign_fixnum_argumentp(((C_word*)t0)[4]);
/* tcp.scm:193: ##sys#peek-c-string */
t6=*((C_word*)lf[10]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=t3;
av2[2]=stub234(t4,t5);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}

/* k3055 in k3048 in chicken.tcp#tcp-addresses in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3057(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(13,c,3)))){
C_save_and_reclaim((void *)f_3057,c,av);}
a=C_alloc(13);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3060,a[2]=((C_word*)t2)[2],a[3]=((C_word*)t2)[3],a[4]=((C_word*)t2)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(t1)){
t4=t3;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t1;
f_3060(2,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3095,a[2]=t3,a[3]=((C_word*)t2)[3],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3099,a[2]=t4,a[3]=C_SCHEME_UNDEFINED,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t5;
av2[2]=lf[94];
av2[3]=lf[13];
tp(4,av2);}}}

/* k3058 in k3055 in k3048 in chicken.tcp#tcp-addresses in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3060(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,3)))){
C_save_and_reclaim((void *)f_3060,c,av);}
a=C_alloc(10);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3064,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
t3=C_a_i_bytevector(&a,1,C_fix(3));
t4=C_i_foreign_fixnum_argumentp(((C_word*)t0)[4]);
/* tcp.scm:217: ##sys#peek-c-string */
t5=*((C_word*)lf[10]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t2;
av2[2]=stub250(t3,t4);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k3062 in k3058 in k3055 in k3048 in chicken.tcp#tcp-addresses in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3064(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,c,3)))){
C_save_and_reclaim((void *)f_3064,c,av);}
a=C_alloc(12);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3067,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(t1)){
/* tcp.scm:674: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
C_values(4,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3074,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3078,a[2]=t3,a[3]=C_SCHEME_UNDEFINED,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t4;
av2[2]=lf[93];
av2[3]=lf[13];
tp(4,av2);}}}

/* k3065 in k3062 in k3058 in k3055 in k3048 in chicken.tcp#tcp-addresses in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3067(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_3067,c,av);}
/* tcp.scm:674: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
C_values(4,av2);}}

/* k3072 in k3062 in k3058 in k3055 in k3048 in chicken.tcp#tcp-addresses in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3074(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_3074,c,av);}
/* tcp.scm:678: ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[7];
av2[3]=lf[92];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k3076 in k3062 in k3058 in k3055 in k3048 in chicken.tcp#tcp-addresses in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3078(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_3078,c,av);}
a=C_alloc(8);
t2=C_mutate(((C_word *)t0)+3,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3082,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t4=stub114(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
/* tcp.scm:172: ##sys#peek-c-string */
t7=*((C_word*)lf[10]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=stub118(t5,t6);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k3080 in k3076 in k3062 in k3058 in k3055 in k3048 in chicken.tcp#tcp-addresses in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3082(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_3082,c,av);}
t2=((C_word*)t0)[2];
/* tcp.scm:678: scheme#string-append */
t3=*((C_word*)lf[9]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=((C_word*)t2)[2];
av2[2]=((C_word*)t2)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k3093 in k3055 in k3048 in chicken.tcp#tcp-addresses in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3095(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_3095,c,av);}
/* tcp.scm:676: ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[7];
av2[3]=lf[92];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k3097 in k3055 in k3048 in chicken.tcp#tcp-addresses in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3099(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_3099,c,av);}
a=C_alloc(8);
t2=C_mutate(((C_word *)t0)+3,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3103,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t4=stub114(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
/* tcp.scm:172: ##sys#peek-c-string */
t7=*((C_word*)lf[10]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=stub118(t5,t6);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k3101 in k3097 in k3055 in k3048 in chicken.tcp#tcp-addresses in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3103(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_3103,c,av);}
t2=((C_word*)t0)[2];
/* tcp.scm:676: scheme#string-append */
t3=*((C_word*)lf[9]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=((C_word*)t2)[2];
av2[2]=((C_word*)t2)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* chicken.tcp#tcp-port-numbers in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3111(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_3111,c,av);}
a=C_alloc(4);
t3=C_i_check_port_2(t2,C_fix(0),C_SCHEME_TRUE,lf[96]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3117,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* tcp.scm:682: tcp-port->fileno */
f_3026(t4,t2,lf[96]);}

/* k3115 in chicken.tcp#tcp-port-numbers in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3117(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(14,c,3)))){
C_save_and_reclaim((void *)f_3117,c,av);}
a=C_alloc(14);
t2=C_i_foreign_fixnum_argumentp(t1);
t3=stub240(C_SCHEME_UNDEFINED,t2);
t4=C_i_foreign_fixnum_argumentp(t1);
t5=stub245(C_SCHEME_UNDEFINED,t4);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3126,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=t5,a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
t7=C_eqp(C_fix(-1),t3);
if(C_truep(t7)){
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3166,a[2]=t6,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3170,a[2]=t8,a[3]=C_SCHEME_UNDEFINED,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t9;
av2[2]=lf[98];
av2[3]=lf[13];
tp(4,av2);}}
else{
t8=t6;{
C_word *av2=av;
av2[0]=t8;
av2[1]=C_SCHEME_UNDEFINED;
f_3126(2,av2);}}}

/* k3124 in k3115 in chicken.tcp#tcp-port-numbers in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3126(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(13,c,3)))){
C_save_and_reclaim((void *)f_3126,c,av);}
a=C_alloc(13);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3129,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
t3=C_eqp(C_fix(-1),((C_word*)t0)[4]);
if(C_truep(t3)){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3142,a[2]=t2,a[3]=((C_word*)t0)[5],tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3146,a[2]=t4,a[3]=C_SCHEME_UNDEFINED,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t5;
av2[2]=lf[97];
av2[3]=lf[13];
tp(4,av2);}}
else{
/* tcp.scm:689: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
C_values(4,av2);}}}

/* k3127 in k3124 in k3115 in chicken.tcp#tcp-port-numbers in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3129(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_3129,c,av);}
/* tcp.scm:689: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
C_values(4,av2);}}

/* k3140 in k3124 in k3115 in chicken.tcp#tcp-port-numbers in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3142(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_3142,c,av);}
/* tcp.scm:688: ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[7];
av2[3]=lf[96];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k3144 in k3124 in k3115 in chicken.tcp#tcp-port-numbers in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3146(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_3146,c,av);}
a=C_alloc(8);
t2=C_mutate(((C_word *)t0)+3,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3150,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t4=stub114(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
/* tcp.scm:172: ##sys#peek-c-string */
t7=*((C_word*)lf[10]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=stub118(t5,t6);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k3148 in k3144 in k3124 in k3115 in chicken.tcp#tcp-port-numbers in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3150(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_3150,c,av);}
t2=((C_word*)t0)[2];
/* tcp.scm:688: scheme#string-append */
t3=*((C_word*)lf[9]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=((C_word*)t2)[2];
av2[2]=((C_word*)t2)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k3164 in k3115 in chicken.tcp#tcp-port-numbers in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3166(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_3166,c,av);}
/* tcp.scm:686: ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[7];
av2[3]=lf[96];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}

/* k3168 in k3115 in chicken.tcp#tcp-port-numbers in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3170(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_3170,c,av);}
a=C_alloc(8);
t2=C_mutate(((C_word *)t0)+3,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3174,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t4=stub114(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
/* tcp.scm:172: ##sys#peek-c-string */
t7=*((C_word*)lf[10]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=stub118(t5,t6);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k3172 in k3168 in k3115 in chicken.tcp#tcp-port-numbers in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3174(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_3174,c,av);}
t2=((C_word*)t0)[2];
/* tcp.scm:686: scheme#string-append */
t3=*((C_word*)lf[9]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=((C_word*)t2)[2];
av2[2]=((C_word*)t2)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* chicken.tcp#tcp-listener-port in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3182(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(13,c,3)))){
C_save_and_reclaim((void *)f_3182,c,av);}
a=C_alloc(13);
t3=C_i_check_structure_2(t2,lf[5],lf[100]);
t4=C_slot(t2,C_fix(1));
t5=C_i_foreign_fixnum_argumentp(t4);
t6=stub240(C_SCHEME_UNDEFINED,t5);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3195,a[2]=t1,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
t8=C_eqp(C_fix(-1),t6);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3205,a[2]=t7,a[3]=t2,a[4]=t4,tmp=(C_word)a,a+=5,tmp);
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3209,a[2]=t9,a[3]=C_SCHEME_UNDEFINED,tmp=(C_word)a,a+=4,tmp);
/* ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[11]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[11]+1);
av2[1]=t10;
av2[2]=lf[101];
av2[3]=lf[13];
tp(4,av2);}}
else{
t9=t1;{
C_word *av2=av;
av2[0]=t9;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}}

/* k3193 in chicken.tcp#tcp-listener-port in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3195(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3195,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k3203 in chicken.tcp#tcp-listener-port in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3205(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_3205,c,av);}
/* tcp.scm:696: ##sys#signal-hook */
t2=*((C_word*)lf[6]+1);{
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[7];
av2[3]=lf[100];
av2[4]=t1;
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(7,av2);}}

/* k3207 in chicken.tcp#tcp-listener-port in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3209(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_3209,c,av);}
a=C_alloc(8);
t2=C_mutate(((C_word *)t0)+3,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3213,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t4=stub114(C_SCHEME_UNDEFINED);
t5=C_a_i_bytevector(&a,1,C_fix(3));
t6=C_i_foreign_fixnum_argumentp(t4);
/* tcp.scm:172: ##sys#peek-c-string */
t7=*((C_word*)lf[10]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=stub118(t5,t6);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k3211 in k3207 in chicken.tcp#tcp-listener-port in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3213(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_3213,c,av);}
t2=((C_word*)t0)[2];
/* tcp.scm:696: scheme#string-append */
t3=*((C_word*)lf[9]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=((C_word*)t2)[2];
av2[2]=((C_word*)t2)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* chicken.tcp#tcp-abandon-port in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3221(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_3221,c,av);}
a=C_alloc(4);
t3=C_i_check_port_2(t2,C_fix(0),C_SCHEME_TRUE,lf[103]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3231,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* tcp.scm:701: ##sys#port-data */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[90]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[90]+1);
av2[1]=t4;
av2[2]=t2;
tp(3,av2);}}

/* k3229 in chicken.tcp#tcp-abandon-port in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3231(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3231,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_i_set_i_slot(t1,C_slot(((C_word*)t0)[3],C_fix(1)),C_SCHEME_TRUE);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.tcp#tcp-listener-fileno in k1724 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3237(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3237,c,av);}
t3=C_i_check_structure_2(t2,lf[5],lf[105]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_slot(t2,C_fix(1));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k3246 in k1720 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3248(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_3248,c,av);}
/* tcp.scm:360: scheme#make-parameter */
t2=*((C_word*)lf[106]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=C_SCHEME_FALSE;
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k3250 in k1716 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3252(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_3252,c,av);}
/* tcp.scm:359: scheme#make-parameter */
t2=*((C_word*)lf[106]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=C_SCHEME_FALSE;
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k3254 in k1712 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3256(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_3256,c,av);}
/* tcp.scm:358: scheme#make-parameter */
t2=*((C_word*)lf[106]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)((C_word*)t0)[3])[1];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k3258 in k1689 in k1298 in k1070 in k1067 in k1064 */
static void C_ccall f_3260(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_3260,c,av);}
/* tcp.scm:357: scheme#make-parameter */
t2=*((C_word*)lf[106]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)((C_word*)t0)[3])[1];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* toplevel */
static int toplevel_initialized=0;

void C_ccall C_tcp_toplevel(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(toplevel_initialized) {C_kontinue(t1,C_SCHEME_UNDEFINED);}
else C_toplevel_entry(C_text("tcp"));
C_check_nursery_minimum(C_calculate_demand(3,c,2));
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void*)C_tcp_toplevel,c,av);}
toplevel_initialized=1;
if(C_unlikely(!C_demand_2(490))){
C_save(t1);
C_rereclaim2(490*sizeof(C_word),1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,112);
lf[0]=C_h_intern(&lf[0],3, C_text("tcp"));
lf[1]=C_h_intern(&lf[1],12, C_text("chicken.tcp#"));
lf[3]=C_h_intern(&lf[3],19, C_text("##sys#make-c-string"));
lf[4]=C_h_intern(&lf[4],22, C_text("chicken.tcp#tcp-listen"));
lf[5]=C_h_intern(&lf[5],12, C_text("tcp-listener"));
lf[6]=C_h_intern(&lf[6],17, C_text("##sys#signal-hook"));
lf[7]=C_h_intern_kw(&lf[7],13, C_text("network-error"));
lf[8]=C_h_intern(&lf[8],10, C_text("tcp-listen"));
lf[9]=C_h_intern(&lf[9],20, C_text("scheme#string-append"));
lf[10]=C_h_intern(&lf[10],19, C_text("##sys#peek-c-string"));
lf[11]=C_h_intern(&lf[11],19, C_text("##sys#string-append"));
lf[12]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\030\143\141\156\156\157\164\040\154\151\163\164\145\156\040\157\156\040\163\157\143\153\145\164\000"));
lf[13]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\004\040\055\040\000"));
lf[14]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\026\143\141\156\156\157\164\040\142\151\156\144\040\164\157\040\163\157\143\153\145\164\000"));
lf[15]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\036\145\162\162\157\162\040\167\150\151\154\145\040\163\145\164\164\151\156\147\040\165\160\040\163\157\143\153\145\164\000"));
lf[16]=C_h_intern(&lf[16],11, C_text("##sys#error"));
lf[17]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\025\143\141\156\156\157\164\040\143\162\145\141\164\145\040\163\157\143\153\145\164\000"));
lf[18]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\040\147\145\164\164\151\156\147\040\154\151\163\164\145\156\145\162\040\150\157\163\164\040\111\120\040\146\141\151\154\145\144\000"));
lf[19]=C_h_intern(&lf[19],17, C_text("##sys#make-string"));
lf[20]=C_h_intern_kw(&lf[20],12, C_text("domain-error"));
lf[21]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\024\151\156\166\141\154\151\144\040\160\157\162\164\040\156\165\155\142\145\162\000"));
lf[22]=C_h_intern(&lf[22],25, C_text("chicken.tcp#tcp-listener?"));
lf[23]=C_h_intern(&lf[23],21, C_text("chicken.tcp#tcp-close"));
lf[24]=C_h_intern(&lf[24],9, C_text("tcp-close"));
lf[25]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\030\143\141\156\156\157\164\040\143\154\157\163\145\040\124\103\120\040\163\157\143\153\145\164\000"));
lf[26]=C_h_intern(&lf[26],27, C_text("chicken.tcp#tcp-buffer-size"));
lf[27]=C_h_intern(&lf[27],28, C_text("chicken.tcp#tcp-read-timeout"));
lf[28]=C_h_intern(&lf[28],29, C_text("chicken.tcp#tcp-write-timeout"));
lf[29]=C_h_intern(&lf[29],31, C_text("chicken.tcp#tcp-connect-timeout"));
lf[30]=C_h_intern(&lf[30],30, C_text("chicken.tcp#tcp-accept-timeout"));
lf[32]=C_h_intern(&lf[32],20, C_text("##sys#current-thread"));
lf[33]=C_h_intern_kw(&lf[33],21, C_text("network-timeout-error"));
lf[34]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\031\162\145\141\144\040\157\160\145\162\141\164\151\157\156\040\164\151\155\145\144\040\157\165\164\000"));
lf[35]=C_h_intern(&lf[35],19, C_text("##sys#thread-yield!"));
lf[36]=C_h_intern(&lf[36],27, C_text("##sys#thread-block-for-i/o!"));
lf[37]=C_h_intern_kw(&lf[37],5, C_text("input"));
lf[38]=C_h_intern(&lf[38],31, C_text("##sys#thread-block-for-timeout!"));
lf[39]=C_h_intern(&lf[39],24, C_text("##sys#dispatch-interrupt"));
lf[40]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\030\143\141\156\156\157\164\040\162\145\141\144\040\146\162\157\155\040\163\157\143\153\145\164\000"));
lf[41]=C_h_intern(&lf[41],41, C_text("chicken.time#current-process-milliseconds"));
lf[42]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\032\167\162\151\164\145\040\157\160\145\162\141\164\151\157\156\040\164\151\155\145\144\040\157\165\164\000"));
lf[43]=C_h_intern_kw(&lf[43],6, C_text("output"));
lf[44]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\027\143\141\156\156\157\164\040\167\162\151\164\145\040\164\157\040\163\157\143\153\145\164\000"));
lf[45]=C_h_intern(&lf[45],19, C_text("##sys#encode-buffer"));
lf[46]=C_h_intern(&lf[46],21, C_text("##sys#make-bytevector"));
lf[47]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\040\143\141\156\156\157\164\040\143\154\157\163\145\040\163\157\143\153\145\164\040\157\165\164\160\165\164\040\160\157\162\164\000"));
lf[48]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\006\050\164\143\160\051\000"));
lf[49]=C_h_intern(&lf[49],6, C_text("socket"));
lf[50]=C_h_intern(&lf[50],20, C_text("##sys#set-port-data!"));
lf[51]=C_h_intern(&lf[51],15, C_text("##sys#make-port"));
lf[52]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\006\050\164\143\160\051\000"));
lf[53]=C_h_intern(&lf[53],19, C_text("##sys#decode-buffer"));
lf[54]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\036\143\141\156\156\157\164\040\143\150\145\143\153\040\163\157\143\153\145\164\040\146\157\162\040\151\156\160\165\164\000"));
lf[55]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\037\143\141\156\156\157\164\040\143\154\157\163\145\040\163\157\143\153\145\164\040\151\156\160\165\164\040\160\157\162\164\000"));
lf[56]=C_h_intern(&lf[56],35, C_text("chicken.fixnum#most-positive-fixnum"));
lf[57]=C_h_intern(&lf[57],22, C_text("##sys#scan-buffer-line"));
lf[58]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\001\000"));
lf[59]=C_h_intern(&lf[59],29, C_text("##sys#buffer->string/encoding"));
lf[60]=C_h_intern(&lf[60],28, C_text("chicken.port#make-input-port"));
lf[61]=C_h_intern_kw(&lf[61],9, C_text("peek-char"));
lf[62]=C_h_intern_kw(&lf[62],15, C_text("read-bytevector"));
lf[63]=C_h_intern_kw(&lf[63],9, C_text("read-line"));
lf[64]=C_h_intern_kw(&lf[64],13, C_text("read-buffered"));
lf[65]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\030\143\141\156\156\157\164\040\143\162\145\141\164\145\040\124\103\120\040\160\157\162\164\163\000"));
lf[66]=C_h_intern(&lf[66],22, C_text("chicken.tcp#tcp-accept"));
lf[67]=C_h_intern(&lf[67],5, C_text("utf-8"));
lf[68]=C_h_intern(&lf[68],10, C_text("tcp-accept"));
lf[69]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\037\143\157\165\154\144\040\156\157\164\040\141\143\143\145\160\164\040\146\162\157\155\040\154\151\163\164\145\156\145\162\000"));
lf[70]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\033\141\143\143\145\160\164\040\157\160\145\162\141\164\151\157\156\040\164\151\155\145\144\040\157\165\164\000"));
lf[71]=C_h_intern(&lf[71],29, C_text("chicken.tcp#tcp-accept-ready?"));
lf[72]=C_h_intern(&lf[72],17, C_text("tcp-accept-ready?"));
lf[73]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\036\143\141\156\156\157\164\040\143\150\145\143\153\040\163\157\143\153\145\164\040\146\157\162\040\151\156\160\165\164\000"));
lf[74]=C_h_intern(&lf[74],23, C_text("chicken.tcp#tcp-connect"));
lf[75]=C_h_intern(&lf[75],11, C_text("tcp-connect"));
lf[76]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\024\147\145\164\163\157\143\153\157\160\164\050\051\040\146\141\151\154\145\144\000"));
lf[77]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\025\143\141\156\156\157\164\040\143\162\145\141\164\145\040\163\157\143\153\145\164\000"));
lf[78]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\031\143\141\156\156\157\164\040\143\157\156\156\145\143\164\040\164\157\040\163\157\143\153\145\164\000"));
lf[79]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\017\146\143\156\164\154\050\051\040\146\141\151\154\145\144\000"));
lf[80]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\036\145\162\162\157\162\040\167\150\151\154\145\040\163\145\164\164\151\156\147\040\165\160\040\163\157\143\153\145\164\000"));
lf[81]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\025\143\141\156\156\157\164\040\143\162\145\141\164\145\040\163\157\143\153\145\164\000"));
lf[82]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\031\143\141\156\156\157\164\040\146\151\156\144\040\150\157\163\164\040\141\144\144\162\145\163\163\000"));
lf[83]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\022\156\157\040\160\157\162\164\040\163\160\145\143\151\146\151\145\144\000"));
lf[84]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\004\164\143\160\000"));
lf[85]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\041\143\141\156\156\157\164\040\143\157\155\160\165\164\145\040\160\157\162\164\040\146\162\157\155\040\163\145\162\166\151\143\145\000"));
lf[86]=C_h_intern(&lf[86],16, C_text("scheme#substring"));
lf[88]=C_h_intern(&lf[88],18, C_text("chicken.base#error"));
lf[89]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\052\141\162\147\165\155\145\156\164\040\144\157\145\163\040\156\157\164\040\141\160\160\145\141\162\040\164\157\040\142\145\040\141\040\124\103\120\040\160\157\162\164\000"));
lf[90]=C_h_intern(&lf[90],15, C_text("##sys#port-data"));
lf[91]=C_h_intern(&lf[91],25, C_text("chicken.tcp#tcp-addresses"));
lf[92]=C_h_intern(&lf[92],13, C_text("tcp-addresses"));
lf[93]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\036\143\141\156\156\157\164\040\143\157\155\160\165\164\145\040\162\145\155\157\164\145\040\141\144\144\162\145\163\163\000"));
lf[94]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\035\143\141\156\156\157\164\040\143\157\155\160\165\164\145\040\154\157\143\141\154\040\141\144\144\162\145\163\163\000"));
lf[95]=C_h_intern(&lf[95],28, C_text("chicken.tcp#tcp-port-numbers"));
lf[96]=C_h_intern(&lf[96],16, C_text("tcp-port-numbers"));
lf[97]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\033\143\141\156\156\157\164\040\143\157\155\160\165\164\145\040\162\145\155\157\164\145\040\160\157\162\164\000"));
lf[98]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\032\143\141\156\156\157\164\040\143\157\155\160\165\164\145\040\154\157\143\141\154\040\160\157\162\164\000"));
lf[99]=C_h_intern(&lf[99],29, C_text("chicken.tcp#tcp-listener-port"));
lf[100]=C_h_intern(&lf[100],17, C_text("tcp-listener-port"));
lf[101]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\034\143\141\156\156\157\164\040\157\142\164\141\151\156\040\154\151\163\164\145\156\145\162\040\160\157\162\164\000"));
lf[102]=C_h_intern(&lf[102],28, C_text("chicken.tcp#tcp-abandon-port"));
lf[103]=C_h_intern(&lf[103],16, C_text("tcp-abandon-port"));
lf[104]=C_h_intern(&lf[104],31, C_text("chicken.tcp#tcp-listener-fileno"));
lf[105]=C_h_intern(&lf[105],19, C_text("tcp-listener-fileno"));
lf[106]=C_h_intern(&lf[106],21, C_text("scheme#make-parameter"));
lf[107]=C_h_intern(&lf[107],18, C_text("tcp-accept-timeout"));
lf[108]=C_h_intern(&lf[108],19, C_text("tcp-connect-timeout"));
lf[109]=C_h_intern(&lf[109],17, C_text("tcp-write-timeout"));
lf[110]=C_h_intern(&lf[110],16, C_text("tcp-read-timeout"));
lf[111]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\032\143\141\156\156\157\164\040\151\156\151\164\151\141\154\151\172\145\040\127\151\156\163\157\143\153\000"));
C_register_lf2(lf,112,create_ptable());{}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_1066,a[2]=t1,tmp=(C_word)a,a+=3,tmp);{
C_word *av2=av;
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t2;
C_port_toplevel(2,av2);}}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[223] = {
{C_text("f3610:tcp_2escm"),(void*)f3610},
{C_text("f_1066:tcp_2escm"),(void*)f_1066},
{C_text("f_1069:tcp_2escm"),(void*)f_1069},
{C_text("f_1072:tcp_2escm"),(void*)f_1072},
{C_text("f_1300:tcp_2escm"),(void*)f_1300},
{C_text("f_1307:tcp_2escm"),(void*)f_1307},
{C_text("f_1311:tcp_2escm"),(void*)f_1311},
{C_text("f_1327:tcp_2escm"),(void*)f_1327},
{C_text("f_1336:tcp_2escm"),(void*)f_1336},
{C_text("f_1359:tcp_2escm"),(void*)f_1359},
{C_text("f_1384:tcp_2escm"),(void*)f_1384},
{C_text("f_1388:tcp_2escm"),(void*)f_1388},
{C_text("f_1391:tcp_2escm"),(void*)f_1391},
{C_text("f_1394:tcp_2escm"),(void*)f_1394},
{C_text("f_1404:tcp_2escm"),(void*)f_1404},
{C_text("f_1408:tcp_2escm"),(void*)f_1408},
{C_text("f_1412:tcp_2escm"),(void*)f_1412},
{C_text("f_1447:tcp_2escm"),(void*)f_1447},
{C_text("f_1450:tcp_2escm"),(void*)f_1450},
{C_text("f_1456:tcp_2escm"),(void*)f_1456},
{C_text("f_1459:tcp_2escm"),(void*)f_1459},
{C_text("f_1462:tcp_2escm"),(void*)f_1462},
{C_text("f_1478:tcp_2escm"),(void*)f_1478},
{C_text("f_1482:tcp_2escm"),(void*)f_1482},
{C_text("f_1486:tcp_2escm"),(void*)f_1486},
{C_text("f_1502:tcp_2escm"),(void*)f_1502},
{C_text("f_1506:tcp_2escm"),(void*)f_1506},
{C_text("f_1510:tcp_2escm"),(void*)f_1510},
{C_text("f_1532:tcp_2escm"),(void*)f_1532},
{C_text("f_1541:tcp_2escm"),(void*)f_1541},
{C_text("f_1560:tcp_2escm"),(void*)f_1560},
{C_text("f_1566:tcp_2escm"),(void*)f_1566},
{C_text("f_1569:tcp_2escm"),(void*)f_1569},
{C_text("f_1588:tcp_2escm"),(void*)f_1588},
{C_text("f_1592:tcp_2escm"),(void*)f_1592},
{C_text("f_1596:tcp_2escm"),(void*)f_1596},
{C_text("f_1640:tcp_2escm"),(void*)f_1640},
{C_text("f_1649:tcp_2escm"),(void*)f_1649},
{C_text("f_1669:tcp_2escm"),(void*)f_1669},
{C_text("f_1673:tcp_2escm"),(void*)f_1673},
{C_text("f_1677:tcp_2escm"),(void*)f_1677},
{C_text("f_1691:tcp_2escm"),(void*)f_1691},
{C_text("f_1697:tcp_2escm"),(void*)f_1697},
{C_text("f_1699:tcp_2escm"),(void*)f_1699},
{C_text("f_1714:tcp_2escm"),(void*)f_1714},
{C_text("f_1718:tcp_2escm"),(void*)f_1718},
{C_text("f_1722:tcp_2escm"),(void*)f_1722},
{C_text("f_1726:tcp_2escm"),(void*)f_1726},
{C_text("f_1728:tcp_2escm"),(void*)f_1728},
{C_text("f_1732:tcp_2escm"),(void*)f_1732},
{C_text("f_1735:tcp_2escm"),(void*)f_1735},
{C_text("f_1741:tcp_2escm"),(void*)f_1741},
{C_text("f_1744:tcp_2escm"),(void*)f_1744},
{C_text("f_1745:tcp_2escm"),(void*)f_1745},
{C_text("f_1749:tcp_2escm"),(void*)f_1749},
{C_text("f_1752:tcp_2escm"),(void*)f_1752},
{C_text("f_1757:tcp_2escm"),(void*)f_1757},
{C_text("f_1776:tcp_2escm"),(void*)f_1776},
{C_text("f_1779:tcp_2escm"),(void*)f_1779},
{C_text("f_1782:tcp_2escm"),(void*)f_1782},
{C_text("f_1785:tcp_2escm"),(void*)f_1785},
{C_text("f_1813:tcp_2escm"),(void*)f_1813},
{C_text("f_1817:tcp_2escm"),(void*)f_1817},
{C_text("f_1821:tcp_2escm"),(void*)f_1821},
{C_text("f_1839:tcp_2escm"),(void*)f_1839},
{C_text("f_1842:tcp_2escm"),(void*)f_1842},
{C_text("f_1843:tcp_2escm"),(void*)f_1843},
{C_text("f_1847:tcp_2escm"),(void*)f_1847},
{C_text("f_1856:tcp_2escm"),(void*)f_1856},
{C_text("f_1864:tcp_2escm"),(void*)f_1864},
{C_text("f_1866:tcp_2escm"),(void*)f_1866},
{C_text("f_1888:tcp_2escm"),(void*)f_1888},
{C_text("f_1891:tcp_2escm"),(void*)f_1891},
{C_text("f_1894:tcp_2escm"),(void*)f_1894},
{C_text("f_1897:tcp_2escm"),(void*)f_1897},
{C_text("f_1920:tcp_2escm"),(void*)f_1920},
{C_text("f_1931:tcp_2escm"),(void*)f_1931},
{C_text("f_1935:tcp_2escm"),(void*)f_1935},
{C_text("f_1939:tcp_2escm"),(void*)f_1939},
{C_text("f_1979:tcp_2escm"),(void*)f_1979},
{C_text("f_1986:tcp_2escm"),(void*)f_1986},
{C_text("f_1987:tcp_2escm"),(void*)f_1987},
{C_text("f_1993:tcp_2escm"),(void*)f_1993},
{C_text("f_2015:tcp_2escm"),(void*)f_2015},
{C_text("f_2037:tcp_2escm"),(void*)f_2037},
{C_text("f_2046:tcp_2escm"),(void*)f_2046},
{C_text("f_2049:tcp_2escm"),(void*)f_2049},
{C_text("f_2062:tcp_2escm"),(void*)f_2062},
{C_text("f_2066:tcp_2escm"),(void*)f_2066},
{C_text("f_2077:tcp_2escm"),(void*)f_2077},
{C_text("f_2098:tcp_2escm"),(void*)f_2098},
{C_text("f_2106:tcp_2escm"),(void*)f_2106},
{C_text("f_2109:tcp_2escm"),(void*)f_2109},
{C_text("f_2115:tcp_2escm"),(void*)f_2115},
{C_text("f_2122:tcp_2escm"),(void*)f_2122},
{C_text("f_2126:tcp_2escm"),(void*)f_2126},
{C_text("f_2130:tcp_2escm"),(void*)f_2130},
{C_text("f_2155:tcp_2escm"),(void*)f_2155},
{C_text("f_2161:tcp_2escm"),(void*)f_2161},
{C_text("f_2171:tcp_2escm"),(void*)f_2171},
{C_text("f_2177:tcp_2escm"),(void*)f_2177},
{C_text("f_2181:tcp_2escm"),(void*)f_2181},
{C_text("f_2196:tcp_2escm"),(void*)f_2196},
{C_text("f_2209:tcp_2escm"),(void*)f_2209},
{C_text("f_2222:tcp_2escm"),(void*)f_2222},
{C_text("f_2235:tcp_2escm"),(void*)f_2235},
{C_text("f_2239:tcp_2escm"),(void*)f_2239},
{C_text("f_2243:tcp_2escm"),(void*)f_2243},
{C_text("f_2251:tcp_2escm"),(void*)f_2251},
{C_text("f_2259:tcp_2escm"),(void*)f_2259},
{C_text("f_2265:tcp_2escm"),(void*)f_2265},
{C_text("f_2272:tcp_2escm"),(void*)f_2272},
{C_text("f_2276:tcp_2escm"),(void*)f_2276},
{C_text("f_2280:tcp_2escm"),(void*)f_2280},
{C_text("f_2301:tcp_2escm"),(void*)f_2301},
{C_text("f_2305:tcp_2escm"),(void*)f_2305},
{C_text("f_2320:tcp_2escm"),(void*)f_2320},
{C_text("f_2329:tcp_2escm"),(void*)f_2329},
{C_text("f_2335:tcp_2escm"),(void*)f_2335},
{C_text("f_2379:tcp_2escm"),(void*)f_2379},
{C_text("f_2390:tcp_2escm"),(void*)f_2390},
{C_text("f_2394:tcp_2escm"),(void*)f_2394},
{C_text("f_2408:tcp_2escm"),(void*)f_2408},
{C_text("f_2418:tcp_2escm"),(void*)f_2418},
{C_text("f_2434:tcp_2escm"),(void*)f_2434},
{C_text("f_2468:tcp_2escm"),(void*)f_2468},
{C_text("f_2513:tcp_2escm"),(void*)f_2513},
{C_text("f_2523:tcp_2escm"),(void*)f_2523},
{C_text("f_2550:tcp_2escm"),(void*)f_2550},
{C_text("f_2554:tcp_2escm"),(void*)f_2554},
{C_text("f_2558:tcp_2escm"),(void*)f_2558},
{C_text("f_2562:tcp_2escm"),(void*)f_2562},
{C_text("f_2575:tcp_2escm"),(void*)f_2575},
{C_text("f_2578:tcp_2escm"),(void*)f_2578},
{C_text("f_2583:tcp_2escm"),(void*)f_2583},
{C_text("f_2587:tcp_2escm"),(void*)f_2587},
{C_text("f_2590:tcp_2escm"),(void*)f_2590},
{C_text("f_2593:tcp_2escm"),(void*)f_2593},
{C_text("f_2596:tcp_2escm"),(void*)f_2596},
{C_text("f_2624:tcp_2escm"),(void*)f_2624},
{C_text("f_2628:tcp_2escm"),(void*)f_2628},
{C_text("f_2632:tcp_2escm"),(void*)f_2632},
{C_text("f_2658:tcp_2escm"),(void*)f_2658},
{C_text("f_2666:tcp_2escm"),(void*)f_2666},
{C_text("f_2676:tcp_2escm"),(void*)f_2676},
{C_text("f_2689:tcp_2escm"),(void*)f_2689},
{C_text("f_2693:tcp_2escm"),(void*)f_2693},
{C_text("f_2697:tcp_2escm"),(void*)f_2697},
{C_text("f_2716:tcp_2escm"),(void*)f_2716},
{C_text("f_2732:tcp_2escm"),(void*)f_2732},
{C_text("f_2735:tcp_2escm"),(void*)f_2735},
{C_text("f_2738:tcp_2escm"),(void*)f_2738},
{C_text("f_2744:tcp_2escm"),(void*)f_2744},
{C_text("f_2750:tcp_2escm"),(void*)f_2750},
{C_text("f_2756:tcp_2escm"),(void*)f_2756},
{C_text("f_2759:tcp_2escm"),(void*)f_2759},
{C_text("f_2762:tcp_2escm"),(void*)f_2762},
{C_text("f_2765:tcp_2escm"),(void*)f_2765},
{C_text("f_2771:tcp_2escm"),(void*)f_2771},
{C_text("f_2790:tcp_2escm"),(void*)f_2790},
{C_text("f_2794:tcp_2escm"),(void*)f_2794},
{C_text("f_2798:tcp_2escm"),(void*)f_2798},
{C_text("f_2816:tcp_2escm"),(void*)f_2816},
{C_text("f_2820:tcp_2escm"),(void*)f_2820},
{C_text("f_2824:tcp_2escm"),(void*)f_2824},
{C_text("f_2828:tcp_2escm"),(void*)f_2828},
{C_text("f_2844:tcp_2escm"),(void*)f_2844},
{C_text("f_2847:tcp_2escm"),(void*)f_2847},
{C_text("f_2875:tcp_2escm"),(void*)f_2875},
{C_text("f_2879:tcp_2escm"),(void*)f_2879},
{C_text("f_2883:tcp_2escm"),(void*)f_2883},
{C_text("f_2902:tcp_2escm"),(void*)f_2902},
{C_text("f_2906:tcp_2escm"),(void*)f_2906},
{C_text("f_2910:tcp_2escm"),(void*)f_2910},
{C_text("f_2928:tcp_2escm"),(void*)f_2928},
{C_text("f_2932:tcp_2escm"),(void*)f_2932},
{C_text("f_2936:tcp_2escm"),(void*)f_2936},
{C_text("f_2952:tcp_2escm"),(void*)f_2952},
{C_text("f_2956:tcp_2escm"),(void*)f_2956},
{C_text("f_2960:tcp_2escm"),(void*)f_2960},
{C_text("f_2969:tcp_2escm"),(void*)f_2969},
{C_text("f_2975:tcp_2escm"),(void*)f_2975},
{C_text("f_2983:tcp_2escm"),(void*)f_2983},
{C_text("f_2989:tcp_2escm"),(void*)f_2989},
{C_text("f_3000:tcp_2escm"),(void*)f_3000},
{C_text("f_3026:tcp_2escm"),(void*)f_3026},
{C_text("f_3030:tcp_2escm"),(void*)f_3030},
{C_text("f_3044:tcp_2escm"),(void*)f_3044},
{C_text("f_3050:tcp_2escm"),(void*)f_3050},
{C_text("f_3057:tcp_2escm"),(void*)f_3057},
{C_text("f_3060:tcp_2escm"),(void*)f_3060},
{C_text("f_3064:tcp_2escm"),(void*)f_3064},
{C_text("f_3067:tcp_2escm"),(void*)f_3067},
{C_text("f_3074:tcp_2escm"),(void*)f_3074},
{C_text("f_3078:tcp_2escm"),(void*)f_3078},
{C_text("f_3082:tcp_2escm"),(void*)f_3082},
{C_text("f_3095:tcp_2escm"),(void*)f_3095},
{C_text("f_3099:tcp_2escm"),(void*)f_3099},
{C_text("f_3103:tcp_2escm"),(void*)f_3103},
{C_text("f_3111:tcp_2escm"),(void*)f_3111},
{C_text("f_3117:tcp_2escm"),(void*)f_3117},
{C_text("f_3126:tcp_2escm"),(void*)f_3126},
{C_text("f_3129:tcp_2escm"),(void*)f_3129},
{C_text("f_3142:tcp_2escm"),(void*)f_3142},
{C_text("f_3146:tcp_2escm"),(void*)f_3146},
{C_text("f_3150:tcp_2escm"),(void*)f_3150},
{C_text("f_3166:tcp_2escm"),(void*)f_3166},
{C_text("f_3170:tcp_2escm"),(void*)f_3170},
{C_text("f_3174:tcp_2escm"),(void*)f_3174},
{C_text("f_3182:tcp_2escm"),(void*)f_3182},
{C_text("f_3195:tcp_2escm"),(void*)f_3195},
{C_text("f_3205:tcp_2escm"),(void*)f_3205},
{C_text("f_3209:tcp_2escm"),(void*)f_3209},
{C_text("f_3213:tcp_2escm"),(void*)f_3213},
{C_text("f_3221:tcp_2escm"),(void*)f_3221},
{C_text("f_3231:tcp_2escm"),(void*)f_3231},
{C_text("f_3237:tcp_2escm"),(void*)f_3237},
{C_text("f_3248:tcp_2escm"),(void*)f_3248},
{C_text("f_3252:tcp_2escm"),(void*)f_3252},
{C_text("f_3256:tcp_2escm"),(void*)f_3256},
{C_text("f_3260:tcp_2escm"),(void*)f_3260},
{C_text("toplevel:tcp_2escm"),(void*)C_tcp_toplevel},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}

/*
o|hiding unexported module binding: chicken.tcp#d 
o|hiding unexported module binding: chicken.tcp#define-alias 
o|hiding unexported module binding: chicken.tcp#last-error-code 
o|hiding unexported module binding: chicken.tcp#error-code->message 
o|hiding unexported module binding: chicken.tcp#retry? 
o|hiding unexported module binding: chicken.tcp#in-progress? 
o|hiding unexported module binding: chicken.tcp#interrupted? 
o|hiding unexported module binding: chicken.tcp#socket 
o|hiding unexported module binding: chicken.tcp#bind 
o|hiding unexported module binding: chicken.tcp#listen 
o|hiding unexported module binding: chicken.tcp#accept 
o|hiding unexported module binding: chicken.tcp#close 
o|hiding unexported module binding: chicken.tcp#recv 
o|hiding unexported module binding: chicken.tcp#shutdown 
o|hiding unexported module binding: chicken.tcp#connect 
o|hiding unexported module binding: chicken.tcp#check-fd-ready 
o|hiding unexported module binding: chicken.tcp#set-socket-options 
o|hiding unexported module binding: chicken.tcp#send 
o|hiding unexported module binding: chicken.tcp#getsockname 
o|hiding unexported module binding: chicken.tcp#getsockport 
o|hiding unexported module binding: chicken.tcp#getpeerport 
o|hiding unexported module binding: chicken.tcp#getpeername 
o|hiding unexported module binding: chicken.tcp#startup 
o|hiding unexported module binding: chicken.tcp#getservbyname 
o|hiding unexported module binding: chicken.tcp#gethostaddr 
o|hiding unexported module binding: chicken.tcp#network-error 
o|hiding unexported module binding: chicken.tcp#network-error/close 
o|hiding unexported module binding: chicken.tcp#network-error/code 
o|hiding unexported module binding: chicken.tcp#parse-host 
o|hiding unexported module binding: chicken.tcp#fresh-addr 
o|hiding unexported module binding: chicken.tcp#bind-socket 
o|hiding unexported module binding: chicken.tcp#io-ports 
o|hiding unexported module binding: chicken.tcp#get-socket-error 
o|hiding unexported module binding: chicken.tcp#tcp-port->fileno 
o|eliminated procedure checks: 69 
o|specializations:
o|  3 (##sys#check-open-port * *)
o|  2 (scheme#make-string fixnum)
o|  24 (scheme#string-append string string)
o|  1 (scheme#char=? char char)
(o e)|safe calls: 364 
(o e)|assignments to immediate values: 10 
o|safe globals: (chicken.tcp#startup chicken.tcp#getpeername chicken.tcp#getpeerport chicken.tcp#getsockport chicken.tcp#getsockname chicken.tcp#send chicken.tcp#set-socket-options chicken.tcp#check-fd-ready chicken.tcp#connect chicken.tcp#shutdown chicken.tcp#recv chicken.tcp#close chicken.tcp#accept chicken.tcp#listen chicken.tcp#bind chicken.tcp#socket chicken.tcp#interrupted? chicken.tcp#in-progress? chicken.tcp#retry? chicken.tcp#error-code->message chicken.tcp#last-error-code) 
o|inlining procedure: k1361 
o|inlining procedure: k1361 
o|substituted constant variable: a1377 
o|inlining procedure: k1392 
o|inlining procedure: "(tcp.scm:291) chicken.tcp#last-error-code" 
o|substituted constant variable: a1417 
o|substituted constant variable: a1418 
o|inlining procedure: k1392 
o|contracted procedure: "(tcp.scm:289) chicken.tcp#getservbyname" 
o|inlining procedure: k1309 
o|inlining procedure: k1309 
o|inlining procedure: k1567 
o|substituted constant variable: a1597 
o|substituted constant variable: a1598 
o|inlining procedure: "(tcp.scm:330) chicken.tcp#close" 
o|inlining procedure: "(tcp.scm:330) chicken.tcp#last-error-code" 
o|inlining procedure: k1567 
o|contracted procedure: "(tcp.scm:329) chicken.tcp#listen" 
o|contracted procedure: "(tcp.scm:328) chicken.tcp#bind-socket" 
o|inlining procedure: k1460 
o|substituted constant variable: a1487 
o|substituted constant variable: a1488 
o|inlining procedure: "(tcp.scm:318) chicken.tcp#close" 
o|inlining procedure: "(tcp.scm:318) chicken.tcp#last-error-code" 
o|inlining procedure: k1460 
o|contracted procedure: "(tcp.scm:317) chicken.tcp#bind" 
o|inlining procedure: "(tcp.scm:316) chicken.tcp#last-error-code" 
o|substituted constant variable: a1515 
o|substituted constant variable: a1516 
o|inlining procedure: "(tcp.scm:315) chicken.tcp#set-socket-options" 
o|inlining procedure: k1527 
o|inlining procedure: k1527 
o|contracted procedure: "(tcp.scm:310) chicken.tcp#fresh-addr" 
o|inlining procedure: k1642 
o|inlining procedure: k1642 
o|inlining procedure: k1657 
o|inlining procedure: "(tcp.scm:341) chicken.tcp#last-error-code" 
o|substituted constant variable: a1682 
o|substituted constant variable: a1683 
o|inlining procedure: k1657 
o|inlining procedure: "(tcp.scm:340) chicken.tcp#close" 
o|inlining procedure: k1701 
o|inlining procedure: k1701 
o|inlining procedure: k1762 
o|inlining procedure: k1783 
o|inlining procedure: k1783 
o|inlining procedure: k1798 
o|inlining procedure: k1798 
o|inlining procedure: "(tcp.scm:398) chicken.tcp#last-error-code" 
o|substituted constant variable: a1826 
o|substituted constant variable: a1827 
o|inlining procedure: "(tcp.scm:395) chicken.tcp#interrupted?" 
o|inlining procedure: "(tcp.scm:384) chicken.tcp#retry?" 
o|inlining procedure: k1762 
o|contracted procedure: "(tcp.scm:382) chicken.tcp#recv" 
o|inlining procedure: k1874 
o|inlining procedure: k1910 
o|inlining procedure: k1910 
o|inlining procedure: "(tcp.scm:521) chicken.tcp#last-error-code" 
o|substituted constant variable: a1944 
o|substituted constant variable: a1945 
o|inlining procedure: "(tcp.scm:517) chicken.tcp#interrupted?" 
o|inlining procedure: "(tcp.scm:508) chicken.tcp#retry?" 
o|inlining procedure: k1874 
o|inlining procedure: k1964 
o|inlining procedure: k1964 
o|contracted procedure: "(tcp.scm:506) chicken.tcp#send" 
o|inlining procedure: k1995 
o|inlining procedure: k1995 
o|inlining procedure: k2067 
o|inlining procedure: k2067 
o|inlining procedure: k2082 
o|inlining procedure: k2082 
o|inlining procedure: k2100 
o|inlining procedure: k2100 
o|inlining procedure: "(tcp.scm:568) chicken.tcp#last-error-code" 
o|substituted constant variable: a2135 
o|substituted constant variable: a2136 
o|inlining procedure: "(tcp.scm:567) chicken.tcp#close" 
o|inlining procedure: k2163 
o|inlining procedure: k2163 
o|inlining procedure: k2182 
o|inlining procedure: k2182 
o|inlining procedure: k2214 
o|inlining procedure: k2214 
o|inlining procedure: "(tcp.scm:421) chicken.tcp#last-error-code" 
o|substituted constant variable: a2248 
o|substituted constant variable: a2249 
o|inlining procedure: "(tcp.scm:419) chicken.tcp#check-fd-ready" 
o|inlining procedure: k2253 
o|inlining procedure: k2253 
o|inlining procedure: "(tcp.scm:428) chicken.tcp#last-error-code" 
o|substituted constant variable: a2285 
o|substituted constant variable: a2286 
o|inlining procedure: "(tcp.scm:427) chicken.tcp#close" 
o|inlining procedure: k2306 
o|inlining procedure: k2306 
o|inlining procedure: k2337 
o|inlining procedure: k2337 
o|inlining procedure: k2380 
o|inlining procedure: k2380 
o|inlining procedure: k2395 
o|inlining procedure: k2395 
o|inlining procedure: k2423 
o|inlining procedure: k2423 
o|inlining procedure: k2470 
o|inlining procedure: k2470 
o|inlining procedure: k2515 
o|inlining procedure: k2515 
o|inlining procedure: k2529 
o|inlining procedure: k2529 
o|substituted constant variable: a2559 
o|substituted constant variable: a2560 
o|inlining procedure: "(tcp.scm:366) chicken.tcp#close" 
o|inlining procedure: "(tcp.scm:366) chicken.tcp#last-error-code" 
o|inlining procedure: k2600 
o|inlining procedure: k2600 
o|inlining procedure: "(tcp.scm:609) chicken.tcp#last-error-code" 
o|substituted constant variable: a2637 
o|substituted constant variable: a2638 
o|inlining procedure: "(tcp.scm:606) chicken.tcp#interrupted?" 
o|contracted procedure: "(tcp.scm:603) chicken.tcp#accept" 
o|inlining procedure: k1152 
o|inlining procedure: k1152 
o|inlining procedure: k2674 
o|inlining procedure: "(tcp.scm:616) chicken.tcp#last-error-code" 
o|substituted constant variable: a2702 
o|substituted constant variable: a2703 
o|inlining procedure: k2674 
o|inlining procedure: "(tcp.scm:614) chicken.tcp#check-fd-ready" 
o|substituted constant variable: a2799 
o|substituted constant variable: a2800 
o|inlining procedure: "(tcp.scm:659) chicken.tcp#close" 
o|inlining procedure: "(tcp.scm:659) chicken.tcp#last-error-code" 
o|inlining procedure: k2801 
o|substituted constant variable: a2825 
o|substituted constant variable: a2826 
o|inlining procedure: "(tcp.scm:661) chicken.tcp#close" 
o|inlining procedure: k2801 
o|contracted procedure: "(tcp.scm:657) chicken.tcp#get-socket-error" 
o|inlining procedure: k2830 
o|inlining procedure: k2854 
o|inlining procedure: k2854 
o|substituted constant variable: a2884 
o|substituted constant variable: a2885 
o|inlining procedure: "(tcp.scm:655) chicken.tcp#close" 
o|inlining procedure: "(tcp.scm:655) chicken.tcp#last-error-code" 
o|inlining procedure: "(tcp.scm:652) chicken.tcp#interrupted?" 
o|contracted procedure: "(tcp.scm:647) chicken.tcp#in-progress?" 
o|inlining procedure: k2830 
o|contracted procedure: "(tcp.scm:646) chicken.tcp#connect" 
o|substituted constant variable: a2911 
o|substituted constant variable: a2912 
o|inlining procedure: "(tcp.scm:644) chicken.tcp#close" 
o|inlining procedure: "(tcp.scm:644) chicken.tcp#last-error-code" 
o|substituted constant variable: a2937 
o|substituted constant variable: a2938 
o|inlining procedure: "(tcp.scm:642) chicken.tcp#close" 
o|inlining procedure: "(tcp.scm:642) chicken.tcp#last-error-code" 
o|inlining procedure: "(tcp.scm:641) chicken.tcp#set-socket-options" 
o|inlining procedure: "(tcp.scm:640) chicken.tcp#last-error-code" 
o|substituted constant variable: a2965 
o|substituted constant variable: a2966 
o|inlining procedure: k2976 
o|inlining procedure: k2976 
o|inlining procedure: k3031 
o|inlining procedure: k3031 
o|substituted constant variable: a3047 
o|inlining procedure: k3065 
o|inlining procedure: k3065 
o|inlining procedure: "(tcp.scm:678) chicken.tcp#last-error-code" 
o|substituted constant variable: a3087 
o|substituted constant variable: a3088 
o|contracted procedure: "(tcp.scm:677) chicken.tcp#getpeername" 
o|inlining procedure: "(tcp.scm:676) chicken.tcp#last-error-code" 
o|substituted constant variable: a3108 
o|substituted constant variable: a3109 
o|contracted procedure: "(tcp.scm:675) chicken.tcp#getsockname" 
o|substituted constant variable: a3114 
o|inlining procedure: k3127 
o|inlining procedure: "(tcp.scm:688) chicken.tcp#last-error-code" 
o|substituted constant variable: a3155 
o|substituted constant variable: a3156 
o|inlining procedure: k3127 
o|inlining procedure: "(tcp.scm:686) chicken.tcp#last-error-code" 
o|substituted constant variable: a3179 
o|substituted constant variable: a3180 
o|contracted procedure: "(tcp.scm:684) chicken.tcp#getpeerport" 
o|inlining procedure: "(tcp.scm:683) chicken.tcp#getsockport" 
o|inlining procedure: k3193 
o|inlining procedure: "(tcp.scm:696) chicken.tcp#last-error-code" 
o|substituted constant variable: a3218 
o|substituted constant variable: a3219 
o|inlining procedure: k3193 
o|inlining procedure: "(tcp.scm:694) chicken.tcp#getsockport" 
o|substituted constant variable: a3224 
o|contracted procedure: "(tcp.scm:237) chicken.tcp#startup" 
o|replaced variables: 595 
o|removed binding forms: 154 
o|removed side-effect free assignment to unused variable: chicken.tcp#last-error-code 
o|removed side-effect free assignment to unused variable: chicken.tcp#retry? 
o|removed side-effect free assignment to unused variable: chicken.tcp#interrupted? 
o|removed side-effect free assignment to unused variable: chicken.tcp#close 
o|removed side-effect free assignment to unused variable: chicken.tcp#check-fd-ready 
o|removed side-effect free assignment to unused variable: chicken.tcp#set-socket-options 
o|removed side-effect free assignment to unused variable: chicken.tcp#getsockport 
o|substituted constant variable: r16433318 
o|substituted constant variable: int180187 
o|substituted constant variable: int179186 
o|inlining procedure: k1964 
o|substituted constant variable: flags222230 
o|substituted constant variable: r21833377 
o|inlining procedure: k2220 
o|substituted constant variable: r23073397 
o|substituted constant variable: r23963403 
o|substituted constant variable: r25163415 
o|substituted constant variable: r25303418 
o|substituted constant variable: c-pointer161168 
o|substituted constant variable: c-pointer161168 
o|substituted constant variable: r11533432 
o|substituted constant variable: r11533432 
o|substituted constant variable: c-pointer160167 
o|substituted constant variable: c-pointer160167 
o|inlining procedure: k2769 
o|contracted procedure: "(tcp.scm:633) chicken.tcp#parse-host" 
o|substituted constant variable: r13103278 
o|substituted constant variable: r13103278 
o|replaced variables: 148 
o|removed binding forms: 504 
o|removed conditional forms: 2 
o|inlining procedure: k1600 
o|inlining procedure: k1490 
o|inlining procedure: k1512 
o|inlining procedure: k1518 
o|inlining procedure: k1606 
o|inlining procedure: k1679 
o|inlining procedure: k1685 
o|inlining procedure: k1823 
o|inlining procedure: k1895 
o|inlining procedure: k1941 
o|substituted constant variable: r19653544 
o|inlining procedure: k2132 
o|inlining procedure: k2141 
o|inlining procedure: k2245 
o|inlining procedure: k2282 
o|inlining procedure: k2291 
o|inlining procedure: k2634 
o|contracted procedure: k1148 
o|inlining procedure: k2699 
o|inlining procedure: k2842 
o|inlining procedure: k2887 
o|inlining procedure: k2940 
o|inlining procedure: k2962 
o|inlining procedure: k1414 
o|inlining procedure: k3084 
o|inlining procedure: k3105 
o|inlining procedure: k3152 
o|inlining procedure: k3176 
o|inlining procedure: k3215 
o|inlining procedure: k3261 
o|replaced variables: 1 
o|removed binding forms: 171 
o|contracted procedure: k1576 
o|contracted procedure: k1579 
o|contracted procedure: k1466 
o|contracted procedure: k1469 
o|contracted procedure: k1759 
o|contracted procedure: k1771 
o|contracted procedure: k1801 
o|contracted procedure: k1871 
o|contracted procedure: k1883 
o|contracted procedure: k1913 
o|contracted procedure: k2217 
o|contracted procedure: k2538 
o|contracted procedure: k2541 
o|contracted procedure: k2597 
o|substituted constant variable: r1149 
o|contracted procedure: k2612 
o|contracted procedure: k2671 
o|contracted procedure: k2766 
o|contracted procedure: k2778 
o|contracted procedure: k2781 
o|contracted procedure: k2807 
o|contracted procedure: k2839 
o|contracted procedure: k2857 
o|contracted procedure: k2863 
o|contracted procedure: k2866 
o|contracted procedure: k2890 
o|contracted procedure: k2893 
o|contracted procedure: k2916 
o|contracted procedure: k2919 
o|contracted procedure: k3118 
o|contracted procedure: k3121 
o|contracted procedure: k3190 
o|simplifications: ((let . 8)) 
o|replaced variables: 1 
o|removed binding forms: 61 
o|removed binding forms: 2 
o|simplifications: ((if . 18) (##core#call . 213) (let . 27)) 
o|  call simplifications:
o|    chicken.fixnum#fx*
o|    scheme#vector?
o|    ##sys#check-string
o|    scheme#string-ref
o|    scheme#not
o|    ##sys#call-with-values	2
o|    scheme#string-length	2
o|    chicken.fixnum#fx>=	9
o|    scheme#vector	2
o|    ##sys#setslot	4
o|    scheme#values	11
o|    chicken.fixnum#fxmin	3
o|    chicken.fixnum#fx-	9
o|    chicken.fixnum#fx+	14
o|    chicken.fixnum#fx=
o|    scheme#+	5
o|    ##sys#setislot	5
o|    ##sys#check-structure	5
o|    ##sys#slot	19
o|    ##sys#structure?
o|    scheme#car	5
o|    scheme#null?	9
o|    scheme#cdr	4
o|    chicken.fixnum#fx<	6
o|    chicken.fixnum#fx>	7
o|    ##sys#check-fixnum	4
o|    scheme#eq?	27
o|    ##sys#make-structure	2
o|    ##sys#foreign-block-argument	6
o|    ##sys#foreign-string-argument	3
o|    ##sys#foreign-unsigned-ranged-integer-argument	2
o|    ##sys#foreign-fixnum-argument	41
o|contracted procedure: k1084 
o|contracted procedure: k1100 
o|contracted procedure: k1104 
o|contracted procedure: k1108 
o|contracted procedure: k1194 
o|contracted procedure: k1198 
o|contracted procedure: k1330 
o|contracted procedure: k1338 
o|contracted procedure: k1346 
o|contracted procedure: k1633 
o|contracted procedure: k1543 
o|contracted procedure: k1627 
o|contracted procedure: k1546 
o|contracted procedure: k1621 
o|contracted procedure: k1549 
o|contracted procedure: k1615 
o|contracted procedure: k1552 
o|contracted procedure: k1555 
o|contracted procedure: k1561 
o|contracted procedure: k1133 
o|contracted procedure: k1137 
o|contracted procedure: k1573 
o|contracted procedure: k11653290 
o|contracted procedure: k1115 
o|contracted procedure: k1119 
o|contracted procedure: k1123 
o|contracted procedure: k1463 
o|contracted procedure: k11653304 
o|contracted procedure: k12303314 
o|contracted procedure: k1493 
o|contracted procedure: k1521 
o|contracted procedure: k1434 
o|contracted procedure: k1438 
o|contracted procedure: k1603 
o|contracted procedure: k1606 
o|contracted procedure: k1651 
o|contracted procedure: k1654 
o|contracted procedure: k11653327 
o|contracted procedure: k1660 
o|contracted procedure: k1701 
o|contracted procedure: k1708 
o|contracted procedure: k1736 
o|contracted procedure: k1172 
o|contracted procedure: k1176 
o|contracted procedure: k1180 
o|contracted procedure: k1184 
o|contracted procedure: k1765 
o|contracted procedure: k1789 
o|contracted procedure: k1829 
o|contracted procedure: k1852 
o|contracted procedure: k1868 
o|contracted procedure: k1237 
o|contracted procedure: k1241 
o|contracted procedure: k1245 
o|contracted procedure: k1249 
o|contracted procedure: k1253 
o|contracted procedure: k1877 
o|contracted procedure: k1901 
o|contracted procedure: k1949 
o|contracted procedure: k1956 
o|contracted procedure: k1960 
o|contracted procedure: k1967 
o|contracted procedure: k1964 
o|contracted procedure: k1998 
o|contracted procedure: k2001 
o|contracted procedure: k2007 
o|contracted procedure: k2010 
o|contracted procedure: k2021 
o|contracted procedure: k2025 
o|contracted procedure: k2029 
o|contracted procedure: k2079 
o|contracted procedure: k2085 
o|contracted procedure: k11653374 
o|contracted procedure: k2144 
o|contracted procedure: k2150 
o|contracted procedure: k2166 
o|contracted procedure: k2032 
o|contracted procedure: k2038 
o|contracted procedure: k2041 
o|contracted procedure: k2052 
o|contracted procedure: k2055 
o|contracted procedure: k2185 
o|contracted procedure: k2192 
o|contracted procedure: k2199 
o|contracted procedure: k2202 
o|contracted procedure: k2211 
o|contracted procedure: k12233387 
o|contracted procedure: k2226 
o|contracted procedure: k11653396 
o|contracted procedure: k2294 
o|contracted procedure: k2309 
o|contracted procedure: k2316 
o|contracted procedure: k2322 
o|contracted procedure: k2340 
o|contracted procedure: k2346 
o|contracted procedure: k2349 
o|contracted procedure: k2374 
o|contracted procedure: k2352 
o|contracted procedure: k2356 
o|contracted procedure: k2363 
o|contracted procedure: k2367 
o|contracted procedure: k2371 
o|contracted procedure: k2383 
o|contracted procedure: k2398 
o|contracted procedure: k2401 
o|contracted procedure: k2464 
o|contracted procedure: k2414 
o|contracted procedure: k2420 
o|contracted procedure: k2426 
o|contracted procedure: k2436 
o|contracted procedure: k2442 
o|contracted procedure: k2453 
o|contracted procedure: k2449 
o|contracted procedure: k2460 
o|contracted procedure: k2485 
o|contracted procedure: k2481 
o|contracted procedure: k2474 
o|inlining procedure: k2470 
o|contracted procedure: k2496 
o|contracted procedure: k2500 
o|contracted procedure: k2492 
o|inlining procedure: k2470 
o|contracted procedure: k2506 
o|contracted procedure: k2518 
o|contracted procedure: k2526 
o|contracted procedure: k2532 
o|contracted procedure: k11653424 
o|contracted procedure: k2659 
o|contracted procedure: k2564 
o|contracted procedure: k2567 
o|contracted procedure: k2570 
o|contracted procedure: k1144 
o|contracted procedure: k2640 
o|contracted procedure: k2603 
o|contracted procedure: k2643 
o|contracted procedure: k2668 
o|contracted procedure: k2705 
o|contracted procedure: k12233450 
o|contracted procedure: k2680 
o|contracted procedure: k3019 
o|contracted procedure: k2718 
o|contracted procedure: k3013 
o|contracted procedure: k2721 
o|contracted procedure: k3007 
o|contracted procedure: k2724 
o|contracted procedure: k3001 
o|contracted procedure: k2727 
o|contracted procedure: k2739 
o|contracted procedure: k2745 
o|contracted procedure: k2712 
o|contracted procedure: k2775 
o|contracted procedure: k11653456 
o|contracted procedure: k2804 
o|contracted procedure: k11653464 
o|contracted procedure: k1205 
o|contracted procedure: k1209 
o|contracted procedure: k1213 
o|contracted procedure: k2833 
o|contracted procedure: k11653474 
o|contracted procedure: k11653483 
o|contracted procedure: k12303497 
o|contracted procedure: k2913 
o|contracted procedure: k11653490 
o|contracted procedure: k2943 
o|contracted procedure: k1352 
o|contracted procedure: k1364 
o|contracted procedure: k1370 
o|contracted procedure: k1395 
o|contracted procedure: k1316 
o|contracted procedure: k1323 
o|contracted procedure: k1420 
o|contracted procedure: k1427 
o|contracted procedure: k3034 
o|contracted procedure: k1292 
o|contracted procedure: k1267 
o|contracted procedure: k12743526 
o|contracted procedure: k1281 
o|contracted procedure: k3133 
o|contracted procedure: k3157 
o|contracted procedure: k3184 
o|contracted procedure: k3187 
o|contracted procedure: k12743537 
o|contracted procedure: k3196 
o|contracted procedure: k3233 
o|contracted procedure: k3239 
o|simplifications: ((let . 45)) 
o|removed binding forms: 183 
o|inlining procedure: k1334 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest436438 0 
(o x)|known list op on rest arg sublist: ##core#rest-car rest436438 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest436438 0 
(o x)|known list op on rest arg sublist: ##core#rest-cdr rest436438 0 
o|inlining procedure: "(tcp.scm:330) chicken.tcp#error-code->message" 
o|inlining procedure: "(tcp.scm:318) chicken.tcp#error-code->message" 
o|inlining procedure: "(tcp.scm:316) chicken.tcp#error-code->message" 
o|inlining procedure: "(tcp.scm:311) chicken.tcp#socket" 
o|inlining procedure: "(tcp.scm:341) chicken.tcp#error-code->message" 
o|inlining procedure: "(tcp.scm:398) chicken.tcp#error-code->message" 
o|inlining procedure: "(tcp.scm:521) chicken.tcp#error-code->message" 
o|inlining procedure: "(tcp.scm:568) chicken.tcp#error-code->message" 
o|inlining procedure: "(tcp.scm:566) chicken.tcp#shutdown" 
o|inlining procedure: "(tcp.scm:421) chicken.tcp#error-code->message" 
o|inlining procedure: "(tcp.scm:428) chicken.tcp#error-code->message" 
o|inlining procedure: "(tcp.scm:426) chicken.tcp#shutdown" 
o|inlining procedure: "(tcp.scm:366) chicken.tcp#error-code->message" 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest704706 0 
(o x)|known list op on rest arg sublist: ##core#rest-car rest704706 0 
o|inlining procedure: "(tcp.scm:609) chicken.tcp#error-code->message" 
o|inlining procedure: "(tcp.scm:616) chicken.tcp#error-code->message" 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest750752 0 
(o x)|known list op on rest arg sublist: ##core#rest-car rest750752 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest750752 0 
(o x)|known list op on rest arg sublist: ##core#rest-cdr rest750752 0 
o|inlining procedure: "(tcp.scm:659) chicken.tcp#error-code->message" 
o|inlining procedure: "(tcp.scm:662) chicken.tcp#error-code->message" 
o|inlining procedure: "(tcp.scm:655) chicken.tcp#error-code->message" 
o|inlining procedure: "(tcp.scm:644) chicken.tcp#error-code->message" 
o|inlining procedure: "(tcp.scm:642) chicken.tcp#error-code->message" 
o|inlining procedure: "(tcp.scm:640) chicken.tcp#error-code->message" 
o|inlining procedure: "(tcp.scm:638) chicken.tcp#socket" 
o|inlining procedure: "(tcp.scm:291) chicken.tcp#error-code->message" 
o|inlining procedure: "(tcp.scm:678) chicken.tcp#error-code->message" 
o|inlining procedure: "(tcp.scm:676) chicken.tcp#error-code->message" 
o|inlining procedure: "(tcp.scm:688) chicken.tcp#error-code->message" 
o|inlining procedure: "(tcp.scm:686) chicken.tcp#error-code->message" 
o|inlining procedure: "(tcp.scm:696) chicken.tcp#error-code->message" 
o|removed binding forms: 1 
o|removed side-effect free assignment to unused variable: chicken.tcp#error-code->message 
o|removed side-effect free assignment to unused variable: chicken.tcp#socket 
o|removed side-effect free assignment to unused variable: chicken.tcp#shutdown 
o|substituted constant variable: r13353700 
(o x)|known list op on rest arg sublist: ##core#rest-null? r1547 1 
(o x)|known list op on rest arg sublist: ##core#rest-car r1547 1 
(o x)|known list op on rest arg sublist: ##core#rest-null? r1547 1 
(o x)|known list op on rest arg sublist: ##core#rest-cdr r1547 1 
o|substituted constant variable: int1341393717 
(o x)|known list op on rest arg sublist: ##core#rest-null? r2722 1 
(o x)|known list op on rest arg sublist: ##core#rest-car r2722 1 
(o x)|known list op on rest arg sublist: ##core#rest-null? r2722 1 
(o x)|known list op on rest arg sublist: ##core#rest-cdr r2722 1 
o|substituted constant variable: int1341393799 
o|replaced variables: 39 
o|removed binding forms: 49 
o|contracted procedure: k1451 
o|contracted procedure: k2751 
o|removed binding forms: 2 
o|customizable procedures: (check482 chicken.tcp#tcp-port->fileno k2733 loop390 k1389 k2576 chicken.tcp#io-ports loop572 k2257 k2263 read-input516 k2104 k2107 k2113 add-to-buf648 output-to-socket611 loop651 k1862 loop618 k1750 chicken.tcp#gethostaddr k1564) 
o|shared closure containers: 31 
o|shared closure users: 35 
o|calls to known targets: 90 
o|unused rest argument: rest436438 f_1541 
o|identified direct recursive calls: f_1866 2 
o|identified direct recursive calls: f_2335 1 
o|unused rest argument: rest704706 f_2562 
o|identified direct recursive calls: f_1359 1 
o|unused rest argument: rest750752 f_2716 
o|fast box initializations: 8 
o|fast global references: 7 
o|fast global assignments: 3 
o|dropping unused closure argument: f_1327 
o|dropping unused closure argument: f_1697 
o|dropping unused closure argument: f_3026 
*/
/* end of file */
