/* Generated from library.scm by the CHICKEN compiler
   http://www.call-cc.org
   Version 6.0.0 (rev e4e9ea4d)
   linux-unix-gnu-x86-64 [ 64bit dload ptables ]
   command line: library.scm -optimize-level 2 -include-path . -include-path ./ -inline -ignore-repository -feature chicken-bootstrap -no-warnings -specialize -consult-types-file ./types.db -explicit-use -no-trace -output-file library.c -no-module-registration -emit-import-library chicken.bitwise -emit-import-library chicken.bytevector -emit-import-library chicken.fixnum -emit-import-library chicken.flonum -emit-import-library chicken.gc -emit-import-library chicken.keyword -emit-import-library chicken.platform -emit-import-library chicken.plist -emit-import-library chicken.io -emit-import-library chicken.process-context
   unit: library
   uses: build-version library
*/
#include "chicken.h"

#include <errno.h>
#include <float.h>

#ifdef HAVE_SYSEXITS_H
# include <sysexits.h>
#endif

#ifndef EX_SOFTWARE
# define EX_SOFTWARE	70
#endif

#define C_close_file(p)	      (C_fclose((C_FILEPTR)(C_port_file(p))), C_SCHEME_UNDEFINED)
#define C_a_f64peek(ptr, c, b, i)  C_flonum(ptr, ((double *)C_data_pointer(b))[ C_unfix(i) ])
#define C_fetch_c_strlen(b, i) C_fix(strlen((C_char *)C_block_item(b, C_unfix(i))))
#define C_asciiz_strlen(str) C_fix(strlen(C_c_string(str)))
#define C_peek_c_string(b, i, to, len) (C_memcpy(C_data_pointer(to), (C_char *)C_block_item(b, C_unfix(i)), C_unfix(len)), C_SCHEME_UNDEFINED)
#define C_free_mptr(p, i)     (C_free((void *)C_block_item(p, C_unfix(i))), C_SCHEME_UNDEFINED)
#define C_free_sptr(p, i)     (C_free((void *)(((C_char **)C_block_item(p, 0))[ C_unfix(i) ])), C_SCHEME_UNDEFINED)

#define C_a_get_current_seconds(ptr, c, dummy)  C_int64_to_num(ptr, time(NULL))
#define C_peek_c_string_at(ptr, i)    ((C_char *)(((C_char **)ptr)[ i ]))

#define C_utf_bytes_needed(b)  C_fix(C_utf_expect(C_unfix(b)))

static C_word
fast_read_line_from_file(C_word str, C_word port, C_word size) {
  int n = C_unfix(size);
  int i;
  int c;
  char *buf = C_c_string(str);
  C_FILEPTR fp = C_port_file(port);

  if ((c = C_getc(fp)) == EOF) {
    if (ferror(fp)) {
      clearerr(fp);
      return C_fix(-1);
    } else { /* feof (fp) */
      return C_SCHEME_END_OF_FILE;
    }
  }

  C_ungetc(c, fp);

  for (i = 0; i < n; i++) {
    c = C_getc(fp);

    if(c == EOF && ferror(fp)) {
      clearerr(fp);
      return C_fix(-(i + 1));
    }

    switch (c) {
    case '\r':	if ((c = C_getc(fp)) != '\n') C_ungetc(c, fp);
    case EOF:	clearerr(fp);
    case '\n':	return C_fix(i);
    }
    buf[i] = c;
  }
  return C_SCHEME_FALSE;
}

static C_word
fast_read_string_from_file(C_word dest, C_word port, C_word len, C_word pos)
{
  size_t m;
  int n = C_unfix (len);
  C_char * buf = C_c_string(dest) + C_unfix(pos);
  C_FILEPTR fp = C_port_file (port);

  if(feof(fp)) return C_SCHEME_END_OF_FILE;

  m = fread (buf, sizeof (char), n, fp);

  if (m < n) {
    if (ferror(fp)) /* Report to Scheme, which may retry, so clear errors */
      clearerr(fp);
    else if (feof(fp) && 0 == m) /* eof but m > 0? Return data first, below */
      return C_SCHEME_END_OF_FILE; /* Calling again will get us here */
  }

  return C_fix (m);
}

static C_word
shallow_equal(C_word x, C_word y)
{
  /* assumes x and y are non-immediate */
  int i, len = C_header_size(x);

  if(C_header_size(y) != len) return C_SCHEME_FALSE;
  else return C_mk_bool(!C_memcmp((void *)x, (void *)y, len * sizeof(C_word)));
}

static C_word
signal_debug_event(C_word mode, C_word msg, C_word args)
{
  C_DEBUG_INFO cell;
  C_word av[ 3 ];
  cell.enabled = 1;
  cell.event = C_DEBUG_SIGNAL;
  cell.loc = "";
  cell.val = "";
  av[ 0 ] = mode;
  av[ 1 ] = msg;
  av[ 2 ] = args;
  C_debugger(&cell, 3, av);
  return C_SCHEME_UNDEFINED;
}

static C_word C_i_sleep_until_interrupt(C_word secs)
{
   while(C_i_process_sleep(secs) == C_fix(-1) && errno == EINTR);
   return C_SCHEME_UNDEFINED;
}

#ifdef NO_DLOAD2
# define HAVE_DLOAD 0
#else
# define HAVE_DLOAD 1
#endif

#ifdef C_ENABLE_PTABLES
# define HAVE_PTABLES 1
#else
# define HAVE_PTABLES 0
#endif

#ifdef C_GC_HOOKS
# define HAVE_GCHOOKS 1
#else
# define HAVE_GCHOOKS 0
#endif

#if defined(C_CROSS_CHICKEN) && C_CROSS_CHICKEN
# define IS_CROSS_CHICKEN 1
#else
# define IS_CROSS_CHICKEN 0
#endif

#if defined(_WIN32) && !defined(__CYGWIN__)
#include <direct.h>

static C_word C_chdir(C_word str) {
	return C_fix(_wchdir(C_utf16(str, 0)));
}

static C_word C_curdir(C_word buf, C_word size) {
	C_WCHAR *cwd = _wgetcwd((C_WCHAR *)C_c_string(buf), C_unfix(size));
        if(cwd == NULL) return C_SCHEME_FALSE;
	C_char *up = C_utf8(cwd);
	C_char *p = up;
	while(*p) {
		*p = *p == '\\' ? '/' : *p;
		++p;
	}
	int len = C_strlen(up);
	C_memcpy(cwd, up, len + 1);
        return C_fix(len);
}
#else
# define C_chdir(str) C_fix(chdir(C_c_string(str)))
# define C_curdir(buf, size) (getcwd(C_c_string(buf), size) ? C_fix(strlen(C_c_string(buf))) : C_SCHEME_FALSE)
#endif



static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_build_2dversion_toplevel)
C_extern void C_ccall C_build_2dversion_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(C_library_toplevel)
C_extern void C_ccall C_library_toplevel(C_word c,C_word *av) C_noret;

static C_word lf[1631];
static double C_possibly_force_alignment;
static C_char li0[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,110,111,116,32,120,41,0,0};
static C_char li1[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,98,111,111,108,101,97,110,63,32,120,41,0,0,0,0,0};
static C_char li2[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,101,113,63,32,120,32,121,41};
static C_char li3[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,101,113,118,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char li4[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,101,113,117,97,108,63,32,120,32,121,41,0,0,0,0,0};
static C_char li5[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,102,41};
static C_char li6[] C_aligned={C_lihdr(0,0,29),40,115,99,104,101,109,101,35,98,111,111,108,101,97,110,61,63,32,120,32,121,32,46,32,109,111,114,101,41,0,0,0};
static C_char li7[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,102,41};
static C_char li8[] C_aligned={C_lihdr(0,0,28),40,115,99,104,101,109,101,35,115,121,109,98,111,108,61,63,32,120,32,121,32,46,32,109,111,114,101,41,0,0,0,0};
static C_char li9[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,112,97,105,114,63,32,120,41};
static C_char li10[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,111,110,115,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char li11[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,99,97,114,32,120,41,0,0};
static C_char li12[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,99,100,114,32,120,41,0,0};
static C_char li13[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,115,101,116,45,99,97,114,33,32,120,32,121,41,0,0,0};
static C_char li14[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,115,101,116,45,99,100,114,33,32,120,32,121,41,0,0,0};
static C_char li15[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,99,97,100,114,32,120,41,0};
static C_char li16[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,97,100,100,114,32,120,41};
static C_char li17[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,100,100,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char li18[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,100,100,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char li19[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,99,97,97,114,32,120,41,0};
static C_char li20[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,99,100,97,114,32,120,41,0};
static C_char li21[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,99,100,100,114,32,120,41,0};
static C_char li22[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,97,97,97,114,32,120,41};
static C_char li23[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,97,97,100,114,32,120,41};
static C_char li24[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,97,100,97,114,32,120,41};
static C_char li25[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,100,97,97,114,32,120,41};
static C_char li26[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,100,97,100,114,32,120,41};
static C_char li27[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,100,100,97,114,32,120,41};
static C_char li28[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,100,100,100,114,32,120,41};
static C_char li29[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,97,97,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char li30[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,97,97,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char li31[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,97,100,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char li32[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,97,100,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char li33[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,100,97,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char li34[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,100,97,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char li35[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,97,100,100,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char li36[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,97,97,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char li37[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,97,97,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char li38[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,97,100,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char li39[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,97,100,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char li40[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,100,97,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char li41[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,100,97,100,114,32,120,41,0,0,0,0,0,0,0};
static C_char li42[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,99,100,100,100,97,114,32,120,41,0,0,0,0,0,0,0};
static C_char li43[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,110,117,108,108,63,32,120,41};
static C_char li44[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,108,105,115,116,32,46,32,108,115,116,41,0,0,0,0,0};
static C_char li45[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,108,101,110,103,116,104,32,108,115,116,41,0,0,0,0,0};
static C_char li46[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,108,105,115,116,45,116,97,105,108,32,108,115,116,32,105,41};
static C_char li47[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,108,105,115,116,45,114,101,102,32,108,115,116,32,105,41,0};
static C_char li48[] C_aligned={C_lihdr(0,0,15),40,108,111,111,112,32,108,115,116,32,114,101,115,116,41,0};
static C_char li49[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,114,101,118,101,114,115,101,32,108,115,116,48,41,0,0,0};
static C_char li50[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,109,101,109,113,32,120,32,108,115,116,41,0,0,0,0,0};
static C_char li51[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,109,101,109,118,32,120,32,108,115,116,41,0,0,0,0,0};
static C_char li52[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char li53[] C_aligned={C_lihdr(0,0,28),40,115,99,104,101,109,101,35,109,101,109,98,101,114,32,120,32,108,115,116,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char li54[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,97,115,115,113,32,120,32,108,115,116,41,0,0,0,0,0};
static C_char li55[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,97,115,115,118,32,120,32,108,115,116,41,0,0,0,0,0};
static C_char li56[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char li57[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,97,115,115,111,99,32,120,32,108,115,116,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li58[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,108,105,115,116,63,32,120,41};
static C_char li59[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,115,116,114,105,110,103,63,32,120,41,0,0,0,0,0,0};
static C_char li60[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,108,101,110,103,116,104,32,115,41};
static C_char li61[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,114,101,102,32,115,32,105,41,0};
static C_char li62[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,115,101,116,33,32,115,32,105,32,99,41,0,0,0,0,0,0};
static C_char li63[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,115,115,32,102,41,0,0,0,0,0};
static C_char li64[] C_aligned={C_lihdr(0,0,28),40,115,99,104,101,109,101,35,115,116,114,105,110,103,61,63,32,120,32,121,32,46,32,109,111,114,101,41,0,0,0,0};
static C_char li65[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,115,115,32,102,41,0,0,0,0,0};
static C_char li66[] C_aligned={C_lihdr(0,0,31),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,105,61,63,32,120,32,121,32,46,32,109,111,114,101,41,0};
static C_char li67[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,101,120,97,99,116,45,62,105,110,101,120,97,99,116,32,120,41,0,0,0,0,0,0,0};
static C_char li68[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,97,98,115,32,120,41,0,0};
static C_char li69[] C_aligned={C_lihdr(0,0,6),67,95,112,108,117,115,0,0};
static C_char li70[] C_aligned={C_lihdr(0,0,7),67,95,109,105,110,117,115,0};
static C_char li71[] C_aligned={C_lihdr(0,0,7),67,95,116,105,109,101,115,0};
static C_char li72[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,113,117,111,116,105,101,110,116,32,97,32,98,41,0,0,0};
static C_char li73[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,114,101,109,97,105,110,100,101,114,32,97,32,98,41,0,0};
static C_char li74[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,109,111,100,117,108,111,32,97,32,98,41,0,0,0,0,0};
static C_char li75[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,101,118,101,110,63,32,110,41};
static C_char li76[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,111,100,100,63,32,110,41,0};
static C_char li77[] C_aligned={C_lihdr(0,0,9),67,95,110,101,113,117,97,108,112,0,0,0,0,0,0,0};
static C_char li78[] C_aligned={C_lihdr(0,0,10),67,95,103,114,101,97,116,101,114,112,0,0,0,0,0,0};
static C_char li79[] C_aligned={C_lihdr(0,0,7),67,95,108,101,115,115,112,0};
static C_char li80[] C_aligned={C_lihdr(0,0,20),67,95,103,114,101,97,116,101,114,95,111,114,95,101,113,117,97,108,95,112,0,0,0,0};
static C_char li81[] C_aligned={C_lihdr(0,0,17),67,95,108,101,115,115,95,111,114,95,101,113,117,97,108,95,112,0,0,0,0,0,0,0};
static C_char li82[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,110,117,109,98,101,114,63,32,120,41,0,0,0,0,0,0};
static C_char li83[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,114,101,97,108,63,32,120,41};
static C_char li84[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,114,97,116,105,111,110,97,108,63,32,110,41,0,0,0,0};
static C_char li85[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,105,110,116,101,103,101,114,63,32,120,41,0,0,0,0,0};
static C_char li86[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,101,120,97,99,116,63,32,120,41,0,0,0,0,0,0,0};
static C_char li87[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,105,110,101,120,97,99,116,63,32,120,41,0,0,0,0,0};
static C_char li88[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,122,101,114,111,63,32,110,41};
static C_char li89[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,112,111,115,105,116,105,118,101,63,32,110,41,0,0,0,0};
static C_char li90[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,110,101,103,97,116,105,118,101,63,32,110,41,0,0,0,0};
static C_char li91[] C_aligned={C_lihdr(0,0,18),67,95,110,117,109,98,101,114,95,116,111,95,115,116,114,105,110,103,0,0,0,0,0,0};
static C_char li92[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,115,121,109,98,111,108,63,32,120,41,0,0,0,0,0,0};
static C_char li93[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,118,101,99,116,111,114,63,32,120,41,0,0,0,0,0,0};
static C_char li94[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,108,101,110,103,116,104,32,118,41};
static C_char li95[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,114,101,102,32,118,32,105,41,0};
static C_char li96[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,115,101,116,33,32,118,32,105,32,120,41,0,0,0,0,0,0};
static C_char li97[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,99,104,97,114,63,32,120,41};
static C_char li98[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,99,104,97,114,45,62,105,110,116,101,103,101,114,32,99,41};
static C_char li99[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,105,110,116,101,103,101,114,45,62,99,104,97,114,32,110,41};
static C_char li100[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,99,115,32,102,41,0,0,0,0,0};
static C_char li101[] C_aligned={C_lihdr(0,0,28),40,115,99,104,101,109,101,35,99,104,97,114,61,63,32,99,49,32,99,50,32,46,32,109,111,114,101,41,0,0,0,0};
static C_char li102[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,99,115,32,102,41,0,0,0,0,0};
static C_char li103[] C_aligned={C_lihdr(0,0,28),40,115,99,104,101,109,101,35,99,104,97,114,62,63,32,99,49,32,99,50,32,46,32,109,111,114,101,41,0,0,0,0};
static C_char li104[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,99,115,32,102,41,0,0,0,0,0};
static C_char li105[] C_aligned={C_lihdr(0,0,28),40,115,99,104,101,109,101,35,99,104,97,114,60,63,32,99,49,32,99,50,32,46,32,109,111,114,101,41,0,0,0,0};
static C_char li106[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,99,115,32,102,41,0,0,0,0,0};
static C_char li107[] C_aligned={C_lihdr(0,0,29),40,115,99,104,101,109,101,35,99,104,97,114,62,61,63,32,99,49,32,99,50,32,46,32,109,111,114,101,41,0,0,0};
static C_char li108[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,99,115,32,102,41,0,0,0,0,0};
static C_char li109[] C_aligned={C_lihdr(0,0,29),40,115,99,104,101,109,101,35,99,104,97,114,60,61,63,32,99,49,32,99,50,32,46,32,109,111,114,101,41,0,0,0};
static C_char li110[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,99,104,97,114,45,117,112,99,97,115,101,32,99,41,0,0};
static C_char li111[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,99,104,97,114,45,100,111,119,110,99,97,115,101,32,99,41};
static C_char li112[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,99,104,97,114,45,117,112,112,101,114,45,99,97,115,101,63,32,99,41,0,0,0,0,0};
static C_char li113[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,99,104,97,114,45,108,111,119,101,114,45,99,97,115,101,63,32,99,41,0,0,0,0,0};
static C_char li114[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,99,104,97,114,45,110,117,109,101,114,105,99,63,32,99,41};
static C_char li115[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,99,104,97,114,45,119,104,105,116,101,115,112,97,99,101,63,32,99,41,0,0,0,0,0};
static C_char li116[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,99,104,97,114,45,97,108,112,104,97,98,101,116,105,99,63,32,99,41,0,0,0,0,0};
static C_char li117[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,46,99,104,97,114,35,100,105,103,105,116,45,118,97,108,117,101,32,99,41,0,0,0,0,0};
static C_char li118[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,112,114,111,99,101,100,117,114,101,63,32,120,41,0,0,0};
static C_char li119[] C_aligned={C_lihdr(0,0,7),67,95,97,112,112,108,121,0};
static C_char li120[] C_aligned={C_lihdr(0,0,8),67,95,118,97,108,117,101,115};
static C_char li121[] C_aligned={C_lihdr(0,0,18),67,95,99,97,108,108,95,119,105,116,104,95,118,97,108,117,101,115,0,0,0,0,0,0};
static C_char li122[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,105,110,112,117,116,45,112,111,114,116,63,32,120,41,0,0};
static C_char li123[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,111,117,116,112,117,116,45,112,111,114,116,63,32,120,41,0};
static C_char li124[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,98,105,110,97,114,121,45,112,111,114,116,63,32,112,111,114,116,41,0,0,0,0,0,0};
static C_char li125[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,116,101,120,116,117,97,108,45,112,111,114,116,63,32,112,111,114,116,41,0,0,0,0,0};
static C_char li126[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,112,111,114,116,63,32,120,41};
static C_char li127[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,105,110,112,117,116,45,112,111,114,116,45,111,112,101,110,63,32,112,41,0,0,0,0,0};
static C_char li128[] C_aligned={C_lihdr(0,0,28),40,115,99,104,101,109,101,35,111,117,116,112,117,116,45,112,111,114,116,45,111,112,101,110,63,32,112,41,0,0,0,0};
static C_char li129[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,101,111,102,45,111,98,106,101,99,116,63,32,120,41,0,0};
static C_char li130[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,101,118,97,108,32,120,32,46,32,101,110,118,41,0,0,0};
static C_char li131[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,105,110,116,101,114,97,99,116,105,111,110,45,101,110,118,105,114,111,110,109,101,110,116,41};
static C_char li132[] C_aligned={C_lihdr(0,0,36),40,115,99,104,101,109,101,35,115,99,104,101,109,101,45,114,101,112,111,114,116,45,101,110,118,105,114,111,110,109,101,110,116,32,110,41,0,0,0,0};
static C_char li133[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,110,117,108,108,45,101,110,118,105,114,111,110,109,101,110,116,41,0,0,0,0,0,0,0};
static C_char li134[] C_aligned={C_lihdr(0,0,34),40,115,99,104,101,109,101,35,108,111,97,100,32,102,105,108,101,110,97,109,101,32,46,32,101,118,97,108,117,97,116,111,114,41,0,0,0,0,0,0};
static C_char li135[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,105,120,110,117,109,63,32,120,41};
static C_char li136[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,108,111,110,117,109,63,32,120,41};
static C_char li137[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,98,105,103,110,117,109,63,32,120,41};
static C_char li138[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,114,97,116,110,117,109,63,32,120,41};
static C_char li139[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,112,108,120,110,117,109,63,32,120,41,0,0,0,0,0,0,0};
static C_char li140[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,120,97,99,116,45,105,110,116,101,103,101,114,63,32,120,41,0};
static C_char li141[] C_aligned={C_lihdr(0,0,24),67,95,113,117,111,116,105,101,110,116,95,97,110,100,95,114,101,109,97,105,110,100,101,114};
static C_char li142[] C_aligned={C_lihdr(0,0,8),40,97,49,50,53,56,53,41};
static C_char li143[] C_aligned={C_lihdr(0,0,16),40,97,49,50,53,57,49,32,100,105,118,32,114,101,109,41};
static C_char li144[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,97,115,101,35,113,117,111,116,105,101,110,116,38,109,111,100,117,108,111,32,120,32,121,41,0,0,0,0,0,0};
static C_char li145[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,105,110,105,116,101,63,32,120,41};
static C_char li146[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,98,97,115,101,35,105,110,102,105,110,105,116,101,63,32,120,41,0,0,0,0,0,0};
static C_char li147[] C_aligned={C_lihdr(0,0,21),40,99,104,105,99,107,101,110,46,98,97,115,101,35,110,97,110,63,32,120,41,0,0,0};
static C_char li148[] C_aligned={C_lihdr(0,0,8),67,95,115,105,103,110,117,109};
static C_char li149[] C_aligned={C_lihdr(0,0,21),40,99,104,105,99,107,101,110,46,98,97,115,101,35,97,100,100,49,32,110,41,0,0,0};
static C_char li150[] C_aligned={C_lihdr(0,0,21),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,117,98,49,32,110,41,0,0,0};
static C_char li151[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,114,114,111,114,32,46,32,97,114,103,115,41,0,0,0,0,0};
static C_char li152[] C_aligned={C_lihdr(0,0,23),40,99,104,105,99,107,101,110,46,98,97,115,101,35,118,111,105,100,32,46,32,95,41,0};
static C_char li153[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,114,111,109,105,115,101,63,32,120,41,0,0,0,0,0,0,0};
static C_char li154[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,109,97,107,101,45,112,114,111,109,105,115,101,32,112,114,111,99,41,0,0,0,0,0,0,0};
static C_char li155[] C_aligned={C_lihdr(0,0,8),40,97,49,50,55,48,54,41};
static C_char li156[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,98,97,115,101,35,109,97,107,101,45,112,114,111,109,105,115,101,32,111,98,106,41,0};
static C_char li157[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,108,115,116,32,122,41,0,0,0,0};
static C_char li158[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,111,108,100,108,32,102,32,122,32,108,115,116,41,0,0,0,0};
static C_char li159[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char li160[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,111,108,100,114,32,102,32,122,32,108,115,116,41,0,0,0,0};
static C_char li161[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,111,110,45,101,120,105,116,32,116,104,117,110,107,41,0,0,0,0};
static C_char li162[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,120,105,116,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char li163[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,109,101,114,103,101,110,99,121,45,101,120,105,116,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char li164[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,98,97,115,101,35,105,100,101,110,116,105,116,121,32,120,41,0,0,0,0,0,0,0};
static C_char li165[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,114,101,100,115,41,0,0,0,0};
static C_char li166[] C_aligned={C_lihdr(0,0,11),40,102,95,49,50,56,51,54,32,120,41,0,0,0,0,0};
static C_char li167[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,111,110,106,111,105,110,32,46,32,112,114,101,100,115,41,0,0};
static C_char li168[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,114,101,100,115,41,0,0,0,0};
static C_char li169[] C_aligned={C_lihdr(0,0,11),40,102,95,49,50,56,54,57,32,120,41,0,0,0,0,0};
static C_char li170[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,97,115,101,35,100,105,115,106,111,105,110,32,46,32,112,114,101,100,115,41,0,0};
static C_char li171[] C_aligned={C_lihdr(0,0,13),40,102,95,49,50,57,49,53,32,46,32,95,41,0,0,0};
static C_char li172[] C_aligned={C_lihdr(0,0,13),40,102,95,49,50,57,49,55,32,46,32,95,41,0,0,0};
static C_char li173[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,111,110,115,116,97,110,116,108,121,32,46,32,120,115,41,0,0};
static C_char li174[] C_aligned={C_lihdr(0,0,13),40,102,95,49,50,57,50,55,32,120,32,121,41,0,0,0};
static C_char li175[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,108,105,112,32,112,114,111,99,41};
static C_char li176[] C_aligned={C_lihdr(0,0,16),40,102,95,49,50,57,51,53,32,46,32,97,114,103,115,41};
static C_char li177[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,111,109,112,108,101,109,101,110,116,32,112,41,0,0,0,0,0};
static C_char li178[] C_aligned={C_lihdr(0,0,8),40,97,49,50,57,54,49,41};
static C_char li179[] C_aligned={C_lihdr(0,0,16),40,102,95,49,50,57,53,54,32,46,32,97,114,103,115,41};
static C_char li180[] C_aligned={C_lihdr(0,0,14),40,114,101,99,32,102,48,32,46,32,102,110,115,41,0,0};
static C_char li181[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,111,109,112,111,115,101,32,46,32,102,110,115,41,0,0,0,0};
static C_char li182[] C_aligned={C_lihdr(0,0,11),40,102,95,49,51,48,48,55,32,120,41,0,0,0,0,0};
static C_char li183[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,102,110,115,41,0,0,0,0,0,0};
static C_char li184[] C_aligned={C_lihdr(0,0,22),40,99,104,105,99,107,101,110,46,98,97,115,101,35,111,32,46,32,102,110,115,41,0,0};
static C_char li185[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char li186[] C_aligned={C_lihdr(0,0,13),40,102,95,49,51,48,50,50,32,108,115,116,41,0,0,0};
static C_char li187[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,108,105,115,116,45,111,102,63,32,112,114,101,100,41,0,0,0,0};
static C_char li188[] C_aligned={C_lihdr(0,0,13),40,102,95,49,51,48,55,50,32,46,32,95,41,0,0,0};
static C_char li189[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,114,111,99,115,41,0,0,0,0};
static C_char li190[] C_aligned={C_lihdr(0,0,16),40,102,95,49,51,48,56,54,32,46,32,97,114,103,115,41};
static C_char li191[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,97,99,104,32,46,32,112,114,111,99,115,41,0,0,0,0,0};
static C_char li192[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,98,119,112,45,111,98,106,101,99,116,63,32,120,41,0,0,0,0};
static C_char li193[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,119,101,97,107,45,99,111,110,115,32,120,32,121,41,0,0,0,0};
static C_char li194[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,97,115,101,35,119,101,97,107,45,112,97,105,114,63,32,120,41,0,0,0,0,0};
static C_char li195[] C_aligned={C_lihdr(0,0,22),40,99,104,105,99,107,101,110,46,98,97,115,101,35,97,116,111,109,63,32,120,41,0,0};
static C_char li196[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char li197[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,98,97,115,101,35,116,97,105,108,63,32,120,32,121,41};
static C_char li198[] C_aligned={C_lihdr(0,0,9),40,108,111,111,112,32,110,115,41,0,0,0,0,0,0,0};
static C_char li199[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,98,97,115,101,35,105,110,116,101,114,115,112,101,114,115,101,32,108,115,116,32,120,41};
static C_char li200[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char li201[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,98,97,115,101,35,98,117,116,108,97,115,116,32,108,115,116,41,0,0,0,0,0,0};
static C_char li202[] C_aligned={C_lihdr(0,0,17),40,108,111,111,112,32,108,105,115,116,115,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char li203[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,108,97,116,116,101,110,32,46,32,108,105,115,116,115,48,41,0};
static C_char li204[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,108,115,116,115,41,0,0,0,0,0};
static C_char li205[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,97,115,101,35,106,111,105,110,32,108,115,116,115,32,46,32,108,115,116,41,0,0};
static C_char li206[] C_aligned={C_lihdr(0,0,15),40,108,111,111,112,32,98,108,115,116,32,108,115,116,41,0};
static C_char li207[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,111,109,112,114,101,115,115,32,98,108,115,116,32,108,115,116,41};
static C_char li208[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,104,97,114,45,102,111,108,100,99,97,115,101,32,99,41,0,0};
static C_char li209[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,116,114,105,110,103,45,102,111,108,100,99,97,115,101,32,115,116,114,41,0,0,0,0,0,0};
static C_char li210[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char li211[] C_aligned={C_lihdr(0,0,15),40,102,95,49,51,52,54,56,32,120,32,108,115,116,41,0};
static C_char li212[] C_aligned={C_lihdr(0,0,43),40,99,104,105,99,107,101,110,46,98,97,115,101,35,97,108,105,115,116,45,117,112,100,97,116,101,33,32,120,32,121,32,108,115,116,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li213[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char li214[] C_aligned={C_lihdr(0,0,42),40,99,104,105,99,107,101,110,46,98,97,115,101,35,97,108,105,115,116,45,117,112,100,97,116,101,32,107,32,118,32,108,115,116,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char li215[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char li216[] C_aligned={C_lihdr(0,0,15),40,102,95,49,51,54,54,48,32,120,32,108,115,116,41,0};
static C_char li217[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,98,97,115,101,35,97,108,105,115,116,45,114,101,102,32,120,32,108,115,116,32,46,32,114,101,115,116,41,0,0,0};
static C_char li218[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,108,41};
static C_char li219[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,98,97,115,101,35,114,97,115,115,111,99,32,120,32,108,115,116,32,46,32,116,115,116,41,0,0,0,0,0,0,0};
static C_char li220[] C_aligned={C_lihdr(0,0,33),40,115,99,104,101,109,101,35,111,112,101,110,45,105,110,112,117,116,45,115,116,114,105,110,103,32,115,116,114,105,110,103,41,0,0,0,0,0,0,0};
static C_char li221[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,111,112,101,110,45,111,117,116,112,117,116,45,115,116,114,105,110,103,41,0,0,0,0,0};
static C_char li222[] C_aligned={C_lihdr(0,0,31),40,115,99,104,101,109,101,35,103,101,116,45,111,117,116,112,117,116,45,115,116,114,105,110,103,32,112,111,114,116,41,0};
static C_char li223[] C_aligned={C_lihdr(0,0,10),40,97,49,51,56,56,49,32,95,41,0,0,0,0,0,0};
static C_char li224[] C_aligned={C_lihdr(0,0,10),40,97,49,51,56,57,52,32,95,41,0,0,0,0,0,0};
static C_char li225[] C_aligned={C_lihdr(0,0,12),40,97,49,51,57,48,51,32,95,32,95,41,0,0,0,0};
static C_char li226[] C_aligned={C_lihdr(0,0,10),40,97,49,51,57,48,57,32,95,41,0,0,0,0,0,0};
static C_char li227[] C_aligned={C_lihdr(0,0,23),40,97,49,51,57,49,57,32,112,32,110,32,100,101,115,116,32,115,116,97,114,116,41,0};
static C_char li228[] C_aligned={C_lihdr(0,0,33),40,115,99,104,101,109,101,35,111,112,101,110,45,105,110,112,117,116,45,98,121,116,101,118,101,99,116,111,114,32,98,118,41,0,0,0,0,0,0,0};
static C_char li229[] C_aligned={C_lihdr(0,0,18),40,97,100,100,32,98,118,32,115,116,97,114,116,32,101,110,100,41,0,0,0,0,0,0};
static C_char li230[] C_aligned={C_lihdr(0,0,8),40,103,101,116,116,101,114,41};
static C_char li231[] C_aligned={C_lihdr(0,0,12),40,97,49,51,57,54,55,32,112,32,99,41,0,0,0,0};
static C_char li232[] C_aligned={C_lihdr(0,0,23),40,97,49,51,57,56,52,32,112,32,98,118,32,115,116,97,114,116,32,101,110,100,41,0};
static C_char li233[] C_aligned={C_lihdr(0,0,12),40,97,49,51,57,57,48,32,95,32,95,41,0,0,0,0};
static C_char li234[] C_aligned={C_lihdr(0,0,31),40,115,99,104,101,109,101,35,111,112,101,110,45,111,117,116,112,117,116,45,98,121,116,101,118,101,99,116,111,114,41,0};
static C_char li235[] C_aligned={C_lihdr(0,0,6),40,102,97,105,108,41,0,0};
static C_char li236[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,103,101,116,45,111,117,116,112,117,116,45,98,121,116,101,118,101,99,116,111,114,32,112,41};
static C_char li237[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,43,32,120,32,121,41};
static C_char li238[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,45,32,120,32,121,41};
static C_char li239[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,42,32,120,32,121,41};
static C_char li240[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,61,32,120,32,121,41};
static C_char li241[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,62,32,120,32,121,41};
static C_char li242[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,60,32,120,32,121,41};
static C_char li243[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,62,61,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char li244[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,60,61,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char li245[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,109,105,110,32,120,32,121,41,0,0,0,0,0,0};
static C_char li246[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,109,97,120,32,120,32,121,41,0,0,0,0,0,0};
static C_char li247[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,110,101,103,32,120,41};
static C_char li248[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,97,110,100,32,120,32,121,41,0,0,0,0,0,0};
static C_char li249[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,105,111,114,32,120,32,121,41,0,0,0,0,0,0};
static C_char li250[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,120,111,114,32,120,32,121,41,0,0,0,0,0,0};
static C_char li251[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,110,111,116,32,120,41};
static C_char li252[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,115,104,108,32,120,32,121,41,0,0,0,0,0,0};
static C_char li253[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,115,104,114,32,120,32,121,41,0,0,0,0,0,0};
static C_char li254[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,111,100,100,63,32,120,41,0,0,0,0,0,0,0};
static C_char li255[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,101,118,101,110,63,32,120,41,0,0,0,0,0,0};
static C_char li256[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,108,101,110,32,120,41};
static C_char li257[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,47,32,120,32,121,41};
static C_char li258[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,103,99,100,32,120,32,121,41,0,0,0,0,0,0};
static C_char li259[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,109,111,100,32,120,32,121,41,0,0,0,0,0,0};
static C_char li260[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,114,101,109,32,120,32,121,41,0,0,0,0,0,0};
static C_char li261[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,43,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char li262[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,45,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char li263[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,42,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char li264[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,105,120,110,117,109,35,102,120,47,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char li265[] C_aligned={C_lihdr(0,0,19),40,35,35,115,121,115,35,100,101,98,117,103,45,109,111,100,101,63,41,0,0,0,0,0};
static C_char li266[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,98,97,115,101,35,119,97,114,110,105,110,103,32,109,115,103,32,46,32,97,114,103,115,41,0,0,0,0,0,0,0};
static C_char li267[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,98,97,115,101,35,110,111,116,105,99,101,32,109,115,103,32,46,32,97,114,103,115,41};
static C_char li268[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,110,97,98,108,101,45,119,97,114,110,105,110,103,115,32,46,32,98,111,111,108,41,0,0,0};
static C_char li269[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,101,114,114,111,114,47,101,114,114,110,111,32,101,114,114,32,46,32,97,114,103,115,41,0,0};
static C_char li270[] C_aligned={C_lihdr(0,0,4),67,95,103,99,0,0,0,0};
static C_char li271[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,115,101,116,115,108,111,116,32,120,32,105,32,121,41,0,0,0};
static C_char li272[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,115,101,116,105,115,108,111,116,32,120,32,105,32,121,41,0,0};
static C_char li273[] C_aligned={C_lihdr(0,0,17),67,95,97,108,108,111,99,97,116,101,95,118,101,99,116,111,114,0,0,0,0,0,0,0};
static C_char li274[] C_aligned={C_lihdr(0,0,21),67,95,97,108,108,111,99,97,116,101,95,98,121,116,101,118,101,99,116,111,114,0,0,0};
static C_char li275[] C_aligned={C_lihdr(0,0,16),67,95,109,97,107,101,95,115,116,114,117,99,116,117,114,101};
static C_char li276[] C_aligned={C_lihdr(0,0,21),67,95,101,110,115,117,114,101,95,104,101,97,112,95,114,101,115,101,114,118,101,0,0,0};
static C_char li277[] C_aligned={C_lihdr(0,0,23),67,95,103,101,116,95,115,121,109,98,111,108,95,116,97,98,108,101,95,105,110,102,111,0};
static C_char li278[] C_aligned={C_lihdr(0,0,17),67,95,103,101,116,95,109,101,109,111,114,121,95,105,110,102,111,0,0,0,0,0,0,0};
static C_char li279[] C_aligned={C_lihdr(0,0,19),40,35,35,115,121,115,35,115,116,97,114,116,45,116,105,109,101,114,41,0,0,0,0,0};
static C_char li280[] C_aligned={C_lihdr(0,0,12),67,95,115,116,111,112,95,116,105,109,101,114,0,0,0,0};
static C_char li281[] C_aligned={C_lihdr(0,0,12),67,95,115,116,111,112,95,116,105,109,101,114,0,0,0,0};
static C_char li282[] C_aligned={C_lihdr(0,0,18),40,35,35,115,121,115,35,115,116,111,112,45,116,105,109,101,114,41,0,0,0,0,0,0};
static C_char li283[] C_aligned={C_lihdr(0,0,20),40,35,35,115,121,115,35,105,109,109,101,100,105,97,116,101,63,32,120,41,0,0,0,0};
static C_char li284[] C_aligned={C_lihdr(0,0,19),40,35,35,115,121,115,35,109,101,115,115,97,103,101,32,115,116,114,41,0,0,0,0,0};
static C_char li285[] C_aligned={C_lihdr(0,0,16),40,35,35,115,121,115,35,98,121,116,101,32,120,32,105,41};
static C_char li286[] C_aligned={C_lihdr(0,0,16),40,35,35,115,121,115,35,104,97,108,116,32,109,115,103,41};
static C_char li287[] C_aligned={C_lihdr(0,0,8),67,95,98,101,99,111,109,101};
static C_char li288[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,98,108,111,99,107,45,114,101,102,32,120,32,105,41,0,0,0};
static C_char li289[] C_aligned={C_lihdr(0,0,14),67,95,97,112,112,108,121,95,118,97,108,117,101,115,0,0};
static C_char li290[] C_aligned={C_lihdr(0,0,14),67,95,99,111,112,121,95,99,108,111,115,117,114,101,0,0};
static C_char li291[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,98,108,111,99,107,45,115,101,116,33,32,120,32,105,32,121,41};
static C_char li292[] C_aligned={C_lihdr(0,0,43),40,99,104,105,99,107,101,110,46,116,105,109,101,35,99,117,114,114,101,110,116,45,112,114,111,99,101,115,115,45,109,105,108,108,105,115,101,99,111,110,100,115,41,0,0,0,0,0};
static C_char li293[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,116,105,109,101,35,99,117,114,114,101,110,116,45,115,101,99,111,110,100,115,41,0,0};
static C_char li294[] C_aligned={C_lihdr(0,0,23),40,99,104,105,99,107,101,110,46,116,105,109,101,35,99,112,117,45,116,105,109,101,41,0};
static C_char li295[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,99,104,101,99,107,45,115,116,114,117,99,116,117,114,101,32,120,32,121,32,46,32,108,111,99,41,0,0,0,0,0,0,0};
static C_char li296[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,98,108,111,98,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char li297[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,112,97,105,114,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char li298[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,108,105,115,116,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char li299[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,99,104,101,99,107,45,115,116,114,105,110,103,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char li300[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,99,104,101,99,107,45,110,117,109,98,101,114,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char li301[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,99,104,101,99,107,45,102,105,120,110,117,109,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char li302[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,99,104,101,99,107,45,98,121,116,101,118,101,99,116,111,114,32,120,32,46,32,108,111,99,41};
static C_char li303[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,99,104,101,99,107,45,101,120,97,99,116,32,120,32,46,32,108,111,99,41,0,0,0,0,0};
static C_char li304[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,99,104,101,99,107,45,105,110,101,120,97,99,116,32,120,32,46,32,108,111,99,41,0,0,0};
static C_char li305[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,99,104,101,99,107,45,115,121,109,98,111,108,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char li306[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,99,104,101,99,107,45,107,101,121,119,111,114,100,32,120,32,46,32,108,111,99,41,0,0,0};
static C_char li307[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,99,104,101,99,107,45,118,101,99,116,111,114,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char li308[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,99,104,97,114,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char li309[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,99,104,101,99,107,45,98,111,111,108,101,97,110,32,120,32,46,32,108,111,99,41,0,0,0};
static C_char li310[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,99,104,101,99,107,45,108,111,99,97,116,105,118,101,32,120,32,46,32,108,111,99,41,0,0};
static C_char li311[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,99,104,101,99,107,45,105,110,116,101,103,101,114,32,120,32,46,32,108,111,99,41,0,0,0};
static C_char li312[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,99,104,101,99,107,45,101,120,97,99,116,45,105,110,116,101,103,101,114,32,120,32,46,32,108,111,99,41,0,0,0,0,0};
static C_char li313[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,99,104,101,99,107,45,101,120,97,99,116,45,117,105,110,116,101,103,101,114,32,120,32,46,32,108,111,99,41,0,0,0,0};
static C_char li314[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,114,101,97,108,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char li315[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,99,104,101,99,107,45,114,97,110,103,101,32,105,32,102,114,111,109,32,116,111,32,46,32,108,111,99,41,0,0,0,0,0};
static C_char li316[] C_aligned={C_lihdr(0,0,45),40,35,35,115,121,115,35,99,104,101,99,107,45,114,97,110,103,101,47,105,110,99,108,117,100,105,110,103,32,105,32,102,114,111,109,32,116,111,32,46,32,108,111,99,41,0,0,0};
static C_char li317[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,99,104,101,99,107,45,115,112,101,99,105,97,108,32,112,116,114,32,46,32,108,111,99,41,0};
static C_char li318[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,99,104,101,99,107,45,99,108,111,115,117,114,101,32,120,32,46,32,108,111,99,41,0,0,0};
static C_char li319[] C_aligned={C_lihdr(0,0,20),40,108,112,32,112,114,111,109,105,115,101,32,102,111,114,119,97,114,100,41,0,0,0,0};
static C_char li320[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,102,111,114,99,101,32,111,98,106,41,0,0,0,0,0,0};
static C_char li321[] C_aligned={C_lihdr(0,0,7),67,95,100,108,111,97,100,0};
static C_char li322[] C_aligned={C_lihdr(0,0,18),67,95,115,101,116,95,100,108,111,112,101,110,95,102,108,97,103,115,0,0,0,0,0,0};
static C_char li323[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,101,114,114,111,114,45,110,111,116,45,97,45,112,114,111,112,101,114,45,108,105,115,116,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char li324[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,110,117,109,98,101,114,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li325[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,105,110,116,101,103,101,114,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char li326[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,101,120,97,99,116,45,105,110,116,101,103,101,114,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char li327[] C_aligned={C_lihdr(0,0,43),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,101,120,97,99,116,45,117,105,110,116,101,103,101,114,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li328[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,105,110,101,120,97,99,116,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char li329[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,114,101,97,108,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char li330[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,101,114,114,111,114,45,98,97,100,45,98,97,115,101,32,97,114,103,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char li331[] C_aligned={C_lihdr(0,0,11),40,99,111,112,121,32,110,111,100,101,41,0,0,0,0,0};
static C_char li332[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,108,115,116,115,41,0,0,0,0,0};
static C_char li333[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,97,112,112,101,110,100,32,46,32,108,115,116,115,41,0,0};
static C_char li334[] C_aligned={C_lihdr(0,0,15),40,108,111,111,112,32,108,115,116,32,114,101,115,116,41,0};
static C_char li335[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,102,97,115,116,45,114,101,118,101,114,115,101,32,108,115,116,48,41,0,0,0,0,0,0,0};
static C_char li336[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,109,97,107,101,45,98,121,116,101,118,101,99,116,111,114,32,115,105,122,101,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li337[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,109,97,107,101,45,115,116,114,105,110,103,32,115,105,122,101,32,46,32,114,101,115,116,41,0};
static C_char li338[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,98,117,102,102,101,114,45,62,115,116,114,105,110,103,32,98,117,102,32,115,116,97,114,116,32,108,101,110,41,0,0,0,0};
static C_char li339[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,117,116,102,45,100,101,99,111,100,101,114,32,98,117,102,32,115,116,97,114,116,32,108,101,110,32,107,41,0,0,0,0,0};
static C_char li340[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,117,116,102,45,101,110,99,111,100,101,114,32,98,117,102,32,115,116,97,114,116,32,108,101,110,32,107,41,0,0,0,0,0};
static C_char li341[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,117,116,102,45,115,99,97,110,110,101,114,32,115,116,97,116,101,32,98,121,116,101,41,0,0};
static C_char li342[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,108,97,116,105,110,45,100,101,99,111,100,101,114,32,98,118,32,115,116,97,114,116,32,108,101,110,32,107,41,0,0,0,0};
static C_char li343[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,108,97,116,105,110,45,101,110,99,111,100,101,114,32,98,118,32,115,116,97,114,116,32,108,101,110,32,107,41,0,0,0,0};
static C_char li344[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,108,97,116,105,110,45,115,99,97,110,110,101,114,32,115,116,97,116,101,32,98,121,116,101,41};
static C_char li345[] C_aligned={C_lihdr(0,0,37),40,35,35,115,121,115,35,98,105,110,97,114,121,45,100,101,99,111,100,101,114,32,98,118,32,115,116,97,114,116,32,108,101,110,32,107,41,0,0,0};
static C_char li346[] C_aligned={C_lihdr(0,0,37),40,35,35,115,121,115,35,98,105,110,97,114,121,45,101,110,99,111,100,101,114,32,98,118,32,115,116,97,114,116,32,108,101,110,32,107,41,0,0,0};
static C_char li347[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,98,105,110,97,114,121,45,115,99,97,110,110,101,114,32,115,116,97,116,101,32,98,121,116,101,41,0,0,0,0,0,0,0};
static C_char li348[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,101,110,99,111,100,105,110,103,45,104,111,111,107,32,101,110,99,32,107,41,0,0,0,0,0};
static C_char li349[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,101,110,99,111,100,105,110,103,45,104,111,111,107,32,101,110,99,32,107,41,0,0,0,0,0};
static C_char li350[] C_aligned={C_lihdr(0,0,44),40,35,35,115,121,115,35,114,101,103,105,115,116,101,114,45,101,110,99,111,100,105,110,103,32,110,97,109,101,115,32,100,101,99,32,101,110,99,32,115,99,97,110,41,0,0,0,0};
static C_char li351[] C_aligned={C_lihdr(0,0,20),40,97,49,53,49,55,56,32,100,101,99,111,100,101,114,32,95,32,95,41,0,0,0,0};
static C_char li352[] C_aligned={C_lihdr(0,0,49),40,35,35,115,121,115,35,98,117,102,102,101,114,45,62,115,116,114,105,110,103,47,101,110,99,111,100,105,110,103,32,98,117,102,32,115,116,97,114,116,32,108,101,110,32,101,110,99,41,0,0,0,0,0,0,0};
static C_char li353[] C_aligned={C_lihdr(0,0,20),40,97,49,53,49,57,48,32,95,32,101,110,99,111,100,101,114,32,95,41,0,0,0,0};
static C_char li354[] C_aligned={C_lihdr(0,0,40),40,35,35,115,121,115,35,101,110,99,111,100,101,45,98,117,102,102,101,114,32,98,118,32,115,116,97,114,116,32,108,101,110,32,101,110,99,32,107,41};
static C_char li355[] C_aligned={C_lihdr(0,0,20),40,97,49,53,50,48,50,32,100,101,99,111,100,101,114,32,95,32,95,41,0,0,0,0};
static C_char li356[] C_aligned={C_lihdr(0,0,40),40,35,35,115,121,115,35,100,101,99,111,100,101,45,98,117,102,102,101,114,32,98,118,32,115,116,97,114,116,32,108,101,110,32,101,110,99,32,107,41};
static C_char li357[] C_aligned={C_lihdr(0,0,22),40,97,49,53,50,50,51,32,98,117,102,32,115,116,97,114,116,32,108,101,110,41,0,0};
static C_char li358[] C_aligned={C_lihdr(0,0,20),40,97,49,53,50,49,52,32,95,32,101,110,99,111,100,101,114,32,95,41,0,0,0,0};
static C_char li359[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,101,110,99,111,100,101,45,99,104,97,114,32,99,32,98,118,32,101,110,99,41,0,0,0,0};
static C_char li360[] C_aligned={C_lihdr(0,0,20),40,97,49,53,50,51,54,32,98,117,102,32,115,116,97,114,116,32,95,41,0,0,0,0};
static C_char li361[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,100,101,99,111,100,101,45,99,104,97,114,32,98,118,32,101,110,99,32,115,116,97,114,116,41};
static C_char li362[] C_aligned={C_lihdr(0,0,14),40,108,111,111,112,32,115,116,97,116,101,32,105,41,0,0};
static C_char li363[] C_aligned={C_lihdr(0,0,19),40,97,49,53,50,52,53,32,100,101,99,32,95,32,115,99,97,110,41,0,0,0,0,0};
static C_char li364[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,114,101,97,100,45,99,104,97,114,47,101,110,99,111,100,105,110,103,32,112,32,101,110,99,32,107,41,0,0,0,0,0,0};
static C_char li365[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,109,97,107,101,45,115,116,114,105,110,103,32,115,105,122,101,32,46,32,102,105,108,108,41};
static C_char li366[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,105,32,108,115,41,0,0,0,0,0};
static C_char li367[] C_aligned={C_lihdr(0,0,30),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,62,108,105,115,116,32,115,32,46,32,114,101,115,116,41,0,0};
static C_char li368[] C_aligned={C_lihdr(0,0,14),40,108,111,111,112,32,105,32,112,32,108,115,116,41,0,0};
static C_char li369[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,108,105,115,116,45,62,115,116,114,105,110,103,32,108,115,116,48,41,0,0,0,0,0,0};
static C_char li370[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,32,108,32,110,41,0,0,0,0};
static C_char li371[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,114,101,118,101,114,115,101,45,108,105,115,116,45,62,115,116,114,105,110,103,32,108,41,0,0};
static C_char li372[] C_aligned={C_lihdr(0,0,12),40,100,111,108,111,111,112,50,48,52,54,41,0,0,0,0};
static C_char li373[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,102,105,108,108,33,32,115,32,99,32,46,32,114,101,115,116,41};
static C_char li374[] C_aligned={C_lihdr(0,0,29),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,111,112,121,32,115,32,46,32,114,101,115,116,41,0,0,0};
static C_char li375[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,50,49,48,52,32,105,41,0,0};
static C_char li376[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,50,49,49,48,32,105,41,0,0};
static C_char li377[] C_aligned={C_lihdr(0,0,39),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,111,112,121,33,32,116,111,32,97,116,32,102,114,111,109,32,46,32,114,101,115,116,41,0};
static C_char li378[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,115,117,98,115,116,114,105,110,103,32,115,32,115,116,97,114,116,32,101,110,100,41,0,0,0};
static C_char li379[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,115,117,98,115,116,114,105,110,103,32,115,32,115,116,97,114,116,32,46,32,101,110,100,41};
static C_char li380[] C_aligned={C_lihdr(0,0,17),40,108,111,111,112,32,115,32,108,101,110,32,115,115,32,102,41,0,0,0,0,0,0,0};
static C_char li381[] C_aligned={C_lihdr(0,0,28),40,99,111,109,112,97,114,101,32,115,49,32,115,50,32,109,111,114,101,32,108,111,99,32,99,109,112,41,0,0,0,0};
static C_char li382[] C_aligned={C_lihdr(0,0,22),40,97,49,54,48,49,55,32,99,109,112,32,108,101,110,49,32,108,101,110,50,41,0,0};
static C_char li383[] C_aligned={C_lihdr(0,0,30),40,115,99,104,101,109,101,35,115,116,114,105,110,103,60,63,32,115,49,32,115,50,32,46,32,109,111,114,101,41,0,0};
static C_char li384[] C_aligned={C_lihdr(0,0,22),40,97,49,54,48,52,49,32,99,109,112,32,108,101,110,49,32,108,101,110,50,41,0,0};
static C_char li385[] C_aligned={C_lihdr(0,0,30),40,115,99,104,101,109,101,35,115,116,114,105,110,103,62,63,32,115,49,32,115,50,32,46,32,109,111,114,101,41,0,0};
static C_char li386[] C_aligned={C_lihdr(0,0,22),40,97,49,54,48,54,53,32,99,109,112,32,108,101,110,49,32,108,101,110,50,41,0,0};
static C_char li387[] C_aligned={C_lihdr(0,0,31),40,115,99,104,101,109,101,35,115,116,114,105,110,103,60,61,63,32,115,49,32,115,50,32,46,32,109,111,114,101,41,0};
static C_char li388[] C_aligned={C_lihdr(0,0,22),40,97,49,54,48,56,54,32,99,109,112,32,108,101,110,49,32,108,101,110,50,41,0,0};
static C_char li389[] C_aligned={C_lihdr(0,0,31),40,115,99,104,101,109,101,35,115,116,114,105,110,103,62,61,63,32,115,49,32,115,50,32,46,32,109,111,114,101,41,0};
static C_char li390[] C_aligned={C_lihdr(0,0,17),40,108,111,111,112,32,115,32,108,101,110,32,115,115,32,102,41,0,0,0,0,0,0,0};
static C_char li391[] C_aligned={C_lihdr(0,0,28),40,99,111,109,112,97,114,101,32,115,49,32,115,50,32,109,111,114,101,32,108,111,99,32,99,109,112,41,0,0,0,0};
static C_char li392[] C_aligned={C_lihdr(0,0,22),40,97,49,54,49,54,55,32,99,109,112,32,108,101,110,49,32,108,101,110,50,41,0,0};
static C_char li393[] C_aligned={C_lihdr(0,0,33),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,105,60,63,32,115,49,32,115,50,32,46,32,109,111,114,101,41,0,0,0,0,0,0,0};
static C_char li394[] C_aligned={C_lihdr(0,0,22),40,97,49,54,49,57,49,32,99,109,112,32,108,101,110,49,32,108,101,110,50,41,0,0};
static C_char li395[] C_aligned={C_lihdr(0,0,33),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,105,62,63,32,115,49,32,115,50,32,46,32,109,111,114,101,41,0,0,0,0,0,0,0};
static C_char li396[] C_aligned={C_lihdr(0,0,22),40,97,49,54,50,49,53,32,99,109,112,32,108,101,110,49,32,108,101,110,50,41,0,0};
static C_char li397[] C_aligned={C_lihdr(0,0,34),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,105,60,61,63,32,115,49,32,115,50,32,46,32,109,111,114,101,41,0,0,0,0,0,0};
static C_char li398[] C_aligned={C_lihdr(0,0,22),40,97,49,54,50,51,54,32,99,109,112,32,108,101,110,49,32,108,101,110,50,41,0,0};
static C_char li399[] C_aligned={C_lihdr(0,0,34),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,99,105,62,61,63,32,115,49,32,115,50,32,46,32,109,111,114,101,41,0,0,0,0,0,0};
static C_char li400[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,115,116,114,105,110,103,45,97,112,112,101,110,100,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char li401[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,115,116,114,115,32,110,32,117,108,41};
static C_char li402[] C_aligned={C_lihdr(0,0,28),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,97,112,112,101,110,100,32,46,32,97,108,108,41,0,0,0,0};
static C_char li403[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,115,116,114,105,110,103,32,46,32,99,104,97,114,115,41,0};
static C_char li404[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,99,104,97,114,45,62,117,116,102,56,45,115,116,114,105,110,103,32,99,41,0,0,0,0,0};
static C_char li405[] C_aligned={C_lihdr(0,0,20),40,100,111,108,111,111,112,50,50,57,54,32,104,100,32,116,108,32,99,41,0,0,0,0};
static C_char li406[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,108,115,116,32,105,41,0,0,0,0};
static C_char li407[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,104,111,112,32,108,115,116,32,110,41,0,0,0,0,0,0,0};
static C_char li408[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,43,32,120,32,121,41};
static C_char li409[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,45,32,120,32,121,41};
static C_char li410[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,42,32,120,32,121,41};
static C_char li411[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,47,32,120,32,121,41};
static C_char li412[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,42,43,32,120,32,121,32,122,41,0,0,0,0,0};
static C_char li413[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,103,99,100,32,120,32,121,41,0,0,0,0,0,0};
static C_char li414[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,47,63,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char li415[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,61,32,120,32,121,41};
static C_char li416[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,62,32,120,32,121,41};
static C_char li417[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,60,32,120,32,121,41};
static C_char li418[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,62,61,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char li419[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,60,61,32,120,32,121,41,0,0,0,0,0,0,0};
static C_char li420[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,110,101,103,32,120,41};
static C_char li421[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,109,97,120,32,120,32,121,41,0,0,0,0,0,0};
static C_char li422[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,109,105,110,32,120,32,121,41,0,0,0,0,0,0};
static C_char li423[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,102,108,111,111,114,32,120,41,0,0,0,0,0,0};
static C_char li424[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,116,114,117,110,99,97,116,101,32,120,41,0,0,0};
static C_char li425[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,114,111,117,110,100,32,120,41,0,0,0,0,0,0};
static C_char li426[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,99,101,105,108,105,110,103,32,120,41,0,0,0,0};
static C_char li427[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,115,105,110,32,120,41};
static C_char li428[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,99,111,115,32,120,41};
static C_char li429[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,116,97,110,32,120,41};
static C_char li430[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,115,105,110,32,120,41,0,0,0,0,0,0,0};
static C_char li431[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,99,111,115,32,120,41,0,0,0,0,0,0,0};
static C_char li432[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,116,97,110,32,120,41,0,0,0,0,0,0,0};
static C_char li433[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,116,97,110,50,32,120,32,121,41,0,0,0,0};
static C_char li434[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,115,105,110,104,32,120,41,0,0,0,0,0,0,0};
static C_char li435[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,99,111,115,104,32,120,41,0,0,0,0,0,0,0};
static C_char li436[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,116,97,110,104,32,120,41,0,0,0,0,0,0,0};
static C_char li437[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,115,105,110,104,32,120,41,0,0,0,0,0,0};
static C_char li438[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,99,111,115,104,32,120,41,0,0,0,0,0,0};
static C_char li439[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,116,97,110,104,32,120,41,0,0,0,0,0,0};
static C_char li440[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,101,120,112,32,120,41};
static C_char li441[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,101,120,112,116,32,120,32,121,41,0,0,0,0,0};
static C_char li442[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,108,111,103,32,120,41};
static C_char li443[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,115,113,114,116,32,120,41,0,0,0,0,0,0,0};
static C_char li444[] C_aligned={C_lihdr(0,0,24),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,97,98,115,32,120,41};
static C_char li445[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,112,105,110,116,101,103,101,114,63,32,120,41,0,0,0};
static C_char li446[] C_aligned={C_lihdr(0,0,46),40,99,104,105,99,107,101,110,46,102,108,111,110,117,109,35,102,108,111,110,117,109,45,112,114,105,110,116,45,112,114,101,99,105,115,105,111,110,32,46,32,114,101,115,116,41,0,0};
static C_char li447[] C_aligned={C_lihdr(0,0,18),40,109,97,107,101,45,99,111,109,112,108,101,120,32,114,32,105,41,0,0,0,0,0,0};
static C_char li448[] C_aligned={C_lihdr(0,0,29),40,115,99,104,101,109,101,35,109,97,107,101,45,114,101,99,116,97,110,103,117,108,97,114,32,114,32,105,41,0,0,0};
static C_char li449[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,109,97,107,101,45,112,111,108,97,114,32,114,32,112,104,105,41,0,0,0,0,0,0,0};
static C_char li450[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,114,101,97,108,45,112,97,114,116,32,120,41,0,0,0,0};
static C_char li451[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,105,109,97,103,45,112,97,114,116,32,120,41,0,0,0,0};
static C_char li452[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,97,110,103,108,101,32,110,41};
static C_char li453[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,109,97,103,110,105,116,117,100,101,32,120,41,0,0,0,0};
static C_char li454[] C_aligned={C_lihdr(0,0,10),40,114,97,116,110,117,109,32,110,41,0,0,0,0,0,0};
static C_char li455[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,110,117,109,101,114,97,116,111,114,32,110,41,0,0,0,0};
static C_char li456[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,100,101,110,111,109,105,110,97,116,111,114,32,110,41,0,0};
static C_char li457[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,101,120,116,101,110,100,101,100,45,115,105,103,110,117,109,32,120,41,0,0,0,0,0,0,0};
static C_char li458[] C_aligned={C_lihdr(0,0,16),40,100,111,108,111,111,112,50,56,54,55,32,120,32,105,41};
static C_char li459[] C_aligned={C_lihdr(0,0,13),40,100,101,108,105,118,101,114,32,121,32,100,41,0,0,0};
static C_char li460[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,105,110,101,120,97,99,116,45,62,101,120,97,99,116,32,120,41,0,0,0,0,0,0,0};
static C_char li461[] C_aligned={C_lihdr(0,0,13),67,95,98,105,116,119,105,115,101,95,97,110,100,0,0,0};
static C_char li462[] C_aligned={C_lihdr(0,0,13),67,95,98,105,116,119,105,115,101,95,105,111,114,0,0,0};
static C_char li463[] C_aligned={C_lihdr(0,0,13),67,95,98,105,116,119,105,115,101,95,120,111,114,0,0,0};
static C_char li464[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,98,105,116,119,105,115,101,35,98,105,116,119,105,115,101,45,110,111,116,32,110,41,0};
static C_char li465[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,105,116,119,105,115,101,35,98,105,116,45,62,98,111,111,108,101,97,110,32,110,32,105,41,0,0,0,0,0,0};
static C_char li466[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,105,116,119,105,115,101,35,105,110,116,101,103,101,114,45,108,101,110,103,116,104,32,120,41,0,0,0,0,0,0};
static C_char li467[] C_aligned={C_lihdr(0,0,38),40,99,104,105,99,107,101,110,46,98,105,116,119,105,115,101,35,97,114,105,116,104,109,101,116,105,99,45,115,104,105,102,116,32,110,32,109,41,0,0};
static C_char li468[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,97,114,103,115,32,120,41,0,0,0};
static C_char li469[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,47,32,97,114,103,49,32,46,32,97,114,103,115,41,0,0};
static C_char li470[] C_aligned={C_lihdr(0,0,15),40,35,35,115,121,115,35,47,45,50,32,120,32,121,41,0};
static C_char li471[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,102,108,111,111,114,32,120,41};
static C_char li472[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,99,101,105,108,105,110,103,32,120,41,0,0,0,0,0,0};
static C_char li473[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,116,114,117,110,99,97,116,101,32,120,41,0,0,0,0,0};
static C_char li474[] C_aligned={C_lihdr(0,0,16),40,115,99,104,101,109,101,35,114,111,117,110,100,32,120,41};
static C_char li475[] C_aligned={C_lihdr(0,0,8),40,115,114,32,120,32,121,41};
static C_char li476[] C_aligned={C_lihdr(0,0,24),40,102,105,110,100,45,114,97,116,105,111,45,98,101,116,119,101,101,110,32,120,32,121,41};
static C_char li477[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,114,97,116,105,111,110,97,108,105,122,101,32,120,32,101,41};
static C_char li478[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,105,32,109,32,120,115,41,0,0,0};
static C_char li479[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,109,97,120,32,120,49,32,46,32,120,115,41,0,0,0,0};
static C_char li480[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,105,32,109,32,120,115,41,0,0,0};
static C_char li481[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,109,105,110,32,120,49,32,46,32,120,115,41,0,0,0,0};
static C_char li482[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,101,120,112,32,110,41,0,0};
static C_char li483[] C_aligned={C_lihdr(0,0,15),40,35,35,115,121,115,35,108,111,103,45,49,32,120,41,0};
static C_char li484[] C_aligned={C_lihdr(0,0,21),40,115,99,104,101,109,101,35,108,111,103,32,97,32,46,32,114,101,115,116,41,0,0,0};
static C_char li485[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,115,105,110,32,110,41,0,0};
static C_char li486[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,99,111,115,32,110,41,0,0};
static C_char li487[] C_aligned={C_lihdr(0,0,14),40,115,99,104,101,109,101,35,116,97,110,32,110,41,0,0};
static C_char li488[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,97,115,105,110,32,110,41,0};
static C_char li489[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,97,99,111,115,32,110,41,0};
static C_char li490[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,97,116,97,110,32,110,32,46,32,114,101,115,116,41,0,0};
static C_char li491[] C_aligned={C_lihdr(0,0,8),40,97,49,57,48,48,52,41};
static C_char li492[] C_aligned={C_lihdr(0,0,34),67,95,117,95,105,110,116,101,103,101,114,95,113,117,111,116,105,101,110,116,95,97,110,100,95,114,101,109,97,105,110,100,101,114,0,0,0,0,0,0};
static C_char li493[] C_aligned={C_lihdr(0,0,8),40,97,49,57,48,51,53,41};
static C_char li494[] C_aligned={C_lihdr(0,0,20),40,97,49,57,48,53,49,32,113,51,50,51,52,32,117,51,50,51,54,41,0,0,0,0};
static C_char li495[] C_aligned={C_lihdr(0,0,22),40,97,49,57,48,49,56,32,115,94,51,50,49,52,32,114,94,51,50,49,54,41,0,0};
static C_char li496[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,101,120,97,99,116,45,105,110,116,101,103,101,114,45,115,113,114,116,32,97,41,0,0,0,0};
static C_char li497[] C_aligned={C_lihdr(0,0,29),40,115,99,104,101,109,101,35,101,120,97,99,116,45,105,110,116,101,103,101,114,45,115,113,114,116,32,120,41,0,0,0};
static C_char li498[] C_aligned={C_lihdr(0,0,8),40,97,49,57,49,57,50,41};
static C_char li499[] C_aligned={C_lihdr(0,0,14),40,97,49,57,49,57,56,32,115,94,50,32,114,41,0,0};
static C_char li500[] C_aligned={C_lihdr(0,0,8),40,97,49,57,50,50,48,41};
static C_char li501[] C_aligned={C_lihdr(0,0,8),40,97,49,57,50,52,52,41};
static C_char li502[] C_aligned={C_lihdr(0,0,16),40,97,49,57,50,53,54,32,100,115,94,50,32,100,114,41};
static C_char li503[] C_aligned={C_lihdr(0,0,16),40,97,49,57,50,51,50,32,110,115,94,50,32,110,114,41};
static C_char li504[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,115,113,114,116,47,108,111,99,32,108,111,99,32,110,41,0,0};
static C_char li505[] C_aligned={C_lihdr(0,0,15),40,115,99,104,101,109,101,35,115,113,114,116,32,120,41,0};
static C_char li506[] C_aligned={C_lihdr(0,0,8),40,97,49,57,50,57,57,41};
static C_char li507[] C_aligned={C_lihdr(0,0,16),40,97,49,57,51,48,53,32,100,105,118,32,114,101,109,41};
static C_char li508[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,102,108,111,111,114,47,32,120,32,121,41,0,0,0,0,0};
static C_char li509[] C_aligned={C_lihdr(0,0,8),40,97,49,57,51,53,52,41};
static C_char li510[] C_aligned={C_lihdr(0,0,16),40,97,49,57,51,54,48,32,100,105,118,32,114,101,109,41};
static C_char li511[] C_aligned={C_lihdr(0,0,28),40,115,99,104,101,109,101,35,102,108,111,111,114,45,114,101,109,97,105,110,100,101,114,32,120,32,121,41,0,0,0,0};
static C_char li512[] C_aligned={C_lihdr(0,0,8),40,97,49,57,51,54,57,41};
static C_char li513[] C_aligned={C_lihdr(0,0,16),40,97,49,57,51,55,53,32,100,105,118,32,114,101,109,41};
static C_char li514[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,102,108,111,111,114,45,113,117,111,116,105,101,110,116,32,120,32,121,41,0,0,0,0,0};
static C_char li515[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,115,113,117,97,114,101,32,110,41,0,0,0,0,0,0,0};
static C_char li516[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,120,97,99,116,45,105,110,116,101,103,101,114,45,110,116,104,45,114,111,111,116,32,107,32,110,41,0,0,0,0,0,0,0};
static C_char li517[] C_aligned={C_lihdr(0,0,10),40,108,112,32,103,48,32,103,49,41,0,0,0,0,0,0};
static C_char li518[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,101,120,97,99,116,45,105,110,116,101,103,101,114,45,110,116,104,45,114,111,111,116,47,108,111,99,32,108,111,99,32,107,32,110,41,0,0,0,0,0,0};
static C_char li519[] C_aligned={C_lihdr(0,0,11),40,108,112,32,114,101,115,32,101,50,41,0,0,0,0,0};
static C_char li520[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,105,110,116,101,103,101,114,45,112,111,119,101,114,32,98,97,115,101,32,101,41,0,0,0,0};
static C_char li521[] C_aligned={C_lihdr(0,0,14),40,108,111,103,45,101,120,112,116,32,97,32,98,41,0,0};
static C_char li522[] C_aligned={C_lihdr(0,0,15),40,115,108,111,119,45,101,120,112,116,32,97,32,98,41,0};
static C_char li523[] C_aligned={C_lihdr(0,0,8),40,97,49,57,55,48,53,41};
static C_char li524[] C_aligned={C_lihdr(0,0,15),40,97,49,57,55,49,55,32,100,115,94,110,32,114,41,0};
static C_char li525[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,101,120,112,116,32,97,32,98,41,0,0,0,0,0,0,0};
static C_char li526[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,105,110,116,101,114,110,97,108,45,103,99,100,32,108,111,99,32,97,32,98,41,0,0,0,0};
static C_char li527[] C_aligned={C_lihdr(0,0,15),40,35,35,115,121,115,35,103,99,100,32,97,32,98,41,0};
static C_char li528[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,104,101,97,100,32,110,101,120,116,41};
static C_char li529[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,103,99,100,32,46,32,110,115,41,0,0,0,0,0,0,0};
static C_char li530[] C_aligned={C_lihdr(0,0,15),40,35,35,115,121,115,35,108,99,109,32,120,32,121,41,0};
static C_char li531[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,104,101,97,100,32,110,101,120,116,41};
static C_char li532[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,108,99,109,32,46,32,110,115,41,0,0,0,0,0,0,0};
static C_char li533[] C_aligned={C_lihdr(0,0,34),67,95,117,95,105,110,116,101,103,101,114,95,113,117,111,116,105,101,110,116,95,97,110,100,95,114,101,109,97,105,110,100,101,114,0,0,0,0,0,0};
static C_char li534[] C_aligned={C_lihdr(0,0,8),40,97,50,48,48,54,56,41};
static C_char li535[] C_aligned={C_lihdr(0,0,22),40,97,50,48,48,55,52,32,104,105,51,52,51,55,32,108,111,51,52,51,57,41,0,0};
static C_char li536[] C_aligned={C_lihdr(0,0,61),40,35,35,115,121,115,35,105,110,116,101,103,101,114,45,62,115,116,114,105,110,103,47,114,101,99,117,114,115,105,118,101,32,110,32,98,97,115,101,32,101,120,112,101,99,116,101,100,45,115,116,114,105,110,103,45,115,105,122,101,41,0,0,0};
static C_char li537[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,101,120,116,101,110,100,101,100,45,110,117,109,98,101,114,45,62,115,116,114,105,110,103,32,110,32,98,97,115,101,41,0,0};
static C_char li538[] C_aligned={C_lihdr(0,0,20),40,114,111,117,110,100,45,113,117,111,116,105,101,110,116,32,110,32,100,41,0,0,0,0};
static C_char li539[] C_aligned={C_lihdr(0,0,13),40,103,111,45,105,110,101,120,97,99,116,33,41,0,0,0};
static C_char li540[] C_aligned={C_lihdr(0,0,23),40,115,97,102,101,45,101,120,112,111,110,101,110,116,32,118,97,108,117,101,32,101,41,0};
static C_char li541[] C_aligned={C_lihdr(0,0,6),40,108,112,32,105,41,0,0};
static C_char li542[] C_aligned={C_lihdr(0,0,19),40,115,99,97,110,45,100,105,103,105,116,115,32,115,116,97,114,116,41,0,0,0,0,0};
static C_char li543[] C_aligned={C_lihdr(0,0,6),40,108,112,32,105,41,0,0};
static C_char li544[] C_aligned={C_lihdr(0,0,19),40,115,99,97,110,45,104,97,115,104,101,115,32,115,116,97,114,116,41,0,0,0,0,0};
static C_char li545[] C_aligned={C_lihdr(0,0,46),40,115,99,97,110,45,100,105,103,105,116,115,43,104,97,115,104,101,115,32,115,116,97,114,116,32,110,101,103,63,32,97,108,108,45,104,97,115,104,101,115,45,111,107,63,41,0,0};
static C_char li546[] C_aligned={C_lihdr(0,0,21),40,115,99,97,110,45,101,120,112,111,110,101,110,116,32,115,116,97,114,116,41,0,0,0};
static C_char li547[] C_aligned={C_lihdr(0,0,43),40,115,99,97,110,45,100,101,99,105,109,97,108,45,116,97,105,108,32,115,116,97,114,116,32,110,101,103,63,32,100,101,99,105,109,97,108,45,104,101,97,100,41,0,0,0,0,0};
static C_char li548[] C_aligned={C_lihdr(0,0,23),40,115,99,97,110,45,117,114,101,97,108,32,115,116,97,114,116,32,110,101,103,63,41,0};
static C_char li549[] C_aligned={C_lihdr(0,0,17),40,115,99,97,110,45,114,101,97,108,32,115,116,97,114,116,41,0,0,0,0,0,0,0};
static C_char li550[] C_aligned={C_lihdr(0,0,50),40,35,35,115,121,115,35,115,116,114,105,110,103,45,62,99,111,109,112,110,117,109,32,114,97,100,105,120,32,115,116,114,32,111,102,102,115,101,116,32,101,120,97,99,116,110,101,115,115,41,0,0,0,0,0,0};
static C_char li551[] C_aligned={C_lihdr(0,0,32),40,115,99,97,110,45,112,114,101,102,105,120,32,105,32,101,120,110,101,115,115,32,114,97,100,105,120,32,108,101,110,41};
static C_char li552[] C_aligned={C_lihdr(0,0,34),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,62,110,117,109,98,101,114,32,115,116,114,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char li553[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,115,116,114,105,110,103,45,62,110,117,109,98,101,114,32,115,116,114,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char li554[] C_aligned={C_lihdr(0,0,18),67,95,102,105,120,110,117,109,95,116,111,95,115,116,114,105,110,103,0,0,0,0,0,0};
static C_char li555[] C_aligned={C_lihdr(0,0,18),67,95,102,108,111,110,117,109,95,116,111,95,115,116,114,105,110,103,0,0,0,0,0,0};
static C_char li556[] C_aligned={C_lihdr(0,0,19),67,95,105,110,116,101,103,101,114,95,116,111,95,115,116,114,105,110,103,0,0,0,0,0};
static C_char li557[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li558[] C_aligned={C_lihdr(0,0,25),40,99,111,109,112,97,114,101,45,115,108,111,116,115,32,120,32,121,32,115,116,97,114,116,41,0,0,0,0,0,0,0};
static C_char li559[] C_aligned={C_lihdr(0,0,10),40,119,97,108,107,32,120,32,121,41,0,0,0,0,0,0};
static C_char li560[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,98,97,115,101,35,101,113,117,97,108,61,63,32,120,32,121,41,0,0,0,0,0,0};
static C_char li561[] C_aligned={C_lihdr(0,0,18),67,95,115,116,114,105,110,103,95,116,111,95,115,121,109,98,111,108,0,0,0,0,0,0};
static C_char li562[] C_aligned={C_lihdr(0,0,19),67,95,115,116,114,105,110,103,95,116,111,95,107,101,121,119,111,114,100,0,0,0,0,0};
static C_char li563[] C_aligned={C_lihdr(0,0,13),67,95,109,97,107,101,95,115,121,109,98,111,108,0,0,0};
static C_char li564[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,105,110,116,101,114,110,101,100,45,115,121,109,98,111,108,63,32,120,41,0,0,0,0,0,0};
static C_char li565[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,115,116,114,105,110,103,45,62,115,121,109,98,111,108,45,110,97,109,101,32,115,41,0,0,0};
static C_char li566[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,115,121,109,98,111,108,45,62,115,116,114,105,110,103,47,115,104,97,114,101,100,32,115,41,0};
static C_char li567[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,115,121,109,98,111,108,45,62,115,116,114,105,110,103,32,115,41};
static C_char li568[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,115,116,114,105,110,103,45,62,115,121,109,98,111,108,32,115,116,114,41,0,0,0,0,0,0};
static C_char li569[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,115,121,109,98,111,108,45,62,115,116,114,105,110,103,32,115,41,0,0,0,0,0,0,0};
static C_char li570[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,62,115,121,109,98,111,108,32,115,116,114,41,0,0,0,0,0};
static C_char li571[] C_aligned={C_lihdr(0,0,44),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,116,114,105,110,103,45,62,117,110,105,110,116,101,114,110,101,100,45,115,121,109,98,111,108,32,115,116,114,41,0,0,0,0};
static C_char li572[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,97,115,101,35,103,101,110,115,121,109,32,46,32,115,116,114,45,111,114,45,115,121,109,41,0,0,0,0,0,0};
static C_char li573[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,51,57,57,54,32,103,52,48,48,56,41,0,0,0,0};
static C_char li574[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,121,109,98,111,108,45,97,112,112,101,110,100,32,46,32,115,115,41,0,0,0,0,0,0,0};
static C_char li575[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,107,101,121,119,111,114,100,35,107,101,121,119,111,114,100,63,32,120,41,0,0,0,0};
static C_char li576[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,107,101,121,119,111,114,100,35,115,116,114,105,110,103,45,62,107,101,121,119,111,114,100,32,115,41,0,0,0,0,0};
static C_char li577[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,107,101,121,119,111,114,100,35,107,101,121,119,111,114,100,45,62,115,116,114,105,110,103,32,107,119,41,0,0,0,0};
static C_char li578[] C_aligned={C_lihdr(0,0,45),40,99,104,105,99,107,101,110,46,107,101,121,119,111,114,100,35,103,101,116,45,107,101,121,119,111,114,100,32,107,101,121,32,97,114,103,115,32,46,32,114,101,115,116,41,0,0,0};
static C_char li579[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,105,32,108,115,116,41,0,0,0,0};
static C_char li580[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,98,121,116,101,118,101,99,116,111,114,45,62,108,105,115,116,32,118,41,0,0,0,0,0,0};
static C_char li581[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,108,115,116,32,105,41,0,0,0,0};
static C_char li582[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,108,105,115,116,45,62,98,121,116,101,118,101,99,116,111,114,32,108,115,116,48,41,0,0,0};
static C_char li583[] C_aligned={C_lihdr(0,0,48),40,99,104,105,99,107,101,110,46,98,121,116,101,118,101,99,116,111,114,35,109,97,107,101,45,98,121,116,101,118,101,99,116,111,114,32,115,105,122,101,32,46,32,114,101,115,116,41};
static C_char li584[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,121,116,101,118,101,99,116,111,114,35,98,121,116,101,118,101,99,116,111,114,63,32,120,41,0,0,0,0,0,0};
static C_char li585[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,98,121,116,101,118,101,99,116,111,114,35,98,121,116,101,118,101,99,116,111,114,45,108,101,110,103,116,104,32,98,118,41,0,0,0,0,0,0,0};
static C_char li586[] C_aligned={C_lihdr(0,0,43),40,99,104,105,99,107,101,110,46,98,121,116,101,118,101,99,116,111,114,35,98,121,116,101,118,101,99,116,111,114,45,117,56,45,114,101,102,32,98,118,32,105,41,0,0,0,0,0};
static C_char li587[] C_aligned={C_lihdr(0,0,46),40,99,104,105,99,107,101,110,46,98,121,116,101,118,101,99,116,111,114,35,98,121,116,101,118,101,99,116,111,114,45,117,56,45,115,101,116,33,32,98,118,32,105,32,98,41,0,0};
static C_char li588[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,98,121,116,101,118,101,99,116,111,114,35,115,116,114,105,110,103,45,62,117,116,102,56,32,115,41,0,0,0,0,0};
static C_char li589[] C_aligned={C_lihdr(0,0,43),40,99,104,105,99,107,101,110,46,98,121,116,101,118,101,99,116,111,114,35,117,116,102,56,45,62,115,116,114,105,110,103,32,98,118,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li590[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,98,121,116,101,118,101,99,116,111,114,35,115,116,114,105,110,103,45,62,108,97,116,105,110,49,32,115,41,0,0,0};
static C_char li591[] C_aligned={C_lihdr(0,0,38),40,99,104,105,99,107,101,110,46,98,121,116,101,118,101,99,116,111,114,35,108,97,116,105,110,49,45,62,115,116,114,105,110,103,32,98,118,41,0,0};
static C_char li592[] C_aligned={C_lihdr(0,0,39),40,99,104,105,99,107,101,110,46,98,121,116,101,118,101,99,116,111,114,35,98,121,116,101,118,101,99,116,111,114,61,63,32,98,49,32,98,50,41,0};
static C_char li593[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li594[] C_aligned={C_lihdr(0,0,38),40,99,104,105,99,107,101,110,46,98,121,116,101,118,101,99,116,111,114,35,98,121,116,101,118,101,99,116,111,114,32,46,32,97,114,103,115,41,0,0};
static C_char li595[] C_aligned={C_lihdr(0,0,46),40,99,104,105,99,107,101,110,46,98,121,116,101,118,101,99,116,111,114,35,98,121,116,101,118,101,99,116,111,114,45,99,111,112,121,32,98,118,32,46,32,114,101,115,116,41,0,0};
static C_char li596[] C_aligned={C_lihdr(0,0,55),40,99,104,105,99,107,101,110,46,98,121,116,101,118,101,99,116,111,114,35,98,121,116,101,118,101,99,116,111,114,45,99,111,112,121,33,32,98,118,49,32,97,116,32,98,118,50,32,46,32,114,101,115,116,41,0};
static C_char li597[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li598[] C_aligned={C_lihdr(0,0,14),40,108,111,111,112,32,108,115,116,32,108,101,110,41,0,0};
static C_char li599[] C_aligned={C_lihdr(0,0,44),40,99,104,105,99,107,101,110,46,98,121,116,101,118,101,99,116,111,114,35,98,121,116,101,118,101,99,116,111,114,45,97,112,112,101,110,100,32,46,32,98,118,115,41,0,0,0,0};
static C_char li600[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,109,97,107,101,45,118,101,99,116,111,114,32,115,105,122,101,32,46,32,102,105,108,108,41};
static C_char li601[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li602[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,108,105,115,116,45,62,118,101,99,116,111,114,32,108,115,116,48,41,0,0,0,0,0,0};
static C_char li603[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li604[] C_aligned={C_lihdr(0,0,30),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,62,108,105,115,116,32,118,32,46,32,114,101,115,116,41,0,0};
static C_char li605[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,118,101,99,116,111,114,32,46,32,120,115,41,0,0,0,0};
static C_char li606[] C_aligned={C_lihdr(0,0,12),40,100,111,108,111,111,112,52,51,51,52,41,0,0,0,0};
static C_char li607[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,102,105,108,108,33,32,118,32,120,32,46,32,114,101,115,116,41};
static C_char li608[] C_aligned={C_lihdr(0,0,15),40,100,111,108,111,111,112,52,51,54,53,32,102,105,41,0};
static C_char li609[] C_aligned={C_lihdr(0,0,18),40,99,111,112,121,32,118,32,115,116,97,114,116,32,101,110,100,41,0,0,0,0,0,0};
static C_char li610[] C_aligned={C_lihdr(0,0,29),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,99,111,112,121,32,118,32,46,32,114,101,115,116,41,0,0,0};
static C_char li611[] C_aligned={C_lihdr(0,0,15),40,100,111,108,111,111,112,52,52,48,54,32,116,105,41,0};
static C_char li612[] C_aligned={C_lihdr(0,0,15),40,100,111,108,111,111,112,52,52,49,50,32,116,105,41,0};
static C_char li613[] C_aligned={C_lihdr(0,0,28),40,99,111,112,121,33,32,116,111,32,97,116,32,102,114,111,109,32,115,116,97,114,116,32,101,110,100,41,0,0,0,0};
static C_char li614[] C_aligned={C_lihdr(0,0,39),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,99,111,112,121,33,32,116,111,32,97,116,32,102,114,111,109,32,46,32,114,101,115,116,41,0};
static C_char li615[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,52,52,51,49,41,0,0,0,0,0};
static C_char li616[] C_aligned={C_lihdr(0,0,22),40,100,111,108,111,111,112,52,52,57,56,32,118,115,32,108,101,110,115,32,105,41,0,0};
static C_char li617[] C_aligned={C_lihdr(0,0,17),40,102,111,108,100,108,52,52,56,56,32,103,52,52,56,55,41,0,0,0,0,0,0,0};
static C_char li618[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,52,52,53,55,32,103,52,52,54,57,41,0,0,0,0};
static C_char li619[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,97,112,112,101,110,100,32,46,32,118,115,41,0,0,0,0,0};
static C_char li620[] C_aligned={C_lihdr(0,0,12),40,100,111,108,111,111,112,52,53,50,53,41,0,0,0,0};
static C_char li621[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,117,98,118,101,99,116,111,114,32,118,32,105,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li622[] C_aligned={C_lihdr(0,0,39),40,99,104,105,99,107,101,110,46,98,97,115,101,35,118,101,99,116,111,114,45,114,101,115,105,122,101,32,118,32,110,32,46,32,114,101,115,116,41,0};
static C_char li623[] C_aligned={C_lihdr(0,0,12),40,100,111,108,111,111,112,52,53,53,51,41,0,0,0,0};
static C_char li624[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,118,101,99,116,111,114,45,114,101,115,105,122,101,32,118,32,110,32,105,110,105,116,41,0,0};
static C_char li625[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,99,32,99,115,32,102,41,0,0,0};
static C_char li626[] C_aligned={C_lihdr(0,0,29),40,115,99,104,101,109,101,35,99,104,97,114,45,99,105,61,63,32,120,32,121,32,46,32,109,111,114,101,41,0,0,0};
static C_char li627[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,99,32,99,115,32,102,41,0,0,0};
static C_char li628[] C_aligned={C_lihdr(0,0,29),40,115,99,104,101,109,101,35,99,104,97,114,45,99,105,62,63,32,120,32,121,32,46,32,109,111,114,101,41,0,0,0};
static C_char li629[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,99,32,99,115,32,102,41,0,0,0};
static C_char li630[] C_aligned={C_lihdr(0,0,29),40,115,99,104,101,109,101,35,99,104,97,114,45,99,105,60,63,32,120,32,121,32,46,32,109,111,114,101,41,0,0,0};
static C_char li631[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,99,32,99,115,32,102,41,0,0,0};
static C_char li632[] C_aligned={C_lihdr(0,0,30),40,115,99,104,101,109,101,35,99,104,97,114,45,99,105,62,61,63,32,120,32,121,32,46,32,109,111,114,101,41,0,0};
static C_char li633[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,99,32,99,115,32,102,41,0,0,0};
static C_char li634[] C_aligned={C_lihdr(0,0,30),40,115,99,104,101,109,101,35,99,104,97,114,45,99,105,60,61,63,32,120,32,121,32,46,32,109,111,114,101,41,0,0};
static C_char li635[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char li636[] C_aligned={C_lihdr(0,0,15),40,108,111,111,107,117,112,45,99,104,97,114,32,99,41,0};
static C_char li637[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,104,97,114,45,110,97,109,101,32,120,32,46,32,121,41,0,0};
static C_char li638[] C_aligned={C_lihdr(0,0,9),67,95,99,97,108,108,95,99,99,0,0,0,0,0,0,0};
static C_char li639[] C_aligned={C_lihdr(0,0,19),67,95,99,97,108,108,95,119,105,116,104,95,99,116,104,117,108,104,117,0,0,0,0,0};
static C_char li640[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char li641[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,102,111,114,45,101,97,99,104,32,112,32,108,115,116,48,41,0};
static C_char li642[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char li643[] C_aligned={C_lihdr(0,0,18),40,35,35,115,121,115,35,109,97,112,32,112,32,108,115,116,48,41,0,0,0,0,0,0};
static C_char li644[] C_aligned={C_lihdr(0,0,9),40,108,112,32,108,115,116,115,41,0,0,0,0,0,0,0};
static C_char li645[] C_aligned={C_lihdr(0,0,14),40,97,50,52,50,52,50,32,101,109,112,116,121,41,0,0};
static C_char li646[] C_aligned={C_lihdr(0,0,24),40,109,97,112,115,97,102,101,52,54,57,57,32,112,32,108,115,116,115,32,108,111,99,41};
static C_char li647[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,52,55,49,57,32,103,52,55,50,54,41,0,0,0,0,0,0,0};
static C_char li648[] C_aligned={C_lihdr(0,0,10),40,97,50,52,51,54,52,32,120,41,0,0,0,0,0,0};
static C_char li649[] C_aligned={C_lihdr(0,0,10),40,97,50,52,51,55,48,32,120,41,0,0,0,0,0,0};
static C_char li650[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,97,108,108,41,0,0,0,0,0,0};
static C_char li651[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,102,111,114,45,101,97,99,104,32,102,110,32,108,115,116,49,32,46,32,108,115,116,115,41};
static C_char li652[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,52,55,52,55,32,103,52,55,53,57,41,0,0,0,0};
static C_char li653[] C_aligned={C_lihdr(0,0,10),40,97,50,52,52,54,53,32,120,41,0,0,0,0,0,0};
static C_char li654[] C_aligned={C_lihdr(0,0,10),40,97,50,52,52,55,49,32,120,41,0,0,0,0,0,0};
static C_char li655[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,97,108,108,41,0,0,0,0,0,0};
static C_char li656[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,109,97,112,32,102,110,32,108,115,116,49,32,46,32,108,115,116,115,41,0,0,0,0,0};
static C_char li657[] C_aligned={C_lihdr(0,0,18),40,97,50,52,52,57,49,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0};
static C_char li658[] C_aligned={C_lihdr(0,0,40),40,115,99,104,101,109,101,35,100,121,110,97,109,105,99,45,119,105,110,100,32,98,101,102,111,114,101,32,116,104,117,110,107,32,97,102,116,101,114,41};
static C_char li659[] C_aligned={C_lihdr(0,0,24),40,99,111,110,116,105,110,117,97,116,105,111,110,32,46,32,114,101,115,117,108,116,115,41};
static C_char li660[] C_aligned={C_lihdr(0,0,13),40,97,50,52,53,49,53,32,99,111,110,116,41,0,0,0};
static C_char li661[] C_aligned={C_lihdr(0,0,44),40,115,99,104,101,109,101,35,99,97,108,108,45,119,105,116,104,45,99,117,114,114,101,110,116,45,99,111,110,116,105,110,117,97,116,105,111,110,32,112,114,111,99,41,0,0,0,0};
static C_char li662[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,100,121,110,97,109,105,99,45,117,110,119,105,110,100,32,119,105,110,100,115,32,110,41,0,0};
static C_char li663[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,111,114,116,45,99,108,111,115,101,100,63,32,112,41,0,0,0};
static C_char li664[] C_aligned={C_lihdr(0,0,37),40,35,35,115,121,115,35,109,97,107,101,45,112,111,114,116,32,105,47,111,32,99,108,97,115,115,32,110,97,109,101,32,116,121,112,101,41,0,0,0};
static C_char li665[] C_aligned={C_lihdr(0,0,22),40,97,52,49,54,57,52,32,98,117,102,32,115,116,97,114,116,32,108,101,110,41,0,0};
static C_char li666[] C_aligned={C_lihdr(0,0,26),40,97,52,49,54,56,56,32,98,117,102,32,115,116,97,114,116,32,108,101,110,32,100,101,99,41,0,0,0,0,0,0};
static C_char li667[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char li668[] C_aligned={C_lihdr(0,0,10),40,97,52,49,54,50,48,32,112,41,0,0,0,0,0,0};
static C_char li669[] C_aligned={C_lihdr(0,0,20),40,97,52,49,55,51,49,32,98,117,102,32,115,116,97,114,116,32,95,41,0,0,0,0};
static C_char li670[] C_aligned={C_lihdr(0,0,26),40,97,52,49,55,49,57,32,98,117,102,32,115,116,97,114,116,32,108,101,110,32,100,101,99,41,0,0,0,0,0,0};
static C_char li671[] C_aligned={C_lihdr(0,0,10),40,97,52,49,55,48,49,32,112,41,0,0,0,0,0,0};
static C_char li672[] C_aligned={C_lihdr(0,0,12),40,97,52,49,55,51,52,32,112,32,99,41,0,0,0,0};
static C_char li673[] C_aligned={C_lihdr(0,0,21),40,97,52,49,55,55,54,32,98,118,32,115,116,97,114,116,32,108,101,110,41,0,0,0};
static C_char li674[] C_aligned={C_lihdr(0,0,21),40,97,52,49,55,54,50,32,112,32,98,118,32,102,114,111,109,32,116,111,41,0,0,0};
static C_char li675[] C_aligned={C_lihdr(0,0,12),40,97,52,49,55,55,57,32,112,32,100,41,0,0,0,0};
static C_char li676[] C_aligned={C_lihdr(0,0,10),40,97,52,49,55,56,53,32,112,41,0,0,0,0,0,0};
static C_char li677[] C_aligned={C_lihdr(0,0,10),40,97,52,49,55,56,56,32,112,41,0,0,0,0,0,0};
static C_char li678[] C_aligned={C_lihdr(0,0,8),40,97,52,49,56,51,52,41};
static C_char li679[] C_aligned={C_lihdr(0,0,20),40,108,111,111,112,32,114,101,109,32,97,99,116,32,115,116,97,114,116,41,0,0,0,0};
static C_char li680[] C_aligned={C_lihdr(0,0,23),40,97,52,49,55,57,49,32,112,32,110,32,100,101,115,116,32,115,116,97,114,116,41,0};
static C_char li681[] C_aligned={C_lihdr(0,0,8),40,97,52,49,57,57,57,41};
static C_char li682[] C_aligned={C_lihdr(0,0,32),40,108,111,111,112,32,108,101,110,32,108,105,109,105,116,32,98,117,102,102,101,114,32,114,101,115,117,108,116,32,102,41};
static C_char li683[] C_aligned={C_lihdr(0,0,17),40,97,52,49,56,57,56,32,112,32,114,108,105,109,105,116,41,0,0,0,0,0,0,0};
static C_char li684[] C_aligned={C_lihdr(0,0,16),67,95,111,112,101,110,95,102,105,108,101,95,112,111,114,116};
static C_char li685[] C_aligned={C_lihdr(0,0,37),40,35,35,115,121,115,35,99,104,101,99,107,45,105,110,112,117,116,45,112,111,114,116,32,120,32,111,112,101,110,32,46,32,108,111,99,41,0,0,0};
static C_char li686[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,99,104,101,99,107,45,111,117,116,112,117,116,45,112,111,114,116,32,120,32,111,112,101,110,32,46,32,108,111,99,41,0,0};
static C_char li687[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,99,104,101,99,107,45,112,111,114,116,32,120,32,46,32,108,111,99,41,0,0,0,0,0,0};
static C_char li688[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,99,104,101,99,107,45,111,112,101,110,45,112,111,114,116,32,120,32,46,32,108,111,99,41,0};
static C_char li689[] C_aligned={C_lihdr(0,0,10),40,98,111,100,121,52,57,54,49,41,0,0,0,0,0,0};
static C_char li690[] C_aligned={C_lihdr(0,0,34),40,115,99,104,101,109,101,35,99,117,114,114,101,110,116,45,105,110,112,117,116,45,112,111,114,116,32,46,32,97,114,103,115,41,0,0,0,0,0,0};
static C_char li691[] C_aligned={C_lihdr(0,0,10),40,98,111,100,121,52,57,56,54,41,0,0,0,0,0,0};
static C_char li692[] C_aligned={C_lihdr(0,0,35),40,115,99,104,101,109,101,35,99,117,114,114,101,110,116,45,111,117,116,112,117,116,45,112,111,114,116,32,46,32,97,114,103,115,41,0,0,0,0,0};
static C_char li693[] C_aligned={C_lihdr(0,0,10),40,98,111,100,121,53,48,49,49,41,0,0,0,0,0,0};
static C_char li694[] C_aligned={C_lihdr(0,0,40),40,99,104,105,99,107,101,110,46,98,97,115,101,35,99,117,114,114,101,110,116,45,101,114,114,111,114,45,112,111,114,116,32,46,32,97,114,103,115,41};
static C_char li695[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,116,116,121,45,112,111,114,116,63,32,112,111,114,116,41,0,0};
static C_char li696[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,112,111,114,116,45,100,97,116,97,32,112,111,114,116,41,0,0};
static C_char li697[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,115,101,116,45,112,111,114,116,45,100,97,116,97,33,32,112,111,114,116,32,100,97,116,97,41};
static C_char li698[] C_aligned={C_lihdr(0,0,18),40,100,111,108,111,111,112,53,48,53,48,32,109,111,100,101,115,41,0,0,0,0,0,0};
static C_char li699[] C_aligned={C_lihdr(0,0,25),40,111,112,101,110,32,110,97,109,101,32,105,110,112,32,109,111,100,101,115,32,108,111,99,41,0,0,0,0,0,0,0};
static C_char li700[] C_aligned={C_lihdr(0,0,20),40,99,108,111,115,101,32,112,111,114,116,32,105,110,112,32,108,111,99,41,0,0,0,0};
static C_char li701[] C_aligned={C_lihdr(0,0,36),40,115,99,104,101,109,101,35,111,112,101,110,45,105,110,112,117,116,45,102,105,108,101,32,110,97,109,101,32,46,32,109,111,100,101,41,0,0,0,0};
static C_char li702[] C_aligned={C_lihdr(0,0,37),40,115,99,104,101,109,101,35,111,112,101,110,45,111,117,116,112,117,116,45,102,105,108,101,32,110,97,109,101,32,46,32,109,111,100,101,41,0,0,0};
static C_char li703[] C_aligned={C_lihdr(0,0,30),40,115,99,104,101,109,101,35,99,108,111,115,101,45,105,110,112,117,116,45,112,111,114,116,32,112,111,114,116,41,0,0};
static C_char li704[] C_aligned={C_lihdr(0,0,31),40,115,99,104,101,109,101,35,99,108,111,115,101,45,111,117,116,112,117,116,45,112,111,114,116,32,112,111,114,116,41,0};
static C_char li705[] C_aligned={C_lihdr(0,0,8),40,97,50,53,50,51,57,41};
static C_char li706[] C_aligned={C_lihdr(0,0,18),40,97,50,53,50,52,53,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0};
static C_char li707[] C_aligned={C_lihdr(0,0,43),40,115,99,104,101,109,101,35,99,97,108,108,45,119,105,116,104,45,105,110,112,117,116,45,102,105,108,101,32,110,97,109,101,32,112,32,46,32,109,111,100,101,41,0,0,0,0,0};
static C_char li708[] C_aligned={C_lihdr(0,0,8),40,97,50,53,50,54,51,41};
static C_char li709[] C_aligned={C_lihdr(0,0,18),40,97,50,53,50,54,57,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0};
static C_char li710[] C_aligned={C_lihdr(0,0,44),40,115,99,104,101,109,101,35,99,97,108,108,45,119,105,116,104,45,111,117,116,112,117,116,45,102,105,108,101,32,110,97,109,101,32,112,32,46,32,109,111,100,101,41,0,0,0,0};
static C_char li711[] C_aligned={C_lihdr(0,0,8),40,97,50,53,50,56,55,41};
static C_char li712[] C_aligned={C_lihdr(0,0,18),40,97,50,53,50,57,56,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0};
static C_char li713[] C_aligned={C_lihdr(0,0,8),40,97,50,53,50,57,50,41};
static C_char li714[] C_aligned={C_lihdr(0,0,8),40,97,50,53,51,48,55,41};
static C_char li715[] C_aligned={C_lihdr(0,0,46),40,115,99,104,101,109,101,35,119,105,116,104,45,105,110,112,117,116,45,102,114,111,109,45,102,105,108,101,32,115,116,114,32,116,104,117,110,107,32,46,32,109,111,100,101,41,0,0};
static C_char li716[] C_aligned={C_lihdr(0,0,8),40,97,50,53,51,50,49,41};
static C_char li717[] C_aligned={C_lihdr(0,0,18),40,97,50,53,51,51,50,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0};
static C_char li718[] C_aligned={C_lihdr(0,0,8),40,97,50,53,51,50,54,41};
static C_char li719[] C_aligned={C_lihdr(0,0,8),40,97,50,53,51,52,49,41};
static C_char li720[] C_aligned={C_lihdr(0,0,45),40,115,99,104,101,109,101,35,119,105,116,104,45,111,117,116,112,117,116,45,116,111,45,102,105,108,101,32,115,116,114,32,116,104,117,110,107,32,46,32,109,111,100,101,41,0,0,0};
static C_char li721[] C_aligned={C_lihdr(0,0,40),40,35,35,115,121,115,35,102,105,108,101,45,101,120,105,115,116,115,63,32,110,97,109,101,32,102,105,108,101,63,32,100,105,114,63,32,108,111,99,41};
static C_char li722[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,102,108,117,115,104,45,111,117,116,112,117,116,32,112,111,114,116,41,0,0,0,0,0,0,0};
static C_char li723[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,97,115,101,35,102,108,117,115,104,45,111,117,116,112,117,116,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char li724[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,112,111,114,116,45,108,105,110,101,32,112,111,114,116,41,0,0};
static C_char li725[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,53,50,49,52,32,105,41,0,0};
static C_char li726[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li727[] C_aligned={C_lihdr(0,0,43),40,35,35,115,121,115,35,100,101,99,111,114,97,116,101,45,108,97,109,98,100,97,32,112,114,111,99,32,112,114,101,100,32,100,101,99,111,114,97,116,111,114,41,0,0,0,0,0};
static C_char li728[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li729[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,108,97,109,98,100,97,45,100,101,99,111,114,97,116,105,111,110,32,112,114,111,99,32,112,114,101,100,41,0,0,0,0,0};
static C_char li730[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,109,97,107,101,45,108,97,109,98,100,97,45,105,110,102,111,32,115,116,114,41,0,0,0,0};
static C_char li731[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,108,97,109,98,100,97,45,105,110,102,111,63,32,120,41,0,0};
static C_char li732[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,108,97,109,98,100,97,45,105,110,102,111,32,112,114,111,99,41};
static C_char li733[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,108,97,109,98,100,97,45,105,110,102,111,45,62,115,116,114,105,110,103,32,105,110,102,111,41};
static C_char li734[] C_aligned={C_lihdr(0,0,38),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,114,111,99,101,100,117,114,101,45,105,110,102,111,114,109,97,116,105,111,110,32,120,41,0,0};
static C_char li735[] C_aligned={C_lihdr(0,0,12),40,97,50,53,54,51,49,32,112,32,105,41,0,0,0,0};
static C_char li736[] C_aligned={C_lihdr(0,0,10),40,97,50,53,54,52,49,32,120,41,0,0,0,0,0,0};
static C_char li737[] C_aligned={C_lihdr(0,0,15),40,97,50,53,54,53,55,32,112,114,111,99,32,105,41,0};
static C_char li738[] C_aligned={C_lihdr(0,0,48),40,99,104,105,99,107,101,110,46,98,97,115,101,35,103,101,116,116,101,114,45,119,105,116,104,45,115,101,116,116,101,114,32,103,101,116,32,115,101,116,32,46,32,114,101,115,116,41};
static C_char li739[] C_aligned={C_lihdr(0,0,11),40,102,95,50,53,57,49,56,32,120,41,0,0,0,0,0};
static C_char li740[] C_aligned={C_lihdr(0,0,28),40,97,115,115,105,103,110,32,118,97,108,32,110,32,99,111,110,118,101,114,116,63,32,115,101,116,63,41,0,0,0,0};
static C_char li741[] C_aligned={C_lihdr(0,0,24),40,98,111,100,121,53,51,54,54,32,99,111,110,118,101,114,116,63,32,115,101,116,63,41};
static C_char li742[] C_aligned={C_lihdr(0,0,24),40,100,101,102,45,115,101,116,63,53,51,54,57,32,37,99,111,110,118,101,114,116,63,41};
static C_char li743[] C_aligned={C_lihdr(0,0,18),40,100,101,102,45,99,111,110,118,101,114,116,63,53,51,54,56,41,0,0,0,0,0,0};
static C_char li744[] C_aligned={C_lihdr(0,0,15),40,97,50,53,56,48,57,32,46,32,97,114,103,115,41,0};
static C_char li745[] C_aligned={C_lihdr(0,0,12),40,97,50,53,56,57,49,32,118,97,108,41,0,0,0,0};
static C_char li746[] C_aligned={C_lihdr(0,0,35),40,115,99,104,101,109,101,35,109,97,107,101,45,112,97,114,97,109,101,116,101,114,32,105,110,105,116,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li747[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,99,104,97,114,45,114,101,97,100,121,63,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li748[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,114,101,97,100,45,99,104,97,114,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char li749[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,114,101,97,100,45,99,104,97,114,45,48,32,112,41,0,0,0};
static C_char li750[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,114,101,97,100,45,99,104,97,114,47,112,111,114,116,32,112,111,114,116,41,0,0,0,0,0};
static C_char li751[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,112,101,101,107,45,99,104,97,114,45,48,32,112,41,0,0,0};
static C_char li752[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,112,101,101,107,45,99,104,97,114,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char li753[] C_aligned={C_lihdr(0,0,20),40,115,99,104,101,109,101,35,114,101,97,100,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char li754[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,114,101,97,100,45,112,114,111,109,112,116,45,104,111,111,107,41};
static C_char li755[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,105,110,102,105,120,45,108,105,115,116,45,104,111,111,107,32,108,115,116,41,0,0,0,0,0};
static C_char li756[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,115,104,97,114,112,45,110,117,109,98,101,114,45,104,111,111,107,32,112,111,114,116,32,110,41};
static C_char li757[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,114,101,97,100,45,119,97,114,110,105,110,103,32,112,111,114,116,32,109,115,103,32,46,32,97,114,103,115,41,0,0,0,0};
static C_char li758[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,114,101,97,100,45,101,114,114,111,114,32,112,111,114,116,32,109,115,103,32,46,32,97,114,103,115,41,0,0,0,0,0,0};
static C_char li759[] C_aligned={C_lihdr(0,0,11),40,102,95,50,54,49,57,57,32,99,41,0,0,0,0,0};
static C_char li760[] C_aligned={C_lihdr(0,0,21),40,105,110,102,111,32,99,108,97,115,115,32,100,97,116,97,32,118,97,108,41,0,0,0};
static C_char li761[] C_aligned={C_lihdr(0,0,8),40,115,107,105,112,32,99,41};
static C_char li762[] C_aligned={C_lihdr(0,0,13),40,115,107,105,112,45,116,111,45,101,111,108,41,0,0,0};
static C_char li763[] C_aligned={C_lihdr(0,0,22),40,114,101,115,101,114,118,101,100,45,99,104,97,114,97,99,116,101,114,32,99,41,0,0};
static C_char li764[] C_aligned={C_lihdr(0,0,29),40,114,101,97,100,45,117,110,114,101,115,101,114,118,101,100,45,99,104,97,114,45,48,32,112,111,114,116,41,0,0,0};
static C_char li765[] C_aligned={C_lihdr(0,0,24),40,114,101,103,105,115,116,101,114,45,115,104,97,114,101,100,33,32,116,104,117,110,107,41};
static C_char li766[] C_aligned={C_lihdr(0,0,16),40,117,110,116,104,117,110,107,32,111,32,102,97,105,108,41};
static C_char li767[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,53,53,52,50,32,105,41,0,0};
static C_char li768[] C_aligned={C_lihdr(0,0,9),40,108,111,111,112,33,32,111,41,0,0,0,0,0,0,0};
static C_char li769[] C_aligned={C_lihdr(0,0,20),40,117,110,116,104,117,110,107,105,102,121,33,32,111,32,102,97,105,108,41,0,0,0,0};
static C_char li770[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,99,41};
static C_char li771[] C_aligned={C_lihdr(0,0,10),40,114,45,115,112,97,99,101,115,41,0,0,0,0,0,0};
static C_char li772[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,115,101,113,32,110,41,0,0,0,0};
static C_char li773[] C_aligned={C_lihdr(0,0,22),40,114,45,117,115,101,113,117,101,110,99,101,32,117,32,110,32,98,97,115,101,41,0,0};
static C_char li774[] C_aligned={C_lihdr(0,0,11),40,112,97,114,115,101,32,115,101,113,41,0,0,0,0,0};
static C_char li775[] C_aligned={C_lihdr(0,0,7),40,97,98,111,114,116,41,0};
static C_char li776[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,115,101,113,41,0,0,0,0,0,0};
static C_char li777[] C_aligned={C_lihdr(0,0,19),40,114,45,120,115,101,113,117,101,110,99,101,32,100,101,108,105,109,41,0,0,0,0,0};
static C_char li778[] C_aligned={C_lihdr(0,0,14),40,101,97,116,45,119,115,32,99,32,110,108,63,41,0,0};
static C_char li779[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,99,32,108,115,116,41,0,0,0,0};
static C_char li780[] C_aligned={C_lihdr(0,0,15),40,114,45,115,116,114,105,110,103,32,116,101,114,109,41,0};
static C_char li781[] C_aligned={C_lihdr(0,0,19),40,115,116,97,114,116,105,110,103,45,108,105,110,101,32,109,115,103,41,0,0,0,0,0};
static C_char li782[] C_aligned={C_lihdr(0,0,11),40,102,95,50,55,50,50,54,32,99,41,0,0,0,0,0};
static C_char li783[] C_aligned={C_lihdr(0,0,15),40,97,50,55,51,52,49,32,116,111,107,32,107,119,41,0};
static C_char li784[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,108,97,115,116,41,0,0,0,0,0};
static C_char li785[] C_aligned={C_lihdr(0,0,15),40,97,50,55,50,50,50,32,114,101,116,117,114,110,41,0};
static C_char li786[] C_aligned={C_lihdr(0,0,18),40,114,45,108,105,115,116,32,115,116,97,114,116,32,101,110,100,41,0,0,0,0,0,0};
static C_char li787[] C_aligned={C_lihdr(0,0,10),40,114,45,118,101,99,116,111,114,41,0,0,0,0,0,0};
static C_char li788[] C_aligned={C_lihdr(0,0,15),40,97,50,55,52,54,56,32,116,111,107,32,107,119,41,0};
static C_char li789[] C_aligned={C_lihdr(0,0,26),40,114,45,110,117,109,98,101,114,32,114,97,100,105,120,32,101,120,97,99,116,110,101,115,115,41,0,0,0,0,0,0};
static C_char li790[] C_aligned={C_lihdr(0,0,31),40,114,45,110,117,109,98,101,114,45,119,105,116,104,45,101,120,97,99,116,110,101,115,115,32,114,97,100,105,120,41,0};
static C_char li791[] C_aligned={C_lihdr(0,0,31),40,114,45,110,117,109,98,101,114,45,119,105,116,104,45,114,97,100,105,120,32,101,120,97,99,116,110,101,115,115,41,0};
static C_char li792[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,99,32,108,115,116,41,0,0,0,0};
static C_char li793[] C_aligned={C_lihdr(0,0,9),40,114,45,116,111,107,101,110,41,0,0,0,0,0,0,0};
static C_char li794[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,99,32,108,115,116,41,0,0,0,0};
static C_char li795[] C_aligned={C_lihdr(0,0,10),40,114,45,100,105,103,105,116,115,41,0,0,0,0,0,0};
static C_char li796[] C_aligned={C_lihdr(0,0,15),40,97,50,55,55,54,51,32,115,116,114,32,107,119,41,0};
static C_char li797[] C_aligned={C_lihdr(0,0,10),40,114,45,115,121,109,98,111,108,41,0,0,0,0,0,0};
static C_char li798[] C_aligned={C_lihdr(0,0,18),40,108,111,111,112,32,108,115,116,32,115,107,119,32,113,116,100,41,0,0,0,0,0,0};
static C_char li799[] C_aligned={C_lihdr(0,0,12),40,114,45,120,116,111,107,101,110,32,107,41,0,0,0,0};
static C_char li800[] C_aligned={C_lihdr(0,0,8),40,114,45,99,104,97,114,41};
static C_char li801[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li802[] C_aligned={C_lihdr(0,0,11),40,114,45,99,111,109,109,101,110,116,41,0,0,0,0,0};
static C_char li803[] C_aligned={C_lihdr(0,0,14),40,114,45,101,120,116,45,115,121,109,98,111,108,41,0,0};
static C_char li804[] C_aligned={C_lihdr(0,0,11),40,114,45,113,117,111,116,101,32,113,41,0,0,0,0,0};
static C_char li805[] C_aligned={C_lihdr(0,0,8),40,97,50,56,52,48,53,41};
static C_char li806[] C_aligned={C_lihdr(0,0,13),40,97,50,56,52,49,49,32,46,32,120,115,41,0,0,0};
static C_char li807[] C_aligned={C_lihdr(0,0,8),40,97,50,56,53,51,57,41};
static C_char li808[] C_aligned={C_lihdr(0,0,8),40,97,50,56,53,55,56,41};
static C_char li809[] C_aligned={C_lihdr(0,0,13),40,97,50,56,53,56,52,32,46,32,120,115,41,0,0,0};
static C_char li810[] C_aligned={C_lihdr(0,0,9),40,103,53,57,56,51,32,104,41,0,0,0,0,0,0,0};
static C_char li811[] C_aligned={C_lihdr(0,0,8),40,97,50,56,54,53,50,41};
static C_char li812[] C_aligned={C_lihdr(0,0,13),40,97,50,56,54,53,56,32,46,32,120,115,41,0,0,0};
static C_char li813[] C_aligned={C_lihdr(0,0,8),40,97,50,56,56,53,48,41};
static C_char li814[] C_aligned={C_lihdr(0,0,15),40,97,50,56,56,54,49,32,115,116,114,32,107,119,41,0};
static C_char li815[] C_aligned={C_lihdr(0,0,8),40,97,50,56,56,53,53,41};
static C_char li816[] C_aligned={C_lihdr(0,0,8),40,97,50,56,56,57,48,41};
static C_char li817[] C_aligned={C_lihdr(0,0,8),40,97,50,57,48,51,50,41};
static C_char li818[] C_aligned={C_lihdr(0,0,13),40,97,50,57,48,51,56,32,46,32,120,115,41,0,0,0};
static C_char li819[] C_aligned={C_lihdr(0,0,9),40,114,101,97,100,114,101,99,41,0,0,0,0,0,0,0};
static C_char li820[] C_aligned={C_lihdr(0,0,12),40,97,50,57,50,56,54,32,46,32,97,41,0,0,0,0};
static C_char li821[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,114,101,97,100,32,112,111,114,116,32,105,110,102,111,104,97,110,100,108,101,114,41,0,0,0};
static C_char li822[] C_aligned={C_lihdr(0,0,11),40,102,97,105,108,32,105,116,101,109,41,0,0,0,0,0};
static C_char li823[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,117,115,101,114,45,114,101,97,100,45,104,111,111,107,32,99,104,97,114,32,112,111,114,116,41};
static C_char li824[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,114,101,97,100,45,110,117,109,118,101,99,116,111,114,45,100,97,116,97,32,112,111,114,116,41};
static C_char li825[] C_aligned={C_lihdr(0,0,15),40,108,111,111,112,50,32,110,115,32,112,114,101,118,41,0};
static C_char li826[] C_aligned={C_lihdr(0,0,9),40,114,101,116,114,121,32,120,41,0,0,0,0,0,0,0};
static C_char li827[] C_aligned={C_lihdr(0,0,15),40,108,111,111,112,32,108,115,116,32,112,114,101,118,41,0};
static C_char li828[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,99,97,110,111,110,105,99,97,108,105,122,101,45,110,117,109,98,101,114,45,108,105,115,116,33,32,108,115,116,49,41,0,0};
static C_char li829[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,119,114,105,116,101,45,99,104,97,114,45,48,32,99,32,112,41};
static C_char li830[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,119,114,105,116,101,45,99,104,97,114,47,112,111,114,116,32,99,32,112,111,114,116,41,0,0};
static C_char li831[] C_aligned={C_lihdr(0,0,28),40,115,99,104,101,109,101,35,119,114,105,116,101,45,99,104,97,114,32,99,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char li832[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,110,101,119,108,105,110,101,32,46,32,114,101,115,116,41,0};
static C_char li833[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,119,114,105,116,101,32,120,32,46,32,114,101,115,116,41,0};
static C_char li834[] C_aligned={C_lihdr(0,0,25),40,115,99,104,101,109,101,35,100,105,115,112,108,97,121,32,120,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char li835[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,54,50,52,53,32,103,54,50,53,50,41,0,0,0,0,0,0,0};
static C_char li836[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,114,105,110,116,32,46,32,97,114,103,115,41,0,0,0,0,0};
static C_char li837[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,54,50,55,55,32,103,54,50,56,52,41,0,0,0,0,0,0,0};
static C_char li838[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,114,105,110,116,42,32,46,32,97,114,103,115,41,0,0,0,0};
static C_char li839[] C_aligned={C_lihdr(0,0,17),40,111,117,116,115,116,114,32,112,111,114,116,32,115,116,114,41,0,0,0,0,0,0,0};
static C_char li840[] C_aligned={C_lihdr(0,0,18),40,111,117,116,115,116,114,48,32,112,111,114,116,32,115,116,114,41,0,0,0,0,0,0};
static C_char li841[] C_aligned={C_lihdr(0,0,17),40,111,117,116,99,104,114,32,112,111,114,116,32,99,104,114,41,0,0,0,0,0,0,0};
static C_char li842[] C_aligned={C_lihdr(0,0,17),40,111,117,116,115,121,109,32,112,111,114,116,32,115,121,109,41,0,0,0,0,0,0,0};
static C_char li843[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li844[] C_aligned={C_lihdr(0,0,25),40,111,117,116,114,101,97,100,97,98,108,101,115,121,109,32,112,111,114,116,32,115,116,114,41,0,0,0,0,0,0,0};
static C_char li845[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li846[] C_aligned={C_lihdr(0,0,22),40,115,121,109,45,105,115,45,114,101,97,100,97,98,108,101,63,32,115,116,114,41,0,0};
static C_char li847[] C_aligned={C_lihdr(0,0,10),40,103,54,52,52,55,32,99,110,41,0,0,0,0,0,0};
static C_char li848[] C_aligned={C_lihdr(0,0,16),40,100,111,108,111,111,112,54,52,54,56,32,105,32,99,41};
static C_char li849[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,54,52,57,57,32,120,41,0,0};
static C_char li850[] C_aligned={C_lihdr(0,0,16),40,100,111,108,111,111,112,54,53,50,56,32,105,32,99,41};
static C_char li851[] C_aligned={C_lihdr(0,0,7),40,111,117,116,32,120,41,0};
static C_char li852[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,112,114,105,110,116,32,120,32,114,101,97,100,97,98,108,101,32,112,111,114,116,41,0,0,0};
static C_char li853[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,112,114,111,99,101,100,117,114,101,45,62,115,116,114,105,110,103,32,120,41,0,0,0,0,0};
static C_char li854[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,98,97,115,101,35,114,101,99,111,114,100,45,112,114,105,110,116,101,114,32,116,121,112,101,41,0,0,0,0,0,0};
static C_char li855[] C_aligned={C_lihdr(0,0,44),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,101,116,45,114,101,99,111,114,100,45,112,114,105,110,116,101,114,33,32,116,121,112,101,32,112,114,111,99,41,0,0,0,0};
static C_char li856[] C_aligned={C_lihdr(0,0,8),40,97,51,49,48,50,52,41};
static C_char li857[] C_aligned={C_lihdr(0,0,11),40,97,51,49,48,49,56,32,101,120,41,0,0,0,0,0};
static C_char li858[] C_aligned={C_lihdr(0,0,8),40,97,51,49,48,55,49,41};
static C_char li859[] C_aligned={C_lihdr(0,0,8),40,97,51,49,48,56,54,41};
static C_char li860[] C_aligned={C_lihdr(0,0,15),40,97,51,49,48,56,48,32,46,32,97,114,103,115,41,0};
static C_char li861[] C_aligned={C_lihdr(0,0,8),40,97,51,49,48,54,53,41};
static C_char li862[] C_aligned={C_lihdr(0,0,10),40,97,51,49,48,49,50,32,107,41,0,0,0,0,0,0};
static C_char li863[] C_aligned={C_lihdr(0,0,39),40,35,35,115,121,115,35,117,115,101,114,45,112,114,105,110,116,45,104,111,111,107,32,120,32,114,101,97,100,97,98,108,101,32,112,111,114,116,41,0};
static C_char li864[] C_aligned={C_lihdr(0,0,8),40,97,51,49,49,53,53,41};
static C_char li865[] C_aligned={C_lihdr(0,0,8),40,97,51,49,49,57,56,41};
static C_char li866[] C_aligned={C_lihdr(0,0,8),40,97,51,49,50,48,52,41};
static C_char li867[] C_aligned={C_lihdr(0,0,15),40,97,51,49,49,52,57,32,114,101,116,117,114,110,41,0};
static C_char li868[] C_aligned={C_lihdr(0,0,43),40,35,35,115,121,115,35,119,105,116,104,45,112,114,105,110,116,45,108,101,110,103,116,104,45,108,105,109,105,116,32,108,105,109,105,116,32,116,104,117,110,107,41,0,0,0,0,0};
static C_char li869[] C_aligned={C_lihdr(0,0,15),40,99,104,101,99,107,54,54,52,55,32,112,32,110,41,0};
static C_char li870[] C_aligned={C_lihdr(0,0,10),40,97,52,49,49,50,50,32,112,41,0,0,0,0,0,0};
static C_char li871[] C_aligned={C_lihdr(0,0,10),40,97,52,49,49,52,52,32,112,41,0,0,0,0,0,0};
static C_char li872[] C_aligned={C_lihdr(0,0,12),40,97,52,49,49,54,50,32,112,32,99,41,0,0,0,0};
static C_char li873[] C_aligned={C_lihdr(0,0,21),40,97,52,49,49,55,56,32,112,32,98,118,32,102,114,111,109,32,116,111,41,0,0,0};
static C_char li874[] C_aligned={C_lihdr(0,0,10),40,97,52,49,50,48,48,32,112,41,0,0,0,0,0,0};
static C_char li875[] C_aligned={C_lihdr(0,0,10),40,97,52,49,50,48,51,32,112,41,0,0,0,0,0,0};
static C_char li876[] C_aligned={C_lihdr(0,0,23),40,97,52,49,50,48,54,32,112,32,110,32,100,101,115,116,32,115,116,97,114,116,41,0};
static C_char li877[] C_aligned={C_lihdr(0,0,12),40,97,52,49,50,55,54,32,112,111,115,41,0,0,0,0};
static C_char li878[] C_aligned={C_lihdr(0,0,8),40,97,52,49,50,54,54,41};
static C_char li879[] C_aligned={C_lihdr(0,0,29),40,97,52,49,50,56,53,32,110,101,120,116,32,108,105,110,101,32,102,117,108,108,45,108,105,110,101,63,41,0,0,0};
static C_char li880[] C_aligned={C_lihdr(0,0,16),40,97,52,49,50,52,50,32,112,32,108,105,109,105,116,41};
static C_char li881[] C_aligned={C_lihdr(0,0,10),40,97,52,49,51,50,54,32,112,41,0,0,0,0,0,0};
static C_char li882[] C_aligned={C_lihdr(0,0,6),40,103,114,111,119,41,0,0};
static C_char li883[] C_aligned={C_lihdr(0,0,18),40,99,111,110,99,32,98,117,102,32,102,114,111,109,32,116,111,41,0,0,0,0,0,0};
static C_char li884[] C_aligned={C_lihdr(0,0,9),40,99,111,110,99,49,32,98,41,0,0,0,0,0,0,0};
static C_char li885[] C_aligned={C_lihdr(0,0,9),40,103,101,116,108,105,110,101,41,0,0,0,0,0,0,0};
static C_char li886[] C_aligned={C_lihdr(0,0,8),40,97,51,49,51,55,52,41};
static C_char li887[] C_aligned={C_lihdr(0,0,25),40,97,51,49,51,56,48,32,98,117,102,32,111,102,102,115,101,116,32,108,105,109,105,116,41,0,0,0,0,0,0,0};
static C_char li888[] C_aligned={C_lihdr(0,0,8),40,97,51,49,52,52,56,41};
static C_char li889[] C_aligned={C_lihdr(0,0,25),40,97,51,49,52,53,52,32,98,117,102,32,111,102,102,115,101,116,32,108,105,109,105,116,41,0,0,0,0,0,0,0};
static C_char li890[] C_aligned={C_lihdr(0,0,27),40,108,111,111,112,32,98,117,102,32,111,102,102,115,101,116,32,112,111,115,32,108,105,109,105,116,41,0,0,0,0,0};
static C_char li891[] C_aligned={C_lihdr(0,0,63),40,35,35,115,121,115,35,115,99,97,110,45,98,117,102,102,101,114,45,108,105,110,101,32,98,117,102,32,108,105,109,105,116,32,115,116,97,114,116,45,112,111,115,32,101,111,115,45,104,97,110,100,108,101,114,32,46,32,114,101,115,116,41,0};
static C_char li892[] C_aligned={C_lihdr(0,0,9),40,103,54,56,48,48,32,120,41,0,0,0,0,0,0,0};
static C_char li893[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,54,55,57,57,32,103,54,56,48,54,41,0,0,0,0,0,0,0};
static C_char li894[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,112,114,105,110,116,45,116,111,45,115,116,114,105,110,103,32,120,115,41,0,0,0,0,0,0};
static C_char li895[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,112,111,105,110,116,101,114,45,62,115,116,114,105,110,103,32,120,41,0,0,0,0,0,0,0};
static C_char li896[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li897[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,98,97,115,101,35,103,101,116,45,99,97,108,108,45,99,104,97,105,110,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char li898[] C_aligned={C_lihdr(0,0,8),40,97,51,49,56,52,57,41};
static C_char li899[] C_aligned={C_lihdr(0,0,12),40,103,54,56,54,57,32,105,110,102,111,41,0,0,0,0};
static C_char li900[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,54,56,54,56,32,103,54,56,55,53,41,0,0,0,0,0,0,0};
static C_char li901[] C_aligned={C_lihdr(0,0,49),40,35,35,115,121,115,35,114,101,97,108,108,121,45,112,114,105,110,116,45,99,97,108,108,45,99,104,97,105,110,32,112,111,114,116,32,99,104,97,105,110,32,104,101,97,100,101,114,41,0,0,0,0,0,0,0};
static C_char li902[] C_aligned={C_lihdr(0,0,38),40,99,104,105,99,107,101,110,46,98,97,115,101,35,112,114,105,110,116,45,99,97,108,108,45,99,104,97,105,110,32,46,32,114,101,115,116,41,0,0};
static C_char li903[] C_aligned={C_lihdr(0,0,7),40,98,114,101,97,107,41,0};
static C_char li904[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,117,115,101,114,45,105,110,116,101,114,114,117,112,116,45,104,111,111,107,41,0,0,0,0,0};
static C_char li905[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,54,57,50,56,32,103,54,57,51,53,41,0,0,0,0,0,0,0};
static C_char li906[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char li907[] C_aligned={C_lihdr(0,0,21),40,99,108,101,97,110,117,112,45,98,101,102,111,114,101,45,101,120,105,116,41,0,0,0};
static C_char li908[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,100,98,103,45,104,111,111,107,32,46,32,97,114,103,115,41,0};
static C_char li909[] C_aligned={C_lihdr(0,0,8),40,97,51,50,49,56,49,41};
static C_char li910[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,55,48,48,55,32,103,55,48,49,52,41,0,0,0,0,0,0,0};
static C_char li911[] C_aligned={C_lihdr(0,0,47),40,35,35,115,121,115,35,115,105,103,110,97,108,45,104,111,111,107,47,101,114,114,110,111,32,109,111,100,101,32,101,114,114,110,111,32,109,115,103,32,46,32,97,114,103,115,41,0};
static C_char li912[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,115,105,103,110,97,108,45,104,111,111,107,32,109,111,100,101,32,109,115,103,32,46,32,97,114,103,115,41,0,0,0,0,0};
static C_char li913[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,97,98,111,114,116,32,120,41,0,0,0,0,0};
static C_char li914[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,115,105,103,110,97,108,32,120,41,0,0,0,0};
static C_char li915[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,99,117,114,114,101,110,116,45,101,120,99,101,112,116,105,111,110,45,104,97,110,100,108,101,114,32,99,41,0,0,0,0,0};
static C_char li916[] C_aligned={C_lihdr(0,0,8),40,97,51,50,54,52,53,41};
static C_char li917[] C_aligned={C_lihdr(0,0,8),40,97,51,50,54,52,57,41};
static C_char li918[] C_aligned={C_lihdr(0,0,56),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,119,105,116,104,45,101,120,99,101,112,116,105,111,110,45,104,97,110,100,108,101,114,32,104,97,110,100,108,101,114,32,116,104,117,110,107,41};
static C_char li919[] C_aligned={C_lihdr(0,0,10),40,98,111,100,121,55,49,54,52,41,0,0,0,0,0,0};
static C_char li920[] C_aligned={C_lihdr(0,0,52),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,117,114,114,101,110,116,45,101,120,99,101,112,116,105,111,110,45,104,97,110,100,108,101,114,32,46,32,97,114,103,115,41,0,0,0,0};
static C_char li921[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,114,111,112,115,41,0,0,0,0};
static C_char li922[] C_aligned={C_lihdr(0,0,69),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,112,114,111,112,45,108,105,115,116,45,62,107,105,110,100,45,112,114,101,102,105,120,101,100,45,112,114,111,112,45,108,105,115,116,32,108,111,99,32,107,105,110,100,32,112,108,105,115,116,41,0,0,0};
static C_char li923[] C_aligned={C_lihdr(0,0,56),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,109,97,107,101,45,112,114,111,112,101,114,116,121,45,99,111,110,100,105,116,105,111,110,32,107,105,110,100,32,46,32,112,114,111,112,115,41};
static C_char li924[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,55,50,48,56,41,0,0,0,0,0};
static C_char li925[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,55,50,53,51,32,103,55,50,54,53,41,0,0,0,0};
static C_char li926[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,55,50,50,54,32,103,55,50,51,56,41,0,0,0,0};
static C_char li927[] C_aligned={C_lihdr(0,0,55),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,109,97,107,101,45,99,111,109,112,111,115,105,116,101,45,99,111,110,100,105,116,105,111,110,32,99,49,32,46,32,99,111,110,100,115,41,0};
static C_char li928[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,55,51,49,51,32,103,55,51,50,53,41,0,0,0,0};
static C_char li929[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,55,50,56,54,32,103,55,50,57,56,41,0,0,0,0};
static C_char li930[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,111,110,100,105,116,105,111,110,32,97,114,103,49,32,46,32,97,114,103,115,41,0,0,0,0,0,0,0};
static C_char li931[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,111,110,100,105,116,105,111,110,63,32,120,41};
static C_char li932[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,114,111,112,115,41,0,0,0,0};
static C_char li933[] C_aligned={C_lihdr(0,0,9),40,103,55,51,52,57,32,107,41,0,0,0,0,0,0,0};
static C_char li934[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,55,51,52,51,32,103,55,51,53,53,41,0,0,0,0};
static C_char li935[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,111,110,100,105,116,105,111,110,45,62,108,105,115,116,32,120,41,0,0,0};
static C_char li936[] C_aligned={C_lihdr(0,0,11),40,102,95,51,51,49,54,56,32,99,41,0,0,0,0,0};
static C_char li937[] C_aligned={C_lihdr(0,0,44),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,111,110,100,105,116,105,111,110,45,112,114,101,100,105,99,97,116,101,32,107,105,110,100,41,0,0,0,0};
static C_char li938[] C_aligned={C_lihdr(0,0,11),40,102,95,51,51,49,57,53,32,99,41,0,0,0,0,0};
static C_char li939[] C_aligned={C_lihdr(0,0,67),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,99,111,110,100,105,116,105,111,110,45,112,114,111,112,101,114,116,121,45,97,99,99,101,115,115,111,114,32,107,105,110,100,32,112,114,111,112,32,46,32,101,114,114,45,100,101,102,41,0,0,0,0,0};
static C_char li940[] C_aligned={C_lihdr(0,0,64),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,103,101,116,45,99,111,110,100,105,116,105,111,110,45,112,114,111,112,101,114,116,121,32,99,32,107,105,110,100,32,112,114,111,112,32,46,32,101,114,114,45,100,101,102,41};
static C_char li941[] C_aligned={C_lihdr(0,0,8),40,97,51,51,50,54,49,41};
static C_char li942[] C_aligned={C_lihdr(0,0,9),40,103,55,52,49,52,32,120,41,0,0,0,0,0,0,0};
static C_char li943[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,55,52,49,51,32,103,55,52,50,48,41,0,0,0,0,0,0,0};
static C_char li944[] C_aligned={C_lihdr(0,0,21),40,119,114,105,116,101,97,114,103,115,32,97,114,103,115,32,112,111,114,116,41,0,0,0};
static C_char li945[] C_aligned={C_lihdr(0,0,11),40,103,55,52,53,55,32,109,115,103,41,0,0,0,0,0};
static C_char li946[] C_aligned={C_lihdr(0,0,22),40,98,111,100,121,55,52,51,52,32,112,111,114,116,32,104,101,97,100,101,114,41,0,0};
static C_char li947[] C_aligned={C_lihdr(0,0,22),40,100,101,102,45,104,101,97,100,101,114,55,52,51,55,32,37,112,111,114,116,41,0,0};
static C_char li948[] C_aligned={C_lihdr(0,0,14),40,100,101,102,45,112,111,114,116,55,52,51,54,41,0,0};
static C_char li949[] C_aligned={C_lihdr(0,0,49),40,99,104,105,99,107,101,110,46,99,111,110,100,105,116,105,111,110,35,112,114,105,110,116,45,101,114,114,111,114,45,109,101,115,115,97,103,101,32,101,120,32,46,32,97,114,103,115,41,0,0,0,0,0,0,0};
static C_char li950[] C_aligned={C_lihdr(0,0,47),40,35,35,115,121,115,35,115,104,111,119,45,101,120,99,101,112,116,105,111,110,45,119,97,114,110,105,110,103,32,101,120,110,32,99,97,117,115,101,32,46,32,114,101,115,116,41,0};
static C_char li951[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,101,114,114,111,114,45,104,111,111,107,32,99,111,100,101,32,108,111,99,32,46,32,97,114,103,115,41,0,0,0,0,0,0};
static C_char li952[] C_aligned={C_lihdr(0,0,8),40,97,51,52,50,55,51,41};
static C_char li953[] C_aligned={C_lihdr(0,0,8),40,97,51,52,51,49,51,41};
static C_char li954[] C_aligned={C_lihdr(0,0,45),40,115,99,104,101,109,101,35,119,105,116,104,45,101,120,99,101,112,116,105,111,110,45,104,97,110,100,108,101,114,32,104,97,110,100,108,101,114,32,116,104,117,110,107,41,0,0,0};
static C_char li955[] C_aligned={C_lihdr(0,0,8),40,97,51,52,51,52,53,41};
static C_char li956[] C_aligned={C_lihdr(0,0,18),40,115,99,104,101,109,101,35,114,97,105,115,101,32,111,98,106,41,0,0,0,0,0,0};
static C_char li957[] C_aligned={C_lihdr(0,0,8),40,97,51,52,51,56,54,41};
static C_char li958[] C_aligned={C_lihdr(0,0,30),40,115,99,104,101,109,101,35,114,97,105,115,101,45,99,111,110,116,105,110,117,97,98,108,101,32,111,98,106,41,0,0};
static C_char li959[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,114,101,97,100,45,101,114,114,111,114,63,32,111,98,106,41};
static C_char li960[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,102,105,108,101,45,101,114,114,111,114,63,32,111,98,106,41};
static C_char li961[] C_aligned={C_lihdr(0,0,22),40,35,35,115,121,115,35,115,116,114,117,99,116,117,114,101,63,32,120,32,115,41,0,0};
static C_char li962[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,103,101,110,101,114,105,99,45,115,116,114,117,99,116,117,114,101,63,32,120,41,0,0,0,0};
static C_char li963[] C_aligned={C_lihdr(0,0,16),40,35,35,115,121,115,35,115,108,111,116,32,120,32,105,41};
static C_char li964[] C_aligned={C_lihdr(0,0,14),40,35,35,115,121,115,35,115,105,122,101,32,120,41,0,0};
static C_char li965[] C_aligned={C_lihdr(0,0,14),67,95,109,97,107,101,95,112,111,105,110,116,101,114,0,0};
static C_char li966[] C_aligned={C_lihdr(0,0,21),67,95,109,97,107,101,95,116,97,103,103,101,100,95,112,111,105,110,116,101,114,0,0,0};
static C_char li967[] C_aligned={C_lihdr(0,0,18),40,35,35,115,121,115,35,112,111,105,110,116,101,114,63,32,120,41,0,0,0,0,0,0};
static C_char li968[] C_aligned={C_lihdr(0,0,37),40,35,35,115,121,115,35,115,101,116,45,112,111,105,110,116,101,114,45,97,100,100,114,101,115,115,33,32,112,116,114,32,97,100,100,114,41,0,0,0};
static C_char li969[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,98,121,116,101,118,101,99,116,111,114,63,32,120,41,0,0,0};
static C_char li970[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,115,116,114,105,110,103,45,62,112,98,121,116,101,118,101,99,116,111,114,32,115,41,0,0,0};
static C_char li971[] C_aligned={C_lihdr(0,0,20),40,35,35,115,121,115,35,112,101,114,109,97,110,101,110,116,63,32,120,41,0,0,0,0};
static C_char li972[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,98,108,111,99,107,45,97,100,100,114,101,115,115,32,120,41,0};
static C_char li973[] C_aligned={C_lihdr(0,0,19),40,35,35,115,121,115,35,108,111,99,97,116,105,118,101,63,32,120,41,0,0,0,0,0};
static C_char li974[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,115,114,102,105,45,52,45,118,101,99,116,111,114,63,32,120,41};
static C_char li975[] C_aligned={C_lihdr(0,0,20),40,35,35,115,121,115,35,110,117,108,108,45,112,111,105,110,116,101,114,41,0,0,0,0};
static C_char li976[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,110,117,108,108,45,112,111,105,110,116,101,114,63,32,120,41,0};
static C_char li977[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,97,100,100,114,101,115,115,45,62,112,111,105,110,116,101,114,32,97,100,100,114,41,0,0,0};
static C_char li978[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,112,111,105,110,116,101,114,45,62,97,100,100,114,101,115,115,32,112,116,114,41,0,0,0,0};
static C_char li979[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,109,97,107,101,45,99,45,115,116,114,105,110,103,32,115,116,114,32,46,32,114,101,115,116,41};
static C_char li980[] C_aligned={C_lihdr(0,0,21),67,95,112,101,101,107,95,115,105,103,110,101,100,95,105,110,116,101,103,101,114,0,0,0};
static C_char li981[] C_aligned={C_lihdr(0,0,23),67,95,112,101,101,107,95,117,110,115,105,103,110,101,100,95,105,110,116,101,103,101,114,0};
static C_char li982[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,112,101,101,107,45,102,105,120,110,117,109,32,98,32,105,41,0};
static C_char li983[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,112,101,101,107,45,98,121,116,101,32,112,116,114,32,105,41,0};
static C_char li984[] C_aligned={C_lihdr(0,0,30),40,35,35,115,121,115,35,118,101,99,116,111,114,45,62,115,116,114,117,99,116,117,114,101,33,32,118,101,99,41,0,0};
static C_char li985[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,112,101,101,107,45,100,111,117,98,108,101,32,98,32,105,41,0};
static C_char li986[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,112,101,101,107,45,99,45,115,116,114,105,110,103,32,98,32,105,41,0,0,0,0,0,0,0};
static C_char li987[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,112,101,101,107,45,110,111,110,110,117,108,108,45,99,45,115,116,114,105,110,103,32,98,32,105,41,0,0,0,0,0,0,0};
static C_char li988[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,112,101,101,107,45,97,110,100,45,102,114,101,101,45,99,45,115,116,114,105,110,103,32,98,32,105,41,0,0,0,0,0,0};
static C_char li989[] C_aligned={C_lihdr(0,0,42),40,35,35,115,121,115,35,112,101,101,107,45,97,110,100,45,102,114,101,101,45,110,111,110,110,117,108,108,45,99,45,115,116,114,105,110,103,32,98,32,105,41,0,0,0,0,0,0};
static C_char li990[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,112,111,107,101,45,99,45,115,116,114,105,110,103,32,98,32,105,32,115,41,0,0,0,0,0};
static C_char li991[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,112,111,107,101,45,105,110,116,101,103,101,114,32,98,32,105,32,110,41,0,0,0,0,0,0};
static C_char li992[] C_aligned={C_lihdr(0,0,25),40,35,35,115,121,115,35,112,111,107,101,45,100,111,117,98,108,101,32,98,32,105,32,110,41,0,0,0,0,0,0,0};
static C_char li993[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li994[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,112,101,101,107,45,99,45,115,116,114,105,110,103,45,108,105,115,116,32,112,116,114,32,110,41};
static C_char li995[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li996[] C_aligned={C_lihdr(0,0,41),40,35,35,115,121,115,35,112,101,101,107,45,97,110,100,45,102,114,101,101,45,99,45,115,116,114,105,110,103,45,108,105,115,116,32,112,116,114,32,110,41,0,0,0,0,0,0,0};
static C_char li997[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,118,101,99,116,111,114,45,62,99,108,111,115,117,114,101,33,32,118,101,99,32,97,100,100,114,41,0,0,0,0,0,0,0};
static C_char li998[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,115,121,109,98,111,108,45,104,97,115,45,116,111,112,108,101,118,101,108,45,98,105,110,100,105,110,103,63,32,115,41,0,0};
static C_char li999[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,98,108,111,99,107,45,112,111,105,110,116,101,114,32,120,41,0};
static C_char li1000[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,99,104,97,114,45,97,114,103,117,109,101,110,116,32,120,41,0};
static C_char li1001[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,102,105,120,110,117,109,45,97,114,103,117,109,101,110,116,32,120,41,0,0,0,0,0,0,0};
static C_char li1002[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,102,108,111,110,117,109,45,97,114,103,117,109,101,110,116,32,120,41,0,0,0,0,0,0,0};
static C_char li1003[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,98,108,111,99,107,45,97,114,103,117,109,101,110,116,32,120,41};
static C_char li1004[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,99,112,108,120,110,117,109,45,97,114,103,117,109,101,110,116,32,120,41,0,0,0,0,0,0};
static C_char li1005[] C_aligned={C_lihdr(0,0,43),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,115,116,114,117,99,116,45,119,114,97,112,112,101,114,45,97,114,103,117,109,101,110,116,32,116,32,120,41,0,0,0,0,0};
static C_char li1006[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,115,116,114,105,110,103,45,97,114,103,117,109,101,110,116,32,120,41,0,0,0,0,0,0,0};
static C_char li1007[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,115,121,109,98,111,108,45,97,114,103,117,109,101,110,116,32,120,41,0,0,0,0,0,0,0};
static C_char li1008[] C_aligned={C_lihdr(0,0,34),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,112,111,105,110,116,101,114,45,97,114,103,117,109,101,110,116,32,120,41,0,0,0,0,0,0};
static C_char li1009[] C_aligned={C_lihdr(0,0,44),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,116,97,103,103,101,100,45,112,111,105,110,116,101,114,45,97,114,103,117,109,101,110,116,32,120,32,116,120,41,0,0,0,0};
static C_char li1010[] C_aligned={C_lihdr(0,0,48),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,114,97,110,103,101,100,45,105,110,116,101,103,101,114,45,97,114,103,117,109,101,110,116,32,111,98,106,32,115,105,122,101,41};
static C_char li1011[] C_aligned={C_lihdr(0,0,57),40,35,35,115,121,115,35,102,111,114,101,105,103,110,45,117,110,115,105,103,110,101,100,45,114,97,110,103,101,100,45,105,110,116,101,103,101,114,45,97,114,103,117,109,101,110,116,32,111,98,106,32,115,105,122,101,41,0,0,0,0,0,0,0};
static C_char li1012[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,119,114,97,112,45,115,116,114,117,99,116,32,116,121,112,101,32,114,101,99,41,0,0,0,0};
static C_char li1013[] C_aligned={C_lihdr(0,0,37),40,35,35,115,121,115,35,100,101,102,97,117,108,116,45,101,120,99,101,112,116,105,111,110,45,104,97,110,100,108,101,114,32,97,114,103,41,0,0,0};
static C_char li1014[] C_aligned={C_lihdr(0,0,38),40,35,35,115,121,115,35,109,97,107,101,45,116,104,114,101,97,100,32,116,104,117,110,107,32,115,116,97,116,101,32,110,97,109,101,32,113,41,0,0};
static C_char li1015[] C_aligned={C_lihdr(0,0,27),40,35,35,115,121,115,35,109,97,107,101,45,109,117,116,101,120,32,105,100,32,111,119,110,101,114,41,0,0,0,0,0};
static C_char li1016[] C_aligned={C_lihdr(0,0,16),40,35,35,115,121,115,35,115,99,104,101,100,117,108,101,41};
static C_char li1017[] C_aligned={C_lihdr(0,0,8),40,97,51,52,56,56,51,41};
static C_char li1018[] C_aligned={C_lihdr(0,0,15),40,97,51,52,56,55,52,32,114,101,116,117,114,110,41,0};
static C_char li1019[] C_aligned={C_lihdr(0,0,21),40,35,35,115,121,115,35,116,104,114,101,97,100,45,121,105,101,108,100,33,41,0,0,0};
static C_char li1020[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,107,105,108,108,45,111,116,104,101,114,45,116,104,114,101,97,100,115,32,116,104,117,110,107,41};
static C_char li1021[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,114,101,115,117,109,101,45,116,104,114,101,97,100,45,111,110,45,101,118,101,110,116,32,116,41};
static C_char li1022[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,115,117,115,112,101,110,100,45,116,104,114,101,97,100,45,111,110,45,101,118,101,110,116,32,116,41,0,0,0,0,0,0,0};
static C_char li1023[] C_aligned={C_lihdr(0,0,12),40,97,51,52,57,49,48,32,46,32,95,41,0,0,0,0};
static C_char li1024[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,115,108,101,101,112,45,117,110,116,105,108,45,105,110,116,101,114,114,117,112,116,41,0,0,0};
static C_char li1025[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,109,97,107,101,45,101,118,101,110,116,45,113,117,101,117,101,41};
static C_char li1026[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,97,100,100,45,101,118,101,110,116,45,116,111,45,113,117,101,117,101,33,32,113,32,101,41,0};
static C_char li1027[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,103,101,116,45,110,101,120,116,45,101,118,101,110,116,32,113,41};
static C_char li1028[] C_aligned={C_lihdr(0,0,7),40,97,103,97,105,110,41,0};
static C_char li1029[] C_aligned={C_lihdr(0,0,29),40,35,35,115,121,115,35,119,97,105,116,45,102,111,114,45,110,101,120,116,45,101,118,101,110,116,32,113,41,0,0,0};
static C_char li1030[] C_aligned={C_lihdr(0,0,27),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,108,101,101,112,45,104,111,111,107,32,110,41,0,0,0,0,0};
static C_char li1031[] C_aligned={C_lihdr(0,0,22),40,99,104,105,99,107,101,110,46,98,97,115,101,35,115,108,101,101,112,32,110,41,0,0};
static C_char li1032[] C_aligned={C_lihdr(0,0,16),67,95,99,111,110,116,101,120,116,95,115,119,105,116,99,104};
static C_char li1033[] C_aligned={C_lihdr(0,0,13),40,108,111,111,112,32,114,101,97,115,111,110,41,0,0,0};
static C_char li1034[] C_aligned={C_lihdr(0,0,35),40,35,35,115,121,115,35,105,110,116,101,114,114,117,112,116,45,104,111,111,107,32,114,101,97,115,111,110,32,115,116,97,116,101,41,0,0,0,0,0};
static C_char li1035[] C_aligned={C_lihdr(0,0,28),40,35,35,115,121,115,35,100,105,115,112,97,116,99,104,45,105,110,116,101,114,114,117,112,116,32,107,41,0,0,0,0};
static C_char li1036[] C_aligned={C_lihdr(0,0,20),40,35,35,115,121,115,35,117,112,100,97,116,101,45,101,114,114,110,111,41,0,0,0,0};
static C_char li1037[] C_aligned={C_lihdr(0,0,13),40,35,35,115,121,115,35,101,114,114,110,111,41,0,0,0};
static C_char li1038[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,55,57,48,57,32,99,41,0,0};
static C_char li1039[] C_aligned={C_lihdr(0,0,13),40,114,101,97,100,108,110,32,112,111,114,116,41,0,0,0};
static C_char li1040[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char li1041[] C_aligned={C_lihdr(0,0,36),40,114,101,97,100,45,101,115,99,97,112,101,100,45,115,101,120,112,32,112,111,114,116,32,115,107,105,112,45,98,114,97,99,101,63,41,0,0,0,0};
static C_char li1042[] C_aligned={C_lihdr(0,0,15),40,100,111,108,111,111,112,55,57,52,52,32,108,110,41,0};
static C_char li1043[] C_aligned={C_lihdr(0,0,15),40,103,101,116,47,99,108,101,97,114,45,115,116,114,41,0};
static C_char li1044[] C_aligned={C_lihdr(0,0,27),40,108,111,111,112,50,32,108,115,116,32,110,101,120,116,45,115,116,114,105,110,103,32,97,99,99,41,0,0,0,0,0};
static C_char li1045[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,108,115,116,41,0,0,0,0,0,0};
static C_char li1046[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,117,115,101,114,45,114,101,97,100,45,104,111,111,107,32,99,104,97,114,32,112,111,114,116,41};
static C_char li1047[] C_aligned={C_lihdr(0,0,47),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,32,110,97,109,101,41,0};
static C_char li1048[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,45,104,111,111,107,32,100,105,114,41,0,0,0,0,0,0,0};
static C_char li1049[] C_aligned={C_lihdr(0,0,54),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,103,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,32,118,97,114,41,0,0};
static C_char li1050[] C_aligned={C_lihdr(0,0,59),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,115,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,33,32,118,97,114,32,118,97,108,41,0,0,0,0,0};
static C_char li1051[] C_aligned={C_lihdr(0,0,57),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,117,110,115,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,33,32,118,97,114,41,0,0,0,0,0,0,0};
static C_char li1052[] C_aligned={C_lihdr(0,0,8),40,115,99,97,110,32,106,41};
static C_char li1053[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li1054[] C_aligned={C_lihdr(0,0,51),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,103,101,116,45,101,110,118,105,114,111,110,109,101,110,116,45,118,97,114,105,97,98,108,101,115,41,0,0,0,0,0};
static C_char li1055[] C_aligned={C_lihdr(0,0,45),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,101,120,101,99,117,116,97,98,108,101,45,112,97,116,104,110,97,109,101,41,0,0,0};
static C_char li1056[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,97,114,103,99,43,97,114,103,118,41,0,0,0,0,0};
static C_char li1057[] C_aligned={C_lihdr(0,0,16),40,100,111,108,111,111,112,56,49,49,50,32,105,32,118,41};
static C_char li1058[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,35,97,114,103,118,41,0,0};
static C_char li1059[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,103,99,35,99,117,114,114,101,110,116,45,103,99,45,109,105,108,108,105,115,101,99,111,110,100,115,41,0,0,0,0};
static C_char li1060[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,103,99,35,115,101,116,45,103,99,45,114,101,112,111,114,116,33,32,102,108,97,103,41};
static C_char li1061[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,103,99,35,109,101,109,111,114,121,45,115,116,97,116,105,115,116,105,99,115,41,0,0};
static C_char li1062[] C_aligned={C_lihdr(0,0,20),67,95,114,101,103,105,115,116,101,114,95,102,105,110,97,108,105,122,101,114,0,0,0,0};
static C_char li1063[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,105,110,105,116,45,102,105,110,97,108,105,122,101,114,32,120,32,121,41,0,0,0,0,0,0};
static C_char li1064[] C_aligned={C_lihdr(0,0,25),40,99,104,105,99,107,101,110,46,103,99,35,102,105,110,97,108,105,122,101,114,63,32,120,41,0,0,0,0,0,0,0};
static C_char li1065[] C_aligned={C_lihdr(0,0,11),40,104,97,110,100,108,101,114,32,111,41,0,0,0,0,0};
static C_char li1066[] C_aligned={C_lihdr(0,0,10),40,104,97,110,100,108,101,32,111,41,0,0,0,0,0,0};
static C_char li1067[] C_aligned={C_lihdr(0,0,15),40,97,51,54,48,52,55,32,46,32,114,101,115,116,41,0};
static C_char li1068[] C_aligned={C_lihdr(0,0,15),40,97,51,54,48,54,56,32,112,114,111,99,32,105,41,0};
static C_char li1069[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,56,49,57,57,32,103,56,50,48,54,41,0,0,0,0,0,0,0};
static C_char li1070[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,103,99,35,109,97,107,101,45,102,105,110,97,108,105,122,101,114,32,46,32,111,98,106,101,99,116,115,41,0,0,0};
static C_char li1071[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,56,50,52,49,32,103,56,50,52,56,41,0,0,0,0,0,0,0};
static C_char li1072[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,103,99,35,97,100,100,45,116,111,45,102,105,110,97,108,105,122,101,114,32,102,32,46,32,111,98,106,101,99,116,115,41,0,0,0,0,0,0,0};
static C_char li1073[] C_aligned={C_lihdr(0,0,8),40,97,51,54,50,51,50,41};
static C_char li1074[] C_aligned={C_lihdr(0,0,11),40,97,51,54,50,50,54,32,101,120,41,0,0,0,0,0};
static C_char li1075[] C_aligned={C_lihdr(0,0,8),40,97,51,54,50,52,52,41};
static C_char li1076[] C_aligned={C_lihdr(0,0,8),40,97,51,54,50,54,55,41};
static C_char li1077[] C_aligned={C_lihdr(0,0,15),40,97,51,54,50,54,49,32,46,32,97,114,103,115,41,0};
static C_char li1078[] C_aligned={C_lihdr(0,0,8),40,97,51,54,50,51,56,41};
static C_char li1079[] C_aligned={C_lihdr(0,0,10),40,97,51,54,50,50,48,32,107,41,0,0,0,0,0,0};
static C_char li1080[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,56,50,55,51,32,105,41,0,0};
static C_char li1081[] C_aligned={C_lihdr(0,0,36),40,35,35,115,121,115,35,114,117,110,45,112,101,110,100,105,110,103,45,102,105,110,97,108,105,122,101,114,115,32,115,116,97,116,101,41,0,0,0,0};
static C_char li1082[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char li1083[] C_aligned={C_lihdr(0,0,24),40,35,35,115,121,115,35,102,111,114,99,101,45,102,105,110,97,108,105,122,101,114,115,41};
static C_char li1084[] C_aligned={C_lihdr(0,0,21),40,99,104,105,99,107,101,110,46,103,99,35,103,99,32,46,32,97,114,103,41,0,0,0};
static C_char li1085[] C_aligned={C_lihdr(0,0,41),40,35,35,115,121,115,35,109,97,107,101,45,108,111,99,97,116,105,118,101,32,111,98,106,32,105,110,100,101,120,32,119,101,97,107,63,32,108,111,99,41,0,0,0,0,0,0,0};
static C_char li1086[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,112,108,105,115,116,35,112,117,116,33,32,115,121,109,32,112,114,111,112,32,118,97,108,41,0,0,0,0,0,0,0};
static C_char li1087[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,112,108,105,115,116,35,103,101,116,32,115,121,109,32,112,114,111,112,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li1088[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,112,116,108,41,0,0,0,0,0,0};
static C_char li1089[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,112,108,105,115,116,35,114,101,109,112,114,111,112,33,32,115,121,109,32,112,114,111,112,41,0,0,0,0,0,0,0};
static C_char li1090[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,112,108,105,115,116,41,0,0,0,0};
static C_char li1091[] C_aligned={C_lihdr(0,0,40),40,99,104,105,99,107,101,110,46,112,108,105,115,116,35,103,101,116,45,112,114,111,112,101,114,116,105,101,115,32,115,121,109,32,112,114,111,112,115,41};
static C_char li1092[] C_aligned={C_lihdr(0,0,10),40,112,110,117,109,32,110,117,109,41,0,0,0,0,0,0};
static C_char li1093[] C_aligned={C_lihdr(0,0,14),40,114,111,117,110,100,45,116,111,32,120,32,121,41,0,0};
static C_char li1094[] C_aligned={C_lihdr(0,0,12),40,112,109,101,109,32,98,121,116,101,115,41,0,0,0,0};
static C_char li1095[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,100,105,115,112,108,97,121,45,116,105,109,101,115,32,105,110,102,111,41,0,0,0,0,0,0};
static C_char li1096[] C_aligned={C_lihdr(0,0,17),67,95,100,117,109,112,95,104,101,97,112,95,115,116,97,116,101,0,0,0,0,0,0,0};
static C_char li1097[] C_aligned={C_lihdr(0,0,21),67,95,102,105,108,116,101,114,95,104,101,97,112,95,111,98,106,101,99,116,115,0,0,0};
static C_char li1098[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,115,111,102,116,119,97,114,101,45,116,121,112,101,41};
static C_char li1099[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,109,97,99,104,105,110,101,45,116,121,112,101,41,0};
static C_char li1100[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,109,97,99,104,105,110,101,45,98,121,116,101,45,111,114,100,101,114,41,0,0,0};
static C_char li1101[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,115,111,102,116,119,97,114,101,45,118,101,114,115,105,111,110,41,0,0,0,0,0};
static C_char li1102[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,98,117,105,108,100,45,112,108,97,116,102,111,114,109,41,0,0,0,0,0,0,0};
static C_char li1103[] C_aligned={C_lihdr(0,0,7),40,115,116,114,32,120,41,0};
static C_char li1104[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,99,104,105,99,107,101,110,45,118,101,114,115,105,111,110,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char li1105[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,99,104,105,99,107,101,110,45,104,111,109,101,41,0};
static C_char li1106[] C_aligned={C_lihdr(0,0,38),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,105,110,99,108,117,100,101,45,112,97,116,104,32,46,32,114,101,115,116,41,0,0};
static C_char li1107[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,115,116,97,114,116,32,112,111,115,41};
static C_char li1108[] C_aligned={C_lihdr(0,0,23),40,35,35,115,121,115,35,115,112,108,105,116,45,112,97,116,104,32,112,97,116,104,41,0};
static C_char li1109[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,99,104,111,112,45,115,101,112,97,114,97,116,111,114,32,115,116,114,41,0,0,0};
static C_char li1110[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,105,110,99,108,117,100,101,45,112,97,116,104,41,0};
static C_char li1111[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,45,62,102,101,97,116,117,114,101,45,105,100,32,120,41,0,0,0,0,0,0,0};
static C_char li1112[] C_aligned={C_lihdr(0,0,9),40,99,104,101,99,107,32,102,41,0,0,0,0,0,0,0};
static C_char li1113[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,56,55,52,54,32,103,56,55,53,51,41,0,0,0,0,0,0,0};
static C_char li1114[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,114,101,103,105,115,116,101,114,45,102,101,97,116,117,114,101,33,32,46,32,102,115,41,0,0,0,0,0,0,0};
static C_char li1115[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,102,102,115,41,0,0,0,0,0,0};
static C_char li1116[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,56,55,54,57,32,103,56,55,56,49,41,0,0,0,0};
static C_char li1117[] C_aligned={C_lihdr(0,0,43),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,117,110,114,101,103,105,115,116,101,114,45,102,101,97,116,117,114,101,33,32,46,32,102,115,41,0,0,0,0,0};
static C_char li1118[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,105,100,115,41,0,0,0,0,0,0};
static C_char li1119[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,102,101,97,116,117,114,101,63,32,46,32,105,100,115,41,0,0,0,0,0,0,0};
static C_char li1120[] C_aligned={C_lihdr(0,0,16),67,95,114,101,116,117,114,110,95,116,111,95,104,111,115,116};
static C_char li1121[] C_aligned={C_lihdr(0,0,42),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,115,121,115,116,101,109,45,99,111,110,102,105,103,45,100,105,114,101,99,116,111,114,121,41,0,0,0,0,0,0};
static C_char li1122[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,112,108,97,116,102,111,114,109,35,115,121,115,116,101,109,45,99,97,99,104,101,45,100,105,114,101,99,116,111,114,121,41,0,0,0,0,0,0,0};
static C_char li1123[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,56,56,54,49,32,103,56,56,55,51,41,0,0,0,0};
static C_char li1124[] C_aligned={C_lihdr(0,0,17),40,115,99,104,101,109,101,35,102,101,97,116,117,114,101,115,41,0,0,0,0,0,0,0};
static C_char li1125[] C_aligned={C_lihdr(0,0,21),40,100,111,108,111,111,112,56,56,57,55,32,105,32,114,101,115,117,108,116,41,0,0,0};
static C_char li1126[] C_aligned={C_lihdr(0,0,27),40,115,99,104,101,109,101,35,109,97,107,101,45,108,105,115,116,32,110,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li1127[] C_aligned={C_lihdr(0,0,16),40,100,111,108,111,111,112,56,57,48,55,32,105,32,108,41};
static C_char li1128[] C_aligned={C_lihdr(0,0,26),40,115,99,104,101,109,101,35,108,105,115,116,45,115,101,116,33,32,108,32,110,32,111,98,106,41,0,0,0,0,0,0};
static C_char li1129[] C_aligned={C_lihdr(0,0,12),40,108,112,32,114,101,115,32,108,115,116,41,0,0,0,0};
static C_char li1130[] C_aligned={C_lihdr(0,0,22),40,115,99,104,101,109,101,35,108,105,115,116,45,99,111,112,121,32,108,115,116,41,0,0};
static C_char li1131[] C_aligned={C_lihdr(0,0,15),40,100,111,108,111,111,112,56,57,52,54,32,102,105,41,0};
static C_char li1132[] C_aligned={C_lihdr(0,0,18),40,115,45,62,118,32,115,32,115,116,97,114,116,32,101,110,100,41,0,0,0,0,0,0};
static C_char li1133[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,62,118,101,99,116,111,114,32,115,32,46,32,114,101,115,116,41};
static C_char li1134[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,116,105,32,102,105,41,0,0,0,0};
static C_char li1135[] C_aligned={C_lihdr(0,0,18),40,118,45,62,115,32,118,32,115,116,97,114,116,32,101,110,100,41,0,0,0,0,0,0};
static C_char li1136[] C_aligned={C_lihdr(0,0,32),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,62,115,116,114,105,110,103,32,118,32,46,32,114,101,115,116,41};
static C_char li1137[] C_aligned={C_lihdr(0,0,10),40,108,111,111,112,32,105,32,106,41,0,0,0,0,0,0};
static C_char li1138[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,57,48,48,57,41,0,0,0,0,0};
static C_char li1139[] C_aligned={C_lihdr(0,0,17),40,102,111,108,100,108,57,48,51,57,32,103,57,48,51,56,41,0,0,0,0,0,0,0};
static C_char li1140[] C_aligned={C_lihdr(0,0,7),40,103,57,48,56,55,41,0};
static C_char li1141[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,57,48,56,49,32,103,57,48,57,51,41,0,0,0,0};
static C_char li1142[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,57,48,55,54,32,105,41,0,0};
static C_char li1143[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,57,48,52,54,32,103,57,48,53,56,41,0,0,0,0};
static C_char li1144[] C_aligned={C_lihdr(0,0,35),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,109,97,112,32,112,114,111,99,32,115,116,114,32,46,32,109,111,114,101,41,0,0,0,0,0};
static C_char li1145[] C_aligned={C_lihdr(0,0,6),40,108,112,32,105,41,0,0};
static C_char li1146[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,57,49,51,50,41,0,0,0,0,0};
static C_char li1147[] C_aligned={C_lihdr(0,0,17),40,102,111,108,100,108,57,49,54,50,32,103,57,49,54,49,41,0,0,0,0,0,0,0};
static C_char li1148[] C_aligned={C_lihdr(0,0,7),40,103,57,50,49,48,41,0};
static C_char li1149[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,57,50,48,52,32,103,57,50,49,54,41,0,0,0,0};
static C_char li1150[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,57,49,57,57,32,105,41,0,0};
static C_char li1151[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,57,49,54,57,32,103,57,49,56,49,41,0,0,0,0};
static C_char li1152[] C_aligned={C_lihdr(0,0,40),40,115,99,104,101,109,101,35,115,116,114,105,110,103,45,102,111,114,45,101,97,99,104,32,112,114,111,99,32,115,116,114,32,46,32,109,111,114,101,41};
static C_char li1153[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,57,50,53,48,32,105,41,0,0};
static C_char li1154[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,57,50,54,48,41,0,0,0,0,0};
static C_char li1155[] C_aligned={C_lihdr(0,0,17),40,102,111,108,100,108,57,50,57,48,32,103,57,50,56,57,41,0,0,0,0,0,0,0};
static C_char li1156[] C_aligned={C_lihdr(0,0,7),40,103,57,51,51,56,41,0};
static C_char li1157[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,57,51,51,50,32,103,57,51,52,52,41,0,0,0,0};
static C_char li1158[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,57,51,50,55,32,105,41,0,0};
static C_char li1159[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,57,50,57,55,32,103,57,51,48,57,41,0,0,0,0};
static C_char li1160[] C_aligned={C_lihdr(0,0,33),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,109,97,112,32,112,114,111,99,32,118,32,46,32,109,111,114,101,41,0,0,0,0,0,0,0};
static C_char li1161[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,57,51,55,54,32,105,41,0,0};
static C_char li1162[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,57,51,56,54,41,0,0,0,0,0};
static C_char li1163[] C_aligned={C_lihdr(0,0,17),40,102,111,108,100,108,57,52,49,54,32,103,57,52,49,53,41,0,0,0,0,0,0,0};
static C_char li1164[] C_aligned={C_lihdr(0,0,7),40,103,57,52,54,52,41,0};
static C_char li1165[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,57,52,53,56,32,103,57,52,55,48,41,0,0,0,0};
static C_char li1166[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,57,52,53,51,32,105,41,0,0};
static C_char li1167[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,57,52,50,51,32,103,57,52,51,53,41,0,0,0,0};
static C_char li1168[] C_aligned={C_lihdr(0,0,38),40,115,99,104,101,109,101,35,118,101,99,116,111,114,45,102,111,114,45,101,97,99,104,32,112,114,111,99,32,118,32,46,32,109,111,114,101,41,0,0};
static C_char li1169[] C_aligned={C_lihdr(0,0,24),40,115,99,104,101,109,101,35,99,108,111,115,101,45,112,111,114,116,32,112,111,114,116,41};
static C_char li1170[] C_aligned={C_lihdr(0,0,8),40,97,51,57,48,55,48,41};
static C_char li1171[] C_aligned={C_lihdr(0,0,14),40,97,51,57,48,55,54,32,46,32,114,101,116,41,0,0};
static C_char li1172[] C_aligned={C_lihdr(0,0,33),40,115,99,104,101,109,101,35,99,97,108,108,45,119,105,116,104,45,112,111,114,116,32,112,111,114,116,32,112,114,111,99,41,0,0,0,0,0,0,0};
static C_char li1173[] C_aligned={C_lihdr(0,0,19),40,115,99,104,101,109,101,35,101,111,102,45,111,98,106,101,99,116,41,0,0,0,0,0};
static C_char li1174[] C_aligned={C_lihdr(0,0,23),40,115,99,104,101,109,101,35,112,101,101,107,45,117,56,32,46,32,114,118,97,114,41,0};
static C_char li1175[] C_aligned={C_lihdr(0,0,30),40,115,99,104,101,109,101,35,119,114,105,116,101,45,115,116,114,105,110,103,32,115,32,46,32,114,101,115,116,41,0,0};
static C_char li1176[] C_aligned={C_lihdr(0,0,19),40,100,111,108,111,111,112,57,53,56,50,32,120,32,105,32,120,115,41,0,0,0,0,0};
static C_char li1177[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,105,111,35,114,101,97,100,45,108,105,115,116,32,46,32,114,101,115,116,41,0,0,0};
static C_char li1178[] C_aligned={C_lihdr(0,0,10),40,103,57,54,48,54,32,114,108,41,0,0,0,0,0,0};
static C_char li1179[] C_aligned={C_lihdr(0,0,8),40,108,111,111,112,32,105,41};
static C_char li1180[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,105,111,35,114,101,97,100,45,108,105,110,101,32,46,32,97,114,103,115,41,0,0,0};
static C_char li1181[] C_aligned={C_lihdr(0,0,12),40,108,111,111,112,32,108,110,115,32,110,41,0,0,0,0};
static C_char li1182[] C_aligned={C_lihdr(0,0,30),40,99,104,105,99,107,101,110,46,105,111,35,114,101,97,100,45,108,105,110,101,115,32,46,32,114,101,115,116,41,0,0};
static C_char li1183[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,105,111,35,119,114,105,116,101,45,108,105,110,101,32,115,116,114,32,46,32,112,111,114,116,41,0,0,0,0,0,0};
static C_char li1184[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,115,116,97,114,116,32,110,32,109,41};
static C_char li1185[] C_aligned={C_lihdr(0,0,52),40,99,104,105,99,107,101,110,46,105,111,35,114,101,97,100,45,98,121,116,101,118,101,99,116,111,114,33,47,112,111,114,116,32,110,32,100,101,115,116,32,112,111,114,116,32,115,116,97,114,116,41,0,0,0,0};
static C_char li1186[] C_aligned={C_lihdr(0,0,23),40,97,51,57,55,51,53,32,100,98,117,102,32,115,116,97,114,116,32,108,101,110,41,0};
static C_char li1187[] C_aligned={C_lihdr(0,0,20),40,114,101,97,100,98,32,110,32,98,117,102,32,112,111,114,116,32,112,41,0,0,0,0};
static C_char li1188[] C_aligned={C_lihdr(0,0,14),40,102,105,110,105,115,104,32,98,121,116,101,115,41,0,0};
static C_char li1189[] C_aligned={C_lihdr(0,0,15),40,114,101,99,111,117,110,116,32,98,121,116,101,115,41,0};
static C_char li1190[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,112,32,110,32,117,110,32,98,110,41};
static C_char li1191[] C_aligned={C_lihdr(0,0,20),40,97,51,57,55,49,55,32,100,101,99,111,100,101,114,32,95,32,95,41,0,0,0,0};
static C_char li1192[] C_aligned={C_lihdr(0,0,48),40,99,104,105,99,107,101,110,46,105,111,35,114,101,97,100,45,115,116,114,105,110,103,33,47,112,111,114,116,32,110,32,100,101,115,116,32,112,111,114,116,32,115,116,97,114,116,41};
static C_char li1193[] C_aligned={C_lihdr(0,0,39),40,99,104,105,99,107,101,110,46,105,111,35,114,101,97,100,45,115,116,114,105,110,103,33,32,110,32,100,101,115,116,32,46,32,114,101,115,116,41,0};
static C_char li1194[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,105,111,35,114,101,97,100,45,98,121,116,101,118,101,99,116,111,114,33,32,100,101,115,116,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char li1195[] C_aligned={C_lihdr(0,0,16),40,97,52,48,48,53,57,32,98,117,102,32,108,101,110,41};
static C_char li1196[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,105,111,35,114,101,97,100,45,115,116,114,105,110,103,47,112,111,114,116,32,110,32,112,41,0,0,0,0,0,0,0};
static C_char li1197[] C_aligned={C_lihdr(0,0,20),40,108,111,111,112,32,98,117,102,32,98,115,105,122,101,32,112,111,115,41,0,0,0,0};
static C_char li1198[] C_aligned={C_lihdr(0,0,26),40,35,35,115,121,115,35,114,101,97,100,45,114,101,109,97,105,110,105,110,103,32,112,32,107,41,0,0,0,0,0,0};
static C_char li1199[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,105,111,35,114,101,97,100,45,98,121,116,101,118,101,99,116,111,114,47,112,111,114,116,32,110,32,112,41,0,0,0};
static C_char li1200[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,105,111,35,114,101,97,100,45,115,116,114,105,110,103,32,46,32,114,101,115,116,41,0};
static C_char li1201[] C_aligned={C_lihdr(0,0,16),40,97,52,48,50,51,49,32,98,117,102,32,108,101,110,41};
static C_char li1202[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,105,111,35,114,101,97,100,45,98,121,116,101,118,101,99,116,111,114,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li1203[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,105,111,35,114,101,97,100,45,98,117,102,102,101,114,101,100,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char li1204[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char li1205[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,105,111,35,114,101,97,100,45,116,111,107,101,110,32,112,114,101,100,32,46,32,112,111,114,116,41,0,0,0,0,0};
static C_char li1206[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,105,111,35,114,101,97,100,45,98,121,116,101,32,46,32,114,101,115,116,41,0,0,0};
static C_char li1207[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,105,111,35,119,114,105,116,101,45,98,121,116,101,32,98,121,116,101,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li1208[] C_aligned={C_lihdr(0,0,39),40,99,104,105,99,107,101,110,46,105,111,35,119,114,105,116,101,45,98,121,116,101,118,101,99,116,111,114,32,98,118,32,46,32,114,101,115,116,41,0};
static C_char li1209[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,56,54,56,54,32,103,56,54,57,56,41,0,0,0,0};
static C_char li1210[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,56,54,52,52,41,0,0,0,0,0};
static C_char li1211[] C_aligned={C_lihdr(0,0,12),40,97,52,48,54,55,50,32,110,101,119,41,0,0,0,0};
static C_char li1212[] C_aligned={C_lihdr(0,0,16),67,95,98,117,105,108,100,95,112,108,97,116,102,111,114,109};
static C_char li1213[] C_aligned={C_lihdr(0,0,18),67,95,115,111,102,116,119,97,114,101,95,118,101,114,115,105,111,110,0,0,0,0,0,0};
static C_char li1214[] C_aligned={C_lihdr(0,0,20),67,95,109,97,99,104,105,110,101,95,98,121,116,101,95,111,114,100,101,114,0,0,0,0};
static C_char li1215[] C_aligned={C_lihdr(0,0,14),67,95,109,97,99,104,105,110,101,95,116,121,112,101,0,0};
static C_char li1216[] C_aligned={C_lihdr(0,0,15),67,95,115,111,102,116,119,97,114,101,95,116,121,112,101,0};
static C_char li1217[] C_aligned={C_lihdr(0,0,12),40,97,52,48,55,55,49,32,115,121,109,41,0,0,0,0};
static C_char li1218[] C_aligned={C_lihdr(0,0,16),40,97,52,48,55,56,48,32,115,121,109,32,108,115,116,41};
static C_char li1219[] C_aligned={C_lihdr(0,0,10),40,97,52,48,56,50,48,32,120,41,0,0,0,0,0,0};
static C_char li1220[] C_aligned={C_lihdr(0,0,11),40,108,111,111,112,32,97,114,103,115,41,0,0,0,0,0};
static C_char li1221[] C_aligned={C_lihdr(0,0,19),40,102,52,57,48,51,48,32,120,56,49,51,51,52,57,48,50,57,41,0,0,0,0,0};
static C_char li1222[] C_aligned={C_lihdr(0,0,19),40,102,52,57,48,51,54,32,120,56,49,49,57,52,57,48,51,53,41,0,0,0,0,0};
static C_char li1223[] C_aligned={C_lihdr(0,0,19),40,102,52,57,48,52,50,32,120,56,49,49,57,52,57,48,52,49,41,0,0,0,0,0};
static C_char li1224[] C_aligned={C_lihdr(0,0,8),40,97,52,48,57,48,49,41};
static C_char li1225[] C_aligned={C_lihdr(0,0,12),40,97,52,48,57,50,54,32,100,105,114,41,0,0,0,0};
static C_char li1226[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,55,48,55,53,32,103,55,48,56,50,41,0,0,0,0,0,0,0};
static C_char li1227[] C_aligned={C_lihdr(0,0,8),40,97,52,48,57,54,56,41};
static C_char li1228[] C_aligned={C_lihdr(0,0,9),40,103,55,49,48,49,32,120,41,0,0,0,0,0,0,0};
static C_char li1229[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,55,49,48,48,32,103,55,49,48,55,41,0,0,0,0,0,0,0};
static C_char li1230[] C_aligned={C_lihdr(0,0,15),40,97,52,49,48,56,48,32,46,32,97,114,103,115,41,0};
static C_char li1231[] C_aligned={C_lihdr(0,0,19),40,97,52,48,57,52,49,32,109,115,103,32,46,32,97,114,103,115,41,0,0,0,0,0};
static C_char li1232[] C_aligned={C_lihdr(0,0,8),40,97,52,49,48,56,51,41};
static C_char li1233[] C_aligned={C_lihdr(0,0,8),40,97,52,49,48,57,50,41};
static C_char li1234[] C_aligned={C_lihdr(0,0,15),40,97,52,49,48,57,56,32,46,32,114,101,115,116,41,0};
static C_char li1235[] C_aligned={C_lihdr(0,0,10),40,97,52,49,51,53,55,32,120,41,0,0,0,0,0,0};
static C_char li1236[] C_aligned={C_lihdr(0,0,14),40,97,52,49,51,54,54,32,120,32,105,32,121,41,0,0};
static C_char li1237[] C_aligned={C_lihdr(0,0,12),40,97,52,49,51,55,54,32,120,32,121,41,0,0,0,0};
static C_char li1238[] C_aligned={C_lihdr(0,0,12),40,97,52,49,51,56,54,32,120,32,121,41,0,0,0,0};
static C_char li1239[] C_aligned={C_lihdr(0,0,12),40,97,52,49,51,57,54,32,120,32,121,41,0,0,0,0};
static C_char li1240[] C_aligned={C_lihdr(0,0,12),40,97,52,49,52,48,54,32,120,32,121,41,0,0,0,0};
static C_char li1241[] C_aligned={C_lihdr(0,0,12),40,97,52,49,52,49,54,32,120,32,121,41,0,0,0,0};
static C_char li1242[] C_aligned={C_lihdr(0,0,12),40,97,52,49,52,50,54,32,120,32,121,41,0,0,0,0};
static C_char li1243[] C_aligned={C_lihdr(0,0,12),40,97,52,49,52,51,54,32,120,32,121,41,0,0,0,0};
static C_char li1244[] C_aligned={C_lihdr(0,0,12),40,97,52,49,52,52,54,32,120,32,121,41,0,0,0,0};
static C_char li1245[] C_aligned={C_lihdr(0,0,12),40,97,52,49,52,53,54,32,120,32,121,41,0,0,0,0};
static C_char li1246[] C_aligned={C_lihdr(0,0,12),40,97,52,49,52,54,54,32,120,32,121,41,0,0,0,0};
static C_char li1247[] C_aligned={C_lihdr(0,0,12),40,97,52,49,52,55,54,32,120,32,121,41,0,0,0,0};
static C_char li1248[] C_aligned={C_lihdr(0,0,12),40,97,52,49,52,56,54,32,120,32,121,41,0,0,0,0};
static C_char li1249[] C_aligned={C_lihdr(0,0,10),40,97,52,49,53,50,48,32,120,41,0,0,0,0,0,0};
static C_char li1250[] C_aligned={C_lihdr(0,0,13),40,97,52,49,52,57,54,32,112,114,111,99,41,0,0,0};
static C_char li1251[] C_aligned={C_lihdr(0,0,10),40,97,52,49,53,51,54,32,120,41,0,0,0,0,0,0};
static C_char li1252[] C_aligned={C_lihdr(0,0,10),40,97,52,49,53,57,49,32,120,41,0,0,0,0,0,0};
static C_char li1253[] C_aligned={C_lihdr(0,0,15),40,97,52,49,54,48,55,32,112,114,111,99,32,105,41,0};
static C_char li1254[] C_aligned={C_lihdr(0,0,16),40,97,52,49,53,54,50,32,103,101,116,32,115,101,116,41};
static C_char li1255[] C_aligned={C_lihdr(0,0,15),40,97,52,49,53,53,50,32,112,114,111,99,32,105,41,0};
static C_char li1256[] C_aligned={C_lihdr(0,0,10),40,116,111,112,108,101,118,101,108,41,0,0,0,0,0,0};


#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
C_regparm static C_word stub8108(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word i=(C_word )(C_a0);
C_return(C_main_argv[C_unfix(i)]);
C_ret:
#undef return

return C_r;}

/* from chicken.process-context#executable-pathname in k35705 in k35069 in k34849 in k34423 in k34420 in k34417 in k34414 in k34409 in k34405 in k34264 in k33248 in k33245 in k33242 in k32475 in k32136 in k32132 in k32128 in k30988 in k29792 in k29788 in k29784 in ... */
C_regparm static C_word stub8100(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_mpointer(&C_a,(void*)C_executable_pathname());
return C_r;}

/* from k35733 */
C_regparm static C_word stub8076(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenventry(t0));
return C_r;}

/* from chicken.process-context#_getenv */
C_regparm static C_word stub8068(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_r=C_mpointer(&C_a,(void*)C_getenv(t0));
return C_r;}

/* from k34719 */
C_regparm static C_word stub7743(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
C_free(t0);
return C_r;}

/* from k34710 */
C_regparm static C_word stub7735(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_mpointer(&C_a,(void*)C_peek_c_string_at(t0,t1));
return C_r;}

/* from k34658 */
C_regparm static C_word stub7716(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_mpointer(&C_a,(void*)C_peek_c_string_at(t0,t1));
return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
C_regparm static C_word stub6822(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word x=(C_word )(C_a0);
C_return((C_char *)x);
C_ret:
#undef return

return C_r;}

/* from k20277 */
C_regparm static C_word stub3495(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
double t0=(double )C_c_double(C_a0);
int t1=(int )C_unfix(C_a1);
C_r=C_flonum(&C_a,ldexp(t0,t1));
return C_r;}

C_noret_decl(f45103)
static void C_ccall f45103(C_word c,C_word *av) C_noret;
C_noret_decl(f45302)
static void C_ccall f45302(C_word c,C_word *av) C_noret;
C_noret_decl(f45306)
static void C_ccall f45306(C_word c,C_word *av) C_noret;
C_noret_decl(f45436)
static void C_ccall f45436(C_word c,C_word *av) C_noret;
C_noret_decl(f45441)
static void C_ccall f45441(C_word c,C_word *av) C_noret;
C_noret_decl(f45448)
static void C_ccall f45448(C_word c,C_word *av) C_noret;
C_noret_decl(f45457)
static void C_ccall f45457(C_word c,C_word *av) C_noret;
C_noret_decl(f45466)
static void C_ccall f45466(C_word c,C_word *av) C_noret;
C_noret_decl(f49030)
static void C_ccall f49030(C_word c,C_word *av) C_noret;
C_noret_decl(f49036)
static void C_ccall f49036(C_word c,C_word *av) C_noret;
C_noret_decl(f49042)
static void C_ccall f49042(C_word c,C_word *av) C_noret;
C_noret_decl(f_11435)
static void C_ccall f_11435(C_word c,C_word *av) C_noret;
C_noret_decl(f_11437)
static void C_ccall f_11437(C_word c,C_word *av) C_noret;
C_noret_decl(f_11440)
static void C_ccall f_11440(C_word c,C_word *av) C_noret;
C_noret_decl(f_11443)
static void C_ccall f_11443(C_word c,C_word *av) C_noret;
C_noret_decl(f_11446)
static void C_ccall f_11446(C_word c,C_word *av) C_noret;
C_noret_decl(f_11449)
static void C_ccall f_11449(C_word c,C_word *av) C_noret;
C_noret_decl(f_11452)
static void C_ccall f_11452(C_word c,C_word *av) C_noret;
C_noret_decl(f_11468)
static C_word f_11468(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_11497)
static void C_ccall f_11497(C_word c,C_word *av) C_noret;
C_noret_decl(f_11513)
static C_word f_11513(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_11542)
static void C_ccall f_11542(C_word c,C_word *av) C_noret;
C_noret_decl(f_11545)
static void C_ccall f_11545(C_word c,C_word *av) C_noret;
C_noret_decl(f_11548)
static void C_ccall f_11548(C_word c,C_word *av) C_noret;
C_noret_decl(f_11551)
static void C_ccall f_11551(C_word c,C_word *av) C_noret;
C_noret_decl(f_11554)
static void C_ccall f_11554(C_word c,C_word *av) C_noret;
C_noret_decl(f_11557)
static void C_ccall f_11557(C_word c,C_word *av) C_noret;
C_noret_decl(f_11560)
static void C_ccall f_11560(C_word c,C_word *av) C_noret;
C_noret_decl(f_11563)
static void C_ccall f_11563(C_word c,C_word *av) C_noret;
C_noret_decl(f_11566)
static void C_ccall f_11566(C_word c,C_word *av) C_noret;
C_noret_decl(f_11569)
static void C_ccall f_11569(C_word c,C_word *av) C_noret;
C_noret_decl(f_11572)
static void C_ccall f_11572(C_word c,C_word *av) C_noret;
C_noret_decl(f_11575)
static void C_ccall f_11575(C_word c,C_word *av) C_noret;
C_noret_decl(f_11578)
static void C_ccall f_11578(C_word c,C_word *av) C_noret;
C_noret_decl(f_11581)
static void C_ccall f_11581(C_word c,C_word *av) C_noret;
C_noret_decl(f_11595)
static void C_ccall f_11595(C_word c,C_word *av) C_noret;
C_noret_decl(f_11602)
static void C_ccall f_11602(C_word c,C_word *av) C_noret;
C_noret_decl(f_11609)
static void C_ccall f_11609(C_word c,C_word *av) C_noret;
C_noret_decl(f_11623)
static void C_ccall f_11623(C_word c,C_word *av) C_noret;
C_noret_decl(f_11630)
static void C_ccall f_11630(C_word c,C_word *av) C_noret;
C_noret_decl(f_11644)
static void C_ccall f_11644(C_word c,C_word *av) C_noret;
C_noret_decl(f_11658)
static void C_ccall f_11658(C_word c,C_word *av) C_noret;
C_noret_decl(f_11676)
static void C_ccall f_11676(C_word c,C_word *av) C_noret;
C_noret_decl(f_11687)
static void C_ccall f_11687(C_word c,C_word *av) C_noret;
C_noret_decl(f_11698)
static void C_ccall f_11698(C_word c,C_word *av) C_noret;
C_noret_decl(f_11705)
static void C_ccall f_11705(C_word c,C_word *av) C_noret;
C_noret_decl(f_11716)
static void C_ccall f_11716(C_word c,C_word *av) C_noret;
C_noret_decl(f_11720)
static void C_ccall f_11720(C_word c,C_word *av) C_noret;
C_noret_decl(f_11727)
static void C_ccall f_11727(C_word c,C_word *av) C_noret;
C_noret_decl(f_11745)
static void C_ccall f_11745(C_word c,C_word *av) C_noret;
C_noret_decl(f_11756)
static void C_ccall f_11756(C_word c,C_word *av) C_noret;
C_noret_decl(f_11767)
static void C_ccall f_11767(C_word c,C_word *av) C_noret;
C_noret_decl(f_11774)
static void C_ccall f_11774(C_word c,C_word *av) C_noret;
C_noret_decl(f_11792)
static void C_ccall f_11792(C_word c,C_word *av) C_noret;
C_noret_decl(f_11803)
static void C_ccall f_11803(C_word c,C_word *av) C_noret;
C_noret_decl(f_11821)
static void C_ccall f_11821(C_word c,C_word *av) C_noret;
C_noret_decl(f_11827)
static void C_ccall f_11827(C_word c,C_word *av) C_noret;
C_noret_decl(f_11830)
static void C_ccall f_11830(C_word c,C_word *av) C_noret;
C_noret_decl(f_11833)
static void C_ccall f_11833(C_word c,C_word *av) C_noret;
C_noret_decl(f_11836)
static void C_ccall f_11836(C_word c,C_word *av) C_noret;
C_noret_decl(f_11839)
static void C_ccall f_11839(C_word c,C_word *av) C_noret;
C_noret_decl(f_11845)
static void f_11845(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_11878)
static void C_ccall f_11878(C_word c,C_word *av) C_noret;
C_noret_decl(f_11881)
static void C_ccall f_11881(C_word c,C_word *av) C_noret;
C_noret_decl(f_11884)
static void C_ccall f_11884(C_word c,C_word *av) C_noret;
C_noret_decl(f_11896)
static void f_11896(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_11909)
static void C_ccall f_11909(C_word c,C_word *av) C_noret;
C_noret_decl(f_11928)
static void C_ccall f_11928(C_word c,C_word *av) C_noret;
C_noret_decl(f_11931)
static void C_ccall f_11931(C_word c,C_word *av) C_noret;
C_noret_decl(f_11934)
static void C_ccall f_11934(C_word c,C_word *av) C_noret;
C_noret_decl(f_11946)
static void f_11946(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_11959)
static void C_ccall f_11959(C_word c,C_word *av) C_noret;
C_noret_decl(f_11983)
static void C_ccall f_11983(C_word c,C_word *av) C_noret;
C_noret_decl(f_11986)
static void C_ccall f_11986(C_word c,C_word *av) C_noret;
C_noret_decl(f_11989)
static void C_ccall f_11989(C_word c,C_word *av) C_noret;
C_noret_decl(f_11992)
static void C_ccall f_11992(C_word c,C_word *av) C_noret;
C_noret_decl(f_11995)
static void C_ccall f_11995(C_word c,C_word *av) C_noret;
C_noret_decl(f_11998)
static void C_ccall f_11998(C_word c,C_word *av) C_noret;
C_noret_decl(f_12005)
static C_word f_12005(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_12031)
static void C_ccall f_12031(C_word c,C_word *av) C_noret;
C_noret_decl(f_12038)
static C_word f_12038(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_12082)
static void C_ccall f_12082(C_word c,C_word *av) C_noret;
C_noret_decl(f_12085)
static void C_ccall f_12085(C_word c,C_word *av) C_noret;
C_noret_decl(f_12091)
static void C_ccall f_12091(C_word c,C_word *av) C_noret;
C_noret_decl(f_12094)
static void C_ccall f_12094(C_word c,C_word *av) C_noret;
C_noret_decl(f_12097)
static void C_ccall f_12097(C_word c,C_word *av) C_noret;
C_noret_decl(f_12100)
static void C_ccall f_12100(C_word c,C_word *av) C_noret;
C_noret_decl(f_12103)
static void C_ccall f_12103(C_word c,C_word *av) C_noret;
C_noret_decl(f_12111)
static void C_ccall f_12111(C_word c,C_word *av) C_noret;
C_noret_decl(f_12115)
static void C_ccall f_12115(C_word c,C_word *av) C_noret;
C_noret_decl(f_12118)
static void C_ccall f_12118(C_word c,C_word *av) C_noret;
C_noret_decl(f_12121)
static void C_ccall f_12121(C_word c,C_word *av) C_noret;
C_noret_decl(f_12124)
static void C_ccall f_12124(C_word c,C_word *av) C_noret;
C_noret_decl(f_12127)
static void C_ccall f_12127(C_word c,C_word *av) C_noret;
C_noret_decl(f_12130)
static void C_ccall f_12130(C_word c,C_word *av) C_noret;
C_noret_decl(f_12133)
static void C_ccall f_12133(C_word c,C_word *av) C_noret;
C_noret_decl(f_12136)
static void C_ccall f_12136(C_word c,C_word *av) C_noret;
C_noret_decl(f_12140)
static void C_ccall f_12140(C_word c,C_word *av) C_noret;
C_noret_decl(f_12143)
static void C_ccall f_12143(C_word c,C_word *av) C_noret;
C_noret_decl(f_12146)
static void C_ccall f_12146(C_word c,C_word *av) C_noret;
C_noret_decl(f_12149)
static void C_ccall f_12149(C_word c,C_word *av) C_noret;
C_noret_decl(f_12152)
static void C_ccall f_12152(C_word c,C_word *av) C_noret;
C_noret_decl(f_12160)
static void C_ccall f_12160(C_word c,C_word *av) C_noret;
C_noret_decl(f_12163)
static void C_ccall f_12163(C_word c,C_word *av) C_noret;
C_noret_decl(f_12170)
static void C_ccall f_12170(C_word c,C_word *av) C_noret;
C_noret_decl(f_12177)
static void C_ccall f_12177(C_word c,C_word *av) C_noret;
C_noret_decl(f_12190)
static C_word f_12190(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_12216)
static void C_ccall f_12216(C_word c,C_word *av) C_noret;
C_noret_decl(f_12229)
static C_word f_12229(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_12255)
static void C_ccall f_12255(C_word c,C_word *av) C_noret;
C_noret_decl(f_12268)
static C_word f_12268(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_12294)
static void C_ccall f_12294(C_word c,C_word *av) C_noret;
C_noret_decl(f_12307)
static C_word f_12307(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_12333)
static void C_ccall f_12333(C_word c,C_word *av) C_noret;
C_noret_decl(f_12346)
static C_word f_12346(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_12372)
static void C_ccall f_12372(C_word c,C_word *av) C_noret;
C_noret_decl(f_12378)
static void C_ccall f_12378(C_word c,C_word *av) C_noret;
C_noret_decl(f_12389)
static void C_ccall f_12389(C_word c,C_word *av) C_noret;
C_noret_decl(f_12395)
static void C_ccall f_12395(C_word c,C_word *av) C_noret;
C_noret_decl(f_12401)
static void C_ccall f_12401(C_word c,C_word *av) C_noret;
C_noret_decl(f_12407)
static void C_ccall f_12407(C_word c,C_word *av) C_noret;
C_noret_decl(f_12413)
static void C_ccall f_12413(C_word c,C_word *av) C_noret;
C_noret_decl(f_12419)
static void C_ccall f_12419(C_word c,C_word *av) C_noret;
C_noret_decl(f_12435)
static void C_ccall f_12435(C_word c,C_word *av) C_noret;
C_noret_decl(f_12443)
static void C_ccall f_12443(C_word c,C_word *av) C_noret;
C_noret_decl(f_12449)
static void C_ccall f_12449(C_word c,C_word *av) C_noret;
C_noret_decl(f_12455)
static void C_ccall f_12455(C_word c,C_word *av) C_noret;
C_noret_decl(f_12462)
static void C_ccall f_12462(C_word c,C_word *av) C_noret;
C_noret_decl(f_12471)
static void C_ccall f_12471(C_word c,C_word *av) C_noret;
C_noret_decl(f_12478)
static void C_ccall f_12478(C_word c,C_word *av) C_noret;
C_noret_decl(f_12487)
static void C_ccall f_12487(C_word c,C_word *av) C_noret;
C_noret_decl(f_12493)
static void C_ccall f_12493(C_word c,C_word *av) C_noret;
C_noret_decl(f_12498)
static void C_ccall f_12498(C_word c,C_word *av) C_noret;
C_noret_decl(f_12513)
static void C_ccall f_12513(C_word c,C_word *av) C_noret;
C_noret_decl(f_12524)
static void C_ccall f_12524(C_word c,C_word *av) C_noret;
C_noret_decl(f_12530)
static void C_ccall f_12530(C_word c,C_word *av) C_noret;
C_noret_decl(f_12536)
static void C_ccall f_12536(C_word c,C_word *av) C_noret;
C_noret_decl(f_12542)
static void C_ccall f_12542(C_word c,C_word *av) C_noret;
C_noret_decl(f_12548)
static void C_ccall f_12548(C_word c,C_word *av) C_noret;
C_noret_decl(f_12558)
static void C_ccall f_12558(C_word c,C_word *av) C_noret;
C_noret_decl(f_12560)
static void C_ccall f_12560(C_word c,C_word *av) C_noret;
C_noret_decl(f_12563)
static void C_ccall f_12563(C_word c,C_word *av) C_noret;
C_noret_decl(f_12566)
static void C_ccall f_12566(C_word c,C_word *av) C_noret;
C_noret_decl(f_12569)
static void C_ccall f_12569(C_word c,C_word *av) C_noret;
C_noret_decl(f_12572)
static void C_ccall f_12572(C_word c,C_word *av) C_noret;
C_noret_decl(f_12575)
static void C_ccall f_12575(C_word c,C_word *av) C_noret;
C_noret_decl(f_12580)
static void C_ccall f_12580(C_word c,C_word *av) C_noret;
C_noret_decl(f_12586)
static void C_ccall f_12586(C_word c,C_word *av) C_noret;
C_noret_decl(f_12592)
static void C_ccall f_12592(C_word c,C_word *av) C_noret;
C_noret_decl(f_12627)
static void C_ccall f_12627(C_word c,C_word *av) C_noret;
C_noret_decl(f_12630)
static void C_ccall f_12630(C_word c,C_word *av) C_noret;
C_noret_decl(f_12633)
static void C_ccall f_12633(C_word c,C_word *av) C_noret;
C_noret_decl(f_12641)
static void C_ccall f_12641(C_word c,C_word *av) C_noret;
C_noret_decl(f_12647)
static void C_ccall f_12647(C_word c,C_word *av) C_noret;
C_noret_decl(f_12654)
static void C_ccall f_12654(C_word c,C_word *av) C_noret;
C_noret_decl(f_12669)
static void C_ccall f_12669(C_word c,C_word *av) C_noret;
C_noret_decl(f_12683)
static void C_ccall f_12683(C_word c,C_word *av) C_noret;
C_noret_decl(f_12689)
static void C_ccall f_12689(C_word c,C_word *av) C_noret;
C_noret_decl(f_12695)
static void C_ccall f_12695(C_word c,C_word *av) C_noret;
C_noret_decl(f_12702)
static void C_ccall f_12702(C_word c,C_word *av) C_noret;
C_noret_decl(f_12707)
static void C_ccall f_12707(C_word c,C_word *av) C_noret;
C_noret_decl(f_12710)
static void C_ccall f_12710(C_word c,C_word *av) C_noret;
C_noret_decl(f_12719)
static void f_12719(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_12737)
static void C_ccall f_12737(C_word c,C_word *av) C_noret;
C_noret_decl(f_12747)
static void C_ccall f_12747(C_word c,C_word *av) C_noret;
C_noret_decl(f_12756)
static void f_12756(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_12774)
static void C_ccall f_12774(C_word c,C_word *av) C_noret;
C_noret_decl(f_12787)
static void C_ccall f_12787(C_word c,C_word *av) C_noret;
C_noret_decl(f_12794)
static void C_ccall f_12794(C_word c,C_word *av) C_noret;
C_noret_decl(f_12801)
static void C_ccall f_12801(C_word c,C_word *av) C_noret;
C_noret_decl(f_12812)
static void C_ccall f_12812(C_word c,C_word *av) C_noret;
C_noret_decl(f_12831)
static void C_ccall f_12831(C_word c,C_word *av) C_noret;
C_noret_decl(f_12834)
static void C_ccall f_12834(C_word c,C_word *av) C_noret;
C_noret_decl(f_12836)
static void C_ccall f_12836(C_word c,C_word *av) C_noret;
C_noret_decl(f_12842)
static void f_12842(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_12858)
static void C_ccall f_12858(C_word c,C_word *av) C_noret;
C_noret_decl(f_12867)
static void C_ccall f_12867(C_word c,C_word *av) C_noret;
C_noret_decl(f_12869)
static void C_ccall f_12869(C_word c,C_word *av) C_noret;
C_noret_decl(f_12875)
static void f_12875(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_12888)
static void C_ccall f_12888(C_word c,C_word *av) C_noret;
C_noret_decl(f_12904)
static void C_ccall f_12904(C_word c,C_word *av) C_noret;
C_noret_decl(f_12915)
static void C_ccall f_12915(C_word c,C_word *av) C_noret;
C_noret_decl(f_12917)
static void C_ccall f_12917(C_word c,C_word *av) C_noret;
C_noret_decl(f_12925)
static void C_ccall f_12925(C_word c,C_word *av) C_noret;
C_noret_decl(f_12927)
static void C_ccall f_12927(C_word c,C_word *av) C_noret;
C_noret_decl(f_12933)
static void C_ccall f_12933(C_word c,C_word *av) C_noret;
C_noret_decl(f_12935)
static void C_ccall f_12935(C_word c,C_word *av) C_noret;
C_noret_decl(f_12943)
static void C_ccall f_12943(C_word c,C_word *av) C_noret;
C_noret_decl(f_12945)
static void C_ccall f_12945(C_word c,C_word *av) C_noret;
C_noret_decl(f_12948)
static void C_ccall f_12948(C_word c,C_word *av) C_noret;
C_noret_decl(f_12956)
static void C_ccall f_12956(C_word c,C_word *av) C_noret;
C_noret_decl(f_12962)
static void C_ccall f_12962(C_word c,C_word *av) C_noret;
C_noret_decl(f_12970)
static void C_ccall f_12970(C_word c,C_word *av) C_noret;
C_noret_decl(f_12981)
static void C_ccall f_12981(C_word c,C_word *av) C_noret;
C_noret_decl(f_12993)
static void f_12993(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_13007)
static void C_ccall f_13007(C_word c,C_word *av) C_noret;
C_noret_decl(f_13015)
static void C_ccall f_13015(C_word c,C_word *av) C_noret;
C_noret_decl(f_13018)
static void C_ccall f_13018(C_word c,C_word *av) C_noret;
C_noret_decl(f_13020)
static void C_ccall f_13020(C_word c,C_word *av) C_noret;
C_noret_decl(f_13022)
static void C_ccall f_13022(C_word c,C_word *av) C_noret;
C_noret_decl(f_13028)
static void f_13028(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_13047)
static void C_ccall f_13047(C_word c,C_word *av) C_noret;
C_noret_decl(f_13064)
static void C_ccall f_13064(C_word c,C_word *av) C_noret;
C_noret_decl(f_13072)
static void C_ccall f_13072(C_word c,C_word *av) C_noret;
C_noret_decl(f_13086)
static void C_ccall f_13086(C_word c,C_word *av) C_noret;
C_noret_decl(f_13092)
static void f_13092(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_13111)
static void C_ccall f_13111(C_word c,C_word *av) C_noret;
C_noret_decl(f_13120)
static void C_ccall f_13120(C_word c,C_word *av) C_noret;
C_noret_decl(f_13123)
static void C_ccall f_13123(C_word c,C_word *av) C_noret;
C_noret_decl(f_13126)
static void C_ccall f_13126(C_word c,C_word *av) C_noret;
C_noret_decl(f_13129)
static void C_ccall f_13129(C_word c,C_word *av) C_noret;
C_noret_decl(f_13132)
static void C_ccall f_13132(C_word c,C_word *av) C_noret;
C_noret_decl(f_13141)
static C_word f_13141(C_word t0,C_word t1);
C_noret_decl(f_13160)
static void C_ccall f_13160(C_word c,C_word *av) C_noret;
C_noret_decl(f_13166)
static void f_13166(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_13191)
static void C_ccall f_13191(C_word c,C_word *av) C_noret;
C_noret_decl(f_13193)
static void C_ccall f_13193(C_word c,C_word *av) C_noret;
C_noret_decl(f_13202)
static void f_13202(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_13223)
static void C_ccall f_13223(C_word c,C_word *av) C_noret;
C_noret_decl(f_13225)
static void C_ccall f_13225(C_word c,C_word *av) C_noret;
C_noret_decl(f_13231)
static void f_13231(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_13257)
static void C_ccall f_13257(C_word c,C_word *av) C_noret;
C_noret_decl(f_13264)
static void C_ccall f_13264(C_word c,C_word *av) C_noret;
C_noret_decl(f_13266)
static void C_ccall f_13266(C_word c,C_word *av) C_noret;
C_noret_decl(f_13278)
static void f_13278(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_13313)
static void C_ccall f_13313(C_word c,C_word *av) C_noret;
C_noret_decl(f_13323)
static void C_ccall f_13323(C_word c,C_word *av) C_noret;
C_noret_decl(f_13332)
static void f_13332(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_13374)
static void C_ccall f_13374(C_word c,C_word *av) C_noret;
C_noret_decl(f_13403)
static void C_ccall f_13403(C_word c,C_word *av) C_noret;
C_noret_decl(f_13409)
static void C_ccall f_13409(C_word c,C_word *av) C_noret;
C_noret_decl(f_13423)
static void C_ccall f_13423(C_word c,C_word *av) C_noret;
C_noret_decl(f_13429)
static void C_ccall f_13429(C_word c,C_word *av) C_noret;
C_noret_decl(f_13436)
static void f_13436(C_word t0,C_word t1) C_noret;
C_noret_decl(f_13439)
static void C_ccall f_13439(C_word c,C_word *av) C_noret;
C_noret_decl(f_13468)
static void C_ccall f_13468(C_word c,C_word *av) C_noret;
C_noret_decl(f_13474)
static void f_13474(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_13490)
static void C_ccall f_13490(C_word c,C_word *av) C_noret;
C_noret_decl(f_13515)
static void C_ccall f_13515(C_word c,C_word *av) C_noret;
C_noret_decl(f_13524)
static void f_13524(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_13565)
static void C_ccall f_13565(C_word c,C_word *av) C_noret;
C_noret_decl(f_13587)
static void C_ccall f_13587(C_word c,C_word *av) C_noret;
C_noret_decl(f_13619)
static void C_ccall f_13619(C_word c,C_word *av) C_noret;
C_noret_decl(f_13635)
static void f_13635(C_word t0,C_word t1) C_noret;
C_noret_decl(f_13638)
static void C_ccall f_13638(C_word c,C_word *av) C_noret;
C_noret_decl(f_13660)
static void C_ccall f_13660(C_word c,C_word *av) C_noret;
C_noret_decl(f_13666)
static void f_13666(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_13691)
static void C_ccall f_13691(C_word c,C_word *av) C_noret;
C_noret_decl(f_13731)
static void C_ccall f_13731(C_word c,C_word *av) C_noret;
C_noret_decl(f_13743)
static void f_13743(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_13762)
static void C_ccall f_13762(C_word c,C_word *av) C_noret;
C_noret_decl(f_13779)
static void C_ccall f_13779(C_word c,C_word *av) C_noret;
C_noret_decl(f_13786)
static void C_ccall f_13786(C_word c,C_word *av) C_noret;
C_noret_decl(f_13796)
static void C_ccall f_13796(C_word c,C_word *av) C_noret;
C_noret_decl(f_13807)
static void C_ccall f_13807(C_word c,C_word *av) C_noret;
C_noret_decl(f_13811)
static void C_ccall f_13811(C_word c,C_word *av) C_noret;
C_noret_decl(f_13824)
static void C_ccall f_13824(C_word c,C_word *av) C_noret;
C_noret_decl(f_13826)
static void C_ccall f_13826(C_word c,C_word *av) C_noret;
C_noret_decl(f_13860)
static void C_ccall f_13860(C_word c,C_word *av) C_noret;
C_noret_decl(f_13864)
static void C_ccall f_13864(C_word c,C_word *av) C_noret;
C_noret_decl(f_13882)
static void C_ccall f_13882(C_word c,C_word *av) C_noret;
C_noret_decl(f_13895)
static void C_ccall f_13895(C_word c,C_word *av) C_noret;
C_noret_decl(f_13904)
static void C_ccall f_13904(C_word c,C_word *av) C_noret;
C_noret_decl(f_13910)
static void C_ccall f_13910(C_word c,C_word *av) C_noret;
C_noret_decl(f_13920)
static void C_ccall f_13920(C_word c,C_word *av) C_noret;
C_noret_decl(f_13924)
static void C_ccall f_13924(C_word c,C_word *av) C_noret;
C_noret_decl(f_13928)
static void C_ccall f_13928(C_word c,C_word *av) C_noret;
C_noret_decl(f_13932)
static void C_ccall f_13932(C_word c,C_word *av) C_noret;
C_noret_decl(f_13935)
static void C_ccall f_13935(C_word c,C_word *av) C_noret;
C_noret_decl(f_13937)
static void f_13937(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_13941)
static void f_13941(C_word t0,C_word t1) C_noret;
C_noret_decl(f_13945)
static void C_ccall f_13945(C_word c,C_word *av) C_noret;
C_noret_decl(f_13949)
static void C_ccall f_13949(C_word c,C_word *av) C_noret;
C_noret_decl(f_13953)
static void C_ccall f_13953(C_word c,C_word *av) C_noret;
C_noret_decl(f_13968)
static void C_ccall f_13968(C_word c,C_word *av) C_noret;
C_noret_decl(f_13985)
static void C_ccall f_13985(C_word c,C_word *av) C_noret;
C_noret_decl(f_13991)
static void C_ccall f_13991(C_word c,C_word *av) C_noret;
C_noret_decl(f_13997)
static void C_ccall f_13997(C_word c,C_word *av) C_noret;
C_noret_decl(f_14000)
static void f_14000(C_word t0,C_word t1) C_noret;
C_noret_decl(f_14007)
static void C_ccall f_14007(C_word c,C_word *av) C_noret;
C_noret_decl(f_14044)
static void C_ccall f_14044(C_word c,C_word *av) C_noret;
C_noret_decl(f_14047)
static void C_ccall f_14047(C_word c,C_word *av) C_noret;
C_noret_decl(f_14050)
static void C_ccall f_14050(C_word c,C_word *av) C_noret;
C_noret_decl(f_14053)
static void C_ccall f_14053(C_word c,C_word *av) C_noret;
C_noret_decl(f_14059)
static void C_ccall f_14059(C_word c,C_word *av) C_noret;
C_noret_decl(f_14062)
static void C_ccall f_14062(C_word c,C_word *av) C_noret;
C_noret_decl(f_14065)
static void C_ccall f_14065(C_word c,C_word *av) C_noret;
C_noret_decl(f_14068)
static void C_ccall f_14068(C_word c,C_word *av) C_noret;
C_noret_decl(f_14071)
static void C_ccall f_14071(C_word c,C_word *av) C_noret;
C_noret_decl(f_14074)
static void C_ccall f_14074(C_word c,C_word *av) C_noret;
C_noret_decl(f_14077)
static void C_ccall f_14077(C_word c,C_word *av) C_noret;
C_noret_decl(f_14080)
static void C_ccall f_14080(C_word c,C_word *av) C_noret;
C_noret_decl(f_14083)
static void C_ccall f_14083(C_word c,C_word *av) C_noret;
C_noret_decl(f_14086)
static void C_ccall f_14086(C_word c,C_word *av) C_noret;
C_noret_decl(f_14089)
static void C_ccall f_14089(C_word c,C_word *av) C_noret;
C_noret_decl(f_14092)
static void C_ccall f_14092(C_word c,C_word *av) C_noret;
C_noret_decl(f_14095)
static void C_ccall f_14095(C_word c,C_word *av) C_noret;
C_noret_decl(f_14098)
static void C_ccall f_14098(C_word c,C_word *av) C_noret;
C_noret_decl(f_14101)
static void C_ccall f_14101(C_word c,C_word *av) C_noret;
C_noret_decl(f_14104)
static void C_ccall f_14104(C_word c,C_word *av) C_noret;
C_noret_decl(f_14107)
static void C_ccall f_14107(C_word c,C_word *av) C_noret;
C_noret_decl(f_14110)
static void C_ccall f_14110(C_word c,C_word *av) C_noret;
C_noret_decl(f_14113)
static void C_ccall f_14113(C_word c,C_word *av) C_noret;
C_noret_decl(f_14116)
static void C_ccall f_14116(C_word c,C_word *av) C_noret;
C_noret_decl(f_14119)
static void C_ccall f_14119(C_word c,C_word *av) C_noret;
C_noret_decl(f_14122)
static void C_ccall f_14122(C_word c,C_word *av) C_noret;
C_noret_decl(f_14125)
static void C_ccall f_14125(C_word c,C_word *av) C_noret;
C_noret_decl(f_14128)
static void C_ccall f_14128(C_word c,C_word *av) C_noret;
C_noret_decl(f_14131)
static void C_ccall f_14131(C_word c,C_word *av) C_noret;
C_noret_decl(f_14136)
static void C_ccall f_14136(C_word c,C_word *av) C_noret;
C_noret_decl(f_14145)
static void C_ccall f_14145(C_word c,C_word *av) C_noret;
C_noret_decl(f_14157)
static void C_ccall f_14157(C_word c,C_word *av) C_noret;
C_noret_decl(f_14171)
static void C_ccall f_14171(C_word c,C_word *av) C_noret;
C_noret_decl(f_14187)
static void C_ccall f_14187(C_word c,C_word *av) C_noret;
C_noret_decl(f_14190)
static void C_ccall f_14190(C_word c,C_word *av) C_noret;
C_noret_decl(f_14199)
static void C_ccall f_14199(C_word c,C_word *av) C_noret;
C_noret_decl(f_14203)
static void C_ccall f_14203(C_word c,C_word *av) C_noret;
C_noret_decl(f_14205)
static void C_ccall f_14205(C_word c,C_word *av) C_noret;
C_noret_decl(f_14209)
static void C_ccall f_14209(C_word c,C_word *av) C_noret;
C_noret_decl(f_14212)
static void C_ccall f_14212(C_word c,C_word *av) C_noret;
C_noret_decl(f_14223)
static void C_ccall f_14223(C_word c,C_word *av) C_noret;
C_noret_decl(f_14225)
static void C_ccall f_14225(C_word c,C_word *av) C_noret;
C_noret_decl(f_14232)
static void C_ccall f_14232(C_word c,C_word *av) C_noret;
C_noret_decl(f_14235)
static void C_ccall f_14235(C_word c,C_word *av) C_noret;
C_noret_decl(f_14240)
static void C_ccall f_14240(C_word c,C_word *av) C_noret;
C_noret_decl(f_14244)
static void C_ccall f_14244(C_word c,C_word *av) C_noret;
C_noret_decl(f_14249)
static void C_ccall f_14249(C_word c,C_word *av) C_noret;
C_noret_decl(f_14253)
static void C_ccall f_14253(C_word c,C_word *av) C_noret;
C_noret_decl(f_14284)
static void C_ccall f_14284(C_word c,C_word *av) C_noret;
C_noret_decl(f_14287)
static void C_ccall f_14287(C_word c,C_word *av) C_noret;
C_noret_decl(f_14290)
static void C_ccall f_14290(C_word c,C_word *av) C_noret;
C_noret_decl(f_14307)
static void C_ccall f_14307(C_word c,C_word *av) C_noret;
C_noret_decl(f_14318)
static void C_ccall f_14318(C_word c,C_word *av) C_noret;
C_noret_decl(f_14329)
static void C_ccall f_14329(C_word c,C_word *av) C_noret;
C_noret_decl(f_14340)
static void C_ccall f_14340(C_word c,C_word *av) C_noret;
C_noret_decl(f_14351)
static void C_ccall f_14351(C_word c,C_word *av) C_noret;
C_noret_decl(f_14362)
static void C_ccall f_14362(C_word c,C_word *av) C_noret;
C_noret_decl(f_14373)
static void C_ccall f_14373(C_word c,C_word *av) C_noret;
C_noret_decl(f_14384)
static void C_ccall f_14384(C_word c,C_word *av) C_noret;
C_noret_decl(f_14395)
static void C_ccall f_14395(C_word c,C_word *av) C_noret;
C_noret_decl(f_14406)
static void C_ccall f_14406(C_word c,C_word *av) C_noret;
C_noret_decl(f_14417)
static void C_ccall f_14417(C_word c,C_word *av) C_noret;
C_noret_decl(f_14428)
static void C_ccall f_14428(C_word c,C_word *av) C_noret;
C_noret_decl(f_14439)
static void C_ccall f_14439(C_word c,C_word *av) C_noret;
C_noret_decl(f_14450)
static void C_ccall f_14450(C_word c,C_word *av) C_noret;
C_noret_decl(f_14461)
static void C_ccall f_14461(C_word c,C_word *av) C_noret;
C_noret_decl(f_14472)
static void C_ccall f_14472(C_word c,C_word *av) C_noret;
C_noret_decl(f_14483)
static void C_ccall f_14483(C_word c,C_word *av) C_noret;
C_noret_decl(f_14500)
static void C_ccall f_14500(C_word c,C_word *av) C_noret;
C_noret_decl(f_14517)
static void C_ccall f_14517(C_word c,C_word *av) C_noret;
C_noret_decl(f_14541)
static void C_ccall f_14541(C_word c,C_word *av) C_noret;
C_noret_decl(f_14558)
static void C_ccall f_14558(C_word c,C_word *av) C_noret;
C_noret_decl(f_14569)
static void C_ccall f_14569(C_word c,C_word *av) C_noret;
C_noret_decl(f_14580)
static void C_ccall f_14580(C_word c,C_word *av) C_noret;
C_noret_decl(f_14600)
static void C_ccall f_14600(C_word c,C_word *av) C_noret;
C_noret_decl(f_14611)
static void C_ccall f_14611(C_word c,C_word *av) C_noret;
C_noret_decl(f_14623)
static void f_14623(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_14657)
static void C_ccall f_14657(C_word c,C_word *av) C_noret;
C_noret_decl(f_14672)
static void f_14672(C_word t0,C_word t1) C_noret;
C_noret_decl(f_14739)
static void C_ccall f_14739(C_word c,C_word *av) C_noret;
C_noret_decl(f_14755)
static void C_ccall f_14755(C_word c,C_word *av) C_noret;
C_noret_decl(f_14771)
static void C_ccall f_14771(C_word c,C_word *av) C_noret;
C_noret_decl(f_14787)
static void C_ccall f_14787(C_word c,C_word *av) C_noret;
C_noret_decl(f_14803)
static void C_ccall f_14803(C_word c,C_word *av) C_noret;
C_noret_decl(f_14819)
static void C_ccall f_14819(C_word c,C_word *av) C_noret;
C_noret_decl(f_14835)
static void C_ccall f_14835(C_word c,C_word *av) C_noret;
C_noret_decl(f_14851)
static void C_ccall f_14851(C_word c,C_word *av) C_noret;
C_noret_decl(f_14867)
static void C_ccall f_14867(C_word c,C_word *av) C_noret;
C_noret_decl(f_14879)
static void f_14879(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_14898)
static void f_14898(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_14929)
static void C_ccall f_14929(C_word c,C_word *av) C_noret;
C_noret_decl(f_14946)
static void C_ccall f_14946(C_word c,C_word *av) C_noret;
C_noret_decl(f_14952)
static void f_14952(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_14976)
static void C_ccall f_14976(C_word c,C_word *av) C_noret;
C_noret_decl(f_14991)
static void C_ccall f_14991(C_word c,C_word *av) C_noret;
C_noret_decl(f_15001)
static void C_ccall f_15001(C_word c,C_word *av) C_noret;
C_noret_decl(f_15013)
static void C_ccall f_15013(C_word c,C_word *av) C_noret;
C_noret_decl(f_15017)
static void C_ccall f_15017(C_word c,C_word *av) C_noret;
C_noret_decl(f_15024)
static void C_ccall f_15024(C_word c,C_word *av) C_noret;
C_noret_decl(f_15030)
static void C_ccall f_15030(C_word c,C_word *av) C_noret;
C_noret_decl(f_15036)
static void C_ccall f_15036(C_word c,C_word *av) C_noret;
C_noret_decl(f_15060)
static void C_ccall f_15060(C_word c,C_word *av) C_noret;
C_noret_decl(f_15064)
static void C_ccall f_15064(C_word c,C_word *av) C_noret;
C_noret_decl(f_15073)
static void C_ccall f_15073(C_word c,C_word *av) C_noret;
C_noret_decl(f_15077)
static void C_ccall f_15077(C_word c,C_word *av) C_noret;
C_noret_decl(f_15086)
static void C_ccall f_15086(C_word c,C_word *av) C_noret;
C_noret_decl(f_15089)
static void C_ccall f_15089(C_word c,C_word *av) C_noret;
C_noret_decl(f_15095)
static void C_ccall f_15095(C_word c,C_word *av) C_noret;
C_noret_decl(f_15101)
static void C_ccall f_15101(C_word c,C_word *av) C_noret;
C_noret_decl(f_15104)
static void C_ccall f_15104(C_word c,C_word *av) C_noret;
C_noret_decl(f_15143)
static void C_ccall f_15143(C_word c,C_word *av) C_noret;
C_noret_decl(f_15146)
static void C_ccall f_15146(C_word c,C_word *av) C_noret;
C_noret_decl(f_15156)
static void f_15156(C_word t0,C_word t1) C_noret;
C_noret_decl(f_15173)
static void C_ccall f_15173(C_word c,C_word *av) C_noret;
C_noret_decl(f_15179)
static void C_ccall f_15179(C_word c,C_word *av) C_noret;
C_noret_decl(f_15185)
static void C_ccall f_15185(C_word c,C_word *av) C_noret;
C_noret_decl(f_15191)
static void C_ccall f_15191(C_word c,C_word *av) C_noret;
C_noret_decl(f_15197)
static void C_ccall f_15197(C_word c,C_word *av) C_noret;
C_noret_decl(f_15203)
static void C_ccall f_15203(C_word c,C_word *av) C_noret;
C_noret_decl(f_15209)
static void C_ccall f_15209(C_word c,C_word *av) C_noret;
C_noret_decl(f_15215)
static void C_ccall f_15215(C_word c,C_word *av) C_noret;
C_noret_decl(f_15219)
static void C_ccall f_15219(C_word c,C_word *av) C_noret;
C_noret_decl(f_15224)
static void C_ccall f_15224(C_word c,C_word *av) C_noret;
C_noret_decl(f_15227)
static void C_ccall f_15227(C_word c,C_word *av) C_noret;
C_noret_decl(f_15237)
static void C_ccall f_15237(C_word c,C_word *av) C_noret;
C_noret_decl(f_15240)
static void C_ccall f_15240(C_word c,C_word *av) C_noret;
C_noret_decl(f_15246)
static void C_ccall f_15246(C_word c,C_word *av) C_noret;
C_noret_decl(f_15250)
static void C_ccall f_15250(C_word c,C_word *av) C_noret;
C_noret_decl(f_15258)
static void f_15258(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_15262)
static void C_ccall f_15262(C_word c,C_word *av) C_noret;
C_noret_decl(f_15280)
static void C_ccall f_15280(C_word c,C_word *av) C_noret;
C_noret_decl(f_15304)
static void C_ccall f_15304(C_word c,C_word *av) C_noret;
C_noret_decl(f_15311)
static void C_ccall f_15311(C_word c,C_word *av) C_noret;
C_noret_decl(f_15335)
static void C_ccall f_15335(C_word c,C_word *av) C_noret;
C_noret_decl(f_15357)
static void C_ccall f_15357(C_word c,C_word *av) C_noret;
C_noret_decl(f_15360)
static void C_ccall f_15360(C_word c,C_word *av) C_noret;
C_noret_decl(f_15369)
static void f_15369(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_15426)
static void C_ccall f_15426(C_word c,C_word *av) C_noret;
C_noret_decl(f_15439)
static void C_ccall f_15439(C_word c,C_word *av) C_noret;
C_noret_decl(f_15444)
static void f_15444(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_15488)
static void C_ccall f_15488(C_word c,C_word *av) C_noret;
C_noret_decl(f_15492)
static void C_ccall f_15492(C_word c,C_word *av) C_noret;
C_noret_decl(f_15497)
static void f_15497(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_15539)
static void C_ccall f_15539(C_word c,C_word *av) C_noret;
C_noret_decl(f_15562)
static void f_15562(C_word t0,C_word t1) C_noret;
C_noret_decl(f_15585)
static C_word f_15585(C_word t0,C_word t1);
C_noret_decl(f_15658)
static void C_ccall f_15658(C_word c,C_word *av) C_noret;
C_noret_decl(f_15678)
static void f_15678(C_word t0,C_word t1) C_noret;
C_noret_decl(f_15681)
static void C_ccall f_15681(C_word c,C_word *av) C_noret;
C_noret_decl(f_15684)
static void C_ccall f_15684(C_word c,C_word *av) C_noret;
C_noret_decl(f_15693)
static void C_ccall f_15693(C_word c,C_word *av) C_noret;
C_noret_decl(f_15706)
static void C_ccall f_15706(C_word c,C_word *av) C_noret;
C_noret_decl(f_15733)
static void C_ccall f_15733(C_word c,C_word *av) C_noret;
C_noret_decl(f_15763)
static void C_ccall f_15763(C_word c,C_word *av) C_noret;
C_noret_decl(f_15782)
static C_word f_15782(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_15816)
static C_word f_15816(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_15850)
static void C_ccall f_15850(C_word c,C_word *av) C_noret;
C_noret_decl(f_15884)
static void C_ccall f_15884(C_word c,C_word *av) C_noret;
C_noret_decl(f_15888)
static void C_ccall f_15888(C_word c,C_word *av) C_noret;
C_noret_decl(f_15898)
static void C_ccall f_15898(C_word c,C_word *av) C_noret;
C_noret_decl(f_15908)
static void f_15908(C_word t0,C_word t1) C_noret;
C_noret_decl(f_15915)
static void f_15915(C_word t0,C_word t1) C_noret;
C_noret_decl(f_15943)
static void f_15943(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_15963)
static void C_ccall f_15963(C_word c,C_word *av) C_noret;
C_noret_decl(f_15965)
static void f_15965(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_15993)
static void C_ccall f_15993(C_word c,C_word *av) C_noret;
C_noret_decl(f_16012)
static void C_ccall f_16012(C_word c,C_word *av) C_noret;
C_noret_decl(f_16018)
static void C_ccall f_16018(C_word c,C_word *av) C_noret;
C_noret_decl(f_16036)
static void C_ccall f_16036(C_word c,C_word *av) C_noret;
C_noret_decl(f_16042)
static void C_ccall f_16042(C_word c,C_word *av) C_noret;
C_noret_decl(f_16060)
static void C_ccall f_16060(C_word c,C_word *av) C_noret;
C_noret_decl(f_16066)
static void C_ccall f_16066(C_word c,C_word *av) C_noret;
C_noret_decl(f_16081)
static void C_ccall f_16081(C_word c,C_word *av) C_noret;
C_noret_decl(f_16087)
static void C_ccall f_16087(C_word c,C_word *av) C_noret;
C_noret_decl(f_16101)
static void f_16101(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_16121)
static void C_ccall f_16121(C_word c,C_word *av) C_noret;
C_noret_decl(f_16123)
static void f_16123(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_16151)
static void C_ccall f_16151(C_word c,C_word *av) C_noret;
C_noret_decl(f_16162)
static void C_ccall f_16162(C_word c,C_word *av) C_noret;
C_noret_decl(f_16168)
static void C_ccall f_16168(C_word c,C_word *av) C_noret;
C_noret_decl(f_16186)
static void C_ccall f_16186(C_word c,C_word *av) C_noret;
C_noret_decl(f_16192)
static void C_ccall f_16192(C_word c,C_word *av) C_noret;
C_noret_decl(f_16210)
static void C_ccall f_16210(C_word c,C_word *av) C_noret;
C_noret_decl(f_16216)
static void C_ccall f_16216(C_word c,C_word *av) C_noret;
C_noret_decl(f_16231)
static void C_ccall f_16231(C_word c,C_word *av) C_noret;
C_noret_decl(f_16237)
static void C_ccall f_16237(C_word c,C_word *av) C_noret;
C_noret_decl(f_16252)
static void C_ccall f_16252(C_word c,C_word *av) C_noret;
C_noret_decl(f_16268)
static void C_ccall f_16268(C_word c,C_word *av) C_noret;
C_noret_decl(f_16298)
static void C_ccall f_16298(C_word c,C_word *av) C_noret;
C_noret_decl(f_16302)
static void C_ccall f_16302(C_word c,C_word *av) C_noret;
C_noret_decl(f_16304)
static void f_16304(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_16315)
static void C_ccall f_16315(C_word c,C_word *av) C_noret;
C_noret_decl(f_16338)
static void C_ccall f_16338(C_word c,C_word *av) C_noret;
C_noret_decl(f_16356)
static void C_ccall f_16356(C_word c,C_word *av) C_noret;
C_noret_decl(f_16362)
static void C_ccall f_16362(C_word c,C_word *av) C_noret;
C_noret_decl(f_16368)
static void C_ccall f_16368(C_word c,C_word *av) C_noret;
C_noret_decl(f_16375)
static void C_ccall f_16375(C_word c,C_word *av) C_noret;
C_noret_decl(f_16383)
static void f_16383(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_16404)
static void f_16404(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_16418)
static void C_ccall f_16418(C_word c,C_word *av) C_noret;
C_noret_decl(f_16422)
static void C_ccall f_16422(C_word c,C_word *av) C_noret;
C_noret_decl(f_16463)
static void C_ccall f_16463(C_word c,C_word *av) C_noret;
C_noret_decl(f_16485)
static void C_ccall f_16485(C_word c,C_word *av) C_noret;
C_noret_decl(f_16487)
static void C_ccall f_16487(C_word c,C_word *av) C_noret;
C_noret_decl(f_16509)
static void C_ccall f_16509(C_word c,C_word *av) C_noret;
C_noret_decl(f_16511)
static void C_ccall f_16511(C_word c,C_word *av) C_noret;
C_noret_decl(f_16533)
static void C_ccall f_16533(C_word c,C_word *av) C_noret;
C_noret_decl(f_16535)
static void C_ccall f_16535(C_word c,C_word *av) C_noret;
C_noret_decl(f_16557)
static void C_ccall f_16557(C_word c,C_word *av) C_noret;
C_noret_decl(f_16559)
static void C_ccall f_16559(C_word c,C_word *av) C_noret;
C_noret_decl(f_16563)
static void C_ccall f_16563(C_word c,C_word *av) C_noret;
C_noret_decl(f_16566)
static void f_16566(C_word t0,C_word t1) C_noret;
C_noret_decl(f_16584)
static void C_ccall f_16584(C_word c,C_word *av) C_noret;
C_noret_decl(f_16606)
static void C_ccall f_16606(C_word c,C_word *av) C_noret;
C_noret_decl(f_16608)
static void C_ccall f_16608(C_word c,C_word *av) C_noret;
C_noret_decl(f_16630)
static void C_ccall f_16630(C_word c,C_word *av) C_noret;
C_noret_decl(f_16632)
static void C_ccall f_16632(C_word c,C_word *av) C_noret;
C_noret_decl(f_16654)
static void C_ccall f_16654(C_word c,C_word *av) C_noret;
C_noret_decl(f_16656)
static void C_ccall f_16656(C_word c,C_word *av) C_noret;
C_noret_decl(f_16678)
static void C_ccall f_16678(C_word c,C_word *av) C_noret;
C_noret_decl(f_16680)
static void C_ccall f_16680(C_word c,C_word *av) C_noret;
C_noret_decl(f_16702)
static void C_ccall f_16702(C_word c,C_word *av) C_noret;
C_noret_decl(f_16704)
static void C_ccall f_16704(C_word c,C_word *av) C_noret;
C_noret_decl(f_16726)
static void C_ccall f_16726(C_word c,C_word *av) C_noret;
C_noret_decl(f_16728)
static void C_ccall f_16728(C_word c,C_word *av) C_noret;
C_noret_decl(f_16750)
static void C_ccall f_16750(C_word c,C_word *av) C_noret;
C_noret_decl(f_16752)
static void C_ccall f_16752(C_word c,C_word *av) C_noret;
C_noret_decl(f_16768)
static void C_ccall f_16768(C_word c,C_word *av) C_noret;
C_noret_decl(f_16770)
static void C_ccall f_16770(C_word c,C_word *av) C_noret;
C_noret_decl(f_16792)
static void C_ccall f_16792(C_word c,C_word *av) C_noret;
C_noret_decl(f_16794)
static void C_ccall f_16794(C_word c,C_word *av) C_noret;
C_noret_decl(f_16816)
static void C_ccall f_16816(C_word c,C_word *av) C_noret;
C_noret_decl(f_16818)
static void C_ccall f_16818(C_word c,C_word *av) C_noret;
C_noret_decl(f_16834)
static void C_ccall f_16834(C_word c,C_word *av) C_noret;
C_noret_decl(f_16836)
static void C_ccall f_16836(C_word c,C_word *av) C_noret;
C_noret_decl(f_16852)
static void C_ccall f_16852(C_word c,C_word *av) C_noret;
C_noret_decl(f_16854)
static void C_ccall f_16854(C_word c,C_word *av) C_noret;
C_noret_decl(f_16870)
static void C_ccall f_16870(C_word c,C_word *av) C_noret;
C_noret_decl(f_16872)
static void C_ccall f_16872(C_word c,C_word *av) C_noret;
C_noret_decl(f_16888)
static void C_ccall f_16888(C_word c,C_word *av) C_noret;
C_noret_decl(f_16890)
static void C_ccall f_16890(C_word c,C_word *av) C_noret;
C_noret_decl(f_16906)
static void C_ccall f_16906(C_word c,C_word *av) C_noret;
C_noret_decl(f_16908)
static void C_ccall f_16908(C_word c,C_word *av) C_noret;
C_noret_decl(f_16924)
static void C_ccall f_16924(C_word c,C_word *av) C_noret;
C_noret_decl(f_16926)
static void C_ccall f_16926(C_word c,C_word *av) C_noret;
C_noret_decl(f_16942)
static void C_ccall f_16942(C_word c,C_word *av) C_noret;
C_noret_decl(f_16944)
static void C_ccall f_16944(C_word c,C_word *av) C_noret;
C_noret_decl(f_16960)
static void C_ccall f_16960(C_word c,C_word *av) C_noret;
C_noret_decl(f_16962)
static void C_ccall f_16962(C_word c,C_word *av) C_noret;
C_noret_decl(f_16978)
static void C_ccall f_16978(C_word c,C_word *av) C_noret;
C_noret_decl(f_16980)
static void C_ccall f_16980(C_word c,C_word *av) C_noret;
C_noret_decl(f_16996)
static void C_ccall f_16996(C_word c,C_word *av) C_noret;
C_noret_decl(f_16998)
static void C_ccall f_16998(C_word c,C_word *av) C_noret;
C_noret_decl(f_17020)
static void C_ccall f_17020(C_word c,C_word *av) C_noret;
C_noret_decl(f_17022)
static void C_ccall f_17022(C_word c,C_word *av) C_noret;
C_noret_decl(f_17038)
static void C_ccall f_17038(C_word c,C_word *av) C_noret;
C_noret_decl(f_17040)
static void C_ccall f_17040(C_word c,C_word *av) C_noret;
C_noret_decl(f_17056)
static void C_ccall f_17056(C_word c,C_word *av) C_noret;
C_noret_decl(f_17058)
static void C_ccall f_17058(C_word c,C_word *av) C_noret;
C_noret_decl(f_17074)
static void C_ccall f_17074(C_word c,C_word *av) C_noret;
C_noret_decl(f_17076)
static void C_ccall f_17076(C_word c,C_word *av) C_noret;
C_noret_decl(f_17092)
static void C_ccall f_17092(C_word c,C_word *av) C_noret;
C_noret_decl(f_17094)
static void C_ccall f_17094(C_word c,C_word *av) C_noret;
C_noret_decl(f_17110)
static void C_ccall f_17110(C_word c,C_word *av) C_noret;
C_noret_decl(f_17112)
static void C_ccall f_17112(C_word c,C_word *av) C_noret;
C_noret_decl(f_17128)
static void C_ccall f_17128(C_word c,C_word *av) C_noret;
C_noret_decl(f_17130)
static void C_ccall f_17130(C_word c,C_word *av) C_noret;
C_noret_decl(f_17146)
static void C_ccall f_17146(C_word c,C_word *av) C_noret;
C_noret_decl(f_17148)
static void C_ccall f_17148(C_word c,C_word *av) C_noret;
C_noret_decl(f_17170)
static void C_ccall f_17170(C_word c,C_word *av) C_noret;
C_noret_decl(f_17172)
static void C_ccall f_17172(C_word c,C_word *av) C_noret;
C_noret_decl(f_17188)
static void C_ccall f_17188(C_word c,C_word *av) C_noret;
C_noret_decl(f_17190)
static void C_ccall f_17190(C_word c,C_word *av) C_noret;
C_noret_decl(f_17206)
static void C_ccall f_17206(C_word c,C_word *av) C_noret;
C_noret_decl(f_17208)
static void C_ccall f_17208(C_word c,C_word *av) C_noret;
C_noret_decl(f_17224)
static void C_ccall f_17224(C_word c,C_word *av) C_noret;
C_noret_decl(f_17226)
static void C_ccall f_17226(C_word c,C_word *av) C_noret;
C_noret_decl(f_17242)
static void C_ccall f_17242(C_word c,C_word *av) C_noret;
C_noret_decl(f_17244)
static void C_ccall f_17244(C_word c,C_word *av) C_noret;
C_noret_decl(f_17262)
static void f_17262(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_17272)
static void C_ccall f_17272(C_word c,C_word *av) C_noret;
C_noret_decl(f_17276)
static void C_ccall f_17276(C_word c,C_word *av) C_noret;
C_noret_decl(f_17298)
static void C_ccall f_17298(C_word c,C_word *av) C_noret;
C_noret_decl(f_17302)
static void C_ccall f_17302(C_word c,C_word *av) C_noret;
C_noret_decl(f_17305)
static void C_ccall f_17305(C_word c,C_word *av) C_noret;
C_noret_decl(f_17310)
static void C_ccall f_17310(C_word c,C_word *av) C_noret;
C_noret_decl(f_17314)
static void C_ccall f_17314(C_word c,C_word *av) C_noret;
C_noret_decl(f_17317)
static void C_ccall f_17317(C_word c,C_word *av) C_noret;
C_noret_decl(f_17320)
static void C_ccall f_17320(C_word c,C_word *av) C_noret;
C_noret_decl(f_17333)
static void C_ccall f_17333(C_word c,C_word *av) C_noret;
C_noret_decl(f_17356)
static void C_ccall f_17356(C_word c,C_word *av) C_noret;
C_noret_decl(f_17382)
static void C_ccall f_17382(C_word c,C_word *av) C_noret;
C_noret_decl(f_17391)
static void C_ccall f_17391(C_word c,C_word *av) C_noret;
C_noret_decl(f_17396)
static void C_ccall f_17396(C_word c,C_word *av) C_noret;
C_noret_decl(f_17398)
static void C_ccall f_17398(C_word c,C_word *av) C_noret;
C_noret_decl(f_17442)
static C_word f_17442(C_word *a,C_word t0,C_word t1);
C_noret_decl(f_17488)
static void C_ccall f_17488(C_word c,C_word *av) C_noret;
C_noret_decl(f_17512)
static void C_ccall f_17512(C_word c,C_word *av) C_noret;
C_noret_decl(f_17516)
static void C_ccall f_17516(C_word c,C_word *av) C_noret;
C_noret_decl(f_17534)
static void C_ccall f_17534(C_word c,C_word *av) C_noret;
C_noret_decl(f_17558)
static void C_ccall f_17558(C_word c,C_word *av) C_noret;
C_noret_decl(f_17562)
static void C_ccall f_17562(C_word c,C_word *av) C_noret;
C_noret_decl(f_17580)
static void C_ccall f_17580(C_word c,C_word *av) C_noret;
C_noret_decl(f_17621)
static void f_17621(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_17632)
static void C_ccall f_17632(C_word c,C_word *av) C_noret;
C_noret_decl(f_17638)
static void f_17638(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_17642)
static void C_ccall f_17642(C_word c,C_word *av) C_noret;
C_noret_decl(f_17656)
static void C_ccall f_17656(C_word c,C_word *av) C_noret;
C_noret_decl(f_17669)
static void C_ccall f_17669(C_word c,C_word *av) C_noret;
C_noret_decl(f_17673)
static void C_ccall f_17673(C_word c,C_word *av) C_noret;
C_noret_decl(f_17690)
static void C_ccall f_17690(C_word c,C_word *av) C_noret;
C_noret_decl(f_17694)
static void C_ccall f_17694(C_word c,C_word *av) C_noret;
C_noret_decl(f_17700)
static void C_ccall f_17700(C_word c,C_word *av) C_noret;
C_noret_decl(f_17704)
static void C_ccall f_17704(C_word c,C_word *av) C_noret;
C_noret_decl(f_17744)
static void C_ccall f_17744(C_word c,C_word *av) C_noret;
C_noret_decl(f_17748)
static void C_ccall f_17748(C_word c,C_word *av) C_noret;
C_noret_decl(f_17768)
static void C_ccall f_17768(C_word c,C_word *av) C_noret;
C_noret_decl(f_17771)
static void C_ccall f_17771(C_word c,C_word *av) C_noret;
C_noret_decl(f_17774)
static void C_ccall f_17774(C_word c,C_word *av) C_noret;
C_noret_decl(f_17777)
static void C_ccall f_17777(C_word c,C_word *av) C_noret;
C_noret_decl(f_17780)
static void C_ccall f_17780(C_word c,C_word *av) C_noret;
C_noret_decl(f_17801)
static void C_ccall f_17801(C_word c,C_word *av) C_noret;
C_noret_decl(f_17803)
static void f_17803(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_17821)
static void C_ccall f_17821(C_word c,C_word *av) C_noret;
C_noret_decl(f_17831)
static void C_ccall f_17831(C_word c,C_word *av) C_noret;
C_noret_decl(f_17835)
static void C_ccall f_17835(C_word c,C_word *av) C_noret;
C_noret_decl(f_17873)
static void C_ccall f_17873(C_word c,C_word *av) C_noret;
C_noret_decl(f_17876)
static void C_ccall f_17876(C_word c,C_word *av) C_noret;
C_noret_decl(f_17879)
static void C_ccall f_17879(C_word c,C_word *av) C_noret;
C_noret_decl(f_17882)
static void C_ccall f_17882(C_word c,C_word *av) C_noret;
C_noret_decl(f_17888)
static void C_ccall f_17888(C_word c,C_word *av) C_noret;
C_noret_decl(f_17891)
static void C_ccall f_17891(C_word c,C_word *av) C_noret;
C_noret_decl(f_17939)
static void C_ccall f_17939(C_word c,C_word *av) C_noret;
C_noret_decl(f_17943)
static void C_ccall f_17943(C_word c,C_word *av) C_noret;
C_noret_decl(f_18020)
static void C_ccall f_18020(C_word c,C_word *av) C_noret;
C_noret_decl(f_18059)
static void C_ccall f_18059(C_word c,C_word *av) C_noret;
C_noret_decl(f_18114)
static void C_ccall f_18114(C_word c,C_word *av) C_noret;
C_noret_decl(f_18159)
static void C_ccall f_18159(C_word c,C_word *av) C_noret;
C_noret_decl(f_18204)
static void C_ccall f_18204(C_word c,C_word *av) C_noret;
C_noret_decl(f_18241)
static void C_ccall f_18241(C_word c,C_word *av) C_noret;
C_noret_decl(f_18261)
static void C_ccall f_18261(C_word c,C_word *av) C_noret;
C_noret_decl(f_18285)
static void f_18285(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_18288)
static void f_18288(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_18292)
static void C_ccall f_18292(C_word c,C_word *av) C_noret;
C_noret_decl(f_18295)
static void C_ccall f_18295(C_word c,C_word *av) C_noret;
C_noret_decl(f_18313)
static void C_ccall f_18313(C_word c,C_word *av) C_noret;
C_noret_decl(f_18336)
static void C_ccall f_18336(C_word c,C_word *av) C_noret;
C_noret_decl(f_18340)
static void C_ccall f_18340(C_word c,C_word *av) C_noret;
C_noret_decl(f_18363)
static void C_ccall f_18363(C_word c,C_word *av) C_noret;
C_noret_decl(f_18367)
static void C_ccall f_18367(C_word c,C_word *av) C_noret;
C_noret_decl(f_18399)
static void C_ccall f_18399(C_word c,C_word *av) C_noret;
C_noret_decl(f_18435)
static void C_ccall f_18435(C_word c,C_word *av) C_noret;
C_noret_decl(f_18439)
static void C_ccall f_18439(C_word c,C_word *av) C_noret;
C_noret_decl(f_18458)
static void C_ccall f_18458(C_word c,C_word *av) C_noret;
C_noret_decl(f_18460)
static void C_ccall f_18460(C_word c,C_word *av) C_noret;
C_noret_decl(f_18467)
static void f_18467(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_18504)
static void C_ccall f_18504(C_word c,C_word *av) C_noret;
C_noret_decl(f_18511)
static void f_18511(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_18548)
static void C_ccall f_18548(C_word c,C_word *av) C_noret;
C_noret_decl(f_18566)
static void C_ccall f_18566(C_word c,C_word *av) C_noret;
C_noret_decl(f_18575)
static void C_ccall f_18575(C_word c,C_word *av) C_noret;
C_noret_decl(f_18580)
static void C_ccall f_18580(C_word c,C_word *av) C_noret;
C_noret_decl(f_18593)
static void C_ccall f_18593(C_word c,C_word *av) C_noret;
C_noret_decl(f_18619)
static void C_ccall f_18619(C_word c,C_word *av) C_noret;
C_noret_decl(f_18627)
static void C_ccall f_18627(C_word c,C_word *av) C_noret;
C_noret_decl(f_18631)
static void C_ccall f_18631(C_word c,C_word *av) C_noret;
C_noret_decl(f_18635)
static void C_ccall f_18635(C_word c,C_word *av) C_noret;
C_noret_decl(f_18639)
static void C_ccall f_18639(C_word c,C_word *av) C_noret;
C_noret_decl(f_18642)
static void C_ccall f_18642(C_word c,C_word *av) C_noret;
C_noret_decl(f_18656)
static void C_ccall f_18656(C_word c,C_word *av) C_noret;
C_noret_decl(f_18660)
static void C_ccall f_18660(C_word c,C_word *av) C_noret;
C_noret_decl(f_18671)
static void C_ccall f_18671(C_word c,C_word *av) C_noret;
C_noret_decl(f_18695)
static void C_ccall f_18695(C_word c,C_word *av) C_noret;
C_noret_decl(f_18699)
static void C_ccall f_18699(C_word c,C_word *av) C_noret;
C_noret_decl(f_18705)
static void C_ccall f_18705(C_word c,C_word *av) C_noret;
C_noret_decl(f_18729)
static void C_ccall f_18729(C_word c,C_word *av) C_noret;
C_noret_decl(f_18733)
static void C_ccall f_18733(C_word c,C_word *av) C_noret;
C_noret_decl(f_18739)
static void C_ccall f_18739(C_word c,C_word *av) C_noret;
C_noret_decl(f_18756)
static void C_ccall f_18756(C_word c,C_word *av) C_noret;
C_noret_decl(f_18760)
static void C_ccall f_18760(C_word c,C_word *av) C_noret;
C_noret_decl(f_18764)
static void C_ccall f_18764(C_word c,C_word *av) C_noret;
C_noret_decl(f_18774)
static void f_18774(C_word t0,C_word t1) C_noret;
C_noret_decl(f_18780)
static void f_18780(C_word t0,C_word t1) C_noret;
C_noret_decl(f_18787)
static void C_ccall f_18787(C_word c,C_word *av) C_noret;
C_noret_decl(f_18799)
static void C_ccall f_18799(C_word c,C_word *av) C_noret;
C_noret_decl(f_18822)
static void C_ccall f_18822(C_word c,C_word *av) C_noret;
C_noret_decl(f_18826)
static void C_ccall f_18826(C_word c,C_word *av) C_noret;
C_noret_decl(f_18836)
static void f_18836(C_word t0,C_word t1) C_noret;
C_noret_decl(f_18842)
static void f_18842(C_word t0,C_word t1) C_noret;
C_noret_decl(f_18849)
static void C_ccall f_18849(C_word c,C_word *av) C_noret;
C_noret_decl(f_18864)
static void C_ccall f_18864(C_word c,C_word *av) C_noret;
C_noret_decl(f_18868)
static void C_ccall f_18868(C_word c,C_word *av) C_noret;
C_noret_decl(f_18901)
static void C_ccall f_18901(C_word c,C_word *av) C_noret;
C_noret_decl(f_18905)
static void C_ccall f_18905(C_word c,C_word *av) C_noret;
C_noret_decl(f_18922)
static void C_ccall f_18922(C_word c,C_word *av) C_noret;
C_noret_decl(f_18932)
static void C_ccall f_18932(C_word c,C_word *av) C_noret;
C_noret_decl(f_19005)
static void C_ccall f_19005(C_word c,C_word *av) C_noret;
C_noret_decl(f_19019)
static void C_ccall f_19019(C_word c,C_word *av) C_noret;
C_noret_decl(f_19036)
static void C_ccall f_19036(C_word c,C_word *av) C_noret;
C_noret_decl(f_19052)
static void C_ccall f_19052(C_word c,C_word *av) C_noret;
C_noret_decl(f_19123)
static void C_ccall f_19123(C_word c,C_word *av) C_noret;
C_noret_decl(f_19127)
static void C_ccall f_19127(C_word c,C_word *av) C_noret;
C_noret_decl(f_19132)
static void C_ccall f_19132(C_word c,C_word *av) C_noret;
C_noret_decl(f_19142)
static void C_ccall f_19142(C_word c,C_word *av) C_noret;
C_noret_decl(f_19146)
static void C_ccall f_19146(C_word c,C_word *av) C_noret;
C_noret_decl(f_19161)
static void C_ccall f_19161(C_word c,C_word *av) C_noret;
C_noret_decl(f_19165)
static void C_ccall f_19165(C_word c,C_word *av) C_noret;
C_noret_decl(f_19182)
static void C_ccall f_19182(C_word c,C_word *av) C_noret;
C_noret_decl(f_19193)
static void C_ccall f_19193(C_word c,C_word *av) C_noret;
C_noret_decl(f_19199)
static void C_ccall f_19199(C_word c,C_word *av) C_noret;
C_noret_decl(f_19210)
static void C_ccall f_19210(C_word c,C_word *av) C_noret;
C_noret_decl(f_19221)
static void C_ccall f_19221(C_word c,C_word *av) C_noret;
C_noret_decl(f_19233)
static void C_ccall f_19233(C_word c,C_word *av) C_noret;
C_noret_decl(f_19245)
static void C_ccall f_19245(C_word c,C_word *av) C_noret;
C_noret_decl(f_19257)
static void C_ccall f_19257(C_word c,C_word *av) C_noret;
C_noret_decl(f_19274)
static void C_ccall f_19274(C_word c,C_word *av) C_noret;
C_noret_decl(f_19281)
static void C_ccall f_19281(C_word c,C_word *av) C_noret;
C_noret_decl(f_19285)
static void C_ccall f_19285(C_word c,C_word *av) C_noret;
C_noret_decl(f_19287)
static void C_ccall f_19287(C_word c,C_word *av) C_noret;
C_noret_decl(f_19294)
static void C_ccall f_19294(C_word c,C_word *av) C_noret;
C_noret_decl(f_19300)
static void C_ccall f_19300(C_word c,C_word *av) C_noret;
C_noret_decl(f_19306)
static void C_ccall f_19306(C_word c,C_word *av) C_noret;
C_noret_decl(f_19349)
static void C_ccall f_19349(C_word c,C_word *av) C_noret;
C_noret_decl(f_19355)
static void C_ccall f_19355(C_word c,C_word *av) C_noret;
C_noret_decl(f_19361)
static void C_ccall f_19361(C_word c,C_word *av) C_noret;
C_noret_decl(f_19364)
static void C_ccall f_19364(C_word c,C_word *av) C_noret;
C_noret_decl(f_19370)
static void C_ccall f_19370(C_word c,C_word *av) C_noret;
C_noret_decl(f_19376)
static void C_ccall f_19376(C_word c,C_word *av) C_noret;
C_noret_decl(f_19379)
static void C_ccall f_19379(C_word c,C_word *av) C_noret;
C_noret_decl(f_19385)
static void C_ccall f_19385(C_word c,C_word *av) C_noret;
C_noret_decl(f_19389)
static void C_ccall f_19389(C_word c,C_word *av) C_noret;
C_noret_decl(f_19392)
static void C_ccall f_19392(C_word c,C_word *av) C_noret;
C_noret_decl(f_19397)
static void C_ccall f_19397(C_word c,C_word *av) C_noret;
C_noret_decl(f_19407)
static void f_19407(C_word t0,C_word t1) C_noret;
C_noret_decl(f_19427)
static void C_ccall f_19427(C_word c,C_word *av) C_noret;
C_noret_decl(f_19442)
static void f_19442(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_19472)
static void C_ccall f_19472(C_word c,C_word *av) C_noret;
C_noret_decl(f_19483)
static void C_ccall f_19483(C_word c,C_word *av) C_noret;
C_noret_decl(f_19499)
static void C_ccall f_19499(C_word c,C_word *av) C_noret;
C_noret_decl(f_19503)
static void C_ccall f_19503(C_word c,C_word *av) C_noret;
C_noret_decl(f_19507)
static void C_ccall f_19507(C_word c,C_word *av) C_noret;
C_noret_decl(f_19523)
static void C_ccall f_19523(C_word c,C_word *av) C_noret;
C_noret_decl(f_19541)
static void C_ccall f_19541(C_word c,C_word *av) C_noret;
C_noret_decl(f_19552)
static void f_19552(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_19574)
static void C_ccall f_19574(C_word c,C_word *av) C_noret;
C_noret_decl(f_19591)
static void C_ccall f_19591(C_word c,C_word *av) C_noret;
C_noret_decl(f_19594)
static void f_19594(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_19606)
static void C_ccall f_19606(C_word c,C_word *av) C_noret;
C_noret_decl(f_19608)
static void f_19608(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_19629)
static void C_ccall f_19629(C_word c,C_word *av) C_noret;
C_noret_decl(f_19660)
static void C_ccall f_19660(C_word c,C_word *av) C_noret;
C_noret_decl(f_19664)
static void C_ccall f_19664(C_word c,C_word *av) C_noret;
C_noret_decl(f_19699)
static void C_ccall f_19699(C_word c,C_word *av) C_noret;
C_noret_decl(f_19706)
static void C_ccall f_19706(C_word c,C_word *av) C_noret;
C_noret_decl(f_19718)
static void C_ccall f_19718(C_word c,C_word *av) C_noret;
C_noret_decl(f_19738)
static void C_ccall f_19738(C_word c,C_word *av) C_noret;
C_noret_decl(f_19742)
static void C_ccall f_19742(C_word c,C_word *av) C_noret;
C_noret_decl(f_19762)
static void f_19762(C_word t0,C_word t1) C_noret;
C_noret_decl(f_19782)
static void C_ccall f_19782(C_word c,C_word *av) C_noret;
C_noret_decl(f_19786)
static void C_ccall f_19786(C_word c,C_word *av) C_noret;
C_noret_decl(f_19790)
static void C_ccall f_19790(C_word c,C_word *av) C_noret;
C_noret_decl(f_19797)
static void C_ccall f_19797(C_word c,C_word *av) C_noret;
C_noret_decl(f_19813)
static void C_ccall f_19813(C_word c,C_word *av) C_noret;
C_noret_decl(f_19817)
static void C_ccall f_19817(C_word c,C_word *av) C_noret;
C_noret_decl(f_19858)
static void f_19858(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_19891)
static void C_ccall f_19891(C_word c,C_word *av) C_noret;
C_noret_decl(f_19920)
static void C_ccall f_19920(C_word c,C_word *av) C_noret;
C_noret_decl(f_19928)
static void C_ccall f_19928(C_word c,C_word *av) C_noret;
C_noret_decl(f_19934)
static void C_ccall f_19934(C_word c,C_word *av) C_noret;
C_noret_decl(f_19954)
static void f_19954(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_19979)
static void C_ccall f_19979(C_word c,C_word *av) C_noret;
C_noret_decl(f_19985)
static void C_ccall f_19985(C_word c,C_word *av) C_noret;
C_noret_decl(f_19989)
static void C_ccall f_19989(C_word c,C_word *av) C_noret;
C_noret_decl(f_19999)
static void C_ccall f_19999(C_word c,C_word *av) C_noret;
C_noret_decl(f_20019)
static void f_20019(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_20040)
static void C_ccall f_20040(C_word c,C_word *av) C_noret;
C_noret_decl(f_20057)
static void C_ccall f_20057(C_word c,C_word *av) C_noret;
C_noret_decl(f_20064)
static void C_ccall f_20064(C_word c,C_word *av) C_noret;
C_noret_decl(f_20069)
static void C_ccall f_20069(C_word c,C_word *av) C_noret;
C_noret_decl(f_20075)
static void C_ccall f_20075(C_word c,C_word *av) C_noret;
C_noret_decl(f_20079)
static void C_ccall f_20079(C_word c,C_word *av) C_noret;
C_noret_decl(f_20082)
static void C_ccall f_20082(C_word c,C_word *av) C_noret;
C_noret_decl(f_20089)
static void C_ccall f_20089(C_word c,C_word *av) C_noret;
C_noret_decl(f_20107)
static void C_ccall f_20107(C_word c,C_word *av) C_noret;
C_noret_decl(f_20121)
static void C_ccall f_20121(C_word c,C_word *av) C_noret;
C_noret_decl(f_20125)
static void C_ccall f_20125(C_word c,C_word *av) C_noret;
C_noret_decl(f_20162)
static void C_ccall f_20162(C_word c,C_word *av) C_noret;
C_noret_decl(f_20170)
static void C_ccall f_20170(C_word c,C_word *av) C_noret;
C_noret_decl(f_20199)
static void C_ccall f_20199(C_word c,C_word *av) C_noret;
C_noret_decl(f_20202)
static void C_ccall f_20202(C_word c,C_word *av) C_noret;
C_noret_decl(f_20217)
static void C_ccall f_20217(C_word c,C_word *av) C_noret;
C_noret_decl(f_20220)
static void f_20220(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20227)
static void C_ccall f_20227(C_word c,C_word *av) C_noret;
C_noret_decl(f_20238)
static void C_ccall f_20238(C_word c,C_word *av) C_noret;
C_noret_decl(f_20256)
static void C_ccall f_20256(C_word c,C_word *av) C_noret;
C_noret_decl(f_20281)
static void f_20281(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20296)
static void C_ccall f_20296(C_word c,C_word *av) C_noret;
C_noret_decl(f_20324)
static void f_20324(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_20328)
static C_word f_20328(C_word t0,C_word t1);
C_noret_decl(f_20342)
static void f_20342(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_20402)
static void C_ccall f_20402(C_word c,C_word *av) C_noret;
C_noret_decl(f_20422)
static void f_20422(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20428)
static void f_20428(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20488)
static void f_20488(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20526)
static void f_20526(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20532)
static void f_20532(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20574)
static void f_20574(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_20578)
static void C_ccall f_20578(C_word c,C_word *av) C_noret;
C_noret_decl(f_20581)
static void C_ccall f_20581(C_word c,C_word *av) C_noret;
C_noret_decl(f_20630)
static void f_20630(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_20643)
static void f_20643(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20649)
static void C_ccall f_20649(C_word c,C_word *av) C_noret;
C_noret_decl(f_20683)
static void f_20683(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_20693)
static void C_ccall f_20693(C_word c,C_word *av) C_noret;
C_noret_decl(f_20702)
static void f_20702(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20714)
static void f_20714(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20723)
static void C_ccall f_20723(C_word c,C_word *av) C_noret;
C_noret_decl(f_20735)
static void C_ccall f_20735(C_word c,C_word *av) C_noret;
C_noret_decl(f_20741)
static void f_20741(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20747)
static void C_ccall f_20747(C_word c,C_word *av) C_noret;
C_noret_decl(f_20789)
static void C_ccall f_20789(C_word c,C_word *av) C_noret;
C_noret_decl(f_20895)
static void f_20895(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_20902)
static void f_20902(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20915)
static void C_ccall f_20915(C_word c,C_word *av) C_noret;
C_noret_decl(f_20973)
static void f_20973(C_word t0,C_word t1) C_noret;
C_noret_decl(f_20991)
static void C_ccall f_20991(C_word c,C_word *av) C_noret;
C_noret_decl(f_21001)
static void C_ccall f_21001(C_word c,C_word *av) C_noret;
C_noret_decl(f_21037)
static void C_ccall f_21037(C_word c,C_word *av) C_noret;
C_noret_decl(f_21063)
static void C_ccall f_21063(C_word c,C_word *av) C_noret;
C_noret_decl(f_21074)
static void C_ccall f_21074(C_word c,C_word *av) C_noret;
C_noret_decl(f_21237)
static void f_21237(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_21250)
static void f_21250(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21305)
static void f_21305(C_word t0,C_word t1) C_noret;
C_noret_decl(f_21343)
static void C_ccall f_21343(C_word c,C_word *av) C_noret;
C_noret_decl(f_21391)
static void C_ccall f_21391(C_word c,C_word *av) C_noret;
C_noret_decl(f_21468)
static void C_ccall f_21468(C_word c,C_word *av) C_noret;
C_noret_decl(f_21471)
static void C_ccall f_21471(C_word c,C_word *av) C_noret;
C_noret_decl(f_21483)
static void C_ccall f_21483(C_word c,C_word *av) C_noret;
C_noret_decl(f_21565)
static void C_ccall f_21565(C_word c,C_word *av) C_noret;
C_noret_decl(f_21629)
static void C_ccall f_21629(C_word c,C_word *av) C_noret;
C_noret_decl(f_21707)
static void C_ccall f_21707(C_word c,C_word *av) C_noret;
C_noret_decl(f_21717)
static void C_ccall f_21717(C_word c,C_word *av) C_noret;
C_noret_decl(f_21724)
static void f_21724(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_21956)
static void C_ccall f_21956(C_word c,C_word *av) C_noret;
C_noret_decl(f_22002)
static void C_ccall f_22002(C_word c,C_word *av) C_noret;
C_noret_decl(f_22005)
static void f_22005(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_22032)
static void f_22032(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_22056)
static void C_ccall f_22056(C_word c,C_word *av) C_noret;
C_noret_decl(f_22073)
static void f_22073(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_22189)
static void C_ccall f_22189(C_word c,C_word *av) C_noret;
C_noret_decl(f_22192)
static void C_ccall f_22192(C_word c,C_word *av) C_noret;
C_noret_decl(f_22202)
static void C_ccall f_22202(C_word c,C_word *av) C_noret;
C_noret_decl(f_22204)
static void C_ccall f_22204(C_word c,C_word *av) C_noret;
C_noret_decl(f_22210)
static void C_ccall f_22210(C_word c,C_word *av) C_noret;
C_noret_decl(f_22220)
static void C_ccall f_22220(C_word c,C_word *av) C_noret;
C_noret_decl(f_22223)
static void C_ccall f_22223(C_word c,C_word *av) C_noret;
C_noret_decl(f_22231)
static void C_ccall f_22231(C_word c,C_word *av) C_noret;
C_noret_decl(f_22233)
static void C_ccall f_22233(C_word c,C_word *av) C_noret;
C_noret_decl(f_22242)
static void C_ccall f_22242(C_word c,C_word *av) C_noret;
C_noret_decl(f_22251)
static void C_ccall f_22251(C_word c,C_word *av) C_noret;
C_noret_decl(f_22262)
static void C_ccall f_22262(C_word c,C_word *av) C_noret;
C_noret_decl(f_22264)
static void C_ccall f_22264(C_word c,C_word *av) C_noret;
C_noret_decl(f_22281)
static void C_ccall f_22281(C_word c,C_word *av) C_noret;
C_noret_decl(f_22285)
static void C_ccall f_22285(C_word c,C_word *av) C_noret;
C_noret_decl(f_22289)
static void C_ccall f_22289(C_word c,C_word *av) C_noret;
C_noret_decl(f_22293)
static void C_ccall f_22293(C_word c,C_word *av) C_noret;
C_noret_decl(f_22302)
static void C_ccall f_22302(C_word c,C_word *av) C_noret;
C_noret_decl(f_22322)
static void C_ccall f_22322(C_word c,C_word *av) C_noret;
C_noret_decl(f_22330)
static void C_ccall f_22330(C_word c,C_word *av) C_noret;
C_noret_decl(f_22345)
static void C_ccall f_22345(C_word c,C_word *av) C_noret;
C_noret_decl(f_22347)
static void f_22347(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_22372)
static void C_ccall f_22372(C_word c,C_word *av) C_noret;
C_noret_decl(f_22381)
static void C_ccall f_22381(C_word c,C_word *av) C_noret;
C_noret_decl(f_22384)
static void C_ccall f_22384(C_word c,C_word *av) C_noret;
C_noret_decl(f_22395)
static void C_ccall f_22395(C_word c,C_word *av) C_noret;
C_noret_decl(f_22397)
static void C_ccall f_22397(C_word c,C_word *av) C_noret;
C_noret_decl(f_22404)
static void C_ccall f_22404(C_word c,C_word *av) C_noret;
C_noret_decl(f_22415)
static void C_ccall f_22415(C_word c,C_word *av) C_noret;
C_noret_decl(f_22422)
static void C_ccall f_22422(C_word c,C_word *av) C_noret;
C_noret_decl(f_22446)
static void C_ccall f_22446(C_word c,C_word *av) C_noret;
C_noret_decl(f_22459)
static void f_22459(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_22480)
static void C_ccall f_22480(C_word c,C_word *av) C_noret;
C_noret_decl(f_22487)
static void C_ccall f_22487(C_word c,C_word *av) C_noret;
C_noret_decl(f_22492)
static void f_22492(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_22505)
static void C_ccall f_22505(C_word c,C_word *av) C_noret;
C_noret_decl(f_22519)
static void C_ccall f_22519(C_word c,C_word *av) C_noret;
C_noret_decl(f_22543)
static void C_ccall f_22543(C_word c,C_word *av) C_noret;
C_noret_decl(f_22549)
static void C_ccall f_22549(C_word c,C_word *av) C_noret;
C_noret_decl(f_22558)
static void C_ccall f_22558(C_word c,C_word *av) C_noret;
C_noret_decl(f_22561)
static void C_ccall f_22561(C_word c,C_word *av) C_noret;
C_noret_decl(f_22564)
static void C_ccall f_22564(C_word c,C_word *av) C_noret;
C_noret_decl(f_22578)
static void C_ccall f_22578(C_word c,C_word *av) C_noret;
C_noret_decl(f_22580)
static void C_ccall f_22580(C_word c,C_word *av) C_noret;
C_noret_decl(f_22590)
static void C_ccall f_22590(C_word c,C_word *av) C_noret;
C_noret_decl(f_22620)
static void C_ccall f_22620(C_word c,C_word *av) C_noret;
C_noret_decl(f_22637)
static void C_ccall f_22637(C_word c,C_word *av) C_noret;
C_noret_decl(f_22639)
static void C_ccall f_22639(C_word c,C_word *av) C_noret;
C_noret_decl(f_22649)
static void C_ccall f_22649(C_word c,C_word *av) C_noret;
C_noret_decl(f_22655)
static void C_ccall f_22655(C_word c,C_word *av) C_noret;
C_noret_decl(f_22677)
static void C_ccall f_22677(C_word c,C_word *av) C_noret;
C_noret_decl(f_22682)
static void C_ccall f_22682(C_word c,C_word *av) C_noret;
C_noret_decl(f_22687)
static C_word f_22687(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_22708)
static void C_ccall f_22708(C_word c,C_word *av) C_noret;
C_noret_decl(f_22733)
static void C_ccall f_22733(C_word c,C_word *av) C_noret;
C_noret_decl(f_22739)
static void f_22739(C_word t0,C_word t1) C_noret;
C_noret_decl(f_22745)
static void C_ccall f_22745(C_word c,C_word *av) C_noret;
C_noret_decl(f_22748)
static void C_ccall f_22748(C_word c,C_word *av) C_noret;
C_noret_decl(f_22789)
static void C_ccall f_22789(C_word c,C_word *av) C_noret;
C_noret_decl(f_22823)
static void f_22823(C_word t0,C_word t1) C_noret;
C_noret_decl(f_22826)
static void C_ccall f_22826(C_word c,C_word *av) C_noret;
C_noret_decl(f_22829)
static void C_ccall f_22829(C_word c,C_word *av) C_noret;
C_noret_decl(f_22832)
static void C_ccall f_22832(C_word c,C_word *av) C_noret;
C_noret_decl(f_22871)
static void C_ccall f_22871(C_word c,C_word *av) C_noret;
C_noret_decl(f_22877)
static void f_22877(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_22887)
static void C_ccall f_22887(C_word c,C_word *av) C_noret;
C_noret_decl(f_22892)
static C_word f_22892(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_22929)
static void C_ccall f_22929(C_word c,C_word *av) C_noret;
C_noret_decl(f_22936)
static void C_ccall f_22936(C_word c,C_word *av) C_noret;
C_noret_decl(f_22958)
static void C_ccall f_22958(C_word c,C_word *av) C_noret;
C_noret_decl(f_22974)
static void C_ccall f_22974(C_word c,C_word *av) C_noret;
C_noret_decl(f_22979)
static C_word f_22979(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_23010)
static void C_ccall f_23010(C_word c,C_word *av) C_noret;
C_noret_decl(f_23032)
static void C_ccall f_23032(C_word c,C_word *av) C_noret;
C_noret_decl(f_23035)
static void C_ccall f_23035(C_word c,C_word *av) C_noret;
C_noret_decl(f_23040)
static void f_23040(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_23058)
static void C_ccall f_23058(C_word c,C_word *av) C_noret;
C_noret_decl(f_23096)
static void C_ccall f_23096(C_word c,C_word *av) C_noret;
C_noret_decl(f_23102)
static void C_ccall f_23102(C_word c,C_word *av) C_noret;
C_noret_decl(f_23124)
static void C_ccall f_23124(C_word c,C_word *av) C_noret;
C_noret_decl(f_23127)
static void C_ccall f_23127(C_word c,C_word *av) C_noret;
C_noret_decl(f_23132)
static C_word f_23132(C_word t0,C_word t1);
C_noret_decl(f_23183)
static void C_ccall f_23183(C_word c,C_word *av) C_noret;
C_noret_decl(f_23200)
static void f_23200(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_23207)
static void C_ccall f_23207(C_word c,C_word *av) C_noret;
C_noret_decl(f_23210)
static void C_ccall f_23210(C_word c,C_word *av) C_noret;
C_noret_decl(f_23213)
static void C_ccall f_23213(C_word c,C_word *av) C_noret;
C_noret_decl(f_23218)
static C_word f_23218(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_23290)
static void C_ccall f_23290(C_word c,C_word *av) C_noret;
C_noret_decl(f_23310)
static void f_23310(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_23323)
static void C_ccall f_23323(C_word c,C_word *av) C_noret;
C_noret_decl(f_23326)
static void C_ccall f_23326(C_word c,C_word *av) C_noret;
C_noret_decl(f_23329)
static void C_ccall f_23329(C_word c,C_word *av) C_noret;
C_noret_decl(f_23332)
static void C_ccall f_23332(C_word c,C_word *av) C_noret;
C_noret_decl(f_23351)
static C_word f_23351(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_23385)
static C_word f_23385(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_23463)
static void C_ccall f_23463(C_word c,C_word *av) C_noret;
C_noret_decl(f_23478)
static void C_ccall f_23478(C_word c,C_word *av) C_noret;
C_noret_decl(f_23481)
static void C_ccall f_23481(C_word c,C_word *av) C_noret;
C_noret_decl(f_23486)
static void f_23486(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_23496)
static void C_ccall f_23496(C_word c,C_word *av) C_noret;
C_noret_decl(f_23526)
static C_word f_23526(C_word t0,C_word t1);
C_noret_decl(f_23550)
static void f_23550(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_23584)
static C_word f_23584(C_word t0);
C_noret_decl(f_23607)
static void C_ccall f_23607(C_word c,C_word *av) C_noret;
C_noret_decl(f_23626)
static void C_ccall f_23626(C_word c,C_word *av) C_noret;
C_noret_decl(f_23629)
static void C_ccall f_23629(C_word c,C_word *av) C_noret;
C_noret_decl(f_23632)
static void C_ccall f_23632(C_word c,C_word *av) C_noret;
C_noret_decl(f_23637)
static C_word f_23637(C_word t0,C_word t1);
C_noret_decl(f_23670)
static void C_ccall f_23670(C_word c,C_word *av) C_noret;
C_noret_decl(f_23691)
static void f_23691(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_23695)
static void C_ccall f_23695(C_word c,C_word *av) C_noret;
C_noret_decl(f_23698)
static void C_ccall f_23698(C_word c,C_word *av) C_noret;
C_noret_decl(f_23703)
static C_word f_23703(C_word t0,C_word t1);
C_noret_decl(f_23730)
static void C_ccall f_23730(C_word c,C_word *av) C_noret;
C_noret_decl(f_23746)
static void f_23746(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_23762)
static void C_ccall f_23762(C_word c,C_word *av) C_noret;
C_noret_decl(f_23779)
static void C_ccall f_23779(C_word c,C_word *av) C_noret;
C_noret_decl(f_23793)
static void f_23793(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_23809)
static void C_ccall f_23809(C_word c,C_word *av) C_noret;
C_noret_decl(f_23822)
static void C_ccall f_23822(C_word c,C_word *av) C_noret;
C_noret_decl(f_23836)
static void f_23836(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_23852)
static void C_ccall f_23852(C_word c,C_word *av) C_noret;
C_noret_decl(f_23865)
static void C_ccall f_23865(C_word c,C_word *av) C_noret;
C_noret_decl(f_23879)
static void f_23879(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_23895)
static void C_ccall f_23895(C_word c,C_word *av) C_noret;
C_noret_decl(f_23908)
static void C_ccall f_23908(C_word c,C_word *av) C_noret;
C_noret_decl(f_23922)
static void f_23922(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_23938)
static void C_ccall f_23938(C_word c,C_word *av) C_noret;
C_noret_decl(f_23953)
static void C_ccall f_23953(C_word c,C_word *av) C_noret;
C_noret_decl(f_23955)
static void f_23955(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_23968)
static C_word f_23968(C_word t0,C_word t1);
C_noret_decl(f_23996)
static void C_ccall f_23996(C_word c,C_word *av) C_noret;
C_noret_decl(f_24009)
static void C_ccall f_24009(C_word c,C_word *av) C_noret;
C_noret_decl(f_24027)
static void C_ccall f_24027(C_word c,C_word *av) C_noret;
C_noret_decl(f_24030)
static void C_ccall f_24030(C_word c,C_word *av) C_noret;
C_noret_decl(f_24113)
static void C_ccall f_24113(C_word c,C_word *av) C_noret;
C_noret_decl(f_24116)
static void C_ccall f_24116(C_word c,C_word *av) C_noret;
C_noret_decl(f_24119)
static void C_ccall f_24119(C_word c,C_word *av) C_noret;
C_noret_decl(f_24122)
static void C_ccall f_24122(C_word c,C_word *av) C_noret;
C_noret_decl(f_24125)
static void C_ccall f_24125(C_word c,C_word *av) C_noret;
C_noret_decl(f_24128)
static void C_ccall f_24128(C_word c,C_word *av) C_noret;
C_noret_decl(f_24131)
static void C_ccall f_24131(C_word c,C_word *av) C_noret;
C_noret_decl(f_24134)
static void C_ccall f_24134(C_word c,C_word *av) C_noret;
C_noret_decl(f_24137)
static void C_ccall f_24137(C_word c,C_word *av) C_noret;
C_noret_decl(f_24140)
static void C_ccall f_24140(C_word c,C_word *av) C_noret;
C_noret_decl(f_24143)
static void C_ccall f_24143(C_word c,C_word *av) C_noret;
C_noret_decl(f_24146)
static void C_ccall f_24146(C_word c,C_word *av) C_noret;
C_noret_decl(f_24149)
static void C_ccall f_24149(C_word c,C_word *av) C_noret;
C_noret_decl(f_24152)
static void C_ccall f_24152(C_word c,C_word *av) C_noret;
C_noret_decl(f_24157)
static void C_ccall f_24157(C_word c,C_word *av) C_noret;
C_noret_decl(f_24163)
static void f_24163(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24179)
static void C_ccall f_24179(C_word c,C_word *av) C_noret;
C_noret_decl(f_24195)
static void C_ccall f_24195(C_word c,C_word *av) C_noret;
C_noret_decl(f_24201)
static void f_24201(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24221)
static void C_ccall f_24221(C_word c,C_word *av) C_noret;
C_noret_decl(f_24225)
static void C_ccall f_24225(C_word c,C_word *av) C_noret;
C_noret_decl(f_24237)
static void C_ccall f_24237(C_word c,C_word *av) C_noret;
C_noret_decl(f_24243)
static void C_ccall f_24243(C_word c,C_word *av) C_noret;
C_noret_decl(f_24249)
static void f_24249(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24281)
static void C_ccall f_24281(C_word c,C_word *av) C_noret;
C_noret_decl(f_24285)
static void C_ccall f_24285(C_word c,C_word *av) C_noret;
C_noret_decl(f_24295)
static void C_ccall f_24295(C_word c,C_word *av) C_noret;
C_noret_decl(f_24310)
static void f_24310(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24320)
static void C_ccall f_24320(C_word c,C_word *av) C_noret;
C_noret_decl(f_24340)
static void f_24340(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24347)
static void C_ccall f_24347(C_word c,C_word *av) C_noret;
C_noret_decl(f_24356)
static void C_ccall f_24356(C_word c,C_word *av) C_noret;
C_noret_decl(f_24363)
static void C_ccall f_24363(C_word c,C_word *av) C_noret;
C_noret_decl(f_24365)
static void C_ccall f_24365(C_word c,C_word *av) C_noret;
C_noret_decl(f_24371)
static void C_ccall f_24371(C_word c,C_word *av) C_noret;
C_noret_decl(f_24377)
static void C_ccall f_24377(C_word c,C_word *av) C_noret;
C_noret_decl(f_24395)
static void f_24395(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24420)
static void C_ccall f_24420(C_word c,C_word *av) C_noret;
C_noret_decl(f_24436)
static void f_24436(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24443)
static void C_ccall f_24443(C_word c,C_word *av) C_noret;
C_noret_decl(f_24456)
static void C_ccall f_24456(C_word c,C_word *av) C_noret;
C_noret_decl(f_24460)
static void C_ccall f_24460(C_word c,C_word *av) C_noret;
C_noret_decl(f_24464)
static void C_ccall f_24464(C_word c,C_word *av) C_noret;
C_noret_decl(f_24466)
static void C_ccall f_24466(C_word c,C_word *av) C_noret;
C_noret_decl(f_24472)
static void C_ccall f_24472(C_word c,C_word *av) C_noret;
C_noret_decl(f_24479)
static void C_ccall f_24479(C_word c,C_word *av) C_noret;
C_noret_decl(f_24483)
static void C_ccall f_24483(C_word c,C_word *av) C_noret;
C_noret_decl(f_24492)
static void C_ccall f_24492(C_word c,C_word *av) C_noret;
C_noret_decl(f_24500)
static void C_ccall f_24500(C_word c,C_word *av) C_noret;
C_noret_decl(f_24510)
static void C_ccall f_24510(C_word c,C_word *av) C_noret;
C_noret_decl(f_24516)
static void C_ccall f_24516(C_word c,C_word *av) C_noret;
C_noret_decl(f_24519)
static void C_ccall f_24519(C_word c,C_word *av) C_noret;
C_noret_decl(f_24523)
static void C_ccall f_24523(C_word c,C_word *av) C_noret;
C_noret_decl(f_24550)
static void f_24550(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_24566)
static void C_ccall f_24566(C_word c,C_word *av) C_noret;
C_noret_decl(f_24572)
static void C_ccall f_24572(C_word c,C_word *av) C_noret;
C_noret_decl(f_24595)
static void C_ccall f_24595(C_word c,C_word *av) C_noret;
C_noret_decl(f_24608)
static void C_ccall f_24608(C_word c,C_word *av) C_noret;
C_noret_decl(f_24612)
static void C_ccall f_24612(C_word c,C_word *av) C_noret;
C_noret_decl(f_24621)
static void C_ccall f_24621(C_word c,C_word *av) C_noret;
C_noret_decl(f_24667)
static void C_ccall f_24667(C_word c,C_word *av) C_noret;
C_noret_decl(f_24671)
static void C_ccall f_24671(C_word c,C_word *av) C_noret;
C_noret_decl(f_24675)
static void C_ccall f_24675(C_word c,C_word *av) C_noret;
C_noret_decl(f_24678)
static void C_ccall f_24678(C_word c,C_word *av) C_noret;
C_noret_decl(f_24681)
static void C_ccall f_24681(C_word c,C_word *av) C_noret;
C_noret_decl(f_24684)
static void C_ccall f_24684(C_word c,C_word *av) C_noret;
C_noret_decl(f_24686)
static void C_ccall f_24686(C_word c,C_word *av) C_noret;
C_noret_decl(f_24697)
static void C_ccall f_24697(C_word c,C_word *av) C_noret;
C_noret_decl(f_24708)
static void C_ccall f_24708(C_word c,C_word *av) C_noret;
C_noret_decl(f_24719)
static void C_ccall f_24719(C_word c,C_word *av) C_noret;
C_noret_decl(f_24730)
static void C_ccall f_24730(C_word c,C_word *av) C_noret;
C_noret_decl(f_24743)
static void C_ccall f_24743(C_word c,C_word *av) C_noret;
C_noret_decl(f_24745)
static C_word f_24745(C_word t0,C_word t1);
C_noret_decl(f_24751)
static C_word f_24751(C_word t0);
C_noret_decl(f_24756)
static C_word f_24756(C_word t0);
C_noret_decl(f_24791)
static void C_ccall f_24791(C_word c,C_word *av) C_noret;
C_noret_decl(f_24804)
static void C_ccall f_24804(C_word c,C_word *av) C_noret;
C_noret_decl(f_24806)
static C_word f_24806(C_word t0,C_word t1);
C_noret_decl(f_24812)
static C_word f_24812(C_word t0);
C_noret_decl(f_24817)
static C_word f_24817(C_word t0);
C_noret_decl(f_24852)
static void C_ccall f_24852(C_word c,C_word *av) C_noret;
C_noret_decl(f_24865)
static void C_ccall f_24865(C_word c,C_word *av) C_noret;
C_noret_decl(f_24867)
static C_word f_24867(C_word t0,C_word t1);
C_noret_decl(f_24873)
static C_word f_24873(C_word t0);
C_noret_decl(f_24878)
static C_word f_24878(C_word t0);
C_noret_decl(f_24913)
static void C_ccall f_24913(C_word c,C_word *av) C_noret;
C_noret_decl(f_24925)
static void C_ccall f_24925(C_word c,C_word *av) C_noret;
C_noret_decl(f_24927)
static void C_ccall f_24927(C_word c,C_word *av) C_noret;
C_noret_decl(f_24933)
static void C_ccall f_24933(C_word c,C_word *av) C_noret;
C_noret_decl(f_24940)
static void f_24940(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_24950)
static void C_ccall f_24950(C_word c,C_word *av) C_noret;
C_noret_decl(f_24953)
static void C_ccall f_24953(C_word c,C_word *av) C_noret;
C_noret_decl(f_24956)
static void C_ccall f_24956(C_word c,C_word *av) C_noret;
C_noret_decl(f_24962)
static void C_ccall f_24962(C_word c,C_word *av) C_noret;
C_noret_decl(f_24965)
static void C_ccall f_24965(C_word c,C_word *av) C_noret;
C_noret_decl(f_24972)
static void C_ccall f_24972(C_word c,C_word *av) C_noret;
C_noret_decl(f_24976)
static void C_ccall f_24976(C_word c,C_word *av) C_noret;
C_noret_decl(f_24980)
static void C_ccall f_24980(C_word c,C_word *av) C_noret;
C_noret_decl(f_24984)
static void C_ccall f_24984(C_word c,C_word *av) C_noret;
C_noret_decl(f_24990)
static void f_24990(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_25003)
static void C_ccall f_25003(C_word c,C_word *av) C_noret;
C_noret_decl(f_25047)
static void f_25047(C_word t0,C_word t1) C_noret;
C_noret_decl(f_25057)
static void f_25057(C_word t0,C_word t1) C_noret;
C_noret_decl(f_25170)
static void f_25170(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_25174)
static void C_ccall f_25174(C_word c,C_word *av) C_noret;
C_noret_decl(f_25207)
static void C_ccall f_25207(C_word c,C_word *av) C_noret;
C_noret_decl(f_25213)
static void C_ccall f_25213(C_word c,C_word *av) C_noret;
C_noret_decl(f_25219)
static void C_ccall f_25219(C_word c,C_word *av) C_noret;
C_noret_decl(f_25225)
static void C_ccall f_25225(C_word c,C_word *av) C_noret;
C_noret_decl(f_25231)
static void C_ccall f_25231(C_word c,C_word *av) C_noret;
C_noret_decl(f_25235)
static void C_ccall f_25235(C_word c,C_word *av) C_noret;
C_noret_decl(f_25240)
static void C_ccall f_25240(C_word c,C_word *av) C_noret;
C_noret_decl(f_25246)
static void C_ccall f_25246(C_word c,C_word *av) C_noret;
C_noret_decl(f_25250)
static void C_ccall f_25250(C_word c,C_word *av) C_noret;
C_noret_decl(f_25255)
static void C_ccall f_25255(C_word c,C_word *av) C_noret;
C_noret_decl(f_25259)
static void C_ccall f_25259(C_word c,C_word *av) C_noret;
C_noret_decl(f_25264)
static void C_ccall f_25264(C_word c,C_word *av) C_noret;
C_noret_decl(f_25270)
static void C_ccall f_25270(C_word c,C_word *av) C_noret;
C_noret_decl(f_25274)
static void C_ccall f_25274(C_word c,C_word *av) C_noret;
C_noret_decl(f_25279)
static void C_ccall f_25279(C_word c,C_word *av) C_noret;
C_noret_decl(f_25283)
static void C_ccall f_25283(C_word c,C_word *av) C_noret;
C_noret_decl(f_25288)
static void C_ccall f_25288(C_word c,C_word *av) C_noret;
C_noret_decl(f_25293)
static void C_ccall f_25293(C_word c,C_word *av) C_noret;
C_noret_decl(f_25299)
static void C_ccall f_25299(C_word c,C_word *av) C_noret;
C_noret_decl(f_25303)
static void C_ccall f_25303(C_word c,C_word *av) C_noret;
C_noret_decl(f_25308)
static void C_ccall f_25308(C_word c,C_word *av) C_noret;
C_noret_decl(f_25313)
static void C_ccall f_25313(C_word c,C_word *av) C_noret;
C_noret_decl(f_25317)
static void C_ccall f_25317(C_word c,C_word *av) C_noret;
C_noret_decl(f_25322)
static void C_ccall f_25322(C_word c,C_word *av) C_noret;
C_noret_decl(f_25327)
static void C_ccall f_25327(C_word c,C_word *av) C_noret;
C_noret_decl(f_25333)
static void C_ccall f_25333(C_word c,C_word *av) C_noret;
C_noret_decl(f_25337)
static void C_ccall f_25337(C_word c,C_word *av) C_noret;
C_noret_decl(f_25342)
static void C_ccall f_25342(C_word c,C_word *av) C_noret;
C_noret_decl(f_25347)
static void C_ccall f_25347(C_word c,C_word *av) C_noret;
C_noret_decl(f_25352)
static void C_ccall f_25352(C_word c,C_word *av) C_noret;
C_noret_decl(f_25373)
static void C_ccall f_25373(C_word c,C_word *av) C_noret;
C_noret_decl(f_25380)
static void C_ccall f_25380(C_word c,C_word *av) C_noret;
C_noret_decl(f_25386)
static void C_ccall f_25386(C_word c,C_word *av) C_noret;
C_noret_decl(f_25404)
static void C_ccall f_25404(C_word c,C_word *av) C_noret;
C_noret_decl(f_25413)
static void C_ccall f_25413(C_word c,C_word *av) C_noret;
C_noret_decl(f_25426)
static void f_25426(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_25434)
static void C_ccall f_25434(C_word c,C_word *av) C_noret;
C_noret_decl(f_25439)
static void f_25439(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_25476)
static void C_ccall f_25476(C_word c,C_word *av) C_noret;
C_noret_decl(f_25488)
static void C_ccall f_25488(C_word c,C_word *av) C_noret;
C_noret_decl(f_25498)
static void f_25498(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_25514)
static void C_ccall f_25514(C_word c,C_word *av) C_noret;
C_noret_decl(f_25527)
static void C_ccall f_25527(C_word c,C_word *av) C_noret;
C_noret_decl(f_25537)
static void C_ccall f_25537(C_word c,C_word *av) C_noret;
C_noret_decl(f_25543)
static void C_ccall f_25543(C_word c,C_word *av) C_noret;
C_noret_decl(f_25556)
static void C_ccall f_25556(C_word c,C_word *av) C_noret;
C_noret_decl(f_25562)
static void C_ccall f_25562(C_word c,C_word *av) C_noret;
C_noret_decl(f_25569)
static void C_ccall f_25569(C_word c,C_word *av) C_noret;
C_noret_decl(f_25576)
static void C_ccall f_25576(C_word c,C_word *av) C_noret;
C_noret_decl(f_25580)
static void C_ccall f_25580(C_word c,C_word *av) C_noret;
C_noret_decl(f_25583)
static void C_ccall f_25583(C_word c,C_word *av) C_noret;
C_noret_decl(f_25593)
static void C_ccall f_25593(C_word c,C_word *av) C_noret;
C_noret_decl(f_25597)
static void C_ccall f_25597(C_word c,C_word *av) C_noret;
C_noret_decl(f_25605)
static void C_ccall f_25605(C_word c,C_word *av) C_noret;
C_noret_decl(f_25608)
static void C_ccall f_25608(C_word c,C_word *av) C_noret;
C_noret_decl(f_25615)
static void C_ccall f_25615(C_word c,C_word *av) C_noret;
C_noret_decl(f_25618)
static void C_ccall f_25618(C_word c,C_word *av) C_noret;
C_noret_decl(f_25621)
static void C_ccall f_25621(C_word c,C_word *av) C_noret;
C_noret_decl(f_25624)
static void C_ccall f_25624(C_word c,C_word *av) C_noret;
C_noret_decl(f_25632)
static void C_ccall f_25632(C_word c,C_word *av) C_noret;
C_noret_decl(f_25640)
static void C_ccall f_25640(C_word c,C_word *av) C_noret;
C_noret_decl(f_25642)
static void C_ccall f_25642(C_word c,C_word *av) C_noret;
C_noret_decl(f_25658)
static void C_ccall f_25658(C_word c,C_word *av) C_noret;
C_noret_decl(f_25685)
static void C_ccall f_25685(C_word c,C_word *av) C_noret;
C_noret_decl(f_25689)
static void C_ccall f_25689(C_word c,C_word *av) C_noret;
C_noret_decl(f_25693)
static void C_ccall f_25693(C_word c,C_word *av) C_noret;
C_noret_decl(f_25697)
static void C_ccall f_25697(C_word c,C_word *av) C_noret;
C_noret_decl(f_25701)
static void C_ccall f_25701(C_word c,C_word *av) C_noret;
C_noret_decl(f_25705)
static void C_ccall f_25705(C_word c,C_word *av) C_noret;
C_noret_decl(f_25709)
static void C_ccall f_25709(C_word c,C_word *av) C_noret;
C_noret_decl(f_25713)
static void C_ccall f_25713(C_word c,C_word *av) C_noret;
C_noret_decl(f_25717)
static void C_ccall f_25717(C_word c,C_word *av) C_noret;
C_noret_decl(f_25721)
static void C_ccall f_25721(C_word c,C_word *av) C_noret;
C_noret_decl(f_25725)
static void C_ccall f_25725(C_word c,C_word *av) C_noret;
C_noret_decl(f_25729)
static void C_ccall f_25729(C_word c,C_word *av) C_noret;
C_noret_decl(f_25733)
static void C_ccall f_25733(C_word c,C_word *av) C_noret;
C_noret_decl(f_25737)
static void C_ccall f_25737(C_word c,C_word *av) C_noret;
C_noret_decl(f_25741)
static void C_ccall f_25741(C_word c,C_word *av) C_noret;
C_noret_decl(f_25745)
static void C_ccall f_25745(C_word c,C_word *av) C_noret;
C_noret_decl(f_25749)
static void C_ccall f_25749(C_word c,C_word *av) C_noret;
C_noret_decl(f_25753)
static void C_ccall f_25753(C_word c,C_word *av) C_noret;
C_noret_decl(f_25760)
static void C_ccall f_25760(C_word c,C_word *av) C_noret;
C_noret_decl(f_25767)
static void C_ccall f_25767(C_word c,C_word *av) C_noret;
C_noret_decl(f_25768)
static void f_25768(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_25772)
static void f_25772(C_word t0,C_word t1) C_noret;
C_noret_decl(f_25775)
static void C_ccall f_25775(C_word c,C_word *av) C_noret;
C_noret_decl(f_25791)
static void C_ccall f_25791(C_word c,C_word *av) C_noret;
C_noret_decl(f_25802)
static void f_25802(C_word t0,C_word t1) C_noret;
C_noret_decl(f_25810)
static void C_ccall f_25810(C_word c,C_word *av) C_noret;
C_noret_decl(f_25822)
static void f_25822(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_25831)
static void f_25831(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_25836)
static void f_25836(C_word t0,C_word t1) C_noret;
C_noret_decl(f_25892)
static void C_ccall f_25892(C_word c,C_word *av) C_noret;
C_noret_decl(f_25906)
static void C_ccall f_25906(C_word c,C_word *av) C_noret;
C_noret_decl(f_25918)
static void C_ccall f_25918(C_word c,C_word *av) C_noret;
C_noret_decl(f_25924)
static void C_ccall f_25924(C_word c,C_word *av) C_noret;
C_noret_decl(f_25949)
static void C_ccall f_25949(C_word c,C_word *av) C_noret;
C_noret_decl(f_25967)
static void C_ccall f_25967(C_word c,C_word *av) C_noret;
C_noret_decl(f_25971)
static void C_ccall f_25971(C_word c,C_word *av) C_noret;
C_noret_decl(f_26027)
static void C_ccall f_26027(C_word c,C_word *av) C_noret;
C_noret_decl(f_26036)
static void C_ccall f_26036(C_word c,C_word *av) C_noret;
C_noret_decl(f_26049)
static void C_ccall f_26049(C_word c,C_word *av) C_noret;
C_noret_decl(f_26061)
static void C_ccall f_26061(C_word c,C_word *av) C_noret;
C_noret_decl(f_26079)
static void C_ccall f_26079(C_word c,C_word *av) C_noret;
C_noret_decl(f_26099)
static void C_ccall f_26099(C_word c,C_word *av) C_noret;
C_noret_decl(f_26102)
static void C_ccall f_26102(C_word c,C_word *av) C_noret;
C_noret_decl(f_26107)
static void C_ccall f_26107(C_word c,C_word *av) C_noret;
C_noret_decl(f_26109)
static void C_ccall f_26109(C_word c,C_word *av) C_noret;
C_noret_decl(f_26117)
static void C_ccall f_26117(C_word c,C_word *av) C_noret;
C_noret_decl(f_26121)
static void C_ccall f_26121(C_word c,C_word *av) C_noret;
C_noret_decl(f_26125)
static void C_ccall f_26125(C_word c,C_word *av) C_noret;
C_noret_decl(f_26129)
static void C_ccall f_26129(C_word c,C_word *av) C_noret;
C_noret_decl(f_26133)
static void C_ccall f_26133(C_word c,C_word *av) C_noret;
C_noret_decl(f_26135)
static void C_ccall f_26135(C_word c,C_word *av) C_noret;
C_noret_decl(f_26143)
static void C_ccall f_26143(C_word c,C_word *av) C_noret;
C_noret_decl(f_26146)
static void C_ccall f_26146(C_word c,C_word *av) C_noret;
C_noret_decl(f_26156)
static void C_ccall f_26156(C_word c,C_word *av) C_noret;
C_noret_decl(f_26158)
static void C_ccall f_26158(C_word c,C_word *av) C_noret;
C_noret_decl(f_26166)
static void C_ccall f_26166(C_word c,C_word *av) C_noret;
C_noret_decl(f_26169)
static void C_ccall f_26169(C_word c,C_word *av) C_noret;
C_noret_decl(f_26179)
static void C_ccall f_26179(C_word c,C_word *av) C_noret;
C_noret_decl(f_26181)
static void C_ccall f_26181(C_word c,C_word *av) C_noret;
C_noret_decl(f_26188)
static void C_ccall f_26188(C_word c,C_word *av) C_noret;
C_noret_decl(f_26191)
static void C_ccall f_26191(C_word c,C_word *av) C_noret;
C_noret_decl(f_26194)
static void C_ccall f_26194(C_word c,C_word *av) C_noret;
C_noret_decl(f_26197)
static void C_ccall f_26197(C_word c,C_word *av) C_noret;
C_noret_decl(f_26199)
static void C_ccall f_26199(C_word c,C_word *av) C_noret;
C_noret_decl(f_26205)
static void f_26205(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_26214)
static void f_26214(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26222)
static void C_ccall f_26222(C_word c,C_word *av) C_noret;
C_noret_decl(f_26224)
static void f_26224(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26238)
static void C_ccall f_26238(C_word c,C_word *av) C_noret;
C_noret_decl(f_26251)
static void f_26251(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26255)
static void C_ccall f_26255(C_word c,C_word *av) C_noret;
C_noret_decl(f_26260)
static void f_26260(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26264)
static void C_ccall f_26264(C_word c,C_word *av) C_noret;
C_noret_decl(f_26275)
static C_word f_26275(C_word *a,C_word t0,C_word t1,C_word t2);
C_noret_decl(f_26286)
static void f_26286(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_26290)
static void C_ccall f_26290(C_word c,C_word *av) C_noret;
C_noret_decl(f_26314)
static void f_26314(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_26320)
static void f_26320(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26330)
static void C_ccall f_26330(C_word c,C_word *av) C_noret;
C_noret_decl(f_26349)
static void C_ccall f_26349(C_word c,C_word *av) C_noret;
C_noret_decl(f_26373)
static void C_ccall f_26373(C_word c,C_word *av) C_noret;
C_noret_decl(f_26395)
static void f_26395(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26408)
static void C_ccall f_26408(C_word c,C_word *av) C_noret;
C_noret_decl(f_26428)
static void C_ccall f_26428(C_word c,C_word *av) C_noret;
C_noret_decl(f_26434)
static void f_26434(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26437)
static void f_26437(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26445)
static void C_ccall f_26445(C_word c,C_word *av) C_noret;
C_noret_decl(f_26447)
static void f_26447(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26460)
static void C_ccall f_26460(C_word c,C_word *av) C_noret;
C_noret_decl(f_26467)
static void C_ccall f_26467(C_word c,C_word *av) C_noret;
C_noret_decl(f_26476)
static void C_ccall f_26476(C_word c,C_word *av) C_noret;
C_noret_decl(f_26483)
static void C_ccall f_26483(C_word c,C_word *av) C_noret;
C_noret_decl(f_26485)
static void f_26485(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_26491)
static void f_26491(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_26501)
static void C_ccall f_26501(C_word c,C_word *av) C_noret;
C_noret_decl(f_26504)
static void C_ccall f_26504(C_word c,C_word *av) C_noret;
C_noret_decl(f_26514)
static void C_ccall f_26514(C_word c,C_word *av) C_noret;
C_noret_decl(f_26517)
static void C_ccall f_26517(C_word c,C_word *av) C_noret;
C_noret_decl(f_26545)
static void f_26545(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26548)
static void f_26548(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26552)
static void C_ccall f_26552(C_word c,C_word *av) C_noret;
C_noret_decl(f_26555)
static void C_ccall f_26555(C_word c,C_word *av) C_noret;
C_noret_decl(f_26565)
static void C_ccall f_26565(C_word c,C_word *av) C_noret;
C_noret_decl(f_26567)
static C_word f_26567(C_word t0);
C_noret_decl(f_26571)
static void f_26571(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26580)
static void f_26580(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26584)
static void C_ccall f_26584(C_word c,C_word *av) C_noret;
C_noret_decl(f_26602)
static void C_ccall f_26602(C_word c,C_word *av) C_noret;
C_noret_decl(f_26623)
static void C_ccall f_26623(C_word c,C_word *av) C_noret;
C_noret_decl(f_26635)
static void f_26635(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26646)
static void C_ccall f_26646(C_word c,C_word *av) C_noret;
C_noret_decl(f_26649)
static void C_ccall f_26649(C_word c,C_word *av) C_noret;
C_noret_decl(f_26685)
static void f_26685(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_26693)
static void C_ccall f_26693(C_word c,C_word *av) C_noret;
C_noret_decl(f_26695)
static void f_26695(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_26712)
static void C_ccall f_26712(C_word c,C_word *av) C_noret;
C_noret_decl(f_26725)
static void C_ccall f_26725(C_word c,C_word *av) C_noret;
C_noret_decl(f_26742)
static void C_ccall f_26742(C_word c,C_word *av) C_noret;
C_noret_decl(f_26759)
static void C_ccall f_26759(C_word c,C_word *av) C_noret;
C_noret_decl(f_26776)
static void C_ccall f_26776(C_word c,C_word *av) C_noret;
C_noret_decl(f_26793)
static void C_ccall f_26793(C_word c,C_word *av) C_noret;
C_noret_decl(f_26810)
static void C_ccall f_26810(C_word c,C_word *av) C_noret;
C_noret_decl(f_26827)
static void C_ccall f_26827(C_word c,C_word *av) C_noret;
C_noret_decl(f_26847)
static void C_ccall f_26847(C_word c,C_word *av) C_noret;
C_noret_decl(f_26855)
static void C_ccall f_26855(C_word c,C_word *av) C_noret;
C_noret_decl(f_26864)
static void C_ccall f_26864(C_word c,C_word *av) C_noret;
C_noret_decl(f_26871)
static void C_ccall f_26871(C_word c,C_word *av) C_noret;
C_noret_decl(f_26888)
static void C_ccall f_26888(C_word c,C_word *av) C_noret;
C_noret_decl(f_26895)
static void C_ccall f_26895(C_word c,C_word *av) C_noret;
C_noret_decl(f_26912)
static void f_26912(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26919)
static void C_ccall f_26919(C_word c,C_word *av) C_noret;
C_noret_decl(f_26932)
static void f_26932(C_word t0,C_word t1) C_noret;
C_noret_decl(f_26937)
static void f_26937(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_26954)
static void C_ccall f_26954(C_word c,C_word *av) C_noret;
C_noret_decl(f_26969)
static void C_ccall f_26969(C_word c,C_word *av) C_noret;
C_noret_decl(f_26982)
static void C_ccall f_26982(C_word c,C_word *av) C_noret;
C_noret_decl(f_27004)
static void C_ccall f_27004(C_word c,C_word *av) C_noret;
C_noret_decl(f_27007)
static void C_ccall f_27007(C_word c,C_word *av) C_noret;
C_noret_decl(f_27036)
static void f_27036(C_word t0,C_word t1) C_noret;
C_noret_decl(f_27046)
static void C_ccall f_27046(C_word c,C_word *av) C_noret;
C_noret_decl(f_27062)
static void C_ccall f_27062(C_word c,C_word *av) C_noret;
C_noret_decl(f_27073)
static void C_ccall f_27073(C_word c,C_word *av) C_noret;
C_noret_decl(f_27080)
static void C_ccall f_27080(C_word c,C_word *av) C_noret;
C_noret_decl(f_27178)
static void C_ccall f_27178(C_word c,C_word *av) C_noret;
C_noret_decl(f_27184)
static void f_27184(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_27193)
static void f_27193(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27207)
static void C_ccall f_27207(C_word c,C_word *av) C_noret;
C_noret_decl(f_27210)
static void C_ccall f_27210(C_word c,C_word *av) C_noret;
C_noret_decl(f_27221)
static void C_ccall f_27221(C_word c,C_word *av) C_noret;
C_noret_decl(f_27223)
static void C_ccall f_27223(C_word c,C_word *av) C_noret;
C_noret_decl(f_27226)
static void C_ccall f_27226(C_word c,C_word *av) C_noret;
C_noret_decl(f_27243)
static void C_ccall f_27243(C_word c,C_word *av) C_noret;
C_noret_decl(f_27248)
static void f_27248(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27252)
static void C_ccall f_27252(C_word c,C_word *av) C_noret;
C_noret_decl(f_27255)
static void f_27255(C_word t0,C_word t1) C_noret;
C_noret_decl(f_27258)
static void C_ccall f_27258(C_word c,C_word *av) C_noret;
C_noret_decl(f_27268)
static void C_ccall f_27268(C_word c,C_word *av) C_noret;
C_noret_decl(f_27286)
static void C_ccall f_27286(C_word c,C_word *av) C_noret;
C_noret_decl(f_27289)
static void C_ccall f_27289(C_word c,C_word *av) C_noret;
C_noret_decl(f_27298)
static void f_27298(C_word t0,C_word t1) C_noret;
C_noret_decl(f_27301)
static void C_ccall f_27301(C_word c,C_word *av) C_noret;
C_noret_decl(f_27304)
static void C_ccall f_27304(C_word c,C_word *av) C_noret;
C_noret_decl(f_27310)
static void C_ccall f_27310(C_word c,C_word *av) C_noret;
C_noret_decl(f_27323)
static void C_ccall f_27323(C_word c,C_word *av) C_noret;
C_noret_decl(f_27327)
static void C_ccall f_27327(C_word c,C_word *av) C_noret;
C_noret_decl(f_27331)
static void C_ccall f_27331(C_word c,C_word *av) C_noret;
C_noret_decl(f_27342)
static void C_ccall f_27342(C_word c,C_word *av) C_noret;
C_noret_decl(f_27346)
static void C_ccall f_27346(C_word c,C_word *av) C_noret;
C_noret_decl(f_27349)
static void C_ccall f_27349(C_word c,C_word *av) C_noret;
C_noret_decl(f_27377)
static void C_ccall f_27377(C_word c,C_word *av) C_noret;
C_noret_decl(f_27432)
static void C_ccall f_27432(C_word c,C_word *av) C_noret;
C_noret_decl(f_27436)
static void C_ccall f_27436(C_word c,C_word *av) C_noret;
C_noret_decl(f_27443)
static void C_ccall f_27443(C_word c,C_word *av) C_noret;
C_noret_decl(f_27445)
static void f_27445(C_word t0,C_word t1) C_noret;
C_noret_decl(f_27449)
static void C_ccall f_27449(C_word c,C_word *av) C_noret;
C_noret_decl(f_27463)
static void f_27463(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_27469)
static void C_ccall f_27469(C_word c,C_word *av) C_noret;
C_noret_decl(f_27476)
static void C_ccall f_27476(C_word c,C_word *av) C_noret;
C_noret_decl(f_27483)
static void C_ccall f_27483(C_word c,C_word *av) C_noret;
C_noret_decl(f_27503)
static void C_ccall f_27503(C_word c,C_word *av) C_noret;
C_noret_decl(f_27532)
static void f_27532(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27542)
static void C_ccall f_27542(C_word c,C_word *av) C_noret;
C_noret_decl(f_27545)
static void C_ccall f_27545(C_word c,C_word *av) C_noret;
C_noret_decl(f_27581)
static void C_ccall f_27581(C_word c,C_word *av) C_noret;
C_noret_decl(f_27583)
static void f_27583(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27593)
static void C_ccall f_27593(C_word c,C_word *av) C_noret;
C_noret_decl(f_27596)
static void C_ccall f_27596(C_word c,C_word *av) C_noret;
C_noret_decl(f_27648)
static void C_ccall f_27648(C_word c,C_word *av) C_noret;
C_noret_decl(f_27650)
static void f_27650(C_word t0,C_word t1) C_noret;
C_noret_decl(f_27658)
static void C_ccall f_27658(C_word c,C_word *av) C_noret;
C_noret_decl(f_27660)
static void f_27660(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_27670)
static void f_27670(C_word t0,C_word t1) C_noret;
C_noret_decl(f_27685)
static void C_ccall f_27685(C_word c,C_word *av) C_noret;
C_noret_decl(f_27692)
static void C_ccall f_27692(C_word c,C_word *av) C_noret;
C_noret_decl(f_27712)
static void f_27712(C_word t0,C_word t1) C_noret;
C_noret_decl(f_27720)
static void C_ccall f_27720(C_word c,C_word *av) C_noret;
C_noret_decl(f_27722)
static void f_27722(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_27738)
static void C_ccall f_27738(C_word c,C_word *av) C_noret;
C_noret_decl(f_27745)
static void C_ccall f_27745(C_word c,C_word *av) C_noret;
C_noret_decl(f_27758)
static void f_27758(C_word t0,C_word t1) C_noret;
C_noret_decl(f_27764)
static void C_ccall f_27764(C_word c,C_word *av) C_noret;
C_noret_decl(f_27768)
static void C_ccall f_27768(C_word c,C_word *av) C_noret;
C_noret_decl(f_27775)
static void C_ccall f_27775(C_word c,C_word *av) C_noret;
C_noret_decl(f_27783)
static void f_27783(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_27788)
static void f_27788(C_word t0,C_word t1) C_noret;
C_noret_decl(f_27793)
static void f_27793(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_27797)
static void C_ccall f_27797(C_word c,C_word *av) C_noret;
C_noret_decl(f_27806)
static void f_27806(C_word t0,C_word t1) C_noret;
C_noret_decl(f_27812)
static void f_27812(C_word t0,C_word t1) C_noret;
C_noret_decl(f_27819)
static void C_ccall f_27819(C_word c,C_word *av) C_noret;
C_noret_decl(f_27836)
static void C_ccall f_27836(C_word c,C_word *av) C_noret;
C_noret_decl(f_27842)
static void f_27842(C_word t0,C_word t1) C_noret;
C_noret_decl(f_27852)
static void C_ccall f_27852(C_word c,C_word *av) C_noret;
C_noret_decl(f_27903)
static void C_ccall f_27903(C_word c,C_word *av) C_noret;
C_noret_decl(f_27912)
static void C_ccall f_27912(C_word c,C_word *av) C_noret;
C_noret_decl(f_27919)
static void C_ccall f_27919(C_word c,C_word *av) C_noret;
C_noret_decl(f_27923)
static void C_ccall f_27923(C_word c,C_word *av) C_noret;
C_noret_decl(f_27927)
static void C_ccall f_27927(C_word c,C_word *av) C_noret;
C_noret_decl(f_27936)
static void C_ccall f_27936(C_word c,C_word *av) C_noret;
C_noret_decl(f_27947)
static void C_ccall f_27947(C_word c,C_word *av) C_noret;
C_noret_decl(f_27969)
static void C_ccall f_27969(C_word c,C_word *av) C_noret;
C_noret_decl(f_27996)
static void C_ccall f_27996(C_word c,C_word *av) C_noret;
C_noret_decl(f_28028)
static void C_ccall f_28028(C_word c,C_word *av) C_noret;
C_noret_decl(f_28032)
static void C_ccall f_28032(C_word c,C_word *av) C_noret;
C_noret_decl(f_28034)
static void f_28034(C_word t0,C_word t1) C_noret;
C_noret_decl(f_28038)
static void C_ccall f_28038(C_word c,C_word *av) C_noret;
C_noret_decl(f_28041)
static void C_ccall f_28041(C_word c,C_word *av) C_noret;
C_noret_decl(f_28053)
static void C_ccall f_28053(C_word c,C_word *av) C_noret;
C_noret_decl(f_28073)
static void f_28073(C_word t0,C_word t1) C_noret;
C_noret_decl(f_28079)
static void C_ccall f_28079(C_word c,C_word *av) C_noret;
C_noret_decl(f_28089)
static void C_ccall f_28089(C_word c,C_word *av) C_noret;
C_noret_decl(f_28226)
static void f_28226(C_word t0,C_word t1) C_noret;
C_noret_decl(f_28233)
static void C_ccall f_28233(C_word c,C_word *av) C_noret;
C_noret_decl(f_28251)
static void f_28251(C_word t0,C_word t1) C_noret;
C_noret_decl(f_28257)
static void f_28257(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_28261)
static void C_ccall f_28261(C_word c,C_word *av) C_noret;
C_noret_decl(f_28297)
static void C_ccall f_28297(C_word c,C_word *av) C_noret;
C_noret_decl(f_28320)
static void C_ccall f_28320(C_word c,C_word *av) C_noret;
C_noret_decl(f_28338)
static void f_28338(C_word t0,C_word t1) C_noret;
C_noret_decl(f_28342)
static void C_ccall f_28342(C_word c,C_word *av) C_noret;
C_noret_decl(f_28349)
static void C_ccall f_28349(C_word c,C_word *av) C_noret;
C_noret_decl(f_28351)
static void f_28351(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_28355)
static void C_ccall f_28355(C_word c,C_word *av) C_noret;
C_noret_decl(f_28366)
static void C_ccall f_28366(C_word c,C_word *av) C_noret;
C_noret_decl(f_28386)
static void C_ccall f_28386(C_word c,C_word *av) C_noret;
C_noret_decl(f_28389)
static void C_ccall f_28389(C_word c,C_word *av) C_noret;
C_noret_decl(f_28392)
static void C_ccall f_28392(C_word c,C_word *av) C_noret;
C_noret_decl(f_28406)
static void C_ccall f_28406(C_word c,C_word *av) C_noret;
C_noret_decl(f_28412)
static void C_ccall f_28412(C_word c,C_word *av) C_noret;
C_noret_decl(f_28434)
static void C_ccall f_28434(C_word c,C_word *av) C_noret;
C_noret_decl(f_28446)
static void C_ccall f_28446(C_word c,C_word *av) C_noret;
C_noret_decl(f_28458)
static void C_ccall f_28458(C_word c,C_word *av) C_noret;
C_noret_decl(f_28467)
static void C_ccall f_28467(C_word c,C_word *av) C_noret;
C_noret_decl(f_28477)
static void C_ccall f_28477(C_word c,C_word *av) C_noret;
C_noret_decl(f_28486)
static void C_ccall f_28486(C_word c,C_word *av) C_noret;
C_noret_decl(f_28489)
static void C_ccall f_28489(C_word c,C_word *av) C_noret;
C_noret_decl(f_28507)
static void C_ccall f_28507(C_word c,C_word *av) C_noret;
C_noret_decl(f_28510)
static void C_ccall f_28510(C_word c,C_word *av) C_noret;
C_noret_decl(f_28531)
static void C_ccall f_28531(C_word c,C_word *av) C_noret;
C_noret_decl(f_28537)
static void C_ccall f_28537(C_word c,C_word *av) C_noret;
C_noret_decl(f_28540)
static void C_ccall f_28540(C_word c,C_word *av) C_noret;
C_noret_decl(f_28550)
static void C_ccall f_28550(C_word c,C_word *av) C_noret;
C_noret_decl(f_28569)
static void f_28569(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_28577)
static void C_ccall f_28577(C_word c,C_word *av) C_noret;
C_noret_decl(f_28579)
static void C_ccall f_28579(C_word c,C_word *av) C_noret;
C_noret_decl(f_28585)
static void C_ccall f_28585(C_word c,C_word *av) C_noret;
C_noret_decl(f_28616)
static void C_ccall f_28616(C_word c,C_word *av) C_noret;
C_noret_decl(f_28639)
static void C_ccall f_28639(C_word c,C_word *av) C_noret;
C_noret_decl(f_28653)
static void C_ccall f_28653(C_word c,C_word *av) C_noret;
C_noret_decl(f_28659)
static void C_ccall f_28659(C_word c,C_word *av) C_noret;
C_noret_decl(f_28684)
static void C_ccall f_28684(C_word c,C_word *av) C_noret;
C_noret_decl(f_28696)
static void C_ccall f_28696(C_word c,C_word *av) C_noret;
C_noret_decl(f_28708)
static void C_ccall f_28708(C_word c,C_word *av) C_noret;
C_noret_decl(f_28720)
static void C_ccall f_28720(C_word c,C_word *av) C_noret;
C_noret_decl(f_28732)
static void C_ccall f_28732(C_word c,C_word *av) C_noret;
C_noret_decl(f_28744)
static void C_ccall f_28744(C_word c,C_word *av) C_noret;
C_noret_decl(f_28765)
static void C_ccall f_28765(C_word c,C_word *av) C_noret;
C_noret_decl(f_28777)
static void C_ccall f_28777(C_word c,C_word *av) C_noret;
C_noret_decl(f_28780)
static void C_ccall f_28780(C_word c,C_word *av) C_noret;
C_noret_decl(f_28792)
static void C_ccall f_28792(C_word c,C_word *av) C_noret;
C_noret_decl(f_28804)
static void C_ccall f_28804(C_word c,C_word *av) C_noret;
C_noret_decl(f_28807)
static void C_ccall f_28807(C_word c,C_word *av) C_noret;
C_noret_decl(f_28819)
static void C_ccall f_28819(C_word c,C_word *av) C_noret;
C_noret_decl(f_28831)
static void C_ccall f_28831(C_word c,C_word *av) C_noret;
C_noret_decl(f_28843)
static void C_ccall f_28843(C_word c,C_word *av) C_noret;
C_noret_decl(f_28846)
static void C_ccall f_28846(C_word c,C_word *av) C_noret;
C_noret_decl(f_28851)
static void C_ccall f_28851(C_word c,C_word *av) C_noret;
C_noret_decl(f_28856)
static void C_ccall f_28856(C_word c,C_word *av) C_noret;
C_noret_decl(f_28862)
static void C_ccall f_28862(C_word c,C_word *av) C_noret;
C_noret_decl(f_28891)
static void C_ccall f_28891(C_word c,C_word *av) C_noret;
C_noret_decl(f_28903)
static void C_ccall f_28903(C_word c,C_word *av) C_noret;
C_noret_decl(f_28906)
static void C_ccall f_28906(C_word c,C_word *av) C_noret;
C_noret_decl(f_28909)
static void C_ccall f_28909(C_word c,C_word *av) C_noret;
C_noret_decl(f_28924)
static void C_ccall f_28924(C_word c,C_word *av) C_noret;
C_noret_decl(f_28933)
static void C_ccall f_28933(C_word c,C_word *av) C_noret;
C_noret_decl(f_28936)
static void C_ccall f_28936(C_word c,C_word *av) C_noret;
C_noret_decl(f_28942)
static void f_28942(C_word t0,C_word t1) C_noret;
C_noret_decl(f_28945)
static void C_ccall f_28945(C_word c,C_word *av) C_noret;
C_noret_decl(f_28951)
static void C_ccall f_28951(C_word c,C_word *av) C_noret;
C_noret_decl(f_28998)
static void C_ccall f_28998(C_word c,C_word *av) C_noret;
C_noret_decl(f_29017)
static void C_ccall f_29017(C_word c,C_word *av) C_noret;
C_noret_decl(f_29033)
static void C_ccall f_29033(C_word c,C_word *av) C_noret;
C_noret_decl(f_29039)
static void C_ccall f_29039(C_word c,C_word *av) C_noret;
C_noret_decl(f_29109)
static void C_ccall f_29109(C_word c,C_word *av) C_noret;
C_noret_decl(f_29121)
static void C_ccall f_29121(C_word c,C_word *av) C_noret;
C_noret_decl(f_29199)
static void C_ccall f_29199(C_word c,C_word *av) C_noret;
C_noret_decl(f_29273)
static void C_ccall f_29273(C_word c,C_word *av) C_noret;
C_noret_decl(f_29276)
static void C_ccall f_29276(C_word c,C_word *av) C_noret;
C_noret_decl(f_29279)
static void C_ccall f_29279(C_word c,C_word *av) C_noret;
C_noret_decl(f_29287)
static void C_ccall f_29287(C_word c,C_word *av) C_noret;
C_noret_decl(f_29297)
static void C_ccall f_29297(C_word c,C_word *av) C_noret;
C_noret_decl(f_29302)
static void C_ccall f_29302(C_word c,C_word *av) C_noret;
C_noret_decl(f_29305)
static void f_29305(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_29318)
static void f_29318(C_word t0,C_word t1) C_noret;
C_noret_decl(f_29321)
static void C_ccall f_29321(C_word c,C_word *av) C_noret;
C_noret_decl(f_29357)
static void C_ccall f_29357(C_word c,C_word *av) C_noret;
C_noret_decl(f_29373)
static void C_ccall f_29373(C_word c,C_word *av) C_noret;
C_noret_decl(f_29423)
static void C_ccall f_29423(C_word c,C_word *av) C_noret;
C_noret_decl(f_29427)
static void C_ccall f_29427(C_word c,C_word *av) C_noret;
C_noret_decl(f_29454)
static void C_ccall f_29454(C_word c,C_word *av) C_noret;
C_noret_decl(f_29460)
static void f_29460(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_29476)
static void f_29476(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_29516)
static void C_ccall f_29516(C_word c,C_word *av) C_noret;
C_noret_decl(f_29518)
static void f_29518(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_29525)
static void f_29525(C_word t0,C_word t1) C_noret;
C_noret_decl(f_29582)
static void C_ccall f_29582(C_word c,C_word *av) C_noret;
C_noret_decl(f_29589)
static void C_ccall f_29589(C_word c,C_word *av) C_noret;
C_noret_decl(f_29598)
static void C_ccall f_29598(C_word c,C_word *av) C_noret;
C_noret_decl(f_29610)
static void C_ccall f_29610(C_word c,C_word *av) C_noret;
C_noret_decl(f_29631)
static void C_ccall f_29631(C_word c,C_word *av) C_noret;
C_noret_decl(f_29646)
static void C_ccall f_29646(C_word c,C_word *av) C_noret;
C_noret_decl(f_29664)
static void C_ccall f_29664(C_word c,C_word *av) C_noret;
C_noret_decl(f_29682)
static void C_ccall f_29682(C_word c,C_word *av) C_noret;
C_noret_decl(f_29701)
static void f_29701(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_29711)
static void C_ccall f_29711(C_word c,C_word *av) C_noret;
C_noret_decl(f_29725)
static void C_ccall f_29725(C_word c,C_word *av) C_noret;
C_noret_decl(f_29728)
static void C_ccall f_29728(C_word c,C_word *av) C_noret;
C_noret_decl(f_29733)
static void C_ccall f_29733(C_word c,C_word *av) C_noret;
C_noret_decl(f_29752)
static void f_29752(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_29762)
static void C_ccall f_29762(C_word c,C_word *av) C_noret;
C_noret_decl(f_29776)
static void C_ccall f_29776(C_word c,C_word *av) C_noret;
C_noret_decl(f_29779)
static void C_ccall f_29779(C_word c,C_word *av) C_noret;
C_noret_decl(f_29786)
static void C_ccall f_29786(C_word c,C_word *av) C_noret;
C_noret_decl(f_29790)
static void C_ccall f_29790(C_word c,C_word *av) C_noret;
C_noret_decl(f_29794)
static void C_ccall f_29794(C_word c,C_word *av) C_noret;
C_noret_decl(f_29796)
static void C_ccall f_29796(C_word c,C_word *av) C_noret;
C_noret_decl(f_29803)
static void C_ccall f_29803(C_word c,C_word *av) C_noret;
C_noret_decl(f_29806)
static void C_ccall f_29806(C_word c,C_word *av) C_noret;
C_noret_decl(f_29809)
static void C_ccall f_29809(C_word c,C_word *av) C_noret;
C_noret_decl(f_29812)
static void C_ccall f_29812(C_word c,C_word *av) C_noret;
C_noret_decl(f_29814)
static void f_29814(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_29824)
static void C_ccall f_29824(C_word c,C_word *av) C_noret;
C_noret_decl(f_29830)
static void C_ccall f_29830(C_word c,C_word *av) C_noret;
C_noret_decl(f_29842)
static void C_ccall f_29842(C_word c,C_word *av) C_noret;
C_noret_decl(f_29845)
static void C_ccall f_29845(C_word c,C_word *av) C_noret;
C_noret_decl(f_29848)
static void C_ccall f_29848(C_word c,C_word *av) C_noret;
C_noret_decl(f_29865)
static void C_ccall f_29865(C_word c,C_word *av) C_noret;
C_noret_decl(f_29873)
static void f_29873(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_29897)
static void f_29897(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_29901)
static void C_ccall f_29901(C_word c,C_word *av) C_noret;
C_noret_decl(f_29914)
static void C_ccall f_29914(C_word c,C_word *av) C_noret;
C_noret_decl(f_29917)
static void C_ccall f_29917(C_word c,C_word *av) C_noret;
C_noret_decl(f_29926)
static void C_ccall f_29926(C_word c,C_word *av) C_noret;
C_noret_decl(f_29929)
static void C_ccall f_29929(C_word c,C_word *av) C_noret;
C_noret_decl(f_29957)
static void f_29957(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_29961)
static void C_ccall f_29961(C_word c,C_word *av) C_noret;
C_noret_decl(f_29970)
static void C_ccall f_29970(C_word c,C_word *av) C_noret;
C_noret_decl(f_29987)
static void f_29987(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_29994)
static void C_ccall f_29994(C_word c,C_word *av) C_noret;
C_noret_decl(f_29999)
static void f_29999(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30023)
static void C_ccall f_30023(C_word c,C_word *av) C_noret;
C_noret_decl(f_30029)
static void C_ccall f_30029(C_word c,C_word *av) C_noret;
C_noret_decl(f_30032)
static void C_ccall f_30032(C_word c,C_word *av) C_noret;
C_noret_decl(f_30043)
static void C_ccall f_30043(C_word c,C_word *av) C_noret;
C_noret_decl(f_30046)
static void C_ccall f_30046(C_word c,C_word *av) C_noret;
C_noret_decl(f_30049)
static void C_ccall f_30049(C_word c,C_word *av) C_noret;
C_noret_decl(f_30072)
static void f_30072(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30123)
static void f_30123(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30198)
static void f_30198(C_word t0,C_word t1) C_noret;
C_noret_decl(f_30298)
static void C_ccall f_30298(C_word c,C_word *av) C_noret;
C_noret_decl(f_30303)
static void f_30303(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30358)
static void C_ccall f_30358(C_word c,C_word *av) C_noret;
C_noret_decl(f_30364)
static void C_ccall f_30364(C_word c,C_word *av) C_noret;
C_noret_decl(f_30368)
static void f_30368(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30376)
static void C_ccall f_30376(C_word c,C_word *av) C_noret;
C_noret_decl(f_30391)
static void C_ccall f_30391(C_word c,C_word *av) C_noret;
C_noret_decl(f_30398)
static void C_ccall f_30398(C_word c,C_word *av) C_noret;
C_noret_decl(f_30417)
static void C_ccall f_30417(C_word c,C_word *av) C_noret;
C_noret_decl(f_30453)
static void C_ccall f_30453(C_word c,C_word *av) C_noret;
C_noret_decl(f_30465)
static void C_ccall f_30465(C_word c,C_word *av) C_noret;
C_noret_decl(f_30471)
static void C_ccall f_30471(C_word c,C_word *av) C_noret;
C_noret_decl(f_30500)
static void C_ccall f_30500(C_word c,C_word *av) C_noret;
C_noret_decl(f_30510)
static void C_ccall f_30510(C_word c,C_word *av) C_noret;
C_noret_decl(f_30519)
static void C_ccall f_30519(C_word c,C_word *av) C_noret;
C_noret_decl(f_30528)
static void f_30528(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_30544)
static void C_ccall f_30544(C_word c,C_word *av) C_noret;
C_noret_decl(f_30582)
static void C_ccall f_30582(C_word c,C_word *av) C_noret;
C_noret_decl(f_30648)
static void C_ccall f_30648(C_word c,C_word *av) C_noret;
C_noret_decl(f_30651)
static void C_ccall f_30651(C_word c,C_word *av) C_noret;
C_noret_decl(f_30654)
static void C_ccall f_30654(C_word c,C_word *av) C_noret;
C_noret_decl(f_30661)
static void C_ccall f_30661(C_word c,C_word *av) C_noret;
C_noret_decl(f_30705)
static void C_ccall f_30705(C_word c,C_word *av) C_noret;
C_noret_decl(f_30708)
static void C_ccall f_30708(C_word c,C_word *av) C_noret;
C_noret_decl(f_30717)
static void f_30717(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_30730)
static void C_ccall f_30730(C_word c,C_word *av) C_noret;
C_noret_decl(f_30739)
static void C_ccall f_30739(C_word c,C_word *av) C_noret;
C_noret_decl(f_30749)
static void C_ccall f_30749(C_word c,C_word *av) C_noret;
C_noret_decl(f_30752)
static void C_ccall f_30752(C_word c,C_word *av) C_noret;
C_noret_decl(f_30778)
static void C_ccall f_30778(C_word c,C_word *av) C_noret;
C_noret_decl(f_30785)
static void C_ccall f_30785(C_word c,C_word *av) C_noret;
C_noret_decl(f_30801)
static void C_ccall f_30801(C_word c,C_word *av) C_noret;
C_noret_decl(f_30813)
static void C_ccall f_30813(C_word c,C_word *av) C_noret;
C_noret_decl(f_30816)
static void C_ccall f_30816(C_word c,C_word *av) C_noret;
C_noret_decl(f_30823)
static void C_ccall f_30823(C_word c,C_word *av) C_noret;
C_noret_decl(f_30832)
static void C_ccall f_30832(C_word c,C_word *av) C_noret;
C_noret_decl(f_30835)
static void C_ccall f_30835(C_word c,C_word *av) C_noret;
C_noret_decl(f_30882)
static void C_ccall f_30882(C_word c,C_word *av) C_noret;
C_noret_decl(f_30885)
static void C_ccall f_30885(C_word c,C_word *av) C_noret;
C_noret_decl(f_30894)
static void f_30894(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_30907)
static void C_ccall f_30907(C_word c,C_word *av) C_noret;
C_noret_decl(f_30910)
static void C_ccall f_30910(C_word c,C_word *av) C_noret;
C_noret_decl(f_30935)
static void C_ccall f_30935(C_word c,C_word *av) C_noret;
C_noret_decl(f_30939)
static void C_ccall f_30939(C_word c,C_word *av) C_noret;
C_noret_decl(f_30949)
static void C_ccall f_30949(C_word c,C_word *av) C_noret;
C_noret_decl(f_30952)
static void C_ccall f_30952(C_word c,C_word *av) C_noret;
C_noret_decl(f_30964)
static void C_ccall f_30964(C_word c,C_word *av) C_noret;
C_noret_decl(f_30968)
static void C_ccall f_30968(C_word c,C_word *av) C_noret;
C_noret_decl(f_30990)
static void C_ccall f_30990(C_word c,C_word *av) C_noret;
C_noret_decl(f_30992)
static void C_ccall f_30992(C_word c,C_word *av) C_noret;
C_noret_decl(f_31008)
static void C_ccall f_31008(C_word c,C_word *av) C_noret;
C_noret_decl(f_31013)
static void C_ccall f_31013(C_word c,C_word *av) C_noret;
C_noret_decl(f_31019)
static void C_ccall f_31019(C_word c,C_word *av) C_noret;
C_noret_decl(f_31025)
static void C_ccall f_31025(C_word c,C_word *av) C_noret;
C_noret_decl(f_31029)
static void C_ccall f_31029(C_word c,C_word *av) C_noret;
C_noret_decl(f_31032)
static void C_ccall f_31032(C_word c,C_word *av) C_noret;
C_noret_decl(f_31047)
static void C_ccall f_31047(C_word c,C_word *av) C_noret;
C_noret_decl(f_31050)
static void C_ccall f_31050(C_word c,C_word *av) C_noret;
C_noret_decl(f_31066)
static void C_ccall f_31066(C_word c,C_word *av) C_noret;
C_noret_decl(f_31072)
static void C_ccall f_31072(C_word c,C_word *av) C_noret;
C_noret_decl(f_31081)
static void C_ccall f_31081(C_word c,C_word *av) C_noret;
C_noret_decl(f_31087)
static void C_ccall f_31087(C_word c,C_word *av) C_noret;
C_noret_decl(f_31094)
static void C_ccall f_31094(C_word c,C_word *av) C_noret;
C_noret_decl(f_31097)
static void C_ccall f_31097(C_word c,C_word *av) C_noret;
C_noret_decl(f_31100)
static void C_ccall f_31100(C_word c,C_word *av) C_noret;
C_noret_decl(f_31109)
static void C_ccall f_31109(C_word c,C_word *av) C_noret;
C_noret_decl(f_31125)
static void C_ccall f_31125(C_word c,C_word *av) C_noret;
C_noret_decl(f_31144)
static void C_ccall f_31144(C_word c,C_word *av) C_noret;
C_noret_decl(f_31150)
static void C_ccall f_31150(C_word c,C_word *av) C_noret;
C_noret_decl(f_31156)
static void C_ccall f_31156(C_word c,C_word *av) C_noret;
C_noret_decl(f_31160)
static void C_ccall f_31160(C_word c,C_word *av) C_noret;
C_noret_decl(f_31163)
static void C_ccall f_31163(C_word c,C_word *av) C_noret;
C_noret_decl(f_31166)
static void C_ccall f_31166(C_word c,C_word *av) C_noret;
C_noret_decl(f_31170)
static void C_ccall f_31170(C_word c,C_word *av) C_noret;
C_noret_decl(f_31174)
static void C_ccall f_31174(C_word c,C_word *av) C_noret;
C_noret_decl(f_31178)
static void C_ccall f_31178(C_word c,C_word *av) C_noret;
C_noret_decl(f_31181)
static void C_ccall f_31181(C_word c,C_word *av) C_noret;
C_noret_decl(f_31184)
static void C_ccall f_31184(C_word c,C_word *av) C_noret;
C_noret_decl(f_31187)
static void C_ccall f_31187(C_word c,C_word *av) C_noret;
C_noret_decl(f_31199)
static void C_ccall f_31199(C_word c,C_word *av) C_noret;
C_noret_decl(f_31205)
static void C_ccall f_31205(C_word c,C_word *av) C_noret;
C_noret_decl(f_31209)
static void C_ccall f_31209(C_word c,C_word *av) C_noret;
C_noret_decl(f_31212)
static void C_ccall f_31212(C_word c,C_word *av) C_noret;
C_noret_decl(f_31215)
static void C_ccall f_31215(C_word c,C_word *av) C_noret;
C_noret_decl(f_31218)
static void C_ccall f_31218(C_word c,C_word *av) C_noret;
C_noret_decl(f_31221)
static void C_ccall f_31221(C_word c,C_word *av) C_noret;
C_noret_decl(f_31224)
static void C_ccall f_31224(C_word c,C_word *av) C_noret;
C_noret_decl(f_31229)
static void C_ccall f_31229(C_word c,C_word *av) C_noret;
C_noret_decl(f_31251)
static void C_ccall f_31251(C_word c,C_word *av) C_noret;
C_noret_decl(f_31257)
static void C_ccall f_31257(C_word c,C_word *av) C_noret;
C_noret_decl(f_31282)
static void C_ccall f_31282(C_word c,C_word *av) C_noret;
C_noret_decl(f_31289)
static void C_ccall f_31289(C_word c,C_word *av) C_noret;
C_noret_decl(f_31291)
static void f_31291(C_word t0,C_word t1) C_noret;
C_noret_decl(f_31298)
static void C_ccall f_31298(C_word c,C_word *av) C_noret;
C_noret_decl(f_31302)
static void f_31302(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_31309)
static void C_ccall f_31309(C_word c,C_word *av) C_noret;
C_noret_decl(f_31325)
static void f_31325(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_31329)
static void C_ccall f_31329(C_word c,C_word *av) C_noret;
C_noret_decl(f_31345)
static void f_31345(C_word t0,C_word t1) C_noret;
C_noret_decl(f_31360)
static void f_31360(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_31370)
static void C_ccall f_31370(C_word c,C_word *av) C_noret;
C_noret_decl(f_31375)
static void C_ccall f_31375(C_word c,C_word *av) C_noret;
C_noret_decl(f_31381)
static void C_ccall f_31381(C_word c,C_word *av) C_noret;
C_noret_decl(f_31395)
static void C_ccall f_31395(C_word c,C_word *av) C_noret;
C_noret_decl(f_31404)
static void C_ccall f_31404(C_word c,C_word *av) C_noret;
C_noret_decl(f_31415)
static void C_ccall f_31415(C_word c,C_word *av) C_noret;
C_noret_decl(f_31421)
static void f_31421(C_word t0,C_word t1) C_noret;
C_noret_decl(f_31424)
static void C_ccall f_31424(C_word c,C_word *av) C_noret;
C_noret_decl(f_31435)
static void C_ccall f_31435(C_word c,C_word *av) C_noret;
C_noret_decl(f_31444)
static void C_ccall f_31444(C_word c,C_word *av) C_noret;
C_noret_decl(f_31449)
static void C_ccall f_31449(C_word c,C_word *av) C_noret;
C_noret_decl(f_31455)
static void C_ccall f_31455(C_word c,C_word *av) C_noret;
C_noret_decl(f_31476)
static void C_ccall f_31476(C_word c,C_word *av) C_noret;
C_noret_decl(f_31479)
static void C_ccall f_31479(C_word c,C_word *av) C_noret;
C_noret_decl(f_31486)
static void C_ccall f_31486(C_word c,C_word *av) C_noret;
C_noret_decl(f_31493)
static void C_ccall f_31493(C_word c,C_word *av) C_noret;
C_noret_decl(f_31502)
static void C_ccall f_31502(C_word c,C_word *av) C_noret;
C_noret_decl(f_31513)
static void C_ccall f_31513(C_word c,C_word *av) C_noret;
C_noret_decl(f_31559)
static void C_ccall f_31559(C_word c,C_word *av) C_noret;
C_noret_decl(f_31563)
static void C_ccall f_31563(C_word c,C_word *av) C_noret;
C_noret_decl(f_31564)
static void f_31564(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_31574)
static void C_ccall f_31574(C_word c,C_word *av) C_noret;
C_noret_decl(f_31579)
static void f_31579(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_31589)
static void C_ccall f_31589(C_word c,C_word *av) C_noret;
C_noret_decl(f_31602)
static void C_ccall f_31602(C_word c,C_word *av) C_noret;
C_noret_decl(f_31613)
static void C_ccall f_31613(C_word c,C_word *av) C_noret;
C_noret_decl(f_31617)
static void C_ccall f_31617(C_word c,C_word *av) C_noret;
C_noret_decl(f_31621)
static void C_ccall f_31621(C_word c,C_word *av) C_noret;
C_noret_decl(f_31643)
static void C_ccall f_31643(C_word c,C_word *av) C_noret;
C_noret_decl(f_31647)
static void C_ccall f_31647(C_word c,C_word *av) C_noret;
C_noret_decl(f_31655)
static void C_ccall f_31655(C_word c,C_word *av) C_noret;
C_noret_decl(f_31671)
static void C_ccall f_31671(C_word c,C_word *av) C_noret;
C_noret_decl(f_31682)
static void f_31682(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_31701)
static void f_31701(C_word t0,C_word t1) C_noret;
C_noret_decl(f_31712)
static void C_ccall f_31712(C_word c,C_word *av) C_noret;
C_noret_decl(f_31723)
static void C_ccall f_31723(C_word c,C_word *av) C_noret;
C_noret_decl(f_31809)
static void C_ccall f_31809(C_word c,C_word *av) C_noret;
C_noret_decl(f_31819)
static void C_ccall f_31819(C_word c,C_word *av) C_noret;
C_noret_decl(f_31820)
static void f_31820(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_31833)
static void C_ccall f_31833(C_word c,C_word *av) C_noret;
C_noret_decl(f_31836)
static void C_ccall f_31836(C_word c,C_word *av) C_noret;
C_noret_decl(f_31839)
static void C_ccall f_31839(C_word c,C_word *av) C_noret;
C_noret_decl(f_31842)
static void C_ccall f_31842(C_word c,C_word *av) C_noret;
C_noret_decl(f_31850)
static void C_ccall f_31850(C_word c,C_word *av) C_noret;
C_noret_decl(f_31857)
static void f_31857(C_word t0,C_word t1) C_noret;
C_noret_decl(f_31860)
static void C_ccall f_31860(C_word c,C_word *av) C_noret;
C_noret_decl(f_31863)
static void C_ccall f_31863(C_word c,C_word *av) C_noret;
C_noret_decl(f_31886)
static void C_ccall f_31886(C_word c,C_word *av) C_noret;
C_noret_decl(f_31891)
static void f_31891(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_31901)
static void C_ccall f_31901(C_word c,C_word *av) C_noret;
C_noret_decl(f_31914)
static void C_ccall f_31914(C_word c,C_word *av) C_noret;
C_noret_decl(f_31955)
static void C_ccall f_31955(C_word c,C_word *av) C_noret;
C_noret_decl(f_32005)
static void C_ccall f_32005(C_word c,C_word *av) C_noret;
C_noret_decl(f_32008)
static void C_ccall f_32008(C_word c,C_word *av) C_noret;
C_noret_decl(f_32027)
static void f_32027(C_word t0) C_noret;
C_noret_decl(f_32032)
static void C_ccall f_32032(C_word c,C_word *av) C_noret;
C_noret_decl(f_32038)
static void C_ccall f_32038(C_word c,C_word *av) C_noret;
C_noret_decl(f_32041)
static void C_ccall f_32041(C_word c,C_word *av) C_noret;
C_noret_decl(f_32050)
static void C_ccall f_32050(C_word c,C_word *av) C_noret;
C_noret_decl(f_32056)
static void C_ccall f_32056(C_word c,C_word *av) C_noret;
C_noret_decl(f_32075)
static void f_32075(C_word t0,C_word t1) C_noret;
C_noret_decl(f_32094)
static void C_ccall f_32094(C_word c,C_word *av) C_noret;
C_noret_decl(f_32099)
static void f_32099(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_32109)
static void C_ccall f_32109(C_word c,C_word *av) C_noret;
C_noret_decl(f_32123)
static void C_ccall f_32123(C_word c,C_word *av) C_noret;
C_noret_decl(f_32130)
static void C_ccall f_32130(C_word c,C_word *av) C_noret;
C_noret_decl(f_32134)
static void C_ccall f_32134(C_word c,C_word *av) C_noret;
C_noret_decl(f_32138)
static void C_ccall f_32138(C_word c,C_word *av) C_noret;
C_noret_decl(f_32140)
static void C_ccall f_32140(C_word c,C_word *av) C_noret;
C_noret_decl(f_32143)
static void C_ccall f_32143(C_word c,C_word *av) C_noret;
C_noret_decl(f_32169)
static void C_ccall f_32169(C_word c,C_word *av) C_noret;
C_noret_decl(f_32172)
static void C_ccall f_32172(C_word c,C_word *av) C_noret;
C_noret_decl(f_32175)
static void C_ccall f_32175(C_word c,C_word *av) C_noret;
C_noret_decl(f_32182)
static void C_ccall f_32182(C_word c,C_word *av) C_noret;
C_noret_decl(f_32186)
static void C_ccall f_32186(C_word c,C_word *av) C_noret;
C_noret_decl(f_32192)
static void C_ccall f_32192(C_word c,C_word *av) C_noret;
C_noret_decl(f_32197)
static void f_32197(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_32207)
static void C_ccall f_32207(C_word c,C_word *av) C_noret;
C_noret_decl(f_32245)
static void f_32245(C_word t0,C_word t1) C_noret;
C_noret_decl(f_32248)
static void f_32248(C_word t0,C_word t1) C_noret;
C_noret_decl(f_32268)
static void f_32268(C_word t0,C_word t1) C_noret;
C_noret_decl(f_32286)
static void C_ccall f_32286(C_word c,C_word *av) C_noret;
C_noret_decl(f_32420)
static void C_ccall f_32420(C_word c,C_word *av) C_noret;
C_noret_decl(f_32437)
static void C_ccall f_32437(C_word c,C_word *av) C_noret;
C_noret_decl(f_32452)
static void C_ccall f_32452(C_word c,C_word *av) C_noret;
C_noret_decl(f_32456)
static void C_ccall f_32456(C_word c,C_word *av) C_noret;
C_noret_decl(f_32469)
static void C_ccall f_32469(C_word c,C_word *av) C_noret;
C_noret_decl(f_32477)
static void C_ccall f_32477(C_word c,C_word *av) C_noret;
C_noret_decl(f_32480)
static void C_ccall f_32480(C_word c,C_word *av) C_noret;
C_noret_decl(f_32484)
static void C_ccall f_32484(C_word c,C_word *av) C_noret;
C_noret_decl(f_32523)
static void C_ccall f_32523(C_word c,C_word *av) C_noret;
C_noret_decl(f_32526)
static void C_ccall f_32526(C_word c,C_word *av) C_noret;
C_noret_decl(f_32533)
static void C_ccall f_32533(C_word c,C_word *av) C_noret;
C_noret_decl(f_32537)
static void C_ccall f_32537(C_word c,C_word *av) C_noret;
C_noret_decl(f_32563)
static void C_ccall f_32563(C_word c,C_word *av) C_noret;
C_noret_decl(f_32594)
static void C_ccall f_32594(C_word c,C_word *av) C_noret;
C_noret_decl(f_32597)
static void C_ccall f_32597(C_word c,C_word *av) C_noret;
C_noret_decl(f_32609)
static void C_ccall f_32609(C_word c,C_word *av) C_noret;
C_noret_decl(f_32612)
static void C_ccall f_32612(C_word c,C_word *av) C_noret;
C_noret_decl(f_32615)
static void C_ccall f_32615(C_word c,C_word *av) C_noret;
C_noret_decl(f_32640)
static void C_ccall f_32640(C_word c,C_word *av) C_noret;
C_noret_decl(f_32646)
static void C_ccall f_32646(C_word c,C_word *av) C_noret;
C_noret_decl(f_32650)
static void C_ccall f_32650(C_word c,C_word *av) C_noret;
C_noret_decl(f_32654)
static void C_ccall f_32654(C_word c,C_word *av) C_noret;
C_noret_decl(f_32667)
static void C_ccall f_32667(C_word c,C_word *av) C_noret;
C_noret_decl(f_32669)
static C_word f_32669(C_word t0,C_word t1);
C_noret_decl(f_32675)
static C_word f_32675(C_word t0);
C_noret_decl(f_32680)
static C_word f_32680(C_word t0);
C_noret_decl(f_32715)
static void f_32715(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_32721)
static void f_32721(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_32737)
static void f_32737(C_word t0,C_word t1) C_noret;
C_noret_decl(f_32759)
static void C_ccall f_32759(C_word c,C_word *av) C_noret;
C_noret_decl(f_32783)
static void C_ccall f_32783(C_word c,C_word *av) C_noret;
C_noret_decl(f_32795)
static void C_ccall f_32795(C_word c,C_word *av) C_noret;
C_noret_decl(f_32797)
static void C_ccall f_32797(C_word c,C_word *av) C_noret;
C_noret_decl(f_32816)
static void C_ccall f_32816(C_word c,C_word *av) C_noret;
C_noret_decl(f_32820)
static void C_ccall f_32820(C_word c,C_word *av) C_noret;
C_noret_decl(f_32832)
static void C_ccall f_32832(C_word c,C_word *av) C_noret;
C_noret_decl(f_32834)
static void f_32834(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_32878)
static void C_ccall f_32878(C_word c,C_word *av) C_noret;
C_noret_decl(f_32880)
static void f_32880(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_32914)
static C_word f_32914(C_word t0);
C_noret_decl(f_32937)
static void C_ccall f_32937(C_word c,C_word *av) C_noret;
C_noret_decl(f_32944)
static void C_ccall f_32944(C_word c,C_word *av) C_noret;
C_noret_decl(f_32954)
static void C_ccall f_32954(C_word c,C_word *av) C_noret;
C_noret_decl(f_32956)
static void f_32956(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_33006)
static void C_ccall f_33006(C_word c,C_word *av) C_noret;
C_noret_decl(f_33008)
static void f_33008(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_33033)
static void C_ccall f_33033(C_word c,C_word *av) C_noret;
C_noret_decl(f_33042)
static void C_ccall f_33042(C_word c,C_word *av) C_noret;
C_noret_decl(f_33048)
static void C_ccall f_33048(C_word c,C_word *av) C_noret;
C_noret_decl(f_33052)
static void C_ccall f_33052(C_word c,C_word *av) C_noret;
C_noret_decl(f_33056)
static void f_33056(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_33064)
static void C_ccall f_33064(C_word c,C_word *av) C_noret;
C_noret_decl(f_33070)
static void f_33070(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_33101)
static void C_ccall f_33101(C_word c,C_word *av) C_noret;
C_noret_decl(f_33126)
static void f_33126(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_33151)
static void C_ccall f_33151(C_word c,C_word *av) C_noret;
C_noret_decl(f_33161)
static void C_ccall f_33161(C_word c,C_word *av) C_noret;
C_noret_decl(f_33166)
static void C_ccall f_33166(C_word c,C_word *av) C_noret;
C_noret_decl(f_33168)
static void C_ccall f_33168(C_word c,C_word *av) C_noret;
C_noret_decl(f_33175)
static void C_ccall f_33175(C_word c,C_word *av) C_noret;
C_noret_decl(f_33187)
static void C_ccall f_33187(C_word c,C_word *av) C_noret;
C_noret_decl(f_33195)
static void C_ccall f_33195(C_word c,C_word *av) C_noret;
C_noret_decl(f_33233)
static void C_ccall f_33233(C_word c,C_word *av) C_noret;
C_noret_decl(f_33237)
static void C_ccall f_33237(C_word c,C_word *av) C_noret;
C_noret_decl(f_33244)
static void C_ccall f_33244(C_word c,C_word *av) C_noret;
C_noret_decl(f_33247)
static void C_ccall f_33247(C_word c,C_word *av) C_noret;
C_noret_decl(f_33250)
static void C_ccall f_33250(C_word c,C_word *av) C_noret;
C_noret_decl(f_33251)
static void f_33251(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_33253)
static void f_33253(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_33257)
static void C_ccall f_33257(C_word c,C_word *av) C_noret;
C_noret_decl(f_33262)
static void C_ccall f_33262(C_word c,C_word *av) C_noret;
C_noret_decl(f_33274)
static void f_33274(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_33284)
static void C_ccall f_33284(C_word c,C_word *av) C_noret;
C_noret_decl(f_33296)
static void C_ccall f_33296(C_word c,C_word *av) C_noret;
C_noret_decl(f_33298)
static void f_33298(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_33305)
static void C_ccall f_33305(C_word c,C_word *av) C_noret;
C_noret_decl(f_33308)
static void C_ccall f_33308(C_word c,C_word *av) C_noret;
C_noret_decl(f_33317)
static void C_ccall f_33317(C_word c,C_word *av) C_noret;
C_noret_decl(f_33320)
static void C_ccall f_33320(C_word c,C_word *av) C_noret;
C_noret_decl(f_33323)
static void C_ccall f_33323(C_word c,C_word *av) C_noret;
C_noret_decl(f_33338)
static void C_ccall f_33338(C_word c,C_word *av) C_noret;
C_noret_decl(f_33344)
static void C_ccall f_33344(C_word c,C_word *av) C_noret;
C_noret_decl(f_33352)
static void f_33352(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_33356)
static void C_ccall f_33356(C_word c,C_word *av) C_noret;
C_noret_decl(f_33359)
static void C_ccall f_33359(C_word c,C_word *av) C_noret;
C_noret_decl(f_33362)
static void C_ccall f_33362(C_word c,C_word *av) C_noret;
C_noret_decl(f_33375)
static void C_ccall f_33375(C_word c,C_word *av) C_noret;
C_noret_decl(f_33379)
static void C_ccall f_33379(C_word c,C_word *av) C_noret;
C_noret_decl(f_33400)
static void C_ccall f_33400(C_word c,C_word *av) C_noret;
C_noret_decl(f_33416)
static void C_ccall f_33416(C_word c,C_word *av) C_noret;
C_noret_decl(f_33419)
static void C_ccall f_33419(C_word c,C_word *av) C_noret;
C_noret_decl(f_33425)
static void C_ccall f_33425(C_word c,C_word *av) C_noret;
C_noret_decl(f_33447)
static void f_33447(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_33452)
static void f_33452(C_word t0,C_word t1) C_noret;
C_noret_decl(f_33487)
static void C_ccall f_33487(C_word c,C_word *av) C_noret;
C_noret_decl(f_33497)
static void C_ccall f_33497(C_word c,C_word *av) C_noret;
C_noret_decl(f_33500)
static void C_ccall f_33500(C_word c,C_word *av) C_noret;
C_noret_decl(f_33503)
static void C_ccall f_33503(C_word c,C_word *av) C_noret;
C_noret_decl(f_33506)
static void C_ccall f_33506(C_word c,C_word *av) C_noret;
C_noret_decl(f_33509)
static void C_ccall f_33509(C_word c,C_word *av) C_noret;
C_noret_decl(f_33512)
static void C_ccall f_33512(C_word c,C_word *av) C_noret;
C_noret_decl(f_33519)
static void C_ccall f_33519(C_word c,C_word *av) C_noret;
C_noret_decl(f_33522)
static void C_ccall f_33522(C_word c,C_word *av) C_noret;
C_noret_decl(f_33525)
static void C_ccall f_33525(C_word c,C_word *av) C_noret;
C_noret_decl(f_33536)
static void C_ccall f_33536(C_word c,C_word *av) C_noret;
C_noret_decl(f_33559)
static void C_ccall f_33559(C_word c,C_word *av) C_noret;
C_noret_decl(f_33570)
static void C_ccall f_33570(C_word c,C_word *av) C_noret;
C_noret_decl(f_33574)
static void C_ccall f_33574(C_word c,C_word *av) C_noret;
C_noret_decl(f_33596)
static void C_ccall f_33596(C_word c,C_word *av) C_noret;
C_noret_decl(f_33607)
static void C_ccall f_33607(C_word c,C_word *av) C_noret;
C_noret_decl(f_33611)
static void C_ccall f_33611(C_word c,C_word *av) C_noret;
C_noret_decl(f_34110)
static void C_ccall f_34110(C_word c,C_word *av) C_noret;
C_noret_decl(f_34121)
static void C_ccall f_34121(C_word c,C_word *av) C_noret;
C_noret_decl(f_34125)
static void C_ccall f_34125(C_word c,C_word *av) C_noret;
C_noret_decl(f_34266)
static void C_ccall f_34266(C_word c,C_word *av) C_noret;
C_noret_decl(f_34268)
static void C_ccall f_34268(C_word c,C_word *av) C_noret;
C_noret_decl(f_34274)
static void C_ccall f_34274(C_word c,C_word *av) C_noret;
C_noret_decl(f_34278)
static void C_ccall f_34278(C_word c,C_word *av) C_noret;
C_noret_decl(f_34281)
static void C_ccall f_34281(C_word c,C_word *av) C_noret;
C_noret_decl(f_34290)
static void C_ccall f_34290(C_word c,C_word *av) C_noret;
C_noret_decl(f_34304)
static void C_ccall f_34304(C_word c,C_word *av) C_noret;
C_noret_decl(f_34312)
static void C_ccall f_34312(C_word c,C_word *av) C_noret;
C_noret_decl(f_34314)
static void C_ccall f_34314(C_word c,C_word *av) C_noret;
C_noret_decl(f_34318)
static void C_ccall f_34318(C_word c,C_word *av) C_noret;
C_noret_decl(f_34326)
static void C_ccall f_34326(C_word c,C_word *av) C_noret;
C_noret_decl(f_34334)
static void C_ccall f_34334(C_word c,C_word *av) C_noret;
C_noret_decl(f_34336)
static void C_ccall f_34336(C_word c,C_word *av) C_noret;
C_noret_decl(f_34346)
static void C_ccall f_34346(C_word c,C_word *av) C_noret;
C_noret_decl(f_34353)
static void C_ccall f_34353(C_word c,C_word *av) C_noret;
C_noret_decl(f_34363)
static void C_ccall f_34363(C_word c,C_word *av) C_noret;
C_noret_decl(f_34367)
static void C_ccall f_34367(C_word c,C_word *av) C_noret;
C_noret_decl(f_34371)
static void C_ccall f_34371(C_word c,C_word *av) C_noret;
C_noret_decl(f_34375)
static void C_ccall f_34375(C_word c,C_word *av) C_noret;
C_noret_decl(f_34377)
static void C_ccall f_34377(C_word c,C_word *av) C_noret;
C_noret_decl(f_34387)
static void C_ccall f_34387(C_word c,C_word *av) C_noret;
C_noret_decl(f_34398)
static void C_ccall f_34398(C_word c,C_word *av) C_noret;
C_noret_decl(f_34402)
static void C_ccall f_34402(C_word c,C_word *av) C_noret;
C_noret_decl(f_34407)
static void C_ccall f_34407(C_word c,C_word *av) C_noret;
C_noret_decl(f_34411)
static void C_ccall f_34411(C_word c,C_word *av) C_noret;
C_noret_decl(f_34416)
static void C_ccall f_34416(C_word c,C_word *av) C_noret;
C_noret_decl(f_34419)
static void C_ccall f_34419(C_word c,C_word *av) C_noret;
C_noret_decl(f_34422)
static void C_ccall f_34422(C_word c,C_word *av) C_noret;
C_noret_decl(f_34425)
static void C_ccall f_34425(C_word c,C_word *av) C_noret;
C_noret_decl(f_34427)
static void C_ccall f_34427(C_word c,C_word *av) C_noret;
C_noret_decl(f_34434)
static void C_ccall f_34434(C_word c,C_word *av) C_noret;
C_noret_decl(f_34437)
static void C_ccall f_34437(C_word c,C_word *av) C_noret;
C_noret_decl(f_34445)
static void C_ccall f_34445(C_word c,C_word *av) C_noret;
C_noret_decl(f_34452)
static void C_ccall f_34452(C_word c,C_word *av) C_noret;
C_noret_decl(f_34457)
static void C_ccall f_34457(C_word c,C_word *av) C_noret;
C_noret_decl(f_34460)
static void C_ccall f_34460(C_word c,C_word *av) C_noret;
C_noret_decl(f_34463)
static void C_ccall f_34463(C_word c,C_word *av) C_noret;
C_noret_decl(f_34466)
static void C_ccall f_34466(C_word c,C_word *av) C_noret;
C_noret_decl(f_34471)
static void C_ccall f_34471(C_word c,C_word *av) C_noret;
C_noret_decl(f_34474)
static void C_ccall f_34474(C_word c,C_word *av) C_noret;
C_noret_decl(f_34477)
static void C_ccall f_34477(C_word c,C_word *av) C_noret;
C_noret_decl(f_34480)
static void C_ccall f_34480(C_word c,C_word *av) C_noret;
C_noret_decl(f_34483)
static void C_ccall f_34483(C_word c,C_word *av) C_noret;
C_noret_decl(f_34486)
static void C_ccall f_34486(C_word c,C_word *av) C_noret;
C_noret_decl(f_34489)
static void C_ccall f_34489(C_word c,C_word *av) C_noret;
C_noret_decl(f_34492)
static void C_ccall f_34492(C_word c,C_word *av) C_noret;
C_noret_decl(f_34516)
static void C_ccall f_34516(C_word c,C_word *av) C_noret;
C_noret_decl(f_34520)
static void C_ccall f_34520(C_word c,C_word *av) C_noret;
C_noret_decl(f_34522)
static void C_ccall f_34522(C_word c,C_word *av) C_noret;
C_noret_decl(f_34530)
static void C_ccall f_34530(C_word c,C_word *av) C_noret;
C_noret_decl(f_34532)
static void C_ccall f_34532(C_word c,C_word *av) C_noret;
C_noret_decl(f_34536)
static void C_ccall f_34536(C_word c,C_word *av) C_noret;
C_noret_decl(f_34538)
static void C_ccall f_34538(C_word c,C_word *av) C_noret;
C_noret_decl(f_34545)
static void C_ccall f_34545(C_word c,C_word *av) C_noret;
C_noret_decl(f_34581)
static void C_ccall f_34581(C_word c,C_word *av) C_noret;
C_noret_decl(f_34584)
static void C_ccall f_34584(C_word c,C_word *av) C_noret;
C_noret_decl(f_34587)
static void C_ccall f_34587(C_word c,C_word *av) C_noret;
C_noret_decl(f_34590)
static void C_ccall f_34590(C_word c,C_word *av) C_noret;
C_noret_decl(f_34593)
static void C_ccall f_34593(C_word c,C_word *av) C_noret;
C_noret_decl(f_34609)
static void C_ccall f_34609(C_word c,C_word *av) C_noret;
C_noret_decl(f_34613)
static void C_ccall f_34613(C_word c,C_word *av) C_noret;
C_noret_decl(f_34622)
static void C_ccall f_34622(C_word c,C_word *av) C_noret;
C_noret_decl(f_34626)
static void C_ccall f_34626(C_word c,C_word *av) C_noret;
C_noret_decl(f_34628)
static void C_ccall f_34628(C_word c,C_word *av) C_noret;
C_noret_decl(f_34632)
static void C_ccall f_34632(C_word c,C_word *av) C_noret;
C_noret_decl(f_34634)
static void C_ccall f_34634(C_word c,C_word *av) C_noret;
C_noret_decl(f_34639)
static void C_ccall f_34639(C_word c,C_word *av) C_noret;
C_noret_decl(f_34641)
static void C_ccall f_34641(C_word c,C_word *av) C_noret;
C_noret_decl(f_34644)
static void C_ccall f_34644(C_word c,C_word *av) C_noret;
C_noret_decl(f_34664)
static void C_ccall f_34664(C_word c,C_word *av) C_noret;
C_noret_decl(f_34670)
static void f_34670(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_34680)
static void C_ccall f_34680(C_word c,C_word *av) C_noret;
C_noret_decl(f_34690)
static void C_ccall f_34690(C_word c,C_word *av) C_noret;
C_noret_decl(f_34725)
static void C_ccall f_34725(C_word c,C_word *av) C_noret;
C_noret_decl(f_34729)
static void C_ccall f_34729(C_word c,C_word *av) C_noret;
C_noret_decl(f_34734)
static void f_34734(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_34744)
static void C_ccall f_34744(C_word c,C_word *av) C_noret;
C_noret_decl(f_34754)
static void C_ccall f_34754(C_word c,C_word *av) C_noret;
C_noret_decl(f_34763)
static void C_ccall f_34763(C_word c,C_word *av) C_noret;
C_noret_decl(f_34766)
static void C_ccall f_34766(C_word c,C_word *av) C_noret;
C_noret_decl(f_34769)
static void C_ccall f_34769(C_word c,C_word *av) C_noret;
C_noret_decl(f_34773)
static void C_ccall f_34773(C_word c,C_word *av) C_noret;
C_noret_decl(f_34775)
static void C_ccall f_34775(C_word c,C_word *av) C_noret;
C_noret_decl(f_34778)
static void C_ccall f_34778(C_word c,C_word *av) C_noret;
C_noret_decl(f_34781)
static void C_ccall f_34781(C_word c,C_word *av) C_noret;
C_noret_decl(f_34784)
static void C_ccall f_34784(C_word c,C_word *av) C_noret;
C_noret_decl(f_34787)
static void C_ccall f_34787(C_word c,C_word *av) C_noret;
C_noret_decl(f_34796)
static void C_ccall f_34796(C_word c,C_word *av) C_noret;
C_noret_decl(f_34799)
static void C_ccall f_34799(C_word c,C_word *av) C_noret;
C_noret_decl(f_34802)
static void C_ccall f_34802(C_word c,C_word *av) C_noret;
C_noret_decl(f_34805)
static void C_ccall f_34805(C_word c,C_word *av) C_noret;
C_noret_decl(f_34808)
static void C_ccall f_34808(C_word c,C_word *av) C_noret;
C_noret_decl(f_34811)
static void C_ccall f_34811(C_word c,C_word *av) C_noret;
C_noret_decl(f_34814)
static void C_ccall f_34814(C_word c,C_word *av) C_noret;
C_noret_decl(f_34817)
static void C_ccall f_34817(C_word c,C_word *av) C_noret;
C_noret_decl(f_34824)
static void C_ccall f_34824(C_word c,C_word *av) C_noret;
C_noret_decl(f_34827)
static void C_ccall f_34827(C_word c,C_word *av) C_noret;
C_noret_decl(f_34843)
static void C_ccall f_34843(C_word c,C_word *av) C_noret;
C_noret_decl(f_34851)
static void C_ccall f_34851(C_word c,C_word *av) C_noret;
C_noret_decl(f_34854)
static void C_ccall f_34854(C_word c,C_word *av) C_noret;
C_noret_decl(f_34860)
static void C_ccall f_34860(C_word c,C_word *av) C_noret;
C_noret_decl(f_34869)
static void C_ccall f_34869(C_word c,C_word *av) C_noret;
C_noret_decl(f_34875)
static void C_ccall f_34875(C_word c,C_word *av) C_noret;
C_noret_decl(f_34884)
static void C_ccall f_34884(C_word c,C_word *av) C_noret;
C_noret_decl(f_34890)
static void C_ccall f_34890(C_word c,C_word *av) C_noret;
C_noret_decl(f_34896)
static void C_ccall f_34896(C_word c,C_word *av) C_noret;
C_noret_decl(f_34899)
static void C_ccall f_34899(C_word c,C_word *av) C_noret;
C_noret_decl(f_34905)
static void C_ccall f_34905(C_word c,C_word *av) C_noret;
C_noret_decl(f_34911)
static void C_ccall f_34911(C_word c,C_word *av) C_noret;
C_noret_decl(f_34914)
static void C_ccall f_34914(C_word c,C_word *av) C_noret;
C_noret_decl(f_34920)
static void C_ccall f_34920(C_word c,C_word *av) C_noret;
C_noret_decl(f_34959)
static void C_ccall f_34959(C_word c,C_word *av) C_noret;
C_noret_decl(f_35002)
static void C_ccall f_35002(C_word c,C_word *av) C_noret;
C_noret_decl(f_35009)
static void C_ccall f_35009(C_word c,C_word *av) C_noret;
C_noret_decl(f_35014)
static void f_35014(C_word t0,C_word t1) C_noret;
C_noret_decl(f_35030)
static void C_ccall f_35030(C_word c,C_word *av) C_noret;
C_noret_decl(f_35056)
static void C_ccall f_35056(C_word c,C_word *av) C_noret;
C_noret_decl(f_35059)
static void C_ccall f_35059(C_word c,C_word *av) C_noret;
C_noret_decl(f_35066)
static void C_ccall f_35066(C_word c,C_word *av) C_noret;
C_noret_decl(f_35071)
static void C_ccall f_35071(C_word c,C_word *av) C_noret;
C_noret_decl(f_35073)
static void C_ccall f_35073(C_word c,C_word *av) C_noret;
C_noret_decl(f_35077)
static void C_ccall f_35077(C_word c,C_word *av) C_noret;
C_noret_decl(f_35104)
static void f_35104(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_35114)
static void C_ccall f_35114(C_word c,C_word *av) C_noret;
C_noret_decl(f_35123)
static void C_ccall f_35123(C_word c,C_word *av) C_noret;
C_noret_decl(f_35130)
static void C_ccall f_35130(C_word c,C_word *av) C_noret;
C_noret_decl(f_35134)
static void C_ccall f_35134(C_word c,C_word *av) C_noret;
C_noret_decl(f_35148)
static void f_35148(C_word t0,C_word t1) C_noret;
C_noret_decl(f_35152)
static void C_ccall f_35152(C_word c,C_word *av) C_noret;
C_noret_decl(f_35159)
static void C_ccall f_35159(C_word c,C_word *av) C_noret;
C_noret_decl(f_35161)
static void f_35161(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_35183)
static void C_ccall f_35183(C_word c,C_word *av) C_noret;
C_noret_decl(f_35190)
static void C_ccall f_35190(C_word c,C_word *av) C_noret;
C_noret_decl(f_35195)
static void f_35195(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_35199)
static void C_ccall f_35199(C_word c,C_word *av) C_noret;
C_noret_decl(f_35202)
static void C_ccall f_35202(C_word c,C_word *av) C_noret;
C_noret_decl(f_35205)
static void C_ccall f_35205(C_word c,C_word *av) C_noret;
C_noret_decl(f_35210)
static void f_35210(C_word t0,C_word t1) C_noret;
C_noret_decl(f_35214)
static void C_ccall f_35214(C_word c,C_word *av) C_noret;
C_noret_decl(f_35240)
static void C_ccall f_35240(C_word c,C_word *av) C_noret;
C_noret_decl(f_35253)
static void C_ccall f_35253(C_word c,C_word *av) C_noret;
C_noret_decl(f_35256)
static void C_ccall f_35256(C_word c,C_word *av) C_noret;
C_noret_decl(f_35265)
static void C_ccall f_35265(C_word c,C_word *av) C_noret;
C_noret_decl(f_35268)
static void C_ccall f_35268(C_word c,C_word *av) C_noret;
C_noret_decl(f_35271)
static void C_ccall f_35271(C_word c,C_word *av) C_noret;
C_noret_decl(f_35277)
static void C_ccall f_35277(C_word c,C_word *av) C_noret;
C_noret_decl(f_35284)
static void C_ccall f_35284(C_word c,C_word *av) C_noret;
C_noret_decl(f_35286)
static void f_35286(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_35299)
static void C_ccall f_35299(C_word c,C_word *av) C_noret;
C_noret_decl(f_35312)
static void C_ccall f_35312(C_word c,C_word *av) C_noret;
C_noret_decl(f_35315)
static void C_ccall f_35315(C_word c,C_word *av) C_noret;
C_noret_decl(f_35318)
static void C_ccall f_35318(C_word c,C_word *av) C_noret;
C_noret_decl(f_35325)
static void C_ccall f_35325(C_word c,C_word *av) C_noret;
C_noret_decl(f_35377)
static void C_ccall f_35377(C_word c,C_word *av) C_noret;
C_noret_decl(f_35380)
static void C_ccall f_35380(C_word c,C_word *av) C_noret;
C_noret_decl(f_35383)
static void C_ccall f_35383(C_word c,C_word *av) C_noret;
C_noret_decl(f_35385)
static void f_35385(C_word t0,C_word t1) C_noret;
C_noret_decl(f_35389)
static void C_ccall f_35389(C_word c,C_word *av) C_noret;
C_noret_decl(f_35393)
static void C_ccall f_35393(C_word c,C_word *av) C_noret;
C_noret_decl(f_35399)
static void C_ccall f_35399(C_word c,C_word *av) C_noret;
C_noret_decl(f_35404)
static void f_35404(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_35408)
static void C_ccall f_35408(C_word c,C_word *av) C_noret;
C_noret_decl(f_35420)
static void C_ccall f_35420(C_word c,C_word *av) C_noret;
C_noret_decl(f_35432)
static void C_ccall f_35432(C_word c,C_word *av) C_noret;
C_noret_decl(f_35439)
static void C_ccall f_35439(C_word c,C_word *av) C_noret;
C_noret_decl(f_35445)
static void f_35445(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_35459)
static void C_ccall f_35459(C_word c,C_word *av) C_noret;
C_noret_decl(f_35498)
static void C_ccall f_35498(C_word c,C_word *av) C_noret;
C_noret_decl(f_35517)
static void C_ccall f_35517(C_word c,C_word *av) C_noret;
C_noret_decl(f_35539)
static void C_ccall f_35539(C_word c,C_word *av) C_noret;
C_noret_decl(f_35548)
static void C_ccall f_35548(C_word c,C_word *av) C_noret;
C_noret_decl(f_35555)
static void C_ccall f_35555(C_word c,C_word *av) C_noret;
C_noret_decl(f_35572)
static void C_ccall f_35572(C_word c,C_word *av) C_noret;
C_noret_decl(f_35580)
static void C_ccall f_35580(C_word c,C_word *av) C_noret;
C_noret_decl(f_35591)
static void C_ccall f_35591(C_word c,C_word *av) C_noret;
C_noret_decl(f_35599)
static void C_ccall f_35599(C_word c,C_word *av) C_noret;
C_noret_decl(f_35606)
static void C_ccall f_35606(C_word c,C_word *av) C_noret;
C_noret_decl(f_35668)
static void C_ccall f_35668(C_word c,C_word *av) C_noret;
C_noret_decl(f_35675)
static void C_ccall f_35675(C_word c,C_word *av) C_noret;
C_noret_decl(f_35678)
static void C_ccall f_35678(C_word c,C_word *av) C_noret;
C_noret_decl(f_35688)
static void C_ccall f_35688(C_word c,C_word *av) C_noret;
C_noret_decl(f_35692)
static void C_ccall f_35692(C_word c,C_word *av) C_noret;
C_noret_decl(f_35696)
static void C_ccall f_35696(C_word c,C_word *av) C_noret;
C_noret_decl(f_35699)
static void C_ccall f_35699(C_word c,C_word *av) C_noret;
C_noret_decl(f_35707)
static void C_ccall f_35707(C_word c,C_word *av) C_noret;
C_noret_decl(f_35716)
static void C_ccall f_35716(C_word c,C_word *av) C_noret;
C_noret_decl(f_35724)
static void C_ccall f_35724(C_word c,C_word *av) C_noret;
C_noret_decl(f_35737)
static void C_ccall f_35737(C_word c,C_word *av) C_noret;
C_noret_decl(f_35745)
static void C_ccall f_35745(C_word c,C_word *av) C_noret;
C_noret_decl(f_35749)
static void C_ccall f_35749(C_word c,C_word *av) C_noret;
C_noret_decl(f_35757)
static void C_ccall f_35757(C_word c,C_word *av) C_noret;
C_noret_decl(f_35765)
static void C_ccall f_35765(C_word c,C_word *av) C_noret;
C_noret_decl(f_35767)
static void C_ccall f_35767(C_word c,C_word *av) C_noret;
C_noret_decl(f_35773)
static void f_35773(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_35777)
static void C_ccall f_35777(C_word c,C_word *av) C_noret;
C_noret_decl(f_35785)
static void f_35785(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_35805)
static void C_ccall f_35805(C_word c,C_word *av) C_noret;
C_noret_decl(f_35813)
static void C_ccall f_35813(C_word c,C_word *av) C_noret;
C_noret_decl(f_35817)
static void C_ccall f_35817(C_word c,C_word *av) C_noret;
C_noret_decl(f_35832)
static void C_ccall f_35832(C_word c,C_word *av) C_noret;
C_noret_decl(f_35839)
static void C_ccall f_35839(C_word c,C_word *av) C_noret;
C_noret_decl(f_35851)
static void C_ccall f_35851(C_word c,C_word *av) C_noret;
C_noret_decl(f_35859)
static void C_ccall f_35859(C_word c,C_word *av) C_noret;
C_noret_decl(f_35865)
static void f_35865(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_35887)
static void C_ccall f_35887(C_word c,C_word *av) C_noret;
C_noret_decl(f_35891)
static void C_ccall f_35891(C_word c,C_word *av) C_noret;
C_noret_decl(f_35895)
static void C_ccall f_35895(C_word c,C_word *av) C_noret;
C_noret_decl(f_35897)
static void C_ccall f_35897(C_word c,C_word *av) C_noret;
C_noret_decl(f_35900)
static void C_ccall f_35900(C_word c,C_word *av) C_noret;
C_noret_decl(f_35903)
static void C_ccall f_35903(C_word c,C_word *av) C_noret;
C_noret_decl(f_35907)
static void C_ccall f_35907(C_word c,C_word *av) C_noret;
C_noret_decl(f_35910)
static void C_ccall f_35910(C_word c,C_word *av) C_noret;
C_noret_decl(f_35932)
static void C_ccall f_35932(C_word c,C_word *av) C_noret;
C_noret_decl(f_35938)
static void C_ccall f_35938(C_word c,C_word *av) C_noret;
C_noret_decl(f_35942)
static void C_ccall f_35942(C_word c,C_word *av) C_noret;
C_noret_decl(f_35959)
static void C_ccall f_35959(C_word c,C_word *av) C_noret;
C_noret_decl(f_35969)
static void C_ccall f_35969(C_word c,C_word *av) C_noret;
C_noret_decl(f_35973)
static void C_ccall f_35973(C_word c,C_word *av) C_noret;
C_noret_decl(f_35977)
static void C_ccall f_35977(C_word c,C_word *av) C_noret;
C_noret_decl(f_35989)
static void C_ccall f_35989(C_word c,C_word *av) C_noret;
C_noret_decl(f_35999)
static void C_ccall f_35999(C_word c,C_word *av) C_noret;
C_noret_decl(f_36008)
static void C_ccall f_36008(C_word c,C_word *av) C_noret;
C_noret_decl(f_36024)
static void C_ccall f_36024(C_word c,C_word *av) C_noret;
C_noret_decl(f_36028)
static void C_ccall f_36028(C_word c,C_word *av) C_noret;
C_noret_decl(f_36030)
static void C_ccall f_36030(C_word c,C_word *av) C_noret;
C_noret_decl(f_36036)
static void C_ccall f_36036(C_word c,C_word *av) C_noret;
C_noret_decl(f_36043)
static void C_ccall f_36043(C_word c,C_word *av) C_noret;
C_noret_decl(f_36048)
static void C_ccall f_36048(C_word c,C_word *av) C_noret;
C_noret_decl(f_36069)
static void C_ccall f_36069(C_word c,C_word *av) C_noret;
C_noret_decl(f_36079)
static void f_36079(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_36089)
static void C_ccall f_36089(C_word c,C_word *av) C_noret;
C_noret_decl(f_36102)
static void C_ccall f_36102(C_word c,C_word *av) C_noret;
C_noret_decl(f_36106)
static void C_ccall f_36106(C_word c,C_word *av) C_noret;
C_noret_decl(f_36109)
static void C_ccall f_36109(C_word c,C_word *av) C_noret;
C_noret_decl(f_36117)
static void f_36117(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_36127)
static void C_ccall f_36127(C_word c,C_word *av) C_noret;
C_noret_decl(f_36149)
static void C_ccall f_36149(C_word c,C_word *av) C_noret;
C_noret_decl(f_36153)
static void C_ccall f_36153(C_word c,C_word *av) C_noret;
C_noret_decl(f_36184)
static void C_ccall f_36184(C_word c,C_word *av) C_noret;
C_noret_decl(f_36187)
static void C_ccall f_36187(C_word c,C_word *av) C_noret;
C_noret_decl(f_36190)
static void C_ccall f_36190(C_word c,C_word *av) C_noret;
C_noret_decl(f_36196)
static void f_36196(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_36209)
static void C_ccall f_36209(C_word c,C_word *av) C_noret;
C_noret_decl(f_36212)
static void C_ccall f_36212(C_word c,C_word *av) C_noret;
C_noret_decl(f_36221)
static void C_ccall f_36221(C_word c,C_word *av) C_noret;
C_noret_decl(f_36227)
static void C_ccall f_36227(C_word c,C_word *av) C_noret;
C_noret_decl(f_36233)
static void C_ccall f_36233(C_word c,C_word *av) C_noret;
C_noret_decl(f_36239)
static void C_ccall f_36239(C_word c,C_word *av) C_noret;
C_noret_decl(f_36245)
static void C_ccall f_36245(C_word c,C_word *av) C_noret;
C_noret_decl(f_36262)
static void C_ccall f_36262(C_word c,C_word *av) C_noret;
C_noret_decl(f_36268)
static void C_ccall f_36268(C_word c,C_word *av) C_noret;
C_noret_decl(f_36283)
static void C_ccall f_36283(C_word c,C_word *av) C_noret;
C_noret_decl(f_36287)
static void C_ccall f_36287(C_word c,C_word *av) C_noret;
C_noret_decl(f_36291)
static void C_ccall f_36291(C_word c,C_word *av) C_noret;
C_noret_decl(f_36295)
static void C_ccall f_36295(C_word c,C_word *av) C_noret;
C_noret_decl(f_36316)
static void C_ccall f_36316(C_word c,C_word *av) C_noret;
C_noret_decl(f_36318)
static void C_ccall f_36318(C_word c,C_word *av) C_noret;
C_noret_decl(f_36324)
static void f_36324(C_word t0,C_word t1) C_noret;
C_noret_decl(f_36328)
static void C_ccall f_36328(C_word c,C_word *av) C_noret;
C_noret_decl(f_36337)
static void C_ccall f_36337(C_word c,C_word *av) C_noret;
C_noret_decl(f_36346)
static void C_ccall f_36346(C_word c,C_word *av) C_noret;
C_noret_decl(f_36389)
static void C_ccall f_36389(C_word c,C_word *av) C_noret;
C_noret_decl(f_36656)
static void C_ccall f_36656(C_word c,C_word *av) C_noret;
C_noret_decl(f_36662)
static void C_ccall f_36662(C_word c,C_word *av) C_noret;
C_noret_decl(f_36681)
static void C_ccall f_36681(C_word c,C_word *av) C_noret;
C_noret_decl(f_36683)
static void C_ccall f_36683(C_word c,C_word *av) C_noret;
C_noret_decl(f_36706)
static C_word f_36706(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_36752)
static void C_ccall f_36752(C_word c,C_word *av) C_noret;
C_noret_decl(f_36754)
static void C_ccall f_36754(C_word c,C_word *av) C_noret;
C_noret_decl(f_36761)
static void f_36761(C_word t0,C_word t1) C_noret;
C_noret_decl(f_36770)
static void f_36770(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_36814)
static void C_ccall f_36814(C_word c,C_word *av) C_noret;
C_noret_decl(f_36829)
static void f_36829(C_word t0,C_word t1) C_noret;
C_noret_decl(f_36837)
static void C_ccall f_36837(C_word c,C_word *av) C_noret;
C_noret_decl(f_36843)
static void f_36843(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_36851)
static void C_ccall f_36851(C_word c,C_word *av) C_noret;
C_noret_decl(f_36855)
static void C_ccall f_36855(C_word c,C_word *av) C_noret;
C_noret_decl(f_36863)
static void C_ccall f_36863(C_word c,C_word *av) C_noret;
C_noret_decl(f_36865)
static void f_36865(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_36875)
static void C_ccall f_36875(C_word c,C_word *av) C_noret;
C_noret_decl(f_36882)
static void C_ccall f_36882(C_word c,C_word *av) C_noret;
C_noret_decl(f_36886)
static void C_ccall f_36886(C_word c,C_word *av) C_noret;
C_noret_decl(f_36897)
static void C_ccall f_36897(C_word c,C_word *av) C_noret;
C_noret_decl(f_36904)
static void C_ccall f_36904(C_word c,C_word *av) C_noret;
C_noret_decl(f_36908)
static void C_ccall f_36908(C_word c,C_word *av) C_noret;
C_noret_decl(f_36919)
static void C_ccall f_36919(C_word c,C_word *av) C_noret;
C_noret_decl(f_36926)
static void C_ccall f_36926(C_word c,C_word *av) C_noret;
C_noret_decl(f_36930)
static void C_ccall f_36930(C_word c,C_word *av) C_noret;
C_noret_decl(f_36935)
static void C_ccall f_36935(C_word c,C_word *av) C_noret;
C_noret_decl(f_36941)
static void C_ccall f_36941(C_word c,C_word *av) C_noret;
C_noret_decl(f_36944)
static void C_ccall f_36944(C_word c,C_word *av) C_noret;
C_noret_decl(f_36947)
static void C_ccall f_36947(C_word c,C_word *av) C_noret;
C_noret_decl(f_36953)
static void C_ccall f_36953(C_word c,C_word *av) C_noret;
C_noret_decl(f_36962)
static void C_ccall f_36962(C_word c,C_word *av) C_noret;
C_noret_decl(f_36971)
static void C_ccall f_36971(C_word c,C_word *av) C_noret;
C_noret_decl(f_36977)
static void C_ccall f_36977(C_word c,C_word *av) C_noret;
C_noret_decl(f_36980)
static void C_ccall f_36980(C_word c,C_word *av) C_noret;
C_noret_decl(f_36983)
static void C_ccall f_36983(C_word c,C_word *av) C_noret;
C_noret_decl(f_36995)
static void C_ccall f_36995(C_word c,C_word *av) C_noret;
C_noret_decl(f_36998)
static void C_ccall f_36998(C_word c,C_word *av) C_noret;
C_noret_decl(f_37001)
static void C_ccall f_37001(C_word c,C_word *av) C_noret;
C_noret_decl(f_37004)
static void C_ccall f_37004(C_word c,C_word *av) C_noret;
C_noret_decl(f_37016)
static void C_ccall f_37016(C_word c,C_word *av) C_noret;
C_noret_decl(f_37019)
static void C_ccall f_37019(C_word c,C_word *av) C_noret;
C_noret_decl(f_37022)
static void C_ccall f_37022(C_word c,C_word *av) C_noret;
C_noret_decl(f_37025)
static void C_ccall f_37025(C_word c,C_word *av) C_noret;
C_noret_decl(f_37034)
static void C_ccall f_37034(C_word c,C_word *av) C_noret;
C_noret_decl(f_37037)
static void C_ccall f_37037(C_word c,C_word *av) C_noret;
C_noret_decl(f_37050)
static void C_ccall f_37050(C_word c,C_word *av) C_noret;
C_noret_decl(f_37051)
static void C_ccall f_37051(C_word c,C_word *av) C_noret;
C_noret_decl(f_37056)
static void C_ccall f_37056(C_word c,C_word *av) C_noret;
C_noret_decl(f_37057)
static void C_ccall f_37057(C_word c,C_word *av) C_noret;
C_noret_decl(f_37062)
static void C_ccall f_37062(C_word c,C_word *av) C_noret;
C_noret_decl(f_37063)
static void C_ccall f_37063(C_word c,C_word *av) C_noret;
C_noret_decl(f_37068)
static void C_ccall f_37068(C_word c,C_word *av) C_noret;
C_noret_decl(f_37069)
static void C_ccall f_37069(C_word c,C_word *av) C_noret;
C_noret_decl(f_37074)
static void C_ccall f_37074(C_word c,C_word *av) C_noret;
C_noret_decl(f_37075)
static void C_ccall f_37075(C_word c,C_word *av) C_noret;
C_noret_decl(f_37080)
static void f_37080(C_word t0,C_word t1) C_noret;
C_noret_decl(f_37082)
static void C_ccall f_37082(C_word c,C_word *av) C_noret;
C_noret_decl(f_37092)
static void C_ccall f_37092(C_word c,C_word *av) C_noret;
C_noret_decl(f_37095)
static void C_ccall f_37095(C_word c,C_word *av) C_noret;
C_noret_decl(f_37098)
static void C_ccall f_37098(C_word c,C_word *av) C_noret;
C_noret_decl(f_37101)
static void C_ccall f_37101(C_word c,C_word *av) C_noret;
C_noret_decl(f_37103)
static void f_37103(C_word t0,C_word t1) C_noret;
C_noret_decl(f_37117)
static void C_ccall f_37117(C_word c,C_word *av) C_noret;
C_noret_decl(f_37125)
static void C_ccall f_37125(C_word c,C_word *av) C_noret;
C_noret_decl(f_37129)
static void C_ccall f_37129(C_word c,C_word *av) C_noret;
C_noret_decl(f_37133)
static void C_ccall f_37133(C_word c,C_word *av) C_noret;
C_noret_decl(f_37137)
static void C_ccall f_37137(C_word c,C_word *av) C_noret;
C_noret_decl(f_37143)
static void C_ccall f_37143(C_word c,C_word *av) C_noret;
C_noret_decl(f_37150)
static void C_ccall f_37150(C_word c,C_word *av) C_noret;
C_noret_decl(f_37154)
static void C_ccall f_37154(C_word c,C_word *av) C_noret;
C_noret_decl(f_37158)
static void C_ccall f_37158(C_word c,C_word *av) C_noret;
C_noret_decl(f_37162)
static void C_ccall f_37162(C_word c,C_word *av) C_noret;
C_noret_decl(f_37180)
static void C_ccall f_37180(C_word c,C_word *av) C_noret;
C_noret_decl(f_37199)
static void C_ccall f_37199(C_word c,C_word *av) C_noret;
C_noret_decl(f_37202)
static void C_ccall f_37202(C_word c,C_word *av) C_noret;
C_noret_decl(f_37205)
static void C_ccall f_37205(C_word c,C_word *av) C_noret;
C_noret_decl(f_37208)
static void C_ccall f_37208(C_word c,C_word *av) C_noret;
C_noret_decl(f_37217)
static void C_ccall f_37217(C_word c,C_word *av) C_noret;
C_noret_decl(f_37223)
static void C_ccall f_37223(C_word c,C_word *av) C_noret;
C_noret_decl(f_37246)
static void C_ccall f_37246(C_word c,C_word *av) C_noret;
C_noret_decl(f_37268)
static void C_ccall f_37268(C_word c,C_word *av) C_noret;
C_noret_decl(f_37274)
static void f_37274(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_37294)
static void C_ccall f_37294(C_word c,C_word *av) C_noret;
C_noret_decl(f_37309)
static void C_ccall f_37309(C_word c,C_word *av) C_noret;
C_noret_decl(f_37313)
static void C_ccall f_37313(C_word c,C_word *av) C_noret;
C_noret_decl(f_37336)
static void C_ccall f_37336(C_word c,C_word *av) C_noret;
C_noret_decl(f_37340)
static void C_ccall f_37340(C_word c,C_word *av) C_noret;
C_noret_decl(f_37342)
static void C_ccall f_37342(C_word c,C_word *av) C_noret;
C_noret_decl(f_37372)
static void C_ccall f_37372(C_word c,C_word *av) C_noret;
C_noret_decl(f_37375)
static void C_ccall f_37375(C_word c,C_word *av) C_noret;
C_noret_decl(f_37377)
static void C_ccall f_37377(C_word c,C_word *av) C_noret;
C_noret_decl(f_37395)
static void C_ccall f_37395(C_word c,C_word *av) C_noret;
C_noret_decl(f_37402)
static void C_ccall f_37402(C_word c,C_word *av) C_noret;
C_noret_decl(f_37424)
static void C_ccall f_37424(C_word c,C_word *av) C_noret;
C_noret_decl(f_37433)
static void f_37433(C_word t0,C_word t1) C_noret;
C_noret_decl(f_37448)
static void C_ccall f_37448(C_word c,C_word *av) C_noret;
C_noret_decl(f_37451)
static void C_ccall f_37451(C_word c,C_word *av) C_noret;
C_noret_decl(f_37454)
static void C_ccall f_37454(C_word c,C_word *av) C_noret;
C_noret_decl(f_37457)
static void C_ccall f_37457(C_word c,C_word *av) C_noret;
C_noret_decl(f_37460)
static void C_ccall f_37460(C_word c,C_word *av) C_noret;
C_noret_decl(f_37463)
static void C_ccall f_37463(C_word c,C_word *av) C_noret;
C_noret_decl(f_37466)
static void f_37466(C_word t0,C_word t1) C_noret;
C_noret_decl(f_37469)
static void f_37469(C_word t0,C_word t1) C_noret;
C_noret_decl(f_37472)
static void f_37472(C_word t0,C_word t1) C_noret;
C_noret_decl(f_37475)
static void f_37475(C_word t0,C_word t1) C_noret;
C_noret_decl(f_37483)
static void C_ccall f_37483(C_word c,C_word *av) C_noret;
C_noret_decl(f_37486)
static void C_ccall f_37486(C_word c,C_word *av) C_noret;
C_noret_decl(f_37491)
static void C_ccall f_37491(C_word c,C_word *av) C_noret;
C_noret_decl(f_37497)
static void C_ccall f_37497(C_word c,C_word *av) C_noret;
C_noret_decl(f_37510)
static void C_ccall f_37510(C_word c,C_word *av) C_noret;
C_noret_decl(f_37512)
static void f_37512(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_37535)
static void C_ccall f_37535(C_word c,C_word *av) C_noret;
C_noret_decl(f_37542)
static void C_ccall f_37542(C_word c,C_word *av) C_noret;
C_noret_decl(f_37546)
static void C_ccall f_37546(C_word c,C_word *av) C_noret;
C_noret_decl(f_37548)
static void f_37548(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_37577)
static void C_ccall f_37577(C_word c,C_word *av) C_noret;
C_noret_decl(f_37579)
static void f_37579(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_37604)
static void C_ccall f_37604(C_word c,C_word *av) C_noret;
C_noret_decl(f_37613)
static void C_ccall f_37613(C_word c,C_word *av) C_noret;
C_noret_decl(f_37619)
static void f_37619(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_37643)
static void C_ccall f_37643(C_word c,C_word *av) C_noret;
C_noret_decl(f_37650)
static void C_ccall f_37650(C_word c,C_word *av) C_noret;
C_noret_decl(f_37654)
static void C_ccall f_37654(C_word c,C_word *av) C_noret;
C_noret_decl(f_37666)
static void C_ccall f_37666(C_word c,C_word *av) C_noret;
C_noret_decl(f_37674)
static void C_ccall f_37674(C_word c,C_word *av) C_noret;
C_noret_decl(f_37678)
static void C_ccall f_37678(C_word c,C_word *av) C_noret;
C_noret_decl(f_37687)
static void C_ccall f_37687(C_word c,C_word *av) C_noret;
C_noret_decl(f_37696)
static void C_ccall f_37696(C_word c,C_word *av) C_noret;
C_noret_decl(f_37704)
static void C_ccall f_37704(C_word c,C_word *av) C_noret;
C_noret_decl(f_37717)
static void C_ccall f_37717(C_word c,C_word *av) C_noret;
C_noret_decl(f_37725)
static void f_37725(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_37750)
static void C_ccall f_37750(C_word c,C_word *av) C_noret;
C_noret_decl(f_37759)
static void C_ccall f_37759(C_word c,C_word *av) C_noret;
C_noret_decl(f_37766)
static void C_ccall f_37766(C_word c,C_word *av) C_noret;
C_noret_decl(f_37769)
static void C_ccall f_37769(C_word c,C_word *av) C_noret;
C_noret_decl(f_37774)
static void f_37774(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_37806)
static void C_ccall f_37806(C_word c,C_word *av) C_noret;
C_noret_decl(f_37810)
static void C_ccall f_37810(C_word c,C_word *av) C_noret;
C_noret_decl(f_37813)
static void C_ccall f_37813(C_word c,C_word *av) C_noret;
C_noret_decl(f_37818)
static void f_37818(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_37831)
static void C_ccall f_37831(C_word c,C_word *av) C_noret;
C_noret_decl(f_37856)
static void C_ccall f_37856(C_word c,C_word *av) C_noret;
C_noret_decl(f_37868)
static void f_37868(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_37893)
static void C_ccall f_37893(C_word c,C_word *av) C_noret;
C_noret_decl(f_37895)
static void C_ccall f_37895(C_word c,C_word *av) C_noret;
C_noret_decl(f_37909)
static void f_37909(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_37919)
static void C_ccall f_37919(C_word c,C_word *av) C_noret;
C_noret_decl(f_37922)
static void C_ccall f_37922(C_word c,C_word *av) C_noret;
C_noret_decl(f_37925)
static void C_ccall f_37925(C_word c,C_word *av) C_noret;
C_noret_decl(f_37930)
static C_word f_37930(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_37999)
static void C_ccall f_37999(C_word c,C_word *av) C_noret;
C_noret_decl(f_38013)
static void f_38013(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_38023)
static void C_ccall f_38023(C_word c,C_word *av) C_noret;
C_noret_decl(f_38026)
static void C_ccall f_38026(C_word c,C_word *av) C_noret;
C_noret_decl(f_38029)
static void C_ccall f_38029(C_word c,C_word *av) C_noret;
C_noret_decl(f_38034)
static void f_38034(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_38113)
static void C_ccall f_38113(C_word c,C_word *av) C_noret;
C_noret_decl(f_38123)
static void C_ccall f_38123(C_word c,C_word *av) C_noret;
C_noret_decl(f_38128)
static void f_38128(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_38141)
static void C_ccall f_38141(C_word c,C_word *av) C_noret;
C_noret_decl(f_38175)
static void C_ccall f_38175(C_word c,C_word *av) C_noret;
C_noret_decl(f_38189)
static void C_ccall f_38189(C_word c,C_word *av) C_noret;
C_noret_decl(f_38198)
static void C_ccall f_38198(C_word c,C_word *av) C_noret;
C_noret_decl(f_38203)
static void f_38203(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_38224)
static void C_ccall f_38224(C_word c,C_word *av) C_noret;
C_noret_decl(f_38229)
static C_word f_38229(C_word t0,C_word t1);
C_noret_decl(f_38236)
static void C_ccall f_38236(C_word c,C_word *av) C_noret;
C_noret_decl(f_38238)
static void f_38238(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_38272)
static C_word f_38272(C_word t0,C_word t1);
C_noret_decl(f_38296)
static void f_38296(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_38330)
static C_word f_38330(C_word t0);
C_noret_decl(f_38353)
static void C_ccall f_38353(C_word c,C_word *av) C_noret;
C_noret_decl(f_38365)
static void f_38365(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_38375)
static void C_ccall f_38375(C_word c,C_word *av) C_noret;
C_noret_decl(f_38401)
static void C_ccall f_38401(C_word c,C_word *av) C_noret;
C_noret_decl(f_38415)
static void C_ccall f_38415(C_word c,C_word *av) C_noret;
C_noret_decl(f_38424)
static void C_ccall f_38424(C_word c,C_word *av) C_noret;
C_noret_decl(f_38429)
static void f_38429(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_38439)
static void C_ccall f_38439(C_word c,C_word *av) C_noret;
C_noret_decl(f_38451)
static C_word f_38451(C_word t0,C_word t1);
C_noret_decl(f_38458)
static void C_ccall f_38458(C_word c,C_word *av) C_noret;
C_noret_decl(f_38460)
static void f_38460(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_38494)
static C_word f_38494(C_word t0,C_word t1);
C_noret_decl(f_38518)
static void f_38518(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_38552)
static C_word f_38552(C_word t0);
C_noret_decl(f_38575)
static void C_ccall f_38575(C_word c,C_word *av) C_noret;
C_noret_decl(f_38585)
static void C_ccall f_38585(C_word c,C_word *av) C_noret;
C_noret_decl(f_38594)
static void C_ccall f_38594(C_word c,C_word *av) C_noret;
C_noret_decl(f_38599)
static void f_38599(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_38620)
static void C_ccall f_38620(C_word c,C_word *av) C_noret;
C_noret_decl(f_38630)
static void C_ccall f_38630(C_word c,C_word *av) C_noret;
C_noret_decl(f_38644)
static void C_ccall f_38644(C_word c,C_word *av) C_noret;
C_noret_decl(f_38653)
static void C_ccall f_38653(C_word c,C_word *av) C_noret;
C_noret_decl(f_38658)
static void f_38658(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_38679)
static void C_ccall f_38679(C_word c,C_word *av) C_noret;
C_noret_decl(f_38684)
static C_word f_38684(C_word t0,C_word t1);
C_noret_decl(f_38691)
static void C_ccall f_38691(C_word c,C_word *av) C_noret;
C_noret_decl(f_38693)
static void f_38693(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_38727)
static C_word f_38727(C_word t0,C_word t1);
C_noret_decl(f_38751)
static void f_38751(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_38785)
static C_word f_38785(C_word t0);
C_noret_decl(f_38808)
static void C_ccall f_38808(C_word c,C_word *av) C_noret;
C_noret_decl(f_38818)
static void C_ccall f_38818(C_word c,C_word *av) C_noret;
C_noret_decl(f_38829)
static void f_38829(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_38839)
static void C_ccall f_38839(C_word c,C_word *av) C_noret;
C_noret_decl(f_38856)
static void C_ccall f_38856(C_word c,C_word *av) C_noret;
C_noret_decl(f_38870)
static void C_ccall f_38870(C_word c,C_word *av) C_noret;
C_noret_decl(f_38879)
static void C_ccall f_38879(C_word c,C_word *av) C_noret;
C_noret_decl(f_38884)
static void f_38884(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_38894)
static void C_ccall f_38894(C_word c,C_word *av) C_noret;
C_noret_decl(f_38906)
static C_word f_38906(C_word t0,C_word t1);
C_noret_decl(f_38913)
static void C_ccall f_38913(C_word c,C_word *av) C_noret;
C_noret_decl(f_38915)
static void f_38915(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_38949)
static C_word f_38949(C_word t0,C_word t1);
C_noret_decl(f_38973)
static void f_38973(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_39007)
static C_word f_39007(C_word t0);
C_noret_decl(f_39030)
static void C_ccall f_39030(C_word c,C_word *av) C_noret;
C_noret_decl(f_39034)
static void C_ccall f_39034(C_word c,C_word *av) C_noret;
C_noret_decl(f_39037)
static void C_ccall f_39037(C_word c,C_word *av) C_noret;
C_noret_decl(f_39040)
static void C_ccall f_39040(C_word c,C_word *av) C_noret;
C_noret_decl(f_39065)
static void C_ccall f_39065(C_word c,C_word *av) C_noret;
C_noret_decl(f_39071)
static void C_ccall f_39071(C_word c,C_word *av) C_noret;
C_noret_decl(f_39077)
static void C_ccall f_39077(C_word c,C_word *av) C_noret;
C_noret_decl(f_39081)
static void C_ccall f_39081(C_word c,C_word *av) C_noret;
C_noret_decl(f_39086)
static void C_ccall f_39086(C_word c,C_word *av) C_noret;
C_noret_decl(f_39089)
static void C_ccall f_39089(C_word c,C_word *av) C_noret;
C_noret_decl(f_39100)
static void C_ccall f_39100(C_word c,C_word *av) C_noret;
C_noret_decl(f_39125)
static void C_ccall f_39125(C_word c,C_word *av) C_noret;
C_noret_decl(f_39139)
static void C_ccall f_39139(C_word c,C_word *av) C_noret;
C_noret_decl(f_39167)
static void f_39167(C_word t0,C_word t1) C_noret;
C_noret_decl(f_39170)
static void f_39170(C_word t0,C_word t1) C_noret;
C_noret_decl(f_39173)
static void C_ccall f_39173(C_word c,C_word *av) C_noret;
C_noret_decl(f_39243)
static void C_ccall f_39243(C_word c,C_word *av) C_noret;
C_noret_decl(f_39272)
static void C_ccall f_39272(C_word c,C_word *av) C_noret;
C_noret_decl(f_39274)
static void f_39274(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_39294)
static void C_ccall f_39294(C_word c,C_word *av) C_noret;
C_noret_decl(f_39346)
static void C_ccall f_39346(C_word c,C_word *av) C_noret;
C_noret_decl(f_39356)
static void f_39356(C_word t0,C_word t1) C_noret;
C_noret_decl(f_39366)
static void f_39366(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_39379)
static void C_ccall f_39379(C_word c,C_word *av) C_noret;
C_noret_decl(f_39384)
static void f_39384(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_39397)
static void C_ccall f_39397(C_word c,C_word *av) C_noret;
C_noret_decl(f_39430)
static void C_ccall f_39430(C_word c,C_word *av) C_noret;
C_noret_decl(f_39439)
static void C_ccall f_39439(C_word c,C_word *av) C_noret;
C_noret_decl(f_39465)
static void C_ccall f_39465(C_word c,C_word *av) C_noret;
C_noret_decl(f_39473)
static void C_ccall f_39473(C_word c,C_word *av) C_noret;
C_noret_decl(f_39502)
static void C_ccall f_39502(C_word c,C_word *av) C_noret;
C_noret_decl(f_39530)
static void f_39530(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_39543)
static void C_ccall f_39543(C_word c,C_word *av) C_noret;
C_noret_decl(f_39592)
static void C_ccall f_39592(C_word c,C_word *av) C_noret;
C_noret_decl(f_39611)
static void C_ccall f_39611(C_word c,C_word *av) C_noret;
C_noret_decl(f_39631)
static void C_ccall f_39631(C_word c,C_word *av) C_noret;
C_noret_decl(f_39646)
static void f_39646(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_39650)
static void C_ccall f_39650(C_word c,C_word *av) C_noret;
C_noret_decl(f_39706)
static void C_ccall f_39706(C_word c,C_word *av) C_noret;
C_noret_decl(f_39710)
static void C_ccall f_39710(C_word c,C_word *av) C_noret;
C_noret_decl(f_39718)
static void C_ccall f_39718(C_word c,C_word *av) C_noret;
C_noret_decl(f_39721)
static void f_39721(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_39725)
static void C_ccall f_39725(C_word c,C_word *av) C_noret;
C_noret_decl(f_39736)
static void C_ccall f_39736(C_word c,C_word *av) C_noret;
C_noret_decl(f_39739)
static C_word f_39739(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_39745)
static void f_39745(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_39749)
static void C_ccall f_39749(C_word c,C_word *av) C_noret;
C_noret_decl(f_39769)
static void f_39769(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_39794)
static void C_ccall f_39794(C_word c,C_word *av) C_noret;
C_noret_decl(f_39864)
static void C_ccall f_39864(C_word c,C_word *av) C_noret;
C_noret_decl(f_39939)
static void C_ccall f_39939(C_word c,C_word *av) C_noret;
C_noret_decl(f_40024)
static void C_ccall f_40024(C_word c,C_word *av) C_noret;
C_noret_decl(f_40043)
static void C_ccall f_40043(C_word c,C_word *av) C_noret;
C_noret_decl(f_40046)
static void C_ccall f_40046(C_word c,C_word *av) C_noret;
C_noret_decl(f_40060)
static void C_ccall f_40060(C_word c,C_word *av) C_noret;
C_noret_decl(f_40072)
static void C_ccall f_40072(C_word c,C_word *av) C_noret;
C_noret_decl(f_40074)
static void C_ccall f_40074(C_word c,C_word *av) C_noret;
C_noret_decl(f_40082)
static void C_ccall f_40082(C_word c,C_word *av) C_noret;
C_noret_decl(f_40084)
static void f_40084(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_40091)
static void C_ccall f_40091(C_word c,C_word *av) C_noret;
C_noret_decl(f_40103)
static void C_ccall f_40103(C_word c,C_word *av) C_noret;
C_noret_decl(f_40123)
static void C_ccall f_40123(C_word c,C_word *av) C_noret;
C_noret_decl(f_40127)
static void C_ccall f_40127(C_word c,C_word *av) C_noret;
C_noret_decl(f_40130)
static void C_ccall f_40130(C_word c,C_word *av) C_noret;
C_noret_decl(f_40139)
static void C_ccall f_40139(C_word c,C_word *av) C_noret;
C_noret_decl(f_40141)
static void C_ccall f_40141(C_word c,C_word *av) C_noret;
C_noret_decl(f_40192)
static void C_ccall f_40192(C_word c,C_word *av) C_noret;
C_noret_decl(f_40217)
static void C_ccall f_40217(C_word c,C_word *av) C_noret;
C_noret_decl(f_40232)
static void C_ccall f_40232(C_word c,C_word *av) C_noret;
C_noret_decl(f_40242)
static void C_ccall f_40242(C_word c,C_word *av) C_noret;
C_noret_decl(f_40272)
static void C_ccall f_40272(C_word c,C_word *av) C_noret;
C_noret_decl(f_40300)
static void C_ccall f_40300(C_word c,C_word *av) C_noret;
C_noret_decl(f_40310)
static void C_ccall f_40310(C_word c,C_word *av) C_noret;
C_noret_decl(f_40315)
static void f_40315(C_word t0,C_word t1) C_noret;
C_noret_decl(f_40319)
static void C_ccall f_40319(C_word c,C_word *av) C_noret;
C_noret_decl(f_40325)
static void C_ccall f_40325(C_word c,C_word *av) C_noret;
C_noret_decl(f_40328)
static void C_ccall f_40328(C_word c,C_word *av) C_noret;
C_noret_decl(f_40335)
static void C_ccall f_40335(C_word c,C_word *av) C_noret;
C_noret_decl(f_40356)
static void C_ccall f_40356(C_word c,C_word *av) C_noret;
C_noret_decl(f_40366)
static void C_ccall f_40366(C_word c,C_word *av) C_noret;
C_noret_decl(f_40369)
static void C_ccall f_40369(C_word c,C_word *av) C_noret;
C_noret_decl(f_40383)
static void C_ccall f_40383(C_word c,C_word *av) C_noret;
C_noret_decl(f_40396)
static void C_ccall f_40396(C_word c,C_word *av) C_noret;
C_noret_decl(f_40414)
static void C_ccall f_40414(C_word c,C_word *av) C_noret;
C_noret_decl(f_40448)
static void C_ccall f_40448(C_word c,C_word *av) C_noret;
C_noret_decl(f_40451)
static void C_ccall f_40451(C_word c,C_word *av) C_noret;
C_noret_decl(f_40510)
static void C_ccall f_40510(C_word c,C_word *av) C_noret;
C_noret_decl(f_40518)
static void C_ccall f_40518(C_word c,C_word *av) C_noret;
C_noret_decl(f_40522)
static void C_ccall f_40522(C_word c,C_word *av) C_noret;
C_noret_decl(f_40526)
static void C_ccall f_40526(C_word c,C_word *av) C_noret;
C_noret_decl(f_40532)
static void C_ccall f_40532(C_word c,C_word *av) C_noret;
C_noret_decl(f_40536)
static void C_ccall f_40536(C_word c,C_word *av) C_noret;
C_noret_decl(f_40540)
static void C_ccall f_40540(C_word c,C_word *av) C_noret;
C_noret_decl(f_40562)
static void C_ccall f_40562(C_word c,C_word *av) C_noret;
C_noret_decl(f_40566)
static void C_ccall f_40566(C_word c,C_word *av) C_noret;
C_noret_decl(f_40570)
static void C_ccall f_40570(C_word c,C_word *av) C_noret;
C_noret_decl(f_40574)
static void C_ccall f_40574(C_word c,C_word *av) C_noret;
C_noret_decl(f_40578)
static void C_ccall f_40578(C_word c,C_word *av) C_noret;
C_noret_decl(f_40598)
static void C_ccall f_40598(C_word c,C_word *av) C_noret;
C_noret_decl(f_40606)
static void f_40606(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_40631)
static void C_ccall f_40631(C_word c,C_word *av) C_noret;
C_noret_decl(f_40648)
static void C_ccall f_40648(C_word c,C_word *av) C_noret;
C_noret_decl(f_40652)
static void C_ccall f_40652(C_word c,C_word *av) C_noret;
C_noret_decl(f_40655)
static void C_ccall f_40655(C_word c,C_word *av) C_noret;
C_noret_decl(f_40658)
static void C_ccall f_40658(C_word c,C_word *av) C_noret;
C_noret_decl(f_40668)
static void C_ccall f_40668(C_word c,C_word *av) C_noret;
C_noret_decl(f_40671)
static void C_ccall f_40671(C_word c,C_word *av) C_noret;
C_noret_decl(f_40673)
static void C_ccall f_40673(C_word c,C_word *av) C_noret;
C_noret_decl(f_40690)
static C_word f_40690(C_word t0);
C_noret_decl(f_40717)
static void C_ccall f_40717(C_word c,C_word *av) C_noret;
C_noret_decl(f_40726)
static void C_ccall f_40726(C_word c,C_word *av) C_noret;
C_noret_decl(f_40746)
static void C_ccall f_40746(C_word c,C_word *av) C_noret;
C_noret_decl(f_40750)
static void C_ccall f_40750(C_word c,C_word *av) C_noret;
C_noret_decl(f_40754)
static void C_ccall f_40754(C_word c,C_word *av) C_noret;
C_noret_decl(f_40758)
static void C_ccall f_40758(C_word c,C_word *av) C_noret;
C_noret_decl(f_40762)
static void C_ccall f_40762(C_word c,C_word *av) C_noret;
C_noret_decl(f_40766)
static void C_ccall f_40766(C_word c,C_word *av) C_noret;
C_noret_decl(f_40770)
static void C_ccall f_40770(C_word c,C_word *av) C_noret;
C_noret_decl(f_40772)
static void C_ccall f_40772(C_word c,C_word *av) C_noret;
C_noret_decl(f_40781)
static void C_ccall f_40781(C_word c,C_word *av) C_noret;
C_noret_decl(f_40791)
static void C_ccall f_40791(C_word c,C_word *av) C_noret;
C_noret_decl(f_40816)
static void C_ccall f_40816(C_word c,C_word *av) C_noret;
C_noret_decl(f_40819)
static void C_ccall f_40819(C_word c,C_word *av) C_noret;
C_noret_decl(f_40821)
static void C_ccall f_40821(C_word c,C_word *av) C_noret;
C_noret_decl(f_40837)
static void f_40837(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_40872)
static void C_ccall f_40872(C_word c,C_word *av) C_noret;
C_noret_decl(f_40896)
static void C_ccall f_40896(C_word c,C_word *av) C_noret;
C_noret_decl(f_40900)
static void C_ccall f_40900(C_word c,C_word *av) C_noret;
C_noret_decl(f_40902)
static void C_ccall f_40902(C_word c,C_word *av) C_noret;
C_noret_decl(f_40906)
static void C_ccall f_40906(C_word c,C_word *av) C_noret;
C_noret_decl(f_40909)
static void C_ccall f_40909(C_word c,C_word *av) C_noret;
C_noret_decl(f_40922)
static void C_ccall f_40922(C_word c,C_word *av) C_noret;
C_noret_decl(f_40927)
static void C_ccall f_40927(C_word c,C_word *av) C_noret;
C_noret_decl(f_40942)
static void C_ccall f_40942(C_word c,C_word *av) C_noret;
C_noret_decl(f_40946)
static void C_ccall f_40946(C_word c,C_word *av) C_noret;
C_noret_decl(f_40955)
static void C_ccall f_40955(C_word c,C_word *av) C_noret;
C_noret_decl(f_40958)
static void C_ccall f_40958(C_word c,C_word *av) C_noret;
C_noret_decl(f_40961)
static void C_ccall f_40961(C_word c,C_word *av) C_noret;
C_noret_decl(f_40964)
static void C_ccall f_40964(C_word c,C_word *av) C_noret;
C_noret_decl(f_40967)
static void C_ccall f_40967(C_word c,C_word *av) C_noret;
C_noret_decl(f_40969)
static void C_ccall f_40969(C_word c,C_word *av) C_noret;
C_noret_decl(f_40979)
static void C_ccall f_40979(C_word c,C_word *av) C_noret;
C_noret_decl(f_40991)
static void C_ccall f_40991(C_word c,C_word *av) C_noret;
C_noret_decl(f_40999)
static void f_40999(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_41009)
static void C_ccall f_41009(C_word c,C_word *av) C_noret;
C_noret_decl(f_41025)
static void C_ccall f_41025(C_word c,C_word *av) C_noret;
C_noret_decl(f_41031)
static void C_ccall f_41031(C_word c,C_word *av) C_noret;
C_noret_decl(f_41034)
static void C_ccall f_41034(C_word c,C_word *av) C_noret;
C_noret_decl(f_41037)
static void C_ccall f_41037(C_word c,C_word *av) C_noret;
C_noret_decl(f_41038)
static void f_41038(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_41042)
static void C_ccall f_41042(C_word c,C_word *av) C_noret;
C_noret_decl(f_41048)
static void C_ccall f_41048(C_word c,C_word *av) C_noret;
C_noret_decl(f_41052)
static void C_ccall f_41052(C_word c,C_word *av) C_noret;
C_noret_decl(f_41054)
static void f_41054(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_41064)
static void C_ccall f_41064(C_word c,C_word *av) C_noret;
C_noret_decl(f_41081)
static void C_ccall f_41081(C_word c,C_word *av) C_noret;
C_noret_decl(f_41084)
static void C_ccall f_41084(C_word c,C_word *av) C_noret;
C_noret_decl(f_41088)
static void C_ccall f_41088(C_word c,C_word *av) C_noret;
C_noret_decl(f_41093)
static void C_ccall f_41093(C_word c,C_word *av) C_noret;
C_noret_decl(f_41099)
static void C_ccall f_41099(C_word c,C_word *av) C_noret;
C_noret_decl(f_41115)
static void C_ccall f_41115(C_word c,C_word *av) C_noret;
C_noret_decl(f_41123)
static void C_ccall f_41123(C_word c,C_word *av) C_noret;
C_noret_decl(f_41145)
static void C_ccall f_41145(C_word c,C_word *av) C_noret;
C_noret_decl(f_41163)
static void C_ccall f_41163(C_word c,C_word *av) C_noret;
C_noret_decl(f_41167)
static void C_ccall f_41167(C_word c,C_word *av) C_noret;
C_noret_decl(f_41179)
static void C_ccall f_41179(C_word c,C_word *av) C_noret;
C_noret_decl(f_41186)
static void C_ccall f_41186(C_word c,C_word *av) C_noret;
C_noret_decl(f_41201)
static void C_ccall f_41201(C_word c,C_word *av) C_noret;
C_noret_decl(f_41204)
static void C_ccall f_41204(C_word c,C_word *av) C_noret;
C_noret_decl(f_41207)
static void C_ccall f_41207(C_word c,C_word *av) C_noret;
C_noret_decl(f_41220)
static void f_41220(C_word t0,C_word t1) C_noret;
C_noret_decl(f_41243)
static void C_ccall f_41243(C_word c,C_word *av) C_noret;
C_noret_decl(f_41267)
static void C_ccall f_41267(C_word c,C_word *av) C_noret;
C_noret_decl(f_41277)
static void C_ccall f_41277(C_word c,C_word *av) C_noret;
C_noret_decl(f_41286)
static void C_ccall f_41286(C_word c,C_word *av) C_noret;
C_noret_decl(f_41327)
static void C_ccall f_41327(C_word c,C_word *av) C_noret;
C_noret_decl(f_41349)
static void C_ccall f_41349(C_word c,C_word *av) C_noret;
C_noret_decl(f_41358)
static void C_ccall f_41358(C_word c,C_word *av) C_noret;
C_noret_decl(f_41362)
static void C_ccall f_41362(C_word c,C_word *av) C_noret;
C_noret_decl(f_41367)
static void C_ccall f_41367(C_word c,C_word *av) C_noret;
C_noret_decl(f_41377)
static void C_ccall f_41377(C_word c,C_word *av) C_noret;
C_noret_decl(f_41387)
static void C_ccall f_41387(C_word c,C_word *av) C_noret;
C_noret_decl(f_41397)
static void C_ccall f_41397(C_word c,C_word *av) C_noret;
C_noret_decl(f_41407)
static void C_ccall f_41407(C_word c,C_word *av) C_noret;
C_noret_decl(f_41417)
static void C_ccall f_41417(C_word c,C_word *av) C_noret;
C_noret_decl(f_41427)
static void C_ccall f_41427(C_word c,C_word *av) C_noret;
C_noret_decl(f_41437)
static void C_ccall f_41437(C_word c,C_word *av) C_noret;
C_noret_decl(f_41447)
static void C_ccall f_41447(C_word c,C_word *av) C_noret;
C_noret_decl(f_41457)
static void C_ccall f_41457(C_word c,C_word *av) C_noret;
C_noret_decl(f_41467)
static void C_ccall f_41467(C_word c,C_word *av) C_noret;
C_noret_decl(f_41477)
static void C_ccall f_41477(C_word c,C_word *av) C_noret;
C_noret_decl(f_41487)
static void C_ccall f_41487(C_word c,C_word *av) C_noret;
C_noret_decl(f_41497)
static void C_ccall f_41497(C_word c,C_word *av) C_noret;
C_noret_decl(f_41513)
static void C_ccall f_41513(C_word c,C_word *av) C_noret;
C_noret_decl(f_41521)
static void C_ccall f_41521(C_word c,C_word *av) C_noret;
C_noret_decl(f_41537)
static void C_ccall f_41537(C_word c,C_word *av) C_noret;
C_noret_decl(f_41553)
static void C_ccall f_41553(C_word c,C_word *av) C_noret;
C_noret_decl(f_41563)
static void C_ccall f_41563(C_word c,C_word *av) C_noret;
C_noret_decl(f_41573)
static void C_ccall f_41573(C_word c,C_word *av) C_noret;
C_noret_decl(f_41592)
static void C_ccall f_41592(C_word c,C_word *av) C_noret;
C_noret_decl(f_41608)
static void C_ccall f_41608(C_word c,C_word *av) C_noret;
C_noret_decl(f_41621)
static void C_ccall f_41621(C_word c,C_word *av) C_noret;
C_noret_decl(f_41627)
static void C_ccall f_41627(C_word c,C_word *av) C_noret;
C_noret_decl(f_41659)
static void C_ccall f_41659(C_word c,C_word *av) C_noret;
C_noret_decl(f_41675)
static void C_ccall f_41675(C_word c,C_word *av) C_noret;
C_noret_decl(f_41679)
static void C_ccall f_41679(C_word c,C_word *av) C_noret;
C_noret_decl(f_41689)
static void C_ccall f_41689(C_word c,C_word *av) C_noret;
C_noret_decl(f_41695)
static void C_ccall f_41695(C_word c,C_word *av) C_noret;
C_noret_decl(f_41702)
static void C_ccall f_41702(C_word c,C_word *av) C_noret;
C_noret_decl(f_41720)
static void C_ccall f_41720(C_word c,C_word *av) C_noret;
C_noret_decl(f_41724)
static void C_ccall f_41724(C_word c,C_word *av) C_noret;
C_noret_decl(f_41732)
static void C_ccall f_41732(C_word c,C_word *av) C_noret;
C_noret_decl(f_41735)
static void C_ccall f_41735(C_word c,C_word *av) C_noret;
C_noret_decl(f_41748)
static void C_ccall f_41748(C_word c,C_word *av) C_noret;
C_noret_decl(f_41751)
static void C_ccall f_41751(C_word c,C_word *av) C_noret;
C_noret_decl(f_41763)
static void C_ccall f_41763(C_word c,C_word *av) C_noret;
C_noret_decl(f_41777)
static void C_ccall f_41777(C_word c,C_word *av) C_noret;
C_noret_decl(f_41780)
static void C_ccall f_41780(C_word c,C_word *av) C_noret;
C_noret_decl(f_41786)
static void C_ccall f_41786(C_word c,C_word *av) C_noret;
C_noret_decl(f_41789)
static void C_ccall f_41789(C_word c,C_word *av) C_noret;
C_noret_decl(f_41792)
static void C_ccall f_41792(C_word c,C_word *av) C_noret;
C_noret_decl(f_41799)
static void f_41799(C_word t0,C_word t1) C_noret;
C_noret_decl(f_41808)
static void f_41808(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_41824)
static void C_ccall f_41824(C_word c,C_word *av) C_noret;
C_noret_decl(f_41835)
static void C_ccall f_41835(C_word c,C_word *av) C_noret;
C_noret_decl(f_41846)
static void C_ccall f_41846(C_word c,C_word *av) C_noret;
C_noret_decl(f_41850)
static void C_ccall f_41850(C_word c,C_word *av) C_noret;
C_noret_decl(f_41899)
static void C_ccall f_41899(C_word c,C_word *av) C_noret;
C_noret_decl(f_41906)
static void f_41906(C_word t0,C_word t1) C_noret;
C_noret_decl(f_41919)
static void f_41919(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_41941)
static void C_ccall f_41941(C_word c,C_word *av) C_noret;
C_noret_decl(f_41965)
static void C_ccall f_41965(C_word c,C_word *av) C_noret;
C_noret_decl(f_41969)
static void C_ccall f_41969(C_word c,C_word *av) C_noret;
C_noret_decl(f_41986)
static void C_ccall f_41986(C_word c,C_word *av) C_noret;
C_noret_decl(f_42000)
static void C_ccall f_42000(C_word c,C_word *av) C_noret;
C_noret_decl(f_42008)
static void C_ccall f_42008(C_word c,C_word *av) C_noret;
C_noret_decl(f_42012)
static void C_ccall f_42012(C_word c,C_word *av) C_noret;
C_noret_decl(f_42027)
static void C_ccall f_42027(C_word c,C_word *av) C_noret;
C_noret_decl(f_42031)
static void C_ccall f_42031(C_word c,C_word *av) C_noret;
C_noret_decl(f_42045)
static void C_ccall f_42045(C_word c,C_word *av) C_noret;
C_noret_decl(f_42085)
static void C_ccall f_42085(C_word c,C_word *av) C_noret;
C_noret_decl(C_library_toplevel)
C_extern void C_ccall C_library_toplevel(C_word c,C_word *av) C_noret;

C_noret_decl(trf_11845)
static void C_ccall trf_11845(C_word c,C_word *av) C_noret;
static void C_ccall trf_11845(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_11845(t0,t1,t2,t3);}

C_noret_decl(trf_11896)
static void C_ccall trf_11896(C_word c,C_word *av) C_noret;
static void C_ccall trf_11896(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_11896(t0,t1,t2);}

C_noret_decl(trf_11946)
static void C_ccall trf_11946(C_word c,C_word *av) C_noret;
static void C_ccall trf_11946(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_11946(t0,t1,t2);}

C_noret_decl(trf_12719)
static void C_ccall trf_12719(C_word c,C_word *av) C_noret;
static void C_ccall trf_12719(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_12719(t0,t1,t2,t3);}

C_noret_decl(trf_12756)
static void C_ccall trf_12756(C_word c,C_word *av) C_noret;
static void C_ccall trf_12756(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_12756(t0,t1,t2);}

C_noret_decl(trf_12842)
static void C_ccall trf_12842(C_word c,C_word *av) C_noret;
static void C_ccall trf_12842(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_12842(t0,t1,t2);}

C_noret_decl(trf_12875)
static void C_ccall trf_12875(C_word c,C_word *av) C_noret;
static void C_ccall trf_12875(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_12875(t0,t1,t2);}

C_noret_decl(trf_12993)
static void C_ccall trf_12993(C_word c,C_word *av) C_noret;
static void C_ccall trf_12993(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_12993(t0,t1,t2);}

C_noret_decl(trf_13028)
static void C_ccall trf_13028(C_word c,C_word *av) C_noret;
static void C_ccall trf_13028(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_13028(t0,t1,t2);}

C_noret_decl(trf_13092)
static void C_ccall trf_13092(C_word c,C_word *av) C_noret;
static void C_ccall trf_13092(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_13092(t0,t1,t2);}

C_noret_decl(trf_13166)
static void C_ccall trf_13166(C_word c,C_word *av) C_noret;
static void C_ccall trf_13166(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_13166(t0,t1,t2);}

C_noret_decl(trf_13202)
static void C_ccall trf_13202(C_word c,C_word *av) C_noret;
static void C_ccall trf_13202(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_13202(t0,t1,t2);}

C_noret_decl(trf_13231)
static void C_ccall trf_13231(C_word c,C_word *av) C_noret;
static void C_ccall trf_13231(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_13231(t0,t1,t2,t3);}

C_noret_decl(trf_13278)
static void C_ccall trf_13278(C_word c,C_word *av) C_noret;
static void C_ccall trf_13278(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_13278(t0,t1,t2);}

C_noret_decl(trf_13332)
static void C_ccall trf_13332(C_word c,C_word *av) C_noret;
static void C_ccall trf_13332(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_13332(t0,t1,t2,t3);}

C_noret_decl(trf_13436)
static void C_ccall trf_13436(C_word c,C_word *av) C_noret;
static void C_ccall trf_13436(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_13436(t0,t1);}

C_noret_decl(trf_13474)
static void C_ccall trf_13474(C_word c,C_word *av) C_noret;
static void C_ccall trf_13474(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_13474(t0,t1,t2);}

C_noret_decl(trf_13524)
static void C_ccall trf_13524(C_word c,C_word *av) C_noret;
static void C_ccall trf_13524(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_13524(t0,t1,t2);}

C_noret_decl(trf_13635)
static void C_ccall trf_13635(C_word c,C_word *av) C_noret;
static void C_ccall trf_13635(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_13635(t0,t1);}

C_noret_decl(trf_13666)
static void C_ccall trf_13666(C_word c,C_word *av) C_noret;
static void C_ccall trf_13666(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_13666(t0,t1,t2);}

C_noret_decl(trf_13743)
static void C_ccall trf_13743(C_word c,C_word *av) C_noret;
static void C_ccall trf_13743(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_13743(t0,t1,t2);}

C_noret_decl(trf_13937)
static void C_ccall trf_13937(C_word c,C_word *av) C_noret;
static void C_ccall trf_13937(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_13937(t0,t1,t2,t3,t4);}

C_noret_decl(trf_13941)
static void C_ccall trf_13941(C_word c,C_word *av) C_noret;
static void C_ccall trf_13941(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_13941(t0,t1);}

C_noret_decl(trf_14000)
static void C_ccall trf_14000(C_word c,C_word *av) C_noret;
static void C_ccall trf_14000(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_14000(t0,t1);}

C_noret_decl(trf_14623)
static void C_ccall trf_14623(C_word c,C_word *av) C_noret;
static void C_ccall trf_14623(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_14623(t0,t1,t2,t3);}

C_noret_decl(trf_14672)
static void C_ccall trf_14672(C_word c,C_word *av) C_noret;
static void C_ccall trf_14672(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_14672(t0,t1);}

C_noret_decl(trf_14879)
static void C_ccall trf_14879(C_word c,C_word *av) C_noret;
static void C_ccall trf_14879(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_14879(t0,t1,t2);}

C_noret_decl(trf_14898)
static void C_ccall trf_14898(C_word c,C_word *av) C_noret;
static void C_ccall trf_14898(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_14898(t0,t1,t2);}

C_noret_decl(trf_14952)
static void C_ccall trf_14952(C_word c,C_word *av) C_noret;
static void C_ccall trf_14952(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_14952(t0,t1,t2,t3);}

C_noret_decl(trf_15156)
static void C_ccall trf_15156(C_word c,C_word *av) C_noret;
static void C_ccall trf_15156(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_15156(t0,t1);}

C_noret_decl(trf_15258)
static void C_ccall trf_15258(C_word c,C_word *av) C_noret;
static void C_ccall trf_15258(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_15258(t0,t1,t2,t3);}

C_noret_decl(trf_15369)
static void C_ccall trf_15369(C_word c,C_word *av) C_noret;
static void C_ccall trf_15369(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_15369(t0,t1,t2,t3);}

C_noret_decl(trf_15444)
static void C_ccall trf_15444(C_word c,C_word *av) C_noret;
static void C_ccall trf_15444(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_15444(t0,t1,t2,t3,t4);}

C_noret_decl(trf_15497)
static void C_ccall trf_15497(C_word c,C_word *av) C_noret;
static void C_ccall trf_15497(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_15497(t0,t1,t2,t3,t4);}

C_noret_decl(trf_15562)
static void C_ccall trf_15562(C_word c,C_word *av) C_noret;
static void C_ccall trf_15562(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_15562(t0,t1);}

C_noret_decl(trf_15678)
static void C_ccall trf_15678(C_word c,C_word *av) C_noret;
static void C_ccall trf_15678(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_15678(t0,t1);}

C_noret_decl(trf_15908)
static void C_ccall trf_15908(C_word c,C_word *av) C_noret;
static void C_ccall trf_15908(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_15908(t0,t1);}

C_noret_decl(trf_15915)
static void C_ccall trf_15915(C_word c,C_word *av) C_noret;
static void C_ccall trf_15915(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_15915(t0,t1);}

C_noret_decl(trf_15943)
static void C_ccall trf_15943(C_word c,C_word *av) C_noret;
static void C_ccall trf_15943(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_15943(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_15965)
static void C_ccall trf_15965(C_word c,C_word *av) C_noret;
static void C_ccall trf_15965(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_15965(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_16101)
static void C_ccall trf_16101(C_word c,C_word *av) C_noret;
static void C_ccall trf_16101(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_16101(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_16123)
static void C_ccall trf_16123(C_word c,C_word *av) C_noret;
static void C_ccall trf_16123(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_16123(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_16304)
static void C_ccall trf_16304(C_word c,C_word *av) C_noret;
static void C_ccall trf_16304(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_16304(t0,t1,t2,t3,t4);}

C_noret_decl(trf_16383)
static void C_ccall trf_16383(C_word c,C_word *av) C_noret;
static void C_ccall trf_16383(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_16383(t0,t1,t2,t3);}

C_noret_decl(trf_16404)
static void C_ccall trf_16404(C_word c,C_word *av) C_noret;
static void C_ccall trf_16404(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_16404(t0,t1,t2,t3,t4);}

C_noret_decl(trf_16566)
static void C_ccall trf_16566(C_word c,C_word *av) C_noret;
static void C_ccall trf_16566(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_16566(t0,t1);}

C_noret_decl(trf_17262)
static void C_ccall trf_17262(C_word c,C_word *av) C_noret;
static void C_ccall trf_17262(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_17262(t0,t1,t2);}

C_noret_decl(trf_17621)
static void C_ccall trf_17621(C_word c,C_word *av) C_noret;
static void C_ccall trf_17621(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_17621(t0,t1,t2,t3);}

C_noret_decl(trf_17638)
static void C_ccall trf_17638(C_word c,C_word *av) C_noret;
static void C_ccall trf_17638(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_17638(t0,t1,t2,t3);}

C_noret_decl(trf_17803)
static void C_ccall trf_17803(C_word c,C_word *av) C_noret;
static void C_ccall trf_17803(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_17803(t0,t1,t2,t3);}

C_noret_decl(trf_18285)
static void C_ccall trf_18285(C_word c,C_word *av) C_noret;
static void C_ccall trf_18285(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_18285(t0,t1,t2);}

C_noret_decl(trf_18288)
static void C_ccall trf_18288(C_word c,C_word *av) C_noret;
static void C_ccall trf_18288(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_18288(t0,t1,t2,t3);}

C_noret_decl(trf_18467)
static void C_ccall trf_18467(C_word c,C_word *av) C_noret;
static void C_ccall trf_18467(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_18467(t0,t1,t2,t3,t4);}

C_noret_decl(trf_18511)
static void C_ccall trf_18511(C_word c,C_word *av) C_noret;
static void C_ccall trf_18511(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_18511(t0,t1,t2,t3,t4);}

C_noret_decl(trf_18774)
static void C_ccall trf_18774(C_word c,C_word *av) C_noret;
static void C_ccall trf_18774(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_18774(t0,t1);}

C_noret_decl(trf_18780)
static void C_ccall trf_18780(C_word c,C_word *av) C_noret;
static void C_ccall trf_18780(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_18780(t0,t1);}

C_noret_decl(trf_18836)
static void C_ccall trf_18836(C_word c,C_word *av) C_noret;
static void C_ccall trf_18836(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_18836(t0,t1);}

C_noret_decl(trf_18842)
static void C_ccall trf_18842(C_word c,C_word *av) C_noret;
static void C_ccall trf_18842(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_18842(t0,t1);}

C_noret_decl(trf_19407)
static void C_ccall trf_19407(C_word c,C_word *av) C_noret;
static void C_ccall trf_19407(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_19407(t0,t1);}

C_noret_decl(trf_19442)
static void C_ccall trf_19442(C_word c,C_word *av) C_noret;
static void C_ccall trf_19442(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_19442(t0,t1,t2,t3);}

C_noret_decl(trf_19552)
static void C_ccall trf_19552(C_word c,C_word *av) C_noret;
static void C_ccall trf_19552(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_19552(t0,t1,t2,t3);}

C_noret_decl(trf_19594)
static void C_ccall trf_19594(C_word c,C_word *av) C_noret;
static void C_ccall trf_19594(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_19594(t0,t1,t2);}

C_noret_decl(trf_19608)
static void C_ccall trf_19608(C_word c,C_word *av) C_noret;
static void C_ccall trf_19608(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_19608(t0,t1,t2);}

C_noret_decl(trf_19762)
static void C_ccall trf_19762(C_word c,C_word *av) C_noret;
static void C_ccall trf_19762(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_19762(t0,t1);}

C_noret_decl(trf_19858)
static void C_ccall trf_19858(C_word c,C_word *av) C_noret;
static void C_ccall trf_19858(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_19858(t0,t1,t2,t3);}

C_noret_decl(trf_19954)
static void C_ccall trf_19954(C_word c,C_word *av) C_noret;
static void C_ccall trf_19954(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_19954(t0,t1,t2,t3);}

C_noret_decl(trf_20019)
static void C_ccall trf_20019(C_word c,C_word *av) C_noret;
static void C_ccall trf_20019(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_20019(t0,t1,t2,t3);}

C_noret_decl(trf_20220)
static void C_ccall trf_20220(C_word c,C_word *av) C_noret;
static void C_ccall trf_20220(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20220(t0,t1);}

C_noret_decl(trf_20281)
static void C_ccall trf_20281(C_word c,C_word *av) C_noret;
static void C_ccall trf_20281(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20281(t0,t1,t2);}

C_noret_decl(trf_20324)
static void C_ccall trf_20324(C_word c,C_word *av) C_noret;
static void C_ccall trf_20324(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_20324(t0,t1,t2,t3,t4);}

C_noret_decl(trf_20342)
static void C_ccall trf_20342(C_word c,C_word *av) C_noret;
static void C_ccall trf_20342(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_20342(t0,t1,t2,t3);}

C_noret_decl(trf_20422)
static void C_ccall trf_20422(C_word c,C_word *av) C_noret;
static void C_ccall trf_20422(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20422(t0,t1,t2);}

C_noret_decl(trf_20428)
static void C_ccall trf_20428(C_word c,C_word *av) C_noret;
static void C_ccall trf_20428(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20428(t0,t1,t2);}

C_noret_decl(trf_20488)
static void C_ccall trf_20488(C_word c,C_word *av) C_noret;
static void C_ccall trf_20488(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20488(t0,t1);}

C_noret_decl(trf_20526)
static void C_ccall trf_20526(C_word c,C_word *av) C_noret;
static void C_ccall trf_20526(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20526(t0,t1,t2);}

C_noret_decl(trf_20532)
static void C_ccall trf_20532(C_word c,C_word *av) C_noret;
static void C_ccall trf_20532(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20532(t0,t1,t2);}

C_noret_decl(trf_20574)
static void C_ccall trf_20574(C_word c,C_word *av) C_noret;
static void C_ccall trf_20574(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_20574(t0,t1,t2,t3,t4);}

C_noret_decl(trf_20630)
static void C_ccall trf_20630(C_word c,C_word *av) C_noret;
static void C_ccall trf_20630(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_20630(t0,t1,t2);}

C_noret_decl(trf_20643)
static void C_ccall trf_20643(C_word c,C_word *av) C_noret;
static void C_ccall trf_20643(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20643(t0,t1);}

C_noret_decl(trf_20683)
static void C_ccall trf_20683(C_word c,C_word *av) C_noret;
static void C_ccall trf_20683(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_20683(t0,t1,t2,t3,t4);}

C_noret_decl(trf_20702)
static void C_ccall trf_20702(C_word c,C_word *av) C_noret;
static void C_ccall trf_20702(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20702(t0,t1);}

C_noret_decl(trf_20714)
static void C_ccall trf_20714(C_word c,C_word *av) C_noret;
static void C_ccall trf_20714(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20714(t0,t1);}

C_noret_decl(trf_20741)
static void C_ccall trf_20741(C_word c,C_word *av) C_noret;
static void C_ccall trf_20741(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20741(t0,t1);}

C_noret_decl(trf_20895)
static void C_ccall trf_20895(C_word c,C_word *av) C_noret;
static void C_ccall trf_20895(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_20895(t0,t1,t2,t3);}

C_noret_decl(trf_20902)
static void C_ccall trf_20902(C_word c,C_word *av) C_noret;
static void C_ccall trf_20902(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20902(t0,t1);}

C_noret_decl(trf_20973)
static void C_ccall trf_20973(C_word c,C_word *av) C_noret;
static void C_ccall trf_20973(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_20973(t0,t1);}

C_noret_decl(trf_21237)
static void C_ccall trf_21237(C_word c,C_word *av) C_noret;
static void C_ccall trf_21237(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_21237(t0,t1,t2);}

C_noret_decl(trf_21250)
static void C_ccall trf_21250(C_word c,C_word *av) C_noret;
static void C_ccall trf_21250(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21250(t0,t1);}

C_noret_decl(trf_21305)
static void C_ccall trf_21305(C_word c,C_word *av) C_noret;
static void C_ccall trf_21305(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_21305(t0,t1);}

C_noret_decl(trf_21724)
static void C_ccall trf_21724(C_word c,C_word *av) C_noret;
static void C_ccall trf_21724(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_21724(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_22005)
static void C_ccall trf_22005(C_word c,C_word *av) C_noret;
static void C_ccall trf_22005(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_22005(t0,t1,t2,t3,t4);}

C_noret_decl(trf_22032)
static void C_ccall trf_22032(C_word c,C_word *av) C_noret;
static void C_ccall trf_22032(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_22032(t0,t1,t2);}

C_noret_decl(trf_22073)
static void C_ccall trf_22073(C_word c,C_word *av) C_noret;
static void C_ccall trf_22073(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_22073(t0,t1,t2,t3);}

C_noret_decl(trf_22347)
static void C_ccall trf_22347(C_word c,C_word *av) C_noret;
static void C_ccall trf_22347(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_22347(t0,t1,t2);}

C_noret_decl(trf_22459)
static void C_ccall trf_22459(C_word c,C_word *av) C_noret;
static void C_ccall trf_22459(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_22459(t0,t1,t2,t3);}

C_noret_decl(trf_22492)
static void C_ccall trf_22492(C_word c,C_word *av) C_noret;
static void C_ccall trf_22492(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_22492(t0,t1,t2,t3);}

C_noret_decl(trf_22739)
static void C_ccall trf_22739(C_word c,C_word *av) C_noret;
static void C_ccall trf_22739(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_22739(t0,t1);}

C_noret_decl(trf_22823)
static void C_ccall trf_22823(C_word c,C_word *av) C_noret;
static void C_ccall trf_22823(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_22823(t0,t1);}

C_noret_decl(trf_22877)
static void C_ccall trf_22877(C_word c,C_word *av) C_noret;
static void C_ccall trf_22877(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_22877(t0,t1,t2,t3);}

C_noret_decl(trf_23040)
static void C_ccall trf_23040(C_word c,C_word *av) C_noret;
static void C_ccall trf_23040(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_23040(t0,t1,t2);}

C_noret_decl(trf_23200)
static void C_ccall trf_23200(C_word c,C_word *av) C_noret;
static void C_ccall trf_23200(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_23200(t0,t1,t2,t3);}

C_noret_decl(trf_23310)
static void C_ccall trf_23310(C_word c,C_word *av) C_noret;
static void C_ccall trf_23310(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_23310(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_23486)
static void C_ccall trf_23486(C_word c,C_word *av) C_noret;
static void C_ccall trf_23486(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_23486(t0,t1,t2,t3,t4);}

C_noret_decl(trf_23550)
static void C_ccall trf_23550(C_word c,C_word *av) C_noret;
static void C_ccall trf_23550(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_23550(t0,t1,t2);}

C_noret_decl(trf_23691)
static void C_ccall trf_23691(C_word c,C_word *av) C_noret;
static void C_ccall trf_23691(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_23691(t0,t1,t2,t3);}

C_noret_decl(trf_23746)
static void C_ccall trf_23746(C_word c,C_word *av) C_noret;
static void C_ccall trf_23746(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_23746(t0,t1,t2,t3,t4);}

C_noret_decl(trf_23793)
static void C_ccall trf_23793(C_word c,C_word *av) C_noret;
static void C_ccall trf_23793(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_23793(t0,t1,t2,t3,t4);}

C_noret_decl(trf_23836)
static void C_ccall trf_23836(C_word c,C_word *av) C_noret;
static void C_ccall trf_23836(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_23836(t0,t1,t2,t3,t4);}

C_noret_decl(trf_23879)
static void C_ccall trf_23879(C_word c,C_word *av) C_noret;
static void C_ccall trf_23879(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_23879(t0,t1,t2,t3,t4);}

C_noret_decl(trf_23922)
static void C_ccall trf_23922(C_word c,C_word *av) C_noret;
static void C_ccall trf_23922(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_23922(t0,t1,t2,t3,t4);}

C_noret_decl(trf_23955)
static void C_ccall trf_23955(C_word c,C_word *av) C_noret;
static void C_ccall trf_23955(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_23955(t0,t1,t2);}

C_noret_decl(trf_24163)
static void C_ccall trf_24163(C_word c,C_word *av) C_noret;
static void C_ccall trf_24163(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24163(t0,t1,t2);}

C_noret_decl(trf_24201)
static void C_ccall trf_24201(C_word c,C_word *av) C_noret;
static void C_ccall trf_24201(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24201(t0,t1,t2);}

C_noret_decl(trf_24249)
static void C_ccall trf_24249(C_word c,C_word *av) C_noret;
static void C_ccall trf_24249(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24249(t0,t1,t2);}

C_noret_decl(trf_24310)
static void C_ccall trf_24310(C_word c,C_word *av) C_noret;
static void C_ccall trf_24310(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24310(t0,t1,t2);}

C_noret_decl(trf_24340)
static void C_ccall trf_24340(C_word c,C_word *av) C_noret;
static void C_ccall trf_24340(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24340(t0,t1,t2);}

C_noret_decl(trf_24395)
static void C_ccall trf_24395(C_word c,C_word *av) C_noret;
static void C_ccall trf_24395(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24395(t0,t1,t2);}

C_noret_decl(trf_24436)
static void C_ccall trf_24436(C_word c,C_word *av) C_noret;
static void C_ccall trf_24436(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24436(t0,t1,t2);}

C_noret_decl(trf_24550)
static void C_ccall trf_24550(C_word c,C_word *av) C_noret;
static void C_ccall trf_24550(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24550(t0,t1,t2);}

C_noret_decl(trf_24940)
static void C_ccall trf_24940(C_word c,C_word *av) C_noret;
static void C_ccall trf_24940(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_24940(t0,t1,t2,t3,t4);}

C_noret_decl(trf_24990)
static void C_ccall trf_24990(C_word c,C_word *av) C_noret;
static void C_ccall trf_24990(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_24990(t0,t1,t2);}

C_noret_decl(trf_25047)
static void C_ccall trf_25047(C_word c,C_word *av) C_noret;
static void C_ccall trf_25047(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_25047(t0,t1);}

C_noret_decl(trf_25057)
static void C_ccall trf_25057(C_word c,C_word *av) C_noret;
static void C_ccall trf_25057(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_25057(t0,t1);}

C_noret_decl(trf_25170)
static void C_ccall trf_25170(C_word c,C_word *av) C_noret;
static void C_ccall trf_25170(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_25170(t0,t1,t2,t3);}

C_noret_decl(trf_25426)
static void C_ccall trf_25426(C_word c,C_word *av) C_noret;
static void C_ccall trf_25426(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_25426(t0,t1,t2);}

C_noret_decl(trf_25439)
static void C_ccall trf_25439(C_word c,C_word *av) C_noret;
static void C_ccall trf_25439(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_25439(t0,t1,t2);}

C_noret_decl(trf_25498)
static void C_ccall trf_25498(C_word c,C_word *av) C_noret;
static void C_ccall trf_25498(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_25498(t0,t1,t2);}

C_noret_decl(trf_25768)
static void C_ccall trf_25768(C_word c,C_word *av) C_noret;
static void C_ccall trf_25768(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_25768(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_25772)
static void C_ccall trf_25772(C_word c,C_word *av) C_noret;
static void C_ccall trf_25772(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_25772(t0,t1);}

C_noret_decl(trf_25802)
static void C_ccall trf_25802(C_word c,C_word *av) C_noret;
static void C_ccall trf_25802(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_25802(t0,t1);}

C_noret_decl(trf_25822)
static void C_ccall trf_25822(C_word c,C_word *av) C_noret;
static void C_ccall trf_25822(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_25822(t0,t1,t2,t3);}

C_noret_decl(trf_25831)
static void C_ccall trf_25831(C_word c,C_word *av) C_noret;
static void C_ccall trf_25831(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_25831(t0,t1,t2);}

C_noret_decl(trf_25836)
static void C_ccall trf_25836(C_word c,C_word *av) C_noret;
static void C_ccall trf_25836(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_25836(t0,t1);}

C_noret_decl(trf_26205)
static void C_ccall trf_26205(C_word c,C_word *av) C_noret;
static void C_ccall trf_26205(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_26205(t0,t1,t2,t3,t4);}

C_noret_decl(trf_26214)
static void C_ccall trf_26214(C_word c,C_word *av) C_noret;
static void C_ccall trf_26214(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26214(t0,t1);}

C_noret_decl(trf_26224)
static void C_ccall trf_26224(C_word c,C_word *av) C_noret;
static void C_ccall trf_26224(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26224(t0,t1,t2);}

C_noret_decl(trf_26251)
static void C_ccall trf_26251(C_word c,C_word *av) C_noret;
static void C_ccall trf_26251(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26251(t0,t1,t2);}

C_noret_decl(trf_26260)
static void C_ccall trf_26260(C_word c,C_word *av) C_noret;
static void C_ccall trf_26260(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26260(t0,t1,t2);}

C_noret_decl(trf_26286)
static void C_ccall trf_26286(C_word c,C_word *av) C_noret;
static void C_ccall trf_26286(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_26286(t0,t1,t2,t3);}

C_noret_decl(trf_26314)
static void C_ccall trf_26314(C_word c,C_word *av) C_noret;
static void C_ccall trf_26314(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_26314(t0,t1,t2,t3);}

C_noret_decl(trf_26320)
static void C_ccall trf_26320(C_word c,C_word *av) C_noret;
static void C_ccall trf_26320(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26320(t0,t1,t2);}

C_noret_decl(trf_26395)
static void C_ccall trf_26395(C_word c,C_word *av) C_noret;
static void C_ccall trf_26395(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26395(t0,t1,t2);}

C_noret_decl(trf_26434)
static void C_ccall trf_26434(C_word c,C_word *av) C_noret;
static void C_ccall trf_26434(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26434(t0,t1);}

C_noret_decl(trf_26437)
static void C_ccall trf_26437(C_word c,C_word *av) C_noret;
static void C_ccall trf_26437(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26437(t0,t1);}

C_noret_decl(trf_26447)
static void C_ccall trf_26447(C_word c,C_word *av) C_noret;
static void C_ccall trf_26447(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26447(t0,t1,t2);}

C_noret_decl(trf_26485)
static void C_ccall trf_26485(C_word c,C_word *av) C_noret;
static void C_ccall trf_26485(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_26485(t0,t1,t2,t3,t4);}

C_noret_decl(trf_26491)
static void C_ccall trf_26491(C_word c,C_word *av) C_noret;
static void C_ccall trf_26491(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_26491(t0,t1,t2,t3);}

C_noret_decl(trf_26545)
static void C_ccall trf_26545(C_word c,C_word *av) C_noret;
static void C_ccall trf_26545(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26545(t0,t1,t2);}

C_noret_decl(trf_26548)
static void C_ccall trf_26548(C_word c,C_word *av) C_noret;
static void C_ccall trf_26548(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26548(t0,t1,t2);}

C_noret_decl(trf_26571)
static void C_ccall trf_26571(C_word c,C_word *av) C_noret;
static void C_ccall trf_26571(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26571(t0,t1);}

C_noret_decl(trf_26580)
static void C_ccall trf_26580(C_word c,C_word *av) C_noret;
static void C_ccall trf_26580(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26580(t0,t1,t2);}

C_noret_decl(trf_26635)
static void C_ccall trf_26635(C_word c,C_word *av) C_noret;
static void C_ccall trf_26635(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26635(t0,t1);}

C_noret_decl(trf_26685)
static void C_ccall trf_26685(C_word c,C_word *av) C_noret;
static void C_ccall trf_26685(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_26685(t0,t1,t2);}

C_noret_decl(trf_26695)
static void C_ccall trf_26695(C_word c,C_word *av) C_noret;
static void C_ccall trf_26695(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_26695(t0,t1,t2,t3);}

C_noret_decl(trf_26912)
static void C_ccall trf_26912(C_word c,C_word *av) C_noret;
static void C_ccall trf_26912(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26912(t0,t1);}

C_noret_decl(trf_26932)
static void C_ccall trf_26932(C_word c,C_word *av) C_noret;
static void C_ccall trf_26932(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_26932(t0,t1);}

C_noret_decl(trf_26937)
static void C_ccall trf_26937(C_word c,C_word *av) C_noret;
static void C_ccall trf_26937(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_26937(t0,t1,t2,t3);}

C_noret_decl(trf_27036)
static void C_ccall trf_27036(C_word c,C_word *av) C_noret;
static void C_ccall trf_27036(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_27036(t0,t1);}

C_noret_decl(trf_27184)
static void C_ccall trf_27184(C_word c,C_word *av) C_noret;
static void C_ccall trf_27184(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_27184(t0,t1,t2,t3);}

C_noret_decl(trf_27193)
static void C_ccall trf_27193(C_word c,C_word *av) C_noret;
static void C_ccall trf_27193(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27193(t0,t1,t2);}

C_noret_decl(trf_27248)
static void C_ccall trf_27248(C_word c,C_word *av) C_noret;
static void C_ccall trf_27248(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27248(t0,t1,t2);}

C_noret_decl(trf_27255)
static void C_ccall trf_27255(C_word c,C_word *av) C_noret;
static void C_ccall trf_27255(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_27255(t0,t1);}

C_noret_decl(trf_27298)
static void C_ccall trf_27298(C_word c,C_word *av) C_noret;
static void C_ccall trf_27298(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_27298(t0,t1);}

C_noret_decl(trf_27445)
static void C_ccall trf_27445(C_word c,C_word *av) C_noret;
static void C_ccall trf_27445(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_27445(t0,t1);}

C_noret_decl(trf_27463)
static void C_ccall trf_27463(C_word c,C_word *av) C_noret;
static void C_ccall trf_27463(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_27463(t0,t1,t2,t3);}

C_noret_decl(trf_27532)
static void C_ccall trf_27532(C_word c,C_word *av) C_noret;
static void C_ccall trf_27532(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27532(t0,t1,t2);}

C_noret_decl(trf_27583)
static void C_ccall trf_27583(C_word c,C_word *av) C_noret;
static void C_ccall trf_27583(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27583(t0,t1,t2);}

C_noret_decl(trf_27650)
static void C_ccall trf_27650(C_word c,C_word *av) C_noret;
static void C_ccall trf_27650(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_27650(t0,t1);}

C_noret_decl(trf_27660)
static void C_ccall trf_27660(C_word c,C_word *av) C_noret;
static void C_ccall trf_27660(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_27660(t0,t1,t2,t3);}

C_noret_decl(trf_27670)
static void C_ccall trf_27670(C_word c,C_word *av) C_noret;
static void C_ccall trf_27670(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_27670(t0,t1);}

C_noret_decl(trf_27712)
static void C_ccall trf_27712(C_word c,C_word *av) C_noret;
static void C_ccall trf_27712(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_27712(t0,t1);}

C_noret_decl(trf_27722)
static void C_ccall trf_27722(C_word c,C_word *av) C_noret;
static void C_ccall trf_27722(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_27722(t0,t1,t2,t3);}

C_noret_decl(trf_27758)
static void C_ccall trf_27758(C_word c,C_word *av) C_noret;
static void C_ccall trf_27758(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_27758(t0,t1);}

C_noret_decl(trf_27783)
static void C_ccall trf_27783(C_word c,C_word *av) C_noret;
static void C_ccall trf_27783(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_27783(t0,t1,t2);}

C_noret_decl(trf_27788)
static void C_ccall trf_27788(C_word c,C_word *av) C_noret;
static void C_ccall trf_27788(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_27788(t0,t1);}

C_noret_decl(trf_27793)
static void C_ccall trf_27793(C_word c,C_word *av) C_noret;
static void C_ccall trf_27793(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_27793(t0,t1,t2,t3,t4);}

C_noret_decl(trf_27806)
static void C_ccall trf_27806(C_word c,C_word *av) C_noret;
static void C_ccall trf_27806(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_27806(t0,t1);}

C_noret_decl(trf_27812)
static void C_ccall trf_27812(C_word c,C_word *av) C_noret;
static void C_ccall trf_27812(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_27812(t0,t1);}

C_noret_decl(trf_27842)
static void C_ccall trf_27842(C_word c,C_word *av) C_noret;
static void C_ccall trf_27842(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_27842(t0,t1);}

C_noret_decl(trf_28034)
static void C_ccall trf_28034(C_word c,C_word *av) C_noret;
static void C_ccall trf_28034(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_28034(t0,t1);}

C_noret_decl(trf_28073)
static void C_ccall trf_28073(C_word c,C_word *av) C_noret;
static void C_ccall trf_28073(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_28073(t0,t1);}

C_noret_decl(trf_28226)
static void C_ccall trf_28226(C_word c,C_word *av) C_noret;
static void C_ccall trf_28226(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_28226(t0,t1);}

C_noret_decl(trf_28251)
static void C_ccall trf_28251(C_word c,C_word *av) C_noret;
static void C_ccall trf_28251(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_28251(t0,t1);}

C_noret_decl(trf_28257)
static void C_ccall trf_28257(C_word c,C_word *av) C_noret;
static void C_ccall trf_28257(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_28257(t0,t1,t2);}

C_noret_decl(trf_28338)
static void C_ccall trf_28338(C_word c,C_word *av) C_noret;
static void C_ccall trf_28338(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_28338(t0,t1);}

C_noret_decl(trf_28351)
static void C_ccall trf_28351(C_word c,C_word *av) C_noret;
static void C_ccall trf_28351(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_28351(t0,t1,t2);}

C_noret_decl(trf_28569)
static void C_ccall trf_28569(C_word c,C_word *av) C_noret;
static void C_ccall trf_28569(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_28569(t0,t1,t2);}

C_noret_decl(trf_28942)
static void C_ccall trf_28942(C_word c,C_word *av) C_noret;
static void C_ccall trf_28942(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_28942(t0,t1);}

C_noret_decl(trf_29305)
static void C_ccall trf_29305(C_word c,C_word *av) C_noret;
static void C_ccall trf_29305(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_29305(t0,t1,t2);}

C_noret_decl(trf_29318)
static void C_ccall trf_29318(C_word c,C_word *av) C_noret;
static void C_ccall trf_29318(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_29318(t0,t1);}

C_noret_decl(trf_29460)
static void C_ccall trf_29460(C_word c,C_word *av) C_noret;
static void C_ccall trf_29460(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_29460(t0,t1,t2,t3);}

C_noret_decl(trf_29476)
static void C_ccall trf_29476(C_word c,C_word *av) C_noret;
static void C_ccall trf_29476(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_29476(t0,t1,t2);}

C_noret_decl(trf_29518)
static void C_ccall trf_29518(C_word c,C_word *av) C_noret;
static void C_ccall trf_29518(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_29518(t0,t1,t2,t3);}

C_noret_decl(trf_29525)
static void C_ccall trf_29525(C_word c,C_word *av) C_noret;
static void C_ccall trf_29525(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_29525(t0,t1);}

C_noret_decl(trf_29701)
static void C_ccall trf_29701(C_word c,C_word *av) C_noret;
static void C_ccall trf_29701(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_29701(t0,t1,t2);}

C_noret_decl(trf_29752)
static void C_ccall trf_29752(C_word c,C_word *av) C_noret;
static void C_ccall trf_29752(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_29752(t0,t1,t2);}

C_noret_decl(trf_29814)
static void C_ccall trf_29814(C_word c,C_word *av) C_noret;
static void C_ccall trf_29814(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_29814(t0,t1,t2,t3);}

C_noret_decl(trf_29873)
static void C_ccall trf_29873(C_word c,C_word *av) C_noret;
static void C_ccall trf_29873(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_29873(t0,t1,t2);}

C_noret_decl(trf_29897)
static void C_ccall trf_29897(C_word c,C_word *av) C_noret;
static void C_ccall trf_29897(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_29897(t0,t1,t2,t3);}

C_noret_decl(trf_29957)
static void C_ccall trf_29957(C_word c,C_word *av) C_noret;
static void C_ccall trf_29957(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_29957(t0,t1,t2,t3);}

C_noret_decl(trf_29987)
static void C_ccall trf_29987(C_word c,C_word *av) C_noret;
static void C_ccall trf_29987(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_29987(t0,t1,t2,t3);}

C_noret_decl(trf_29999)
static void C_ccall trf_29999(C_word c,C_word *av) C_noret;
static void C_ccall trf_29999(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_29999(t0,t1,t2);}

C_noret_decl(trf_30072)
static void C_ccall trf_30072(C_word c,C_word *av) C_noret;
static void C_ccall trf_30072(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30072(t0,t1,t2);}

C_noret_decl(trf_30123)
static void C_ccall trf_30123(C_word c,C_word *av) C_noret;
static void C_ccall trf_30123(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30123(t0,t1,t2);}

C_noret_decl(trf_30198)
static void C_ccall trf_30198(C_word c,C_word *av) C_noret;
static void C_ccall trf_30198(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_30198(t0,t1);}

C_noret_decl(trf_30303)
static void C_ccall trf_30303(C_word c,C_word *av) C_noret;
static void C_ccall trf_30303(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30303(t0,t1,t2);}

C_noret_decl(trf_30368)
static void C_ccall trf_30368(C_word c,C_word *av) C_noret;
static void C_ccall trf_30368(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30368(t0,t1,t2);}

C_noret_decl(trf_30528)
static void C_ccall trf_30528(C_word c,C_word *av) C_noret;
static void C_ccall trf_30528(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_30528(t0,t1,t2,t3);}

C_noret_decl(trf_30717)
static void C_ccall trf_30717(C_word c,C_word *av) C_noret;
static void C_ccall trf_30717(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_30717(t0,t1,t2);}

C_noret_decl(trf_30894)
static void C_ccall trf_30894(C_word c,C_word *av) C_noret;
static void C_ccall trf_30894(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_30894(t0,t1,t2,t3);}

C_noret_decl(trf_31291)
static void C_ccall trf_31291(C_word c,C_word *av) C_noret;
static void C_ccall trf_31291(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_31291(t0,t1);}

C_noret_decl(trf_31302)
static void C_ccall trf_31302(C_word c,C_word *av) C_noret;
static void C_ccall trf_31302(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_31302(t0,t1,t2,t3,t4);}

C_noret_decl(trf_31325)
static void C_ccall trf_31325(C_word c,C_word *av) C_noret;
static void C_ccall trf_31325(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_31325(t0,t1,t2);}

C_noret_decl(trf_31345)
static void C_ccall trf_31345(C_word c,C_word *av) C_noret;
static void C_ccall trf_31345(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_31345(t0,t1);}

C_noret_decl(trf_31360)
static void C_ccall trf_31360(C_word c,C_word *av) C_noret;
static void C_ccall trf_31360(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_31360(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_31421)
static void C_ccall trf_31421(C_word c,C_word *av) C_noret;
static void C_ccall trf_31421(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_31421(t0,t1);}

C_noret_decl(trf_31564)
static void C_ccall trf_31564(C_word c,C_word *av) C_noret;
static void C_ccall trf_31564(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_31564(t0,t1,t2);}

C_noret_decl(trf_31579)
static void C_ccall trf_31579(C_word c,C_word *av) C_noret;
static void C_ccall trf_31579(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_31579(t0,t1,t2);}

C_noret_decl(trf_31682)
static void C_ccall trf_31682(C_word c,C_word *av) C_noret;
static void C_ccall trf_31682(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_31682(t0,t1,t2);}

C_noret_decl(trf_31701)
static void C_ccall trf_31701(C_word c,C_word *av) C_noret;
static void C_ccall trf_31701(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_31701(t0,t1);}

C_noret_decl(trf_31820)
static void C_ccall trf_31820(C_word c,C_word *av) C_noret;
static void C_ccall trf_31820(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_31820(t0,t1,t2);}

C_noret_decl(trf_31857)
static void C_ccall trf_31857(C_word c,C_word *av) C_noret;
static void C_ccall trf_31857(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_31857(t0,t1);}

C_noret_decl(trf_31891)
static void C_ccall trf_31891(C_word c,C_word *av) C_noret;
static void C_ccall trf_31891(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_31891(t0,t1,t2);}

C_noret_decl(trf_32027)
static void C_ccall trf_32027(C_word c,C_word *av) C_noret;
static void C_ccall trf_32027(C_word c,C_word *av){
C_word t0=av[0];
f_32027(t0);}

C_noret_decl(trf_32075)
static void C_ccall trf_32075(C_word c,C_word *av) C_noret;
static void C_ccall trf_32075(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_32075(t0,t1);}

C_noret_decl(trf_32099)
static void C_ccall trf_32099(C_word c,C_word *av) C_noret;
static void C_ccall trf_32099(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_32099(t0,t1,t2);}

C_noret_decl(trf_32197)
static void C_ccall trf_32197(C_word c,C_word *av) C_noret;
static void C_ccall trf_32197(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_32197(t0,t1,t2);}

C_noret_decl(trf_32245)
static void C_ccall trf_32245(C_word c,C_word *av) C_noret;
static void C_ccall trf_32245(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_32245(t0,t1);}

C_noret_decl(trf_32248)
static void C_ccall trf_32248(C_word c,C_word *av) C_noret;
static void C_ccall trf_32248(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_32248(t0,t1);}

C_noret_decl(trf_32268)
static void C_ccall trf_32268(C_word c,C_word *av) C_noret;
static void C_ccall trf_32268(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_32268(t0,t1);}

C_noret_decl(trf_32715)
static void C_ccall trf_32715(C_word c,C_word *av) C_noret;
static void C_ccall trf_32715(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_32715(t0,t1,t2,t3);}

C_noret_decl(trf_32721)
static void C_ccall trf_32721(C_word c,C_word *av) C_noret;
static void C_ccall trf_32721(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_32721(t0,t1,t2);}

C_noret_decl(trf_32737)
static void C_ccall trf_32737(C_word c,C_word *av) C_noret;
static void C_ccall trf_32737(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_32737(t0,t1);}

C_noret_decl(trf_32834)
static void C_ccall trf_32834(C_word c,C_word *av) C_noret;
static void C_ccall trf_32834(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_32834(t0,t1,t2);}

C_noret_decl(trf_32880)
static void C_ccall trf_32880(C_word c,C_word *av) C_noret;
static void C_ccall trf_32880(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_32880(t0,t1,t2);}

C_noret_decl(trf_32956)
static void C_ccall trf_32956(C_word c,C_word *av) C_noret;
static void C_ccall trf_32956(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_32956(t0,t1,t2);}

C_noret_decl(trf_33008)
static void C_ccall trf_33008(C_word c,C_word *av) C_noret;
static void C_ccall trf_33008(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_33008(t0,t1,t2);}

C_noret_decl(trf_33056)
static void C_ccall trf_33056(C_word c,C_word *av) C_noret;
static void C_ccall trf_33056(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_33056(t0,t1,t2);}

C_noret_decl(trf_33070)
static void C_ccall trf_33070(C_word c,C_word *av) C_noret;
static void C_ccall trf_33070(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_33070(t0,t1,t2);}

C_noret_decl(trf_33126)
static void C_ccall trf_33126(C_word c,C_word *av) C_noret;
static void C_ccall trf_33126(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_33126(t0,t1,t2);}

C_noret_decl(trf_33251)
static void C_ccall trf_33251(C_word c,C_word *av) C_noret;
static void C_ccall trf_33251(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_33251(t0,t1,t2);}

C_noret_decl(trf_33253)
static void C_ccall trf_33253(C_word c,C_word *av) C_noret;
static void C_ccall trf_33253(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_33253(t0,t1,t2);}

C_noret_decl(trf_33274)
static void C_ccall trf_33274(C_word c,C_word *av) C_noret;
static void C_ccall trf_33274(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_33274(t0,t1,t2);}

C_noret_decl(trf_33298)
static void C_ccall trf_33298(C_word c,C_word *av) C_noret;
static void C_ccall trf_33298(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_33298(t0,t1,t2,t3);}

C_noret_decl(trf_33352)
static void C_ccall trf_33352(C_word c,C_word *av) C_noret;
static void C_ccall trf_33352(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_33352(t0,t1,t2);}

C_noret_decl(trf_33447)
static void C_ccall trf_33447(C_word c,C_word *av) C_noret;
static void C_ccall trf_33447(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_33447(t0,t1,t2);}

C_noret_decl(trf_33452)
static void C_ccall trf_33452(C_word c,C_word *av) C_noret;
static void C_ccall trf_33452(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_33452(t0,t1);}

C_noret_decl(trf_34670)
static void C_ccall trf_34670(C_word c,C_word *av) C_noret;
static void C_ccall trf_34670(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_34670(t0,t1,t2);}

C_noret_decl(trf_34734)
static void C_ccall trf_34734(C_word c,C_word *av) C_noret;
static void C_ccall trf_34734(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_34734(t0,t1,t2);}

C_noret_decl(trf_35014)
static void C_ccall trf_35014(C_word c,C_word *av) C_noret;
static void C_ccall trf_35014(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_35014(t0,t1);}

C_noret_decl(trf_35104)
static void C_ccall trf_35104(C_word c,C_word *av) C_noret;
static void C_ccall trf_35104(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_35104(t0,t1,t2);}

C_noret_decl(trf_35148)
static void C_ccall trf_35148(C_word c,C_word *av) C_noret;
static void C_ccall trf_35148(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_35148(t0,t1);}

C_noret_decl(trf_35161)
static void C_ccall trf_35161(C_word c,C_word *av) C_noret;
static void C_ccall trf_35161(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_35161(t0,t1,t2);}

C_noret_decl(trf_35195)
static void C_ccall trf_35195(C_word c,C_word *av) C_noret;
static void C_ccall trf_35195(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_35195(t0,t1,t2);}

C_noret_decl(trf_35210)
static void C_ccall trf_35210(C_word c,C_word *av) C_noret;
static void C_ccall trf_35210(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_35210(t0,t1);}

C_noret_decl(trf_35286)
static void C_ccall trf_35286(C_word c,C_word *av) C_noret;
static void C_ccall trf_35286(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_35286(t0,t1,t2);}

C_noret_decl(trf_35385)
static void C_ccall trf_35385(C_word c,C_word *av) C_noret;
static void C_ccall trf_35385(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_35385(t0,t1);}

C_noret_decl(trf_35404)
static void C_ccall trf_35404(C_word c,C_word *av) C_noret;
static void C_ccall trf_35404(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_35404(t0,t1,t2);}

C_noret_decl(trf_35445)
static void C_ccall trf_35445(C_word c,C_word *av) C_noret;
static void C_ccall trf_35445(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_35445(t0,t1,t2,t3,t4);}

C_noret_decl(trf_35773)
static void C_ccall trf_35773(C_word c,C_word *av) C_noret;
static void C_ccall trf_35773(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_35773(t0,t1,t2);}

C_noret_decl(trf_35785)
static void C_ccall trf_35785(C_word c,C_word *av) C_noret;
static void C_ccall trf_35785(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_35785(t0,t1,t2);}

C_noret_decl(trf_35865)
static void C_ccall trf_35865(C_word c,C_word *av) C_noret;
static void C_ccall trf_35865(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_35865(t0,t1,t2,t3);}

C_noret_decl(trf_36079)
static void C_ccall trf_36079(C_word c,C_word *av) C_noret;
static void C_ccall trf_36079(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_36079(t0,t1,t2);}

C_noret_decl(trf_36117)
static void C_ccall trf_36117(C_word c,C_word *av) C_noret;
static void C_ccall trf_36117(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_36117(t0,t1,t2);}

C_noret_decl(trf_36196)
static void C_ccall trf_36196(C_word c,C_word *av) C_noret;
static void C_ccall trf_36196(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_36196(t0,t1,t2);}

C_noret_decl(trf_36324)
static void C_ccall trf_36324(C_word c,C_word *av) C_noret;
static void C_ccall trf_36324(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_36324(t0,t1);}

C_noret_decl(trf_36761)
static void C_ccall trf_36761(C_word c,C_word *av) C_noret;
static void C_ccall trf_36761(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_36761(t0,t1);}

C_noret_decl(trf_36770)
static void C_ccall trf_36770(C_word c,C_word *av) C_noret;
static void C_ccall trf_36770(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_36770(t0,t1,t2);}

C_noret_decl(trf_36829)
static void C_ccall trf_36829(C_word c,C_word *av) C_noret;
static void C_ccall trf_36829(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_36829(t0,t1);}

C_noret_decl(trf_36843)
static void C_ccall trf_36843(C_word c,C_word *av) C_noret;
static void C_ccall trf_36843(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_36843(t0,t1,t2);}

C_noret_decl(trf_36865)
static void C_ccall trf_36865(C_word c,C_word *av) C_noret;
static void C_ccall trf_36865(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_36865(t0,t1,t2);}

C_noret_decl(trf_37080)
static void C_ccall trf_37080(C_word c,C_word *av) C_noret;
static void C_ccall trf_37080(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_37080(t0,t1);}

C_noret_decl(trf_37103)
static void C_ccall trf_37103(C_word c,C_word *av) C_noret;
static void C_ccall trf_37103(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_37103(t0,t1);}

C_noret_decl(trf_37274)
static void C_ccall trf_37274(C_word c,C_word *av) C_noret;
static void C_ccall trf_37274(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_37274(t0,t1,t2,t3);}

C_noret_decl(trf_37433)
static void C_ccall trf_37433(C_word c,C_word *av) C_noret;
static void C_ccall trf_37433(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_37433(t0,t1);}

C_noret_decl(trf_37466)
static void C_ccall trf_37466(C_word c,C_word *av) C_noret;
static void C_ccall trf_37466(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_37466(t0,t1);}

C_noret_decl(trf_37469)
static void C_ccall trf_37469(C_word c,C_word *av) C_noret;
static void C_ccall trf_37469(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_37469(t0,t1);}

C_noret_decl(trf_37472)
static void C_ccall trf_37472(C_word c,C_word *av) C_noret;
static void C_ccall trf_37472(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_37472(t0,t1);}

C_noret_decl(trf_37475)
static void C_ccall trf_37475(C_word c,C_word *av) C_noret;
static void C_ccall trf_37475(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_37475(t0,t1);}

C_noret_decl(trf_37512)
static void C_ccall trf_37512(C_word c,C_word *av) C_noret;
static void C_ccall trf_37512(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_37512(t0,t1,t2);}

C_noret_decl(trf_37548)
static void C_ccall trf_37548(C_word c,C_word *av) C_noret;
static void C_ccall trf_37548(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_37548(t0,t1,t2);}

C_noret_decl(trf_37579)
static void C_ccall trf_37579(C_word c,C_word *av) C_noret;
static void C_ccall trf_37579(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_37579(t0,t1,t2);}

C_noret_decl(trf_37619)
static void C_ccall trf_37619(C_word c,C_word *av) C_noret;
static void C_ccall trf_37619(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_37619(t0,t1,t2);}

C_noret_decl(trf_37725)
static void C_ccall trf_37725(C_word c,C_word *av) C_noret;
static void C_ccall trf_37725(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_37725(t0,t1,t2);}

C_noret_decl(trf_37774)
static void C_ccall trf_37774(C_word c,C_word *av) C_noret;
static void C_ccall trf_37774(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_37774(t0,t1,t2,t3);}

C_noret_decl(trf_37818)
static void C_ccall trf_37818(C_word c,C_word *av) C_noret;
static void C_ccall trf_37818(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_37818(t0,t1,t2,t3);}

C_noret_decl(trf_37868)
static void C_ccall trf_37868(C_word c,C_word *av) C_noret;
static void C_ccall trf_37868(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_37868(t0,t1,t2,t3);}

C_noret_decl(trf_37909)
static void C_ccall trf_37909(C_word c,C_word *av) C_noret;
static void C_ccall trf_37909(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_37909(t0,t1,t2,t3);}

C_noret_decl(trf_38013)
static void C_ccall trf_38013(C_word c,C_word *av) C_noret;
static void C_ccall trf_38013(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_38013(t0,t1,t2,t3);}

C_noret_decl(trf_38034)
static void C_ccall trf_38034(C_word c,C_word *av) C_noret;
static void C_ccall trf_38034(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_38034(t0,t1,t2,t3);}

C_noret_decl(trf_38128)
static void C_ccall trf_38128(C_word c,C_word *av) C_noret;
static void C_ccall trf_38128(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_38128(t0,t1,t2,t3);}

C_noret_decl(trf_38203)
static void C_ccall trf_38203(C_word c,C_word *av) C_noret;
static void C_ccall trf_38203(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38203(t0,t1,t2);}

C_noret_decl(trf_38238)
static void C_ccall trf_38238(C_word c,C_word *av) C_noret;
static void C_ccall trf_38238(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38238(t0,t1,t2);}

C_noret_decl(trf_38296)
static void C_ccall trf_38296(C_word c,C_word *av) C_noret;
static void C_ccall trf_38296(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38296(t0,t1,t2);}

C_noret_decl(trf_38365)
static void C_ccall trf_38365(C_word c,C_word *av) C_noret;
static void C_ccall trf_38365(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38365(t0,t1,t2);}

C_noret_decl(trf_38429)
static void C_ccall trf_38429(C_word c,C_word *av) C_noret;
static void C_ccall trf_38429(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38429(t0,t1,t2);}

C_noret_decl(trf_38460)
static void C_ccall trf_38460(C_word c,C_word *av) C_noret;
static void C_ccall trf_38460(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38460(t0,t1,t2);}

C_noret_decl(trf_38518)
static void C_ccall trf_38518(C_word c,C_word *av) C_noret;
static void C_ccall trf_38518(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38518(t0,t1,t2);}

C_noret_decl(trf_38599)
static void C_ccall trf_38599(C_word c,C_word *av) C_noret;
static void C_ccall trf_38599(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38599(t0,t1,t2);}

C_noret_decl(trf_38658)
static void C_ccall trf_38658(C_word c,C_word *av) C_noret;
static void C_ccall trf_38658(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38658(t0,t1,t2);}

C_noret_decl(trf_38693)
static void C_ccall trf_38693(C_word c,C_word *av) C_noret;
static void C_ccall trf_38693(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38693(t0,t1,t2);}

C_noret_decl(trf_38751)
static void C_ccall trf_38751(C_word c,C_word *av) C_noret;
static void C_ccall trf_38751(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38751(t0,t1,t2);}

C_noret_decl(trf_38829)
static void C_ccall trf_38829(C_word c,C_word *av) C_noret;
static void C_ccall trf_38829(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38829(t0,t1,t2);}

C_noret_decl(trf_38884)
static void C_ccall trf_38884(C_word c,C_word *av) C_noret;
static void C_ccall trf_38884(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38884(t0,t1,t2);}

C_noret_decl(trf_38915)
static void C_ccall trf_38915(C_word c,C_word *av) C_noret;
static void C_ccall trf_38915(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38915(t0,t1,t2);}

C_noret_decl(trf_38973)
static void C_ccall trf_38973(C_word c,C_word *av) C_noret;
static void C_ccall trf_38973(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_38973(t0,t1,t2);}

C_noret_decl(trf_39167)
static void C_ccall trf_39167(C_word c,C_word *av) C_noret;
static void C_ccall trf_39167(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_39167(t0,t1);}

C_noret_decl(trf_39170)
static void C_ccall trf_39170(C_word c,C_word *av) C_noret;
static void C_ccall trf_39170(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_39170(t0,t1);}

C_noret_decl(trf_39274)
static void C_ccall trf_39274(C_word c,C_word *av) C_noret;
static void C_ccall trf_39274(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_39274(t0,t1,t2,t3,t4);}

C_noret_decl(trf_39356)
static void C_ccall trf_39356(C_word c,C_word *av) C_noret;
static void C_ccall trf_39356(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_39356(t0,t1);}

C_noret_decl(trf_39366)
static void C_ccall trf_39366(C_word c,C_word *av) C_noret;
static void C_ccall trf_39366(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_39366(t0,t1,t2);}

C_noret_decl(trf_39384)
static void C_ccall trf_39384(C_word c,C_word *av) C_noret;
static void C_ccall trf_39384(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_39384(t0,t1,t2);}

C_noret_decl(trf_39530)
static void C_ccall trf_39530(C_word c,C_word *av) C_noret;
static void C_ccall trf_39530(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_39530(t0,t1,t2,t3);}

C_noret_decl(trf_39646)
static void C_ccall trf_39646(C_word c,C_word *av) C_noret;
static void C_ccall trf_39646(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_39646(t0,t1,t2,t3,t4);}

C_noret_decl(trf_39721)
static void C_ccall trf_39721(C_word c,C_word *av) C_noret;
static void C_ccall trf_39721(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_39721(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_39745)
static void C_ccall trf_39745(C_word c,C_word *av) C_noret;
static void C_ccall trf_39745(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_39745(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_39769)
static void C_ccall trf_39769(C_word c,C_word *av) C_noret;
static void C_ccall trf_39769(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_39769(t0,t1,t2);}

C_noret_decl(trf_40084)
static void C_ccall trf_40084(C_word c,C_word *av) C_noret;
static void C_ccall trf_40084(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_40084(t0,t1,t2,t3,t4);}

C_noret_decl(trf_40315)
static void C_ccall trf_40315(C_word c,C_word *av) C_noret;
static void C_ccall trf_40315(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_40315(t0,t1);}

C_noret_decl(trf_40606)
static void C_ccall trf_40606(C_word c,C_word *av) C_noret;
static void C_ccall trf_40606(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_40606(t0,t1,t2);}

C_noret_decl(trf_40837)
static void C_ccall trf_40837(C_word c,C_word *av) C_noret;
static void C_ccall trf_40837(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_40837(t0,t1,t2);}

C_noret_decl(trf_40999)
static void C_ccall trf_40999(C_word c,C_word *av) C_noret;
static void C_ccall trf_40999(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_40999(t0,t1,t2);}

C_noret_decl(trf_41038)
static void C_ccall trf_41038(C_word c,C_word *av) C_noret;
static void C_ccall trf_41038(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_41038(t0,t1,t2);}

C_noret_decl(trf_41054)
static void C_ccall trf_41054(C_word c,C_word *av) C_noret;
static void C_ccall trf_41054(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_41054(t0,t1,t2);}

C_noret_decl(trf_41220)
static void C_ccall trf_41220(C_word c,C_word *av) C_noret;
static void C_ccall trf_41220(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_41220(t0,t1);}

C_noret_decl(trf_41799)
static void C_ccall trf_41799(C_word c,C_word *av) C_noret;
static void C_ccall trf_41799(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_41799(t0,t1);}

C_noret_decl(trf_41808)
static void C_ccall trf_41808(C_word c,C_word *av) C_noret;
static void C_ccall trf_41808(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_41808(t0,t1,t2,t3,t4);}

C_noret_decl(trf_41906)
static void C_ccall trf_41906(C_word c,C_word *av) C_noret;
static void C_ccall trf_41906(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_41906(t0,t1);}

C_noret_decl(trf_41919)
static void C_ccall trf_41919(C_word c,C_word *av) C_noret;
static void C_ccall trf_41919(C_word c,C_word *av){
C_word t0=av[6];
C_word t1=av[5];
C_word t2=av[4];
C_word t3=av[3];
C_word t4=av[2];
C_word t5=av[1];
C_word t6=av[0];
f_41919(t0,t1,t2,t3,t4,t5,t6);}

/* f45103 in chicken.base#exit in k12556 in k11433 */
static void C_ccall f45103(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f45103,c,av);}
/* library.scm:907: g887 */
t2=t1;{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=C_fix(0);
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* f45302 in chicken.base#gensym in k12556 in k11433 */
static void C_ccall f45302(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f45302,c,av);}
/* library.scm:3321: ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[507]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[507]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=lf[747];
av2[3]=t1;
tp(4,av2);}}

/* f45306 in k22300 in chicken.base#gensym in k12556 in k11433 */
static void C_ccall f45306(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f45306,c,av);}
/* library.scm:3321: ##sys#string-append */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[507]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[507]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
tp(4,av2);}}

/* f45436 in k27344 in a27341 in k27296 in k27287 in k27284 in k27256 in k27253 in k27250 in loop in a27222 in k27441 in r-list in readrec in k26195 in k26192 in k26189 in k26186 in k29295 in ##sys#read in k26131 in k26127 in ... */
static void C_ccall f45436(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f45436,c,av);}
/* library.scm:5044: ##sys#intern-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[733]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[733]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
tp(3,av2);}}

/* f45441 in k27344 in a27341 in k27296 in k27287 in k27284 in k27256 in k27253 in k27250 in loop in a27222 in k27441 in r-list in readrec in k26195 in k26192 in k26189 in k26186 in k29295 in ##sys#read in k26131 in k26127 in ... */
static void C_ccall f45441(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f45441,c,av);}
/* library.scm:5044: ##sys#intern-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[733]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[733]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
tp(3,av2);}}

/* f45448 in a27468 in r-number in readrec in k26195 in k26192 in k26189 in k26186 in k29295 in ##sys#read in k26131 in k26127 in k26123 in k26119 in k26115 in k26105 in k25751 in k25747 in k25743 in k25739 in k25735 in k25731 in ... */
static void C_ccall f45448(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f45448,c,av);}
/* library.scm:5044: ##sys#intern-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[733]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[733]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
tp(3,av2);}}

/* f45457 in a27763 in r-symbol in readrec in k26195 in k26192 in k26189 in k26186 in k29295 in ##sys#read in k26131 in k26127 in k26123 in k26119 in k26115 in k26105 in k25751 in k25747 in k25743 in k25739 in k25735 in k25731 in ... */
static void C_ccall f45457(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f45457,c,av);}
/* library.scm:5044: ##sys#intern-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[733]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[733]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
tp(3,av2);}}

/* f45466 in a28861 in a28855 in k28844 in k28841 in k28487 in k28484 in k28390 in k28387 in k28384 in readrec in k26195 in k26192 in k26189 in k26186 in k29295 in ##sys#read in k26131 in k26127 in k26123 in k26119 in k26115 in ... */
static void C_ccall f45466(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f45466,c,av);}
/* library.scm:5044: ##sys#intern-keyword */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[733]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[733]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
tp(3,av2);}}

/* f49030 in k40814 in k35889 in k35705 in k35069 in k34849 in k34423 in k34420 in k34417 in k34414 in k34409 in k34405 in k34264 in k33248 in k33245 in k33242 in k32475 in k32136 in k32132 in k32128 in k30988 in k29792 in ... */
static void C_ccall f49030(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f49030,c,av);}
t3=C_i_check_list_2(t2,lf[1591]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* f49036 in k40898 in k35705 in k35069 in k34849 in k34423 in k34420 in k34417 in k34414 in k34409 in k34405 in k34264 in k33248 in k33245 in k33242 in k32475 in k32136 in k32132 in k32128 in k30988 in k29792 in k29788 in ... */
static void C_ccall f49036(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f49036,c,av);}
t3=C_i_check_string_2(t2,lf[1594]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* f49042 in k40894 in k40898 in k35705 in k35069 in k34849 in k34423 in k34420 in k34417 in k34414 in k34409 in k34405 in k34264 in k33248 in k33245 in k33242 in k32475 in k32136 in k32132 in k32128 in k30988 in k29792 in ... */
static void C_ccall f49042(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f49042,c,av);}
t3=C_i_check_string_2(t2,lf[1594]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k11433 */
static void C_ccall f_11435(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word t106;
C_word t107;
C_word t108;
C_word t109;
C_word t110;
C_word t111;
C_word t112;
C_word t113;
C_word t114;
C_word t115;
C_word t116;
C_word t117;
C_word t118;
C_word t119;
C_word t120;
C_word t121;
C_word t122;
C_word t123;
C_word t124;
C_word t125;
C_word t126;
C_word t127;
C_word t128;
C_word t129;
C_word t130;
C_word t131;
C_word t132;
C_word t133;
C_word t134;
C_word t135;
C_word t136;
C_word t137;
C_word t138;
C_word t139;
C_word t140;
C_word t141;
C_word t142;
C_word t143;
C_word t144;
C_word t145;
C_word t146;
C_word t147;
C_word t148;
C_word t149;
C_word t150;
C_word t151;
C_word t152;
C_word t153;
C_word t154;
C_word t155;
C_word t156;
C_word t157;
C_word t158;
C_word t159;
C_word t160;
C_word t161;
C_word t162;
C_word t163;
C_word t164;
C_word t165;
C_word t166;
C_word t167;
C_word t168;
C_word t169;
C_word t170;
C_word t171;
C_word t172;
C_word t173;
C_word t174;
C_word t175;
C_word t176;
C_word t177;
C_word t178;
C_word t179;
C_word t180;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(388,c,5)))){
C_save_and_reclaim((void *)f_11435,c,av);}
a=C_alloc(388);
t2=C_a_i_provide(&a,1,lf[0]);
t3=C_a_i_provide(&a,1,lf[1]);
t4=C_mutate((C_word*)lf[2]+1 /* (set! scheme#not ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11437,a[2]=((C_word)li0),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[3]+1 /* (set! scheme#boolean? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11440,a[2]=((C_word)li1),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[4]+1 /* (set! scheme#eq? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11443,a[2]=((C_word)li2),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[5]+1 /* (set! scheme#eqv? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11446,a[2]=((C_word)li3),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[6]+1 /* (set! scheme#equal? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11449,a[2]=((C_word)li4),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate((C_word*)lf[7]+1 /* (set! scheme#boolean=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11452,a[2]=((C_word)li6),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate((C_word*)lf[9]+1 /* (set! scheme#symbol=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11497,a[2]=((C_word)li8),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate((C_word*)lf[11]+1 /* (set! scheme#pair? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11542,a[2]=((C_word)li9),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate((C_word*)lf[12]+1 /* (set! scheme#cons ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11545,a[2]=((C_word)li10),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate((C_word*)lf[13]+1 /* (set! scheme#car ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11548,a[2]=((C_word)li11),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate((C_word*)lf[14]+1 /* (set! scheme#cdr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11551,a[2]=((C_word)li12),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate((C_word*)lf[15]+1 /* (set! scheme#set-car! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11554,a[2]=((C_word)li13),tmp=(C_word)a,a+=3,tmp));
t16=C_mutate((C_word*)lf[16]+1 /* (set! scheme#set-cdr! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11557,a[2]=((C_word)li14),tmp=(C_word)a,a+=3,tmp));
t17=C_mutate((C_word*)lf[17]+1 /* (set! scheme#cadr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11560,a[2]=((C_word)li15),tmp=(C_word)a,a+=3,tmp));
t18=C_mutate((C_word*)lf[18]+1 /* (set! scheme#caddr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11563,a[2]=((C_word)li16),tmp=(C_word)a,a+=3,tmp));
t19=C_mutate((C_word*)lf[19]+1 /* (set! scheme#cadddr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11566,a[2]=((C_word)li17),tmp=(C_word)a,a+=3,tmp));
t20=C_mutate((C_word*)lf[20]+1 /* (set! scheme#cddddr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11569,a[2]=((C_word)li18),tmp=(C_word)a,a+=3,tmp));
t21=C_mutate((C_word*)lf[21]+1 /* (set! scheme#caar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11572,a[2]=((C_word)li19),tmp=(C_word)a,a+=3,tmp));
t22=C_mutate((C_word*)lf[22]+1 /* (set! scheme#cdar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11575,a[2]=((C_word)li20),tmp=(C_word)a,a+=3,tmp));
t23=C_mutate((C_word*)lf[23]+1 /* (set! scheme#cddr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11578,a[2]=((C_word)li21),tmp=(C_word)a,a+=3,tmp));
t24=C_mutate((C_word*)lf[24]+1 /* (set! scheme#caaar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11581,a[2]=((C_word)li22),tmp=(C_word)a,a+=3,tmp));
t25=C_mutate((C_word*)lf[25]+1 /* (set! scheme#caadr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11595,a[2]=((C_word)li23),tmp=(C_word)a,a+=3,tmp));
t26=C_mutate((C_word*)lf[26]+1 /* (set! scheme#cadar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11602,a[2]=((C_word)li24),tmp=(C_word)a,a+=3,tmp));
t27=C_mutate((C_word*)lf[27]+1 /* (set! scheme#cdaar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11609,a[2]=((C_word)li25),tmp=(C_word)a,a+=3,tmp));
t28=C_mutate((C_word*)lf[28]+1 /* (set! scheme#cdadr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11623,a[2]=((C_word)li26),tmp=(C_word)a,a+=3,tmp));
t29=C_mutate((C_word*)lf[29]+1 /* (set! scheme#cddar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11630,a[2]=((C_word)li27),tmp=(C_word)a,a+=3,tmp));
t30=C_mutate((C_word*)lf[30]+1 /* (set! scheme#cdddr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11644,a[2]=((C_word)li28),tmp=(C_word)a,a+=3,tmp));
t31=C_mutate((C_word*)lf[31]+1 /* (set! scheme#caaaar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11658,a[2]=((C_word)li29),tmp=(C_word)a,a+=3,tmp));
t32=C_mutate((C_word*)lf[32]+1 /* (set! scheme#caaadr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11676,a[2]=((C_word)li30),tmp=(C_word)a,a+=3,tmp));
t33=C_mutate((C_word*)lf[33]+1 /* (set! scheme#caadar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11687,a[2]=((C_word)li31),tmp=(C_word)a,a+=3,tmp));
t34=C_mutate((C_word*)lf[34]+1 /* (set! scheme#caaddr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11698,a[2]=((C_word)li32),tmp=(C_word)a,a+=3,tmp));
t35=C_mutate((C_word*)lf[35]+1 /* (set! scheme#cadaar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11705,a[2]=((C_word)li33),tmp=(C_word)a,a+=3,tmp));
t36=C_mutate((C_word*)lf[36]+1 /* (set! scheme#cadadr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11716,a[2]=((C_word)li34),tmp=(C_word)a,a+=3,tmp));
t37=C_mutate((C_word*)lf[37]+1 /* (set! scheme#caddar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11720,a[2]=((C_word)li35),tmp=(C_word)a,a+=3,tmp));
t38=C_mutate((C_word*)lf[38]+1 /* (set! scheme#cdaaar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11727,a[2]=((C_word)li36),tmp=(C_word)a,a+=3,tmp));
t39=C_mutate((C_word*)lf[39]+1 /* (set! scheme#cdaadr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11745,a[2]=((C_word)li37),tmp=(C_word)a,a+=3,tmp));
t40=C_mutate((C_word*)lf[40]+1 /* (set! scheme#cdadar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11756,a[2]=((C_word)li38),tmp=(C_word)a,a+=3,tmp));
t41=C_mutate((C_word*)lf[41]+1 /* (set! scheme#cdaddr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11767,a[2]=((C_word)li39),tmp=(C_word)a,a+=3,tmp));
t42=C_mutate((C_word*)lf[42]+1 /* (set! scheme#cddaar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11774,a[2]=((C_word)li40),tmp=(C_word)a,a+=3,tmp));
t43=C_mutate((C_word*)lf[43]+1 /* (set! scheme#cddadr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11792,a[2]=((C_word)li41),tmp=(C_word)a,a+=3,tmp));
t44=C_mutate((C_word*)lf[44]+1 /* (set! scheme#cdddar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11803,a[2]=((C_word)li42),tmp=(C_word)a,a+=3,tmp));
t45=C_mutate((C_word*)lf[45]+1 /* (set! scheme#null? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11821,a[2]=((C_word)li43),tmp=(C_word)a,a+=3,tmp));
t46=C_mutate((C_word*)lf[46]+1 /* (set! scheme#list ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11827,a[2]=((C_word)li44),tmp=(C_word)a,a+=3,tmp));
t47=C_mutate((C_word*)lf[47]+1 /* (set! scheme#length ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11830,a[2]=((C_word)li45),tmp=(C_word)a,a+=3,tmp));
t48=C_mutate((C_word*)lf[48]+1 /* (set! scheme#list-tail ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11833,a[2]=((C_word)li46),tmp=(C_word)a,a+=3,tmp));
t49=C_mutate((C_word*)lf[49]+1 /* (set! scheme#list-ref ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11836,a[2]=((C_word)li47),tmp=(C_word)a,a+=3,tmp));
t50=C_mutate((C_word*)lf[50]+1 /* (set! scheme#reverse ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11839,a[2]=((C_word)li49),tmp=(C_word)a,a+=3,tmp));
t51=C_mutate((C_word*)lf[53]+1 /* (set! scheme#memq ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11878,a[2]=((C_word)li50),tmp=(C_word)a,a+=3,tmp));
t52=C_mutate((C_word*)lf[54]+1 /* (set! scheme#memv ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11881,a[2]=((C_word)li51),tmp=(C_word)a,a+=3,tmp));
t53=C_mutate((C_word*)lf[55]+1 /* (set! scheme#member ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11884,a[2]=((C_word)li53),tmp=(C_word)a,a+=3,tmp));
t54=C_mutate((C_word*)lf[56]+1 /* (set! scheme#assq ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11928,a[2]=((C_word)li54),tmp=(C_word)a,a+=3,tmp));
t55=C_mutate((C_word*)lf[57]+1 /* (set! scheme#assv ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11931,a[2]=((C_word)li55),tmp=(C_word)a,a+=3,tmp));
t56=C_mutate((C_word*)lf[58]+1 /* (set! scheme#assoc ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11934,a[2]=((C_word)li57),tmp=(C_word)a,a+=3,tmp));
t57=C_mutate((C_word*)lf[59]+1 /* (set! scheme#list? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11983,a[2]=((C_word)li58),tmp=(C_word)a,a+=3,tmp));
t58=C_mutate((C_word*)lf[60]+1 /* (set! scheme#string? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11986,a[2]=((C_word)li59),tmp=(C_word)a,a+=3,tmp));
t59=C_mutate((C_word*)lf[61]+1 /* (set! scheme#string-length ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11989,a[2]=((C_word)li60),tmp=(C_word)a,a+=3,tmp));
t60=C_mutate((C_word*)lf[62]+1 /* (set! scheme#string-ref ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11992,a[2]=((C_word)li61),tmp=(C_word)a,a+=3,tmp));
t61=C_mutate((C_word*)lf[63]+1 /* (set! scheme#string-set! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11995,a[2]=((C_word)li62),tmp=(C_word)a,a+=3,tmp));
t62=C_mutate((C_word*)lf[64]+1 /* (set! scheme#string=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_11998,a[2]=((C_word)li64),tmp=(C_word)a,a+=3,tmp));
t63=C_mutate((C_word*)lf[66]+1 /* (set! scheme#string-ci=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12031,a[2]=((C_word)li66),tmp=(C_word)a,a+=3,tmp));
t64=C_set_block_item(lf[68] /* scheme#features */,0,C_SCHEME_UNDEFINED);
t65=C_set_block_item(lf[69] /* scheme#call-with-port */,0,C_SCHEME_UNDEFINED);
t66=C_set_block_item(lf[70] /* scheme#close-port */,0,C_SCHEME_UNDEFINED);
t67=C_set_block_item(lf[71] /* scheme#peek-u8 */,0,C_SCHEME_UNDEFINED);
t68=C_set_block_item(lf[72] /* scheme#string-map */,0,C_SCHEME_UNDEFINED);
t69=C_set_block_item(lf[73] /* scheme#vector-map */,0,C_SCHEME_UNDEFINED);
t70=C_set_block_item(lf[74] /* scheme#string-for-each */,0,C_SCHEME_UNDEFINED);
t71=C_set_block_item(lf[75] /* scheme#vector-for-each */,0,C_SCHEME_UNDEFINED);
t72=C_set_block_item(lf[76] /* scheme#make-list */,0,C_SCHEME_UNDEFINED);
t73=C_set_block_item(lf[77] /* scheme#list-set! */,0,C_SCHEME_UNDEFINED);
t74=C_set_block_item(lf[78] /* scheme#write-string */,0,C_SCHEME_UNDEFINED);
t75=C_set_block_item(lf[79] /* scheme#eof-object */,0,C_SCHEME_UNDEFINED);
t76=C_set_block_item(lf[80] /* scheme#list-copy */,0,C_SCHEME_UNDEFINED);
t77=C_set_block_item(lf[81] /* scheme#string->vector */,0,C_SCHEME_UNDEFINED);
t78=C_set_block_item(lf[82] /* scheme#vector->string */,0,C_SCHEME_UNDEFINED);
t79=C_set_block_item(lf[83] /* scheme#exact */,0,C_SCHEME_UNDEFINED);
t80=C_set_block_item(lf[84] /* scheme#inexact */,0,C_SCHEME_UNDEFINED);
t81=C_set_block_item(lf[85] /* scheme#make-parameter */,0,C_SCHEME_UNDEFINED);
t82=C_mutate((C_word*)lf[86]+1 /* (set! scheme#exact->inexact ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12082,a[2]=((C_word)li67),tmp=(C_word)a,a+=3,tmp));
t83=C_mutate((C_word*)lf[87]+1 /* (set! scheme#abs ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12085,a[2]=((C_word)li68),tmp=(C_word)a,a+=3,tmp));
t84=C_mutate((C_word*)lf[88]+1 /* (set! scheme#+ ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_plus,a[2]=((C_word)li69),tmp=(C_word)a,a+=3,tmp));
t85=C_mutate((C_word*)lf[89]+1 /* (set! scheme#- ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_minus,a[2]=((C_word)li70),tmp=(C_word)a,a+=3,tmp));
t86=C_mutate((C_word*)lf[90]+1 /* (set! scheme#* ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_times,a[2]=((C_word)li71),tmp=(C_word)a,a+=3,tmp));
t87=C_mutate((C_word*)lf[91]+1 /* (set! scheme#quotient ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12091,a[2]=((C_word)li72),tmp=(C_word)a,a+=3,tmp));
t88=C_mutate((C_word*)lf[92]+1 /* (set! scheme#remainder ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12094,a[2]=((C_word)li73),tmp=(C_word)a,a+=3,tmp));
t89=C_mutate((C_word*)lf[93]+1 /* (set! scheme#modulo ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12097,a[2]=((C_word)li74),tmp=(C_word)a,a+=3,tmp));
t90=C_mutate((C_word*)lf[94]+1 /* (set! scheme#even? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12100,a[2]=((C_word)li75),tmp=(C_word)a,a+=3,tmp));
t91=C_mutate((C_word*)lf[95]+1 /* (set! scheme#odd? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12103,a[2]=((C_word)li76),tmp=(C_word)a,a+=3,tmp));
t92=C_mutate((C_word*)lf[96]+1 /* (set! scheme#= ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_nequalp,a[2]=((C_word)li77),tmp=(C_word)a,a+=3,tmp));
t93=C_mutate((C_word*)lf[97]+1 /* (set! scheme#> ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_greaterp,a[2]=((C_word)li78),tmp=(C_word)a,a+=3,tmp));
t94=C_mutate((C_word*)lf[98]+1 /* (set! scheme#< ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_lessp,a[2]=((C_word)li79),tmp=(C_word)a,a+=3,tmp));
t95=C_mutate((C_word*)lf[99]+1 /* (set! scheme#>= ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_greater_or_equal_p,a[2]=((C_word)li80),tmp=(C_word)a,a+=3,tmp));
t96=C_mutate((C_word*)lf[100]+1 /* (set! scheme#<= ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_less_or_equal_p,a[2]=((C_word)li81),tmp=(C_word)a,a+=3,tmp));
t97=C_mutate((C_word*)lf[101]+1 /* (set! scheme#number? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12111,a[2]=((C_word)li82),tmp=(C_word)a,a+=3,tmp));
t98=C_mutate((C_word*)lf[102]+1 /* (set! scheme#complex? ...) */,*((C_word*)lf[101]+1));
t99=C_mutate((C_word*)lf[103]+1 /* (set! scheme#real? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12115,a[2]=((C_word)li83),tmp=(C_word)a,a+=3,tmp));
t100=C_mutate((C_word*)lf[104]+1 /* (set! scheme#rational? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12118,a[2]=((C_word)li84),tmp=(C_word)a,a+=3,tmp));
t101=C_mutate((C_word*)lf[105]+1 /* (set! scheme#integer? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12121,a[2]=((C_word)li85),tmp=(C_word)a,a+=3,tmp));
t102=C_mutate((C_word*)lf[106]+1 /* (set! scheme#exact? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12124,a[2]=((C_word)li86),tmp=(C_word)a,a+=3,tmp));
t103=C_mutate((C_word*)lf[107]+1 /* (set! scheme#inexact? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12127,a[2]=((C_word)li87),tmp=(C_word)a,a+=3,tmp));
t104=C_mutate((C_word*)lf[108]+1 /* (set! scheme#zero? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12130,a[2]=((C_word)li88),tmp=(C_word)a,a+=3,tmp));
t105=C_mutate((C_word*)lf[109]+1 /* (set! scheme#positive? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12133,a[2]=((C_word)li89),tmp=(C_word)a,a+=3,tmp));
t106=C_mutate((C_word*)lf[110]+1 /* (set! scheme#negative? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12136,a[2]=((C_word)li90),tmp=(C_word)a,a+=3,tmp));
t107=C_mutate((C_word*)lf[111]+1 /* (set! scheme#number->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_number_to_string,a[2]=((C_word)li91),tmp=(C_word)a,a+=3,tmp));
t108=C_mutate((C_word*)lf[112]+1 /* (set! scheme#symbol? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12140,a[2]=((C_word)li92),tmp=(C_word)a,a+=3,tmp));
t109=C_mutate((C_word*)lf[113]+1 /* (set! scheme#vector? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12143,a[2]=((C_word)li93),tmp=(C_word)a,a+=3,tmp));
t110=C_mutate((C_word*)lf[114]+1 /* (set! scheme#vector-length ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12146,a[2]=((C_word)li94),tmp=(C_word)a,a+=3,tmp));
t111=C_mutate((C_word*)lf[115]+1 /* (set! scheme#vector-ref ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12149,a[2]=((C_word)li95),tmp=(C_word)a,a+=3,tmp));
t112=C_mutate((C_word*)lf[116]+1 /* (set! scheme#vector-set! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12152,a[2]=((C_word)li96),tmp=(C_word)a,a+=3,tmp));
t113=C_set_block_item(lf[117] /* scheme#make-vector */,0,C_SCHEME_UNDEFINED);
t114=C_set_block_item(lf[118] /* scheme#list->vector */,0,C_SCHEME_UNDEFINED);
t115=C_set_block_item(lf[119] /* scheme#vector->list */,0,C_SCHEME_UNDEFINED);
t116=C_set_block_item(lf[120] /* scheme#vector */,0,C_SCHEME_UNDEFINED);
t117=C_set_block_item(lf[121] /* scheme#vector-fill! */,0,C_SCHEME_UNDEFINED);
t118=C_mutate((C_word*)lf[122]+1 /* (set! scheme#char? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12160,a[2]=((C_word)li97),tmp=(C_word)a,a+=3,tmp));
t119=C_mutate((C_word*)lf[123]+1 /* (set! scheme#char->integer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12163,a[2]=((C_word)li98),tmp=(C_word)a,a+=3,tmp));
t120=C_mutate((C_word*)lf[125]+1 /* (set! scheme#integer->char ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12170,a[2]=((C_word)li99),tmp=(C_word)a,a+=3,tmp));
t121=C_mutate((C_word*)lf[127]+1 /* (set! scheme#char=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12177,a[2]=((C_word)li101),tmp=(C_word)a,a+=3,tmp));
t122=C_mutate((C_word*)lf[129]+1 /* (set! scheme#char>? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12216,a[2]=((C_word)li103),tmp=(C_word)a,a+=3,tmp));
t123=C_mutate((C_word*)lf[131]+1 /* (set! scheme#char<? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12255,a[2]=((C_word)li105),tmp=(C_word)a,a+=3,tmp));
t124=C_mutate((C_word*)lf[133]+1 /* (set! scheme#char>=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12294,a[2]=((C_word)li107),tmp=(C_word)a,a+=3,tmp));
t125=C_mutate((C_word*)lf[135]+1 /* (set! scheme#char<=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12333,a[2]=((C_word)li109),tmp=(C_word)a,a+=3,tmp));
t126=C_mutate((C_word*)lf[137]+1 /* (set! scheme#char-upcase ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12372,a[2]=((C_word)li110),tmp=(C_word)a,a+=3,tmp));
t127=C_mutate((C_word*)lf[139]+1 /* (set! scheme#char-downcase ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12378,a[2]=((C_word)li111),tmp=(C_word)a,a+=3,tmp));
t128=C_set_block_item(lf[141] /* scheme#char-ci=? */,0,C_SCHEME_UNDEFINED);
t129=C_set_block_item(lf[142] /* scheme#char-ci>? */,0,C_SCHEME_UNDEFINED);
t130=C_set_block_item(lf[143] /* scheme#char-ci<? */,0,C_SCHEME_UNDEFINED);
t131=C_set_block_item(lf[144] /* scheme#char-ci>=? */,0,C_SCHEME_UNDEFINED);
t132=C_set_block_item(lf[145] /* scheme#char-ci<=? */,0,C_SCHEME_UNDEFINED);
t133=C_mutate((C_word*)lf[146]+1 /* (set! scheme#char-upper-case? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12389,a[2]=((C_word)li112),tmp=(C_word)a,a+=3,tmp));
t134=C_mutate((C_word*)lf[148]+1 /* (set! scheme#char-lower-case? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12395,a[2]=((C_word)li113),tmp=(C_word)a,a+=3,tmp));
t135=C_mutate((C_word*)lf[150]+1 /* (set! scheme#char-numeric? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12401,a[2]=((C_word)li114),tmp=(C_word)a,a+=3,tmp));
t136=C_mutate((C_word*)lf[152]+1 /* (set! scheme#char-whitespace? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12407,a[2]=((C_word)li115),tmp=(C_word)a,a+=3,tmp));
t137=C_mutate((C_word*)lf[154]+1 /* (set! scheme#char-alphabetic? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12413,a[2]=((C_word)li116),tmp=(C_word)a,a+=3,tmp));
t138=C_mutate((C_word*)lf[156]+1 /* (set! scheme.char#digit-value ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12419,a[2]=((C_word)li117),tmp=(C_word)a,a+=3,tmp));
t139=C_mutate((C_word*)lf[158]+1 /* (set! scheme#procedure? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12435,a[2]=((C_word)li118),tmp=(C_word)a,a+=3,tmp));
t140=C_mutate((C_word*)lf[159]+1 /* (set! scheme#apply ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_apply,a[2]=((C_word)li119),tmp=(C_word)a,a+=3,tmp));
t141=C_mutate((C_word*)lf[160]+1 /* (set! scheme#values ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_values,a[2]=((C_word)li120),tmp=(C_word)a,a+=3,tmp));
t142=C_mutate((C_word*)lf[161]+1 /* (set! scheme#call-with-values ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_call_with_values,a[2]=((C_word)li121),tmp=(C_word)a,a+=3,tmp));
t143=C_set_block_item(lf[162] /* scheme#call-with-current-continuation */,0,C_SCHEME_UNDEFINED);
t144=C_set_block_item(lf[163] /* scheme#call/cc */,0,C_SCHEME_UNDEFINED);
t145=C_mutate((C_word*)lf[164]+1 /* (set! scheme#input-port? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12443,a[2]=((C_word)li122),tmp=(C_word)a,a+=3,tmp));
t146=C_mutate((C_word*)lf[165]+1 /* (set! scheme#output-port? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12449,a[2]=((C_word)li123),tmp=(C_word)a,a+=3,tmp));
t147=C_mutate((C_word*)lf[166]+1 /* (set! scheme#binary-port? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12455,a[2]=((C_word)li124),tmp=(C_word)a,a+=3,tmp));
t148=C_mutate((C_word*)lf[169]+1 /* (set! scheme#textual-port? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12471,a[2]=((C_word)li125),tmp=(C_word)a,a+=3,tmp));
t149=C_mutate((C_word*)lf[168]+1 /* (set! scheme#port? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12487,a[2]=((C_word)li126),tmp=(C_word)a,a+=3,tmp));
t150=C_mutate((C_word*)lf[171]+1 /* (set! scheme#input-port-open? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12493,a[2]=((C_word)li127),tmp=(C_word)a,a+=3,tmp));
t151=C_mutate((C_word*)lf[173]+1 /* (set! scheme#output-port-open? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12498,a[2]=((C_word)li128),tmp=(C_word)a,a+=3,tmp));
t152=C_set_block_item(lf[175] /* scheme#current-input-port */,0,C_SCHEME_UNDEFINED);
t153=C_set_block_item(lf[176] /* scheme#current-output-port */,0,C_SCHEME_UNDEFINED);
t154=C_set_block_item(lf[177] /* scheme#open-input-file */,0,C_SCHEME_UNDEFINED);
t155=C_set_block_item(lf[178] /* scheme#open-output-file */,0,C_SCHEME_UNDEFINED);
t156=C_set_block_item(lf[179] /* scheme#close-input-port */,0,C_SCHEME_UNDEFINED);
t157=C_set_block_item(lf[180] /* scheme#close-output-port */,0,C_SCHEME_UNDEFINED);
t158=C_set_block_item(lf[181] /* scheme#call-with-input-file */,0,C_SCHEME_UNDEFINED);
t159=C_set_block_item(lf[182] /* scheme#call-with-output-file */,0,C_SCHEME_UNDEFINED);
t160=C_set_block_item(lf[183] /* scheme#with-input-from-file */,0,C_SCHEME_UNDEFINED);
t161=C_set_block_item(lf[184] /* scheme#with-output-to-file */,0,C_SCHEME_UNDEFINED);
t162=C_mutate((C_word*)lf[185]+1 /* (set! scheme#eof-object? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12513,a[2]=((C_word)li129),tmp=(C_word)a,a+=3,tmp));
t163=C_set_block_item(lf[186] /* scheme#char-ready? */,0,C_SCHEME_UNDEFINED);
t164=C_set_block_item(lf[187] /* scheme#read-char */,0,C_SCHEME_UNDEFINED);
t165=C_set_block_item(lf[188] /* scheme#peek-char */,0,C_SCHEME_UNDEFINED);
t166=C_set_block_item(lf[189] /* scheme#read */,0,C_SCHEME_UNDEFINED);
t167=C_set_block_item(lf[190] /* scheme#write-char */,0,C_SCHEME_UNDEFINED);
t168=C_set_block_item(lf[191] /* scheme#newline */,0,C_SCHEME_UNDEFINED);
t169=C_set_block_item(lf[192] /* scheme#write */,0,C_SCHEME_UNDEFINED);
t170=C_set_block_item(lf[193] /* scheme#display */,0,C_SCHEME_UNDEFINED);
t171=C_mutate((C_word*)lf[194]+1 /* (set! scheme#eval ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12524,a[2]=((C_word)li130),tmp=(C_word)a,a+=3,tmp));
t172=C_mutate((C_word*)lf[198]+1 /* (set! scheme#interaction-environment ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12530,a[2]=((C_word)li131),tmp=(C_word)a,a+=3,tmp));
t173=C_mutate((C_word*)lf[201]+1 /* (set! scheme#scheme-report-environment ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12536,a[2]=((C_word)li132),tmp=(C_word)a,a+=3,tmp));
t174=C_mutate((C_word*)lf[204]+1 /* (set! scheme#null-environment ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12542,a[2]=((C_word)li133),tmp=(C_word)a,a+=3,tmp));
t175=C_mutate((C_word*)lf[207]+1 /* (set! scheme#load ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12548,a[2]=((C_word)li134),tmp=(C_word)a,a+=3,tmp));
t176=C_set_block_item(lf[210] /* scheme#for-each */,0,C_SCHEME_UNDEFINED);
t177=C_set_block_item(lf[211] /* scheme#map */,0,C_SCHEME_UNDEFINED);
t178=C_set_block_item(lf[212] /* scheme#dynamic-wind */,0,C_SCHEME_UNDEFINED);
t179=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12558,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);{
C_word *av2=av;
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t179;
C_library_toplevel(2,av2);}}

/* scheme#not in k11433 */
static void C_ccall f_11437(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11437,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_not(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#boolean? in k11433 */
static void C_ccall f_11440(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11440,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_booleanp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#eq? in k11433 */
static void C_ccall f_11443(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11443,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_eqp(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#eqv? in k11433 */
static void C_ccall f_11446(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11446,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_eqvp(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#equal? in k11433 */
static void C_ccall f_11449(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11449,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_equalp(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#boolean=? in k11433 */
static void C_ccall f_11452(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,3)))){
C_save_and_reclaim((void*)f_11452,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t5=C_i_check_boolean_2(t2,lf[8]);
t6=C_i_check_boolean_2(t3,lf[8]);
t7=C_eqp(t2,t3);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11468,a[2]=t3,a[3]=((C_word)li5),tmp=(C_word)a,a+=4,tmp);
t9=t1;{
C_word *av2=av;
av2[0]=t9;
av2[1]=(
  f_11468(t8,t4,t7)
);
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}

/* loop in scheme#boolean=? in k11433 */
static C_word f_11468(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t1))){
return(t2);}
else{
t3=C_slot(t1,C_fix(0));
t4=C_i_check_boolean_2(t3,lf[8]);
t5=C_slot(t1,C_fix(1));
if(C_truep(t2)){
t7=t5;
t8=C_eqp(t3,((C_word*)t0)[2]);
t1=t7;
t2=t8;
goto loop;}
else{
t7=t5;
t8=C_SCHEME_FALSE;
t1=t7;
t2=t8;
goto loop;}}}

/* scheme#symbol=? in k11433 */
static void C_ccall f_11497(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,3)))){
C_save_and_reclaim((void*)f_11497,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t5=C_i_check_symbol_2(t2,lf[10]);
t6=C_i_check_symbol_2(t3,lf[10]);
t7=C_eqp(t2,t3);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_11513,a[2]=t3,a[3]=((C_word)li7),tmp=(C_word)a,a+=4,tmp);
t9=t1;{
C_word *av2=av;
av2[0]=t9;
av2[1]=(
  f_11513(t8,t4,t7)
);
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}

/* loop in scheme#symbol=? in k11433 */
static C_word f_11513(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t1))){
return(t2);}
else{
t3=C_slot(t1,C_fix(0));
t4=C_i_check_symbol_2(t3,lf[10]);
t5=C_slot(t1,C_fix(1));
if(C_truep(t2)){
t7=t5;
t8=C_eqp(t3,((C_word*)t0)[2]);
t1=t7;
t2=t8;
goto loop;}
else{
t7=t5;
t8=C_SCHEME_FALSE;
t1=t7;
t2=t8;
goto loop;}}}

/* scheme#pair? in k11433 */
static void C_ccall f_11542(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11542,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_pairp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#cons in k11433 */
static void C_ccall f_11545(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_11545,c,av);}
a=C_alloc(3);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_cons(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#car in k11433 */
static void C_ccall f_11548(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11548,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_car(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#cdr in k11433 */
static void C_ccall f_11551(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11551,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cdr(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#set-car! in k11433 */
static void C_ccall f_11554(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11554,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_set_car(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#set-cdr! in k11433 */
static void C_ccall f_11557(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11557,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_set_cdr(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#cadr in k11433 */
static void C_ccall f_11560(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11560,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cadr(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#caddr in k11433 */
static void C_ccall f_11563(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11563,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_caddr(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#cadddr in k11433 */
static void C_ccall f_11566(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11566,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cadddr(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#cddddr in k11433 */
static void C_ccall f_11569(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11569,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cddddr(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#caar in k11433 */
static void C_ccall f_11572(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11572,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_caar(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#cdar in k11433 */
static void C_ccall f_11575(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11575,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cdar(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#cddr in k11433 */
static void C_ccall f_11578(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11578,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cddr(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#caaar in k11433 */
static void C_ccall f_11581(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11581,c,av);}
t3=C_i_car(t2);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_car(C_i_car(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#caadr in k11433 */
static void C_ccall f_11595(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11595,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_car(C_i_cadr(t2));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#cadar in k11433 */
static void C_ccall f_11602(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11602,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cadr(C_i_car(t2));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#cdaar in k11433 */
static void C_ccall f_11609(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11609,c,av);}
t3=C_i_car(t2);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_cdr(C_i_car(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#cdadr in k11433 */
static void C_ccall f_11623(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11623,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cdr(C_i_cadr(t2));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#cddar in k11433 */
static void C_ccall f_11630(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11630,c,av);}
t3=C_i_car(t2);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_cdr(C_i_cdr(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#cdddr in k11433 */
static void C_ccall f_11644(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11644,c,av);}
t3=C_i_cdr(t2);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_cdr(C_i_cdr(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#caaaar in k11433 */
static void C_ccall f_11658(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11658,c,av);}
t3=C_i_car(t2);
t4=C_i_car(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_i_car(C_i_car(t4));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#caaadr in k11433 */
static void C_ccall f_11676(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11676,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_car(C_i_car(C_i_cadr(t2)));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#caadar in k11433 */
static void C_ccall f_11687(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11687,c,av);}
t3=C_i_car(t2);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_car(C_i_cadr(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#caaddr in k11433 */
static void C_ccall f_11698(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11698,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_car(C_i_caddr(t2));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#cadaar in k11433 */
static void C_ccall f_11705(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11705,c,av);}
t3=C_i_car(t2);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_cadr(C_i_car(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#cadadr in k11433 */
static void C_ccall f_11716(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11716,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cadr(C_i_cadr(t2));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#caddar in k11433 */
static void C_ccall f_11720(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11720,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_caddr(C_i_car(t2));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#cdaaar in k11433 */
static void C_ccall f_11727(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11727,c,av);}
t3=C_i_car(t2);
t4=C_i_car(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_i_cdr(C_i_car(t4));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#cdaadr in k11433 */
static void C_ccall f_11745(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11745,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cdr(C_i_car(C_i_cadr(t2)));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#cdadar in k11433 */
static void C_ccall f_11756(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11756,c,av);}
t3=C_i_car(t2);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_cdr(C_i_cadr(t3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#cdaddr in k11433 */
static void C_ccall f_11767(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11767,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cdr(C_i_caddr(t2));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#cddaar in k11433 */
static void C_ccall f_11774(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11774,c,av);}
t3=C_i_car(t2);
t4=C_i_car(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_i_cdr(C_i_cdr(t4));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#cddadr in k11433 */
static void C_ccall f_11792(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11792,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cdr(C_i_cdr(C_i_cadr(t2)));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#cdddar in k11433 */
static void C_ccall f_11803(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11803,c,av);}
t3=C_i_car(t2);
t4=C_i_cdr(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_i_cdr(C_i_cdr(t4));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#null? in k11433 */
static void C_ccall f_11821(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11821,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_eqp(t2,C_SCHEME_END_OF_LIST);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#list in k11433 */
static void C_ccall f_11827(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_11827,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+0);
t2=C_build_rest(&a,c,2,av);
C_word t3;
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#length in k11433 */
static void C_ccall f_11830(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11830,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_length(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#list-tail in k11433 */
static void C_ccall f_11833(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11833,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_list_tail(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#list-ref in k11433 */
static void C_ccall f_11836(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11836,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_list_ref(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#reverse in k11433 */
static void C_ccall f_11839(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_11839,c,av);}
a=C_alloc(7);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11845,a[2]=t4,a[3]=t2,a[4]=((C_word)li48),tmp=(C_word)a,a+=5,tmp));
t6=((C_word*)t4)[1];
f_11845(t6,t1,t2,C_SCHEME_END_OF_LIST);}

/* loop in scheme#reverse in k11433 */
static void f_11845(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(3,0,3)))){
C_save_and_reclaim_args((void *)trf_11845,4,t0,t1,t2,t3);}
a=C_alloc(3);
t4=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t4)){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t2))){
t5=C_slot(t2,C_fix(1));
t6=C_slot(t2,C_fix(0));
t7=C_a_i_cons(&a,2,t6,t3);
/* library.scm:353: loop */
t9=t1;
t10=t5;
t11=t7;
t1=t9;
t2=t10;
t3=t11;
goto loop;}
else{
/* library.scm:354: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[51]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[51]+1);
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
av2[3]=lf[52];
tp(4,av2);}}}}

/* scheme#memq in k11433 */
static void C_ccall f_11878(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11878,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_memq(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#memv in k11433 */
static void C_ccall f_11881(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11881,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_memv(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#member in k11433 */
static void C_ccall f_11884(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_11884,c,av);}
a=C_alloc(8);
t4=C_rest_nullp(c,4);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_get_rest_arg(c,4,av,4,t0));
if(C_truep(t5)){
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_11896,a[2]=t7,a[3]=t5,a[4]=t2,a[5]=((C_word)li52),tmp=(C_word)a,a+=6,tmp));
t9=((C_word*)t7)[1];
f_11896(t9,t1,t3);}
else{
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_i_member(t2,t3);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* loop in scheme#member in k11433 */
static void f_11896(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_11896,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11909,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* library.scm:363: eq */
t4=((C_word*)t0)[3];{
C_word av2[4];
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
av2[3]=C_slot(t2,C_fix(0));
((C_proc)C_fast_retrieve_proc(t4))(4,av2);}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k11907 in loop in scheme#member in k11433 */
static void C_ccall f_11909(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_11909,c,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* library.scm:365: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_11896(t2,((C_word*)t0)[2],C_slot(((C_word*)t0)[3],C_fix(1)));}}

/* scheme#assq in k11433 */
static void C_ccall f_11928(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11928,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_assq(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#assv in k11433 */
static void C_ccall f_11931(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11931,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_assv(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#assoc in k11433 */
static void C_ccall f_11934(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_11934,c,av);}
a=C_alloc(8);
t4=C_rest_nullp(c,4);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_get_rest_arg(c,4,av,4,t0));
if(C_truep(t5)){
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_11946,a[2]=t7,a[3]=t5,a[4]=t2,a[5]=((C_word)li56),tmp=(C_word)a,a+=6,tmp));
t9=((C_word*)t7)[1];
f_11946(t9,t1,t3);}
else{
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_i_assoc(t2,t3);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* loop in scheme#assoc in k11433 */
static void f_11946(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_11946,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_11959,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
t4=C_slot(t2,C_fix(0));
/* library.scm:375: eq */
t5=((C_word*)t0)[3];{
C_word av2[4];
av2[0]=t5;
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
av2[3]=C_i_car(t4);
((C_proc)C_fast_retrieve_proc(t5))(4,av2);}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k11957 in loop in scheme#assoc in k11433 */
static void C_ccall f_11959(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_11959,c,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_u_i_car(((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* library.scm:377: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_11946(t2,((C_word*)t0)[2],C_slot(((C_word*)t0)[3],C_fix(1)));}}

/* scheme#list? in k11433 */
static void C_ccall f_11983(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11983,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_listp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#string? in k11433 */
static void C_ccall f_11986(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11986,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_stringp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#string-length in k11433 */
static void C_ccall f_11989(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11989,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_string_length(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#string-ref in k11433 */
static void C_ccall f_11992(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11992,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_string_ref(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#string-set! in k11433 */
static void C_ccall f_11995(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_11995,c,av);}
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_i_string_set(t2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#string=? in k11433 */
static void C_ccall f_11998(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,4)))){
C_save_and_reclaim((void*)f_11998,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
t5=C_i_string_equal_p(t2,t3);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12005,a[2]=((C_word)li63),tmp=(C_word)a,a+=3,tmp);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(
  f_12005(t3,t4,t5)
);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* loop in scheme#string=? in k11433 */
static C_word f_12005(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t2))){
return(t3);}
else{
t4=C_slot(t2,C_fix(0));
t5=C_i_check_string_2(t4,lf[65]);
t6=C_slot(t2,C_fix(1));
if(C_truep(t3)){
t8=t4;
t9=t6;
t10=C_i_string_equal_p(t1,t4);
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t8=t4;
t9=t6;
t10=C_SCHEME_FALSE;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}}

/* scheme#string-ci=? in k11433 */
static void C_ccall f_12031(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,4)))){
C_save_and_reclaim((void*)f_12031,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
t5=C_i_string_ci_equal_p(t2,t3);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12038,a[2]=((C_word)li65),tmp=(C_word)a,a+=3,tmp);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(
  f_12038(t3,t4,t5)
);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* loop in scheme#string-ci=? in k11433 */
static C_word f_12038(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t2))){
return(t3);}
else{
t4=C_slot(t2,C_fix(0));
t5=C_i_check_string_2(t4,lf[67]);
t6=C_slot(t2,C_fix(1));
if(C_truep(t3)){
t8=t4;
t9=t6;
t10=C_i_string_ci_equal_p(t1,t4);
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t8=t4;
t9=t6;
t10=C_SCHEME_FALSE;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}}

/* scheme#exact->inexact in k11433 */
static void C_ccall f_12082(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(12,c,1)))){
C_save_and_reclaim((void *)f_12082,c,av);}
a=C_alloc(12);
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_exact_to_inexact(&a,1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#abs in k11433 */
static void C_ccall f_12085(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,1)))){
C_save_and_reclaim((void *)f_12085,c,av);}
a=C_alloc(7);
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_i_abs(&a,1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#quotient in k11433 */
static void C_ccall f_12091(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_12091,c,av);}
a=C_alloc(5);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_s_a_i_quotient(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#remainder in k11433 */
static void C_ccall f_12094(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_12094,c,av);}
a=C_alloc(5);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_s_a_i_remainder(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#modulo in k11433 */
static void C_ccall f_12097(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_12097,c,av);}
a=C_alloc(5);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_s_a_i_modulo(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#even? in k11433 */
static void C_ccall f_12100(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12100,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_evenp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#odd? in k11433 */
static void C_ccall f_12103(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12103,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_oddp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#number? in k11433 */
static void C_ccall f_12111(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12111,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_numberp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#real? in k11433 */
static void C_ccall f_12115(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12115,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_realp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#rational? in k11433 */
static void C_ccall f_12118(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12118,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_rationalp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#integer? in k11433 */
static void C_ccall f_12121(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12121,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_integerp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#exact? in k11433 */
static void C_ccall f_12124(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12124,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_exactp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#inexact? in k11433 */
static void C_ccall f_12127(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12127,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_inexactp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#zero? in k11433 */
static void C_ccall f_12130(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12130,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_zerop(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#positive? in k11433 */
static void C_ccall f_12133(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12133,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_positivep(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#negative? in k11433 */
static void C_ccall f_12136(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12136,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_negativep(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#symbol? in k11433 */
static void C_ccall f_12140(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12140,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_symbolp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#vector? in k11433 */
static void C_ccall f_12143(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12143,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_vectorp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#vector-length in k11433 */
static void C_ccall f_12146(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12146,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_vector_length(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#vector-ref in k11433 */
static void C_ccall f_12149(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12149,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_vector_ref(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#vector-set! in k11433 */
static void C_ccall f_12152(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12152,c,av);}
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_i_vector_set(t2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#char? in k11433 */
static void C_ccall f_12160(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12160,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_charp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#char->integer in k11433 */
static void C_ccall f_12163(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12163,c,av);}
t3=C_i_check_char_2(t2,lf[124]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fix(C_character_code(t2));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#integer->char in k11433 */
static void C_ccall f_12170(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12170,c,av);}
t3=C_i_check_fixnum_2(t2,lf[126]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_make_character(C_unfix(t2));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#char=? in k11433 */
static void C_ccall f_12177(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,4)))){
C_save_and_reclaim((void*)f_12177,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t5=C_i_check_char_2(t2,lf[128]);
t6=C_i_check_char_2(t3,lf[128]);
t7=C_u_i_char_equalp(t2,t3);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12190,a[2]=((C_word)li100),tmp=(C_word)a,a+=3,tmp);
t9=t1;{
C_word *av2=av;
av2[0]=t9;
av2[1]=(
  f_12190(t3,t4,t7)
);
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}

/* loop in scheme#char=? in k11433 */
static C_word f_12190(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t2))){
return(t3);}
else{
t4=C_slot(t2,C_fix(0));
t5=C_i_check_char_2(t4,lf[128]);
t6=C_slot(t2,C_fix(1));
if(C_truep(t3)){
t8=t4;
t9=t6;
t10=C_u_i_char_equalp(t1,t4);
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t8=t4;
t9=t6;
t10=C_SCHEME_FALSE;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}}

/* scheme#char>? in k11433 */
static void C_ccall f_12216(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,4)))){
C_save_and_reclaim((void*)f_12216,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t5=C_i_check_char_2(t2,lf[130]);
t6=C_i_check_char_2(t3,lf[130]);
t7=C_u_i_char_greaterp(t2,t3);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12229,a[2]=((C_word)li102),tmp=(C_word)a,a+=3,tmp);
t9=t1;{
C_word *av2=av;
av2[0]=t9;
av2[1]=(
  f_12229(t3,t4,t7)
);
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}

/* loop in scheme#char>? in k11433 */
static C_word f_12229(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t2))){
return(t3);}
else{
t4=C_slot(t2,C_fix(0));
t5=C_i_check_char_2(t4,lf[130]);
t6=C_slot(t2,C_fix(1));
if(C_truep(t3)){
t8=t4;
t9=t6;
t10=C_u_i_char_greaterp(t1,t4);
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t8=t4;
t9=t6;
t10=C_SCHEME_FALSE;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}}

/* scheme#char<? in k11433 */
static void C_ccall f_12255(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,4)))){
C_save_and_reclaim((void*)f_12255,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t5=C_i_check_char_2(t2,lf[132]);
t6=C_i_check_char_2(t3,lf[132]);
t7=C_u_i_char_lessp(t2,t3);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12268,a[2]=((C_word)li104),tmp=(C_word)a,a+=3,tmp);
t9=t1;{
C_word *av2=av;
av2[0]=t9;
av2[1]=(
  f_12268(t3,t4,t7)
);
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}

/* loop in scheme#char<? in k11433 */
static C_word f_12268(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t2))){
return(t3);}
else{
t4=C_slot(t2,C_fix(0));
t5=C_i_check_char_2(t4,lf[132]);
t6=C_slot(t2,C_fix(1));
if(C_truep(t3)){
t8=t4;
t9=t6;
t10=C_u_i_char_lessp(t1,t4);
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t8=t4;
t9=t6;
t10=C_SCHEME_FALSE;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}}

/* scheme#char>=? in k11433 */
static void C_ccall f_12294(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,4)))){
C_save_and_reclaim((void*)f_12294,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t5=C_i_check_char_2(t2,lf[134]);
t6=C_i_check_char_2(t3,lf[134]);
t7=C_u_i_char_greater_or_equal_p(t2,t3);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12307,a[2]=((C_word)li106),tmp=(C_word)a,a+=3,tmp);
t9=t1;{
C_word *av2=av;
av2[0]=t9;
av2[1]=(
  f_12307(t3,t4,t7)
);
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}

/* loop in scheme#char>=? in k11433 */
static C_word f_12307(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t2))){
return(t3);}
else{
t4=C_slot(t2,C_fix(0));
t5=C_i_check_char_2(t4,lf[134]);
t6=C_slot(t2,C_fix(1));
if(C_truep(t3)){
t8=t4;
t9=t6;
t10=C_u_i_char_greater_or_equal_p(t1,t4);
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t8=t4;
t9=t6;
t10=C_SCHEME_FALSE;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}}

/* scheme#char<=? in k11433 */
static void C_ccall f_12333(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,4)))){
C_save_and_reclaim((void*)f_12333,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t5=C_i_check_char_2(t2,lf[136]);
t6=C_i_check_char_2(t3,lf[136]);
t7=C_u_i_char_less_or_equal_p(t2,t3);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12346,a[2]=((C_word)li108),tmp=(C_word)a,a+=3,tmp);
t9=t1;{
C_word *av2=av;
av2[0]=t9;
av2[1]=(
  f_12346(t3,t4,t7)
);
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}

/* loop in scheme#char<=? in k11433 */
static C_word f_12346(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t2))){
return(t3);}
else{
t4=C_slot(t2,C_fix(0));
t5=C_i_check_char_2(t4,lf[136]);
t6=C_slot(t2,C_fix(1));
if(C_truep(t3)){
t8=t4;
t9=t6;
t10=C_u_i_char_less_or_equal_p(t1,t4);
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t8=t4;
t9=t6;
t10=C_SCHEME_FALSE;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}}

/* scheme#char-upcase in k11433 */
static void C_ccall f_12372(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12372,c,av);}
t3=C_i_check_char_2(t2,lf[138]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_char_upcase(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#char-downcase in k11433 */
static void C_ccall f_12378(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12378,c,av);}
t3=C_i_check_char_2(t2,lf[140]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_char_downcase(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#char-upper-case? in k11433 */
static void C_ccall f_12389(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12389,c,av);}
t3=C_i_check_char_2(t2,lf[147]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_char_upper_casep(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#char-lower-case? in k11433 */
static void C_ccall f_12395(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12395,c,av);}
t3=C_i_check_char_2(t2,lf[149]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_char_lower_casep(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#char-numeric? in k11433 */
static void C_ccall f_12401(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12401,c,av);}
t3=C_i_check_char_2(t2,lf[151]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_char_numericp(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#char-whitespace? in k11433 */
static void C_ccall f_12407(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12407,c,av);}
t3=C_i_check_char_2(t2,lf[153]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_char_whitespacep(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#char-alphabetic? in k11433 */
static void C_ccall f_12413(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12413,c,av);}
t3=C_i_check_char_2(t2,lf[155]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_char_alphabeticp(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme.char#digit-value in k11433 */
static void C_ccall f_12419(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12419,c,av);}
t3=C_i_check_char_2(t2,lf[157]);
t4=C_u_i_digit_value(t2);
t5=C_eqp(t4,C_fix(0));
t6=C_i_not(t5);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?C_fixnum_difference(t4,C_fix(1)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* scheme#procedure? in k11433 */
static void C_ccall f_12435(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12435,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_closurep(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#input-port? in k11433 */
static void C_ccall f_12443(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12443,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(C_blockp(t2))?C_input_portp(t2):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#output-port? in k11433 */
static void C_ccall f_12449(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12449,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(C_blockp(t2))?C_output_portp(t2):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#binary-port? in k11433 */
static void C_ccall f_12455(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_12455,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12462,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:682: port? */
t4=*((C_word*)lf[168]+1);{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k12460 in scheme#binary-port? in k11433 */
static void C_ccall f_12462(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12462,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=(C_truep(t1)?C_eqp(lf[167],C_slot(((C_word*)t0)[3],C_fix(14))):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* scheme#textual-port? in k11433 */
static void C_ccall f_12471(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_12471,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12478,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:686: port? */
t4=*((C_word*)lf[168]+1);{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k12476 in scheme#textual-port? in k11433 */
static void C_ccall f_12478(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12478,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=(C_truep(t1)?C_eqp(lf[170],C_slot(((C_word*)t0)[3],C_fix(14))):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* scheme#port? in k11433 */
static void C_ccall f_12487(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12487,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(C_blockp(t2))?C_portp(t2):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#input-port-open? in k11433 */
static void C_ccall f_12493(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12493,c,av);}
t3=C_i_check_port(t2,C_fix(1),lf[172]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_input_port_openp(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#output-port-open? in k11433 */
static void C_ccall f_12498(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12498,c,av);}
t3=C_i_check_port(t2,C_fix(2),lf[174]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_output_port_openp(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#eof-object? in k11433 */
static void C_ccall f_12513(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12513,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_eofp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#eval in k11433 */
static void C_ccall f_12524(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_12524,c,av);}
/* library.scm:736: ##sys#error */
t3=*((C_word*)lf[195]+1);{
C_word av2[4];
av2[0]=t3;
av2[1]=t1;
av2[2]=lf[196];
av2[3]=lf[197];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* scheme#interaction-environment in k11433 */
static void C_ccall f_12530(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_12530,c,av);}
/* library.scm:739: ##sys#error */
t2=*((C_word*)lf[195]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[199];
av2[3]=lf[200];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* scheme#scheme-report-environment in k11433 */
static void C_ccall f_12536(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_12536,c,av);}
/* library.scm:742: ##sys#error */
t3=*((C_word*)lf[195]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=lf[202];
av2[3]=lf[203];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* scheme#null-environment in k11433 */
static void C_ccall f_12542(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_12542,c,av);}
/* library.scm:745: ##sys#error */
t2=*((C_word*)lf[195]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[205];
av2[3]=lf[206];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* scheme#load in k11433 */
static void C_ccall f_12548(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_12548,c,av);}
/* library.scm:748: ##sys#error */
t3=*((C_word*)lf[195]+1);{
C_word av2[4];
av2[0]=t3;
av2[1]=t1;
av2[2]=lf[208];
av2[3]=lf[209];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k12556 in k11433 */
static void C_ccall f_12558(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word t106;
C_word t107;
C_word t108;
C_word t109;
C_word t110;
C_word t111;
C_word t112;
C_word t113;
C_word t114;
C_word t115;
C_word t116;
C_word t117;
C_word t118;
C_word t119;
C_word t120;
C_word t121;
C_word t122;
C_word t123;
C_word t124;
C_word t125;
C_word t126;
C_word t127;
C_word t128;
C_word t129;
C_word t130;
C_word t131;
C_word t132;
C_word t133;
C_word t134;
C_word t135;
C_word t136;
C_word t137;
C_word t138;
C_word t139;
C_word t140;
C_word t141;
C_word t142;
C_word t143;
C_word t144;
C_word t145;
C_word t146;
C_word t147;
C_word t148;
C_word t149;
C_word t150;
C_word t151;
C_word t152;
C_word t153;
C_word t154;
C_word t155;
C_word t156;
C_word t157;
C_word t158;
C_word t159;
C_word t160;
C_word t161;
C_word t162;
C_word t163;
C_word t164;
C_word t165;
C_word t166;
C_word t167;
C_word t168;
C_word t169;
C_word t170;
C_word t171;
C_word t172;
C_word t173;
C_word t174;
C_word t175;
C_word t176;
C_word t177;
C_word t178;
C_word t179;
C_word t180;
C_word t181;
C_word t182;
C_word t183;
C_word t184;
C_word t185;
C_word t186;
C_word t187;
C_word t188;
C_word t189;
C_word t190;
C_word t191;
C_word t192;
C_word t193;
C_word t194;
C_word t195;
C_word t196;
C_word t197;
C_word t198;
C_word t199;
C_word t200;
C_word t201;
C_word t202;
C_word t203;
C_word t204;
C_word t205;
C_word t206;
C_word t207;
C_word t208;
C_word t209;
C_word t210;
C_word t211;
C_word t212;
C_word t213;
C_word t214;
C_word t215;
C_word t216;
C_word t217;
C_word t218;
C_word t219;
C_word t220;
C_word t221;
C_word t222;
C_word t223;
C_word t224;
C_word t225;
C_word t226;
C_word t227;
C_word t228;
C_word t229;
C_word t230;
C_word t231;
C_word t232;
C_word t233;
C_word t234;
C_word t235;
C_word t236;
C_word t237;
C_word t238;
C_word t239;
C_word t240;
C_word t241;
C_word t242;
C_word t243;
C_word t244;
C_word t245;
C_word t246;
C_word t247;
C_word t248;
C_word t249;
C_word t250;
C_word t251;
C_word t252;
C_word t253;
C_word t254;
C_word t255;
C_word t256;
C_word t257;
C_word t258;
C_word t259;
C_word t260;
C_word t261;
C_word t262;
C_word t263;
C_word t264;
C_word t265;
C_word t266;
C_word t267;
C_word t268;
C_word t269;
C_word t270;
C_word t271;
C_word t272;
C_word t273;
C_word t274;
C_word t275;
C_word t276;
C_word t277;
C_word t278;
C_word t279;
C_word t280;
C_word t281;
C_word t282;
C_word t283;
C_word t284;
C_word t285;
C_word t286;
C_word t287;
C_word t288;
C_word t289;
C_word t290;
C_word t291;
C_word t292;
C_word t293;
C_word t294;
C_word t295;
C_word t296;
C_word t297;
C_word t298;
C_word t299;
C_word t300;
C_word t301;
C_word t302;
C_word t303;
C_word t304;
C_word t305;
C_word t306;
C_word t307;
C_word t308;
C_word t309;
C_word t310;
C_word t311;
C_word t312;
C_word t313;
C_word t314;
C_word t315;
C_word t316;
C_word t317;
C_word t318;
C_word t319;
C_word t320;
C_word t321;
C_word t322;
C_word t323;
C_word t324;
C_word t325;
C_word t326;
C_word t327;
C_word t328;
C_word t329;
C_word t330;
C_word t331;
C_word t332;
C_word t333;
C_word t334;
C_word t335;
C_word t336;
C_word t337;
C_word t338;
C_word t339;
C_word t340;
C_word t341;
C_word t342;
C_word t343;
C_word t344;
C_word t345;
C_word t346;
C_word t347;
C_word t348;
C_word t349;
C_word t350;
C_word t351;
C_word t352;
C_word t353;
C_word t354;
C_word t355;
C_word t356;
C_word t357;
C_word t358;
C_word t359;
C_word t360;
C_word t361;
C_word t362;
C_word t363;
C_word t364;
C_word t365;
C_word t366;
C_word t367;
C_word t368;
C_word t369;
C_word t370;
C_word t371;
C_word t372;
C_word t373;
C_word t374;
C_word t375;
C_word t376;
C_word t377;
C_word t378;
C_word t379;
C_word t380;
C_word t381;
C_word t382;
C_word t383;
C_word t384;
C_word t385;
C_word t386;
C_word t387;
C_word t388;
C_word t389;
C_word t390;
C_word t391;
C_word t392;
C_word t393;
C_word t394;
C_word t395;
C_word t396;
C_word t397;
C_word t398;
C_word t399;
C_word t400;
C_word t401;
C_word t402;
C_word t403;
C_word t404;
C_word t405;
C_word t406;
C_word t407;
C_word t408;
C_word t409;
C_word t410;
C_word t411;
C_word t412;
C_word t413;
C_word t414;
C_word t415;
C_word t416;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(1142,c,7)))){
C_save_and_reclaim((void *)f_12558,c,av);}
a=C_alloc(1142);
t2=C_a_i_provide(&a,1,lf[213]);
t3=C_mutate((C_word*)lf[214]+1 /* (set! chicken.base#fixnum? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12560,a[2]=((C_word)li135),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[215]+1 /* (set! chicken.base#flonum? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12563,a[2]=((C_word)li136),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[216]+1 /* (set! chicken.base#bignum? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12566,a[2]=((C_word)li137),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[217]+1 /* (set! chicken.base#ratnum? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12569,a[2]=((C_word)li138),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[218]+1 /* (set! chicken.base#cplxnum? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12572,a[2]=((C_word)li139),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[219]+1 /* (set! chicken.base#exact-integer? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12575,a[2]=((C_word)li140),tmp=(C_word)a,a+=3,tmp));
t9=C_set_block_item(lf[220] /* chicken.base#exact-integer-sqrt */,0,C_SCHEME_UNDEFINED);
t10=C_mutate((C_word*)lf[221]+1 /* (set! chicken.base#quotient&remainder ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_quotient_and_remainder,a[2]=((C_word)li141),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate((C_word*)lf[222]+1 /* (set! chicken.base#quotient&modulo ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12580,a[2]=((C_word)li144),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate((C_word*)lf[223]+1 /* (set! chicken.base#finite? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12627,a[2]=((C_word)li145),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate((C_word*)lf[224]+1 /* (set! chicken.base#infinite? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12630,a[2]=((C_word)li146),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate((C_word*)lf[225]+1 /* (set! chicken.base#nan? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12633,a[2]=((C_word)li147),tmp=(C_word)a,a+=3,tmp));
t15=C_mutate((C_word*)lf[226]+1 /* (set! chicken.base#signum ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_signum,a[2]=((C_word)li148),tmp=(C_word)a,a+=3,tmp));
t16=C_set_block_item(lf[227] /* chicken.base#get-call-chain */,0,C_SCHEME_UNDEFINED);
t17=C_set_block_item(lf[228] /* chicken.base#print-call-chain */,0,C_SCHEME_UNDEFINED);
t18=C_set_block_item(lf[229] /* chicken.base#print */,0,C_SCHEME_UNDEFINED);
t19=C_set_block_item(lf[230] /* chicken.base#print* */,0,C_SCHEME_UNDEFINED);
t20=C_mutate((C_word*)lf[231]+1 /* (set! chicken.base#add1 ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12641,a[2]=((C_word)li149),tmp=(C_word)a,a+=3,tmp));
t21=C_mutate((C_word*)lf[232]+1 /* (set! chicken.base#sub1 ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12647,a[2]=((C_word)li150),tmp=(C_word)a,a+=3,tmp));
t22=C_set_block_item(lf[233] /* chicken.base#current-error-port */,0,C_SCHEME_UNDEFINED);
t23=C_mutate((C_word*)lf[234]+1 /* (set! chicken.base#error ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12654,a[2]=((C_word)li151),tmp=(C_word)a,a+=3,tmp));
t24=C_mutate((C_word*)lf[237]+1 /* (set! chicken.base#void ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12669,a[2]=((C_word)li152),tmp=(C_word)a,a+=3,tmp));
t25=C_set_block_item(lf[238] /* chicken.base#sleep */,0,C_SCHEME_UNDEFINED);
t26=C_set_block_item(lf[239] /* chicken.base#char-name */,0,C_SCHEME_UNDEFINED);
t27=C_set_block_item(lf[240] /* chicken.base#getter-with-setter */,0,C_SCHEME_UNDEFINED);
t28=C_set_block_item(lf[241] /* chicken.base#procedure-information */,0,C_SCHEME_UNDEFINED);
t29=C_set_block_item(lf[242] /* chicken.base#setter */,0,C_SCHEME_UNDEFINED);
t30=C_set_block_item(lf[243] /* chicken.base#record-printer */,0,C_SCHEME_UNDEFINED);
t31=C_set_block_item(lf[244] /* chicken.base#set-record-printer! */,0,C_SCHEME_UNDEFINED);
t32=C_set_block_item(lf[245] /* chicken.base#subvector */,0,C_SCHEME_UNDEFINED);
t33=C_set_block_item(lf[246] /* chicken.base#vector-resize */,0,C_SCHEME_UNDEFINED);
t34=C_set_block_item(lf[247] /* chicken.base#port-closed? */,0,C_SCHEME_UNDEFINED);
t35=C_set_block_item(lf[248] /* chicken.base#flush-output */,0,C_SCHEME_UNDEFINED);
t36=C_mutate((C_word*)lf[249]+1 /* (set! chicken.base#promise? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12683,a[2]=((C_word)li153),tmp=(C_word)a,a+=3,tmp));
t37=C_mutate((C_word*)lf[251]+1 /* (set! ##sys#make-promise ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12689,a[2]=((C_word)li154),tmp=(C_word)a,a+=3,tmp));
t38=C_mutate((C_word*)lf[252]+1 /* (set! chicken.base#make-promise ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12695,a[2]=((C_word)li156),tmp=(C_word)a,a+=3,tmp));
t39=C_mutate((C_word*)lf[253]+1 /* (set! chicken.base#foldl ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12710,a[2]=((C_word)li158),tmp=(C_word)a,a+=3,tmp));
t40=C_mutate((C_word*)lf[255]+1 /* (set! chicken.base#foldr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12747,a[2]=((C_word)li160),tmp=(C_word)a,a+=3,tmp));
t41=C_set_block_item(lf[257] /* chicken.base#implicit-exit-handler */,0,C_SCHEME_UNDEFINED);
t42=C_set_block_item(lf[258] /* chicken.base#exit-handler */,0,C_SCHEME_UNDEFINED);
t43=C_set_block_item(lf[259] /* chicken.base#cleanup-tasks */,0,C_SCHEME_END_OF_LIST);
t44=C_mutate((C_word*)lf[260]+1 /* (set! chicken.base#on-exit ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12787,a[2]=((C_word)li161),tmp=(C_word)a,a+=3,tmp));
t45=C_mutate((C_word*)lf[261]+1 /* (set! chicken.base#exit ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12794,a[2]=((C_word)li162),tmp=(C_word)a,a+=3,tmp));
t46=C_mutate((C_word*)lf[262]+1 /* (set! chicken.base#emergency-exit ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12812,a[2]=((C_word)li163),tmp=(C_word)a,a+=3,tmp));
t47=C_set_block_item(lf[264] /* chicken.base#case-sensitive */,0,C_SCHEME_UNDEFINED);
t48=C_set_block_item(lf[265] /* chicken.base#keyword-style */,0,C_SCHEME_UNDEFINED);
t49=C_set_block_item(lf[266] /* chicken.base#parentheses-synonyms */,0,C_SCHEME_UNDEFINED);
t50=C_set_block_item(lf[267] /* chicken.base#symbol-escape */,0,C_SCHEME_UNDEFINED);
t51=C_mutate((C_word*)lf[268]+1 /* (set! chicken.base#identity ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12831,a[2]=((C_word)li164),tmp=(C_word)a,a+=3,tmp));
t52=C_mutate((C_word*)lf[269]+1 /* (set! chicken.base#conjoin ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12834,a[2]=((C_word)li167),tmp=(C_word)a,a+=3,tmp));
t53=C_mutate((C_word*)lf[270]+1 /* (set! chicken.base#disjoin ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12867,a[2]=((C_word)li170),tmp=(C_word)a,a+=3,tmp));
t54=C_mutate((C_word*)lf[271]+1 /* (set! chicken.base#constantly ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12904,a[2]=((C_word)li173),tmp=(C_word)a,a+=3,tmp));
t55=C_mutate((C_word*)lf[272]+1 /* (set! chicken.base#flip ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12925,a[2]=((C_word)li175),tmp=(C_word)a,a+=3,tmp));
t56=C_mutate((C_word*)lf[273]+1 /* (set! chicken.base#complement ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12933,a[2]=((C_word)li177),tmp=(C_word)a,a+=3,tmp));
t57=C_mutate((C_word*)lf[274]+1 /* (set! chicken.base#compose ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12945,a[2]=((C_word)li181),tmp=(C_word)a,a+=3,tmp));
t58=C_mutate((C_word*)lf[275]+1 /* (set! chicken.base#o ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12981,a[2]=((C_word)li184),tmp=(C_word)a,a+=3,tmp));
t59=C_mutate((C_word*)lf[276]+1 /* (set! chicken.base#list-of? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13020,a[2]=((C_word)li187),tmp=(C_word)a,a+=3,tmp));
t60=C_mutate((C_word*)lf[277]+1 /* (set! chicken.base#each ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13064,a[2]=((C_word)li191),tmp=(C_word)a,a+=3,tmp));
t61=C_mutate((C_word*)lf[279]+1 /* (set! chicken.base#bwp-object? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13120,a[2]=((C_word)li192),tmp=(C_word)a,a+=3,tmp));
t62=C_mutate((C_word*)lf[280]+1 /* (set! chicken.base#weak-cons ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13123,a[2]=((C_word)li193),tmp=(C_word)a,a+=3,tmp));
t63=C_mutate((C_word*)lf[281]+1 /* (set! chicken.base#weak-pair? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13126,a[2]=((C_word)li194),tmp=(C_word)a,a+=3,tmp));
t64=C_mutate((C_word*)lf[282]+1 /* (set! chicken.base#atom? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13129,a[2]=((C_word)li195),tmp=(C_word)a,a+=3,tmp));
t65=C_mutate((C_word*)lf[283]+1 /* (set! chicken.base#tail? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13132,a[2]=((C_word)li197),tmp=(C_word)a,a+=3,tmp));
t66=C_mutate((C_word*)lf[285]+1 /* (set! chicken.base#intersperse ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13160,a[2]=((C_word)li199),tmp=(C_word)a,a+=3,tmp));
t67=C_mutate((C_word*)lf[286]+1 /* (set! chicken.base#butlast ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13193,a[2]=((C_word)li201),tmp=(C_word)a,a+=3,tmp));
t68=C_mutate((C_word*)lf[288]+1 /* (set! chicken.base#flatten ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13225,a[2]=((C_word)li203),tmp=(C_word)a,a+=3,tmp));
t69=C_mutate((C_word*)lf[289]+1 /* (set! chicken.base#join ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13266,a[2]=((C_word)li205),tmp=(C_word)a,a+=3,tmp));
t70=C_mutate((C_word*)lf[292]+1 /* (set! chicken.base#compress ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13323,a[2]=((C_word)li207),tmp=(C_word)a,a+=3,tmp));
t71=C_mutate((C_word*)lf[296]+1 /* (set! chicken.base#char-foldcase ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13403,a[2]=((C_word)li208),tmp=(C_word)a,a+=3,tmp));
t72=C_mutate((C_word*)lf[298]+1 /* (set! chicken.base#string-foldcase ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13409,a[2]=((C_word)li209),tmp=(C_word)a,a+=3,tmp));
t73=C_mutate((C_word*)lf[302]+1 /* (set! chicken.base#alist-update! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13429,a[2]=((C_word)li212),tmp=(C_word)a,a+=3,tmp));
t74=C_mutate((C_word*)lf[303]+1 /* (set! chicken.base#alist-update ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13515,a[2]=((C_word)li214),tmp=(C_word)a,a+=3,tmp));
t75=C_mutate((C_word*)lf[307]+1 /* (set! chicken.base#alist-ref ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13619,a[2]=((C_word)li217),tmp=(C_word)a,a+=3,tmp));
t76=C_mutate((C_word*)lf[310]+1 /* (set! chicken.base#rassoc ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13731,a[2]=((C_word)li219),tmp=(C_word)a,a+=3,tmp));
t77=C_mutate((C_word*)lf[312]+1 /* (set! scheme#open-input-string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13779,a[2]=((C_word)li220),tmp=(C_word)a,a+=3,tmp));
t78=C_mutate((C_word*)lf[318]+1 /* (set! scheme#open-output-string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13807,a[2]=((C_word)li221),tmp=(C_word)a,a+=3,tmp));
t79=C_mutate((C_word*)lf[320]+1 /* (set! scheme#get-output-string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13826,a[2]=((C_word)li222),tmp=(C_word)a,a+=3,tmp));
t80=C_mutate((C_word*)lf[323]+1 /* (set! scheme#open-input-bytevector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13860,a[2]=((C_word)li228),tmp=(C_word)a,a+=3,tmp));
t81=C_mutate((C_word*)lf[328]+1 /* (set! scheme#open-output-bytevector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13928,a[2]=((C_word)li234),tmp=(C_word)a,a+=3,tmp));
t82=C_mutate((C_word*)lf[330]+1 /* (set! scheme#get-output-bytevector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13997,a[2]=((C_word)li236),tmp=(C_word)a,a+=3,tmp));
t83=C_unsigned_long_to_num(&a,C_HEADER_SIZE_MASK);
t84=C_mutate(&lf[334] /* (set! maximal-string-length ...) */,C_s_a_u_i_integer_minus(&a,2,t83,C_fix(1)));
t85=C_a_i_provide(&a,1,lf[335]);
t86=C_set_block_item(lf[336] /* chicken.fixnum#most-positive-fixnum */,0,C_fix((C_word)C_MOST_POSITIVE_FIXNUM));
t87=C_set_block_item(lf[337] /* chicken.fixnum#most-negative-fixnum */,0,C_fix((C_word)C_MOST_NEGATIVE_FIXNUM));
t88=C_set_block_item(lf[338] /* chicken.fixnum#fixnum-bits */,0,C_fix((C_word)(C_WORD_SIZE - 1)));
t89=C_set_block_item(lf[339] /* chicken.fixnum#fixnum-precision */,0,C_fix((C_word)(C_WORD_SIZE - (1 + 1))));
t90=C_mutate((C_word*)lf[340]+1 /* (set! chicken.fixnum#fx+ ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14044,a[2]=((C_word)li237),tmp=(C_word)a,a+=3,tmp));
t91=C_mutate((C_word*)lf[341]+1 /* (set! chicken.fixnum#fx- ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14047,a[2]=((C_word)li238),tmp=(C_word)a,a+=3,tmp));
t92=C_mutate((C_word*)lf[342]+1 /* (set! chicken.fixnum#fx* ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14050,a[2]=((C_word)li239),tmp=(C_word)a,a+=3,tmp));
t93=C_mutate((C_word*)lf[343]+1 /* (set! chicken.fixnum#fx= ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14053,a[2]=((C_word)li240),tmp=(C_word)a,a+=3,tmp));
t94=C_mutate((C_word*)lf[344]+1 /* (set! chicken.fixnum#fx> ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14059,a[2]=((C_word)li241),tmp=(C_word)a,a+=3,tmp));
t95=C_mutate((C_word*)lf[345]+1 /* (set! chicken.fixnum#fx< ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14062,a[2]=((C_word)li242),tmp=(C_word)a,a+=3,tmp));
t96=C_mutate((C_word*)lf[346]+1 /* (set! chicken.fixnum#fx>= ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14065,a[2]=((C_word)li243),tmp=(C_word)a,a+=3,tmp));
t97=C_mutate((C_word*)lf[347]+1 /* (set! chicken.fixnum#fx<= ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14068,a[2]=((C_word)li244),tmp=(C_word)a,a+=3,tmp));
t98=C_mutate((C_word*)lf[348]+1 /* (set! chicken.fixnum#fxmin ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14071,a[2]=((C_word)li245),tmp=(C_word)a,a+=3,tmp));
t99=C_mutate((C_word*)lf[349]+1 /* (set! chicken.fixnum#fxmax ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14074,a[2]=((C_word)li246),tmp=(C_word)a,a+=3,tmp));
t100=C_mutate((C_word*)lf[350]+1 /* (set! chicken.fixnum#fxneg ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14077,a[2]=((C_word)li247),tmp=(C_word)a,a+=3,tmp));
t101=C_mutate((C_word*)lf[351]+1 /* (set! chicken.fixnum#fxand ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14080,a[2]=((C_word)li248),tmp=(C_word)a,a+=3,tmp));
t102=C_mutate((C_word*)lf[352]+1 /* (set! chicken.fixnum#fxior ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14083,a[2]=((C_word)li249),tmp=(C_word)a,a+=3,tmp));
t103=C_mutate((C_word*)lf[353]+1 /* (set! chicken.fixnum#fxxor ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14086,a[2]=((C_word)li250),tmp=(C_word)a,a+=3,tmp));
t104=C_mutate((C_word*)lf[354]+1 /* (set! chicken.fixnum#fxnot ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14089,a[2]=((C_word)li251),tmp=(C_word)a,a+=3,tmp));
t105=C_mutate((C_word*)lf[355]+1 /* (set! chicken.fixnum#fxshl ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14092,a[2]=((C_word)li252),tmp=(C_word)a,a+=3,tmp));
t106=C_mutate((C_word*)lf[356]+1 /* (set! chicken.fixnum#fxshr ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14095,a[2]=((C_word)li253),tmp=(C_word)a,a+=3,tmp));
t107=C_mutate((C_word*)lf[357]+1 /* (set! chicken.fixnum#fxodd? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14098,a[2]=((C_word)li254),tmp=(C_word)a,a+=3,tmp));
t108=C_mutate((C_word*)lf[358]+1 /* (set! chicken.fixnum#fxeven? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14101,a[2]=((C_word)li255),tmp=(C_word)a,a+=3,tmp));
t109=C_mutate((C_word*)lf[359]+1 /* (set! chicken.fixnum#fxlen ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14104,a[2]=((C_word)li256),tmp=(C_word)a,a+=3,tmp));
t110=C_mutate((C_word*)lf[360]+1 /* (set! chicken.fixnum#fx/ ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14107,a[2]=((C_word)li257),tmp=(C_word)a,a+=3,tmp));
t111=C_mutate((C_word*)lf[361]+1 /* (set! chicken.fixnum#fxgcd ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14110,a[2]=((C_word)li258),tmp=(C_word)a,a+=3,tmp));
t112=C_mutate((C_word*)lf[362]+1 /* (set! chicken.fixnum#fxmod ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14113,a[2]=((C_word)li259),tmp=(C_word)a,a+=3,tmp));
t113=C_mutate((C_word*)lf[363]+1 /* (set! chicken.fixnum#fxrem ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14116,a[2]=((C_word)li260),tmp=(C_word)a,a+=3,tmp));
t114=C_mutate((C_word*)lf[364]+1 /* (set! chicken.fixnum#fx+? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14119,a[2]=((C_word)li261),tmp=(C_word)a,a+=3,tmp));
t115=C_mutate((C_word*)lf[365]+1 /* (set! chicken.fixnum#fx-? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14122,a[2]=((C_word)li262),tmp=(C_word)a,a+=3,tmp));
t116=C_mutate((C_word*)lf[366]+1 /* (set! chicken.fixnum#fx*? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14125,a[2]=((C_word)li263),tmp=(C_word)a,a+=3,tmp));
t117=C_mutate((C_word*)lf[367]+1 /* (set! chicken.fixnum#fx/? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14128,a[2]=((C_word)li264),tmp=(C_word)a,a+=3,tmp));
t118=C_mutate((C_word*)lf[368]+1 /* (set! ##sys#debug-mode? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14131,a[2]=((C_word)li265),tmp=(C_word)a,a+=3,tmp));
t119=C_set_block_item(lf[369] /* ##sys#warnings-enabled */,0,C_SCHEME_TRUE);
t120=C_set_block_item(lf[370] /* ##sys#notices-enabled */,0,C_i_debug_modep());
t121=C_mutate((C_word*)lf[371]+1 /* (set! chicken.base#warning ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14136,a[2]=((C_word)li266),tmp=(C_word)a,a+=3,tmp));
t122=C_mutate((C_word*)lf[373]+1 /* (set! chicken.base#notice ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14145,a[2]=((C_word)li267),tmp=(C_word)a,a+=3,tmp));
t123=C_mutate((C_word*)lf[375]+1 /* (set! chicken.base#enable-warnings ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14157,a[2]=((C_word)li268),tmp=(C_word)a,a+=3,tmp));
t124=C_mutate((C_word*)lf[195]+1 /* (set! ##sys#error ...) */,*((C_word*)lf[234]+1));
t125=C_mutate((C_word*)lf[376]+1 /* (set! ##sys#warn ...) */,*((C_word*)lf[371]+1));
t126=C_mutate((C_word*)lf[377]+1 /* (set! ##sys#notice ...) */,*((C_word*)lf[373]+1));
t127=C_mutate((C_word*)lf[378]+1 /* (set! ##sys#error/errno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14171,a[2]=((C_word)li269),tmp=(C_word)a,a+=3,tmp));
t128=C_mutate((C_word*)lf[380]+1 /* (set! ##sys#gc ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_gc,a[2]=((C_word)li270),tmp=(C_word)a,a+=3,tmp));
t129=C_mutate((C_word*)lf[381]+1 /* (set! ##sys#setslot ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14187,a[2]=((C_word)li271),tmp=(C_word)a,a+=3,tmp));
t130=C_mutate((C_word*)lf[382]+1 /* (set! ##sys#setislot ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14190,a[2]=((C_word)li272),tmp=(C_word)a,a+=3,tmp));
t131=C_mutate((C_word*)lf[383]+1 /* (set! ##sys#allocate-vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_allocate_vector,a[2]=((C_word)li273),tmp=(C_word)a,a+=3,tmp));
t132=C_mutate((C_word*)lf[384]+1 /* (set! ##sys#allocate-bytevector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_allocate_bytevector,a[2]=((C_word)li274),tmp=(C_word)a,a+=3,tmp));
t133=C_mutate((C_word*)lf[385]+1 /* (set! ##sys#make-structure ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_make_structure,a[2]=((C_word)li275),tmp=(C_word)a,a+=3,tmp));
t134=C_mutate((C_word*)lf[386]+1 /* (set! ##sys#ensure-heap-reserve ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_ensure_heap_reserve,a[2]=((C_word)li276),tmp=(C_word)a,a+=3,tmp));
t135=C_mutate((C_word*)lf[387]+1 /* (set! ##sys#symbol-table-info ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_get_symbol_table_info,a[2]=((C_word)li277),tmp=(C_word)a,a+=3,tmp));
t136=C_mutate((C_word*)lf[388]+1 /* (set! ##sys#memory-info ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_get_memory_info,a[2]=((C_word)li278),tmp=(C_word)a,a+=3,tmp));
t137=C_mutate((C_word*)lf[389]+1 /* (set! ##sys#start-timer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14199,a[2]=((C_word)li279),tmp=(C_word)a,a+=3,tmp));
t138=C_mutate((C_word*)lf[390]+1 /* (set! ##sys#stop-timer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14205,a[2]=((C_word)li282),tmp=(C_word)a,a+=3,tmp));
t139=C_mutate((C_word*)lf[391]+1 /* (set! ##sys#immediate? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14225,a[2]=((C_word)li283),tmp=(C_word)a,a+=3,tmp));
t140=C_mutate((C_word*)lf[392]+1 /* (set! ##sys#message ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14232,a[2]=((C_word)li284),tmp=(C_word)a,a+=3,tmp));
t141=C_mutate((C_word*)lf[393]+1 /* (set! ##sys#byte ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14235,a[2]=((C_word)li285),tmp=(C_word)a,a+=3,tmp));
t142=C_mutate((C_word*)lf[394]+1 /* (set! ##sys#void ...) */,*((C_word*)lf[237]+1));
t143=C_set_block_item(lf[278] /* ##sys#undefined-value */,0,C_SCHEME_UNDEFINED);
t144=C_mutate((C_word*)lf[395]+1 /* (set! ##sys#halt ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14240,a[2]=((C_word)li286),tmp=(C_word)a,a+=3,tmp));
t145=C_mutate((C_word*)lf[396]+1 /* (set! ##sys#become! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_become,a[2]=((C_word)li287),tmp=(C_word)a,a+=3,tmp));
t146=C_mutate((C_word*)lf[397]+1 /* (set! ##sys#block-ref ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14244,a[2]=((C_word)li288),tmp=(C_word)a,a+=3,tmp));
t147=C_mutate((C_word*)lf[398]+1 /* (set! ##sys#apply-values ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_apply_values,a[2]=((C_word)li289),tmp=(C_word)a,a+=3,tmp));
t148=C_mutate((C_word*)lf[399]+1 /* (set! ##sys#copy-closure ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_copy_closure,a[2]=((C_word)li290),tmp=(C_word)a,a+=3,tmp));
t149=C_mutate((C_word*)lf[400]+1 /* (set! ##sys#block-set! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14249,a[2]=((C_word)li291),tmp=(C_word)a,a+=3,tmp));
t150=C_a_i_provide(&a,1,lf[402]);
t151=C_mutate((C_word*)lf[403]+1 /* (set! chicken.time#current-process-milliseconds ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14284,a[2]=((C_word)li292),tmp=(C_word)a,a+=3,tmp));
t152=C_mutate((C_word*)lf[404]+1 /* (set! chicken.time#current-seconds ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14287,a[2]=((C_word)li293),tmp=(C_word)a,a+=3,tmp));
t153=C_mutate((C_word*)lf[405]+1 /* (set! chicken.time#cpu-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14290,a[2]=((C_word)li294),tmp=(C_word)a,a+=3,tmp));
t154=C_mutate((C_word*)lf[406]+1 /* (set! ##sys#check-structure ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14307,a[2]=((C_word)li295),tmp=(C_word)a,a+=3,tmp));
t155=C_mutate((C_word*)lf[407]+1 /* (set! ##sys#check-blob ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14318,a[2]=((C_word)li296),tmp=(C_word)a,a+=3,tmp));
t156=C_mutate((C_word*)lf[408]+1 /* (set! ##sys#check-pair ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14329,a[2]=((C_word)li297),tmp=(C_word)a,a+=3,tmp));
t157=C_mutate((C_word*)lf[409]+1 /* (set! ##sys#check-list ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14340,a[2]=((C_word)li298),tmp=(C_word)a,a+=3,tmp));
t158=C_mutate((C_word*)lf[410]+1 /* (set! ##sys#check-string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14351,a[2]=((C_word)li299),tmp=(C_word)a,a+=3,tmp));
t159=C_mutate((C_word*)lf[411]+1 /* (set! ##sys#check-number ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14362,a[2]=((C_word)li300),tmp=(C_word)a,a+=3,tmp));
t160=C_mutate((C_word*)lf[412]+1 /* (set! ##sys#check-fixnum ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14373,a[2]=((C_word)li301),tmp=(C_word)a,a+=3,tmp));
t161=C_mutate((C_word*)lf[413]+1 /* (set! ##sys#check-bytevector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14384,a[2]=((C_word)li302),tmp=(C_word)a,a+=3,tmp));
t162=C_mutate((C_word*)lf[414]+1 /* (set! ##sys#check-exact ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14395,a[2]=((C_word)li303),tmp=(C_word)a,a+=3,tmp));
t163=C_mutate((C_word*)lf[415]+1 /* (set! ##sys#check-inexact ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14406,a[2]=((C_word)li304),tmp=(C_word)a,a+=3,tmp));
t164=C_mutate((C_word*)lf[416]+1 /* (set! ##sys#check-symbol ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14417,a[2]=((C_word)li305),tmp=(C_word)a,a+=3,tmp));
t165=C_mutate((C_word*)lf[417]+1 /* (set! ##sys#check-keyword ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14428,a[2]=((C_word)li306),tmp=(C_word)a,a+=3,tmp));
t166=C_mutate((C_word*)lf[418]+1 /* (set! ##sys#check-vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14439,a[2]=((C_word)li307),tmp=(C_word)a,a+=3,tmp));
t167=C_mutate((C_word*)lf[419]+1 /* (set! ##sys#check-char ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14450,a[2]=((C_word)li308),tmp=(C_word)a,a+=3,tmp));
t168=C_mutate((C_word*)lf[420]+1 /* (set! ##sys#check-boolean ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14461,a[2]=((C_word)li309),tmp=(C_word)a,a+=3,tmp));
t169=C_mutate((C_word*)lf[421]+1 /* (set! ##sys#check-locative ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14472,a[2]=((C_word)li310),tmp=(C_word)a,a+=3,tmp));
t170=C_mutate((C_word*)lf[422]+1 /* (set! ##sys#check-integer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14483,a[2]=((C_word)li311),tmp=(C_word)a,a+=3,tmp));
t171=C_mutate((C_word*)lf[424]+1 /* (set! ##sys#check-exact-integer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14500,a[2]=((C_word)li312),tmp=(C_word)a,a+=3,tmp));
t172=C_mutate((C_word*)lf[426]+1 /* (set! ##sys#check-exact-uinteger ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14517,a[2]=((C_word)li313),tmp=(C_word)a,a+=3,tmp));
t173=C_mutate((C_word*)lf[428]+1 /* (set! ##sys#check-real ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14541,a[2]=((C_word)li314),tmp=(C_word)a,a+=3,tmp));
t174=C_mutate((C_word*)lf[430]+1 /* (set! ##sys#check-range ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14558,a[2]=((C_word)li315),tmp=(C_word)a,a+=3,tmp));
t175=C_mutate((C_word*)lf[431]+1 /* (set! ##sys#check-range/including ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14569,a[2]=((C_word)li316),tmp=(C_word)a,a+=3,tmp));
t176=C_mutate((C_word*)lf[432]+1 /* (set! ##sys#check-special ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14580,a[2]=((C_word)li317),tmp=(C_word)a,a+=3,tmp));
t177=C_mutate((C_word*)lf[434]+1 /* (set! ##sys#check-closure ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14600,a[2]=((C_word)li318),tmp=(C_word)a,a+=3,tmp));
t178=C_mutate((C_word*)lf[435]+1 /* (set! scheme#force ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14611,a[2]=((C_word)li320),tmp=(C_word)a,a+=3,tmp));
t179=C_mutate((C_word*)lf[437]+1 /* (set! ##sys#dload ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_dload,a[2]=((C_word)li321),tmp=(C_word)a,a+=3,tmp));
t180=C_mutate((C_word*)lf[438]+1 /* (set! ##sys#set-dlopen-flags! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_set_dlopen_flags,a[2]=((C_word)li322),tmp=(C_word)a,a+=3,tmp));
t181=C_mutate((C_word*)lf[51]+1 /* (set! ##sys#error-not-a-proper-list ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14739,a[2]=((C_word)li323),tmp=(C_word)a,a+=3,tmp));
t182=C_mutate((C_word*)lf[440]+1 /* (set! ##sys#error-bad-number ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14755,a[2]=((C_word)li324),tmp=(C_word)a,a+=3,tmp));
t183=C_mutate((C_word*)lf[423]+1 /* (set! ##sys#error-bad-integer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14771,a[2]=((C_word)li325),tmp=(C_word)a,a+=3,tmp));
t184=C_mutate((C_word*)lf[425]+1 /* (set! ##sys#error-bad-exact-integer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14787,a[2]=((C_word)li326),tmp=(C_word)a,a+=3,tmp));
t185=C_mutate((C_word*)lf[427]+1 /* (set! ##sys#error-bad-exact-uinteger ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14803,a[2]=((C_word)li327),tmp=(C_word)a,a+=3,tmp));
t186=C_mutate((C_word*)lf[441]+1 /* (set! ##sys#error-bad-inexact ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14819,a[2]=((C_word)li328),tmp=(C_word)a,a+=3,tmp));
t187=C_mutate((C_word*)lf[429]+1 /* (set! ##sys#error-bad-real ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14835,a[2]=((C_word)li329),tmp=(C_word)a,a+=3,tmp));
t188=C_mutate((C_word*)lf[442]+1 /* (set! ##sys#error-bad-base ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14851,a[2]=((C_word)li330),tmp=(C_word)a,a+=3,tmp));
t189=C_mutate((C_word*)lf[443]+1 /* (set! scheme#append ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14867,a[2]=((C_word)li333),tmp=(C_word)a,a+=3,tmp));
t190=C_mutate((C_word*)lf[445]+1 /* (set! ##sys#fast-reverse ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14946,a[2]=((C_word)li335),tmp=(C_word)a,a+=3,tmp));
t191=C_mutate((C_word*)lf[301]+1 /* (set! ##sys#make-bytevector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14976,a[2]=((C_word)li336),tmp=(C_word)a,a+=3,tmp));
t192=C_mutate((C_word*)lf[446]+1 /* (set! ##sys#make-string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14991,a[2]=((C_word)li337),tmp=(C_word)a,a+=3,tmp));
t193=C_mutate((C_word*)lf[300]+1 /* (set! ##sys#buffer->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15013,a[2]=((C_word)li338),tmp=(C_word)a,a+=3,tmp));
t194=C_mutate((C_word*)lf[447]+1 /* (set! ##sys#utf-decoder ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15024,a[2]=((C_word)li339),tmp=(C_word)a,a+=3,tmp));
t195=C_mutate((C_word*)lf[448]+1 /* (set! ##sys#utf-encoder ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15030,a[2]=((C_word)li340),tmp=(C_word)a,a+=3,tmp));
t196=C_mutate((C_word*)lf[449]+1 /* (set! ##sys#utf-scanner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15036,a[2]=((C_word)li341),tmp=(C_word)a,a+=3,tmp));
t197=C_mutate((C_word*)lf[450]+1 /* (set! ##sys#latin-decoder ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15060,a[2]=((C_word)li342),tmp=(C_word)a,a+=3,tmp));
t198=C_mutate((C_word*)lf[451]+1 /* (set! ##sys#latin-encoder ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15073,a[2]=((C_word)li343),tmp=(C_word)a,a+=3,tmp));
t199=C_mutate((C_word*)lf[452]+1 /* (set! ##sys#latin-scanner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15086,a[2]=((C_word)li344),tmp=(C_word)a,a+=3,tmp));
t200=C_mutate((C_word*)lf[453]+1 /* (set! ##sys#binary-decoder ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15089,a[2]=((C_word)li345),tmp=(C_word)a,a+=3,tmp));
t201=C_mutate((C_word*)lf[454]+1 /* (set! ##sys#binary-encoder ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15095,a[2]=((C_word)li346),tmp=(C_word)a,a+=3,tmp));
t202=C_mutate((C_word*)lf[455]+1 /* (set! ##sys#binary-scanner ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15101,a[2]=((C_word)li347),tmp=(C_word)a,a+=3,tmp));
t203=C_mutate((C_word*)lf[456]+1 /* (set! ##sys#encoding-hook ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15104,a[2]=((C_word)li348),tmp=(C_word)a,a+=3,tmp));
t204=C_mutate((C_word*)lf[460]+1 /* (set! ##sys#register-encoding ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15143,a[2]=((C_word)li350),tmp=(C_word)a,a+=3,tmp));
t205=C_mutate((C_word*)lf[461]+1 /* (set! ##sys#buffer->string/encoding ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15173,a[2]=((C_word)li352),tmp=(C_word)a,a+=3,tmp));
t206=C_mutate((C_word*)lf[462]+1 /* (set! ##sys#encode-buffer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15185,a[2]=((C_word)li354),tmp=(C_word)a,a+=3,tmp));
t207=C_mutate((C_word*)lf[463]+1 /* (set! ##sys#decode-buffer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15197,a[2]=((C_word)li356),tmp=(C_word)a,a+=3,tmp));
t208=C_mutate((C_word*)lf[464]+1 /* (set! ##sys#encode-char ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15209,a[2]=((C_word)li359),tmp=(C_word)a,a+=3,tmp));
t209=C_mutate((C_word*)lf[465]+1 /* (set! ##sys#decode-char ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15227,a[2]=((C_word)li361),tmp=(C_word)a,a+=3,tmp));
t210=C_mutate((C_word*)lf[466]+1 /* (set! ##sys#read-char/encoding ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15240,a[2]=((C_word)li364),tmp=(C_word)a,a+=3,tmp));
t211=C_mutate((C_word*)lf[470]+1 /* (set! scheme#make-string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15304,a[2]=((C_word)li365),tmp=(C_word)a,a+=3,tmp));
t212=C_mutate((C_word*)lf[474]+1 /* (set! scheme#string->list ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15335,a[2]=((C_word)li367),tmp=(C_word)a,a+=3,tmp));
t213=C_mutate((C_word*)lf[476]+1 /* (set! ##sys#string->list ...) */,*((C_word*)lf[474]+1));
t214=C_mutate((C_word*)lf[477]+1 /* (set! scheme#list->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15426,a[2]=((C_word)li369),tmp=(C_word)a,a+=3,tmp));
t215=C_mutate((C_word*)lf[479]+1 /* (set! ##sys#list->string ...) */,*((C_word*)lf[477]+1));
t216=C_mutate((C_word*)lf[480]+1 /* (set! ##sys#reverse-list->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15488,a[2]=((C_word)li371),tmp=(C_word)a,a+=3,tmp));
t217=C_mutate((C_word*)lf[482]+1 /* (set! scheme#string-fill! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15539,a[2]=((C_word)li373),tmp=(C_word)a,a+=3,tmp));
t218=C_mutate((C_word*)lf[484]+1 /* (set! scheme#string-copy ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15658,a[2]=((C_word)li374),tmp=(C_word)a,a+=3,tmp));
t219=C_mutate((C_word*)lf[487]+1 /* (set! scheme#string-copy! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15733,a[2]=((C_word)li377),tmp=(C_word)a,a+=3,tmp));
t220=C_mutate((C_word*)lf[486]+1 /* (set! ##sys#substring ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15884,a[2]=((C_word)li378),tmp=(C_word)a,a+=3,tmp));
t221=C_mutate((C_word*)lf[489]+1 /* (set! scheme#substring ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15898,a[2]=((C_word)li379),tmp=(C_word)a,a+=3,tmp));
t222=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15943,a[2]=((C_word)li381),tmp=(C_word)a,a+=3,tmp);
t223=C_mutate((C_word*)lf[491]+1 /* (set! scheme#string<? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16012,a[2]=t222,a[3]=((C_word)li383),tmp=(C_word)a,a+=4,tmp));
t224=C_mutate((C_word*)lf[493]+1 /* (set! scheme#string>? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16036,a[2]=t222,a[3]=((C_word)li385),tmp=(C_word)a,a+=4,tmp));
t225=C_mutate((C_word*)lf[495]+1 /* (set! scheme#string<=? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16060,a[2]=t222,a[3]=((C_word)li387),tmp=(C_word)a,a+=4,tmp));
t226=C_mutate((C_word*)lf[497]+1 /* (set! scheme#string>=? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16081,a[2]=t222,a[3]=((C_word)li389),tmp=(C_word)a,a+=4,tmp));
t227=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16101,a[2]=((C_word)li391),tmp=(C_word)a,a+=3,tmp);
t228=C_mutate((C_word*)lf[499]+1 /* (set! scheme#string-ci<? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16162,a[2]=t227,a[3]=((C_word)li393),tmp=(C_word)a,a+=4,tmp));
t229=C_mutate((C_word*)lf[501]+1 /* (set! scheme#string-ci>? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16186,a[2]=t227,a[3]=((C_word)li395),tmp=(C_word)a,a+=4,tmp));
t230=C_mutate((C_word*)lf[503]+1 /* (set! scheme#string-ci<=? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16210,a[2]=t227,a[3]=((C_word)li397),tmp=(C_word)a,a+=4,tmp));
t231=C_mutate((C_word*)lf[505]+1 /* (set! scheme#string-ci>=? ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16231,a[2]=t227,a[3]=((C_word)li399),tmp=(C_word)a,a+=4,tmp));
t232=C_mutate((C_word*)lf[507]+1 /* (set! ##sys#string-append ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16252,a[2]=((C_word)li400),tmp=(C_word)a,a+=3,tmp));
t233=C_mutate((C_word*)lf[508]+1 /* (set! scheme#string-append ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16298,a[2]=((C_word)li402),tmp=(C_word)a,a+=3,tmp));
t234=C_mutate((C_word*)lf[510]+1 /* (set! scheme#string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16356,a[2]=((C_word)li403),tmp=(C_word)a,a+=3,tmp));
t235=C_mutate((C_word*)lf[511]+1 /* (set! ##sys#char->utf8-string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16362,a[2]=((C_word)li404),tmp=(C_word)a,a+=3,tmp));
t236=C_mutate((C_word*)lf[512]+1 /* (set! chicken.base#chop ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16368,a[2]=((C_word)li407),tmp=(C_word)a,a+=3,tmp));
t237=C_a_i_provide(&a,1,lf[515]);
t238=C_mutate((C_word*)lf[516]+1 /* (set! chicken.flonum#maximum-flonum ...) */,C_flonum(&a,DBL_MAX));
t239=C_mutate((C_word*)lf[517]+1 /* (set! chicken.flonum#minimum-flonum ...) */,C_flonum(&a,DBL_MIN));
t240=C_set_block_item(lf[518] /* chicken.flonum#flonum-radix */,0,C_fix((C_word)FLT_RADIX));
t241=C_mutate((C_word*)lf[519]+1 /* (set! chicken.flonum#flonum-epsilon ...) */,C_flonum(&a,DBL_EPSILON));
t242=C_set_block_item(lf[520] /* chicken.flonum#flonum-precision */,0,C_fix((C_word)DBL_MANT_DIG));
t243=C_set_block_item(lf[521] /* chicken.flonum#flonum-decimal-precision */,0,C_fix((C_word)DBL_DIG));
t244=C_set_block_item(lf[522] /* chicken.flonum#flonum-maximum-exponent */,0,C_fix((C_word)DBL_MAX_EXP));
t245=C_set_block_item(lf[523] /* chicken.flonum#flonum-minimum-exponent */,0,C_fix((C_word)DBL_MIN_EXP));
t246=C_set_block_item(lf[524] /* chicken.flonum#flonum-maximum-decimal-exponent */,0,C_fix((C_word)DBL_MAX_10_EXP));
t247=C_set_block_item(lf[525] /* chicken.flonum#flonum-minimum-decimal-exponent */,0,C_fix((C_word)DBL_MIN_10_EXP));
t248=C_mutate((C_word*)lf[526]+1 /* (set! chicken.flonum#fp+ ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16463,a[2]=((C_word)li408),tmp=(C_word)a,a+=3,tmp));
t249=C_mutate((C_word*)lf[528]+1 /* (set! chicken.flonum#fp- ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16487,a[2]=((C_word)li409),tmp=(C_word)a,a+=3,tmp));
t250=C_mutate((C_word*)lf[530]+1 /* (set! chicken.flonum#fp* ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16511,a[2]=((C_word)li410),tmp=(C_word)a,a+=3,tmp));
t251=C_mutate((C_word*)lf[532]+1 /* (set! chicken.flonum#fp/ ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16535,a[2]=((C_word)li411),tmp=(C_word)a,a+=3,tmp));
t252=C_mutate((C_word*)lf[534]+1 /* (set! chicken.flonum#fp*+ ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16559,a[2]=((C_word)li412),tmp=(C_word)a,a+=3,tmp));
t253=C_mutate((C_word*)lf[536]+1 /* (set! chicken.flonum#fpgcd ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16584,a[2]=((C_word)li413),tmp=(C_word)a,a+=3,tmp));
t254=C_mutate((C_word*)lf[538]+1 /* (set! chicken.flonum#fp/? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16608,a[2]=((C_word)li414),tmp=(C_word)a,a+=3,tmp));
t255=C_mutate((C_word*)lf[540]+1 /* (set! chicken.flonum#fp= ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16632,a[2]=((C_word)li415),tmp=(C_word)a,a+=3,tmp));
t256=C_mutate((C_word*)lf[542]+1 /* (set! chicken.flonum#fp> ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16656,a[2]=((C_word)li416),tmp=(C_word)a,a+=3,tmp));
t257=C_mutate((C_word*)lf[544]+1 /* (set! chicken.flonum#fp< ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16680,a[2]=((C_word)li417),tmp=(C_word)a,a+=3,tmp));
t258=C_mutate((C_word*)lf[546]+1 /* (set! chicken.flonum#fp>= ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16704,a[2]=((C_word)li418),tmp=(C_word)a,a+=3,tmp));
t259=C_mutate((C_word*)lf[548]+1 /* (set! chicken.flonum#fp<= ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16728,a[2]=((C_word)li419),tmp=(C_word)a,a+=3,tmp));
t260=C_mutate((C_word*)lf[550]+1 /* (set! chicken.flonum#fpneg ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16752,a[2]=((C_word)li420),tmp=(C_word)a,a+=3,tmp));
t261=C_mutate((C_word*)lf[552]+1 /* (set! chicken.flonum#fpmax ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16770,a[2]=((C_word)li421),tmp=(C_word)a,a+=3,tmp));
t262=C_mutate((C_word*)lf[554]+1 /* (set! chicken.flonum#fpmin ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16794,a[2]=((C_word)li422),tmp=(C_word)a,a+=3,tmp));
t263=C_mutate((C_word*)lf[556]+1 /* (set! chicken.flonum#fpfloor ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16818,a[2]=((C_word)li423),tmp=(C_word)a,a+=3,tmp));
t264=C_mutate((C_word*)lf[558]+1 /* (set! chicken.flonum#fptruncate ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16836,a[2]=((C_word)li424),tmp=(C_word)a,a+=3,tmp));
t265=C_mutate((C_word*)lf[560]+1 /* (set! chicken.flonum#fpround ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16854,a[2]=((C_word)li425),tmp=(C_word)a,a+=3,tmp));
t266=C_mutate((C_word*)lf[562]+1 /* (set! chicken.flonum#fpceiling ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16872,a[2]=((C_word)li426),tmp=(C_word)a,a+=3,tmp));
t267=C_mutate((C_word*)lf[564]+1 /* (set! chicken.flonum#fpsin ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16890,a[2]=((C_word)li427),tmp=(C_word)a,a+=3,tmp));
t268=C_mutate((C_word*)lf[566]+1 /* (set! chicken.flonum#fpcos ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16908,a[2]=((C_word)li428),tmp=(C_word)a,a+=3,tmp));
t269=C_mutate((C_word*)lf[568]+1 /* (set! chicken.flonum#fptan ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16926,a[2]=((C_word)li429),tmp=(C_word)a,a+=3,tmp));
t270=C_mutate((C_word*)lf[570]+1 /* (set! chicken.flonum#fpasin ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16944,a[2]=((C_word)li430),tmp=(C_word)a,a+=3,tmp));
t271=C_mutate((C_word*)lf[572]+1 /* (set! chicken.flonum#fpacos ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16962,a[2]=((C_word)li431),tmp=(C_word)a,a+=3,tmp));
t272=C_mutate((C_word*)lf[574]+1 /* (set! chicken.flonum#fpatan ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16980,a[2]=((C_word)li432),tmp=(C_word)a,a+=3,tmp));
t273=C_mutate((C_word*)lf[576]+1 /* (set! chicken.flonum#fpatan2 ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16998,a[2]=((C_word)li433),tmp=(C_word)a,a+=3,tmp));
t274=C_mutate((C_word*)lf[578]+1 /* (set! chicken.flonum#fpsinh ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17022,a[2]=((C_word)li434),tmp=(C_word)a,a+=3,tmp));
t275=C_mutate((C_word*)lf[580]+1 /* (set! chicken.flonum#fpcosh ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17040,a[2]=((C_word)li435),tmp=(C_word)a,a+=3,tmp));
t276=C_mutate((C_word*)lf[582]+1 /* (set! chicken.flonum#fptanh ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17058,a[2]=((C_word)li436),tmp=(C_word)a,a+=3,tmp));
t277=C_mutate((C_word*)lf[584]+1 /* (set! chicken.flonum#fpasinh ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17076,a[2]=((C_word)li437),tmp=(C_word)a,a+=3,tmp));
t278=C_mutate((C_word*)lf[586]+1 /* (set! chicken.flonum#fpacosh ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17094,a[2]=((C_word)li438),tmp=(C_word)a,a+=3,tmp));
t279=C_mutate((C_word*)lf[588]+1 /* (set! chicken.flonum#fpatanh ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17112,a[2]=((C_word)li439),tmp=(C_word)a,a+=3,tmp));
t280=C_mutate((C_word*)lf[590]+1 /* (set! chicken.flonum#fpexp ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17130,a[2]=((C_word)li440),tmp=(C_word)a,a+=3,tmp));
t281=C_mutate((C_word*)lf[592]+1 /* (set! chicken.flonum#fpexpt ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17148,a[2]=((C_word)li441),tmp=(C_word)a,a+=3,tmp));
t282=C_mutate((C_word*)lf[594]+1 /* (set! chicken.flonum#fplog ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17172,a[2]=((C_word)li442),tmp=(C_word)a,a+=3,tmp));
t283=C_mutate((C_word*)lf[596]+1 /* (set! chicken.flonum#fpsqrt ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17190,a[2]=((C_word)li443),tmp=(C_word)a,a+=3,tmp));
t284=C_mutate((C_word*)lf[598]+1 /* (set! chicken.flonum#fpabs ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17208,a[2]=((C_word)li444),tmp=(C_word)a,a+=3,tmp));
t285=C_mutate((C_word*)lf[600]+1 /* (set! chicken.flonum#fpinteger? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17226,a[2]=((C_word)li445),tmp=(C_word)a,a+=3,tmp));
t286=C_mutate((C_word*)lf[602]+1 /* (set! chicken.flonum#flonum-print-precision ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17244,a[2]=((C_word)li446),tmp=(C_word)a,a+=3,tmp));
t287=C_mutate(&lf[604] /* (set! make-complex ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17262,a[2]=((C_word)li447),tmp=(C_word)a,a+=3,tmp));
t288=C_mutate((C_word*)lf[606]+1 /* (set! scheme#make-rectangular ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17298,a[2]=((C_word)li448),tmp=(C_word)a,a+=3,tmp));
t289=C_mutate((C_word*)lf[608]+1 /* (set! scheme#make-polar ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17310,a[2]=((C_word)li449),tmp=(C_word)a,a+=3,tmp));
t290=C_mutate((C_word*)lf[610]+1 /* (set! scheme#real-part ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17333,a[2]=((C_word)li450),tmp=(C_word)a,a+=3,tmp));
t291=C_mutate((C_word*)lf[612]+1 /* (set! scheme#imag-part ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17356,a[2]=((C_word)li451),tmp=(C_word)a,a+=3,tmp));
t292=C_mutate((C_word*)lf[614]+1 /* (set! scheme#angle ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17382,a[2]=((C_word)li452),tmp=(C_word)a,a+=3,tmp));
t293=C_mutate((C_word*)lf[616]+1 /* (set! scheme#magnitude ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17398,a[2]=((C_word)li453),tmp=(C_word)a,a+=3,tmp));
t294=C_mutate(&lf[619] /* (set! ratnum ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17442,a[2]=((C_word)li454),tmp=(C_word)a,a+=3,tmp));
t295=C_mutate((C_word*)lf[620]+1 /* (set! scheme#numerator ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17488,a[2]=((C_word)li455),tmp=(C_word)a,a+=3,tmp));
t296=C_mutate((C_word*)lf[624]+1 /* (set! scheme#denominator ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17534,a[2]=((C_word)li456),tmp=(C_word)a,a+=3,tmp));
t297=C_mutate((C_word*)lf[628]+1 /* (set! ##sys#extended-signum ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17580,a[2]=((C_word)li457),tmp=(C_word)a,a+=3,tmp));
t298=C_mutate((C_word*)lf[622]+1 /* (set! scheme#inexact->exact ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17704,a[2]=((C_word)li460),tmp=(C_word)a,a+=3,tmp));
t299=C_a_i_provide(&a,1,lf[635]);
t300=C_mutate((C_word*)lf[636]+1 /* (set! chicken.bitwise#bitwise-and ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_bitwise_and,a[2]=((C_word)li461),tmp=(C_word)a,a+=3,tmp));
t301=C_mutate((C_word*)lf[637]+1 /* (set! chicken.bitwise#bitwise-ior ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_bitwise_ior,a[2]=((C_word)li462),tmp=(C_word)a,a+=3,tmp));
t302=C_mutate((C_word*)lf[638]+1 /* (set! chicken.bitwise#bitwise-xor ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_bitwise_xor,a[2]=((C_word)li463),tmp=(C_word)a,a+=3,tmp));
t303=C_mutate((C_word*)lf[639]+1 /* (set! chicken.bitwise#bitwise-not ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17768,a[2]=((C_word)li464),tmp=(C_word)a,a+=3,tmp));
t304=C_mutate((C_word*)lf[640]+1 /* (set! chicken.bitwise#bit->boolean ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17771,a[2]=((C_word)li465),tmp=(C_word)a,a+=3,tmp));
t305=C_mutate((C_word*)lf[641]+1 /* (set! chicken.bitwise#integer-length ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17774,a[2]=((C_word)li466),tmp=(C_word)a,a+=3,tmp));
t306=C_mutate((C_word*)lf[642]+1 /* (set! chicken.bitwise#arithmetic-shift ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17777,a[2]=((C_word)li467),tmp=(C_word)a,a+=3,tmp));
t307=C_mutate((C_word*)lf[643]+1 /* (set! scheme#/ ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17780,a[2]=((C_word)li469),tmp=(C_word)a,a+=3,tmp));
t308=C_mutate((C_word*)lf[630]+1 /* (set! ##sys#/-2 ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17831,a[2]=((C_word)li470),tmp=(C_word)a,a+=3,tmp));
t309=C_mutate((C_word*)lf[646]+1 /* (set! scheme#floor ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18114,a[2]=((C_word)li471),tmp=(C_word)a,a+=3,tmp));
t310=C_mutate((C_word*)lf[648]+1 /* (set! scheme#ceiling ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18159,a[2]=((C_word)li472),tmp=(C_word)a,a+=3,tmp));
t311=C_mutate((C_word*)lf[650]+1 /* (set! scheme#truncate ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18204,a[2]=((C_word)li473),tmp=(C_word)a,a+=3,tmp));
t312=C_mutate((C_word*)lf[652]+1 /* (set! scheme#round ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18241,a[2]=((C_word)li474),tmp=(C_word)a,a+=3,tmp));
t313=C_mutate(&lf[654] /* (set! find-ratio-between ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18285,a[2]=((C_word)li476),tmp=(C_word)a,a+=3,tmp));
t314=C_mutate((C_word*)lf[656]+1 /* (set! scheme#rationalize ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18435,a[2]=((C_word)li477),tmp=(C_word)a,a+=3,tmp));
t315=C_mutate((C_word*)lf[657]+1 /* (set! scheme#max ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18460,a[2]=((C_word)li479),tmp=(C_word)a,a+=3,tmp));
t316=C_mutate((C_word*)lf[325]+1 /* (set! scheme#min ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18504,a[2]=((C_word)li481),tmp=(C_word)a,a+=3,tmp));
t317=C_mutate((C_word*)lf[660]+1 /* (set! scheme#exp ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18548,a[2]=((C_word)li482),tmp=(C_word)a,a+=3,tmp));
t318=C_mutate((C_word*)lf[662]+1 /* (set! ##sys#log-1 ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18593,a[2]=((C_word)li483),tmp=(C_word)a,a+=3,tmp));
t319=C_mutate((C_word*)lf[666]+1 /* (set! scheme#log ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18642,a[2]=((C_word)li484),tmp=(C_word)a,a+=3,tmp));
t320=C_mutate((C_word*)lf[667]+1 /* (set! scheme#sin ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18671,a[2]=((C_word)li485),tmp=(C_word)a,a+=3,tmp));
t321=C_mutate((C_word*)lf[671]+1 /* (set! scheme#cos ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18705,a[2]=((C_word)li486),tmp=(C_word)a,a+=3,tmp));
t322=C_mutate((C_word*)lf[673]+1 /* (set! scheme#tan ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18739,a[2]=((C_word)li487),tmp=(C_word)a,a+=3,tmp));
t323=C_mutate((C_word*)lf[675]+1 /* (set! scheme#asin ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18764,a[2]=((C_word)li488),tmp=(C_word)a,a+=3,tmp));
t324=C_a_i_asin(&a,1,C_fix(1));
t325=C_mutate((C_word*)lf[680]+1 /* (set! scheme#acos ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18826,a[2]=t324,a[3]=((C_word)li489),tmp=(C_word)a,a+=4,tmp));
t326=C_mutate((C_word*)lf[682]+1 /* (set! scheme#atan ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18868,a[2]=((C_word)li490),tmp=(C_word)a,a+=3,tmp));
t327=C_mutate((C_word*)lf[684]+1 /* (set! ##sys#exact-integer-sqrt ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18932,a[2]=((C_word)li496),tmp=(C_word)a,a+=3,tmp));
t328=C_mutate((C_word*)lf[686]+1 /* (set! scheme#exact-integer-sqrt ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19123,a[2]=((C_word)li497),tmp=(C_word)a,a+=3,tmp));
t329=C_mutate((C_word*)lf[678]+1 /* (set! ##sys#sqrt/loc ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19132,a[2]=((C_word)li504),tmp=(C_word)a,a+=3,tmp));
t330=C_mutate((C_word*)lf[617]+1 /* (set! scheme#sqrt ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19287,a[2]=((C_word)li505),tmp=(C_word)a,a+=3,tmp));
t331=C_mutate((C_word*)lf[689]+1 /* (set! scheme#truncate/ ...) */,*((C_word*)lf[221]+1));
t332=C_mutate((C_word*)lf[690]+1 /* (set! scheme#floor/ ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19294,a[2]=((C_word)li508),tmp=(C_word)a,a+=3,tmp));
t333=C_mutate((C_word*)lf[691]+1 /* (set! scheme#floor-remainder ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19349,a[2]=((C_word)li511),tmp=(C_word)a,a+=3,tmp));
t334=C_mutate((C_word*)lf[692]+1 /* (set! scheme#floor-quotient ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19364,a[2]=((C_word)li514),tmp=(C_word)a,a+=3,tmp));
t335=C_mutate((C_word*)lf[693]+1 /* (set! scheme#square ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19379,a[2]=((C_word)li515),tmp=(C_word)a,a+=3,tmp));
t336=C_mutate((C_word*)lf[694]+1 /* (set! chicken.base#exact-integer-nth-root ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19385,a[2]=((C_word)li516),tmp=(C_word)a,a+=3,tmp));
t337=C_mutate((C_word*)lf[695]+1 /* (set! ##sys#exact-integer-nth-root/loc ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19397,a[2]=((C_word)li518),tmp=(C_word)a,a+=3,tmp));
t338=C_mutate((C_word*)lf[632]+1 /* (set! ##sys#integer-power ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19523,a[2]=((C_word)li520),tmp=(C_word)a,a+=3,tmp));
t339=C_mutate((C_word*)lf[634]+1 /* (set! scheme#expt ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19591,a[2]=((C_word)li525),tmp=(C_word)a,a+=3,tmp));
t340=C_mutate(&lf[644] /* (set! ##sys#internal-gcd ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19858,a[2]=((C_word)li526),tmp=(C_word)a,a+=3,tmp));
t341=C_mutate((C_word*)lf[699]+1 /* (set! ##sys#gcd ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19928,a[2]=((C_word)li527),tmp=(C_word)a,a+=3,tmp));
t342=C_mutate((C_word*)lf[701]+1 /* (set! scheme#gcd ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19934,a[2]=((C_word)li529),tmp=(C_word)a,a+=3,tmp));
t343=C_mutate((C_word*)lf[702]+1 /* (set! ##sys#lcm ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19985,a[2]=((C_word)li530),tmp=(C_word)a,a+=3,tmp));
t344=C_mutate((C_word*)lf[704]+1 /* (set! scheme#lcm ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19999,a[2]=((C_word)li532),tmp=(C_word)a,a+=3,tmp));
t345=C_mutate((C_word*)lf[705]+1 /* (set! ##sys#integer->string/recursive ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20057,a[2]=((C_word)li536),tmp=(C_word)a,a+=3,tmp));
t346=C_mutate((C_word*)lf[707]+1 /* (set! ##sys#extended-number->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20107,a[2]=((C_word)li537),tmp=(C_word)a,a+=3,tmp));
t347=C_mutate(&lf[713] /* (set! round-quotient ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20281,a[2]=((C_word)li538),tmp=(C_word)a,a+=3,tmp));
t348=C_mutate(&lf[714] /* (set! ##sys#string->compnum ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_20324,a[2]=((C_word)li550),tmp=(C_word)a,a+=3,tmp));
t349=C_mutate((C_word*)lf[723]+1 /* (set! scheme#string->number ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_21707,a[2]=((C_word)li552),tmp=(C_word)a,a+=3,tmp));
t350=C_mutate((C_word*)lf[725]+1 /* (set! ##sys#string->number ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_21956,a[2]=((C_word)li553),tmp=(C_word)a,a+=3,tmp));
t351=C_mutate((C_word*)lf[726]+1 /* (set! ##sys#fixnum->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_fixnum_to_string,a[2]=((C_word)li554),tmp=(C_word)a,a+=3,tmp));
t352=C_mutate((C_word*)lf[727]+1 /* (set! ##sys#flonum->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_flonum_to_string,a[2]=((C_word)li555),tmp=(C_word)a,a+=3,tmp));
t353=C_mutate((C_word*)lf[728]+1 /* (set! ##sys#integer->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_integer_to_string,a[2]=((C_word)li556),tmp=(C_word)a,a+=3,tmp));
t354=C_mutate((C_word*)lf[706]+1 /* (set! ##sys#number->string ...) */,*((C_word*)lf[111]+1));
t355=C_mutate((C_word*)lf[729]+1 /* (set! chicken.base#equal=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22002,a[2]=((C_word)li560),tmp=(C_word)a,a+=3,tmp));
t356=C_mutate((C_word*)lf[730]+1 /* (set! ##sys#snafu ...) */,lf[731]);
t357=C_mutate((C_word*)lf[732]+1 /* (set! ##sys#intern-symbol ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_string_to_symbol,a[2]=((C_word)li561),tmp=(C_word)a,a+=3,tmp));
t358=C_mutate((C_word*)lf[733]+1 /* (set! ##sys#intern-keyword ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_string_to_keyword,a[2]=((C_word)li562),tmp=(C_word)a,a+=3,tmp));
t359=C_mutate((C_word*)lf[734]+1 /* (set! ##sys#make-symbol ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_make_symbol,a[2]=((C_word)li563),tmp=(C_word)a,a+=3,tmp));
t360=C_mutate((C_word*)lf[735]+1 /* (set! ##sys#interned-symbol? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22189,a[2]=((C_word)li564),tmp=(C_word)a,a+=3,tmp));
t361=C_mutate((C_word*)lf[736]+1 /* (set! ##sys#string->symbol-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22192,a[2]=((C_word)li565),tmp=(C_word)a,a+=3,tmp));
t362=C_mutate((C_word*)lf[737]+1 /* (set! ##sys#symbol->string/shared ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22204,a[2]=((C_word)li566),tmp=(C_word)a,a+=3,tmp));
t363=C_mutate((C_word*)lf[738]+1 /* (set! ##sys#symbol->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22210,a[2]=((C_word)li567),tmp=(C_word)a,a+=3,tmp));
t364=C_mutate((C_word*)lf[739]+1 /* (set! ##sys#string->symbol ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22223,a[2]=((C_word)li568),tmp=(C_word)a,a+=3,tmp));
t365=C_mutate((C_word*)lf[740]+1 /* (set! scheme#symbol->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22233,a[2]=((C_word)li569),tmp=(C_word)a,a+=3,tmp));
t366=C_mutate((C_word*)lf[742]+1 /* (set! scheme#string->symbol ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22242,a[2]=((C_word)li570),tmp=(C_word)a,a+=3,tmp));
t367=C_mutate((C_word*)lf[744]+1 /* (set! chicken.base#string->uninterned-symbol ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22251,a[2]=((C_word)li571),tmp=(C_word)a,a+=3,tmp));
t368=C_fix(-1);
t369=(*a=C_VECTOR_TYPE|1,a[1]=t368,tmp=(C_word)a,a+=2,tmp);
t370=C_mutate((C_word*)lf[746]+1 /* (set! chicken.base#gensym ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_22264,a[2]=t369,a[3]=((C_word)li572),tmp=(C_word)a,a+=4,tmp));
t371=*((C_word*)lf[508]+1);
t372=C_mutate((C_word*)lf[750]+1 /* (set! chicken.base#symbol-append ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_22322,a[2]=t371,a[3]=((C_word)li574),tmp=(C_word)a,a+=4,tmp));
t373=C_a_i_provide(&a,1,lf[752]);
t374=C_mutate((C_word*)lf[753]+1 /* (set! chicken.keyword#keyword? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22381,a[2]=((C_word)li575),tmp=(C_word)a,a+=3,tmp));
t375=C_mutate((C_word*)lf[754]+1 /* (set! chicken.keyword#string->keyword ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22384,a[2]=((C_word)li576),tmp=(C_word)a,a+=3,tmp));
t376=*((C_word*)lf[753]+1);
t377=C_mutate((C_word*)lf[756]+1 /* (set! chicken.keyword#keyword->string ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_22397,a[2]=t376,a[3]=((C_word)li577),tmp=(C_word)a,a+=4,tmp));
t378=C_a_i_list1(&a,1,lf[759]);
t379=C_mutate((C_word*)lf[760]+1 /* (set! chicken.keyword#get-keyword ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_22415,a[2]=t378,a[3]=((C_word)li578),tmp=(C_word)a,a+=4,tmp));
t380=C_mutate((C_word*)lf[762]+1 /* (set! ##sys#get-keyword ...) */,*((C_word*)lf[760]+1));
t381=C_mutate((C_word*)lf[763]+1 /* (set! ##sys#bytevector->list ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22446,a[2]=((C_word)li580),tmp=(C_word)a,a+=3,tmp));
t382=C_mutate((C_word*)lf[764]+1 /* (set! ##sys#list->bytevector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22480,a[2]=((C_word)li582),tmp=(C_word)a,a+=3,tmp));
t383=C_a_i_provide(&a,1,lf[766]);
t384=C_mutate((C_word*)lf[767]+1 /* (set! chicken.bytevector#make-bytevector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22519,a[2]=((C_word)li583),tmp=(C_word)a,a+=3,tmp));
t385=C_mutate((C_word*)lf[769]+1 /* (set! chicken.bytevector#bytevector? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22543,a[2]=((C_word)li584),tmp=(C_word)a,a+=3,tmp));
t386=C_mutate((C_word*)lf[770]+1 /* (set! chicken.bytevector#bytevector-length ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22549,a[2]=((C_word)li585),tmp=(C_word)a,a+=3,tmp));
t387=C_mutate((C_word*)lf[772]+1 /* (set! chicken.bytevector#bytevector-u8-ref ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22558,a[2]=((C_word)li586),tmp=(C_word)a,a+=3,tmp));
t388=C_mutate((C_word*)lf[773]+1 /* (set! chicken.bytevector#bytevector-u8-set! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22561,a[2]=((C_word)li587),tmp=(C_word)a,a+=3,tmp));
t389=C_mutate((C_word*)lf[774]+1 /* (set! chicken.bytevector#string->utf8 ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22564,a[2]=((C_word)li588),tmp=(C_word)a,a+=3,tmp));
t390=C_mutate((C_word*)lf[776]+1 /* (set! chicken.bytevector#utf8->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22580,a[2]=((C_word)li589),tmp=(C_word)a,a+=3,tmp));
t391=C_mutate((C_word*)lf[778]+1 /* (set! chicken.bytevector#string->latin1 ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22620,a[2]=((C_word)li590),tmp=(C_word)a,a+=3,tmp));
t392=C_mutate((C_word*)lf[780]+1 /* (set! chicken.bytevector#latin1->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22639,a[2]=((C_word)li591),tmp=(C_word)a,a+=3,tmp));
t393=C_mutate((C_word*)lf[782]+1 /* (set! chicken.bytevector#bytevector=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22655,a[2]=((C_word)li592),tmp=(C_word)a,a+=3,tmp));
t394=C_mutate((C_word*)lf[784]+1 /* (set! chicken.bytevector#bytevector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22677,a[2]=((C_word)li594),tmp=(C_word)a,a+=3,tmp));
t395=C_mutate((C_word*)lf[786]+1 /* (set! chicken.bytevector#bytevector-copy ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22708,a[2]=((C_word)li595),tmp=(C_word)a,a+=3,tmp));
t396=C_mutate((C_word*)lf[789]+1 /* (set! chicken.bytevector#bytevector-copy! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22789,a[2]=((C_word)li596),tmp=(C_word)a,a+=3,tmp));
t397=C_mutate((C_word*)lf[792]+1 /* (set! chicken.bytevector#bytevector-append ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22871,a[2]=((C_word)li599),tmp=(C_word)a,a+=3,tmp));
t398=C_mutate((C_word*)lf[117]+1 /* (set! scheme#make-vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22929,a[2]=((C_word)li600),tmp=(C_word)a,a+=3,tmp));
t399=C_mutate((C_word*)lf[796]+1 /* (set! ##sys#make-vector ...) */,*((C_word*)lf[117]+1));
t400=C_mutate((C_word*)lf[118]+1 /* (set! scheme#list->vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_22958,a[2]=((C_word)li602),tmp=(C_word)a,a+=3,tmp));
t401=C_mutate((C_word*)lf[119]+1 /* (set! scheme#vector->list ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23010,a[2]=((C_word)li604),tmp=(C_word)a,a+=3,tmp));
t402=C_mutate((C_word*)lf[120]+1 /* (set! scheme#vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23096,a[2]=((C_word)li605),tmp=(C_word)a,a+=3,tmp));
t403=C_mutate((C_word*)lf[121]+1 /* (set! scheme#vector-fill! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23102,a[2]=((C_word)li607),tmp=(C_word)a,a+=3,tmp));
t404=C_mutate((C_word*)lf[800]+1 /* (set! scheme#vector-copy ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23183,a[2]=((C_word)li610),tmp=(C_word)a,a+=3,tmp));
t405=C_mutate((C_word*)lf[802]+1 /* (set! scheme#vector-copy! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23290,a[2]=((C_word)li614),tmp=(C_word)a,a+=3,tmp));
t406=C_mutate((C_word*)lf[804]+1 /* (set! scheme#vector-append ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23463,a[2]=((C_word)li619),tmp=(C_word)a,a+=3,tmp));
t407=C_mutate((C_word*)lf[245]+1 /* (set! chicken.base#subvector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23607,a[2]=((C_word)li621),tmp=(C_word)a,a+=3,tmp));
t408=C_mutate((C_word*)lf[246]+1 /* (set! chicken.base#vector-resize ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23670,a[2]=((C_word)li622),tmp=(C_word)a,a+=3,tmp));
t409=C_mutate(&lf[808] /* (set! ##sys#vector-resize ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23691,a[2]=((C_word)li624),tmp=(C_word)a,a+=3,tmp));
t410=C_mutate((C_word*)lf[141]+1 /* (set! scheme#char-ci=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23730,a[2]=((C_word)li626),tmp=(C_word)a,a+=3,tmp));
t411=C_mutate((C_word*)lf[142]+1 /* (set! scheme#char-ci>? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23779,a[2]=((C_word)li628),tmp=(C_word)a,a+=3,tmp));
t412=C_mutate((C_word*)lf[143]+1 /* (set! scheme#char-ci<? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23822,a[2]=((C_word)li630),tmp=(C_word)a,a+=3,tmp));
t413=C_mutate((C_word*)lf[144]+1 /* (set! scheme#char-ci>=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23865,a[2]=((C_word)li632),tmp=(C_word)a,a+=3,tmp));
t414=C_mutate((C_word*)lf[145]+1 /* (set! scheme#char-ci<=? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23908,a[2]=((C_word)li634),tmp=(C_word)a,a+=3,tmp));
t415=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_23953,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* library.scm:3748: scheme#make-vector */
t416=*((C_word*)lf[117]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t416;
av2[1]=t415;
av2[2]=C_fix(37);
av2[3]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t416+1)))(4,av2);}}

/* chicken.base#fixnum? in k12556 in k11433 */
static void C_ccall f_12560(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12560,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_fixnump(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#flonum? in k12556 in k11433 */
static void C_ccall f_12563(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12563,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_flonump(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#bignum? in k12556 in k11433 */
static void C_ccall f_12566(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12566,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_bignump(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#ratnum? in k12556 in k11433 */
static void C_ccall f_12569(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12569,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_ratnump(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#cplxnum? in k12556 in k11433 */
static void C_ccall f_12572(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12572,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_cplxnump(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#exact-integer? in k12556 in k11433 */
static void C_ccall f_12575(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12575,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_exact_integerp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#quotient&modulo in k12556 in k11433 */
static void C_ccall f_12580(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,4)))){
C_save_and_reclaim((void *)f_12580,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12586,a[2]=t2,a[3]=t3,a[4]=((C_word)li142),tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12592,a[2]=t3,a[3]=((C_word)li143),tmp=(C_word)a,a+=4,tmp);
/* library.scm:812: scheme#call-with-values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t4;
av2[3]=t5;
C_call_with_values(4,av2);}}

/* a12585 in chicken.base#quotient&modulo in k12556 in k11433 */
static void C_ccall f_12586(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_12586,c,av);}
/* library.scm:812: chicken.base#quotient&remainder */
t2=*((C_word*)lf[221]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* a12591 in chicken.base#quotient&modulo in k12556 in k11433 */
static void C_ccall f_12592(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(29,c,3)))){
C_save_and_reclaim((void *)f_12592,c,av);}
a=C_alloc(29);
if(C_truep(C_i_positivep(((C_word*)t0)[2]))){
if(C_truep(C_i_negativep(t3))){
t4=C_s_a_i_plus(&a,2,t3,((C_word*)t0)[2]);
/* library.scm:816: scheme#values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t2;
av2[3]=t4;
C_values(4,av2);}}
else{
/* library.scm:817: scheme#values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
C_values(4,av2);}}}
else{
if(C_truep(C_i_positivep(t3))){
t4=C_s_a_i_plus(&a,2,t3,((C_word*)t0)[2]);
/* library.scm:819: scheme#values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t2;
av2[3]=t4;
C_values(4,av2);}}
else{
/* library.scm:820: scheme#values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
C_values(4,av2);}}}}

/* chicken.base#finite? in k12556 in k11433 */
static void C_ccall f_12627(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12627,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_finitep(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#infinite? in k12556 in k11433 */
static void C_ccall f_12630(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12630,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_infinitep(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#nan? in k12556 in k11433 */
static void C_ccall f_12633(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12633,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_nanp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#add1 in k12556 in k11433 */
static void C_ccall f_12641(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(29,c,1)))){
C_save_and_reclaim((void *)f_12641,c,av);}
a=C_alloc(29);
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_i_plus(&a,2,t2,C_fix(1));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#sub1 in k12556 in k11433 */
static void C_ccall f_12647(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(29,c,1)))){
C_save_and_reclaim((void *)f_12647,c,av);}
a=C_alloc(29);
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_i_minus(&a,2,t2,C_fix(1));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#error in k12556 in k11433 */
static void C_ccall f_12654(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +0,c,4)))){
C_save_and_reclaim((void*)f_12654,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+0);
t2=C_build_rest(&a,c,2,av);
C_word t3;
if(C_truep(C_i_pairp(t2))){{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t1;
av2[2]=*((C_word*)lf[235]+1);
av2[3]=lf[236];
av2[4]=t2;
C_apply(5,av2);}}
else{
/* library.scm:841: ##sys#signal-hook */
t3=*((C_word*)lf[235]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=lf[236];
av2[3]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}}

/* chicken.base#void in k12556 in k11433 */
static void C_ccall f_12669(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12669,c,av);}
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.base#promise? in k12556 in k11433 */
static void C_ccall f_12683(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12683,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_structurep(t2,lf[250]);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#make-promise in k12556 in k11433 */
static void C_ccall f_12689(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_12689,c,av);}
a=C_alloc(3);
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_record2(&a,2,lf[250],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#make-promise in k12556 in k11433 */
static void C_ccall f_12695(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_12695,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12702,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:878: promise? */
t4=*((C_word*)lf[249]+1);{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k12700 in chicken.base#make-promise in k12556 in k11433 */
static void C_ccall f_12702(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_12702,c,av);}
a=C_alloc(4);
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12707,a[2]=((C_word*)t0)[3],a[3]=((C_word)li155),tmp=(C_word)a,a+=4,tmp);
/* library.scm:879: ##sys#make-promise */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[251]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[251]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t2;
tp(3,av2);}}}

/* a12706 in k12700 in chicken.base#make-promise in k12556 in k11433 */
static void C_ccall f_12707(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12707,c,av);}
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.base#foldl in k12556 in k11433 */
static void C_ccall f_12710(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_12710,c,av);}
a=C_alloc(7);
t5=C_i_check_list_2(t4,lf[254]);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12719,a[2]=t7,a[3]=t2,a[4]=((C_word)li157),tmp=(C_word)a,a+=5,tmp));
t9=((C_word*)t7)[1];
f_12719(t9,t1,t4,t3);}

/* loop in chicken.base#foldl in k12556 in k11433 */
static void f_12719(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_12719,4,t0,t1,t2,t3);}
a=C_alloc(5);
t4=C_i_pairp(t2);
if(C_truep(C_i_not(t4))){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t5=C_slot(t2,C_fix(1));
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12737,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t5,tmp=(C_word)a,a+=5,tmp);
/* library.scm:888: f */
t7=((C_word*)t0)[3];{
C_word av2[4];
av2[0]=t7;
av2[1]=t6;
av2[2]=t3;
av2[3]=C_slot(t2,C_fix(0));
((C_proc)C_fast_retrieve_proc(t7))(4,av2);}}}

/* k12735 in loop in chicken.base#foldl in k12556 in k11433 */
static void C_ccall f_12737(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_12737,c,av);}
/* library.scm:888: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_12719(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* chicken.base#foldr in k12556 in k11433 */
static void C_ccall f_12747(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_12747,c,av);}
a=C_alloc(8);
t5=C_i_check_list_2(t4,lf[256]);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_12756,a[2]=t3,a[3]=t2,a[4]=t7,a[5]=((C_word)li159),tmp=(C_word)a,a+=6,tmp));
t9=((C_word*)t7)[1];
f_12756(t9,t1,t4);}

/* loop in chicken.base#foldr in k12556 in k11433 */
static void f_12756(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_12756,3,t0,t1,t2);}
a=C_alloc(5);
t3=C_i_pairp(t2);
if(C_truep(C_i_not(t3))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_slot(t2,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12774,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* library.scm:895: loop */
t7=t5;
t8=C_slot(t2,C_fix(1));
t1=t7;
t2=t8;
goto loop;}}

/* k12772 in loop in chicken.base#foldr in k12556 in k11433 */
static void C_ccall f_12774(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_12774,c,av);}
/* library.scm:895: f */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=t1;
((C_proc)C_fast_retrieve_proc(t2))(4,av2);}}

/* chicken.base#on-exit in k12556 in k11433 */
static void C_ccall f_12787(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_12787,c,av);}
a=C_alloc(3);
t3=C_a_i_cons(&a,2,t2,*((C_word*)lf[259]+1));
t4=C_mutate((C_word*)lf[259]+1 /* (set! chicken.base#cleanup-tasks ...) */,t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* chicken.base#exit in k12556 in k11433 */
static void C_ccall f_12794(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_12794,c,av);}
a=C_alloc(4);
if(C_truep(C_rest_nullp(c,2))){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f45103,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:908: chicken.base#exit-handler */
t3=*((C_word*)lf[258]+1);{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=C_get_rest_arg(c,2,av,2,t0);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12801,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:908: chicken.base#exit-handler */
t4=*((C_word*)lf[258]+1);{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k12799 in chicken.base#exit in k12556 in k11433 */
static void C_ccall f_12801(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_12801,c,av);}
/* library.scm:907: g887 */
t2=t1;{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* chicken.base#emergency-exit in k12556 in k11433 */
static void C_ccall f_12812(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12812,c,av);}
if(C_truep(C_rest_nullp(c,2))){
t2=C_i_check_fixnum_2(C_fix(0),lf[263]);
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_exit_runtime(C_fix(0));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=C_get_rest_arg(c,2,av,2,t0);
t3=C_i_check_fixnum_2(t2,lf[263]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_exit_runtime(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* chicken.base#identity in k12556 in k11433 */
static void C_ccall f_12831(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12831,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#conjoin in k12556 in k11433 */
static void C_ccall f_12834(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,3)))){
C_save_and_reclaim((void*)f_12834,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12836,a[2]=t2,a[3]=((C_word)li166),tmp=(C_word)a,a+=4,tmp);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* f_12836 in chicken.base#conjoin in k12556 in k11433 */
static void C_ccall f_12836(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,3)))){
C_save_and_reclaim((void *)f_12836,c,av);}
a=C_alloc(7);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12842,a[2]=t4,a[3]=t2,a[4]=((C_word)li165),tmp=(C_word)a,a+=5,tmp));
t6=((C_word*)t4)[1];
f_12842(t6,t1,((C_word*)t0)[2]);}

/* loop */
static void f_12842(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_12842,3,t0,t1,t2);}
a=C_alloc(5);
t3=C_i_nullp(t2);
if(C_truep(t3)){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_slot(t2,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12858,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:929: g916 */
t6=t4;{
C_word av2[3];
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[3];
((C_proc)C_fast_retrieve_proc(t6))(3,av2);}}}

/* k12856 in loop */
static void C_ccall f_12858(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_12858,c,av);}
if(C_truep(t1)){
/* library.scm:930: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_12842(t2,((C_word*)t0)[3],C_slot(((C_word*)t0)[4],C_fix(1)));}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* chicken.base#disjoin in k12556 in k11433 */
static void C_ccall f_12867(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,3)))){
C_save_and_reclaim((void*)f_12867,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12869,a[2]=t2,a[3]=((C_word)li169),tmp=(C_word)a,a+=4,tmp);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* f_12869 in chicken.base#disjoin in k12556 in k11433 */
static void C_ccall f_12869(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,3)))){
C_save_and_reclaim((void *)f_12869,c,av);}
a=C_alloc(7);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12875,a[2]=t4,a[3]=t2,a[4]=((C_word)li168),tmp=(C_word)a,a+=5,tmp));
t6=((C_word*)t4)[1];
f_12875(t6,t1,((C_word*)t0)[2]);}

/* loop */
static void f_12875(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_12875,3,t0,t1,t2);}
a=C_alloc(5);
t3=C_i_nullp(t2);
if(C_truep(C_i_not(t3))){
t4=C_slot(t2,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_12888,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:936: g928 */
t6=t4;{
C_word av2[3];
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[3];
((C_proc)C_fast_retrieve_proc(t6))(3,av2);}}
else{
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k12886 in loop */
static void C_ccall f_12888(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_12888,c,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* library.scm:937: loop */
t2=((C_word*)((C_word*)t0)[3])[1];
f_12875(t2,((C_word*)t0)[2],C_slot(((C_word*)t0)[4],C_fix(1)));}}

/* chicken.base#constantly in k12556 in k11433 */
static void C_ccall f_12904(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_12904,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
t3=C_eqp(C_fix(1),C_u_i_length(t2));
if(C_truep(t3)){
t4=C_i_car(t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12915,a[2]=t4,a[3]=((C_word)li171),tmp=(C_word)a,a+=4,tmp);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12917,a[2]=t2,a[3]=((C_word)li172),tmp=(C_word)a,a+=4,tmp);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* f_12915 in chicken.base#constantly in k12556 in k11433 */
static void C_ccall f_12915(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12915,c,av);}
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* f_12917 in chicken.base#constantly in k12556 in k11433 */
static void C_ccall f_12917(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_12917,c,av);}{
C_word av2[4];
av2[0]=0;
av2[1]=t1;
av2[2]=*((C_word*)lf[160]+1);
av2[3]=((C_word*)t0)[2];
C_apply(4,av2);}}

/* chicken.base#flip in k12556 in k11433 */
static void C_ccall f_12925(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,4)))){
C_save_and_reclaim((void *)f_12925,c,av);}
a=C_alloc(4);
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12927,a[2]=t2,a[3]=((C_word)li174),tmp=(C_word)a,a+=4,tmp);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* f_12927 in chicken.base#flip in k12556 in k11433 */
static void C_ccall f_12927(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_12927,c,av);}
/* library.scm:945: proc */
t4=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t1;
av2[2]=t3;
av2[3]=t2;
((C_proc)C_fast_retrieve_proc(t4))(4,av2);}}

/* chicken.base#complement in k12556 in k11433 */
static void C_ccall f_12933(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_12933,c,av);}
a=C_alloc(4);
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12935,a[2]=t2,a[3]=((C_word)li176),tmp=(C_word)a,a+=4,tmp);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* f_12935 in chicken.base#complement in k12556 in k11433 */
static void C_ccall f_12935(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +3,c,3)))){
C_save_and_reclaim((void*)f_12935,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+3);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_12943,a[2]=t1,tmp=(C_word)a,a+=3,tmp);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
av2[3]=t2;
C_apply(4,av2);}}

/* k12941 */
static void C_ccall f_12943(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_12943,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_i_not(t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.base#compose in k12556 in k11433 */
static void C_ccall f_12945(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +6,c,3)))){
C_save_and_reclaim((void*)f_12945,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+6);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12948,a[2]=t4,a[3]=((C_word)li180),tmp=(C_word)a,a+=4,tmp));
if(C_truep(C_rest_nullp(c,2))){
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=*((C_word*)lf[160]+1);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=((C_word*)t4)[1];
av2[3]=t2;
C_apply(4,av2);}}}

/* rec in chicken.base#compose in k12556 in k11433 */
static void C_ccall f_12948(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +6,c,2)))){
C_save_and_reclaim((void*)f_12948,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+6);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
if(C_truep(C_i_nullp(t3))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_12956,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=t2,a[5]=((C_word)li179),tmp=(C_word)a,a+=6,tmp);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* f_12956 in rec in chicken.base#compose in k12556 in k11433 */
static void C_ccall f_12956(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +6,c,3)))){
C_save_and_reclaim((void*)f_12956,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+6);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_12962,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word)li178),tmp=(C_word)a,a+=6,tmp);
/* library.scm:956: scheme#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t3;
av2[3]=((C_word*)t0)[4];
C_call_with_values(4,av2);}}

/* a12961 */
static void C_ccall f_12962(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_12962,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12970,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t2;
av2[2]=((C_word*)((C_word*)t0)[3])[1];
av2[3]=((C_word*)t0)[4];
C_apply(4,av2);}}

/* k12968 in a12961 */
static void C_ccall f_12970(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_12970,c,av);}{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=((C_word*)t0)[3];
C_apply(4,av2);}}

/* chicken.base#o in k12556 in k11433 */
static void C_ccall f_12981(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +6,c,3)))){
C_save_and_reclaim((void*)f_12981,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+6);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
if(C_truep(C_rest_nullp(c,2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=*((C_word*)lf[268]+1);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_12993,a[2]=t4,a[3]=((C_word)li183),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_12993(t6,t1,t2);}}

/* loop in chicken.base#o in k12556 in k11433 */
static void f_12993(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_12993,3,t0,t1,t2);}
a=C_alloc(6);
t3=C_slot(t2,C_fix(0));
t4=C_slot(t2,C_fix(1));
if(C_truep(C_i_nullp(t4))){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13007,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=t4,a[5]=((C_word)li182),tmp=(C_word)a,a+=6,tmp);
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* f_13007 in loop in chicken.base#o in k12556 in k11433 */
static void C_ccall f_13007(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_13007,c,av);}
a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13015,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:971: loop */
t4=((C_word*)((C_word*)t0)[3])[1];
f_12993(t4,t3,((C_word*)t0)[4]);}

/* k13013 */
static void C_ccall f_13015(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_13015,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13018,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:971: g957 */
t3=t1;{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
((C_proc)C_fast_retrieve_proc(t3))(3,av2);}}

/* k13016 in k13013 */
static void C_ccall f_13018(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_13018,c,av);}
/* library.scm:971: h */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
((C_proc)C_fast_retrieve_proc(t2))(3,av2);}}

/* chicken.base#list-of? in k12556 in k11433 */
static void C_ccall f_13020(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_13020,c,av);}
a=C_alloc(4);
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13022,a[2]=t2,a[3]=((C_word)li186),tmp=(C_word)a,a+=4,tmp);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* f_13022 in chicken.base#list-of? in k12556 in k11433 */
static void C_ccall f_13022(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,3)))){
C_save_and_reclaim((void *)f_13022,c,av);}
a=C_alloc(7);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13028,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=((C_word)li185),tmp=(C_word)a,a+=5,tmp));
t6=((C_word*)t4)[1];
f_13028(t6,t1,t2);}

/* loop */
static void f_13028(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_13028,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_nullp(t2))){
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_i_pairp(t2);
if(C_truep(C_i_not(t3))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13047,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:978: pred */
t5=((C_word*)t0)[3];{
C_word av2[3];
av2[0]=t5;
av2[1]=t4;
av2[2]=C_slot(t2,C_fix(0));
((C_proc)C_fast_retrieve_proc(t5))(3,av2);}}}}

/* k13045 in loop */
static void C_ccall f_13047(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_13047,c,av);}
if(C_truep(t1)){
/* library.scm:978: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_13028(t2,((C_word*)t0)[3],C_slot(((C_word*)t0)[4],C_fix(1)));}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* chicken.base#each in k12556 in k11433 */
static void C_ccall f_13064(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_13064,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
if(C_truep(C_i_nullp(t2))){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13072,a[2]=((C_word)li188),tmp=(C_word)a,a+=3,tmp);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_slot(t2,C_fix(1));
t4=C_i_nullp(t3);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=(C_truep(t4)?C_slot(t2,C_fix(0)):(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13086,a[2]=t2,a[3]=((C_word)li190),tmp=(C_word)a,a+=4,tmp));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* f_13072 in chicken.base#each in k12556 in k11433 */
static void C_ccall f_13072(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13072,c,av);}
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=*((C_word*)lf[278]+1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* f_13086 in chicken.base#each in k12556 in k11433 */
static void C_ccall f_13086(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +7,c,3)))){
C_save_and_reclaim((void*)f_13086,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+7);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13092,a[2]=t2,a[3]=t4,a[4]=((C_word)li189),tmp=(C_word)a,a+=5,tmp));
t6=((C_word*)t4)[1];
f_13092(t6,t1,((C_word*)t0)[2]);}

/* loop */
static void f_13092(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_13092,3,t0,t1,t2);}
a=C_alloc(5);
t3=C_slot(t2,C_fix(0));
t4=C_slot(t2,C_fix(1));
if(C_truep(C_i_nullp(t4))){{
C_word av2[4];
av2[0]=0;
av2[1]=t1;
av2[2]=t3;
av2[3]=((C_word*)t0)[2];
C_apply(4,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13111,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t4,tmp=(C_word)a,a+=5,tmp);{
C_word av2[4];
av2[0]=0;
av2[1]=t5;
av2[2]=t3;
av2[3]=((C_word*)t0)[2];
C_apply(4,av2);}}}

/* k13109 in loop */
static void C_ccall f_13111(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_13111,c,av);}
/* library.scm:993: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_13092(t2,((C_word*)t0)[3],((C_word*)t0)[4]);}

/* chicken.base#bwp-object? in k12556 in k11433 */
static void C_ccall f_13120(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13120,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_bwpp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#weak-cons in k12556 in k11433 */
static void C_ccall f_13123(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_13123,c,av);}
a=C_alloc(3);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_weak_cons(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.base#weak-pair? in k12556 in k11433 */
static void C_ccall f_13126(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13126,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_weak_pairp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#atom? in k12556 in k11433 */
static void C_ccall f_13129(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13129,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_not_pair_p(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#tail? in k12556 in k11433 */
static void C_ccall f_13132(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_13132,c,av);}
a=C_alloc(4);
t4=C_i_check_list_2(t3,lf[284]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13141,a[2]=t2,a[3]=((C_word)li196),tmp=(C_word)a,a+=4,tmp);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(
  f_13141(t5,t3)
);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* loop in chicken.base#tail? in k12556 in k11433 */
static C_word f_13141(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_stack_overflow_check;
loop:{}
if(C_truep(C_eqp(((C_word*)t0)[2],t1))){
return(C_SCHEME_TRUE);}
else{
t2=(C_truep(C_blockp(t1))?C_pairp(t1):C_SCHEME_FALSE);
if(C_truep(t2)){
t4=C_slot(t1,C_fix(1));
t1=t4;
goto loop;}
else{
return(C_SCHEME_FALSE);}}}

/* chicken.base#intersperse in k12556 in k11433 */
static void C_ccall f_13160(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,3)))){
C_save_and_reclaim((void *)f_13160,c,av);}
a=C_alloc(7);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13166,a[2]=t3,a[3]=t5,a[4]=((C_word)li198),tmp=(C_word)a,a+=5,tmp));
t7=((C_word*)t5)[1];
f_13166(t7,t1,t2);}

/* loop in chicken.base#intersperse in k12556 in k11433 */
static void f_13166(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_13166,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_eqp(t2,C_SCHEME_END_OF_LIST))){
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_i_cdr(t2);
if(C_truep(C_eqp(t3,C_SCHEME_END_OF_LIST))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_slot(t2,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13191,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1022: loop */
t7=t5;
t8=t3;
t1=t7;
t2=t8;
goto loop;}}}

/* k13189 in loop in chicken.base#intersperse in k12556 in k11433 */
static void C_ccall f_13191(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,1)))){
C_save_and_reclaim((void *)f_13191,c,av);}
a=C_alloc(6);
t2=C_a_i_cons(&a,2,((C_word*)t0)[2],t1);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[4],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#butlast in k12556 in k11433 */
static void C_ccall f_13193(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_13193,c,av);}
a=C_alloc(6);
t3=C_i_check_pair_2(t2,lf[287]);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13202,a[2]=t5,a[3]=((C_word)li200),tmp=(C_word)a,a+=4,tmp));
t7=((C_word*)t5)[1];
f_13202(t7,t1,t2);}

/* loop in chicken.base#butlast in k12556 in k11433 */
static void f_13202(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_13202,3,t0,t1,t2);}
a=C_alloc(4);
t3=C_slot(t2,C_fix(1));
t4=(C_truep(C_blockp(t3))?C_pairp(t3):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=C_slot(t2,C_fix(0));
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13223,a[2]=t1,a[3]=t5,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1029: loop */
t8=t6;
t9=t3;
t1=t8;
t2=t9;
goto loop;}
else{
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k13221 in loop in chicken.base#butlast in k12556 in k11433 */
static void C_ccall f_13223(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_13223,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.base#flatten in k12556 in k11433 */
static void C_ccall f_13225(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +6,c,4)))){
C_save_and_reclaim((void*)f_13225,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+6);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13231,a[2]=t4,a[3]=((C_word)li202),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_13231(t6,t1,t2,C_SCHEME_END_OF_LIST);}

/* loop in chicken.base#flatten in k12556 in k11433 */
static void f_13231(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_13231,4,t0,t1,t2,t3);}
a=C_alloc(5);
if(C_truep(C_i_nullp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_slot(t2,C_fix(0));
t5=C_slot(t2,C_fix(1));
if(C_truep(C_i_listp(t4))){
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13257,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1039: loop */
t8=t6;
t9=t5;
t10=t3;
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13264,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1040: loop */
t8=t6;
t9=t5;
t10=t3;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}}

/* k13255 in loop in chicken.base#flatten in k12556 in k11433 */
static void C_ccall f_13257(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_13257,c,av);}
/* library.scm:1039: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_13231(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k13262 in loop in chicken.base#flatten in k12556 in k11433 */
static void C_ccall f_13264(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_13264,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.base#join in k12556 in k11433 */
static void C_ccall f_13266(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +7,c,3)))){
C_save_and_reclaim((void*)f_13266,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+7);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
t4=C_i_pairp(t3);
t5=(C_truep(t4)?C_get_rest_arg(c,3,av,3,t0):C_SCHEME_END_OF_LIST);
t6=C_i_check_list_2(t5,lf[290]);
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13278,a[2]=t5,a[3]=t8,a[4]=((C_word)li204),tmp=(C_word)a,a+=5,tmp));
t10=((C_word*)t8)[1];
f_13278(t10,t1,t2);}

/* loop in chicken.base#join in k12556 in k11433 */
static void f_13278(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_13278,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_nullp(t2))){
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_i_pairp(t2);
if(C_truep(C_i_not(t3))){
/* library.scm:1050: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[51]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[51]+1);
av2[1]=t1;
av2[2]=t2;
tp(3,av2);}}
else{
t4=C_slot(t2,C_fix(0));
t5=C_slot(t2,C_fix(1));
if(C_truep(C_i_nullp(t5))){
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13313,a[2]=t1,a[3]=t4,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* library.scm:1056: loop */
t8=t6;
t9=t5;
t1=t8;
t2=t9;
goto loop;}}}}

/* k13311 in loop in chicken.base#join in k12556 in k11433 */
static void C_ccall f_13313(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_13313,c,av);}
/* library.scm:1056: ##sys#append */
t2=*((C_word*)lf[291]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
av2[4]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* chicken.base#compress in k12556 in k11433 */
static void C_ccall f_13323(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_13323,c,av);}
a=C_alloc(7);
t4=lf[293];
t5=C_i_check_list_2(t3,lf[294]);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13332,a[2]=t4,a[3]=t7,a[4]=((C_word)li206),tmp=(C_word)a,a+=5,tmp));
t9=((C_word*)t7)[1];
f_13332(t9,t1,t2,t3);}

/* loop in chicken.base#compress in k12556 in k11433 */
static void f_13332(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(4,0,5)))){
C_save_and_reclaim_args((void *)trf_13332,4,t0,t1,t2,t3);}
a=C_alloc(4);
if(C_truep(C_i_nullp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_i_pairp(t2);
if(C_truep(C_i_not(t4))){
/* library.scm:1065: ##sys#signal-hook */
t5=*((C_word*)lf[235]+1);{
C_word av2[6];
av2[0]=t5;
av2[1]=t1;
av2[2]=lf[295];
av2[3]=lf[294];
av2[4]=((C_word*)t0)[2];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(6,av2);}}
else{
t5=C_i_pairp(t3);
if(C_truep(C_i_not(t5))){
/* library.scm:1067: ##sys#signal-hook */
t6=*((C_word*)lf[235]+1);{
C_word av2[6];
av2[0]=t6;
av2[1]=t1;
av2[2]=lf[295];
av2[3]=lf[294];
av2[4]=((C_word*)t0)[2];
av2[5]=t3;
((C_proc)(void*)(*((C_word*)t6+1)))(6,av2);}}
else{
if(C_truep(C_slot(t2,C_fix(0)))){
t6=C_slot(t3,C_fix(0));
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13374,a[2]=t1,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1069: loop */
t9=t7;
t10=C_slot(t2,C_fix(1));
t11=C_slot(t3,C_fix(1));
t1=t9;
t2=t10;
t3=t11;
goto loop;}
else{
/* library.scm:1070: loop */
t9=t1;
t10=C_slot(t2,C_fix(1));
t11=C_slot(t3,C_fix(1));
t1=t9;
t2=t10;
t3=t11;
goto loop;}}}}}

/* k13372 in loop in chicken.base#compress in k12556 in k11433 */
static void C_ccall f_13374(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_13374,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.base#char-foldcase in k12556 in k11433 */
static void C_ccall f_13403(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13403,c,av);}
t3=C_i_check_char_2(t2,lf[297]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_utf_char_foldcase(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.base#string-foldcase in k12556 in k11433 */
static void C_ccall f_13409(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_13409,c,av);}
a=C_alloc(5);
t3=C_i_check_string_2(t2,lf[299]);
t4=C_slot(t2,C_fix(0));
t5=C_block_size(t4);
t6=C_fixnum_difference(t5,C_fix(1));
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13423,a[2]=t1,a[3]=t4,a[4]=t6,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1083: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[301]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[301]+1);
av2[1]=t7;
av2[2]=C_fixnum_times(t6,C_fix(2));
tp(3,av2);}}

/* k13421 in chicken.base#string-foldcase in k12556 in k11433 */
static void C_ccall f_13423(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_13423,c,av);}
/* library.scm:1085: ##sys#buffer->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[300]+1));
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[300]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=C_fix(0);
av2[4]=C_utf_string_foldcase(((C_word*)t0)[3],t1,((C_word*)t0)[4]);
tp(5,av2);}}

/* chicken.base#alist-update! in k12556 in k11433 */
static void C_ccall f_13429(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(10,c,4)))){
C_save_and_reclaim((void *)f_13429,c,av);}
a=C_alloc(10);
t5=C_rest_nullp(c,5);
t6=(C_truep(t5)?*((C_word*)lf[5]+1):C_get_rest_arg(c,5,av,5,t0));
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13436,a[2]=t3,a[3]=t1,a[4]=t4,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t8=C_eqp(*((C_word*)lf[4]+1),t6);
if(C_truep(t8)){
t9=t7;
f_13436(t9,*((C_word*)lf[56]+1));}
else{
t9=C_eqp(*((C_word*)lf[5]+1),t6);
if(C_truep(t9)){
t10=t7;
f_13436(t10,*((C_word*)lf[57]+1));}
else{
t10=C_eqp(*((C_word*)lf[6]+1),t6);
t11=t7;
f_13436(t11,(C_truep(t10)?*((C_word*)lf[58]+1):(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13468,a[2]=t6,a[3]=((C_word)li211),tmp=(C_word)a,a+=4,tmp)));}}}

/* k13434 in chicken.base#alist-update! in k12556 in k11433 */
static void f_13436(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,0,3)))){
C_save_and_reclaim_args((void *)trf_13436,2,t0,t1);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13439,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* library.scm:1102: aq */
t3=t1;{
C_word av2[4];
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[5];
av2[3]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k13437 in k13434 in chicken.base#alist-update! in k12556 in k11433 */
static void C_ccall f_13439(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,1)))){
C_save_and_reclaim((void *)f_13439,c,av);}
a=C_alloc(6);
t2=((C_word*)t0)[2];
if(C_truep(t1)){
t3=C_i_setslot(t1,C_fix(1),((C_word*)t2)[2]);
t4=((C_word*)t2)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=((C_word*)t2)[4];
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_a_i_cons(&a,2,((C_word*)t2)[5],((C_word*)t2)[2]);
t4=((C_word*)t2)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_cons(&a,2,t3,((C_word*)t2)[4]);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* f_13468 in chicken.base#alist-update! in k12556 in k11433 */
static void C_ccall f_13468(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_13468,c,av);}
a=C_alloc(8);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13474,a[2]=t5,a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=((C_word)li210),tmp=(C_word)a,a+=6,tmp));
t7=((C_word*)t5)[1];
f_13474(t7,t1,t3);}

/* loop */
static void f_13474(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_13474,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_pairp(t2))){
t3=C_slot(t2,C_fix(0));
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13490,a[2]=t1,a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_i_pairp(t3))){
/* library.scm:1099: cmp */
t5=((C_word*)t0)[3];{
C_word av2[4];
av2[0]=t5;
av2[1]=t4;
av2[2]=((C_word*)t0)[4];
av2[3]=C_slot(t3,C_fix(0));
((C_proc)C_fast_retrieve_proc(t5))(4,av2);}}
else{
/* library.scm:1101: loop */
t6=t1;
t7=C_slot(t2,C_fix(1));
t1=t6;
t2=t7;
goto loop;}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k13488 in loop */
static void C_ccall f_13490(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_13490,c,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* library.scm:1101: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_13474(t2,((C_word*)t0)[2],C_slot(((C_word*)t0)[5],C_fix(1)));}}

/* chicken.base#alist-update in k12556 in k11433 */
static void C_ccall f_13515(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_13515,c,av);}
a=C_alloc(9);
t5=C_rest_nullp(c,5);
t6=(C_truep(t5)?*((C_word*)lf[5]+1):C_get_rest_arg(c,5,av,5,t0));
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_13524,a[2]=t2,a[3]=t3,a[4]=t8,a[5]=t6,a[6]=((C_word)li213),tmp=(C_word)a,a+=7,tmp));
t10=((C_word*)t8)[1];
f_13524(t10,t1,t4);}

/* loop in chicken.base#alist-update in k12556 in k11433 */
static void f_13524(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,4)))){
C_save_and_reclaim_args((void *)trf_13524,3,t0,t1,t2);}
a=C_alloc(8);
if(C_truep(C_i_nullp(t2))){
t3=C_a_i_cons(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_a_i_list1(&a,1,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=C_i_pairp(t2);
if(C_truep(C_i_not(t3))){
/* library.scm:1114: chicken.base#error */
t4=*((C_word*)lf[234]+1);{
C_word av2[5];
av2[0]=t4;
av2[1]=t1;
av2[2]=lf[304];
av2[3]=lf[305];
av2[4]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}
else{
t4=C_slot(t2,C_fix(0));
t5=C_i_pairp(t4);
if(C_truep(C_i_not(t5))){
/* library.scm:1118: chicken.base#error */
t6=*((C_word*)lf[234]+1);{
C_word av2[5];
av2[0]=t6;
av2[1]=t1;
av2[2]=lf[304];
av2[3]=lf[306];
av2[4]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}
else{
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_13565,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=t1,a[6]=t4,a[7]=((C_word*)t0)[4],tmp=(C_word)a,a+=8,tmp);
/* library.scm:1119: cmp */
t7=((C_word*)t0)[5];{
C_word av2[4];
av2[0]=t7;
av2[1]=t6;
av2[2]=((C_word*)t0)[2];
av2[3]=C_slot(t4,C_fix(0));
((C_proc)C_fast_retrieve_proc(t7))(4,av2);}}}}}

/* k13563 in loop in chicken.base#alist-update in k12556 in k11433 */
static void C_ccall f_13565(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_13565,c,av);}
a=C_alloc(7);
if(C_truep(t1)){
t2=C_a_i_cons(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=C_slot(((C_word*)t0)[4],C_fix(1));
t4=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_cons(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t2=C_slot(((C_word*)t0)[6],C_fix(0));
t3=C_slot(((C_word*)t0)[6],C_fix(1));
t4=C_a_i_cons(&a,2,t2,t3);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13587,a[2]=((C_word*)t0)[5],a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1123: loop */
t6=((C_word*)((C_word*)t0)[7])[1];
f_13524(t6,t5,C_slot(((C_word*)t0)[4],C_fix(1)));}}

/* k13585 in k13563 in loop in chicken.base#alist-update in k12556 in k11433 */
static void C_ccall f_13587(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_13587,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.base#alist-ref in k12556 in k11433 */
static void C_ccall f_13619(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(10,c,4)))){
C_save_and_reclaim((void *)f_13619,c,av);}
a=C_alloc(10);
t4=C_rest_nullp(c,4);
t5=(C_truep(t4)?*((C_word*)lf[5]+1):C_get_rest_arg(c,4,av,4,t0));
t6=C_rest_nullp(c,4);
t7=C_rest_nullp(c,5);
t8=(C_truep(t7)?C_SCHEME_FALSE:C_get_rest_arg(c,5,av,4,t0));
t9=C_rest_nullp(c,5);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13635,a[2]=t1,a[3]=t8,a[4]=t2,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t11=C_eqp(*((C_word*)lf[4]+1),t5);
if(C_truep(t11)){
t12=t10;
f_13635(t12,*((C_word*)lf[56]+1));}
else{
t12=C_eqp(*((C_word*)lf[5]+1),t5);
if(C_truep(t12)){
t13=t10;
f_13635(t13,*((C_word*)lf[57]+1));}
else{
t13=C_eqp(*((C_word*)lf[6]+1),t5);
t14=t10;
f_13635(t14,(C_truep(t13)?*((C_word*)lf[58]+1):(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13660,a[2]=t5,a[3]=((C_word)li216),tmp=(C_word)a,a+=4,tmp)));}}}

/* k13633 in chicken.base#alist-ref in k12556 in k11433 */
static void f_13635(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,3)))){
C_save_and_reclaim_args((void *)trf_13635,2,t0,t1);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13638,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:1141: aq */
t3=t1;{
C_word av2[4];
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* k13636 in k13633 in chicken.base#alist-ref in k12556 in k11433 */
static void C_ccall f_13638(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13638,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=(C_truep(t1)?C_slot(t1,C_fix(1)):((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* f_13660 in chicken.base#alist-ref in k12556 in k11433 */
static void C_ccall f_13660(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_13660,c,av);}
a=C_alloc(8);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13666,a[2]=t5,a[3]=((C_word*)t0)[2],a[4]=t2,a[5]=((C_word)li215),tmp=(C_word)a,a+=6,tmp));
t7=((C_word*)t5)[1];
f_13666(t7,t1,t3);}

/* loop */
static void f_13666(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,4)))){
C_save_and_reclaim_args((void *)trf_13666,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_nullp(t2))){
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t2))){
t3=C_slot(t2,C_fix(0));
t4=C_i_check_pair_2(t3,lf[308]);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13691,a[2]=t1,a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* library.scm:1137: cmp */
t6=((C_word*)t0)[3];{
C_word av2[4];
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[4];
av2[3]=C_slot(t3,C_fix(0));
((C_proc)C_fast_retrieve_proc(t6))(4,av2);}}
else{
/* library.scm:1140: chicken.base#error */
t3=*((C_word*)lf[234]+1);{
C_word av2[5];
av2[0]=t3;
av2[1]=t1;
av2[2]=lf[308];
av2[3]=lf[309];
av2[4]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}}}

/* k13689 in loop */
static void C_ccall f_13691(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_13691,c,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* library.scm:1139: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_13666(t2,((C_word*)t0)[2],C_slot(((C_word*)t0)[5],C_fix(1)));}}

/* chicken.base#rassoc in k12556 in k11433 */
static void C_ccall f_13731(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +8,c,3)))){
C_save_and_reclaim((void*)f_13731,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+8);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t5=C_i_check_list_2(t3,lf[311]);
t6=C_i_pairp(t4);
t7=(C_truep(t6)?C_get_rest_arg(c,4,av,4,t0):*((C_word*)lf[5]+1));
t8=C_SCHEME_UNDEFINED;
t9=(*a=C_VECTOR_TYPE|1,a[1]=t8,tmp=(C_word)a,a+=2,tmp);
t10=C_set_block_item(t9,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13743,a[2]=t9,a[3]=t7,a[4]=t2,a[5]=((C_word)li218),tmp=(C_word)a,a+=6,tmp));
t11=((C_word*)t9)[1];
f_13743(t11,t1,t3);}

/* loop in chicken.base#rassoc in k12556 in k11433 */
static void f_13743(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_13743,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_pairp(t2))){
t3=C_slot(t2,C_fix(0));
t4=C_i_check_pair_2(t3,lf[311]);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13762,a[2]=t1,a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* library.scm:1154: tst */
t6=((C_word*)t0)[3];{
C_word av2[4];
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[4];
av2[3]=C_slot(t3,C_fix(1));
((C_proc)C_fast_retrieve_proc(t6))(4,av2);}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k13760 in loop in chicken.base#rassoc in k12556 in k11433 */
static void C_ccall f_13762(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_13762,c,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* library.scm:1156: loop */
t2=((C_word*)((C_word*)t0)[4])[1];
f_13743(t2,((C_word*)t0)[2],C_slot(((C_word*)t0)[5],C_fix(1)));}}

/* scheme#open-input-string in k12556 in k11433 */
static void C_ccall f_13779(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,5)))){
C_save_and_reclaim((void *)f_13779,c,av);}
a=C_alloc(4);
t3=C_i_check_string_2(t2,lf[313]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13786,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1167: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[314]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[314]+1);
av2[1]=t4;
av2[2]=C_fix(1);
av2[3]=C_fast_retrieve(lf[315]);
av2[4]=lf[316];
av2[5]=lf[317];
tp(6,av2);}}

/* k13784 in scheme#open-input-string in k12556 in k11433 */
static void C_ccall f_13786(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_13786,c,av);}
a=C_alloc(6);
t2=C_slot(((C_word*)t0)[2],C_fix(0));
t3=C_block_size(t2);
t4=C_fixnum_difference(t3,C_fix(1));
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13796,a[2]=t2,a[3]=t4,a[4]=t1,a[5]=((C_word*)t0)[3],tmp=(C_word)a,a+=6,tmp);
/* library.scm:1170: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[301]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[301]+1);
av2[1]=t5;
av2[2]=t4;
tp(3,av2);}}

/* k13794 in k13784 in scheme#open-input-string in k12556 in k11433 */
static void C_ccall f_13796(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13796,c,av);}
t2=C_copy_memory(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=C_i_set_i_slot(((C_word*)t0)[4],C_fix(10),C_fix(0));
t4=C_i_set_i_slot(((C_word*)t0)[4],C_fix(11),((C_word*)t0)[3]);
t5=C_i_setslot(((C_word*)t0)[4],C_fix(12),t1);
t6=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t6;
av2[1]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* scheme#open-output-string in k12556 in k11433 */
static void C_ccall f_13807(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,5)))){
C_save_and_reclaim((void *)f_13807,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13811,a[2]=C_SCHEME_UNDEFINED,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1179: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[314]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[314]+1);
av2[1]=t2;
av2[2]=C_fix(2);
av2[3]=C_fast_retrieve(lf[315]);
av2[4]=lf[319];
av2[5]=lf[317];
tp(6,av2);}}

/* k13809 in scheme#open-output-string in k12556 in k11433 */
static void C_ccall f_13811(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_13811,c,av);}
a=C_alloc(3);
t2=C_mutate(((C_word *)t0)+2,t1);
t3=C_i_set_i_slot(((C_word*)t0)[2],C_fix(10),C_fix(0));
t4=C_i_set_i_slot(((C_word*)t0)[2],C_fix(11),C_fix(256));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13824,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* library.scm:1182: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[301]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[301]+1);
av2[1]=t5;
av2[2]=C_fix(256);
tp(3,av2);}}

/* k13822 in k13809 in scheme#open-output-string in k12556 in k11433 */
static void C_ccall f_13824(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13824,c,av);}
t2=((C_word*)t0)[2];
t3=C_i_setslot(((C_word*)t2)[2],C_fix(12),t1);
t4=((C_word*)t2)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=((C_word*)t2)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#get-output-string in k12556 in k11433 */
static void C_ccall f_13826(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_13826,c,av);}
t3=C_i_check_port_2(t2,C_fix(2),C_SCHEME_FALSE,lf[321]);
t4=C_slot(t2,C_fix(7));
t5=C_eqp(lf[317],t4);
if(C_truep(C_i_not(t5))){
/* library.scm:1189: ##sys#signal-hook */
t6=*((C_word*)lf[235]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t6;
av2[1]=t1;
av2[2]=lf[295];
av2[3]=lf[321];
av2[4]=lf[322];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t6+1)))(6,av2);}}
else{
/* library.scm:1191: ##sys#buffer->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[300]+1));
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[300]+1);
av2[1]=t1;
av2[2]=C_slot(t2,C_fix(12));
av2[3]=C_fix(0);
av2[4]=C_slot(t2,C_fix(10));
tp(5,av2);}}}

/* scheme#open-input-bytevector in k12556 in k11433 */
static void C_ccall f_13860(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,5)))){
C_save_and_reclaim((void *)f_13860,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13864,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1195: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[314]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[314]+1);
av2[1]=t3;
av2[2]=C_fix(1);
av2[3]=C_SCHEME_FALSE;
av2[4]=lf[326];
av2[5]=lf[327];
tp(6,av2);}}

/* k13862 in scheme#open-input-bytevector in k12556 in k11433 */
static void C_ccall f_13864(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(40,c,6)))){
C_save_and_reclaim((void *)f_13864,c,av);}
a=C_alloc(40);
t2=C_i_check_bytevector_2(((C_word*)t0)[2],lf[324]);
t3=C_i_setslot(t1,C_fix(14),lf[167]);
t4=C_fix(0);
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_block_size(((C_word*)t0)[2]);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13882,a[2]=t5,a[3]=t6,a[4]=((C_word*)t0)[2],a[5]=((C_word)li223),tmp=(C_word)a,a+=6,tmp);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13895,a[2]=t5,a[3]=t6,a[4]=((C_word*)t0)[2],a[5]=((C_word)li224),tmp=(C_word)a,a+=6,tmp);
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13904,a[2]=t1,a[3]=((C_word)li225),tmp=(C_word)a,a+=4,tmp);
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13910,a[2]=t5,a[3]=t6,a[4]=((C_word)li226),tmp=(C_word)a,a+=5,tmp);
t11=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13920,a[2]=((C_word*)t0)[2],a[3]=t5,a[4]=t6,a[5]=((C_word)li227),tmp=(C_word)a,a+=6,tmp);
t12=C_a_i_vector(&a,10,t7,t8,C_SCHEME_FALSE,C_SCHEME_FALSE,t9,C_SCHEME_FALSE,t10,t11,C_SCHEME_FALSE,C_SCHEME_FALSE);
t13=C_i_setslot(t1,C_fix(2),t12);
t14=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t14;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t14+1)))(2,av2);}}

/* a13881 in k13862 in scheme#open-input-bytevector in k12556 in k11433 */
static void C_ccall f_13882(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13882,c,av);}
t3=C_eqp(((C_word*)((C_word*)t0)[2])[1],((C_word*)t0)[3]);
if(C_truep(t3)){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_END_OF_FILE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_i_bytevector_ref(((C_word*)t0)[4],((C_word*)((C_word*)t0)[2])[1]);
t5=C_mutate(((C_word *)((C_word*)t0)[2])+1,C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],C_fix(1)));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_make_character(C_unfix(t4));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* a13894 in k13862 in scheme#open-input-bytevector in k12556 in k11433 */
static void C_ccall f_13895(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13895,c,av);}
t3=C_eqp(((C_word*)((C_word*)t0)[2])[1],((C_word*)t0)[3]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=(C_truep(t3)?C_SCHEME_END_OF_FILE:C_i_bytevector_ref(((C_word*)t0)[4],((C_word*)((C_word*)t0)[2])[1]));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* a13903 in k13862 in scheme#open-input-bytevector in k12556 in k11433 */
static void C_ccall f_13904(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13904,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_set_i_slot(((C_word*)t0)[2],C_fix(8),C_SCHEME_TRUE);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* a13909 in k13862 in scheme#open-input-bytevector in k12556 in k11433 */
static void C_ccall f_13910(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13910,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_not(C_eqp(((C_word*)((C_word*)t0)[2])[1],((C_word*)t0)[3]));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* a13919 in k13862 in scheme#open-input-bytevector in k12556 in k11433 */
static void C_ccall f_13920(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,3)))){
C_save_and_reclaim((void *)f_13920,c,av);}
a=C_alloc(7);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_13924,a[2]=t4,a[3]=((C_word*)t0)[2],a[4]=t5,a[5]=((C_word*)t0)[3],a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* library.scm:1221: scheme#min */
t7=*((C_word*)lf[325]+1);{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
av2[2]=t3;
av2[3]=C_fixnum_difference(((C_word*)t0)[4],((C_word*)((C_word*)t0)[3])[1]);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k13922 in a13919 in k13862 in scheme#open-input-bytevector in k12556 in k11433 */
static void C_ccall f_13924(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13924,c,av);}
t2=C_copy_memory_with_offset(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)((C_word*)t0)[5])[1],t1);
t3=C_mutate(((C_word *)((C_word*)t0)[5])+1,C_fixnum_plus(((C_word*)((C_word*)t0)[5])[1],t1));
t4=((C_word*)t0)[6];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#open-output-bytevector in k12556 in k11433 */
static void C_ccall f_13928(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,5)))){
C_save_and_reclaim((void *)f_13928,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13932,a[2]=C_SCHEME_UNDEFINED,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1231: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[314]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[314]+1);
av2[1]=t2;
av2[2]=C_fix(2);
av2[3]=C_SCHEME_FALSE;
av2[4]=lf[329];
av2[5]=lf[327];
tp(6,av2);}}

/* k13930 in scheme#open-output-bytevector in k12556 in k11433 */
static void C_ccall f_13932(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_13932,c,av);}
a=C_alloc(3);
t2=C_mutate(((C_word *)t0)+2,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_13935,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* library.scm:1232: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[301]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[301]+1);
av2[1]=t3;
av2[2]=C_fix(256);
tp(3,av2);}}

/* k13933 in k13930 in scheme#open-output-bytevector in k12556 in k11433 */
static void C_ccall f_13935(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(42,c,6)))){
C_save_and_reclaim((void *)f_13935,c,av);}
a=C_alloc(42);
t2=((C_word*)t0)[2];
t3=t1;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_fix(0);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_fix(256);
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_SCHEME_UNDEFINED;
t10=(*a=C_VECTOR_TYPE|1,a[1]=t9,tmp=(C_word)a,a+=2,tmp);
t11=C_SCHEME_UNDEFINED;
t12=C_set_block_item(t10,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_13937,a[2]=t6,a[3]=t4,a[4]=t8,a[5]=((C_word)li229),tmp=(C_word)a,a+=6,tmp));
t13=t11=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13949,a[2]=t4,a[3]=t6,a[4]=((C_word)li230),tmp=(C_word)a,a+=5,tmp);
t14=C_i_setslot(((C_word*)t2)[2],C_fix(9),t11);
t15=C_i_setslot(((C_word*)t2)[2],C_fix(14),lf[167]);
t16=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13968,a[2]=t10,a[3]=((C_word)li231),tmp=(C_word)a,a+=4,tmp);
t17=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13985,a[2]=t10,a[3]=((C_word)li232),tmp=(C_word)a,a+=4,tmp);
t18=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_13991,a[2]=((C_word*)t2)[2],a[3]=((C_word)li233),tmp=(C_word)a,a+=4,tmp);
t19=C_a_i_vector(&a,10,C_SCHEME_FALSE,C_SCHEME_FALSE,t16,t17,t18,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE);
t20=C_i_setslot(((C_word*)t2)[2],C_fix(2),t19);
t21=((C_word*)t2)[3];{
C_word *av2=av;
av2[0]=t21;
av2[1]=((C_word*)t2)[2];
((C_proc)(void*)(*((C_word*)t21+1)))(2,av2);}}

/* add in k13933 in k13930 in scheme#open-output-bytevector in k12556 in k11433 */
static void f_13937(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(16,0,2)))){
C_save_and_reclaim_args((void *)trf_13937,5,t0,t1,t2,t3,t4);}
a=C_alloc(16);
t5=C_fixnum_difference(t4,t3);
t6=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],t5);
t7=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_13941,a[2]=((C_word*)t0)[3],a[3]=t2,a[4]=((C_word*)t0)[2],a[5]=t3,a[6]=t5,a[7]=t6,a[8]=t1,tmp=(C_word)a,a+=9,tmp);
if(C_truep(C_fixnum_greaterp(t6,((C_word*)((C_word*)t0)[4])[1]))){
t8=C_fixnum_times(((C_word*)((C_word*)t0)[4])[1],C_fix(2));
t9=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_13945,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[4],a[5]=t8,a[6]=t7,tmp=(C_word)a,a+=7,tmp);
/* library.scm:1240: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[301]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[301]+1);
av2[1]=t9;
av2[2]=t8;
tp(3,av2);}}
else{
t8=t7;
f_13941(t8,C_SCHEME_UNDEFINED);}}

/* k13939 in add in k13933 in k13930 in scheme#open-output-bytevector in k12556 in k11433 */
static void f_13941(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,1)))){
C_save_and_reclaim_args((void *)trf_13941,2,t0,t1);}
t2=C_copy_memory_with_offset(((C_word*)((C_word*)t0)[2])[1],((C_word*)t0)[3],((C_word*)((C_word*)t0)[4])[1],((C_word*)t0)[5],((C_word*)t0)[6]);
t3=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)t0)[7]);
t4=((C_word*)t0)[8];{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k13943 in add in k13933 in k13930 in scheme#open-output-bytevector in k12556 in k11433 */
static void C_ccall f_13945(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13945,c,av);}
t2=C_copy_memory_with_offset(t1,((C_word*)((C_word*)t0)[2])[1],C_fix(0),C_fix(0),((C_word*)((C_word*)t0)[3])[1]);
t3=C_mutate(((C_word *)((C_word*)t0)[4])+1,((C_word*)t0)[5]);
t4=C_mutate(((C_word *)((C_word*)t0)[2])+1,t1);
t5=((C_word*)t0)[6];
f_13941(t5,t4);}

/* getter in k13933 in k13930 in scheme#open-output-bytevector in k12556 in k11433 */
static void C_ccall f_13949(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_13949,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_13953,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1247: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[301]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[301]+1);
av2[1]=t2;
av2[2]=((C_word*)((C_word*)t0)[3])[1];
tp(3,av2);}}

/* k13951 in getter in k13933 in k13930 in scheme#open-output-bytevector in k12556 in k11433 */
static void C_ccall f_13953(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13953,c,av);}
t2=C_copy_memory_with_offset(t1,((C_word*)((C_word*)t0)[2])[1],C_fix(0),C_fix(0),((C_word*)((C_word*)t0)[3])[1]);
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* a13967 in k13933 in k13930 in scheme#open-output-bytevector in k12556 in k11433 */
static void C_ccall f_13968(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_13968,c,av);}
a=C_alloc(8);
t4=C_a_i_string(&a,1,t3);
t5=C_slot(t4,C_fix(0));
t6=C_block_size(t5);
/* library.scm:1260: add */
t7=((C_word*)((C_word*)t0)[2])[1];
f_13937(t7,t1,t5,C_fix(0),C_fixnum_difference(t6,C_fix(1)));}

/* a13984 in k13933 in k13930 in scheme#open-output-bytevector in k12556 in k11433 */
static void C_ccall f_13985(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_13985,c,av);}
/* library.scm:1262: add */
t6=((C_word*)((C_word*)t0)[2])[1];
f_13937(t6,t1,t3,t4,t5);}

/* a13990 in k13933 in k13930 in scheme#open-output-bytevector in k12556 in k11433 */
static void C_ccall f_13991(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_13991,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_set_i_slot(((C_word*)t0)[2],C_fix(8),C_SCHEME_TRUE);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#get-output-bytevector in k12556 in k11433 */
static void C_ccall f_13997(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_13997,c,av);}
a=C_alloc(9);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14000,a[2]=t2,a[3]=((C_word)li235),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_14007,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1275: ##sys#check-port */
t5=*((C_word*)lf[333]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[331];
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* fail in scheme#get-output-bytevector in k12556 in k11433 */
static void f_14000(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,4)))){
C_save_and_reclaim_args((void *)trf_14000,2,t0,t1);}
/* library.scm:1274: chicken.base#error */
t2=*((C_word*)lf[234]+1);{
C_word av2[5];
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[331];
av2[3]=lf[332];
av2[4]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* k14005 in scheme#get-output-bytevector in k12556 in k11433 */
static void C_ccall f_14007(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14007,c,av);}
t2=C_slot(((C_word*)t0)[2],C_fix(7));
t3=C_eqp(t2,lf[327]);
if(C_truep(t3)){
t4=C_slot(((C_word*)t0)[2],C_fix(9));
if(C_truep(C_i_closurep(t4))){
/* library.scm:1279: getter */
t5=t4;{
C_word *av2=av;
av2[0]=t5;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
/* library.scm:1280: fail */
t5=((C_word*)t0)[4];
f_14000(t5,((C_word*)t0)[3]);}}
else{
/* library.scm:1281: fail */
t4=((C_word*)t0)[4];
f_14000(t4,((C_word*)t0)[3]);}}

/* chicken.fixnum#fx+ in k12556 in k11433 */
static void C_ccall f_14044(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14044,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_plus(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx- in k12556 in k11433 */
static void C_ccall f_14047(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14047,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_difference(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx* in k12556 in k11433 */
static void C_ccall f_14050(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14050,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_times(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx= in k12556 in k11433 */
static void C_ccall f_14053(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14053,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_eqp(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx> in k12556 in k11433 */
static void C_ccall f_14059(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14059,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_greaterp(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx< in k12556 in k11433 */
static void C_ccall f_14062(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14062,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_lessp(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx>= in k12556 in k11433 */
static void C_ccall f_14065(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14065,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_greater_or_equal_p(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx<= in k12556 in k11433 */
static void C_ccall f_14068(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14068,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_less_or_equal_p(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxmin in k12556 in k11433 */
static void C_ccall f_14071(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14071,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_fixnum_min(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxmax in k12556 in k11433 */
static void C_ccall f_14074(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14074,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_fixnum_max(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxneg in k12556 in k11433 */
static void C_ccall f_14077(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14077,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_fixnum_negate(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.fixnum#fxand in k12556 in k11433 */
static void C_ccall f_14080(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14080,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_and(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxior in k12556 in k11433 */
static void C_ccall f_14083(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14083,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_or(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxxor in k12556 in k11433 */
static void C_ccall f_14086(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14086,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_xor(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxnot in k12556 in k11433 */
static void C_ccall f_14089(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14089,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_fixnum_not(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.fixnum#fxshl in k12556 in k11433 */
static void C_ccall f_14092(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14092,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_shift_left(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxshr in k12556 in k11433 */
static void C_ccall f_14095(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14095,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_shift_right(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxodd? in k12556 in k11433 */
static void C_ccall f_14098(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14098,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_fixnumoddp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.fixnum#fxeven? in k12556 in k11433 */
static void C_ccall f_14101(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14101,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_fixnumevenp(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.fixnum#fxlen in k12556 in k11433 */
static void C_ccall f_14104(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14104,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_fixnum_length(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.fixnum#fx/ in k12556 in k11433 */
static void C_ccall f_14107(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14107,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_divide(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxgcd in k12556 in k11433 */
static void C_ccall f_14110(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14110,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_fixnum_gcd(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxmod in k12556 in k11433 */
static void C_ccall f_14113(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14113,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fixnum_modulo(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fxrem in k12556 in k11433 */
static void C_ccall f_14116(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14116,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_fixnum_remainder_checked(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx+? in k12556 in k11433 */
static void C_ccall f_14119(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14119,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_o_fixnum_plus(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx-? in k12556 in k11433 */
static void C_ccall f_14122(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14122,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_o_fixnum_difference(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx*? in k12556 in k11433 */
static void C_ccall f_14125(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14125,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_o_fixnum_times(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.fixnum#fx/? in k12556 in k11433 */
static void C_ccall f_14128(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14128,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_o_fixnum_quotient(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#debug-mode? in k12556 in k11433 */
static void C_ccall f_14131(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14131,c,av);}
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_i_debug_modep();
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.base#warning in k12556 in k11433 */
static void C_ccall f_14136(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,5)))){
C_save_and_reclaim((void*)f_14136,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
if(C_truep(*((C_word*)lf[369]+1))){{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=0;
av2[1]=t1;
av2[2]=*((C_word*)lf[235]+1);
av2[3]=lf[372];
av2[4]=t2;
av2[5]=t3;
C_apply(6,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* chicken.base#notice in k12556 in k11433 */
static void C_ccall f_14145(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,5)))){
C_save_and_reclaim((void*)f_14145,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
t4=(C_truep(*((C_word*)lf[370]+1))?*((C_word*)lf[369]+1):C_SCHEME_FALSE);
if(C_truep(t4)){{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=0;
av2[1]=t1;
av2[2]=*((C_word*)lf[235]+1);
av2[3]=lf[374];
av2[4]=t2;
av2[5]=t3;
C_apply(6,av2);}}
else{
t5=C_SCHEME_UNDEFINED;
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* chicken.base#enable-warnings in k12556 in k11433 */
static void C_ccall f_14157(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14157,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+0);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
if(C_truep(C_i_pairp(t2))){
t3=C_mutate((C_word*)lf[369]+1 /* (set! ##sys#warnings-enabled ...) */,C_get_rest_arg(c,2,av,2,t0));
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=*((C_word*)lf[369]+1);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=*((C_word*)lf[369]+1);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* ##sys#error/errno in k12556 in k11433 */
static void C_ccall f_14171(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,6)))){
C_save_and_reclaim((void*)f_14171,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
if(C_truep(C_i_pairp(t3))){{
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_fast_retrieve(lf[379]);
av2[3]=lf[236];
av2[4]=t2;
av2[5]=C_SCHEME_FALSE;
av2[6]=t3;
C_apply(7,av2);}}
else{
/* library.scm:1366: ##sys#signal-hook/errno */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[379]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[379]+1);
av2[1]=t1;
av2[2]=lf[236];
av2[3]=t2;
av2[4]=C_SCHEME_FALSE;
tp(5,av2);}}}

/* ##sys#setslot in k12556 in k11433 */
static void C_ccall f_14187(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14187,c,av);}
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_i_setslot(t2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#setislot in k12556 in k11433 */
static void C_ccall f_14190(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14190,c,av);}
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_i_set_i_slot(t2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#start-timer in k12556 in k11433 */
static void C_ccall f_14199(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_14199,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14203,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:1381: ##sys#gc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[380]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[380]+1);
av2[1]=t2;
av2[2]=C_SCHEME_TRUE;
tp(3,av2);}}

/* k14201 in ##sys#start-timer in k12556 in k11433 */
static void C_ccall f_14203(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14203,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_start_timer();
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* ##sys#stop-timer in k12556 in k11433 */
static void C_ccall f_14205(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_14205,c,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_stop_timer,a[2]=((C_word)li280),tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14209,a[2]=C_SCHEME_UNDEFINED,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1385: g1513 */
t4=t2;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)C_fast_retrieve_proc(t4))(2,av2);}}

/* k14207 in ##sys#stop-timer in k12556 in k11433 */
static void C_ccall f_14209(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_14209,c,av);}
a=C_alloc(3);
t2=C_mutate(((C_word *)t0)+2,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14212,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* library.scm:1388: ##sys#gc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[380]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[380]+1);
av2[1]=t3;
av2[2]=C_SCHEME_TRUE;
tp(3,av2);}}

/* k14210 in k14207 in ##sys#stop-timer in k12556 in k11433 */
static void C_ccall f_14212(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_14212,c,av);}
a=C_alloc(6);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_stop_timer,a[2]=((C_word)li281),tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_14223,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* library.scm:1389: g1515 */
t5=t3;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)C_fast_retrieve_proc(t5))(2,av2);}}

/* k14221 in k14210 in k14207 in ##sys#stop-timer in k12556 in k11433 */
static void C_ccall f_14223(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14223,c,av);}
t2=((C_word*)t0)[2];
t3=C_slot(t1,C_fix(6));
t4=C_i_setslot(((C_word*)t2)[2],C_fix(6),t3);
t5=((C_word*)t2)[3];{
C_word *av2=av;
av2[0]=t5;
av2[1]=((C_word*)t2)[2];
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#immediate? in k12556 in k11433 */
static void C_ccall f_14225(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14225,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_not(C_blockp(t2));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#message in k12556 in k11433 */
static void C_ccall f_14232(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14232,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_message(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#byte in k12556 in k11433 */
static void C_ccall f_14235(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14235,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_subbyte(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#halt in k12556 in k11433 */
static void C_ccall f_14240(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14240,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_halt(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#block-ref in k12556 in k11433 */
static void C_ccall f_14244(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14244,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_block_ref(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#block-set! in k12556 in k11433 */
static void C_ccall f_14249(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_14249,c,av);}
a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_14253,a[2]=t2,a[3]=t3,a[4]=t1,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=C_i_not(C_blockp(t2));
if(C_truep(t6)){
if(C_truep(t6)){
/* library.scm:1407: ##sys#signal-hook */
t7=*((C_word*)lf[235]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t7;
av2[1]=t5;
av2[2]=lf[295];
av2[3]=lf[400];
av2[4]=lf[401];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t7+1)))(6,av2);}}
else{
t7=t5;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_SCHEME_UNDEFINED;
f_14253(2,av2);}}}
else{
t7=(C_truep(C_specialp(t2))?C_eqp(t3,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t7)){
if(C_truep(t7)){
/* library.scm:1407: ##sys#signal-hook */
t8=*((C_word*)lf[235]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t8;
av2[1]=t5;
av2[2]=lf[295];
av2[3]=lf[400];
av2[4]=lf[401];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t8+1)))(6,av2);}}
else{
t8=t5;{
C_word *av2=av;
av2[0]=t8;
av2[1]=C_SCHEME_UNDEFINED;
f_14253(2,av2);}}}
else{
if(C_truep(C_byteblockp(t2))){
/* library.scm:1407: ##sys#signal-hook */
t8=*((C_word*)lf[235]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t8;
av2[1]=t5;
av2[2]=lf[295];
av2[3]=lf[400];
av2[4]=lf[401];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t8+1)))(6,av2);}}
else{
t8=t5;{
C_word *av2=av;
av2[0]=t8;
av2[1]=C_SCHEME_UNDEFINED;
f_14253(2,av2);}}}}}

/* k14251 in ##sys#block-set! in k12556 in k11433 */
static void C_ccall f_14253(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_14253,c,av);}
t2=C_block_size(((C_word*)t0)[2]);
t3=C_i_check_range_2(((C_word*)t0)[3],C_fix(0),t2,lf[400]);
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_setslot(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[5]);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.time#current-process-milliseconds in k12556 in k11433 */
static void C_ccall f_14284(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,1)))){
C_save_and_reclaim((void *)f_14284,c,av);}
a=C_alloc(7);
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_current_process_milliseconds(&a,1,C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.time#current-seconds in k12556 in k11433 */
static void C_ccall f_14287(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,1)))){
C_save_and_reclaim((void *)f_14287,c,av);}
a=C_alloc(7);
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_get_current_seconds(&a,1,C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.time#cpu-time in k12556 in k11433 */
static void C_ccall f_14290(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(11,c,3)))){
C_save_and_reclaim((void *)f_14290,c,av);}
a=C_alloc(11);
t2=C_a_i_vector2(&a,2,C_SCHEME_FALSE,C_SCHEME_FALSE);
t3=C_a_i_cpu_time(&a,1,t2);
/* library.scm:1436: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_slot(t2,C_fix(0));
av2[3]=C_slot(t2,C_fix(1));
C_values(4,av2);}}

/* ##sys#check-structure in k12556 in k11433 */
static void C_ccall f_14307(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14307,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+0);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=C_i_pairp(t4);
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=(C_truep(t5)?C_i_check_structure_2(t2,t3,C_get_rest_arg(c,4,av,4,t0)):C_i_check_structure(t2,t3));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* ##sys#check-blob in k12556 in k11433 */
static void C_ccall f_14318(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14318,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_bytevector_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_bytevector(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-pair in k12556 in k11433 */
static void C_ccall f_14329(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14329,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_pair_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_pair(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-list in k12556 in k11433 */
static void C_ccall f_14340(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14340,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_list_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_list(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-string in k12556 in k11433 */
static void C_ccall f_14351(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14351,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_string_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_string(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-number in k12556 in k11433 */
static void C_ccall f_14362(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14362,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_number_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_number(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-fixnum in k12556 in k11433 */
static void C_ccall f_14373(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14373,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_fixnum_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_fixnum(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-bytevector in k12556 in k11433 */
static void C_ccall f_14384(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14384,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_bytevector_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_bytevector(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-exact in k12556 in k11433 */
static void C_ccall f_14395(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14395,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_exact_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_exact(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-inexact in k12556 in k11433 */
static void C_ccall f_14406(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14406,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_inexact_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_inexact(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-symbol in k12556 in k11433 */
static void C_ccall f_14417(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14417,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_symbol_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_symbol(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-keyword in k12556 in k11433 */
static void C_ccall f_14428(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14428,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_keyword_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_keyword(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-vector in k12556 in k11433 */
static void C_ccall f_14439(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14439,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_vector_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_vector(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-char in k12556 in k11433 */
static void C_ccall f_14450(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14450,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_char_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_char(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-boolean in k12556 in k11433 */
static void C_ccall f_14461(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14461,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_boolean_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_boolean(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-locative in k12556 in k11433 */
static void C_ccall f_14472(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14472,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_locative_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_locative(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#check-integer in k12556 in k11433 */
static void C_ccall f_14483(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,3)))){
C_save_and_reclaim((void*)f_14483,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
if(C_truep(C_i_integerp(t2))){
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t3))){
/* library.scm:1525: ##sys#error-bad-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[423]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[423]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_get_rest_arg(c,3,av,3,t0);
tp(4,av2);}}
else{
/* library.scm:1525: ##sys#error-bad-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[423]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[423]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}}}

/* ##sys#check-exact-integer in k12556 in k11433 */
static void C_ccall f_14500(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,3)))){
C_save_and_reclaim((void*)f_14500,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
if(C_truep(C_i_exact_integerp(t2))){
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t3))){
/* library.scm:1529: ##sys#error-bad-exact-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[425]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[425]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_get_rest_arg(c,3,av,3,t0);
tp(4,av2);}}
else{
/* library.scm:1529: ##sys#error-bad-exact-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[425]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[425]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}}}

/* ##sys#check-exact-uinteger in k12556 in k11433 */
static void C_ccall f_14517(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,3)))){
C_save_and_reclaim((void*)f_14517,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
t4=C_i_not(C_i_exact_integerp(t2));
t5=(C_truep(t4)?t4:C_i_integer_negativep(t2));
if(C_truep(t5)){
if(C_truep(C_i_pairp(t3))){
/* library.scm:1534: ##sys#error-bad-exact-uinteger */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[427]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[427]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_get_rest_arg(c,3,av,3,t0);
tp(4,av2);}}
else{
/* library.scm:1534: ##sys#error-bad-exact-uinteger */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[427]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[427]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}}
else{
t6=C_SCHEME_UNDEFINED;
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* ##sys#check-real in k12556 in k11433 */
static void C_ccall f_14541(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,3)))){
C_save_and_reclaim((void*)f_14541,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
if(C_truep(C_i_realp(t2))){
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t3))){
/* library.scm:1538: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[429]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[429]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_get_rest_arg(c,3,av,3,t0);
tp(4,av2);}}
else{
/* library.scm:1538: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[429]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[429]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}}}

/* ##sys#check-range in k12556 in k11433 */
static void C_ccall f_14558(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-5)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14558,c,av);}
a=C_alloc((c-5)*C_SIZEOF_PAIR+0);
t5=C_build_rest(&a,c,5,av);
C_word t6;
C_word t7;
t6=C_i_pairp(t5);
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=(C_truep(t6)?C_i_check_range_2(t2,t3,t4,C_get_rest_arg(c,5,av,5,t0)):C_i_check_range(t2,t3,t4));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* ##sys#check-range/including in k12556 in k11433 */
static void C_ccall f_14569(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-5)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14569,c,av);}
a=C_alloc((c-5)*C_SIZEOF_PAIR+0);
t5=C_build_rest(&a,c,5,av);
C_word t6;
C_word t7;
t6=C_i_pairp(t5);
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=(C_truep(t6)?C_i_check_range_including_2(t2,t3,t4,C_get_rest_arg(c,5,av,5,t0)):C_i_check_range_including(t2,t3,t4));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* ##sys#check-special in k12556 in k11433 */
static void C_ccall f_14580(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,5)))){
C_save_and_reclaim((void*)f_14580,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
t4=(C_truep(C_blockp(t2))?C_specialp(t2):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=C_SCHEME_UNDEFINED;
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t3))){
/* library.scm:1552: ##sys#signal-hook */
t5=*((C_word*)lf[235]+1);{
C_word av2[6];
av2[0]=t5;
av2[1]=t1;
av2[2]=lf[295];
av2[3]=C_get_rest_arg(c,3,av,3,t0);
av2[4]=lf[433];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(6,av2);}}
else{
/* library.scm:1552: ##sys#signal-hook */
t5=*((C_word*)lf[235]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=lf[295];
av2[3]=C_SCHEME_FALSE;
av2[4]=lf[433];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(6,av2);}}}}

/* ##sys#check-closure in k12556 in k11433 */
static void C_ccall f_14600(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +0,c,1)))){
C_save_and_reclaim((void*)f_14600,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+0);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=C_i_pairp(t3);
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=(C_truep(t4)?C_i_check_closure_2(t2,C_get_rest_arg(c,3,av,3,t0)):C_i_check_closure(t2));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#force in k12556 in k11433 */
static void C_ccall f_14611(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_14611,c,av);}
a=C_alloc(6);
if(C_truep(C_i_structurep(t2,lf[250]))){
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14623,a[2]=t4,a[3]=((C_word)li319),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_14623(t6,t1,t2,C_SCHEME_FALSE);}
else{
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* lp in scheme#force in k12556 in k11433 */
static void f_14623(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_14623,4,t0,t1,t2,t3);}
a=C_alloc(6);
t4=C_slot(t2,C_fix(1));
if(C_truep(C_i_nullp(t4))){
/* library.scm:1565: ##sys#values */{
C_word av2[2];
av2[0]=0;
av2[1]=t1;
C_values(2,av2);}}
else{
if(C_truep(C_i_pairp(t4))){{
C_word av2[3];
av2[0]=0;
av2[1]=t1;
av2[2]=t4;
C_apply_values(3,av2);}}
else{
if(C_truep(C_i_closurep(t4))){
t5=(C_truep(t3)?C_i_setslot(t3,C_fix(1),t2):C_SCHEME_UNDEFINED);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_14657,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* library.scm:1569: ##sys#call-with-values */{
C_word av2[4];
av2[0]=0;
av2[1]=t6;
av2[2]=t4;
av2[3]=*((C_word*)lf[436]+1);
C_call_with_values(4,av2);}}
else{
if(C_truep(C_i_structurep(t4,lf[250]))){
/* library.scm:1581: lp */
t8=t1;
t9=t4;
t10=t3;
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}}}}

/* k14655 in lp in scheme#force in k12556 in k11433 */
static void C_ccall f_14657(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_14657,c,av);}
a=C_alloc(6);
t2=C_slot(((C_word*)t0)[2],C_fix(1));
t3=C_i_closurep(t2);
if(C_truep(C_i_not(t3))){
/* library.scm:1571: lp */
t4=((C_word*)((C_word*)t0)[3])[1];
f_14623(t4,((C_word*)t0)[4],((C_word*)t0)[2],((C_word*)t0)[5]);}
else{
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_14672,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t5=C_i_nullp(t1);
if(C_truep(C_i_not(t5))){
t6=C_i_cdr(t1);
t7=C_i_nullp(t6);
t8=t4;
f_14672(t8,(C_truep(t7)?C_i_structurep(C_slot(t1,C_fix(0)),lf[250]):C_SCHEME_FALSE));}
else{
t6=t4;
f_14672(t6,C_SCHEME_FALSE);}}}

/* k14670 in k14655 in lp in scheme#force in k12556 in k11433 */
static void f_14672(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,3)))){
C_save_and_reclaim_args((void *)trf_14672,2,t0,t1);}
if(C_truep(t1)){
t2=C_slot(((C_word*)t0)[2],C_fix(0));
t3=C_slot(t2,C_fix(1));
t4=C_i_setslot(((C_word*)t0)[3],C_fix(1),t3);
/* library.scm:1576: lp */
t5=((C_word*)((C_word*)t0)[4])[1];
f_14623(t5,((C_word*)t0)[5],((C_word*)t0)[3],t2);}
else{
t2=C_i_setslot(((C_word*)t0)[3],C_fix(1),((C_word*)t0)[2]);{
C_word av2[3];
av2[0]=0;
av2[1]=((C_word*)t0)[5];
av2[2]=((C_word*)t0)[2];
C_apply_values(3,av2);}}}

/* ##sys#error-not-a-proper-list in k12556 in k11433 */
static void C_ccall f_14739(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_14739,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_NOT_A_PROPER_LIST_ERROR);
/* library.scm:1591: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word av2[5];
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_NOT_A_PROPER_LIST_ERROR);
/* library.scm:1591: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word av2[5];
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-number in k12556 in k11433 */
static void C_ccall f_14755(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_14755,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_NUMBER_ERROR);
/* library.scm:1595: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word av2[5];
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_NUMBER_ERROR);
/* library.scm:1595: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word av2[5];
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-integer in k12556 in k11433 */
static void C_ccall f_14771(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_14771,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_INTEGER_ERROR);
/* library.scm:1599: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word av2[5];
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_INTEGER_ERROR);
/* library.scm:1599: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word av2[5];
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-exact-integer in k12556 in k11433 */
static void C_ccall f_14787(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_14787,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_INTEGER_ERROR);
/* library.scm:1603: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word av2[5];
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_INTEGER_ERROR);
/* library.scm:1603: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word av2[5];
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-exact-uinteger in k12556 in k11433 */
static void C_ccall f_14803(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_14803,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_UINTEGER_ERROR);
/* library.scm:1607: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word av2[5];
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_UINTEGER_ERROR);
/* library.scm:1607: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word av2[5];
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-inexact in k12556 in k11433 */
static void C_ccall f_14819(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_14819,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_CANT_REPRESENT_INEXACT_ERROR);
/* library.scm:1611: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word av2[5];
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_CANT_REPRESENT_INEXACT_ERROR);
/* library.scm:1611: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word av2[5];
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-real in k12556 in k11433 */
static void C_ccall f_14835(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_14835,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_REAL_ERROR);
/* library.scm:1615: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word av2[5];
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_REAL_ERROR);
/* library.scm:1615: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word av2[5];
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* ##sys#error-bad-base in k12556 in k11433 */
static void C_ccall f_14851(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_14851,c,av);}
if(C_truep(C_rest_nullp(c,3))){
t3=C_fix((C_word)C_BAD_ARGUMENT_TYPE_BAD_BASE_ERROR);
/* library.scm:1619: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word av2[5];
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=C_SCHEME_FALSE;
av2[4]=t2;
tp(5,av2);}}
else{
t3=C_get_rest_arg(c,3,av,3,t0);
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_BAD_BASE_ERROR);
/* library.scm:1619: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word av2[5];
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t3;
av2[4]=t2;
tp(5,av2);}}}

/* scheme#append in k12556 in k11433 */
static void C_ccall f_14867(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +6,c,3)))){
C_save_and_reclaim((void*)f_14867,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+6);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
t3=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t3)){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14879,a[2]=t5,a[3]=((C_word)li332),tmp=(C_word)a,a+=4,tmp));
t7=((C_word*)t5)[1];
f_14879(t7,t1,t2);}}

/* loop in scheme#append in k12556 in k11433 */
static void f_14879(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,3)))){
C_save_and_reclaim_args((void *)trf_14879,3,t0,t1,t2);}
a=C_alloc(8);
t3=C_slot(t2,C_fix(1));
t4=C_eqp(t3,C_SCHEME_END_OF_LIST);
if(C_truep(t4)){
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=C_slot(t2,C_fix(0));
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t5=C_slot(t2,C_fix(0));
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_14898,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t7,a[5]=((C_word)li331),tmp=(C_word)a,a+=6,tmp));
t9=((C_word*)t7)[1];
f_14898(t9,t1,t5);}}

/* copy in loop in scheme#append in k12556 in k11433 */
static void f_14898(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(4,0,3)))){
C_save_and_reclaim_args((void *)trf_14898,3,t0,t1,t2);}
a=C_alloc(4);
t3=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t3)){
/* library.scm:1630: loop */
t4=((C_word*)((C_word*)t0)[2])[1];
f_14879(t4,t1,C_slot(((C_word*)t0)[3],C_fix(1)));}
else{
if(C_truep(C_i_pairp(t2))){
t4=C_slot(t2,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14929,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1632: copy */
t7=t5;
t8=C_slot(t2,C_fix(1));
t1=t7;
t2=t8;
goto loop;}
else{
/* library.scm:1634: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[51]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[51]+1);
av2[1]=t1;
av2[2]=C_slot(((C_word*)t0)[3],C_fix(0));
av2[3]=lf[444];
tp(4,av2);}}}}

/* k14927 in copy in loop in scheme#append in k12556 in k11433 */
static void C_ccall f_14929(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_14929,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* ##sys#fast-reverse in k12556 in k11433 */
static void C_ccall f_14946(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_14946,c,av);}
a=C_alloc(6);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_14952,a[2]=t4,a[3]=((C_word)li334),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_14952(t6,t1,t2,C_SCHEME_END_OF_LIST);}

/* loop in ##sys#fast-reverse in k12556 in k11433 */
static void f_14952(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(3,0,3)))){
C_save_and_reclaim_args((void *)trf_14952,4,t0,t1,t2,t3);}
a=C_alloc(3);
if(C_truep(C_i_pairp(t2))){
t4=C_slot(t2,C_fix(1));
t5=C_slot(t2,C_fix(0));
t6=C_a_i_cons(&a,2,t5,t3);
/* library.scm:1640: loop */
t8=t1;
t9=t4;
t10=t6;
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* ##sys#make-bytevector in k12556 in k11433 */
static void C_ccall f_14976(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_14976,c,av);}
if(C_truep(C_rest_nullp(c,3))){
/* library.scm:1647: ##sys#allocate-bytevector */
t3=*((C_word*)lf[384]+1);{
C_word av2[4];
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}
else{
/* library.scm:1647: ##sys#allocate-bytevector */
t3=*((C_word*)lf[384]+1);{
C_word av2[4];
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
av2[3]=C_get_rest_arg(c,3,av,3,t0);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}}

/* ##sys#make-string in k12556 in k11433 */
static void C_ccall f_14991(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_14991,c,av);}
a=C_alloc(5);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_make_character(32):C_get_rest_arg(c,3,av,3,t0));
t5=C_utf_bytes(t4);
t6=C_fixnum_times(t5,t2);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15001,a[2]=t4,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1652: ##sys#allocate-bytevector */
t8=*((C_word*)lf[384]+1);{
C_word av2[4];
av2[0]=t8;
av2[1]=t7;
av2[2]=C_fixnum_plus(t6,C_fix(1));
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}

/* k14999 in ##sys#make-string in k12556 in k11433 */
static void C_ccall f_15001(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_15001,c,av);}
a=C_alloc(5);
t2=C_utf_fill(t1,((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_ustring(&a,2,t1,((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#buffer->string in k12556 in k11433 */
static void C_ccall f_15013(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_15013,c,av);}
a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15017,a[2]=t2,a[3]=t3,a[4]=t4,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* library.scm:1657: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[301]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[301]+1);
av2[1]=t5;
av2[2]=C_fixnum_plus(t4,C_fix(1));
tp(3,av2);}}

/* k15015 in ##sys#buffer->string in k12556 in k11433 */
static void C_ccall f_15017(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_15017,c,av);}
a=C_alloc(5);
t2=C_copy_memory_with_offset(t1,((C_word*)t0)[2],C_fix(0),((C_word*)t0)[3],((C_word*)t0)[4]);
t3=C_utf_range_length(t1,C_fix(0),((C_word*)t0)[4]);
t4=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_ustring(&a,2,t1,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#utf-decoder in k12556 in k11433 */
static void C_ccall f_15024(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_15024,c,av);}
/* library.scm:1663: k */
t6=t5;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=t4;
((C_proc)C_fast_retrieve_proc(t6))(5,av2);}}

/* ##sys#utf-encoder in k12556 in k11433 */
static void C_ccall f_15030(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_15030,c,av);}
/* library.scm:1666: k */
t6=t5;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=t4;
((C_proc)C_fast_retrieve_proc(t6))(5,av2);}}

/* ##sys#utf-scanner in k12556 in k11433 */
static void C_ccall f_15036(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_15036,c,av);}
if(C_truep(t2)){
t4=C_fixnum_greaterp(t2,C_fix(1));
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=(C_truep(t4)?C_fixnum_difference(t2,C_fix(1)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t4=C_utf_bytes_needed(t3);
t5=C_eqp(t4,C_fix(1));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(C_truep(t5)?C_SCHEME_FALSE:C_fixnum_difference(t4,C_fix(1)));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* ##sys#latin-decoder in k12556 in k11433 */
static void C_ccall f_15060(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_15060,c,av);}
a=C_alloc(7);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15064,a[2]=t5,a[3]=t1,a[4]=t2,a[5]=t3,a[6]=t4,tmp=(C_word)a,a+=7,tmp);
/* library.scm:1679: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[301]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[301]+1);
av2[1]=t6;
av2[2]=C_fixnum_times(t4,C_fix(2));
tp(3,av2);}}

/* k15062 in ##sys#latin-decoder in k12556 in k11433 */
static void C_ccall f_15064(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_15064,c,av);}
/* library.scm:1681: k */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
av2[3]=C_fix(0);
av2[4]=C_latin_to_utf(((C_word*)t0)[4],t1,((C_word*)t0)[5],((C_word*)t0)[6]);
((C_proc)C_fast_retrieve_proc(t2))(5,av2);}}

/* ##sys#latin-encoder in k12556 in k11433 */
static void C_ccall f_15073(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_15073,c,av);}
a=C_alloc(7);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15077,a[2]=t5,a[3]=t1,a[4]=t2,a[5]=t3,a[6]=t4,tmp=(C_word)a,a+=7,tmp);
/* library.scm:1684: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[301]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[301]+1);
av2[1]=t6;
av2[2]=C_fixnum_plus(t4,C_fix(1));
tp(3,av2);}}

/* k15075 in ##sys#latin-encoder in k12556 in k11433 */
static void C_ccall f_15077(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_15077,c,av);}
/* library.scm:1686: k */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
av2[3]=C_fix(0);
av2[4]=C_utf_to_latin(((C_word*)t0)[4],t1,((C_word*)t0)[5],((C_word*)t0)[6]);
((C_proc)C_fast_retrieve_proc(t2))(5,av2);}}

/* ##sys#latin-scanner in k12556 in k11433 */
static void C_ccall f_15086(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_15086,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#binary-decoder in k12556 in k11433 */
static void C_ccall f_15089(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_15089,c,av);}
/* library.scm:1691: k */
t6=t5;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=t4;
((C_proc)C_fast_retrieve_proc(t6))(5,av2);}}

/* ##sys#binary-encoder in k12556 in k11433 */
static void C_ccall f_15095(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_15095,c,av);}
/* library.scm:1694: k */
t6=t5;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
av2[4]=t4;
((C_proc)C_fast_retrieve_proc(t6))(5,av2);}}

/* ##sys#binary-scanner in k12556 in k11433 */
static void C_ccall f_15101(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_15101,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#encoding-hook in k12556 in k11433 */
static void C_ccall f_15104(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_15104,c,av);}
t4=C_eqp(t2,lf[167]);
if(C_truep(t4)){
/* library.scm:1701: k */
t5=t3;{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=*((C_word*)lf[453]+1);
av2[3]=*((C_word*)lf[454]+1);
av2[4]=*((C_word*)lf[455]+1);
((C_proc)C_fast_retrieve_proc(t5))(5,av2);}}
else{
t5=C_eqp(t2,lf[457]);
if(C_truep(t5)){
/* library.scm:1702: k */
t6=t3;{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t6;
av2[1]=t1;
av2[2]=*((C_word*)lf[447]+1);
av2[3]=*((C_word*)lf[448]+1);
av2[4]=*((C_word*)lf[449]+1);
((C_proc)C_fast_retrieve_proc(t6))(5,av2);}}
else{
t6=C_eqp(t2,lf[458]);
if(C_truep(t6)){
/* library.scm:1703: k */
t7=t3;{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t7;
av2[1]=t1;
av2[2]=*((C_word*)lf[450]+1);
av2[3]=*((C_word*)lf[451]+1);
av2[4]=*((C_word*)lf[452]+1);
((C_proc)C_fast_retrieve_proc(t7))(5,av2);}}
else{
/* library.scm:1704: ##sys#signal-hook */
t7=*((C_word*)lf[235]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t7;
av2[1]=t1;
av2[2]=lf[295];
av2[3]=C_SCHEME_FALSE;
av2[4]=lf[459];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t7+1)))(6,av2);}}}}}

/* ##sys#register-encoding in k12556 in k11433 */
static void C_ccall f_15143(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_15143,c,av);}
a=C_alloc(7);
t6=*((C_word*)lf[456]+1);
t7=C_mutate((C_word*)lf[456]+1 /* (set! ##sys#encoding-hook ...) */,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15146,a[2]=t2,a[3]=t3,a[4]=t5,a[5]=t6,a[6]=((C_word)li349),tmp=(C_word)a,a+=7,tmp));
t8=t1;{
C_word *av2=av;
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}

/* ##sys#encoding-hook in ##sys#register-encoding in k12556 in k11433 */
static void C_ccall f_15146(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,2)))){
C_save_and_reclaim((void *)f_15146,c,av);}
a=C_alloc(8);
t4=C_eqp(t2,((C_word*)t0)[2]);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_15156,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=t2,a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],tmp=(C_word)a,a+=8,tmp);
if(C_truep(t4)){
t6=t5;
f_15156(t6,t4);}
else{
t6=C_i_pairp(((C_word*)t0)[2]);
t7=t5;
f_15156(t7,(C_truep(t6)?C_i_memq(t2,((C_word*)t0)[2]):C_SCHEME_FALSE));}}

/* k15154 in ##sys#encoding-hook in ##sys#register-encoding in k12556 in k11433 */
static void f_15156(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,4)))){
C_save_and_reclaim_args((void *)trf_15156,2,t0,t1);}
if(C_truep(t1)){
/* library.scm:1712: k */
t2=((C_word*)t0)[2];{
C_word av2[5];
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
av2[4]=((C_word*)t0)[6];
((C_proc)C_fast_retrieve_proc(t2))(5,av2);}}
else{
/* library.scm:1713: old */
t2=((C_word*)t0)[7];{
C_word av2[4];
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[5];
av2[3]=((C_word*)t0)[2];
((C_proc)C_fast_retrieve_proc(t2))(4,av2);}}}

/* ##sys#buffer->string/encoding in k12556 in k11433 */
static void C_ccall f_15173(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_15173,c,av);}
a=C_alloc(6);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15179,a[2]=t2,a[3]=t3,a[4]=t4,a[5]=((C_word)li351),tmp=(C_word)a,a+=6,tmp);
/* library.scm:1717: ##sys#encoding-hook */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[456]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[456]+1);
av2[1]=t1;
av2[2]=t5;
av2[3]=t6;
tp(4,av2);}}

/* a15178 in ##sys#buffer->string/encoding in k12556 in k11433 */
static void C_ccall f_15179(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_15179,c,av);}
/* library.scm:1719: decoder */
t5=t2;{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=((C_word*)t0)[3];
av2[4]=((C_word*)t0)[4];
av2[5]=*((C_word*)lf[300]+1);
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* ##sys#encode-buffer in k12556 in k11433 */
static void C_ccall f_15185(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6=av[6];
C_word t7;
C_word t8;
C_word *a;
if(c!=7) C_bad_argc_2(c,7,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,5)))){
C_save_and_reclaim((void *)f_15185,c,av);}
a=C_alloc(7);
t7=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15191,a[2]=t2,a[3]=t3,a[4]=t4,a[5]=t6,a[6]=((C_word)li353),tmp=(C_word)a,a+=7,tmp);
/* library.scm:1723: ##sys#encoding-hook */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[456]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[456]+1);
av2[1]=t1;
av2[2]=t5;
av2[3]=t7;
tp(4,av2);}}

/* a15190 in ##sys#encode-buffer in k12556 in k11433 */
static void C_ccall f_15191(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_15191,c,av);}
/* library.scm:1725: encoder */
t5=t3;{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=((C_word*)t0)[3];
av2[4]=((C_word*)t0)[4];
av2[5]=((C_word*)t0)[5];
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* ##sys#decode-buffer in k12556 in k11433 */
static void C_ccall f_15197(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6=av[6];
C_word t7;
C_word t8;
C_word *a;
if(c!=7) C_bad_argc_2(c,7,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,5)))){
C_save_and_reclaim((void *)f_15197,c,av);}
a=C_alloc(7);
t7=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15203,a[2]=t2,a[3]=t3,a[4]=t4,a[5]=t6,a[6]=((C_word)li355),tmp=(C_word)a,a+=7,tmp);
/* library.scm:1729: ##sys#encoding-hook */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[456]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[456]+1);
av2[1]=t1;
av2[2]=t5;
av2[3]=t7;
tp(4,av2);}}

/* a15202 in ##sys#decode-buffer in k12556 in k11433 */
static void C_ccall f_15203(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_15203,c,av);}
/* library.scm:1731: decoder */
t5=t2;{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=((C_word*)t0)[3];
av2[4]=((C_word*)t0)[4];
av2[5]=((C_word*)t0)[5];
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* ##sys#encode-char in k12556 in k11433 */
static void C_ccall f_15209(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_15209,c,av);}
a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15215,a[2]=t2,a[3]=t3,a[4]=((C_word)li358),tmp=(C_word)a,a+=5,tmp);
/* library.scm:1735: ##sys#encoding-hook */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[456]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[456]+1);
av2[1]=t1;
av2[2]=t4;
av2[3]=t5;
tp(4,av2);}}

/* a15214 in ##sys#encode-char in k12556 in k11433 */
static void C_ccall f_15215(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_15215,c,av);}
a=C_alloc(6);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15219,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t3,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* library.scm:1738: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[301]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[301]+1);
av2[1]=t5;
av2[2]=C_fix(4);
tp(3,av2);}}

/* k15217 in a15214 in ##sys#encode-char in k12556 in k11433 */
static void C_ccall f_15219(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,5)))){
C_save_and_reclaim((void *)f_15219,c,av);}
a=C_alloc(4);
t2=C_utf_insert(t1,C_fix(0),((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15224,a[2]=((C_word*)t0)[3],a[3]=((C_word)li357),tmp=(C_word)a,a+=4,tmp);
/* library.scm:1740: encoder */
t4=((C_word*)t0)[4];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=((C_word*)t0)[5];
av2[2]=t1;
av2[3]=C_fix(0);
av2[4]=t2;
av2[5]=t3;
((C_proc)C_fast_retrieve_proc(t4))(6,av2);}}

/* a15223 in k15217 in a15214 in ##sys#encode-char in k12556 in k11433 */
static void C_ccall f_15224(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_15224,c,av);}
t5=C_copy_memory_with_offset(((C_word*)t0)[2],t2,C_fix(0),t3,t4);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* ##sys#decode-char in k12556 in k11433 */
static void C_ccall f_15227(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,6)))){
C_save_and_reclaim((void *)f_15227,c,av);}
a=C_alloc(3);
t5=C_block_size(t2);
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15237,a[2]=((C_word)li360),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1746: ##sys#decode-buffer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[463]+1));
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=*((C_word*)lf[463]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=t4;
av2[4]=t5;
av2[5]=t3;
av2[6]=t6;
tp(7,av2);}}

/* a15236 in ##sys#decode-char in k12556 in k11433 */
static void C_ccall f_15237(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_15237,c,av);}
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_utf_decode(t2,t3);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* ##sys#read-char/encoding in k12556 in k11433 */
static void C_ccall f_15240(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_15240,c,av);}
a=C_alloc(5);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15246,a[2]=t2,a[3]=t4,a[4]=((C_word)li363),tmp=(C_word)a,a+=5,tmp);
/* library.scm:1753: ##sys#encoding-hook */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[456]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[456]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=t5;
tp(4,av2);}}

/* a15245 in ##sys#read-char/encoding in k12556 in k11433 */
static void C_ccall f_15246(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_15246,c,av);}
a=C_alloc(7);
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15250,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=t4,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
/* library.scm:1756: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[301]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[301]+1);
av2[1]=t5;
av2[2]=C_fix(4);
tp(3,av2);}}

/* k15248 in a15245 in ##sys#read-char/encoding in k12556 in k11433 */
static void C_ccall f_15250(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,c,4)))){
C_save_and_reclaim((void *)f_15250,c,av);}
a=C_alloc(12);
t2=C_slot(((C_word*)t0)[2],C_fix(2));
t3=C_slot(t2,C_fix(7));
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_15258,a[2]=t1,a[3]=t5,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=t3,a[8]=((C_word*)t0)[2],a[9]=((C_word)li362),tmp=(C_word)a,a+=10,tmp));
t7=((C_word*)t5)[1];
f_15258(t7,((C_word*)t0)[6],C_SCHEME_FALSE,C_fix(0));}

/* loop in k15248 in a15245 in ##sys#read-char/encoding in k12556 in k11433 */
static void f_15258(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,0,5)))){
C_save_and_reclaim_args((void *)trf_15258,4,t0,t1,t2,t3);}
a=C_alloc(10);
t4=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_15262,a[2]=t3,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[6],a[9]=t2,tmp=(C_word)a,a+=10,tmp);
/* library.scm:1759: rbv! */
t5=((C_word*)t0)[7];{
C_word av2[6];
av2[0]=t5;
av2[1]=t4;
av2[2]=((C_word*)t0)[8];
av2[3]=C_fix(1);
av2[4]=((C_word*)t0)[2];
av2[5]=t3;
((C_proc)C_fast_retrieve_proc(t5))(6,av2);}}

/* k15260 in loop in k15248 in a15245 in ##sys#read-char/encoding in k12556 in k11433 */
static void C_ccall f_15262(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,6)))){
C_save_and_reclaim((void *)f_15262,c,av);}
a=C_alloc(8);
t2=C_eqp(C_fix(0),t1);
if(C_truep(t2)){
t3=C_eqp(((C_word*)t0)[2],C_fix(0));
if(C_truep(t3)){
t4=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_END_OF_FILE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
/* library.scm:1763: ##sys#signal-hook */
t4=*((C_word*)lf[235]+1);{
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=t4;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[467];
av2[3]=lf[468];
av2[4]=lf[469];
av2[5]=((C_word*)t0)[4];
av2[6]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(7,av2);}}}
else{
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_15280,a[2]=((C_word*)t0)[5],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[7],tmp=(C_word)a,a+=8,tmp);
/* library.scm:1764: scan */
t4=((C_word*)t0)[8];{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[9];
av2[3]=C_subbyte(((C_word*)t0)[4],((C_word*)t0)[2]);
((C_proc)C_fast_retrieve_proc(t4))(4,av2);}}}

/* k15278 in k15260 in loop in k15248 in a15245 in ##sys#read-char/encoding in k12556 in k11433 */
static void C_ccall f_15280(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_15280,c,av);}
if(C_truep(t1)){
/* library.scm:1766: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_15258(t2,((C_word*)t0)[3],t1,C_fixnum_plus(((C_word*)t0)[4],C_fix(1)));}
else{
/* library.scm:1767: k */
t2=((C_word*)t0)[5];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[6];
av2[3]=C_fix(0);
av2[4]=C_fixnum_plus(((C_word*)t0)[4],C_fix(1));
av2[5]=((C_word*)t0)[7];
((C_proc)C_fast_retrieve_proc(t2))(6,av2);}}}

/* scheme#make-string in k12556 in k11433 */
static void C_ccall f_15304(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +5,c,5)))){
C_save_and_reclaim((void*)f_15304,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+5);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
t4=C_i_check_fixnum_2(t2,lf[471]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15311,a[2]=t3,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* library.scm:1773: ##sys#signal-hook */
t6=*((C_word*)lf[235]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=lf[472];
av2[3]=lf[471];
av2[4]=lf[473];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t6+1)))(6,av2);}}
else{
t6=t5;{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_SCHEME_UNDEFINED;
f_15311(2,av2);}}}

/* k15309 in scheme#make-string in k12556 in k11433 */
static void C_ccall f_15311(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_15311,c,av);}
if(C_truep(C_i_nullp(((C_word*)t0)[2]))){
/* library.scm:1774: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[446]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[446]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=C_make_character(32);
tp(4,av2);}}
else{
t2=C_i_car(((C_word*)t0)[2]);
t3=C_i_check_char_2(t2,lf[471]);
/* library.scm:1774: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[446]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[446]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=t2;
tp(4,av2);}}}

/* scheme#string->list in k12556 in k11433 */
static void C_ccall f_15335(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(11,c,5)))){
C_save_and_reclaim((void *)f_15335,c,av);}
a=C_alloc(11);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_get_rest_arg(c,3,av,3,t0));
t5=t4;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_rest_nullp(c,3);
t8=C_rest_nullp(c,4);
t9=(C_truep(t8)?C_SCHEME_FALSE:C_get_rest_arg(c,4,av,3,t0));
t10=t9;
t11=(*a=C_VECTOR_TYPE|1,a[1]=t10,tmp=(C_word)a,a+=2,tmp);
t12=C_rest_nullp(c,4);
t13=C_i_check_string_2(t2,lf[475]);
t14=C_slot(t2,C_fix(1));
t15=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15357,a[2]=t11,a[3]=t6,a[4]=t2,a[5]=t1,a[6]=t14,tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t6)[1])){
/* library.scm:1787: ##sys#check-range/including */
t16=*((C_word*)lf[431]+1);{
C_word av2[6];
av2[0]=t16;
av2[1]=t15;
av2[2]=((C_word*)t6)[1];
av2[3]=C_fix(0);
av2[4]=t14;
av2[5]=lf[475];
((C_proc)(void*)(*((C_word*)t16+1)))(6,av2);}}
else{
t16=C_set_block_item(t6,0,C_fix(0));
t17=t15;{
C_word *av2=av;
av2[0]=t17;
av2[1]=t16;
f_15357(2,av2);}}}

/* k15355 in scheme#string->list in k12556 in k11433 */
static void C_ccall f_15357(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_15357,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15360,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)((C_word*)t0)[2])[1])){
/* library.scm:1790: ##sys#check-range/including */
t3=*((C_word*)lf[431]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)((C_word*)t0)[2])[1];
av2[3]=C_fix(0);
av2[4]=((C_word*)t0)[6];
av2[5]=lf[475];
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}
else{
t3=C_mutate(((C_word *)((C_word*)t0)[2])+1,((C_word*)t0)[6]);
t4=t2;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
f_15360(2,av2);}}}

/* k15358 in k15355 in scheme#string->list in k12556 in k11433 */
static void C_ccall f_15360(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_15360,c,av);}
a=C_alloc(8);
t2=C_fixnum_difference(((C_word*)((C_word*)t0)[2])[1],C_fix(1));
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15369,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t4,a[5]=((C_word)li366),tmp=(C_word)a,a+=6,tmp));
t6=((C_word*)t4)[1];
f_15369(t6,((C_word*)t0)[5],t2,C_SCHEME_END_OF_LIST);}

/* loop in k15358 in k15355 in scheme#string->list in k12556 in k11433 */
static void f_15369(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(3,0,3)))){
C_save_and_reclaim_args((void *)trf_15369,4,t0,t1,t2,t3);}
a=C_alloc(3);
if(C_truep(C_fixnum_lessp(t2,((C_word*)((C_word*)t0)[2])[1]))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fixnum_difference(t2,C_fix(1));
t5=C_i_string_ref(((C_word*)t0)[3],t2);
t6=C_a_i_cons(&a,2,t5,t3);
/* library.scm:1795: loop */
t8=t1;
t9=t4;
t10=t6;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}

/* scheme#list->string in k12556 in k11433 */
static void C_ccall f_15426(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_15426,c,av);}
a=C_alloc(4);
t3=C_i_listp(t2);
if(C_truep(C_i_not(t3))){
/* library.scm:1803: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[51]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[51]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[478];
tp(4,av2);}}
else{
t4=C_utf_list_size(t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_15439,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:1805: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[301]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[301]+1);
av2[1]=t5;
av2[2]=C_fixnum_plus(C_fix(1),t4);
tp(3,av2);}}}

/* k15437 in scheme#list->string in k12556 in k11433 */
static void C_ccall f_15439(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,5)))){
C_save_and_reclaim((void *)f_15439,c,av);}
a=C_alloc(7);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15444,a[2]=t1,a[3]=t3,a[4]=((C_word)li368),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_15444(t5,((C_word*)t0)[2],C_fix(0),C_fix(0),((C_word*)t0)[3]);}

/* loop in k15437 in scheme#list->string in k12556 in k11433 */
static void f_15444(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(5,0,4)))){
C_save_and_reclaim_args((void *)trf_15444,5,t0,t1,t2,t3,t4);}
a=C_alloc(5);
t5=C_i_pairp(t4);
if(C_truep(C_i_not(t5))){
t6=C_a_ustring(&a,2,((C_word*)t0)[2],t2);
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t6=C_slot(t4,C_fix(0));
t7=C_i_check_char_2(t6,lf[478]);
t8=C_utf_insert(((C_word*)t0)[2],t3,t6);
/* library.scm:1814: loop */
t10=t1;
t11=C_fixnum_plus(t2,C_fix(1));
t12=C_fixnum_plus(t3,C_utf_bytes(t6));
t13=C_slot(t4,C_fix(1));
t1=t10;
t2=t11;
t3=t12;
t4=t13;
goto loop;}}

/* ##sys#reverse-list->string in k12556 in k11433 */
static void C_ccall f_15488(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_15488,c,av);}
a=C_alloc(5);
t3=C_utf_list_size(t2);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15492,a[2]=t1,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1822: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[301]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[301]+1);
av2[1]=t4;
av2[2]=C_fixnum_plus(t3,C_fix(1));
tp(3,av2);}}

/* k15490 in ##sys#reverse-list->string in k12556 in k11433 */
static void C_ccall f_15492(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,5)))){
C_save_and_reclaim((void *)f_15492,c,av);}
a=C_alloc(7);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15497,a[2]=t1,a[3]=t3,a[4]=((C_word)li370),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_15497(t5,((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4],C_fix(0));}

/* loop in k15490 in ##sys#reverse-list->string in k12556 in k11433 */
static void f_15497(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(5,0,4)))){
C_save_and_reclaim_args((void *)trf_15497,5,t0,t1,t2,t3,t4);}
a=C_alloc(5);
if(C_truep(C_i_nullp(t3))){
t5=C_a_ustring(&a,2,((C_word*)t0)[2],t4);
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
if(C_truep(C_i_pairp(t3))){
t5=C_slot(t3,C_fix(0));
t6=C_i_check_char_2(t5,lf[481]);
t7=C_utf_bytes(t5);
t8=C_fixnum_difference(t2,t7);
t9=C_utf_insert(((C_word*)t0)[2],t8,t5);
/* library.scm:1832: loop */
t11=t1;
t12=t8;
t13=C_slot(t3,C_fix(1));
t14=C_fixnum_plus(t4,C_fix(1));
t1=t11;
t2=t12;
t3=t13;
t4=t14;
goto loop;}
else{
/* library.scm:1833: ##sys#error-not-a-proper-list */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[51]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[51]+1);
av2[1]=t1;
av2[2]=t3;
av2[3]=lf[481];
tp(4,av2);}}}}

/* scheme#string-fill! in k12556 in k11433 */
static void C_ccall f_15539(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(11,c,2)))){
C_save_and_reclaim((void *)f_15539,c,av);}
a=C_alloc(11);
t4=C_rest_nullp(c,4);
t5=(C_truep(t4)?C_SCHEME_FALSE:C_get_rest_arg(c,4,av,4,t0));
t6=t5;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_rest_nullp(c,4);
t9=C_rest_nullp(c,5);
t10=(C_truep(t9)?C_SCHEME_FALSE:C_get_rest_arg(c,5,av,4,t0));
t11=t10;
t12=(*a=C_VECTOR_TYPE|1,a[1]=t11,tmp=(C_word)a,a+=2,tmp);
t13=C_rest_nullp(c,5);
t14=C_i_check_string_2(t2,lf[483]);
t15=C_i_check_char_2(t3,lf[483]);
t16=C_u_i_string_length(t2);
t17=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15562,a[2]=t2,a[3]=t12,a[4]=t7,a[5]=t3,a[6]=t1,tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)t7)[1])){
t18=C_i_check_range_2(((C_word*)t7)[1],C_fix(0),t16,lf[483]);
if(C_truep(((C_word*)t12)[1])){
t19=t17;
f_15562(t19,C_i_check_range_2(((C_word*)t12)[1],C_fix(0),t16,lf[483]));}
else{
t19=C_set_block_item(t12,0,t16);
t20=t17;
f_15562(t20,t19);}}
else{
t18=C_set_block_item(t7,0,C_fix(0));
t19=C_set_block_item(t12,0,t16);
t20=t17;
f_15562(t20,t19);}}

/* k15560 in scheme#string-fill! in k12556 in k11433 */
static void f_15562(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,2)))){
C_save_and_reclaim_args((void *)trf_15562,2,t0,t1);}
a=C_alloc(6);
t2=C_slot(((C_word*)t0)[2],C_fix(0));
t3=C_block_size(t2);
t4=C_fixnum_difference(((C_word*)((C_word*)t0)[3])[1],((C_word*)((C_word*)t0)[4])[1]);
t5=C_i_fixnum_max(C_fix(0),t4);
t6=C_fix(C_character_code(((C_word*)t0)[5]));
t7=C_fixnum_difference(t3,C_fix(1));
t8=C_slot(((C_word*)t0)[2],C_fix(1));
t9=C_eqp(t7,t8);
t10=(C_truep(t9)?C_fixnum_lessp(t6,C_fix(128)):C_SCHEME_FALSE);
if(C_truep(t10)){
t11=((C_word*)t0)[6];{
C_word av2[2];
av2[0]=t11;
av2[1]=C_fill_bytevector(t2,t6,((C_word*)((C_word*)t0)[4])[1],t5);
((C_proc)(void*)(*((C_word*)t11+1)))(2,av2);}}
else{
t11=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15585,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[5],a[5]=((C_word)li372),tmp=(C_word)a,a+=6,tmp);
t12=((C_word*)t0)[6];{
C_word av2[2];
av2[0]=t12;
av2[1]=(
  f_15585(t11,((C_word*)((C_word*)t0)[4])[1])
);
((C_proc)(void*)(*((C_word*)t12+1)))(2,av2);}}}

/* doloop2046 in k15560 in scheme#string-fill! in k12556 in k11433 */
static C_word f_15585(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_stack_overflow_check;
loop:{}
if(C_truep(C_fixnum_greater_or_equal_p(t1,((C_word*)((C_word*)t0)[2])[1]))){
t2=C_SCHEME_UNDEFINED;
return(t2);}
else{
t2=C_i_string_set(((C_word*)t0)[3],t1,((C_word*)t0)[4]);
t4=C_fixnum_plus(t1,C_fix(1));
t1=t4;
goto loop;}}

/* scheme#string-copy in k12556 in k11433 */
static void C_ccall f_15658(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(17,c,5)))){
C_save_and_reclaim((void *)f_15658,c,av);}
a=C_alloc(17);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_get_rest_arg(c,3,av,3,t0));
t5=C_rest_nullp(c,3);
t6=C_rest_nullp(c,4);
t7=(C_truep(t6)?C_SCHEME_FALSE:C_get_rest_arg(c,4,av,3,t0));
t8=t7;
t9=(*a=C_VECTOR_TYPE|1,a[1]=t8,tmp=(C_word)a,a+=2,tmp);
t10=C_rest_nullp(c,4);
t11=C_i_check_string_2(t2,lf[485]);
t12=C_u_i_string_length(t2);
t13=C_fix(0);
t14=(*a=C_VECTOR_TYPE|1,a[1]=t13,tmp=(C_word)a,a+=2,tmp);
t15=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_15678,a[2]=t9,a[3]=t14,a[4]=t1,a[5]=t4,a[6]=t2,a[7]=t12,tmp=(C_word)a,a+=8,tmp);
if(C_truep(t4)){
t16=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15706,a[2]=t14,a[3]=t4,a[4]=t15,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1864: ##sys#check-range/including */
t17=*((C_word*)lf[431]+1);{
C_word av2[6];
av2[0]=t17;
av2[1]=t16;
av2[2]=t4;
av2[3]=C_fix(0);
av2[4]=t12;
av2[5]=lf[485];
((C_proc)(void*)(*((C_word*)t17+1)))(6,av2);}}
else{
t16=t15;
f_15678(t16,C_SCHEME_UNDEFINED);}}

/* k15676 in scheme#string-copy in k12556 in k11433 */
static void f_15678(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,5)))){
C_save_and_reclaim_args((void *)trf_15678,2,t0,t1);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15681,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],tmp=(C_word)a,a+=7,tmp);
if(C_truep(((C_word*)((C_word*)t0)[2])[1])){
/* library.scm:1867: ##sys#check-range/including */
t3=*((C_word*)lf[431]+1);{
C_word av2[6];
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)((C_word*)t0)[2])[1];
av2[3]=C_fix(0);
av2[4]=((C_word*)t0)[7];
av2[5]=lf[485];
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}
else{
t3=C_set_block_item(((C_word*)t0)[2],0,((C_word*)t0)[7]);
t4=t2;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
f_15681(2,av2);}}}

/* k15679 in k15676 in scheme#string-copy in k12556 in k11433 */
static void C_ccall f_15681(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,4)))){
C_save_and_reclaim((void *)f_15681,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15684,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[5])){
/* library.scm:1870: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[486]+1));
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[486]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[6];
av2[3]=((C_word*)((C_word*)t0)[3])[1];
av2[4]=((C_word*)((C_word*)t0)[2])[1];
tp(5,av2);}}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_slot(((C_word*)t0)[6],C_fix(0));
f_15684(2,av2);}}}

/* k15682 in k15679 in k15676 in scheme#string-copy in k12556 in k11433 */
static void C_ccall f_15684(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_15684,c,av);}
a=C_alloc(6);
t2=C_block_size(t1);
t3=C_fixnum_difference(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15693,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[4],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* library.scm:1874: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[301]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[301]+1);
av2[1]=t4;
av2[2]=t2;
tp(3,av2);}}

/* k15691 in k15682 in k15679 in k15676 in scheme#string-copy in k12556 in k11433 */
static void C_ccall f_15693(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_15693,c,av);}
a=C_alloc(5);
t2=C_copy_memory(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_ustring(&a,2,t1,((C_word*)t0)[5]);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k15704 in scheme#string-copy in k12556 in k11433 */
static void C_ccall f_15706(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_15706,c,av);}
t2=C_set_block_item(((C_word*)t0)[2],0,((C_word*)t0)[3]);
t3=((C_word*)t0)[4];
f_15678(t3,t2);}

/* scheme#string-copy! in k12556 in k11433 */
static void C_ccall f_15733(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(18,c,5)))){
C_save_and_reclaim((void *)f_15733,c,av);}
a=C_alloc(18);
t5=C_rest_nullp(c,5);
t6=(C_truep(t5)?C_SCHEME_FALSE:C_get_rest_arg(c,5,av,5,t0));
t7=t6;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_rest_nullp(c,5);
t10=C_rest_nullp(c,6);
t11=(C_truep(t10)?C_SCHEME_FALSE:C_get_rest_arg(c,6,av,5,t0));
t12=t11;
t13=(*a=C_VECTOR_TYPE|1,a[1]=t12,tmp=(C_word)a,a+=2,tmp);
t14=C_rest_nullp(c,6);
t15=C_i_check_string_2(t2,lf[488]);
t16=C_i_check_string_2(t4,lf[488]);
t17=C_u_i_string_length(t2);
t18=C_u_i_string_length(t4);
t19=C_fixnum_difference(((C_word*)t13)[1],((C_word*)t8)[1]);
t20=C_i_check_range_2(t3,C_fix(0),t17,lf[488]);
t21=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_15763,a[2]=t2,a[3]=t4,a[4]=t8,a[5]=t3,a[6]=t19,a[7]=t13,a[8]=t1,tmp=(C_word)a,a+=9,tmp);
if(C_truep(((C_word*)t8)[1])){
t22=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_15850,a[2]=t13,a[3]=t21,a[4]=t18,tmp=(C_word)a,a+=5,tmp);
/* library.scm:1888: ##sys#check-range/including */
t23=*((C_word*)lf[431]+1);{
C_word av2[6];
av2[0]=t23;
av2[1]=t22;
av2[2]=((C_word*)t8)[1];
av2[3]=C_fix(0);
av2[4]=t18;
av2[5]=lf[488];
((C_proc)(void*)(*((C_word*)t23+1)))(6,av2);}}
else{
t22=C_set_block_item(t8,0,C_fix(0));
t23=t21;{
C_word *av2=av;
av2[0]=t23;
av2[1]=t22;
f_15763(2,av2);}}}

/* k15761 in scheme#string-copy! in k12556 in k11433 */
static void C_ccall f_15763(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_15763,c,av);}
a=C_alloc(6);
t2=C_eqp(((C_word*)t0)[2],((C_word*)t0)[3]);
t3=(C_truep(t2)?C_fixnum_lessp(((C_word*)((C_word*)t0)[4])[1],((C_word*)t0)[5]):C_SCHEME_FALSE);
if(C_truep(t3)){
t4=C_fixnum_plus(((C_word*)t0)[5],((C_word*)t0)[6]);
t5=C_fixnum_difference(t4,C_fix(1));
t6=C_fixnum_difference(((C_word*)((C_word*)t0)[7])[1],C_fix(1));
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15782,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[2],a[5]=((C_word)li375),tmp=(C_word)a,a+=6,tmp);
t8=((C_word*)t0)[8];{
C_word *av2=av;
av2[0]=t8;
av2[1]=(
  f_15782(t7,t5,t6)
);
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15816,a[2]=((C_word*)t0)[7],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[2],a[5]=((C_word)li376),tmp=(C_word)a,a+=6,tmp);
t5=((C_word*)t0)[8];{
C_word *av2=av;
av2[0]=t5;
av2[1]=(
  f_15816(t4,((C_word*)t0)[5],((C_word*)((C_word*)t0)[4])[1])
);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* doloop2104 in k15761 in scheme#string-copy! in k12556 in k11433 */
static C_word f_15782(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_overflow_check;
loop:{}
if(C_truep(C_fixnum_lessp(t2,((C_word*)((C_word*)t0)[2])[1]))){
t3=C_SCHEME_UNDEFINED;
return(t3);}
else{
t3=C_i_string_ref(((C_word*)t0)[3],t2);
t4=C_i_string_set(((C_word*)t0)[4],t1,t3);
t6=C_fixnum_difference(t1,C_fix(1));
t7=C_fixnum_difference(t2,C_fix(1));
t1=t6;
t2=t7;
goto loop;}}

/* doloop2110 in k15761 in scheme#string-copy! in k12556 in k11433 */
static C_word f_15816(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_stack_overflow_check;
loop:{}
if(C_truep(C_fixnum_greater_or_equal_p(t2,((C_word*)((C_word*)t0)[2])[1]))){
t3=C_SCHEME_UNDEFINED;
return(t3);}
else{
t3=C_i_string_ref(((C_word*)t0)[3],t2);
t4=C_i_string_set(((C_word*)t0)[4],t1,t3);
t6=C_fixnum_plus(t1,C_fix(1));
t7=C_fixnum_plus(t2,C_fix(1));
t1=t6;
t2=t7;
goto loop;}}

/* k15848 in scheme#string-copy! in k12556 in k11433 */
static void C_ccall f_15850(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_15850,c,av);}
if(C_truep(((C_word*)((C_word*)t0)[2])[1])){
/* library.scm:1890: ##sys#check-range/including */
t2=*((C_word*)lf[431]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)((C_word*)t0)[2])[1];
av2[3]=C_fix(0);
av2[4]=((C_word*)t0)[4];
av2[5]=lf[488];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}
else{
t2=C_set_block_item(((C_word*)t0)[2],0,((C_word*)t0)[4]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
f_15763(2,av2);}}}

/* ##sys#substring in k12556 in k11433 */
static void C_ccall f_15884(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_15884,c,av);}
a=C_alloc(6);
t5=C_utf_range(t2,t3,t4);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15888,a[2]=t4,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* library.scm:1905: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[301]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[301]+1);
av2[1]=t6;
av2[2]=C_fixnum_plus(t5,C_fix(1));
tp(3,av2);}}

/* k15886 in ##sys#substring in k12556 in k11433 */
static void C_ccall f_15888(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_15888,c,av);}
a=C_alloc(5);
t2=C_fixnum_difference(((C_word*)t0)[2],((C_word*)t0)[3]);
t3=C_a_ustring(&a,2,t1,t2);
t4=C_utf_copy(((C_word*)t0)[4],t3,((C_word*)t0)[3],((C_word*)t0)[2],C_fix(0));
t5=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t5;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#substring in k12556 in k11433 */
static void C_ccall f_15898(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +6,c,2)))){
C_save_and_reclaim((void*)f_15898,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+6);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
t5=C_i_check_string_2(t2,lf[490]);
t6=C_i_check_fixnum_2(t3,lf[490]);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15908,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=C_SCHEME_UNDEFINED,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_i_pairp(t4))){
t8=C_get_rest_arg(c,4,av,4,t0);
t9=C_i_check_fixnum_2(t8,lf[490]);
t10=t7;
f_15908(t10,t8);}
else{
t8=t7;
f_15908(t8,C_u_i_string_length(t2));}}

/* k15906 in scheme#substring in k12556 in k11433 */
static void f_15908(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,0,2)))){
C_save_and_reclaim_args((void *)trf_15908,2,t0,t1);}
a=C_alloc(3);
t2=C_mutate(((C_word *)t0)+5,t1);
t3=C_u_i_string_length(((C_word*)t0)[3]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_15915,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_fixnum_less_or_equal_p(((C_word*)t0)[4],((C_word*)t0)[5]))){
t5=C_fixnum_greater_or_equal_p(((C_word*)t0)[4],C_fix(0));
t6=t4;
f_15915(t6,(C_truep(t5)?C_fixnum_less_or_equal_p(((C_word*)t0)[5],t3):C_SCHEME_FALSE));}
else{
t5=t4;
f_15915(t5,C_SCHEME_FALSE);}}

/* k15913 in k15906 in scheme#substring in k12556 in k11433 */
static void f_15915(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,5)))){
C_save_and_reclaim_args((void *)trf_15915,2,t0,t1);}
t2=((C_word*)t0)[2];
if(C_truep(t1)){
/* library.scm:1923: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[486]+1));
C_word av2[5];
av2[0]=*((C_word*)lf[486]+1);
av2[1]=((C_word*)t2)[2];
av2[2]=((C_word*)t2)[3];
av2[3]=((C_word*)t2)[4];
av2[4]=((C_word*)t2)[5];
tp(5,av2);}}
else{
t3=C_fix((C_word)C_OUT_OF_BOUNDS_ERROR);
/* library.scm:1924: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word av2[6];
av2[0]=*((C_word*)lf[439]+1);
av2[1]=((C_word*)t2)[2];
av2[2]=t3;
av2[3]=lf[490];
av2[4]=((C_word*)t2)[3];
av2[5]=((C_word*)t2)[4];
tp(6,av2);}}}

/* compare in k12556 in k11433 */
static void f_15943(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,4)))){
C_save_and_reclaim_args((void *)trf_15943,6,t1,t2,t3,t4,t5,t6);}
a=C_alloc(7);
t7=C_i_check_string_2(t2,t5);
t8=C_i_check_string_2(t3,t5);
t9=C_u_i_string_length(t2);
t10=C_u_i_string_length(t3);
t11=C_fixnum_lessp(t9,t10);
t12=(C_truep(t11)?t9:t10);
t13=C_utf_compare(t2,t3,C_fix(0),C_fix(0),t12);
t14=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15963,a[2]=t4,a[3]=t6,a[4]=t1,a[5]=t3,a[6]=t10,tmp=(C_word)a,a+=7,tmp);
t15=C_fixnum_lessp(t9,t10);
t16=(C_truep(t15)?t9:t10);
/* library.scm:1938: cmp */
t17=t6;{
C_word av2[5];
av2[0]=t17;
av2[1]=t14;
av2[2]=C_utf_compare(t2,t3,C_fix(0),C_fix(0),t16);
av2[3]=t9;
av2[4]=t10;
((C_proc)C_fast_retrieve_proc(t17))(5,av2);}}

/* k15961 in compare in k12556 in k11433 */
static void C_ccall f_15963(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,6)))){
C_save_and_reclaim((void *)f_15963,c,av);}
a=C_alloc(8);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_15965,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word)li380),tmp=(C_word)a,a+=6,tmp));
t5=((C_word*)t3)[1];
f_15965(t5,((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[2],t1);}

/* loop in k15961 in compare in k12556 in k11433 */
static void f_15965(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(7,0,5)))){
C_save_and_reclaim_args((void *)trf_15965,6,t0,t1,t2,t3,t4,t5);}
a=C_alloc(7);
if(C_truep(C_i_nullp(t4))){
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_slot(((C_word*)t0)[2],C_fix(0));
t7=C_i_string_length(t6);
t8=C_fixnum_lessp(t3,t7);
t9=(C_truep(t8)?t3:t7);
t10=C_utf_compare_ci(t2,t6,C_fix(0),C_fix(0),t9);
t11=C_slot(((C_word*)t0)[2],C_fix(1));
t12=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_15993,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t6,a[5]=t7,a[6]=t11,tmp=(C_word)a,a+=7,tmp);
if(C_truep(t5)){
/* library.scm:1950: cmp */
t13=((C_word*)t0)[4];{
C_word av2[5];
av2[0]=t13;
av2[1]=t12;
av2[2]=t10;
av2[3]=t3;
av2[4]=t7;
((C_proc)C_fast_retrieve_proc(t13))(5,av2);}}
else{
/* library.scm:1949: loop */
t14=t1;
t15=t6;
t16=t7;
t17=t11;
t18=C_SCHEME_FALSE;
t1=t14;
t2=t15;
t3=t16;
t4=t17;
t5=t18;
goto loop;}}}

/* k15991 in loop in k15961 in compare in k12556 in k11433 */
static void C_ccall f_15993(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_15993,c,av);}
/* library.scm:1949: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_15965(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],t1);}

/* scheme#string<? in k12556 in k11433 */
static void C_ccall f_16012(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,6)))){
C_save_and_reclaim((void*)f_16012,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16018,a[2]=((C_word)li382),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1952: compare */
f_15943(t1,t2,t3,t4,lf[492],t5);}

/* a16017 in scheme#string<? in k12556 in k11433 */
static void C_ccall f_16018(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16018,c,av);}
t5=C_fixnum_lessp(t2,C_fix(0));
if(C_truep(t5)){
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_fixnum_lessp(t3,t4);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?C_eqp(t2,C_fix(0)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* scheme#string>? in k12556 in k11433 */
static void C_ccall f_16036(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,6)))){
C_save_and_reclaim((void*)f_16036,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16042,a[2]=((C_word)li384),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1959: compare */
f_15943(t1,t2,t3,t4,lf[494],t5);}

/* a16041 in scheme#string>? in k12556 in k11433 */
static void C_ccall f_16042(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16042,c,av);}
t5=C_fixnum_greaterp(t2,C_fix(0));
if(C_truep(t5)){
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_fixnum_lessp(t4,t3);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?C_eqp(t2,C_fix(0)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* scheme#string<=? in k12556 in k11433 */
static void C_ccall f_16060(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,6)))){
C_save_and_reclaim((void*)f_16060,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16066,a[2]=((C_word)li386),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1966: compare */
f_15943(t1,t2,t3,t4,lf[496],t5);}

/* a16065 in scheme#string<=? in k12556 in k11433 */
static void C_ccall f_16066(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16066,c,av);}
t5=C_eqp(t2,C_fix(0));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(C_truep(t5)?C_fixnum_less_or_equal_p(t3,t4):C_fixnum_lessp(t2,C_fix(0)));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* scheme#string>=? in k12556 in k11433 */
static void C_ccall f_16081(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,6)))){
C_save_and_reclaim((void*)f_16081,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16087,a[2]=((C_word)li388),tmp=(C_word)a,a+=3,tmp);
/* library.scm:1973: compare */
f_15943(t1,t2,t3,t4,lf[498],t5);}

/* a16086 in scheme#string>=? in k12556 in k11433 */
static void C_ccall f_16087(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16087,c,av);}
t5=C_eqp(t2,C_fix(0));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(C_truep(t5)?C_fixnum_greater_or_equal_p(t3,t4):C_fixnum_greaterp(t2,C_fix(0)));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* compare in k12556 in k11433 */
static void f_16101(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,4)))){
C_save_and_reclaim_args((void *)trf_16101,6,t1,t2,t3,t4,t5,t6);}
a=C_alloc(7);
t7=C_i_check_string_2(t2,t5);
t8=C_i_check_string_2(t3,t5);
t9=C_u_i_string_length(t2);
t10=C_u_i_string_length(t3);
t11=C_fixnum_lessp(t9,t10);
t12=(C_truep(t11)?t9:t10);
t13=C_utf_compare_ci(t2,t3,C_fix(0),C_fix(0),t12);
t14=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_16121,a[2]=t6,a[3]=t1,a[4]=t3,a[5]=t10,a[6]=t4,tmp=(C_word)a,a+=7,tmp);
/* library.scm:1990: cmp */
t15=t6;{
C_word av2[5];
av2[0]=t15;
av2[1]=t14;
av2[2]=t13;
av2[3]=t9;
av2[4]=t10;
((C_proc)C_fast_retrieve_proc(t15))(5,av2);}}

/* k16119 in compare in k12556 in k11433 */
static void C_ccall f_16121(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,6)))){
C_save_and_reclaim((void *)f_16121,c,av);}
a=C_alloc(7);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16123,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=((C_word)li390),tmp=(C_word)a,a+=5,tmp));
t5=((C_word*)t3)[1];
f_16123(t5,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],t1);}

/* loop in k16119 in compare in k12556 in k11433 */
static void f_16123(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(7,0,5)))){
C_save_and_reclaim_args((void *)trf_16123,6,t0,t1,t2,t3,t4,t5);}
a=C_alloc(7);
if(C_truep(C_i_nullp(t4))){
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_slot(t4,C_fix(0));
t7=C_i_string_length(t6);
t8=C_fixnum_lessp(t3,t7);
t9=(C_truep(t8)?t3:t7);
t10=C_utf_compare_ci(t2,t6,C_fix(0),C_fix(0),t9);
t11=C_slot(t4,C_fix(1));
t12=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_16151,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t6,a[5]=t7,a[6]=t11,tmp=(C_word)a,a+=7,tmp);
if(C_truep(t5)){
/* library.scm:1999: cmp */
t13=((C_word*)t0)[3];{
C_word av2[5];
av2[0]=t13;
av2[1]=t12;
av2[2]=t10;
av2[3]=t3;
av2[4]=t7;
((C_proc)C_fast_retrieve_proc(t13))(5,av2);}}
else{
/* library.scm:1998: loop */
t14=t1;
t15=t6;
t16=t7;
t17=t11;
t18=C_SCHEME_FALSE;
t1=t14;
t2=t15;
t3=t16;
t4=t17;
t5=t18;
goto loop;}}}

/* k16149 in loop in k16119 in compare in k12556 in k11433 */
static void C_ccall f_16151(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_16151,c,av);}
/* library.scm:1998: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_16123(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],t1);}

/* scheme#string-ci<? in k12556 in k11433 */
static void C_ccall f_16162(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,6)))){
C_save_and_reclaim((void*)f_16162,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16168,a[2]=((C_word)li392),tmp=(C_word)a,a+=3,tmp);
/* library.scm:2001: compare */
f_16101(t1,t2,t3,t4,lf[500],t5);}

/* a16167 in scheme#string-ci<? in k12556 in k11433 */
static void C_ccall f_16168(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16168,c,av);}
t5=C_fixnum_lessp(t2,C_fix(0));
if(C_truep(t5)){
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_fixnum_lessp(t3,t4);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?C_eqp(t2,C_fix(0)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* scheme#string-ci>? in k12556 in k11433 */
static void C_ccall f_16186(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,6)))){
C_save_and_reclaim((void*)f_16186,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16192,a[2]=((C_word)li394),tmp=(C_word)a,a+=3,tmp);
/* library.scm:2008: compare */
f_16101(t1,t2,t3,t4,lf[502],t5);}

/* a16191 in scheme#string-ci>? in k12556 in k11433 */
static void C_ccall f_16192(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16192,c,av);}
t5=C_fixnum_greaterp(t2,C_fix(0));
if(C_truep(t5)){
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_fixnum_lessp(t4,t3);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?C_eqp(t2,C_fix(0)):C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* scheme#string-ci<=? in k12556 in k11433 */
static void C_ccall f_16210(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,6)))){
C_save_and_reclaim((void*)f_16210,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16216,a[2]=((C_word)li396),tmp=(C_word)a,a+=3,tmp);
/* library.scm:2015: compare */
f_16101(t1,t2,t3,t4,lf[504],t5);}

/* a16215 in scheme#string-ci<=? in k12556 in k11433 */
static void C_ccall f_16216(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16216,c,av);}
t5=C_eqp(t2,C_fix(0));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(C_truep(t5)?C_fixnum_less_or_equal_p(t3,t4):C_fixnum_lessp(t2,C_fix(0)));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* scheme#string-ci>=? in k12556 in k11433 */
static void C_ccall f_16231(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +3,c,6)))){
C_save_and_reclaim((void*)f_16231,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+3);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_16237,a[2]=((C_word)li398),tmp=(C_word)a,a+=3,tmp);
/* library.scm:2022: compare */
f_16101(t1,t2,t3,t4,lf[506],t5);}

/* a16236 in scheme#string-ci>=? in k12556 in k11433 */
static void C_ccall f_16237(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16237,c,av);}
t5=C_eqp(t2,C_fix(0));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=(C_truep(t5)?C_fixnum_greater_or_equal_p(t3,t4):C_fixnum_greaterp(t2,C_fix(0)));
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* ##sys#string-append in k12556 in k11433 */
static void C_ccall f_16252(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_16252,c,av);}
a=C_alloc(9);
t4=C_slot(t2,C_fix(0));
t5=C_slot(t3,C_fix(0));
t6=C_block_size(t4);
t7=C_fixnum_difference(t6,C_fix(1));
t8=C_block_size(t5);
t9=C_fixnum_difference(t8,C_fix(1));
t10=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_16268,a[2]=t4,a[3]=t7,a[4]=t5,a[5]=t9,a[6]=t2,a[7]=t3,a[8]=t1,tmp=(C_word)a,a+=9,tmp);
t11=C_fixnum_plus(t9,C_fix(1));
/* library.scm:2034: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[301]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[301]+1);
av2[1]=t10;
av2[2]=C_fixnum_plus(t7,t11);
av2[3]=C_fix(0);
tp(4,av2);}}

/* k16266 in ##sys#string-append in k12556 in k11433 */
static void C_ccall f_16268(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_16268,c,av);}
a=C_alloc(5);
t2=C_copy_memory_with_offset(t1,((C_word*)t0)[2],C_fix(0),C_fix(0),((C_word*)t0)[3]);
t3=C_copy_memory_with_offset(t1,((C_word*)t0)[4],((C_word*)t0)[3],C_fix(0),((C_word*)t0)[5]);
t4=C_slot(((C_word*)t0)[6],C_fix(1));
t5=C_slot(((C_word*)t0)[7],C_fix(1));
t6=C_fixnum_plus(t4,t5);
t7=((C_word*)t0)[8];{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_a_ustring(&a,2,t1,t6);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* scheme#string-append in k12556 in k11433 */
static void C_ccall f_16298(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +17,c,5)))){
C_save_and_reclaim((void*)f_16298,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+17);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t3=C_SCHEME_FALSE;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_fix(0);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16302,a[2]=t1,a[3]=t4,a[4]=t6,tmp=(C_word)a,a+=5,tmp);
t8=C_SCHEME_UNDEFINED;
t9=(*a=C_VECTOR_TYPE|1,a[1]=t8,tmp=(C_word)a,a+=2,tmp);
t10=C_set_block_item(t9,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_16304,a[2]=t4,a[3]=t6,a[4]=t9,a[5]=((C_word)li401),tmp=(C_word)a,a+=6,tmp));
t11=((C_word*)t9)[1];
f_16304(t11,t7,t2,C_fix(0),C_fix(0));}

/* k16300 in scheme#string-append in k12556 in k11433 */
static void C_ccall f_16302(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_16302,c,av);}
a=C_alloc(5);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_ustring(&a,2,((C_word*)((C_word*)t0)[3])[1],((C_word*)((C_word*)t0)[4])[1]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* loop in scheme#string-append in k12556 in k11433 */
static void f_16304(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(7,0,4)))){
C_save_and_reclaim_args((void *)trf_16304,5,t0,t1,t2,t3,t4);}
a=C_alloc(7);
t5=C_eqp(t2,C_SCHEME_END_OF_LIST);
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_16315,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t4,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
/* library.scm:2046: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[301]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[301]+1);
av2[1]=t6;
av2[2]=C_fixnum_plus(t3,C_fix(1));
av2[3]=C_fix(0);
tp(4,av2);}}
else{
t6=C_slot(t2,C_fix(0));
t7=C_i_check_string_2(t6,lf[509]);
t8=C_slot(t6,C_fix(0));
t9=C_block_size(t8);
t10=C_fixnum_difference(t9,C_fix(1));
t11=C_slot(t6,C_fix(1));
t12=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_16338,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t8,a[5]=t3,a[6]=t10,tmp=(C_word)a,a+=7,tmp);
/* library.scm:2054: loop */
t14=t12;
t15=C_slot(t2,C_fix(1));
t16=C_fixnum_plus(t3,t10);
t17=C_fixnum_plus(t4,t11);
t1=t14;
t2=t15;
t3=t16;
t4=t17;
goto loop;}}

/* k16313 in loop in scheme#string-append in k12556 in k11433 */
static void C_ccall f_16315(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16315,c,av);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,t1);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)t0)[4]);
t4=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k16336 in loop in scheme#string-append in k12556 in k11433 */
static void C_ccall f_16338(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16338,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_copy_memory_with_offset(((C_word*)((C_word*)t0)[3])[1],((C_word*)t0)[4],((C_word*)t0)[5],C_fix(0),((C_word*)t0)[6]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* scheme#string in k12556 in k11433 */
static void C_ccall f_16356(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +0,c,2)))){
C_save_and_reclaim((void*)f_16356,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+0);
t2=C_build_rest(&a,c,2,av);
C_word t3;
/* ##sys#list->string */
t3=*((C_word*)lf[479]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* ##sys#char->utf8-string in k12556 in k11433 */
static void C_ccall f_16362(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,1)))){
C_save_and_reclaim((void *)f_16362,c,av);}
a=C_alloc(8);
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_string(&a,1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.base#chop in k12556 in k11433 */
static void C_ccall f_16368(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,4)))){
C_save_and_reclaim((void *)f_16368,c,av);}
a=C_alloc(5);
t4=C_i_check_fixnum_2(t3,lf[513]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16375,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnum_less_or_equal_p(t3,C_fix(0)))){
/* library.scm:2069: ##sys#error */
t6=*((C_word*)lf[195]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=lf[513];
av2[3]=lf[514];
av2[4]=t3;
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}
else{
t6=t5;{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_SCHEME_UNDEFINED;
f_16375(2,av2);}}}

/* k16373 in chicken.base#chop in k12556 in k11433 */
static void C_ccall f_16375(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_16375,c,av);}
a=C_alloc(7);
t2=C_i_length(((C_word*)t0)[2]);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16383,a[2]=((C_word*)t0)[3],a[3]=t4,a[4]=((C_word)li406),tmp=(C_word)a,a+=5,tmp));
t6=((C_word*)t4)[1];
f_16383(t6,((C_word*)t0)[4],((C_word*)t0)[2],t2);}

/* loop in k16373 in chicken.base#chop in k12556 in k11433 */
static void f_16383(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,0,5)))){
C_save_and_reclaim_args((void *)trf_16383,4,t0,t1,t2,t3);}
a=C_alloc(9);
if(C_truep(C_i_nullp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_END_OF_LIST;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
if(C_truep(C_fixnum_lessp(t3,((C_word*)t0)[2]))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_a_i_list1(&a,1,t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_16404,a[2]=((C_word*)t0)[3],a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=t5,a[6]=((C_word)li405),tmp=(C_word)a,a+=7,tmp));
t7=((C_word*)t5)[1];
f_16404(t7,t1,C_SCHEME_END_OF_LIST,t2,((C_word*)t0)[2]);}}}

/* doloop2296 in loop in k16373 in chicken.base#chop in k12556 in k11433 */
static void f_16404(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(7,0,4)))){
C_save_and_reclaim_args((void *)trf_16404,5,t0,t1,t2,t3,t4);}
a=C_alloc(7);
t5=C_eqp(t4,C_fix(0));
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_16418,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t3,a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],tmp=(C_word)a,a+=7,tmp);
/* library.scm:2079: scheme#reverse */
t7=*((C_word*)lf[50]+1);{
C_word av2[3];
av2[0]=t7;
av2[1]=t6;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}
else{
t6=C_slot(t3,C_fix(0));
t7=C_a_i_cons(&a,2,t6,t2);
t9=t1;
t10=t7;
t11=C_slot(t3,C_fix(1));
t12=C_fixnum_difference(t4,C_fix(1));
t1=t9;
t2=t10;
t3=t11;
t4=t12;
goto loop;}}

/* k16416 in doloop2296 in loop in k16373 in chicken.base#chop in k12556 in k11433 */
static void C_ccall f_16418(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_16418,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16422,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2079: loop */
t3=((C_word*)((C_word*)t0)[3])[1];
f_16383(t3,t2,((C_word*)t0)[4],C_fixnum_difference(((C_word*)t0)[5],((C_word*)t0)[6]));}

/* k16420 in k16416 in doloop2296 in loop in k16373 in chicken.base#chop in k12556 in k11433 */
static void C_ccall f_16422(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_16422,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_cons(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp+ in k12556 in k11433 */
static void C_ccall f_16463(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_16463,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16485,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_flonum(&a,C_ub_i_flonum_plus(C_flonum_magnitude(t2),C_flonum_magnitude(t3)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2110: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[527];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k16483 in chicken.flonum#fp+ in k12556 in k11433 */
static void C_ccall f_16485(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16485,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_ub_i_flonum_plus(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp- in k12556 in k11433 */
static void C_ccall f_16487(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_16487,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16509,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_flonum(&a,C_ub_i_flonum_difference(C_flonum_magnitude(t2),C_flonum_magnitude(t3)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2110: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[529];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k16507 in chicken.flonum#fp- in k12556 in k11433 */
static void C_ccall f_16509(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16509,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_ub_i_flonum_difference(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp* in k12556 in k11433 */
static void C_ccall f_16511(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_16511,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16533,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_flonum(&a,C_ub_i_flonum_times(C_flonum_magnitude(t2),C_flonum_magnitude(t3)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2110: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[531];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k16531 in chicken.flonum#fp* in k12556 in k11433 */
static void C_ccall f_16533(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16533,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_ub_i_flonum_times(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp/ in k12556 in k11433 */
static void C_ccall f_16535(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_16535,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16557,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_flonum(&a,C_ub_i_flonum_quotient(C_flonum_magnitude(t2),C_flonum_magnitude(t3)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2110: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[533];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k16555 in chicken.flonum#fp/ in k12556 in k11433 */
static void C_ccall f_16557(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16557,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_ub_i_flonum_quotient(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp*+ in k12556 in k11433 */
static void C_ccall f_16559(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(13,c,2)))){
C_save_and_reclaim((void *)f_16559,c,av);}
a=C_alloc(13);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_16563,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_16566,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,a[6]=t5,tmp=(C_word)a,a+=7,tmp);
if(C_truep(C_i_flonump(t2))){
t7=C_i_flonump(t3);
t8=t6;
f_16566(t8,(C_truep(t7)?C_i_flonump(t4):C_SCHEME_FALSE));}
else{
t7=t6;
f_16566(t7,C_SCHEME_FALSE);}}

/* k16561 in chicken.flonum#fp*+ in k12556 in k11433 */
static void C_ccall f_16563(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16563,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_ub_i_flonum_multiply_add(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]),C_flonum_magnitude(((C_word*)t0)[5])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k16564 in chicken.flonum#fp*+ in k12556 in k11433 */
static void f_16566(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,6)))){
C_save_and_reclaim_args((void *)trf_16566,2,t0,t1);}
a=C_alloc(4);
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_flonum(&a,C_ub_i_flonum_multiply_add(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]),C_flonum_magnitude(((C_word*)t0)[5])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2130: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word av2[7];
av2[0]=*((C_word*)lf[439]+1);
av2[1]=((C_word*)t0)[6];
av2[2]=t2;
av2[3]=lf[535];
av2[4]=((C_word*)t0)[3];
av2[5]=((C_word*)t0)[4];
av2[6]=((C_word*)t0)[5];
tp(7,av2);}}}

/* chicken.flonum#fpgcd in k12556 in k11433 */
static void C_ccall f_16584(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_16584,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16606,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_a_i_flonum_gcd(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2110: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[537];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k16604 in chicken.flonum#fpgcd in k12556 in k11433 */
static void C_ccall f_16606(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16606,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_flonum_gcd(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp/? in k12556 in k11433 */
static void C_ccall f_16608(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_16608,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16630,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_a_i_flonum_quotient_checked(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2110: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[539];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k16628 in chicken.flonum#fp/? in k12556 in k11433 */
static void C_ccall f_16630(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16630,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_flonum_quotient_checked(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp= in k12556 in k11433 */
static void C_ccall f_16632(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_16632,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16654,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_ub_i_flonum_equalp(C_flonum_magnitude(t2),C_flonum_magnitude(t3));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2110: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[541];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k16652 in chicken.flonum#fp= in k12556 in k11433 */
static void C_ccall f_16654(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16654,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_ub_i_flonum_equalp(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp> in k12556 in k11433 */
static void C_ccall f_16656(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_16656,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16678,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_ub_i_flonum_greaterp(C_flonum_magnitude(t2),C_flonum_magnitude(t3));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2110: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[543];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k16676 in chicken.flonum#fp> in k12556 in k11433 */
static void C_ccall f_16678(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16678,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_ub_i_flonum_greaterp(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp< in k12556 in k11433 */
static void C_ccall f_16680(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_16680,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16702,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_ub_i_flonum_lessp(C_flonum_magnitude(t2),C_flonum_magnitude(t3));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2110: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[545];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k16700 in chicken.flonum#fp< in k12556 in k11433 */
static void C_ccall f_16702(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16702,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_ub_i_flonum_lessp(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp>= in k12556 in k11433 */
static void C_ccall f_16704(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_16704,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16726,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_ub_i_flonum_greater_or_equal_p(C_flonum_magnitude(t2),C_flonum_magnitude(t3));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2110: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[547];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k16724 in chicken.flonum#fp>= in k12556 in k11433 */
static void C_ccall f_16726(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16726,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_ub_i_flonum_greater_or_equal_p(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fp<= in k12556 in k11433 */
static void C_ccall f_16728(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_16728,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16750,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_ub_i_flonum_less_or_equal_p(C_flonum_magnitude(t2),C_flonum_magnitude(t3));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2110: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[549];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k16748 in chicken.flonum#fp<= in k12556 in k11433 */
static void C_ccall f_16750(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16750,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_ub_i_flonum_less_or_equal_p(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4]));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpneg in k12556 in k11433 */
static void C_ccall f_16752(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_16752,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16768,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_flonum_negate(&a,1,t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2106: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[551];
av2[4]=t2;
tp(5,av2);}}}

/* k16766 in chicken.flonum#fpneg in k12556 in k11433 */
static void C_ccall f_16768(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16768,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_flonum_negate(&a,1,((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpmax in k12556 in k11433 */
static void C_ccall f_16770(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_16770,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16792,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_i_flonum_max(t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2110: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[553];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k16790 in chicken.flonum#fpmax in k12556 in k11433 */
static void C_ccall f_16792(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16792,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_i_flonum_max(((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpmin in k12556 in k11433 */
static void C_ccall f_16794(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_16794,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_16816,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_i_flonum_min(t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2110: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[555];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k16814 in chicken.flonum#fpmin in k12556 in k11433 */
static void C_ccall f_16816(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_16816,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_i_flonum_min(((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpfloor in k12556 in k11433 */
static void C_ccall f_16818(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_16818,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16834,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_floor(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2106: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[557];
av2[4]=t2;
tp(5,av2);}}}

/* k16832 in chicken.flonum#fpfloor in k12556 in k11433 */
static void C_ccall f_16834(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16834,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_floor(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fptruncate in k12556 in k11433 */
static void C_ccall f_16836(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_16836,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16852,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_trunc(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2106: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[559];
av2[4]=t2;
tp(5,av2);}}}

/* k16850 in chicken.flonum#fptruncate in k12556 in k11433 */
static void C_ccall f_16852(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16852,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_trunc(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpround in k12556 in k11433 */
static void C_ccall f_16854(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_16854,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16870,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_round(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2106: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[561];
av2[4]=t2;
tp(5,av2);}}}

/* k16868 in chicken.flonum#fpround in k12556 in k11433 */
static void C_ccall f_16870(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16870,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_round(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpceiling in k12556 in k11433 */
static void C_ccall f_16872(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_16872,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16888,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_ceil(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2106: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[563];
av2[4]=t2;
tp(5,av2);}}}

/* k16886 in chicken.flonum#fpceiling in k12556 in k11433 */
static void C_ccall f_16888(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16888,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_ceil(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpsin in k12556 in k11433 */
static void C_ccall f_16890(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_16890,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16906,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_sin(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2106: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[565];
av2[4]=t2;
tp(5,av2);}}}

/* k16904 in chicken.flonum#fpsin in k12556 in k11433 */
static void C_ccall f_16906(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16906,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_sin(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpcos in k12556 in k11433 */
static void C_ccall f_16908(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_16908,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16924,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_cos(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2106: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[567];
av2[4]=t2;
tp(5,av2);}}}

/* k16922 in chicken.flonum#fpcos in k12556 in k11433 */
static void C_ccall f_16924(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16924,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_cos(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fptan in k12556 in k11433 */
static void C_ccall f_16926(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_16926,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16942,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_tan(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2106: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[569];
av2[4]=t2;
tp(5,av2);}}}

/* k16940 in chicken.flonum#fptan in k12556 in k11433 */
static void C_ccall f_16942(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16942,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_tan(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpasin in k12556 in k11433 */
static void C_ccall f_16944(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_16944,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16960,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_asin(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2106: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[571];
av2[4]=t2;
tp(5,av2);}}}

/* k16958 in chicken.flonum#fpasin in k12556 in k11433 */
static void C_ccall f_16960(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16960,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_asin(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpacos in k12556 in k11433 */
static void C_ccall f_16962(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_16962,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16978,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_acos(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2106: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[573];
av2[4]=t2;
tp(5,av2);}}}

/* k16976 in chicken.flonum#fpacos in k12556 in k11433 */
static void C_ccall f_16978(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16978,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_acos(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpatan in k12556 in k11433 */
static void C_ccall f_16980(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_16980,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_16996,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_atan(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2106: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[575];
av2[4]=t2;
tp(5,av2);}}}

/* k16994 in chicken.flonum#fpatan in k12556 in k11433 */
static void C_ccall f_16996(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_16996,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_atan(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpatan2 in k12556 in k11433 */
static void C_ccall f_16998(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_16998,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17020,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_flonum(&a,C_atan2(C_flonum_magnitude(t2),C_flonum_magnitude(t3)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2110: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[577];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k17018 in chicken.flonum#fpatan2 in k12556 in k11433 */
static void C_ccall f_17020(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_17020,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_atan2(C_flonum_magnitude(((C_word*)t0)[3]),C_flonum_magnitude(((C_word*)t0)[4])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpsinh in k12556 in k11433 */
static void C_ccall f_17022(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_17022,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17038,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_sinh(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2106: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[579];
av2[4]=t2;
tp(5,av2);}}}

/* k17036 in chicken.flonum#fpsinh in k12556 in k11433 */
static void C_ccall f_17038(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_17038,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_sinh(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpcosh in k12556 in k11433 */
static void C_ccall f_17040(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_17040,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17056,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_cosh(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2106: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[581];
av2[4]=t2;
tp(5,av2);}}}

/* k17054 in chicken.flonum#fpcosh in k12556 in k11433 */
static void C_ccall f_17056(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_17056,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_cosh(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fptanh in k12556 in k11433 */
static void C_ccall f_17058(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_17058,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17074,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_tanh(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2106: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[583];
av2[4]=t2;
tp(5,av2);}}}

/* k17072 in chicken.flonum#fptanh in k12556 in k11433 */
static void C_ccall f_17074(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_17074,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_tanh(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpasinh in k12556 in k11433 */
static void C_ccall f_17076(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_17076,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17092,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_asinh(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2106: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[585];
av2[4]=t2;
tp(5,av2);}}}

/* k17090 in chicken.flonum#fpasinh in k12556 in k11433 */
static void C_ccall f_17092(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_17092,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_asinh(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpacosh in k12556 in k11433 */
static void C_ccall f_17094(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_17094,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17110,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_acosh(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2106: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[587];
av2[4]=t2;
tp(5,av2);}}}

/* k17108 in chicken.flonum#fpacosh in k12556 in k11433 */
static void C_ccall f_17110(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_17110,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_acosh(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpatanh in k12556 in k11433 */
static void C_ccall f_17112(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_17112,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17128,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_atanh(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2106: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[589];
av2[4]=t2;
tp(5,av2);}}}

/* k17126 in chicken.flonum#fpatanh in k12556 in k11433 */
static void C_ccall f_17128(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_17128,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_atanh(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpexp in k12556 in k11433 */
static void C_ccall f_17130(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_17130,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17146,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_exp(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2106: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[591];
av2[4]=t2;
tp(5,av2);}}}

/* k17144 in chicken.flonum#fpexp in k12556 in k11433 */
static void C_ccall f_17146(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_17146,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_exp(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpexpt in k12556 in k11433 */
static void C_ccall f_17148(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,5)))){
C_save_and_reclaim((void *)f_17148,c,av);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17170,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_i_flonump(t2);
t6=(C_truep(t5)?C_i_flonump(t3):C_SCHEME_FALSE);
if(C_truep(t6)){
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_a_i_flonum_expt(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2110: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t4;
av2[2]=t7;
av2[3]=lf[593];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}}

/* k17168 in chicken.flonum#fpexpt in k12556 in k11433 */
static void C_ccall f_17170(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_17170,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_flonum_expt(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fplog in k12556 in k11433 */
static void C_ccall f_17172(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_17172,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17188,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_log(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2106: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[595];
av2[4]=t2;
tp(5,av2);}}}

/* k17186 in chicken.flonum#fplog in k12556 in k11433 */
static void C_ccall f_17188(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_17188,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_log(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpsqrt in k12556 in k11433 */
static void C_ccall f_17190(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_17190,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17206,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_sqrt(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2106: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[597];
av2[4]=t2;
tp(5,av2);}}}

/* k17204 in chicken.flonum#fpsqrt in k12556 in k11433 */
static void C_ccall f_17206(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_17206,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_sqrt(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpabs in k12556 in k11433 */
static void C_ccall f_17208(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_17208,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17224,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_flonum(&a,C_fabs(C_flonum_magnitude(t2)));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2106: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[599];
av2[4]=t2;
tp(5,av2);}}}

/* k17222 in chicken.flonum#fpabs in k12556 in k11433 */
static void C_ccall f_17224(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_17224,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_flonum(&a,C_fabs(C_flonum_magnitude(((C_word*)t0)[3])));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#fpinteger? in k12556 in k11433 */
static void C_ccall f_17226(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,4)))){
C_save_and_reclaim((void *)f_17226,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17242,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_u_i_fpintegerp(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_fix((C_word)C_BAD_ARGUMENT_TYPE_NO_FLONUM_ERROR);
/* library.scm:2106: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t3;
av2[2]=t4;
av2[3]=lf[601];
av2[4]=t2;
tp(5,av2);}}}

/* k17240 in chicken.flonum#fpinteger? in k12556 in k11433 */
static void C_ccall f_17242(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17242,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_u_i_fpintegerp(((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.flonum#flonum-print-precision in k12556 in k11433 */
static void C_ccall f_17244(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17244,c,av);}
t2=C_rest_nullp(c,2);
t3=(C_truep(t2)?C_SCHEME_FALSE:C_get_rest_arg(c,2,av,2,t0));
t4=C_get_print_precision();
if(C_truep(t3)){
t5=C_i_check_fixnum_2(t3,lf[603]);
t6=C_set_print_precision(t3);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* make-complex in k12556 in k11433 */
static void f_17262(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_17262,3,t1,t2,t3);}
a=C_alloc(5);
t4=C_eqp(t3,C_fix(0));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17272,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(t4)){
t6=t5;{
C_word av2[2];
av2[0]=t6;
av2[1]=t4;
f_17272(2,av2);}}
else{
if(C_truep(C_i_flonump(t3))){
/* library.scm:2284: chicken.flonum#fp= */
t6=*((C_word*)lf[540]+1);{
C_word av2[4];
av2[0]=t6;
av2[1]=t5;
av2[2]=t3;
av2[3]=lf[605];
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}
else{
t6=t5;{
C_word av2[2];
av2[0]=t6;
av2[1]=C_SCHEME_FALSE;
f_17272(2,av2);}}}}

/* k17270 in make-complex in k12556 in k11433 */
static void C_ccall f_17272(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_17272,c,av);}
a=C_alloc(3);
if(C_truep(t1)){
t2=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17276,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_inexactp(((C_word*)t0)[3]))){
/* library.scm:2287: scheme#exact->inexact */
t3=*((C_word*)lf[86]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=((C_word*)t0)[2];
f_17276(2,av2);}}}}

/* k17274 in k17270 in make-complex in k12556 in k11433 */
static void C_ccall f_17276(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(14,c,1)))){
C_save_and_reclaim((void *)f_17276,c,av);}
a=C_alloc(14);
t2=((C_word*)t0)[2];
if(C_truep(C_i_inexactp(((C_word*)t2)[2]))){
t3=C_a_i_exact_to_inexact(&a,1,((C_word*)t2)[3]);
t4=C_a_i_cplxnum(&a,2,t1,t3);
t5=((C_word*)t2)[4];{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t3=C_a_i_cplxnum(&a,2,t1,((C_word*)t2)[3]);
t4=((C_word*)t2)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* scheme#make-rectangular in k12556 in k11433 */
static void C_ccall f_17298(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_17298,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17302,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2292: ##sys#check-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[428]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[428]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[607];
tp(4,av2);}}

/* k17300 in scheme#make-rectangular in k12556 in k11433 */
static void C_ccall f_17302(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_17302,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17305,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2293: ##sys#check-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[428]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[428]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=lf[607];
tp(4,av2);}}

/* k17303 in k17300 in scheme#make-rectangular in k12556 in k11433 */
static void C_ccall f_17305(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_17305,c,av);}
t2=((C_word*)t0)[2];
/* library.scm:2294: make-complex */
f_17262(((C_word*)t2)[2],((C_word*)t2)[3],((C_word*)t2)[4]);}

/* scheme#make-polar in k12556 in k11433 */
static void C_ccall f_17310(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_17310,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17314,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2298: ##sys#check-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[428]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[428]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[609];
tp(4,av2);}}

/* k17312 in scheme#make-polar in k12556 in k11433 */
static void C_ccall f_17314(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_17314,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17317,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2299: ##sys#check-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[428]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[428]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=lf[609];
tp(4,av2);}}

/* k17315 in k17312 in scheme#make-polar in k12556 in k11433 */
static void C_ccall f_17317(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_17317,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17320,a[2]=((C_word*)t2)[2],a[3]=((C_word*)t2)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2300: scheme#exact->inexact */
t4=*((C_word*)lf[86]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t2)[4];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k17318 in k17315 in k17312 in scheme#make-polar in k12556 in k11433 */
static void C_ccall f_17320(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(74,c,3)))){
C_save_and_reclaim((void *)f_17320,c,av);}
a=C_alloc(74);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],C_a_i_cos(&a,1,t1));
t3=C_s_a_i_times(&a,2,((C_word*)t0)[2],C_a_i_sin(&a,1,t1));
/* library.scm:2301: make-complex */
f_17262(((C_word*)t0)[3],t2,t3);}

/* scheme#real-part in k12556 in k11433 */
static void C_ccall f_17333(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_17333,c,av);}
if(C_truep(C_i_cplxnump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_u_i_cplxnum_real(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_numberp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* library.scm:2309: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[440]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[440]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[611];
tp(4,av2);}}}}

/* scheme#imag-part in k12556 in k11433 */
static void C_ccall f_17356(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_17356,c,av);}
if(C_truep(C_i_cplxnump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_u_i_cplxnum_imag(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=lf[605];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_numberp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_fix(0);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* library.scm:2316: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[440]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[440]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[613];
tp(4,av2);}}}}}

/* scheme#angle in k12556 in k11433 */
static void C_ccall f_17382(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_17382,c,av);}
a=C_alloc(4);
t3=C_i_check_number_2(t2,lf[615]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17391,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2322: scheme#imag-part */
t5=*((C_word*)lf[612]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}

/* k17389 in scheme#angle in k12556 in k11433 */
static void C_ccall f_17391(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,c,2)))){
C_save_and_reclaim((void *)f_17391,c,av);}
a=C_alloc(15);
t2=C_a_i_exact_to_inexact(&a,1,t1);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17396,a[2]=((C_word*)t0)[2],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2323: scheme#real-part */
t4=*((C_word*)lf[610]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k17394 in k17389 in scheme#angle in k12556 in k11433 */
static void C_ccall f_17396(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,c,1)))){
C_save_and_reclaim((void *)f_17396,c,av);}
a=C_alloc(15);
t2=C_a_i_exact_to_inexact(&a,1,t1);
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_atan2(&a,2,((C_word*)t0)[3],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* scheme#magnitude in k12556 in k11433 */
static void C_ccall f_17398(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(95,c,3)))){
C_save_and_reclaim((void *)f_17398,c,av);}
a=C_alloc(95);
if(C_truep(C_i_cplxnump(t2))){
t3=C_u_i_cplxnum_real(t2);
t4=C_u_i_cplxnum_imag(t2);
t5=C_s_a_i_times(&a,2,t3,t3);
t6=C_s_a_i_times(&a,2,t4,t4);
t7=C_s_a_i_plus(&a,2,t5,t6);
/* library.scm:2330: scheme#sqrt */
t8=*((C_word*)lf[617]+1);{
C_word *av2=av;
av2[0]=t8;
av2[1]=t1;
av2[2]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(3,av2);}}
else{
if(C_truep(C_i_numberp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_i_abs(&a,1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* library.scm:2332: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[440]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[440]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[618];
tp(4,av2);}}}}

/* ratnum in k12556 in k11433 */
static C_word f_17442(C_word *a,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_stack_overflow_check;{}
switch(t2){
case C_fix(1):
return(t1);
case C_fix(-1):
return(C_s_a_u_i_integer_negate(&a,1,t1));
default:
if(C_truep(C_i_negativep(t2))){
t3=C_s_a_u_i_integer_negate(&a,1,t1);
t4=C_s_a_u_i_integer_negate(&a,1,t2);
return(C_a_i_ratnum(&a,2,t3,t4));}
else{
return(C_a_i_ratnum(&a,2,t1,t2));}}}

/* scheme#numerator in k12556 in k11433 */
static void C_ccall f_17488(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_17488,c,av);}
a=C_alloc(6);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
if(C_truep(C_i_not(C_i_finitep(t2)))){
/* library.scm:2352: ##sys#error-bad-inexact */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[441]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[441]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[621];
tp(4,av2);}}
else{
if(C_truep(C_u_i_fpintegerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17512,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17516,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2354: scheme#inexact->exact */
t5=*((C_word*)lf[622]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_u_i_ratnum_num(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* library.scm:2356: ##sys#signal-hook */
t3=*((C_word*)lf[235]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=lf[295];
av2[3]=lf[621];
av2[4]=lf[623];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}}}}

/* k17510 in scheme#numerator in k12556 in k11433 */
static void C_ccall f_17512(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,1)))){
C_save_and_reclaim((void *)f_17512,c,av);}
a=C_alloc(11);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_exact_to_inexact(&a,1,t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k17514 in scheme#numerator in k12556 in k11433 */
static void C_ccall f_17516(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_17516,c,av);}
/* library.scm:2354: scheme#numerator */
t2=*((C_word*)lf[620]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* scheme#denominator in k12556 in k11433 */
static void C_ccall f_17534(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_17534,c,av);}
a=C_alloc(6);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_fix(1);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
if(C_truep(C_i_not(C_i_finitep(t2)))){
/* library.scm:2364: ##sys#error-bad-inexact */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[441]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[441]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[625];
tp(4,av2);}}
else{
if(C_truep(C_u_i_fpintegerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=lf[626];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17558,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17562,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2366: scheme#inexact->exact */
t5=*((C_word*)lf[622]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_u_i_ratnum_denom(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* library.scm:2368: ##sys#signal-hook */
t3=*((C_word*)lf[235]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=lf[295];
av2[3]=lf[621];
av2[4]=lf[627];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}}}}

/* k17556 in scheme#denominator in k12556 in k11433 */
static void C_ccall f_17558(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,1)))){
C_save_and_reclaim((void *)f_17558,c,av);}
a=C_alloc(11);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_exact_to_inexact(&a,1,t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k17560 in scheme#denominator in k12556 in k11433 */
static void C_ccall f_17562(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_17562,c,av);}
/* library.scm:2366: scheme#denominator */
t2=*((C_word*)lf[624]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* ##sys#extended-signum in k12556 in k11433 */
static void C_ccall f_17580(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(26,c,3)))){
C_save_and_reclaim((void *)f_17580,c,av);}
a=C_alloc(26);
if(C_truep(C_i_ratnump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_u_i_integer_signum(C_u_i_ratnum_num(t2));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_cplxnump(t2))){
t3=C_u_i_cplxnum_imag(t2);
t4=C_a_i_exact_to_inexact(&a,1,t3);
t5=C_u_i_cplxnum_real(t2);
t6=C_a_i_exact_to_inexact(&a,1,t5);
t7=C_flonum(&a,C_atan2(C_flonum_magnitude(t4),C_flonum_magnitude(t6)));
/* library.scm:2375: scheme#make-polar */
t8=*((C_word*)lf[608]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t8;
av2[1]=t1;
av2[2]=C_fix(1);
av2[3]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(4,av2);}}
else{
/* library.scm:2376: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[440]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[440]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[629];
tp(4,av2);}}}}

/* doloop2867 in deliver in scheme#inexact->exact in k12556 in k11433 */
static void f_17621(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_17621,4,t0,t1,t2,t3);}
a=C_alloc(5);
if(C_truep(C_u_i_fpintegerp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17632,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2384: chicken.flonum#fp* */
t5=*((C_word*)lf[530]+1);{
C_word av2[4];
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[633];
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}}

/* k17630 in doloop2867 in deliver in scheme#inexact->exact in k12556 in k11433 */
static void C_ccall f_17632(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_17632,c,av);}
t2=((C_word*)((C_word*)t0)[2])[1];
f_17621(t2,((C_word*)t0)[3],t1,C_fixnum_plus(((C_word*)t0)[4],C_fix(1)));}

/* deliver in scheme#inexact->exact in k12556 in k11433 */
static void f_17638(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(16,0,4)))){
C_save_and_reclaim_args((void *)trf_17638,4,t0,t1,t2,t3);}
a=C_alloc(16);
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_17642,a[2]=t2,a[3]=t1,a[4]=t3,a[5]=C_SCHEME_UNDEFINED,a[6]=((C_word*)t0)[2],tmp=(C_word)a,a+=7,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17673,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=C_set_block_item(t7,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17621,a[2]=t7,a[3]=((C_word)li458),tmp=(C_word)a,a+=4,tmp));
t9=((C_word*)t7)[1];
f_17621(t9,t5,t2,C_fix(0));}

/* k17640 in deliver in scheme#inexact->exact in k12556 in k11433 */
static void C_ccall f_17642(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_17642,c,av);}
a=C_alloc(3);
t2=C_mutate(((C_word *)t0)+5,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17669,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2390: scheme#exact->inexact */
t4=*((C_word*)lf[86]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k17654 in k17667 in k17640 in deliver in scheme#inexact->exact in k12556 in k11433 */
static void C_ccall f_17656(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_17656,c,av);}
/* library.scm:2392: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[630]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[630]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=((C_word*)t0)[3];
tp(4,av2);}}

/* k17667 in k17640 in deliver in scheme#inexact->exact in k12556 in k11433 */
static void C_ccall f_17669(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(42,c,3)))){
C_save_and_reclaim((void *)f_17669,c,av);}
a=C_alloc(42);
t2=((C_word*)t0)[2];
t3=C_s_a_i_times(&a,2,((C_word*)t2)[2],t1);
if(C_truep(C_i_finitep(t3))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17656,a[2]=((C_word*)t2)[3],a[3]=((C_word*)t2)[4],tmp=(C_word)a,a+=4,tmp);
t5=C_s_a_u_i_flo_to_int(&a,1,t3);
/* library.scm:2392: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[630]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[630]+1);
av2[1]=t4;
av2[2]=t5;
av2[3]=((C_word*)t2)[5];
tp(4,av2);}}
else{
/* library.scm:2393: ##sys#error-bad-inexact */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[441]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[441]+1);
av2[1]=((C_word*)t2)[3];
av2[2]=((C_word*)t2)[6];
av2[3]=lf[631];
tp(4,av2);}}}

/* k17671 in deliver in scheme#inexact->exact in k12556 in k11433 */
static void C_ccall f_17673(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_17673,c,av);}
/* library.scm:2389: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[632]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[632]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=C_fix(2);
av2[3]=t1;
tp(4,av2);}}

/* k17688 in k17692 in k17698 in scheme#inexact->exact in k12556 in k11433 */
static void C_ccall f_17690(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_17690,c,av);}
/* library.scm:2397: deliver */
t2=((C_word*)t0)[2];
f_17638(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k17692 in k17698 in scheme#inexact->exact in k12556 in k11433 */
static void C_ccall f_17694(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(38,c,3)))){
C_save_and_reclaim((void *)f_17694,c,av);}
a=C_alloc(38);
t2=((C_word*)t0)[2];
t3=C_s_a_i_times(&a,2,((C_word*)t2)[2],t1);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17690,a[2]=((C_word*)t2)[3],a[3]=((C_word*)t2)[4],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2400: ##sys#integer-power */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[632]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[632]+1);
av2[1]=t4;
av2[2]=C_fix(2);
av2[3]=*((C_word*)lf[520]+1);
tp(4,av2);}}

/* k17698 in scheme#inexact->exact in k12556 in k11433 */
static void C_ccall f_17700(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_17700,c,av);}
a=C_alloc(3);
t2=(C_truep(t1)?C_ub_i_flonum_greaterp(C_flonum_magnitude(((C_word*)t0)[2]),(double)-1.0):C_SCHEME_FALSE);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17694,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2397: scheme#expt */
t4=*((C_word*)lf[634]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[633];
av2[3]=*((C_word*)lf[520]+1);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}
else{
/* library.scm:2401: deliver */
t3=((C_word*)t0)[3];
f_17638(t3,((C_word*)t0)[4],((C_word*)t0)[2],C_fix(1));}}

/* scheme#inexact->exact in k12556 in k11433 */
static void C_ccall f_17704(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,4)))){
C_save_and_reclaim((void *)f_17704,c,av);}
a=C_alloc(9);
if(C_truep(C_i_exactp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
if(C_truep(C_u_i_fpintegerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_u_i_flo_to_int(&a,1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_u_i_flonum_finitep(t2))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17638,a[2]=t2,a[3]=((C_word)li459),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17700,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2395: chicken.flonum#fp< */
t5=*((C_word*)lf[544]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[626];
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}
else{
/* library.scm:2409: ##sys#error-bad-inexact */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[441]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[441]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[631];
tp(4,av2);}}}}
else{
if(C_truep(C_i_cplxnump(t2))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17744,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2411: scheme#inexact->exact */
t4=*((C_word*)lf[622]+1);{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
av2[2]=C_u_i_cplxnum_real(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}
else{
/* library.scm:2413: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[440]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[440]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[631];
tp(4,av2);}}}}}

/* k17742 in scheme#inexact->exact in k12556 in k11433 */
static void C_ccall f_17744(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_17744,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17748,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2412: scheme#inexact->exact */
t3=*((C_word*)lf[622]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=C_u_i_cplxnum_imag(((C_word*)t0)[3]);
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k17746 in k17742 in scheme#inexact->exact in k12556 in k11433 */
static void C_ccall f_17748(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_17748,c,av);}
/* library.scm:2411: make-complex */
f_17262(((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* chicken.bitwise#bitwise-not in k12556 in k11433 */
static void C_ccall f_17768(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_17768,c,av);}
a=C_alloc(5);
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_i_bitwise_not(&a,1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.bitwise#bit->boolean in k12556 in k11433 */
static void C_ccall f_17771(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17771,c,av);}
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_bit_to_bool(t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.bitwise#integer-length in k12556 in k11433 */
static void C_ccall f_17774(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_17774,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_integer_length(t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.bitwise#arithmetic-shift in k12556 in k11433 */
static void C_ccall f_17777(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,1)))){
C_save_and_reclaim((void *)f_17777,c,av);}
a=C_alloc(5);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_s_a_i_arithmetic_shift(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* scheme#/ in k12556 in k11433 */
static void C_ccall f_17780(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +4,c,3)))){
C_save_and_reclaim((void*)f_17780,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+4);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
if(C_truep(C_rest_nullp(c,3))){
/* library.scm:2445: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[630]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[630]+1);
av2[1]=t1;
av2[2]=C_fix(1);
av2[3]=t2;
tp(4,av2);}}
else{
t4=C_slot(t3,C_fix(1));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17801,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2447: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[630]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[630]+1);
av2[1]=t5;
av2[2]=t2;
av2[3]=C_slot(t3,C_fix(0));
tp(4,av2);}}}

/* k17799 in scheme#/ in k12556 in k11433 */
static void C_ccall f_17801(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_17801,c,av);}
a=C_alloc(6);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17803,a[2]=t3,a[3]=((C_word)li468),tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_17803(t5,((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* loop in k17799 in scheme#/ in k12556 in k11433 */
static void f_17803(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_17803,4,t0,t1,t2,t3);}
a=C_alloc(5);
if(C_truep(C_i_nullp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_slot(t2,C_fix(1));
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17821,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2451: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[630]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[630]+1);
av2[1]=t5;
av2[2]=t3;
av2[3]=C_slot(t2,C_fix(0));
tp(4,av2);}}}

/* k17819 in loop in k17799 in scheme#/ in k12556 in k11433 */
static void C_ccall f_17821(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_17821,c,av);}
/* library.scm:2450: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_17803(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* ##sys#/-2 in k12556 in k11433 */
static void C_ccall f_17831(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_17831,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_17835,a[2]=t2,a[3]=t3,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t5=C_eqp(t3,C_fix(0));
if(C_truep(t5)){
t6=C_fix((C_word)C_DIVISION_BY_ZERO_ERROR);
/* library.scm:2458: ##sys#error-hook */
{C_proc tp=(C_proc)C_fast_retrieve_symbol_proc(lf[439]);
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[439]+1);
av2[1]=t4;
av2[2]=t6;
av2[3]=lf[645];
av2[4]=t2;
av2[5]=t3;
tp(6,av2);}}
else{
t6=t4;{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_SCHEME_UNDEFINED;
f_17835(2,av2);}}}

/* k17833 in ##sys#/-2 in k12556 in k11433 */
static void C_ccall f_17835(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(117,c,4)))){
C_save_and_reclaim((void *)f_17835,c,av);}
a=C_alloc(117);
t2=(C_truep(C_i_exact_integerp(((C_word*)t0)[2]))?C_i_exact_integerp(((C_word*)t0)[3]):C_SCHEME_FALSE);
if(C_truep(t2)){
t3=C_s_a_u_i_integer_gcd(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t4=C_s_a_u_i_integer_quotient(&a,2,((C_word*)t0)[2],t3);
t5=C_s_a_u_i_integer_quotient(&a,2,((C_word*)t0)[3],t3);
/* library.scm:2461: ratnum */
t6=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t6;
av2[1]=(
/* library.scm:2461: ratnum */
  f_17442(C_a_i(&a,21),t4,t5)
);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t3=C_i_cplxnump(((C_word*)t0)[2]);
t4=(C_truep(t3)?t3:C_i_cplxnump(((C_word*)t0)[3]));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17873,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2464: scheme#real-part */
t6=*((C_word*)lf[610]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
t5=C_i_flonump(((C_word*)t0)[2]);
t6=(C_truep(t5)?t5:C_i_flonump(((C_word*)t0)[3]));
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17939,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2472: scheme#exact->inexact */
t8=*((C_word*)lf[86]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t8;
av2[1]=t7;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t8+1)))(3,av2);}}
else{
if(C_truep(C_i_ratnump(((C_word*)t0)[2]))){
if(C_truep(C_i_ratnump(((C_word*)t0)[3]))){
t7=C_u_i_ratnum_num(((C_word*)t0)[2]);
t8=C_u_i_ratnum_denom(((C_word*)t0)[2]);
t9=C_u_i_ratnum_num(((C_word*)t0)[3]);
t10=C_u_i_ratnum_denom(((C_word*)t0)[3]);
t11=C_s_a_u_i_integer_gcd(&a,2,t7,t9);
t12=C_s_a_u_i_integer_gcd(&a,2,t8,t10);
t13=C_s_a_i_quotient(&a,2,t7,t11);
t14=C_s_a_i_quotient(&a,2,t10,t12);
t15=C_s_a_i_times(&a,2,t13,t14);
t16=C_s_a_i_quotient(&a,2,t8,t12);
t17=C_s_a_i_quotient(&a,2,t9,t11);
t18=C_s_a_i_times(&a,2,t16,t17);
/* library.scm:2482: ratnum */
t19=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t19;
av2[1]=(
/* library.scm:2482: ratnum */
  f_17442(C_a_i(&a,21),t15,t18)
);
((C_proc)(void*)(*((C_word*)t19+1)))(2,av2);}}
else{
t7=C_u_i_ratnum_num(((C_word*)t0)[2]);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18020,a[2]=t7,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* library.scm:2488: ##sys#internal-gcd */
f_19858(t8,lf[645],t7,((C_word*)t0)[3]);}}
else{
if(C_truep(C_i_ratnump(((C_word*)t0)[3]))){
t7=C_u_i_ratnum_num(((C_word*)t0)[3]);
t8=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18059,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t7,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* library.scm:2499: ##sys#internal-gcd */
f_19858(t8,lf[645],((C_word*)t0)[2],t7);}
else{
t7=C_i_numberp(((C_word*)t0)[2]);
if(C_truep(C_i_not(t7))){
/* library.scm:2505: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[440]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[440]+1);
av2[1]=((C_word*)t0)[4];
av2[2]=((C_word*)t0)[2];
av2[3]=lf[645];
tp(4,av2);}}
else{
/* library.scm:2506: ##sys#error-bad-number */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[440]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[440]+1);
av2[1]=((C_word*)t0)[4];
av2[2]=((C_word*)t0)[3];
av2[3]=lf[645];
tp(4,av2);}}}}}}}}

/* k17871 in k17833 in ##sys#/-2 in k12556 in k11433 */
static void C_ccall f_17873(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_17873,c,av);}
a=C_alloc(6);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_17876,a[2]=((C_word*)t2)[4],a[3]=C_SCHEME_UNDEFINED,a[4]=t1,a[5]=((C_word*)t2)[3],tmp=(C_word)a,a+=6,tmp);
/* library.scm:2464: scheme#imag-part */
t4=*((C_word*)lf[612]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t2)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k17874 in k17871 in k17833 in ##sys#/-2 in k12556 in k11433 */
static void C_ccall f_17876(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_17876,c,av);}
a=C_alloc(3);
t2=C_mutate(((C_word *)t0)+3,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17879,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2465: scheme#real-part */
t4=*((C_word*)lf[610]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k17877 in k17874 in k17871 in k17833 in ##sys#/-2 in k12556 in k11433 */
static void C_ccall f_17879(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,2)))){
C_save_and_reclaim((void *)f_17879,c,av);}
a=C_alloc(8);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_17882,a[2]=((C_word*)t2)[2],a[3]=((C_word*)t2)[3],a[4]=t1,a[5]=((C_word*)t2)[4],a[6]=C_SCHEME_UNDEFINED,a[7]=C_SCHEME_UNDEFINED,tmp=(C_word)a,a+=8,tmp);
/* library.scm:2465: scheme#imag-part */
t4=*((C_word*)lf[612]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t2)[5];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k17880 in k17877 in k17874 in k17871 in k17833 in ##sys#/-2 in k12556 in k11433 */
static void C_ccall f_17882(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(193,c,3)))){
C_save_and_reclaim((void *)f_17882,c,av);}
a=C_alloc(193);
t2=C_mutate(((C_word *)t0)+6,t1);
t3=C_s_a_i_times(&a,2,((C_word*)t0)[4],((C_word*)t0)[4]);
t4=C_s_a_i_times(&a,2,((C_word*)t0)[6],((C_word*)t0)[6]);
t5=C_s_a_i_plus(&a,2,t3,t4);
t6=C_mutate(((C_word *)t0)+7,t5);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_17888,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t8=C_s_a_i_times(&a,2,((C_word*)t0)[5],((C_word*)t0)[4]);
t9=C_s_a_i_times(&a,2,((C_word*)t0)[3],((C_word*)t0)[6]);
t10=C_s_a_i_plus(&a,2,t8,t9);
/* library.scm:2467: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[630]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[630]+1);
av2[1]=t7;
av2[2]=t10;
av2[3]=((C_word*)t0)[7];
tp(4,av2);}}

/* k17886 in k17880 in k17877 in k17874 in k17871 in k17833 in ##sys#/-2 in k12556 in k11433 */
static void C_ccall f_17888(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(99,c,3)))){
C_save_and_reclaim((void *)f_17888,c,av);}
a=C_alloc(99);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17891,a[2]=((C_word*)t2)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=C_s_a_i_times(&a,2,((C_word*)t2)[3],((C_word*)t2)[4]);
t5=C_s_a_i_times(&a,2,((C_word*)t2)[5],((C_word*)t2)[6]);
t6=C_s_a_i_minus(&a,2,t4,t5);
/* library.scm:2468: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[630]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[630]+1);
av2[1]=t3;
av2[2]=t6;
av2[3]=((C_word*)t2)[7];
tp(4,av2);}}

/* k17889 in k17886 in k17880 in k17877 in k17874 in k17871 in k17833 in ##sys#/-2 in k12556 in k11433 */
static void C_ccall f_17891(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_17891,c,av);}
/* library.scm:2469: make-complex */
f_17262(((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* k17937 in k17833 in ##sys#/-2 in k12556 in k11433 */
static void C_ccall f_17939(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_17939,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_17943,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2472: scheme#exact->inexact */
t3=*((C_word*)lf[86]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k17941 in k17937 in k17833 in ##sys#/-2 in k12556 in k11433 */
static void C_ccall f_17943(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_17943,c,av);}
/* library.scm:2472: chicken.flonum#fp/ */
t2=*((C_word*)lf[532]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* k18018 in k17833 in ##sys#/-2 in k12556 in k11433 */
static void C_ccall f_18020(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(64,c,3)))){
C_save_and_reclaim((void *)f_18020,c,av);}
a=C_alloc(64);
t2=C_s_a_i_quotient(&a,2,((C_word*)t0)[2],t1);
t3=C_u_i_ratnum_denom(((C_word*)t0)[3]);
t4=C_s_a_i_quotient(&a,2,((C_word*)t0)[4],t1);
t5=C_s_a_i_times(&a,2,t3,t4);
if(C_truep(C_i_flonump(t5))){
/* library.scm:2492: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[630]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[630]+1);
av2[1]=((C_word*)t0)[5];
av2[2]=t2;
av2[3]=t5;
tp(4,av2);}}
else{
/* library.scm:2493: ratnum */
t6=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t6;
av2[1]=(
/* library.scm:2493: ratnum */
  f_17442(C_a_i(&a,21),t2,t5)
);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k18057 in k17833 in ##sys#/-2 in k12556 in k11433 */
static void C_ccall f_18059(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(64,c,3)))){
C_save_and_reclaim((void *)f_18059,c,av);}
a=C_alloc(64);
t2=C_s_a_i_quotient(&a,2,((C_word*)t0)[2],t1);
t3=C_u_i_ratnum_denom(((C_word*)t0)[3]);
t4=C_s_a_i_times(&a,2,t2,t3);
t5=C_s_a_i_quotient(&a,2,((C_word*)t0)[4],t1);
if(C_truep(C_i_flonump(t5))){
/* library.scm:2503: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[630]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[630]+1);
av2[1]=((C_word*)t0)[5];
av2[2]=t4;
av2[3]=t5;
tp(4,av2);}}
else{
/* library.scm:2504: ratnum */
t6=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t6;
av2[1]=(
/* library.scm:2504: ratnum */
  f_17442(C_a_i(&a,21),t4,t5)
);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* scheme#floor in k12556 in k11433 */
static void C_ccall f_18114(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(34,c,3)))){
C_save_and_reclaim((void *)f_18114,c,av);}
a=C_alloc(34);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
/* library.scm:2511: chicken.flonum#fpfloor */
t3=*((C_word*)lf[556]+1);{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=C_u_i_ratnum_num(t2);
t4=C_u_i_ratnum_denom(t2);
t5=C_s_a_i_quotient(&a,2,t3,t4);
t6=C_i_greater_or_equalp(t3,C_fix(0));
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?t5:C_s_a_i_minus(&a,2,t5,C_fix(1)));
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
/* library.scm:2516: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[429]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[429]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[647];
tp(4,av2);}}}}}

/* scheme#ceiling in k12556 in k11433 */
static void C_ccall f_18159(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(34,c,3)))){
C_save_and_reclaim((void *)f_18159,c,av);}
a=C_alloc(34);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
/* library.scm:2521: chicken.flonum#fpceiling */
t3=*((C_word*)lf[562]+1);{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=C_u_i_ratnum_num(t2);
t4=C_u_i_ratnum_denom(t2);
t5=C_s_a_i_quotient(&a,2,t3,t4);
t6=C_i_greater_or_equalp(t3,C_fix(0));
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=(C_truep(t6)?C_s_a_i_plus(&a,2,t5,C_fix(1)):t5);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
/* library.scm:2526: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[429]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[429]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[649];
tp(4,av2);}}}}}

/* scheme#truncate in k12556 in k11433 */
static void C_ccall f_18204(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_18204,c,av);}
a=C_alloc(5);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
/* library.scm:2531: chicken.flonum#fptruncate */
t3=*((C_word*)lf[558]+1);{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=C_u_i_ratnum_num(t2);
t4=C_u_i_ratnum_denom(t2);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_s_a_i_quotient(&a,2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
/* library.scm:2535: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[429]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[429]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[651];
tp(4,av2);}}}}}

/* scheme#round in k12556 in k11433 */
static void C_ccall f_18241(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(36,c,3)))){
C_save_and_reclaim((void *)f_18241,c,av);}
a=C_alloc(36);
if(C_truep(C_i_exact_integerp(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_flonump(t2))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_flonum_round_proper(&a,1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_ratnump(t2))){
t3=C_a_i_ratnum(&a,2,C_fix(1),C_fix(2));
t4=C_s_a_i_plus(&a,2,t2,t3);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18261,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2544: scheme#floor */
t6=*((C_word*)lf[646]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
/* library.scm:2546: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[429]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[429]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[653];
tp(4,av2);}}}}}

/* k18259 in scheme#round in k12556 in k11433 */
static void C_ccall f_18261(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,1)))){
C_save_and_reclaim((void *)f_18261,c,av);}
a=C_alloc(29);
t2=C_i_nequalp(t1,((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=(C_truep(t2)?(C_truep(C_i_oddp(t1))?C_s_a_i_minus(&a,2,t1,C_fix(1)):t1):t1);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* find-ratio-between in k12556 in k11433 */
static void f_18285(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(67,0,4)))){
C_save_and_reclaim_args((void *)trf_18285,3,t1,t2,t3);}
a=C_alloc(67);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18288,a[2]=t5,a[3]=((C_word)li475),tmp=(C_word)a,a+=4,tmp));
if(C_truep(C_i_lessp(t3,t2))){
/* library.scm:2559: find-ratio-between */
t12=t1;
t13=t3;
t14=t2;
t1=t12;
t2=t13;
t3=t14;
goto loop;}
else{
t7=C_i_lessp(t2,t3);
if(C_truep(C_i_not(t7))){
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=C_a_i_list2(&a,2,t2,C_fix(1));
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
if(C_truep(C_i_positivep(t2))){
/* library.scm:2561: sr */
t8=((C_word*)t5)[1];
f_18288(t8,t1,t2,t3);}
else{
if(C_truep(C_i_negativep(t3))){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18399,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t9=C_s_a_i_negate(&a,1,t3);
t10=C_s_a_i_negate(&a,1,t2);
/* library.scm:2562: sr */
t11=((C_word*)t5)[1];
f_18288(t11,t8,t9,t10);}
else{
t8=t1;{
C_word av2[2];
av2[0]=t8;
av2[1]=lf[655];
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}}}}

/* sr in find-ratio-between in k12556 in k11433 */
static void f_18288(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,0,2)))){
C_save_and_reclaim_args((void *)trf_18288,4,t0,t1,t2,t3);}
a=C_alloc(9);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18292,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18367,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2550: scheme#floor */
t6=*((C_word*)lf[646]+1);{
C_word av2[3];
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}

/* k18290 in sr in find-ratio-between in k12556 in k11433 */
static void C_ccall f_18292(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,2)))){
C_save_and_reclaim((void *)f_18292,c,av);}
a=C_alloc(10);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_18295,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18363,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2551: scheme#floor */
t4=*((C_word*)lf[646]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k18293 in k18290 in sr in find-ratio-between in k12556 in k11433 */
static void C_ccall f_18295(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(39,c,3)))){
C_save_and_reclaim((void *)f_18295,c,av);}
a=C_alloc(39);
t2=C_i_lessp(((C_word*)t0)[2],((C_word*)t0)[3]);
if(C_truep(C_i_not(t2))){
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_a_i_list2(&a,2,((C_word*)t0)[2],C_fix(1));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_i_nequalp(((C_word*)t0)[2],t1))){
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18313,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_18336,a[2]=((C_word*)t0)[5],a[3]=t3,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
t5=C_s_a_i_minus(&a,2,((C_word*)t0)[6],t1);
/* library.scm:2554: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[630]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[630]+1);
av2[1]=t4;
av2[2]=C_fix(1);
av2[3]=t5;
tp(4,av2);}}
else{
t3=C_s_a_i_plus(&a,2,C_fix(1),((C_word*)t0)[2]);
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_list2(&a,2,t3,C_fix(1));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}}

/* k18311 in k18293 in k18290 in sr in find-ratio-between in k12556 in k11433 */
static void C_ccall f_18313(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(68,c,1)))){
C_save_and_reclaim((void *)f_18313,c,av);}
a=C_alloc(68);
t2=C_i_cadr(t1);
t3=C_u_i_car(t1);
t4=C_s_a_i_times(&a,2,((C_word*)t0)[2],t3);
t5=C_s_a_i_plus(&a,2,t2,t4);
t6=C_u_i_car(t1);
t7=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_a_i_list2(&a,2,t5,t6);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* k18334 in k18293 in k18290 in sr in find-ratio-between in k12556 in k11433 */
static void C_ccall f_18336(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(34,c,3)))){
C_save_and_reclaim((void *)f_18336,c,av);}
a=C_alloc(34);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18340,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t3=C_s_a_i_minus(&a,2,((C_word*)t0)[4],((C_word*)t0)[5]);
/* library.scm:2555: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[630]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[630]+1);
av2[1]=t2;
av2[2]=C_fix(1);
av2[3]=t3;
tp(4,av2);}}

/* k18338 in k18334 in k18293 in k18290 in sr in find-ratio-between in k12556 in k11433 */
static void C_ccall f_18340(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_18340,c,av);}
/* library.scm:2554: sr */
t2=((C_word*)((C_word*)t0)[2])[1];
f_18288(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k18361 in k18290 in sr in find-ratio-between in k12556 in k11433 */
static void C_ccall f_18363(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_18363,c,av);}
/* library.scm:2551: scheme#inexact->exact */
t2=*((C_word*)lf[622]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* k18365 in sr in find-ratio-between in k12556 in k11433 */
static void C_ccall f_18367(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_18367,c,av);}
/* library.scm:2550: scheme#inexact->exact */
t2=*((C_word*)lf[622]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* k18397 in find-ratio-between in k12556 in k11433 */
static void C_ccall f_18399(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(35,c,1)))){
C_save_and_reclaim((void *)f_18399,c,av);}
a=C_alloc(35);
t2=C_i_car(t1);
t3=C_s_a_i_negate(&a,1,t2);
t4=C_i_cadr(t1);
t5=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_a_i_list2(&a,2,t3,t4);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* scheme#rationalize in k12556 in k11433 */
static void C_ccall f_18435(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(66,c,3)))){
C_save_and_reclaim((void *)f_18435,c,av);}
a=C_alloc(66);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18439,a[2]=t2,a[3]=t1,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18458,a[2]=t4,tmp=(C_word)a,a+=3,tmp);
t6=C_s_a_i_minus(&a,2,t2,t3);
t7=C_s_a_i_plus(&a,2,t2,t3);
/* library.scm:2566: find-ratio-between */
f_18285(t5,t6,t7);}

/* k18437 in scheme#rationalize in k12556 in k11433 */
static void C_ccall f_18439(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_18439,c,av);}
t2=C_i_inexactp(((C_word*)t0)[2]);
if(C_truep(t2)){
if(C_truep(t2)){
/* library.scm:2572: scheme#exact->inexact */
t3=*((C_word*)lf[86]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}
else{
if(C_truep(C_i_inexactp(((C_word*)t0)[4]))){
/* library.scm:2572: scheme#exact->inexact */
t3=*((C_word*)lf[86]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}}

/* k18456 in scheme#rationalize in k12556 in k11433 */
static void C_ccall f_18458(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_18458,c,av);}{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=*((C_word*)lf[630]+1);
av2[3]=t1;
C_apply(4,av2);}}

/* scheme#max in k12556 in k11433 */
static void C_ccall f_18460(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +6,c,5)))){
C_save_and_reclaim((void*)f_18460,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+6);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
t4=C_i_flonump(t2);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18467,a[2]=t6,a[3]=((C_word)li478),tmp=(C_word)a,a+=4,tmp));
t8=((C_word*)t6)[1];
f_18467(t8,t1,t4,t2,t3);}

/* loop in scheme#max in k12556 in k11433 */
static void f_18467(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(11,0,4)))){
C_save_and_reclaim_args((void *)trf_18467,5,t0,t1,t2,t3,t4);}
a=C_alloc(11);
t5=C_i_check_number_2(t3,lf[658]);
if(C_truep(C_i_nullp(t4))){
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=(C_truep(t2)?C_a_i_exact_to_inexact(&a,1,t3):t3);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_slot(t4,C_fix(0));
t7=(C_truep(t2)?t2:C_i_flonump(t6));
t8=C_i_greaterp(t6,t3);
t9=(C_truep(t8)?t6:t3);
/* library.scm:2582: loop */
t11=t1;
t12=t7;
t13=t9;
t14=C_slot(t4,C_fix(1));
t1=t11;
t2=t12;
t3=t13;
t4=t14;
goto loop;}}

/* scheme#min in k12556 in k11433 */
static void C_ccall f_18504(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +6,c,5)))){
C_save_and_reclaim((void*)f_18504,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+6);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
t4=C_i_flonump(t2);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18511,a[2]=t6,a[3]=((C_word)li480),tmp=(C_word)a,a+=4,tmp));
t8=((C_word*)t6)[1];
f_18511(t8,t1,t4,t2,t3);}

/* loop in scheme#min in k12556 in k11433 */
static void f_18511(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(11,0,4)))){
C_save_and_reclaim_args((void *)trf_18511,5,t0,t1,t2,t3,t4);}
a=C_alloc(11);
t5=C_i_check_number_2(t3,lf[659]);
if(C_truep(C_i_nullp(t4))){
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=(C_truep(t2)?C_a_i_exact_to_inexact(&a,1,t3):t3);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_slot(t4,C_fix(0));
t7=(C_truep(t2)?t2:C_i_flonump(t6));
t8=C_i_lessp(t6,t3);
t9=(C_truep(t8)?t6:t3);
/* library.scm:2593: loop */
t11=t1;
t12=t7;
t13=t9;
t14=C_slot(t4,C_fix(1));
t1=t11;
t2=t12;
t3=t13;
t4=t14;
goto loop;}}

/* scheme#exp in k12556 in k11433 */
static void C_ccall f_18548(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(15,c,2)))){
C_save_and_reclaim((void *)f_18548,c,av);}
a=C_alloc(15);
t3=C_i_check_number_2(t2,lf[661]);
if(C_truep(C_i_cplxnump(t2))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18566,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2602: scheme#exact->inexact */
t5=*((C_word*)lf[86]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=C_u_i_cplxnum_real(t2);
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}
else{
t4=C_a_i_exact_to_inexact(&a,1,t2);
t5=C_flonum(&a,C_exp(C_flonum_magnitude(t4)));
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k18564 in scheme#exp in k12556 in k11433 */
static void C_ccall f_18566(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,c,2)))){
C_save_and_reclaim((void *)f_18566,c,av);}
a=C_alloc(12);
t2=C_a_i_exp(&a,1,t1);
t3=C_u_i_cplxnum_imag(((C_word*)t0)[2]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18575,a[2]=((C_word*)t0)[3],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18580,a[2]=t3,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2605: scheme#exact->inexact */
t6=*((C_word*)lf[86]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=t3;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}

/* k18573 in k18564 in scheme#exp in k12556 in k11433 */
static void C_ccall f_18575(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,1)))){
C_save_and_reclaim((void *)f_18575,c,av);}
a=C_alloc(33);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_s_a_i_times(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k18578 in k18564 in scheme#exp in k12556 in k11433 */
static void C_ccall f_18580(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(19,c,3)))){
C_save_and_reclaim((void *)f_18580,c,av);}
a=C_alloc(19);
t2=C_a_i_cos(&a,1,t1);
t3=C_a_i_exact_to_inexact(&a,1,((C_word*)t0)[2]);
t4=C_a_i_sin(&a,1,t3);
/* library.scm:2604: make-complex */
f_17262(((C_word*)t0)[3],t2,t4);}

/* ##sys#log-1 in k12556 in k11433 */
static void C_ccall f_18593(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,5)))){
C_save_and_reclaim((void *)f_18593,c,av);}
a=C_alloc(8);
t3=C_eqp(t2,C_fix(0));
if(C_truep(t3)){
/* library.scm:2612: ##sys#signal-hook */
t4=*((C_word*)lf[235]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t1;
av2[2]=lf[663];
av2[3]=lf[664];
av2[4]=lf[665];
av2[5]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(6,av2);}}
else{
t4=C_i_cplxnump(t2);
t5=(C_truep(t4)?t4:C_i_negativep(t2));
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18619,a[2]=t1,a[3]=C_SCHEME_UNDEFINED,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18635,a[2]=t6,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2615: scheme#magnitude */
t8=*((C_word*)lf[616]+1);{
C_word *av2=av;
av2[0]=t8;
av2[1]=t7;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t8+1)))(3,av2);}}
else{
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18639,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2618: scheme#exact->inexact */
t7=*((C_word*)lf[86]+1);{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}}}

/* k18617 in ##sys#log-1 in k12556 in k11433 */
static void C_ccall f_18619(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_18619,c,av);}
a=C_alloc(3);
t2=C_mutate(((C_word *)t0)+3,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18627,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2616: make-complex */
f_17262(t3,C_fix(0),C_fix(1));}

/* k18625 in k18617 in ##sys#log-1 in k12556 in k11433 */
static void C_ccall f_18627(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_18627,c,av);}
a=C_alloc(5);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18631,a[2]=t1,a[3]=((C_word*)t2)[2],a[4]=((C_word*)t2)[3],tmp=(C_word)a,a+=5,tmp);
/* library.scm:2616: scheme#angle */
t4=*((C_word*)lf[614]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t2)[4];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k18629 in k18625 in k18617 in ##sys#log-1 in k12556 in k11433 */
static void C_ccall f_18631(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(62,c,1)))){
C_save_and_reclaim((void *)f_18631,c,av);}
a=C_alloc(62);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],t1);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_s_a_i_plus(&a,2,((C_word*)t0)[4],t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* k18633 in ##sys#log-1 in k12556 in k11433 */
static void C_ccall f_18635(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_18635,c,av);}
/* library.scm:2615: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[662]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[662]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
tp(3,av2);}}

/* k18637 in ##sys#log-1 in k12556 in k11433 */
static void C_ccall f_18639(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_18639,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_log(&a,1,t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* scheme#log in k12556 in k11433 */
static void C_ccall f_18642(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_18642,c,av);}
a=C_alloc(4);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_get_rest_arg(c,3,av,3,t0));
if(C_truep(t4)){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18656,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2622: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[662]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[662]+1);
av2[1]=t5;
av2[2]=t2;
tp(3,av2);}}
else{
/* library.scm:2622: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[662]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[662]+1);
av2[1]=t1;
av2[2]=t2;
tp(3,av2);}}}

/* k18654 in scheme#log in k12556 in k11433 */
static void C_ccall f_18656(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_18656,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18660,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2622: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[662]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[662]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
tp(3,av2);}}

/* k18658 in k18654 in scheme#log in k12556 in k11433 */
static void C_ccall f_18660(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_18660,c,av);}
/* library.scm:2622: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[630]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[630]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
tp(4,av2);}}

/* scheme#sin in k12556 in k11433 */
static void C_ccall f_18671(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(37,c,2)))){
C_save_and_reclaim((void *)f_18671,c,av);}
a=C_alloc(37);
t3=C_i_check_number_2(t2,lf[668]);
if(C_truep(C_i_cplxnump(t2))){
t4=C_s_a_i_times(&a,2,lf[669],t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18695,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2629: scheme#exp */
t6=*((C_word*)lf[660]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
t4=C_a_i_exact_to_inexact(&a,1,t2);
t5=C_a_i_sin(&a,1,t4);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k18693 in scheme#sin in k12556 in k11433 */
static void C_ccall f_18695(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,2)))){
C_save_and_reclaim((void *)f_18695,c,av);}
a=C_alloc(33);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18699,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=C_s_a_i_negate(&a,1,((C_word*)t0)[3]);
/* library.scm:2629: scheme#exp */
t4=*((C_word*)lf[660]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t2;
av2[2]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k18697 in k18693 in scheme#sin in k12556 in k11433 */
static void C_ccall f_18699(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,3)))){
C_save_and_reclaim((void *)f_18699,c,av);}
a=C_alloc(29);
t2=C_s_a_i_minus(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2629: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[630]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[630]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
av2[3]=lf[670];
tp(4,av2);}}

/* scheme#cos in k12556 in k11433 */
static void C_ccall f_18705(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(37,c,2)))){
C_save_and_reclaim((void *)f_18705,c,av);}
a=C_alloc(37);
t3=C_i_check_number_2(t2,lf[672]);
if(C_truep(C_i_cplxnump(t2))){
t4=C_s_a_i_times(&a,2,lf[669],t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18729,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2637: scheme#exp */
t6=*((C_word*)lf[660]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
t4=C_a_i_exact_to_inexact(&a,1,t2);
t5=C_a_i_cos(&a,1,t4);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k18727 in scheme#cos in k12556 in k11433 */
static void C_ccall f_18729(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,2)))){
C_save_and_reclaim((void *)f_18729,c,av);}
a=C_alloc(33);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18733,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=C_s_a_i_negate(&a,1,((C_word*)t0)[3]);
/* library.scm:2637: scheme#exp */
t4=*((C_word*)lf[660]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t2;
av2[2]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k18731 in k18727 in scheme#cos in k12556 in k11433 */
static void C_ccall f_18733(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,3)))){
C_save_and_reclaim((void *)f_18733,c,av);}
a=C_alloc(29);
t2=C_s_a_i_plus(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2637: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[630]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[630]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
av2[3]=C_fix(2);
tp(4,av2);}}

/* scheme#tan in k12556 in k11433 */
static void C_ccall f_18739(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(15,c,2)))){
C_save_and_reclaim((void *)f_18739,c,av);}
a=C_alloc(15);
t3=C_i_check_number_2(t2,lf[674]);
if(C_truep(C_i_cplxnump(t2))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18756,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2644: scheme#sin */
t5=*((C_word*)lf[667]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}
else{
t4=C_a_i_exact_to_inexact(&a,1,t2);
t5=C_a_i_tan(&a,1,t4);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k18754 in scheme#tan in k12556 in k11433 */
static void C_ccall f_18756(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_18756,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18760,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2644: scheme#cos */
t3=*((C_word*)lf[671]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k18758 in k18754 in scheme#tan in k12556 in k11433 */
static void C_ccall f_18760(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_18760,c,av);}
/* library.scm:2644: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[630]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[630]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
tp(4,av2);}}

/* scheme#asin in k12556 in k11433 */
static void C_ccall f_18764(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_18764,c,av);}
a=C_alloc(8);
t3=C_i_check_number_2(t2,lf[676]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18774,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_flonump(t2))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18822,a[2]=t4,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2651: chicken.flonum#fp>= */
t6=*((C_word*)lf[546]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
av2[3]=lf[679];
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}
else{
t5=t4;
f_18774(t5,C_SCHEME_FALSE);}}

/* k18772 in scheme#asin in k12556 in k11433 */
static void f_18774(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_18774,2,t0,t1);}
a=C_alloc(4);
if(C_truep(t1)){
t2=C_a_i_asin(&a,1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18780,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_fixnump(((C_word*)t0)[3]))){
t3=C_fixnum_greater_or_equal_p(((C_word*)t0)[3],C_fix(-1));
t4=t2;
f_18780(t4,(C_truep(t3)?C_fixnum_less_or_equal_p(((C_word*)t0)[3],C_fix(1)):C_SCHEME_FALSE));}
else{
t3=t2;
f_18780(t3,C_SCHEME_FALSE);}}}

/* k18778 in k18772 in scheme#asin in k12556 in k11433 */
static void f_18780(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(102,0,3)))){
C_save_and_reclaim_args((void *)trf_18780,2,t0,t1);}
a=C_alloc(102);
t2=((C_word*)t0)[2];
if(C_truep(t1)){
t3=((C_word*)t2)[2];{
C_word av2[2];
av2[0]=t3;
av2[1]=C_a_i_asin(&a,1,C_a_i_fix_to_flo(&a,1,((C_word*)t2)[3]));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18787,a[2]=((C_word*)t2)[2],tmp=(C_word)a,a+=3,tmp);
t4=C_s_a_i_times(&a,2,lf[669],((C_word*)t2)[3]);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18799,a[2]=t4,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t6=C_s_a_i_times(&a,2,((C_word*)t2)[3],((C_word*)t2)[3]);
t7=C_s_a_i_minus(&a,2,C_fix(1),t6);
/* library.scm:2660: ##sys#sqrt/loc */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[678]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[678]+1);
av2[1]=t5;
av2[2]=lf[676];
av2[3]=t7;
tp(4,av2);}}}

/* k18785 in k18778 in k18772 in scheme#asin in k12556 in k11433 */
static void C_ccall f_18787(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,1)))){
C_save_and_reclaim((void *)f_18787,c,av);}
a=C_alloc(33);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_s_a_i_times(&a,2,lf[677],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k18797 in k18778 in k18772 in scheme#asin in k12556 in k11433 */
static void C_ccall f_18799(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,2)))){
C_save_and_reclaim((void *)f_18799,c,av);}
a=C_alloc(29);
t2=C_s_a_i_plus(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2658: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[662]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[662]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
tp(3,av2);}}

/* k18820 in scheme#asin in k12556 in k11433 */
static void C_ccall f_18822(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18822,c,av);}
t2=((C_word*)t0)[2];
f_18774(t2,(C_truep(t1)?C_ub_i_flonum_less_or_equal_p(C_flonum_magnitude(((C_word*)t0)[3]),(double)1.0):C_SCHEME_FALSE));}

/* scheme#acos in k12556 in k11433 */
static void C_ccall f_18826(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_18826,c,av);}
a=C_alloc(9);
t3=C_i_check_number_2(t2,lf[681]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_18836,a[2]=t1,a[3]=t2,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_flonump(t2))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18864,a[2]=t4,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2668: chicken.flonum#fp>= */
t6=*((C_word*)lf[546]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=t2;
av2[3]=lf[679];
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}
else{
t5=t4;
f_18836(t5,C_SCHEME_FALSE);}}

/* k18834 in scheme#acos in k12556 in k11433 */
static void f_18836(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_18836,2,t0,t1);}
a=C_alloc(4);
if(C_truep(t1)){
t2=C_a_i_acos(&a,1,((C_word*)t0)[3]);
t3=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_18842,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_fixnump(((C_word*)t0)[3]))){
t3=C_fixnum_greater_or_equal_p(((C_word*)t0)[3],C_fix(-1));
t4=t2;
f_18842(t4,(C_truep(t3)?C_fixnum_less_or_equal_p(((C_word*)t0)[3],C_fix(1)):C_SCHEME_FALSE));}
else{
t3=t2;
f_18842(t3,C_SCHEME_FALSE);}}}

/* k18840 in k18834 in scheme#acos in k12556 in k11433 */
static void f_18842(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,2)))){
C_save_and_reclaim_args((void *)trf_18842,2,t0,t1);}
a=C_alloc(8);
t2=((C_word*)t0)[2];
if(C_truep(t1)){
t3=((C_word*)t2)[2];{
C_word av2[2];
av2[0]=t3;
av2[1]=C_a_i_acos(&a,1,C_a_i_fix_to_flo(&a,1,((C_word*)t2)[3]));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18849,a[2]=((C_word*)t2)[2],a[3]=((C_word*)t2)[4],tmp=(C_word)a,a+=4,tmp);
/* library.scm:2675: scheme#asin */
t4=*((C_word*)lf[675]+1);{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t2)[3];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}}

/* k18847 in k18840 in k18834 in scheme#acos in k12556 in k11433 */
static void C_ccall f_18849(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,1)))){
C_save_and_reclaim((void *)f_18849,c,av);}
a=C_alloc(29);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_s_a_i_minus(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k18862 in scheme#acos in k12556 in k11433 */
static void C_ccall f_18864(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_18864,c,av);}
t2=((C_word*)t0)[2];
f_18836(t2,(C_truep(t1)?C_ub_i_flonum_less_or_equal_p(C_flonum_magnitude(((C_word*)t0)[3]),(double)1.0):C_SCHEME_FALSE));}

/* scheme#atan in k12556 in k11433 */
static void C_ccall f_18868(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(66,c,3)))){
C_save_and_reclaim((void *)f_18868,c,av);}
a=C_alloc(66);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_get_rest_arg(c,3,av,3,t0));
t5=C_i_check_number_2(t2,lf[683]);
if(C_truep(C_i_cplxnump(t2))){
if(C_truep(t4)){
/* library.scm:2682: ##sys#error-bad-real */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[429]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[429]+1);
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[683];
tp(4,av2);}}
else{
t6=C_s_a_i_times(&a,2,lf[669],t2);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18901,a[2]=t1,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
t8=C_s_a_i_plus(&a,2,C_fix(1),t6);
/* library.scm:2684: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[662]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[662]+1);
av2[1]=t7;
av2[2]=t8;
tp(3,av2);}}}
else{
if(C_truep(t4)){
t6=C_a_i_exact_to_inexact(&a,1,t2);
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18922,a[2]=t1,a[3]=t6,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2688: scheme#exact->inexact */
t8=*((C_word*)lf[86]+1);{
C_word *av2=av;
av2[0]=t8;
av2[1]=t7;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t8+1)))(3,av2);}}
else{
t6=C_a_i_exact_to_inexact(&a,1,t2);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_a_i_atan(&a,1,t6);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}}

/* k18899 in scheme#atan in k12556 in k11433 */
static void C_ccall f_18901(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,2)))){
C_save_and_reclaim((void *)f_18901,c,av);}
a=C_alloc(33);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_18905,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=C_s_a_i_minus(&a,2,C_fix(1),((C_word*)t0)[3]);
/* library.scm:2685: ##sys#log-1 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[662]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[662]+1);
av2[1]=t2;
av2[2]=t3;
tp(3,av2);}}

/* k18903 in k18899 in scheme#atan in k12556 in k11433 */
static void C_ccall f_18905(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(29,c,3)))){
C_save_and_reclaim((void *)f_18905,c,av);}
a=C_alloc(29);
t2=C_s_a_i_minus(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2684: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[630]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[630]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
av2[3]=lf[670];
tp(4,av2);}}

/* k18920 in scheme#atan in k12556 in k11433 */
static void C_ccall f_18922(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_18922,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_atan2(&a,2,((C_word*)t0)[3],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* ##sys#exact-integer-sqrt in k12556 in k11433 */
static void C_ccall f_18932(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(10,c,4)))){
C_save_and_reclaim((void *)f_18932,c,av);}
a=C_alloc(10);
t3=C_fixnump(t2);
t4=(C_truep(t3)?C_fixnum_less_or_equal_p(t2,C_fix(4)):C_SCHEME_FALSE);
if(C_truep(t4)){
t5=C_eqp(t2,C_fix(0));
t6=(C_truep(t5)?t5:C_eqp(t2,C_fix(1)));
if(C_truep(t6)){
/* library.scm:2700: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t2;
av2[3]=C_fix(0);
C_values(4,av2);}}
else{
switch(t2){
case C_fix(2):
/* library.scm:2701: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_fix(1);
av2[3]=C_fix(1);
C_values(4,av2);}
case C_fix(3):
/* library.scm:2702: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_fix(1);
av2[3]=C_fix(2);
C_values(4,av2);}
case C_fix(4):
/* library.scm:2703: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_fix(2);
av2[3]=C_fix(0);
C_values(4,av2);}
default:
/* library.scm:2704: chicken.base#error */
t7=*((C_word*)lf[234]+1);{
C_word *av2=av;
av2[0]=t7;
av2[1]=t1;
av2[2]=lf[685];
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}}}
else{
t5=C_fixnum_plus(C_i_integer_length(t2),C_fix(1));
t6=C_fixnum_shift_right(t5,C_fix(2));
t7=C_fixnum_shift_left(t6,C_fix(1));
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19005,a[2]=t7,a[3]=t2,a[4]=((C_word)li491),tmp=(C_word)a,a+=5,tmp);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19019,a[2]=t6,a[3]=t2,a[4]=((C_word)li495),tmp=(C_word)a,a+=5,tmp);
/* library.scm:2705: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t8;
av2[3]=t9;
C_call_with_values(4,av2);}}}

/* a19004 in ##sys#exact-integer-sqrt in k12556 in k11433 */
static void C_ccall f_19005(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_19005,c,av);}
a=C_alloc(5);
t2=C_fixnum_negate(((C_word*)t0)[2]);
t3=C_s_a_i_arithmetic_shift(&a,2,((C_word*)t0)[3],t2);
/* library.scm:2708: ##sys#exact-integer-sqrt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[684]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[684]+1);
av2[1]=t1;
av2[2]=t3;
tp(3,av2);}}

/* a19018 in ##sys#exact-integer-sqrt in k12556 in k11433 */
static void C_ccall f_19019(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(38,c,4)))){
C_save_and_reclaim((void *)f_19019,c,av);}
a=C_alloc(38);
t4=C_s_a_i_arithmetic_shift(&a,2,C_fix(1),((C_word*)t0)[2]);
t5=C_s_a_u_i_integer_minus(&a,2,t4,C_fix(1));
t6=C_s_a_i_bitwise_and(&a,2,((C_word*)t0)[3],t5);
t7=C_fixnum_negate(((C_word*)t0)[2]);
t8=C_s_a_i_arithmetic_shift(&a,2,((C_word*)t0)[3],t7);
t9=C_s_a_i_bitwise_and(&a,2,t8,t5);
t10=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_19036,a[2]=t3,a[3]=((C_word*)t0)[2],a[4]=t9,a[5]=t2,a[6]=((C_word)li493),tmp=(C_word)a,a+=7,tmp);
t11=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_19052,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t6,a[5]=((C_word)li494),tmp=(C_word)a,a+=6,tmp);
/* library.scm:2705: ##sys#call-with-values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t10;
av2[3]=t11;
C_call_with_values(4,av2);}}

/* a19035 in a19018 in ##sys#exact-integer-sqrt in k12556 in k11433 */
static void C_ccall f_19036(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(18,c,3)))){
C_save_and_reclaim((void *)f_19036,c,av);}
a=C_alloc(18);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_u_integer_quotient_and_remainder,a[2]=((C_word)li492),tmp=(C_word)a,a+=3,tmp);
t3=C_s_a_i_arithmetic_shift(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t4=C_s_a_u_i_integer_plus(&a,2,t3,((C_word*)t0)[4]);
t5=C_s_a_i_arithmetic_shift(&a,2,((C_word*)t0)[5],C_fix(1));
/* library.scm:2705: g3238 */
t6=t2;{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=t1;
av2[2]=t4;
av2[3]=t5;
((C_proc)C_fast_retrieve_proc(t6))(4,av2);}}

/* a19051 in a19018 in ##sys#exact-integer-sqrt in k12556 in k11433 */
static void C_ccall f_19052(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(222,c,3)))){
C_save_and_reclaim((void *)f_19052,c,av);}
a=C_alloc(222);
t4=C_s_a_i_arithmetic_shift(&a,2,((C_word*)t0)[2],((C_word*)t0)[3]);
t5=C_s_a_i_plus(&a,2,t4,t2);
t6=C_s_a_i_arithmetic_shift(&a,2,t3,((C_word*)t0)[3]);
t7=C_s_a_i_times(&a,2,t2,t2);
t8=C_s_a_i_minus(&a,2,((C_word*)t0)[4],t7);
t9=C_s_a_i_plus(&a,2,t6,t8);
if(C_truep(C_i_negativep(t9))){
t10=C_s_a_i_minus(&a,2,t5,C_fix(1));
t11=C_s_a_i_arithmetic_shift(&a,2,t5,C_fix(1));
t12=C_s_a_i_plus(&a,2,t9,t11);
t13=C_s_a_i_minus(&a,2,t12,C_fix(1));
/* library.scm:2719: scheme#values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t10;
av2[3]=t13;
C_values(4,av2);}}
else{
/* library.scm:2721: scheme#values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t5;
av2[3]=t9;
C_values(4,av2);}}}

/* scheme#exact-integer-sqrt in k12556 in k11433 */
static void C_ccall f_19123(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_19123,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19127,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* library.scm:2725: ##sys#check-exact-uinteger */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[426]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[426]+1);
av2[1]=t3;
av2[2]=t2;
av2[3]=lf[687];
tp(4,av2);}}

/* k19125 in scheme#exact-integer-sqrt in k12556 in k11433 */
static void C_ccall f_19127(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19127,c,av);}
/* library.scm:2726: ##sys#exact-integer-sqrt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[684]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[684]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
tp(3,av2);}}

/* ##sys#sqrt/loc in k12556 in k11433 */
static void C_ccall f_19132(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(32,c,4)))){
C_save_and_reclaim((void *)f_19132,c,av);}
a=C_alloc(32);
if(C_truep(C_i_cplxnump(t3))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19142,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
t5=C_u_i_cplxnum_imag(t3);
t6=C_a_i_exact_to_inexact(&a,1,t5);
t7=C_u_i_cplxnum_real(t3);
t8=C_a_i_exact_to_inexact(&a,1,t7);
t9=C_flonum(&a,C_atan2(C_flonum_magnitude(t6),C_flonum_magnitude(t8)));
/* library.scm:2732: ##sys#/-2 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[630]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[630]+1);
av2[1]=t4;
av2[2]=t9;
av2[3]=C_fix(2);
tp(4,av2);}}
else{
if(C_truep(C_i_negativep(t3))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19182,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t5=C_s_a_i_negate(&a,1,t3);
/* library.scm:2737: scheme#exact->inexact */
t6=*((C_word*)lf[86]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t4;
av2[2]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
if(C_truep(C_i_exact_integerp(t3))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19193,a[2]=t3,a[3]=((C_word)li498),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19199,a[2]=t3,a[3]=((C_word)li499),tmp=(C_word)a,a+=4,tmp);
/* library.scm:2739: ##sys#call-with-values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t4;
av2[3]=t5;
C_call_with_values(4,av2);}}
else{
if(C_truep(C_i_ratnump(t3))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_19221,a[2]=t3,a[3]=((C_word)li500),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19233,a[2]=t3,a[3]=t2,a[4]=((C_word)li503),tmp=(C_word)a,a+=5,tmp);
/* library.scm:2744: ##sys#call-with-values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=t4;
av2[3]=t5;
C_call_with_values(4,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19285,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2752: scheme#exact->inexact */
t5=*((C_word*)lf[86]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t3;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}}}}}

/* k19140 in ##sys#sqrt/loc in k12556 in k11433 */
static void C_ccall f_19142(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_19142,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19146,a[2]=C_SCHEME_UNDEFINED,a[3]=((C_word*)t0)[2],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2733: scheme#magnitude */
t3=*((C_word*)lf[616]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* k19144 in k19140 in ##sys#sqrt/loc in k12556 in k11433 */
static void C_ccall f_19146(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_19146,c,av);}
a=C_alloc(7);
t2=C_a_i_sqrt(&a,1,t1);
t3=C_mutate(((C_word *)t0)+2,t2);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19165,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2734: scheme#cos */
t5=*((C_word*)lf[671]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}

/* k19159 in k19163 in k19144 in k19140 in ##sys#sqrt/loc in k12556 in k11433 */
static void C_ccall f_19161(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,3)))){
C_save_and_reclaim((void *)f_19161,c,av);}
a=C_alloc(33);
t2=C_s_a_i_times(&a,2,((C_word*)t0)[2],t1);
/* library.scm:2734: make-complex */
f_17262(((C_word*)t0)[3],((C_word*)t0)[4],t2);}

/* k19163 in k19144 in k19140 in ##sys#sqrt/loc in k12556 in k11433 */
static void C_ccall f_19165(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(38,c,2)))){
C_save_and_reclaim((void *)f_19165,c,av);}
a=C_alloc(38);
t2=((C_word*)t0)[2];
t3=C_s_a_i_times(&a,2,((C_word*)t2)[2],t1);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_19161,a[2]=((C_word*)t2)[2],a[3]=((C_word*)t2)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* library.scm:2734: scheme#sin */
t5=*((C_word*)lf[667]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=((C_word*)t2)[4];
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}

/* k19180 in ##sys#sqrt/loc in k12556 in k11433 */
static void C_ccall f_19182(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_19182,c,av);}
a=C_alloc(4);
t2=C_a_i_sqrt(&a,1,t1);
/* library.scm:2736: make-complex */
f_17262(((C_word*)t0)[2],lf[605],t2);}

/* a19192 in ##sys#sqrt/loc in k12556 in k11433 */
static void C_ccall f_19193(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19193,c,av);}
/* library.scm:2739: ##sys#exact-integer-sqrt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[684]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[684]+1);
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
tp(3,av2);}}

/* a19198 in ##sys#sqrt/loc in k12556 in k11433 */
static void C_ccall f_19199(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_19199,c,av);}
a=C_alloc(3);
t4=C_eqp(C_fix(0),t3);
if(C_truep(t4)){
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_19210,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* library.scm:2742: scheme#exact->inexact */
t6=*((C_word*)lf[86]+1);{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}}

/* k19208 in a19198 in ##sys#sqrt/loc in k12556 in k11433 */
static void C_ccall f_19210(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,1)))){
C_save_and_reclaim((void *)f_19210,c,av);}
a=C_alloc(4);
t2=C_a_i_sqrt(&a,1,t1);
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* a19220 in ##sys#sqrt/loc in k12556 in k11433 */
static void C_ccall f_19221(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_19221,c,av);}
/* library.scm:2744: ##sys#exact-integer-sqrt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[684]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[684]+1);
av2[1]=t1;
av2[2]=C_u_i_ratnum_num(((C_word*)t0)[2]);
tp(3,av2);}}

/* a19232 in ##sys#sqrt/loc in k12556 in k11433 */
static void C_ccall f_19233(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_