/* Generated from posix.scm by the CHICKEN compiler
   http://www.call-cc.org
   Version 6.0.0 (rev e4e9ea4d)
   linux-unix-gnu-x86-64 [ 64bit dload ptables ]
   command line: posix.scm -optimize-level 2 -include-path . -include-path ./ -inline -ignore-repository -feature chicken-bootstrap -no-warnings -specialize -consult-types-file ./types.db -explicit-use -no-trace -output-file posixunix.c -feature platform-unix -emit-import-library chicken.errno -emit-import-library chicken.file.posix -emit-import-library chicken.time.posix -emit-import-library chicken.process -emit-import-library chicken.process.signal -emit-import-library chicken.process-context.posix -no-module-registration
   unit: posix
   uses: extras scheduler port pathname lolevel library
*/
#include "chicken.h"


#include <signal.h>

static int C_not_implemented(void);
int C_not_implemented() { return -1; }

#if defined(_WIN32) && !defined(__CYGWIN__)
static struct _stat64i32 C_statbuf;
#define C_fstat   _fstat64i32
#else
static struct stat C_statbuf;
#define C_fstat   fstat
#endif

#define C_stat_type         (C_statbuf.st_mode & S_IFMT)
#define C_stat_perm         (C_statbuf.st_mode & ~S_IFMT)

#define C_u_i_stat(fn)      C_fix(C_stat(C_OS_FILENAME(fn, 0), &C_statbuf))
#define C_u_i_fstat(fd)     C_fix(C_fstat(C_unfix(fd), &C_statbuf))

#ifndef S_IFSOCK
# define S_IFSOCK           0140000
#endif

#ifndef S_IRUSR
# define S_IRUSR  S_IREAD
#endif
#ifndef S_IWUSR
# define S_IWUSR  S_IWRITE
#endif
#ifndef S_IXUSR
# define S_IXUSR  S_IEXEC
#endif

#ifndef S_IRGRP
# define S_IRGRP  S_IREAD
#endif
#ifndef S_IWGRP
# define S_IWGRP  S_IWRITE
#endif
#ifndef S_IXGRP
# define S_IXGRP  S_IEXEC
#endif

#ifndef S_IROTH
# define S_IROTH  S_IREAD
#endif
#ifndef S_IWOTH
# define S_IWOTH  S_IWRITE
#endif
#ifndef S_IXOTH
# define S_IXOTH  S_IEXEC
#endif

#define cpy_tmvec_to_tmstc08(ptm, v) \
    ((ptm)->tm_sec = C_unfix(C_block_item((v), 0)), \
    (ptm)->tm_min = C_unfix(C_block_item((v), 1)), \
    (ptm)->tm_hour = C_unfix(C_block_item((v), 2)), \
    (ptm)->tm_mday = C_unfix(C_block_item((v), 3)), \
    (ptm)->tm_mon = C_unfix(C_block_item((v), 4)), \
    (ptm)->tm_year = C_unfix(C_block_item((v), 5)), \
    (ptm)->tm_wday = C_unfix(C_block_item((v), 6)), \
    (ptm)->tm_yday = C_unfix(C_block_item((v), 7)), \
    (ptm)->tm_isdst = (C_block_item((v), 8) != C_SCHEME_FALSE))

#define cpy_tmvec_to_tmstc9(ptm, v) \
    (((struct tm *)ptm)->tm_gmtoff = -C_unfix(C_block_item((v), 9)))

#define C_tm_set_08(v, tm)  cpy_tmvec_to_tmstc08( (tm), (v) )
#define C_tm_set_9(v, tm)   cpy_tmvec_to_tmstc9( (tm), (v) )

static struct tm *
C_tm_set( C_word v, void *tm )
{
  C_tm_set_08( v, (struct tm *)tm );
#if defined(C_GNU_ENV) && !defined(__CYGWIN__) && !defined(__uClinux__)
  C_tm_set_9( v, (struct tm *)tm );
#endif
  return tm;
}

#define TIME_STRING_MAXLENGTH 255
static char C_time_string [TIME_STRING_MAXLENGTH + 1];
#undef TIME_STRING_MAXLENGTH

#define C_strftime(v, f, tm) \
        (strftime(C_time_string, sizeof(C_time_string), C_c_string(f), C_tm_set((v), (tm))) ? C_time_string : NULL)
#define C_a_mktime(ptr, c, v, tm)  C_int64_to_num(ptr, mktime(C_tm_set((v), C_data_pointer(tm))))
#define C_asctime(v, tm)    (asctime(C_tm_set((v), (tm))))

#define C_fdopen(a, n, fd, m) C_mpointer(a, fdopen(C_unfix(fd), C_c_string(m)))
#define C_dup(x)            C_fix(dup(C_unfix(x)))
#define C_dup2(x, y)        C_fix(dup2(C_unfix(x), C_unfix(y)))

#define C_set_file_ptr(port, ptr)  (C_set_block_item(port, 0, (C_block_item(ptr, 0))), C_SCHEME_UNDEFINED)

/* It is assumed that 'int' is-a 'long' */
#define C_ftell(a, n, p)    C_int64_to_num(a, ftell(C_port_file(p)))
#define C_fseek(p, n, w)    C_mk_nbool(fseek(C_port_file(p), C_num_to_int64(n), C_unfix(w)))
#define C_lseek(fd, o, w)     C_fix(lseek(C_unfix(fd), C_num_to_int64(o), C_unfix(w)))

#ifndef S_IFLNK
#define S_IFLNK S_IFREG
#endif

#ifndef S_IFREG
#define S_IFREG S_IFREG
#endif

#ifndef S_IFDIR
#define S_IFDIR S_IFREG
#endif

#ifndef S_IFCHR
#define S_IFCHR S_IFREG
#endif

#ifndef S_IFBLK
#define S_IFBLK S_IFREG
#endif

#ifndef S_IFSOCK
#define S_IFSOCK S_IFREG
#endif

#ifndef S_IFIFO
#define S_IFIFO S_IFREG
#endif



static int C_wait_status;

#include <sys/time.h>
#include <sys/wait.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <dirent.h>
#include <pwd.h>
#include <utime.h>

#if defined(__sun) && defined(__SVR4)
# include <sys/tty.h>
# include <termios.h>
#endif

#ifdef __linux__
# include <sys/file.h>
#endif

#include <sys/mman.h>
#include <poll.h>

#ifndef O_FSYNC
# define O_FSYNC O_SYNC
#endif

#ifndef PIPE_BUF
# ifdef __CYGWIN__
#  define PIPE_BUF       _POSIX_PIPE_BUF
# else
#  define PIPE_BUF 1024
# endif
#endif

#ifndef O_BINARY
# define O_BINARY        0
#endif
#ifndef O_TEXT
# define O_TEXT          0
#endif

#ifndef MAP_FILE
# define MAP_FILE    0
#endif

#ifndef MAP_ANON
# define MAP_ANON    0
#endif

#ifndef FILENAME_MAX
# define FILENAME_MAX          1024
#endif

static DIR *temphandle;
static struct passwd *C_user;

/* Android doesn't provide pw_gecos in the passwd struct */
#ifdef __ANDROID__
# define C_PW_GECOS ("")
#else
# define C_PW_GECOS (C_user->pw_gecos)
#endif

static int C_pipefds[ 2 ];
static time_t C_secs;
static struct timeval C_timeval;
static struct stat C_statbuf;

#define C_fchdir(fd)        C_fix(fchdir(C_unfix(fd)))

#define open_binary_input_pipe(a, n, name)   C_mpointer(a, popen(C_c_string(name), "r"))
#define open_text_input_pipe(a, n, name)     open_binary_input_pipe(a, n, name)
#define open_binary_output_pipe(a, n, name)  C_mpointer(a, popen(C_c_string(name), "w"))
#define open_text_output_pipe(a, n, name)    open_binary_output_pipe(a, n, name)
#define close_pipe(p)                        C_fix(pclose(C_port_file(p)))

#define C_fork              fork
#define C_waitpid(id, o)    C_fix(waitpid(C_unfix(id), &C_wait_status, C_unfix(o)))
#define C_getppid           getppid
#define C_kill(id, s)       C_fix(kill(C_unfix(id), C_unfix(s)))
#define C_getuid            getuid
#define C_getgid            getgid
#define C_geteuid           geteuid
#define C_getegid           getegid
#define C_chown(fn, u, g)   C_fix(chown(C_c_string(fn), C_unfix(u), C_unfix(g)))
#define C_fchown(fd, u, g)  C_fix(fchown(C_unfix(fd), C_unfix(u), C_unfix(g)))
#define C_chmod(fn, m)      C_fix(chmod(C_c_string(fn), C_unfix(m)))
#define C_fchmod(fd, m)     C_fix(fchmod(C_unfix(fd), C_unfix(m)))
#define C_setuid(id)        C_fix(setuid(C_unfix(id)))
#define C_setgid(id)        C_fix(setgid(C_unfix(id)))
#define C_seteuid(id)       C_fix(seteuid(C_unfix(id)))
#define C_setegid(id)       C_fix(setegid(C_unfix(id)))
#define C_setsid(dummy)     C_fix(setsid())
#define C_setpgid(x, y)     C_fix(setpgid(C_unfix(x), C_unfix(y)))
#define C_getpgid(x)        C_fix(getpgid(C_unfix(x)))
#define C_symlink(o, n)     C_fix(symlink(C_c_string(o), C_c_string(n)))
#define C_do_readlink(f, b) C_fix(readlink(C_c_string(f), C_c_string(b), FILENAME_MAX))
#define C_getpwnam(n)       C_mk_bool((C_user = getpwnam(C_c_string(n))) != NULL)
#define C_getpwuid(u)       C_mk_bool((C_user = getpwuid(C_unfix(u))) != NULL)
#define C_pipe(d)           C_fix(pipe(C_pipefds))
#define C_truncate(f, n)    C_fix(truncate(C_c_string(f), C_num_to_int(n)))
#define C_ftruncate(f, n)   C_fix(ftruncate(C_unfix(f), C_num_to_int(n)))
#define C_alarm             alarm
#define C_close(fd)         C_fix(close(C_unfix(fd)))
#define C_umask(m)          C_fix(umask(C_unfix(m)))

#define C_u_i_lstat(fn)     C_fix(lstat(C_c_string(fn), &C_statbuf))

#define C_u_i_execvp(f,a)   C_fix(execvp(C_c_string(f), (char *const *)C_c_pointer_vector_or_null(a)))
#define C_u_i_execve(f,a,e) C_fix(execve(C_c_string(f), (char *const *)C_c_pointer_vector_or_null(a), (char *const *)C_c_pointer_vector_or_null(e)))

static int C_uw;
#define C_WIFEXITED(n)      (C_uw = C_unfix(n), C_mk_bool(WIFEXITED(C_uw)))
#define C_WIFSIGNALED(n)    (C_uw = C_unfix(n), C_mk_bool(WIFSIGNALED(C_uw)))
#define C_WIFSTOPPED(n)     (C_uw = C_unfix(n), C_mk_bool(WIFSTOPPED(C_uw)))
#define C_WEXITSTATUS(n)    (C_uw = C_unfix(n), C_fix(WEXITSTATUS(C_uw)))
#define C_WTERMSIG(n)       (C_uw = C_unfix(n), C_fix(WTERMSIG(C_uw)))
#define C_WSTOPSIG(n)       (C_uw = C_unfix(n), C_fix(WSTOPSIG(C_uw)))

#ifdef __CYGWIN__
# define C_mkfifo(fn, m)    C_fix(-1)
#else
# define C_mkfifo(fn, m)    C_fix(mkfifo(C_c_string(fn), C_unfix(m)))
#endif

static C_word C_flock(C_word n, C_word f)
{
#ifdef __HAIKU__
# define LOCK_SH	0
# define LOCK_EX	0
# define LOCK_NB 	0
# define LOCK_UN	0
	return C_fix(-1);
#else
    return C_fix(flock(C_unfix(n), C_unfix(f)));
#endif
}

static sigset_t C_sigset;
#define C_sigemptyset(d)    (sigemptyset(&C_sigset), C_SCHEME_UNDEFINED)
#define C_sigaddset(s)      (sigaddset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigdelset(s)      (sigdelset(&C_sigset, C_unfix(s)), C_SCHEME_UNDEFINED)
#define C_sigismember(s)    C_mk_bool(sigismember(&C_sigset, C_unfix(s)))
#define C_sigprocmask_set(d)        C_fix(sigprocmask(SIG_SETMASK, &C_sigset, NULL))
#define C_sigprocmask_block(d)      C_fix(sigprocmask(SIG_BLOCK, &C_sigset, NULL))
#define C_sigprocmask_unblock(d)    C_fix(sigprocmask(SIG_UNBLOCK, &C_sigset, NULL))
#define C_sigprocmask_get(d)        C_fix(sigprocmask(SIG_SETMASK, NULL, &C_sigset))

#define C_open(fn, fl, m)   C_fix(open(C_c_string(fn), C_unfix(fl), C_unfix(m)))
#define C_read(fd, b, n)    C_fix(read(C_unfix(fd), C_c_string(b), C_unfix(n)))
#define C_write(fd, b, start, n)   C_fix(write(C_unfix(fd), C_c_string(b) + C_unfix(start), C_unfix(n)))
#define C_mkstemp(t)        C_fix(mkstemp(C_c_string(t)))

#define C_ctime(n)          (C_secs = (n), ctime(&C_secs))

#if defined(__SVR4) || defined(C_MACOSX) || defined(__ANDROID__) || defined(_AIX)
/* Seen here: http://lists.samba.org/archive/samba-technical/2002-November/025571.html */

static time_t C_timegm(struct tm *t)
{
  time_t tl, tb;
  struct tm *tg;

  tl = mktime (t);
  if (tl == -1)
    {
      t->tm_hour--;
      tl = mktime (t);
      if (tl == -1)
        return -1; /* can't deal with output from strptime */
      tl += 3600;
    }
  tg = gmtime (&tl);
  tg->tm_isdst = 0;
  tb = mktime (tg);
  if (tb == -1)
    {
      tg->tm_hour--;
      tb = mktime (tg);
      if (tb == -1)
        return -1; /* can't deal with output from gmtime */
      tb += 3600;
    }
  return (tl - (tb - tl));
}
#else
#define C_timegm timegm
#endif

#define C_a_timegm(ptr, c, v, tm)  C_int64_to_num(ptr, C_timegm(C_tm_set((v), C_data_pointer(tm))))

#ifdef __linux__
extern char *strptime(const char *s, const char *format, struct tm *tm);
extern pid_t getpgid(pid_t pid);
#endif

/* tm_get could be in posix-common, but it's only used in here */
#define cpy_tmstc08_to_tmvec(v, ptm) \
    (C_set_block_item((v), 0, C_fix(((struct tm *)ptm)->tm_sec)), \
    C_set_block_item((v), 1, C_fix((ptm)->tm_min)), \
    C_set_block_item((v), 2, C_fix((ptm)->tm_hour)), \
    C_set_block_item((v), 3, C_fix((ptm)->tm_mday)), \
    C_set_block_item((v), 4, C_fix((ptm)->tm_mon)), \
    C_set_block_item((v), 5, C_fix((ptm)->tm_year)), \
    C_set_block_item((v), 6, C_fix((ptm)->tm_wday)), \
    C_set_block_item((v), 7, C_fix((ptm)->tm_yday)), \
    C_set_block_item((v), 8, ((ptm)->tm_isdst ? C_SCHEME_TRUE : C_SCHEME_FALSE)))

#define cpy_tmstc9_to_tmvec(v, ptm) \
    (C_set_block_item((v), 9, C_fix(-(ptm)->tm_gmtoff)))

#define C_tm_get_08(v, tm)  cpy_tmstc08_to_tmvec( (v), (tm) )
#define C_tm_get_9(v, tm)   cpy_tmstc9_to_tmvec( (v), (tm) )

static C_word
C_tm_get( C_word v, void *tm )
{
  C_tm_get_08( v, (struct tm *)tm );
#if defined(C_GNU_ENV) && !defined(__CYGWIN__) && !defined(__uClinux__)
  C_tm_get_9( v, (struct tm *)tm );
#endif
  return v;
}

#define C_strptime(s, f, v, stm) \
        (strptime(C_c_string(s), C_c_string(f), ((struct tm *)(stm))) ? C_tm_get((v), (stm)) : C_SCHEME_FALSE)

static int set_file_mtime(C_word filename, C_word atime, C_word mtime)
{
  struct stat sb;
  struct utimbuf tb;
  C_word bv = C_block_item(filename, 0);

  /* Only lstat if needed */
  if (atime == C_SCHEME_FALSE || mtime == C_SCHEME_FALSE) {
    if (lstat(C_c_string(bv), &sb) == -1) return -1;
  }

  if (atime == C_SCHEME_FALSE) {
    tb.actime = sb.st_atime;
  } else {
    tb.actime = C_num_to_int64(atime);
  }
  if (mtime == C_SCHEME_FALSE) {
    tb.modtime = sb.st_mtime;
  } else {
    tb.modtime = C_num_to_int64(mtime);
  }
  return utime(C_c_string(bv), &tb);
}



static C_PTABLE_ENTRY *create_ptable(void);
C_noret_decl(C_extras_toplevel)
C_extern void C_ccall C_extras_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(C_scheduler_toplevel)
C_extern void C_ccall C_scheduler_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(C_port_toplevel)
C_extern void C_ccall C_port_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(C_pathname_toplevel)
C_extern void C_ccall C_pathname_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(C_lolevel_toplevel)
C_extern void C_ccall C_lolevel_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(C_library_toplevel)
C_extern void C_ccall C_library_toplevel(C_word c,C_word *av) C_noret;

static C_word lf[527];
static double C_possibly_force_alignment;
static C_char li0[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,35,115,121,115,116,101,109,32,99,109,100,41,0,0,0,0};
static C_char li1[] C_aligned={C_lihdr(0,0,29),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,35,115,121,115,116,101,109,42,32,115,116,114,41,0,0,0};
static C_char li2[] C_aligned={C_lihdr(0,0,8),40,103,50,53,56,32,99,41};
static C_char li3[] C_aligned={C_lihdr(0,0,18),40,109,97,112,45,108,111,111,112,50,53,50,32,103,50,54,52,41,0,0,0,0,0,0};
static C_char li4[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,35,113,115,32,115,116,114,32,46,32,114,101,115,116,41,0};
static C_char li5[] C_aligned={C_lihdr(0,0,47),40,99,104,105,99,107,101,110,46,112,111,115,105,120,35,112,111,115,105,120,45,101,114,114,111,114,32,116,121,112,101,32,108,111,99,32,109,115,103,32,46,32,97,114,103,115,41,0};
static C_char li6[] C_aligned={C_lihdr(0,0,38),40,99,104,105,99,107,101,110,46,112,111,115,105,120,35,115,116,97,116,32,102,105,108,101,32,108,105,110,107,32,101,114,114,32,108,111,99,41,0,0};
static C_char li7[] C_aligned={C_lihdr(0,0,39),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,102,105,108,101,45,115,116,97,116,32,102,32,46,32,114,101,115,116,41,0};
static C_char li8[] C_aligned={C_lihdr(0,0,46),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,115,101,116,45,102,105,108,101,45,112,101,114,109,105,115,115,105,111,110,115,33,32,102,32,112,41,0,0};
static C_char li9[] C_aligned={C_lihdr(0,0,45),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,102,105,108,101,45,109,111,100,105,102,105,99,97,116,105,111,110,45,116,105,109,101,32,102,41,0,0,0};
static C_char li10[] C_aligned={C_lihdr(0,0,39),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,102,105,108,101,45,97,99,99,101,115,115,45,116,105,109,101,32,102,41,0};
static C_char li11[] C_aligned={C_lihdr(0,0,39),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,102,105,108,101,45,99,104,97,110,103,101,45,116,105,109,101,32,102,41,0};
static C_char li12[] C_aligned={C_lihdr(0,0,45),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,115,101,116,45,102,105,108,101,45,116,105,109,101,115,33,32,102,32,46,32,114,101,115,116,41,0,0,0};
static C_char li13[] C_aligned={C_lihdr(0,0,32),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,102,105,108,101,45,115,105,122,101,32,102,41};
static C_char li14[] C_aligned={C_lihdr(0,0,42),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,115,101,116,45,102,105,108,101,45,111,119,110,101,114,33,32,102,32,117,105,100,41,0,0,0,0,0,0};
static C_char li15[] C_aligned={C_lihdr(0,0,42),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,115,101,116,45,102,105,108,101,45,103,114,111,117,112,33,32,102,32,103,105,100,41,0,0,0,0,0,0};
static C_char li16[] C_aligned={C_lihdr(0,0,42),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,102,105,108,101,45,116,121,112,101,32,102,105,108,101,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char li17[] C_aligned={C_lihdr(0,0,39),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,114,101,103,117,108,97,114,45,102,105,108,101,63,32,102,105,108,101,41,0};
static C_char li18[] C_aligned={C_lihdr(0,0,40),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,115,121,109,98,111,108,105,99,45,108,105,110,107,63,32,102,105,108,101,41};
static C_char li19[] C_aligned={C_lihdr(0,0,39),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,98,108,111,99,107,45,100,101,118,105,99,101,63,32,102,105,108,101,41,0};
static C_char li20[] C_aligned={C_lihdr(0,0,43),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,99,104,97,114,97,99,116,101,114,45,100,101,118,105,99,101,63,32,102,105,108,101,41,0,0,0,0,0};
static C_char li21[] C_aligned={C_lihdr(0,0,31),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,102,105,102,111,63,32,102,105,108,101,41,0};
static C_char li22[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,115,111,99,107,101,116,63,32,102,105,108,101,41,0,0,0,0,0,0,0};
static C_char li23[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,100,105,114,101,99,116,111,114,121,63,32,102,105,108,101,41,0,0,0,0};
static C_char li24[] C_aligned={C_lihdr(0,0,57),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,115,101,116,45,102,105,108,101,45,112,111,115,105,116,105,111,110,33,32,112,111,114,116,32,112,111,115,32,46,32,119,104,101,110,99,101,41,0,0,0,0,0,0,0};
static C_char li25[] C_aligned={C_lihdr(0,0,16),40,109,111,100,101,32,105,110,112,32,109,32,108,111,99,41};
static C_char li26[] C_aligned={C_lihdr(0,0,24),40,99,104,101,99,107,32,108,111,99,32,102,100,32,105,110,112,32,114,32,101,110,99,41};
static C_char li27[] C_aligned={C_lihdr(0,0,47),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,111,112,101,110,45,105,110,112,117,116,45,102,105,108,101,42,32,102,100,32,46,32,114,101,115,116,41,0};
static C_char li28[] C_aligned={C_lihdr(0,0,48),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,111,112,101,110,45,111,117,116,112,117,116,45,102,105,108,101,42,32,102,100,32,46,32,114,101,115,116,41};
static C_char li29[] C_aligned={C_lihdr(0,0,38),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,112,111,114,116,45,62,102,105,108,101,110,111,32,112,111,114,116,41,0,0};
static C_char li30[] C_aligned={C_lihdr(0,0,47),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,100,117,112,108,105,99,97,116,101,45,102,105,108,101,110,111,32,111,108,100,32,46,32,110,101,119,41,0};
static C_char li31[] C_aligned={C_lihdr(0,0,50),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,46,112,111,115,105,120,35,99,117,114,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,41,0,0,0,0,0,0};
static C_char li32[] C_aligned={C_lihdr(0,0,52),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,46,112,111,115,105,120,35,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,42,32,102,100,41,0,0,0,0};
static C_char li33[] C_aligned={C_lihdr(0,0,33),40,35,35,115,121,115,35,99,104,97,110,103,101,45,100,105,114,101,99,116,111,114,121,45,104,111,111,107,32,100,105,114,41,0,0,0,0,0,0,0};
static C_char li34[] C_aligned={C_lihdr(0,0,16),67,95,100,101,99,111,100,101,95,115,101,99,111,110,100,115};
static C_char li35[] C_aligned={C_lihdr(0,0,40),40,99,104,105,99,107,101,110,46,112,111,115,105,120,35,99,104,101,99,107,45,116,105,109,101,45,118,101,99,116,111,114,32,108,111,99,32,116,109,41};
static C_char li36[] C_aligned={C_lihdr(0,0,47),40,99,104,105,99,107,101,110,46,116,105,109,101,46,112,111,115,105,120,35,115,101,99,111,110,100,115,45,62,108,111,99,97,108,45,116,105,109,101,32,46,32,114,101,115,116,41,0};
static C_char li37[] C_aligned={C_lihdr(0,0,45),40,99,104,105,99,107,101,110,46,116,105,109,101,46,112,111,115,105,120,35,115,101,99,111,110,100,115,45,62,117,116,99,45,116,105,109,101,32,46,32,114,101,115,116,41,0,0,0};
static C_char li38[] C_aligned={C_lihdr(0,0,43),40,99,104,105,99,107,101,110,46,116,105,109,101,46,112,111,115,105,120,35,115,101,99,111,110,100,115,45,62,115,116,114,105,110,103,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li39[] C_aligned={C_lihdr(0,0,43),40,99,104,105,99,107,101,110,46,116,105,109,101,46,112,111,115,105,120,35,108,111,99,97,108,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,116,109,41,0,0,0,0,0};
static C_char li40[] C_aligned={C_lihdr(0,0,43),40,99,104,105,99,107,101,110,46,116,105,109,101,46,112,111,115,105,120,35,116,105,109,101,45,62,115,116,114,105,110,103,32,116,109,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li41[] C_aligned={C_lihdr(0,0,53),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,46,115,105,103,110,97,108,35,115,101,116,45,115,105,103,110,97,108,45,104,97,110,100,108,101,114,33,32,115,105,103,32,112,114,111,99,41,0,0,0};
static C_char li42[] C_aligned={C_lihdr(0,0,11),40,97,52,50,51,51,32,115,105,103,41,0,0,0,0,0};
static C_char li43[] C_aligned={C_lihdr(0,0,11),40,103,49,48,50,52,32,115,105,103,41,0,0,0,0,0};
static C_char li44[] C_aligned={C_lihdr(0,0,15),40,102,95,52,50,52,50,32,46,32,114,101,115,116,41,0};
static C_char li45[] C_aligned={C_lihdr(0,0,25),40,102,111,114,45,101,97,99,104,45,108,111,111,112,49,48,50,51,32,103,49,48,51,48,41,0,0,0,0,0,0,0};
static C_char li46[] C_aligned={C_lihdr(0,0,51),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,46,115,105,103,110,97,108,35,109,97,107,101,45,115,105,103,110,97,108,45,104,97,110,100,108,101,114,32,46,32,115,105,103,115,41,0,0,0,0,0};
static C_char li47[] C_aligned={C_lihdr(0,0,42),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,46,115,105,103,110,97,108,35,115,105,103,110,97,108,45,105,103,110,111,114,101,32,115,105,103,41,0,0,0,0,0,0};
static C_char li48[] C_aligned={C_lihdr(0,0,43),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,46,115,105,103,110,97,108,35,115,105,103,110,97,108,45,100,101,102,97,117,108,116,32,115,105,103,41,0,0,0,0,0};
static C_char li49[] C_aligned={C_lihdr(0,0,26),40,99,104,105,99,107,101,110,46,112,111,115,105,120,35,112,114,111,99,101,115,115,63,32,120,41,0,0,0,0,0,0};
static C_char li50[] C_aligned={C_lihdr(0,0,28),40,99,104,105,99,107,101,110,46,112,111,115,105,120,35,112,114,111,99,101,115,115,45,105,100,32,120,41,0,0,0,0};
static C_char li51[] C_aligned={C_lihdr(0,0,44),40,99,104,105,99,107,101,110,46,112,111,115,105,120,35,112,114,111,99,101,115,115,45,114,101,116,117,114,110,101,100,45,110,111,114,109,97,108,108,121,63,32,120,41,0,0,0,0};
static C_char li52[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,112,111,115,105,120,35,112,114,111,99,101,115,115,45,105,110,112,117,116,45,112,111,114,116,32,120,41,0,0,0,0};
static C_char li53[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,112,111,115,105,120,35,112,114,111,99,101,115,115,45,111,117,116,112,117,116,45,112,111,114,116,32,120,41,0,0,0};
static C_char li54[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,112,111,115,105,120,35,112,114,111,99,101,115,115,45,101,114,114,111,114,45,112,111,114,116,32,120,41,0,0,0,0};
static C_char li55[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,112,111,115,105,120,35,112,114,111,99,101,115,115,45,101,120,105,116,45,115,116,97,116,117,115,32,120,41,0,0,0};
static C_char li56[] C_aligned={C_lihdr(0,0,33),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,35,112,114,111,99,101,115,115,45,115,108,101,101,112,32,110,41,0,0,0,0,0,0,0};
static C_char li57[] C_aligned={C_lihdr(0,0,7),40,97,52,53,53,54,41,0};
static C_char li58[] C_aligned={C_lihdr(0,0,5),40,114,101,99,41,0,0,0};
static C_char li59[] C_aligned={C_lihdr(0,0,24),40,97,52,53,54,50,32,101,112,105,100,32,101,110,111,114,109,32,101,99,111,100,101,41};
static C_char li60[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,35,112,114,111,99,101,115,115,45,119,97,105,116,32,46,32,97,114,103,115,41,0,0,0};
static C_char li61[] C_aligned={C_lihdr(0,0,7),40,97,52,54,55,53,41,0};
static C_char li62[] C_aligned={C_lihdr(0,0,11),40,97,52,54,54,57,32,101,120,110,41,0,0,0,0,0};
static C_char li63[] C_aligned={C_lihdr(0,0,17),40,100,111,108,111,111,112,49,49,57,56,32,115,108,32,105,41,0,0,0,0,0,0,0};
static C_char li64[] C_aligned={C_lihdr(0,0,10),40,116,109,112,49,50,56,48,55,41,0,0,0,0,0,0};
static C_char li65[] C_aligned={C_lihdr(0,0,7),40,97,52,55,52,57,41,0};
static C_char li66[] C_aligned={C_lihdr(0,0,15),40,116,109,112,50,50,56,48,56,32,97,114,103,115,41,0};
static C_char li67[] C_aligned={C_lihdr(0,0,7),40,97,52,54,56,52,41,0};
static C_char li68[] C_aligned={C_lihdr(0,0,9),40,97,52,54,54,51,32,107,41,0,0,0,0,0,0,0};
static C_char li69[] C_aligned={C_lihdr(0,0,61),40,99,104,105,99,107,101,110,46,112,111,115,105,120,35,108,105,115,116,45,62,99,45,115,116,114,105,110,103,45,98,117,102,102,101,114,32,115,116,114,105,110,103,45,108,105,115,116,32,99,111,110,118,101,114,116,32,108,111,99,41,0,0,0};
static C_char li70[] C_aligned={C_lihdr(0,0,14),40,100,111,108,111,111,112,49,50,49,55,32,105,41,0,0};
static C_char li71[] C_aligned={C_lihdr(0,0,49),40,99,104,105,99,107,101,110,46,112,111,115,105,120,35,102,114,101,101,45,99,45,115,116,114,105,110,103,45,98,117,102,102,101,114,32,98,117,102,102,101,114,45,97,114,114,97,121,41,0,0,0,0,0,0,0};
static C_char li72[] C_aligned={C_lihdr(0,0,7),40,103,49,50,51,48,41,0};
static C_char li73[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,49,50,50,57,41,0,0,0,0,0};
static C_char li74[] C_aligned={C_lihdr(0,0,46),40,99,104,105,99,107,101,110,46,112,111,115,105,120,35,99,104,101,99,107,45,101,110,118,105,114,111,110,109,101,110,116,45,108,105,115,116,32,108,115,116,32,108,111,99,41,0,0};
static C_char li75[] C_aligned={C_lihdr(0,0,7),40,110,111,112,32,120,41,0};
static C_char li76[] C_aligned={C_lihdr(0,0,7),40,97,52,56,55,52,41,0};
static C_char li77[] C_aligned={C_lihdr(0,0,11),40,97,52,56,54,56,32,101,120,110,41,0,0,0,0,0};
static C_char li78[] C_aligned={C_lihdr(0,0,20),40,109,97,112,45,108,111,111,112,49,50,55,49,32,103,49,50,56,51,41,0,0,0,0};
static C_char li79[] C_aligned={C_lihdr(0,0,7),40,97,52,56,57,53,41,0};
static C_char li80[] C_aligned={C_lihdr(0,0,7),40,97,52,57,55,54,41,0};
static C_char li81[] C_aligned={C_lihdr(0,0,14),40,97,52,57,55,48,32,46,32,97,114,103,115,41,0,0};
static C_char li82[] C_aligned={C_lihdr(0,0,7),40,97,52,56,56,57,41,0};
static C_char li83[] C_aligned={C_lihdr(0,0,9),40,97,52,56,54,50,32,107,41,0,0,0,0,0,0,0};
static C_char li84[] C_aligned={C_lihdr(0,0,77),40,99,104,105,99,107,101,110,46,112,111,115,105,120,35,99,97,108,108,45,119,105,116,104,45,101,120,101,99,45,97,114,103,115,32,108,111,99,32,102,105,108,101,110,97,109,101,32,97,114,103,99,111,110,118,32,97,114,103,108,105,115,116,32,101,110,118,108,105,115,116,32,112,114,111,99,41,0,0,0};
static C_char li85[] C_aligned={C_lihdr(0,0,21),40,99,104,101,99,107,32,108,111,99,32,99,109,100,32,105,110,112,32,114,41,0,0,0};
static C_char li86[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,35,111,112,101,110,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,32,46,32,109,41,0,0,0,0,0,0,0};
static C_char li87[] C_aligned={C_lihdr(0,0,42),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,35,111,112,101,110,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,32,46,32,109,41,0,0,0,0,0,0};
static C_char li88[] C_aligned={C_lihdr(0,0,39),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,35,99,108,111,115,101,45,105,110,112,117,116,45,112,105,112,101,32,112,111,114,116,41,0};
static C_char li89[] C_aligned={C_lihdr(0,0,40),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,35,99,108,111,115,101,45,111,117,116,112,117,116,45,112,105,112,101,32,112,111,114,116,41};
static C_char li90[] C_aligned={C_lihdr(0,0,7),40,97,53,49,51,57,41,0};
static C_char li91[] C_aligned={C_lihdr(0,0,17),40,97,53,49,53,48,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0,0};
static C_char li92[] C_aligned={C_lihdr(0,0,7),40,97,53,49,52,52,41,0};
static C_char li93[] C_aligned={C_lihdr(0,0,7),40,97,53,49,53,57,41,0};
static C_char li94[] C_aligned={C_lihdr(0,0,55),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,35,119,105,116,104,45,105,110,112,117,116,45,102,114,111,109,45,112,105,112,101,32,99,109,100,32,116,104,117,110,107,32,46,32,109,111,100,101,41,0};
static C_char li95[] C_aligned={C_lihdr(0,0,7),40,97,53,49,55,51,41,0};
static C_char li96[] C_aligned={C_lihdr(0,0,17),40,97,53,49,55,57,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0,0};
static C_char li97[] C_aligned={C_lihdr(0,0,55),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,35,99,97,108,108,45,119,105,116,104,45,111,117,116,112,117,116,45,112,105,112,101,32,99,109,100,32,112,114,111,99,32,46,32,109,111,100,101,41,0};
static C_char li98[] C_aligned={C_lihdr(0,0,7),40,97,53,49,57,55,41,0};
static C_char li99[] C_aligned={C_lihdr(0,0,17),40,97,53,50,48,51,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0,0};
static C_char li100[] C_aligned={C_lihdr(0,0,54),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,35,99,97,108,108,45,119,105,116,104,45,105,110,112,117,116,45,112,105,112,101,32,99,109,100,32,112,114,111,99,32,46,32,109,111,100,101,41,0,0};
static C_char li101[] C_aligned={C_lihdr(0,0,7),40,97,53,50,50,49,41,0};
static C_char li102[] C_aligned={C_lihdr(0,0,17),40,97,53,50,51,50,32,46,32,114,101,115,117,108,116,115,41,0,0,0,0,0,0,0};
static C_char li103[] C_aligned={C_lihdr(0,0,7),40,97,53,50,50,54,41,0};
static C_char li104[] C_aligned={C_lihdr(0,0,7),40,97,53,50,52,49,41,0};
static C_char li105[] C_aligned={C_lihdr(0,0,54),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,35,119,105,116,104,45,111,117,116,112,117,116,45,116,111,45,112,105,112,101,32,99,109,100,32,116,104,117,110,107,32,46,32,109,111,100,101,41,0,0};
static C_char li106[] C_aligned={C_lihdr(0,0,32),40,35,35,115,121,115,35,102,105,108,101,45,110,111,110,98,108,111,99,107,105,110,103,33,32,102,100,49,52,56,54,41};
static C_char li107[] C_aligned={C_lihdr(0,0,31),40,35,35,115,121,115,35,102,105,108,101,45,115,101,108,101,99,116,45,111,110,101,32,105,110,116,49,52,57,49,41,0};
static C_char li108[] C_aligned={C_lihdr(0,0,47),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,102,105,108,101,45,99,111,110,116,114,111,108,32,102,100,32,99,109,100,32,46,32,114,101,115,116,41,0};
static C_char li109[] C_aligned={C_lihdr(0,0,52),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,102,105,108,101,45,111,112,101,110,32,102,105,108,101,110,97,109,101,32,102,108,97,103,115,32,46,32,109,111,100,101,41,0,0,0,0};
static C_char li110[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char li111[] C_aligned={C_lihdr(0,0,34),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,102,105,108,101,45,99,108,111,115,101,32,102,100,41,0,0,0,0,0,0};
static C_char li112[] C_aligned={C_lihdr(0,0,47),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,102,105,108,101,45,114,101,97,100,32,102,100,32,115,105,122,101,32,46,32,98,117,102,102,101,114,41,0};
static C_char li113[] C_aligned={C_lihdr(0,0,48),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,102,105,108,101,45,119,114,105,116,101,32,102,100,32,98,117,102,102,101,114,32,46,32,115,105,122,101,41};
static C_char li114[] C_aligned={C_lihdr(0,0,42),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,102,105,108,101,45,109,107,115,116,101,109,112,32,116,101,109,112,108,97,116,101,41,0,0,0,0,0,0};
static C_char li115[] C_aligned={C_lihdr(0,0,18),40,100,111,108,111,111,112,49,53,56,51,32,102,100,115,114,108,41,0,0,0,0,0,0};
static C_char li116[] C_aligned={C_lihdr(0,0,18),40,100,111,108,111,111,112,49,53,56,52,32,102,100,115,119,108,41,0,0,0,0,0,0};
static C_char li117[] C_aligned={C_lihdr(0,0,14),40,108,112,32,105,32,114,101,115,32,102,100,115,41,0,0};
static C_char li118[] C_aligned={C_lihdr(0,0,14),40,108,112,32,105,32,114,101,115,32,102,100,115,41,0,0};
static C_char li119[] C_aligned={C_lihdr(0,0,52),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,102,105,108,101,45,115,101,108,101,99,116,32,102,100,115,114,32,102,100,115,119,32,46,32,116,105,109,101,111,117,116,41,0,0,0,0};
static C_char li120[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,35,99,114,101,97,116,101,45,112,105,112,101,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char li121[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,49,54,57,54,41,0,0,0,0,0};
static C_char li122[] C_aligned={C_lihdr(0,0,46),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,46,115,105,103,110,97,108,35,115,101,116,45,115,105,103,110,97,108,45,109,97,115,107,33,32,115,105,103,115,41,0,0};
static C_char li123[] C_aligned={C_lihdr(0,0,43),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,46,115,105,103,110,97,108,35,115,105,103,110,97,108,45,109,97,115,107,101,100,63,32,115,105,103,41,0,0,0,0,0};
static C_char li124[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,46,115,105,103,110,97,108,35,115,105,103,110,97,108,45,109,97,115,107,33,32,115,105,103,41,0,0,0,0,0,0,0};
static C_char li125[] C_aligned={C_lihdr(0,0,43),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,46,115,105,103,110,97,108,35,115,105,103,110,97,108,45,117,110,109,97,115,107,33,32,115,105,103,41,0,0,0,0,0};
static C_char li126[] C_aligned={C_lihdr(0,0,60),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,46,112,111,115,105,120,35,117,115,101,114,45,105,110,102,111,114,109,97,116,105,111,110,32,117,115,101,114,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char li127[] C_aligned={C_lihdr(0,0,49),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,46,112,111,115,105,120,35,99,117,114,114,101,110,116,45,117,115,101,114,45,110,97,109,101,41,0,0,0,0,0,0,0};
static C_char li128[] C_aligned={C_lihdr(0,0,59),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,46,112,111,115,105,120,35,99,117,114,114,101,110,116,45,101,102,102,101,99,116,105,118,101,45,117,115,101,114,45,110,97,109,101,41,0,0,0,0,0};
static C_char li129[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,112,111,115,105,120,35,99,104,111,119,110,32,108,111,99,32,102,32,117,105,100,32,103,105,100,41,0,0,0,0,0};
static C_char li130[] C_aligned={C_lihdr(0,0,46),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,46,112,111,115,105,120,35,99,114,101,97,116,101,45,115,101,115,115,105,111,110,41,0,0};
static C_char li131[] C_aligned={C_lihdr(0,0,49),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,99,114,101,97,116,101,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,111,108,100,32,110,101,119,41,0,0,0,0,0,0,0};
static C_char li132[] C_aligned={C_lihdr(0,0,41),40,35,35,115,121,115,35,114,101,97,100,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,102,110,97,109,101,32,108,111,99,97,116,105,111,110,41,0,0,0,0,0,0,0};
static C_char li133[] C_aligned={C_lihdr(0,0,7),40,97,54,50,52,53,41,0};
static C_char li134[] C_aligned={C_lihdr(0,0,24),40,108,111,111,112,32,99,111,109,112,111,110,101,110,116,115,32,114,101,115,117,108,116,41};
static C_char li135[] C_aligned={C_lihdr(0,0,55),40,97,54,50,53,49,32,98,97,115,101,45,111,114,105,103,105,110,32,98,97,115,101,45,100,105,114,101,99,116,111,114,121,32,100,105,114,101,99,116,111,114,121,45,99,111,109,112,111,110,101,110,116,115,41,0};
static C_char li136[] C_aligned={C_lihdr(0,0,52),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,114,101,97,100,45,115,121,109,98,111,108,105,99,45,108,105,110,107,32,102,110,97,109,101,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char li137[] C_aligned={C_lihdr(0,0,38),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,102,105,108,101,45,108,105,110,107,32,111,108,100,32,110,101,119,41,0,0};
static C_char li138[] C_aligned={C_lihdr(0,0,8),40,114,101,97,100,121,63,41};
static C_char li139[] C_aligned={C_lihdr(0,0,19),40,97,54,52,53,56,32,98,117,102,32,115,116,97,114,116,32,110,41,0,0,0,0,0};
static C_char li140[] C_aligned={C_lihdr(0,0,6),40,112,101,101,107,41,0,0};
static C_char li141[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char li142[] C_aligned={C_lihdr(0,0,7),40,102,101,116,99,104,41,0};
static C_char li143[] C_aligned={C_lihdr(0,0,19),40,97,54,53,57,49,32,98,117,102,32,115,116,97,114,116,32,110,41,0,0,0,0,0};
static C_char li144[] C_aligned={C_lihdr(0,0,7),40,97,54,53,55,50,41,0};
static C_char li145[] C_aligned={C_lihdr(0,0,7),40,97,54,54,48,52,41,0};
static C_char li146[] C_aligned={C_lihdr(0,0,7),40,97,54,54,49,54,41,0};
static C_char li147[] C_aligned={C_lihdr(0,0,7),40,97,54,54,51,50,41,0};
static C_char li148[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,110,32,109,32,115,116,97,114,116,41};
static C_char li149[] C_aligned={C_lihdr(0,0,25),40,97,54,54,52,55,32,112,111,114,116,32,110,32,100,101,115,116,32,115,116,97,114,116,41,0,0,0,0,0,0,0};
static C_char li150[] C_aligned={C_lihdr(0,0,11),40,97,54,55,52,55,32,112,111,115,41,0,0,0,0,0};
static C_char li151[] C_aligned={C_lihdr(0,0,7),40,97,54,55,51,55,41,0};
static C_char li152[] C_aligned={C_lihdr(0,0,28),40,97,54,55,57,55,32,110,101,120,116,32,108,105,110,101,32,102,117,108,108,45,108,105,110,101,63,41,0,0,0,0};
static C_char li153[] C_aligned={C_lihdr(0,0,15),40,97,54,55,49,57,32,112,32,108,105,109,105,116,41,0};
static C_char li154[] C_aligned={C_lihdr(0,0,12),40,97,54,56,52,50,32,112,111,114,116,41,0,0,0,0};
static C_char li155[] C_aligned={C_lihdr(0,0,43),40,35,35,115,121,115,35,99,117,115,116,111,109,45,105,110,112,117,116,45,112,111,114,116,32,108,111,99,32,110,97,109,32,102,100,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li156[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char li157[] C_aligned={C_lihdr(0,0,23),40,112,111,107,101,49,57,57,52,32,98,118,32,115,116,97,114,116,32,108,101,110,41,0};
static C_char li158[] C_aligned={C_lihdr(0,0,11),40,97,55,48,53,50,32,115,116,114,41,0,0,0,0,0};
static C_char li159[] C_aligned={C_lihdr(0,0,7),40,97,55,48,53,56,41,0};
static C_char li160[] C_aligned={C_lihdr(0,0,7),40,97,55,48,55,52,41,0};
static C_char li161[] C_aligned={C_lihdr(0,0,12),40,102,95,55,48,56,51,32,115,116,114,41,0,0,0,0};
static C_char li162[] C_aligned={C_lihdr(0,0,20),40,108,111,111,112,32,114,101,109,32,115,116,97,114,116,32,108,101,110,41,0,0,0,0};
static C_char li163[] C_aligned={C_lihdr(0,0,12),40,102,95,55,49,48,53,32,115,116,114,41,0,0,0,0};
static C_char li164[] C_aligned={C_lihdr(0,0,44),40,35,35,115,121,115,35,99,117,115,116,111,109,45,111,117,116,112,117,116,45,112,111,114,116,32,108,111,99,32,110,97,109,32,102,100,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char li165[] C_aligned={C_lihdr(0,0,44),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,102,105,108,101,45,116,114,117,110,99,97,116,101,32,102,110,97,109,101,32,111,102,102,41,0,0,0,0};
static C_char li166[] C_aligned={C_lihdr(0,0,14),40,102,105,108,101,110,111,32,120,32,108,111,99,41,0,0};
static C_char li167[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char li168[] C_aligned={C_lihdr(0,0,42),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,102,105,108,101,45,108,111,99,107,32,112,111,114,116,32,46,32,114,101,115,116,41,0,0,0,0,0,0};
static C_char li169[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char li170[] C_aligned={C_lihdr(0,0,51),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,102,105,108,101,45,108,111,99,107,47,98,108,111,99,107,105,110,103,32,112,111,114,116,32,46,32,114,101,115,116,41,0,0,0,0,0};
static C_char li171[] C_aligned={C_lihdr(0,0,6),40,108,111,111,112,41,0,0};
static C_char li172[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,102,105,108,101,45,117,110,108,111,99,107,32,112,111,114,116,41,0,0,0};
static C_char li173[] C_aligned={C_lihdr(0,0,45),40,99,104,105,99,107,101,110,46,102,105,108,101,46,112,111,115,105,120,35,99,114,101,97,116,101,45,102,105,102,111,32,102,110,97,109,101,32,46,32,109,111,100,101,41,0,0,0};
static C_char li174[] C_aligned={C_lihdr(0,0,44),40,99,104,105,99,107,101,110,46,116,105,109,101,46,112,111,115,105,120,35,115,116,114,105,110,103,45,62,116,105,109,101,32,116,105,109,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char li175[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,116,105,109,101,46,112,111,115,105,120,35,117,116,99,45,116,105,109,101,45,62,115,101,99,111,110,100,115,32,116,109,41,0,0,0,0,0,0,0};
static C_char li176[] C_aligned={C_lihdr(0,0,48),40,99,104,105,99,107,101,110,46,116,105,109,101,46,112,111,115,105,120,35,108,111,99,97,108,45,116,105,109,101,122,111,110,101,45,97,98,98,114,101,118,105,97,116,105,111,110,41};
static C_char li177[] C_aligned={C_lihdr(0,0,43),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,46,115,105,103,110,97,108,35,115,101,116,45,97,108,97,114,109,33,32,105,110,116,50,49,54,55,41,0,0,0,0,0};
static C_char li178[] C_aligned={C_lihdr(0,0,7),40,97,55,54,49,50,41,0};
static C_char li179[] C_aligned={C_lihdr(0,0,7),40,97,55,54,51,48,41,0};
static C_char li180[] C_aligned={C_lihdr(0,0,16),40,97,55,54,50,52,32,99,111,110,116,105,110,117,101,41};
static C_char li181[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,35,112,114,111,99,101,115,115,45,102,111,114,107,32,46,32,114,101,115,116,41,0,0,0};
static C_char li182[] C_aligned={C_lihdr(0,0,9),40,97,55,54,56,55,32,120,41,0,0,0,0,0,0,0};
static C_char li183[] C_aligned={C_lihdr(0,0,25),40,97,55,54,57,48,32,112,114,103,32,97,114,103,98,117,102,32,101,110,118,98,117,102,41,0,0,0,0,0,0,0};
static C_char li184[] C_aligned={C_lihdr(0,0,49),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,35,112,114,111,99,101,115,115,45,101,120,101,99,117,116,101,32,102,105,108,101,110,97,109,101,32,46,32,114,101,115,116,41,0,0,0,0,0,0,0};
static C_char li185[] C_aligned={C_lihdr(0,0,7),40,97,55,55,53,55,41,0};
static C_char li186[] C_aligned={C_lihdr(0,0,44),40,99,104,105,99,107,101,110,46,112,111,115,105,120,35,112,114,111,99,101,115,115,45,119,97,105,116,45,105,109,112,108,32,112,105,100,32,110,111,104,97,110,103,41,0,0,0,0};
static C_char li187[] C_aligned={C_lihdr(0,0,49),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,46,112,111,115,105,120,35,112,97,114,101,110,116,45,112,114,111,99,101,115,115,45,105,100,41,0,0,0,0,0,0,0};
static C_char li188[] C_aligned={C_lihdr(0,0,41),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,35,112,114,111,99,101,115,115,45,115,105,103,110,97,108,32,105,100,32,46,32,115,105,103,41,0,0,0,0,0,0,0};
static C_char li189[] C_aligned={C_lihdr(0,0,38),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,35,112,114,111,99,101,115,115,45,114,117,110,32,102,32,46,32,97,114,103,115,41,0,0};
static C_char li190[] C_aligned={C_lihdr(0,0,8),40,102,95,55,56,56,49,41};
static C_char li191[] C_aligned={C_lihdr(0,0,41),40,109,97,107,101,45,111,110,45,99,108,111,115,101,32,112,114,111,99,32,99,108,115,118,101,99,32,105,100,120,32,105,100,120,97,32,105,100,120,98,41,0,0,0,0,0,0,0};
static C_char li192[] C_aligned={C_lihdr(0,0,7),40,97,55,57,49,50,41,0};
static C_char li193[] C_aligned={C_lihdr(0,0,11),40,97,55,57,49,56,32,105,32,111,41,0,0,0,0,0};
static C_char li194[] C_aligned={C_lihdr(0,0,18),40,110,101,101,100,101,100,45,112,105,112,101,32,112,111,114,116,41,0,0,0,0,0,0};
static C_char li195[] C_aligned={C_lihdr(0,0,26),40,99,111,110,110,101,99,116,45,112,97,114,101,110,116,32,112,105,112,101,32,112,111,114,116,41,0,0,0,0,0,0};
static C_char li196[] C_aligned={C_lihdr(0,0,31),40,99,111,110,110,101,99,116,45,99,104,105,108,100,32,112,105,112,101,32,112,111,114,116,32,115,116,100,102,100,41,0};
static C_char li197[] C_aligned={C_lihdr(0,0,7),40,97,55,57,56,55,41,0};
static C_char li198[] C_aligned={C_lihdr(0,0,43),40,115,112,97,119,110,32,99,109,100,32,97,114,103,115,32,101,110,118,32,115,116,100,111,117,116,102,32,115,116,100,105,110,102,32,115,116,100,101,114,114,102,41,0,0,0,0,0};
static C_char li199[] C_aligned={C_lihdr(0,0,43),40,105,110,112,117,116,45,112,111,114,116,32,108,111,99,32,99,109,100,32,112,105,112,101,32,115,116,100,102,32,111,110,45,99,108,111,115,101,32,101,110,99,41,0,0,0,0,0};
static C_char li200[] C_aligned={C_lihdr(0,0,44),40,111,117,116,112,117,116,45,112,111,114,116,32,108,111,99,32,99,109,100,32,112,105,112,101,32,115,116,100,102,32,111,110,45,99,108,111,115,101,32,101,110,99,41,0,0,0,0};
static C_char li201[] C_aligned={C_lihdr(0,0,7),40,97,56,48,51,55,41,0};
static C_char li202[] C_aligned={C_lihdr(0,0,35),40,97,56,48,52,51,32,105,110,112,105,112,101,32,111,117,116,112,105,112,101,32,101,114,114,112,105,112,101,32,112,114,111,99,41,0,0,0,0,0};
static C_char li203[] C_aligned={C_lihdr(0,0,72),40,99,104,105,99,107,101,110,46,112,111,115,105,120,35,112,114,111,99,101,115,115,45,105,109,112,108,32,108,111,99,32,99,109,100,32,97,114,103,115,32,101,110,118,32,115,116,100,111,117,116,102,32,115,116,100,105,110,102,32,115,116,100,101,114,114,102,32,101,110,99,41};
static C_char li204[] C_aligned={C_lihdr(0,0,7),40,103,50,51,55,54,41,0};
static C_char li205[] C_aligned={C_lihdr(0,0,19),40,102,111,114,45,101,97,99,104,45,108,111,111,112,50,51,55,53,41,0,0,0,0,0};
static C_char li206[] C_aligned={C_lihdr(0,0,15),40,99,104,107,115,116,114,108,115,116,32,108,115,116,41,0};
static C_char li207[] C_aligned={C_lihdr(0,0,36),40,37,112,114,111,99,101,115,115,32,108,111,99,32,101,114,114,63,32,99,109,100,32,97,114,103,115,32,101,110,118,32,101,110,99,41,0,0,0,0};
static C_char li208[] C_aligned={C_lihdr(0,0,36),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,35,112,114,111,99,101,115,115,32,99,109,100,32,46,32,114,101,115,116,41,0,0,0,0};
static C_char li209[] C_aligned={C_lihdr(0,0,37),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,35,112,114,111,99,101,115,115,42,32,99,109,100,32,46,32,114,101,115,116,41,0,0,0};
static C_char li210[] C_aligned={C_lihdr(0,0,55),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,45,99,111,110,116,101,120,116,46,112,111,115,105,120,35,115,101,116,45,114,111,111,116,45,100,105,114,101,99,116,111,114,121,33,32,100,105,114,41,0};
static C_char li211[] C_aligned={C_lihdr(0,0,35),40,99,104,105,99,107,101,110,46,112,114,111,99,101,115,115,35,112,114,111,99,101,115,115,45,115,112,97,119,110,32,46,32,95,41,0,0,0,0,0};
static C_char li212[] C_aligned={C_lihdr(0,0,21),40,99,104,105,99,107,101,110,46,101,114,114,110,111,35,101,114,114,110,111,41,0,0,0};
static C_char li213[] C_aligned={C_lihdr(0,0,11),40,97,56,51,57,56,32,112,105,100,41,0,0,0,0,0};
static C_char li214[] C_aligned={C_lihdr(0,0,16),40,97,56,52,49,55,32,112,105,100,32,112,103,105,100,41};
static C_char li215[] C_aligned={C_lihdr(0,0,7),40,97,56,52,52,48,41,0};
static C_char li216[] C_aligned={C_lihdr(0,0,10),40,97,56,52,52,51,32,105,100,41,0,0,0,0,0,0};
static C_char li217[] C_aligned={C_lihdr(0,0,7),40,97,56,52,54,51,41,0};
static C_char li218[] C_aligned={C_lihdr(0,0,10),40,97,56,52,54,54,32,105,100,41,0,0,0,0,0,0};
static C_char li219[] C_aligned={C_lihdr(0,0,7),40,97,56,52,56,54,41,0};
static C_char li220[] C_aligned={C_lihdr(0,0,10),40,97,56,52,56,57,32,105,100,41,0,0,0,0,0,0};
static C_char li221[] C_aligned={C_lihdr(0,0,7),40,97,56,53,48,57,41,0};
static C_char li222[] C_aligned={C_lihdr(0,0,10),40,97,56,53,49,50,32,105,100,41,0,0,0,0,0,0};
static C_char li223[] C_aligned={C_lihdr(0,0,16),40,108,111,111,112,32,115,105,103,115,32,109,97,115,107,41};
static C_char li224[] C_aligned={C_lihdr(0,0,7),40,97,56,53,51,50,41,0};
static C_char li225[] C_aligned={C_lihdr(0,0,8),40,118,97,57,54,50,49,41};
static C_char li226[] C_aligned={C_lihdr(0,0,8),40,118,97,57,54,50,51,41};
static C_char li227[] C_aligned={C_lihdr(0,0,8),40,118,97,57,54,50,53,41};
static C_char li228[] C_aligned={C_lihdr(0,0,8),40,118,97,57,54,50,55,41};
static C_char li229[] C_aligned={C_lihdr(0,0,11),40,97,56,53,54,50,32,115,105,103,41,0,0,0,0,0};
static C_char li230[] C_aligned={C_lihdr(0,0,14),40,97,56,53,55,49,32,46,32,114,101,115,116,41,0,0};
static C_char li231[] C_aligned={C_lihdr(0,0,10),40,97,56,53,57,54,32,117,109,41,0,0,0,0,0,0};
static C_char li232[] C_aligned={C_lihdr(0,0,12),40,97,56,54,48,50,32,112,111,114,116,41,0,0,0,0};
static C_char li233[] C_aligned={C_lihdr(0,0,9),40,97,56,54,51,57,32,102,41,0,0,0,0,0,0,0};
static C_char li234[] C_aligned={C_lihdr(0,0,9),40,97,56,54,52,53,32,102,41,0,0,0,0,0,0,0};
static C_char li235[] C_aligned={C_lihdr(0,0,9),40,97,56,54,53,49,32,102,41,0,0,0,0,0,0,0};
static C_char li236[] C_aligned={C_lihdr(0,0,10),40,116,111,112,108,101,118,101,108,41,0,0,0,0,0,0};


/* from k8318 in chicken.process-context.posix#set-root-directory! in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
C_regparm static C_word stub2446(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_c_string(C_a0);
C_r=C_fix((C_word)chroot(t0));
return C_r;}

/* from chicken.process-context.posix#parent-process-id in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
C_regparm static C_word stub2246(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getppid());
return C_r;}

/* from k7575 */
C_regparm static C_word stub2198(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_c_pointer_or_null(C_a0);
C_r=C_fix((C_word)C_fflush(t0));
return C_r;}

/* from fork */
C_regparm static C_word stub2178(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_fork());
return C_r;}

#define return(x) C_cblock C_r = (C_mpointer_or_false(&C_a,(void*)(x))); goto C_ret; C_cblockend
C_regparm static C_word stub2173(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word o=(C_word )(C_a0);
char *ptr = C_malloc(C_header_size(o)); 

if (ptr != NULL) {

  C_memcpy(ptr, C_data_pointer(o), C_header_size(o)); 

}

C_return(ptr);
C_ret:
#undef return

return C_r;}

/* from k7549 */
C_regparm static C_word stub2168(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_alarm(t0));
return C_r;}

#define return(x) C_cblock C_r = (C_mpointer(&C_a,(void*)(x))); goto C_ret; C_cblockend
C_regparm static C_word stub2164(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;

#if !defined(__CYGWIN__) && !defined(__SVR4) && !defined(__uClinux__) && !defined(__hpux__) && !defined(_AIX)

time_t clock = time(NULL);
struct tm *ltm = C_localtime(&clock);
char *z = ltm ? (char *)ltm->tm_zone : 0;

#else

char *z = (daylight ? tzname[1] : tzname[0]);

#endif

C_return(z);
C_ret:
#undef return

return C_r;}

/* from k7477 */
C_regparm static C_word stub2137(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2,C_word C_a3){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
C_word t2=(C_word )(C_a2);
void * t3=(void * )C_data_pointer_or_null(C_a3);
C_r=((C_word)C_strptime(t0,t1,t2,t3));
return C_r;}

/* from k6335 in k6331 in chicken.file.posix#file-link in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
C_regparm static C_word stub1827(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
char * t0=(char * )C_c_string(C_a0);
char * t1=(char * )C_c_string(C_a1);
C_r=C_fix((C_word)link(t0,t1));
return C_r;}

/* from a8440 in k6025 in k6021 in k6017 in k5975 */
C_regparm static C_word stub1746(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getegid());
return C_r;}

/* from a8463 in k6021 in k6017 in k5975 */
C_regparm static C_word stub1742(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getgid());
return C_r;}

/* from a8486 in k6017 in k5975 */
C_regparm static C_word stub1738(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_geteuid());
return C_r;}

/* from a8509 in k5975 */
C_regparm static C_word stub1734(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getuid());
return C_r;}

#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
C_regparm static C_word stub1669(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
void * p=(void * )C_data_pointer_or_null(C_a1);
struct pollfd *fds = p;
C_return(fds[i].revents & (POLLOUT|POLLERR|POLLHUP|POLLNVAL));
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
C_regparm static C_word stub1650(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
void * p=(void * )C_data_pointer_or_null(C_a1);
struct pollfd *fds = p;
C_return(fds[i].revents & (POLLIN|POLLERR|POLLHUP|POLLNVAL));
C_ret:
#undef return

return C_r;}

/* from k5529 */
C_regparm static C_word stub1625(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
void * t0=(void * )C_data_pointer_or_null(C_a0);
int t1=(int )C_unfix(C_a1);
int t2=(int )C_unfix(C_a2);
C_r=C_fix((C_word)poll(t0,t1,t2));
return C_r;}

#define return(x) C_cblock C_r = (((C_word)(x))); goto C_ret; C_cblockend
C_regparm static C_word stub1610(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
int fd=(int )C_unfix(C_a1);
void * p=(void * )C_data_pointer_or_null(C_a2);
struct pollfd *fds = p;
fds[i].fd = fd; fds[i].events = POLLOUT;
C_ret:
#undef return

return C_r;}

#define return(x) C_cblock C_r = (((C_word)(x))); goto C_ret; C_cblockend
C_regparm static C_word stub1593(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int i=(int )C_unfix(C_a0);
int fd=(int )C_unfix(C_a1);
void * p=(void * )C_data_pointer_or_null(C_a2);
struct pollfd *fds = p;
fds[i].fd = fd; fds[i].events = POLLIN;
C_ret:
#undef return

return C_r;}

/* from k5290 */
C_regparm static C_word stub1499(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
int t1=(int )C_unfix(C_a1);
long t2=(long )C_num_to_long(C_a2);
C_r=C_fix((C_word)fcntl(t0,t1,t2));
return C_r;}

/* from k5257 */
C_regparm static C_word stub1492(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_fix((C_word)C_check_fd_ready(t0));
return C_r;}

#define return(x) C_cblock C_r = (C_mk_bool((x))); goto C_ret; C_cblockend
C_regparm static C_word stub1487(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int fd=(int )C_unfix(C_a0);
int val = fcntl(fd, F_GETFL, 0);
if(val == -1) C_return(0);
C_return(fcntl(fd, F_SETFL, val | O_NONBLOCK) != -1);
C_ret:
#undef return

return C_r;}

/* from k4135 */
C_regparm static C_word stub986(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
void * t2=(void * )C_data_pointer_or_null(C_a2);
C_r=C_mpointer(&C_a,(void*)C_strftime(t0,t1,t2));
return C_r;}

/* from k4122 */
C_regparm static C_word stub976(C_word C_buf,C_word C_a0,C_word C_a1){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
void * t1=(void * )C_data_pointer_or_null(C_a1);
C_r=C_mpointer(&C_a,(void*)C_asctime(t0,t1));
return C_r;}

/* from k4054 */
C_regparm static C_word stub949(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_num_to_int(C_a0);
C_r=C_mpointer(&C_a,(void*)C_ctime(t0));
return C_r;}

/* from chicken.process-context.posix#current-process-id in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
C_regparm static C_word stub893(C_word C_buf){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_r=C_fix((C_word)C_getpid());
return C_r;}

/* from g743 */
C_regparm static C_word stub748(C_word C_buf,C_word C_a0,C_word C_a1,C_word C_a2){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
C_word t0=(C_word )(C_a0);
C_word t1=(C_word )(C_a1);
C_word t2=(C_word )(C_a2);
C_r=C_fix((C_word)set_file_mtime(t0,t1,t2));
return C_r;}

/* from k3235 */
C_regparm static C_word stub674(C_word C_buf,C_word C_a0){
C_word C_r=C_SCHEME_UNDEFINED,*C_a=(C_word*)C_buf;
int t0=(int )C_unfix(C_a0);
C_r=C_mpointer(&C_a,(void*)strerror(t0));
return C_r;}

C_noret_decl(f9632)
static void C_ccall f9632(C_word c,C_word *av) C_noret;
C_noret_decl(f9636)
static void C_ccall f9636(C_word c,C_word *av) C_noret;
C_noret_decl(f9684)
static void C_ccall f9684(C_word c,C_word *av) C_noret;
C_noret_decl(f9690)
static void C_ccall f9690(C_word c,C_word *av) C_noret;
C_noret_decl(f_2906)
static void C_ccall f_2906(C_word c,C_word *av) C_noret;
C_noret_decl(f_2909)
static void C_ccall f_2909(C_word c,C_word *av) C_noret;
C_noret_decl(f_2912)
static void C_ccall f_2912(C_word c,C_word *av) C_noret;
C_noret_decl(f_2915)
static void C_ccall f_2915(C_word c,C_word *av) C_noret;
C_noret_decl(f_2918)
static void C_ccall f_2918(C_word c,C_word *av) C_noret;
C_noret_decl(f_2921)
static void C_ccall f_2921(C_word c,C_word *av) C_noret;
C_noret_decl(f_3006)
static void C_ccall f_3006(C_word c,C_word *av) C_noret;
C_noret_decl(f_3023)
static void C_ccall f_3023(C_word c,C_word *av) C_noret;
C_noret_decl(f_3025)
static void C_ccall f_3025(C_word c,C_word *av) C_noret;
C_noret_decl(f_3029)
static void C_ccall f_3029(C_word c,C_word *av) C_noret;
C_noret_decl(f_3041)
static void C_ccall f_3041(C_word c,C_word *av) C_noret;
C_noret_decl(f_3045)
static void C_ccall f_3045(C_word c,C_word *av) C_noret;
C_noret_decl(f_3055)
static void f_3055(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3076)
static void C_ccall f_3076(C_word c,C_word *av) C_noret;
C_noret_decl(f_3079)
static void C_ccall f_3079(C_word c,C_word *av) C_noret;
C_noret_decl(f_3090)
static void C_ccall f_3090(C_word c,C_word *av) C_noret;
C_noret_decl(f_3096)
static void f_3096(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_3121)
static void C_ccall f_3121(C_word c,C_word *av) C_noret;
C_noret_decl(f_3238)
static void C_ccall f_3238(C_word c,C_word *av) C_noret;
C_noret_decl(f_3242)
static void C_ccall f_3242(C_word c,C_word *av) C_noret;
C_noret_decl(f_3249)
static void C_ccall f_3249(C_word c,C_word *av) C_noret;
C_noret_decl(f_3253)
static void C_ccall f_3253(C_word c,C_word *av) C_noret;
C_noret_decl(f_3256)
static void f_3256(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_3260)
static void C_ccall f_3260(C_word c,C_word *av) C_noret;
C_noret_decl(f_3281)
static void C_ccall f_3281(C_word c,C_word *av) C_noret;
C_noret_decl(f_3285)
static void C_ccall f_3285(C_word c,C_word *av) C_noret;
C_noret_decl(f_3294)
static void C_ccall f_3294(C_word c,C_word *av) C_noret;
C_noret_decl(f_3302)
static void C_ccall f_3302(C_word c,C_word *av) C_noret;
C_noret_decl(f_3309)
static void C_ccall f_3309(C_word c,C_word *av) C_noret;
C_noret_decl(f_3320)
static void C_ccall f_3320(C_word c,C_word *av) C_noret;
C_noret_decl(f_3327)
static void C_ccall f_3327(C_word c,C_word *av) C_noret;
C_noret_decl(f_3345)
static void C_ccall f_3345(C_word c,C_word *av) C_noret;
C_noret_decl(f_3349)
static void C_ccall f_3349(C_word c,C_word *av) C_noret;
C_noret_decl(f_3359)
static void C_ccall f_3359(C_word c,C_word *av) C_noret;
C_noret_decl(f_3364)
static void C_ccall f_3364(C_word c,C_word *av) C_noret;
C_noret_decl(f_3368)
static void C_ccall f_3368(C_word c,C_word *av) C_noret;
C_noret_decl(f_3370)
static void C_ccall f_3370(C_word c,C_word *av) C_noret;
C_noret_decl(f_3374)
static void C_ccall f_3374(C_word c,C_word *av) C_noret;
C_noret_decl(f_3376)
static void C_ccall f_3376(C_word c,C_word *av) C_noret;
C_noret_decl(f_3380)
static void C_ccall f_3380(C_word c,C_word *av) C_noret;
C_noret_decl(f_3382)
static void C_ccall f_3382(C_word c,C_word *av) C_noret;
C_noret_decl(f_3386)
static void C_ccall f_3386(C_word c,C_word *av) C_noret;
C_noret_decl(f_3398)
static void C_ccall f_3398(C_word c,C_word *av) C_noret;
C_noret_decl(f_3401)
static void C_ccall f_3401(C_word c,C_word *av) C_noret;
C_noret_decl(f_3450)
static void C_ccall f_3450(C_word c,C_word *av) C_noret;
C_noret_decl(f_3454)
static void C_ccall f_3454(C_word c,C_word *av) C_noret;
C_noret_decl(f_3456)
static void C_ccall f_3456(C_word c,C_word *av) C_noret;
C_noret_decl(f_3462)
static void C_ccall f_3462(C_word c,C_word *av) C_noret;
C_noret_decl(f_3470)
static void C_ccall f_3470(C_word c,C_word *av) C_noret;
C_noret_decl(f_3474)
static void C_ccall f_3474(C_word c,C_word *av) C_noret;
C_noret_decl(f_3478)
static void C_ccall f_3478(C_word c,C_word *av) C_noret;
C_noret_decl(f_3480)
static void C_ccall f_3480(C_word c,C_word *av) C_noret;
C_noret_decl(f_3499)
static void C_ccall f_3499(C_word c,C_word *av) C_noret;
C_noret_decl(f_3567)
static void C_ccall f_3567(C_word c,C_word *av) C_noret;
C_noret_decl(f_3575)
static void C_ccall f_3575(C_word c,C_word *av) C_noret;
C_noret_decl(f_3577)
static void C_ccall f_3577(C_word c,C_word *av) C_noret;
C_noret_decl(f_3585)
static void C_ccall f_3585(C_word c,C_word *av) C_noret;
C_noret_decl(f_3587)
static void C_ccall f_3587(C_word c,C_word *av) C_noret;
C_noret_decl(f_3595)
static void C_ccall f_3595(C_word c,C_word *av) C_noret;
C_noret_decl(f_3597)
static void C_ccall f_3597(C_word c,C_word *av) C_noret;
C_noret_decl(f_3605)
static void C_ccall f_3605(C_word c,C_word *av) C_noret;
C_noret_decl(f_3607)
static void C_ccall f_3607(C_word c,C_word *av) C_noret;
C_noret_decl(f_3615)
static void C_ccall f_3615(C_word c,C_word *av) C_noret;
C_noret_decl(f_3617)
static void C_ccall f_3617(C_word c,C_word *av) C_noret;
C_noret_decl(f_3625)
static void C_ccall f_3625(C_word c,C_word *av) C_noret;
C_noret_decl(f_3627)
static void C_ccall f_3627(C_word c,C_word *av) C_noret;
C_noret_decl(f_3635)
static void C_ccall f_3635(C_word c,C_word *av) C_noret;
C_noret_decl(f_3640)
static void C_ccall f_3640(C_word c,C_word *av) C_noret;
C_noret_decl(f_3656)
static void C_ccall f_3656(C_word c,C_word *av) C_noret;
C_noret_decl(f_3662)
static void C_ccall f_3662(C_word c,C_word *av) C_noret;
C_noret_decl(f_3695)
static void C_ccall f_3695(C_word c,C_word *av) C_noret;
C_noret_decl(f_3723)
static void f_3723(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_3731)
static void C_ccall f_3731(C_word c,C_word *av) C_noret;
C_noret_decl(f_3756)
static void f_3756(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_3769)
static void C_ccall f_3769(C_word c,C_word *av) C_noret;
C_noret_decl(f_3778)
static void C_ccall f_3778(C_word c,C_word *av) C_noret;
C_noret_decl(f_3802)
static void C_ccall f_3802(C_word c,C_word *av) C_noret;
C_noret_decl(f_3828)
static void C_ccall f_3828(C_word c,C_word *av) C_noret;
C_noret_decl(f_3852)
static void C_ccall f_3852(C_word c,C_word *av) C_noret;
C_noret_decl(f_3878)
static void C_ccall f_3878(C_word c,C_word *av) C_noret;
C_noret_decl(f_3894)
static void C_ccall f_3894(C_word c,C_word *av) C_noret;
C_noret_decl(f_3903)
static void C_ccall f_3903(C_word c,C_word *av) C_noret;
C_noret_decl(f_3917)
static void C_ccall f_3917(C_word c,C_word *av) C_noret;
C_noret_decl(f_3923)
static void C_ccall f_3923(C_word c,C_word *av) C_noret;
C_noret_decl(f_3930)
static void f_3930(C_word t0,C_word t1) C_noret;
C_noret_decl(f_3933)
static void C_ccall f_3933(C_word c,C_word *av) C_noret;
C_noret_decl(f_3950)
static void C_ccall f_3950(C_word c,C_word *av) C_noret;
C_noret_decl(f_3953)
static void C_ccall f_3953(C_word c,C_word *av) C_noret;
C_noret_decl(f_3960)
static void C_ccall f_3960(C_word c,C_word *av) C_noret;
C_noret_decl(f_3969)
static void C_ccall f_3969(C_word c,C_word *av) C_noret;
C_noret_decl(f_3983)
static void C_ccall f_3983(C_word c,C_word *av) C_noret;
C_noret_decl(f_3986)
static void f_3986(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4005)
static void C_ccall f_4005(C_word c,C_word *av) C_noret;
C_noret_decl(f_4009)
static void C_ccall f_4009(C_word c,C_word *av) C_noret;
C_noret_decl(f_4012)
static void C_ccall f_4012(C_word c,C_word *av) C_noret;
C_noret_decl(f_4026)
static void C_ccall f_4026(C_word c,C_word *av) C_noret;
C_noret_decl(f_4030)
static void C_ccall f_4030(C_word c,C_word *av) C_noret;
C_noret_decl(f_4033)
static void C_ccall f_4033(C_word c,C_word *av) C_noret;
C_noret_decl(f_4058)
static void C_ccall f_4058(C_word c,C_word *av) C_noret;
C_noret_decl(f_4062)
static void C_ccall f_4062(C_word c,C_word *av) C_noret;
C_noret_decl(f_4065)
static void C_ccall f_4065(C_word c,C_word *av) C_noret;
C_noret_decl(f_4068)
static void C_ccall f_4068(C_word c,C_word *av) C_noret;
C_noret_decl(f_4096)
static void C_ccall f_4096(C_word c,C_word *av) C_noret;
C_noret_decl(f_4100)
static void C_ccall f_4100(C_word c,C_word *av) C_noret;
C_noret_decl(f_4104)
static void C_ccall f_4104(C_word c,C_word *av) C_noret;
C_noret_decl(f_4141)
static void C_ccall f_4141(C_word c,C_word *av) C_noret;
C_noret_decl(f_4148)
static void C_ccall f_4148(C_word c,C_word *av) C_noret;
C_noret_decl(f_4157)
static void C_ccall f_4157(C_word c,C_word *av) C_noret;
C_noret_decl(f_4167)
static void C_ccall f_4167(C_word c,C_word *av) C_noret;
C_noret_decl(f_4171)
static void C_ccall f_4171(C_word c,C_word *av) C_noret;
C_noret_decl(f_4174)
static void C_ccall f_4174(C_word c,C_word *av) C_noret;
C_noret_decl(f_4195)
static void C_ccall f_4195(C_word c,C_word *av) C_noret;
C_noret_decl(f_4203)
static void C_ccall f_4203(C_word c,C_word *av) C_noret;
C_noret_decl(f_4218)
static void C_ccall f_4218(C_word c,C_word *av) C_noret;
C_noret_decl(f_4220)
static void C_ccall f_4220(C_word c,C_word *av) C_noret;
C_noret_decl(f_4224)
static void C_ccall f_4224(C_word c,C_word *av) C_noret;
C_noret_decl(f_4225)
static void f_4225(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4234)
static void C_ccall f_4234(C_word c,C_word *av) C_noret;
C_noret_decl(f_4241)
static void C_ccall f_4241(C_word c,C_word *av) C_noret;
C_noret_decl(f_4242)
static void C_ccall f_4242(C_word c,C_word *av) C_noret;
C_noret_decl(f_4263)
static void f_4263(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4273)
static void C_ccall f_4273(C_word c,C_word *av) C_noret;
C_noret_decl(f_4286)
static void C_ccall f_4286(C_word c,C_word *av) C_noret;
C_noret_decl(f_4295)
static void C_ccall f_4295(C_word c,C_word *av) C_noret;
C_noret_decl(f_4312)
static void C_ccall f_4312(C_word c,C_word *av) C_noret;
C_noret_decl(f_4327)
static void C_ccall f_4327(C_word c,C_word *av) C_noret;
C_noret_decl(f_4345)
static void C_ccall f_4345(C_word c,C_word *av) C_noret;
C_noret_decl(f_4363)
static void C_ccall f_4363(C_word c,C_word *av) C_noret;
C_noret_decl(f_4381)
static void C_ccall f_4381(C_word c,C_word *av) C_noret;
C_noret_decl(f_4399)
static void C_ccall f_4399(C_word c,C_word *av) C_noret;
C_noret_decl(f_4417)
static void C_ccall f_4417(C_word c,C_word *av) C_noret;
C_noret_decl(f_4474)
static C_word f_4474(C_word t0,C_word t1);
C_noret_decl(f_4506)
static void C_ccall f_4506(C_word c,C_word *av) C_noret;
C_noret_decl(f_4512)
static void C_ccall f_4512(C_word c,C_word *av) C_noret;
C_noret_decl(f_4531)
static void f_4531(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4549)
static void f_4549(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4557)
static void C_ccall f_4557(C_word c,C_word *av) C_noret;
C_noret_decl(f_4563)
static void C_ccall f_4563(C_word c,C_word *av) C_noret;
C_noret_decl(f_4585)
static void f_4585(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4591)
static void C_ccall f_4591(C_word c,C_word *av) C_noret;
C_noret_decl(f_4600)
static void C_ccall f_4600(C_word c,C_word *av) C_noret;
C_noret_decl(f_4648)
static void f_4648(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4656)
static void C_ccall f_4656(C_word c,C_word *av) C_noret;
C_noret_decl(f_4659)
static void C_ccall f_4659(C_word c,C_word *av) C_noret;
C_noret_decl(f_4664)
static void C_ccall f_4664(C_word c,C_word *av) C_noret;
C_noret_decl(f_4670)
static void C_ccall f_4670(C_word c,C_word *av) C_noret;
C_noret_decl(f_4676)
static void C_ccall f_4676(C_word c,C_word *av) C_noret;
C_noret_decl(f_4680)
static void C_ccall f_4680(C_word c,C_word *av) C_noret;
C_noret_decl(f_4685)
static void C_ccall f_4685(C_word c,C_word *av) C_noret;
C_noret_decl(f_4687)
static void f_4687(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4691)
static void C_ccall f_4691(C_word c,C_word *av) C_noret;
C_noret_decl(f_4693)
static void f_4693(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_4709)
static void C_ccall f_4709(C_word c,C_word *av) C_noret;
C_noret_decl(f_4715)
static void C_ccall f_4715(C_word c,C_word *av) C_noret;
C_noret_decl(f_4718)
static void C_ccall f_4718(C_word c,C_word *av) C_noret;
C_noret_decl(f_4734)
static void C_ccall f_4734(C_word c,C_word *av) C_noret;
C_noret_decl(f_4744)
static void f_4744(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4750)
static void C_ccall f_4750(C_word c,C_word *av) C_noret;
C_noret_decl(f_4761)
static void C_ccall f_4761(C_word c,C_word *av) C_noret;
C_noret_decl(f_4765)
static void f_4765(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4769)
static void C_ccall f_4769(C_word c,C_word *av) C_noret;
C_noret_decl(f_4774)
static void f_4774(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4784)
static void C_ccall f_4784(C_word c,C_word *av) C_noret;
C_noret_decl(f_4787)
static void C_ccall f_4787(C_word c,C_word *av) C_noret;
C_noret_decl(f_4799)
static void f_4799(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4804)
static C_word f_4804(C_word t0,C_word t1);
C_noret_decl(f_4823)
static C_word f_4823(C_word t0,C_word t1);
C_noret_decl(f_4846)
static void C_ccall f_4846(C_word c,C_word *av) C_noret;
C_noret_decl(f_4848)
static void f_4848(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_noret;
C_noret_decl(f_4855)
static void C_ccall f_4855(C_word c,C_word *av) C_noret;
C_noret_decl(f_4858)
static void C_ccall f_4858(C_word c,C_word *av) C_noret;
C_noret_decl(f_4863)
static void C_ccall f_4863(C_word c,C_word *av) C_noret;
C_noret_decl(f_4869)
static void C_ccall f_4869(C_word c,C_word *av) C_noret;
C_noret_decl(f_4875)
static void C_ccall f_4875(C_word c,C_word *av) C_noret;
C_noret_decl(f_4879)
static void C_ccall f_4879(C_word c,C_word *av) C_noret;
C_noret_decl(f_4882)
static void C_ccall f_4882(C_word c,C_word *av) C_noret;
C_noret_decl(f_4890)
static void C_ccall f_4890(C_word c,C_word *av) C_noret;
C_noret_decl(f_4896)
static void C_ccall f_4896(C_word c,C_word *av) C_noret;
C_noret_decl(f_4900)
static void f_4900(C_word t0,C_word t1) C_noret;
C_noret_decl(f_4907)
static void C_ccall f_4907(C_word c,C_word *av) C_noret;
C_noret_decl(f_4910)
static void C_ccall f_4910(C_word c,C_word *av) C_noret;
C_noret_decl(f_4914)
static void C_ccall f_4914(C_word c,C_word *av) C_noret;
C_noret_decl(f_4935)
static void C_ccall f_4935(C_word c,C_word *av) C_noret;
C_noret_decl(f_4937)
static void f_4937(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_4962)
static void C_ccall f_4962(C_word c,C_word *av) C_noret;
C_noret_decl(f_4971)
static void C_ccall f_4971(C_word c,C_word *av) C_noret;
C_noret_decl(f_4977)
static void C_ccall f_4977(C_word c,C_word *av) C_noret;
C_noret_decl(f_5002)
static void f_5002(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5015)
static void C_ccall f_5015(C_word c,C_word *av) C_noret;
C_noret_decl(f_5021)
static void C_ccall f_5021(C_word c,C_word *av) C_noret;
C_noret_decl(f_5035)
static void C_ccall f_5035(C_word c,C_word *av) C_noret;
C_noret_decl(f_5042)
static void C_ccall f_5042(C_word c,C_word *av) C_noret;
C_noret_decl(f_5052)
static void C_ccall f_5052(C_word c,C_word *av) C_noret;
C_noret_decl(f_5061)
static void C_ccall f_5061(C_word c,C_word *av) C_noret;
C_noret_decl(f_5075)
static void C_ccall f_5075(C_word c,C_word *av) C_noret;
C_noret_decl(f_5082)
static void C_ccall f_5082(C_word c,C_word *av) C_noret;
C_noret_decl(f_5092)
static void C_ccall f_5092(C_word c,C_word *av) C_noret;
C_noret_decl(f_5101)
static void C_ccall f_5101(C_word c,C_word *av) C_noret;
C_noret_decl(f_5108)
static void C_ccall f_5108(C_word c,C_word *av) C_noret;
C_noret_decl(f_5116)
static void C_ccall f_5116(C_word c,C_word *av) C_noret;
C_noret_decl(f_5123)
static void C_ccall f_5123(C_word c,C_word *av) C_noret;
C_noret_decl(f_5131)
static void C_ccall f_5131(C_word c,C_word *av) C_noret;
C_noret_decl(f_5135)
static void C_ccall f_5135(C_word c,C_word *av) C_noret;
C_noret_decl(f_5140)
static void C_ccall f_5140(C_word c,C_word *av) C_noret;
C_noret_decl(f_5145)
static void C_ccall f_5145(C_word c,C_word *av) C_noret;
C_noret_decl(f_5151)
static void C_ccall f_5151(C_word c,C_word *av) C_noret;
C_noret_decl(f_5155)
static void C_ccall f_5155(C_word c,C_word *av) C_noret;
C_noret_decl(f_5160)
static void C_ccall f_5160(C_word c,C_word *av) C_noret;
C_noret_decl(f_5165)
static void C_ccall f_5165(C_word c,C_word *av) C_noret;
C_noret_decl(f_5169)
static void C_ccall f_5169(C_word c,C_word *av) C_noret;
C_noret_decl(f_5174)
static void C_ccall f_5174(C_word c,C_word *av) C_noret;
C_noret_decl(f_5180)
static void C_ccall f_5180(C_word c,C_word *av) C_noret;
C_noret_decl(f_5184)
static void C_ccall f_5184(C_word c,C_word *av) C_noret;
C_noret_decl(f_5189)
static void C_ccall f_5189(C_word c,C_word *av) C_noret;
C_noret_decl(f_5193)
static void C_ccall f_5193(C_word c,C_word *av) C_noret;
C_noret_decl(f_5198)
static void C_ccall f_5198(C_word c,C_word *av) C_noret;
C_noret_decl(f_5204)
static void C_ccall f_5204(C_word c,C_word *av) C_noret;
C_noret_decl(f_5208)
static void C_ccall f_5208(C_word c,C_word *av) C_noret;
C_noret_decl(f_5213)
static void C_ccall f_5213(C_word c,C_word *av) C_noret;
C_noret_decl(f_5217)
static void C_ccall f_5217(C_word c,C_word *av) C_noret;
C_noret_decl(f_5222)
static void C_ccall f_5222(C_word c,C_word *av) C_noret;
C_noret_decl(f_5227)
static void C_ccall f_5227(C_word c,C_word *av) C_noret;
C_noret_decl(f_5233)
static void C_ccall f_5233(C_word c,C_word *av) C_noret;
C_noret_decl(f_5237)
static void C_ccall f_5237(C_word c,C_word *av) C_noret;
C_noret_decl(f_5242)
static void C_ccall f_5242(C_word c,C_word *av) C_noret;
C_noret_decl(f_5247)
static void C_ccall f_5247(C_word c,C_word *av) C_noret;
C_noret_decl(f_5254)
static void C_ccall f_5254(C_word c,C_word *av) C_noret;
C_noret_decl(f_5294)
static void C_ccall f_5294(C_word c,C_word *av) C_noret;
C_noret_decl(f_5327)
static void C_ccall f_5327(C_word c,C_word *av) C_noret;
C_noret_decl(f_5344)
static void C_ccall f_5344(C_word c,C_word *av) C_noret;
C_noret_decl(f_5347)
static void C_ccall f_5347(C_word c,C_word *av) C_noret;
C_noret_decl(f_5359)
static void C_ccall f_5359(C_word c,C_word *av) C_noret;
C_noret_decl(f_5368)
static void C_ccall f_5368(C_word c,C_word *av) C_noret;
C_noret_decl(f_5390)
static void C_ccall f_5390(C_word c,C_word *av) C_noret;
C_noret_decl(f_5400)
static void C_ccall f_5400(C_word c,C_word *av) C_noret;
C_noret_decl(f_5403)
static void C_ccall f_5403(C_word c,C_word *av) C_noret;
C_noret_decl(f_5406)
static void C_ccall f_5406(C_word c,C_word *av) C_noret;
C_noret_decl(f_5427)
static void C_ccall f_5427(C_word c,C_word *av) C_noret;
C_noret_decl(f_5434)
static void C_ccall f_5434(C_word c,C_word *av) C_noret;
C_noret_decl(f_5443)
static void C_ccall f_5443(C_word c,C_word *av) C_noret;
C_noret_decl(f_5461)
static void C_ccall f_5461(C_word c,C_word *av) C_noret;
C_noret_decl(f_5468)
static void C_ccall f_5468(C_word c,C_word *av) C_noret;
C_noret_decl(f_5474)
static void C_ccall f_5474(C_word c,C_word *av) C_noret;
C_noret_decl(f_5481)
static void C_ccall f_5481(C_word c,C_word *av) C_noret;
C_noret_decl(f_5493)
static void C_ccall f_5493(C_word c,C_word *av) C_noret;
C_noret_decl(f_5500)
static void f_5500(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5503)
static void f_5503(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5511)
static void C_ccall f_5511(C_word c,C_word *av) C_noret;
C_noret_decl(f_5572)
static void C_ccall f_5572(C_word c,C_word *av) C_noret;
C_noret_decl(f_5575)
static void C_ccall f_5575(C_word c,C_word *av) C_noret;
C_noret_decl(f_5582)
static void f_5582(C_word t0,C_word t1) C_noret;
C_noret_decl(f_5612)
static void f_5612(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5671)
static void f_5671(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_5732)
static void C_ccall f_5732(C_word c,C_word *av) C_noret;
C_noret_decl(f_5739)
static void C_ccall f_5739(C_word c,C_word *av) C_noret;
C_noret_decl(f_5747)
static void C_ccall f_5747(C_word c,C_word *av) C_noret;
C_noret_decl(f_5749)
static C_word f_5749(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_5791)
static C_word f_5791(C_word t0,C_word t1,C_word t2);
C_noret_decl(f_5872)
static void C_ccall f_5872(C_word c,C_word *av) C_noret;
C_noret_decl(f_5879)
static void C_ccall f_5879(C_word c,C_word *av) C_noret;
C_noret_decl(f_5928)
static void C_ccall f_5928(C_word c,C_word *av) C_noret;
C_noret_decl(f_5952)
static C_word f_5952(C_word t0);
C_noret_decl(f_5977)
static void C_ccall f_5977(C_word c,C_word *av) C_noret;
C_noret_decl(f_5979)
static void C_ccall f_5979(C_word c,C_word *av) C_noret;
C_noret_decl(f_5985)
static void C_ccall f_5985(C_word c,C_word *av) C_noret;
C_noret_decl(f_6001)
static void C_ccall f_6001(C_word c,C_word *av) C_noret;
C_noret_decl(f_6019)
static void C_ccall f_6019(C_word c,C_word *av) C_noret;
C_noret_decl(f_6023)
static void C_ccall f_6023(C_word c,C_word *av) C_noret;
C_noret_decl(f_6027)
static void C_ccall f_6027(C_word c,C_word *av) C_noret;
C_noret_decl(f_6031)
static void C_ccall f_6031(C_word c,C_word *av) C_noret;
C_noret_decl(f_6033)
static void C_ccall f_6033(C_word c,C_word *av) C_noret;
C_noret_decl(f_6040)
static void f_6040(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6053)
static void C_ccall f_6053(C_word c,C_word *av) C_noret;
C_noret_decl(f_6057)
static void C_ccall f_6057(C_word c,C_word *av) C_noret;
C_noret_decl(f_6061)
static void C_ccall f_6061(C_word c,C_word *av) C_noret;
C_noret_decl(f_6065)
static void C_ccall f_6065(C_word c,C_word *av) C_noret;
C_noret_decl(f_6069)
static void C_ccall f_6069(C_word c,C_word *av) C_noret;
C_noret_decl(f_6079)
static void C_ccall f_6079(C_word c,C_word *av) C_noret;
C_noret_decl(f_6087)
static void C_ccall f_6087(C_word c,C_word *av) C_noret;
C_noret_decl(f_6095)
static void C_ccall f_6095(C_word c,C_word *av) C_noret;
C_noret_decl(f_6099)
static void C_ccall f_6099(C_word c,C_word *av) C_noret;
C_noret_decl(f_6101)
static void C_ccall f_6101(C_word c,C_word *av) C_noret;
C_noret_decl(f_6109)
static void C_ccall f_6109(C_word c,C_word *av) C_noret;
C_noret_decl(f_6113)
static void C_ccall f_6113(C_word c,C_word *av) C_noret;
C_noret_decl(f_6115)
static void f_6115(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6125)
static void C_ccall f_6125(C_word c,C_word *av) C_noret;
C_noret_decl(f_6137)
static void C_ccall f_6137(C_word c,C_word *av) C_noret;
C_noret_decl(f_6141)
static void C_ccall f_6141(C_word c,C_word *av) C_noret;
C_noret_decl(f_6157)
static void C_ccall f_6157(C_word c,C_word *av) C_noret;
C_noret_decl(f_6162)
static void C_ccall f_6162(C_word c,C_word *av) C_noret;
C_noret_decl(f_6166)
static void C_ccall f_6166(C_word c,C_word *av) C_noret;
C_noret_decl(f_6176)
static void C_ccall f_6176(C_word c,C_word *av) C_noret;
C_noret_decl(f_6180)
static void C_ccall f_6180(C_word c,C_word *av) C_noret;
C_noret_decl(f_6182)
static void C_ccall f_6182(C_word c,C_word *av) C_noret;
C_noret_decl(f_6203)
static void C_ccall f_6203(C_word c,C_word *av) C_noret;
C_noret_decl(f_6207)
static void C_ccall f_6207(C_word c,C_word *av) C_noret;
C_noret_decl(f_6211)
static void C_ccall f_6211(C_word c,C_word *av) C_noret;
C_noret_decl(f_6212)
static void C_ccall f_6212(C_word c,C_word *av) C_noret;
C_noret_decl(f_6217)
static void C_ccall f_6217(C_word c,C_word *av) C_noret;
C_noret_decl(f_6231)
static void C_ccall f_6231(C_word c,C_word *av) C_noret;
C_noret_decl(f_6246)
static void C_ccall f_6246(C_word c,C_word *av) C_noret;
C_noret_decl(f_6252)
static void C_ccall f_6252(C_word c,C_word *av) C_noret;
C_noret_decl(f_6260)
static void C_ccall f_6260(C_word c,C_word *av) C_noret;
C_noret_decl(f_6262)
static void f_6262(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_6272)
static void C_ccall f_6272(C_word c,C_word *av) C_noret;
C_noret_decl(f_6278)
static void C_ccall f_6278(C_word c,C_word *av) C_noret;
C_noret_decl(f_6287)
static void C_ccall f_6287(C_word c,C_word *av) C_noret;
C_noret_decl(f_6290)
static void C_ccall f_6290(C_word c,C_word *av) C_noret;
C_noret_decl(f_6293)
static void C_ccall f_6293(C_word c,C_word *av) C_noret;
C_noret_decl(f_6299)
static void C_ccall f_6299(C_word c,C_word *av) C_noret;
C_noret_decl(f_6333)
static void C_ccall f_6333(C_word c,C_word *av) C_noret;
C_noret_decl(f_6337)
static void C_ccall f_6337(C_word c,C_word *av) C_noret;
C_noret_decl(f_6346)
static void C_ccall f_6346(C_word c,C_word *av) C_noret;
C_noret_decl(f_6368)
static void C_ccall f_6368(C_word c,C_word *av) C_noret;
C_noret_decl(f_6402)
static void C_ccall f_6402(C_word c,C_word *av) C_noret;
C_noret_decl(f_6408)
static void C_ccall f_6408(C_word c,C_word *av) C_noret;
C_noret_decl(f_6409)
static void f_6409(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6413)
static void C_ccall f_6413(C_word c,C_word *av) C_noret;
C_noret_decl(f_6443)
static void f_6443(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6459)
static void C_ccall f_6459(C_word c,C_word *av) C_noret;
C_noret_decl(f_6461)
static void f_6461(C_word t0,C_word t1) C_noret;
C_noret_decl(f_6467)
static void C_ccall f_6467(C_word c,C_word *av) C_noret;
C_noret_decl(f_6494)
static void C_ccall f_6494(C_word c,C_word *av) C_noret;
C_noret_decl(f_6497)
static void C_ccall f_6497(C_word c,C_word *av) C_noret;
C_noret_decl(f_6524)
static void C_ccall f_6524(C_word c,C_word *av) C_noret;
C_noret_decl(f_6530)
static void C_ccall f_6530(C_word c,C_word *av) C_noret;
C_noret_decl(f_6564)
static void C_ccall f_6564(C_word c,C_word *av) C_noret;
C_noret_decl(f_6573)
static void C_ccall f_6573(C_word c,C_word *av) C_noret;
C_noret_decl(f_6577)
static void C_ccall f_6577(C_word c,C_word *av) C_noret;
C_noret_decl(f_6592)
static void C_ccall f_6592(C_word c,C_word *av) C_noret;
C_noret_decl(f_6605)
static void C_ccall f_6605(C_word c,C_word *av) C_noret;
C_noret_decl(f_6617)
static void C_ccall f_6617(C_word c,C_word *av) C_noret;
C_noret_decl(f_6621)
static void C_ccall f_6621(C_word c,C_word *av) C_noret;
C_noret_decl(f_6633)
static void C_ccall f_6633(C_word c,C_word *av) C_noret;
C_noret_decl(f_6637)
static void C_ccall f_6637(C_word c,C_word *av) C_noret;
C_noret_decl(f_6648)
static void C_ccall f_6648(C_word c,C_word *av) C_noret;
C_noret_decl(f_6658)
static void f_6658(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_6702)
static void C_ccall f_6702(C_word c,C_word *av) C_noret;
C_noret_decl(f_6720)
static void C_ccall f_6720(C_word c,C_word *av) C_noret;
C_noret_decl(f_6724)
static void C_ccall f_6724(C_word c,C_word *av) C_noret;
C_noret_decl(f_6738)
static void C_ccall f_6738(C_word c,C_word *av) C_noret;
C_noret_decl(f_6748)
static void C_ccall f_6748(C_word c,C_word *av) C_noret;
C_noret_decl(f_6768)
static void C_ccall f_6768(C_word c,C_word *av) C_noret;
C_noret_decl(f_6798)
static void C_ccall f_6798(C_word c,C_word *av) C_noret;
C_noret_decl(f_6843)
static void C_ccall f_6843(C_word c,C_word *av) C_noret;
C_noret_decl(f_6856)
static void C_ccall f_6856(C_word c,C_word *av) C_noret;
C_noret_decl(f_6938)
static void C_ccall f_6938(C_word c,C_word *av) C_noret;
C_noret_decl(f_6966)
static void C_ccall f_6966(C_word c,C_word *av) C_noret;
C_noret_decl(f_6967)
static void C_ccall f_6967(C_word c,C_word *av) C_noret;
C_noret_decl(f_6973)
static void C_ccall f_6973(C_word c,C_word *av) C_noret;
C_noret_decl(f_7000)
static void C_ccall f_7000(C_word c,C_word *av) C_noret;
C_noret_decl(f_7038)
static void f_7038(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7044)
static void C_ccall f_7044(C_word c,C_word *av) C_noret;
C_noret_decl(f_7053)
static void C_ccall f_7053(C_word c,C_word *av) C_noret;
C_noret_decl(f_7059)
static void C_ccall f_7059(C_word c,C_word *av) C_noret;
C_noret_decl(f_7063)
static void C_ccall f_7063(C_word c,C_word *av) C_noret;
C_noret_decl(f_7075)
static void C_ccall f_7075(C_word c,C_word *av) C_noret;
C_noret_decl(f_7083)
static void C_ccall f_7083(C_word c,C_word *av) C_noret;
C_noret_decl(f_7104)
static void C_ccall f_7104(C_word c,C_word *av) C_noret;
C_noret_decl(f_7105)
static void C_ccall f_7105(C_word c,C_word *av) C_noret;
C_noret_decl(f_7115)
static void C_ccall f_7115(C_word c,C_word *av) C_noret;
C_noret_decl(f_7134)
static void f_7134(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4) C_noret;
C_noret_decl(f_7144)
static void C_ccall f_7144(C_word c,C_word *av) C_noret;
C_noret_decl(f_7234)
static void C_ccall f_7234(C_word c,C_word *av) C_noret;
C_noret_decl(f_7238)
static void C_ccall f_7238(C_word c,C_word *av) C_noret;
C_noret_decl(f_7244)
static void f_7244(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7251)
static void C_ccall f_7251(C_word c,C_word *av) C_noret;
C_noret_decl(f_7258)
static void C_ccall f_7258(C_word c,C_word *av) C_noret;
C_noret_decl(f_7264)
static void C_ccall f_7264(C_word c,C_word *av) C_noret;
C_noret_decl(f_7268)
static void C_ccall f_7268(C_word c,C_word *av) C_noret;
C_noret_decl(f_7285)
static void f_7285(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7292)
static void C_ccall f_7292(C_word c,C_word *av) C_noret;
C_noret_decl(f_7298)
static void C_ccall f_7298(C_word c,C_word *av) C_noret;
C_noret_decl(f_7300)
static void C_ccall f_7300(C_word c,C_word *av) C_noret;
C_noret_decl(f_7309)
static void f_7309(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7314)
static void C_ccall f_7314(C_word c,C_word *av) C_noret;
C_noret_decl(f_7362)
static void C_ccall f_7362(C_word c,C_word *av) C_noret;
C_noret_decl(f_7371)
static void f_7371(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7376)
static void C_ccall f_7376(C_word c,C_word *av) C_noret;
C_noret_decl(f_7406)
static void C_ccall f_7406(C_word c,C_word *av) C_noret;
C_noret_decl(f_7412)
static void f_7412(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7417)
static void C_ccall f_7417(C_word c,C_word *av) C_noret;
C_noret_decl(f_7437)
static void C_ccall f_7437(C_word c,C_word *av) C_noret;
C_noret_decl(f_7461)
static void C_ccall f_7461(C_word c,C_word *av) C_noret;
C_noret_decl(f_7483)
static void C_ccall f_7483(C_word c,C_word *av) C_noret;
C_noret_decl(f_7500)
static void C_ccall f_7500(C_word c,C_word *av) C_noret;
C_noret_decl(f_7504)
static void C_ccall f_7504(C_word c,C_word *av) C_noret;
C_noret_decl(f_7512)
static void C_ccall f_7512(C_word c,C_word *av) C_noret;
C_noret_decl(f_7520)
static void C_ccall f_7520(C_word c,C_word *av) C_noret;
C_noret_decl(f_7524)
static void C_ccall f_7524(C_word c,C_word *av) C_noret;
C_noret_decl(f_7528)
static void C_ccall f_7528(C_word c,C_word *av) C_noret;
C_noret_decl(f_7539)
static void C_ccall f_7539(C_word c,C_word *av) C_noret;
C_noret_decl(f_7546)
static void C_ccall f_7546(C_word c,C_word *av) C_noret;
C_noret_decl(f_7558)
static void C_ccall f_7558(C_word c,C_word *av) C_noret;
C_noret_decl(f_7605)
static void C_ccall f_7605(C_word c,C_word *av) C_noret;
C_noret_decl(f_7613)
static void C_ccall f_7613(C_word c,C_word *av) C_noret;
C_noret_decl(f_7617)
static void C_ccall f_7617(C_word c,C_word *av) C_noret;
C_noret_decl(f_7625)
static void C_ccall f_7625(C_word c,C_word *av) C_noret;
C_noret_decl(f_7631)
static void C_ccall f_7631(C_word c,C_word *av) C_noret;
C_noret_decl(f_7664)
static void C_ccall f_7664(C_word c,C_word *av) C_noret;
C_noret_decl(f_7688)
static void C_ccall f_7688(C_word c,C_word *av) C_noret;
C_noret_decl(f_7691)
static void C_ccall f_7691(C_word c,C_word *av) C_noret;
C_noret_decl(f_7742)
static void f_7742(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7758)
static void C_ccall f_7758(C_word c,C_word *av) C_noret;
C_noret_decl(f_7780)
static void C_ccall f_7780(C_word c,C_word *av) C_noret;
C_noret_decl(f_7783)
static void C_ccall f_7783(C_word c,C_word *av) C_noret;
C_noret_decl(f_7790)
static void f_7790(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7832)
static void C_ccall f_7832(C_word c,C_word *av) C_noret;
C_noret_decl(f_7839)
static void C_ccall f_7839(C_word c,C_word *av) C_noret;
C_noret_decl(f_7875)
static void C_ccall f_7875(C_word c,C_word *av) C_noret;
C_noret_decl(f_7879)
static void f_7879(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5) C_noret;
C_noret_decl(f_7881)
static void C_ccall f_7881(C_word c,C_word *av) C_noret;
C_noret_decl(f_7888)
static void C_ccall f_7888(C_word c,C_word *av) C_noret;
C_noret_decl(f_7904)
static void f_7904(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7913)
static void C_ccall f_7913(C_word c,C_word *av) C_noret;
C_noret_decl(f_7919)
static void C_ccall f_7919(C_word c,C_word *av) C_noret;
C_noret_decl(f_7924)
static void f_7924(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_7935)
static void C_ccall f_7935(C_word c,C_word *av) C_noret;
C_noret_decl(f_7936)
static void f_7936(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_7947)
static void C_ccall f_7947(C_word c,C_word *av) C_noret;
C_noret_decl(f_7965)
static void f_7965(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_noret;
C_noret_decl(f_7969)
static void C_ccall f_7969(C_word c,C_word *av) C_noret;
C_noret_decl(f_7972)
static void C_ccall f_7972(C_word c,C_word *av) C_noret;
C_noret_decl(f_7975)
static void C_ccall f_7975(C_word c,C_word *av) C_noret;
C_noret_decl(f_7982)
static void f_7982(C_word t0,C_word t1) C_noret;
C_noret_decl(f_7986)
static void C_ccall f_7986(C_word c,C_word *av) C_noret;
C_noret_decl(f_7988)
static void C_ccall f_7988(C_word c,C_word *av) C_noret;
C_noret_decl(f_7992)
static void C_ccall f_7992(C_word c,C_word *av) C_noret;
C_noret_decl(f_7995)
static void C_ccall f_7995(C_word c,C_word *av) C_noret;
C_noret_decl(f_7998)
static void C_ccall f_7998(C_word c,C_word *av) C_noret;
C_noret_decl(f_8010)
static void f_8010(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_noret;
C_noret_decl(f_8014)
static void C_ccall f_8014(C_word c,C_word *av) C_noret;
C_noret_decl(f_8021)
static void f_8021(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7) C_noret;
C_noret_decl(f_8025)
static void C_ccall f_8025(C_word c,C_word *av) C_noret;
C_noret_decl(f_8032)
static void f_8032(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,C_word t9) C_noret;
C_noret_decl(f_8038)
static void C_ccall f_8038(C_word c,C_word *av) C_noret;
C_noret_decl(f_8044)
static void C_ccall f_8044(C_word c,C_word *av) C_noret;
C_noret_decl(f_8051)
static void C_ccall f_8051(C_word c,C_word *av) C_noret;
C_noret_decl(f_8054)
static void C_ccall f_8054(C_word c,C_word *av) C_noret;
C_noret_decl(f_8057)
static void C_ccall f_8057(C_word c,C_word *av) C_noret;
C_noret_decl(f_8061)
static void C_ccall f_8061(C_word c,C_word *av) C_noret;
C_noret_decl(f_8065)
static void C_ccall f_8065(C_word c,C_word *av) C_noret;
C_noret_decl(f_8069)
static void C_ccall f_8069(C_word c,C_word *av) C_noret;
C_noret_decl(f_8073)
static void C_ccall f_8073(C_word c,C_word *av) C_noret;
C_noret_decl(f_8077)
static void C_ccall f_8077(C_word c,C_word *av) C_noret;
C_noret_decl(f_8081)
static void C_ccall f_8081(C_word c,C_word *av) C_noret;
C_noret_decl(f_8094)
static void f_8094(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6) C_noret;
C_noret_decl(f_8096)
static void f_8096(C_word t0,C_word t1,C_word t2) C_noret;
C_noret_decl(f_8101)
static C_word f_8101(C_word t0,C_word t1);
C_noret_decl(f_8110)
static C_word f_8110(C_word t0,C_word t1);
C_noret_decl(f_8137)
static void C_ccall f_8137(C_word c,C_word *av) C_noret;
C_noret_decl(f_8140)
static void C_ccall f_8140(C_word c,C_word *av) C_noret;
C_noret_decl(f_8159)
static void C_ccall f_8159(C_word c,C_word *av) C_noret;
C_noret_decl(f_8237)
static void C_ccall f_8237(C_word c,C_word *av) C_noret;
C_noret_decl(f_8320)
static void C_ccall f_8320(C_word c,C_word *av) C_noret;
C_noret_decl(f_8325)
static void C_ccall f_8325(C_word c,C_word *av) C_noret;
C_noret_decl(f_8344)
static void C_ccall f_8344(C_word c,C_word *av) C_noret;
C_noret_decl(f_8350)
static void C_ccall f_8350(C_word c,C_word *av) C_noret;
C_noret_decl(f_8399)
static void C_ccall f_8399(C_word c,C_word *av) C_noret;
C_noret_decl(f_8406)
static void C_ccall f_8406(C_word c,C_word *av) C_noret;
C_noret_decl(f_8416)
static void C_ccall f_8416(C_word c,C_word *av) C_noret;
C_noret_decl(f_8418)
static void C_ccall f_8418(C_word c,C_word *av) C_noret;
C_noret_decl(f_8438)
static void C_ccall f_8438(C_word c,C_word *av) C_noret;
C_noret_decl(f_8441)
static void C_ccall f_8441(C_word c,C_word *av) C_noret;
C_noret_decl(f_8444)
static void C_ccall f_8444(C_word c,C_word *av) C_noret;
C_noret_decl(f_8461)
static void C_ccall f_8461(C_word c,C_word *av) C_noret;
C_noret_decl(f_8464)
static void C_ccall f_8464(C_word c,C_word *av) C_noret;
C_noret_decl(f_8467)
static void C_ccall f_8467(C_word c,C_word *av) C_noret;
C_noret_decl(f_8484)
static void C_ccall f_8484(C_word c,C_word *av) C_noret;
C_noret_decl(f_8487)
static void C_ccall f_8487(C_word c,C_word *av) C_noret;
C_noret_decl(f_8490)
static void C_ccall f_8490(C_word c,C_word *av) C_noret;
C_noret_decl(f_8507)
static void C_ccall f_8507(C_word c,C_word *av) C_noret;
C_noret_decl(f_8510)
static void C_ccall f_8510(C_word c,C_word *av) C_noret;
C_noret_decl(f_8513)
static void C_ccall f_8513(C_word c,C_word *av) C_noret;
C_noret_decl(f_8530)
static void C_ccall f_8530(C_word c,C_word *av) C_noret;
C_noret_decl(f_8533)
static void C_ccall f_8533(C_word c,C_word *av) C_noret;
C_noret_decl(f_8539)
static void f_8539(C_word t0,C_word t1,C_word t2,C_word t3) C_noret;
C_noret_decl(f_8563)
static void C_ccall f_8563(C_word c,C_word *av) C_noret;
C_noret_decl(f_8572)
static void C_ccall f_8572(C_word c,C_word *av) C_noret;
C_noret_decl(f_8597)
static void C_ccall f_8597(C_word c,C_word *av) C_noret;
C_noret_decl(f_8603)
static void C_ccall f_8603(C_word c,C_word *av) C_noret;
C_noret_decl(f_8607)
static void C_ccall f_8607(C_word c,C_word *av) C_noret;
C_noret_decl(f_8610)
static void C_ccall f_8610(C_word c,C_word *av) C_noret;
C_noret_decl(f_8619)
static void C_ccall f_8619(C_word c,C_word *av) C_noret;
C_noret_decl(f_8640)
static void C_ccall f_8640(C_word c,C_word *av) C_noret;
C_noret_decl(f_8644)
static void C_ccall f_8644(C_word c,C_word *av) C_noret;
C_noret_decl(f_8646)
static void C_ccall f_8646(C_word c,C_word *av) C_noret;
C_noret_decl(f_8650)
static void C_ccall f_8650(C_word c,C_word *av) C_noret;
C_noret_decl(f_8652)
static void C_ccall f_8652(C_word c,C_word *av) C_noret;
C_noret_decl(f_8656)
static void C_ccall f_8656(C_word c,C_word *av) C_noret;
C_noret_decl(C_posix_toplevel)
C_extern void C_ccall C_posix_toplevel(C_word c,C_word *av) C_noret;
C_noret_decl(va9621)
static void va9621(C_word t0,C_word t1) C_noret;
C_noret_decl(va9623)
static void va9623(C_word t0,C_word t1) C_noret;
C_noret_decl(va9625)
static void va9625(C_word t0,C_word t1) C_noret;
C_noret_decl(va9627)
static void va9627(C_word t0,C_word t1) C_noret;

C_noret_decl(trf_3055)
static void C_ccall trf_3055(C_word c,C_word *av) C_noret;
static void C_ccall trf_3055(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_3055(t0,t1,t2);}

C_noret_decl(trf_3096)
static void C_ccall trf_3096(C_word c,C_word *av) C_noret;
static void C_ccall trf_3096(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_3096(t0,t1,t2);}

C_noret_decl(trf_3256)
static void C_ccall trf_3256(C_word c,C_word *av) C_noret;
static void C_ccall trf_3256(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_3256(t0,t1,t2,t3,t4);}

C_noret_decl(trf_3723)
static void C_ccall trf_3723(C_word c,C_word *av) C_noret;
static void C_ccall trf_3723(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_3723(t0,t1,t2,t3);}

C_noret_decl(trf_3756)
static void C_ccall trf_3756(C_word c,C_word *av) C_noret;
static void C_ccall trf_3756(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_3756(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_3930)
static void C_ccall trf_3930(C_word c,C_word *av) C_noret;
static void C_ccall trf_3930(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_3930(t0,t1);}

C_noret_decl(trf_3986)
static void C_ccall trf_3986(C_word c,C_word *av) C_noret;
static void C_ccall trf_3986(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_3986(t0,t1,t2);}

C_noret_decl(trf_4225)
static void C_ccall trf_4225(C_word c,C_word *av) C_noret;
static void C_ccall trf_4225(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_4225(t0,t1,t2);}

C_noret_decl(trf_4263)
static void C_ccall trf_4263(C_word c,C_word *av) C_noret;
static void C_ccall trf_4263(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_4263(t0,t1,t2);}

C_noret_decl(trf_4531)
static void C_ccall trf_4531(C_word c,C_word *av) C_noret;
static void C_ccall trf_4531(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4531(t0,t1);}

C_noret_decl(trf_4549)
static void C_ccall trf_4549(C_word c,C_word *av) C_noret;
static void C_ccall trf_4549(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4549(t0,t1);}

C_noret_decl(trf_4585)
static void C_ccall trf_4585(C_word c,C_word *av) C_noret;
static void C_ccall trf_4585(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4585(t0,t1);}

C_noret_decl(trf_4648)
static void C_ccall trf_4648(C_word c,C_word *av) C_noret;
static void C_ccall trf_4648(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_4648(t0,t1,t2,t3);}

C_noret_decl(trf_4687)
static void C_ccall trf_4687(C_word c,C_word *av) C_noret;
static void C_ccall trf_4687(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4687(t0,t1);}

C_noret_decl(trf_4693)
static void C_ccall trf_4693(C_word c,C_word *av) C_noret;
static void C_ccall trf_4693(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_4693(t0,t1,t2,t3);}

C_noret_decl(trf_4744)
static void C_ccall trf_4744(C_word c,C_word *av) C_noret;
static void C_ccall trf_4744(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_4744(t0,t1,t2);}

C_noret_decl(trf_4765)
static void C_ccall trf_4765(C_word c,C_word *av) C_noret;
static void C_ccall trf_4765(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4765(t0,t1);}

C_noret_decl(trf_4774)
static void C_ccall trf_4774(C_word c,C_word *av) C_noret;
static void C_ccall trf_4774(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_4774(t0,t1,t2);}

C_noret_decl(trf_4799)
static void C_ccall trf_4799(C_word c,C_word *av) C_noret;
static void C_ccall trf_4799(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_4799(t0,t1,t2);}

C_noret_decl(trf_4848)
static void C_ccall trf_4848(C_word c,C_word *av) C_noret;
static void C_ccall trf_4848(C_word c,C_word *av){
C_word t0=av[7];
C_word t1=av[6];
C_word t2=av[5];
C_word t3=av[4];
C_word t4=av[3];
C_word t5=av[2];
C_word t6=av[1];
C_word t7=av[0];
f_4848(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(trf_4900)
static void C_ccall trf_4900(C_word c,C_word *av) C_noret;
static void C_ccall trf_4900(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_4900(t0,t1);}

C_noret_decl(trf_4937)
static void C_ccall trf_4937(C_word c,C_word *av) C_noret;
static void C_ccall trf_4937(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_4937(t0,t1,t2);}

C_noret_decl(trf_5002)
static void C_ccall trf_5002(C_word c,C_word *av) C_noret;
static void C_ccall trf_5002(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_5002(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5500)
static void C_ccall trf_5500(C_word c,C_word *av) C_noret;
static void C_ccall trf_5500(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_5500(t0,t1);}

C_noret_decl(trf_5503)
static void C_ccall trf_5503(C_word c,C_word *av) C_noret;
static void C_ccall trf_5503(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_5503(t0,t1);}

C_noret_decl(trf_5582)
static void C_ccall trf_5582(C_word c,C_word *av) C_noret;
static void C_ccall trf_5582(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_5582(t0,t1);}

C_noret_decl(trf_5612)
static void C_ccall trf_5612(C_word c,C_word *av) C_noret;
static void C_ccall trf_5612(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_5612(t0,t1,t2,t3,t4);}

C_noret_decl(trf_5671)
static void C_ccall trf_5671(C_word c,C_word *av) C_noret;
static void C_ccall trf_5671(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_5671(t0,t1,t2,t3,t4);}

C_noret_decl(trf_6040)
static void C_ccall trf_6040(C_word c,C_word *av) C_noret;
static void C_ccall trf_6040(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_6040(t0,t1);}

C_noret_decl(trf_6115)
static void C_ccall trf_6115(C_word c,C_word *av) C_noret;
static void C_ccall trf_6115(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_6115(t0,t1,t2,t3,t4);}

C_noret_decl(trf_6262)
static void C_ccall trf_6262(C_word c,C_word *av) C_noret;
static void C_ccall trf_6262(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_6262(t0,t1,t2,t3);}

C_noret_decl(trf_6409)
static void C_ccall trf_6409(C_word c,C_word *av) C_noret;
static void C_ccall trf_6409(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_6409(t0,t1);}

C_noret_decl(trf_6443)
static void C_ccall trf_6443(C_word c,C_word *av) C_noret;
static void C_ccall trf_6443(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_6443(t0,t1);}

C_noret_decl(trf_6461)
static void C_ccall trf_6461(C_word c,C_word *av) C_noret;
static void C_ccall trf_6461(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_6461(t0,t1);}

C_noret_decl(trf_6658)
static void C_ccall trf_6658(C_word c,C_word *av) C_noret;
static void C_ccall trf_6658(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_6658(t0,t1,t2,t3,t4);}

C_noret_decl(trf_7038)
static void C_ccall trf_7038(C_word c,C_word *av) C_noret;
static void C_ccall trf_7038(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_7038(t0,t1);}

C_noret_decl(trf_7134)
static void C_ccall trf_7134(C_word c,C_word *av) C_noret;
static void C_ccall trf_7134(C_word c,C_word *av){
C_word t0=av[4];
C_word t1=av[3];
C_word t2=av[2];
C_word t3=av[1];
C_word t4=av[0];
f_7134(t0,t1,t2,t3,t4);}

C_noret_decl(trf_7244)
static void C_ccall trf_7244(C_word c,C_word *av) C_noret;
static void C_ccall trf_7244(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_7244(t0,t1);}

C_noret_decl(trf_7285)
static void C_ccall trf_7285(C_word c,C_word *av) C_noret;
static void C_ccall trf_7285(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_7285(t0,t1,t2);}

C_noret_decl(trf_7309)
static void C_ccall trf_7309(C_word c,C_word *av) C_noret;
static void C_ccall trf_7309(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_7309(t0,t1);}

C_noret_decl(trf_7371)
static void C_ccall trf_7371(C_word c,C_word *av) C_noret;
static void C_ccall trf_7371(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_7371(t0,t1);}

C_noret_decl(trf_7412)
static void C_ccall trf_7412(C_word c,C_word *av) C_noret;
static void C_ccall trf_7412(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_7412(t0,t1);}

C_noret_decl(trf_7742)
static void C_ccall trf_7742(C_word c,C_word *av) C_noret;
static void C_ccall trf_7742(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_7742(t0,t1,t2);}

C_noret_decl(trf_7790)
static void C_ccall trf_7790(C_word c,C_word *av) C_noret;
static void C_ccall trf_7790(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_7790(t0,t1);}

C_noret_decl(trf_7879)
static void C_ccall trf_7879(C_word c,C_word *av) C_noret;
static void C_ccall trf_7879(C_word c,C_word *av){
C_word t0=av[5];
C_word t1=av[4];
C_word t2=av[3];
C_word t3=av[2];
C_word t4=av[1];
C_word t5=av[0];
f_7879(t0,t1,t2,t3,t4,t5);}

C_noret_decl(trf_7904)
static void C_ccall trf_7904(C_word c,C_word *av) C_noret;
static void C_ccall trf_7904(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_7904(t0,t1);}

C_noret_decl(trf_7924)
static void C_ccall trf_7924(C_word c,C_word *av) C_noret;
static void C_ccall trf_7924(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_7924(t0,t1,t2);}

C_noret_decl(trf_7936)
static void C_ccall trf_7936(C_word c,C_word *av) C_noret;
static void C_ccall trf_7936(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_7936(t0,t1,t2,t3);}

C_noret_decl(trf_7965)
static void C_ccall trf_7965(C_word c,C_word *av) C_noret;
static void C_ccall trf_7965(C_word c,C_word *av){
C_word t0=av[7];
C_word t1=av[6];
C_word t2=av[5];
C_word t3=av[4];
C_word t4=av[3];
C_word t5=av[2];
C_word t6=av[1];
C_word t7=av[0];
f_7965(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(trf_7982)
static void C_ccall trf_7982(C_word c,C_word *av) C_noret;
static void C_ccall trf_7982(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
f_7982(t0,t1);}

C_noret_decl(trf_8010)
static void C_ccall trf_8010(C_word c,C_word *av) C_noret;
static void C_ccall trf_8010(C_word c,C_word *av){
C_word t0=av[7];
C_word t1=av[6];
C_word t2=av[5];
C_word t3=av[4];
C_word t4=av[3];
C_word t5=av[2];
C_word t6=av[1];
C_word t7=av[0];
f_8010(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(trf_8021)
static void C_ccall trf_8021(C_word c,C_word *av) C_noret;
static void C_ccall trf_8021(C_word c,C_word *av){
C_word t0=av[7];
C_word t1=av[6];
C_word t2=av[5];
C_word t3=av[4];
C_word t4=av[3];
C_word t5=av[2];
C_word t6=av[1];
C_word t7=av[0];
f_8021(t0,t1,t2,t3,t4,t5,t6,t7);}

C_noret_decl(trf_8032)
static void C_ccall trf_8032(C_word c,C_word *av) C_noret;
static void C_ccall trf_8032(C_word c,C_word *av){
C_word t0=av[9];
C_word t1=av[8];
C_word t2=av[7];
C_word t3=av[6];
C_word t4=av[5];
C_word t5=av[4];
C_word t6=av[3];
C_word t7=av[2];
C_word t8=av[1];
C_word t9=av[0];
f_8032(t0,t1,t2,t3,t4,t5,t6,t7,t8,t9);}

C_noret_decl(trf_8094)
static void C_ccall trf_8094(C_word c,C_word *av) C_noret;
static void C_ccall trf_8094(C_word c,C_word *av){
C_word t0=av[6];
C_word t1=av[5];
C_word t2=av[4];
C_word t3=av[3];
C_word t4=av[2];
C_word t5=av[1];
C_word t6=av[0];
f_8094(t0,t1,t2,t3,t4,t5,t6);}

C_noret_decl(trf_8096)
static void C_ccall trf_8096(C_word c,C_word *av) C_noret;
static void C_ccall trf_8096(C_word c,C_word *av){
C_word t0=av[2];
C_word t1=av[1];
C_word t2=av[0];
f_8096(t0,t1,t2);}

C_noret_decl(trf_8539)
static void C_ccall trf_8539(C_word c,C_word *av) C_noret;
static void C_ccall trf_8539(C_word c,C_word *av){
C_word t0=av[3];
C_word t1=av[2];
C_word t2=av[1];
C_word t3=av[0];
f_8539(t0,t1,t2,t3);}

C_noret_decl(trva9621)
static void C_ccall trva9621(C_word c,C_word *av) C_noret;
static void C_ccall trva9621(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
va9621(t0,t1);}

C_noret_decl(trva9623)
static void C_ccall trva9623(C_word c,C_word *av) C_noret;
static void C_ccall trva9623(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
va9623(t0,t1);}

C_noret_decl(trva9625)
static void C_ccall trva9625(C_word c,C_word *av) C_noret;
static void C_ccall trva9625(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
va9625(t0,t1);}

C_noret_decl(trva9627)
static void C_ccall trva9627(C_word c,C_word *av) C_noret;
static void C_ccall trva9627(C_word c,C_word *av){
C_word t0=av[1];
C_word t1=av[0];
va9627(t0,t1);}

/* f9632 in chicken.time.posix#seconds->local-time in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f9632(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f9632,c,av);}
/* posix-common.scm:592: decode-seconds */
{C_proc tp=(C_proc)C_fast_retrieve_proc(lf[264]);
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=lf[264];
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}

/* f9636 in chicken.time.posix#seconds->utc-time in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f9636(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f9636,c,av);}
/* posix-common.scm:597: decode-seconds */
{C_proc tp=(C_proc)C_fast_retrieve_proc(lf[264]);
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=lf[264];
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=C_SCHEME_TRUE;
tp(4,av2);}}

/* f9684 in k7837 in chicken.process#process-run in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f9684(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f9684,c,av);}
a=C_alloc(6);
t2=(C_truep(t1)?t1:lf[438]);
t3=C_a_i_list2(&a,2,lf[439],((C_word*)t0)[2]);
/* posixunix.scm:1188: chicken.process#process-execute */
t4=*((C_word*)lf[106]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
av2[3]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* f9690 in %process in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f9690(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f9690,c,av);}
t2=(C_truep(t1)?t1:lf[438]);
t3=C_mutate(((C_word *)((C_word*)t0)[2])+1,t2);
t4=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
f_8137(2,av2);}}

/* k2904 */
static void C_ccall f_2906(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_2906,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2909,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);{
C_word *av2=av;
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t2;
C_pathname_toplevel(2,av2);}}

/* k2907 in k2904 */
static void C_ccall f_2909(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_2909,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2912,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);{
C_word *av2=av;
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t2;
C_extras_toplevel(2,av2);}}

/* k2910 in k2907 in k2904 */
static void C_ccall f_2912(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_2912,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2915,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);{
C_word *av2=av;
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t2;
C_port_toplevel(2,av2);}}

/* k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_2915(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_2915,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2918,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);{
C_word *av2=av;
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t2;
C_lolevel_toplevel(2,av2);}}

/* k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_2918(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(19,c,2)))){
C_save_and_reclaim((void *)f_2918,c,av);}
a=C_alloc(19);
t2=C_a_i_provide(&a,1,lf[0]);
t3=C_a_i_provide(&a,1,lf[1]);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2921,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);{
C_word *av2=av;
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t4;
C_library_toplevel(2,av2);}}

/* k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_2921(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word t80;
C_word t81;
C_word t82;
C_word t83;
C_word t84;
C_word t85;
C_word t86;
C_word t87;
C_word t88;
C_word t89;
C_word t90;
C_word t91;
C_word t92;
C_word t93;
C_word t94;
C_word t95;
C_word t96;
C_word t97;
C_word t98;
C_word t99;
C_word t100;
C_word t101;
C_word t102;
C_word t103;
C_word t104;
C_word t105;
C_word t106;
C_word t107;
C_word t108;
C_word t109;
C_word t110;
C_word t111;
C_word t112;
C_word t113;
C_word t114;
C_word t115;
C_word t116;
C_word t117;
C_word t118;
C_word t119;
C_word t120;
C_word t121;
C_word t122;
C_word t123;
C_word t124;
C_word t125;
C_word t126;
C_word t127;
C_word t128;
C_word t129;
C_word t130;
C_word t131;
C_word t132;
C_word t133;
C_word t134;
C_word t135;
C_word t136;
C_word t137;
C_word t138;
C_word t139;
C_word t140;
C_word t141;
C_word t142;
C_word t143;
C_word t144;
C_word t145;
C_word t146;
C_word t147;
C_word t148;
C_word t149;
C_word t150;
C_word t151;
C_word t152;
C_word t153;
C_word t154;
C_word t155;
C_word t156;
C_word t157;
C_word t158;
C_word t159;
C_word t160;
C_word t161;
C_word t162;
C_word t163;
C_word t164;
C_word t165;
C_word t166;
C_word t167;
C_word t168;
C_word t169;
C_word t170;
C_word t171;
C_word t172;
C_word t173;
C_word t174;
C_word t175;
C_word t176;
C_word t177;
C_word t178;
C_word t179;
C_word t180;
C_word t181;
C_word t182;
C_word t183;
C_word t184;
C_word t185;
C_word t186;
C_word t187;
C_word t188;
C_word t189;
C_word t190;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(88,c,6)))){
C_save_and_reclaim((void *)f_2921,c,av);}
a=C_alloc(88);
t2=C_set_block_item(lf[2] /* chicken.file.posix#create-fifo */,0,C_SCHEME_UNDEFINED);
t3=C_set_block_item(lf[3] /* chicken.file.posix#create-symbolic-link */,0,C_SCHEME_UNDEFINED);
t4=C_set_block_item(lf[4] /* chicken.file.posix#read-symbolic-link */,0,C_SCHEME_UNDEFINED);
t5=C_set_block_item(lf[5] /* chicken.file.posix#duplicate-fileno */,0,C_SCHEME_UNDEFINED);
t6=C_set_block_item(lf[6] /* chicken.file.posix#fcntl/dupfd */,0,C_SCHEME_UNDEFINED);
t7=C_set_block_item(lf[7] /* chicken.file.posix#fcntl/getfd */,0,C_SCHEME_UNDEFINED);
t8=C_set_block_item(lf[8] /* chicken.file.posix#fcntl/getfl */,0,C_SCHEME_UNDEFINED);
t9=C_set_block_item(lf[9] /* chicken.file.posix#fcntl/setfd */,0,C_SCHEME_UNDEFINED);
t10=C_set_block_item(lf[10] /* chicken.file.posix#fcntl/setfl */,0,C_SCHEME_UNDEFINED);
t11=C_set_block_item(lf[11] /* chicken.file.posix#file-close */,0,C_SCHEME_UNDEFINED);
t12=C_set_block_item(lf[12] /* chicken.file.posix#file-control */,0,C_SCHEME_UNDEFINED);
t13=C_set_block_item(lf[13] /* chicken.file.posix#file-creation-mode */,0,C_SCHEME_UNDEFINED);
t14=C_set_block_item(lf[14] /* chicken.file.posix#file-group */,0,C_SCHEME_UNDEFINED);
t15=C_set_block_item(lf[15] /* chicken.file.posix#file-link */,0,C_SCHEME_UNDEFINED);
t16=C_set_block_item(lf[16] /* chicken.file.posix#file-lock */,0,C_SCHEME_UNDEFINED);
t17=C_set_block_item(lf[17] /* chicken.file.posix#file-lock/blocking */,0,C_SCHEME_UNDEFINED);
t18=C_set_block_item(lf[18] /* chicken.file.posix#file-mkstemp */,0,C_SCHEME_UNDEFINED);
t19=C_set_block_item(lf[19] /* chicken.file.posix#file-open */,0,C_SCHEME_UNDEFINED);
t20=C_set_block_item(lf[20] /* chicken.file.posix#file-owner */,0,C_SCHEME_UNDEFINED);
t21=C_set_block_item(lf[21] /* chicken.file.posix#file-permissions */,0,C_SCHEME_UNDEFINED);
t22=C_set_block_item(lf[22] /* chicken.file.posix#file-position */,0,C_SCHEME_UNDEFINED);
t23=C_set_block_item(lf[23] /* chicken.file.posix#file-read */,0,C_SCHEME_UNDEFINED);
t24=C_set_block_item(lf[24] /* chicken.file.posix#file-select */,0,C_SCHEME_UNDEFINED);
t25=C_set_block_item(lf[25] /* chicken.file.posix#file-truncate */,0,C_SCHEME_UNDEFINED);
t26=C_set_block_item(lf[26] /* chicken.file.posix#file-unlock */,0,C_SCHEME_UNDEFINED);
t27=C_set_block_item(lf[27] /* chicken.file.posix#file-write */,0,C_SCHEME_UNDEFINED);
t28=C_set_block_item(lf[28] /* chicken.file.posix#file-type */,0,C_SCHEME_UNDEFINED);
t29=C_set_block_item(lf[29] /* chicken.file.posix#block-device? */,0,C_SCHEME_UNDEFINED);
t30=C_set_block_item(lf[30] /* chicken.file.posix#character-device? */,0,C_SCHEME_UNDEFINED);
t31=C_set_block_item(lf[31] /* chicken.file.posix#directory? */,0,C_SCHEME_UNDEFINED);
t32=C_set_block_item(lf[32] /* chicken.file.posix#fifo? */,0,C_SCHEME_UNDEFINED);
t33=C_set_block_item(lf[33] /* chicken.file.posix#regular-file? */,0,C_SCHEME_UNDEFINED);
t34=C_set_block_item(lf[34] /* chicken.file.posix#socket? */,0,C_SCHEME_UNDEFINED);
t35=C_set_block_item(lf[35] /* chicken.file.posix#symbolic-link? */,0,C_SCHEME_UNDEFINED);
t36=C_set_block_item(lf[36] /* chicken.file.posix#fileno/stderr */,0,C_SCHEME_UNDEFINED);
t37=C_set_block_item(lf[37] /* chicken.file.posix#fileno/stdin */,0,C_SCHEME_UNDEFINED);
t38=C_set_block_item(lf[38] /* chicken.file.posix#fileno/stdout */,0,C_SCHEME_UNDEFINED);
t39=C_set_block_item(lf[39] /* chicken.file.posix#open-input-file* */,0,C_SCHEME_UNDEFINED);
t40=C_set_block_item(lf[40] /* chicken.file.posix#open-output-file* */,0,C_SCHEME_UNDEFINED);
t41=C_set_block_item(lf[41] /* chicken.file.posix#open/append */,0,C_SCHEME_UNDEFINED);
t42=C_set_block_item(lf[42] /* chicken.file.posix#open/binary */,0,C_SCHEME_UNDEFINED);
t43=C_set_block_item(lf[43] /* chicken.file.posix#open/creat */,0,C_SCHEME_UNDEFINED);
t44=C_set_block_item(lf[44] /* chicken.file.posix#open/excl */,0,C_SCHEME_UNDEFINED);
t45=C_set_block_item(lf[45] /* chicken.file.posix#open/fsync */,0,C_SCHEME_UNDEFINED);
t46=C_set_block_item(lf[46] /* chicken.file.posix#open/noctty */,0,C_SCHEME_UNDEFINED);
t47=C_set_block_item(lf[47] /* chicken.file.posix#open/noinherit */,0,C_SCHEME_UNDEFINED);
t48=C_set_block_item(lf[48] /* chicken.file.posix#open/nonblock */,0,C_SCHEME_UNDEFINED);
t49=C_set_block_item(lf[49] /* chicken.file.posix#open/rdonly */,0,C_SCHEME_UNDEFINED);
t50=C_set_block_item(lf[50] /* chicken.file.posix#open/rdwr */,0,C_SCHEME_UNDEFINED);
t51=C_set_block_item(lf[51] /* chicken.file.posix#open/read */,0,C_SCHEME_UNDEFINED);
t52=C_set_block_item(lf[52] /* chicken.file.posix#open/sync */,0,C_SCHEME_UNDEFINED);
t53=C_set_block_item(lf[53] /* chicken.file.posix#open/text */,0,C_SCHEME_UNDEFINED);
t54=C_set_block_item(lf[54] /* chicken.file.posix#open/trunc */,0,C_SCHEME_UNDEFINED);
t55=C_set_block_item(lf[55] /* chicken.file.posix#open/write */,0,C_SCHEME_UNDEFINED);
t56=C_set_block_item(lf[56] /* chicken.file.posix#open/wronly */,0,C_SCHEME_UNDEFINED);
t57=C_set_block_item(lf[57] /* chicken.file.posix#perm/irgrp */,0,C_SCHEME_UNDEFINED);
t58=C_set_block_item(lf[58] /* chicken.file.posix#perm/iroth */,0,C_SCHEME_UNDEFINED);
t59=C_set_block_item(lf[59] /* chicken.file.posix#perm/irusr */,0,C_SCHEME_UNDEFINED);
t60=C_set_block_item(lf[60] /* chicken.file.posix#perm/irwxg */,0,C_SCHEME_UNDEFINED);
t61=C_set_block_item(lf[61] /* chicken.file.posix#perm/irwxo */,0,C_SCHEME_UNDEFINED);
t62=C_set_block_item(lf[62] /* chicken.file.posix#perm/irwxu */,0,C_SCHEME_UNDEFINED);
t63=C_set_block_item(lf[63] /* chicken.file.posix#perm/isgid */,0,C_SCHEME_UNDEFINED);
t64=C_set_block_item(lf[64] /* chicken.file.posix#perm/isuid */,0,C_SCHEME_UNDEFINED);
t65=C_set_block_item(lf[65] /* chicken.file.posix#perm/isvtx */,0,C_SCHEME_UNDEFINED);
t66=C_set_block_item(lf[66] /* chicken.file.posix#perm/iwgrp */,0,C_SCHEME_UNDEFINED);
t67=C_set_block_item(lf[67] /* chicken.file.posix#perm/iwoth */,0,C_SCHEME_UNDEFINED);
t68=C_set_block_item(lf[68] /* chicken.file.posix#perm/iwusr */,0,C_SCHEME_UNDEFINED);
t69=C_set_block_item(lf[69] /* chicken.file.posix#perm/ixgrp */,0,C_SCHEME_UNDEFINED);
t70=C_set_block_item(lf[70] /* chicken.file.posix#perm/ixoth */,0,C_SCHEME_UNDEFINED);
t71=C_set_block_item(lf[71] /* chicken.file.posix#perm/ixusr */,0,C_SCHEME_UNDEFINED);
t72=C_set_block_item(lf[72] /* chicken.file.posix#port->fileno */,0,C_SCHEME_UNDEFINED);
t73=C_set_block_item(lf[73] /* chicken.file.posix#seek/cur */,0,C_SCHEME_UNDEFINED);
t74=C_set_block_item(lf[74] /* chicken.file.posix#seek/end */,0,C_SCHEME_UNDEFINED);
t75=C_set_block_item(lf[75] /* chicken.file.posix#seek/set */,0,C_SCHEME_UNDEFINED);
t76=C_set_block_item(lf[76] /* chicken.file.posix#set-file-position! */,0,C_SCHEME_UNDEFINED);
t77=C_a_i_provide(&a,1,lf[77]);
t78=C_set_block_item(lf[78] /* chicken.time.posix#seconds->utc-time */,0,C_SCHEME_UNDEFINED);
t79=C_set_block_item(lf[79] /* chicken.time.posix#utc-time->seconds */,0,C_SCHEME_UNDEFINED);
t80=C_set_block_item(lf[80] /* chicken.time.posix#seconds->local-time */,0,C_SCHEME_UNDEFINED);
t81=C_set_block_item(lf[81] /* chicken.time.posix#seconds->string */,0,C_SCHEME_UNDEFINED);
t82=C_set_block_item(lf[82] /* chicken.time.posix#local-time->seconds */,0,C_SCHEME_UNDEFINED);
t83=C_set_block_item(lf[83] /* chicken.time.posix#string->time */,0,C_SCHEME_UNDEFINED);
t84=C_set_block_item(lf[84] /* chicken.time.posix#time->string */,0,C_SCHEME_UNDEFINED);
t85=C_set_block_item(lf[85] /* chicken.time.posix#local-timezone-abbreviation */,0,C_SCHEME_UNDEFINED);
t86=C_a_i_provide(&a,1,lf[86]);
t87=C_mutate((C_word*)lf[87]+1 /* (set! chicken.process#system ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3006,a[2]=((C_word)li0),tmp=(C_word)a,a+=3,tmp));
t88=C_mutate((C_word*)lf[93]+1 /* (set! chicken.process#system* ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3025,a[2]=((C_word)li1),tmp=(C_word)a,a+=3,tmp));
t89=C_mutate((C_word*)lf[96]+1 /* (set! chicken.process#qs ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3041,a[2]=((C_word)li4),tmp=(C_word)a,a+=3,tmp));
t90=C_set_block_item(lf[106] /* chicken.process#process-execute */,0,C_SCHEME_UNDEFINED);
t91=C_set_block_item(lf[107] /* chicken.process#process-fork */,0,C_SCHEME_UNDEFINED);
t92=C_set_block_item(lf[108] /* chicken.process#process-run */,0,C_SCHEME_UNDEFINED);
t93=C_set_block_item(lf[109] /* chicken.process#process-signal */,0,C_SCHEME_UNDEFINED);
t94=C_set_block_item(lf[110] /* chicken.process#process-spawn */,0,C_SCHEME_UNDEFINED);
t95=C_set_block_item(lf[111] /* chicken.process#process-wait */,0,C_SCHEME_UNDEFINED);
t96=C_set_block_item(lf[112] /* chicken.process#call-with-input-pipe */,0,C_SCHEME_UNDEFINED);
t97=C_set_block_item(lf[113] /* chicken.process#call-with-output-pipe */,0,C_SCHEME_UNDEFINED);
t98=C_set_block_item(lf[114] /* chicken.process#close-input-pipe */,0,C_SCHEME_UNDEFINED);
t99=C_set_block_item(lf[115] /* chicken.process#close-output-pipe */,0,C_SCHEME_UNDEFINED);
t100=C_set_block_item(lf[116] /* chicken.process#create-pipe */,0,C_SCHEME_UNDEFINED);
t101=C_set_block_item(lf[117] /* chicken.process#open-input-pipe */,0,C_SCHEME_UNDEFINED);
t102=C_set_block_item(lf[118] /* chicken.process#open-output-pipe */,0,C_SCHEME_UNDEFINED);
t103=C_set_block_item(lf[119] /* chicken.process#with-input-from-pipe */,0,C_SCHEME_UNDEFINED);
t104=C_set_block_item(lf[120] /* chicken.process#with-output-to-pipe */,0,C_SCHEME_UNDEFINED);
t105=C_set_block_item(lf[121] /* chicken.process#process */,0,C_SCHEME_UNDEFINED);
t106=C_set_block_item(lf[122] /* chicken.process#process* */,0,C_SCHEME_UNDEFINED);
t107=C_set_block_item(lf[123] /* chicken.process#process-sleep */,0,C_SCHEME_UNDEFINED);
t108=C_set_block_item(lf[124] /* chicken.process#process? */,0,C_SCHEME_UNDEFINED);
t109=C_set_block_item(lf[125] /* chicken.process#process-exit-status */,0,C_SCHEME_UNDEFINED);
t110=C_set_block_item(lf[126] /* chicken.process#process-returned-normally? */,0,C_SCHEME_UNDEFINED);
t111=C_set_block_item(lf[127] /* chicken.process#process-input-port */,0,C_SCHEME_UNDEFINED);
t112=C_set_block_item(lf[128] /* chicken.process#process-output-port */,0,C_SCHEME_UNDEFINED);
t113=C_set_block_item(lf[129] /* chicken.process#process-error-port */,0,C_SCHEME_UNDEFINED);
t114=C_set_block_item(lf[130] /* chicken.process#process-id */,0,C_SCHEME_UNDEFINED);
t115=C_set_block_item(lf[131] /* chicken.process#pipe/buf */,0,C_SCHEME_UNDEFINED);
t116=C_set_block_item(lf[132] /* chicken.process#spawn/overlay */,0,C_SCHEME_UNDEFINED);
t117=C_set_block_item(lf[133] /* chicken.process#spawn/wait */,0,C_SCHEME_UNDEFINED);
t118=C_set_block_item(lf[134] /* chicken.process#spawn/nowait */,0,C_SCHEME_UNDEFINED);
t119=C_set_block_item(lf[135] /* chicken.process#spawn/nowaito */,0,C_SCHEME_UNDEFINED);
t120=C_set_block_item(lf[136] /* chicken.process#spawn/detach */,0,C_SCHEME_UNDEFINED);
t121=C_a_i_provide(&a,1,lf[137]);
t122=C_set_block_item(lf[138] /* chicken.process.signal#set-alarm! */,0,C_SCHEME_UNDEFINED);
t123=C_set_block_item(lf[139] /* chicken.process.signal#set-signal-handler! */,0,C_SCHEME_UNDEFINED);
t124=C_set_block_item(lf[140] /* chicken.process.signal#set-signal-mask! */,0,C_SCHEME_UNDEFINED);
t125=C_set_block_item(lf[141] /* chicken.process.signal#signal-handler */,0,C_SCHEME_UNDEFINED);
t126=C_set_block_item(lf[142] /* chicken.process.signal#make-signal-handler */,0,C_SCHEME_UNDEFINED);
t127=C_set_block_item(lf[143] /* chicken.process.signal#signal-ignore */,0,C_SCHEME_UNDEFINED);
t128=C_set_block_item(lf[144] /* chicken.process.signal#signal-default */,0,C_SCHEME_UNDEFINED);
t129=C_set_block_item(lf[145] /* chicken.process.signal#signal-mask */,0,C_SCHEME_UNDEFINED);
t130=C_set_block_item(lf[146] /* chicken.process.signal#signal-mask! */,0,C_SCHEME_UNDEFINED);
t131=C_set_block_item(lf[147] /* chicken.process.signal#signal-masked? */,0,C_SCHEME_UNDEFINED);
t132=C_set_block_item(lf[148] /* chicken.process.signal#signal-unmask! */,0,C_SCHEME_UNDEFINED);
t133=C_set_block_item(lf[149] /* chicken.process.signal#signal/abrt */,0,C_SCHEME_UNDEFINED);
t134=C_set_block_item(lf[150] /* chicken.process.signal#signal/alrm */,0,C_SCHEME_UNDEFINED);
t135=C_set_block_item(lf[151] /* chicken.process.signal#signal/break */,0,C_SCHEME_UNDEFINED);
t136=C_set_block_item(lf[152] /* chicken.process.signal#signal/bus */,0,C_SCHEME_UNDEFINED);
t137=C_set_block_item(lf[153] /* chicken.process.signal#signal/chld */,0,C_SCHEME_UNDEFINED);
t138=C_set_block_item(lf[154] /* chicken.process.signal#signal/cont */,0,C_SCHEME_UNDEFINED);
t139=C_set_block_item(lf[155] /* chicken.process.signal#signal/fpe */,0,C_SCHEME_UNDEFINED);
t140=C_set_block_item(lf[156] /* chicken.process.signal#signal/hup */,0,C_SCHEME_UNDEFINED);
t141=C_set_block_item(lf[157] /* chicken.process.signal#signal/ill */,0,C_SCHEME_UNDEFINED);
t142=C_set_block_item(lf[158] /* chicken.process.signal#signal/int */,0,C_SCHEME_UNDEFINED);
t143=C_set_block_item(lf[159] /* chicken.process.signal#signal/io */,0,C_SCHEME_UNDEFINED);
t144=C_set_block_item(lf[160] /* chicken.process.signal#signal/kill */,0,C_SCHEME_UNDEFINED);
t145=C_set_block_item(lf[161] /* chicken.process.signal#signal/pipe */,0,C_SCHEME_UNDEFINED);
t146=C_set_block_item(lf[162] /* chicken.process.signal#signal/prof */,0,C_SCHEME_UNDEFINED);
t147=C_set_block_item(lf[163] /* chicken.process.signal#signal/quit */,0,C_SCHEME_UNDEFINED);
t148=C_set_block_item(lf[164] /* chicken.process.signal#signal/segv */,0,C_SCHEME_UNDEFINED);
t149=C_set_block_item(lf[165] /* chicken.process.signal#signal/stop */,0,C_SCHEME_UNDEFINED);
t150=C_set_block_item(lf[166] /* chicken.process.signal#signal/term */,0,C_SCHEME_UNDEFINED);
t151=C_set_block_item(lf[167] /* chicken.process.signal#signal/trap */,0,C_SCHEME_UNDEFINED);
t152=C_set_block_item(lf[168] /* chicken.process.signal#signal/tstp */,0,C_SCHEME_UNDEFINED);
t153=C_set_block_item(lf[169] /* chicken.process.signal#signal/urg */,0,C_SCHEME_UNDEFINED);
t154=C_set_block_item(lf[170] /* chicken.process.signal#signal/usr1 */,0,C_SCHEME_UNDEFINED);
t155=C_set_block_item(lf[171] /* chicken.process.signal#signal/usr2 */,0,C_SCHEME_UNDEFINED);
t156=C_set_block_item(lf[172] /* chicken.process.signal#signal/vtalrm */,0,C_SCHEME_UNDEFINED);
t157=C_set_block_item(lf[173] /* chicken.process.signal#signal/winch */,0,C_SCHEME_UNDEFINED);
t158=C_set_block_item(lf[174] /* chicken.process.signal#signal/xcpu */,0,C_SCHEME_UNDEFINED);
t159=C_set_block_item(lf[175] /* chicken.process.signal#signal/xfsz */,0,C_SCHEME_UNDEFINED);
t160=C_set_block_item(lf[176] /* chicken.process.signal#signals-list */,0,C_SCHEME_UNDEFINED);
t161=C_a_i_provide(&a,1,lf[177]);
t162=C_set_block_item(lf[178] /* chicken.process-context.posix#change-directory* */,0,C_SCHEME_UNDEFINED);
t163=C_set_block_item(lf[179] /* chicken.process-context.posix#set-root-directory! */,0,C_SCHEME_UNDEFINED);
t164=C_set_block_item(lf[180] /* chicken.process-context.posix#current-effective-group-id */,0,C_SCHEME_UNDEFINED);
t165=C_set_block_item(lf[181] /* chicken.process-context.posix#current-effective-user-id */,0,C_SCHEME_UNDEFINED);
t166=C_set_block_item(lf[182] /* chicken.process-context.posix#current-group-id */,0,C_SCHEME_UNDEFINED);
t167=C_set_block_item(lf[183] /* chicken.process-context.posix#current-user-id */,0,C_SCHEME_UNDEFINED);
t168=C_set_block_item(lf[184] /* chicken.process-context.posix#current-process-id */,0,C_SCHEME_UNDEFINED);
t169=C_set_block_item(lf[185] /* chicken.process-context.posix#parent-process-id */,0,C_SCHEME_UNDEFINED);
t170=C_set_block_item(lf[186] /* chicken.process-context.posix#current-user-name */,0,C_SCHEME_UNDEFINED);
t171=C_set_block_item(lf[187] /* chicken.process-context.posix#current-effective-user-name */,0,C_SCHEME_UNDEFINED);
t172=C_set_block_item(lf[188] /* chicken.process-context.posix#create-session */,0,C_SCHEME_UNDEFINED);
t173=C_set_block_item(lf[189] /* chicken.process-context.posix#process-group-id */,0,C_SCHEME_UNDEFINED);
t174=C_set_block_item(lf[190] /* chicken.process-context.posix#user-information */,0,C_SCHEME_UNDEFINED);
t175=C_a_i_provide(&a,1,lf[191]);
t176=C_mutate(&lf[192] /* (set! chicken.posix#posix-error ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3238,a[2]=((C_word)li5),tmp=(C_word)a,a+=3,tmp));
t177=C_mutate((C_word*)lf[195]+1 /* (set! ##sys#posix-error ...) */,lf[192]);
t178=C_mutate(&lf[196] /* (set! chicken.posix#stat ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3256,a[2]=((C_word)li6),tmp=(C_word)a,a+=3,tmp));
t179=C_mutate((C_word*)lf[204]+1 /* (set! chicken.file.posix#file-stat ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3302,a[2]=((C_word)li7),tmp=(C_word)a,a+=3,tmp));
t180=C_mutate((C_word*)lf[206]+1 /* (set! chicken.file.posix#set-file-permissions! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3320,a[2]=((C_word)li8),tmp=(C_word)a,a+=3,tmp));
t181=C_mutate((C_word*)lf[211]+1 /* (set! chicken.file.posix#file-modification-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3364,a[2]=((C_word)li9),tmp=(C_word)a,a+=3,tmp));
t182=C_mutate((C_word*)lf[213]+1 /* (set! chicken.file.posix#file-access-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3370,a[2]=((C_word)li10),tmp=(C_word)a,a+=3,tmp));
t183=C_mutate((C_word*)lf[215]+1 /* (set! chicken.file.posix#file-change-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3376,a[2]=((C_word)li11),tmp=(C_word)a,a+=3,tmp));
t184=C_mutate((C_word*)lf[217]+1 /* (set! chicken.file.posix#set-file-times! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3382,a[2]=((C_word)li12),tmp=(C_word)a,a+=3,tmp));
t185=C_mutate((C_word*)lf[222]+1 /* (set! chicken.file.posix#file-size ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3450,a[2]=((C_word)li13),tmp=(C_word)a,a+=3,tmp));
t186=C_mutate((C_word*)lf[224]+1 /* (set! chicken.file.posix#set-file-owner! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3456,a[2]=((C_word)li14),tmp=(C_word)a,a+=3,tmp));
t187=C_mutate((C_word*)lf[227]+1 /* (set! chicken.file.posix#set-file-group! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3462,a[2]=((C_word)li15),tmp=(C_word)a,a+=3,tmp));
t188=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3470,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t189=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8652,a[2]=((C_word)li235),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:321: chicken.base#getter-with-setter */
t190=*((C_word*)lf[495]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t190;
av2[1]=t188;
av2[2]=t189;
av2[3]=*((C_word*)lf[224]+1);
av2[4]=lf[526];
((C_proc)(void*)(*((C_word*)t190+1)))(5,av2);}}

/* chicken.process#system in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3006(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_3006,c,av);}
a=C_alloc(4);
t3=C_i_check_string_2(t2,lf[88]);
t4=C_execute_shell_command(t2);
if(C_truep(C_fixnum_lessp(t4,C_fix(0)))){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3023,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix.scm:204: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[92]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[92]+1);
av2[1]=t5;
tp(2,av2);}}
else{
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k3021 in chicken.process#system in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3023(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_3023,c,av);}
/* posix.scm:203: ##sys#signal-hook/errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[89]+1));
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=*((C_word*)lf[89]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=lf[90];
av2[3]=t1;
av2[4]=lf[88];
av2[5]=lf[91];
av2[6]=((C_word*)t0)[3];
tp(7,av2);}}

/* chicken.process#system* in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3025(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_3025,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3029,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix.scm:210: system */
t4=*((C_word*)lf[87]+1);{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k3027 in chicken.process#system* in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3029(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_3029,c,av);}
t2=C_eqp(t1,C_fix(0));
if(C_truep(t2)){
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
/* posix.scm:212: ##sys#error */
t3=*((C_word*)lf[94]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[95];
av2[3]=((C_word*)t0)[3];
av2[4]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}}

/* chicken.process#qs in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3041(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_3041,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3045,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_rest_nullp(c,3))){
/* posix.scm:217: chicken.platform#software-version */
t4=*((C_word*)lf[105]+1);{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=t3;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_get_rest_arg(c,3,av,3,t0);
f_3045(2,av2);}}}

/* k3043 in chicken.process#qs in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3045(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(18,c,3)))){
C_save_and_reclaim((void *)f_3045,c,av);}
a=C_alloc(18);
t2=C_eqp(t1,lf[97]);
t3=(C_truep(t2)?C_make_character(34):C_make_character(39));
t4=C_eqp(t1,lf[97]);
t5=(C_truep(t4)?lf[98]:lf[99]);
t6=C_a_i_cons(&a,2,C_SCHEME_UNDEFINED,C_SCHEME_END_OF_LIST);
t7=t6;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=((C_word*)t8)[1];
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3055,a[2]=t3,a[3]=t5,a[4]=((C_word*)t0)[2],a[5]=((C_word)li2),tmp=(C_word)a,a+=6,tmp);
t11=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3076,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=t8,a[5]=t10,a[6]=t9,tmp=(C_word)a,a+=7,tmp);
/* ##sys#string->list */
t12=*((C_word*)lf[104]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t12;
av2[1]=t11;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t12+1)))(3,av2);}}

/* g258 in k3043 in chicken.process#qs in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void f_3055(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,4)))){
C_save_and_reclaim_args((void *)trf_3055,3,t0,t1,t2);}
a=C_alloc(8);
if(C_truep(C_i_char_equalp(t2,((C_word*)t0)[2]))){
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
if(C_truep(C_u_i_char_equalp(t2,C_make_character(0)))){
/* posix.scm:225: chicken.base#error */
t3=*((C_word*)lf[100]+1);{
C_word av2[5];
av2[0]=t3;
av2[1]=t1;
av2[2]=lf[101];
av2[3]=lf[102];
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_a_i_string(&a,1,t2);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}}

/* k3074 in k3043 in chicken.process#qs in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3076(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(14,c,3)))){
C_save_and_reclaim((void *)f_3076,c,av);}
a=C_alloc(14);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3079,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=C_SCHEME_UNDEFINED,tmp=(C_word)a,a+=5,tmp);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3096,a[2]=((C_word*)t0)[4],a[3]=t4,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word)li3),tmp=(C_word)a,a+=7,tmp));
t6=((C_word*)t4)[1];
f_3096(t6,t2,t1);}

/* k3077 in k3074 in k3043 in chicken.process#qs in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3079(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,3)))){
C_save_and_reclaim((void *)f_3079,c,av);}
a=C_alloc(11);
t2=C_a_i_string(&a,1,((C_word*)t0)[2]);
t3=C_mutate(((C_word *)t0)+4,t2);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3090,a[2]=t0,tmp=(C_word)a,a+=3,tmp);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t4;
av2[2]=*((C_word*)lf[103]+1);
av2[3]=t1;
C_apply(4,av2);}}

/* k3088 in k3077 in k3074 in k3043 in chicken.process#qs in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3090(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,4)))){
C_save_and_reclaim((void *)f_3090,c,av);}
a=C_alloc(8);
t2=((C_word*)t0)[2];
t3=C_a_i_string(&a,1,((C_word*)t2)[2]);
/* posix.scm:228: scheme#string-append */
t4=*((C_word*)lf[103]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=((C_word*)t2)[3];
av2[2]=((C_word*)t2)[4];
av2[3]=t1;
av2[4]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* map-loop252 in k3074 in k3043 in chicken.process#qs in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void f_3096(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,2)))){
C_save_and_reclaim_args((void *)trf_3096,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3121,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* posix.scm:221: g258 */
t4=((C_word*)t0)[4];
f_3055(t4,t3,C_slot(t2,C_fix(0)));}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_slot(((C_word*)t0)[5],C_fix(1));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k3119 in map-loop252 in k3074 in k3043 in chicken.process#qs in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3121(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_3121,c,av);}
a=C_alloc(3);
t2=C_a_i_cons(&a,2,t1,C_SCHEME_END_OF_LIST);
t3=C_i_setslot(((C_word*)((C_word*)t0)[2])[1],C_fix(1),t2);
t4=C_mutate(((C_word *)((C_word*)t0)[2])+1,t2);
t5=((C_word*)((C_word*)t0)[3])[1];
f_3096(t5,((C_word*)t0)[4],C_slot(((C_word*)t0)[5],C_fix(1)));}

/* chicken.posix#posix-error in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3238(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-5)*C_SIZEOF_PAIR +7,c,2)))){
C_save_and_reclaim((void*)f_3238,c,av);}
a=C_alloc((c-5)*C_SIZEOF_PAIR+7);
t5=C_build_rest(&a,c,5,av);
C_word t6;
C_word t7;
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3242,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t5,a[6]=t4,tmp=(C_word)a,a+=7,tmp);
/* posix-common.scm:199: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[92]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[92]+1);
av2[1]=t6;
tp(2,av2);}}

/* k3240 in chicken.posix#posix-error in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3242(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(16,c,3)))){
C_save_and_reclaim((void *)f_3242,c,av);}
a=C_alloc(16);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3249,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3253,a[2]=t2,a[3]=((C_word*)t0)[6],tmp=(C_word)a,a+=4,tmp);
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=C_i_foreign_fixnum_argumentp(t1);
/* posix-common.scm:196: ##sys#peek-c-string */
t6=*((C_word*)lf[194]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t6;
av2[1]=t3;
av2[2]=stub674(t4,t5);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}

/* k3247 in k3240 in chicken.posix#posix-error in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3249(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,7)))){
C_save_and_reclaim((void *)f_3249,c,av);}{
C_word *av2;
if(c >= 8) {
  av2=av;
} else {
  av2=C_alloc(8);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=*((C_word*)lf[89]+1);
av2[3]=((C_word*)t0)[3];
av2[4]=((C_word*)t0)[4];
av2[5]=((C_word*)t0)[5];
av2[6]=t1;
av2[7]=((C_word*)t0)[6];
C_apply(8,av2);}}

/* k3251 in k3240 in chicken.posix#posix-error in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3253(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_3253,c,av);}
/* posix-common.scm:201: string-append */
t2=*((C_word*)lf[103]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=lf[193];
av2[4]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* chicken.posix#stat in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void f_3256(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,0,2)))){
C_save_and_reclaim_args((void *)trf_3256,5,t1,t2,t3,t4,t5);}
a=C_alloc(12);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3260,a[2]=t4,a[3]=t1,a[4]=t5,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_fixnump(t2))){
t7=t6;{
C_word av2[2];
av2[0]=t7;
av2[1]=C_u_i_fstat(t2);
f_3260(2,av2);}}
else{
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3281,a[2]=t6,a[3]=t2,a[4]=t3,a[5]=t5,tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:244: scheme#port? */
t8=*((C_word*)lf[203]+1);{
C_word av2[3];
av2[0]=t8;
av2[1]=t7;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t8+1)))(3,av2);}}}

/* k3258 in chicken.posix#stat in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3260(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_3260,c,av);}
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
if(C_truep(((C_word*)t0)[2])){
/* posix-common.scm:255: posix-error */
t2=lf[192];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[197];
av2[3]=((C_word*)t0)[4];
av2[4]=lf[198];
av2[5]=((C_word*)t0)[5];
f_3238(6,av2);}}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k3279 in chicken.posix#stat in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3281(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,5)))){
C_save_and_reclaim((void *)f_3281,c,av);}
a=C_alloc(4);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3285,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:244: chicken.file.posix#port->fileno */
t3=*((C_word*)lf[72]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
if(C_truep(C_i_stringp(((C_word*)t0)[3]))){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3294,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:246: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[199]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[199]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[5];
tp(4,av2);}}
else{
/* posix-common.scm:251: ##sys#signal-hook */
t2=*((C_word*)lf[200]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[201];
av2[3]=((C_word*)t0)[5];
av2[4]=lf[202];
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}}

/* k3283 in k3279 in chicken.posix#stat in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3285(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3285,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_u_i_fstat(t1);
f_3260(2,av2);}}

/* k3292 in k3279 in chicken.posix#stat in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3294(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3294,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=(C_truep(((C_word*)t0)[3])?C_u_i_lstat(t1):C_u_i_stat(t1));
f_3260(2,av2);}}

/* chicken.file.posix#file-stat in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3302(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_3302,c,av);}
a=C_alloc(3);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_get_rest_arg(c,3,av,3,t0));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3309,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:261: stat */
f_3256(t5,t2,t4,C_SCHEME_TRUE,lf[205]);}

/* k3307 in chicken.file.posix#file-stat in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3309(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(42,c,1)))){
C_save_and_reclaim((void *)f_3309,c,av);}
a=C_alloc(42);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_vector(&a,13,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_ino),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_mode),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_nlink),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_gid),C_int64_to_num(&a,C_statbuf.st_size),C_int64_to_num(&a,C_statbuf.st_atime),C_int64_to_num(&a,C_statbuf.st_ctime),C_int64_to_num(&a,C_statbuf.st_mtime),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_dev),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_rdev),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_blksize),C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_blocks));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.file.posix#set-file-permissions! in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3320(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(10,c,2)))){
C_save_and_reclaim((void *)f_3320,c,av);}
a=C_alloc(10);
t4=C_i_check_fixnum_2(t3,lf[207]);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3327,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnump(t2))){
t6=t5;{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_fchmod(t2,t3);
f_3327(2,av2);}}
else{
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3345,a[2]=t5,a[3]=t3,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:272: scheme#port? */
t7=*((C_word*)lf[203]+1);{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}}

/* k3325 in chicken.file.posix#set-file-permissions! in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3327(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_3327,c,av);}
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
/* posix-common.scm:281: posix-error */
t2=lf[192];{
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[197];
av2[3]=lf[207];
av2[4]=lf[208];
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
f_3238(7,av2);}}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k3343 in chicken.file.posix#set-file-permissions! in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3345(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,5)))){
C_save_and_reclaim((void *)f_3345,c,av);}
a=C_alloc(4);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3349,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:272: chicken.file.posix#port->fileno */
t3=*((C_word*)lf[72]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
if(C_truep(C_i_stringp(((C_word*)t0)[4]))){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3359,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:275: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[199]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[199]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=lf[207];
tp(4,av2);}}
else{
/* posix-common.scm:277: ##sys#signal-hook */
t2=*((C_word*)lf[200]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[201];
av2[3]=lf[209];
av2[4]=lf[210];
av2[5]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}}

/* k3347 in k3343 in chicken.file.posix#set-file-permissions! in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3349(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3349,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_fchmod(t1,((C_word*)t0)[3]);
f_3327(2,av2);}}

/* k3357 in k3343 in chicken.file.posix#set-file-permissions! in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3359(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3359,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_chmod(t1,((C_word*)t0)[3]);
f_3327(2,av2);}}

/* chicken.file.posix#file-modification-time in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3364(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_3364,c,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3368,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:285: stat */
f_3256(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[212]);}

/* k3366 in chicken.file.posix#file-modification-time in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3368(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,1)))){
C_save_and_reclaim((void *)f_3368,c,av);}
a=C_alloc(7);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_int64_to_num(&a,C_statbuf.st_mtime);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.file.posix#file-access-time in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3370(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_3370,c,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3374,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:289: stat */
f_3256(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[214]);}

/* k3372 in chicken.file.posix#file-access-time in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3374(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,1)))){
C_save_and_reclaim((void *)f_3374,c,av);}
a=C_alloc(7);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_int64_to_num(&a,C_statbuf.st_atime);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.file.posix#file-change-time in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3376(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_3376,c,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3380,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:293: stat */
f_3256(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[216]);}

/* k3378 in chicken.file.posix#file-change-time in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3380(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,1)))){
C_save_and_reclaim((void *)f_3380,c,av);}
a=C_alloc(7);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_int64_to_num(&a,C_statbuf.st_ctime);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.file.posix#set-file-times! in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3382(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +7,c,2)))){
C_save_and_reclaim((void*)f_3382,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+7);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_3386,a[2]=t2,a[3]=C_SCHEME_UNDEFINED,a[4]=C_SCHEME_UNDEFINED,a[5]=t1,a[6]=t3,tmp=(C_word)a,a+=7,tmp);
if(C_truep(C_i_nullp(t3))){
/* posix-common.scm:298: chicken.time#current-seconds */
t5=*((C_word*)lf[221]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t5=t4;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_i_car(t3);
f_3386(2,av2);}}}

/* k3384 in chicken.file.posix#set-file-times! in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3386(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_3386,c,av);}
a=C_alloc(3);
t2=C_mutate(((C_word *)t0)+3,t1);
t3=C_i_nullp(((C_word*)t0)[6]);
t4=(C_truep(t3)?C_SCHEME_END_OF_LIST:C_i_cdr(((C_word*)t0)[6]));
t5=C_i_nullp(t4);
t6=(C_truep(t5)?((C_word*)t0)[3]:C_i_car(t4));
t7=C_mutate(((C_word *)t0)+4,t6);
t8=C_i_nullp(t4);
t9=(C_truep(t8)?C_SCHEME_END_OF_LIST:C_i_cdr(t4));
t10=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3398,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
if(C_truep(((C_word*)t0)[3])){
/* posix-common.scm:299: ##sys#check-exact-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[220]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[220]+1);
av2[1]=t10;
av2[2]=((C_word*)t0)[3];
av2[3]=lf[218];
tp(4,av2);}}
else{
t11=t10;{
C_word *av2=av;
av2[0]=t11;
av2[1]=C_SCHEME_UNDEFINED;
f_3398(2,av2);}}}

/* k3396 in k3384 in chicken.file.posix#set-file-times! in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3398(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_3398,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3401,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
if(C_truep(((C_word*)t2)[4])){
/* posix-common.scm:300: ##sys#check-exact-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[220]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[220]+1);
av2[1]=t3;
av2[2]=((C_word*)t2)[4];
av2[3]=lf[218];
tp(4,av2);}}
else{
t4=t3;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
f_3401(2,av2);}}}

/* k3399 in k3396 in k3384 in chicken.file.posix#set-file-times! in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3401(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,7)))){
C_save_and_reclaim((void *)f_3401,c,av);}
t2=((C_word*)t0)[2];
t3=stub748(C_SCHEME_UNDEFINED,((C_word*)t2)[2],((C_word*)t2)[3],((C_word*)t2)[4]);
if(C_truep(C_fixnum_lessp(t3,C_fix(0)))){{
C_word *av2;
if(c >= 8) {
  av2=av;
} else {
  av2=C_alloc(8);
}
av2[0]=0;
av2[1]=((C_word*)t2)[5];
av2[2]=lf[192];
av2[3]=lf[197];
av2[4]=lf[218];
av2[5]=lf[219];
av2[6]=((C_word*)t2)[2];
av2[7]=((C_word*)t2)[6];
C_apply(8,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=((C_word*)t2)[5];{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* chicken.file.posix#file-size in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3450(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_3450,c,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3454,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:310: stat */
f_3256(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[223]);}

/* k3452 in chicken.file.posix#file-size in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3454(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,1)))){
C_save_and_reclaim((void *)f_3454,c,av);}
a=C_alloc(7);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_int64_to_num(&a,C_statbuf.st_size);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.file.posix#set-file-owner! in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3456(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_3456,c,av);}
/* posix-common.scm:314: chown */
f_6115(t1,lf[226],t2,t3,C_fix(-1));}

/* chicken.file.posix#set-file-group! in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3462(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_3462,c,av);}
/* posix-common.scm:318: chown */
f_6115(t1,lf[228],t2,C_fix(-1),t3);}

/* k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3470(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_3470,c,av);}
a=C_alloc(6);
t2=C_mutate((C_word*)lf[20]+1 /* (set! chicken.file.posix#file-owner ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3474,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8646,a[2]=((C_word)li234),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:327: chicken.base#getter-with-setter */
t5=*((C_word*)lf[495]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t5;
av2[1]=t3;
av2[2]=t4;
av2[3]=*((C_word*)lf[227]+1);
av2[4]=lf[524];
((C_proc)(void*)(*((C_word*)t5+1)))(5,av2);}}

/* k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3474(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_3474,c,av);}
a=C_alloc(6);
t2=C_mutate((C_word*)lf[14]+1 /* (set! chicken.file.posix#file-group ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3478,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8640,a[2]=((C_word)li233),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:333: chicken.base#getter-with-setter */
t5=*((C_word*)lf[495]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t5;
av2[1]=t3;
av2[2]=t4;
av2[3]=*((C_word*)lf[206]+1);
av2[4]=lf[522];
((C_proc)(void*)(*((C_word*)t5+1)))(5,av2);}}

/* k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3478(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,4)))){
C_save_and_reclaim((void *)f_3478,c,av);}
a=C_alloc(33);
t2=C_mutate((C_word*)lf[21]+1 /* (set! chicken.file.posix#file-permissions ...) */,t1);
t3=C_mutate((C_word*)lf[28]+1 /* (set! chicken.file.posix#file-type ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3480,a[2]=((C_word)li16),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[33]+1 /* (set! chicken.file.posix#regular-file? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3567,a[2]=((C_word)li17),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[35]+1 /* (set! chicken.file.posix#symbolic-link? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3577,a[2]=((C_word)li18),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[29]+1 /* (set! chicken.file.posix#block-device? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3587,a[2]=((C_word)li19),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[30]+1 /* (set! chicken.file.posix#character-device? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3597,a[2]=((C_word)li20),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[32]+1 /* (set! chicken.file.posix#fifo? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3607,a[2]=((C_word)li21),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate((C_word*)lf[34]+1 /* (set! chicken.file.posix#socket? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3617,a[2]=((C_word)li22),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate((C_word*)lf[31]+1 /* (set! chicken.file.posix#directory? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3627,a[2]=((C_word)li23),tmp=(C_word)a,a+=3,tmp));
t11=C_set_block_item(lf[75] /* chicken.file.posix#seek/set */,0,C_fix((C_word)SEEK_SET));
t12=C_set_block_item(lf[74] /* chicken.file.posix#seek/end */,0,C_fix((C_word)SEEK_END));
t13=C_set_block_item(lf[73] /* chicken.file.posix#seek/cur */,0,C_fix((C_word)SEEK_CUR));
t14=C_mutate((C_word*)lf[76]+1 /* (set! chicken.file.posix#set-file-position! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3640,a[2]=((C_word)li24),tmp=(C_word)a,a+=3,tmp));
t15=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3695,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t16=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8603,a[2]=((C_word)li232),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:410: chicken.base#getter-with-setter */
t17=*((C_word*)lf[495]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t17;
av2[1]=t15;
av2[2]=t16;
av2[3]=*((C_word*)lf[76]+1);
av2[4]=lf[521];
((C_proc)(void*)(*((C_word*)t17+1)))(5,av2);}}

/* chicken.file.posix#file-type in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3480(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_3480,c,av);}
a=C_alloc(3);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_get_rest_arg(c,3,av,3,t0));
t5=C_rest_nullp(c,3);
t6=C_rest_nullp(c,4);
t7=(C_truep(t6)?C_SCHEME_TRUE:C_get_rest_arg(c,4,av,3,t0));
t8=C_rest_nullp(c,4);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3499,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:342: stat */
f_3256(t9,t2,t4,t7,lf[236]);}

/* k3497 in chicken.file.posix#file-type in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3499(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3499,c,av);}
if(C_truep(t1)){
t2=C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_stat_type);
t3=C_eqp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFREG));
if(C_truep(t3)){
t4=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t4;
av2[1]=lf[229];
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_eqp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFLNK));
if(C_truep(t4)){
t5=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t5;
av2[1]=lf[230];
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t5=C_eqp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFDIR));
if(C_truep(t5)){
t6=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t6;
av2[1]=lf[231];
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_eqp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFCHR));
if(C_truep(t6)){
t7=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t7;
av2[1]=lf[232];
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t7=C_eqp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFBLK));
if(C_truep(t7)){
t8=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t8;
av2[1]=lf[233];
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}
else{
t8=C_eqp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFIFO));
if(C_truep(t8)){
t9=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t9;
av2[1]=lf[234];
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}
else{
t9=C_eqp(t2,C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)S_IFSOCK));
t10=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t10;
av2[1]=(C_truep(t9)?lf[235]:lf[229]);
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}}}}}}}
else{
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* chicken.file.posix#regular-file? in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3567(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_3567,c,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3575,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:356: chicken.file.posix#file-type */
t4=*((C_word*)lf[28]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* k3573 in chicken.file.posix#regular-file? in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3575(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3575,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_eqp(lf[229],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.file.posix#symbolic-link? in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3577(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_3577,c,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3585,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:360: chicken.file.posix#file-type */
t4=*((C_word*)lf[28]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_TRUE;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* k3583 in chicken.file.posix#symbolic-link? in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3585(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3585,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_eqp(lf[230],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.file.posix#block-device? in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3587(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_3587,c,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3595,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:364: chicken.file.posix#file-type */
t4=*((C_word*)lf[28]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* k3593 in chicken.file.posix#block-device? in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3595(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3595,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_eqp(lf[233],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.file.posix#character-device? in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3597(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_3597,c,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3605,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:368: chicken.file.posix#file-type */
t4=*((C_word*)lf[28]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* k3603 in chicken.file.posix#character-device? in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3605(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3605,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_eqp(lf[232],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.file.posix#fifo? in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3607(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_3607,c,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3615,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:372: chicken.file.posix#file-type */
t4=*((C_word*)lf[28]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* k3613 in chicken.file.posix#fifo? in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3615(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3615,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_eqp(lf[234],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.file.posix#socket? in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3617(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_3617,c,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3625,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:376: chicken.file.posix#file-type */
t4=*((C_word*)lf[28]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* k3623 in chicken.file.posix#socket? in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3625(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3625,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_eqp(lf[235],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.file.posix#directory? in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3627(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_3627,c,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3635,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:380: chicken.file.posix#file-type */
t4=*((C_word*)lf[28]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
av2[3]=C_SCHEME_FALSE;
av2[4]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* k3633 in chicken.file.posix#directory? in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3635(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3635,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_eqp(lf[231],t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.file.posix#set-file-position! in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3640(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +11,c,2)))){
C_save_and_reclaim((void*)f_3640,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+11);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t5=C_i_pairp(t4);
t6=(C_truep(t5)?C_get_rest_arg(c,4,av,4,t0):C_fix((C_word)SEEK_SET));
t7=C_i_check_fixnum_2(t3,lf[237]);
t8=C_i_check_fixnum_2(t6,lf[237]);
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3656,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3662,a[2]=t2,a[3]=t3,a[4]=t6,a[5]=t9,tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:398: scheme#port? */
t11=*((C_word*)lf[203]+1);{
C_word *av2=av;
av2[0]=t11;
av2[1]=t10;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t11+1)))(3,av2);}}

/* k3654 in chicken.file.posix#set-file-position! in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3656(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_3656,c,av);}
if(C_truep(t1)){
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* posix-common.scm:407: posix-error */
t2=lf[192];{
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[197];
av2[3]=lf[237];
av2[4]=lf[238];
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
f_3238(7,av2);}}}

/* k3660 in chicken.file.posix#set-file-position! in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3662(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_3662,c,av);}
if(C_truep(t1)){
t2=C_slot(((C_word*)t0)[2],C_fix(7));
t3=C_eqp(t2,lf[239]);
if(C_truep(t3)){
t4=C_fseek(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
if(C_truep(t4)){
t5=C_i_set_i_slot(((C_word*)t0)[2],C_fix(6),C_SCHEME_FALSE);
t6=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t6;
av2[1]=t4;
f_3656(2,av2);}}
else{
t5=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_SCHEME_FALSE;
f_3656(2,av2);}}}
else{
t4=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
f_3656(2,av2);}}}
else{
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
t2=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_lseek(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
f_3656(2,av2);}}
else{
/* posix-common.scm:406: ##sys#signal-hook */
t2=*((C_word*)lf[200]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[5];
av2[2]=lf[201];
av2[3]=lf[237];
av2[4]=lf[240];
av2[5]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}}

/* k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3695(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(45,c,7)))){
C_save_and_reclaim((void *)f_3695,c,av);}
a=C_alloc(45);
t2=C_mutate((C_word*)lf[22]+1 /* (set! chicken.file.posix#file-position ...) */,t1);
t3=C_set_block_item(lf[37] /* chicken.file.posix#fileno/stdin */,0,C_fix((C_word)STDIN_FILENO));
t4=C_set_block_item(lf[38] /* chicken.file.posix#fileno/stdout */,0,C_fix((C_word)STDOUT_FILENO));
t5=C_set_block_item(lf[36] /* chicken.file.posix#fileno/stderr */,0,C_fix((C_word)STDERR_FILENO));
t6=C_set_block_item(lf[49] /* chicken.file.posix#open/rdonly */,0,C_fix((C_word)O_RDONLY));
t7=C_set_block_item(lf[56] /* chicken.file.posix#open/wronly */,0,C_fix((C_word)O_WRONLY));
t8=C_set_block_item(lf[50] /* chicken.file.posix#open/rdwr */,0,C_fix((C_word)O_RDWR));
t9=C_set_block_item(lf[51] /* chicken.file.posix#open/read */,0,C_fix((C_word)O_RDONLY));
t10=C_set_block_item(lf[55] /* chicken.file.posix#open/write */,0,C_fix((C_word)O_WRONLY));
t11=C_set_block_item(lf[43] /* chicken.file.posix#open/creat */,0,C_fix((C_word)O_CREAT));
t12=C_set_block_item(lf[41] /* chicken.file.posix#open/append */,0,C_fix((C_word)O_APPEND));
t13=C_set_block_item(lf[44] /* chicken.file.posix#open/excl */,0,C_fix((C_word)O_EXCL));
t14=C_set_block_item(lf[54] /* chicken.file.posix#open/trunc */,0,C_fix((C_word)O_TRUNC));
t15=C_set_block_item(lf[42] /* chicken.file.posix#open/binary */,0,C_fix((C_word)O_BINARY));
t16=C_set_block_item(lf[53] /* chicken.file.posix#open/text */,0,C_fix((C_word)O_TEXT));
t17=C_set_block_item(lf[59] /* chicken.file.posix#perm/irusr */,0,C_fix((C_word)S_IRUSR));
t18=C_set_block_item(lf[68] /* chicken.file.posix#perm/iwusr */,0,C_fix((C_word)S_IWUSR));
t19=C_set_block_item(lf[71] /* chicken.file.posix#perm/ixusr */,0,C_fix((C_word)S_IXUSR));
t20=C_set_block_item(lf[57] /* chicken.file.posix#perm/irgrp */,0,C_fix((C_word)S_IRGRP));
t21=C_set_block_item(lf[66] /* chicken.file.posix#perm/iwgrp */,0,C_fix((C_word)S_IWGRP));
t22=C_set_block_item(lf[69] /* chicken.file.posix#perm/ixgrp */,0,C_fix((C_word)S_IXGRP));
t23=C_set_block_item(lf[58] /* chicken.file.posix#perm/iroth */,0,C_fix((C_word)S_IROTH));
t24=C_set_block_item(lf[67] /* chicken.file.posix#perm/iwoth */,0,C_fix((C_word)S_IWOTH));
t25=C_set_block_item(lf[70] /* chicken.file.posix#perm/ixoth */,0,C_fix((C_word)S_IXOTH));
t26=C_set_block_item(lf[62] /* chicken.file.posix#perm/irwxu */,0,C_fix((C_word)S_IRUSR | S_IWUSR | S_IXUSR));
t27=C_set_block_item(lf[60] /* chicken.file.posix#perm/irwxg */,0,C_fix((C_word)S_IRGRP | S_IWGRP | S_IXGRP));
t28=C_set_block_item(lf[61] /* chicken.file.posix#perm/irwxo */,0,C_fix((C_word)S_IROTH | S_IWOTH | S_IXOTH));
t29=C_SCHEME_UNDEFINED;
t30=(*a=C_VECTOR_TYPE|1,a[1]=t29,tmp=(C_word)a,a+=2,tmp);
t31=C_SCHEME_UNDEFINED;
t32=(*a=C_VECTOR_TYPE|1,a[1]=t31,tmp=(C_word)a,a+=2,tmp);
t33=C_set_block_item(t30,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3723,a[2]=((C_word)li25),tmp=(C_word)a,a+=3,tmp));
t34=C_set_block_item(t32,0,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3756,a[2]=((C_word)li26),tmp=(C_word)a,a+=3,tmp));
t35=C_mutate((C_word*)lf[39]+1 /* (set! chicken.file.posix#open-input-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3778,a[2]=t32,a[3]=t30,a[4]=((C_word)li27),tmp=(C_word)a,a+=5,tmp));
t36=C_mutate((C_word*)lf[40]+1 /* (set! chicken.file.posix#open-output-file* ...) */,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3828,a[2]=t32,a[3]=t30,a[4]=((C_word)li28),tmp=(C_word)a,a+=5,tmp));
t37=C_mutate((C_word*)lf[72]+1 /* (set! chicken.file.posix#port->fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3878,a[2]=((C_word)li29),tmp=(C_word)a,a+=3,tmp));
t38=C_mutate((C_word*)lf[5]+1 /* (set! chicken.file.posix#duplicate-fileno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3923,a[2]=((C_word)li30),tmp=(C_word)a,a+=3,tmp));
t39=C_mutate((C_word*)lf[184]+1 /* (set! chicken.process-context.posix#current-process-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3950,a[2]=((C_word)li31),tmp=(C_word)a,a+=3,tmp));
t40=C_mutate((C_word*)lf[178]+1 /* (set! chicken.process-context.posix#change-directory* ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3953,a[2]=((C_word)li32),tmp=(C_word)a,a+=3,tmp));
t41=*((C_word*)lf[263]+1);
t42=C_mutate((C_word*)lf[263]+1 /* (set! ##sys#change-directory-hook ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3969,a[2]=t41,a[3]=((C_word)li33),tmp=(C_word)a,a+=4,tmp));
t43=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3983,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t44=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8572,a[2]=((C_word)li230),tmp=(C_word)a,a+=3,tmp);
t45=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8597,a[2]=((C_word)li231),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:568: chicken.base#getter-with-setter */
t46=*((C_word*)lf[495]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t46;
av2[1]=t43;
av2[2]=t44;
av2[3]=t45;
av2[4]=lf[517];
((C_proc)(void*)(*((C_word*)t46+1)))(5,av2);}}

/* mode in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void f_3723(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,3)))){
C_save_and_reclaim_args((void *)trf_3723,4,t1,t2,t3,t4);}
a=C_alloc(4);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3731,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t3)){
t6=C_eqp(t3,lf[241]);
if(C_truep(t6)){
if(C_truep(C_i_not(t2))){
/* posix-common.scm:491: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[199]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[199]+1);
av2[1]=t1;
av2[2]=lf[242];
av2[3]=t4;
tp(4,av2);}}
else{
/* posix-common.scm:493: ##sys#error */
t7=*((C_word*)lf[94]+1);{
C_word av2[4];
av2[0]=t7;
av2[1]=t5;
av2[2]=lf[243];
av2[3]=t3;
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}}
else{
/* posix-common.scm:494: ##sys#error */
t7=*((C_word*)lf[94]+1);{
C_word av2[4];
av2[0]=t7;
av2[1]=t5;
av2[2]=lf[244];
av2[3]=t3;
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}}
else{
if(C_truep(t2)){
/* posix-common.scm:491: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[199]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[199]+1);
av2[1]=t1;
av2[2]=lf[245];
av2[3]=t4;
tp(4,av2);}}
else{
/* posix-common.scm:491: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[199]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[199]+1);
av2[1]=t1;
av2[2]=lf[246];
av2[3]=t4;
tp(4,av2);}}}}

/* k3729 in mode in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3731(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_3731,c,av);}
/* posix-common.scm:491: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[199]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[199]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=((C_word*)t0)[3];
tp(4,av2);}}

/* check in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void f_3756(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,5)))){
C_save_and_reclaim_args((void *)trf_3756,6,t1,t2,t3,t4,t5,t6);}
a=C_alloc(5);
if(C_truep(C_null_pointerp(t5))){
/* posix-common.scm:500: posix-error */
t7=lf[192];{
C_word av2[6];
av2[0]=t7;
av2[1]=t1;
av2[2]=lf[197];
av2[3]=t2;
av2[4]=lf[247];
av2[5]=t3;
f_3238(6,av2);}}
else{
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_3769,a[2]=t5,a[3]=t6,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
if(C_truep(t4)){
/* posix-common.scm:501: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[248]+1));
C_word av2[6];
av2[0]=*((C_word*)lf[248]+1);
av2[1]=t7;
av2[2]=C_fix(1);
av2[3]=*((C_word*)lf[249]+1);
av2[4]=lf[250];
av2[5]=lf[239];
tp(6,av2);}}
else{
/* posix-common.scm:501: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[248]+1));
C_word av2[6];
av2[0]=*((C_word*)lf[248]+1);
av2[1]=t7;
av2[2]=C_fix(2);
av2[3]=*((C_word*)lf[249]+1);
av2[4]=lf[250];
av2[5]=lf[239];
tp(6,av2);}}}}

/* k3767 in check in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3769(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3769,c,av);}
t2=C_set_file_ptr(t1,((C_word*)t0)[2]);
t3=C_i_setslot(t1,C_fix(15),((C_word*)t0)[3]);
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.file.posix#open-input-file* in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3778(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_3778,c,av);}
a=C_alloc(6);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_get_rest_arg(c,3,av,3,t0));
t5=C_rest_nullp(c,3);
t6=C_rest_nullp(c,4);
t7=(C_truep(t6)?lf[251]:C_get_rest_arg(c,4,av,3,t0));
t8=C_rest_nullp(c,4);
t9=C_i_check_fixnum_2(t2,lf[252]);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3802,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,a[5]=t7,tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:508: mode */
f_3723(t10,C_SCHEME_TRUE,t4,lf[252]);}

/* k3800 in chicken.file.posix#open-input-file* in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3802(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(2,c,6)))){
C_save_and_reclaim((void *)f_3802,c,av);}
a=C_alloc(2);
t2=C_fdopen(&a,2,((C_word*)t0)[2],t1);
/* posix-common.scm:508: check */
f_3756(((C_word*)t0)[4],lf[252],((C_word*)t0)[2],C_SCHEME_TRUE,t2,((C_word*)t0)[5]);}

/* chicken.file.posix#open-output-file* in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3828(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_3828,c,av);}
a=C_alloc(6);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_get_rest_arg(c,3,av,3,t0));
t5=C_rest_nullp(c,3);
t6=C_rest_nullp(c,4);
t7=(C_truep(t6)?lf[251]:C_get_rest_arg(c,4,av,3,t0));
t8=C_rest_nullp(c,4);
t9=C_i_check_fixnum_2(t2,lf[253]);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_3852,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,a[5]=t7,tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:512: mode */
f_3723(t10,C_SCHEME_FALSE,t4,lf[253]);}

/* k3850 in chicken.file.posix#open-output-file* in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3852(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(2,c,6)))){
C_save_and_reclaim((void *)f_3852,c,av);}
a=C_alloc(2);
t2=C_fdopen(&a,2,((C_word*)t0)[2],t1);
/* posix-common.scm:512: check */
f_3756(((C_word*)t0)[4],lf[253],((C_word*)t0)[2],C_SCHEME_FALSE,t2,((C_word*)t0)[5]);}

/* chicken.file.posix#port->fileno in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3878(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_3878,c,av);}
a=C_alloc(4);
t3=C_i_check_port_2(t2,C_fix(0),C_SCHEME_TRUE,lf[254]);
t4=C_slot(t2,C_fix(7));
t5=C_eqp(lf[235],t4);
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3894,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:522: ##sys#port-data */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[255]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[255]+1);
av2[1]=t6;
av2[2]=t2;
tp(3,av2);}}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3917,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:523: ##sys#peek-unsigned-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[258]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[258]+1);
av2[1]=t6;
av2[2]=t2;
av2[3]=C_fix(0);
tp(4,av2);}}}

/* k3892 in chicken.file.posix#port->fileno in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3894(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3894,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_slot(t1,C_fix(0));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k3901 in k3915 in chicken.file.posix#port->fileno in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3903(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3903,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k3915 in chicken.file.posix#port->fileno in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3917(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,5)))){
C_save_and_reclaim((void *)f_3917,c,av);}
a=C_alloc(4);
if(C_truep(C_i_not(C_i_zerop(t1)))){
t2=C_port_fileno(((C_word*)t0)[2]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3903,a[2]=((C_word*)t0)[3],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posix-common.scm:526: posix-error */
t4=lf[192];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[197];
av2[3]=lf[254];
av2[4]=lf[256];
av2[5]=((C_word*)t0)[2];
f_3238(6,av2);}}
else{
t4=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}
else{
/* posix-common.scm:528: posix-error */
t2=lf[192];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[201];
av2[3]=lf[254];
av2[4]=lf[257];
av2[5]=((C_word*)t0)[2];
f_3238(6,av2);}}}

/* chicken.file.posix#duplicate-fileno in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3923(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_3923,c,av);}
a=C_alloc(4);
t3=C_i_check_fixnum_2(t2,lf[259]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3930,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_rest_nullp(c,3))){
t5=t4;
f_3930(t5,C_dup(t2));}
else{
t5=C_get_rest_arg(c,3,av,3,t0);
t6=C_i_check_fixnum_2(t5,lf[259]);
t7=t4;
f_3930(t7,C_dup2(t2,t5));}}

/* k3928 in chicken.file.posix#duplicate-fileno in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void f_3930(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,5)))){
C_save_and_reclaim_args((void *)trf_3930,2,t0,t1);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3933,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
/* posix-common.scm:539: posix-error */
t3=lf[192];{
C_word av2[6];
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[197];
av2[3]=lf[259];
av2[4]=lf[260];
av2[5]=((C_word*)t0)[3];
f_3238(6,av2);}}
else{
t3=((C_word*)t0)[2];{
C_word av2[2];
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k3931 in k3928 in chicken.file.posix#duplicate-fileno in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3933(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3933,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.process-context.posix#current-process-id in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3950(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3950,c,av);}
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=stub893(C_SCHEME_UNDEFINED);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.process-context.posix#change-directory* in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3953(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,5)))){
C_save_and_reclaim((void *)f_3953,c,av);}
a=C_alloc(4);
t3=C_i_check_fixnum_2(t2,lf[261]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_3960,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t5=C_eqp(C_fix(0),C_fchdir(t2));
if(C_truep(t5)){
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
/* posix-common.scm:555: posix-error */
t6=lf[192];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t6;
av2[1]=t4;
av2[2]=lf[197];
av2[3]=lf[261];
av2[4]=lf[262];
av2[5]=t2;
f_3238(6,av2);}}}

/* k3958 in chicken.process-context.posix#change-directory* in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3960(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_3960,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* ##sys#change-directory-hook in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3969(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_3969,c,av);}
if(C_truep(C_fixnump(t2))){
t3=*((C_word*)lf[178]+1);
t4=*((C_word*)lf[178]+1);
/* posix-common.scm:560: g900 */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[178]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[178]+1);
av2[1]=t1;
av2[2]=t2;
tp(3,av2);}}
else{
/* posix-common.scm:560: g900 */
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
((C_proc)C_fast_retrieve_proc(t3))(3,av2);}}}

/* k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_3983(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(32,c,4)))){
C_save_and_reclaim((void *)f_3983,c,av);}
a=C_alloc(32);
t2=C_mutate((C_word*)lf[13]+1 /* (set! chicken.file.posix#file-creation-mode ...) */,t1);
t3=C_mutate(&lf[264] /* (set! chicken.posix#decode-seconds ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)C_decode_seconds,a[2]=((C_word)li34),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate(&lf[265] /* (set! chicken.posix#check-time-vector ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_3986,a[2]=((C_word)li35),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[80]+1 /* (set! chicken.time.posix#seconds->local-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4005,a[2]=((C_word)li36),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[78]+1 /* (set! chicken.time.posix#seconds->utc-time ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4026,a[2]=((C_word)li37),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[81]+1 /* (set! chicken.time.posix#seconds->string ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4058,a[2]=((C_word)li38),tmp=(C_word)a,a+=3,tmp));
t8=C_fix((C_word)sizeof(struct tm));
t9=C_mutate((C_word*)lf[82]+1 /* (set! chicken.time.posix#local-time->seconds ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4096,a[2]=t8,a[3]=((C_word)li39),tmp=(C_word)a,a+=4,tmp));
t10=C_fix((C_word)sizeof(struct tm));
t11=C_mutate((C_word*)lf[84]+1 /* (set! chicken.time.posix#time->string ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4141,a[2]=t10,a[3]=((C_word)li40),tmp=(C_word)a,a+=4,tmp));
t12=C_mutate((C_word*)lf[139]+1 /* (set! chicken.process.signal#set-signal-handler! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4203,a[2]=((C_word)li41),tmp=(C_word)a,a+=3,tmp));
t13=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4218,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t14=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8563,a[2]=((C_word)li229),tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:643: chicken.base#getter-with-setter */
t15=*((C_word*)lf[495]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t15;
av2[1]=t13;
av2[2]=t14;
av2[3]=*((C_word*)lf[139]+1);
av2[4]=lf[515];
((C_proc)(void*)(*((C_word*)t15+1)))(5,av2);}}

/* chicken.posix#check-time-vector in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void f_3986(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,4)))){
C_save_and_reclaim_args((void *)trf_3986,3,t1,t2,t3);}
t4=C_i_check_vector_2(t3,t2);
t5=C_block_size(t3);
if(C_truep(C_fixnum_lessp(t5,C_fix(10)))){
/* posix-common.scm:587: ##sys#error */
t6=*((C_word*)lf[94]+1);{
C_word av2[5];
av2[0]=t6;
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[266];
av2[4]=t3;
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}
else{
t6=C_SCHEME_UNDEFINED;
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* chicken.time.posix#seconds->local-time in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4005(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_4005,c,av);}
a=C_alloc(8);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4009,a[2]=t1,a[3]=C_SCHEME_UNDEFINED,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_rest_nullp(c,2))){
/* posix-common.scm:590: chicken.time#current-seconds */
t3=*((C_word*)lf[221]+1);{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_get_rest_arg(c,2,av,2,t0);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f9632,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:591: ##sys#check-exact-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[220]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[220]+1);
av2[1]=t4;
av2[2]=t3;
av2[3]=lf[267];
tp(4,av2);}}}

/* k4007 in chicken.time.posix#seconds->local-time in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4009(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_4009,c,av);}
a=C_alloc(3);
t2=C_mutate(((C_word *)t0)+3,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4012,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:591: ##sys#check-exact-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[220]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[220]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[3];
av2[3]=lf[267];
tp(4,av2);}}

/* k4010 in k4007 in chicken.time.posix#seconds->local-time in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4012(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_4012,c,av);}
t2=((C_word*)t0)[2];
/* posix-common.scm:592: decode-seconds */
{C_proc tp=(C_proc)C_fast_retrieve_proc(lf[264]);
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=lf[264];
av2[1]=((C_word*)t2)[2];
av2[2]=((C_word*)t2)[3];
av2[3]=C_SCHEME_FALSE;
tp(4,av2);}}

/* chicken.time.posix#seconds->utc-time in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4026(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_4026,c,av);}
a=C_alloc(8);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4030,a[2]=t1,a[3]=C_SCHEME_UNDEFINED,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_rest_nullp(c,2))){
/* posix-common.scm:595: chicken.time#current-seconds */
t3=*((C_word*)lf[221]+1);{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_get_rest_arg(c,2,av,2,t0);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f9636,a[2]=t1,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:596: ##sys#check-exact-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[220]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[220]+1);
av2[1]=t4;
av2[2]=t3;
av2[3]=lf[268];
tp(4,av2);}}}

/* k4028 in chicken.time.posix#seconds->utc-time in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4030(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_4030,c,av);}
a=C_alloc(3);
t2=C_mutate(((C_word *)t0)+3,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4033,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:596: ##sys#check-exact-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[220]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[220]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[3];
av2[3]=lf[268];
tp(4,av2);}}

/* k4031 in k4028 in chicken.time.posix#seconds->utc-time in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4033(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_4033,c,av);}
t2=((C_word*)t0)[2];
/* posix-common.scm:597: decode-seconds */
{C_proc tp=(C_proc)C_fast_retrieve_proc(lf[264]);
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=lf[264];
av2[1]=((C_word*)t2)[2];
av2[2]=((C_word*)t2)[3];
av2[3]=C_SCHEME_TRUE;
tp(4,av2);}}

/* chicken.time.posix#seconds->string in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4058(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_4058,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4062,a[2]=t1,a[3]=C_SCHEME_UNDEFINED,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_rest_nullp(c,2))){
/* posix-common.scm:601: chicken.time#current-seconds */
t3=*((C_word*)lf[221]+1);{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=t2;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_get_rest_arg(c,2,av,2,t0);
f_4062(2,av2);}}}

/* k4060 in chicken.time.posix#seconds->string in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4062(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_4062,c,av);}
a=C_alloc(3);
t2=C_mutate(((C_word *)t0)+3,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4065,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:602: ##sys#check-exact-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[220]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[220]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[3];
av2[3]=lf[270];
tp(4,av2);}}

/* k4063 in k4060 in chicken.time.posix#seconds->string in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4065(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_4065,c,av);}
a=C_alloc(8);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4068,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t4=C_a_i_bytevector(&a,1,C_fix(3));
t5=C_fix((C_word)sizeof(int) * CHAR_BIT);
t6=C_i_foreign_ranged_integer_argumentp(((C_word*)t2)[3],t5);
/* posix-common.scm:600: ##sys#peek-c-string */
t7=*((C_word*)lf[194]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t7;
av2[1]=t3;
av2[2]=stub949(t4,t6);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}

/* k4066 in k4063 in k4060 in chicken.time.posix#seconds->string in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4068(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_4068,c,av);}
t2=((C_word*)t0)[2];
if(C_truep(t1)){
t3=C_i_string_length(t1);
/* posix-common.scm:605: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[269]+1));
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[269]+1);
av2[1]=((C_word*)t2)[2];
av2[2]=t1;
av2[3]=C_fix(0);
av2[4]=C_fixnum_difference(t3,C_fix(1));
tp(5,av2);}}
else{
/* posix-common.scm:606: ##sys#error */
t3=*((C_word*)lf[94]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=((C_word*)t2)[2];
av2[2]=lf[270];
av2[3]=lf[271];
av2[4]=((C_word*)t2)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}}

/* chicken.time.posix#local-time->seconds in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4096(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_4096,c,av);}
a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4100,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:611: check-time-vector */
f_3986(t3,lf[272],t2);}

/* k4098 in chicken.time.posix#local-time->seconds in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4100(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_4100,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4104,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:612: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[274]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[274]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=C_make_character(0);
tp(4,av2);}}

/* k4102 in k4098 in chicken.time.posix#local-time->seconds in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4104(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_4104,c,av);}
a=C_alloc(7);
t2=C_a_mktime(&a,2,((C_word*)t0)[2],t1);
if(C_truep(C_i_nequalp(C_fix(-1),t2))){
/* posix-common.scm:614: ##sys#error */
t3=*((C_word*)lf[94]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[272];
av2[3]=lf[273];
av2[4]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}
else{
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* chicken.time.posix#time->string in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4141(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_4141,c,av);}
a=C_alloc(6);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_get_rest_arg(c,3,av,3,t0));
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4148,a[2]=t4,a[3]=t1,a[4]=t2,a[5]=((C_word*)t0)[2],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:622: check-time-vector */
f_3986(t5,lf[275],t2);}

/* k4146 in chicken.time.posix#time->string in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4148(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_4148,c,av);}
a=C_alloc(9);
if(C_truep(((C_word*)t0)[2])){
t2=C_i_check_string_2(((C_word*)t0)[2],lf[275]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4157,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4167,a[2]=t3,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:626: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[199]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[199]+1);
av2[1]=t4;
av2[2]=((C_word*)t0)[2];
av2[3]=lf[275];
tp(4,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4174,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4195,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:628: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[274]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[274]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[5];
av2[3]=C_make_character(0);
tp(4,av2);}}}

/* k4155 in k4146 in chicken.time.posix#time->string in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4157(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_4157,c,av);}
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
/* posix-common.scm:627: ##sys#error */
t2=*((C_word*)lf[94]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[275];
av2[3]=lf[276];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}}

/* k4165 in k4146 in chicken.time.posix#time->string in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4167(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_4167,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4171,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:626: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[274]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[274]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=C_make_character(0);
tp(4,av2);}}

/* k4169 in k4165 in k4146 in chicken.time.posix#time->string in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4171(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_4171,c,av);}
a=C_alloc(5);
t2=C_a_i_bytevector(&a,1,C_fix(3));
if(C_truep(t1)){
t3=C_i_foreign_block_argumentp(t1);
/* posix-common.scm:619: ##sys#peek-c-string */
t4=*((C_word*)lf[194]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=((C_word*)t0)[2];
av2[2]=stub986(t2,((C_word*)t0)[3],((C_word*)t0)[4],t3);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}
else{
/* posix-common.scm:619: ##sys#peek-c-string */
t3=*((C_word*)lf[194]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[2];
av2[2]=stub986(t2,((C_word*)t0)[3],((C_word*)t0)[4],C_SCHEME_FALSE);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}}

/* k4172 in k4146 in chicken.time.posix#time->string in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4174(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_4174,c,av);}
if(C_truep(t1)){
t2=C_i_string_length(t1);
/* posix-common.scm:630: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[269]+1));
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[269]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=C_fix(0);
av2[4]=C_fixnum_difference(t2,C_fix(1));
tp(5,av2);}}
else{
/* posix-common.scm:631: ##sys#error */
t2=*((C_word*)lf[94]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[275];
av2[3]=lf[277];
av2[4]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}}

/* k4193 in k4146 in chicken.time.posix#time->string in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4195(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_4195,c,av);}
a=C_alloc(5);
t2=C_a_i_bytevector(&a,1,C_fix(3));
if(C_truep(t1)){
t3=C_i_foreign_block_argumentp(t1);
/* posix-common.scm:618: ##sys#peek-c-string */
t4=*((C_word*)lf[194]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=((C_word*)t0)[2];
av2[2]=stub976(t2,((C_word*)t0)[3],t3);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}
else{
/* posix-common.scm:618: ##sys#peek-c-string */
t3=*((C_word*)lf[194]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[2];
av2[2]=stub976(t2,((C_word*)t0)[3],C_SCHEME_FALSE);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}}

/* chicken.process.signal#set-signal-handler! in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4203(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4203,c,av);}
t4=C_i_check_fixnum_2(t2,lf[278]);
if(C_truep(t3)){
t5=C_establish_signal_handler(t2,t2);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_i_vector_set(*((C_word*)lf[279]+1),t2,t3);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t5=C_establish_signal_handler(t2,C_SCHEME_FALSE);
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_i_vector_set(*((C_word*)lf[279]+1),t2,t3);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4218(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(116,c,8)))){
C_save_and_reclaim((void *)f_4218,c,av);}
a=C_alloc(116);
t2=C_mutate((C_word*)lf[141]+1 /* (set! chicken.process.signal#signal-handler ...) */,t1);
t3=C_mutate((C_word*)lf[142]+1 /* (set! chicken.process.signal#make-signal-handler ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4220,a[2]=((C_word)li46),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[143]+1 /* (set! chicken.process.signal#signal-ignore ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4286,a[2]=((C_word)li47),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[144]+1 /* (set! chicken.process.signal#signal-default ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4295,a[2]=((C_word)li48),tmp=(C_word)a,a+=3,tmp));
t6=lf[287] /* chicken.posix#children */ =C_SCHEME_END_OF_LIST;;
t7=C_mutate(&lf[288] /* (set! chicken.posix#process? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4312,a[2]=((C_word)li49),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate(&lf[290] /* (set! chicken.posix#process-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4327,a[2]=((C_word)li50),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate(&lf[291] /* (set! chicken.posix#process-returned-normally? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4345,a[2]=((C_word)li51),tmp=(C_word)a,a+=3,tmp));
t10=C_mutate(&lf[292] /* (set! chicken.posix#process-input-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4363,a[2]=((C_word)li52),tmp=(C_word)a,a+=3,tmp));
t11=C_mutate(&lf[293] /* (set! chicken.posix#process-output-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4381,a[2]=((C_word)li53),tmp=(C_word)a,a+=3,tmp));
t12=C_mutate(&lf[294] /* (set! chicken.posix#process-error-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4399,a[2]=((C_word)li54),tmp=(C_word)a,a+=3,tmp));
t13=C_mutate(&lf[295] /* (set! chicken.posix#process-exit-status ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4417,a[2]=((C_word)li55),tmp=(C_word)a,a+=3,tmp));
t14=C_mutate((C_word*)lf[124]+1 /* (set! chicken.process#process? ...) */,lf[288]);
t15=C_mutate((C_word*)lf[130]+1 /* (set! chicken.process#process-id ...) */,lf[290]);
t16=C_mutate((C_word*)lf[125]+1 /* (set! chicken.process#process-exit-status ...) */,lf[295]);
t17=C_mutate((C_word*)lf[126]+1 /* (set! chicken.process#process-returned-normally? ...) */,lf[291]);
t18=C_mutate((C_word*)lf[127]+1 /* (set! chicken.process#process-input-port ...) */,lf[292]);
t19=C_mutate((C_word*)lf[128]+1 /* (set! chicken.process#process-output-port ...) */,lf[293]);
t20=C_mutate((C_word*)lf[129]+1 /* (set! chicken.process#process-error-port ...) */,lf[294]);
t21=C_mutate((C_word*)lf[123]+1 /* (set! chicken.process#process-sleep ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4506,a[2]=((C_word)li56),tmp=(C_word)a,a+=3,tmp));
t22=C_mutate((C_word*)lf[111]+1 /* (set! chicken.process#process-wait ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4512,a[2]=((C_word)li60),tmp=(C_word)a,a+=3,tmp));
t23=C_mutate(&lf[301] /* (set! chicken.posix#list->c-string-buffer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4648,a[2]=((C_word)li69),tmp=(C_word)a,a+=3,tmp));
t24=C_mutate(&lf[303] /* (set! chicken.posix#free-c-string-buffer ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4765,a[2]=((C_word)li71),tmp=(C_word)a,a+=3,tmp));
t25=C_mutate(&lf[312] /* (set! chicken.posix#check-environment-list ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4799,a[2]=((C_word)li74),tmp=(C_word)a,a+=3,tmp));
t26=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4846,a[2]=((C_word)li75),tmp=(C_word)a,a+=3,tmp);
t27=C_mutate(&lf[313] /* (set! chicken.posix#call-with-exec-args ...) */,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4848,a[2]=C_SCHEME_UNDEFINED,a[3]=C_SCHEME_UNDEFINED,a[4]=C_SCHEME_UNDEFINED,a[5]=C_SCHEME_UNDEFINED,a[6]=C_SCHEME_UNDEFINED,a[7]=t26,a[8]=((C_word)li84),tmp=(C_word)a,a+=9,tmp));
t28=C_set_block_item(lf[131] /* chicken.process#pipe/buf */,0,C_fix((C_word)PIPE_BUF));
t29=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5002,a[2]=((C_word)li85),tmp=(C_word)a,a+=3,tmp);
t30=C_mutate((C_word*)lf[117]+1 /* (set! chicken.process#open-input-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5021,a[2]=t29,a[3]=((C_word)li86),tmp=(C_word)a,a+=4,tmp));
t31=C_mutate((C_word*)lf[118]+1 /* (set! chicken.process#open-output-pipe ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5061,a[2]=t29,a[3]=((C_word)li87),tmp=(C_word)a,a+=4,tmp));
t32=C_mutate((C_word*)lf[114]+1 /* (set! chicken.process#close-input-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5101,a[2]=((C_word)li88),tmp=(C_word)a,a+=3,tmp));
t33=C_mutate((C_word*)lf[115]+1 /* (set! chicken.process#close-output-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5116,a[2]=((C_word)li89),tmp=(C_word)a,a+=3,tmp));
t34=C_mutate((C_word*)lf[119]+1 /* (set! chicken.process#with-input-from-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5131,a[2]=((C_word)li94),tmp=(C_word)a,a+=3,tmp));
t35=C_mutate((C_word*)lf[113]+1 /* (set! chicken.process#call-with-output-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5165,a[2]=((C_word)li97),tmp=(C_word)a,a+=3,tmp));
t36=C_mutate((C_word*)lf[112]+1 /* (set! chicken.process#call-with-input-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5189,a[2]=((C_word)li100),tmp=(C_word)a,a+=3,tmp));
t37=C_mutate((C_word*)lf[120]+1 /* (set! chicken.process#with-output-to-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5213,a[2]=((C_word)li105),tmp=(C_word)a,a+=3,tmp));
t38=C_mutate((C_word*)lf[331]+1 /* (set! ##sys#file-nonblocking! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5247,a[2]=((C_word)li106),tmp=(C_word)a,a+=3,tmp));
t39=C_mutate((C_word*)lf[332]+1 /* (set! ##sys#file-select-one ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5254,a[2]=((C_word)li107),tmp=(C_word)a,a+=3,tmp));
t40=C_set_block_item(lf[6] /* chicken.file.posix#fcntl/dupfd */,0,C_fix((C_word)F_DUPFD));
t41=C_set_block_item(lf[7] /* chicken.file.posix#fcntl/getfd */,0,C_fix((C_word)F_GETFD));
t42=C_set_block_item(lf[9] /* chicken.file.posix#fcntl/setfd */,0,C_fix((C_word)F_SETFD));
t43=C_set_block_item(lf[8] /* chicken.file.posix#fcntl/getfl */,0,C_fix((C_word)F_GETFL));
t44=C_set_block_item(lf[10] /* chicken.file.posix#fcntl/setfl */,0,C_fix((C_word)F_SETFL));
t45=C_set_block_item(lf[48] /* chicken.file.posix#open/nonblock */,0,C_fix((C_word)O_NONBLOCK));
t46=C_set_block_item(lf[46] /* chicken.file.posix#open/noctty */,0,C_fix((C_word)O_NOCTTY));
t47=C_set_block_item(lf[45] /* chicken.file.posix#open/fsync */,0,C_fix((C_word)O_FSYNC));
t48=C_set_block_item(lf[52] /* chicken.file.posix#open/sync */,0,C_fix((C_word)O_SYNC));
t49=C_set_block_item(lf[47] /* chicken.file.posix#open/noinherit */,0,C_fix(0));
t50=C_set_block_item(lf[132] /* chicken.process#spawn/overlay */,0,C_fix(0));
t51=C_set_block_item(lf[133] /* chicken.process#spawn/wait */,0,C_fix(0));
t52=C_set_block_item(lf[134] /* chicken.process#spawn/nowait */,0,C_fix(0));
t53=C_set_block_item(lf[135] /* chicken.process#spawn/nowaito */,0,C_fix(0));
t54=C_set_block_item(lf[136] /* chicken.process#spawn/detach */,0,C_fix(0));
t55=C_set_block_item(lf[65] /* chicken.file.posix#perm/isvtx */,0,C_fix((C_word)S_ISVTX));
t56=C_set_block_item(lf[64] /* chicken.file.posix#perm/isuid */,0,C_fix((C_word)S_ISUID));
t57=C_set_block_item(lf[63] /* chicken.file.posix#perm/isgid */,0,C_fix((C_word)S_ISGID));
t58=C_mutate((C_word*)lf[12]+1 /* (set! chicken.file.posix#file-control ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5294,a[2]=((C_word)li108),tmp=(C_word)a,a+=3,tmp));
t59=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)va9621,a[2]=((C_word*)t0)[2],a[3]=((C_word)li225),tmp=(C_word)a,a+=4,tmp);
t60=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)va9623,a[2]=t59,a[3]=((C_word)li226),tmp=(C_word)a,a+=4,tmp);
t61=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)va9625,a[2]=t60,a[3]=((C_word)li227),tmp=(C_word)a,a+=4,tmp);
t62=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)va9627,a[2]=t61,a[3]=((C_word)li228),tmp=(C_word)a,a+=4,tmp);
t63=t62;
va9627(t63,C_s_a_i_bitwise_ior(&a,2,C_fix((C_word)S_IRUSR),C_fix((C_word)S_IWUSR)));}

/* chicken.process.signal#make-signal-handler in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4220(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_4220,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4224,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:652: ##sys#make-event-queue */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[284]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[284]+1);
av2[1]=t3;
tp(2,av2);}}

/* k4222 in chicken.process.signal#make-signal-handler in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4224(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,c,3)))){
C_save_and_reclaim((void *)f_4224,c,av);}
a=C_alloc(15);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4225,a[2]=t1,a[3]=((C_word)li43),tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4241,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4263,a[2]=t5,a[3]=t2,a[4]=((C_word)li45),tmp=(C_word)a,a+=5,tmp));
t7=((C_word*)t5)[1];
f_4263(t7,t3,((C_word*)t0)[3]);}

/* g1024 in k4222 in chicken.process.signal#make-signal-handler in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void f_4225(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,3)))){
C_save_and_reclaim_args((void *)trf_4225,3,t0,t1,t2);}
a=C_alloc(4);
t3=C_i_check_fixnum_2(t2,lf[280]);
t4=C_establish_signal_handler(t2,t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4234,a[2]=((C_word*)t0)[2],a[3]=((C_word)li42),tmp=(C_word)a,a+=4,tmp);
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=C_i_vector_set(*((C_word*)lf[279]+1),t2,t5);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* a4233 in g1024 in k4222 in chicken.process.signal#make-signal-handler in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4234(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_4234,c,av);}
/* posix-common.scm:658: ##sys#add-event-to-queue! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[281]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[281]+1);
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
av2[3]=t2;
tp(4,av2);}}

/* k4239 in k4222 in chicken.process.signal#make-signal-handler in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4241(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_4241,c,av);}
a=C_alloc(4);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4242,a[2]=((C_word*)t0)[3],a[3]=((C_word)li44),tmp=(C_word)a,a+=4,tmp);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* f_4242 in k4239 in k4222 in chicken.process.signal#make-signal-handler in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4242(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_4242,c,av);}
if(C_truep(C_rest_nullp(c,2))){
/* posix-common.scm:663: ##sys#get-next-event */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[282]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[282]+1);
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
tp(3,av2);}}
else{
if(C_truep(C_get_rest_arg(c,2,av,2,t0))){
/* posix-common.scm:662: ##sys#wait-for-next-event */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[283]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[283]+1);
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
tp(3,av2);}}
else{
/* posix-common.scm:663: ##sys#get-next-event */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[282]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[282]+1);
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
tp(3,av2);}}}}

/* for-each-loop1023 in k4222 in chicken.process.signal#make-signal-handler in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void f_4263(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_4263,3,t0,t1,t2);}
a=C_alloc(5);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4273,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:653: g1024 */
t4=((C_word*)t0)[3];
f_4225(t4,t3,C_slot(t2,C_fix(0)));}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k4271 in for-each-loop1023 in k4222 in chicken.process.signal#make-signal-handler in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4273(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_4273,c,av);}
t2=((C_word*)((C_word*)t0)[2])[1];
f_4263(t2,((C_word*)t0)[3],C_slot(((C_word*)t0)[4],C_fix(1)));}

/* chicken.process.signal#signal-ignore in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4286(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4286,c,av);}
t3=C_i_check_fixnum_2(t2,lf[285]);
t4=C_establish_signal_handler(t2,C_SCHEME_FALSE);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_i_vector_set(*((C_word*)lf[279]+1),t2,C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* chicken.process.signal#signal-default in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4295(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4295,c,av);}
t3=C_i_check_fixnum_2(t2,lf[286]);
t4=C_establish_signal_handler(t2,C_SCHEME_TRUE);
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_i_vector_set(*((C_word*)lf[279]+1),t2,C_SCHEME_FALSE);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* chicken.posix#process? in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4312(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4312,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_i_structurep(t2,lf[289]);
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.posix#process-id in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4327(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4327,c,av);}
t3=C_i_check_structure(t2,lf[289]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_block_ref(t2,C_fix(1));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.posix#process-returned-normally? in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4345(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4345,c,av);}
t3=C_i_check_structure(t2,lf[289]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_block_ref(t2,C_fix(2));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.posix#process-input-port in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4363(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4363,c,av);}
t3=C_i_check_structure(t2,lf[289]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_block_ref(t2,C_fix(3));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.posix#process-output-port in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4381(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4381,c,av);}
t3=C_i_check_structure(t2,lf[289]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_block_ref(t2,C_fix(4));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.posix#process-error-port in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4399(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4399,c,av);}
t3=C_i_check_structure(t2,lf[289]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_block_ref(t2,C_fix(5));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.posix#process-exit-status in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4417(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4417,c,av);}
t3=C_i_check_structure(t2,lf[289]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_block_ref(t2,C_fix(6));
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* rec in k4583 in a4562 in k4547 in k4529 in chicken.process#process-wait in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static C_word f_4474(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t1))){
return(C_SCHEME_END_OF_LIST);}
else{
t2=C_i_caar(t1);
t3=C_eqp(((C_word*)t0)[2],t2);
if(C_truep(t3)){
return(C_u_i_cdr(t1));}
else{
t5=C_u_i_cdr(t1);
t1=t5;
goto loop;}}}

/* chicken.process#process-sleep in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4506(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4506,c,av);}
t3=C_i_check_fixnum_2(t2,lf[296]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_i_process_sleep(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.process#process-wait in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4512(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_4512,c,av);}
a=C_alloc(7);
t2=C_rest_nullp(c,2);
t3=(C_truep(t2)?C_SCHEME_FALSE:C_get_rest_arg(c,2,av,2,t0));
t4=t3;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_rest_nullp(c,2);
t7=C_rest_nullp(c,3);
t8=(C_truep(t7)?C_SCHEME_FALSE:C_get_rest_arg(c,3,av,2,t0));
t9=C_rest_nullp(c,3);
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4531,a[2]=t8,a[3]=t5,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
t11=((C_word*)t5)[1];
if(C_truep(C_i_structurep(t11,lf[289]))){
t12=((C_word*)t5)[1];
t13=C_i_check_structure(t12,lf[289]);
t14=t10;
f_4531(t14,C_i_block_ref(t12,C_fix(6)));}
else{
t12=t10;
f_4531(t12,C_SCHEME_FALSE);}}

/* k4529 in chicken.process#process-wait in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void f_4531(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,4)))){
C_save_and_reclaim_args((void *)trf_4531,2,t0,t1);}
a=C_alloc(6);
if(C_truep(t1)){
t2=((C_word*)((C_word*)t0)[3])[1];
t3=C_i_check_structure(t2,lf[289]);
t4=C_i_block_ref(t2,C_fix(1));
t5=((C_word*)((C_word*)t0)[3])[1];
t6=C_i_check_structure(t5,lf[289]);
t7=C_i_block_ref(t5,C_fix(2));
t8=((C_word*)((C_word*)t0)[3])[1];
t9=C_i_check_structure(t8,lf[289]);
/* posix-common.scm:719: scheme#values */{
C_word av2[5];
av2[0]=0;
av2[1]=((C_word*)t0)[4];
av2[2]=t4;
av2[3]=t7;
av2[4]=C_i_block_ref(t8,C_fix(6));
C_values(5,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4549,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t3=((C_word*)((C_word*)t0)[3])[1];
t4=C_a_i_list(&a,1,C_fix(-1));
t5=C_i_nullp(t4);
t6=(C_truep(t5)?C_SCHEME_FALSE:C_i_car(t4));
if(C_truep(C_fixnump(t3))){
t7=t2;
f_4549(t7,t3);}
else{
if(C_truep(C_i_structurep(t3,lf[289]))){
t7=C_SCHEME_UNDEFINED;
t8=t2;
f_4549(t8,C_i_block_ref(t3,C_fix(1)));}
else{
t7=t2;
f_4549(t7,t6);}}}}

/* k4547 in k4529 in chicken.process#process-wait in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void f_4549(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,0,5)))){
C_save_and_reclaim_args((void *)trf_4549,2,t0,t1);}
a=C_alloc(10);
t2=((C_word*)t0)[2];
t3=C_i_check_fixnum_2(t1,lf[297]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4557,a[2]=t1,a[3]=((C_word*)t2)[2],a[4]=((C_word)li57),tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4563,a[2]=t1,a[3]=((C_word*)t2)[3],a[4]=((C_word)li59),tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:724: ##sys#call-with-values */{
C_word av2[4];
av2[0]=0;
av2[1]=((C_word*)t2)[4];
av2[2]=t4;
av2[3]=t5;
C_call_with_values(4,av2);}}

/* a4556 in k4547 in k4529 in chicken.process#process-wait in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4557(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_4557,c,av);}
/* posix-common.scm:724: process-wait-impl */
f_7742(t1,((C_word*)t0)[2],((C_word*)t0)[3]);}

/* a4562 in k4547 in k4529 in chicken.process#process-wait in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4563(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,5)))){
C_save_and_reclaim((void *)f_4563,c,av);}
a=C_alloc(7);
switch(t2){
case C_fix(-1):
/* posix-common.scm:727: posix-error */
t5=lf[192];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=lf[90];
av2[3]=lf[297];
av2[4]=lf[299];
av2[5]=((C_word*)t0)[2];
f_3238(6,av2);}
case C_fix(0):
/* posix-common.scm:730: scheme#values */{
C_word *av2=av;
av2[0]=0;
av2[1]=t1;
av2[2]=C_fix(0);
av2[3]=C_SCHEME_FALSE;
av2[4]=C_SCHEME_FALSE;
C_values(5,av2);}
default:
t5=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4585,a[2]=t2,a[3]=t1,a[4]=t3,a[5]=t4,a[6]=((C_word*)t0)[3],tmp=(C_word)a,a+=7,tmp);
t6=((C_word*)((C_word*)t0)[3])[1];
if(C_truep(C_i_structurep(t6,lf[289]))){
t7=t5;
f_4585(t7,C_SCHEME_UNDEFINED);}
else{
t7=C_i_assq(t2,lf[287]);
if(C_truep(t7)){
t8=C_i_cdr(t7);
t9=C_mutate(((C_word *)((C_word*)t0)[3])+1,t8);
t10=t5;
f_4585(t10,t9);}
else{
t8=C_SCHEME_UNDEFINED;
t9=t5;
f_4585(t9,t8);}}}}

/* k4583 in a4562 in k4547 in k4529 in chicken.process#process-wait in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void f_4585(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,0,4)))){
C_save_and_reclaim_args((void *)trf_4585,2,t0,t1);}
a=C_alloc(15);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4474,a[2]=((C_word*)t0)[2],a[3]=((C_word)li58),tmp=(C_word)a,a+=4,tmp);
t3=(
  f_4474(t2,lf[287])
);
t4=C_mutate(&lf[287] /* (set! chicken.posix#children ...) */,t3);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4591,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
t6=((C_word*)((C_word*)t0)[6])[1];
if(C_truep(C_i_structurep(t6,lf[289]))){
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4600,a[2]=((C_word*)t0)[6],a[3]=t5,a[4]=((C_word*)t0)[5],tmp=(C_word)a,a+=5,tmp);
t8=((C_word*)((C_word*)t0)[6])[1];
t9=C_i_check_structure(t8,lf[289]);
/* posix-common.scm:682: ##sys#block-set! */
t10=*((C_word*)lf[300]+1);{
C_word av2[5];
av2[0]=t10;
av2[1]=t7;
av2[2]=t8;
av2[3]=C_fix(2);
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t10+1)))(5,av2);}}
else{
/* posix-common.scm:740: scheme#values */{
C_word av2[5];
av2[0]=0;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[2];
av2[3]=((C_word*)t0)[4];
av2[4]=((C_word*)t0)[5];
C_values(5,av2);}}}

/* k4589 in k4583 in a4562 in k4547 in k4529 in chicken.process#process-wait in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4591(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_4591,c,av);}
/* posix-common.scm:740: scheme#values */{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
av2[4]=((C_word*)t0)[5];
C_values(5,av2);}}

/* k4598 in k4583 in a4562 in k4547 in k4529 in chicken.process#process-wait in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4600(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_4600,c,av);}
t2=((C_word*)((C_word*)t0)[2])[1];
t3=C_i_check_structure(t2,lf[289]);
/* posix-common.scm:682: ##sys#block-set! */
t4=*((C_word*)lf[300]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
av2[3]=C_fix(6);
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t4+1)))(5,av2);}}

/* chicken.posix#list->c-string-buffer in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void f_4648(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,0,3)))){
C_save_and_reclaim_args((void *)trf_4648,4,t1,t2,t3,t4);}
a=C_alloc(12);
t5=C_i_check_list_2(t2,t4);
t6=C_u_i_length(t2);
t7=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4656,a[2]=t1,a[3]=t6,a[4]=t4,a[5]=t3,a[6]=t2,tmp=(C_word)a,a+=7,tmp);
t8=C_a_i_fixnum_plus(&a,2,t6,C_fix(1));
/* posix-common.scm:749: chicken.memory#make-pointer-vector */
t9=*((C_word*)lf[308]+1);{
C_word av2[4];
av2[0]=t9;
av2[1]=t7;
av2[2]=t8;
av2[3]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t9+1)))(4,av2);}}

/* k4654 in chicken.posix#list->c-string-buffer in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4656(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,3)))){
C_save_and_reclaim((void *)f_4656,c,av);}
a=C_alloc(11);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4659,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4664,a[2]=t1,a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word)li68),tmp=(C_word)a,a+=8,tmp);
/* posix-common.scm:751: scheme#call-with-current-continuation */
t4=*((C_word*)lf[307]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t2;
av2[2]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k4657 in k4654 in chicken.posix#list->c-string-buffer in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4659(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4659,c,av);}
/* posix-common.scm:747: g1193 */
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
((C_proc)C_fast_retrieve_proc(t2))(2,av2);}}

/* a4663 in k4654 in chicken.posix#list->c-string-buffer in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4664(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(14,c,3)))){
C_save_and_reclaim((void *)f_4664,c,av);}
a=C_alloc(14);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4670,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=((C_word)li62),tmp=(C_word)a,a+=5,tmp);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_4685,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t2,a[8]=((C_word)li67),tmp=(C_word)a,a+=9,tmp);
/* posix-common.scm:751: chicken.condition#with-exception-handler */
t5=*((C_word*)lf[306]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t3;
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* a4669 in a4663 in k4654 in chicken.posix#list->c-string-buffer in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4670(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_4670,c,av);}
a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4676,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word)li61),tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:751: k1190 */
t4=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t1;
av2[2]=t3;
((C_proc)C_fast_retrieve_proc(t4))(3,av2);}}

/* a4675 in a4669 in a4663 in k4654 in chicken.posix#list->c-string-buffer in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4676(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_4676,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4680,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:753: free-c-string-buffer */
f_4765(t2,((C_word*)t0)[3]);}

/* k4678 in a4675 in a4669 in a4663 in k4654 in chicken.posix#list->c-string-buffer in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4680(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_4680,c,av);}
/* posix-common.scm:753: chicken.condition#signal */
t2=*((C_word*)lf[302]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* a4684 in a4663 in k4654 in chicken.posix#list->c-string-buffer in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4685(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(16,c,3)))){
C_save_and_reclaim((void *)f_4685,c,av);}
a=C_alloc(16);
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4687,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word)li64),tmp=(C_word)a,a+=8,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4744,a[2]=((C_word*)t0)[7],a[3]=((C_word)li66),tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4761,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* tmp12807 */
t5=t2;
f_4687(t5,t4);}

/* tmp12807 in a4684 in a4663 in k4654 in chicken.posix#list->c-string-buffer in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void f_4687(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(14,0,4)))){
C_save_and_reclaim_args((void *)trf_4687,2,t0,t1);}
a=C_alloc(14);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4691,a[2]=t1,a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4693,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=t4,a[5]=((C_word*)t0)[2],a[6]=((C_word*)t0)[5],a[7]=((C_word)li63),tmp=(C_word)a,a+=8,tmp));
t6=((C_word*)t4)[1];
f_4693(t6,t2,((C_word*)t0)[6],C_fix(0));}

/* k4689 in tmp12807 in a4684 in a4663 in k4654 in chicken.posix#list->c-string-buffer in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4691(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4691,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* doloop1198 in tmp12807 in a4684 in a4663 in k4654 in chicken.posix#list->c-string-buffer in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void f_4693(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,0,2)))){
C_save_and_reclaim_args((void *)trf_4693,4,t0,t1,t2,t3);}
a=C_alloc(12);
t4=C_i_nullp(t2);
t5=(C_truep(t4)?t4:C_eqp(t3,((C_word*)t0)[2]));
if(C_truep(t5)){
t6=C_SCHEME_UNDEFINED;
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
t6=C_i_car(t2);
t7=C_i_check_string_2(t6,((C_word*)t0)[3]);
t8=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4709,a[2]=((C_word*)t0)[4],a[3]=t1,a[4]=t2,a[5]=t3,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[3],tmp=(C_word)a,a+=8,tmp);
t9=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4734,a[2]=t8,a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:762: convert */
t10=((C_word*)t0)[6];{
C_word av2[3];
av2[0]=t10;
av2[1]=t9;
av2[2]=C_u_i_car(t2);
((C_proc)C_fast_retrieve_proc(t10))(3,av2);}}}

/* k4707 in doloop1198 in tmp12807 in a4684 in a4663 in k4654 in chicken.posix#list->c-string-buffer in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4709(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(13,c,3)))){
C_save_and_reclaim((void *)f_4709,c,av);}
a=C_alloc(13);
t2=C_a_i_bytevector(&a,1,C_fix(3));
t3=stub2173(t2,t1);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4715,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=t3,tmp=(C_word)a,a+=8,tmp);
if(C_truep(t3)){
t5=t4;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_SCHEME_UNDEFINED;
f_4715(2,av2);}}
else{
/* posix-common.scm:764: chicken.base#error */
t5=*((C_word*)lf[100]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=((C_word*)t0)[7];
av2[3]=lf[305];
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}}

/* k4713 in k4707 in doloop1198 in tmp12807 in a4684 in a4663 in k4654 in chicken.posix#list->c-string-buffer in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4715(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_4715,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4718,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:765: chicken.memory#pointer-vector-set! */
t3=*((C_word*)lf[304]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[6];
av2[3]=((C_word*)t0)[5];
av2[4]=((C_word*)t0)[7];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}

/* k4716 in k4713 in k4707 in doloop1198 in tmp12807 in a4684 in a4663 in k4654 in chicken.posix#list->c-string-buffer in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4718(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_4718,c,av);}
t2=((C_word*)((C_word*)t0)[2])[1];
f_4693(t2,((C_word*)t0)[3],C_u_i_cdr(((C_word*)t0)[4]),C_fixnum_plus(((C_word*)t0)[5],C_fix(1)));}

/* k4732 in doloop1198 in tmp12807 in a4684 in a4663 in k4654 in chicken.posix#list->c-string-buffer in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4734(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_4734,c,av);}
/* posix-common.scm:762: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[199]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[199]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=((C_word*)t0)[3];
tp(4,av2);}}

/* tmp22808 in a4684 in a4663 in k4654 in chicken.posix#list->c-string-buffer in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void f_4744(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_4744,3,t0,t1,t2);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4750,a[2]=t2,a[3]=((C_word)li65),tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:751: k1190 */
t4=((C_word*)t0)[2];{
C_word av2[3];
av2[0]=t4;
av2[1]=t1;
av2[2]=t3;
((C_proc)C_fast_retrieve_proc(t4))(3,av2);}}

/* a4749 in tmp22808 in a4684 in a4663 in k4654 in chicken.posix#list->c-string-buffer in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4750(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_4750,c,av);}{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
C_apply_values(3,av2);}}

/* k4759 in a4684 in a4663 in k4654 in chicken.posix#list->c-string-buffer in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4761(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_4761,c,av);}
a=C_alloc(3);
/* tmp22808 */
t2=((C_word*)t0)[2];
f_4744(t2,((C_word*)t0)[3],C_a_i_list(&a,1,t1));}

/* chicken.posix#free-c-string-buffer in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void f_4765(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_4765,2,t1,t2);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4769,a[2]=t2,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:770: chicken.memory#pointer-vector-length */
t4=*((C_word*)lf[311]+1);{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k4767 in chicken.posix#free-c-string-buffer in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4769(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_4769,c,av);}
a=C_alloc(8);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4774,a[2]=t1,a[3]=t3,a[4]=((C_word*)t0)[2],a[5]=((C_word)li70),tmp=(C_word)a,a+=6,tmp));
t5=((C_word*)t3)[1];
f_4774(t5,((C_word*)t0)[3],C_fix(0));}

/* doloop1217 in k4767 in chicken.posix#free-c-string-buffer in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void f_4774(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_4774,3,t0,t1,t2);}
a=C_alloc(5);
t3=C_eqp(t2,((C_word*)t0)[2]);
if(C_truep(t3)){
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word av2[2];
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4784,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:773: chicken.memory#pointer-vector-ref */
t5=*((C_word*)lf[310]+1);{
C_word av2[4];
av2[0]=t5;
av2[1]=t4;
av2[2]=((C_word*)t0)[4];
av2[3]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}}

/* k4782 in doloop1217 in k4767 in chicken.posix#free-c-string-buffer in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4784(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_4784,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4787,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
if(C_truep(t1)){
/* posix-common.scm:774: chicken.memory#free */
t3=*((C_word*)lf[309]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
t3=((C_word*)((C_word*)t0)[2])[1];
f_4774(t3,((C_word*)t0)[3],C_fixnum_plus(((C_word*)t0)[4],C_fix(1)));}}

/* k4785 in k4782 in doloop1217 in k4767 in chicken.posix#free-c-string-buffer in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4787(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_4787,c,av);}
t2=((C_word*)t0)[2];
t3=((C_word*)((C_word*)t2)[2])[1];
f_4774(t3,((C_word*)t2)[3],C_fixnum_plus(((C_word*)t2)[4],C_fix(1)));}

/* chicken.posix#check-environment-list in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void f_4799(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,2)))){
C_save_and_reclaim_args((void *)trf_4799,3,t1,t2,t3);}
a=C_alloc(8);
t4=C_i_check_list_2(t2,t3);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4804,a[2]=t3,a[3]=((C_word)li72),tmp=(C_word)a,a+=4,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4823,a[2]=t5,a[3]=((C_word)li73),tmp=(C_word)a,a+=4,tmp);
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=(
  f_4823(t6,t2)
);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* g1230 in chicken.posix#check-environment-list in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static C_word f_4804(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_stack_overflow_check;{}
t2=C_i_check_pair_2(t1,((C_word*)t0)[2]);
t3=C_i_check_string_2(C_u_i_car(t1),((C_word*)t0)[2]);
return(C_i_check_string_2(C_u_i_cdr(t1),((C_word*)t0)[2]));}

/* for-each-loop1229 in chicken.posix#check-environment-list in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static C_word f_4823(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_pairp(t1))){
t2=(
/* posix-common.scm:779: g1230 */
  f_4804(((C_word*)t0)[2],C_slot(t1,C_fix(0)))
);
t4=C_slot(t1,C_fix(1));
t1=t4;
goto loop;}
else{
t2=C_SCHEME_UNDEFINED;
return(t2);}}

/* nop in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4846(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4846,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.posix#call-with-exec-args in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void f_4848(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,4)))){
C_save_and_reclaim_args((void *)trf_4848,8,t0,t1,t2,t3,t4,t5,t6,t7);}
a=C_alloc(6);
t8=C_mutate(((C_word *)t0)+3,t7);
t9=C_mutate(((C_word *)t0)+6,t6);
t10=C_mutate(((C_word *)t0)+4,t3);
t11=C_mutate(((C_word *)t0)+5,t2);
t12=C_mutate(((C_word *)t0)+2,t1);
t13=C_a_i_cons(&a,2,((C_word*)t0)[4],t5);
t14=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4855,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:790: list->c-string-buffer */
f_4648(t14,t13,t4,((C_word*)t0)[5]);}

/* k4853 in chicken.posix#call-with-exec-args in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4855(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,c,3)))){
C_save_and_reclaim((void *)f_4855,c,av);}
a=C_alloc(15);
t2=((C_word*)t0)[2];
t3=C_SCHEME_FALSE;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_4858,a[2]=((C_word*)t2)[2],tmp=(C_word)a,a+=3,tmp);
t6=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4863,a[2]=t4,a[3]=t1,a[4]=((C_word*)t2)[3],a[5]=((C_word*)t2)[4],a[6]=((C_word*)t2)[5],a[7]=((C_word*)t2)[6],a[8]=((C_word*)t2)[7],a[9]=((C_word)li83),tmp=(C_word)a,a+=10,tmp);
/* posix-common.scm:793: scheme#call-with-current-continuation */
t7=*((C_word*)lf[307]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t7;
av2[1]=t5;
av2[2]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}

/* k4856 in k4853 in chicken.posix#call-with-exec-args in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4858(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4858,c,av);}
/* posix-common.scm:789: g1263 */
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
((C_proc)C_fast_retrieve_proc(t2))(2,av2);}}

/* a4862 in k4853 in chicken.posix#call-with-exec-args in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4863(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(17,c,3)))){
C_save_and_reclaim((void *)f_4863,c,av);}
a=C_alloc(17);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4869,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t2,a[5]=((C_word)li77),tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_4890,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=t2,a[10]=((C_word)li82),tmp=(C_word)a,a+=11,tmp);
/* posix-common.scm:793: chicken.condition#with-exception-handler */
t5=*((C_word*)lf[306]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t3;
av2[3]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* a4868 in a4862 in k4853 in chicken.posix#call-with-exec-args in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4869(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_4869,c,av);}
a=C_alloc(6);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4875,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word)li76),tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:793: k1260 */
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t1;
av2[2]=t3;
((C_proc)C_fast_retrieve_proc(t4))(3,av2);}}

/* a4874 in a4868 in a4862 in k4853 in chicken.posix#call-with-exec-args in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4875(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_4875,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4879,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:795: free-c-string-buffer */
f_4765(t2,((C_word*)t0)[4]);}

/* k4877 in a4874 in a4868 in a4862 in k4853 in chicken.posix#call-with-exec-args in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4879(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_4879,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4882,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
if(C_truep(((C_word*)((C_word*)t0)[4])[1])){
/* posix-common.scm:796: free-c-string-buffer */
f_4765(t2,((C_word*)((C_word*)t0)[4])[1]);}
else{
/* posix-common.scm:797: chicken.condition#signal */
t3=*((C_word*)lf[302]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}}

/* k4880 in k4877 in a4874 in a4868 in a4862 in k4853 in chicken.posix#call-with-exec-args in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4882(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_4882,c,av);}
/* posix-common.scm:797: chicken.condition#signal */
t2=*((C_word*)lf[302]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* a4889 in a4862 in k4853 in chicken.posix#call-with-exec-args in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4890(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(14,c,3)))){
C_save_and_reclaim((void *)f_4890,c,av);}
a=C_alloc(14);
t2=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_4896,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word)li79),tmp=(C_word)a,a+=10,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4971,a[2]=((C_word*)t0)[9],a[3]=((C_word)li81),tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:793: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=t2;
av2[3]=t3;
C_call_with_values(4,av2);}}

/* a4895 in a4889 in a4862 in k4853 in chicken.posix#call-with-exec-args in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4896(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(15,c,3)))){
C_save_and_reclaim((void *)f_4896,c,av);}
a=C_alloc(15);
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_4900,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
if(C_truep(((C_word*)t0)[7])){
t3=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_4910,a[2]=((C_word*)t0)[4],a[3]=t2,a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],a[6]=((C_word*)t0)[6],tmp=(C_word)a,a+=7,tmp);
/* posix-common.scm:801: check-environment-list */
f_4799(t3,((C_word*)t0)[7],((C_word*)t0)[6]);}
else{
t3=t2;
f_4900(t3,C_SCHEME_UNDEFINED);}}

/* k4898 in a4895 in a4889 in a4862 in k4853 in chicken.posix#call-with-exec-args in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void f_4900(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_4900,2,t0,t1);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4907,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
/* posix-common.scm:807: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[199]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[199]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[6];
av2[3]=((C_word*)t0)[7];
tp(4,av2);}}

/* k4905 in k4898 in a4895 in a4889 in a4862 in k4853 in chicken.posix#call-with-exec-args in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4907(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_4907,c,av);}
/* posix-common.scm:807: proc */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=t1;
av2[3]=((C_word*)t0)[4];
av2[4]=((C_word*)((C_word*)t0)[5])[1];
((C_proc)C_fast_retrieve_proc(t2))(5,av2);}}

/* k4908 in a4895 in a4889 in a4862 in k4853 in chicken.posix#call-with-exec-args in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4910(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(22,c,3)))){
C_save_and_reclaim((void *)f_4910,c,av);}
a=C_alloc(22);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4914,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=C_a_i_cons(&a,2,C_SCHEME_UNDEFINED,C_SCHEME_END_OF_LIST);
t4=t3;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=((C_word*)t5)[1];
t7=C_i_check_list_2(((C_word*)t0)[4],lf[314]);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_4935,a[2]=t2,a[3]=((C_word*)t0)[5],a[4]=((C_word*)t0)[6],tmp=(C_word)a,a+=5,tmp);
t9=C_SCHEME_UNDEFINED;
t10=(*a=C_VECTOR_TYPE|1,a[1]=t9,tmp=(C_word)a,a+=2,tmp);
t11=C_set_block_item(t10,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4937,a[2]=t5,a[3]=t10,a[4]=t6,a[5]=((C_word)li78),tmp=(C_word)a,a+=6,tmp));
t12=((C_word*)t10)[1];
f_4937(t12,t8,((C_word*)t0)[4]);}

/* k4912 in k4908 in a4895 in a4889 in a4862 in k4853 in chicken.posix#call-with-exec-args in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4914(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_4914,c,av);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,t1);
t3=((C_word*)t0)[3];
f_4900(t3,t2);}

/* k4933 in k4908 in a4895 in a4889 in a4862 in k4853 in chicken.posix#call-with-exec-args in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4935(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_4935,c,av);}
/* posix-common.scm:803: list->c-string-buffer */
f_4648(((C_word*)t0)[2],t1,((C_word*)t0)[3],((C_word*)t0)[4]);}

/* map-loop1271 in k4908 in a4895 in a4889 in a4862 in k4853 in chicken.posix#call-with-exec-args in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void f_4937(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,4)))){
C_save_and_reclaim_args((void *)trf_4937,3,t0,t1,t2);}
a=C_alloc(6);
if(C_truep(C_i_pairp(t2))){
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_4962,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
t4=C_slot(t2,C_fix(0));
/* posix-common.scm:804: scheme#string-append */
t5=*((C_word*)lf[103]+1);{
C_word av2[5];
av2[0]=t5;
av2[1]=t3;
av2[2]=C_i_car(t4);
av2[3]=lf[315];
av2[4]=C_u_i_cdr(t4);
((C_proc)(void*)(*((C_word*)t5+1)))(5,av2);}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_slot(((C_word*)t0)[4],C_fix(1));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k4960 in map-loop1271 in k4908 in a4895 in a4889 in a4862 in k4853 in chicken.posix#call-with-exec-args in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4962(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_4962,c,av);}
a=C_alloc(3);
t2=C_a_i_cons(&a,2,t1,C_SCHEME_END_OF_LIST);
t3=C_i_setslot(((C_word*)((C_word*)t0)[2])[1],C_fix(1),t2);
t4=C_mutate(((C_word *)((C_word*)t0)[2])+1,t2);
t5=((C_word*)((C_word*)t0)[3])[1];
f_4937(t5,((C_word*)t0)[4],C_slot(((C_word*)t0)[5],C_fix(1)));}

/* a4970 in a4889 in a4862 in k4853 in chicken.posix#call-with-exec-args in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4971(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_4971,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_4977,a[2]=t2,a[3]=((C_word)li80),tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:793: k1260 */
t4=((C_word*)t0)[2];{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t1;
av2[2]=t3;
((C_proc)C_fast_retrieve_proc(t4))(3,av2);}}

/* a4976 in a4970 in a4889 in a4862 in k4853 in chicken.posix#call-with-exec-args in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_4977(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_4977,c,av);}{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=0;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
C_apply_values(3,av2);}}

/* check in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void f_5002(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,5)))){
C_save_and_reclaim_args((void *)trf_5002,5,t1,t2,t3,t4,t5);}
a=C_alloc(4);
if(C_truep(C_null_pointerp(t5))){
/* posix-common.scm:819: posix-error */
t6=lf[192];{
C_word av2[6];
av2[0]=t6;
av2[1]=t1;
av2[2]=lf[197];
av2[3]=t2;
av2[4]=lf[316];
av2[5]=t3;
f_3238(6,av2);}}
else{
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5015,a[2]=t5,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t4)){
/* posix-common.scm:820: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[248]+1));
C_word av2[6];
av2[0]=*((C_word*)lf[248]+1);
av2[1]=t6;
av2[2]=C_fix(1);
av2[3]=*((C_word*)lf[249]+1);
av2[4]=lf[317];
av2[5]=lf[239];
tp(6,av2);}}
else{
/* posix-common.scm:820: ##sys#make-port */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[248]+1));
C_word av2[6];
av2[0]=*((C_word*)lf[248]+1);
av2[1]=t6;
av2[2]=C_fix(2);
av2[3]=*((C_word*)lf[249]+1);
av2[4]=lf[317];
av2[5]=lf[239];
tp(6,av2);}}}}

/* k5013 in check in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5015(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_5015,c,av);}
t2=C_set_file_ptr(t1,((C_word*)t0)[2]);
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.process#open-input-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5021(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +10,c,3)))){
C_save_and_reclaim((void*)f_5021,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+10);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t4=C_i_check_string_2(t2,lf[318]);
t5=C_i_pairp(t3);
t6=(C_truep(t5)?C_slot(t3,C_fix(0)):lf[319]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5035,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t8=C_eqp(t6,lf[319]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5042,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:831: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[199]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[199]+1);
av2[1]=t9;
av2[2]=t2;
av2[3]=lf[318];
tp(4,av2);}}
else{
t9=C_eqp(t6,lf[320]);
if(C_truep(t9)){
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5052,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:832: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[199]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[199]+1);
av2[1]=t10;
av2[2]=t2;
av2[3]=lf[318];
tp(4,av2);}}
else{
/* posix-common.scm:816: ##sys#error */
t10=*((C_word*)lf[94]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t10;
av2[1]=t7;
av2[2]=lf[321];
av2[3]=t6;
((C_proc)(void*)(*((C_word*)t10+1)))(4,av2);}}}}

/* k5033 in chicken.process#open-input-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5035(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_5035,c,av);}
/* posix-common.scm:827: check */
f_5002(((C_word*)t0)[3],lf[318],((C_word*)t0)[4],C_SCHEME_TRUE,t1);}

/* k5040 in chicken.process#open-input-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5042(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(2,c,5)))){
C_save_and_reclaim((void *)f_5042,c,av);}
a=C_alloc(2);
t2=open_text_input_pipe(&a,1,t1);
/* posix-common.scm:827: check */
f_5002(((C_word*)t0)[3],lf[318],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* k5050 in chicken.process#open-input-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5052(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(2,c,5)))){
C_save_and_reclaim((void *)f_5052,c,av);}
a=C_alloc(2);
t2=open_binary_input_pipe(&a,1,t1);
/* posix-common.scm:827: check */
f_5002(((C_word*)t0)[3],lf[318],((C_word*)t0)[4],C_SCHEME_TRUE,t2);}

/* chicken.process#open-output-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5061(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +10,c,3)))){
C_save_and_reclaim((void*)f_5061,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+10);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t4=C_i_check_string_2(t2,lf[322]);
t5=C_i_pairp(t3);
t6=(C_truep(t5)?C_slot(t3,C_fix(0)):lf[319]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5075,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
t8=C_eqp(t6,lf[319]);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5082,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:842: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[199]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[199]+1);
av2[1]=t9;
av2[2]=t2;
av2[3]=lf[322];
tp(4,av2);}}
else{
t9=C_eqp(t6,lf[320]);
if(C_truep(t9)){
t10=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5092,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:843: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[199]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[199]+1);
av2[1]=t10;
av2[2]=t2;
av2[3]=lf[322];
tp(4,av2);}}
else{
/* posix-common.scm:816: ##sys#error */
t10=*((C_word*)lf[94]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t10;
av2[1]=t7;
av2[2]=lf[321];
av2[3]=t6;
((C_proc)(void*)(*((C_word*)t10+1)))(4,av2);}}}}

/* k5073 in chicken.process#open-output-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5075(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_5075,c,av);}
/* posix-common.scm:838: check */
f_5002(((C_word*)t0)[3],lf[322],((C_word*)t0)[4],C_SCHEME_FALSE,t1);}

/* k5080 in chicken.process#open-output-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5082(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(2,c,5)))){
C_save_and_reclaim((void *)f_5082,c,av);}
a=C_alloc(2);
t2=open_text_output_pipe(&a,1,t1);
/* posix-common.scm:838: check */
f_5002(((C_word*)t0)[3],lf[322],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* k5090 in chicken.process#open-output-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5092(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(2,c,5)))){
C_save_and_reclaim((void *)f_5092,c,av);}
a=C_alloc(2);
t2=open_binary_output_pipe(&a,1,t1);
/* posix-common.scm:838: check */
f_5002(((C_word*)t0)[3],lf[322],((C_word*)t0)[4],C_SCHEME_FALSE,t2);}

/* chicken.process#close-input-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5101(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,5)))){
C_save_and_reclaim((void *)f_5101,c,av);}
a=C_alloc(4);
t3=C_i_check_port_2(t2,C_fix(1),C_SCHEME_TRUE,lf[323]);
t4=close_pipe(t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5108,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t6=C_eqp(C_fix(-1),t4);
if(C_truep(t6)){
/* posix-common.scm:850: posix-error */
t7=lf[192];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t7;
av2[1]=t5;
av2[2]=lf[197];
av2[3]=lf[323];
av2[4]=lf[324];
av2[5]=t2;
f_3238(6,av2);}}
else{
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* k5106 in chicken.process#close-input-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5108(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_5108,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.process#close-output-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5116(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,5)))){
C_save_and_reclaim((void *)f_5116,c,av);}
a=C_alloc(4);
t3=C_i_check_port_2(t2,C_fix(2),C_SCHEME_TRUE,lf[325]);
t4=close_pipe(t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5123,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t6=C_eqp(C_fix(-1),t4);
if(C_truep(t6)){
/* posix-common.scm:857: posix-error */
t7=lf[192];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t7;
av2[1]=t5;
av2[2]=lf[197];
av2[3]=lf[325];
av2[4]=lf[326];
av2[5]=t2;
f_3238(6,av2);}}
else{
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* k5121 in chicken.process#close-output-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5123(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_5123,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.process#with-input-from-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5131(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,4)))){
C_save_and_reclaim((void*)f_5131,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5135,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t5;
av2[2]=*((C_word*)lf[117]+1);
av2[3]=t2;
av2[4]=t4;
C_apply(5,av2);}}

/* k5133 in chicken.process#with-input-from-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5135(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(19,c,4)))){
C_save_and_reclaim((void *)f_5135,c,av);}
a=C_alloc(19);
t2=t1;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_FALSE;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5140,a[2]=t5,a[3]=t3,a[4]=((C_word)li90),tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5145,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word)li92),tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5160,a[2]=t3,a[3]=t5,a[4]=((C_word)li93),tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:863: ##sys#dynamic-wind */
t9=*((C_word*)lf[329]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t9;
av2[1]=((C_word*)t0)[3];
av2[2]=t6;
av2[3]=t7;
av2[4]=t8;
((C_proc)(void*)(*((C_word*)t9+1)))(5,av2);}}

/* a5139 in k5133 in chicken.process#with-input-from-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5140(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_5140,c,av);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[327]+1));
t3=C_mutate((C_word*)lf[327]+1 /* (set! ##sys#standard-input ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* a5144 in k5133 in chicken.process#with-input-from-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5145(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_5145,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5151,a[2]=((C_word*)t0)[2],a[3]=((C_word)li91),tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:864: scheme#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
av2[3]=t2;
C_call_with_values(4,av2);}}

/* a5150 in a5144 in k5133 in chicken.process#with-input-from-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5151(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_5151,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5155,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:866: chicken.process#close-input-pipe */
t4=*((C_word*)lf[114]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k5153 in a5150 in a5144 in k5133 in chicken.process#with-input-from-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5155(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_5155,c,av);}{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=*((C_word*)lf[328]+1);
av2[3]=((C_word*)t0)[3];
C_apply(4,av2);}}

/* a5159 in k5133 in chicken.process#with-input-from-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5160(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_5160,c,av);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[327]+1));
t3=C_mutate((C_word*)lf[327]+1 /* (set! ##sys#standard-input ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* chicken.process#call-with-output-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5165(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,4)))){
C_save_and_reclaim((void*)f_5165,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5169,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t5;
av2[2]=*((C_word*)lf[118]+1);
av2[3]=t2;
av2[4]=t4;
C_apply(5,av2);}}

/* k5167 in chicken.process#call-with-output-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5169(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_5169,c,av);}
a=C_alloc(9);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5174,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word)li95),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5180,a[2]=t1,a[3]=((C_word)li96),tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:872: scheme#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
av2[3]=t3;
C_call_with_values(4,av2);}}

/* a5173 in k5167 in chicken.process#call-with-output-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5174(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_5174,c,av);}
/* posix-common.scm:873: proc */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
((C_proc)C_fast_retrieve_proc(t2))(3,av2);}}

/* a5179 in k5167 in chicken.process#call-with-output-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5180(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_5180,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5184,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:875: chicken.process#close-output-pipe */
t4=*((C_word*)lf[115]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k5182 in a5179 in k5167 in chicken.process#call-with-output-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5184(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_5184,c,av);}{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=*((C_word*)lf[328]+1);
av2[3]=((C_word*)t0)[3];
C_apply(4,av2);}}

/* chicken.process#call-with-input-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5189(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,4)))){
C_save_and_reclaim((void*)f_5189,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5193,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t5;
av2[2]=*((C_word*)lf[117]+1);
av2[3]=t2;
av2[4]=t4;
C_apply(5,av2);}}

/* k5191 in chicken.process#call-with-input-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5193(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_5193,c,av);}
a=C_alloc(9);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5198,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word)li98),tmp=(C_word)a,a+=5,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5204,a[2]=t1,a[3]=((C_word)li99),tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:881: scheme#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
av2[3]=t3;
C_call_with_values(4,av2);}}

/* a5197 in k5191 in chicken.process#call-with-input-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5198(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_5198,c,av);}
/* posix-common.scm:882: proc */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
((C_proc)C_fast_retrieve_proc(t2))(3,av2);}}

/* a5203 in k5191 in chicken.process#call-with-input-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5204(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_5204,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5208,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:884: chicken.process#close-input-pipe */
t4=*((C_word*)lf[114]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k5206 in a5203 in k5191 in chicken.process#call-with-input-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5208(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_5208,c,av);}{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=*((C_word*)lf[328]+1);
av2[3]=((C_word*)t0)[3];
C_apply(4,av2);}}

/* chicken.process#with-output-to-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5213(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +4,c,4)))){
C_save_and_reclaim((void*)f_5213,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+4);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5217,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t5;
av2[2]=*((C_word*)lf[118]+1);
av2[3]=t2;
av2[4]=t4;
C_apply(5,av2);}}

/* k5215 in chicken.process#with-output-to-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5217(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(19,c,4)))){
C_save_and_reclaim((void *)f_5217,c,av);}
a=C_alloc(19);
t2=t1;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_FALSE;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5222,a[2]=t5,a[3]=t3,a[4]=((C_word)li101),tmp=(C_word)a,a+=5,tmp);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5227,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word)li103),tmp=(C_word)a,a+=5,tmp);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5242,a[2]=t3,a[3]=t5,a[4]=((C_word)li104),tmp=(C_word)a,a+=5,tmp);
/* posix-common.scm:890: ##sys#dynamic-wind */
t9=*((C_word*)lf[329]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t9;
av2[1]=((C_word*)t0)[3];
av2[2]=t6;
av2[3]=t7;
av2[4]=t8;
((C_proc)(void*)(*((C_word*)t9+1)))(5,av2);}}

/* a5221 in k5215 in chicken.process#with-output-to-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5222(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_5222,c,av);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[330]+1));
t3=C_mutate((C_word*)lf[330]+1 /* (set! ##sys#standard-output ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* a5226 in k5215 in chicken.process#with-output-to-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5227(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_5227,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5233,a[2]=((C_word*)t0)[2],a[3]=((C_word)li102),tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:891: scheme#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
av2[3]=t2;
C_call_with_values(4,av2);}}

/* a5232 in a5226 in k5215 in chicken.process#with-output-to-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5233(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand((c-2)*C_SIZEOF_PAIR +4,c,2)))){
C_save_and_reclaim((void*)f_5233,c,av);}
a=C_alloc((c-2)*C_SIZEOF_PAIR+4);
t2=C_build_rest(&a,c,2,av);
C_word t3;
C_word t4;
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5237,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:893: chicken.process#close-output-pipe */
t4=*((C_word*)lf[115]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k5235 in a5232 in a5226 in k5215 in chicken.process#with-output-to-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5237(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_5237,c,av);}{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=*((C_word*)lf[328]+1);
av2[3]=((C_word*)t0)[3];
C_apply(4,av2);}}

/* a5241 in k5215 in chicken.process#with-output-to-pipe in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5242(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_5242,c,av);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,*((C_word*)lf[330]+1));
t3=C_mutate((C_word*)lf[330]+1 /* (set! ##sys#standard-output ...) */,((C_word*)((C_word*)t0)[3])[1]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* ##sys#file-nonblocking! in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5247(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_5247,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=stub1487(C_SCHEME_UNDEFINED,C_i_foreign_fixnum_argumentp(t2));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#file-select-one in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5254(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_5254,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=stub1492(C_SCHEME_UNDEFINED,C_i_foreign_fixnum_argumentp(t2));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.file.posix#file-control in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_5294(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_5294,c,av);}
t4=C_rest_nullp(c,4);
t5=(C_truep(t4)?C_fix(0):C_get_rest_arg(c,4,av,4,t0));
t6=C_i_check_fixnum_2(t2,lf[333]);
t7=C_i_check_fixnum_2(t3,lf[333]);
t8=C_i_foreign_fixnum_argumentp(t2);
t9=C_i_foreign_fixnum_argumentp(t3);
t10=C_fix((C_word)sizeof(long) * CHAR_BIT);
t11=C_i_foreign_ranged_integer_argumentp(t5,t10);
t12=stub1499(C_SCHEME_UNDEFINED,t8,t9,t11);
t13=C_eqp(t12,C_fix(-1));
if(C_truep(t13)){
/* posixunix.scm:346: posix-error */
t14=lf[192];{
C_word av2[7];
av2[0]=t14;
av2[1]=t1;
av2[2]=lf[197];
av2[3]=lf[333];
av2[4]=lf[334];
av2[5]=t2;
av2[6]=t3;
f_3238(7,av2);}}
else{
t14=t1;{
C_word *av2=av;
av2[0]=t14;
av2[1]=t12;
((C_proc)(void*)(*((C_word*)t14+1)))(2,av2);}}}

/* chicken.file.posix#file-open */
static void C_ccall f_5327(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +6,c,3)))){
C_save_and_reclaim((void*)f_5327,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+6);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
t5=C_i_pairp(t4);
t6=(C_truep(t5)?C_get_rest_arg(c,4,av,4,t0):((C_word*)t0)[2]);
t7=C_i_check_string_2(t2,lf[335]);
t8=C_i_check_fixnum_2(t3,lf[335]);
t9=C_i_check_fixnum_2(t6,lf[335]);
t10=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5344,a[2]=t3,a[3]=t6,a[4]=t1,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:356: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[199]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[199]+1);
av2[1]=t10;
av2[2]=t2;
av2[3]=lf[335];
tp(4,av2);}}

/* k5342 in chicken.file.posix#file-open */
static void C_ccall f_5344(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,7)))){
C_save_and_reclaim((void *)f_5344,c,av);}
a=C_alloc(4);
t2=C_open(t1,((C_word*)t0)[2],((C_word*)t0)[3]);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5347,a[2]=((C_word*)t0)[4],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=C_eqp(C_fix(-1),t2);
if(C_truep(t4)){
/* posixunix.scm:358: posix-error */
t5=lf[192];{
C_word *av2;
if(c >= 8) {
  av2=av;
} else {
  av2=C_alloc(8);
}
av2[0]=t5;
av2[1]=t3;
av2[2]=lf[197];
av2[3]=lf[335];
av2[4]=lf[336];
av2[5]=((C_word*)t0)[5];
av2[6]=((C_word*)t0)[2];
av2[7]=((C_word*)t0)[3];
f_3238(8,av2);}}
else{
t5=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t5;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k5345 in k5342 in chicken.file.posix#file-open */
static void C_ccall f_5347(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_5347,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.file.posix#file-close */
static void C_ccall f_5359(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_5359,c,av);}
a=C_alloc(7);
t3=C_i_check_fixnum_2(t2,lf[337]);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_set_block_item(t5,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5368,a[2]=t2,a[3]=t5,a[4]=((C_word)li110),tmp=(C_word)a,a+=5,tmp));
t7=((C_word*)t5)[1];{
C_word *av2=av;
av2[0]=t7;
av2[1]=t1;
f_5368(2,av2);}}

/* loop in chicken.file.posix#file-close */
static void C_ccall f_5368(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_5368,c,av);}
if(C_truep(C_fixnum_lessp(C_close(((C_word*)t0)[2]),C_fix(0)))){
t2=C_eqp(C_fix((C_word)errno),C_fix((C_word)EINTR));
if(C_truep(t2)){
/* posixunix.scm:367: ##sys#dispatch-interrupt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[338]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[338]+1);
av2[1]=t1;
av2[2]=((C_word*)((C_word*)t0)[3])[1];
tp(3,av2);}}
else{
/* posixunix.scm:369: posix-error */
t3=lf[192];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=lf[197];
av2[3]=lf[337];
av2[4]=lf[339];
av2[5]=((C_word*)t0)[2];
f_3238(6,av2);}}}
else{
t2=C_SCHEME_UNDEFINED;
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* chicken.file.posix#file-read */
static void C_ccall f_5390(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +6,c,2)))){
C_save_and_reclaim((void*)f_5390,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+6);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
t5=C_i_check_fixnum_2(t2,lf[340]);
t6=C_i_check_fixnum_2(t3,lf[340]);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5400,a[2]=t2,a[3]=C_SCHEME_UNDEFINED,a[4]=t3,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_i_pairp(t4))){
t8=t7;{
C_word av2[2];
av2[0]=t8;
av2[1]=C_get_rest_arg(c,4,av,4,t0);
f_5400(2,av2);}}
else{
/* posixunix.scm:375: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[343]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[343]+1);
av2[1]=t7;
av2[2]=t3;
tp(3,av2);}}}

/* k5398 in chicken.file.posix#file-read */
static void C_ccall f_5400(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_5400,c,av);}
a=C_alloc(3);
t2=C_mutate(((C_word *)t0)+3,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5403,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_byteblockp(((C_word*)t0)[3]))){
t4=t3;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
f_5403(2,av2);}}
else{
/* posixunix.scm:377: ##sys#signal-hook */
t4=*((C_word*)lf[200]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=lf[201];
av2[3]=lf[340];
av2[4]=lf[342];
av2[5]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t4+1)))(6,av2);}}}

/* k5401 in k5398 in chicken.file.posix#file-read */
static void C_ccall f_5403(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,c,6)))){
C_save_and_reclaim((void *)f_5403,c,av);}
a=C_alloc(11);
t2=((C_word*)t0)[2];
t3=C_read(((C_word*)t2)[2],((C_word*)t2)[3],((C_word*)t2)[4]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5406,a[2]=((C_word*)t2)[5],a[3]=((C_word*)t2)[3],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=C_eqp(C_fix(-1),t3);
if(C_truep(t5)){
/* posixunix.scm:380: posix-error */
t6=lf[192];{
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=t6;
av2[1]=t4;
av2[2]=lf[197];
av2[3]=lf[340];
av2[4]=lf[341];
av2[5]=((C_word*)t2)[2];
av2[6]=((C_word*)t2)[4];
f_3238(7,av2);}}
else{
t6=((C_word*)t2)[5];{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_a_i_list2(&a,2,((C_word*)t2)[3],t3);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k5404 in k5401 in k5398 in chicken.file.posix#file-read */
static void C_ccall f_5406(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,1)))){
C_save_and_reclaim((void *)f_5406,c,av);}
a=C_alloc(6);
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_a_i_list2(&a,2,((C_word*)t0)[3],((C_word*)t0)[4]);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.file.posix#file-write */
static void C_ccall f_5427(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +6,c,5)))){
C_save_and_reclaim((void*)f_5427,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+6);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
t5=C_i_check_fixnum_2(t2,lf[344]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5434,a[2]=t4,a[3]=t3,a[4]=t2,a[5]=t1,tmp=(C_word)a,a+=6,tmp);
if(C_truep(C_byteblockp(t3))){
t7=t6;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_SCHEME_UNDEFINED;
f_5434(2,av2);}}
else{
/* posixunix.scm:387: ##sys#signal-hook */
t7=*((C_word*)lf[200]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t7;
av2[1]=t6;
av2[2]=lf[201];
av2[3]=lf[344];
av2[4]=lf[346];
av2[5]=t3;
((C_proc)(void*)(*((C_word*)t7+1)))(6,av2);}}}

/* k5432 in chicken.file.posix#file-write */
static void C_ccall f_5434(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,6)))){
C_save_and_reclaim((void *)f_5434,c,av);}
a=C_alloc(4);
t2=C_i_pairp(((C_word*)t0)[2]);
t3=(C_truep(t2)?C_u_i_car(((C_word*)t0)[2]):C_block_size(((C_word*)t0)[3]));
t4=C_i_check_fixnum_2(t3,lf[344]);
t5=C_write(((C_word*)t0)[4],((C_word*)t0)[3],C_fix(0),t3);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5443,a[2]=((C_word*)t0)[5],a[3]=t5,tmp=(C_word)a,a+=4,tmp);
t7=C_eqp(C_fix(-1),t5);
if(C_truep(t7)){
/* posixunix.scm:392: posix-error */
t8=lf[192];{
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=t8;
av2[1]=t6;
av2[2]=lf[197];
av2[3]=lf[344];
av2[4]=lf[345];
av2[5]=((C_word*)t0)[4];
av2[6]=t3;
f_3238(7,av2);}}
else{
t8=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t8;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}

/* k5441 in k5432 in chicken.file.posix#file-write */
static void C_ccall f_5443(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_5443,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.file.posix#file-mkstemp */
static void C_ccall f_5461(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_5461,c,av);}
a=C_alloc(4);
t3=C_i_check_string_2(t2,lf[347]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5468,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:398: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[199]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[199]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=lf[347];
tp(4,av2);}}

/* k5466 in chicken.file.posix#file-mkstemp */
static void C_ccall f_5468(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,5)))){
C_save_and_reclaim((void *)f_5468,c,av);}
a=C_alloc(6);
t2=C_mkstemp(t1);
t3=C_i_string_length(t1);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5474,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t1,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
t5=C_eqp(C_fix(-1),t2);
if(C_truep(t5)){
/* posixunix.scm:402: posix-error */
t6=lf[192];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t6;
av2[1]=t4;
av2[2]=lf[197];
av2[3]=lf[347];
av2[4]=lf[348];
av2[5]=((C_word*)t0)[3];
f_3238(6,av2);}}
else{
t6=t4;{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_SCHEME_UNDEFINED;
f_5474(2,av2);}}}

/* k5472 in k5466 in chicken.file.posix#file-mkstemp */
static void C_ccall f_5474(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,4)))){
C_save_and_reclaim((void *)f_5474,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5481,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:403: ##sys#substring */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[269]+1));
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[269]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=C_fix(0);
av2[4]=C_fixnum_difference(((C_word*)t0)[5],C_fix(1));
tp(5,av2);}}

/* k5479 in k5472 in k5466 in chicken.file.posix#file-mkstemp */
static void C_ccall f_5481(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_5481,c,av);}
/* posixunix.scm:403: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=t1;
C_values(4,av2);}}

/* chicken.file.posix#file-select */
static void C_ccall f_5493(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c<4) C_bad_min_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-4)*C_SIZEOF_PAIR +13,c,2)))){
C_save_and_reclaim((void*)f_5493,c,av);}
a=C_alloc((c-4)*C_SIZEOF_PAIR+13);
t4=C_build_rest(&a,c,4,av);
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t5=C_i_pairp(t4);
t6=(C_truep(t5)?C_get_rest_arg(c,4,av,4,t0):C_SCHEME_FALSE);
t7=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_5500,a[2]=C_SCHEME_UNDEFINED,a[3]=C_SCHEME_UNDEFINED,a[4]=C_SCHEME_UNDEFINED,a[5]=C_SCHEME_UNDEFINED,a[6]=t1,a[7]=t2,a[8]=t3,a[9]=t6,tmp=(C_word)a,a+=10,tmp);
if(C_truep(C_i_not(t2))){
t8=t7;
f_5500(t8,C_SCHEME_END_OF_LIST);}
else{
if(C_truep(C_fixnump(t2))){
t8=t7;
f_5500(t8,C_a_i_list1(&a,1,t2));}
else{
t8=C_i_check_list_2(t2,lf[349]);
t9=t7;
f_5500(t9,t2);}}}

/* k5498 in chicken.file.posix#file-select */
static void f_5500(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,2)))){
C_save_and_reclaim_args((void *)trf_5500,2,t0,t1);}
a=C_alloc(6);
t2=C_mutate(((C_word *)t0)+2,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5503,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_not(((C_word*)t0)[8]))){
t4=t3;
f_5503(t4,C_SCHEME_END_OF_LIST);}
else{
if(C_truep(C_fixnump(((C_word*)t0)[8]))){
t4=t3;
f_5503(t4,C_a_i_list1(&a,1,((C_word*)t0)[8]));}
else{
t4=C_i_check_list_2(((C_word*)t0)[8],lf[349]);
t5=t3;
f_5503(t5,((C_word*)t0)[8]);}}}

/* k5501 in k5498 in chicken.file.posix#file-select */
static void f_5503(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,0,2)))){
C_save_and_reclaim_args((void *)trf_5503,2,t0,t1);}
a=C_alloc(3);
t2=((C_word*)t0)[2];
t3=C_mutate(((C_word *)t2)+4,t1);
t4=C_u_i_length(((C_word*)t2)[2]);
t5=C_mutate(((C_word *)t2)+3,t4);
t6=C_u_i_length(((C_word*)t2)[4]);
t7=C_fixnum_plus(((C_word*)t2)[3],t6);
t8=C_mutate(((C_word *)t2)+5,t7);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5511,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
t10=C_fix((C_word)sizeof(struct pollfd));
/* posixunix.scm:422: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[343]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[343]+1);
av2[1]=t9;
av2[2]=C_fixnum_times(((C_word*)t2)[5],t10);
tp(3,av2);}}

/* k5509 in k5501 in k5498 in chicken.file.posix#file-select */
static void C_ccall f_5511(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(24,c,3)))){
C_save_and_reclaim((void *)f_5511,c,av);}
a=C_alloc(24);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5791,a[2]=t1,a[3]=((C_word)li115),tmp=(C_word)a,a+=4,tmp);
t4=(
  f_5791(t3,C_fix(0),((C_word*)t2)[2])
);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5749,a[2]=t1,a[3]=((C_word)li116),tmp=(C_word)a,a+=4,tmp);
t6=(
  f_5749(t5,((C_word*)t2)[3],((C_word*)t2)[4])
);
t7=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_5732,a[2]=t1,a[3]=((C_word*)t2)[5],a[4]=((C_word*)t2)[6],a[5]=((C_word*)t2)[7],a[6]=((C_word*)t2)[8],a[7]=((C_word*)t2)[3],a[8]=((C_word*)t2)[4],a[9]=((C_word*)t2)[2],tmp=(C_word)a,a+=10,tmp);
if(C_truep(((C_word*)t2)[9])){
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5739,a[2]=t7,tmp=(C_word)a,a+=3,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5747,a[2]=t8,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:437: scheme#max */
t10=*((C_word*)lf[354]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t10;
av2[1]=t9;
av2[2]=C_fix(0);
av2[3]=((C_word*)t2)[9];
((C_proc)(void*)(*((C_word*)t10+1)))(4,av2);}}
else{
t8=t7;{
C_word *av2=av;
av2[0]=t8;
av2[1]=C_fix(-1);
f_5732(2,av2);}}}

/* k5570 in k5730 in k5509 in k5501 in k5498 in chicken.file.posix#file-select */
static void C_ccall f_5572(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(13,c,5)))){
C_save_and_reclaim((void *)f_5572,c,av);}
a=C_alloc(13);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_5575,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5612,a[2]=((C_word*)t0)[5],a[3]=t4,a[4]=((C_word)li117),tmp=(C_word)a,a+=5,tmp));
t6=((C_word*)t4)[1];
f_5612(t6,t2,((C_word*)t0)[6],C_SCHEME_END_OF_LIST,((C_word*)t0)[7]);}

/* k5573 in k5570 in k5730 in k5509 in k5501 in k5498 in chicken.file.posix#file-select */
static void C_ccall f_5575(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_5575,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5582,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
if(C_truep(((C_word*)t0)[4])){
if(C_truep(C_fixnump(((C_word*)t0)[4]))){
t3=C_i_memq(((C_word*)t0)[4],((C_word*)t0)[5]);
t4=t2;
f_5582(t4,(C_truep(t3)?((C_word*)t0)[4]:C_SCHEME_FALSE));}
else{
t3=t2;
f_5582(t3,((C_word*)t0)[5]);}}
else{
t3=t2;
f_5582(t3,C_SCHEME_FALSE);}}

/* k5580 in k5573 in k5570 in k5730 in k5509 in k5501 in k5498 in chicken.file.posix#file-select */
static void f_5582(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,3)))){
C_save_and_reclaim_args((void *)trf_5582,2,t0,t1);}
if(C_truep(((C_word*)t0)[2])){
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
if(C_truep(C_i_memq(((C_word*)t0)[2],((C_word*)t0)[3]))){
/* posixunix.scm:458: scheme#values */{
C_word av2[4];
av2[0]=0;
av2[1]=((C_word*)t0)[4];
av2[2]=t1;
av2[3]=((C_word*)t0)[2];
C_values(4,av2);}}
else{
/* posixunix.scm:458: scheme#values */{
C_word av2[4];
av2[0]=0;
av2[1]=((C_word*)t0)[4];
av2[2]=t1;
av2[3]=C_SCHEME_FALSE;
C_values(4,av2);}}}
else{
/* posixunix.scm:458: scheme#values */{
C_word av2[4];
av2[0]=0;
av2[1]=((C_word*)t0)[4];
av2[2]=t1;
av2[3]=((C_word*)t0)[3];
C_values(4,av2);}}}
else{
/* posixunix.scm:458: scheme#values */{
C_word av2[4];
av2[0]=0;
av2[1]=((C_word*)t0)[4];
av2[2]=t1;
av2[3]=C_SCHEME_FALSE;
C_values(4,av2);}}}

/* lp in k5570 in k5730 in k5509 in k5501 in k5498 in chicken.file.posix#file-select */
static void f_5612(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(3,0,4)))){
C_save_and_reclaim_args((void *)trf_5612,5,t0,t1,t2,t3,t4);}
a=C_alloc(3);
if(C_truep(C_i_nullp(t4))){
/* posixunix.scm:451: ##sys#fast-reverse */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[351]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[351]+1);
av2[1]=t1;
av2[2]=t3;
tp(3,av2);}}
else{
t5=C_i_foreign_fixnum_argumentp(t2);
t6=(C_truep(((C_word*)t0)[2])?stub1669(C_SCHEME_UNDEFINED,t5,C_i_foreign_block_argumentp(((C_word*)t0)[2])):stub1669(C_SCHEME_UNDEFINED,t5,C_SCHEME_FALSE));
if(C_truep(t6)){
t7=C_fixnum_plus(t2,C_fix(1));
t8=C_i_car(t4);
t9=C_a_i_cons(&a,2,t8,t3);
/* posixunix.scm:456: lp */
t11=t1;
t12=t7;
t13=t9;
t14=C_u_i_cdr(t4);
t1=t11;
t2=t12;
t3=t13;
t4=t14;
goto loop;}
else{
/* posixunix.scm:457: lp */
t11=t1;
t12=C_fixnum_plus(t2,C_fix(1));
t13=t3;
t14=C_i_cdr(t4);
t1=t11;
t2=t12;
t3=t13;
t4=t14;
goto loop;}}}

/* lp in k5730 in k5509 in k5501 in k5498 in chicken.file.posix#file-select */
static void f_5671(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(3,0,4)))){
C_save_and_reclaim_args((void *)trf_5671,5,t0,t1,t2,t3,t4);}
a=C_alloc(3);
if(C_truep(C_i_nullp(t4))){
/* posixunix.scm:443: ##sys#fast-reverse */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[351]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[351]+1);
av2[1]=t1;
av2[2]=t3;
tp(3,av2);}}
else{
t5=C_i_foreign_fixnum_argumentp(t2);
t6=(C_truep(((C_word*)t0)[2])?stub1650(C_SCHEME_UNDEFINED,t5,C_i_foreign_block_argumentp(((C_word*)t0)[2])):stub1650(C_SCHEME_UNDEFINED,t5,C_SCHEME_FALSE));
if(C_truep(t6)){
t7=C_fixnum_plus(t2,C_fix(1));
t8=C_i_car(t4);
t9=C_a_i_cons(&a,2,t8,t3);
/* posixunix.scm:448: lp */
t11=t1;
t12=t7;
t13=t9;
t14=C_u_i_cdr(t4);
t1=t11;
t2=t12;
t3=t13;
t4=t14;
goto loop;}
else{
/* posixunix.scm:449: lp */
t11=t1;
t12=C_fixnum_plus(t2,C_fix(1));
t13=t3;
t14=C_i_cdr(t4);
t1=t11;
t2=t12;
t3=t13;
t4=t14;
goto loop;}}}

/* k5730 in k5509 in k5501 in k5498 in chicken.file.posix#file-select */
static void C_ccall f_5732(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(15,c,6)))){
C_save_and_reclaim((void *)f_5732,c,av);}
a=C_alloc(15);
t2=(C_truep(((C_word*)t0)[2])?C_i_foreign_block_argumentp(((C_word*)t0)[2]):C_SCHEME_FALSE);
t3=C_i_foreign_fixnum_argumentp(((C_word*)t0)[3]);
t4=C_i_foreign_fixnum_argumentp(t1);
t5=stub1625(C_SCHEME_UNDEFINED,t2,t3,t4);
if(C_truep(C_fixnum_lessp(t5,C_fix(0)))){
/* posixunix.scm:439: posix-error */
t6=lf[192];{
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=t6;
av2[1]=((C_word*)t0)[4];
av2[2]=lf[197];
av2[3]=lf[349];
av2[4]=lf[350];
av2[5]=((C_word*)t0)[5];
av2[6]=((C_word*)t0)[6];
f_3238(7,av2);}}
else{
t6=C_eqp(t5,C_fix(0));
if(C_truep(t6)){
t7=C_i_pairp(((C_word*)t0)[5]);
t8=(C_truep(t7)?C_SCHEME_END_OF_LIST:C_SCHEME_FALSE);
if(C_truep(C_i_pairp(((C_word*)t0)[6]))){
/* posixunix.scm:440: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[4];
av2[2]=t8;
av2[3]=C_SCHEME_END_OF_LIST;
C_values(4,av2);}}
else{
/* posixunix.scm:440: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[4];
av2[2]=t8;
av2[3]=C_SCHEME_FALSE;
C_values(4,av2);}}}
else{
t7=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_5572,a[2]=((C_word*)t0)[6],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[2],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],tmp=(C_word)a,a+=8,tmp);
t8=C_SCHEME_UNDEFINED;
t9=(*a=C_VECTOR_TYPE|1,a[1]=t8,tmp=(C_word)a,a+=2,tmp);
t10=C_set_block_item(t9,0,(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_5671,a[2]=((C_word*)t0)[2],a[3]=t9,a[4]=((C_word)li118),tmp=(C_word)a,a+=5,tmp));
t11=((C_word*)t9)[1];
f_5671(t11,t7,C_fix(0),C_SCHEME_END_OF_LIST,((C_word*)t0)[9]);}}}

/* k5737 in k5509 in k5501 in k5498 in chicken.file.posix#file-select */
static void C_ccall f_5739(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_5739,c,av);}
/* posixunix.scm:437: scheme#inexact->exact */
t2=*((C_word*)lf[352]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* k5745 in k5509 in k5501 in k5498 in chicken.file.posix#file-select */
static void C_ccall f_5747(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(33,c,2)))){
C_save_and_reclaim((void *)f_5747,c,av);}
a=C_alloc(33);
t2=C_s_a_i_times(&a,2,t1,C_fix(1000));
/* posixunix.scm:437: scheme#truncate */
t3=*((C_word*)lf[353]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[2];
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}

/* doloop1584 in k5509 in k5501 in k5498 in chicken.file.posix#file-select */
static C_word f_5749(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t2))){
t3=C_SCHEME_UNDEFINED;
return(t3);}
else{
t3=C_i_car(t2);
t4=C_i_foreign_fixnum_argumentp(t1);
t5=C_i_foreign_fixnum_argumentp(t3);
t6=(C_truep(((C_word*)t0)[2])?stub1610(C_SCHEME_UNDEFINED,t4,t5,C_i_foreign_block_argumentp(((C_word*)t0)[2])):stub1610(C_SCHEME_UNDEFINED,t4,t5,C_SCHEME_FALSE));
t8=C_fixnum_plus(t1,C_fix(1));
t9=C_u_i_cdr(t2);
t1=t8;
t2=t9;
goto loop;}}

/* doloop1583 in k5509 in k5501 in k5498 in chicken.file.posix#file-select */
static C_word f_5791(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_nullp(t2))){
t3=C_SCHEME_UNDEFINED;
return(t3);}
else{
t3=C_i_car(t2);
t4=C_i_foreign_fixnum_argumentp(t1);
t5=C_i_foreign_fixnum_argumentp(t3);
t6=(C_truep(((C_word*)t0)[2])?stub1593(C_SCHEME_UNDEFINED,t4,t5,C_i_foreign_block_argumentp(((C_word*)t0)[2])):stub1593(C_SCHEME_UNDEFINED,t4,t5,C_SCHEME_FALSE));
t8=C_fixnum_plus(t1,C_fix(1));
t9=C_u_i_cdr(t2);
t1=t8;
t2=t9;
goto loop;}}

/* chicken.process#create-pipe */
static void C_ccall f_5872(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_5872,c,av);}
a=C_alloc(3);
t2=C_rest_nullp(c,2);
t3=(C_truep(t2)?C_SCHEME_FALSE:C_get_rest_arg(c,2,av,2,t0));
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5879,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_fixnum_lessp(C_pipe(C_SCHEME_FALSE),C_fix(0)))){
/* posixunix.scm:471: posix-error */
t5=lf[192];{
C_word av2[5];
av2[0]=t5;
av2[1]=t4;
av2[2]=lf[197];
av2[3]=lf[355];
av2[4]=lf[356];
f_3238(5,av2);}}
else{
/* posixunix.scm:472: scheme#values */{
C_word av2[4];
av2[0]=0;
av2[1]=t1;
av2[2]=C_fix((C_word)C_pipefds[ 0 ]);
av2[3]=C_fix((C_word)C_pipefds[ 1 ]);
C_values(4,av2);}}}

/* k5877 in chicken.process#create-pipe */
static void C_ccall f_5879(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_5879,c,av);}
/* posixunix.scm:472: scheme#values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=C_fix((C_word)C_pipefds[ 0 ]);
av2[3]=C_fix((C_word)C_pipefds[ 1 ]);
C_values(4,av2);}}

/* chicken.process.signal#set-signal-mask! */
static void C_ccall f_5928(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,4)))){
C_save_and_reclaim((void *)f_5928,c,av);}
a=C_alloc(3);
t3=C_i_check_list_2(t2,lf[357]);
t4=C_sigemptyset(C_fix(0));
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5952,a[2]=((C_word)li121),tmp=(C_word)a,a+=3,tmp);
t6=(
  f_5952(t2)
);
if(C_truep(C_fixnum_lessp(C_sigprocmask_set(C_fix(0)),C_fix(0)))){
/* posixunix.scm:572: posix-error */
t7=lf[192];{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t7;
av2[1]=t1;
av2[2]=lf[90];
av2[3]=lf[357];
av2[4]=lf[358];
f_3238(5,av2);}}
else{
t7=C_SCHEME_UNDEFINED;
t8=t1;{
C_word *av2=av;
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}

/* for-each-loop1696 in chicken.process.signal#set-signal-mask! */
static C_word f_5952(C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_pairp(t1))){
t2=C_slot(t1,C_fix(0));
t3=C_i_check_fixnum_2(t2,lf[357]);
t4=C_sigaddset(t2);
t6=C_slot(t1,C_fix(1));
t1=t6;
goto loop;}
else{
t2=C_SCHEME_UNDEFINED;
return(t2);}}

/* k5975 */
static void C_ccall f_5977(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(18,c,4)))){
C_save_and_reclaim((void *)f_5977,c,av);}
a=C_alloc(18);
t2=C_mutate((C_word*)lf[145]+1 /* (set! chicken.process.signal#signal-mask ...) */,t1);
t3=C_mutate((C_word*)lf[147]+1 /* (set! chicken.process.signal#signal-masked? ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5979,a[2]=((C_word)li123),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[146]+1 /* (set! chicken.process.signal#signal-mask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5985,a[2]=((C_word)li124),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[148]+1 /* (set! chicken.process.signal#signal-unmask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6001,a[2]=((C_word)li125),tmp=(C_word)a,a+=3,tmp));
t6=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6019,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8510,a[2]=((C_word)li221),tmp=(C_word)a,a+=3,tmp);
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8513,a[2]=((C_word)li222),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:613: chicken.base#getter-with-setter */
t9=*((C_word*)lf[495]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t9;
av2[1]=t6;
av2[2]=t7;
av2[3]=t8;
av2[4]=lf[512];
((C_proc)(void*)(*((C_word*)t9+1)))(5,av2);}}

/* chicken.process.signal#signal-masked? in k5975 */
static void C_ccall f_5979(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_5979,c,av);}
t3=C_i_check_fixnum_2(t2,lf[359]);
t4=C_sigprocmask_get(C_fix(0));
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_sigismember(t2);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* chicken.process.signal#signal-mask! in k5975 */
static void C_ccall f_5985(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_5985,c,av);}
t3=C_i_check_fixnum_2(t2,lf[360]);
t4=C_sigemptyset(C_fix(0));
t5=C_sigaddset(t2);
if(C_truep(C_fixnum_lessp(C_sigprocmask_block(C_fix(0)),C_fix(0)))){
/* posixunix.scm:599: posix-error */
t6=lf[192];{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t6;
av2[1]=t1;
av2[2]=lf[90];
av2[3]=lf[360];
av2[4]=lf[361];
f_3238(5,av2);}}
else{
t6=C_SCHEME_UNDEFINED;
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* chicken.process.signal#signal-unmask! in k5975 */
static void C_ccall f_6001(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_6001,c,av);}
t3=C_i_check_fixnum_2(t2,lf[362]);
t4=C_sigemptyset(C_fix(0));
t5=C_sigaddset(t2);
if(C_truep(C_fixnum_lessp(C_sigprocmask_unblock(C_fix(0)),C_fix(0)))){
/* posixunix.scm:607: posix-error */
t6=lf[192];{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t6;
av2[1]=t1;
av2[2]=lf[90];
av2[3]=lf[362];
av2[4]=lf[363];
f_3238(5,av2);}}
else{
t6=C_SCHEME_UNDEFINED;
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* k6017 in k5975 */
static void C_ccall f_6019(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,4)))){
C_save_and_reclaim((void *)f_6019,c,av);}
a=C_alloc(9);
t2=C_mutate((C_word*)lf[183]+1 /* (set! chicken.process-context.posix#current-user-id ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6023,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8487,a[2]=((C_word)li219),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8490,a[2]=((C_word)li220),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:623: chicken.base#getter-with-setter */
t6=*((C_word*)lf[495]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t6;
av2[1]=t3;
av2[2]=t4;
av2[3]=t5;
av2[4]=lf[508];
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}

/* k6021 in k6017 in k5975 */
static void C_ccall f_6023(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,4)))){
C_save_and_reclaim((void *)f_6023,c,av);}
a=C_alloc(9);
t2=C_mutate((C_word*)lf[181]+1 /* (set! chicken.process-context.posix#current-effective-user-id ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6027,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8464,a[2]=((C_word)li217),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8467,a[2]=((C_word)li218),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:634: chicken.base#getter-with-setter */
t6=*((C_word*)lf[495]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t6;
av2[1]=t3;
av2[2]=t4;
av2[3]=t5;
av2[4]=lf[504];
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}

/* k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6027(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,4)))){
C_save_and_reclaim((void *)f_6027,c,av);}
a=C_alloc(9);
t2=C_mutate((C_word*)lf[182]+1 /* (set! chicken.process-context.posix#current-group-id ...) */,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6031,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8441,a[2]=((C_word)li215),tmp=(C_word)a,a+=3,tmp);
t5=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8444,a[2]=((C_word)li216),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:644: chicken.base#getter-with-setter */
t6=*((C_word*)lf[495]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t6;
av2[1]=t3;
av2[2]=t4;
av2[3]=t5;
av2[4]=lf[500];
((C_proc)(void*)(*((C_word*)t6+1)))(5,av2);}}

/* k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6031(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(24,c,6)))){
C_save_and_reclaim((void *)f_6031,c,av);}
a=C_alloc(24);
t2=C_mutate((C_word*)lf[180]+1 /* (set! chicken.process-context.posix#current-effective-group-id ...) */,t1);
t3=C_mutate((C_word*)lf[190]+1 /* (set! chicken.process-context.posix#user-information ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6033,a[2]=((C_word)li126),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[186]+1 /* (set! chicken.process-context.posix#current-user-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6087,a[2]=((C_word)li127),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[187]+1 /* (set! chicken.process-context.posix#current-effective-user-name ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6101,a[2]=((C_word)li128),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate(&lf[225] /* (set! chicken.posix#chown ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6115,a[2]=((C_word)li129),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[188]+1 /* (set! chicken.process-context.posix#create-session ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6162,a[2]=((C_word)li130),tmp=(C_word)a,a+=3,tmp));
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6180,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t9=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8399,a[2]=((C_word)li213),tmp=(C_word)a,a+=3,tmp);
t10=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8418,a[2]=((C_word)li214),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:716: chicken.base#getter-with-setter */
t11=*((C_word*)lf[495]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t11;
av2[1]=t8;
av2[2]=t9;
av2[3]=t10;
av2[4]=lf[496];
((C_proc)(void*)(*((C_word*)t11+1)))(5,av2);}}

/* chicken.process-context.posix#user-information in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6033(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,3)))){
C_save_and_reclaim((void *)f_6033,c,av);}
a=C_alloc(7);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_get_rest_arg(c,3,av,3,t0));
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6040,a[2]=t4,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnump(t2))){
t6=t5;
f_6040(t6,C_getpwuid(t2));}
else{
t6=C_i_check_string_2(t2,lf[367]);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6079,a[2]=t5,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:668: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[199]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[199]+1);
av2[1]=t7;
av2[2]=t2;
av2[3]=lf[367];
tp(4,av2);}}}

/* k6038 in chicken.process-context.posix#user-information in k6029 in k6025 in k6021 in k6017 in k5975 */
static void f_6040(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(11,0,3)))){
C_save_and_reclaim_args((void *)trf_6040,2,t0,t1);}
a=C_alloc(11);
if(C_truep(t1)){
t2=(C_truep(((C_word*)t0)[2])?*((C_word*)lf[364]+1):*((C_word*)lf[365]+1));
t3=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6053,a[2]=t2,a[3]=((C_word*)t0)[3],a[4]=C_SCHEME_UNDEFINED,a[5]=C_SCHEME_UNDEFINED,a[6]=C_SCHEME_UNDEFINED,a[7]=C_SCHEME_UNDEFINED,tmp=(C_word)a,a+=8,tmp);
/* ##sys#peek-nonnull-c-string */
t4=*((C_word*)lf[366]+1);{
C_word av2[4];
av2[0]=t4;
av2[1]=t3;
av2[2]=C_mpointer(&a,(void*)C_user->pw_name);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}
else{
t2=((C_word*)t0)[3];{
C_word av2[2];
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* k6051 in k6038 in chicken.process-context.posix#user-information in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6053(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_6053,c,av);}
a=C_alloc(6);
t2=C_mutate(((C_word *)t0)+4,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6057,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-nonnull-c-string */
t4=*((C_word*)lf[366]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=C_mpointer(&a,(void*)C_user->pw_passwd);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}

/* k6055 in k6051 in k6038 in chicken.process-context.posix#user-information in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6057(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_6057,c,av);}
a=C_alloc(6);
t2=((C_word*)t0)[2];
t3=C_mutate(((C_word *)t2)+5,t1);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6061,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-nonnull-c-string */
t5=*((C_word*)lf[366]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=C_mpointer(&a,(void*)C_PW_GECOS);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k6059 in k6055 in k6051 in k6038 in chicken.process-context.posix#user-information in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6061(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_6061,c,av);}
a=C_alloc(6);
t2=((C_word*)t0)[2];
t3=C_mutate(((C_word *)t2)+6,t1);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6065,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-c-string */
t5=*((C_word*)lf[194]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=C_mpointer(&a,(void*)C_user->pw_dir);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k6063 in k6059 in k6055 in k6051 in k6038 in chicken.process-context.posix#user-information in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6065(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_6065,c,av);}
a=C_alloc(6);
t2=((C_word*)t0)[2];
t3=C_mutate(((C_word *)t2)+7,t1);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6069,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* ##sys#peek-c-string */
t5=*((C_word*)lf[194]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=C_mpointer(&a,(void*)C_user->pw_shell);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}

/* k6067 in k6063 in k6059 in k6055 in k6051 in k6038 in chicken.process-context.posix#user-information in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6069(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,8)))){
C_save_and_reclaim((void *)f_6069,c,av);}
t2=((C_word*)t0)[2];
/* posixunix.scm:669: g1764 */
t3=((C_word*)t2)[2];{
C_word *av2;
if(c >= 9) {
  av2=av;
} else {
  av2=C_alloc(9);
}
av2[0]=t3;
av2[1]=((C_word*)t2)[3];
av2[2]=((C_word*)t2)[4];
av2[3]=((C_word*)t2)[5];
av2[4]=C_fix((C_word)C_user->pw_uid);
av2[5]=C_fix((C_word)C_user->pw_gid);
av2[6]=((C_word*)t2)[6];
av2[7]=((C_word*)t2)[7];
av2[8]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(9,av2);}}

/* k6077 in chicken.process-context.posix#user-information in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6079(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6079,c,av);}
t2=((C_word*)t0)[2];
f_6040(t2,C_getpwnam(t1));}

/* chicken.process-context.posix#current-user-name in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6087(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_6087,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6095,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6099,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:682: chicken.process-context.posix#current-user-id */
t4=*((C_word*)lf[183]+1);{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k6093 in chicken.process-context.posix#current-user-name in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6095(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6095,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_i_car(t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k6097 in chicken.process-context.posix#current-user-name in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6099(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_6099,c,av);}
/* posixunix.scm:681: chicken.process-context.posix#user-information */
t2=*((C_word*)lf[190]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* chicken.process-context.posix#current-effective-user-name in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6101(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_6101,c,av);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6109,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6113,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:687: chicken.process-context.posix#current-effective-user-id */
t4=*((C_word*)lf[181]+1);{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k6107 in chicken.process-context.posix#current-effective-user-name in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6109(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6109,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_i_car(t1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k6111 in chicken.process-context.posix#current-effective-user-name in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6113(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_6113,c,av);}
/* posixunix.scm:686: chicken.process-context.posix#user-information */
t2=*((C_word*)lf[190]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* chicken.posix#chown in k6029 in k6025 in k6021 in k6017 in k5975 */
static void f_6115(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5){
C_word tmp;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(14,0,2)))){
C_save_and_reclaim_args((void *)trf_6115,5,t1,t2,t3,t4,t5);}
a=C_alloc(14);
t6=C_i_check_fixnum_2(t4,t2);
t7=C_i_check_fixnum_2(t5,t2);
t8=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6125,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t4,a[6]=t5,tmp=(C_word)a,a+=7,tmp);
t9=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6137,a[2]=t8,a[3]=t4,a[4]=t5,a[5]=t3,a[6]=t2,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:694: scheme#port? */
t10=*((C_word*)lf[203]+1);{
C_word av2[3];
av2[0]=t10;
av2[1]=t9;
av2[2]=t3;
((C_proc)(void*)(*((C_word*)t10+1)))(3,av2);}}

/* k6123 in chicken.posix#chown in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6125(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,7)))){
C_save_and_reclaim((void *)f_6125,c,av);}
if(C_truep(C_fixnum_lessp(t1,C_fix(0)))){
/* posixunix.scm:705: posix-error */
t2=lf[192];{
C_word *av2;
if(c >= 8) {
  av2=av;
} else {
  av2=C_alloc(8);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[197];
av2[3]=((C_word*)t0)[3];
av2[4]=lf[368];
av2[5]=((C_word*)t0)[4];
av2[6]=((C_word*)t0)[5];
av2[7]=((C_word*)t0)[6];
f_3238(8,av2);}}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k6135 in chicken.posix#chown in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6137(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_6137,c,av);}
a=C_alloc(5);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6141,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:695: chicken.file.posix#port->fileno */
t3=*((C_word*)lf[72]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
if(C_truep(C_fixnump(((C_word*)t0)[5]))){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_fchown(((C_word*)t0)[5],((C_word*)t0)[3],((C_word*)t0)[4]);
f_6125(2,av2);}}
else{
if(C_truep(C_i_stringp(((C_word*)t0)[5]))){
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6157,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:700: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[199]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[199]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[5];
av2[3]=((C_word*)t0)[6];
tp(4,av2);}}
else{
/* posixunix.scm:701: ##sys#signal-hook */
t2=*((C_word*)lf[200]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[201];
av2[3]=((C_word*)t0)[6];
av2[4]=lf[369];
av2[5]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}}}

/* k6139 in k6135 in chicken.posix#chown in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6141(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6141,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_fchown(t1,((C_word*)t0)[3],((C_word*)t0)[4]);
f_6125(2,av2);}}

/* k6155 in k6135 in chicken.posix#chown in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6157(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6157,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_chown(t1,((C_word*)t0)[3],((C_word*)t0)[4]);
f_6125(2,av2);}}

/* chicken.process-context.posix#create-session in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6162(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_6162,c,av);}
a=C_alloc(7);
t2=C_setsid(C_SCHEME_FALSE);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6166,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6176,a[2]=t3,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:711: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[92]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[92]+1);
av2[1]=t4;
tp(2,av2);}}
else{
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k6164 in chicken.process-context.posix#create-session in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6166(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6166,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k6174 in chicken.process-context.posix#create-session in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6176(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_6176,c,av);}
/* posixunix.scm:711: ##sys#error/errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[370]+1));
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[370]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=lf[371];
av2[4]=lf[372];
tp(5,av2);}}

/* k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6180(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_6180,c,av);}
a=C_alloc(6);
t2=C_mutate((C_word*)lf[189]+1 /* (set! chicken.process-context.posix#process-group-id ...) */,t1);
t3=C_mutate((C_word*)lf[3]+1 /* (set! chicken.file.posix#create-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6182,a[2]=((C_word)li131),tmp=(C_word)a,a+=3,tmp));
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6211,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:750: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[343]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[343]+1);
av2[1]=t4;
av2[2]=C_fixnum_plus(C_fix((C_word)FILENAME_MAX),C_fix(1));
av2[3]=C_fix(0);
tp(4,av2);}}

/* chicken.file.posix#create-symbolic-link in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6182(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_6182,c,av);}
a=C_alloc(6);
t4=C_i_check_string_2(t2,lf[373]);
t5=C_i_check_string_2(t3,lf[373]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6203,a[2]=C_SCHEME_UNDEFINED,a[3]=t1,a[4]=t2,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:742: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[199]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[199]+1);
av2[1]=t6;
av2[2]=t2;
av2[3]=lf[373];
tp(4,av2);}}

/* k6201 in chicken.file.posix#create-symbolic-link in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6203(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_6203,c,av);}
a=C_alloc(3);
t2=C_mutate(((C_word *)t0)+2,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6207,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:743: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[199]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[199]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[5];
av2[3]=lf[373];
tp(4,av2);}}

/* k6205 in k6201 in chicken.file.posix#create-symbolic-link in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6207(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_6207,c,av);}
t2=((C_word*)t0)[2];
if(C_truep(C_fixnum_lessp(C_symlink(((C_word*)t2)[2],t1),C_fix(0)))){
/* posixunix.scm:745: posix-error */
t3=lf[192];{
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=t3;
av2[1]=((C_word*)t2)[3];
av2[2]=lf[197];
av2[3]=lf[373];
av2[4]=lf[374];
av2[5]=((C_word*)t2)[4];
av2[6]=((C_word*)t2)[5];
f_3238(7,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t2)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6211(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word t43;
C_word t44;
C_word t45;
C_word t46;
C_word t47;
C_word t48;
C_word t49;
C_word t50;
C_word t51;
C_word t52;
C_word t53;
C_word t54;
C_word t55;
C_word t56;
C_word t57;
C_word t58;
C_word t59;
C_word t60;
C_word t61;
C_word t62;
C_word t63;
C_word t64;
C_word t65;
C_word t66;
C_word t67;
C_word t68;
C_word t69;
C_word t70;
C_word t71;
C_word t72;
C_word t73;
C_word t74;
C_word t75;
C_word t76;
C_word t77;
C_word t78;
C_word t79;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(137,c,10)))){
C_save_and_reclaim((void *)f_6211,c,av);}
a=C_alloc(137);
t2=C_mutate((C_word*)lf[375]+1 /* (set! ##sys#read-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6212,a[2]=t1,a[3]=((C_word)li132),tmp=(C_word)a,a+=4,tmp));
t3=C_mutate((C_word*)lf[4]+1 /* (set! chicken.file.posix#read-symbolic-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6231,a[2]=((C_word)li136),tmp=(C_word)a,a+=3,tmp));
t4=C_mutate((C_word*)lf[15]+1 /* (set! chicken.file.posix#file-link ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6346,a[2]=((C_word)li137),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[389]+1 /* (set! ##sys#custom-input-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6368,a[2]=((C_word)li155),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[409]+1 /* (set! ##sys#custom-output-port ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6938,a[2]=((C_word)li164),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[25]+1 /* (set! chicken.file.posix#file-truncate ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7234,a[2]=((C_word)li165),tmp=(C_word)a,a+=3,tmp));
t8=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7285,a[2]=((C_word)li166),tmp=(C_word)a,a+=3,tmp);
t9=C_mutate((C_word*)lf[16]+1 /* (set! chicken.file.posix#file-lock ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7300,a[2]=t8,a[3]=((C_word)li168),tmp=(C_word)a,a+=4,tmp));
t10=C_mutate((C_word*)lf[17]+1 /* (set! chicken.file.posix#file-lock/blocking ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7362,a[2]=t8,a[3]=((C_word)li170),tmp=(C_word)a,a+=4,tmp));
t11=C_mutate((C_word*)lf[26]+1 /* (set! chicken.file.posix#file-unlock ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7406,a[2]=t8,a[3]=((C_word)li172),tmp=(C_word)a,a+=4,tmp));
t12=C_mutate((C_word*)lf[2]+1 /* (set! chicken.file.posix#create-fifo ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7437,a[2]=((C_word)li173),tmp=(C_word)a,a+=3,tmp));
t13=C_fix((C_word)sizeof(struct tm));
t14=C_mutate((C_word*)lf[83]+1 /* (set! chicken.time.posix#string->time ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7483,a[2]=t13,a[3]=((C_word)li174),tmp=(C_word)a,a+=4,tmp));
t15=C_fix((C_word)sizeof(struct tm));
t16=C_mutate((C_word*)lf[79]+1 /* (set! chicken.time.posix#utc-time->seconds ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7520,a[2]=t15,a[3]=((C_word)li175),tmp=(C_word)a,a+=4,tmp));
t17=C_mutate((C_word*)lf[85]+1 /* (set! chicken.time.posix#local-timezone-abbreviation ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7539,a[2]=((C_word)li176),tmp=(C_word)a,a+=3,tmp));
t18=C_mutate((C_word*)lf[138]+1 /* (set! chicken.process.signal#set-alarm! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7546,a[2]=((C_word)li177),tmp=(C_word)a,a+=3,tmp));
t19=C_mutate((C_word*)lf[107]+1 /* (set! chicken.process#process-fork ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7558,a[2]=((C_word)li181),tmp=(C_word)a,a+=3,tmp));
t20=C_mutate((C_word*)lf[106]+1 /* (set! chicken.process#process-execute ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7664,a[2]=((C_word)li184),tmp=(C_word)a,a+=3,tmp));
t21=C_mutate(&lf[298] /* (set! chicken.posix#process-wait-impl ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7742,a[2]=((C_word)li186),tmp=(C_word)a,a+=3,tmp));
t22=C_mutate((C_word*)lf[185]+1 /* (set! chicken.process-context.posix#parent-process-id ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7780,a[2]=((C_word)li187),tmp=(C_word)a,a+=3,tmp));
t23=C_mutate((C_word*)lf[109]+1 /* (set! chicken.process#process-signal ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7783,a[2]=((C_word)li188),tmp=(C_word)a,a+=3,tmp));
t24=C_mutate((C_word*)lf[108]+1 /* (set! chicken.process#process-run ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7832,a[2]=((C_word)li189),tmp=(C_word)a,a+=3,tmp));
t25=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7879,a[2]=((C_word)li191),tmp=(C_word)a,a+=3,tmp);
t26=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7904,a[2]=((C_word)li194),tmp=(C_word)a,a+=3,tmp);
t27=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7924,a[2]=((C_word)li195),tmp=(C_word)a,a+=3,tmp);
t28=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7936,a[2]=((C_word)li196),tmp=(C_word)a,a+=3,tmp);
t29=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_7965,a[2]=C_SCHEME_UNDEFINED,a[3]=C_SCHEME_UNDEFINED,a[4]=C_SCHEME_UNDEFINED,a[5]=C_SCHEME_UNDEFINED,a[6]=C_SCHEME_UNDEFINED,a[7]=t28,a[8]=C_SCHEME_UNDEFINED,a[9]=C_SCHEME_UNDEFINED,a[10]=C_SCHEME_UNDEFINED,a[11]=t26,a[12]=((C_word)li198),tmp=(C_word)a,a+=13,tmp);
t30=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8010,a[2]=t27,a[3]=((C_word)li199),tmp=(C_word)a,a+=4,tmp);
t31=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8021,a[2]=t27,a[3]=((C_word)li200),tmp=(C_word)a,a+=4,tmp);
t32=C_mutate(&lf[443] /* (set! chicken.posix#process-impl ...) */,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_8032,a[2]=t29,a[3]=t30,a[4]=t25,a[5]=t31,a[6]=((C_word)li203),tmp=(C_word)a,a+=7,tmp));
t33=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8094,a[2]=((C_word)li207),tmp=(C_word)a,a+=3,tmp);
t34=C_mutate((C_word*)lf[121]+1 /* (set! chicken.process#process ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8159,a[2]=t33,a[3]=((C_word)li208),tmp=(C_word)a,a+=4,tmp));
t35=C_mutate((C_word*)lf[122]+1 /* (set! chicken.process#process* ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8237,a[2]=t33,a[3]=((C_word)li209),tmp=(C_word)a,a+=4,tmp));
t36=C_mutate((C_word*)lf[179]+1 /* (set! chicken.process-context.posix#set-root-directory! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8325,a[2]=((C_word)li210),tmp=(C_word)a,a+=3,tmp));
t37=C_mutate((C_word*)lf[110]+1 /* (set! chicken.process#process-spawn ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8344,a[2]=((C_word)li211),tmp=(C_word)a,a+=3,tmp));
t38=C_a_i_provide(&a,1,lf[449]);
t39=C_mutate((C_word*)lf[450]+1 /* (set! chicken.errno#errno ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8350,a[2]=((C_word)li212),tmp=(C_word)a,a+=3,tmp));
t40=C_set_block_item(lf[452] /* chicken.errno#errno/2big */,0,C_fix((C_word)E2BIG));
t41=C_set_block_item(lf[453] /* chicken.errno#errno/acces */,0,C_fix((C_word)EACCES));
t42=C_set_block_item(lf[454] /* chicken.errno#errno/again */,0,C_fix((C_word)EAGAIN));
t43=C_set_block_item(lf[455] /* chicken.errno#errno/badf */,0,C_fix((C_word)EBADF));
t44=C_set_block_item(lf[456] /* chicken.errno#errno/busy */,0,C_fix((C_word)EBUSY));
t45=C_set_block_item(lf[457] /* chicken.errno#errno/child */,0,C_fix((C_word)ECHILD));
t46=C_set_block_item(lf[458] /* chicken.errno#errno/deadlk */,0,C_fix((C_word)EDEADLK));
t47=C_set_block_item(lf[459] /* chicken.errno#errno/dom */,0,C_fix((C_word)EDOM));
t48=C_set_block_item(lf[460] /* chicken.errno#errno/exist */,0,C_fix((C_word)EEXIST));
t49=C_set_block_item(lf[461] /* chicken.errno#errno/fault */,0,C_fix((C_word)EFAULT));
t50=C_set_block_item(lf[462] /* chicken.errno#errno/fbig */,0,C_fix((C_word)EFBIG));
t51=C_set_block_item(lf[463] /* chicken.errno#errno/ilseq */,0,C_fix((C_word)EILSEQ));
t52=C_set_block_item(lf[464] /* chicken.errno#errno/intr */,0,C_fix((C_word)EINTR));
t53=C_set_block_item(lf[465] /* chicken.errno#errno/inval */,0,C_fix((C_word)EINVAL));
t54=C_set_block_item(lf[466] /* chicken.errno#errno/io */,0,C_fix((C_word)EIO));
t55=C_set_block_item(lf[467] /* chicken.errno#errno/isdir */,0,C_fix((C_word)EISDIR));
t56=C_set_block_item(lf[468] /* chicken.errno#errno/mfile */,0,C_fix((C_word)EMFILE));
t57=C_set_block_item(lf[469] /* chicken.errno#errno/mlink */,0,C_fix((C_word)EMLINK));
t58=C_set_block_item(lf[470] /* chicken.errno#errno/nametoolong */,0,C_fix((C_word)ENAMETOOLONG));
t59=C_set_block_item(lf[471] /* chicken.errno#errno/nfile */,0,C_fix((C_word)ENFILE));
t60=C_set_block_item(lf[472] /* chicken.errno#errno/nodev */,0,C_fix((C_word)ENODEV));
t61=C_set_block_item(lf[473] /* chicken.errno#errno/noent */,0,C_fix((C_word)ENOENT));
t62=C_set_block_item(lf[474] /* chicken.errno#errno/noexec */,0,C_fix((C_word)ENOEXEC));
t63=C_set_block_item(lf[475] /* chicken.errno#errno/nolck */,0,C_fix((C_word)ENOLCK));
t64=C_set_block_item(lf[476] /* chicken.errno#errno/nomem */,0,C_fix((C_word)ENOMEM));
t65=C_set_block_item(lf[477] /* chicken.errno#errno/nospc */,0,C_fix((C_word)ENOSPC));
t66=C_set_block_item(lf[478] /* chicken.errno#errno/nosys */,0,C_fix((C_word)ENOSYS));
t67=C_set_block_item(lf[479] /* chicken.errno#errno/notdir */,0,C_fix((C_word)ENOTDIR));
t68=C_set_block_item(lf[480] /* chicken.errno#errno/notempty */,0,C_fix((C_word)ENOTEMPTY));
t69=C_set_block_item(lf[481] /* chicken.errno#errno/notty */,0,C_fix((C_word)ENOTTY));
t70=C_set_block_item(lf[482] /* chicken.errno#errno/nxio */,0,C_fix((C_word)ENXIO));
t71=C_set_block_item(lf[483] /* chicken.errno#errno/perm */,0,C_fix((C_word)EPERM));
t72=C_set_block_item(lf[484] /* chicken.errno#errno/pipe */,0,C_fix((C_word)EPIPE));
t73=C_set_block_item(lf[485] /* chicken.errno#errno/range */,0,C_fix((C_word)ERANGE));
t74=C_set_block_item(lf[486] /* chicken.errno#errno/rofs */,0,C_fix((C_word)EROFS));
t75=C_set_block_item(lf[487] /* chicken.errno#errno/spipe */,0,C_fix((C_word)ESPIPE));
t76=C_set_block_item(lf[488] /* chicken.errno#errno/srch */,0,C_fix((C_word)ESRCH));
t77=C_set_block_item(lf[489] /* chicken.errno#errno/wouldblock */,0,C_fix((C_word)EWOULDBLOCK));
t78=C_set_block_item(lf[490] /* chicken.errno#errno/xdev */,0,C_fix((C_word)EXDEV));
t79=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t79;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t79+1)))(2,av2);}}

/* ##sys#read-symbolic-link in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6212(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,3)))){
C_save_and_reclaim((void *)f_6212,c,av);}
a=C_alloc(6);
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6217,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=t3,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:754: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[199]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[199]+1);
av2[1]=t4;
av2[2]=t2;
av2[3]=t3;
tp(4,av2);}}

/* k6215 in ##sys#read-symbolic-link in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6217(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_6217,c,av);}
t2=C_do_readlink(t1,((C_word*)t0)[2]);
if(C_truep(C_fixnum_lessp(t2,C_fix(0)))){
/* posixunix.scm:757: posix-error */
t3=lf[192];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[197];
av2[3]=((C_word*)t0)[4];
av2[4]=lf[376];
av2[5]=((C_word*)t0)[5];
f_3238(6,av2);}}
else{
/* posixunix.scm:758: ##sys#buffer->string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[377]+1));
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[377]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[2];
av2[3]=C_fix(0);
av2[4]=t2;
tp(5,av2);}}}

/* chicken.file.posix#read-symbolic-link in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6231(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,5)))){
C_save_and_reclaim((void *)f_6231,c,av);}
a=C_alloc(7);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_get_rest_arg(c,3,av,3,t0));
t5=C_i_check_string_2(t2,lf[378]);
if(C_truep(t4)){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6246,a[2]=t2,a[3]=((C_word)li133),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6252,a[2]=((C_word)li135),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:764: ##sys#call-with-values */{
C_word av2[4];
av2[0]=0;
av2[1]=t1;
av2[2]=t6;
av2[3]=t7;
C_call_with_values(4,av2);}}
else{
/* posixunix.scm:779: ##sys#read-symbolic-link */
t6=*((C_word*)lf[375]+1);{
C_word av2[4];
av2[0]=t6;
av2[1]=t1;
av2[2]=t2;
av2[3]=lf[378];
((C_proc)(void*)(*((C_word*)t6+1)))(4,av2);}}}

/* a6245 in chicken.file.posix#read-symbolic-link in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6246(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_6246,c,av);}
/* posixunix.scm:764: chicken.pathname#decompose-directory */
t2=*((C_word*)lf[379]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* a6251 in chicken.file.posix#read-symbolic-link in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6252(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_6252,c,av);}
a=C_alloc(4);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6260,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
t6=(C_truep(t2)?t2:lf[384]);
if(C_truep(t3)){
/* posixunix.scm:766: scheme#string-append */
t7=*((C_word*)lf[103]+1);{
C_word *av2=av;
av2[0]=t7;
av2[1]=t5;
av2[2]=t6;
av2[3]=t3;
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}
else{
/* posixunix.scm:766: scheme#string-append */
t7=*((C_word*)lf[103]+1);{
C_word *av2=av;
av2[0]=t7;
av2[1]=t5;
av2[2]=t6;
av2[3]=lf[385];
((C_proc)(void*)(*((C_word*)t7+1)))(4,av2);}}}

/* k6258 in a6251 in chicken.file.posix#read-symbolic-link in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6260(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_6260,c,av);}
a=C_alloc(6);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6262,a[2]=t3,a[3]=((C_word)li134),tmp=(C_word)a,a+=4,tmp));
t5=((C_word*)t3)[1];
f_6262(t5,((C_word*)t0)[2],((C_word*)t0)[3],t1);}

/* loop in k6258 in a6251 in chicken.file.posix#read-symbolic-link in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void f_6262(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,3)))){
C_save_and_reclaim_args((void *)trf_6262,4,t0,t1,t2,t3);}
a=C_alloc(7);
if(C_truep(C_i_nullp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6272,a[2]=t2,a[3]=((C_word*)t0)[2],a[4]=t1,a[5]=t3,a[6]=C_SCHEME_UNDEFINED,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:769: chicken.pathname#make-pathname */
t5=*((C_word*)lf[380]+1);{
C_word av2[4];
av2[0]=t5;
av2[1]=t4;
av2[2]=t3;
av2[3]=C_i_car(t2);
((C_proc)(void*)(*((C_word*)t5+1)))(4,av2);}}}

/* k6270 in loop in k6258 in a6251 in chicken.file.posix#read-symbolic-link in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6272(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_6272,c,av);}
a=C_alloc(3);
t2=C_mutate(((C_word *)t0)+6,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6278,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:770: ##sys#file-exists? */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[383]+1));
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[383]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[6];
av2[3]=C_SCHEME_FALSE;
av2[4]=C_SCHEME_FALSE;
av2[5]=lf[378];
tp(6,av2);}}

/* k6276 in k6270 in loop in k6258 in a6251 in chicken.file.posix#read-symbolic-link in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6278(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(13,c,5)))){
C_save_and_reclaim((void *)f_6278,c,av);}
a=C_alloc(13);
t2=((C_word*)t0)[2];
if(C_truep(t1)){
t3=C_u_i_cdr(((C_word*)t2)[2]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6287,a[2]=((C_word*)t2)[3],a[3]=((C_word*)t2)[4],a[4]=t3,tmp=(C_word)a,a+=5,tmp);
t5=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6290,a[2]=((C_word*)t2)[3],a[3]=((C_word*)t2)[4],a[4]=t3,a[5]=t4,a[6]=((C_word*)t2)[5],a[7]=((C_word*)t2)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:772: chicken.file.posix#symbolic-link? */
t6=*((C_word*)lf[35]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t6;
av2[1]=t5;
av2[2]=((C_word*)t2)[6];
((C_proc)(void*)(*((C_word*)t6+1)))(3,av2);}}
else{
/* posixunix.scm:778: ##sys#signal-hook */
t3=*((C_word*)lf[200]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=((C_word*)t2)[4];
av2[2]=lf[197];
av2[3]=lf[378];
av2[4]=lf[382];
av2[5]=((C_word*)t2)[6];
((C_proc)(void*)(*((C_word*)t3+1)))(6,av2);}}}

/* k6285 in k6276 in k6270 in loop in k6258 in a6251 in chicken.file.posix#read-symbolic-link in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6287(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_6287,c,av);}
/* posixunix.scm:771: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_6262(t2,((C_word*)t0)[3],((C_word*)t0)[4],t1);}

/* k6288 in k6276 in k6270 in loop in k6258 in a6251 in chicken.file.posix#read-symbolic-link in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6290(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,c,3)))){
C_save_and_reclaim((void *)f_6290,c,av);}
a=C_alloc(8);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6293,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=C_SCHEME_UNDEFINED,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:773: ##sys#read-symbolic-link */
t3=*((C_word*)lf[375]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[7];
av2[3]=lf[378];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}
else{
/* posixunix.scm:771: loop */
t2=((C_word*)((C_word*)t0)[2])[1];
f_6262(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[7]);}}

/* k6291 in k6288 in k6276 in k6270 in loop in k6258 in a6251 in chicken.file.posix#read-symbolic-link in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6293(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_6293,c,av);}
a=C_alloc(3);
t2=C_mutate(((C_word *)t0)+5,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6299,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:774: chicken.pathname#absolute-pathname? */
t4=*((C_word*)lf[381]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k6297 in k6291 in k6288 in k6276 in k6270 in loop in k6258 in a6251 in chicken.file.posix#read-symbolic-link in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6299(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_6299,c,av);}
t2=((C_word*)t0)[2];
if(C_truep(t1)){
/* posixunix.scm:771: loop */
t3=((C_word*)((C_word*)t2)[2])[1];
f_6262(t3,((C_word*)t2)[3],((C_word*)t2)[4],((C_word*)t2)[5]);}
else{
/* posixunix.scm:776: chicken.pathname#make-pathname */
t3=*((C_word*)lf[380]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=((C_word*)t2)[6];
av2[2]=((C_word*)t2)[7];
av2[3]=((C_word*)t2)[5];
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}}

/* k6331 in chicken.file.posix#file-link in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6333(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_6333,c,av);}
a=C_alloc(3);
t2=C_mutate(((C_word *)t0)+2,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6337,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:782: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[199]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[199]+1);
av2[1]=t3;
av2[2]=C_i_foreign_string_argumentp(((C_word*)t0)[5]);
tp(3,av2);}}

/* k6335 in k6331 in chicken.file.posix#file-link in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6337(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_6337,c,av);}
t2=((C_word*)t0)[2];
if(C_truep(C_fixnum_lessp(stub1827(C_SCHEME_UNDEFINED,((C_word*)t2)[2],t1),C_fix(0)))){
/* posixunix.scm:787: posix-error */
t3=lf[192];{
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=t3;
av2[1]=((C_word*)t2)[3];
av2[2]=lf[197];
av2[3]=lf[387];
av2[4]=lf[388];
av2[5]=((C_word*)t2)[4];
av2[6]=((C_word*)t2)[5];
f_3238(7,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t2)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* chicken.file.posix#file-link in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6346(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_6346,c,av);}
a=C_alloc(6);
t4=C_i_check_string_2(t2,lf[386]);
t5=C_i_check_string_2(t3,lf[386]);
t6=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6333,a[2]=C_SCHEME_UNDEFINED,a[3]=t1,a[4]=t2,a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:782: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[199]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[199]+1);
av2[1]=t6;
av2[2]=C_i_foreign_string_argumentp(t2);
tp(3,av2);}}

/* ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6368(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(10,c,2)))){
C_save_and_reclaim((void *)f_6368,c,av);}
a=C_alloc(10);
t5=C_rest_nullp(c,5);
t6=(C_truep(t5)?C_SCHEME_FALSE:C_get_rest_arg(c,5,av,5,t0));
t7=C_rest_nullp(c,5);
t8=C_rest_nullp(c,6);
t9=(C_truep(t8)?C_fix(1):C_get_rest_arg(c,6,av,5,t0));
t10=C_rest_nullp(c,6);
t11=C_rest_nullp(c,7);
t12=(C_truep(t11)?*((C_word*)lf[390]+1):C_get_rest_arg(c,7,av,5,t0));
t13=C_rest_nullp(c,7);
t14=C_rest_nullp(c,8);
t15=(C_truep(t14)?C_SCHEME_FALSE:C_get_rest_arg(c,8,av,5,t0));
t16=C_rest_nullp(c,8);
t17=C_rest_nullp(c,9);
t18=(C_truep(t17)?C_SCHEME_FALSE:C_get_rest_arg(c,9,av,5,t0));
t19=C_rest_nullp(c,9);
t20=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6402,a[2]=t9,a[3]=t2,a[4]=t4,a[5]=t3,a[6]=t15,a[7]=t18,a[8]=t1,a[9]=t12,tmp=(C_word)a,a+=10,tmp);
if(C_truep(t6)){
/* posixunix.scm:795: ##sys#file-nonblocking! */
t21=*((C_word*)lf[331]+1);{
C_word *av2=av;
av2[0]=t21;
av2[1]=t20;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t21+1)))(3,av2);}}
else{
t21=t20;{
C_word *av2=av;
av2[0]=t21;
av2[1]=C_SCHEME_UNDEFINED;
f_6402(2,av2);}}}

/* k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6402(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(10,c,2)))){
C_save_and_reclaim((void *)f_6402,c,av);}
a=C_alloc(10);
t2=C_fixnump(((C_word*)t0)[2]);
t3=(C_truep(t2)?((C_word*)t0)[2]:C_block_size(((C_word*)t0)[2]));
t4=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6408,a[2]=((C_word*)t0)[3],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[5],a[5]=t3,a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],tmp=(C_word)a,a+=10,tmp);
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
/* posixunix.scm:797: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[343]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[343]+1);
av2[1]=t4;
av2[2]=((C_word*)t0)[2];
tp(3,av2);}}
else{
t5=t4;{
C_word *av2=av;
av2[0]=t5;
av2[1]=((C_word*)t0)[2];
f_6408(2,av2);}}}

/* k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6408(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(87,c,12)))){
C_save_and_reclaim((void *)f_6408,c,av);}
a=C_alloc(87);
t2=C_fix(0);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_fix(0);
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_SCHEME_FALSE;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6409,a[2]=C_SCHEME_UNDEFINED,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word)li138),tmp=(C_word)a,a+=7,tmp);
t9=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6443,a[2]=t5,a[3]=t3,a[4]=t7,a[5]=t1,a[6]=((C_word)li140),tmp=(C_word)a,a+=7,tmp);
t10=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6461,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[2],a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[6],a[8]=t3,a[9]=t5,a[10]=((C_word)li142),tmp=(C_word)a,a+=11,tmp);
t11=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6564,a[2]=t7,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],tmp=(C_word)a,a+=6,tmp);
t12=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6573,a[2]=t5,a[3]=t3,a[4]=t7,a[5]=t1,a[6]=t10,a[7]=((C_word)li144),tmp=(C_word)a,a+=8,tmp);
t13=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6605,a[2]=t5,a[3]=t3,a[4]=t8,a[5]=((C_word)li145),tmp=(C_word)a,a+=6,tmp);
t14=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6617,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[2],a[5]=((C_word*)t0)[4],a[6]=((C_word)li146),tmp=(C_word)a,a+=7,tmp);
t15=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6633,a[2]=t9,a[3]=t5,a[4]=t3,a[5]=t10,a[6]=((C_word)li147),tmp=(C_word)a,a+=7,tmp);
t16=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6648,a[2]=t5,a[3]=t3,a[4]=t1,a[5]=t10,a[6]=((C_word)li149),tmp=(C_word)a,a+=7,tmp);
t17=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6720,a[2]=t5,a[3]=t3,a[4]=t1,a[5]=t10,a[6]=t7,a[7]=((C_word)li153),tmp=(C_word)a,a+=8,tmp);
t18=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6843,a[2]=t5,a[3]=t3,a[4]=t1,a[5]=t7,a[6]=((C_word)li154),tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:847: chicken.port#make-input-port */
t19=*((C_word*)lf[404]+1);{
C_word *av2;
if(c >= 13) {
  av2=av;
} else {
  av2=C_alloc(13);
}
av2[0]=t19;
av2[1]=t11;
av2[2]=t12;
av2[3]=t13;
av2[4]=t14;
av2[5]=lf[405];
av2[6]=t15;
av2[7]=lf[406];
av2[8]=t16;
av2[9]=lf[407];
av2[10]=t17;
av2[11]=lf[408];
av2[12]=t18;
((C_proc)(void*)(*((C_word*)t19+1)))(13,av2);}}

/* ready? in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void f_6409(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,0,2)))){
C_save_and_reclaim_args((void *)trf_6409,2,t0,t1);}
a=C_alloc(3);
t2=C_mutate(((C_word *)t0)+2,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6413,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:803: ##sys#file-select-one */
t4=*((C_word*)lf[332]+1);{
C_word av2[3];
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t4+1)))(3,av2);}}

/* k6411 in ready? in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6413(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_6413,c,av);}
t2=((C_word*)t0)[2];
t3=C_eqp(C_fix(-1),t1);
if(C_truep(t3)){
t4=C_fix((C_word)errno);
t5=C_eqp(t4,C_fix((C_word)EWOULDBLOCK));
t6=(C_truep(t5)?t5:C_eqp(t4,C_fix((C_word)EAGAIN)));
if(C_truep(t6)){
t7=((C_word*)t2)[2];{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}
else{
/* posixunix.scm:807: posix-error */
t7=lf[192];{
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=t7;
av2[1]=((C_word*)t2)[2];
av2[2]=lf[197];
av2[3]=((C_word*)t2)[3];
av2[4]=lf[391];
av2[5]=((C_word*)t2)[4];
av2[6]=((C_word*)t2)[5];
f_3238(7,av2);}}}
else{
t4=((C_word*)t2)[2];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_eqp(C_fix(1),t1);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* peek in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void f_6443(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,0,6)))){
C_save_and_reclaim_args((void *)trf_6443,2,t0,t1);}
a=C_alloc(3);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t2=t1;{
C_word av2[2];
av2[0]=t2;
av2[1]=C_SCHEME_END_OF_FILE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=C_slot(((C_word*)((C_word*)t0)[4])[1],C_fix(15));
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6459,a[2]=((C_word)li139),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:813: ##sys#decode-buffer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[392]+1));
C_word av2[7];
av2[0]=*((C_word*)lf[392]+1);
av2[1]=t1;
av2[2]=((C_word*)t0)[5];
av2[3]=((C_word*)((C_word*)t0)[2])[1];
av2[4]=C_fix(1);
av2[5]=t2;
av2[6]=t3;
tp(7,av2);}}}

/* a6458 in peek in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6459(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6459,c,av);}
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_utf_decode(t2,t3);
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* fetch in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void f_6461(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(14,0,2)))){
C_save_and_reclaim_args((void *)trf_6461,2,t0,t1);}
a=C_alloc(14);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_set_block_item(t3,0,(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_6467,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=t3,a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=((C_word)li141),tmp=(C_word)a,a+=12,tmp));
t5=((C_word*)t3)[1];{
C_word av2[2];
av2[0]=t5;
av2[1]=t1;
f_6467(2,av2);}}

/* loop in fetch in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6467(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,6)))){
C_save_and_reclaim((void *)f_6467,c,av);}
a=C_alloc(8);
t2=C_read(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t3=C_eqp(t2,C_fix(-1));
if(C_truep(t3)){
t4=C_fix((C_word)errno);
t5=C_eqp(t4,C_fix((C_word)EWOULDBLOCK));
t6=(C_truep(t5)?t5:C_eqp(t4,C_fix((C_word)EAGAIN)));
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6494,a[2]=((C_word*)t0)[5],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:823: ##sys#thread-block-for-i/o! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[394]+1));
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=*((C_word*)lf[394]+1);
av2[1]=t7;
av2[2]=*((C_word*)lf[395]+1);
av2[3]=((C_word*)t0)[2];
av2[4]=lf[396];
tp(5,av2);}}
else{
t7=C_eqp(C_fix((C_word)errno),C_fix((C_word)EINTR));
if(C_truep(t7)){
/* posixunix.scm:827: ##sys#dispatch-interrupt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[338]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[338]+1);
av2[1]=t1;
av2[2]=((C_word*)((C_word*)t0)[5])[1];
tp(3,av2);}}
else{
/* posixunix.scm:828: posix-error */
t8=lf[192];{
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=t8;
av2[1]=t1;
av2[2]=lf[197];
av2[3]=((C_word*)t0)[6];
av2[4]=lf[397];
av2[5]=((C_word*)t0)[2];
av2[6]=((C_word*)t0)[7];
f_3238(7,av2);}}}}
else{
t4=(C_truep(((C_word*)t0)[8])?C_eqp(t2,C_fix(0)):C_SCHEME_FALSE);
if(C_truep(t4)){
if(C_truep(((C_word*)t0)[8])){
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6524,a[2]=((C_word*)t0)[5],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:834: ##sys#thread-yield! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[393]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[393]+1);
av2[1]=t5;
tp(2,av2);}}
else{
t5=C_read(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4]);
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_6530,a[2]=((C_word*)t0)[9],a[3]=t6,a[4]=((C_word*)t0)[10],a[5]=t1,tmp=(C_word)a,a+=6,tmp);
t8=C_eqp(((C_word*)t6)[1],C_fix(-1));
if(C_truep(t8)){
t9=C_fix((C_word)errno);
t10=C_eqp(t9,C_fix((C_word)EWOULDBLOCK));
t11=(C_truep(t10)?t10:C_eqp(t9,C_fix((C_word)EAGAIN)));
if(C_truep(t11)){
t12=C_set_block_item(t6,0,C_fix(0));
t13=C_mutate(((C_word *)((C_word*)t0)[9])+1,((C_word*)t6)[1]);
t14=C_set_block_item(((C_word*)t0)[10],0,C_fix(0));
t15=t1;{
C_word *av2=av;
av2[0]=t15;
av2[1]=t14;
((C_proc)(void*)(*((C_word*)t15+1)))(2,av2);}}
else{
/* posixunix.scm:840: posix-error */
t12=lf[192];{
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=t12;
av2[1]=t7;
av2[2]=lf[197];
av2[3]=((C_word*)t0)[6];
av2[4]=lf[398];
av2[5]=((C_word*)t0)[2];
av2[6]=((C_word*)t0)[7];
f_3238(7,av2);}}}
else{
t9=C_mutate(((C_word *)((C_word*)t0)[9])+1,((C_word*)t6)[1]);
t10=C_set_block_item(((C_word*)t0)[10],0,C_fix(0));
t11=t1;{
C_word *av2=av;
av2[0]=t11;
av2[1]=t10;
((C_proc)(void*)(*((C_word*)t11+1)))(2,av2);}}}}
else{
t5=C_mutate(((C_word *)((C_word*)t0)[9])+1,t2);
t6=C_set_block_item(((C_word*)t0)[10],0,C_fix(0));
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}}

/* k6492 in loop in fetch in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6494(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_6494,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_6497,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:824: ##sys#thread-yield! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[393]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[393]+1);
av2[1]=t2;
tp(2,av2);}}

/* k6495 in k6492 in loop in fetch in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6497(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6497,c,av);}
t2=((C_word*)t0)[2];
/* posixunix.scm:825: loop */
t3=((C_word*)((C_word*)t2)[2])[1];{
C_word *av2=av;
av2[0]=t3;
av2[1]=((C_word*)t2)[3];
f_6467(2,av2);}}

/* k6522 in loop in fetch in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6524(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6524,c,av);}
/* posixunix.scm:835: loop */
t2=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
f_6467(2,av2);}}

/* k6528 in loop in fetch in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6530(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6530,c,av);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=C_set_block_item(((C_word*)t0)[4],0,C_fix(0));
t4=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* k6562 in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6564(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6564,c,av);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,t1);
t3=C_i_setslot(((C_word*)((C_word*)t0)[2])[1],C_fix(3),((C_word*)t0)[3]);
t4=C_i_setslot(((C_word*)((C_word*)t0)[2])[1],C_fix(15),((C_word*)t0)[4]);
t5=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t5;
av2[1]=((C_word*)((C_word*)t0)[2])[1];
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* a6572 in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6573(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,2)))){
C_save_and_reclaim((void *)f_6573,c,av);}
a=C_alloc(7);
t2=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6577,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
/* posixunix.scm:850: fetch */
t3=((C_word*)t0)[6];
f_6461(t3,t2);}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_6577(2,av2);}}}

/* k6575 in a6572 in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6577(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,6)))){
C_save_and_reclaim((void *)f_6577,c,av);}
a=C_alloc(4);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t2=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_END_OF_FILE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=C_slot(((C_word*)((C_word*)t0)[5])[1],C_fix(15));
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6592,a[2]=((C_word*)t0)[2],a[3]=((C_word)li143),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:853: ##sys#decode-buffer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[392]+1));
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=*((C_word*)lf[392]+1);
av2[1]=((C_word*)t0)[4];
av2[2]=((C_word*)t0)[6];
av2[3]=((C_word*)((C_word*)t0)[2])[1];
av2[4]=C_fix(1);
av2[5]=t2;
av2[6]=t3;
tp(7,av2);}}}

/* a6591 in k6575 in a6572 in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6592(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6592,c,av);}
t5=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],t4);
t6=C_set_block_item(((C_word*)t0)[2],0,t5);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=C_utf_decode(t2,t3);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* a6604 in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6605(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6605,c,av);}
t2=C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]);
if(C_truep(t2)){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* posixunix.scm:859: ready? */
t3=((C_word*)t0)[4];
f_6409(t3,t1);}}

/* a6616 in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6617(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,6)))){
C_save_and_reclaim((void *)f_6617,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6621,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(C_close(((C_word*)t0)[3]),C_fix(0)))){
/* posixunix.scm:862: posix-error */
t3=lf[192];{
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[197];
av2[3]=((C_word*)t0)[4];
av2[4]=lf[399];
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[5];
f_3238(7,av2);}}
else{
/* posixunix.scm:863: on-close */
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)C_fast_retrieve_proc(t3))(2,av2);}}}

/* k6619 in a6616 in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6621(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6621,c,av);}
/* posixunix.scm:863: on-close */
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)C_fast_retrieve_proc(t2))(2,av2);}}

/* a6632 in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6633(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_6633,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_6637,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[3])[1],((C_word*)((C_word*)t0)[4])[1]))){
/* posixunix.scm:867: fetch */
t3=((C_word*)t0)[5];
f_6461(t3,t2);}
else{
/* posixunix.scm:868: peek */
t3=((C_word*)t0)[2];
f_6443(t3,t1);}}

/* k6635 in a6632 in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6637(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6637,c,av);}
/* posixunix.scm:868: peek */
t2=((C_word*)t0)[2];
f_6443(t2,((C_word*)t0)[3]);}

/* a6647 in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6648(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(11,c,5)))){
C_save_and_reclaim((void *)f_6648,c,av);}
a=C_alloc(11);
t6=(C_truep(t3)?t3:C_fixnum_difference(C_block_size(t4),t5));
t7=C_SCHEME_UNDEFINED;
t8=(*a=C_VECTOR_TYPE|1,a[1]=t7,tmp=(C_word)a,a+=2,tmp);
t9=C_set_block_item(t8,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6658,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t4,a[5]=((C_word*)t0)[4],a[6]=t8,a[7]=((C_word*)t0)[5],a[8]=((C_word)li148),tmp=(C_word)a,a+=9,tmp));
t10=((C_word*)t8)[1];
f_6658(t10,t1,t6,C_fix(0),t5);}

/* loop in a6647 in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void f_6658(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(8,0,4)))){
C_save_and_reclaim_args((void *)trf_6658,5,t0,t1,t2,t3,t4);}
a=C_alloc(8);
t5=C_eqp(C_fix(0),t2);
if(C_truep(t5)){
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
if(C_truep(C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t6=C_fixnum_difference(((C_word*)((C_word*)t0)[3])[1],((C_word*)((C_word*)t0)[2])[1]);
t7=C_fixnum_lessp(t2,t6);
t8=(C_truep(t7)?t2:t6);
t9=C_copy_memory_with_offset(((C_word*)t0)[4],((C_word*)t0)[5],t4,((C_word*)((C_word*)t0)[2])[1],t8);
t10=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],t8);
t11=C_set_block_item(((C_word*)t0)[2],0,t10);
/* posixunix.scm:881: loop */
t13=t1;
t14=C_fixnum_difference(t2,t8);
t15=C_fixnum_plus(t3,t8);
t16=C_fixnum_plus(t4,t8);
t1=t13;
t2=t14;
t3=t15;
t4=t16;
goto loop;}
else{
t6=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6702,a[2]=((C_word*)t0)[3],a[3]=t1,a[4]=t3,a[5]=((C_word*)t0)[6],a[6]=t2,a[7]=t4,tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:883: fetch */
t7=((C_word*)t0)[7];
f_6461(t7,t6);}}}

/* k6700 in loop in a6647 in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6702(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_6702,c,av);}
t2=C_eqp(C_fix(0),((C_word*)((C_word*)t0)[2])[1]);
if(C_truep(t2)){
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
/* posixunix.scm:886: loop */
t3=((C_word*)((C_word*)t0)[5])[1];
f_6658(t3,((C_word*)t0)[3],((C_word*)t0)[6],((C_word*)t0)[4],((C_word*)t0)[7]);}}

/* a6719 in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6720(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(10,c,2)))){
C_save_and_reclaim((void *)f_6720,c,av);}
a=C_alloc(10);
t4=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_6724,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=t3,a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[5],a[8]=((C_word*)t0)[6],a[9]=t2,tmp=(C_word)a,a+=10,tmp);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
/* posixunix.scm:890: fetch */
t5=((C_word*)t0)[5];
f_6461(t5,t4);}
else{
t5=t4;{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_SCHEME_UNDEFINED;
f_6724(2,av2);}}}

/* k6722 in a6719 in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6724(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(16,c,5)))){
C_save_and_reclaim((void *)f_6724,c,av);}
a=C_alloc(16);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t2=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_END_OF_FILE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
t2=(C_truep(((C_word*)t0)[5])?((C_word*)t0)[5]:C_fixnum_difference(*((C_word*)lf[400]+1),((C_word*)((C_word*)t0)[2])[1]));
t3=t2;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6738,a[2]=((C_word*)t0)[2],a[3]=t4,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word)li151),tmp=(C_word)a,a+=9,tmp);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6798,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[2],a[4]=((C_word)li152),tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:894: ##sys#call-with-values */{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=0;
av2[1]=((C_word*)t0)[4];
av2[2]=t5;
av2[3]=t6;
C_call_with_values(4,av2);}}}

/* a6737 in k6722 in a6719 in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6738(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,6)))){
C_save_and_reclaim((void *)f_6738,c,av);}
a=C_alloc(8);
t2=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]);
t3=C_i_fixnum_min(((C_word*)((C_word*)t0)[4])[1],t2);
t4=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_6748,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word)li150),tmp=(C_word)a,a+=8,tmp);
/* posixunix.scm:895: ##sys#scan-buffer-line */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[401]+1));
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=*((C_word*)lf[401]+1);
av2[1]=t1;
av2[2]=((C_word*)t0)[5];
av2[3]=t3;
av2[4]=((C_word*)((C_word*)t0)[2])[1];
av2[5]=t4;
av2[6]=C_slot(((C_word*)((C_word*)t0)[7])[1],C_fix(15));
tp(7,av2);}}

/* a6747 in a6737 in k6722 in a6719 in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6748(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_6748,c,av);}
a=C_alloc(7);
t3=C_fixnum_difference(t2,((C_word*)((C_word*)t0)[2])[1]);
if(C_truep(C_fixnum_greater_or_equal_p(t3,((C_word*)((C_word*)t0)[3])[1]))){
/* posixunix.scm:902: scheme#values */{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=t1;
av2[2]=C_SCHEME_FALSE;
av2[3]=t2;
av2[4]=C_SCHEME_FALSE;
C_values(5,av2);}}
else{
t4=C_fixnum_difference(((C_word*)((C_word*)t0)[3])[1],t3);
t5=C_set_block_item(((C_word*)t0)[3],0,t4);
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6768,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[3],a[5]=t1,a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:905: fetch */
t7=((C_word*)t0)[6];
f_6461(t7,t6);}}

/* k6766 in a6747 in a6737 in k6722 in a6719 in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6768(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_6768,c,av);}
if(C_truep(C_fixnum_lessp(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t2=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[4])[1]);
/* posixunix.scm:907: scheme#values */{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=((C_word*)t0)[5];
av2[2]=((C_word*)t0)[6];
av2[3]=((C_word*)((C_word*)t0)[2])[1];
av2[4]=C_i_fixnum_min(((C_word*)((C_word*)t0)[3])[1],t2);
C_values(5,av2);}}
else{
/* posixunix.scm:910: scheme#values */{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=0;
av2[1]=((C_word*)t0)[5];
av2[2]=C_SCHEME_FALSE;
av2[3]=((C_word*)((C_word*)t0)[2])[1];
av2[4]=C_SCHEME_FALSE;
C_values(5,av2);}}}

/* a6797 in k6722 in a6719 in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6798(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6798,c,av);}
if(C_truep(t4)){
t5=C_slot(((C_word*)t0)[2],C_fix(4));
t6=C_fixnum_plus(t5,C_fix(1));
t7=C_i_set_i_slot(((C_word*)t0)[2],C_fix(4),t6);
t8=C_i_set_i_slot(((C_word*)t0)[2],C_fix(5),C_fix(0));
t9=C_mutate(((C_word *)((C_word*)t0)[3])+1,t2);
t10=t1;{
C_word *av2=av;
av2[0]=t10;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}
else{
t5=C_slot(((C_word*)t0)[2],C_fix(5));
t6=C_i_string_length(t3);
t7=C_fixnum_plus(t5,t6);
t8=C_i_set_i_slot(((C_word*)t0)[2],C_fix(5),t7);
t9=C_mutate(((C_word *)((C_word*)t0)[3])+1,t2);
t10=t1;{
C_word *av2=av;
av2[0]=t10;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}}

/* a6842 in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6843(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,5)))){
C_save_and_reclaim((void *)f_6843,c,av);}
a=C_alloc(5);
if(C_truep(C_fixnum_greater_or_equal_p(((C_word*)((C_word*)t0)[2])[1],((C_word*)((C_word*)t0)[3])[1]))){
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=lf[402];
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}
else{
t3=C_fixnum_difference(((C_word*)((C_word*)t0)[3])[1],((C_word*)((C_word*)t0)[2])[1]);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_6856,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:926: ##sys#buffer->string/encoding */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[403]+1));
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[403]+1);
av2[1]=t4;
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)((C_word*)t0)[2])[1];
av2[4]=t3;
av2[5]=C_slot(((C_word*)((C_word*)t0)[5])[1],C_fix(15));
tp(6,av2);}}}

/* k6854 in a6842 in k6406 in k6400 in ##sys#custom-input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6856(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_6856,c,av);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,((C_word*)((C_word*)t0)[3])[1]);
t3=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* ##sys#custom-output-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6938(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word *a;
if(c<5) C_bad_min_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,2)))){
C_save_and_reclaim((void *)f_6938,c,av);}
a=C_alloc(9);
t5=C_rest_nullp(c,5);
t6=(C_truep(t5)?C_SCHEME_FALSE:C_get_rest_arg(c,5,av,5,t0));
t7=C_rest_nullp(c,5);
t8=C_rest_nullp(c,6);
t9=(C_truep(t8)?C_fix(0):C_get_rest_arg(c,6,av,5,t0));
t10=C_rest_nullp(c,6);
t11=C_rest_nullp(c,7);
t12=(C_truep(t11)?*((C_word*)lf[390]+1):C_get_rest_arg(c,7,av,5,t0));
t13=C_rest_nullp(c,7);
t14=C_rest_nullp(c,8);
t15=(C_truep(t14)?C_SCHEME_FALSE:C_get_rest_arg(c,8,av,5,t0));
t16=C_rest_nullp(c,8);
t17=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_6966,a[2]=t4,a[3]=t2,a[4]=t3,a[5]=t9,a[6]=t15,a[7]=t1,a[8]=t12,tmp=(C_word)a,a+=9,tmp);
if(C_truep(t6)){
/* posixunix.scm:937: ##sys#file-nonblocking! */
t18=*((C_word*)lf[331]+1);{
C_word *av2=av;
av2[0]=t18;
av2[1]=t17;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t18+1)))(3,av2);}}
else{
t18=t17;{
C_word *av2=av;
av2[0]=t18;
av2[1]=C_SCHEME_UNDEFINED;
f_6966(2,av2);}}}

/* k6964 in ##sys#custom-output-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6966(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(30,c,5)))){
C_save_and_reclaim((void *)f_6966,c,av);}
a=C_alloc(30);
t2=C_SCHEME_UNDEFINED;
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=C_SCHEME_UNDEFINED;
t5=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t6=C_SCHEME_UNDEFINED;
t7=(*a=C_VECTOR_TYPE|1,a[1]=t6,tmp=(C_word)a,a+=2,tmp);
t8=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_6967,a[2]=((C_word*)t0)[2],a[3]=t5,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word)li157),tmp=(C_word)a,a+=7,tmp);
t9=C_fixnump(((C_word*)t0)[5]);
t10=(C_truep(t9)?((C_word*)t0)[5]:C_block_size(((C_word*)t0)[5]));
t11=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_7038,a[2]=t3,a[3]=t5,a[4]=t8,a[5]=t7,a[6]=((C_word*)t0)[4],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[2],a[11]=((C_word*)t0)[3],tmp=(C_word)a,a+=12,tmp);
t12=C_eqp(C_fix(0),t10);
if(C_truep(t12)){
t13=t11;
f_7038(t13,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7083,a[2]=t5,a[3]=((C_word)li161),tmp=(C_word)a,a+=4,tmp));}
else{
t13=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7104,a[2]=t11,a[3]=t5,a[4]=t10,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_fixnump(((C_word*)t0)[5]))){
/* posixunix.scm:961: ##sys#make-bytevector */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[343]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[343]+1);
av2[1]=t13;
av2[2]=((C_word*)t0)[5];
tp(3,av2);}}
else{
t14=t13;{
C_word *av2=av;
av2[0]=t14;
av2[1]=((C_word*)t0)[5];
f_7104(2,av2);}}}}

/* poke1994 in k6964 in ##sys#custom-output-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6967(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(13,c,2)))){
C_save_and_reclaim((void *)f_6967,c,av);}
a=C_alloc(13);
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_6973,a[2]=((C_word*)t0)[2],a[3]=t2,a[4]=t3,a[5]=t4,a[6]=((C_word*)t0)[3],a[7]=t6,a[8]=((C_word*)t0)[4],a[9]=((C_word*)t0)[5],a[10]=((C_word)li156),tmp=(C_word)a,a+=11,tmp));
t8=((C_word*)t6)[1];{
C_word *av2=av;
av2[0]=t8;
av2[1]=t1;
f_6973(2,av2);}}

/* loop in poke1994 in k6964 in ##sys#custom-output-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_6973(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,6)))){
C_save_and_reclaim((void *)f_6973,c,av);}
a=C_alloc(7);
t2=C_write(((C_word*)t0)[2],((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5]);
t3=C_eqp(C_fix(-1),t2);
if(C_truep(t3)){
t4=C_fix((C_word)errno);
t5=C_eqp(t4,C_fix((C_word)EWOULDBLOCK));
t6=(C_truep(t5)?t5:C_eqp(t4,C_fix((C_word)EAGAIN)));
if(C_truep(t6)){
t7=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_7000,a[2]=((C_word*)t0)[6],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:946: ##sys#thread-yield! */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[393]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[393]+1);
av2[1]=t7;
tp(2,av2);}}
else{
t7=C_eqp(C_fix((C_word)errno),C_fix((C_word)EINTR));
if(C_truep(t7)){
/* posixunix.scm:949: ##sys#dispatch-interrupt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[338]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[338]+1);
av2[1]=t1;
av2[2]=((C_word*)((C_word*)t0)[7])[1];
tp(3,av2);}}
else{
/* posixunix.scm:951: posix-error */
t8=lf[192];{
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=t8;
av2[1]=t1;
av2[2]=((C_word*)t0)[8];
av2[3]=lf[197];
av2[4]=lf[410];
av2[5]=((C_word*)t0)[2];
av2[6]=((C_word*)t0)[9];
f_3238(7,av2);}}}}
else{
if(C_truep(C_fixnum_lessp(t2,((C_word*)t0)[5]))){
/* posixunix.scm:953: poke */
t4=((C_word*)((C_word*)t0)[6])[1];{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t4;
av2[1]=t1;
av2[2]=((C_word*)t0)[3];
av2[3]=C_fixnum_plus(((C_word*)t0)[4],t2);
av2[4]=C_fixnum_difference(((C_word*)t0)[5],t2);
((C_proc)C_fast_retrieve_proc(t4))(5,av2);}}
else{
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}}

/* k6998 in loop in poke1994 in k6964 in ##sys#custom-output-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7000(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_7000,c,av);}
/* posixunix.scm:947: poke */
t2=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[5];
av2[4]=((C_word*)t0)[6];
((C_proc)C_fast_retrieve_proc(t2))(5,av2);}}

/* k7036 in k6964 in ##sys#custom-output-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void f_7038(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(21,0,5)))){
C_save_and_reclaim_args((void *)trf_7038,2,t0,t1);}
a=C_alloc(21);
t2=C_set_block_item(((C_word*)t0)[2],0,C_SCHEME_FALSE);
t3=C_mutate(((C_word *)((C_word*)t0)[3])+1,((C_word*)t0)[4]);
t4=C_mutate(((C_word *)((C_word*)t0)[5])+1,t1);
t5=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7044,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[6],a[4]=((C_word*)t0)[7],a[5]=((C_word*)t0)[8],tmp=(C_word)a,a+=6,tmp);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7053,a[2]=((C_word*)t0)[5],a[3]=((C_word)li158),tmp=(C_word)a,a+=4,tmp);
t7=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_7059,a[2]=((C_word*)t0)[9],a[3]=((C_word*)t0)[10],a[4]=((C_word*)t0)[11],a[5]=((C_word*)t0)[6],a[6]=((C_word)li159),tmp=(C_word)a,a+=7,tmp);
t8=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7075,a[2]=((C_word*)t0)[5],a[3]=((C_word)li160),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:982: chicken.port#make-output-port */
t9=*((C_word*)lf[412]+1);{
C_word av2[6];
av2[0]=t9;
av2[1]=t5;
av2[2]=t6;
av2[3]=t7;
av2[4]=lf[413];
av2[5]=t8;
((C_proc)(void*)(*((C_word*)t9+1)))(6,av2);}}

/* k7042 in k7036 in k6964 in ##sys#custom-output-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7044(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_7044,c,av);}
t2=C_mutate(((C_word *)((C_word*)t0)[2])+1,t1);
t3=C_i_setslot(((C_word*)((C_word*)t0)[2])[1],C_fix(3),((C_word*)t0)[3]);
t4=C_i_setslot(((C_word*)((C_word*)t0)[2])[1],C_fix(15),((C_word*)t0)[4]);
t5=((C_word*)t0)[5];{
C_word *av2=av;
av2[0]=t5;
av2[1]=((C_word*)((C_word*)t0)[2])[1];
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}

/* a7052 in k7036 in k6964 in ##sys#custom-output-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7053(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_7053,c,av);}
/* posixunix.scm:983: store */
t3=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
av2[2]=t2;
((C_proc)C_fast_retrieve_proc(t3))(3,av2);}}

/* a7058 in k7036 in k6964 in ##sys#custom-output-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7059(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,6)))){
C_save_and_reclaim((void *)f_7059,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7063,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(C_close(((C_word*)t0)[3]),C_fix(0)))){
/* posixunix.scm:986: posix-error */
t3=lf[192];{
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[197];
av2[3]=((C_word*)t0)[4];
av2[4]=lf[411];
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[5];
f_3238(7,av2);}}
else{
/* posixunix.scm:987: on-close */
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)C_fast_retrieve_proc(t3))(2,av2);}}}

/* k7061 in a7058 in k7036 in k6964 in ##sys#custom-output-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7063(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_7063,c,av);}
/* posixunix.scm:987: on-close */
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)C_fast_retrieve_proc(t2))(2,av2);}}

/* a7074 in k7036 in k6964 in ##sys#custom-output-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7075(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_7075,c,av);}
/* posixunix.scm:990: store */
t2=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=C_SCHEME_FALSE;
((C_proc)C_fast_retrieve_proc(t2))(3,av2);}}

/* f_7083 in k6964 in ##sys#custom-output-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7083(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_7083,c,av);}
if(C_truep(t2)){
t3=C_slot(t2,C_fix(0));
t4=C_block_size(t3);
/* posixunix.scm:960: poke */
t5=((C_word*)((C_word*)t0)[2])[1];{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t5;
av2[1]=t1;
av2[2]=t3;
av2[3]=C_fix(0);
av2[4]=C_fixnum_difference(t4,C_fix(1));
((C_proc)C_fast_retrieve_proc(t5))(5,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k7102 in k6964 in ##sys#custom-output-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7104(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,3)))){
C_save_and_reclaim((void *)f_7104,c,av);}
a=C_alloc(9);
t2=C_fix(0);
t3=(*a=C_VECTOR_TYPE|1,a[1]=t2,tmp=(C_word)a,a+=2,tmp);
t4=((C_word*)t0)[2];
f_7038(t4,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_7105,a[2]=t3,a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=((C_word)li163),tmp=(C_word)a,a+=7,tmp));}

/* f_7105 in k7102 in k6964 in ##sys#custom-output-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7105(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(17,c,5)))){
C_save_and_reclaim((void *)f_7105,c,av);}
a=C_alloc(17);
if(C_truep(t2)){
t3=C_slot(t2,C_fix(0));
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7115,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
t5=C_fixnum_difference(((C_word*)t0)[5],((C_word*)((C_word*)t0)[2])[1]);
t6=C_block_size(t3);
t7=C_fixnum_difference(t6,C_fix(1));
t8=C_SCHEME_UNDEFINED;
t9=(*a=C_VECTOR_TYPE|1,a[1]=t8,tmp=(C_word)a,a+=2,tmp);
t10=C_set_block_item(t9,0,(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_7134,a[2]=((C_word*)t0)[2],a[3]=t9,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[3],a[6]=((C_word*)t0)[4],a[7]=t3,a[8]=((C_word)li162),tmp=(C_word)a,a+=9,tmp));
t11=((C_word*)t9)[1];
f_7134(t11,t4,t5,C_fix(0),t7);}
else{
t3=C_SCHEME_UNDEFINED;
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k7113 */
static void C_ccall f_7115(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_7115,c,av);}
if(C_truep(C_fixnum_lessp(C_fix(0),((C_word*)((C_word*)t0)[2])[1]))){
/* posixunix.scm:980: poke */
t2=((C_word*)((C_word*)t0)[3])[1];{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[4];
av2[2]=((C_word*)t0)[5];
av2[3]=((C_word*)((C_word*)t0)[2])[1];
((C_proc)C_fast_retrieve_proc(t2))(4,av2);}}
else{
t2=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_UNDEFINED;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* loop */
static void f_7134(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(7,0,4)))){
C_save_and_reclaim_args((void *)trf_7134,5,t0,t1,t2,t3,t4);}
a=C_alloc(7);
t5=C_eqp(C_fix(0),t2);
if(C_truep(t5)){
t6=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_7144,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=((C_word*)t0)[4],a[6]=t4,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:970: poke */
t7=((C_word*)((C_word*)t0)[5])[1];{
C_word av2[5];
av2[0]=t7;
av2[1]=t6;
av2[2]=((C_word*)t0)[6];
av2[3]=C_fix(0);
av2[4]=((C_word*)t0)[4];
((C_proc)C_fast_retrieve_proc(t7))(5,av2);}}
else{
if(C_truep(C_fixnum_lessp(t2,t4))){
t6=C_copy_memory_with_offset(((C_word*)t0)[6],((C_word*)t0)[7],((C_word*)((C_word*)t0)[2])[1],C_fix(0),t4);
/* posixunix.scm:975: loop */
t10=t1;
t11=C_fix(0);
t12=t2;
t13=C_fixnum_difference(t4,t2);
t1=t10;
t2=t11;
t3=t12;
t4=t13;
goto loop;}
else{
t6=C_copy_memory_with_offset(((C_word*)t0)[6],((C_word*)t0)[7],((C_word*)((C_word*)t0)[2])[1],t3,t4);
t7=C_fixnum_plus(((C_word*)((C_word*)t0)[2])[1],t4);
t8=C_set_block_item(((C_word*)t0)[2],0,t7);
t9=t1;{
C_word av2[2];
av2[0]=t9;
av2[1]=t8;
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}}}

/* k7142 in loop */
static void C_ccall f_7144(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_7144,c,av);}
t2=C_set_block_item(((C_word*)t0)[2],0,C_fix(0));
/* posixunix.scm:972: loop */
t3=((C_word*)((C_word*)t0)[3])[1];
f_7134(t3,((C_word*)t0)[4],((C_word*)t0)[5],C_fix(0),((C_word*)t0)[6]);}

/* chicken.file.posix#file-truncate in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7234(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_7234,c,av);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7238,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1001: ##sys#check-exact-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[220]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[220]+1);
av2[1]=t4;
av2[2]=t3;
av2[3]=lf[414];
tp(4,av2);}}

/* k7236 in chicken.file.posix#file-truncate in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7238(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,c,3)))){
C_save_and_reclaim((void *)f_7238,c,av);}
a=C_alloc(12);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7244,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7251,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_stringp(((C_word*)t0)[3]))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7258,a[2]=t2,a[3]=((C_word*)t0)[4],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1002: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[199]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[199]+1);
av2[1]=t4;
av2[2]=((C_word*)t0)[3];
av2[3]=lf[414];
tp(4,av2);}}
else{
t4=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7264,a[2]=t2,a[3]=((C_word*)t0)[4],a[4]=((C_word*)t0)[3],a[5]=t3,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1003: scheme#port? */
t5=*((C_word*)lf[203]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t5;
av2[1]=t4;
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}}

/* k7242 in k7236 in chicken.file.posix#file-truncate in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void f_7244(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,6)))){
C_save_and_reclaim_args((void *)trf_7244,2,t0,t1);}
t2=((C_word*)t0)[2];
if(C_truep(t1)){
/* posixunix.scm:1007: posix-error */
t3=lf[192];{
C_word av2[7];
av2[0]=t3;
av2[1]=((C_word*)t2)[2];
av2[2]=lf[197];
av2[3]=lf[414];
av2[4]=lf[415];
av2[5]=((C_word*)t2)[3];
av2[6]=((C_word*)t2)[4];
f_3238(7,av2);}}
else{
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t2)[2];{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k7249 in k7236 in chicken.file.posix#file-truncate in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7251(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_7251,c,av);}
t2=((C_word*)t0)[2];
f_7244(t2,C_fixnum_lessp(t1,C_fix(0)));}

/* k7256 in k7236 in chicken.file.posix#file-truncate in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7258(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_7258,c,av);}
t2=((C_word*)t0)[2];
f_7244(t2,C_fixnum_lessp(C_truncate(t1,((C_word*)t0)[3]),C_fix(0)));}

/* k7262 in k7236 in chicken.file.posix#file-truncate in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7264(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,4)))){
C_save_and_reclaim((void *)f_7264,c,av);}
a=C_alloc(4);
if(C_truep(t1)){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7268,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1003: chicken.file.posix#port->fileno */
t3=*((C_word*)lf[72]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}
else{
if(C_truep(C_fixnump(((C_word*)t0)[4]))){
t2=((C_word*)t0)[2];
f_7244(t2,C_fixnum_lessp(C_ftruncate(((C_word*)t0)[4],((C_word*)t0)[3]),C_fix(0)));}
else{
/* posixunix.scm:1005: ##sys#error */
t2=*((C_word*)lf[94]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[5];
av2[2]=lf[414];
av2[3]=lf[416];
av2[4]=((C_word*)t0)[4];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}}}

/* k7266 in k7262 in k7236 in chicken.file.posix#file-truncate in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7268(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_7268,c,av);}
t2=((C_word*)t0)[2];
f_7244(t2,C_fixnum_lessp(C_ftruncate(t1,((C_word*)t0)[3]),C_fix(0)));}

/* fileno in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void f_7285(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_7285,3,t1,t2,t3);}
a=C_alloc(5);
t4=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7292,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1021: scheme#port? */
t5=*((C_word*)lf[203]+1);{
C_word av2[3];
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}

/* k7290 in fileno in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7292(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_7292,c,av);}
a=C_alloc(4);
if(C_truep(t1)){
/* posixunix.scm:1022: chicken.file.posix#port->fileno */
t2=*((C_word*)lf[72]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7298,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1024: ##sys#check-exact-integer */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[220]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[220]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
tp(4,av2);}}}

/* k7296 in k7290 in fileno in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7298(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_7298,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.file.posix#file-lock in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7300(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,2)))){
C_save_and_reclaim((void *)f_7300,c,av);}
a=C_alloc(9);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_get_rest_arg(c,3,av,3,t0));
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_7309,a[2]=t4,a[3]=t6,a[4]=t2,a[5]=((C_word*)t0)[2],a[6]=((C_word)li167),tmp=(C_word)a,a+=7,tmp));
t8=((C_word*)t6)[1];
f_7309(t8,t1);}

/* loop in chicken.file.posix#file-lock in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void f_7309(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_7309,2,t0,t1);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7314,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1029: fileno */
f_7285(t2,((C_word*)t0)[4],lf[417]);}

/* k7312 in loop in chicken.file.posix#file-lock in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7314(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_7314,c,av);}
t2=(C_truep(((C_word*)t0)[2])?C_fix((C_word)LOCK_SH):C_fix((C_word)LOCK_EX));
t3=C_fixnum_or(C_fix((C_word)LOCK_NB),t2);
t4=C_flock(t1,t3);
t5=C_eqp(t4,C_fix(0));
if(C_truep(t5)){
t6=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t6;
av2[1]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_eqp(C_fix((C_word)errno),C_fix((C_word)EINTR));
if(C_truep(t6)){
/* posixunix.scm:1032: loop */
t7=((C_word*)((C_word*)t0)[4])[1];
f_7309(t7,((C_word*)t0)[3]);}
else{
t7=C_fix((C_word)errno);
t8=C_eqp(t7,C_fix((C_word)EWOULDBLOCK));
if(C_truep(t8)){
if(C_truep(t8)){
t9=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t9;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t9+1)))(2,av2);}}
else{
/* posixunix.scm:1019: posix-error */
t9=lf[192];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t9;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[197];
av2[3]=lf[417];
av2[4]=lf[418];
av2[5]=((C_word*)t0)[5];
f_3238(6,av2);}}}
else{
t9=C_eqp(t7,C_fix((C_word)EAGAIN));
if(C_truep(t9)){
t10=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t10;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t10+1)))(2,av2);}}
else{
/* posixunix.scm:1019: posix-error */
t10=lf[192];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t10;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[197];
av2[3]=lf[417];
av2[4]=lf[418];
av2[5]=((C_word*)t0)[5];
f_3238(6,av2);}}}}}}

/* chicken.file.posix#file-lock/blocking in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7362(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(9,c,2)))){
C_save_and_reclaim((void *)f_7362,c,av);}
a=C_alloc(9);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_get_rest_arg(c,3,av,3,t0));
t5=C_SCHEME_UNDEFINED;
t6=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t7=C_set_block_item(t6,0,(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_7371,a[2]=t4,a[3]=t6,a[4]=t2,a[5]=((C_word*)t0)[2],a[6]=((C_word)li169),tmp=(C_word)a,a+=7,tmp));
t8=((C_word*)t6)[1];
f_7371(t8,t1);}

/* loop in chicken.file.posix#file-lock/blocking in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void f_7371(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,3)))){
C_save_and_reclaim_args((void *)trf_7371,2,t0,t1);}
a=C_alloc(6);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7376,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1038: fileno */
f_7285(t2,((C_word*)t0)[4],lf[419]);}

/* k7374 in loop in chicken.file.posix#file-lock/blocking in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7376(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_7376,c,av);}
t2=(C_truep(((C_word*)t0)[2])?C_fix((C_word)LOCK_SH):C_fix((C_word)LOCK_EX));
t3=C_flock(t1,t2);
t4=C_eqp(t3,C_fix(0));
if(C_truep(t4)){
t5=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t5;
av2[1]=C_SCHEME_TRUE;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}
else{
t5=C_eqp(C_fix((C_word)errno),C_fix((C_word)EINTR));
if(C_truep(t5)){
/* posixunix.scm:1041: loop */
t6=((C_word*)((C_word*)t0)[4])[1];
f_7371(t6,((C_word*)t0)[3]);}
else{
/* posixunix.scm:1019: posix-error */
t6=lf[192];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t6;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[197];
av2[3]=lf[419];
av2[4]=lf[420];
av2[5]=((C_word*)t0)[5];
f_3238(6,av2);}}}}

/* chicken.file.posix#file-unlock in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7406(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,2)))){
C_save_and_reclaim((void *)f_7406,c,av);}
a=C_alloc(8);
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7412,a[2]=t4,a[3]=t2,a[4]=((C_word*)t0)[2],a[5]=((C_word)li171),tmp=(C_word)a,a+=6,tmp));
t6=((C_word*)t4)[1];
f_7412(t6,t1);}

/* loop in chicken.file.posix#file-unlock in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void f_7412(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,3)))){
C_save_and_reclaim_args((void *)trf_7412,2,t0,t1);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7417,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1046: fileno */
f_7285(t2,((C_word*)t0)[3],lf[421]);}

/* k7415 in loop in chicken.file.posix#file-unlock in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7417(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_7417,c,av);}
t2=C_flock(t1,C_fix((C_word)LOCK_UN));
t3=C_eqp(t2,C_fix(0));
if(C_truep(t3)){
t4=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_eqp(C_fix((C_word)errno),C_fix((C_word)EINTR));
if(C_truep(t4)){
/* posixunix.scm:1048: loop */
t5=((C_word*)((C_word*)t0)[3])[1];
f_7412(t5,((C_word*)t0)[2]);}
else{
/* posixunix.scm:1019: posix-error */
t5=lf[192];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t5;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[197];
av2[3]=lf[421];
av2[4]=lf[422];
av2[5]=((C_word*)t0)[4];
f_3238(6,av2);}}}}

/* chicken.file.posix#create-fifo in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7437(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +5,c,3)))){
C_save_and_reclaim((void*)f_7437,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+5);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
t4=C_i_check_string_2(t2,lf[423]);
t5=C_i_pairp(t3);
t6=(C_truep(t5)?C_get_rest_arg(c,3,av,3,t0):C_fixnum_or(C_fix((C_word)S_IRUSR | S_IWUSR | S_IXUSR),C_fixnum_or(C_fix((C_word)S_IRGRP | S_IWGRP | S_IXGRP),C_fix((C_word)S_IROTH | S_IWOTH | S_IXOTH))));
t7=C_i_check_fixnum_2(t6,lf[423]);
t8=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7461,a[2]=t6,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1059: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[199]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[199]+1);
av2[1]=t8;
av2[2]=t2;
av2[3]=lf[423];
tp(4,av2);}}

/* k7459 in chicken.file.posix#create-fifo in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7461(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_7461,c,av);}
if(C_truep(C_fixnum_lessp(C_mkfifo(t1,((C_word*)t0)[2]),C_fix(0)))){
/* posixunix.scm:1060: posix-error */
t2=lf[192];{
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[197];
av2[3]=lf[423];
av2[4]=lf[424];
av2[5]=((C_word*)t0)[4];
av2[6]=((C_word*)t0)[2];
f_3238(7,av2);}}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* chicken.time.posix#string->time in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7483(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_7483,c,av);}
a=C_alloc(5);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?lf[425]:C_get_rest_arg(c,3,av,3,t0));
t5=C_i_check_string_2(t2,lf[426]);
t6=C_i_check_string_2(t4,lf[426]);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7500,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=t4,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1071: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[199]+1));
C_word av2[4];
av2[0]=*((C_word*)lf[199]+1);
av2[1]=t7;
av2[2]=t2;
av2[3]=lf[426];
tp(4,av2);}}

/* k7498 in chicken.time.posix#string->time in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7500(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_7500,c,av);}
a=C_alloc(5);
t2=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7504,a[2]=((C_word*)t0)[2],a[3]=t1,a[4]=((C_word*)t0)[3],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1071: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[199]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[199]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
tp(3,av2);}}

/* k7502 in k7498 in chicken.time.posix#string->time in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7504(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(17,c,3)))){
C_save_and_reclaim((void *)f_7504,c,av);}
a=C_alloc(17);
t2=C_a_i_vector(&a,10,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE);
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7512,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=t1,a[5]=t2,tmp=(C_word)a,a+=6,tmp);
/* posixunix.scm:1071: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[274]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[274]+1);
av2[1]=t3;
av2[2]=((C_word*)t0)[4];
av2[3]=C_make_character(0);
tp(4,av2);}}

/* k7510 in k7502 in k7498 in chicken.time.posix#string->time in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7512(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_7512,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=(C_truep(t1)?stub2137(C_SCHEME_UNDEFINED,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],C_i_foreign_block_argumentp(t1)):stub2137(C_SCHEME_UNDEFINED,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],C_SCHEME_FALSE));
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.time.posix#utc-time->seconds in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7520(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_7520,c,av);}
a=C_alloc(5);
t3=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7524,a[2]=t2,a[3]=t1,a[4]=((C_word*)t0)[2],tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1076: check-time-vector */
f_3986(t3,lf[427],t2);}

/* k7522 in chicken.time.posix#utc-time->seconds in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7524(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_7524,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7528,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1077: ##sys#make-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[274]+1));
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=*((C_word*)lf[274]+1);
av2[1]=t2;
av2[2]=((C_word*)t0)[4];
av2[3]=C_make_character(0);
tp(4,av2);}}

/* k7526 in k7522 in chicken.time.posix#utc-time->seconds in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7528(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,4)))){
C_save_and_reclaim((void *)f_7528,c,av);}
a=C_alloc(7);
t2=C_a_timegm(&a,2,((C_word*)t0)[2],t1);
if(C_truep(C_i_nequalp(C_fix(-1),t2))){
/* posixunix.scm:1079: ##sys#error */
t3=*((C_word*)lf[94]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[427];
av2[3]=lf[428];
av2[4]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}
else{
t3=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* chicken.time.posix#local-timezone-abbreviation in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7539(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,3)))){
C_save_and_reclaim((void *)f_7539,c,av);}
a=C_alloc(5);
t2=C_a_i_bytevector(&a,1,C_fix(3));
/* posixunix.scm:1083: ##sys#peek-c-string */
t3=*((C_word*)lf[194]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t3;
av2[1]=t1;
av2[2]=stub2164(t2);
av2[3]=C_fix(0);
((C_proc)(void*)(*((C_word*)t3+1)))(4,av2);}}

/* chicken.process.signal#set-alarm! in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7546(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_7546,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=stub2168(C_SCHEME_UNDEFINED,C_i_foreign_fixnum_argumentp(t2));
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* chicken.process#process-fork in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7558(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(14,c,4)))){
C_save_and_reclaim((void *)f_7558,c,av);}
a=C_alloc(14);
t2=C_rest_nullp(c,2);
t3=(C_truep(t2)?C_SCHEME_FALSE:C_get_rest_arg(c,2,av,2,t0));
t4=C_rest_nullp(c,2);
t5=C_rest_nullp(c,3);
t6=(C_truep(t5)?C_SCHEME_FALSE:C_get_rest_arg(c,3,av,2,t0));
t7=C_rest_nullp(c,3);
t8=stub2198(C_SCHEME_UNDEFINED,C_SCHEME_FALSE);
t9=stub2178(C_SCHEME_UNDEFINED);
t10=C_eqp(C_fix(-1),t9);
if(C_truep(t10)){
/* posixunix.scm:1117: posix-error */
t11=lf[192];{
C_word av2[5];
av2[0]=t11;
av2[1]=t1;
av2[2]=lf[90];
av2[3]=lf[429];
av2[4]=lf[430];
f_3238(5,av2);}}
else{
t11=C_eqp(C_fix(0),t9);
if(C_truep(t11)){
t12=lf[287] /* chicken.posix#children */ =C_SCHEME_END_OF_LIST;;
t13=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7605,a[2]=t3,a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(t6)){
t14=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7625,a[2]=((C_word)li180),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1121: scheme#call-with-current-continuation */
t15=*((C_word*)lf[307]+1);{
C_word av2[3];
av2[0]=t15;
av2[1]=t13;
av2[2]=t14;
((C_proc)(void*)(*((C_word*)t15+1)))(3,av2);}}
else{
t14=t13;{
C_word *av2=av;
av2[0]=t14;
av2[1]=C_SCHEME_UNDEFINED;
f_7605(2,av2);}}}
else{
t12=C_a_i_record7(&a,7,lf[289],t9,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE,C_SCHEME_FALSE);
t13=C_a_i_cons(&a,2,t9,t12);
t14=C_a_i_cons(&a,2,t13,lf[287]);
t15=C_mutate(&lf[287] /* (set! chicken.posix#children ...) */,t14);
t16=t1;{
C_word *av2=av;
av2[0]=t16;
av2[1]=t12;
((C_proc)(void*)(*((C_word*)t16+1)))(2,av2);}}}}

/* k7603 in chicken.process#process-fork in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7605(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_7605,c,av);}
a=C_alloc(4);
if(C_truep(((C_word*)t0)[2])){
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7613,a[2]=((C_word*)t0)[2],a[3]=((C_word)li178),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1123: ##sys#call-with-cthulhu */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[432]+1));
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=*((C_word*)lf[432]+1);
av2[1]=((C_word*)t0)[3];
av2[2]=t2;
tp(3,av2);}}
else{
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* a7612 in k7603 in chicken.process#process-fork in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7613(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_7613,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7617,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1125: thunk */
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)C_fast_retrieve_proc(t3))(2,av2);}}

/* k7615 in a7612 in k7603 in chicken.process#process-fork in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7617(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_7617,c,av);}
/* posixunix.scm:1129: chicken.base#exit */
t2=*((C_word*)lf[431]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=C_fix(0);
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* a7624 in chicken.process#process-fork in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7625(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_7625,c,av);}
a=C_alloc(4);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7631,a[2]=t2,a[3]=((C_word)li179),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1121: ##sys#kill-other-threads */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[433]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[433]+1);
av2[1]=t1;
av2[2]=t3;
tp(3,av2);}}

/* a7630 in a7624 in chicken.process#process-fork in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7631(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_7631,c,av);}
/* posixunix.scm:1121: continue */
t2=((C_word*)t0)[2];{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=t1;
av2[2]=C_SCHEME_FALSE;
((C_proc)C_fast_retrieve_proc(t2))(3,av2);}}

/* chicken.process#process-execute in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7664(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(7,c,7)))){
C_save_and_reclaim((void *)f_7664,c,av);}
a=C_alloc(7);
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_SCHEME_END_OF_LIST:C_get_rest_arg(c,3,av,3,t0));
t5=C_rest_nullp(c,3);
t6=C_rest_nullp(c,4);
t7=(C_truep(t6)?C_SCHEME_FALSE:C_get_rest_arg(c,4,av,3,t0));
t8=C_rest_nullp(c,4);
t9=C_rest_nullp(c,5);
t10=(C_truep(t9)?C_SCHEME_FALSE:C_get_rest_arg(c,5,av,3,t0));
t11=C_rest_nullp(c,5);
t12=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7688,a[2]=((C_word)li182),tmp=(C_word)a,a+=3,tmp);
t13=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7691,a[2]=t2,a[3]=((C_word)li183),tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1136: call-with-exec-args */
t14=lf[313];
f_4848(t14,t1,lf[434],t2,t12,t4,t7,t13);}

/* a7687 in chicken.process#process-execute in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7688(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_7688,c,av);}
t3=t1;{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}

/* a7690 in chicken.process#process-execute in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7691(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(c!=5) C_bad_argc_2(c,5,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_7691,c,av);}
t5=(C_truep(t4)?C_u_i_execve(t2,t3,t4):C_u_i_execvp(t2,t3));
t6=C_eqp(t5,C_fix(-1));
if(C_truep(t6)){
/* posixunix.scm:1143: posix-error */
t7=lf[192];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t7;
av2[1]=t1;
av2[2]=lf[90];
av2[3]=lf[434];
av2[4]=lf[435];
av2[5]=((C_word*)t0)[2];
f_3238(6,av2);}}
else{
t7=C_SCHEME_UNDEFINED;
t8=t1;{
C_word *av2=av;
av2[0]=t8;
av2[1]=t7;
((C_proc)(void*)(*((C_word*)t8+1)))(2,av2);}}}

/* chicken.posix#process-wait-impl in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void f_7742(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,4)))){
C_save_and_reclaim_args((void *)trf_7742,3,t1,t2,t3);}
a=C_alloc(5);
t4=(C_truep(t3)?C_fix((C_word)WNOHANG):C_fix(0));
t5=C_waitpid(t2,t4);
t6=C_WIFEXITED(C_fix((C_word)C_wait_status));
t7=C_eqp(t5,C_fix(-1));
t8=(C_truep(t7)?C_eqp(C_fix((C_word)errno),C_fix((C_word)EINTR)):C_SCHEME_FALSE);
if(C_truep(t8)){
t9=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7758,a[2]=t2,a[3]=t3,a[4]=((C_word)li185),tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1152: ##sys#dispatch-interrupt */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[338]+1));
C_word av2[3];
av2[0]=*((C_word*)lf[338]+1);
av2[1]=t1;
av2[2]=t9;
tp(3,av2);}}
else{
if(C_truep(t6)){
/* posixunix.scm:1154: scheme#values */{
C_word av2[5];
av2[0]=0;
av2[1]=t1;
av2[2]=t5;
av2[3]=t6;
av2[4]=C_WEXITSTATUS(C_fix((C_word)C_wait_status));
C_values(5,av2);}}
else{
if(C_truep(C_WIFSIGNALED(C_fix((C_word)C_wait_status)))){
/* posixunix.scm:1154: scheme#values */{
C_word av2[5];
av2[0]=0;
av2[1]=t1;
av2[2]=t5;
av2[3]=t6;
av2[4]=C_WTERMSIG(C_fix((C_word)C_wait_status));
C_values(5,av2);}}
else{
/* posixunix.scm:1154: scheme#values */{
C_word av2[5];
av2[0]=0;
av2[1]=t1;
av2[2]=t5;
av2[3]=t6;
av2[4]=C_WSTOPSIG(C_fix((C_word)C_wait_status));
C_values(5,av2);}}}}}

/* a7757 in chicken.posix#process-wait-impl in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7758(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_7758,c,av);}
/* posixunix.scm:1153: process-wait-impl */
f_7742(t1,((C_word*)t0)[2],((C_word*)t0)[3]);}

/* chicken.process-context.posix#parent-process-id in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7780(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_7780,c,av);}
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=stub2246(C_SCHEME_UNDEFINED);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* chicken.process#process-signal in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7783(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +5,c,2)))){
C_save_and_reclaim((void*)f_7783,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+5);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
t4=C_i_pairp(t3);
t5=(C_truep(t4)?C_get_rest_arg(c,3,av,3,t0):C_fix((C_word)SIGTERM));
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7790,a[2]=t5,a[3]=t1,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
if(C_truep(C_i_structurep(t2,lf[289]))){
t7=C_SCHEME_UNDEFINED;
t8=t6;
f_7790(t8,C_i_block_ref(t2,C_fix(1)));}
else{
t7=t6;
f_7790(t7,t2);}}

/* k7788 in chicken.process#process-signal in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void f_7790(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,0,6)))){
C_save_and_reclaim_args((void *)trf_7790,2,t0,t1);}
t2=C_i_check_fixnum_2(t1,lf[436]);
t3=C_i_check_fixnum_2(((C_word*)t0)[2],lf[436]);
t4=C_kill(t1,((C_word*)t0)[2]);
t5=C_eqp(t4,C_fix(-1));
if(C_truep(t5)){
/* posixunix.scm:1172: posix-error */
t6=lf[192];{
C_word av2[7];
av2[0]=t6;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[90];
av2[3]=lf[436];
av2[4]=lf[437];
av2[5]=((C_word*)t0)[4];
av2[6]=((C_word*)t0)[2];
f_3238(7,av2);}}
else{
t6=C_SCHEME_UNDEFINED;
t7=((C_word*)t0)[3];{
C_word av2[2];
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* chicken.process#process-run in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7832(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand((c-3)*C_SIZEOF_PAIR +5,c,2)))){
C_save_and_reclaim((void*)f_7832,c,av);}
a=C_alloc((c-3)*C_SIZEOF_PAIR+5);
t3=C_build_rest(&a,c,3,av);
C_word t4;
C_word t5;
C_word t6;
C_word t7;
t4=C_i_pairp(t3);
t5=(C_truep(t4)?C_get_rest_arg(c,3,av,3,t0):C_SCHEME_FALSE);
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7839,a[2]=t1,a[3]=t5,a[4]=t2,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1184: chicken.process#process-fork */
t7=*((C_word*)lf[107]+1);{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* k7837 in chicken.process#process-run in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7839(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_7839,c,av);}
a=C_alloc(4);
if(C_truep(t1)){
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}
else{
if(C_truep(((C_word*)t0)[3])){
/* posixunix.scm:1186: chicken.process#process-execute */
t2=*((C_word*)lf[106]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[4];
av2[3]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}
else{
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f9684,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[2],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1176: chicken.process-context#get-environment-variable */
t3=*((C_word*)lf[440]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[441];
((C_proc)(void*)(*((C_word*)t3+1)))(3,av2);}}}}

/* k7873 in k7945 in connect-child in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7875(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,2)))){
C_save_and_reclaim((void *)f_7875,c,av);}
/* posixunix.scm:1216: chicken.file.posix#file-close */
t2=*((C_word*)lf[11]+1);{
C_word *av2;
if(c >= 3) {
  av2=av;
} else {
  av2=C_alloc(3);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(3,av2);}}

/* make-on-close in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void f_7879(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6){
C_word tmp;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,2)))){
C_save_and_reclaim_args((void *)trf_7879,6,t1,t2,t3,t4,t5,t6);}
a=C_alloc(8);
t7=t1;{
C_word av2[2];
av2[0]=t7;
av2[1]=(*a=C_CLOSURE_TYPE|7,a[1]=(C_word)f_7881,a[2]=t3,a[3]=t4,a[4]=t5,a[5]=t6,a[6]=t2,a[7]=((C_word)li190),tmp=(C_word)a,a+=8,tmp);
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}

/* f_7881 in make-on-close in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7881(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_7881,c,av);}
a=C_alloc(3);
t2=C_i_vector_set(((C_word*)t0)[2],((C_word*)t0)[3],C_SCHEME_TRUE);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7888,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
if(C_truep(C_i_vector_ref(((C_word*)t0)[2],((C_word*)t0)[4]))){
if(C_truep(C_i_vector_ref(((C_word*)t0)[2],((C_word*)t0)[5]))){
/* posixunix.scm:1222: chicken.process#process-wait */
t4=*((C_word*)lf[111]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[6];
av2[3]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}
else{
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=*((C_word*)lf[442]+1);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}
else{
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=*((C_word*)lf[442]+1);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k7886 */
static void C_ccall f_7888(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_7888,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=*((C_word*)lf[442]+1);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* needed-pipe in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void f_7904(C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,0,4)))){
C_save_and_reclaim_args((void *)trf_7904,2,t1,t2);}
a=C_alloc(6);
if(C_truep(t2)){
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7913,a[2]=((C_word)li192),tmp=(C_word)a,a+=3,tmp);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7919,a[2]=((C_word)li193),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1227: ##sys#call-with-values */{
C_word av2[4];
av2[0]=0;
av2[1]=t1;
av2[2]=t3;
av2[3]=t4;
C_call_with_values(4,av2);}}
else{
t3=t1;{
C_word av2[2];
av2[0]=t3;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* a7912 in needed-pipe in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7913(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_7913,c,av);}
/* posixunix.scm:1227: chicken.process#create-pipe */
t2=*((C_word*)lf[116]+1);{
C_word *av2=av;
av2[0]=t2;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* a7918 in needed-pipe in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7919(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,1)))){
C_save_and_reclaim((void *)f_7919,c,av);}
a=C_alloc(3);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_a_i_cons(&a,2,t2,t3);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* connect-parent in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void f_7924(C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,0,2)))){
C_save_and_reclaim_args((void *)trf_7924,3,t1,t2,t3);}
a=C_alloc(4);
if(C_truep(t3)){
t4=C_i_car(t2);
t5=C_u_i_cdr(t2);
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7935,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1233: chicken.file.posix#file-close */
t7=*((C_word*)lf[11]+1);{
C_word av2[3];
av2[0]=t7;
av2[1]=t6;
av2[2]=t5;
((C_proc)(void*)(*((C_word*)t7+1)))(3,av2);}}
else{
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}}

/* k7933 in connect-parent in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7935(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_7935,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* connect-child in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void f_7936(C_word t1,C_word t2,C_word t3,C_word t4){
C_word tmp;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,2)))){
C_save_and_reclaim_args((void *)trf_7936,4,t1,t2,t3,t4);}
a=C_alloc(5);
if(C_truep(t3)){
t5=C_i_car(t2);
t6=C_u_i_cdr(t2);
t7=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_7947,a[2]=t4,a[3]=t5,a[4]=t1,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:1239: chicken.file.posix#file-close */
t8=*((C_word*)lf[11]+1);{
C_word av2[3];
av2[0]=t8;
av2[1]=t7;
av2[2]=t6;
((C_proc)(void*)(*((C_word*)t8+1)))(3,av2);}}
else{
t5=C_SCHEME_UNDEFINED;
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k7945 in connect-child in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7947(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,3)))){
C_save_and_reclaim((void *)f_7947,c,av);}
a=C_alloc(4);
t2=C_eqp(((C_word*)t0)[2],((C_word*)t0)[3]);
if(C_truep(t2)){
t3=C_SCHEME_UNDEFINED;
t4=((C_word*)t0)[4];{
C_word *av2=av;
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_7875,a[2]=((C_word*)t0)[4],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1215: chicken.file.posix#duplicate-fileno */
t4=*((C_word*)lf[5]+1);{
C_word *av2;
if(c >= 4) {
  av2=av;
} else {
  av2=C_alloc(4);
}
av2[0]=t4;
av2[1]=t3;
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t4+1)))(4,av2);}}}

/* spawn in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void f_7965(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,0,2)))){
C_save_and_reclaim_args((void *)trf_7965,8,t0,t1,t2,t3,t4,t5,t6,t7);}
a=C_alloc(3);
t8=C_mutate(((C_word *)t0)+8,t7);
t9=C_mutate(((C_word *)t0)+10,t6);
t10=C_mutate(((C_word *)t0)+9,t5);
t11=C_mutate(((C_word *)t0)+6,t4);
t12=C_mutate(((C_word *)t0)+5,t3);
t13=C_mutate(((C_word *)t0)+4,t2);
t14=C_mutate(((C_word *)t0)+2,t1);
t15=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7969,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1248: needed-pipe */
f_7904(t15,((C_word*)t0)[10]);}

/* k7967 in spawn in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7969(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void *)f_7969,c,av);}
a=C_alloc(3);
t2=((C_word*)t0)[2];
t3=C_mutate(((C_word *)t2)+3,t1);
t4=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7972,a[2]=t2,tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:1249: needed-pipe */
f_7904(t4,((C_word*)t2)[9]);}

/* k7970 in k7967 in spawn in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7972(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(13,c,2)))){
C_save_and_reclaim((void *)f_7972,c,av);}
a=C_alloc(13);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_7975,a[2]=((C_word*)t2)[2],a[3]=((C_word*)t2)[3],a[4]=C_SCHEME_UNDEFINED,a[5]=((C_word*)t2)[4],a[6]=((C_word*)t2)[5],a[7]=((C_word*)t2)[6],a[8]=((C_word*)t2)[7],a[9]=((C_word*)t2)[8],a[10]=((C_word*)t2)[9],a[11]=t1,a[12]=((C_word*)t2)[10],tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm:1250: needed-pipe */
f_7904(t3,((C_word*)t2)[8]);}

/* k7973 in k7970 in k7967 in spawn in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7975(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(6,c,2)))){
C_save_and_reclaim((void *)f_7975,c,av);}
a=C_alloc(6);
t2=C_mutate(((C_word *)t0)+4,t1);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_7982,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
if(C_truep(((C_word*)t0)[11])){
t4=C_i_cdr(((C_word*)t0)[11]);
t5=C_u_i_car(((C_word*)t0)[11]);
t6=t3;
f_7982(t6,C_a_i_cons(&a,2,t4,t5));}
else{
t4=t3;
f_7982(t4,C_SCHEME_FALSE);}}

/* k7980 in k7973 in k7970 in k7967 in spawn in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void f_7982(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(19,0,2)))){
C_save_and_reclaim_args((void *)trf_7982,2,t0,t1);}
a=C_alloc(19);
t2=((C_word*)t0)[2];
t3=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7986,a[2]=((C_word*)t2)[2],a[3]=((C_word*)t2)[3],a[4]=t1,a[5]=((C_word*)t2)[4],tmp=(C_word)a,a+=6,tmp);
t4=(*a=C_CLOSURE_TYPE|12,a[1]=(C_word)f_7988,a[2]=((C_word*)t2)[5],a[3]=((C_word*)t2)[6],a[4]=((C_word*)t2)[7],a[5]=((C_word*)t2)[4],a[6]=((C_word*)t2)[8],a[7]=((C_word*)t2)[9],a[8]=((C_word*)t2)[3],a[9]=((C_word*)t2)[10],a[10]=((C_word*)t2)[11],a[11]=((C_word*)t2)[12],a[12]=((C_word)li197),tmp=(C_word)a,a+=13,tmp);
/* posixunix.scm:1253: chicken.process#process-fork */
t5=*((C_word*)lf[107]+1);{
C_word av2[3];
av2[0]=t5;
av2[1]=t3;
av2[2]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}

/* k7984 in k7980 in k7973 in k7970 in k7967 in spawn in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7986(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_7986,c,av);}
/* posixunix.scm:1251: scheme#values */{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=0;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
av2[4]=((C_word*)t0)[5];
av2[5]=t1;
C_values(6,av2);}}

/* a7987 in k7980 in k7973 in k7970 in k7967 in spawn in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7988(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(11,c,4)))){
C_save_and_reclaim((void *)f_7988,c,av);}
a=C_alloc(11);
t2=(*a=C_CLOSURE_TYPE|10,a[1]=(C_word)f_7992,a[2]=t1,a[3]=((C_word*)t0)[2],a[4]=((C_word*)t0)[3],a[5]=((C_word*)t0)[4],a[6]=((C_word*)t0)[5],a[7]=((C_word*)t0)[6],a[8]=((C_word*)t0)[7],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],tmp=(C_word)a,a+=11,tmp);
/* posixunix.scm:1255: connect-child */
f_7936(t2,((C_word*)t0)[10],((C_word*)t0)[11],*((C_word*)lf[37]+1));}

/* k7990 in a7987 in k7980 in k7973 in k7970 in k7967 in spawn in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7992(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(12,c,4)))){
C_save_and_reclaim((void *)f_7992,c,av);}
a=C_alloc(12);
t2=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_7995,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
if(C_truep(((C_word*)t0)[9])){
t3=C_i_cdr(((C_word*)t0)[9]);
t4=C_u_i_car(((C_word*)t0)[9]);
t5=C_a_i_cons(&a,2,t3,t4);
/* posixunix.scm:1256: connect-child */
f_7936(t2,t5,((C_word*)t0)[10],*((C_word*)lf[38]+1));}
else{
/* posixunix.scm:1256: connect-child */
f_7936(t2,C_SCHEME_FALSE,((C_word*)t0)[10],*((C_word*)lf[38]+1));}}

/* k7993 in k7990 in a7987 in k7980 in k7973 in k7970 in k7967 in spawn in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7995(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(9,c,4)))){
C_save_and_reclaim((void *)f_7995,c,av);}
a=C_alloc(9);
t2=(*a=C_CLOSURE_TYPE|5,a[1]=(C_word)f_7998,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],tmp=(C_word)a,a+=6,tmp);
if(C_truep(((C_word*)t0)[6])){
t3=C_i_cdr(((C_word*)t0)[6]);
t4=C_u_i_car(((C_word*)t0)[6]);
t5=C_a_i_cons(&a,2,t3,t4);
/* posixunix.scm:1257: connect-child */
f_7936(t2,t5,((C_word*)t0)[8],*((C_word*)lf[36]+1));}
else{
/* posixunix.scm:1257: connect-child */
f_7936(t2,C_SCHEME_FALSE,((C_word*)t0)[8],*((C_word*)lf[36]+1));}}

/* k7996 in k7993 in k7990 in a7987 in k7980 in k7973 in k7970 in k7967 in spawn in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_7998(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_7998,c,av);}
/* posixunix.scm:1258: chicken.process#process-execute */
t2=*((C_word*)lf[106]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
av2[4]=((C_word*)t0)[5];
((C_proc)(void*)(*((C_word*)t2+1)))(5,av2);}}

/* input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void f_8010(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,3)))){
C_save_and_reclaim_args((void *)trf_8010,8,t0,t1,t2,t3,t4,t5,t6,t7);}
a=C_alloc(7);
t8=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_8014,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t6,a[6]=t7,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1261: connect-parent */
f_7924(t8,t4,t5);}

/* k8012 in input-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8014(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,9)))){
C_save_and_reclaim((void *)f_8014,c,av);}
if(C_truep(t1)){
/* posixunix.scm:1262: ##sys#custom-input-port */
t2=*((C_word*)lf[389]+1);{
C_word *av2;
if(c >= 10) {
  av2=av;
} else {
  av2=C_alloc(10);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
av2[4]=t1;
av2[5]=C_SCHEME_TRUE;
av2[6]=C_fix(256);
av2[7]=((C_word*)t0)[5];
av2[8]=C_SCHEME_FALSE;
av2[9]=((C_word*)t0)[6];
((C_proc)(void*)(*((C_word*)t2+1)))(10,av2);}}
else{
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* output-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void f_8021(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,0,3)))){
C_save_and_reclaim_args((void *)trf_8021,8,t0,t1,t2,t3,t4,t5,t6,t7);}
a=C_alloc(7);
t8=(*a=C_CLOSURE_TYPE|6,a[1]=(C_word)f_8025,a[2]=t1,a[3]=t2,a[4]=t3,a[5]=t6,a[6]=t7,tmp=(C_word)a,a+=7,tmp);
/* posixunix.scm:1265: connect-parent */
f_7924(t8,t4,t5);}

/* k8023 in output-port in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8025(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,8)))){
C_save_and_reclaim((void *)f_8025,c,av);}
if(C_truep(t1)){
/* posixunix.scm:1266: ##sys#custom-output-port */
t2=*((C_word*)lf[409]+1);{
C_word *av2;
if(c >= 9) {
  av2=av;
} else {
  av2=C_alloc(9);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=((C_word*)t0)[3];
av2[3]=((C_word*)t0)[4];
av2[4]=t1;
av2[5]=C_SCHEME_TRUE;
av2[6]=C_fix(0);
av2[7]=((C_word*)t0)[5];
av2[8]=((C_word*)t0)[6];
((C_proc)(void*)(*((C_word*)t2+1)))(9,av2);}}
else{
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_SCHEME_FALSE;
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}}

/* chicken.posix#process-impl in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void f_8032(C_word t0,C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7,C_word t8,C_word t9){
C_word tmp;
C_word t10;
C_word t11;
C_word t12;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(22,0,6)))){
C_save_and_reclaim_args((void *)trf_8032,10,t0,t1,t2,t3,t4,t5,t6,t7,t8,t9);}
a=C_alloc(22);
t10=(*a=C_CLOSURE_TYPE|9,a[1]=(C_word)f_8038,a[2]=((C_word*)t0)[2],a[3]=t3,a[4]=t4,a[5]=t5,a[6]=t6,a[7]=t7,a[8]=t8,a[9]=((C_word)li201),tmp=(C_word)a,a+=10,tmp);
t11=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_8044,a[2]=t7,a[3]=t6,a[4]=t8,a[5]=((C_word*)t0)[3],a[6]=t2,a[7]=t3,a[8]=t9,a[9]=((C_word*)t0)[4],a[10]=((C_word*)t0)[5],a[11]=((C_word)li202),tmp=(C_word)a,a+=12,tmp);
/* posixunix.scm:1268: ##sys#call-with-values */{
C_word av2[4];
av2[0]=0;
av2[1]=t1;
av2[2]=t10;
av2[3]=t11;
C_call_with_values(4,av2);}}

/* a8037 in chicken.posix#process-impl in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8038(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,7)))){
C_save_and_reclaim((void *)f_8038,c,av);}
/* posixunix.scm:1269: spawn */
t2=((C_word*)t0)[2];
f_7965(t2,t1,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[7],((C_word*)t0)[8]);}

/* a8043 in chicken.posix#process-impl in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8044(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4=av[4];
C_word t5=av[5];
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word *a;
if(c!=6) C_bad_argc_2(c,6,t0);
if(C_unlikely(!C_demand(C_calculate_demand(32,c,6)))){
C_save_and_reclaim((void *)f_8044,c,av);}
a=C_alloc(32);
t6=C_i_not(((C_word*)t0)[2]);
t7=C_i_not(((C_word*)t0)[3]);
t8=C_i_not(((C_word*)t0)[4]);
t9=C_a_i_vector3(&a,3,t6,t7,t8);
t10=(*a=C_CLOSURE_TYPE|14,a[1]=(C_word)f_8051,a[2]=t1,a[3]=t5,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=t4,a[8]=((C_word*)t0)[4],a[9]=((C_word*)t0)[8],a[10]=((C_word*)t0)[9],a[11]=t9,a[12]=((C_word*)t0)[10],a[13]=t3,a[14]=((C_word*)t0)[3],tmp=(C_word)a,a+=15,tmp);
t11=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8077,a[2]=t5,a[3]=t10,tmp=(C_word)a,a+=4,tmp);
t12=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_8081,a[2]=((C_word*)t0)[5],a[3]=t11,a[4]=((C_word*)t0)[6],a[5]=((C_word*)t0)[7],a[6]=t2,a[7]=((C_word*)t0)[2],a[8]=((C_word*)t0)[8],tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm:1277: make-on-close */
f_7879(t12,t5,t9,C_fix(0),C_fix(1),C_fix(2));}

/* k8049 in a8043 in chicken.posix#process-impl in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8051(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(25,c,6)))){
C_save_and_reclaim((void *)f_8051,c,av);}
a=C_alloc(25);
t2=(*a=C_CLOSURE_TYPE|11,a[1]=(C_word)f_8054,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],a[4]=((C_word*)t0)[4],a[5]=((C_word*)t0)[5],a[6]=((C_word*)t0)[6],a[7]=((C_word*)t0)[7],a[8]=((C_word*)t0)[8],a[9]=((C_word*)t0)[9],a[10]=((C_word*)t0)[10],a[11]=((C_word*)t0)[11],tmp=(C_word)a,a+=12,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8069,a[2]=((C_word*)t0)[3],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_8073,a[2]=((C_word*)t0)[12],a[3]=t3,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[13],a[7]=((C_word*)t0)[14],a[8]=((C_word*)t0)[9],tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm:1282: make-on-close */
f_7879(t4,((C_word*)t0)[3],((C_word*)t0)[11],C_fix(1),C_fix(0),C_fix(2));}

/* k8052 in k8049 in a8043 in chicken.posix#process-impl in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8054(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(17,c,6)))){
C_save_and_reclaim((void *)f_8054,c,av);}
a=C_alloc(17);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8057,a[2]=((C_word*)t0)[2],a[3]=((C_word*)t0)[3],tmp=(C_word)a,a+=4,tmp);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8061,a[2]=((C_word*)t0)[3],a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_8065,a[2]=((C_word*)t0)[4],a[3]=t3,a[4]=((C_word*)t0)[5],a[5]=((C_word*)t0)[6],a[6]=((C_word*)t0)[7],a[7]=((C_word*)t0)[8],a[8]=((C_word*)t0)[9],tmp=(C_word)a,a+=9,tmp);
/* posixunix.scm:1287: make-on-close */
f_7879(t4,((C_word*)t0)[3],((C_word*)t0)[11],C_fix(2),C_fix(0),C_fix(1));}

/* k8055 in k8052 in k8049 in a8043 in chicken.posix#process-impl in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8057(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8057,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k8059 in k8052 in k8049 in a8043 in chicken.posix#process-impl in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8061(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_8061,c,av);}
t2=C_i_check_structure(((C_word*)t0)[2],lf[289]);
/* posix-common.scm:682: ##sys#block-set! */
t3=*((C_word*)lf[300]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[2];
av2[3]=C_fix(5);
av2[4]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}

/* k8063 in k8052 in k8049 in a8043 in chicken.posix#process-impl in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8065(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,7)))){
C_save_and_reclaim((void *)f_8065,c,av);}
/* posixunix.scm:1285: input-port */
t2=((C_word*)t0)[2];
f_8010(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[7],t1,((C_word*)t0)[8]);}

/* k8067 in k8049 in a8043 in chicken.posix#process-impl in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8069(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_8069,c,av);}
t2=C_i_check_structure(((C_word*)t0)[2],lf[289]);
/* posix-common.scm:682: ##sys#block-set! */
t3=*((C_word*)lf[300]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[2];
av2[3]=C_fix(3);
av2[4]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}

/* k8071 in k8049 in a8043 in chicken.posix#process-impl in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8073(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,7)))){
C_save_and_reclaim((void *)f_8073,c,av);}
/* posixunix.scm:1280: output-port */
t2=((C_word*)t0)[2];
f_8021(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[7],t1,((C_word*)t0)[8]);}

/* k8075 in a8043 in chicken.posix#process-impl in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8077(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,4)))){
C_save_and_reclaim((void *)f_8077,c,av);}
t2=C_i_check_structure(((C_word*)t0)[2],lf[289]);
/* posix-common.scm:682: ##sys#block-set! */
t3=*((C_word*)lf[300]+1);{
C_word *av2;
if(c >= 5) {
  av2=av;
} else {
  av2=C_alloc(5);
}
av2[0]=t3;
av2[1]=((C_word*)t0)[3];
av2[2]=((C_word*)t0)[2];
av2[3]=C_fix(4);
av2[4]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(5,av2);}}

/* k8079 in a8043 in chicken.posix#process-impl in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8081(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,7)))){
C_save_and_reclaim((void *)f_8081,c,av);}
/* posixunix.scm:1275: input-port */
t2=((C_word*)t0)[2];
f_8010(t2,((C_word*)t0)[3],((C_word*)t0)[4],((C_word*)t0)[5],((C_word*)t0)[6],((C_word*)t0)[7],t1,((C_word*)t0)[8]);}

/* %process in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void f_8094(C_word t1,C_word t2,C_word t3,C_word t4,C_word t5,C_word t6,C_word t7){
C_word tmp;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(27,0,3)))){
C_save_and_reclaim_args((void *)trf_8094,7,t1,t2,t3,t4,t5,t6,t7);}
a=C_alloc(27);
t8=(*a=C_VECTOR_TYPE|1,a[1]=t4,tmp=(C_word)a,a+=2,tmp);
t9=(*a=C_VECTOR_TYPE|1,a[1]=t5,tmp=(C_word)a,a+=2,tmp);
t10=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8096,a[2]=t2,a[3]=((C_word)li206),tmp=(C_word)a,a+=4,tmp);
t11=C_i_check_string_2(((C_word*)t8)[1],t2);
t12=(*a=C_CLOSURE_TYPE|8,a[1]=(C_word)f_8137,a[2]=t1,a[3]=t2,a[4]=t8,a[5]=t9,a[6]=t6,a[7]=t3,a[8]=t7,tmp=(C_word)a,a+=9,tmp);
if(C_truep(((C_word*)t9)[1])){
/* posixunix.scm:1302: chkstrlst */
t13=t10;
f_8096(t13,t12,((C_word*)t9)[1]);}
else{
t13=((C_word*)t8)[1];
t14=C_a_i_list2(&a,2,lf[439],t13);
t15=C_set_block_item(t9,0,t14);
t16=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f9690,a[2]=t8,a[3]=t12,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1176: chicken.process-context#get-environment-variable */
t17=*((C_word*)lf[440]+1);{
C_word av2[3];
av2[0]=t17;
av2[1]=t16;
av2[2]=lf[441];
((C_proc)(void*)(*((C_word*)t17+1)))(3,av2);}}}

/* chkstrlst in %process in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void f_8096(C_word t0,C_word t1,C_word t2){
C_word tmp;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(8,0,2)))){
C_save_and_reclaim_args((void *)trf_8096,3,t0,t1,t2);}
a=C_alloc(8);
t3=C_i_check_list_2(t2,((C_word*)t0)[2]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8101,a[2]=((C_word*)t0)[2],a[3]=((C_word)li204),tmp=(C_word)a,a+=4,tmp);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8110,a[2]=t4,a[3]=((C_word)li205),tmp=(C_word)a,a+=4,tmp);
t6=t1;{
C_word av2[2];
av2[0]=t6;
av2[1]=(
  f_8110(t5,t2)
);
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}

/* g2376 in chkstrlst in %process in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static C_word f_8101(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_stack_overflow_check;{}
return(C_i_check_string_2(t1,((C_word*)t0)[2]));}

/* for-each-loop2375 in chkstrlst in %process in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static C_word f_8110(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_stack_overflow_check;
loop:{}
if(C_truep(C_i_pairp(t1))){
t2=(
/* posixunix.scm:1299: g2376 */
  f_8101(((C_word*)t0)[2],C_slot(t1,C_fix(0)))
);
t4=C_slot(t1,C_fix(1));
t1=t4;
goto loop;}
else{
t2=C_SCHEME_UNDEFINED;
return(t2);}}

/* k8135 in %process in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8137(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(3,c,3)))){
C_save_and_reclaim((void *)f_8137,c,av);}
a=C_alloc(3);
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8140,a[2]=t0,tmp=(C_word)a,a+=3,tmp);
if(C_truep(((C_word*)t0)[6])){
/* posixunix.scm:1306: check-environment-list */
f_4799(t2,((C_word*)t0)[6],((C_word*)t0)[3]);}
else{
t3=t2;{
C_word *av2=av;
av2[0]=t3;
av2[1]=C_SCHEME_UNDEFINED;
f_8140(2,av2);}}}

/* k8138 in k8135 in %process in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8140(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,9)))){
C_save_and_reclaim((void *)f_8140,c,av);}
t2=((C_word*)t0)[2];
/* posixunix.scm:1307: process-impl */
t3=lf[443];
f_8032(t3,((C_word*)t2)[2],((C_word*)t2)[3],((C_word*)((C_word*)t2)[4])[1],((C_word*)((C_word*)t2)[5])[1],((C_word*)t2)[6],C_SCHEME_TRUE,C_SCHEME_TRUE,((C_word*)t2)[7],((C_word*)t2)[8]);}

/* chicken.process#process in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8159(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,7)))){
C_save_and_reclaim((void *)f_8159,c,av);}
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_get_rest_arg(c,3,av,3,t0));
t5=C_rest_nullp(c,3);
t6=C_rest_nullp(c,4);
t7=(C_truep(t6)?C_SCHEME_FALSE:C_get_rest_arg(c,4,av,3,t0));
t8=C_rest_nullp(c,4);
t9=C_rest_nullp(c,5);
t10=(C_truep(t9)?lf[251]:C_get_rest_arg(c,5,av,3,t0));
t11=C_rest_nullp(c,5);
t12=C_rest_nullp(c,6);
t13=(C_truep(t12)?C_SCHEME_FALSE:C_get_rest_arg(c,6,av,3,t0));
if(C_truep(C_rest_nullp(c,6))){
/* posixunix.scm:1310: %process */
f_8094(t1,lf[444],C_SCHEME_FALSE,t2,t4,t7,t10);}
else{
/* posixunix.scm:1310: %process */
f_8094(t1,lf[444],C_SCHEME_FALSE,t2,t4,t7,t10);}}

/* chicken.process#process* in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8237(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word *a;
if(c<3) C_bad_min_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,7)))){
C_save_and_reclaim((void *)f_8237,c,av);}
t3=C_rest_nullp(c,3);
t4=(C_truep(t3)?C_SCHEME_FALSE:C_get_rest_arg(c,3,av,3,t0));
t5=C_rest_nullp(c,3);
t6=C_rest_nullp(c,4);
t7=(C_truep(t6)?C_SCHEME_FALSE:C_get_rest_arg(c,4,av,3,t0));
t8=C_rest_nullp(c,4);
t9=C_rest_nullp(c,5);
t10=(C_truep(t9)?lf[251]:C_get_rest_arg(c,5,av,3,t0));
t11=C_rest_nullp(c,5);
t12=C_rest_nullp(c,6);
t13=(C_truep(t12)?C_SCHEME_FALSE:C_get_rest_arg(c,6,av,3,t0));
if(C_truep(C_rest_nullp(c,6))){
/* posixunix.scm:1313: %process */
f_8094(t1,lf[445],C_SCHEME_TRUE,t2,t4,t7,t10);}
else{
/* posixunix.scm:1313: %process */
f_8094(t1,lf[445],C_SCHEME_TRUE,t2,t4,t7,t10);}}

/* k8318 in chicken.process-context.posix#set-root-directory! in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8320(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_8320,c,av);}
if(C_truep(C_fixnum_lessp(stub2446(C_SCHEME_UNDEFINED,t1),C_fix(0)))){
/* posixunix.scm:1323: posix-error */
t2=lf[192];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[2];
av2[2]=lf[197];
av2[3]=lf[446];
av2[4]=lf[447];
av2[5]=((C_word*)t0)[3];
f_3238(6,av2);}}
else{
t2=C_SCHEME_UNDEFINED;
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t2;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* chicken.process-context.posix#set-root-directory! in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8325(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_8325,c,av);}
a=C_alloc(4);
t3=C_i_check_string_2(t2,lf[446]);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8320,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:1319: ##sys#make-c-string */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[199]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[199]+1);
av2[1]=t4;
av2[2]=C_i_foreign_string_argumentp(t2);
tp(3,av2);}}

/* chicken.process#process-spawn in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8344(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,3)))){
C_save_and_reclaim((void *)f_8344,c,av);}
/* posixunix.scm:1327: chicken.base#error */
t2=*((C_word*)lf[100]+1);{
C_word av2[4];
av2[0]=t2;
av2[1]=t1;
av2[2]=lf[110];
av2[3]=lf[448];
((C_proc)(void*)(*((C_word*)t2+1)))(4,av2);}}

/* chicken.errno#errno in k6209 in k6178 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8350(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8350,c,av);}
/* posix.scm:388: ##sys#errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[451]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[451]+1);
av2[1]=t1;
tp(2,av2);}}

/* a8398 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8399(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,2)))){
C_save_and_reclaim((void *)f_8399,c,av);}
a=C_alloc(8);
t3=C_i_check_fixnum_2(t2,lf[491]);
t4=C_getpgid(t2);
t5=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8406,a[2]=t1,a[3]=t4,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_fixnum_lessp(t4,C_fix(0)))){
t6=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8416,a[2]=t5,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:721: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[92]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[92]+1);
av2[1]=t6;
tp(2,av2);}}
else{
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}}

/* k8404 in a8398 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8406(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8406,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k8414 in a8398 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8416(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_8416,c,av);}
/* posixunix.scm:721: ##sys#error/errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[370]+1));
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[370]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=lf[491];
av2[4]=lf[492];
av2[5]=((C_word*)t0)[3];
tp(6,av2);}}

/* a8417 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8418(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3=av[3];
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(c!=4) C_bad_argc_2(c,4,t0);
if(C_unlikely(!C_demand(C_calculate_demand(5,c,2)))){
C_save_and_reclaim((void *)f_8418,c,av);}
a=C_alloc(5);
t4=C_i_check_fixnum_2(t2,lf[493]);
t5=C_i_check_fixnum_2(t3,lf[493]);
if(C_truep(C_fixnum_lessp(C_setpgid(t2,t3),C_fix(0)))){
t6=(*a=C_CLOSURE_TYPE|4,a[1]=(C_word)f_8438,a[2]=t1,a[3]=t2,a[4]=t3,tmp=(C_word)a,a+=5,tmp);
/* posixunix.scm:729: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[92]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[92]+1);
av2[1]=t6;
tp(2,av2);}}
else{
t6=C_SCHEME_UNDEFINED;
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=t6;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}

/* k8436 in a8417 in k6029 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8438(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,6)))){
C_save_and_reclaim((void *)f_8438,c,av);}
/* posixunix.scm:729: ##sys#error/errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[370]+1));
C_word *av2;
if(c >= 7) {
  av2=av;
} else {
  av2=C_alloc(7);
}
av2[0]=*((C_word*)lf[370]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=lf[493];
av2[4]=lf[494];
av2[5]=((C_word*)t0)[3];
av2[6]=((C_word*)t0)[4];
tp(7,av2);}}

/* a8440 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8441(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8441,c,av);}
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=stub1746(C_SCHEME_UNDEFINED);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* a8443 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8444(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_8444,c,av);}
a=C_alloc(4);
t3=C_i_check_fixnum_2(t2,lf[497]);
if(C_truep(C_fixnum_lessp(C_setegid(t2),C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8461,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:649: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[92]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[92]+1);
av2[1]=t4;
tp(2,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k8459 in a8443 in k6025 in k6021 in k6017 in k5975 */
static void C_ccall f_8461(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_8461,c,av);}
/* posixunix.scm:649: ##sys#error/errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[370]+1));
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[370]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=lf[498];
av2[4]=lf[499];
av2[5]=((C_word*)t0)[3];
tp(6,av2);}}

/* a8463 in k6021 in k6017 in k5975 */
static void C_ccall f_8464(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8464,c,av);}
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=stub1742(C_SCHEME_UNDEFINED);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* a8466 in k6021 in k6017 in k5975 */
static void C_ccall f_8467(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_8467,c,av);}
a=C_alloc(4);
t3=C_i_check_fixnum_2(t2,lf[501]);
if(C_truep(C_fixnum_lessp(C_setgid(t2),C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8484,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:639: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[92]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[92]+1);
av2[1]=t4;
tp(2,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k8482 in a8466 in k6021 in k6017 in k5975 */
static void C_ccall f_8484(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_8484,c,av);}
/* posixunix.scm:639: ##sys#error/errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[370]+1));
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[370]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=lf[502];
av2[4]=lf[503];
av2[5]=((C_word*)t0)[3];
tp(6,av2);}}

/* a8486 in k6017 in k5975 */
static void C_ccall f_8487(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8487,c,av);}
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=stub1738(C_SCHEME_UNDEFINED);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* a8489 in k6017 in k5975 */
static void C_ccall f_8490(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_8490,c,av);}
a=C_alloc(4);
t3=C_i_check_fixnum_2(t2,lf[505]);
if(C_truep(C_fixnum_lessp(C_seteuid(t2),C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8507,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:628: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[92]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[92]+1);
av2[1]=t4;
tp(2,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k8505 in a8489 in k6017 in k5975 */
static void C_ccall f_8507(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_8507,c,av);}
/* posixunix.scm:628: ##sys#error/errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[370]+1));
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[370]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=lf[506];
av2[4]=lf[507];
av2[5]=((C_word*)t0)[3];
tp(6,av2);}}

/* a8509 in k5975 */
static void C_ccall f_8510(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8510,c,av);}
t2=t1;{
C_word *av2=av;
av2[0]=t2;
av2[1]=stub1734(C_SCHEME_UNDEFINED);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* a8512 in k5975 */
static void C_ccall f_8513(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(4,c,2)))){
C_save_and_reclaim((void *)f_8513,c,av);}
a=C_alloc(4);
t3=C_i_check_fixnum_2(t2,lf[509]);
if(C_truep(C_fixnum_lessp(C_setuid(t2),C_fix(0)))){
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8530,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
/* posixunix.scm:618: ##sys#update-errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[92]+1));
C_word *av2=av;
av2[0]=*((C_word*)lf[92]+1);
av2[1]=t4;
tp(2,av2);}}
else{
t4=C_SCHEME_UNDEFINED;
t5=t1;{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
((C_proc)(void*)(*((C_word*)t5+1)))(2,av2);}}}

/* k8528 in a8512 in k5975 */
static void C_ccall f_8530(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,5)))){
C_save_and_reclaim((void *)f_8530,c,av);}
/* posixunix.scm:618: ##sys#error/errno */
{C_proc tp=(C_proc)C_fast_retrieve_proc(*((C_word*)lf[370]+1));
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=*((C_word*)lf[370]+1);
av2[1]=((C_word*)t0)[2];
av2[2]=t1;
av2[3]=lf[510];
av2[4]=lf[511];
av2[5]=((C_word*)t0)[3];
tp(6,av2);}}

/* a8532 */
static void C_ccall f_8533(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word *a;
if(c!=2) C_bad_argc_2(c,2,t0);
if(C_unlikely(!C_demand(C_calculate_demand(6,c,4)))){
C_save_and_reclaim((void *)f_8533,c,av);}
a=C_alloc(6);
t2=C_sigprocmask_get(C_fix(0));
t3=C_SCHEME_UNDEFINED;
t4=(*a=C_VECTOR_TYPE|1,a[1]=t3,tmp=(C_word)a,a+=2,tmp);
t5=C_set_block_item(t4,0,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8539,a[2]=t4,a[3]=((C_word)li223),tmp=(C_word)a,a+=4,tmp));
t6=((C_word*)t4)[1];
f_8539(t6,t1,*((C_word*)lf[176]+1),C_SCHEME_END_OF_LIST);}

/* loop in a8532 */
static void f_8539(C_word t0,C_word t1,C_word t2,C_word t3){
C_word tmp;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word *a;
loop:
if(C_unlikely(!C_demand(C_calculate_demand(3,0,3)))){
C_save_and_reclaim_args((void *)trf_8539,4,t0,t1,t2,t3);}
a=C_alloc(3);
if(C_truep(C_i_nullp(t2))){
t4=t1;{
C_word av2[2];
av2[0]=t4;
av2[1]=t3;
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}
else{
t4=C_i_car(t2);
t5=C_u_i_cdr(t2);
if(C_truep(C_sigismember(t4))){
t6=C_a_i_cons(&a,2,t4,t3);
/* posixunix.scm:582: loop */
t8=t1;
t9=t5;
t10=t6;
t1=t8;
t2=t9;
t3=t10;
goto loop;}
else{
/* posixunix.scm:582: loop */
t8=t1;
t9=t5;
t10=t3;
t1=t8;
t2=t9;
t3=t10;
goto loop;}}}

/* a8562 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_8563(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8563,c,av);}
t3=C_i_check_fixnum_2(t2,lf[514]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_slot(*((C_word*)lf[279]+1),t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* a8571 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_8572(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8572,c,av);}
t2=C_rest_nullp(c,2);
t3=(C_truep(t2)?C_SCHEME_FALSE:C_get_rest_arg(c,2,av,2,t0));
t4=(C_truep(t3)?C_i_check_fixnum_2(t3,lf[516]):C_SCHEME_UNDEFINED);
if(C_truep(t3)){
t5=C_umask(t3);
if(C_truep(t3)){
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_umask(t5);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}
else{
t5=C_umask(C_fix(0));
if(C_truep(t3)){
t6=t1;{
C_word *av2=av;
av2[0]=t6;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t6+1)))(2,av2);}}
else{
t6=C_umask(t5);
t7=t1;{
C_word *av2=av;
av2[0]=t7;
av2[1]=t5;
((C_proc)(void*)(*((C_word*)t7+1)))(2,av2);}}}}

/* a8596 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_8597(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8597,c,av);}
t3=C_i_check_fixnum_2(t2,lf[516]);
t4=t1;{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_umask(t2);
((C_proc)(void*)(*((C_word*)t4+1)))(2,av2);}}

/* a8602 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_8603(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(8,c,2)))){
C_save_and_reclaim((void *)f_8603,c,av);}
a=C_alloc(8);
t3=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8607,a[2]=t1,a[3]=t2,tmp=(C_word)a,a+=4,tmp);
t4=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8619,a[2]=t2,a[3]=t3,tmp=(C_word)a,a+=4,tmp);
/* posix-common.scm:412: scheme#port? */
t5=*((C_word*)lf[203]+1);{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
av2[2]=t2;
((C_proc)(void*)(*((C_word*)t5+1)))(3,av2);}}

/* k8605 in a8602 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_8607(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(4,c,5)))){
C_save_and_reclaim((void *)f_8607,c,av);}
a=C_alloc(4);
t2=(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_8610,a[2]=((C_word*)t0)[2],a[3]=t1,tmp=(C_word)a,a+=4,tmp);
if(C_truep(C_i_lessp(t1,C_fix(0)))){
/* posix-common.scm:421: posix-error */
t3=lf[192];{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t3;
av2[1]=t2;
av2[2]=lf[197];
av2[3]=lf[518];
av2[4]=lf[519];
av2[5]=((C_word*)t0)[3];
f_3238(6,av2);}}
else{
t3=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t3;
av2[1]=t1;
((C_proc)(void*)(*((C_word*)t3+1)))(2,av2);}}}

/* k8608 in k8605 in a8602 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_8610(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8610,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* k8617 in a8602 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_8619(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(7,c,5)))){
C_save_and_reclaim((void *)f_8619,c,av);}
a=C_alloc(7);
if(C_truep(t1)){
t2=C_slot(((C_word*)t0)[2],C_fix(7));
t3=C_eqp(t2,lf[239]);
if(C_truep(t3)){
t4=C_ftell(&a,1,((C_word*)t0)[2]);
t5=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t5;
av2[1]=t4;
f_8607(2,av2);}}
else{
t4=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t4;
av2[1]=C_fix(-1);
f_8607(2,av2);}}}
else{
if(C_truep(C_fixnump(((C_word*)t0)[2]))){
t2=((C_word*)t0)[3];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_lseek(((C_word*)t0)[2],C_fix(0),C_fix((C_word)SEEK_CUR));
f_8607(2,av2);}}
else{
/* posix-common.scm:419: ##sys#signal-hook */
t2=*((C_word*)lf[200]+1);{
C_word *av2;
if(c >= 6) {
  av2=av;
} else {
  av2=C_alloc(6);
}
av2[0]=t2;
av2[1]=((C_word*)t0)[3];
av2[2]=lf[201];
av2[3]=lf[518];
av2[4]=lf[520];
av2[5]=((C_word*)t0)[2];
((C_proc)(void*)(*((C_word*)t2+1)))(6,av2);}}}}

/* a8639 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_8640(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_8640,c,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8644,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:335: stat */
f_3256(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[209]);}

/* k8642 in a8639 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_8644(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8644,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_stat_perm);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* a8645 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_8646(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_8646,c,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8650,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:328: stat */
f_3256(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[523]);}

/* k8648 in a8645 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_8650(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8650,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_gid);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* a8651 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_8652(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2=av[2];
C_word t3;
C_word t4;
C_word *a;
if(c!=3) C_bad_argc_2(c,3,t0);
if(C_unlikely(!C_demand(C_calculate_demand(3,c,5)))){
C_save_and_reclaim((void *)f_8652,c,av);}
a=C_alloc(3);
t3=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8656,a[2]=t1,tmp=(C_word)a,a+=3,tmp);
/* posix-common.scm:322: stat */
f_3256(t3,t2,C_SCHEME_FALSE,C_SCHEME_TRUE,lf[525]);}

/* k8654 in a8651 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void C_ccall f_8656(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(0,c,1)))){
C_save_and_reclaim((void *)f_8656,c,av);}
t2=((C_word*)t0)[2];{
C_word *av2=av;
av2[0]=t2;
av2[1]=C_fix(C_MOST_POSITIVE_FIXNUM&(C_word)C_statbuf.st_uid);
((C_proc)(void*)(*((C_word*)t2+1)))(2,av2);}}

/* toplevel */
static int toplevel_initialized=0;

void C_ccall C_posix_toplevel(C_word c,C_word *av){
C_word tmp;
C_word t0=av[0];
C_word t1=av[1];
C_word t2;
C_word t3;
C_word *a;
if(toplevel_initialized) {C_kontinue(t1,C_SCHEME_UNDEFINED);}
else C_toplevel_entry(C_text("posix"));
C_check_nursery_minimum(C_calculate_demand(3,c,2));
if(C_unlikely(!C_demand(C_calculate_demand(3,c,2)))){
C_save_and_reclaim((void*)C_posix_toplevel,c,av);}
toplevel_initialized=1;
if(C_unlikely(!C_demand_2(2842))){
C_save(t1);
C_rereclaim2(2842*sizeof(C_word),1);
t1=C_restore;}
a=C_alloc(3);
C_initialize_lf(lf,527);
lf[0]=C_h_intern(&lf[0],5, C_text("posix"));
lf[1]=C_h_intern(&lf[1],19, C_text("chicken.file.posix#"));
lf[2]=C_h_intern(&lf[2],30, C_text("chicken.file.posix#create-fifo"));
lf[3]=C_h_intern(&lf[3],39, C_text("chicken.file.posix#create-symbolic-link"));
lf[4]=C_h_intern(&lf[4],37, C_text("chicken.file.posix#read-symbolic-link"));
lf[5]=C_h_intern(&lf[5],35, C_text("chicken.file.posix#duplicate-fileno"));
lf[6]=C_h_intern(&lf[6],30, C_text("chicken.file.posix#fcntl/dupfd"));
lf[7]=C_h_intern(&lf[7],30, C_text("chicken.file.posix#fcntl/getfd"));
lf[8]=C_h_intern(&lf[8],30, C_text("chicken.file.posix#fcntl/getfl"));
lf[9]=C_h_intern(&lf[9],30, C_text("chicken.file.posix#fcntl/setfd"));
lf[10]=C_h_intern(&lf[10],30, C_text("chicken.file.posix#fcntl/setfl"));
lf[11]=C_h_intern(&lf[11],29, C_text("chicken.file.posix#file-close"));
lf[12]=C_h_intern(&lf[12],31, C_text("chicken.file.posix#file-control"));
lf[13]=C_h_intern(&lf[13],37, C_text("chicken.file.posix#file-creation-mode"));
lf[14]=C_h_intern(&lf[14],29, C_text("chicken.file.posix#file-group"));
lf[15]=C_h_intern(&lf[15],28, C_text("chicken.file.posix#file-link"));
lf[16]=C_h_intern(&lf[16],28, C_text("chicken.file.posix#file-lock"));
lf[17]=C_h_intern(&lf[17],37, C_text("chicken.file.posix#file-lock/blocking"));
lf[18]=C_h_intern(&lf[18],31, C_text("chicken.file.posix#file-mkstemp"));
lf[19]=C_h_intern(&lf[19],28, C_text("chicken.file.posix#file-open"));
lf[20]=C_h_intern(&lf[20],29, C_text("chicken.file.posix#file-owner"));
lf[21]=C_h_intern(&lf[21],35, C_text("chicken.file.posix#file-permissions"));
lf[22]=C_h_intern(&lf[22],32, C_text("chicken.file.posix#file-position"));
lf[23]=C_h_intern(&lf[23],28, C_text("chicken.file.posix#file-read"));
lf[24]=C_h_intern(&lf[24],30, C_text("chicken.file.posix#file-select"));
lf[25]=C_h_intern(&lf[25],32, C_text("chicken.file.posix#file-truncate"));
lf[26]=C_h_intern(&lf[26],30, C_text("chicken.file.posix#file-unlock"));
lf[27]=C_h_intern(&lf[27],29, C_text("chicken.file.posix#file-write"));
lf[28]=C_h_intern(&lf[28],28, C_text("chicken.file.posix#file-type"));
lf[29]=C_h_intern(&lf[29],32, C_text("chicken.file.posix#block-device?"));
lf[30]=C_h_intern(&lf[30],36, C_text("chicken.file.posix#character-device?"));
lf[31]=C_h_intern(&lf[31],29, C_text("chicken.file.posix#directory?"));
lf[32]=C_h_intern(&lf[32],24, C_text("chicken.file.posix#fifo?"));
lf[33]=C_h_intern(&lf[33],32, C_text("chicken.file.posix#regular-file?"));
lf[34]=C_h_intern(&lf[34],26, C_text("chicken.file.posix#socket?"));
lf[35]=C_h_intern(&lf[35],33, C_text("chicken.file.posix#symbolic-link?"));
lf[36]=C_h_intern(&lf[36],32, C_text("chicken.file.posix#fileno/stderr"));
lf[37]=C_h_intern(&lf[37],31, C_text("chicken.file.posix#fileno/stdin"));
lf[38]=C_h_intern(&lf[38],32, C_text("chicken.file.posix#fileno/stdout"));
lf[39]=C_h_intern(&lf[39],35, C_text("chicken.file.posix#open-input-file*"));
lf[40]=C_h_intern(&lf[40],36, C_text("chicken.file.posix#open-output-file*"));
lf[41]=C_h_intern(&lf[41],30, C_text("chicken.file.posix#open/append"));
lf[42]=C_h_intern(&lf[42],30, C_text("chicken.file.posix#open/binary"));
lf[43]=C_h_intern(&lf[43],29, C_text("chicken.file.posix#open/creat"));
lf[44]=C_h_intern(&lf[44],28, C_text("chicken.file.posix#open/excl"));
lf[45]=C_h_intern(&lf[45],29, C_text("chicken.file.posix#open/fsync"));
lf[46]=C_h_intern(&lf[46],30, C_text("chicken.file.posix#open/noctty"));
lf[47]=C_h_intern(&lf[47],33, C_text("chicken.file.posix#open/noinherit"));
lf[48]=C_h_intern(&lf[48],32, C_text("chicken.file.posix#open/nonblock"));
lf[49]=C_h_intern(&lf[49],30, C_text("chicken.file.posix#open/rdonly"));
lf[50]=C_h_intern(&lf[50],28, C_text("chicken.file.posix#open/rdwr"));
lf[51]=C_h_intern(&lf[51],28, C_text("chicken.file.posix#open/read"));
lf[52]=C_h_intern(&lf[52],28, C_text("chicken.file.posix#open/sync"));
lf[53]=C_h_intern(&lf[53],28, C_text("chicken.file.posix#open/text"));
lf[54]=C_h_intern(&lf[54],29, C_text("chicken.file.posix#open/trunc"));
lf[55]=C_h_intern(&lf[55],29, C_text("chicken.file.posix#open/write"));
lf[56]=C_h_intern(&lf[56],30, C_text("chicken.file.posix#open/wronly"));
lf[57]=C_h_intern(&lf[57],29, C_text("chicken.file.posix#perm/irgrp"));
lf[58]=C_h_intern(&lf[58],29, C_text("chicken.file.posix#perm/iroth"));
lf[59]=C_h_intern(&lf[59],29, C_text("chicken.file.posix#perm/irusr"));
lf[60]=C_h_intern(&lf[60],29, C_text("chicken.file.posix#perm/irwxg"));
lf[61]=C_h_intern(&lf[61],29, C_text("chicken.file.posix#perm/irwxo"));
lf[62]=C_h_intern(&lf[62],29, C_text("chicken.file.posix#perm/irwxu"));
lf[63]=C_h_intern(&lf[63],29, C_text("chicken.file.posix#perm/isgid"));
lf[64]=C_h_intern(&lf[64],29, C_text("chicken.file.posix#perm/isuid"));
lf[65]=C_h_intern(&lf[65],29, C_text("chicken.file.posix#perm/isvtx"));
lf[66]=C_h_intern(&lf[66],29, C_text("chicken.file.posix#perm/iwgrp"));
lf[67]=C_h_intern(&lf[67],29, C_text("chicken.file.posix#perm/iwoth"));
lf[68]=C_h_intern(&lf[68],29, C_text("chicken.file.posix#perm/iwusr"));
lf[69]=C_h_intern(&lf[69],29, C_text("chicken.file.posix#perm/ixgrp"));
lf[70]=C_h_intern(&lf[70],29, C_text("chicken.file.posix#perm/ixoth"));
lf[71]=C_h_intern(&lf[71],29, C_text("chicken.file.posix#perm/ixusr"));
lf[72]=C_h_intern(&lf[72],31, C_text("chicken.file.posix#port->fileno"));
lf[73]=C_h_intern(&lf[73],27, C_text("chicken.file.posix#seek/cur"));
lf[74]=C_h_intern(&lf[74],27, C_text("chicken.file.posix#seek/end"));
lf[75]=C_h_intern(&lf[75],27, C_text("chicken.file.posix#seek/set"));
lf[76]=C_h_intern(&lf[76],37, C_text("chicken.file.posix#set-file-position!"));
lf[77]=C_h_intern(&lf[77],19, C_text("chicken.time.posix#"));
lf[78]=C_h_intern(&lf[78],36, C_text("chicken.time.posix#seconds->utc-time"));
lf[79]=C_h_intern(&lf[79],36, C_text("chicken.time.posix#utc-time->seconds"));
lf[80]=C_h_intern(&lf[80],38, C_text("chicken.time.posix#seconds->local-time"));
lf[81]=C_h_intern(&lf[81],34, C_text("chicken.time.posix#seconds->string"));
lf[82]=C_h_intern(&lf[82],38, C_text("chicken.time.posix#local-time->seconds"));
lf[83]=C_h_intern(&lf[83],31, C_text("chicken.time.posix#string->time"));
lf[84]=C_h_intern(&lf[84],31, C_text("chicken.time.posix#time->string"));
lf[85]=C_h_intern(&lf[85],46, C_text("chicken.time.posix#local-timezone-abbreviation"));
lf[86]=C_h_intern(&lf[86],16, C_text("chicken.process#"));
lf[87]=C_h_intern(&lf[87],22, C_text("chicken.process#system"));
lf[88]=C_h_intern(&lf[88],6, C_text("system"));
lf[89]=C_h_intern(&lf[89],23, C_text("##sys#signal-hook/errno"));
lf[90]=C_h_intern_kw(&lf[90],13, C_text("process-error"));
lf[91]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\033\140\163\171\163\164\145\155\047\040\151\156\166\157\143\141\164\151\157\156\040\146\141\151\154\145\144\000"));
lf[92]=C_h_intern(&lf[92],18, C_text("##sys#update-errno"));
lf[93]=C_h_intern(&lf[93],23, C_text("chicken.process#system*"));
lf[94]=C_h_intern(&lf[94],11, C_text("##sys#error"));
lf[95]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\064\163\150\145\154\154\040\151\156\166\157\143\141\164\151\157\156\040\146\141\151\154\145\144\040\167\151\164\150\040\156\157\156\055\172\145\162\157\040\162\145\164\165\162\156\040\163\164\141\164\165\163\000"));
lf[96]=C_h_intern(&lf[96],18, C_text("chicken.process#qs"));
lf[97]=C_h_intern(&lf[97],5, C_text("mingw"));
lf[98]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\003\042\042\000"));
lf[99]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\005\047\134\047\047\000"));
lf[100]=C_h_intern(&lf[100],18, C_text("chicken.base#error"));
lf[101]=C_h_intern(&lf[101],2, C_text("qs"));
lf[102]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\065\116\125\114\040\143\150\141\162\141\143\164\145\162\040\143\141\156\040\156\157\164\040\142\145\040\162\145\160\162\145\163\145\156\164\145\144\040\151\156\040\163\150\145\154\154\040\163\164\162\151\156\147\000"));
lf[103]=C_h_intern(&lf[103],20, C_text("scheme#string-append"));
lf[104]=C_h_intern(&lf[104],18, C_text("##sys#string->list"));
lf[105]=C_h_intern(&lf[105],33, C_text("chicken.platform#software-version"));
lf[106]=C_h_intern(&lf[106],31, C_text("chicken.process#process-execute"));
lf[107]=C_h_intern(&lf[107],28, C_text("chicken.process#process-fork"));
lf[108]=C_h_intern(&lf[108],27, C_text("chicken.process#process-run"));
lf[109]=C_h_intern(&lf[109],30, C_text("chicken.process#process-signal"));
lf[110]=C_h_intern(&lf[110],29, C_text("chicken.process#process-spawn"));
lf[111]=C_h_intern(&lf[111],28, C_text("chicken.process#process-wait"));
lf[112]=C_h_intern(&lf[112],36, C_text("chicken.process#call-with-input-pipe"));
lf[113]=C_h_intern(&lf[113],37, C_text("chicken.process#call-with-output-pipe"));
lf[114]=C_h_intern(&lf[114],32, C_text("chicken.process#close-input-pipe"));
lf[115]=C_h_intern(&lf[115],33, C_text("chicken.process#close-output-pipe"));
lf[116]=C_h_intern(&lf[116],27, C_text("chicken.process#create-pipe"));
lf[117]=C_h_intern(&lf[117],31, C_text("chicken.process#open-input-pipe"));
lf[118]=C_h_intern(&lf[118],32, C_text("chicken.process#open-output-pipe"));
lf[119]=C_h_intern(&lf[119],36, C_text("chicken.process#with-input-from-pipe"));
lf[120]=C_h_intern(&lf[120],35, C_text("chicken.process#with-output-to-pipe"));
lf[121]=C_h_intern(&lf[121],23, C_text("chicken.process#process"));
lf[122]=C_h_intern(&lf[122],24, C_text("chicken.process#process*"));
lf[123]=C_h_intern(&lf[123],29, C_text("chicken.process#process-sleep"));
lf[124]=C_h_intern(&lf[124],24, C_text("chicken.process#process?"));
lf[125]=C_h_intern(&lf[125],35, C_text("chicken.process#process-exit-status"));
lf[126]=C_h_intern(&lf[126],42, C_text("chicken.process#process-returned-normally?"));
lf[127]=C_h_intern(&lf[127],34, C_text("chicken.process#process-input-port"));
lf[128]=C_h_intern(&lf[128],35, C_text("chicken.process#process-output-port"));
lf[129]=C_h_intern(&lf[129],34, C_text("chicken.process#process-error-port"));
lf[130]=C_h_intern(&lf[130],26, C_text("chicken.process#process-id"));
lf[131]=C_h_intern(&lf[131],24, C_text("chicken.process#pipe/buf"));
lf[132]=C_h_intern(&lf[132],29, C_text("chicken.process#spawn/overlay"));
lf[133]=C_h_intern(&lf[133],26, C_text("chicken.process#spawn/wait"));
lf[134]=C_h_intern(&lf[134],28, C_text("chicken.process#spawn/nowait"));
lf[135]=C_h_intern(&lf[135],29, C_text("chicken.process#spawn/nowaito"));
lf[136]=C_h_intern(&lf[136],28, C_text("chicken.process#spawn/detach"));
lf[137]=C_h_intern(&lf[137],23, C_text("chicken.process.signal#"));
lf[138]=C_h_intern(&lf[138],33, C_text("chicken.process.signal#set-alarm!"));
lf[139]=C_h_intern(&lf[139],42, C_text("chicken.process.signal#set-signal-handler!"));
lf[140]=C_h_intern(&lf[140],39, C_text("chicken.process.signal#set-signal-mask!"));
lf[141]=C_h_intern(&lf[141],37, C_text("chicken.process.signal#signal-handler"));
lf[142]=C_h_intern(&lf[142],42, C_text("chicken.process.signal#make-signal-handler"));
lf[143]=C_h_intern(&lf[143],36, C_text("chicken.process.signal#signal-ignore"));
lf[144]=C_h_intern(&lf[144],37, C_text("chicken.process.signal#signal-default"));
lf[145]=C_h_intern(&lf[145],34, C_text("chicken.process.signal#signal-mask"));
lf[146]=C_h_intern(&lf[146],35, C_text("chicken.process.signal#signal-mask!"));
lf[147]=C_h_intern(&lf[147],37, C_text("chicken.process.signal#signal-masked?"));
lf[148]=C_h_intern(&lf[148],37, C_text("chicken.process.signal#signal-unmask!"));
lf[149]=C_h_intern(&lf[149],34, C_text("chicken.process.signal#signal/abrt"));
lf[150]=C_h_intern(&lf[150],34, C_text("chicken.process.signal#signal/alrm"));
lf[151]=C_h_intern(&lf[151],35, C_text("chicken.process.signal#signal/break"));
lf[152]=C_h_intern(&lf[152],33, C_text("chicken.process.signal#signal/bus"));
lf[153]=C_h_intern(&lf[153],34, C_text("chicken.process.signal#signal/chld"));
lf[154]=C_h_intern(&lf[154],34, C_text("chicken.process.signal#signal/cont"));
lf[155]=C_h_intern(&lf[155],33, C_text("chicken.process.signal#signal/fpe"));
lf[156]=C_h_intern(&lf[156],33, C_text("chicken.process.signal#signal/hup"));
lf[157]=C_h_intern(&lf[157],33, C_text("chicken.process.signal#signal/ill"));
lf[158]=C_h_intern(&lf[158],33, C_text("chicken.process.signal#signal/int"));
lf[159]=C_h_intern(&lf[159],32, C_text("chicken.process.signal#signal/io"));
lf[160]=C_h_intern(&lf[160],34, C_text("chicken.process.signal#signal/kill"));
lf[161]=C_h_intern(&lf[161],34, C_text("chicken.process.signal#signal/pipe"));
lf[162]=C_h_intern(&lf[162],34, C_text("chicken.process.signal#signal/prof"));
lf[163]=C_h_intern(&lf[163],34, C_text("chicken.process.signal#signal/quit"));
lf[164]=C_h_intern(&lf[164],34, C_text("chicken.process.signal#signal/segv"));
lf[165]=C_h_intern(&lf[165],34, C_text("chicken.process.signal#signal/stop"));
lf[166]=C_h_intern(&lf[166],34, C_text("chicken.process.signal#signal/term"));
lf[167]=C_h_intern(&lf[167],34, C_text("chicken.process.signal#signal/trap"));
lf[168]=C_h_intern(&lf[168],34, C_text("chicken.process.signal#signal/tstp"));
lf[169]=C_h_intern(&lf[169],33, C_text("chicken.process.signal#signal/urg"));
lf[170]=C_h_intern(&lf[170],34, C_text("chicken.process.signal#signal/usr1"));
lf[171]=C_h_intern(&lf[171],34, C_text("chicken.process.signal#signal/usr2"));
lf[172]=C_h_intern(&lf[172],36, C_text("chicken.process.signal#signal/vtalrm"));
lf[173]=C_h_intern(&lf[173],35, C_text("chicken.process.signal#signal/winch"));
lf[174]=C_h_intern(&lf[174],34, C_text("chicken.process.signal#signal/xcpu"));
lf[175]=C_h_intern(&lf[175],34, C_text("chicken.process.signal#signal/xfsz"));
lf[176]=C_h_intern(&lf[176],35, C_text("chicken.process.signal#signals-list"));
lf[177]=C_h_intern(&lf[177],30, C_text("chicken.process-context.posix#"));
lf[178]=C_h_intern(&lf[178],47, C_text("chicken.process-context.posix#change-directory*"));
lf[179]=C_h_intern(&lf[179],49, C_text("chicken.process-context.posix#set-root-directory!"));
lf[180]=C_h_intern(&lf[180],56, C_text("chicken.process-context.posix#current-effective-group-id"));
lf[181]=C_h_intern(&lf[181],55, C_text("chicken.process-context.posix#current-effective-user-id"));
lf[182]=C_h_intern(&lf[182],46, C_text("chicken.process-context.posix#current-group-id"));
lf[183]=C_h_intern(&lf[183],45, C_text("chicken.process-context.posix#current-user-id"));
lf[184]=C_h_intern(&lf[184],48, C_text("chicken.process-context.posix#current-process-id"));
lf[185]=C_h_intern(&lf[185],47, C_text("chicken.process-context.posix#parent-process-id"));
lf[186]=C_h_intern(&lf[186],47, C_text("chicken.process-context.posix#current-user-name"));
lf[187]=C_h_intern(&lf[187],57, C_text("chicken.process-context.posix#current-effective-user-name"));
lf[188]=C_h_intern(&lf[188],44, C_text("chicken.process-context.posix#create-session"));
lf[189]=C_h_intern(&lf[189],46, C_text("chicken.process-context.posix#process-group-id"));
lf[190]=C_h_intern(&lf[190],46, C_text("chicken.process-context.posix#user-information"));
lf[191]=C_h_intern(&lf[191],14, C_text("chicken.posix#"));
lf[193]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\004\040\055\040\000"));
lf[194]=C_h_intern(&lf[194],19, C_text("##sys#peek-c-string"));
lf[195]=C_h_intern(&lf[195],17, C_text("##sys#posix-error"));
lf[197]=C_h_intern_kw(&lf[197],10, C_text("file-error"));
lf[198]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\023\143\141\156\156\157\164\040\141\143\143\145\163\163\040\146\151\154\145\000"));
lf[199]=C_h_intern(&lf[199],19, C_text("##sys#make-c-string"));
lf[200]=C_h_intern(&lf[200],17, C_text("##sys#signal-hook"));
lf[201]=C_h_intern_kw(&lf[201],10, C_text("type-error"));
lf[202]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\061\142\141\144\040\141\162\147\165\155\145\156\164\040\164\171\160\145\040\055\040\156\157\164\040\141\040\146\151\170\156\165\155\054\040\160\157\162\164\040\157\162\040\163\164\162\151\156\147\000"));
lf[203]=C_h_intern(&lf[203],12, C_text("scheme#port?"));
lf[204]=C_h_intern(&lf[204],28, C_text("chicken.file.posix#file-stat"));
lf[205]=C_h_intern(&lf[205],9, C_text("file-stat"));
lf[206]=C_h_intern(&lf[206],40, C_text("chicken.file.posix#set-file-permissions!"));
lf[207]=C_h_intern(&lf[207],21, C_text("set-file-permissions!"));
lf[208]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\037\143\141\156\156\157\164\040\143\150\141\156\147\145\040\146\151\154\145\040\160\145\162\155\151\163\163\151\157\156\163\000"));
lf[209]=C_h_intern(&lf[209],16, C_text("file-permissions"));
lf[210]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\061\142\141\144\040\141\162\147\165\155\145\156\164\040\164\171\160\145\040\055\040\156\157\164\040\141\040\146\151\170\156\165\155\054\040\160\157\162\164\040\157\162\040\163\164\162\151\156\147\000"));
lf[211]=C_h_intern(&lf[211],41, C_text("chicken.file.posix#file-modification-time"));
lf[212]=C_h_intern(&lf[212],22, C_text("file-modification-time"));
lf[213]=C_h_intern(&lf[213],35, C_text("chicken.file.posix#file-access-time"));
lf[214]=C_h_intern(&lf[214],16, C_text("file-access-time"));
lf[215]=C_h_intern(&lf[215],35, C_text("chicken.file.posix#file-change-time"));
lf[216]=C_h_intern(&lf[216],16, C_text("file-change-time"));
lf[217]=C_h_intern(&lf[217],34, C_text("chicken.file.posix#set-file-times!"));
lf[218]=C_h_intern(&lf[218],15, C_text("set-file-times!"));
lf[219]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\026\143\141\156\156\157\164\040\163\145\164\040\146\151\154\145\040\164\151\155\145\163\000"));
lf[220]=C_h_intern(&lf[220],25, C_text("##sys#check-exact-integer"));
lf[221]=C_h_intern(&lf[221],28, C_text("chicken.time#current-seconds"));
lf[222]=C_h_intern(&lf[222],28, C_text("chicken.file.posix#file-size"));
lf[223]=C_h_intern(&lf[223],9, C_text("file-size"));
lf[224]=C_h_intern(&lf[224],34, C_text("chicken.file.posix#set-file-owner!"));
lf[226]=C_h_intern(&lf[226],15, C_text("set-file-owner!"));
lf[227]=C_h_intern(&lf[227],34, C_text("chicken.file.posix#set-file-group!"));
lf[228]=C_h_intern(&lf[228],15, C_text("set-file-group!"));
lf[229]=C_h_intern(&lf[229],12, C_text("regular-file"));
lf[230]=C_h_intern(&lf[230],13, C_text("symbolic-link"));
lf[231]=C_h_intern(&lf[231],9, C_text("directory"));
lf[232]=C_h_intern(&lf[232],16, C_text("character-device"));
lf[233]=C_h_intern(&lf[233],12, C_text("block-device"));
lf[234]=C_h_intern(&lf[234],4, C_text("fifo"));
lf[235]=C_h_intern(&lf[235],6, C_text("socket"));
lf[236]=C_h_intern(&lf[236],9, C_text("file-type"));
lf[237]=C_h_intern(&lf[237],18, C_text("set-file-position!"));
lf[238]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\031\143\141\156\156\157\164\040\163\145\164\040\146\151\154\145\040\160\157\163\151\164\151\157\156\000"));
lf[239]=C_h_intern(&lf[239],6, C_text("stream"));
lf[240]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\015\151\156\166\141\154\151\144\040\146\151\154\145\000"));
lf[241]=C_h_intern_kw(&lf[241],6, C_text("append"));
lf[242]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\002\141\000"));
lf[243]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\034\151\156\166\141\154\151\144\040\155\157\144\145\040\146\157\162\040\151\156\160\165\164\040\146\151\154\145\000"));
lf[244]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\026\151\156\166\141\154\151\144\040\155\157\144\145\040\141\162\147\165\155\145\156\164\000"));
lf[245]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\002\162\000"));
lf[246]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\002\167\000"));
lf[247]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\021\143\141\156\156\157\164\040\157\160\145\156\040\146\151\154\145\000"));
lf[248]=C_h_intern(&lf[248],15, C_text("##sys#make-port"));
lf[249]=C_h_intern(&lf[249],23, C_text("##sys#stream-port-class"));
lf[250]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\011\050\146\144\160\157\162\164\051\000"));
lf[251]=C_h_intern(&lf[251],5, C_text("utf-8"));
lf[252]=C_h_intern(&lf[252],16, C_text("open-input-file*"));
lf[253]=C_h_intern(&lf[253],17, C_text("open-output-file*"));
lf[254]=C_h_intern(&lf[254],12, C_text("port->fileno"));
lf[255]=C_h_intern(&lf[255],15, C_text("##sys#port-data"));
lf[256]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\046\143\141\156\156\157\164\040\141\143\143\145\163\163\040\146\151\154\145\055\144\145\163\143\162\151\160\164\157\162\040\157\146\040\160\157\162\164\000"));
lf[257]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\032\160\157\162\164\040\150\141\163\040\156\157\040\141\164\164\141\143\150\145\144\040\146\151\154\145\000"));
lf[258]=C_h_intern(&lf[258],27, C_text("##sys#peek-unsigned-integer"));
lf[259]=C_h_intern(&lf[259],16, C_text("duplicate-fileno"));
lf[260]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\041\143\141\156\156\157\164\040\144\165\160\154\151\143\141\164\145\040\146\151\154\145\055\144\145\163\143\162\151\160\164\157\162\000"));
lf[261]=C_h_intern(&lf[261],17, C_text("change-directory*"));
lf[262]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\040\143\141\156\156\157\164\040\143\150\141\156\147\145\040\143\165\162\162\145\156\164\040\144\151\162\145\143\164\157\162\171\000"));
lf[263]=C_h_intern(&lf[263],27, C_text("##sys#change-directory-hook"));
lf[266]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\026\164\151\155\145\040\166\145\143\164\157\162\040\164\157\157\040\163\150\157\162\164\000"));
lf[267]=C_h_intern(&lf[267],19, C_text("seconds->local-time"));
lf[268]=C_h_intern(&lf[268],17, C_text("seconds->utc-time"));
lf[269]=C_h_intern(&lf[269],15, C_text("##sys#substring"));
lf[270]=C_h_intern(&lf[270],15, C_text("seconds->string"));
lf[271]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\041\143\141\156\156\157\164\040\143\157\156\166\145\162\164\040\163\145\143\157\156\144\163\040\164\157\040\163\164\162\151\156\147\000"));
lf[272]=C_h_intern(&lf[272],19, C_text("local-time->seconds"));
lf[273]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\046\143\141\156\156\157\164\040\143\157\156\166\145\162\164\040\164\151\155\145\040\166\145\143\164\157\162\040\164\157\040\163\145\143\157\156\144\163\000"));
lf[274]=C_h_intern(&lf[274],17, C_text("##sys#make-string"));
lf[275]=C_h_intern(&lf[275],12, C_text("time->string"));
lf[276]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\041\164\151\155\145\040\146\157\162\155\141\164\164\151\156\147\040\157\166\145\162\146\154\157\167\163\040\142\165\146\146\145\162\000"));
lf[277]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\045\143\141\156\156\157\164\040\143\157\156\166\145\162\164\040\164\151\155\145\040\166\145\143\164\157\162\040\164\157\040\163\164\162\151\156\147\000"));
lf[278]=C_h_intern(&lf[278],19, C_text("set-signal-handler!"));
lf[279]=C_h_intern(&lf[279],19, C_text("##sys#signal-vector"));
lf[280]=C_h_intern(&lf[280],19, C_text("make-signal-handler"));
lf[281]=C_h_intern(&lf[281],25, C_text("##sys#add-event-to-queue!"));
lf[282]=C_h_intern(&lf[282],20, C_text("##sys#get-next-event"));
lf[283]=C_h_intern(&lf[283],25, C_text("##sys#wait-for-next-event"));
lf[284]=C_h_intern(&lf[284],22, C_text("##sys#make-event-queue"));
lf[285]=C_h_intern(&lf[285],13, C_text("signal-ignore"));
lf[286]=C_h_intern(&lf[286],14, C_text("signal-default"));
lf[289]=C_h_intern(&lf[289],21, C_text("chicken.posix#process"));
lf[296]=C_h_intern(&lf[296],13, C_text("process-sleep"));
lf[297]=C_h_intern(&lf[297],12, C_text("process-wait"));
lf[299]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\041\167\141\151\164\151\156\147\040\146\157\162\040\143\150\151\154\144\040\160\162\157\143\145\163\163\040\146\141\151\154\145\144\000"));
lf[300]=C_h_intern(&lf[300],16, C_text("##sys#block-set!"));
lf[302]=C_h_intern(&lf[302],24, C_text("chicken.condition#signal"));
lf[304]=C_h_intern(&lf[304],34, C_text("chicken.memory#pointer-vector-set!"));
lf[305]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\016\117\165\164\040\157\146\040\155\145\155\157\162\171\000"));
lf[306]=C_h_intern(&lf[306],40, C_text("chicken.condition#with-exception-handler"));
lf[307]=C_h_intern(&lf[307],37, C_text("scheme#call-with-current-continuation"));
lf[308]=C_h_intern(&lf[308],34, C_text("chicken.memory#make-pointer-vector"));
lf[309]=C_h_intern(&lf[309],19, C_text("chicken.memory#free"));
lf[310]=C_h_intern(&lf[310],33, C_text("chicken.memory#pointer-vector-ref"));
lf[311]=C_h_intern(&lf[311],36, C_text("chicken.memory#pointer-vector-length"));
lf[314]=C_h_intern(&lf[314],3, C_text("map"));
lf[315]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\002\075\000"));
lf[316]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\021\143\141\156\156\157\164\040\157\160\145\156\040\160\151\160\145\000"));
lf[317]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\007\050\160\151\160\145\051\000"));
lf[318]=C_h_intern(&lf[318],15, C_text("open-input-pipe"));
lf[319]=C_h_intern_kw(&lf[319],4, C_text("text"));
lf[320]=C_h_intern_kw(&lf[320],6, C_text("binary"));
lf[321]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\044\151\154\154\145\147\141\154\040\151\156\160\165\164\057\157\165\164\160\165\164\040\155\157\144\145\040\163\160\145\143\151\146\151\145\162\000"));
lf[322]=C_h_intern(&lf[322],16, C_text("open-output-pipe"));
lf[323]=C_h_intern(&lf[323],16, C_text("close-input-pipe"));
lf[324]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\031\145\162\162\157\162\040\167\150\151\154\145\040\143\154\157\163\151\156\147\040\160\151\160\145\000"));
lf[325]=C_h_intern(&lf[325],17, C_text("close-output-pipe"));
lf[326]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\031\145\162\162\157\162\040\167\150\151\154\145\040\143\154\157\163\151\156\147\040\160\151\160\145\000"));
lf[327]=C_h_intern(&lf[327],20, C_text("##sys#standard-input"));
lf[328]=C_h_intern(&lf[328],13, C_text("scheme#values"));
lf[329]=C_h_intern(&lf[329],18, C_text("##sys#dynamic-wind"));
lf[330]=C_h_intern(&lf[330],21, C_text("##sys#standard-output"));
lf[331]=C_h_intern(&lf[331],23, C_text("##sys#file-nonblocking!"));
lf[332]=C_h_intern(&lf[332],21, C_text("##sys#file-select-one"));
lf[333]=C_h_intern(&lf[333],12, C_text("file-control"));
lf[334]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\024\143\141\156\156\157\164\040\143\157\156\164\162\157\154\040\146\151\154\145\000"));
lf[335]=C_h_intern(&lf[335],9, C_text("file-open"));
lf[336]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\021\143\141\156\156\157\164\040\157\160\145\156\040\146\151\154\145\000"));
lf[337]=C_h_intern(&lf[337],10, C_text("file-close"));
lf[338]=C_h_intern(&lf[338],24, C_text("##sys#dispatch-interrupt"));
lf[339]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\022\143\141\156\156\157\164\040\143\154\157\163\145\040\146\151\154\145\000"));
lf[340]=C_h_intern(&lf[340],9, C_text("file-read"));
lf[341]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\026\143\141\156\156\157\164\040\162\145\141\144\040\146\162\157\155\040\146\151\154\145\000"));
lf[342]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\045\142\141\144\040\141\162\147\165\155\145\156\164\040\164\171\160\145\040\055\040\156\157\164\040\141\040\142\171\164\145\166\145\143\164\157\162\000"));
lf[343]=C_h_intern(&lf[343],21, C_text("##sys#make-bytevector"));
lf[344]=C_h_intern(&lf[344],10, C_text("file-write"));
lf[345]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\025\143\141\156\156\157\164\040\167\162\151\164\145\040\164\157\040\146\151\154\145\000"));
lf[346]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\045\142\141\144\040\141\162\147\165\155\145\156\164\040\164\171\160\145\040\055\040\156\157\164\040\141\040\142\171\164\145\166\145\143\164\157\162\000"));
lf[347]=C_h_intern(&lf[347],12, C_text("file-mkstemp"));
lf[348]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\035\143\141\156\156\157\164\040\143\162\145\141\164\145\040\164\145\155\160\157\162\141\162\171\040\146\151\154\145\000"));
lf[349]=C_h_intern(&lf[349],11, C_text("file-select"));
lf[350]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\007\146\141\151\154\145\144\000"));
lf[351]=C_h_intern(&lf[351],18, C_text("##sys#fast-reverse"));
lf[352]=C_h_intern(&lf[352],21, C_text("scheme#inexact->exact"));
lf[353]=C_h_intern(&lf[353],15, C_text("scheme#truncate"));
lf[354]=C_h_intern(&lf[354],10, C_text("scheme#max"));
lf[355]=C_h_intern(&lf[355],11, C_text("create-pipe"));
lf[356]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\023\143\141\156\156\157\164\040\143\162\145\141\164\145\040\160\151\160\145\000"));
lf[357]=C_h_intern(&lf[357],16, C_text("set-signal-mask!"));
lf[358]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\027\143\141\156\156\157\164\040\163\145\164\040\163\151\147\156\141\154\040\155\141\163\153\000"));
lf[359]=C_h_intern(&lf[359],14, C_text("signal-masked?"));
lf[360]=C_h_intern(&lf[360],12, C_text("signal-mask!"));
lf[361]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\024\143\141\156\156\157\164\040\142\154\157\143\153\040\163\151\147\156\141\154\000"));
lf[362]=C_h_intern(&lf[362],14, C_text("signal-unmask!"));
lf[363]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\026\143\141\156\156\157\164\040\165\156\142\154\157\143\153\040\163\151\147\156\141\154\000"));
lf[364]=C_h_intern(&lf[364],13, C_text("scheme#vector"));
lf[365]=C_h_intern(&lf[365],11, C_text("scheme#list"));
lf[366]=C_h_intern(&lf[366],27, C_text("##sys#peek-nonnull-c-string"));
lf[367]=C_h_intern(&lf[367],16, C_text("user-information"));
lf[368]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\031\143\141\156\156\157\164\040\143\150\141\156\147\145\040\146\151\154\145\040\157\167\156\145\162\000"));
lf[369]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\061\142\141\144\040\141\162\147\165\155\145\156\164\040\164\171\160\145\040\055\040\156\157\164\040\141\040\146\151\170\156\165\155\054\040\160\157\162\164\040\157\162\040\163\164\162\151\156\147\000"));
lf[370]=C_h_intern(&lf[370],17, C_text("##sys#error/errno"));
lf[371]=C_h_intern(&lf[371],14, C_text("create-session"));
lf[372]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\026\143\141\156\156\157\164\040\143\162\145\141\164\145\040\163\145\163\163\151\157\156\000"));
lf[373]=C_h_intern(&lf[373],20, C_text("create-symbolic-link"));
lf[374]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\034\143\141\156\156\157\164\040\143\162\145\141\164\145\040\163\171\155\142\157\154\151\143\040\154\151\156\153\000"));
lf[375]=C_h_intern(&lf[375],24, C_text("##sys#read-symbolic-link"));
lf[376]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\032\143\141\156\156\157\164\040\162\145\141\144\040\163\171\155\142\157\154\151\143\040\154\151\156\153\000"));
lf[377]=C_h_intern(&lf[377],20, C_text("##sys#buffer->string"));
lf[378]=C_h_intern(&lf[378],18, C_text("read-symbolic-link"));
lf[379]=C_h_intern(&lf[379],36, C_text("chicken.pathname#decompose-directory"));
lf[380]=C_h_intern(&lf[380],30, C_text("chicken.pathname#make-pathname"));
lf[381]=C_h_intern(&lf[381],35, C_text("chicken.pathname#absolute-pathname?"));
lf[382]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\112\143\157\165\154\144\040\156\157\164\040\143\141\156\157\156\151\143\141\154\151\172\145\040\160\141\164\150\040\167\151\164\150\040\163\171\155\142\157\154\151\143\040\154\151\156\153\163\054\040\143\157\155\160\157\156\145\156\164\040\144\157\145\163\040\156\157\164\040\145\170\151\163\164\000"));
lf[383]=C_h_intern(&lf[383],18, C_text("##sys#file-exists?"));
lf[384]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\001\000"));
lf[385]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\001\000"));
lf[386]=C_h_intern(&lf[386],9, C_text("file-link"));
lf[387]=C_h_intern(&lf[387],9, C_text("hard-link"));
lf[388]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\033\143\157\165\154\144\040\156\157\164\040\143\162\145\141\164\145\040\150\141\162\144\040\154\151\156\153\000"));
lf[389]=C_h_intern(&lf[389],23, C_text("##sys#custom-input-port"));
lf[390]=C_h_intern(&lf[390],17, C_text("chicken.base#void"));
lf[391]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\016\143\141\156\156\157\164\040\163\145\154\145\143\164\000"));
lf[392]=C_h_intern(&lf[392],19, C_text("##sys#decode-buffer"));
lf[393]=C_h_intern(&lf[393],19, C_text("##sys#thread-yield!"));
lf[394]=C_h_intern(&lf[394],27, C_text("##sys#thread-block-for-i/o!"));
lf[395]=C_h_intern(&lf[395],20, C_text("##sys#current-thread"));
lf[396]=C_h_intern_kw(&lf[396],5, C_text("input"));
lf[397]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\014\143\141\156\156\157\164\040\162\145\141\144\000"));
lf[398]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\014\143\141\156\156\157\164\040\162\145\141\144\000"));
lf[399]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\015\143\141\156\156\157\164\040\143\154\157\163\145\000"));
lf[400]=C_h_intern(&lf[400],35, C_text("chicken.fixnum#most-positive-fixnum"));
lf[401]=C_h_intern(&lf[401],22, C_text("##sys#scan-buffer-line"));
lf[402]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\001\000"));
lf[403]=C_h_intern(&lf[403],29, C_text("##sys#buffer->string/encoding"));
lf[404]=C_h_intern(&lf[404],28, C_text("chicken.port#make-input-port"));
lf[405]=C_h_intern_kw(&lf[405],9, C_text("peek-char"));
lf[406]=C_h_intern_kw(&lf[406],15, C_text("read-bytevector"));
lf[407]=C_h_intern_kw(&lf[407],9, C_text("read-line"));
lf[408]=C_h_intern_kw(&lf[408],13, C_text("read-buffered"));
lf[409]=C_h_intern(&lf[409],24, C_text("##sys#custom-output-port"));
lf[410]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\015\143\141\156\156\157\164\040\167\162\151\164\145\000"));
lf[411]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\015\143\141\156\156\157\164\040\143\154\157\163\145\000"));
lf[412]=C_h_intern(&lf[412],29, C_text("chicken.port#make-output-port"));
lf[413]=C_h_intern_kw(&lf[413],12, C_text("force-output"));
lf[414]=C_h_intern(&lf[414],13, C_text("file-truncate"));
lf[415]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\025\143\141\156\156\157\164\040\164\162\165\156\143\141\164\145\040\146\151\154\145\000"));
lf[416]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\015\151\156\166\141\154\151\144\040\146\151\154\145\000"));
lf[417]=C_h_intern(&lf[417],9, C_text("file-lock"));
lf[418]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\024\154\157\143\153\151\156\147\040\146\151\154\145\040\146\141\151\154\145\144\000"));
lf[419]=C_h_intern(&lf[419],18, C_text("file-lock/blocking"));
lf[420]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\024\154\157\143\153\151\156\147\040\146\151\154\145\040\146\141\151\154\145\144\000"));
lf[421]=C_h_intern(&lf[421],11, C_text("file-unlock"));
lf[422]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\026\165\156\154\157\143\153\151\156\147\040\146\151\154\145\040\146\141\151\154\145\144\000"));
lf[423]=C_h_intern(&lf[423],11, C_text("create-fifo"));
lf[424]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\023\143\141\156\156\157\164\040\143\162\145\141\164\145\040\106\111\106\117\000"));
lf[425]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\030\045\141\040\045\142\040\045\145\040\045\110\072\045\115\072\045\123\040\045\132\040\045\131\000"));
lf[426]=C_h_intern(&lf[426],12, C_text("string->time"));
lf[427]=C_h_intern(&lf[427],17, C_text("utc-time->seconds"));
lf[428]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\046\143\141\156\156\157\164\040\143\157\156\166\145\162\164\040\164\151\155\145\040\166\145\143\164\157\162\040\164\157\040\163\145\143\157\156\144\163\000"));
lf[429]=C_h_intern(&lf[429],12, C_text("process-fork"));
lf[430]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\034\143\141\156\156\157\164\040\143\162\145\141\164\145\040\143\150\151\154\144\040\160\162\157\143\145\163\163\000"));
lf[431]=C_h_intern(&lf[431],17, C_text("chicken.base#exit"));
lf[432]=C_h_intern(&lf[432],23, C_text("##sys#call-with-cthulhu"));
lf[433]=C_h_intern(&lf[433],24, C_text("##sys#kill-other-threads"));
lf[434]=C_h_intern(&lf[434],15, C_text("process-execute"));
lf[435]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\027\143\141\156\156\157\164\040\145\170\145\143\165\164\145\040\160\162\157\143\145\163\163\000"));
lf[436]=C_h_intern(&lf[436],14, C_text("process-signal"));
lf[437]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\041\143\157\165\154\144\040\156\157\164\040\163\145\156\144\040\163\151\147\156\141\154\040\164\157\040\160\162\157\143\145\163\163\000"));
lf[438]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\010\057\142\151\156\057\163\150\000"));
lf[439]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\003\055\143\000"));
lf[440]=C_h_intern(&lf[440],48, C_text("chicken.process-context#get-environment-variable"));
lf[441]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\006\123\110\105\114\114\000"));
lf[442]=C_h_intern(&lf[442],21, C_text("##sys#undefined-value"));
lf[444]=C_h_intern(&lf[444],7, C_text("process"));
lf[445]=C_h_intern(&lf[445],8, C_text("process*"));
lf[446]=C_h_intern(&lf[446],19, C_text("set-root-directory!"));
lf[447]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\040\165\156\141\142\154\145\040\164\157\040\143\150\141\156\147\145\040\162\157\157\164\040\144\151\162\145\143\164\157\162\171\000"));
lf[448]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\060\164\150\151\163\040\146\165\156\143\164\151\157\156\040\151\163\040\156\157\164\040\141\166\141\151\154\141\142\154\145\040\157\156\040\164\150\151\163\040\160\154\141\164\146\157\162\155\000"));
lf[449]=C_h_intern(&lf[449],14, C_text("chicken.errno#"));
lf[450]=C_h_intern(&lf[450],19, C_text("chicken.errno#errno"));
lf[451]=C_h_intern(&lf[451],11, C_text("##sys#errno"));
lf[452]=C_h_intern(&lf[452],24, C_text("chicken.errno#errno/2big"));
lf[453]=C_h_intern(&lf[453],25, C_text("chicken.errno#errno/acces"));
lf[454]=C_h_intern(&lf[454],25, C_text("chicken.errno#errno/again"));
lf[455]=C_h_intern(&lf[455],24, C_text("chicken.errno#errno/badf"));
lf[456]=C_h_intern(&lf[456],24, C_text("chicken.errno#errno/busy"));
lf[457]=C_h_intern(&lf[457],25, C_text("chicken.errno#errno/child"));
lf[458]=C_h_intern(&lf[458],26, C_text("chicken.errno#errno/deadlk"));
lf[459]=C_h_intern(&lf[459],23, C_text("chicken.errno#errno/dom"));
lf[460]=C_h_intern(&lf[460],25, C_text("chicken.errno#errno/exist"));
lf[461]=C_h_intern(&lf[461],25, C_text("chicken.errno#errno/fault"));
lf[462]=C_h_intern(&lf[462],24, C_text("chicken.errno#errno/fbig"));
lf[463]=C_h_intern(&lf[463],25, C_text("chicken.errno#errno/ilseq"));
lf[464]=C_h_intern(&lf[464],24, C_text("chicken.errno#errno/intr"));
lf[465]=C_h_intern(&lf[465],25, C_text("chicken.errno#errno/inval"));
lf[466]=C_h_intern(&lf[466],22, C_text("chicken.errno#errno/io"));
lf[467]=C_h_intern(&lf[467],25, C_text("chicken.errno#errno/isdir"));
lf[468]=C_h_intern(&lf[468],25, C_text("chicken.errno#errno/mfile"));
lf[469]=C_h_intern(&lf[469],25, C_text("chicken.errno#errno/mlink"));
lf[470]=C_h_intern(&lf[470],31, C_text("chicken.errno#errno/nametoolong"));
lf[471]=C_h_intern(&lf[471],25, C_text("chicken.errno#errno/nfile"));
lf[472]=C_h_intern(&lf[472],25, C_text("chicken.errno#errno/nodev"));
lf[473]=C_h_intern(&lf[473],25, C_text("chicken.errno#errno/noent"));
lf[474]=C_h_intern(&lf[474],26, C_text("chicken.errno#errno/noexec"));
lf[475]=C_h_intern(&lf[475],25, C_text("chicken.errno#errno/nolck"));
lf[476]=C_h_intern(&lf[476],25, C_text("chicken.errno#errno/nomem"));
lf[477]=C_h_intern(&lf[477],25, C_text("chicken.errno#errno/nospc"));
lf[478]=C_h_intern(&lf[478],25, C_text("chicken.errno#errno/nosys"));
lf[479]=C_h_intern(&lf[479],26, C_text("chicken.errno#errno/notdir"));
lf[480]=C_h_intern(&lf[480],28, C_text("chicken.errno#errno/notempty"));
lf[481]=C_h_intern(&lf[481],25, C_text("chicken.errno#errno/notty"));
lf[482]=C_h_intern(&lf[482],24, C_text("chicken.errno#errno/nxio"));
lf[483]=C_h_intern(&lf[483],24, C_text("chicken.errno#errno/perm"));
lf[484]=C_h_intern(&lf[484],24, C_text("chicken.errno#errno/pipe"));
lf[485]=C_h_intern(&lf[485],25, C_text("chicken.errno#errno/range"));
lf[486]=C_h_intern(&lf[486],24, C_text("chicken.errno#errno/rofs"));
lf[487]=C_h_intern(&lf[487],25, C_text("chicken.errno#errno/spipe"));
lf[488]=C_h_intern(&lf[488],24, C_text("chicken.errno#errno/srch"));
lf[489]=C_h_intern(&lf[489],30, C_text("chicken.errno#errno/wouldblock"));
lf[490]=C_h_intern(&lf[490],24, C_text("chicken.errno#errno/xdev"));
lf[491]=C_h_intern(&lf[491],16, C_text("process-group-id"));
lf[492]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\041\143\141\156\156\157\164\040\162\145\164\162\151\145\166\145\040\160\162\157\143\145\163\163\040\147\162\157\165\160\040\111\104\000"));
lf[493]=C_h_intern(&lf[493],13, C_text("process-group"));
lf[494]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\034\143\141\156\156\157\164\040\163\145\164\040\160\162\157\143\145\163\163\040\147\162\157\165\160\040\111\104\000"));
lf[495]=C_h_intern(&lf[495],31, C_text("chicken.base#getter-with-setter"));
lf[496]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\065\050\143\150\151\143\153\145\156\056\160\162\157\143\145\163\163\055\143\157\156\164\145\170\164\056\160\157\163\151\170\043\160\162\157\143\145\163\163\055\147\162\157\165\160\055\151\144\040\160\151\144\051\000"));
lf[497]=C_h_intern(&lf[497],26, C_text("current-effective-group-id"));
lf[498]=C_h_intern(&lf[498],26, C_text("effective-group-id!-setter"));
lf[499]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\036\143\141\156\156\157\164\040\163\145\164\040\145\146\146\145\143\164\151\166\145\040\147\162\157\165\160\040\111\104\000"));
lf[500]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\073\050\143\150\151\143\153\145\156\056\160\162\157\143\145\163\163\055\143\157\156\164\145\170\164\056\160\157\163\151\170\043\143\165\162\162\145\156\164\055\145\146\146\145\143\164\151\166\145\055\147\162\157\165\160\055\151\144\051\000"));
lf[501]=C_h_intern(&lf[501],16, C_text("current-group-id"));
lf[502]=C_h_intern(&lf[502],24, C_text("current-group-id!-setter"));
lf[503]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\024\143\141\156\156\157\164\040\163\145\164\040\147\162\157\165\160\040\111\104\000"));
lf[504]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\061\050\143\150\151\143\153\145\156\056\160\162\157\143\145\163\163\055\143\157\156\164\145\170\164\056\160\157\163\151\170\043\143\165\162\162\145\156\164\055\147\162\157\165\160\055\151\144\051\000"));
lf[505]=C_h_intern(&lf[505],25, C_text("current-effective-user-id"));
lf[506]=C_h_intern(&lf[506],25, C_text("effective-user-id!-setter"));
lf[507]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\035\143\141\156\156\157\164\040\163\145\164\040\145\146\146\145\143\164\151\166\145\040\165\163\145\162\040\111\104\000"));
lf[508]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\072\050\143\150\151\143\153\145\156\056\160\162\157\143\145\163\163\055\143\157\156\164\145\170\164\056\160\157\163\151\170\043\143\165\162\162\145\156\164\055\145\146\146\145\143\164\151\166\145\055\165\163\145\162\055\151\144\051\000"));
lf[509]=C_h_intern(&lf[509],15, C_text("current-user-id"));
lf[510]=C_h_intern(&lf[510],23, C_text("current-user-id!-setter"));
lf[511]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\023\143\141\156\156\157\164\040\163\145\164\040\165\163\145\162\040\111\104\000"));
lf[512]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\060\050\143\150\151\143\153\145\156\056\160\162\157\143\145\163\163\055\143\157\156\164\145\170\164\056\160\157\163\151\170\043\143\165\162\162\145\156\164\055\165\163\145\162\055\151\144\051\000"));
lf[513]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\045\050\143\150\151\143\153\145\156\056\160\162\157\143\145\163\163\056\163\151\147\156\141\154\043\163\151\147\156\141\154\055\155\141\163\153\051\000"));
lf[514]=C_h_intern(&lf[514],14, C_text("signal-handler"));
lf[515]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\054\050\143\150\151\143\153\145\156\056\160\162\157\143\145\163\163\056\163\151\147\156\141\154\043\163\151\147\156\141\154\055\150\141\156\144\154\145\162\040\163\151\147\051\000"));
lf[516]=C_h_intern(&lf[516],18, C_text("file-creation-mode"));
lf[517]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\055\050\143\150\151\143\153\145\156\056\146\151\154\145\056\160\157\163\151\170\043\146\151\154\145\055\143\162\145\141\164\151\157\156\055\155\157\144\145\040\155\157\144\145\051\000"));
lf[518]=C_h_intern(&lf[518],13, C_text("file-position"));
lf[519]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\046\143\141\156\156\157\164\040\162\145\164\162\151\145\166\145\040\146\151\154\145\040\160\157\163\151\164\151\157\156\040\157\146\040\160\157\162\164\000"));
lf[520]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\015\151\156\166\141\154\151\144\040\146\151\154\145\000"));
lf[521]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\050\050\143\150\151\143\153\145\156\056\146\151\154\145\056\160\157\163\151\170\043\146\151\154\145\055\160\157\163\151\164\151\157\156\040\160\157\162\164\051\000"));
lf[522]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\050\050\143\150\151\143\153\145\156\056\146\151\154\145\056\160\157\163\151\170\043\146\151\154\145\055\160\145\162\155\151\163\163\151\157\156\163\040\146\051\000"));
lf[523]=C_h_intern(&lf[523],10, C_text("file-group"));
lf[524]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\042\050\143\150\151\143\153\145\156\056\146\151\154\145\056\160\157\163\151\170\043\146\151\154\145\055\147\162\157\165\160\040\146\051\000"));
lf[525]=C_h_intern(&lf[525],10, C_text("file-owner"));
lf[526]=C_decode_literal(C_heaptop,C_text("\376\002\000\000\042\050\143\150\151\143\153\145\156\056\146\151\154\145\056\160\157\163\151\170\043\146\151\154\145\055\157\167\156\145\162\040\146\051\000"));
C_register_lf2(lf,527,create_ptable());{}
t2=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_2906,a[2]=t1,tmp=(C_word)a,a+=3,tmp);{
C_word *av2=av;
av2[0]=C_SCHEME_UNDEFINED;
av2[1]=t2;
C_scheduler_toplevel(2,av2);}}

/* va9621 in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void va9621(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word t3;
C_word t4;
C_word t5;
C_word t6;
C_word t7;
C_word t8;
C_word t9;
C_word t10;
C_word t11;
C_word t12;
C_word t13;
C_word t14;
C_word t15;
C_word t16;
C_word t17;
C_word t18;
C_word t19;
C_word t20;
C_word t21;
C_word t22;
C_word t23;
C_word t24;
C_word t25;
C_word t26;
C_word t27;
C_word t28;
C_word t29;
C_word t30;
C_word t31;
C_word t32;
C_word t33;
C_word t34;
C_word t35;
C_word t36;
C_word t37;
C_word t38;
C_word t39;
C_word t40;
C_word t41;
C_word t42;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(114,0,4)))){
C_save_and_reclaim_args((void *)trva9621,2,t0,t1);}
a=C_alloc(114);
t2=C_s_a_i_bitwise_ior(&a,2,t1,C_fix((C_word)S_IWOTH));
t3=C_mutate((C_word*)lf[19]+1 /* (set! chicken.file.posix#file-open ...) */,(*a=C_CLOSURE_TYPE|3,a[1]=(C_word)f_5327,a[2]=t2,a[3]=((C_word)li109),tmp=(C_word)a,a+=4,tmp));
t4=C_mutate((C_word*)lf[11]+1 /* (set! chicken.file.posix#file-close ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5359,a[2]=((C_word)li111),tmp=(C_word)a,a+=3,tmp));
t5=C_mutate((C_word*)lf[23]+1 /* (set! chicken.file.posix#file-read ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5390,a[2]=((C_word)li112),tmp=(C_word)a,a+=3,tmp));
t6=C_mutate((C_word*)lf[27]+1 /* (set! chicken.file.posix#file-write ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5427,a[2]=((C_word)li113),tmp=(C_word)a,a+=3,tmp));
t7=C_mutate((C_word*)lf[18]+1 /* (set! chicken.file.posix#file-mkstemp ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5461,a[2]=((C_word)li114),tmp=(C_word)a,a+=3,tmp));
t8=C_mutate((C_word*)lf[24]+1 /* (set! chicken.file.posix#file-select ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5493,a[2]=((C_word)li119),tmp=(C_word)a,a+=3,tmp));
t9=C_mutate((C_word*)lf[116]+1 /* (set! chicken.process#create-pipe ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5872,a[2]=((C_word)li120),tmp=(C_word)a,a+=3,tmp));
t10=C_set_block_item(lf[166] /* chicken.process.signal#signal/term */,0,C_fix((C_word)SIGTERM));
t11=C_set_block_item(lf[160] /* chicken.process.signal#signal/kill */,0,C_fix((C_word)SIGKILL));
t12=C_set_block_item(lf[158] /* chicken.process.signal#signal/int */,0,C_fix((C_word)SIGINT));
t13=C_set_block_item(lf[156] /* chicken.process.signal#signal/hup */,0,C_fix((C_word)SIGHUP));
t14=C_set_block_item(lf[155] /* chicken.process.signal#signal/fpe */,0,C_fix((C_word)SIGFPE));
t15=C_set_block_item(lf[157] /* chicken.process.signal#signal/ill */,0,C_fix((C_word)SIGILL));
t16=C_set_block_item(lf[164] /* chicken.process.signal#signal/segv */,0,C_fix((C_word)SIGSEGV));
t17=C_set_block_item(lf[149] /* chicken.process.signal#signal/abrt */,0,C_fix((C_word)SIGABRT));
t18=C_set_block_item(lf[167] /* chicken.process.signal#signal/trap */,0,C_fix((C_word)SIGTRAP));
t19=C_set_block_item(lf[163] /* chicken.process.signal#signal/quit */,0,C_fix((C_word)SIGQUIT));
t20=C_set_block_item(lf[150] /* chicken.process.signal#signal/alrm */,0,C_fix((C_word)SIGALRM));
t21=C_set_block_item(lf[172] /* chicken.process.signal#signal/vtalrm */,0,C_fix((C_word)SIGVTALRM));
t22=C_set_block_item(lf[162] /* chicken.process.signal#signal/prof */,0,C_fix((C_word)SIGPROF));
t23=C_set_block_item(lf[159] /* chicken.process.signal#signal/io */,0,C_fix((C_word)SIGIO));
t24=C_set_block_item(lf[169] /* chicken.process.signal#signal/urg */,0,C_fix((C_word)SIGURG));
t25=C_set_block_item(lf[153] /* chicken.process.signal#signal/chld */,0,C_fix((C_word)SIGCHLD));
t26=C_set_block_item(lf[154] /* chicken.process.signal#signal/cont */,0,C_fix((C_word)SIGCONT));
t27=C_set_block_item(lf[165] /* chicken.process.signal#signal/stop */,0,C_fix((C_word)SIGSTOP));
t28=C_set_block_item(lf[168] /* chicken.process.signal#signal/tstp */,0,C_fix((C_word)SIGTSTP));
t29=C_set_block_item(lf[161] /* chicken.process.signal#signal/pipe */,0,C_fix((C_word)SIGPIPE));
t30=C_set_block_item(lf[174] /* chicken.process.signal#signal/xcpu */,0,C_fix((C_word)SIGXCPU));
t31=C_set_block_item(lf[175] /* chicken.process.signal#signal/xfsz */,0,C_fix((C_word)SIGXFSZ));
t32=C_set_block_item(lf[170] /* chicken.process.signal#signal/usr1 */,0,C_fix((C_word)SIGUSR1));
t33=C_set_block_item(lf[171] /* chicken.process.signal#signal/usr2 */,0,C_fix((C_word)SIGUSR2));
t34=C_set_block_item(lf[173] /* chicken.process.signal#signal/winch */,0,C_fix((C_word)SIGWINCH));
t35=C_set_block_item(lf[152] /* chicken.process.signal#signal/bus */,0,C_fix((C_word)SIGBUS));
t36=C_set_block_item(lf[151] /* chicken.process.signal#signal/break */,0,C_fix(0));
t37=C_a_i_list(&a,26,*((C_word*)lf[166]+1),*((C_word*)lf[160]+1),*((C_word*)lf[158]+1),*((C_word*)lf[156]+1),*((C_word*)lf[155]+1),*((C_word*)lf[157]+1),*((C_word*)lf[164]+1),*((C_word*)lf[149]+1),*((C_word*)lf[167]+1),*((C_word*)lf[163]+1),*((C_word*)lf[150]+1),*((C_word*)lf[172]+1),*((C_word*)lf[162]+1),*((C_word*)lf[159]+1),*((C_word*)lf[169]+1),*((C_word*)lf[153]+1),*((C_word*)lf[154]+1),*((C_word*)lf[165]+1),*((C_word*)lf[168]+1),*((C_word*)lf[161]+1),*((C_word*)lf[174]+1),*((C_word*)lf[175]+1),*((C_word*)lf[170]+1),*((C_word*)lf[171]+1),*((C_word*)lf[173]+1),*((C_word*)lf[152]+1));
t38=C_mutate((C_word*)lf[176]+1 /* (set! chicken.process.signal#signals-list ...) */,t37);
t39=C_mutate((C_word*)lf[140]+1 /* (set! chicken.process.signal#set-signal-mask! ...) */,(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5928,a[2]=((C_word)li122),tmp=(C_word)a,a+=3,tmp));
t40=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_5977,a[2]=((C_word*)t0)[2],tmp=(C_word)a,a+=3,tmp);
t41=(*a=C_CLOSURE_TYPE|2,a[1]=(C_word)f_8533,a[2]=((C_word)li224),tmp=(C_word)a,a+=3,tmp);
/* posixunix.scm:575: chicken.base#getter-with-setter */
t42=*((C_word*)lf[495]+1);{
C_word av2[5];
av2[0]=t42;
av2[1]=t40;
av2[2]=t41;
av2[3]=*((C_word*)lf[140]+1);
av2[4]=lf[513];
((C_proc)(void*)(*((C_word*)t42+1)))(5,av2);}}

/* va9623 in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void va9623(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,1)))){
C_save_and_reclaim_args((void *)trva9623,2,t0,t1);}
a=C_alloc(5);
t2=((C_word*)t0)[2];
va9621(t2,C_s_a_i_bitwise_ior(&a,2,t1,C_fix((C_word)S_IROTH)));}

/* va9625 in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void va9625(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,1)))){
C_save_and_reclaim_args((void *)trva9625,2,t0,t1);}
a=C_alloc(5);
t2=((C_word*)t0)[2];
va9623(t2,C_s_a_i_bitwise_ior(&a,2,t1,C_fix((C_word)S_IWGRP)));}

/* va9627 in k4216 in k3981 in k3693 in k3476 in k3472 in k3468 in k2919 in k2916 in k2913 in k2910 in k2907 in k2904 */
static void va9627(C_word t0,C_word t1){
C_word tmp;
C_word t2;
C_word *a;
if(C_unlikely(!C_demand(C_calculate_demand(5,0,1)))){
C_save_and_reclaim_args((void *)trva9627,2,t0,t1);}
a=C_alloc(5);
t2=((C_word*)t0)[2];
va9625(t2,C_s_a_i_bitwise_ior(&a,2,t1,C_fix((C_word)S_IRGRP)));}

#ifdef C_ENABLE_PTABLES
static C_PTABLE_ENTRY ptable[500] = {
{C_text("f9632:posix_2escm"),(void*)f9632},
{C_text("f9636:posix_2escm"),(void*)f9636},
{C_text("f9684:posix_2escm"),(void*)f9684},
{C_text("f9690:posix_2escm"),(void*)f9690},
{C_text("f_2906:posix_2escm"),(void*)f_2906},
{C_text("f_2909:posix_2escm"),(void*)f_2909},
{C_text("f_2912:posix_2escm"),(void*)f_2912},
{C_text("f_2915:posix_2escm"),(void*)f_2915},
{C_text("f_2918:posix_2escm"),(void*)f_2918},
{C_text("f_2921:posix_2escm"),(void*)f_2921},
{C_text("f_3006:posix_2escm"),(void*)f_3006},
{C_text("f_3023:posix_2escm"),(void*)f_3023},
{C_text("f_3025:posix_2escm"),(void*)f_3025},
{C_text("f_3029:posix_2escm"),(void*)f_3029},
{C_text("f_3041:posix_2escm"),(void*)f_3041},
{C_text("f_3045:posix_2escm"),(void*)f_3045},
{C_text("f_3055:posix_2escm"),(void*)f_3055},
{C_text("f_3076:posix_2escm"),(void*)f_3076},
{C_text("f_3079:posix_2escm"),(void*)f_3079},
{C_text("f_3090:posix_2escm"),(void*)f_3090},
{C_text("f_3096:posix_2escm"),(void*)f_3096},
{C_text("f_3121:posix_2escm"),(void*)f_3121},
{C_text("f_3238:posix_2escm"),(void*)f_3238},
{C_text("f_3242:posix_2escm"),(void*)f_3242},
{C_text("f_3249:posix_2escm"),(void*)f_3249},
{C_text("f_3253:posix_2escm"),(void*)f_3253},
{C_text("f_3256:posix_2escm"),(void*)f_3256},
{C_text("f_3260:posix_2escm"),(void*)f_3260},
{C_text("f_3281:posix_2escm"),(void*)f_3281},
{C_text("f_3285:posix_2escm"),(void*)f_3285},
{C_text("f_3294:posix_2escm"),(void*)f_3294},
{C_text("f_3302:posix_2escm"),(void*)f_3302},
{C_text("f_3309:posix_2escm"),(void*)f_3309},
{C_text("f_3320:posix_2escm"),(void*)f_3320},
{C_text("f_3327:posix_2escm"),(void*)f_3327},
{C_text("f_3345:posix_2escm"),(void*)f_3345},
{C_text("f_3349:posix_2escm"),(void*)f_3349},
{C_text("f_3359:posix_2escm"),(void*)f_3359},
{C_text("f_3364:posix_2escm"),(void*)f_3364},
{C_text("f_3368:posix_2escm"),(void*)f_3368},
{C_text("f_3370:posix_2escm"),(void*)f_3370},
{C_text("f_3374:posix_2escm"),(void*)f_3374},
{C_text("f_3376:posix_2escm"),(void*)f_3376},
{C_text("f_3380:posix_2escm"),(void*)f_3380},
{C_text("f_3382:posix_2escm"),(void*)f_3382},
{C_text("f_3386:posix_2escm"),(void*)f_3386},
{C_text("f_3398:posix_2escm"),(void*)f_3398},
{C_text("f_3401:posix_2escm"),(void*)f_3401},
{C_text("f_3450:posix_2escm"),(void*)f_3450},
{C_text("f_3454:posix_2escm"),(void*)f_3454},
{C_text("f_3456:posix_2escm"),(void*)f_3456},
{C_text("f_3462:posix_2escm"),(void*)f_3462},
{C_text("f_3470:posix_2escm"),(void*)f_3470},
{C_text("f_3474:posix_2escm"),(void*)f_3474},
{C_text("f_3478:posix_2escm"),(void*)f_3478},
{C_text("f_3480:posix_2escm"),(void*)f_3480},
{C_text("f_3499:posix_2escm"),(void*)f_3499},
{C_text("f_3567:posix_2escm"),(void*)f_3567},
{C_text("f_3575:posix_2escm"),(void*)f_3575},
{C_text("f_3577:posix_2escm"),(void*)f_3577},
{C_text("f_3585:posix_2escm"),(void*)f_3585},
{C_text("f_3587:posix_2escm"),(void*)f_3587},
{C_text("f_3595:posix_2escm"),(void*)f_3595},
{C_text("f_3597:posix_2escm"),(void*)f_3597},
{C_text("f_3605:posix_2escm"),(void*)f_3605},
{C_text("f_3607:posix_2escm"),(void*)f_3607},
{C_text("f_3615:posix_2escm"),(void*)f_3615},
{C_text("f_3617:posix_2escm"),(void*)f_3617},
{C_text("f_3625:posix_2escm"),(void*)f_3625},
{C_text("f_3627:posix_2escm"),(void*)f_3627},
{C_text("f_3635:posix_2escm"),(void*)f_3635},
{C_text("f_3640:posix_2escm"),(void*)f_3640},
{C_text("f_3656:posix_2escm"),(void*)f_3656},
{C_text("f_3662:posix_2escm"),(void*)f_3662},
{C_text("f_3695:posix_2escm"),(void*)f_3695},
{C_text("f_3723:posix_2escm"),(void*)f_3723},
{C_text("f_3731:posix_2escm"),(void*)f_3731},
{C_text("f_3756:posix_2escm"),(void*)f_3756},
{C_text("f_3769:posix_2escm"),(void*)f_3769},
{C_text("f_3778:posix_2escm"),(void*)f_3778},
{C_text("f_3802:posix_2escm"),(void*)f_3802},
{C_text("f_3828:posix_2escm"),(void*)f_3828},
{C_text("f_3852:posix_2escm"),(void*)f_3852},
{C_text("f_3878:posix_2escm"),(void*)f_3878},
{C_text("f_3894:posix_2escm"),(void*)f_3894},
{C_text("f_3903:posix_2escm"),(void*)f_3903},
{C_text("f_3917:posix_2escm"),(void*)f_3917},
{C_text("f_3923:posix_2escm"),(void*)f_3923},
{C_text("f_3930:posix_2escm"),(void*)f_3930},
{C_text("f_3933:posix_2escm"),(void*)f_3933},
{C_text("f_3950:posix_2escm"),(void*)f_3950},
{C_text("f_3953:posix_2escm"),(void*)f_3953},
{C_text("f_3960:posix_2escm"),(void*)f_3960},
{C_text("f_3969:posix_2escm"),(void*)f_3969},
{C_text("f_3983:posix_2escm"),(void*)f_3983},
{C_text("f_3986:posix_2escm"),(void*)f_3986},
{C_text("f_4005:posix_2escm"),(void*)f_4005},
{C_text("f_4009:posix_2escm"),(void*)f_4009},
{C_text("f_4012:posix_2escm"),(void*)f_4012},
{C_text("f_4026:posix_2escm"),(void*)f_4026},
{C_text("f_4030:posix_2escm"),(void*)f_4030},
{C_text("f_4033:posix_2escm"),(void*)f_4033},
{C_text("f_4058:posix_2escm"),(void*)f_4058},
{C_text("f_4062:posix_2escm"),(void*)f_4062},
{C_text("f_4065:posix_2escm"),(void*)f_4065},
{C_text("f_4068:posix_2escm"),(void*)f_4068},
{C_text("f_4096:posix_2escm"),(void*)f_4096},
{C_text("f_4100:posix_2escm"),(void*)f_4100},
{C_text("f_4104:posix_2escm"),(void*)f_4104},
{C_text("f_4141:posix_2escm"),(void*)f_4141},
{C_text("f_4148:posix_2escm"),(void*)f_4148},
{C_text("f_4157:posix_2escm"),(void*)f_4157},
{C_text("f_4167:posix_2escm"),(void*)f_4167},
{C_text("f_4171:posix_2escm"),(void*)f_4171},
{C_text("f_4174:posix_2escm"),(void*)f_4174},
{C_text("f_4195:posix_2escm"),(void*)f_4195},
{C_text("f_4203:posix_2escm"),(void*)f_4203},
{C_text("f_4218:posix_2escm"),(void*)f_4218},
{C_text("f_4220:posix_2escm"),(void*)f_4220},
{C_text("f_4224:posix_2escm"),(void*)f_4224},
{C_text("f_4225:posix_2escm"),(void*)f_4225},
{C_text("f_4234:posix_2escm"),(void*)f_4234},
{C_text("f_4241:posix_2escm"),(void*)f_4241},
{C_text("f_4242:posix_2escm"),(void*)f_4242},
{C_text("f_4263:posix_2escm"),(void*)f_4263},
{C_text("f_4273:posix_2escm"),(void*)f_4273},
{C_text("f_4286:posix_2escm"),(void*)f_4286},
{C_text("f_4295:posix_2escm"),(void*)f_4295},
{C_text("f_4312:posix_2escm"),(void*)f_4312},
{C_text("f_4327:posix_2escm"),(void*)f_4327},
{C_text("f_4345:posix_2escm"),(void*)f_4345},
{C_text("f_4363:posix_2escm"),(void*)f_4363},
{C_text("f_4381:posix_2escm"),(void*)f_4381},
{C_text("f_4399:posix_2escm"),(void*)f_4399},
{C_text("f_4417:posix_2escm"),(void*)f_4417},
{C_text("f_4474:posix_2escm"),(void*)f_4474},
{C_text("f_4506:posix_2escm"),(void*)f_4506},
{C_text("f_4512:posix_2escm"),(void*)f_4512},
{C_text("f_4531:posix_2escm"),(void*)f_4531},
{C_text("f_4549:posix_2escm"),(void*)f_4549},
{C_text("f_4557:posix_2escm"),(void*)f_4557},
{C_text("f_4563:posix_2escm"),(void*)f_4563},
{C_text("f_4585:posix_2escm"),(void*)f_4585},
{C_text("f_4591:posix_2escm"),(void*)f_4591},
{C_text("f_4600:posix_2escm"),(void*)f_4600},
{C_text("f_4648:posix_2escm"),(void*)f_4648},
{C_text("f_4656:posix_2escm"),(void*)f_4656},
{C_text("f_4659:posix_2escm"),(void*)f_4659},
{C_text("f_4664:posix_2escm"),(void*)f_4664},
{C_text("f_4670:posix_2escm"),(void*)f_4670},
{C_text("f_4676:posix_2escm"),(void*)f_4676},
{C_text("f_4680:posix_2escm"),(void*)f_4680},
{C_text("f_4685:posix_2escm"),(void*)f_4685},
{C_text("f_4687:posix_2escm"),(void*)f_4687},
{C_text("f_4691:posix_2escm"),(void*)f_4691},
{C_text("f_4693:posix_2escm"),(void*)f_4693},
{C_text("f_4709:posix_2escm"),(void*)f_4709},
{C_text("f_4715:posix_2escm"),(void*)f_4715},
{C_text("f_4718:posix_2escm"),(void*)f_4718},
{C_text("f_4734:posix_2escm"),(void*)f_4734},
{C_text("f_4744:posix_2escm"),(void*)f_4744},
{C_text("f_4750:posix_2escm"),(void*)f_4750},
{C_text("f_4761:posix_2escm"),(void*)f_4761},
{C_text("f_4765:posix_2escm"),(void*)f_4765},
{C_text("f_4769:posix_2escm"),(void*)f_4769},
{C_text("f_4774:posix_2escm"),(void*)f_4774},
{C_text("f_4784:posix_2escm"),(void*)f_4784},
{C_text("f_4787:posix_2escm"),(void*)f_4787},
{C_text("f_4799:posix_2escm"),(void*)f_4799},
{C_text("f_4804:posix_2escm"),(void*)f_4804},
{C_text("f_4823:posix_2escm"),(void*)f_4823},
{C_text("f_4846:posix_2escm"),(void*)f_4846},
{C_text("f_4848:posix_2escm"),(void*)f_4848},
{C_text("f_4855:posix_2escm"),(void*)f_4855},
{C_text("f_4858:posix_2escm"),(void*)f_4858},
{C_text("f_4863:posix_2escm"),(void*)f_4863},
{C_text("f_4869:posix_2escm"),(void*)f_4869},
{C_text("f_4875:posix_2escm"),(void*)f_4875},
{C_text("f_4879:posix_2escm"),(void*)f_4879},
{C_text("f_4882:posix_2escm"),(void*)f_4882},
{C_text("f_4890:posix_2escm"),(void*)f_4890},
{C_text("f_4896:posix_2escm"),(void*)f_4896},
{C_text("f_4900:posix_2escm"),(void*)f_4900},
{C_text("f_4907:posix_2escm"),(void*)f_4907},
{C_text("f_4910:posix_2escm"),(void*)f_4910},
{C_text("f_4914:posix_2escm"),(void*)f_4914},
{C_text("f_4935:posix_2escm"),(void*)f_4935},
{C_text("f_4937:posix_2escm"),(void*)f_4937},
{C_text("f_4962:posix_2escm"),(void*)f_4962},
{C_text("f_4971:posix_2escm"),(void*)f_4971},
{C_text("f_4977:posix_2escm"),(void*)f_4977},
{C_text("f_5002:posix_2escm"),(void*)f_5002},
{C_text("f_5015:posix_2escm"),(void*)f_5015},
{C_text("f_5021:posix_2escm"),(void*)f_5021},
{C_text("f_5035:posix_2escm"),(void*)f_5035},
{C_text("f_5042:posix_2escm"),(void*)f_5042},
{C_text("f_5052:posix_2escm"),(void*)f_5052},
{C_text("f_5061:posix_2escm"),(void*)f_5061},
{C_text("f_5075:posix_2escm"),(void*)f_5075},
{C_text("f_5082:posix_2escm"),(void*)f_5082},
{C_text("f_5092:posix_2escm"),(void*)f_5092},
{C_text("f_5101:posix_2escm"),(void*)f_5101},
{C_text("f_5108:posix_2escm"),(void*)f_5108},
{C_text("f_5116:posix_2escm"),(void*)f_5116},
{C_text("f_5123:posix_2escm"),(void*)f_5123},
{C_text("f_5131:posix_2escm"),(void*)f_5131},
{C_text("f_5135:posix_2escm"),(void*)f_5135},
{C_text("f_5140:posix_2escm"),(void*)f_5140},
{C_text("f_5145:posix_2escm"),(void*)f_5145},
{C_text("f_5151:posix_2escm"),(void*)f_5151},
{C_text("f_5155:posix_2escm"),(void*)f_5155},
{C_text("f_5160:posix_2escm"),(void*)f_5160},
{C_text("f_5165:posix_2escm"),(void*)f_5165},
{C_text("f_5169:posix_2escm"),(void*)f_5169},
{C_text("f_5174:posix_2escm"),(void*)f_5174},
{C_text("f_5180:posix_2escm"),(void*)f_5180},
{C_text("f_5184:posix_2escm"),(void*)f_5184},
{C_text("f_5189:posix_2escm"),(void*)f_5189},
{C_text("f_5193:posix_2escm"),(void*)f_5193},
{C_text("f_5198:posix_2escm"),(void*)f_5198},
{C_text("f_5204:posix_2escm"),(void*)f_5204},
{C_text("f_5208:posix_2escm"),(void*)f_5208},
{C_text("f_5213:posix_2escm"),(void*)f_5213},
{C_text("f_5217:posix_2escm"),(void*)f_5217},
{C_text("f_5222:posix_2escm"),(void*)f_5222},
{C_text("f_5227:posix_2escm"),(void*)f_5227},
{C_text("f_5233:posix_2escm"),(void*)f_5233},
{C_text("f_5237:posix_2escm"),(void*)f_5237},
{C_text("f_5242:posix_2escm"),(void*)f_5242},
{C_text("f_5247:posix_2escm"),(void*)f_5247},
{C_text("f_5254:posix_2escm"),(void*)f_5254},
{C_text("f_5294:posix_2escm"),(void*)f_5294},
{C_text("f_5327:posix_2escm"),(void*)f_5327},
{C_text("f_5344:posix_2escm"),(void*)f_5344},
{C_text("f_5347:posix_2escm"),(void*)f_5347},
{C_text("f_5359:posix_2escm"),(void*)f_5359},
{C_text("f_5368:posix_2escm"),(void*)f_5368},
{C_text("f_5390:posix_2escm"),(void*)f_5390},
{C_text("f_5400:posix_2escm"),(void*)f_5400},
{C_text("f_5403:posix_2escm"),(void*)f_5403},
{C_text("f_5406:posix_2escm"),(void*)f_5406},
{C_text("f_5427:posix_2escm"),(void*)f_5427},
{C_text("f_5434:posix_2escm"),(void*)f_5434},
{C_text("f_5443:posix_2escm"),(void*)f_5443},
{C_text("f_5461:posix_2escm"),(void*)f_5461},
{C_text("f_5468:posix_2escm"),(void*)f_5468},
{C_text("f_5474:posix_2escm"),(void*)f_5474},
{C_text("f_5481:posix_2escm"),(void*)f_5481},
{C_text("f_5493:posix_2escm"),(void*)f_5493},
{C_text("f_5500:posix_2escm"),(void*)f_5500},
{C_text("f_5503:posix_2escm"),(void*)f_5503},
{C_text("f_5511:posix_2escm"),(void*)f_5511},
{C_text("f_5572:posix_2escm"),(void*)f_5572},
{C_text("f_5575:posix_2escm"),(void*)f_5575},
{C_text("f_5582:posix_2escm"),(void*)f_5582},
{C_text("f_5612:posix_2escm"),(void*)f_5612},
{C_text("f_5671:posix_2escm"),(void*)f_5671},
{C_text("f_5732:posix_2escm"),(void*)f_5732},
{C_text("f_5739:posix_2escm"),(void*)f_5739},
{C_text("f_5747:posix_2escm"),(void*)f_5747},
{C_text("f_5749:posix_2escm"),(void*)f_5749},
{C_text("f_5791:posix_2escm"),(void*)f_5791},
{C_text("f_5872:posix_2escm"),(void*)f_5872},
{C_text("f_5879:posix_2escm"),(void*)f_5879},
{C_text("f_5928:posix_2escm"),(void*)f_5928},
{C_text("f_5952:posix_2escm"),(void*)f_5952},
{C_text("f_5977:posix_2escm"),(void*)f_5977},
{C_text("f_5979:posix_2escm"),(void*)f_5979},
{C_text("f_5985:posix_2escm"),(void*)f_5985},
{C_text("f_6001:posix_2escm"),(void*)f_6001},
{C_text("f_6019:posix_2escm"),(void*)f_6019},
{C_text("f_6023:posix_2escm"),(void*)f_6023},
{C_text("f_6027:posix_2escm"),(void*)f_6027},
{C_text("f_6031:posix_2escm"),(void*)f_6031},
{C_text("f_6033:posix_2escm"),(void*)f_6033},
{C_text("f_6040:posix_2escm"),(void*)f_6040},
{C_text("f_6053:posix_2escm"),(void*)f_6053},
{C_text("f_6057:posix_2escm"),(void*)f_6057},
{C_text("f_6061:posix_2escm"),(void*)f_6061},
{C_text("f_6065:posix_2escm"),(void*)f_6065},
{C_text("f_6069:posix_2escm"),(void*)f_6069},
{C_text("f_6079:posix_2escm"),(void*)f_6079},
{C_text("f_6087:posix_2escm"),(void*)f_6087},
{C_text("f_6095:posix_2escm"),(void*)f_6095},
{C_text("f_6099:posix_2escm"),(void*)f_6099},
{C_text("f_6101:posix_2escm"),(void*)f_6101},
{C_text("f_6109:posix_2escm"),(void*)f_6109},
{C_text("f_6113:posix_2escm"),(void*)f_6113},
{C_text("f_6115:posix_2escm"),(void*)f_6115},
{C_text("f_6125:posix_2escm"),(void*)f_6125},
{C_text("f_6137:posix_2escm"),(void*)f_6137},
{C_text("f_6141:posix_2escm"),(void*)f_6141},
{C_text("f_6157:posix_2escm"),(void*)f_6157},
{C_text("f_6162:posix_2escm"),(void*)f_6162},
{C_text("f_6166:posix_2escm"),(void*)f_6166},
{C_text("f_6176:posix_2escm"),(void*)f_6176},
{C_text("f_6180:posix_2escm"),(void*)f_6180},
{C_text("f_6182:posix_2escm"),(void*)f_6182},
{C_text("f_6203:posix_2escm"),(void*)f_6203},
{C_text("f_6207:posix_2escm"),(void*)f_6207},
{C_text("f_6211:posix_2escm"),(void*)f_6211},
{C_text("f_6212:posix_2escm"),(void*)f_6212},
{C_text("f_6217:posix_2escm"),(void*)f_6217},
{C_text("f_6231:posix_2escm"),(void*)f_6231},
{C_text("f_6246:posix_2escm"),(void*)f_6246},
{C_text("f_6252:posix_2escm"),(void*)f_6252},
{C_text("f_6260:posix_2escm"),(void*)f_6260},
{C_text("f_6262:posix_2escm"),(void*)f_6262},
{C_text("f_6272:posix_2escm"),(void*)f_6272},
{C_text("f_6278:posix_2escm"),(void*)f_6278},
{C_text("f_6287:posix_2escm"),(void*)f_6287},
{C_text("f_6290:posix_2escm"),(void*)f_6290},
{C_text("f_6293:posix_2escm"),(void*)f_6293},
{C_text("f_6299:posix_2escm"),(void*)f_6299},
{C_text("f_6333:posix_2escm"),(void*)f_6333},
{C_text("f_6337:posix_2escm"),(void*)f_6337},
{C_text("f_6346:posix_2escm"),(void*)f_6346},
{C_text("f_6368:posix_2escm"),(void*)f_6368},
{C_text("f_6402:posix_2escm"),(void*)f_6402},
{C_text("f_6408:posix_2escm"),(void*)f_6408},
{C_text("f_6409:posix_2escm"),(void*)f_6409},
{C_text("f_6413:posix_2escm"),(void*)f_6413},
{C_text("f_6443:posix_2escm"),(void*)f_6443},
{C_text("f_6459:posix_2escm"),(void*)f_6459},
{C_text("f_6461:posix_2escm"),(void*)f_6461},
{C_text("f_6467:posix_2escm"),(void*)f_6467},
{C_text("f_6494:posix_2escm"),(void*)f_6494},
{C_text("f_6497:posix_2escm"),(void*)f_6497},
{C_text("f_6524:posix_2escm"),(void*)f_6524},
{C_text("f_6530:posix_2escm"),(void*)f_6530},
{C_text("f_6564:posix_2escm"),(void*)f_6564},
{C_text("f_6573:posix_2escm"),(void*)f_6573},
{C_text("f_6577:posix_2escm"),(void*)f_6577},
{C_text("f_6592:posix_2escm"),(void*)f_6592},
{C_text("f_6605:posix_2escm"),(void*)f_6605},
{C_text("f_6617:posix_2escm"),(void*)f_6617},
{C_text("f_6621:posix_2escm"),(void*)f_6621},
{C_text("f_6633:posix_2escm"),(void*)f_6633},
{C_text("f_6637:posix_2escm"),(void*)f_6637},
{C_text("f_6648:posix_2escm"),(void*)f_6648},
{C_text("f_6658:posix_2escm"),(void*)f_6658},
{C_text("f_6702:posix_2escm"),(void*)f_6702},
{C_text("f_6720:posix_2escm"),(void*)f_6720},
{C_text("f_6724:posix_2escm"),(void*)f_6724},
{C_text("f_6738:posix_2escm"),(void*)f_6738},
{C_text("f_6748:posix_2escm"),(void*)f_6748},
{C_text("f_6768:posix_2escm"),(void*)f_6768},
{C_text("f_6798:posix_2escm"),(void*)f_6798},
{C_text("f_6843:posix_2escm"),(void*)f_6843},
{C_text("f_6856:posix_2escm"),(void*)f_6856},
{C_text("f_6938:posix_2escm"),(void*)f_6938},
{C_text("f_6966:posix_2escm"),(void*)f_6966},
{C_text("f_6967:posix_2escm"),(void*)f_6967},
{C_text("f_6973:posix_2escm"),(void*)f_6973},
{C_text("f_7000:posix_2escm"),(void*)f_7000},
{C_text("f_7038:posix_2escm"),(void*)f_7038},
{C_text("f_7044:posix_2escm"),(void*)f_7044},
{C_text("f_7053:posix_2escm"),(void*)f_7053},
{C_text("f_7059:posix_2escm"),(void*)f_7059},
{C_text("f_7063:posix_2escm"),(void*)f_7063},
{C_text("f_7075:posix_2escm"),(void*)f_7075},
{C_text("f_7083:posix_2escm"),(void*)f_7083},
{C_text("f_7104:posix_2escm"),(void*)f_7104},
{C_text("f_7105:posix_2escm"),(void*)f_7105},
{C_text("f_7115:posix_2escm"),(void*)f_7115},
{C_text("f_7134:posix_2escm"),(void*)f_7134},
{C_text("f_7144:posix_2escm"),(void*)f_7144},
{C_text("f_7234:posix_2escm"),(void*)f_7234},
{C_text("f_7238:posix_2escm"),(void*)f_7238},
{C_text("f_7244:posix_2escm"),(void*)f_7244},
{C_text("f_7251:posix_2escm"),(void*)f_7251},
{C_text("f_7258:posix_2escm"),(void*)f_7258},
{C_text("f_7264:posix_2escm"),(void*)f_7264},
{C_text("f_7268:posix_2escm"),(void*)f_7268},
{C_text("f_7285:posix_2escm"),(void*)f_7285},
{C_text("f_7292:posix_2escm"),(void*)f_7292},
{C_text("f_7298:posix_2escm"),(void*)f_7298},
{C_text("f_7300:posix_2escm"),(void*)f_7300},
{C_text("f_7309:posix_2escm"),(void*)f_7309},
{C_text("f_7314:posix_2escm"),(void*)f_7314},
{C_text("f_7362:posix_2escm"),(void*)f_7362},
{C_text("f_7371:posix_2escm"),(void*)f_7371},
{C_text("f_7376:posix_2escm"),(void*)f_7376},
{C_text("f_7406:posix_2escm"),(void*)f_7406},
{C_text("f_7412:posix_2escm"),(void*)f_7412},
{C_text("f_7417:posix_2escm"),(void*)f_7417},
{C_text("f_7437:posix_2escm"),(void*)f_7437},
{C_text("f_7461:posix_2escm"),(void*)f_7461},
{C_text("f_7483:posix_2escm"),(void*)f_7483},
{C_text("f_7500:posix_2escm"),(void*)f_7500},
{C_text("f_7504:posix_2escm"),(void*)f_7504},
{C_text("f_7512:posix_2escm"),(void*)f_7512},
{C_text("f_7520:posix_2escm"),(void*)f_7520},
{C_text("f_7524:posix_2escm"),(void*)f_7524},
{C_text("f_7528:posix_2escm"),(void*)f_7528},
{C_text("f_7539:posix_2escm"),(void*)f_7539},
{C_text("f_7546:posix_2escm"),(void*)f_7546},
{C_text("f_7558:posix_2escm"),(void*)f_7558},
{C_text("f_7605:posix_2escm"),(void*)f_7605},
{C_text("f_7613:posix_2escm"),(void*)f_7613},
{C_text("f_7617:posix_2escm"),(void*)f_7617},
{C_text("f_7625:posix_2escm"),(void*)f_7625},
{C_text("f_7631:posix_2escm"),(void*)f_7631},
{C_text("f_7664:posix_2escm"),(void*)f_7664},
{C_text("f_7688:posix_2escm"),(void*)f_7688},
{C_text("f_7691:posix_2escm"),(void*)f_7691},
{C_text("f_7742:posix_2escm"),(void*)f_7742},
{C_text("f_7758:posix_2escm"),(void*)f_7758},
{C_text("f_7780:posix_2escm"),(void*)f_7780},
{C_text("f_7783:posix_2escm"),(void*)f_7783},
{C_text("f_7790:posix_2escm"),(void*)f_7790},
{C_text("f_7832:posix_2escm"),(void*)f_7832},
{C_text("f_7839:posix_2escm"),(void*)f_7839},
{C_text("f_7875:posix_2escm"),(void*)f_7875},
{C_text("f_7879:posix_2escm"),(void*)f_7879},
{C_text("f_7881:posix_2escm"),(void*)f_7881},
{C_text("f_7888:posix_2escm"),(void*)f_7888},
{C_text("f_7904:posix_2escm"),(void*)f_7904},
{C_text("f_7913:posix_2escm"),(void*)f_7913},
{C_text("f_7919:posix_2escm"),(void*)f_7919},
{C_text("f_7924:posix_2escm"),(void*)f_7924},
{C_text("f_7935:posix_2escm"),(void*)f_7935},
{C_text("f_7936:posix_2escm"),(void*)f_7936},
{C_text("f_7947:posix_2escm"),(void*)f_7947},
{C_text("f_7965:posix_2escm"),(void*)f_7965},
{C_text("f_7969:posix_2escm"),(void*)f_7969},
{C_text("f_7972:posix_2escm"),(void*)f_7972},
{C_text("f_7975:posix_2escm"),(void*)f_7975},
{C_text("f_7982:posix_2escm"),(void*)f_7982},
{C_text("f_7986:posix_2escm"),(void*)f_7986},
{C_text("f_7988:posix_2escm"),(void*)f_7988},
{C_text("f_7992:posix_2escm"),(void*)f_7992},
{C_text("f_7995:posix_2escm"),(void*)f_7995},
{C_text("f_7998:posix_2escm"),(void*)f_7998},
{C_text("f_8010:posix_2escm"),(void*)f_8010},
{C_text("f_8014:posix_2escm"),(void*)f_8014},
{C_text("f_8021:posix_2escm"),(void*)f_8021},
{C_text("f_8025:posix_2escm"),(void*)f_8025},
{C_text("f_8032:posix_2escm"),(void*)f_8032},
{C_text("f_8038:posix_2escm"),(void*)f_8038},
{C_text("f_8044:posix_2escm"),(void*)f_8044},
{C_text("f_8051:posix_2escm"),(void*)f_8051},
{C_text("f_8054:posix_2escm"),(void*)f_8054},
{C_text("f_8057:posix_2escm"),(void*)f_8057},
{C_text("f_8061:posix_2escm"),(void*)f_8061},
{C_text("f_8065:posix_2escm"),(void*)f_8065},
{C_text("f_8069:posix_2escm"),(void*)f_8069},
{C_text("f_8073:posix_2escm"),(void*)f_8073},
{C_text("f_8077:posix_2escm"),(void*)f_8077},
{C_text("f_8081:posix_2escm"),(void*)f_8081},
{C_text("f_8094:posix_2escm"),(void*)f_8094},
{C_text("f_8096:posix_2escm"),(void*)f_8096},
{C_text("f_8101:posix_2escm"),(void*)f_8101},
{C_text("f_8110:posix_2escm"),(void*)f_8110},
{C_text("f_8137:posix_2escm"),(void*)f_8137},
{C_text("f_8140:posix_2escm"),(void*)f_8140},
{C_text("f_8159:posix_2escm"),(void*)f_8159},
{C_text("f_8237:posix_2escm"),(void*)f_8237},
{C_text("f_8320:posix_2escm"),(void*)f_8320},
{C_text("f_8325:posix_2escm"),(void*)f_8325},
{C_text("f_8344:posix_2escm"),(void*)f_8344},
{C_text("f_8350:posix_2escm"),(void*)f_8350},
{C_text("f_8399:posix_2escm"),(void*)f_8399},
{C_text("f_8406:posix_2escm"),(void*)f_8406},
{C_text("f_8416:posix_2escm"),(void*)f_8416},
{C_text("f_8418:posix_2escm"),(void*)f_8418},
{C_text("f_8438:posix_2escm"),(void*)f_8438},
{C_text("f_8441:posix_2escm"),(void*)f_8441},
{C_text("f_8444:posix_2escm"),(void*)f_8444},
{C_text("f_8461:posix_2escm"),(void*)f_8461},
{C_text("f_8464:posix_2escm"),(void*)f_8464},
{C_text("f_8467:posix_2escm"),(void*)f_8467},
{C_text("f_8484:posix_2escm"),(void*)f_8484},
{C_text("f_8487:posix_2escm"),(void*)f_8487},
{C_text("f_8490:posix_2escm"),(void*)f_8490},
{C_text("f_8507:posix_2escm"),(void*)f_8507},
{C_text("f_8510:posix_2escm"),(void*)f_8510},
{C_text("f_8513:posix_2escm"),(void*)f_8513},
{C_text("f_8530:posix_2escm"),(void*)f_8530},
{C_text("f_8533:posix_2escm"),(void*)f_8533},
{C_text("f_8539:posix_2escm"),(void*)f_8539},
{C_text("f_8563:posix_2escm"),(void*)f_8563},
{C_text("f_8572:posix_2escm"),(void*)f_8572},
{C_text("f_8597:posix_2escm"),(void*)f_8597},
{C_text("f_8603:posix_2escm"),(void*)f_8603},
{C_text("f_8607:posix_2escm"),(void*)f_8607},
{C_text("f_8610:posix_2escm"),(void*)f_8610},
{C_text("f_8619:posix_2escm"),(void*)f_8619},
{C_text("f_8640:posix_2escm"),(void*)f_8640},
{C_text("f_8644:posix_2escm"),(void*)f_8644},
{C_text("f_8646:posix_2escm"),(void*)f_8646},
{C_text("f_8650:posix_2escm"),(void*)f_8650},
{C_text("f_8652:posix_2escm"),(void*)f_8652},
{C_text("f_8656:posix_2escm"),(void*)f_8656},
{C_text("toplevel:posix_2escm"),(void*)C_posix_toplevel},
{C_text("va9621:posix_2escm"),(void*)va9621},
{C_text("va9623:posix_2escm"),(void*)va9623},
{C_text("va9625:posix_2escm"),(void*)va9625},
{C_text("va9627:posix_2escm"),(void*)va9627},
{NULL,NULL}};
#endif

static C_PTABLE_ENTRY *create_ptable(void){
#ifdef C_ENABLE_PTABLES
return ptable;
#else
return NULL;
#endif
}

/*
o|hiding unexported module binding: chicken.posix#d 
o|hiding unexported module binding: chicken.posix#define-alias 
o|hiding unexported module binding: chicken.posix#define-unimplemented 
o|hiding unexported module binding: chicken.posix#set!-unimplemented 
o|hiding unexported module binding: chicken.posix#posix-error 
o|hiding unexported module binding: chicken.posix#stat-mode 
o|hiding unexported module binding: chicken.posix#stat 
o|hiding unexported module binding: chicken.posix#decode-seconds 
o|hiding unexported module binding: chicken.posix#check-time-vector 
o|hiding unexported module binding: chicken.posix#children 
o|hiding unexported module binding: chicken.posix#process 
o|hiding unexported module binding: chicken.posix#make-process 
o|hiding unexported module binding: chicken.posix#process? 
o|hiding unexported module binding: chicken.posix#process-id-set! 
o|hiding unexported module binding: chicken.posix#process-id 
o|hiding unexported module binding: chicken.posix#process-returned-normally?-set! 
o|hiding unexported module binding: chicken.posix#process-returned-normally? 
o|hiding unexported module binding: chicken.posix#process-input-port-set! 
o|hiding unexported module binding: chicken.posix#process-input-port 
o|hiding unexported module binding: chicken.posix#process-output-port-set! 
o|hiding unexported module binding: chicken.posix#process-output-port 
o|hiding unexported module binding: chicken.posix#process-error-port-set! 
o|hiding unexported module binding: chicken.posix#process-error-port 
o|hiding unexported module binding: chicken.posix#process-exit-status-set! 
o|hiding unexported module binding: chicken.posix#process-exit-status 
o|hiding unexported module binding: chicken.posix#get-pid 
o|hiding unexported module binding: chicken.posix#register-pid 
o|hiding unexported module binding: chicken.posix#drop-child 
o|hiding unexported module binding: chicken.posix#list->c-string-buffer 
o|hiding unexported module binding: chicken.posix#free-c-string-buffer 
o|hiding unexported module binding: chicken.posix#check-environment-list 
o|hiding unexported module binding: chicken.posix#call-with-exec-args 
o|hiding unexported module binding: chicken.posix#chown 
o|hiding unexported module binding: chicken.posix#c-string->allocated-pointer 
o|hiding unexported module binding: chicken.posix#process-wait-impl 
o|hiding unexported module binding: chicken.posix#shell-command 
o|hiding unexported module binding: chicken.posix#shell-command-arguments 
o|hiding unexported module binding: chicken.posix#process-impl 
S|applied compiler syntax:
S|  scheme#for-each		4
S|  scheme#map		2
o|eliminated procedure checks: 143 
o|specializations:
o|  1 (##sys#check-output-port * * *)
o|  1 (##sys#check-input-port * * *)
o|  1 (##sys#call-with-values (procedure () *) *)
o|  1 (chicken.base#add1 fixnum)
o|  3 (##sys#length list)
o|  13 (scheme#cdr pair)
o|  1 (scheme#zero? *)
o|  1 (##sys#check-open-port * *)
o|  5 (scheme#eqv? * (or eof null fixnum char boolean symbol keyword))
o|  11 (scheme#car pair)
o|  5 (##sys#check-list (or pair list) *)
o|  1 (scheme#char=? char char)
o|  1 (scheme#zero? integer)
(o e)|safe calls: 853 
(o e)|assignments to immediate values: 124 
o|dropping redundant toplevel assignment: chicken.file.posix#file-stat 
o|dropping redundant toplevel assignment: chicken.file.posix#set-file-permissions! 
o|dropping redundant toplevel assignment: chicken.file.posix#file-modification-time 
o|dropping redundant toplevel assignment: chicken.file.posix#file-access-time 
o|dropping redundant toplevel assignment: chicken.file.posix#file-change-time 
o|dropping redundant toplevel assignment: chicken.file.posix#set-file-times! 
o|dropping redundant toplevel assignment: chicken.file.posix#file-size 
o|dropping redundant toplevel assignment: chicken.file.posix#set-file-owner! 
o|dropping redundant toplevel assignment: chicken.file.posix#set-file-group! 
o|safe globals: (chicken.file.posix#set-file-group! chicken.file.posix#set-file-owner! chicken.file.posix#file-size chicken.file.posix#set-file-times! chicken.file.posix#file-change-time chicken.file.posix#file-access-time chicken.file.posix#file-modification-time chicken.file.posix#set-file-permissions! chicken.file.posix#file-stat chicken.posix#stat ##sys#posix-error chicken.posix#posix-error chicken.process-context.posix#user-information chicken.process-context.posix#process-group-id chicken.process-context.posix#create-session chicken.process-context.posix#current-effective-user-name chicken.process-context.posix#current-user-name chicken.process-context.posix#parent-process-id chicken.process-context.posix#current-process-id chicken.process-context.posix#current-user-id chicken.process-context.posix#current-group-id chicken.process-context.posix#current-effective-user-id chicken.process-context.posix#current-effective-group-id chicken.process-context.posix#set-root-directory! chicken.process-context.posix#change-directory* chicken.process.signal#signals-list chicken.process.signal#signal/xfsz chicken.process.signal#signal/xcpu chicken.process.signal#signal/winch chicken.process.signal#signal/vtalrm chicken.process.signal#signal/usr2 chicken.process.signal#signal/usr1 chicken.process.signal#signal/urg chicken.process.signal#signal/tstp chicken.process.signal#signal/trap chicken.process.signal#signal/term chicken.process.signal#signal/stop chicken.process.signal#signal/segv chicken.process.signal#signal/quit chicken.process.signal#signal/prof chicken.process.signal#signal/pipe chicken.process.signal#signal/kill chicken.process.signal#signal/io chicken.process.signal#signal/int chicken.process.signal#signal/ill chicken.process.signal#signal/hup chicken.process.signal#signal/fpe chicken.process.signal#signal/cont chicken.process.signal#signal/chld chicken.process.signal#signal/bus chicken.process.signal#signal/break chicken.process.signal#signal/alrm chicken.process.signal#signal/abrt chicken.process.signal#signal-unmask! chicken.process.signal#signal-masked? chicken.process.signal#signal-mask! chicken.process.signal#signal-mask chicken.process.signal#signal-default chicken.process.signal#signal-ignore chicken.process.signal#make-signal-handler chicken.process.signal#signal-handler chicken.process.signal#set-signal-mask! chicken.process.signal#set-signal-handler! chicken.process.signal#set-alarm! chicken.process#spawn/detach chicken.process#spawn/nowaito chicken.process#spawn/nowait chicken.process#spawn/wait chicken.process#spawn/overlay chicken.process#pipe/buf chicken.process#process-id chicken.process#process-error-port chicken.process#process-output-port chicken.process#process-input-port chicken.process#process-returned-normally? chicken.process#process-exit-status chicken.process#process? chicken.process#process-sleep chicken.process#process* chicken.process#process chicken.process#with-output-to-pipe chicken.process#with-input-from-pipe chicken.process#open-output-pipe chicken.process#open-input-pipe chicken.process#create-pipe chicken.process#close-output-pipe chicken.process#close-input-pipe chicken.process#call-with-output-pipe chicken.process#call-with-input-pipe chicken.process#process-wait chicken.process#process-spawn chicken.process#process-signal chicken.process#process-run chicken.process#process-fork chicken.process#process-execute chicken.process#qs chicken.process#system* chicken.process#system chicken.time.posix#local-timezone-abbreviation chicken.time.posix#time->string chicken.time.posix#string->time chicken.time.posix#local-time->seconds chicken.time.posix#seconds->string chicken.time.posix#seconds->local-time chicken.time.posix#utc-time->seconds chicken.time.posix#seconds->utc-time chicken.file.posix#set-file-position! chicken.file.posix#seek/set chicken.file.posix#seek/end chicken.file.posix#seek/cur chicken.file.posix#port->fileno chicken.file.posix#perm/ixusr chicken.file.posix#perm/ixoth chicken.file.posix#perm/ixgrp chicken.file.posix#perm/iwusr chicken.file.posix#perm/iwoth chicken.file.posix#perm/iwgrp chicken.file.posix#perm/isvtx chicken.file.posix#perm/isuid chicken.file.posix#perm/isgid chicken.file.posix#perm/irwxu chicken.file.posix#perm/irwxo chicken.file.posix#perm/irwxg chicken.file.posix#perm/irusr chicken.file.posix#perm/iroth chicken.file.posix#perm/irgrp chicken.file.posix#open/wronly chicken.file.posix#open/write chicken.file.posix#open/trunc chicken.file.posix#open/text chicken.file.posix#open/sync chicken.file.posix#open/read chicken.file.posix#open/rdwr chicken.file.posix#open/rdonly chicken.file.posix#open/nonblock chicken.file.posix#open/noinherit chicken.file.posix#open/noctty chicken.file.posix#open/fsync chicken.file.posix#open/excl chicken.file.posix#open/creat chicken.file.posix#open/binary chicken.file.posix#open/append chicken.file.posix#open-output-file* chicken.file.posix#open-input-file* chicken.file.posix#fileno/stdout chicken.file.posix#fileno/stdin chicken.file.posix#fileno/stderr chicken.file.posix#symbolic-link? chicken.file.posix#socket? chicken.file.posix#regular-file? chicken.file.posix#fifo? chicken.file.posix#directory? chicken.file.posix#character-device? chicken.file.posix#block-device? chicken.file.posix#file-type chicken.file.posix#file-write chicken.file.posix#file-unlock chicken.file.posix#file-truncate chicken.file.posix#file-select chicken.file.posix#file-read chicken.file.posix#file-position chicken.file.posix#file-permissions chicken.file.posix#file-owner chicken.file.posix#file-open chicken.file.posix#file-mkstemp chicken.file.posix#file-lock/blocking chicken.file.posix#file-lock chicken.file.posix#file-link chicken.file.posix#file-group chicken.file.posix#file-creation-mode chicken.file.posix#file-control chicken.file.posix#file-close chicken.file.posix#fcntl/setfl chicken.file.posix#fcntl/setfd chicken.file.posix#fcntl/getfl chicken.file.posix#fcntl/getfd chicken.file.posix#fcntl/dupfd chicken.file.posix#duplicate-fileno chicken.file.posix#read-symbolic-link chicken.file.posix#create-symbolic-link chicken.file.posix#create-fifo c2457) 
o|inlining procedure: k3011 
o|inlining procedure: k3011 
o|inlining procedure: k3030 
o|inlining procedure: k3030 
o|inlining procedure: k3057 
o|inlining procedure: k3057 
o|substituted constant variable: a3067 
o|inlining procedure: k3098 
o|inlining procedure: k3098 
o|contracted procedure: "(posix-common.scm:201) strerror671" 
o|inlining procedure: k3261 
o|inlining procedure: k3261 
o|inlining procedure: k3276 
o|inlining procedure: k3276 
o|inlining procedure: k3295 
o|inlining procedure: k3295 
o|inlining procedure: k3328 
o|inlining procedure: k3328 
o|inlining procedure: k3340 
o|inlining procedure: k3340 
o|inlining procedure: k3407 
o|inlining procedure: k3407 
o|contracted procedure: "(posix-common.scm:301) g743744" 
o|inlining procedure: k3494 
o|inlining procedure: k3506 
o|inlining procedure: k3506 
o|inlining procedure: k3518 
o|inlining procedure: k3518 
o|inlining procedure: k3530 
o|inlining procedure: k3530 
o|inlining procedure: k3494 
o|inlining procedure: k3651 
o|inlining procedure: k3651 
o|inlining procedure: k3666 
o|inlining procedure: k3666 
o|inlining procedure: k3679 
o|inlining procedure: k3679 
o|inlining procedure: k3729 
o|inlining procedure: k3738 
o|inlining procedure: k3738 
o|substituted constant variable: a3751 
o|inlining procedure: k3729 
o|inlining procedure: k3758 
o|inlining procedure: k3758 
o|inlining procedure: k3774 
o|inlining procedure: k3774 
o|substituted constant variable: a3881 
o|inlining procedure: k3882 
o|inlining procedure: k3882 
o|inlining procedure: k3901 
o|inlining procedure: k3901 
o|inlining procedure: k3931 
o|inlining procedure: k3931 
o|inlining procedure: k3958 
o|inlining procedure: k3958 
o|inlining procedure: k3971 
o|propagated global variable: r39728717 chicken.process-context.posix#change-directory* 
o|inlining procedure: k3971 
o|inlining procedure: k3991 
o|inlining procedure: k3991 
o|inlining procedure: k4069 
o|inlining procedure: k4069 
o|contracted procedure: "(posix-common.scm:603) ctime947" 
o|inlining procedure: k4105 
o|inlining procedure: k4105 
o|inlining procedure: k4149 
o|contracted procedure: "(posix-common.scm:626) strftime972" 
o|inlining procedure: k4135 
o|inlining procedure: k4135 
o|inlining procedure: k4149 
o|contracted procedure: "(posix-common.scm:628) asctime971" 
o|inlining procedure: k4122 
o|inlining procedure: k4122 
o|inlining procedure: k4247 
o|inlining procedure: k4247 
o|inlining procedure: k4265 
o|inlining procedure: k4265 
o|removed side-effect free assignment to unused variable: chicken.posix#process 
o|removed side-effect free assignment to unused variable: chicken.posix#process-id-set! 
o|inlining procedure: k4526 
o|inlining procedure: k4526 
o|inlining procedure: k4565 
o|inlining procedure: k4565 
o|contracted procedure: "(posix-common.scm:739) chicken.posix#process-exit-status-set!" 
o|contracted procedure: "(posix-common.scm:738) chicken.posix#process-returned-normally?-set!" 
o|inlining procedure: "(posix-common.scm:737) chicken.posix#process?" 
o|contracted procedure: "(posix-common.scm:736) chicken.posix#drop-child" 
o|inlining procedure: k4476 
o|inlining procedure: k4476 
o|inlining procedure: k4610 
o|inlining procedure: k4610 
o|inlining procedure: "(posix-common.scm:732) chicken.posix#process?" 
o|contracted procedure: "(posix-common.scm:722) chicken.posix#get-pid" 
o|inlining procedure: k4431 
o|inlining procedure: k4431 
o|inlining procedure: "(posix-common.scm:687) chicken.posix#process?" 
o|inlining procedure: "(posix-common.scm:718) chicken.posix#process?" 
o|inlining procedure: k4695 
o|inlining procedure: k4695 
o|contracted procedure: "(posix-common.scm:763) chicken.posix#c-string->allocated-pointer" 
o|merged explicitly consed rest parameter: args11911212 
o|consed rest parameter at call site: tmp22808 1 
o|inlining procedure: k4776 
o|inlining procedure: k4776 
o|inlining procedure: k4825 
o|inlining procedure: k4825 
o|inlining procedure: k4880 
o|inlining procedure: k4880 
o|inlining procedure: k4939 
o|contracted procedure: "(posix-common.scm:804) g12771286" 
o|inlining procedure: k4939 
o|inlining procedure: k4986 
o|inlining procedure: k4986 
o|inlining procedure: k5004 
o|inlining procedure: k5004 
o|inlining procedure: k5017 
o|inlining procedure: k5017 
o|inlining procedure: k5033 
o|inlining procedure: k5033 
o|inlining procedure: "(posix-common.scm:833) badmode1300" 
o|substituted constant variable: a5057 
o|substituted constant variable: a5059 
o|inlining procedure: k5073 
o|inlining procedure: k5073 
o|inlining procedure: "(posix-common.scm:844) badmode1300" 
o|substituted constant variable: a5097 
o|substituted constant variable: a5099 
o|substituted constant variable: a5104 
o|substituted constant variable: a5105 
o|inlining procedure: k5106 
o|inlining procedure: k5106 
o|substituted constant variable: a5119 
o|substituted constant variable: a5120 
o|inlining procedure: k5121 
o|inlining procedure: k5121 
o|inlining procedure: k5308 
o|inlining procedure: k5308 
o|contracted procedure: "(posixunix.scm:344) fcntl1495" 
o|inlining procedure: k5345 
o|inlining procedure: k5345 
o|inlining procedure: k5370 
o|inlining procedure: k5370 
o|inlining procedure: k5404 
o|inlining procedure: k5404 
o|inlining procedure: k5441 
o|inlining procedure: k5441 
o|inlining procedure: k5538 
o|inlining procedure: k5538 
o|inlining procedure: k5561 
o|inlining procedure: k5561 
o|inlining procedure: k5584 
o|inlining procedure: k5593 
o|inlining procedure: k5593 
o|inlining procedure: k5584 
o|inlining procedure: k5599 
o|inlining procedure: k5599 
o|inlining procedure: k5614 
o|inlining procedure: k5614 
o|contracted procedure: "(posixunix.scm:451) g16651666" 
o|inlining procedure: k5633 
o|inlining procedure: k5633 
o|inlining procedure: k5673 
o|inlining procedure: k5673 
o|contracted procedure: "(posixunix.scm:443) g16461647" 
o|inlining procedure: k5692 
o|inlining procedure: k5692 
o|contracted procedure: "(posixunix.scm:436) g16201621" 
o|inlining procedure: k5751 
o|inlining procedure: k5751 
o|contracted procedure: "(posixunix.scm:430) g16051606" 
o|inlining procedure: k5768 
o|inlining procedure: k5768 
o|inlining procedure: k5793 
o|inlining procedure: k5793 
o|contracted procedure: "(posixunix.scm:424) g15881589" 
o|inlining procedure: k5810 
o|inlining procedure: k5810 
o|inlining procedure: k5840 
o|inlining procedure: k5840 
o|inlining procedure: k5855 
o|inlining procedure: k5855 
o|inlining procedure: k5877 
o|inlining procedure: k5877 
o|inlining procedure: k5941 
o|inlining procedure: k5941 
o|inlining procedure: k5954 
o|contracted procedure: "(posixunix.scm:566) g16971704" 
o|inlining procedure: k5954 
o|inlining procedure: k5990 
o|inlining procedure: k5990 
o|inlining procedure: k6006 
o|inlining procedure: k6006 
o|inlining procedure: k6041 
o|inlining procedure: k6041 
o|inlining procedure: k6126 
o|inlining procedure: k6126 
o|inlining procedure: k6142 
o|inlining procedure: k6142 
o|inlining procedure: k6164 
o|inlining procedure: k6164 
o|inlining procedure: k6190 
o|inlining procedure: k6190 
o|inlining procedure: k6218 
o|inlining procedure: k6218 
o|inlining procedure: k6239 
o|inlining procedure: k6264 
o|inlining procedure: k6264 
o|inlining procedure: k6285 
o|inlining procedure: k6285 
o|inlining procedure: k6315 
o|inlining procedure: k6315 
o|inlining procedure: k6239 
o|inlining procedure: k6354 
o|inlining procedure: k6354 
o|contracted procedure: "(posixunix.scm:786) link1824" 
o|inlining procedure: k6414 
o|contracted procedure: "(posixunix.scm:805) g18691870" 
o|inlining procedure: k6428 
o|inlining procedure: k6428 
o|inlining procedure: k6414 
o|inlining procedure: k6445 
o|inlining procedure: k6445 
o|inlining procedure: k6469 
o|inlining procedure: k6501 
o|inlining procedure: k6501 
o|contracted procedure: "(posixunix.scm:822) g18881889" 
o|inlining procedure: k6483 
o|inlining procedure: k6483 
o|inlining procedure: k6469 
o|inlining procedure: k6519 
o|inlining procedure: k6519 
o|inlining procedure: k6536 
o|inlining procedure: k6536 
o|contracted procedure: "(posixunix.scm:838) g18991900" 
o|inlining procedure: k6544 
o|inlining procedure: k6544 
o|inlining procedure: k6578 
o|inlining procedure: k6578 
o|inlining procedure: k6610 
o|inlining procedure: k6610 
o|inlining procedure: k6619 
o|inlining procedure: k6619 
o|inlining procedure: k6635 
o|inlining procedure: k6635 
o|inlining procedure: k6660 
o|inlining procedure: k6660 
o|inlining procedure: k6703 
o|inlining procedure: k6703 
o|inlining procedure: k6725 
o|inlining procedure: k6725 
o|inlining procedure: k6753 
o|inlining procedure: k6753 
o|inlining procedure: k6800 
o|inlining procedure: k6800 
o|inlining procedure: k6845 
o|inlining procedure: k6845 
o|inlining procedure: k6975 
o|inlining procedure: k7004 
o|inlining procedure: k7004 
o|contracted procedure: "(posixunix.scm:945) g20152016" 
o|inlining procedure: k6989 
o|inlining procedure: k6989 
o|inlining procedure: k6975 
o|substituted constant variable: this-port19931999 
o|inlining procedure: k7061 
o|inlining procedure: k7061 
o|inlining procedure: k7085 
o|inlining procedure: k7085 
o|inlining procedure: k7107 
o|inlining procedure: k7136 
o|inlining procedure: k7136 
o|inlining procedure: k7107 
o|inlining procedure: k7239 
o|inlining procedure: k7239 
o|inlining procedure: k7249 
o|inlining procedure: k7249 
o|inlining procedure: k7269 
o|inlining procedure: k7269 
o|inlining procedure: k7287 
o|inlining procedure: k7287 
o|inlining procedure: k7320 
o|inlining procedure: k7320 
o|inlining procedure: k7335 
o|inlining procedure: k7335 
o|inlining procedure: "(posixunix.scm:1034) err2061" 
o|contracted procedure: "(posixunix.scm:1033) g20862087" 
o|inlining procedure: k7343 
o|inlining procedure: k7343 
o|inlining procedure: k7381 
o|inlining procedure: k7381 
o|inlining procedure: "(posixunix.scm:1042) err2061" 
o|inlining procedure: k7421 
o|inlining procedure: k7421 
o|inlining procedure: "(posixunix.scm:1049) err2061" 
o|inlining procedure: k7448 
o|inlining procedure: k7448 
o|contracted procedure: "(posixunix.scm:1071) strptime2131" 
o|inlining procedure: k7477 
o|inlining procedure: k7477 
o|inlining procedure: k7529 
o|inlining procedure: k7529 
o|inlining procedure: k7587 
o|inlining procedure: k7587 
o|inlining procedure: k7606 
o|inlining procedure: k7606 
o|contracted procedure: "(posixunix.scm:1132) chicken.posix#register-pid" 
o|contracted procedure: "(posix-common.scm:691) chicken.posix#make-process" 
o|contracted procedure: "(posixunix.scm:1115) fork2177" 
o|contracted procedure: "(posixunix.scm:1112) g21952196" 
o|inlining procedure: k7575 
o|inlining procedure: k7575 
o|inlining procedure: k7696 
o|inlining procedure: k7696 
o|inlining procedure: k7748 
o|inlining procedure: k7748 
o|inlining procedure: k7767 
o|inlining procedure: k7767 
o|inlining procedure: k7797 
o|inlining procedure: k7797 
o|inlining procedure: "(posixunix.scm:1167) chicken.posix#process?" 
o|removed unused formal parameters: (loc2256) 
o|inlining procedure: k7822 
o|inlining procedure: k7822 
o|inlining procedure: k7840 
o|inlining procedure: k7840 
o|inlining procedure: "(posixunix.scm:1190) chicken.posix#shell-command-arguments" 
o|removed unused parameter to known procedure: loc2256 "(posixunix.scm:1189) chicken.posix#shell-command" 
o|removed unused formal parameters: (loc2282) 
o|inlining procedure: k7886 
o|inlining procedure: k7886 
o|removed unused formal parameters: (loc2291) 
o|inlining procedure: k7906 
o|inlining procedure: k7906 
o|removed unused formal parameters: (loc2296 fd2299) 
o|inlining procedure: k7926 
o|inlining procedure: k7926 
o|inlining procedure: k7938 
o|contracted procedure: "(posixunix.scm:1240) replace-fd2273" 
o|inlining procedure: k7867 
o|inlining procedure: k7867 
o|inlining procedure: k7938 
o|inlining procedure: k7953 
o|inlining procedure: k7953 
o|removed unused parameter to known procedure: loc2291 "(posixunix.scm:1250) needed-pipe2279" 
o|removed unused parameter to known procedure: loc2291 "(posixunix.scm:1249) needed-pipe2279" 
o|removed unused parameter to known procedure: loc2291 "(posixunix.scm:1248) needed-pipe2279" 
o|inlining procedure: k8015 
o|inlining procedure: k8015 
o|removed unused parameter to known procedure: loc2296 "(posixunix.scm:1261) connect-parent2280" 
o|removed unused parameter to known procedure: fd2299 "(posixunix.scm:1261) connect-parent2280" 
o|inlining procedure: k8026 
o|inlining procedure: k8026 
o|removed unused parameter to known procedure: loc2296 "(posixunix.scm:1265) connect-parent2280" 
o|removed unused parameter to known procedure: fd2299 "(posixunix.scm:1265) connect-parent2280" 
o|contracted procedure: "(posixunix.scm:1284) chicken.posix#process-error-port-set!" 
o|removed unused parameter to known procedure: loc2282 "(posixunix.scm:1287) make-on-close2278" 
o|contracted procedure: "(posixunix.scm:1279) chicken.posix#process-input-port-set!" 
o|removed unused parameter to known procedure: loc2282 "(posixunix.scm:1282) make-on-close2278" 
o|contracted procedure: "(posixunix.scm:1274) chicken.posix#process-output-port-set!" 
o|removed unused parameter to known procedure: loc2282 "(posixunix.scm:1277) make-on-close2278" 
o|inlining procedure: k8112 
o|inlining procedure: k8112 
o|removed unused parameter to known procedure: loc2256 "(posixunix.scm:1305) chicken.posix#shell-command" 
o|inlining procedure: "(posixunix.scm:1304) chicken.posix#shell-command-arguments" 
o|inlining procedure: k8330 
o|inlining procedure: k8330 
o|contracted procedure: "(posixunix.scm:1322) chroot2444" 
o|substituted constant variable: c2457 
o|inlining procedure: k8404 
o|inlining procedure: k8404 
o|inlining procedure: k8426 
o|inlining procedure: k8426 
o|inlining procedure: k8449 
o|inlining procedure: k8449 
o|inlining procedure: k8472 
o|inlining procedure: k8472 
o|inlining procedure: k8495 
o|inlining procedure: k8495 
o|inlining procedure: k8518 
o|inlining procedure: k8518 
o|inlining procedure: k8541 
o|inlining procedure: k8541 
o|inlining procedure: k8556 
o|inlining procedure: k8556 
o|inlining procedure: k8584 
o|inlining procedure: k8584 
o|inlining procedure: k8608 
o|inlining procedure: k8608 
o|inlining procedure: k8620 
o|inlining procedure: k8620 
o|inlining procedure: k8630 
o|inlining procedure: k8630 
o|replaced variables: 1316 
o|removed binding forms: 752 
o|removed side-effect free assignment to unused variable: c2457 
o|substituted constant variable: r32628666 
o|substituted constant variable: r35078678 
o|substituted constant variable: r35198680 
o|substituted constant variable: r35318682 
o|substituted constant variable: r34958684 
o|substituted constant variable: r36678688 
o|inlining procedure: k3729 
o|substituted constant variable: r37398693 
o|inlining procedure: k3729 
o|inlining procedure: k3729 
o|substituted constant variable: r37758699 
o|substituted constant variable: r37758699 
o|substituted constant variable: r37758701 
o|substituted constant variable: r37758701 
o|propagated global variable: g9009018718 chicken.process-context.posix#change-directory* 
o|substituted constant variable: r41368737 
o|substituted constant variable: r41368737 
o|substituted constant variable: r41238744 
o|substituted constant variable: r41238744 
o|substituted constant variable: r44778760 
o|substituted constant variable: r49878801 
o|removed side-effect free assignment to unused variable: badmode1300 
o|substituted constant variable: r50188804 
o|substituted constant variable: r50188804 
o|substituted constant variable: r50188806 
o|substituted constant variable: r50188806 
o|inlining procedure: k5033 
o|inlining procedure: k5073 
o|substituted constant variable: r55628858 
o|substituted constant variable: r55628858 
o|substituted constant variable: r55628860 
o|substituted constant variable: r55628860 
o|inlining procedure: k5584 
o|inlining procedure: k5584 
o|substituted constant variable: r55948865 
o|inlining procedure: k5584 
o|substituted constant variable: r55858866 
o|substituted constant variable: r55858866 
o|substituted constant variable: r56348874 
o|substituted constant variable: r56348874 
o|substituted constant variable: r56938880 
o|substituted constant variable: r56938880 
o|substituted constant variable: r57698886 
o|substituted constant variable: r57698886 
o|substituted constant variable: r58118892 
o|substituted constant variable: r58118892 
o|substituted constant variable: r60428917 
o|inlining procedure: k6285 
o|substituted constant variable: r63168939 
o|substituted constant variable: r63168939 
o|substituted constant variable: r64468948 
o|inlining procedure: k6528 
o|inlining procedure: k6528 
o|substituted constant variable: r65798962 
o|substituted constant variable: r67268990 
o|substituted constant variable: r68469002 
o|inlining procedure: k7249 
o|inlining procedure: k7249 
o|removed side-effect free assignment to unused variable: err2061 
o|substituted constant variable: r73219036 
o|substituted constant variable: r73369038 
o|substituted constant variable: loc20659043 
o|substituted constant variable: msg20639041 
o|substituted constant variable: r73829049 
o|substituted constant variable: loc20659054 
o|substituted constant variable: msg20639052 
o|substituted constant variable: loc20659063 
o|substituted constant variable: msg20639061 
o|substituted constant variable: r74789071 
o|substituted constant variable: r74789071 
o|substituted constant variable: r76079078 
o|substituted constant variable: returned-normally?1064 
o|substituted constant variable: input-port1065 
o|substituted constant variable: output-port1066 
o|substituted constant variable: error-port1067 
o|substituted constant variable: exit-status1068 
o|substituted constant variable: c-pointer21972201 
o|substituted constant variable: c-pointer21972201 
o|substituted constant variable: r75769081 
o|substituted constant variable: r75769081 
o|inlining procedure: k7767 
o|substituted constant variable: r78239099 
o|removed side-effect free assignment to unused variable: chicken.posix#shell-command-arguments 
o|substituted constant variable: r79079118 
o|substituted constant variable: r79279120 
o|substituted constant variable: r79549126 
o|removed unused formal parameters: (stdfd2334) 
o|substituted constant variable: r80169128 
o|removed unused formal parameters: (stdfd2343) 
o|substituted constant variable: r80279130 
o|removed unused parameter to known procedure: stdfd2334 "(posixunix.scm:1285) input-port2312" 
o|removed unused parameter to known procedure: stdfd2343 "(posixunix.scm:1280) output-port2313" 
o|removed unused parameter to known procedure: stdfd2334 "(posixunix.scm:1275) input-port2312" 
o|substituted constant variable: r86219169 
o|replaced variables: 206 
o|removed binding forms: 1082 
o|removed conditional forms: 1 
o|inlining procedure: k4209 
o|inlining procedure: k4209 
o|inlining procedure: k4244 
o|inlining procedure: "(posix-common.scm:721) chicken.posix#process-exit-status" 
o|inlining procedure: "(posix-common.scm:720) chicken.posix#process-returned-normally?" 
o|inlining procedure: "(posix-common.scm:719) chicken.posix#process-id" 
o|inlining procedure: k4589 
o|inlining procedure: "(posix-common.scm:687) chicken.posix#process-id" 
o|inlining procedure: "(posix-common.scm:718) chicken.posix#process-exit-status" 
o|inlining procedure: k4785 
o|substituted constant variable: r55859210 
o|inlining procedure: k5960 
o|inlining procedure: k6364 
o|contracted procedure: k7767 
o|inlining procedure: "(posixunix.scm:1167) chicken.posix#process-id" 
o|removed unused formal parameters: (loc2304) 
o|removed unused parameter to known procedure: loc2304 "(posixunix.scm:1257) connect-child2281" 
o|removed unused parameter to known procedure: loc2304 "(posixunix.scm:1256) connect-child2281" 
o|removed unused parameter to known procedure: loc2304 "(posixunix.scm:1255) connect-child2281" 
o|inlining procedure: k8182 
o|inlining procedure: k8260 
o|inlining procedure: k8340 
o|converted assignments to bindings: (fileno2062) 
o|simplifications: ((let . 1)) 
o|replaced variables: 6 
o|removed binding forms: 278 
o|contracted procedure: k3404 
o|substituted constant variable: r37309174 
o|substituted constant variable: r37309176 
o|substituted constant variable: r37309178 
o|substituted constant variable: r42109290 
o|substituted constant variable: r42459292 
o|contracted procedure: k4586 
o|contracted procedure: k4710 
o|contracted procedure: k5305 
o|contracted procedure: k5535 
o|inlining procedure: k7349 
o|contracted procedure: k7581 
o|contracted procedure: k7584 
o|inlining procedure: k7892 
o|removed unused formal parameters: (loc2317) 
o|removed unused parameter to known procedure: loc2317 "(posixunix.scm:1269) spawn2311" 
o|inlining procedure: k8581 
o|inlining procedure: k8581 
o|replaced variables: 11 
o|removed binding forms: 22 
o|removed conditional forms: 1 
o|substituted constant variable: r78939424 
o|substituted constant variable: r85829432 
o|replaced variables: 2 
o|removed binding forms: 16 
o|removed conditional forms: 1 
o|removed binding forms: 4 
o|simplifications: ((let . 47) (if . 105) (##core#call . 671)) 
o|  call simplifications:
o|    scheme#<
o|    chicken.bitwise#bitwise-ior
o|    scheme#vector-ref	2
o|    chicken.base#void	3
o|    ##sys#make-structure
o|    scheme#make-vector
o|    chicken.fixnum#fxior	2
o|    chicken.fixnum#fxmin	2
o|    chicken.fixnum#fx>=	8
o|    ##sys#foreign-string-argument	3
o|    chicken.fixnum#fx*
o|    scheme#*
o|    scheme#memq	2
o|    scheme#list	7
o|    scheme#call-with-values	4
o|    ##sys#check-pair
o|    ##sys#check-list	7
o|    ##sys#apply	2
o|    chicken.fixnum#fx+	21
o|    ##sys#call-with-values	6
o|    scheme#assq
o|    scheme#caar
o|    scheme#values	20
o|    ##sys#check-structure	17
o|    ##sys#block-ref	12
o|    ##sys#structure?	6
o|    scheme#vector-set!	6
o|    ##sys#foreign-block-argument	8
o|    scheme#=	2
o|    ##sys#foreign-ranged-integer-argument	2
o|    scheme#string-length	4
o|    chicken.fixnum#fx-	15
o|    ##sys#check-vector
o|    ##sys#size	7
o|    ##sys#null-pointer?	2
o|    scheme#not	7
o|    ##sys#setislot	4
o|    chicken.fixnum#fx=	45
o|    scheme#cdr	36
o|    ##sys#check-fixnum	42
o|    scheme#vector	2
o|    chicken.base#fixnum?	17
o|    scheme#string?	4
o|    ##sys#foreign-fixnum-argument	14
o|    scheme#null?	89
o|    scheme#car	61
o|    scheme#string->list
o|    scheme#pair?	17
o|    scheme#cons	12
o|    ##sys#setslot	7
o|    ##sys#slot	28
o|    scheme#apply	11
o|    scheme#char=?
o|    scheme#string	3
o|    scheme#eq?	30
o|    ##sys#check-string	21
o|    chicken.fixnum#fx<	39
o|contracted procedure: k3008 
o|contracted procedure: k3014 
o|contracted procedure: k3033 
o|contracted procedure: k3132 
o|contracted procedure: k3046 
o|contracted procedure: k3129 
o|contracted procedure: k3049 
o|contracted procedure: k3052 
o|contracted procedure: k3060 
o|contracted procedure: k3084 
o|contracted procedure: k3092 
o|contracted procedure: k3101 
o|contracted procedure: k3104 
o|contracted procedure: k3107 
o|contracted procedure: k3115 
o|contracted procedure: k3123 
o|contracted procedure: k3135 
o|contracted procedure: k3235 
o|contracted procedure: k3264 
o|contracted procedure: k3273 
o|contracted procedure: k3289 
o|contracted procedure: k3313 
o|contracted procedure: k3304 
o|contracted procedure: k3322 
o|contracted procedure: k3331 
o|contracted procedure: k3337 
o|contracted procedure: k3353 
o|contracted procedure: k3434 
o|contracted procedure: k3387 
o|contracted procedure: k3428 
o|contracted procedure: k3390 
o|contracted procedure: k3422 
o|contracted procedure: k3393 
o|contracted procedure: k3410 
o|contracted procedure: k3440 
o|contracted procedure: k3560 
o|contracted procedure: k3482 
o|contracted procedure: k3554 
o|contracted procedure: k3485 
o|contracted procedure: k3548 
o|contracted procedure: k3488 
o|contracted procedure: k3542 
o|contracted procedure: k3491 
o|contracted procedure: k3503 
o|contracted procedure: k3509 
o|contracted procedure: k3515 
o|contracted procedure: k3521 
o|contracted procedure: k3527 
o|contracted procedure: k3533 
o|contracted procedure: k3539 
o|contracted procedure: k3688 
o|contracted procedure: k3642 
o|contracted procedure: k3645 
o|contracted procedure: k3648 
o|contracted procedure: k3676 
o|contracted procedure: k3663 
o|contracted procedure: k3672 
o|contracted procedure: k3682 
o|contracted procedure: k3735 
o|contracted procedure: k3741 
o|contracted procedure: k3761 
o|contracted procedure: k3770 
o|contracted procedure: k3821 
o|contracted procedure: k3780 
o|contracted procedure: k3815 
o|contracted procedure: k3783 
o|contracted procedure: k3809 
o|contracted procedure: k3786 
o|contracted procedure: k3803 
o|contracted procedure: k3789 
o|contracted procedure: k3792 
o|contracted procedure: k3871 
o|contracted procedure: k3830 
o|contracted procedure: k3865 
o|contracted procedure: k3833 
o|contracted procedure: k3859 
o|contracted procedure: k3836 
o|contracted procedure: k3853 
o|contracted procedure: k3839 
o|contracted procedure: k3842 
o|contracted procedure: k3919 
o|contracted procedure: k3885 
o|contracted procedure: k3898 
o|contracted procedure: k3904 
o|contracted procedure: k3925 
o|contracted procedure: k3934 
o|contracted procedure: k3940 
o|contracted procedure: k3943 
o|contracted procedure: k3946 
o|contracted procedure: k3955 
o|contracted procedure: k3961 
o|contracted procedure: k3977 
o|contracted procedure: k3988 
o|contracted procedure: k4001 
o|contracted procedure: k3994 
o|contracted procedure: k4016 
o|inlining procedure: k4007 
o|contracted procedure: k4037 
o|inlining procedure: k4028 
o|contracted procedure: k4080 
o|contracted procedure: k4076 
o|contracted procedure: k4054 
o|contracted procedure: k4086 
o|contracted procedure: k4108 
o|contracted procedure: k4196 
o|contracted procedure: k4143 
o|contracted procedure: k4152 
o|contracted procedure: k4135 
o|contracted procedure: k4186 
o|contracted procedure: k4182 
o|contracted procedure: k4122 
o|contracted procedure: k4205 
o|contracted procedure: k4227 
o|contracted procedure: k4256 
o|contracted procedure: k4244 
o|contracted procedure: k4268 
o|contracted procedure: k4278 
o|contracted procedure: k4282 
o|contracted procedure: k4288 
o|contracted procedure: k4297 
o|contracted procedure: k4329 
o|contracted procedure: k4347 
o|contracted procedure: k4365 
o|contracted procedure: k4383 
o|contracted procedure: k4401 
o|contracted procedure: k4419 
o|contracted procedure: k4508 
o|contracted procedure: k4641 
o|contracted procedure: k4514 
o|contracted procedure: k4635 
o|contracted procedure: k4517 
o|contracted procedure: k4629 
o|contracted procedure: k4520 
o|contracted procedure: k4623 
o|contracted procedure: k4523 
o|contracted procedure: k43299309 
o|contracted procedure: k4536 
o|contracted procedure: k43479304 
o|contracted procedure: k4540 
o|contracted procedure: k44199299 
o|contracted procedure: k4544 
o|contracted procedure: k4550 
o|contracted procedure: k4568 
o|contracted procedure: k4577 
o|contracted procedure: k4595 
o|contracted procedure: k4410 
o|contracted procedure: k4338 
o|contracted procedure: k4479 
o|contracted procedure: k4495 
o|contracted procedure: k4485 
o|contracted procedure: k4604 
o|contracted procedure: k4607 
o|contracted procedure: k4614 
o|contracted procedure: k4446 
o|contracted procedure: k4428 
o|contracted procedure: k4434 
o|contracted procedure: k4440 
o|contracted procedure: k43299317 
o|contracted procedure: k4617 
o|contracted procedure: k44199322 
o|contracted procedure: k4650 
o|contracted procedure: k4698 
o|contracted procedure: k4701 
o|contracted procedure: k4738 
o|contracted procedure: k4704 
o|contracted procedure: k4725 
o|contracted procedure: k4779 
o|contracted procedure: k4792 
o|contracted procedure: k47929328 
o|contracted procedure: k4801 
o|contracted procedure: k4806 
o|contracted procedure: k4809 
o|contracted procedure: k4828 
o|contracted procedure: k4838 
o|contracted procedure: k4842 
o|contracted procedure: k4850 
o|contracted procedure: k4916 
o|contracted procedure: k4930 
o|contracted procedure: k4942 
o|contracted procedure: k4945 
o|contracted procedure: k4948 
o|contracted procedure: k4956 
o|contracted procedure: k4964 
o|contracted procedure: k4925 
o|contracted procedure: k4989 
o|contracted procedure: k5007 
o|contracted procedure: k5023 
o|contracted procedure: k5036 
o|contracted procedure: k5046 
o|contracted procedure: k5063 
o|contracted procedure: k5076 
o|contracted procedure: k5086 
o|contracted procedure: k5109 
o|contracted procedure: k5124 
o|contracted procedure: k5250 
o|contracted procedure: k5257 
o|contracted procedure: k5317 
o|contracted procedure: k5296 
o|contracted procedure: k5299 
o|contracted procedure: k5302 
o|contracted procedure: k5282 
o|contracted procedure: k5286 
o|contracted procedure: k5290 
o|contracted procedure: k5311 
o|contracted procedure: k5354 
o|contracted procedure: k5329 
o|contracted procedure: k5332 
o|contracted procedure: k5335 
o|contracted procedure: k5338 
o|contracted procedure: k5348 
o|contracted procedure: k5361 
o|contracted procedure: k5373 
o|contracted procedure: k5379 
o|contracted procedure: k5392 
o|contracted procedure: k5395 
o|contracted procedure: k5410 
o|contracted procedure: k5419 
o|contracted procedure: k5429 
o|contracted procedure: k5450 
o|contracted procedure: k5435 
o|contracted procedure: k5438 
o|contracted procedure: k5444 
o|contracted procedure: k5463 
o|contracted procedure: k5469 
o|contracted procedure: k5483 
o|contracted procedure: k5486 
o|contracted procedure: k5867 
o|contracted procedure: k5495 
o|contracted procedure: k5506 
o|contracted procedure: k5521 
o|contracted procedure: k5525 
o|contracted procedure: k5529 
o|contracted procedure: k5541 
o|contracted procedure: k5550 
o|contracted procedure: k5567 
o|contracted procedure: k5557 
o|contracted procedure: k5564 
o|contracted procedure: k5590 
o|contracted procedure: k5596 
o|contracted procedure: k5602 
o|contracted procedure: k5608 
o|contracted procedure: k5617 
o|contracted procedure: k5646 
o|contracted procedure: k5656 
o|contracted procedure: k5650 
o|contracted procedure: k5663 
o|contracted procedure: k5667 
o|contracted procedure: k5629 
o|contracted procedure: k5633 
o|contracted procedure: k5676 
o|contracted procedure: k5705 
o|contracted procedure: k5715 
o|contracted procedure: k5709 
o|contracted procedure: k5722 
o|contracted procedure: k5726 
o|contracted procedure: k5688 
o|contracted procedure: k5692 
o|contracted procedure: k5741 
o|contracted procedure: k5754 
o|contracted procedure: k5781 
o|contracted procedure: k5787 
o|contracted procedure: k5760 
o|contracted procedure: k5764 
o|contracted procedure: k5768 
o|contracted procedure: k5796 
o|contracted procedure: k5823 
o|contracted procedure: k5829 
o|contracted procedure: k5802 
o|contracted procedure: k5806 
o|contracted procedure: k5810 
o|contracted procedure: k5833 
o|contracted procedure: k5837 
o|contracted procedure: k5843 
o|contracted procedure: k5849 
o|contracted procedure: k5852 
o|contracted procedure: k5858 
o|contracted procedure: k5864 
o|contracted procedure: k5890 
o|contracted procedure: k5874 
o|contracted procedure: k5883 
o|contracted procedure: k5924 
o|contracted procedure: k5930 
o|contracted procedure: k5944 
o|contracted procedure: k5957 
o|contracted procedure: k5971 
o|contracted procedure: k5935 
o|contracted procedure: k59679348 
o|contracted procedure: k5981 
o|contracted procedure: k5987 
o|contracted procedure: k5993 
o|contracted procedure: k6003 
o|contracted procedure: k6009 
o|contracted procedure: k6080 
o|contracted procedure: k6035 
o|contracted procedure: k6044 
o|contracted procedure: k6070 
o|contracted procedure: k6073 
o|contracted procedure: k6117 
o|contracted procedure: k6120 
o|contracted procedure: k6129 
o|contracted procedure: k6145 
o|contracted procedure: k6151 
o|contracted procedure: k6167 
o|contracted procedure: k6184 
o|contracted procedure: k6187 
o|contracted procedure: k6193 
o|contracted procedure: k6221 
o|contracted procedure: k6321 
o|contracted procedure: k6233 
o|contracted procedure: k6236 
o|contracted procedure: k6267 
o|contracted procedure: k6307 
o|contracted procedure: k6311 
o|contracted procedure: k6348 
o|contracted procedure: k6351 
o|contracted procedure: k6357 
o|contracted procedure: k6339 
o|contracted procedure: k6343 
o|contracted procedure: k6931 
o|contracted procedure: k6370 
o|contracted procedure: k6925 
o|contracted procedure: k6373 
o|contracted procedure: k6919 
o|contracted procedure: k6376 
o|contracted procedure: k6913 
o|contracted procedure: k6379 
o|contracted procedure: k6907 
o|contracted procedure: k6382 
o|contracted procedure: k6901 
o|contracted procedure: k6385 
o|contracted procedure: k6895 
o|contracted procedure: k6388 
o|contracted procedure: k6889 
o|contracted procedure: k6391 
o|contracted procedure: k6883 
o|contracted procedure: k6394 
o|contracted procedure: k6877 
o|contracted procedure: k6397 
o|contracted procedure: k6868 
o|contracted procedure: k6403 
o|contracted procedure: k6417 
o|contracted procedure: k6425 
o|contracted procedure: k6434 
o|contracted procedure: k6448 
o|contracted procedure: k6455 
o|contracted procedure: k6472 
o|contracted procedure: k6480 
o|contracted procedure: k6489 
o|contracted procedure: k6504 
o|contracted procedure: k6516 
o|contracted procedure: k6533 
o|contracted procedure: k6541 
o|contracted procedure: k6550 
o|contracted procedure: k6566 
o|contracted procedure: k6569 
o|contracted procedure: k6581 
o|contracted procedure: k6588 
o|contracted procedure: k6595 
o|contracted procedure: k6598 
o|contracted procedure: k6607 
o|contracted procedure: k6625 
o|contracted procedure: k6641 
o|contracted procedure: k6663 
o|contracted procedure: k6669 
o|contracted procedure: k6672 
o|contracted procedure: k6697 
o|contracted procedure: k6675 
o|contracted procedure: k6679 
o|contracted procedure: k6686 
o|contracted procedure: k6690 
o|contracted procedure: k6694 
o|contracted procedure: k6706 
o|contracted procedure: k6716 
o|contracted procedure: k6728 
o|contracted procedure: k6731 
o|contracted procedure: k6794 
o|contracted procedure: k6744 
o|contracted procedure: k6750 
o|contracted procedure: k6756 
o|contracted procedure: k6763 
o|contracted procedure: k6772 
o|contracted procedure: k6783 
o|contracted procedure: k6779 
o|contracted procedure: k6790 
o|contracted procedure: k6815 
o|contracted procedure: k6811 
o|contracted procedure: k6804 
o|inlining procedure: k6800 
o|contracted procedure: k6826 
o|contracted procedure: k6830 
o|contracted procedure: k6822 
o|inlining procedure: k6800 
o|contracted procedure: k6836 
o|contracted procedure: k6848 
o|contracted procedure: k6851 
o|contracted procedure: k6859 
o|contracted procedure: k6862 
o|contracted procedure: k7227 
o|contracted procedure: k6940 
o|contracted procedure: k7221 
o|contracted procedure: k6943 
o|contracted procedure: k7215 
o|contracted procedure: k6946 
o|contracted procedure: k7209 
o|contracted procedure: k6949 
o|contracted procedure: k7203 
o|contracted procedure: k6952 
o|contracted procedure: k7197 
o|contracted procedure: k6955 
o|contracted procedure: k7191 
o|contracted procedure: k6958 
o|contracted procedure: k7185 
o|contracted procedure: k6961 
o|contracted procedure: k6978 
o|contracted procedure: k6986 
o|contracted procedure: k6995 
o|contracted procedure: k7007 
o|contracted procedure: k7019 
o|contracted procedure: k7026 
o|contracted procedure: k7030 
o|contracted procedure: k7176 
o|contracted procedure: k7033 
o|contracted procedure: k7046 
o|contracted procedure: k7049 
o|contracted procedure: k7067 
o|contracted procedure: k7080 
o|contracted procedure: k7088 
o|contracted procedure: k7099 
o|contracted procedure: k7095 
o|contracted procedure: k7110 
o|contracted procedure: k7119 
o|contracted procedure: k7126 
o|contracted procedure: k7167 
o|contracted procedure: k7130 
o|contracted procedure: k7139 
o|contracted procedure: k7152 
o|contracted procedure: k7159 
o|contracted procedure: k7163 
o|contracted procedure: k7170 
o|contracted procedure: k7252 
o|contracted procedure: k7272 
o|contracted procedure: k7355 
o|contracted procedure: k7302 
o|contracted procedure: k7317 
o|contracted procedure: k7323 
o|contracted procedure: k7329 
o|contracted procedure: k7340 
o|contracted procedure: k7349 
o|contracted procedure: k7399 
o|contracted procedure: k7364 
o|contracted procedure: k7378 
o|contracted procedure: k7384 
o|contracted procedure: k7390 
o|contracted procedure: k7418 
o|contracted procedure: k7427 
o|contracted procedure: k7439 
o|contracted procedure: k7445 
o|contracted procedure: k7451 
o|contracted procedure: k7462 
o|contracted procedure: k7470 
o|contracted procedure: k7513 
o|contracted procedure: k7485 
o|contracted procedure: k7488 
o|contracted procedure: k7491 
o|contracted procedure: k7506 
o|substituted constant variable: g9615 
o|substituted constant variable: g9615 
o|substituted constant variable: g9615 
o|substituted constant variable: g9615 
o|substituted constant variable: g9615 
o|substituted constant variable: g9615 
o|substituted constant variable: g9615 
o|substituted constant variable: g9615 
o|substituted constant variable: g9615 
o|substituted constant variable: g9615 
o|contracted procedure: k7477 
o|contracted procedure: k7532 
o|contracted procedure: k7549 
o|contracted procedure: k7657 
o|contracted procedure: k7560 
o|contracted procedure: k7651 
o|contracted procedure: k7563 
o|contracted procedure: k7645 
o|contracted procedure: k7566 
o|contracted procedure: k7639 
o|contracted procedure: k7569 
o|contracted procedure: k7590 
o|contracted procedure: k7599 
o|contracted procedure: k4455 
o|contracted procedure: k4463 
o|contracted procedure: k4459 
o|contracted procedure: k7735 
o|contracted procedure: k7666 
o|contracted procedure: k7729 
o|contracted procedure: k7669 
o|contracted procedure: k7723 
o|contracted procedure: k7672 
o|contracted procedure: k7717 
o|contracted procedure: k7675 
o|contracted procedure: k7711 
o|contracted procedure: k7678 
o|contracted procedure: k7705 
o|contracted procedure: k7681 
o|contracted procedure: k7693 
o|contracted procedure: k7699 
o|contracted procedure: k7745 
o|contracted procedure: k7773 
o|contracted procedure: k7751 
o|contracted procedure: k7812 
o|contracted procedure: k7785 
o|contracted procedure: k7791 
o|contracted procedure: k7794 
o|contracted procedure: k7800 
o|contracted procedure: k7806 
o|contracted procedure: k43299372 
o|contracted procedure: k7860 
o|contracted procedure: k7834 
o|contracted procedure: k7857 
o|inlining procedure: "(posixunix.scm:1189) chicken.posix#shell-command" 
o|contracted procedure: k7883 
o|contracted procedure: k7898 
o|contracted procedure: k7892 
o|contracted procedure: k7929 
o|contracted procedure: k7941 
o|contracted procedure: k7870 
o|contracted procedure: k7960 
o|contracted procedure: k8083 
o|contracted procedure: k8087 
o|contracted procedure: k8091 
o|contracted procedure: k8046 
o|contracted procedure: k4392 
o|contracted procedure: k4356 
o|contracted procedure: k4374 
o|contracted procedure: k8098 
o|contracted procedure: k8115 
o|contracted procedure: k8125 
o|contracted procedure: k8129 
o|contracted procedure: k8132 
o|contracted procedure: k8151 
o|inlining procedure: "(posixunix.scm:1305) chicken.posix#shell-command" 
o|contracted procedure: k8230 
o|contracted procedure: k8161 
o|contracted procedure: k8224 
o|contracted procedure: k8164 
o|contracted procedure: k8218 
o|contracted procedure: k8167 
o|contracted procedure: k8212 
o|contracted procedure: k8170 
o|contracted procedure: k8206 
o|contracted procedure: k8173 
o|contracted procedure: k8200 
o|contracted procedure: k8176 
o|contracted procedure: k8194 
o|contracted procedure: k8179 
o|contracted procedure: k8188 
o|contracted procedure: k8182 
o|contracted procedure: k8308 
o|contracted procedure: k8239 
o|contracted procedure: k8302 
o|contracted procedure: k8242 
o|contracted procedure: k8296 
o|contracted procedure: k8245 
o|contracted procedure: k8290 
o|contracted procedure: k8248 
o|contracted procedure: k8284 
o|contracted procedure: k8251 
o|contracted procedure: k8278 
o|contracted procedure: k8254 
o|contracted procedure: k8272 
o|contracted procedure: k8257 
o|contracted procedure: k8266 
o|contracted procedure: k8260 
o|contracted procedure: k8327 
o|contracted procedure: k8333 
o|contracted procedure: k8322 
o|contracted procedure: k8395 
o|contracted procedure: k8401 
o|contracted procedure: k8407 
o|contracted procedure: k8420 
o|contracted procedure: k8423 
o|contracted procedure: k8429 
o|contracted procedure: k8446 
o|contracted procedure: k8452 
o|contracted procedure: k8469 
o|contracted procedure: k8475 
o|contracted procedure: k8492 
o|contracted procedure: k8498 
o|contracted procedure: k8515 
o|contracted procedure: k8521 
o|contracted procedure: k8544 
o|contracted procedure: k8547 
o|contracted procedure: k8556 
o|contracted procedure: k8565 
o|contracted procedure: k8590 
o|contracted procedure: k8574 
o|contracted procedure: k8577 
o|contracted procedure: k8599 
o|contracted procedure: k8611 
o|contracted procedure: k8627 
o|contracted procedure: k8623 
o|contracted procedure: k8633 
o|simplifications: ((##core#call . 5) (if . 7) (let . 155)) 
o|  call simplifications:
o|    chicken.bitwise#bitwise-ior	5
o|removed binding forms: 585 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest239241 0 
(o x)|known list op on rest arg sublist: ##core#rest-car rest239241 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest707709 0 
(o x)|known list op on rest arg sublist: ##core#rest-car rest707709 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest771773 0 
(o x)|known list op on rest arg sublist: ##core#rest-car rest771773 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest771773 0 
(o x)|known list op on rest arg sublist: ##core#rest-cdr rest771773 0 
(o x)|known list op on rest arg sublist: ##core#rest-car whence800 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest844846 0 
(o x)|known list op on rest arg sublist: ##core#rest-car rest844846 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest844846 0 
(o x)|known list op on rest arg sublist: ##core#rest-cdr rest844846 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest861863 0 
(o x)|known list op on rest arg sublist: ##core#rest-car rest861863 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest861863 0 
(o x)|known list op on rest arg sublist: ##core#rest-cdr rest861863 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? new887 0 
(o x)|known list op on rest arg sublist: ##core#rest-car new887 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest928929 0 
(o x)|known list op on rest arg sublist: ##core#rest-car rest928929 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest939940 0 
(o x)|known list op on rest arg sublist: ##core#rest-car rest939940 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest957958 0 
(o x)|known list op on rest arg sublist: ##core#rest-car rest957958 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest9981000 0 
(o x)|known list op on rest arg sublist: ##core#rest-car rest9981000 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest10451046 0 
(o x)|known list op on rest arg sublist: ##core#rest-car rest10451046 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? args1158 0 
(o x)|known list op on rest arg sublist: ##core#rest-car args1158 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? args1158 0 
(o x)|known list op on rest arg sublist: ##core#rest-cdr args1158 0 
o|inlining procedure: "(posix-common.scm:826) mode1299" 
o|inlining procedure: "(posix-common.scm:837) mode1299" 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest15081511 0 
(o x)|known list op on rest arg sublist: ##core#rest-car rest15081511 0 
o|contracted procedure: k5324 
(o x)|known list op on rest arg sublist: ##core#rest-car mode1523 0 
(o x)|known list op on rest arg sublist: ##core#rest-car buffer1540 0 
(o x)|known list op on rest arg sublist: ##core#rest-car timeout1564 0 
o|contracted procedure: k5639 
o|contracted procedure: k5698 
o|contracted procedure: k5774 
o|contracted procedure: k5816 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest16851686 0 
(o x)|known list op on rest arg sublist: ##core#rest-car rest16851686 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest17531755 0 
(o x)|known list op on rest arg sublist: ##core#rest-car rest17531755 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest18001802 0 
(o x)|known list op on rest arg sublist: ##core#rest-car rest18001802 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest18391843 0 
(o x)|known list op on rest arg sublist: ##core#rest-car rest18391843 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest18391843 0 
(o x)|known list op on rest arg sublist: ##core#rest-cdr rest18391843 0 
o|contracted procedure: k6654 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest19741978 0 
(o x)|known list op on rest arg sublist: ##core#rest-car rest19741978 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest19741978 0 
(o x)|known list op on rest arg sublist: ##core#rest-cdr rest19741978 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest20722074 0 
(o x)|known list op on rest arg sublist: ##core#rest-car rest20722074 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest20962098 0 
(o x)|known list op on rest arg sublist: ##core#rest-car rest20962098 0 
o|contracted procedure: k7442 
(o x)|known list op on rest arg sublist: ##core#rest-car mode2127 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest21492151 0 
(o x)|known list op on rest arg sublist: ##core#rest-car rest21492151 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest21832184 0 
(o x)|known list op on rest arg sublist: ##core#rest-car rest21832184 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest21832184 0 
(o x)|known list op on rest arg sublist: ##core#rest-cdr rest21832184 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest22162218 0 
(o x)|known list op on rest arg sublist: ##core#rest-car rest22162218 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest22162218 0 
(o x)|known list op on rest arg sublist: ##core#rest-cdr rest22162218 0 
(o x)|known list op on rest arg sublist: ##core#rest-car sig2249 0 
o|removed side-effect free assignment to unused variable: chicken.posix#shell-command 
(o x)|known list op on rest arg sublist: ##core#rest-car args2263 0 
o|inlining procedure: "(posixunix.scm:1257) swapped-ends2314" 
o|inlining procedure: "(posixunix.scm:1256) swapped-ends2314" 
o|inlining procedure: "(posixunix.scm:1252) swapped-ends2314" 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest24062408 0 
(o x)|known list op on rest arg sublist: ##core#rest-car rest24062408 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest24062408 0 
(o x)|known list op on rest arg sublist: ##core#rest-cdr rest24062408 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest24262428 0 
(o x)|known list op on rest arg sublist: ##core#rest-car rest24262428 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest24262428 0 
(o x)|known list op on rest arg sublist: ##core#rest-cdr rest24262428 0 
(o x)|known list op on rest arg sublist: ##core#rest-null? rest905906 0 
(o x)|known list op on rest arg sublist: ##core#rest-car rest905906 0 
o|replaced variables: 2 
o|removed binding forms: 9 
(o x)|known list op on rest arg sublist: ##core#rest-null? r3486 1 
(o x)|known list op on rest arg sublist: ##core#rest-car r3486 1 
(o x)|known list op on rest arg sublist: ##core#rest-null? r3486 1 
(o x)|known list op on rest arg sublist: ##core#rest-cdr r3486 1 
(o x)|known list op on rest arg sublist: ##core#rest-null? r3784 1 
(o x)|known list op on rest arg sublist: ##core#rest-car r3784 1 
(o x)|known list op on rest arg sublist: ##core#rest-null? r3784 1 
(o x)|known list op on rest arg sublist: ##core#rest-cdr r3784 1 
(o x)|known list op on rest arg sublist: ##core#rest-null? r3834 1 
(o x)|known list op on rest arg sublist: ##core#rest-car r3834 1 
(o x)|known list op on rest arg sublist: ##core#rest-null? r3834 1 
(o x)|known list op on rest arg sublist: ##core#rest-cdr r3834 1 
(o x)|known list op on rest arg sublist: ##core#rest-null? r4518 1 
(o x)|known list op on rest arg sublist: ##core#rest-car r4518 1 
(o x)|known list op on rest arg sublist: ##core#rest-null? r4518 1 
(o x)|known list op on rest arg sublist: ##core#rest-cdr r4518 1 
o|removed side-effect free assignment to unused variable: mode1299 
(o x)|known list op on rest arg sublist: ##core#rest-null? r6374 1 
(o x)|known list op on rest arg sublist: ##core#rest-car r6374 1 
(o x)|known list op on rest arg sublist: ##core#rest-null? r6374 1 
(o x)|known list op on rest arg sublist: ##core#rest-cdr r6374 1 
(o x)|known list op on rest arg sublist: ##core#rest-null? r6944 1 
(o x)|known list op on rest arg sublist: ##core#rest-car r6944 1 
(o x)|known list op on rest arg sublist: ##core#rest-null? r6944 1 
(o x)|known list op on rest arg sublist: ##core#rest-cdr r6944 1 
(o x)|known list op on rest arg sublist: ##core#rest-null? r7564 1 
(o x)|known list op on rest arg sublist: ##core#rest-car r7564 1 
(o x)|known list op on rest arg sublist: ##core#rest-null? r7564 1 
(o x)|known list op on rest arg sublist: ##core#rest-cdr r7564 1 
(o x)|known list op on rest arg sublist: ##core#rest-null? r7670 1 
(o x)|known list op on rest arg sublist: ##core#rest-car r7670 1 
(o x)|known list op on rest arg sublist: ##core#rest-null? r7670 1 
(o x)|known list op on rest arg sublist: ##core#rest-cdr r7670 1 
o|inlining procedure: k7853 
o|inlining procedure: k8155 
(o x)|known list op on rest arg sublist: ##core#rest-null? r8165 1 
(o x)|known list op on rest arg sublist: ##core#rest-car r8165 1 
(o x)|known list op on rest arg sublist: ##core#rest-null? r8165 1 
(o x)|known list op on rest arg sublist: ##core#rest-cdr r8165 1 
(o x)|known list op on rest arg sublist: ##core#rest-null? r8243 1 
(o x)|known list op on rest arg sublist: ##core#rest-car r8243 1 
(o x)|known list op on rest arg sublist: ##core#rest-null? r8243 1 
(o x)|known list op on rest arg sublist: ##core#rest-cdr r8243 1 
o|replaced variables: 21 
o|removed binding forms: 4 
(o x)|known list op on rest arg sublist: ##core#rest-null? r6380 2 
(o x)|known list op on rest arg sublist: ##core#rest-car r6380 2 
(o x)|known list op on rest arg sublist: ##core#rest-null? r6380 2 
(o x)|known list op on rest arg sublist: ##core#rest-cdr r6380 2 
(o x)|known list op on rest arg sublist: ##core#rest-null? r6950 2 
(o x)|known list op on rest arg sublist: ##core#rest-car r6950 2 
(o x)|known list op on rest arg sublist: ##core#rest-null? r6950 2 
(o x)|known list op on rest arg sublist: ##core#rest-cdr r6950 2 
(o x)|known list op on rest arg sublist: ##core#rest-null? r7676 2 
(o x)|known list op on rest arg sublist: ##core#rest-car r7676 2 
(o x)|known list op on rest arg sublist: ##core#rest-null? r7676 2 
(o x)|known list op on rest arg sublist: ##core#rest-cdr r7676 2 
o|inlining procedure: k8003 
o|inlining procedure: k8003 
o|inlining procedure: k8007 
o|inlining procedure: k8007 
(o x)|known list op on rest arg sublist: ##core#rest-null? r8171 2 
(o x)|known list op on rest arg sublist: ##core#rest-car r8171 2 
(o x)|known list op on rest arg sublist: ##core#rest-null? r8171 2 
(o x)|known list op on rest arg sublist: ##core#rest-cdr r8171 2 
(o x)|known list op on rest arg sublist: ##core#rest-null? r8249 2 
(o x)|known list op on rest arg sublist: ##core#rest-car r8249 2 
(o x)|known list op on rest arg sublist: ##core#rest-null? r8249 2 
(o x)|known list op on rest arg sublist: ##core#rest-cdr r8249 2 
o|converted assignments to bindings: (check1301) 
o|simplifications: ((let . 1)) 
o|removed binding forms: 29 
o|contracted procedure: k5026 
o|contracted procedure: k5066 
(o x)|known list op on rest arg sublist: ##core#rest-null? r6386 3 
(o x)|known list op on rest arg sublist: ##core#rest-car r6386 3 
(o x)|known list op on rest arg sublist: ##core#rest-null? r6386 3 
(o x)|known list op on rest arg sublist: ##core#rest-cdr r6386 3 
(o x)|known list op on rest arg sublist: ##core#rest-null? r6956 3 
(o x)|known list op on rest arg sublist: ##core#rest-car r6956 3 
(o x)|known list op on rest arg sublist: ##core#rest-null? r6956 3 
(o x)|known list op on rest arg sublist: ##core#rest-cdr r6956 3 
o|substituted constant variable: r80049851 
o|substituted constant variable: r80089853 
(o x)|known list op on rest arg sublist: ##core#rest-null? r8177 3 
(o x)|known list op on rest arg sublist: ##core#rest-car r8177 3 
(o x)|known list op on rest arg sublist: ##core#rest-null? r8177 3 
(o x)|known list op on rest arg sublist: ##core#rest-cdr r8177 3 
(o x)|known list op on rest arg sublist: ##core#rest-null? r8255 3 
(o x)|known list op on rest arg sublist: ##core#rest-car r8255 3 
(o x)|known list op on rest arg sublist: ##core#rest-null? r8255 3 
(o x)|known list op on rest arg sublist: ##core#rest-cdr r8255 3 
o|removed binding forms: 10 
(o x)|known list op on rest arg sublist: ##core#rest-null? r6392 4 
(o x)|known list op on rest arg sublist: ##core#rest-car r6392 4 
(o x)|known list op on rest arg sublist: ##core#rest-null? r6392 4 
(o x)|known list op on rest arg sublist: ##core#rest-cdr r6392 4 
o|removed binding forms: 9 
o|removed binding forms: 2 
o|direct leaf routine/allocation: rec1149 0 
o|direct leaf routine/allocation: g12301237 0 
o|direct leaf routine/allocation: doloop15841602 0 
o|direct leaf routine/allocation: doloop15831585 0 
o|direct leaf routine/allocation: for-each-loop16961708 0 
o|direct leaf routine/allocation: g23762383 0 
o|contracted procedure: k4470 
o|converted assignments to bindings: (rec1149) 
o|contracted procedure: "(posix-common.scm:779) k4831" 
o|contracted procedure: k5512 
o|contracted procedure: k5515 
o|converted assignments to bindings: (doloop15841602) 
o|converted assignments to bindings: (doloop15831585) 
o|contracted procedure: k5938 
o|converted assignments to bindings: (for-each-loop16961708) 
o|contracted procedure: "(posixunix.scm:1299) k8118" 
o|simplifications: ((let . 4)) 
o|removed binding forms: 6 
o|direct leaf routine/allocation: for-each-loop12291242 0 
o|direct leaf routine/allocation: for-each-loop23752393 0 
o|converted assignments to bindings: (for-each-loop12291242) 
o|converted assignments to bindings: (for-each-loop23752393) 
o|simplifications: ((let . 2)) 
x|eliminated type checks:
x|  C_i_check_structure:	2
o|customizable procedures: (va9627 va9625 va9623 va9621 loop1717 %process2364 chkstrlst2371 chicken.posix#process-impl output-port2313 make-on-close2278 input-port2312 spawn2311 connect-parent2280 needed-pipe2279 k7980 connect-child2281 k7788 chicken.posix#call-with-exec-args loop2112 loop2104 fileno2062 loop2080 k7242 loop2030 k7036 loop1924 peek1866 ready?1865 fetch1867 loop1811 k6038 k5498 k5501 lp1638 lp1657 k5580 check1301 chicken.posix#check-environment-list map-loop12711289 chicken.posix#list->c-string-buffer k4898 doloop12171218 tmp12807 tmp22808 doloop11981199 chicken.posix#free-c-string-buffer k4529 k4547 k4583 chicken.posix#process-wait-impl g10241031 for-each-loop10231037 chicken.posix#check-time-vector k3928 mode819 check820 chicken.posix#chown chicken.posix#stat g258267 map-loop252274) 
o|shared closure containers: 21 
o|shared closure users: 28 
o|calls to known targets: 230 
o|unused rest argument: rest239241 f_3041 
o|unused rest argument: rest707709 f_3302 
o|unused rest argument: rest771773 f_3480 
o|unused rest argument: rest844846 f_3778 
o|unused rest argument: rest861863 f_3828 
o|unused rest argument: new887 f_3923 
o|unused rest argument: rest928929 f_4005 
o|unused rest argument: rest939940 f_4026 
o|unused rest argument: rest957958 f_4058 
o|unused rest argument: rest9981000 f_4141 
o|unused rest argument: rest10451046 f_4242 
o|identified direct recursive calls: f_4474 1 
o|unused rest argument: args1158 f_4512 
o|identified direct recursive calls: f_4823 1 
o|unused rest argument: rest15081511 f_5294 
o|identified direct recursive calls: f_5791 1 
o|identified direct recursive calls: f_5749 1 
o|identified direct recursive calls: f_5612 2 
o|identified direct recursive calls: f_5671 2 
o|unused rest argument: rest16851686 f_5872 
o|identified direct recursive calls: f_5952 1 
o|unused rest argument: rest17531755 f_6033 
o|unused rest argument: rest18001802 f_6231 
o|identified direct recursive calls: f_6658 1 
o|unused rest argument: rest18391843 f_6368 
o|identified direct recursive calls: f_7134 1 
o|unused rest argument: rest19741978 f_6938 
o|unused rest argument: rest20722074 f_7300 
o|unused rest argument: rest20962098 f_7362 
o|unused rest argument: rest21492151 f_7483 
o|unused rest argument: rest21832184 f_7558 
o|unused rest argument: rest22162218 f_7664 
o|identified direct recursive calls: f_8110 1 
o|unused rest argument: rest24062408 f_8159 
o|unused rest argument: rest24262428 f_8237 
o|unused rest argument: _24532456 f_8344 
o|identified direct recursive calls: f_8539 2 
o|unused rest argument: rest905906 f_8572 
o|fast box initializations: 20 
o|fast global references: 85 
o|fast global assignments: 22 
o|dropping unused closure argument: f_3256 
o|dropping unused closure argument: f_3723 
o|dropping unused closure argument: f_3756 
o|dropping unused closure argument: f_3986 
o|dropping unused closure argument: f_4648 
o|dropping unused closure argument: f_4765 
o|dropping unused closure argument: f_4799 
o|dropping unused closure argument: f_5002 
o|dropping unused closure argument: f_5952 
o|dropping unused closure argument: f_6115 
o|dropping unused closure argument: f_7285 
o|dropping unused closure argument: f_7742 
o|dropping unused closure argument: f_7879 
o|dropping unused closure argument: f_7904 
o|dropping unused closure argument: f_7924 
o|dropping unused closure argument: f_7936 
o|dropping unused closure argument: f_8094 
*/
/* end of file */
